/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ImageContainer
extends JComponent {
    private String text;
    private Image image;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.text != null) {
            Rectangle2D bounds = g2.getFontMetrics().getStringBounds(this.text, g2);
            int x = this.getWidth() / 2 - (int)bounds.getWidth() / 2;
            int y = this.getHeight() / 2 - (int)bounds.getHeight() / 2;
            g2.drawString(this.text, x, y);
        }
        if (this.image != null) {
            int x = this.getWidth() / 2 - this.image.getWidth(null) / 2;
            int y = this.getHeight() / 2 - this.image.getHeight(null) / 2;
            g2.drawImage(this.image, x, y, null);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.image = null;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.text = null;
    }
}

