/*
 * Decompiled with CFR 0.152.
 */
package io.github.azige.moebooruviewer;

import io.github.azige.moebooruviewer.UserSetting;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(scopeName="prototype")
public class ConfigDialog
extends JDialog {
    private Logger logger = LoggerFactory.getLogger(ConfigDialog.class);
    @Autowired
    private UserSetting userSetting;
    private List<JTextField> saveNames;
    private List<JTextField> savePaths;
    private JFileChooser fileChooser = new JFileChooser();
    private JButton cancelButton;
    private JButton choosePathButton1;
    private JButton choosePathButton2;
    private JButton choosePathButton3;
    private JButton choosePathButton4;
    private JButton confirmButton;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JComboBox lafComboBox;
    private JTextField pageSizeTextField;
    private JCheckBox safeModeCheckBox;
    private JTextField saveNameTextField1;
    private JTextField saveNameTextField2;
    private JTextField saveNameTextField3;
    private JTextField saveNameTextField4;
    private JTextField savePathTextField1;
    private JTextField savePathTextField2;
    private JTextField savePathTextField3;
    private JTextField savePathTextField4;

    public ConfigDialog() {
        this.initComponents();
        this.saveNames = Arrays.asList(this.saveNameTextField1, this.saveNameTextField2, this.saveNameTextField3, this.saveNameTextField4);
        this.savePaths = Arrays.asList(this.savePathTextField1, this.savePathTextField2, this.savePathTextField3, this.savePathTextField4);
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setApproveButtonText("\u9009\u62e9");
    }

    @PostConstruct
    private void init() {
        this.safeModeCheckBox.setSelected(this.userSetting.isSafeMode());
        this.lafComboBox.setModel(new DefaultComboBoxModel(Stream.of(UIManager.getInstalledLookAndFeels()).map(UIManager.LookAndFeelInfo::getName).toArray(String[]::new)));
        this.lafComboBox.setSelectedItem(UIManager.getLookAndFeel().getName());
        for (int i = 0; i < this.saveNames.size(); ++i) {
            this.saveNames.get(i).setText(this.userSetting.getSaveLocations().get(i).getName());
            this.savePaths.get(i).setText(this.userSetting.getSaveLocations().get(i).getLocation().toString());
        }
        this.pageSizeTextField.setText(String.valueOf(this.userSetting.getPageSize()));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.safeModeCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.saveNameTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.savePathTextField1 = new JTextField();
        this.choosePathButton1 = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.saveNameTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.savePathTextField2 = new JTextField();
        this.choosePathButton2 = new JButton();
        this.jPanel7 = new JPanel();
        this.jLabel9 = new JLabel();
        this.saveNameTextField4 = new JTextField();
        this.jLabel10 = new JLabel();
        this.savePathTextField4 = new JTextField();
        this.choosePathButton4 = new JButton();
        this.jPanel8 = new JPanel();
        this.jLabel11 = new JLabel();
        this.saveNameTextField3 = new JTextField();
        this.jLabel12 = new JLabel();
        this.savePathTextField3 = new JTextField();
        this.choosePathButton3 = new JButton();
        this.confirmButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel5 = new JPanel();
        this.lafComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel6 = new JLabel();
        this.pageSizeTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u8bbe\u7f6e");
        this.setModal(true);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("\u6742\u9879"));
        this.safeModeCheckBox.setText("\u5b89\u5168\u6a21\u5f0f");
        this.safeModeCheckBox.setToolTipText("\u8fc7\u6ee4\u51fa\u9002\u5408\u5728\u516c\u4f17\u573a\u5408\u6216\u4e0a\u73ed\u65f6\u95f4\u6d4f\u89c8\u7684\u56fe\u7247");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.safeModeCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.safeModeCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("\u56fe\u7247\u4fdd\u5b58\u4f4d\u7f6e"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("\u5206\u7c7b1"));
        this.jLabel1.setText("\u540d\u5b57");
        this.saveNameTextField1.setText("\u58c1\u7eb8");
        this.jLabel2.setText("\u8def\u5f84");
        this.savePathTextField1.setText("wallpaper");
        this.choosePathButton1.setText("\u9009\u62e9");
        this.choosePathButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.choosePathButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.saveNameTextField1, -2, 80, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.savePathTextField1).addGap(18, 18, 18).addComponent(this.choosePathButton1).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.saveNameTextField1, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.savePathTextField1, -2, -1, -2).addComponent(this.choosePathButton1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("\u5206\u7c7b2"));
        this.jLabel3.setText("\u540d\u5b57");
        this.saveNameTextField2.setText("\u53ef\u516c\u5f00\u6536\u85cf");
        this.jLabel4.setText("\u8def\u5f84");
        this.savePathTextField2.setText("collections");
        this.choosePathButton2.setText("\u9009\u62e9");
        this.choosePathButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.choosePathButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.saveNameTextField2, -2, 80, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.savePathTextField2).addGap(18, 18, 18).addComponent(this.choosePathButton2).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.saveNameTextField2, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.savePathTextField2, -2, -1, -2).addComponent(this.choosePathButton2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("\u5206\u7c7b4"));
        this.jLabel9.setText("\u540d\u5b57");
        this.saveNameTextField4.setText("\u6682\u5b58");
        this.jLabel10.setText("\u8def\u5f84");
        this.savePathTextField4.setText("recycler");
        this.choosePathButton4.setText("\u9009\u62e9");
        this.choosePathButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.choosePathButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addGap(18, 18, 18).addComponent(this.saveNameTextField4, -2, 80, -2).addGap(18, 18, 18).addComponent(this.jLabel10).addGap(18, 18, 18).addComponent(this.savePathTextField4).addGap(18, 18, 18).addComponent(this.choosePathButton4).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.saveNameTextField4, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.savePathTextField4, -2, -1, -2).addComponent(this.choosePathButton4)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("\u5206\u7c7b3"));
        this.jLabel11.setText("\u540d\u5b57");
        this.saveNameTextField3.setText("\u975e\u516c\u5f00\u6536\u85cf");
        this.jLabel12.setText("\u8def\u5f84");
        this.savePathTextField3.setText(".collections");
        this.choosePathButton3.setText("\u9009\u62e9");
        this.choosePathButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.choosePathButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel11).addGap(18, 18, 18).addComponent(this.saveNameTextField3, -2, 80, -2).addGap(18, 18, 18).addComponent(this.jLabel12).addGap(18, 18, 18).addComponent(this.savePathTextField3, -1, 151, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.choosePathButton3).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.saveNameTextField3, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.savePathTextField3, -2, -1, -2).addComponent(this.choosePathButton3)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel8, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel7, -2, -1, -2)));
        this.confirmButton.setText("\u786e\u8ba4");
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.confirmButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("\u53d6\u6d88");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("\u5916\u89c2"));
        this.lafComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Windows"}));
        this.jLabel5.setText("\u9700\u8981\u91cd\u542f");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lafComboBox, -2, -1, -2).addComponent(this.jLabel5)).addContainerGap(36, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.lafComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel5).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("\u5206\u9875\u8bbe\u7f6e"));
        this.jLabel6.setText("\u9875\u5927\u5c0f");
        this.pageSizeTextField.setText("20");
        this.jLabel7.setText("\u4e0a\u9650\u662f 100");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(18, 18, 18).addComponent(this.pageSizeTextField)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.pageSizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.confirmButton).addGap(18, 18, 18).addComponent(this.cancelButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2)).addComponent(this.jPanel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confirmButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    @Override
    @PreDestroy
    public void dispose() {
        super.dispose();
    }

    private void choosePath(JTextField pathField) {
        File current = new File(pathField.getText()).getAbsoluteFile();
        this.fileChooser.setSelectedFile(current);
        if (this.fileChooser.showDialog(this, null) == 0) {
            pathField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void saveSettings() {
        this.userSetting.setSafeMode(this.safeModeCheckBox.isSelected());
        this.userSetting.setLookAndFeel((String)this.lafComboBox.getSelectedItem());
        ArrayList<UserSetting.SaveLocation> saveLocations = new ArrayList<UserSetting.SaveLocation>();
        for (int i = 0; i < this.saveNames.size(); ++i) {
            saveLocations.add(new UserSetting.SaveLocation(this.saveNames.get(i).getText(), new File(this.savePaths.get(i).getText()).getAbsoluteFile()));
        }
        this.userSetting.setSaveLocations(saveLocations);
        try {
            int pageSize = Integer.parseInt(this.pageSizeTextField.getText());
            pageSize = Math.max(1, Math.min(100, pageSize));
            this.userSetting.setPageSize(pageSize);
        }
        catch (NumberFormatException ex) {
            this.logger.debug("\u6570\u5b57\u683c\u5f0f\u9519\u8bef", (Throwable)ex);
        }
    }

    private void confirmButtonActionPerformed(ActionEvent evt) {
        this.saveSettings();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void choosePathButton1ActionPerformed(ActionEvent evt) {
        this.choosePath(this.savePathTextField1);
    }

    private void choosePathButton2ActionPerformed(ActionEvent evt) {
        this.choosePath(this.savePathTextField2);
    }

    private void choosePathButton3ActionPerformed(ActionEvent evt) {
        this.choosePath(this.savePathTextField3);
    }

    private void choosePathButton4ActionPerformed(ActionEvent evt) {
        this.choosePath(this.savePathTextField4);
    }
}

