/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.DataBufferNative;
import sun.java2d.SurfaceData;

public class WritableRasterNative
extends WritableRaster {
    public static WritableRasterNative createNativeRaster(SampleModel sampleModel, DataBuffer dataBuffer) {
        return new WritableRasterNative(sampleModel, dataBuffer);
    }

    protected WritableRasterNative(SampleModel sampleModel, DataBuffer dataBuffer) {
        super(sampleModel, dataBuffer, new Point(0, 0));
    }

    public static WritableRasterNative createNativeRaster(ColorModel colorModel, SurfaceData surfaceData, int n, int n2) {
        Object object;
        SampleModel sampleModel = null;
        int n3 = 0;
        int n4 = n;
        switch (colorModel.getPixelSize()) {
            case 8: 
            case 12: {
                n3 = colorModel.getPixelSize() == 8 ? 0 : 1;
                object = new int[]{0};
                sampleModel = new PixelInterleavedSampleModel(n3, n, n2, 1, n4, (int[])object);
                break;
            }
            case 15: 
            case 16: {
                n3 = 1;
                int[] nArray = new int[3];
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                nArray[0] = directColorModel.getRedMask();
                nArray[1] = directColorModel.getGreenMask();
                nArray[2] = directColorModel.getBlueMask();
                sampleModel = new SinglePixelPackedSampleModel(n3, n, n2, n4, nArray);
                break;
            }
            case 24: 
            case 32: {
                n3 = 3;
                int[] nArray = new int[3];
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                nArray[0] = directColorModel.getRedMask();
                nArray[1] = directColorModel.getGreenMask();
                nArray[2] = directColorModel.getBlueMask();
                sampleModel = new SinglePixelPackedSampleModel(n3, n, n2, n4, nArray);
                break;
            }
            default: {
                throw new InternalError("Unsupported depth " + colorModel.getPixelSize());
            }
        }
        object = new DataBufferNative(surfaceData, n3, n, n2);
        return new WritableRasterNative(sampleModel, (DataBuffer)object);
    }
}

