--[[   ____    ______
      /\  _`\ /\__  _\   __
 __  _\ \ \/\_\/_/\ \/ /_\ \___
/\ \/'\\ \ \/_/_ \ \ \/\___  __\
\/>  </ \ \ \L\ \ \ \ \/__/\_\_/
 /\_/\_\ \ \____/  \ \_\  \/_/
 \//\/_/  \/___/    \/_/

 [=====================================]
 [  Author: Dandraffbal-Stormreaver US ]
 [  xCT+ Version 4.x.x                 ]
 [  ©2015. All Rights Reserved.        ]
 [====================================]]

local build = select(4, GetBuildInfo())

local ADDON_NAME, addon = ...
local LSM = LibStub("LibSharedMedia-3.0")
local x, noop = addon.engine, addon.noop
local blankTable, unpack, select = {}, unpack, select
local string_gsub, string_match, sformat, pairs = string.gsub, string.match, string.format, pairs
print("|cff00dfff[xCT+]|r 由|c00FF9900NGA:Suakuboy|r于2016.09.09日翻译修改,输入|cff33ff99/xct|r设置.")
--翻译汉化修改：NGA @Suakuboy
-- New Icon "!"
local NEW = x.new

-- Store Localized Strings
-- To remove: "Changed Target!"
local XCT_CT_DEC_0, XCT_CT_DEC_1, XCT_CT_DEC_2 = COMBAT_THREAT_DECREASE_0, COMBAT_THREAT_DECREASE_1, COMBAT_THREAT_DECREASE_2
local XCT_CT_INC_1, XCT_CT_INC_3 = COMBAT_THREAT_INCREASE_1, COMBAT_THREAT_INCREASE_3

local PLAYER_NAME = UnitName('player')
local _, PLAYER_CLASS = UnitClass('player')
if PLAYER_CLASS then
  PLAYER_NAME = ('|c%s%s|r'):format(RAID_CLASS_COLORS[PLAYER_CLASS].colorStr, PLAYER_NAME)
end

-- Creating an Config
addon.options = {
  -- Add a place for the user to grab
  name = "                                                      " .. "Version: "..(GetAddOnMetadata("xCT+", "Version") or "Unknown") .. "                                                      ",
  handler = x,
  type = 'group',
  args = {
    xCT_Title = {
      order = 0,
      type = 'description',
      fontSize = 'large',
      name = "|cffFF0000x|rCT|cffFFFF00+|r |cff798BDD控制台|r\n",
      width = 'double',
    },

    spacer0 = {
      order = 1,
      type = 'description',
      name = "|cffFFFF00Helpful Tips:|r\n\n",
      width = 'half',
    },

    helpfulTip = {
      order = 2,
      type = 'description',
      fontSize = 'medium',
      name = "On the left list, under the |cffFFFF00Startup Message|r checkbox, you can click on the |cff798BDD+ Buttons|r (plus) to show more options.",
      width = 'double',
    },

    --[[xCT_Header = {
      order = 10,
      type = "header",
      name = "Version: "..(GetAddOnMetadata("xCT+", "Version") or "Unknown"),
      width = "full",
    },]]

    space1 = {
      order = 10,
      type = 'description',
      name = "\n",
      width = 'full',
    },

    showStartupText = {
      order = 11,
      type = 'toggle',
      name = "启动信息",
      get = function(info) return x.db.profile.showStartupText end,
      set = function(info, value) x.db.profile.showStartupText = value end,
    },
    hideConfig = {
      order = 12,
      type = 'toggle',
      name = "战斗时隐藏设置界面",
      desc = "防止进入战斗后出现污染信息.\n\n|cffFF8000推荐启用|r",
      get = function(info) return x.db.profile.hideConfig end,
      set = function(info, value) x.db.profile.hideConfig = value; if not value then StaticPopup_Show("XCT_PLUS_HIDE_IN_COMBAT") end end,
    },
    --[==[RestoreDefaults = {
      order = 3,
      type = 'execute',
      name = "Restore Defaults",
      func = x.RestoreAllDefaults,
    },]==]
    space2 = {
      order = 20,
      type = 'description',
      name = " ",
      width = 'half',
    },
    space3 = {
      order = 30,
      type = 'description',
      name = " ",
      width = 'half',
    },
    space4 = {
      order = 30,
      type = 'description',
      name = " ",
      width = 'half',
    },
    ToggleTestMode = {
      order = 31,
      type = 'execute',
      name = "打开测试模式",
      func = x.ToggleTestMode,
      desc = "Allows you to preview xCT+ inorder to tweak settings outside of combat.\n\nYou can also type: '|cffFF0000/xct test|r'",
      width = 'half',
    },
    ToggleFrames = {
      order = 32,
      type = 'execute',
      name = "打开框体(移动,尺寸)",
      desc = "Allows you to adjust the position of all the xCT+ frames on your screen.\n\nYou can also type: '|cffFF0000/xct lock|r'",
      func = x.ToggleConfigMode,
      width = 'half',
    },

    hiddenObjectShhhhhh = {
      order = 9001,
      type = 'description',
      name = function(info) x:OnAddonConfigRefreshed() return "" end,
    },
  },
}

-- A fast C-Var Update routine
local function isCVarsDisabled( ) return x.db.profile.bypassCVars end


x.cvar_update = function( force )
  -- Floating Combat Text: Threat Changes
  if not x.db.profile.blizzardFCT.CombatThreatChanges then
    COMBAT_THREAT_DECREASE_0, COMBAT_THREAT_DECREASE_1, COMBAT_THREAT_DECREASE_2 = "", "", ""
    COMBAT_THREAT_INCREASE_1, COMBAT_THREAT_INCREASE_3 = "", ""
  elseif COMBAT_THREAT_DECREASE_0 == "" then
    -- only overwrite Blizzard constants if they were previously changed
    COMBAT_THREAT_DECREASE_0, COMBAT_THREAT_DECREASE_1, COMBAT_THREAT_DECREASE_2 = XCT_CT_DEC_0, XCT_CT_DEC_1, XCT_CT_DEC_2
    COMBAT_THREAT_INCREASE_1, COMBAT_THREAT_INCREASE_3 = XCT_CT_INC_1, XCT_CT_INC_3
  end

  if  isCVarsDisabled( ) then
    if force then
      StaticPopup_Show("XCT_PLUS_FORCE_CVAR_UPDATE")
    else
      return
    end
  end

  if x.db.profile.blizzardFCT.floatingCombatTextAllSpellMechanics then
    SetCVar("floatingCombatTextAllSpellMechanics", 1)
  else
    SetCVar("floatingCombatTextAllSpellMechanics", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextAuras then
    SetCVar("floatingCombatTextAuras", 1)
  else
    SetCVar("floatingCombatTextAuras", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatDamage then
    SetCVar("floatingCombatTextCombatDamage", 1)
  else
    SetCVar("floatingCombatTextCombatDamage", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatDamageAllAutos then
    SetCVar("floatingCombatTextCombatDamageAllAutos", 1)
  else
    SetCVar("floatingCombatTextCombatDamageAllAutos", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatDamageDirectionalOffset then
    SetCVar("floatingCombatTextCombatDamageDirectionalOffset", 1)
  else
    SetCVar("floatingCombatTextCombatDamageDirectionalOffset", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatDamageDirectionalScale then
    SetCVar("floatingCombatTextCombatDamageDirectionalScale", 1)
  else
    SetCVar("floatingCombatTextCombatDamageDirectionalScale", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatHealing then
    SetCVar("floatingCombatTextCombatHealing", 1)
  else
    SetCVar("floatingCombatTextCombatHealing", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatHealingAbsorbSelf then
    SetCVar("floatingCombatTextCombatHealingAbsorbSelf", 1)
  else
    SetCVar("floatingCombatTextCombatHealingAbsorbSelf", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatHealingAbsorbTarget then
    SetCVar("floatingCombatTextCombatHealingAbsorbTarget", 1)
  else
    SetCVar("floatingCombatTextCombatHealingAbsorbTarget", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatLogPeriodicSpells then
    SetCVar("floatingCombatTextCombatLogPeriodicSpells", 1)
  else
    SetCVar("floatingCombatTextCombatLogPeriodicSpells", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextCombatState then
    SetCVar("floatingCombatTextCombatState", 1)
  else
    SetCVar("floatingCombatTextCombatState", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextComboPoints then
    SetCVar("floatingCombatTextComboPoints", 1)
  else
    SetCVar("floatingCombatTextComboPoints", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextDamageReduction then
    SetCVar("floatingCombatTextDamageReduction", 1)
  else
    SetCVar("floatingCombatTextDamageReduction", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextDodgeParryMiss then
    SetCVar("floatingCombatTextDodgeParryMiss", 1)
  else
    SetCVar("floatingCombatTextDodgeParryMiss", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextEnergyGains then
    SetCVar("floatingCombatTextEnergyGains", 1)
  else
    SetCVar("floatingCombatTextEnergyGains", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextFloatMode then
    SetCVar("floatingCombatTextFloatMode", 1)
  else
    SetCVar("floatingCombatTextFloatMode", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextFriendlyHealers then
    SetCVar("floatingCombatTextFriendlyHealers", 1)
  else
    SetCVar("floatingCombatTextFriendlyHealers", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextHonorGains then
    SetCVar("floatingCombatTextHonorGains", 1)
  else
    SetCVar("floatingCombatTextHonorGains", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextLowManaHealth then
    SetCVar("floatingCombatTextLowManaHealth", 1)
  else
    SetCVar("floatingCombatTextLowManaHealth", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextPeriodicEnergyGains then
    SetCVar("floatingCombatTextPeriodicEnergyGains", 1)
  else
    SetCVar("floatingCombatTextPeriodicEnergyGains", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextPetMeleeDamage then
    SetCVar("floatingCombatTextPetMeleeDamage", 1)
  else
    SetCVar("floatingCombatTextPetMeleeDamage", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextPetSpellDamage then
    SetCVar("floatingCombatTextPetSpellDamage", 1)
  else
    SetCVar("floatingCombatTextPetSpellDamage", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextReactives then
    SetCVar("floatingCombatTextReactives", 1)
  else
    SetCVar("floatingCombatTextReactives", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextRepChanges then
    SetCVar("floatingCombatTextRepChanges", 1)
  else
    SetCVar("floatingCombatTextRepChanges", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextSpellMechanics then
    SetCVar("floatingCombatTextSpellMechanics", 1)
  else
    SetCVar("floatingCombatTextSpellMechanics", 0)
  end

  if x.db.profile.blizzardFCT.floatingCombatTextSpellMechanicsOther then
    SetCVar("floatingCombatTextSpellMechanicsOther", 1)
  else
    SetCVar("floatingCombatTextSpellMechanicsOther", 0)
  end
end

-- Generic Get/Set methods
local function get0(info) return x.db.profile[info[#info-1]][info[#info]] end
local function set0(info, value) x.db.profile[info[#info-1]][info[#info]] = value; x.cvar_update() end
local function set0_update(info, value) x.db.profile[info[#info-1]][info[#info]] = value; x:UpdateFrames(); x.cvar_update() end
local function get0_1(info) return x.db.profile[info[#info-2]][info[#info]] end
local function set0_1(info, value) x.db.profile[info[#info-2]][info[#info]] = value; x.cvar_update() end
local function getTextIn0(info) return string_gsub(x.db.profile[info[#info-1]][info[#info]], "|", "||") end
local function setTextIn0(info, value) x.db.profile[info[#info-1]][info[#info]] = string_gsub(value, "||", "|"); x.cvar_update() end
local function get1(info) return x.db.profile.frames[info[#info-1]][info[#info]] end
local function set1(info, value) x.db.profile.frames[info[#info-1]][info[#info]] = value; x.cvar_update() end
local function set1_update(info, value) set1(info, value); x:UpdateFrames(info[#info-1]); x.cvar_update() end
local function get2(info) return x.db.profile.frames[info[#info-2]][info[#info]] end
local function set2(info, value) x.db.profile.frames[info[#info-2]][info[#info]] = value; x.cvar_update() end
local function set2_update(info, value) set2(info, value); x:UpdateFrames(info[#info-2]); x.cvar_update() end
local function set2_update_force(info, value) set2(info, value); x:UpdateFrames(info[#info-2]); x.cvar_update(true) end
local function getColor2(info) return unpack(x.db.profile.frames[info[#info-2]][info[#info]] or blankTable) end
local function setColor2(info, r, g, b) x.db.profile.frames[info[#info-2]][info[#info]] = {r,g,b} end
local function getTextIn2(info) return string_gsub(x.db.profile.frames[info[#info-2]][info[#info]], "|", "||") end
local function setTextIn2(info, value) x.db.profile.frames[info[#info-2]][info[#info]] = string_gsub(value, "||", "|") end
local function getNumber2(info) return tostring(x.db.profile[info[#info-2]][info[#info]]) end
local function setNumber2(info, value) if tonumber(value) then x.db.profile[info[#info-2]][info[#info]] = tonumber(value) end end

local function outgoingSpellColorsHidden(info) return not x.db.profile.frames["outgoing"].standardSpellColor end

local function isFrameEnabled(info) return x.db.profile.frames[info[#info-1]].enabledFrame end
local function isFrameDisabled(info) return not x.db.profile.frames[info[#info-1]].enabledFrame end
local function isFrameItemDisabled(info) return not x.db.profile.frames[info[#info-2]].enabledFrame end
local function isFrameNotScrollable(info) return isFrameItemDisabled(info) or not x.db.profile.frames[info[#info-2]].enableScrollable end
local function isFrameUseCustomFade(info) return not x.db.profile.frames[info[#info-2]].enableCustomFade or isFrameItemDisabled(info) end
local function isFrameFadingDisabled(info) return isFrameUseCustomFade(info) or not x.db.profile.frames[info[#info-2]].enableFade end
local function isFrameIconDisabled(info) return isFrameItemDisabled(info) or not x.db.profile.frames[info[#info-2]].iconsEnabled end

-- This is TEMP
local function isFrameItemEnabled(info) return x.db.profile.frames[info[#info-2]].enabledFrame end


local function setSpecialCriticalOptions(info, value)
  x.db.profile[info[#info-2]].mergeCriticalsWithOutgoing = false
  x.db.profile[info[#info-2]].mergeCriticalsByThemselves = false
  x.db.profile[info[#info-2]].mergeDontMergeCriticals = false
  x.db.profile[info[#info-2]].mergeHideMergedCriticals = false

  x.db.profile[info[#info-2]][info[#info]] = true
end

local function setFormating(info, value)
  x.db.profile.spells.formatAbbreviate = false
  x.db.profile.spells.formatGroups = false

  x.db.profile.spells[info[#info]] = true
end

local function getDBSpells(info)
  return x.db.profile.spells[info[#info]]
end

-- Apply to All variables
local miscFont, miscFontOutline, miscEnableCustomFade;

-- Spell Filter Methods
local checkAdd = {
  listBuffs = false,
  listDebuffs = false,
  listSpells = false,
  listProcs = false,
}

local function getCheckAdd(info) return checkAdd[info[#info-1]] end
local function setCheckAdd(info, value) checkAdd[info[#info-1]] = value end

local function trim(s)
  return ( s:gsub("^%s*(.-)%s*$", "%1") )
end

-- For each 'comma' separated value in 'input' (string) do 'func(value, ...)'
local function foreach(input, comma, func, ...)
  local pattern = ("[^%s]+"):format(comma)
  local s, e = 0, 0
  while e do
    s, e = input:find(pattern, e + 1)
    if s and e then
      func(trim(input:sub(s, e)), ...)
    end
  end
end

local function setSpell(info, value)
  if not checkAdd[info[#info-1]] then
    -- Add Spell
    foreach(value, ';', x.AddFilteredSpell, info[#info-1])
  else
    -- Remove Spell
    foreach(value, ';', x.RemoveFilteredSpell, info[#info-1])
  end
end

local function IsTrackSpellsDisabled() return not x.db.profile.spellFilter.trackSpells end

-- Lists that will be used to show tracked spells
local buffHistory, debuffHistory, spellHistory, procHistory, itemHistory = { }, { }, { }, { }, { }


-- GetSpellTextureFormatted( spellID, message, multistrike, iconSize, justify, strColor, mergeOverride, forceOff )

local function GetBuffHistory()
  for i in pairs(buffHistory) do
    buffHistory[i] = nil
  end

  for i in pairs(x.spellCache.buffs) do
    buffHistory[i] = x:GetSpellTextureFormatted(i, "", 0, 16, nil, nil, nil, true).." "..i
  end

  return buffHistory
end

local function GetDebuffHistory()
  for i in pairs(debuffHistory) do
    debuffHistory[i] = nil
  end

  for i in pairs(x.spellCache.debuffs) do
    debuffHistory[i] = x:GetSpellTextureFormatted(i, "", 0, 16, nil, nil, nil, true).." "..i
  end

  return debuffHistory
end

local function GetSpellHistory()
  for i in pairs(spellHistory) do
    spellHistory[i] = nil
  end

  for i in pairs(x.spellCache.spells) do
    local name = GetSpellInfo(i) or "未知技能ID"
    spellHistory[tostring(i)] = x:GetSpellTextureFormatted(i, "", 0, 16, nil, nil, nil, true).." "..name.." (|cff798BDD"..i.."|r)"
  end

  return spellHistory
end

local function GetProcHistory()
  for i in pairs(procHistory) do
    procHistory[i] = nil
  end

  for i in pairs(x.spellCache.procs) do
    procHistory[i] = x:GetSpellTextureFormatted(i, "", 0, 16, nil, nil, nil, true).." "..i
  end

  return procHistory
end

local function GetItemHistory()
  for i in pairs(itemHistory) do
    itemHistory[i] = nil
  end

  for i in pairs(x.spellCache.items) do
	local name, _, _, _, _, _, _, _, _, texture = GetItemInfo( i )
    itemHistory[i] = sformat("|T%s:%d:%d:0:0:64:64:5:59:5:59|t %s", texture, 16, 16, name)
  end

  return itemHistory
end


addon.options.args["spells"] = {
  name = "信息合并",
  type = 'group',
  childGroups = 'tab',
  order = 2,
  args = {

    mergeOptions = {
      name = "合并选项",
      type = 'group',
      order = 11,
      args = {

        enableMerger = {
          order = 1,
          type = 'toggle',
          name = "启用合并",
          get = get0_1,
          set = set0_1,
        },
        enableMergerDebug = {
          order = 2,
          type = 'toggle',
          width = "double",
          name = "显示技能ID",
          get = get0_1,
          set = set0_1,
        },

        listSpacer1 = {
          type = "description",
          order = 10,
          name = "\n|cff798BDD合并受到的治疗设置|r:",
          fontSize = 'large',
        },

        mergeHealing = {
          order = 11,
          type = 'toggle',
          name = "按姓名合并治疗",
          desc = "按给你治疗的玩家姓名合并治疗.",
          get = get0_1,
          set = set0_1,
          width = 'double',
        },

        listSpacer2 = {
          type = "description",
          order = 20,
          name = "\n|cff798BDD合并多个驱散|r:",
          fontSize = 'large',
        },

        mergeDispells = {
          order = 21,
          type = 'toggle',
          name = "按技能名称合并驱散",
          desc = "合并你施放的多个驱散技能,如果光环名称是相同的.",
          get = get0_1,
          set = set0_1,
          width = 'double',
        },

        listSpacer3 = {
          type = "description",
          order = 30,
          name = "\n|cff798BDD合并自动攻击|r:",
          fontSize = 'large',
        },

        mergeSwings = {
          order = 31,
          type = 'toggle',
          name = "合并近战平砍",
          desc = "|cffFF0000ID|r 6603 |cff798BDD(玩家平砍)|r\n|cffFF0000ID|r 0 |cff798BDD(宠物近战攻击)|r",
          get = get0_1,
          set = set0_1,
        },

        mergeRanged = {
          order = 32,
          type = 'toggle',
          name = "合并远程自动攻击",
          desc = "|cffFF0000ID|r 75",
          get = get0_1,
          set = set0_1,
        },

        listSpacer4 = {
          type = "description",
          order = 40,
          name = "\n|cff798BDD合并爆击|r (选择一个):",
          fontSize = 'large',
        },

        mergeDontMergeCriticals = {
          order = 41,
          type = 'toggle',
          name = "不合并爆击",
          desc = "爆击不会合并到爆击窗口中, 但将输出到整体的伤害窗口中. |cffFFFF00(默认)|r",
          get = get0_1,
          set = setSpecialCriticalOptions,
          width = 'full',
        },

        mergeCriticalsWithOutgoing = {
          order = 42,
          type = 'toggle',
          name = "爆击和输出",
          desc = "暴击伤害将被合并，但合并后的总伤害在输出框中包括暴击.",
          get = get0_1,
          set = setSpecialCriticalOptions,
          width = 'full',
        },

        mergeCriticalsByThemselves = {
          order = 43,
          type = 'toggle',
          name = "自身爆击",
          desc = "暴击伤害将被合并，但合并后的总伤害在输出框中|cffFF0000不|r包括暴击.",
          get = get0_1,
          set = setSpecialCriticalOptions,
          width = 'full',
        },

        mergeHideMergedCriticals = {
          order = 44,
          type = 'toggle',
          name = "隐藏暴击",
          desc = "暴击伤害将不再显示.",
          get = get0_1,
          set = setSpecialCriticalOptions,
          width = 'full',
        },

      },
    },

    classList = {
      name = "职业技能", --"List of Mergeable Spells |cff798BDD(Class Specific)|r",
      type = 'group',
      order = 21,
      childGroups = 'select',
      args = {
        title = {
          type = 'description',
          order = 0,
          name = "列出合并的技能|cff798BDD(职业特定的)|r",
          fontSize = "large",
          width = "double",
        },

        --[[  TODO: Add Check all and uncheck all buttons ]]

        mergeListDesc = {
          type = "description",
          order = 1,
          fontSize = "small",
          name = "反选你不想合并的技能, 添加技能请与我联系,详情看|cffFFFF00Credits|r 联系信息.\n\n",
        },

        --[[classes = {
          name = "Class Spells",
          type = 'group',
          order = 2,
          childGroups = 'select',
          args = {

          },
        }]]


        ["DEATHKNIGHT"] = { type = 'group', order = 1,  name = "|cffC41F3B死亡骑士|r" },
        ["DEMONHUNTER"] = { type = 'group', order = 2,  name = "|cffA330C9恶魔猎手|r" },
        ["DRUID"]       = { type = 'group', order = 3,  name = "|cffFF7D0A德鲁伊|r" },
        ["HUNTER"]      = { type = 'group', order = 4,  name = "|cffABD473猎人|r" },
        ["MAGE"]        = { type = 'group', order = 5,  name = "|cff69CCF0法师|r" },
        ["MONK"]        = { type = 'group', order = 6,  name = "|cff00FF96武僧|r" },
        ["PALADIN"]     = { type = 'group', order = 7,  name = "|cffF58CBA圣骑士|r" },
        ["PRIEST"]      = { type = 'group', order = 8,  name = "|cffFFFFFF牧师|r" },
        ["ROGUE"]       = { type = 'group', order = 9,  name = "|cffFFF569盗贼|r" },
        ["SHAMAN"]      = { type = 'group', order = 10, name = "|cff0070DE萨满|r" },
        ["WARLOCK"]     = { type = 'group', order = 11, name = "|cff9482C9术士|r" },
        ["WARRIOR"]     = { type = 'group', order = 12, name = "|cffC79C6E战士|r" },

      },
    },

    globalList = {
      name = "通用技能",
      type = 'group',
      order = 22,
      args = {
        title = {
          type = 'description',
          order = 0,
          name = "List of Mergeable Spells |cff798BDD(See Category)|r",
          fontSize = "large",
          width = "double",
        },
        mergeListDesc = {
          type = "description",
          order = 1,
          fontSize = "small",
          name = "Uncheck an item if you do not want it merged. Contact me to add new items. See |cffFFFF00Credits|r for contact info.\n\n",
        },
      },
    },

  },
}

addon.options.args["spellFilter"] = {
  name = "过滤器",
  type = "group",
  order = 3,
  args = {
    --[[filterSpacer1 = {
      type = 'description',
      order = 1,
      fontSize = "medium",
      name = "",
    },]]

    filterValues = {
      name = "最小阈值",
      type = 'group',
      order = 10,
      guiInline = true,
      args = {
        listSpacer0 = {
          type = "description",
          order = 0,
          name = "|cff798BDD玩家获得能量阀值|r: (法力, 能量, 怒气等.)",
          fontSize = "large",
        },

        filterPowerValue = {
          order = 1,
          type = 'input',
          name = "获得能量",
          desc = "玩家获得能量显示的最小值.",
          set = setNumber2,
          get = getNumber2,
        },

        listSpacer1 = {
          type = "description",
          order = 10,
          name = "|cff798BDD输出伤害和治疗的阀值|r:",
          fontSize = "large",
        },

        filterOutgoingDamageValue = {
          order = 11,
          type = 'input',
          name = "输出伤害",
          desc = "伤害输出显示的最小值",
          set = setNumber2,
          get = getNumber2,
        },

        filterOutgoingHealingValue = {
          order = 12,
          type = 'input',
          name = "输出治疗",
          desc = "治疗输出显示的最小值",
          set = setNumber2,
          get = getNumber2,
        },

        listSpacer2 = {
          type = "description",
          order = 20,
          name = "|cff798BDD受到伤害和治疗的阀值|r:",
          fontSize = "large",
        },

        filterIncomingDamageValue = {
          order = 21,
          type = 'input',
          name = "受到的伤害",
          desc = "受到伤害显示的最小值.",
          set = setNumber2,
          get = getNumber2,
        },

        filterIncomingHealingValue = {
          order = 22,
          type = 'input',
          name = "受到的治疗",
          set = setNumber2,
          get = getNumber2,
        },
      },
    },

    spellFilter = {
      name = "追踪技能历史",
      type = 'group',
      order = 21,
      guiInline = true,
      args = {
        trackSpells = {
          order = 1,
          type = 'toggle',
          name = "启用历史",
          desc = "\n\n追踪获得的|cff1AFF1ABuff|r和|cff1AFF1ADebuff|r名称, 以及|cff71d5ff输出技能|r IDs. |cffFF0000(建议临时使用)|r\n",
          set = set0_1,
          get = get0_1,
        }
      }
    },


    listBuffs = {
      name = "|cffFFFFFF过滤:|r |cff798BDDBuffs|r",
      type = 'group',
      order = 20,
      guiInline = false,
      args = {
        title = {
          order = 0,
          type = "description",
          name = "These options allow you to filter out |cff1AFF1ABuff|r auras that your player gains or loses.  In order to filter them, you need to type the |cffFFFF00exact name of the aura|r (case sensitive).",
        },
        whitelistBuffs = {
          order = 1,
          type = 'toggle',
          name = "白名单",
          desc = "Filtered auras gains and fades that are |cff1AFF1ABuffs|r will be on a whitelist (opposed to a blacklist).",
          set = set0_1,
          get = get0_1,
          width = "full",
        },
        spellName = {
          order = 6,
          type = 'input',
          name = "光环名称",
          desc = "The full, case-sensitive name of the |cff1AFF1ABuff|r you want to filter.\n\nYou can add/remove |cff798BDDmultiple|r entries by separating them with a |cffFF8000semicolon|r (e.g. 'Shadowform;Power Word: Fortitude').",
          set = setSpell,
          get = noop,
        },
        checkAdd = {
          order = 7,
          type = 'toggle',
          name = "移除",
          desc = "Check to remove the aura from the filtered list.",
          get = getCheckAdd,
          set = setCheckAdd,
        },

        -- This is a feature option that I will enable when I get more time D:
        selectTracked = {
          order = 8,
          type = 'select',
          name = "Buff 历史记录:",
          desc = "A list of |cff1AFF1ABuff|r names that have been seen. |cffFF0000Requires:|r |cff798BDDTrack Spell History|r",
          disabled = IsTrackSpellsDisabled,
          values = GetBuffHistory,
          get = noop,
          set = setSpell,
        },
      },
    },

    listDebuffs = {
      name = "|cffFFFFFF过滤:|r |cff798BDDDebuffs|r",
      type = 'group',
      order = 30,
      guiInline = false,
      args = {
        title = {
          order = 0,
          type = "description",
          name = "These options allow you to filter out |cffFF1A1ADebuff|r auras that your player gains or loses. In order to filter them, you need to type the |cffFFFF00exact name of the aura|r (case sensitive).",
        },
        whitelistDebuffs = {
          order = 1,
          type = 'toggle',
          name = "白名单",
          desc = "Filtered auras gains and fades that are |cffFF1A1ADebuffs|r will be on a whitelist (opposed to a blacklist).",
          set = set0_1,
          get = get0_1,
          width = "full",
        },
        spellName = {
          order = 2,
          type = 'input',
          name = "光环名称",
          desc = "The full, case-sensitive name of the |cffFF1A1ADebuff|r you want to filter.",
          set = setSpell,
          get = noop,
        },
        checkAdd = {
          order = 3,
          type = 'toggle',
          name = "移除",
          desc = "Check to remove the aura from the filtered list.",
          get = getCheckAdd,
          set = setCheckAdd,
        },

        -- This is a feature option that I will enable when I get more time D:
        selectTracked = {
          order = 4,
          type = 'select',
          name = "Debuff 历史记录:",
          desc = "A list of |cffFF1A1ABuff|r names that have been seen. |cffFF0000Requires:|r |cff798BDDTrack Spell History|r",
          disabled = IsTrackSpellsDisabled,
          values = GetDebuffHistory,
          get = noop,
          set = setSpell,
        },
      },
    },

    listProcs = {
      name = "|cffFFFFFF过滤:|r |cff798BDD特效|r",
      type = 'group',
      order = 40,
      guiInline = false,
      args = {
        title = {
          order = 0,
          type = "description",
          name = "These options allow you to filter out spell |cffFFFF00Procs|r that your player triggers.  In order to filter them, you need to type the |cffFFFF00exact name of the proc|r (case sensitive).",
        },
        whitelistProcs = {
          order = 1,
          type = 'toggle',
          name = "白名单",
          desc = "Check for whitelist, uncheck for blacklist.",
          set = set0_1,
          get = get0_1,
          width = "full",
        },
        spellName = {
          order = 6,
          type = 'input',
          name = "特效名称",
          desc = "The full, case-sensitive name of the |cff1AFF1AProc|r you want to filter.\n\nYou can add/remove |cff798BDDmultiple|r entries by separating them with a |cffFF8000semicolon|r (e.g. 'Shadowform;Power Word: Fortitude').",
          set = setProc,
          get = noop,
        },
        checkAdd = {
          order = 7,
          type = 'toggle',
          name = "移除",
          desc = "Check to remove the item from the filtered list.",
          get = getCheckAdd,
          set = setCheckAdd,
        },

        -- This is a feature option that I will enable when I get more time D:
        selectTracked = {
          order = 8,
          type = 'select',
          name = "特效历史记录:",
          desc = "A list of |cff1AFF1AProc|r items that have been seen. |cffFF0000Requires:|r |cff798BDDTrack Spell History|r",
          disabled = IsTrackSpellsDisabled,
          values = GetProcHistory,
          get = noop,
          set = setSpell,
        },
      },
    },

    listSpells = {
      name = "|cffFFFFFF过滤:|r |cff798BDD输出技能|r",
      type = 'group',
      order = 50,
      guiInline = false,
      args = {
        title = {
          order = 0,
          type = "description",
          name = "These options allow you to filter |cff71d5ffOutgoing Spells|r that your player does. In order to filter them, you need to type the |cffFFFF00Spell ID|r of the spell.",
        },
        whitelistSpells = {
          order = 1,
          type = 'toggle',
          name = "白名单",
          desc = "Filtered |cff71d5ffOutgoing Spells|r will be on a whitelist (opposed to a blacklist).",
          set = set0_1,
          get = get0_1,
          width = "full",
        },
        spellName = {
          order = 2,
          type = 'input',
          name = "技能ID",
          desc = "The spell ID of the |cff71d5ffOutgoing Spell|r you want to filter.",
          set = setSpell,
          get = noop,
        },
        checkAdd = {
          order = 3,
          type = 'toggle',
          name = "移除",
          desc = "Check to remove the spell from the filtered list.",
          get = getCheckAdd,
          set = setCheckAdd,
        },

        -- This is a feature option that I will enable when I get more time D:
        selectTracked = {
          order = 4,
          type = 'select',
          name = "技能历史记录:",
          desc = "A list of |cff71d5ffOutgoing Spell|r IDs that have been seen. |cffFF0000Requires:|r |cff798BDDTrack Spell History|r",
          disabled = IsTrackSpellsDisabled,
          values = GetSpellHistory,
          get = noop,
          set = setSpell,
        },
      },
    },

    listItems = {
      name = "|cffFFFFFF过滤:|r |cff798BDD物品(+)|r",
      type = 'group',
      order = 50,
      guiInline = false,
      args = {
        title = {
          order = 0,
          type = "description",
          name = "These options allow you to filter out |cff8020FFItems|r that your player collects.  In order to filter them, you need to type the |cffFFFF00exact name of the item|r (case sensitive).",
        },
        whitelistItems = {
          order = 1,
          type = 'toggle',
          name = "白名单",
          desc = "Filtered |cff798BDDItems (Plus)|r will be on a whitelist (opposed to a blacklist).",
          set = set0_1,
          get = get0_1,
          width = "full",
        },
        spellName = {
          order = 2,
          type = 'input',
          name = "物品ID",
          desc = "The Item ID of the |cff798BDDItem|r you want to filter.",
          set = setSpell,
          get = noop,
        },
        checkAdd = {
          order = 3,
          type = 'toggle',
          name = "移除",
          desc = "Check to remove the spell from the filtered list.",
          get = getCheckAdd,
          set = setCheckAdd,
        },

        -- This is a feature option that I will enable when I get more time D:
        selectTracked = {
          order = 4,
          type = 'select',
          name = "物品历史记录:",
          desc = "A list of |cff798BDDItem|r IDs that have been seen. |cffFF0000Requires:|r |cff798BDDTrack Spell History|r",
          disabled = IsTrackSpellsDisabled,
          values = GetItemHistory,
          get = noop,
          set = setSpell,
        },
      },
    },


  },
}

addon.options.args["Credits"] = {
  name = "Credits",
  type = 'group',
  order = 4,
  args = {
    title = {
      type = "header",
      order = 0,
      name = "Credits",
    },
    specialThanksTitle = {
      type = 'description',
      order = 1,
      name = "|cffFFFF00Special Thanks|r",
      fontSize = "large",
    },
    specialThanksList = {
      type = 'description',
      order = 2,
      fontSize = "medium",
      name = "  |cffAA0000Tukz|r, |cffAA0000Elv|r, |cffFFFF00Affli|r, |cffFF8000BuG|r, |cff8080FFShestak|r, Nidra, gnangnan, NitZo, Naughtia, Derap, sortokk, ckaotik, Cecile.",
    },
    testerTitleSpace1 = {
      type = 'description',
      order = 3,
      name = " ",
    },

    testerTitle = {
      type = 'description',
      order = 10,
      name = "|cffFFFF00Beta Testers - Version 3.0.0|r",
      fontSize = "large",
    },
    userName1 = {
      type = 'description',
      order = 11,
      fontSize = "medium",
      name = " |cffAAAAFF Alex|r,|cff8080EE BuG|r,|cffAAAAFF Kkthnxbye|r,|cff8080EE Azilroka|r,|cffAAAAFF Prizma|r,|cff8080EE schmeebs|r,|cffAAAAFF Pat|r,|cff8080EE hgwells|r,|cffAAAAFF Jaron|r,|cff8080EE Fitzbattleaxe|r,|cffAAAAFF Nihan|r,|cff8080EE Jaxo|r,|cffAAAAFF Schaduw|r,|cff8080EE sylenced|r,|cffAAAAFF kaleidoscope|r,|cff8080EE Killatones|r,|cffAAAAFF Trokko|r,|cff8080EE Yperia|r,|cffAAAAFF Edoc|r,|cff8080EE Cazart|r,|cffAAAAFF Nevah|r,|cff8080EE Refrakt|r,|cffAAAAFF Thakah|r,|cff8080EE johnis007|r,|cffAAAAFF Sgt|r,|cff8080EE NitZo|r,|cffAAAAFF cptblackgb|r,|cff8080EE pollyzoid|r.",
    },

    testerTitleSpace2 = {
      type = 'description',
      order = 20,
      name = " ",
    },
    curseTitle = {
      type = 'description',
      order = 21,
      name = "|cffFFFF00Beta Testers - Version 4.0.0 (Curse)|r",
      fontSize = "large",
    },
    userName2 = {
      type = 'description',
      order = 22,
      fontSize = "medium",
      name = " |cffAAAAFF CadjieBOOM|r,|cff8080EE Mokal|r,|cffAAAAFF ShadoFall|r,|cff8080EE alloman|r,|cffAAAAFF chhld|r,|cff8080EE chizzlestick|r,|cffAAAAFF egreym|r,|cff8080EE nukme|r,|cffAAAAFF razrwolf|r,|cff8080EE star182|r,|cffAAAAFF zacheklund|r"
    },

    testerTitleSpace3 = {
      type = 'description',
      order = 30,
      name = " ",
    },
    tukuiTitle = {
      type = 'description',
      order = 31,
      name = "|cffFFFF00Beta Testers - Version 4.0.0 (Tukui)|r",
      fontSize = "large",
    },
    userName3 = {
      type = 'description',
      order = 32,
      fontSize = "medium",
      name = " |cffAAAAFF Affiniti|r,|cff8080EE Badinfluence|r,|cffAAAAFF Badinfluence|r,|cff8080EE BuG|r,|cffAAAAFF Curdi|r,|cff8080EE Dorkie|r,|cffAAAAFF Galadeon|r,|cff8080EE HarryDotter|r,|cffAAAAFF Joebacsi21|r,|cff8080EE Kuron|r,|cffAAAAFF Mabb22|r,|cff8080EE Narlya|r,|cffAAAAFF Nihan|r,|cff8080EE Verdell|r,|cffAAAAFF arzelia|r,|cff8080EE blessed|r,|cffAAAAFF djouga|r,|cff8080EE fakemessiah|r,|cffAAAAFF faze|r,|cff8080EE firewall|r,|cffAAAAFF jatha86|r,|cff8080EE jaydogg10|r,|cffAAAAFF jlor|r,|cff8080EE lunariongames|r,|cffAAAAFF stoankold|r",
    },

    testerTitleSpace3Legion = {
      type = 'description',
      order = 33,
      name = " ",
    },
    tukuiTitleLegion = {
      type = 'description',
      order = 34,
      name = "|cffFFFF00Beta Testers - Version 4.2.0 for Legion|r",
      fontSize = "large",
    },
    userName3Legion = {
      type = 'description',
      order = 35,
      fontSize = "medium",
      name = " |cffAAAAFF Azazu|r,|cff8080EE Merathilis|r,|cffAAAAFF Torch|r,|cff8080EE Broni|r,|cffAAAAFF Zylos|r",
    },

    testerTitleSpace4 = {
      type = 'description',
      order = 40,
      name = " ",
    },

    githubTitle = {
      type = 'description',
      order = 41,
      name = "|cffFFFF00Thank You Github Contributors!|r",
      fontSize = "large",
    },
    userName4 = {
      type = 'description',
      order = 42,
      fontSize = "medium",
      name = " |cff22FF80 Tonyleila|r,|cff1AAD59 ckaotik|r,|cff22FF80 Stanzilla|r,|cff1AAD59 Torch (behub)|r,|cff22FF80 vforge|r",
    },

    testerTitleSpace5 = {
      type = 'description',
      order = 50,
      name = " ",
    },

    contactTitle = {
      type = 'description',
      order = 51,
      name = "|cffFFFF00Contact Me|r",
      fontSize = "large",
    },

    contactStep1 = {
      type = 'description',
      order = 52,
      name = "1. GitHub: |cff22FF80https://github.com/dandruff/xCT|r\n\n2. Send a PM to |cffFF8000Dandruff|r at |cff6495EDhttp://tukui.org/|r",
    }
  }
}

addon.options.args["FloatingCombatText"] = {
  name = "浮动战斗文字",
  type = 'group',
  order = 1,
  args = {
    title2 = {
      order = 0,
      type = "description",
      name = "|cffA0A0A0一些改变需要完整的|r |cffD0D000重启客户端|r |cffA0A0A0(完全退出WoW). 不要使用|r |cffD00000Alt+F4|r |cffA0A0A0or|r |cffD00000Command+Q|r |cffA0A0A0你的设置将不能保存. 使用'|r|cff798BDD/exit|r|cffA0A0A0' 去关闭客户端.|r",
      fontSize = "small",
    },

    listSpacer1 = {
      type = "description",
      order = 3,
      name = "\n\n|cff798BDDFloating Combat Text|r |cffFF0000Advanced Settings|r:",
      fontSize = 'large',
    },

    bypassCVARUpdates = {
      order = 4,
      type = 'toggle',
      name = "Bypass CVar Updates (requires |cffFF0000/reload|r)",
      desc = "Allows you to bypass xCT+'s CVar engine. This option might help if you have FCT enabled, but it disappears after awhile. Once you set your FCT options, enable this. Requires a UI reload after changing.",
      width = 'full',
      get = function( info ) return x.db.profile.bypassCVars end,
      set = function( info, value ) x.db.profile.bypassCVars = value end,
    },

    listSpacer2 = {
      type = "description",
      order = 5,
      name = "\n\n",
      fontSize = 'large',
    },

    blizzardFCT = {
      name = "", --Blizzard's Floating Combat Text |cffFFFFFF(Head Numbers)|r",
      type = 'group',
      order = 1,
      guiInline = true,
      disabled = isCVarsDisabled,
      args = {
        listSpacer0 = {
          type = "description",
          order = 0,
          name = "|cff798BDD浮动战斗文字设置|r:\n",
          fontSize = 'large',
        },

        -- Damage
        headerDamage = {
          type = "description",
          order = 1,
          name = "|cffFFFF00伤害:|r",
          fontSize = 'medium',
        },

        floatingCombatTextCombatDamage = {
          order = 2,
          name = "显示伤害",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到你的伤害请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextCombatLogPeriodicSpells = {
          order = 3,
          name = "显示DOT",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到你的DOT伤害请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextCombatDamageAllAutos = {
          order = 4,
          name = "显示自动攻击",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到你自动攻击伤害请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextPetMeleeDamage = {
          order = 5,
          name = "显示宠物近战伤害",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到你宠物的近战伤害请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextPetSpellDamage = {
          order = 6,
          name = "显示宠物技能",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到你宠物的技能请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextDamageReduction = {
          order = 7,
          name = "显示伤害吸收",
          type = 'toggle',
          desc = "New option in Legion. Updating description soon.",
          get = get0,
          set = set0_update,
        },

        -- Healing and Absorbs
        headerHealingAbsorbs = {
          type = "description",
          order = 10,
          name = "\n|cffFFFF00治疗和吸收:|r",
          fontSize = 'medium',
        },

        floatingCombatTextCombatHealing = {
          order = 11,
          name = "显示治疗",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到你的治疗请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextFriendlyHealers = {
          order = 12,
          name = "显示友方治疗",
          type = 'toggle',
          desc = "New option in Legion. Updating description soon.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextCombatHealingAbsorbSelf = {
          order = 13,
          name = "显示吸收量 (自己)",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到显示吸收量 (自己)请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextCombatHealingAbsorbTarget = {
          order = 14,
          name = "显示吸收量 (目标)",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到显示吸收量 (目标)请启用此选项.",
          get = get0,
          set = set0_update,
        },


        -- Gains
        headerGains = {
          type = "description",
          order = 20,
          name = "\n|cffFFFF00玩家 获取:|r",
          fontSize = 'medium',
        },

        floatingCombatTextEnergyGains = {
          order = 21,
          name = "显示能量获取",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到显示能量获取请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextPeriodicEnergyGains = {
          order = 21,
          name = "显示能量获取 (周期性)",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到显示能量获取(周期性)请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextComboPoints = {
          order = 22,
          name = "显示连击点数",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到显示连击点数请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextHonorGains = {
          order = 23,
          name = "显示荣誉获取",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到显示荣誉获取请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextRepChanges = {
          order = 24,
          name = "显示声望获取",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到显示声望获取请启用此选项.",
          get = get0,
          set = set0_update,
        },


        -- Status Effects
        headerStatusEffects = {
          type = "description",
          order = 30,
          name = "\n|cffFFFF00特效状态:|r",
          fontSize = 'medium',
        },

        floatingCombatTextDodgeParryMiss = {
          order = 31,
          name = "显示未命中类型",
          type = 'toggle',
          desc = "当你未命中你的目标时, 显示'未命中', '躲闪', '招架'.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextAuras = {
          order = 32,
          name = "显示光环",
          type = 'toggle',
          desc = "New option in Legion. Updating description soon.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextSpellMechanics = {
          order = 33,
          name = "显示效果 (自己)",
          type = 'toggle',
          desc = "如果你想看到自已的陷井和图腾等请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextSpellMechanicsOther = {
          order = 34,
          name = "显示效果 (团队)",
          type = 'toggle',
          desc = "如果你想看到其它玩家的陷井和图腾等请启用此选项.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextAllSpellMechanics = {
          order = 35,
          name = "显示效果 (全部)",
          type = 'toggle',
          desc = "如果你想看到所有玩家的陷井和图腾等请启用此选项.",
          get = get0,
          set = set0_update,
        },

        CombatThreatChanges = {
          order = 36,
          type = 'toggle',
          name = "显示仇恨改变",
          desc = "如果你想在浮动文字中看到仇恨变化信息请启用此选项.",
          get = get0,
          set = set0_update,
        },


        -- Player's Status
        headerPlayerStatus = {
          type = "description",
          order = 40,
          name = "\n|cffFFFF00玩家状态:|r",
          fontSize = 'medium',
        },

        floatingCombatTextCombatState = {
          order = 41,
          name = "显示战斗状态",
          type = 'toggle',
          desc = "如果你想在浮动文字中看到进入战斗/离开战斗请启用此选项",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextLowManaHealth = {
          order = 42,
          name = "显示低生命值或者低法力值状态",
          type = 'toggle',
          desc = "如果你想在浮动文字中显示低生命值或者低法力值状态请启用此选项",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextReactives = {
          order = 43,
          name = "显示技能反映",
          type = 'toggle',
          desc = "如果你想看到你的技能反映启用此选项（致命一击，暗言术：死亡，等）",
          get = get0,
          set = set0_update,
        },


        -- Misc
        --[[
        headerMisc = {
          type = "description",
          order = 20,
          name = "|cffFFFF00Misc:|r",
          fontSize = 'medium',
        },

        floatingCombatTextCombatDamageDirectionalOffset = {
          order = 51,
          name = "Show Damage",
          type = 'toggle',
          desc = "Amount to offset directional damage numbers when they start.",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextCombatDamageDirectionalScale = {
          order = 51,
          name = "Show Damage",
          type = 'toggle',
          desc = "Directional damage numbers movement scale (0 = no directional numbers)",
          get = get0,
          set = set0_update,
        },

        floatingCombatTextFloatMode = {
          order = 51,
          name = "Show Damage",
          type = 'range',
          desc = "The combat text float mode.",
          
          min = 1, max = 100,
          get = get0,
          set = set0_update,
        },]]













        --[==[
        CombatDamage = {
          order = 2,
          type = 'toggle',
          name = "Show Damage",
          desc = "Enable this option if you want your damage as Floating Combat Text.",
          get = get0,
          set = set0_update,
        },

        CombatLogPeriodicSpells = {
          order = 3,
          type = 'toggle',
          name = "Show Damage over Time",
          desc = "Enable this option if you want your DoT's as Floating Combat Text.",
          get = get0,
          set = set0_update,
          disabled = function(info) return isCVarsDisabled( ) or not x.db.profile.blizzardFCT.CombatDamage end,
        },

        PetMeleeDamage = {
          order = 4,
          type = 'toggle',
          name = "Show Pet Melee Damage",
          desc = "Enable this option if you want your pet's melee damage as Floating Combat Text.",
          get = get0,
          set = set0_update,
          disabled = function(info) return isCVarsDisabled( ) or not x.db.profile.blizzardFCT.CombatDamage end,
        },

        CombatHealing = {
          order = 5,
          type = 'toggle',
          name = "Show Healing",
          desc = "Enable this option if you want your healing as Floating Combat Text.",
          get = get0,
          set = set0_update,
        },

        CombatHealingAbsorbTarget = {
          order = 6,
          type = 'toggle',
          name = "Show Absorbs",
          desc = "Enable this option if you want your aborbs as Floating Combat Text.",
          get = get0,
          set = set0_update,
        },

        

        -- Floating Combat Text Effects
        fctSpellMechanics = {
          order = 8,
          type = 'toggle',
          name = "Show Effects",
          desc = "Enable this option if you want to see your snares and roots.",
          get = get0,
          set = set0_update,
        },

        fctSpellMechanicsOther = {
          order = 9,
          type = 'toggle',
          name = "Show Other's Effects",
          desc = "Enable this option if you want to see other player's snares and roots too.",
          get = get0,
          set = set0_update,
          disabled = function(info) return isCVarsDisabled( ) or not x.db.profile.blizzardFCT.fctSpellMechanics end,
        },

        listSpacer2 = {
          type = "description",
          order = 20,
          name = "\n\n|cff798BDDFloating Combat Text Target Mode|r:",
          fontSize = 'large',
        },

        CombatDamageStyle = {
          type = "select",
              order = 21,
          name = "Target Mode:",
          values = {
            [1] = COMBAT_TARGET_MODE_NEW,
            [2] = COMBAT_TARGET_MODE_OLD,
          },
          get = get0,
          set = set0_update,
          desc = "Allows you to change how your target's FCT is displayed.\n\n|cff798BDD"..COMBAT_TARGET_MODE_NEW.."|r - |cffFF8000(Fastest)|r displays damage on your target in an arc. New in WoD.\n\n|cff798BDD"..COMBAT_TARGET_MODE_OLD.."|r - |cffFF8000(Slower)|r displays damage floating up. This was the old default in MoP.",
        },

        listSpacer3 = {
          type = "description",
          order = 30,
          name = "\n\n|cff798BDDFloating Combat Text 字体|r:",
          fontSize = 'large',
        },

        enabled = {
          order = 31,
          type = 'toggle',
          name = "Customize",
          get = get0,
          set = set0_update,
        },

        font = {
          type = 'select', dialogControl = 'LSM30_Font',
          order = 32,
          name = "Blizzard's FCT Font",
          desc = "Set the font Blizzard's head numbers (|cffFFFF00Default:|r Friz Quadrata TT)",
          values = AceGUIWidgetLSMlists.font,
          get = get0,
          set = function(info, value)
            x.db.profile.blizzardFCT.font = value
            x.db.profile.blizzardFCT.fontName = LSM:Fetch("font", value)

            --x:UpdateFrames()
            --x.cvar_update()
          end,
          disabled = function(info) return isCVarsDisabled( ) or not x.db.profile.blizzardFCT.enabled end,
        },
        ]==]




      },
    },
    --[[
    battlePetFCT = {
      name = "Battle Pets",
      type = 'group',
      order = 2,
      args = {
        title1 = {
          order = 0,
          type = "description",
          name = "Battle Pet Settings to go in here :)",
        },
      },
    },
    ]]
  },
}

addon.options.args["Frames"] = {
  name = "窗口",
  type = 'group',
  order = 0,
  args = {


    frameSettings = {
      name = "窗口设置",
      type = 'group',
      order = 1,
      guiInline = true,
      args = {

        listSpacer0 = {
          type = "description",
          order = 1,
          name = "|cff798BDD离开窗口时|r:",
          fontSize = 'large',
        },

        showGrid = {
          order = 2,
          type = 'toggle',
          name = "显示对齐的网格",
          desc = "显示网络,在你打开窗口时帮你更好的对齐|cffFF0000x|r|cffFFFF00CT|r|cffFF0000+|r 窗口",
          get = get0,
          set = set0,
        },

        showPositions = {
          order = 3,
          type = 'toggle',
          name = "显示位置",
          desc = "S显示位置和尺寸,在你打开窗口时帮你更好的对齐|cffFF0000x|r|cffFFFF00CT|r|cffFF0000+|r 窗口",
          get = get0,
          set = set0,
        },

        listSpacer1 = {
          type = "description",
          order = 10,
          name = "\n|cff798BDD显示窗口时|r:",
          fontSize = 'large',
        },

        frameStrata = {
          type = 'select',
          order = 11,
          name = "窗口层级",
          desc = "放置|cffFF0000x|r|cffFFFF00CT|r|cffFF0000+|r的窗口,如果其它插件的挡在|cffFF0000x|r|cffFFFF00CT|r|cffFF0000+|r窗口前面,你可以适当的提高|cffFF0000x|r|cffFFFF00CT|r|cffFF0000+|r窗口的层级.",
          values = {
            --["1PARENT"]             = "Parent |cffFF0000(Lowest)|r",
            ["2BACKGROUND"]         = "背景 |cffFF0000(最低的)|r",
            ["3LOW"]                = "低",
            ["4MEDIUM"]             = "中",
            ["5HIGH"]               = "高 |cffFFFF00(默认)|r",
            ["6DIALOG"]             = "对话框",
            ["7FULLSCREEN"]         = "全屏",
            ["8FULLSCREEN_DIALOG"]  = "全屏对话框",
            ["9TOOLTIP"]            = "鼠标提示 |cffAAFF80(最高的)|r",
          },
          get = get0,
          set = set0_update,
        },

        listSpacer2 = {
          type = "description",
          order = 20,
          name = "\n|cff798BDD离开战斗时|r:",
          fontSize = 'large',
        },

        clearLeavingCombat = {
          order = 21,
          type = 'toggle',
          name = "清空窗口",
          desc = "Enable this option if you have problems with 'floating' icons.",
          width = "full",
          get = get0,
          set = set0,
        },

      },
    },

    spacer1 = {
      type = 'description',
      name = "\n",
      order = 2,
    },

    megaDamage = {
      name = "数字格式化设置",
      type = 'group',
      order = 3,
      guiInline = true,
      args = {
        listSpacer0 = {
          type = "description",
          order = 0,
          name = "|cff798BDD格式化数字|r (选择一个):",
          fontSize = 'large',
        },
        formatAbbreviate = {
          type = 'toggle',
          order = 1,
          name = "缩写数字",
          set = setFormating,
          get = getDBSpells,
        },
        formatGroups = {
          type = 'toggle',
          order = 2,
          name = "十进制的标记",
          desc = "为了更好的去阅读，使用逗号来隔开十进制数字\n\n|cffFF0000例子|r |cff798BDD12,890|r",
          set = setFormating,
          get = getDBSpells,
        },

        abbDesc = {
          type = "description",
          order = 9,
          name = "\n\n|cffFFFF00PLEASE NOTE|r |cffAAAAAAFormat settings need to be independently enabled on each frame through its respective settings page.|r",
          fontSize = 'small',
        },

        listSpacer1 = {
          type = "description",
          order = 10,
          name = "\n|cff798BDD缩写设置|r:",
          fontSize = 'large',
        },
        thousandSymbol = {
          order = 11,
          type = 'input',
          name = "千",
          desc = "符号显示:|cffFF0000千|r |cff798BDD(10e+3)|r",
          get = getTextIn0,
          set = setTextIn0,
        },
        millionSymbol = {
          order = 12,
          type = 'input',
          name = "百万",
          desc = "符号显示:|cffFF0000百万|r |cff798BDD(10e+6)|r",
          get = getTextIn0,
          set = setTextIn0,
        },
        decimalPoint = {
          order = 13,
          type = 'toggle',
          name = "1位小数",
          desc = "显示缩写数值时显示1位小数(如将显示|cff798BDD5.9K|r 而不是|cff798BDD6K|r).",
          get = get0,
          set = set0,
        },
      },
    },

    spacer2 = {
      type = 'description',
      name = "\n",
      order = 4,
    },

    miscFonts = {
      order = 5,
      type = 'group',
      guiInline = true,
      name = "全局窗口设置 |cffFFFFFF(Experimental)|r",
      args = {
        miscDesc = {
          type = "description",
          order = 0,
          name = "点击|cffFFFF00设置所有|r 将应用设置到所有的|cffFF0000x|r|cffFFFF00CT|r|cffFF0000+|r 窗口.\n",
        },


        font = {
          type = 'select', dialogControl = 'LSM30_Font',
          order = 1,
          name = "字体",
          desc = "设置窗口字体",
          values = AceGUIWidgetLSMlists.font,
          get = function(info) return miscFont end,
          set = function(info, value) miscFont = value end,
        },

        applyFont = {
          type = 'execute',
          order = 2,
          name = "设置所有",
          width = "half",
          func = function()
            if miscFont then
              for framename, settings in pairs(x.db.profile.frames) do
                settings.font = miscFont
              end
              x:UpdateFrames()
            end
          end,
        },

        spacer1 = {
          type = 'description',
          order = 3,
          name = "",
        },

        fontOutline = {
          type = 'select',
          order = 4,
          name = "字体轮廓",
          desc = "设置字体轮廓",
          values = {
            ['1NONE'] = "None",
            ['2OUTLINE'] = 'OUTLINE',
            -- BUG: Setting font to monochrome AND above size 16 will crash WoW
            -- http://us.battle.net/wow/en/forum/topic/6470967362
            ['3MONOCHROME'] = 'MONOCHROME',
            ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
            ['5THICKOUTLINE'] = 'THICKOUTLINE',
          },
          get = function(info) return miscFontOutline end,
          set = function(info, value) miscFontOutline = value end,
        },

        applyFontOutline = {
          type = 'execute',
          order = 5,
          name = "设置所有",
          width = "half",
          func = function()
            if miscFontOutline then
              for framename, settings in pairs(x.db.profile.frames) do
                settings.fontOutline = miscFontOutline
              end
              x:UpdateFrames()
            end
          end,
        },

        spacer2 = {
          type = 'description',
          order = 6,
          name = "",
        },

        customFade = {
          type = 'toggle',
          order = 7,
          name = "使用自定义淡出",
          desc = "允许你自定义每个窗口的淡出时间",
          get = function(info) return miscEnableCustomFade end,
          set = function(info, value) miscEnableCustomFade = value end,
        },

        applyCustomFade = {
          type = 'execute',
          order = 8,
          name = "设置所有",
          width = "half",
          func = function()
            if miscEnableCustomFade ~= nil then
              for framename, settings in pairs(x.db.profile.frames) do
                if settings.enableCustomFade ~= nil then
                  settings.enableCustomFade = miscEnableCustomFade
                end
              end
              x:UpdateFrames()
            end
          end,
        },

      },
    },

    spacer3 = {
      type = 'description',
      name = "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n",
      order = 6,
    },

--[[ XCT+ The Frames: ]]
    general = {
      name = "|cffFFFFFF综合|r",
      type = 'group',
      order = 11,
      childGroups = 'tab',
      args = {

        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                --[1] = "综合",
                [2] = "伤害输出",
                [3] = "伤害输出(爆击)",
                [4] = "承受伤害",
                [5] = "受到治疗",
                [6] = "职业能量",
                [7] = "特殊效果(特效)",
                [8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            megaDamage = {
              order = 5,
              type = 'toggle',
              name = "数字格式化",
              desc = "Enables number formatting. This option can be customized in the main |cff00FF00Frames|r options page to be either |cff798BDDAbbreviation|r or |cff798BDDDecimal Marks|r. ",
              get = get2,
              set = set2,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 20,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 21,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 22,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 23,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 24,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },

          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体.",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },

            iconSizeSettings = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD图标尺寸设置|r:",
              fontSize = 'large',
            },
            iconsEnabled = {
              order = 11,
              type = 'toggle',
              name = "图标",
              desc = "显示伤害图标",
              get = get2,
              set = set2,
              disabled = isFrameItemDisabled,
            },
            iconsSize = {
              order = 12,
              name = "图标尺寸",
              desc = "设置图标尺寸",
              type = 'range',
              min = 6, max = 22, step = 1,
              get = get2,
              set = set2,
              disabled = isFrameIconDisabled,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

        specialTweaks = {
          order = 40,
          name = "特殊调整",
          type = 'group',
          args = {
            specialTweaks = {
              type = 'description',
              order = 0,
              name = "|cff798BDD特殊调整|r:",
              fontSize = 'large',
            },
            showInterrupts = {
              order = 1,
              type = 'toggle',
              name = "打断",
              desc = "显示你成功打断的技能",
              get = get2,
              set = set2,
            },
            showDispells = {
              order = 2,
              type = 'toggle',
              name = "驱散/偷取",
              desc = "显示你驱散或偷取的技能",
              get = get2,
              set = set2,
            },
            showPartyKills = {
              order = 3,
              type = 'toggle',
              name = "单位击杀",
              desc = "显示被杀死的单位你的最后一击.",
              get = get2,
              set = set2,
            },
            showBuffs = {
              order = 4,
              type = 'toggle',
              name = "Buff的获取和消失",
              desc = "显示有益的光环名字|cff00FF00(Buffs)|r 你获得和失去的.",
              get = get2,
              set = set2,
            },
            showDebuffs = {
              order = 5,
              type = 'toggle',
              name = "Debuff的获取和消失",
              desc = "显示有害的光环名字|cff00FF00(Buffs)|r 你获得和失去的.",
              get = get2,
              set = set2,
            },
            showLowManaHealth = {
              order = 6,
              type = 'toggle',
              name = "低 血量/法力",
              desc = "显示'低血量/法力' 当你的血量/法力低于最低阀值时.",
              get = get2,
              set = set2,
            },
            showCombatState = {
              order = 7,
              type = 'toggle',
              name = "进出战斗",
              desc = "在你进入或离开战斗时显示提示",
              get = get2,
              set = set2,
            },
            showRepChanges = {
              order = 8,
              type = 'toggle',
              name = "显示声望",
              desc = "显示你声望的得失",
              get = get2,
              set = set2,
            },
            showHonorGains = {
              order = 9,
              type = 'toggle',
              name = "显示荣誉",
              desc = "显示你荣誉的收益",
              get = get2,
              set = set2,
            },
          },
        },

      },
    },

    outgoing = {
      name = "|cffFFFFFF输出|r",
      type = 'group',
      order = 12,
      childGroups = 'tab',
      args = {

        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                [1] = "综合",
                --[2] = "伤害输出",
                [3] = "伤害输出(爆击)",
                [4] = "承受伤害",
                [5] = "受到治疗",
                [6] = "职业能量",
                [7] = "特殊效果(特效)",
                [8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            megaDamage = {
              order = 5,
              type = 'toggle',
              name = "数字格式化",
              desc = "Enables number formatting. This option can be customized in the main |cff00FF00Frames|r options page to be either |cff798BDDAbbreviation|r or |cff798BDDDecimal Marks|r. ",
              get = get2,
              set = set2,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 30,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 31,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 32,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 33,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 34,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },

          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },

            iconSizeSettings = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD图标尺寸设置|r:",
              fontSize = 'large',
            },
            iconsEnabled = {
              order = 11,
              type = 'toggle',
              name = "图标",
              desc = "显示伤害图标",
              get = get2,
              set = set2,
              disabled = isFrameItemDisabled,
            },
            iconsSize = {
              order = 12,
              name = "图标尺寸",
              desc = "设置图标尺寸",
              type = 'range',
              min = 6, max = 22, step = 1,
              get = get2,
              set = set2,
              disabled = isFrameIconDisabled,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

        specialTweaks = {
          order = 40,
          type = 'group',
          name = "特殊调整",
          args = {
            specialTweaks = {
              type = 'description',
              order = 0,
              name = "|cff798BDD特殊调整|r:",
              fontSize = 'large',
            },
            enableOutDmg = {
              order = 1,
              type = 'toggle',
              name = "显示输出伤害",
              desc = "显示你的伤害",
              get = get2,
              set = set2,
            },
            enableOutHeal = {
              order = 2,
              type = 'toggle',
              name = "显示输出治疗",
              desc = "显示你的治疗",
              get = get2,
              set = set2,
            },
            enablePetDmg = {
              order = 3,
              type = 'toggle',
              name = "显示宠物伤害",
              desc = "显示你的宠物伤害",
              get = get2,
              set = set2,
            },
            enableAutoAttack = {
              order = 4,
              type = 'toggle',
              name = "显示自动攻击",
              desc = "显示你的自动攻击伤害",
              get = get2,
              set = set2,
            },
            enableDotDmg = {
              order = 5,
              type = 'toggle',
              name = "显示DOT伤害",
              desc = "显示你的DOT伤害. (|cffFF0000需求:|r 伤害输出)",
              get = get2,
              set = set2,
            },
            enableHots = {
              order = 6,
              type = 'toggle',
              name = "显示HOT",
              desc = "显示你的HOT治疗. (|cffFF0000需求:|r 治疗输出)",
              get = get2,
              set = set2,
            },
            enableImmunes = {
              order = 7,
              type = 'toggle',
              name = "显示免疫",
              desc = "当目标不能攻击时显示'免疫'",
              get = get2,
              set = set2,
            },
            enableMisses = {
              order = 8,
              type = 'toggle',
              name = "显示未命中类型",
              desc = "当你未命中你的目标时, 显示'未命中', '躲闪', '招架'.",
              get = get2,
              set = set2,
            },
          },
        },

      },
    },

    critical = {
      name = "|cffFFFFFF输出|r |cff798BDD(暴击)|r",
      type = 'group',
      order = 13,
      childGroups = 'tab',
      args = {


        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                [1] = "综合",
                [2] = "伤害输出",
                --[3] = "伤害输出(爆击)",
                [4] = "承受伤害",
                [5] = "受到治疗",
                [6] = "职业能量",
                [7] = "特殊效果(特效)",
                [8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            megaDamage = {
              order = 5,
              type = 'toggle',
              name = "数字格式化",
              desc = "Enables number formatting. This option can be customized in the main |cff00FF00Frames|r options page to be either |cff798BDDAbbreviation|r or |cff798BDDDecimal Marks|r. ",
              get = get2,
              set = set2,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 30,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 31,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 32,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 33,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 34,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },

            iconSizeSettings = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD图标尺寸设置|r:",
              fontSize = 'large',
            },
            iconsEnabled = {
              order = 11,
              type = 'toggle',
              name = "图标",
              desc = "显示伤害图标",
              get = get2,
              set = set2,
              disabled = isFrameItemDisabled,
            },
            iconsSize = {
              order = 12,
              name = "图标尺寸",
              desc = "设置图标尺寸",
              type = 'range',
              min = 6, max = 22, step = 1,
              get = get2,
              set = set2,
              disabled = isFrameIconDisabled,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

        specialTweaks = {
          order = 40,
          type = 'group',
          name = "特殊调整",
          args = {
            specialTweaks = {
              type = 'description',
              order = 0,
              name = "|cff798BDD特殊调整|r:",
              fontSize = 'large',
            },
            showSwing = {
              order = 1,
              type = 'toggle',
              name = "显示自动攻击",
              desc = "Show Auto Attack and Swings criticals in this frame. If disabled here, they are automatically shown in the Outgoing frame and can be completely disabled there.",
              get = get2,
              set = set2,
            },
            prefixSwing = {
              order = 2,
              type = 'toggle',
              name = "显示自动攻击前后缀",
              desc = "自动攻击爆击附加前后缀,使其更加显目",
              get = get2,
              set = set2,
            },

            criticalAppearance = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD爆击的外观|r:",
              fontSize = 'large',
            },
            critPrefix = {
              order = 11,
              type = 'input',
              name = "前缀",
              desc = "附加在爆击数值前面的值.",
              get = getTextIn2,
              set = setTextIn2,
              disabled = isFrameItemDisabled,
            },
            critPostfix = {
              order = 12,
              type = 'input',
              name = "后缀",
              desc = "附加在爆击数值后面的值.",
              get = getTextIn2,
              set = setTextIn2,
              disabled = isFrameItemDisabled,
            },
          },

        },
      },
    },

    damage = {
      name = "|cffFFFFFF承受|r |cff798BDD(伤害)|r",
      type = 'group',
      order = 14,
      childGroups = 'tab',
      args = {

        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                [1] = "综合",
                [2] = "伤害输出",
                [3] = "伤害输出(爆击)",
                --[4] = "承受伤害",
                [5] = "受到治疗",
                [6] = "职业能量",
                [7] = "特殊效果(特效)",
                [8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            megaDamage = {
              order = 5,
              type = 'toggle',
              name = "数字格式化",
              desc = "Enables number formatting. This option can be customized in the main |cff00FF00Frames|r options page to be either |cff798BDDAbbreviation|r or |cff798BDDDecimal Marks|r. ",
              get = get2,
              set = set2,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 20,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 21,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 22,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 23,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 24,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },

          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

        specialTweaks = {
          order = 40,
          name = "特殊调整",
          type = 'group',
          args = {
            specialTweaks = {
              type = 'description',
              order = 0,
              name = "|cff798BDD特殊调整|r:",
              fontSize = 'large',
            },
            showDodgeParryMiss = {
              order = 1,
              type = 'toggle',
              name = "显示未命中类型",
              desc = "当你未命中你的目标时, 显示'未命中', '躲闪', '招架'.",
              get = get2,
              set = set2,
            },
            showDamageReduction = {
              order = 2,
              type = 'toggle',
              name = "显示吸收",
              desc = "格式化显示多少伤害被吸收",
              get = get2,
              set = set2,
            },
          },
        },
      },
    },

    healing = {
      name = "|cffFFFFFF受到|r |cff798BDD(治疗)|r",
      type = 'group',
      order = 15,
      childGroups = 'tab',
      args = {

        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                [1] = "综合",
                [2] = "伤害输出",
                [3] = "伤害输出(爆击)",
                [4] = "承受伤害",
                --[5] = "受到治疗",
                [6] = "职业能量",
                [7] = "特殊效果(特效)",
                [8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            megaDamage = {
              order = 5,
              type = 'toggle',
              name = "数字格式化",
              desc = "Enables number formatting. This option can be customized in the main |cff00FF00Frames|r options page to be either |cff798BDDAbbreviation|r or |cff798BDDDecimal Marks|r. ",
              get = get2,
              set = set2,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 20,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 21,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 22,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 23,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 24,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },

          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

        specialTweaks = {
          order = 40,
          name = "特殊调整",
          type = 'group',
          args = {
            specialTweaks = {
              type = 'description',
              order = 0,
              name = "|cff798BDD特殊调整|r:",
              fontSize = 'large',
            },
            showFriendlyHealers = {
              order = 1,
              type = 'toggle',
              name = "显示姓名",
              desc = "显示受到的治疗者姓名",
              get = get2,
              set = set2,
            },
            enableClassNames = {
              order = 2,
              type = 'toggle',
              name = "职业色姓名",
              desc = "职业色治疗者姓名. \n\n|cffFF0000需求:|r 治疗者在|cffAAAAFF队伍|r或|cffFF8000团队|r中",
              get = get2,
              set = set2,
            },
            enableRealmNames = {
              order = 3,
              type = 'toggle',
              name = "显示服务器名",
              desc = "显示受到的治疗姓名附带他们的服务器名",
              get = get2,
              set = set2,
            },
            enableOverHeal = {
              order = 4,
              type = 'toggle',
              name = "显示溢出治疗",
              desc = "显示治疗溢出值. 关闭不显示防止少量的治疗刷屏",
              get = get2,
              set = set2,
            },
            enableSelfAbsorbs = {
              order = 5,
              type = 'toggle',
              name = "显示吸收",
              desc = "显示受到的治疗吸收",
              get = get2,
              set = set2,
            },
            showOnlyMyHeals = {
              order = 6,
              type = 'toggle',
              name = "只显示自己的治疗",
              desc = "Shows only the player's healing done to himself or herself.",
              get = get2,
              set = set2,
            },
            showOnlyPetHeals = {
              order = 7,
              type = 'toggle',
              name = "显示宠物的治疗",
              desc = "Will also attempt to show the player pet's healing.",
              get = get2,
              set = set2,
              disabled = function() return not x.db.profile.frames.healing.showOnlyMyHeals end
            },
          },
        },
      },
    },

    class = {
      name = "|cffFFFFFF职业连击点|r",
      type = 'group',
      order = 16,
      childGroups = 'tab',
      args = {
        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'description',
              order = 2,
              name = "\n|cffFF0000Secondary Frame Not Available|r - |cffFFFFFFThis frame cannot output to another frame when it is disabled.\n\n",
              width = "double",
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            --[[frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },]]
          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

      },
    },

    power = {
      name = "|cffFFFFFF职业能量|r",
      type = 'group',
      order = 17,
      childGroups = 'tab',
      args = {

        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                [1] = "综合",
                [2] = "伤害输出",
                [3] = "伤害输出(爆击)",
                [4] = "承受伤害",
                [5] = "受到治疗",
                --[6] = "职业能量",
                [7] = "特殊效果(特效)",
                [8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            megaDamage = {
              order = 5,
              type = 'toggle',
              name = "数字格式化",
              desc = "Enables number formatting. This option can be customized in the main |cff00FF00Frames|r options page to be either |cff798BDDAbbreviation|r or |cff798BDDDecimal Marks|r. ",
              get = get2,
              set = set2,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 20,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 21,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 22,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 23,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 24,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },

          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

        specialTweaks = {
          order = 40,
          name = "特殊调整",
          type = 'group',
          args = {
            specialTweaks = {
              type = 'description',
              order = 0,
              name = "|cff798BDD特殊调整|r:",
              fontSize = 'large',
            },
            showEnergyGains = {
              order = 1,
              type = 'toggle',
              name = "显示能量获取",
              desc = "显示瞬间能量收益",
              get = get2,
              set = set2,
            },
            showPeriodicEnergyGains = {
              order = 2,
              type = 'toggle',
              name = "显示周期性的能量收益",
              desc = "显示获得的能量随着时间的推移",
              get = get2,
              set = set2,
            },
            showEnergyType = {
              order = 3,
              type = 'toggle',
              name = "显示能量类型",
              desc = "显示你获取的能量类型",
              get = get2,
              set = set2,
            },

            title1 = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD资源过滤|r:",
              fontSize = 'large',
            },
            title2 = {
              type = 'description',
              order = 11,
              name = "选择你不想显示的角色能量类型:",
              fontSize = 'small',
            },

            disableResource_MANA = {
              order = 20,
              type = 'toggle',
              name = "禁用 |cff798BDD"..MANA,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_RAGE = {
              order = 21,
              type = 'toggle',
              name = "禁用 |cff798BDD"..RAGE,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_FOCUS = {
              order = 22,
              type = 'toggle',
              name = "禁用 |cff798BDD"..FOCUS,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_ENERGY = {
              order = 23,
              type = 'toggle',
              name = "禁用 |cff798BDD"..ENERGY,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_CHI = {
              order = 24,
              type = 'toggle',
              name = "禁用 |cff798BDD"..CHI,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_RUNES = {
              order = 25,
              type = 'toggle',
              name = "禁用 |cff798BDD"..RUNES,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_RUNIC_POWER = {
              order = 26,
              type = 'toggle',
              name = "禁用 |cff798BDD"..RUNIC_POWER,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_SOUL_SHARDS = {
              order = 27,
              type = 'toggle',
              name = "禁用 |cff798BDD"..SOUL_SHARDS,
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_ECLIPSE_negative = {
              order = 28,
              type = 'toggle',
              name = "禁用 |cff798BDD"..ECLIPSE.."|r (Negative)",
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_ECLIPSE_positive = {
              order = 28,
              type = 'toggle',
              name = "禁用 |cff798BDD"..ECLIPSE.."|r (Positive)",
              get = get2,
              set = set2,
              width = "full",
            },
            disableResource_HOLY_POWER = {
              order = 29,
              type = 'toggle',
              name = "禁用 |cff798BDD"..HOLY_POWER,
              get = get2,
              set = set2,
              width = "full",
            },

          },
        },
      },
    },

    procs = {
      name = "|cffFFFFFF特殊效果|r |cff798BDD(特效)|r",
      type = 'group',
      order = 18,
      childGroups = 'tab',
      args = {

        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2_update,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                [1] = "综合",
                [2] = "伤害输出",
                [3] = "伤害输出(爆击)",
                [4] = "承受伤害",
                [5] = "受到治疗",
                [6] = "职业能量",
                --[7] = "特殊效果(特效)",
                [8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 20,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 21,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 22,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 23,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 24,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },

            iconSizeSettings = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD图标尺寸设置|r:",
              fontSize = 'large',
            },
            iconsEnabled = {
              order = 11,
              type = 'toggle',
              name = "图标",
              desc = "显示伤害图标",
              get = get2,
              set = set2,
              disabled = isFrameItemDisabled,
            },
            iconsSize = {
              order = 12,
              name = "图标尺寸",
              desc = "设置图标尺寸",
              type = 'range',
              min = 6, max = 22, step = 1,
              get = get2,
              set = set2,
              disabled = isFrameIconDisabled,
            },
          },
        },

        fontColors = {
          order = 30,
          type = 'group',
          name = "定义颜色",
          args = {
            customColors = {
              type = 'description',
              order = 0,
              name = "|cff798BDD定义颜色|r:\n",
              fontSize = 'large',
            },
          },
        },

      },
    },

    loot = {
      name = "|cffFFFFFF拾取,货币和金钱|r",
      type = 'group',
      order = 19,
      childGroups = 'tab',
      args = {

        frameSettings = {
          order = 10,
          type = 'group',
          name = "窗口设置",
          args = {
            frameSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD窗口设置|r:",
              fontSize = 'large',
            },
            enabledFrame = {
              order = 1,
              type = 'toggle',
              name = "启用",
              width = 'half',
              get = get2,
              set = set2,
            },
            secondaryFrame = {
              type = 'select',
              order = 2,
              name = "第二窗口",
              desc = "在当前窗口被禁用时,这个窗口用来转发信息",
              values = {
                [0] = "无",
                [1] = "综合",
                [2] = "伤害输出",
                [3] = "伤害输出(爆击)",
                [4] = "承受伤害",
                [5] = "受到治疗",
                [6] = "职业能量",
                [7] = "特殊效果(特效)",
                --[8] = "拾取,货币和金钱",
              },
              get = get2,
              set = set2,
              disabled = isFrameItemEnabled,
            },
            insertText = {
              type = 'select',
              order = 3,
              name = "文字方向",
              desc = "改变窗口中文字的增长方向",
              values = {
                ["top"] = "下",
                ["bottom"] = "上",
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            alpha = {
              order = 4,
              name = "窗口透明度",
              desc = "设置窗口的透明度.",
              type = 'range',
              min = 0, max = 100, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameScrolling = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD滚动窗口设置|r:",
              fontSize = 'large',
            },
            enableScrollable = {
              order = 11,
              type = 'toggle',
              name = "启用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            scrollableLines = {
              order = 12,
              name = "行数",
              type = 'range',
              min = 10, max = 60, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameNotScrollable,
            },
            scrollableInCombat = {
              order = 13,
              type = 'toggle',
              name = "战斗禁用",
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },

            frameFading = {
              type = 'description',
              order = 30,
              name = "\n|cff798BDD文字淡出设置|r:",
              fontSize = 'large',
            },
            enableCustomFade = {
              order = 31,
              type = 'toggle',
              name = "使用自定义淡出",
              width = 'full',
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            enableFade = {
              order = 32,
              type = 'toggle',
              name = "启用",
              desc = "关闭以禁用淡出.\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              width = 'half',
              get = get2,
              set = set2_update,
              disabled = isFrameUseCustomFade,
            },
            fadeTime = {
              order = 33,
              name = "淡出持续时间",
              desc = "淡出动画的持续时间. |cffFFFF00(默认: |cff798BDD0.3|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 0, max = 2, step = .1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },
            visibilityTime = {
              order = 34,
              name = "可见持续时间",
              desc = "窗口中文本能看见的持续时间. |cffFFFF00(默认: |cff798BDD5|r)|r\n\n|cffFF0000需求:|r |cffFFFF00使用自定义淡出|r",
              type = 'range',
              min = 2, max = 15, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameFadingDisabled,
            },

          },
        },

        fonts = {
          order = 20,
          type = 'group',
          name = "字体设置",
          args = {
            fontSettings = {
              type = 'description',
              order = 0,
              name = "|cff798BDD字体设置|r:",
              fontSize = 'large',
            },
            font = {
              type = 'select', dialogControl = 'LSM30_Font',
              order = 1,
              name = "字体",
              desc = "设置窗口字体",
              values = AceGUIWidgetLSMlists.font,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontSize = {
              order = 2,
              name = "字体大小",
              desc = "设置窗口字体大小",
              type = 'range',
              min = 6, max = 64, step = 1,
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontOutline = {
              type = 'select',
              order = 3,
              name = "字体描边",
              desc = "设置字体描边",
              values = {
                ['1NONE'] = "None",
                ['2OUTLINE'] = 'OUTLINE',
                -- BUG: Setting font to monochrome AND above size 16 will crash WoW
                -- http://us.battle.net/wow/en/forum/topic/6470967362
                ['3MONOCHROME'] = 'MONOCHROME',
                ['4MONOCHROMEOUTLINE'] = 'MONOCHROMEOUTLINE',
                ['5THICKOUTLINE'] = 'THICKOUTLINE',
              },
              get = get2,
              set = set2_update,
              disabled = isFrameItemDisabled,
            },
            fontJustify = {
              type = 'select',
              order = 4,
              name = "对齐",
              desc = "输出对齐边",
              values = {
                ['RIGHT']  = "居右",
                ['LEFT']   = "居左",
                ['CENTER'] = "居中",
              },
              get = get2,
              set = set2_update,
            },

            iconSizeSettings = {
              type = 'description',
              order = 10,
              name = "\n|cff798BDD图标尺寸设置|r:",
              fontSize = 'large',
            },
            iconsEnabled = {
              order = 11,
              type = 'toggle',
              name = "图标",
              desc = "显示伤害图标",
              get = get2,
              set = set2,
              disabled = isFrameItemDisabled,
            },
            iconsSize = {
              order = 12,
              name = "图标尺寸",
              desc = "设置图标尺寸",
              type = 'range',
              min = 6, max = 22, step = 1,
              get = get2,
              set = set2,
              disabled = isFrameIconDisabled,
            },
          },
        },

        specialTweaks = {
          order = 40,
          type = 'group',
          name = "特殊调整",
          args = {
            specialTweaks = {
              type = 'description',
              order = 0,
              name = "|cff798BDD特殊调整|r:",
              fontSize = 'large',
            },
            showMoney = {
              order = 1,
              type = 'toggle',
              name = "捡到的钱",
              desc = "显示你捡到的钱",
              get = get2,
              set = set2,
            },
            showItems = {
              order = 2,
              type = 'toggle',
              name = "拾取的物品",
              desc = "显示你拾取到的物品",
              get = get2,
              set = set2,
            },
            showCurrency = {
              order = 3,
              type = 'toggle',
              name = "获取货币",
              desc = "显示你获取的货币",
              get = get2,
              set = set2,
            },
            showItemTypes = {
              order = 4,
              type = 'toggle',
              name = "显示物品类型",
              desc = "格式化拾取信息包括物品的类型(如商品,护甲,垃圾等).",
              get = get2,
              set = set2,
            },
            showItemTotal = {
              order = 5,
              type = 'toggle',
              name = "物品总量",
              desc = "显示你背包中物品的总量",
              get = get2,
              set = set2,
            },
            showCrafted = {
              order = 6,
              type = 'toggle',
              name = "制造物品",
              desc = "显示制造的物品",
              get = get2,
              set = set2,
            },
            showQuest = {
              order = 7,
              type = 'toggle',
              name = "任务物品",
              desc = "显示关联到一个任务的物品",
              get = get2,
              set = set2,
            },
            colorBlindMoney = {
              order = 8,
              type = 'toggle',
              name = "彩色绑定模式",
              desc = "显示金钱使用字母G,S,C来取代图标.",
              get = get2,
              set = set2,
            },
            filterItemQuality = {
              order = 9,
              type = 'select',
              name = "过滤物品品质",
              desc = "当显示物品时按品质过滤(不过滤任务和制造物品).",
              values = {
                [0] = '1. |cff9d9d9d'..ITEM_QUALITY0_DESC..'|r',   -- Poor
                [1] = '2. |cffffffff'..ITEM_QUALITY1_DESC..'|r',   -- Common
                [2] = '3. |cff1eff00'..ITEM_QUALITY2_DESC..'|r',   -- Uncommon
                [3] = '4. |cff0070dd'..ITEM_QUALITY3_DESC..'|r',   -- Rare
                [4] = '5. |cffa335ee'..ITEM_QUALITY4_DESC..'|r',   -- Epic
                [5] = '6. |cffff8000'..ITEM_QUALITY5_DESC..'|r',   -- Legendary
                [6] = '7. |cffe6cc80'..ITEM_QUALITY6_DESC..'|r',   -- Artifact
                [7] = '8. |cffe6cc80'..ITEM_QUALITY7_DESC..'|r',   -- Heirloom
              },
              get = get2,
              set = set2,
            },
          },
        },

      },
    },
  },
}
