--
--	Grail Reputations
--	Written by scott@mithrandir.com
--
--	Version History
--		001	Initial version
--		002	Converted to be a load-on-demand addon.
--		003 Converted codes to be more MoP-friendly.
--		004	Removed the version check because live has MoP data.
--		005 Changes the technique of how reputation data is stored, which reduces memory by over 0.6 MB.
--			Basically each reputation change is converted to a four-character code (representing a bitmap)
--			that is stored in a separate table whose index is the questId.  For quests that change more
--			than one reputation the four-character codes are appended, so no more tons of little tables.
--		006	Interface 50300
--		007	Switches to not relying on Grail.quests any more.
--
--	Known Issues
--
--	UTF-8 file
--

local pairs, strsub, tonumber = pairs, strsub, tonumber
local GetBuildInfo = GetBuildInfo
local COMBAT_TEXT_SHOW_REPUTATION_TEXT = COMBAT_TEXT_SHOW_REPUTATION_TEXT

local Grail_Reputations_File_Version = 007

if Grail.reputationsVersionNumber < Grail_Reputations_File_Version then
	Grail.reputationsVersionNumber = Grail_Reputations_File_Version

local _, release, _, interface = GetBuildInfo()
release = tonumber(release)
interface = tonumber(interface)

local G = Grail.questReputations

if release >= 0 then
G[2]={'43D250'}
G[11]={'048250'}
G[23]={'43D250'}
G[24]={'43D250'}
G[25]={'43D250','41C125','42862','42B62','46462'}
G[35]={'048250'}
G[37]={'04825'}
G[40]={'04810'}
G[45]={'04875'}
G[46]={'048250'}
G[47]={'048250'}
G[52]={'048150'}
G[54]={'04875'}
G[59]={'04825'}
G[60]={'048250'}
G[62]={'048250'}
G[71]={'04825'}
G[76]={'048250'}
G[83]={'048250'}
G[84]={'04825'}
G[85]={'04825'}
G[86]={'048350'}
G[87]={'048250'}
G[88]={'048250'}
G[106]={'04825'}
G[107]={'04825'}
G[111]={'04825'}
G[112]={'048250'}
G[114]={'048250'}
G[123]={'048250'}
G[147]={'048250'}
G[172]={'04310'}
G[176]={'048350'}
G[182]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[184]={'048250'}
G[216]={'04C250'}
G[218]={'02F350','1D587','03687','04587','04887','3A287','46E87'}
G[239]={'04825'}
G[309]={'02F250'}
G[313]={'02F250','036250'}
G[314]={'02F250','036250'}
G[315]={'02F250','036250'}
G[332]={'048150'}
G[333]={'04875'}
G[334]={'048150'}
G[351]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[353]={'02F250'}
G[384]={'02F250','036250'}
G[412]={'036250','02F250'}
G[432]={'02F250','036250'}
G[433]={'02F250','036250'}
G[475]={'04575'}
G[476]={'045250'}
G[483]={'045250'}
G[485]={'015250','057-250'}
G[486]={'045350'}
G[487]={'045250'}
G[489]={'045500'}
G[543]={'048500'}
G[648]={'015350','057-350'}
G[743]={'051250'}
G[744]={'051250'}
G[749]={'051150'}
G[751]={'051150'}
G[761]={'051350'}
G[768]={'051350','04387','04487','04C87','21287','38F87','46D87'}
G[769]={'05175','04318','04418','04C18','21218','38F18','46D18'}
G[770]={'051250'}
G[773]={'051250'}
G[822]={'04C75','04318','04418','05118','21218','38F18','46D18'}
G[824]={'212250'}
G[833]={'051150'}
G[834]={'04C250','212250','1D6250'}
G[835]={'04C250','212250','1D6250'}
G[836]={'015350','057-350'}
G[840]={'04C75','21275'}
G[844]={'04C250'}
G[845]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[848]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[850]={'04C150'}
G[851]={'04C150'}
G[852]={'04C150'}
G[855]={'04C250'}
G[858]={'1D6250','171125','241125','015125'}
G[861]={'051250'}
G[863]={'1D6350','171175','241175','015175'}
G[865]={'1D6250','171125','241125','015125'}
G[866]={'1D6250'}
G[867]={'04C250'}
G[870]={'051150','04337','04437','04C37','21237','38F37','46D37'}
G[871]={'04C250'}
G[872]={'04C250'}
G[875]={'04C250'}
G[876]={'04C350'}
G[877]={'051250'}
G[880]={'051250'}
G[881]={'04C350'}
G[887]={'1D6150','17175','24175','01575'}
G[891]={'1D6250','171125','241125','015125','04375'}
G[895]={'1D6250','171125','241125','015125'}
G[899]={'04C250'}
G[903]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[905]={'04C250'}
G[918]={'045250'}
G[919]={'045350'}
G[922]={'04575'}
G[923]={'045350'}
G[927]={'04575'}
G[929]={'045250'}
G[930]={'045250'}
G[931]={'045250'}
G[932]={'045250'}
G[933]={'045250'}
G[935]={'045350'}
G[937]={'04575'}
G[938]={'045250'}
G[941]={'045250'}
G[997]={'04575'}
G[1036]={'05725','015-25'}
G[1201]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[1202]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[1204]={'048250'}
G[1205]={'051250'}
G[1222]={'048250'}
G[1258]={'048250'}
G[1270]={'1D6250'}
G[1431]={'04C25'}
G[1432]={'04C75'}
G[1434]={'044250'}
G[1436]={'04C250'}
G[1453]={'02F75'}
G[1454]={'02F250'}
G[1455]={'02F75'}
G[1456]={'02F250'}
G[1578]={'02F250'}
G[1581]={'045250'}
G[1582]={'045250'}
G[1618]={'048250'}
G[1918]={'04C25'}
G[2039]={'03625'}
G[2158]={'04825'}
G[2159]={'04525'}
G[2383]={'04C75'}
G[2399]={'04510'}
G[2438]={'045150'}
G[2459]={'045350'}
G[2499]={'045250'}
G[2518]={'045350'}
G[2541]={'045250'}
G[2561]={'045350'}
G[2948]={'02F250','036250'}
G[2950]={'04C250'}
G[3087]={'04C75'}
G[3088]={'04C75'}
G[3089]={'04C75'}
G[3090]={'04C75'}
G[3091]={'05175'}
G[3092]={'05175'}
G[3093]={'05175'}
G[3094]={'05175'}
G[3095]={'04475'}
G[3096]={'04475'}
G[3097]={'04475'}
G[3098]={'04475'}
G[3099]={'04475'}
G[3100]={'04875'}
G[3101]={'04875'}
G[3102]={'04875'}
G[3103]={'04875'}
G[3104]={'04875'}
G[3105]={'04875'}
G[3106]={'02F75'}
G[3107]={'02F75'}
G[3108]={'02F75'}
G[3109]={'02F75','1D518','03618','04518','04818','3A218','46E18'}
G[3110]={'02F75'}
G[3115]={'02F75'}
G[3116]={'04575'}
G[3117]={'04575'}
G[3118]={'04575'}
G[3119]={'04575'}
G[3120]={'04575'}
G[3361]={'02F250','036250','1D562','03662','04562','04862','3A262','46E62','02F62'}
G[3721]={'015500','057-500'}
G[4021]={'04C350'}
G[4512]={'036350'}
G[4513]={'036350'}
G[4621]={'057500','015-500'}
G[5041]={'04C250'}
G[5501]={'1D6150'}
G[5561]={'1D6150'}
G[5581]={'051350'}
G[5713]={'045250'}
G[5821]={'1D6250'}
G[5892]={'02F25'}
G[5893]={'04C25'}
G[5943]={'1D6250','171125','241125','015125'}
G[6031]={'2401000'}
G[6032]={'2401000'}
G[6142]={'212250'}
G[6143]={'212250'}
G[6321]={'04425'}
G[6322]={'04425'}
G[6323]={'04475'}
G[6324]={'044350'}
G[6341]={'04525'}
G[6342]={'04575'}
G[6343]={'045350'}
G[6344]={'04525'}
G[6361]={'05125'}
G[6362]={'05175'}
G[6363]={'05125'}
G[6364]={'051350'}
G[6365]={'04C25','21225'}
G[6384]={'04C75','21275'}
G[6385]={'04C25','21225'}
G[6386]={'04C350','212350'}
G[6387]={'02F25','03625'}
G[6388]={'02F25','03625'}
G[6391]={'02F75','03675'}
G[6392]={'02F350','036350'}
G[6441]={'1D6250','171125','241125','015125'}
G[6442]={'212250'}
G[6462]={'212250'}
G[6482]={'051350'}
G[6503]={'212250'}
G[6544]={'04C350'}
G[6563]={'212250'}
G[6642]={'03B75'}
G[6643]={'03B500'}
G[6644]={'03B500'}
G[6645]={'03B350'}
G[6646]={'03B500'}
G[6741]={'04C10'}
G[6781]={'02F10'}
G[6801]={'04C10'}
G[6825]={'04C10'}
G[6826]={'04C10'}
G[6827]={'04C10'}
G[6881]={'02F10'}
G[6922]={'212500'}
G[6941]={'02F10'}
G[6942]={'02F10'}
G[6943]={'02F10'}
G[6982]={'02F25'}
G[6985]={'04C25'}
G[7001]={'04C10'}
G[7025]={'0A925','01525','17125','1D625','24125'}
G[7027]={'02F10'}
G[7045]={'0A9250','015250','171250','1D6250','241250'}
G[7061]={'051500'}
G[7063]={'02F500','1D5125','036125','045125','048125','3A2125','46E125','549125'}
G[7081]={'2DA250','02F250'}
G[7082]={'2D9250','04C250'}
G[7101]={'2D9250','04C250'}
G[7102]={'2DA250','02F250'}
G[7121]={'2DA10','02F10'}
G[7122]={'2DA250','02F250'}
G[7123]={'2D910','04C10'}
G[7124]={'2D9250','04C250'}
G[7141]={'2DA500','02F500'}
G[7142]={'2D9500','04C500'}
G[7161]={'2D9250','04C250'}
G[7162]={'2DA250','02F250'}
G[7163]={'2D9250','04C250'}
G[7164]={'2D9250','04C250'}
G[7165]={'2D9350','04C350'}
G[7166]={'2D9500','04C500'}
G[7167]={'2D9500','04C500'}
G[7168]={'2DA250','02F250'}
G[7169]={'2DA250','02F250'}
G[7170]={'2DA350','02F350'}
G[7171]={'2DA500','02F500'}
G[7172]={'02F500','2DA500'}
G[7223]={'2DA250','02F250'}
G[7224]={'2D9250','04C250'}
G[7383]={'045150'}
G[7385]={'04C75'}
G[7386]={'02F75'}
G[7498]={'329500'}
G[7499]={'329500'}
G[7500]={'329500'}
G[7501]={'329500'}
G[7502]={'329500'}
G[7503]={'329500'}
G[7504]={'329500'}
G[7505]={'329500'}
G[7506]={'329500'}
G[7604]={'03B1000'}
G[7649]={'329500'}
G[7650]={'329500'}
G[7651]={'329500'}
G[7737]={'03B625'}
G[7781]={'048500','02F500','045500','036500','3A2500'}
G[7782]={'048500','02F500','045500','036500','3A2500'}
G[7783]={'04C500','212500','051500','044500','38F500'}
G[7784]={'04C500','212500','051500','044500','38F500'}
G[7863]={'37A10'}
G[7865]={'37A10'}
G[7866]={'37910'}
G[7868]={'37910'}
G[7905]={'38D75'}
G[7907]={'38D350'}
G[7926]={'38D75'}
G[7927]={'38D350'}
G[7928]={'38D350'}
G[7929]={'38D350'}
G[8041]={'10E250'}
G[8042]={'10E250'}
G[8043]={'10E250'}
G[8044]={'10E250'}
G[8045]={'10E250'}
G[8046]={'10E250'}
G[8047]={'10E250'}
G[8048]={'10E250'}
G[8049]={'10E250'}
G[8050]={'10E250'}
G[8051]={'10E250'}
G[8052]={'10E250'}
G[8053]={'10E350'}
G[8054]={'10E350'}
G[8055]={'10E350'}
G[8056]={'10E350'}
G[8057]={'10E350'}
G[8058]={'10E350'}
G[8059]={'10E350'}
G[8060]={'10E350'}
G[8061]={'10E350'}
G[8062]={'10E350'}
G[8064]={'10E350'}
G[8065]={'10E350'}
G[8066]={'10E350'}
G[8067]={'10E350'}
G[8068]={'10E350'}
G[8069]={'10E350'}
G[8070]={'10E350'}
G[8071]={'10E350'}
G[8073]={'10E350'}
G[8074]={'10E350'}
G[8075]={'10E350'}
G[8076]={'10E350'}
G[8077]={'10E350'}
G[8078]={'10E350'}
G[8079]={'10E350'}
G[8101]={'10E250'}
G[8102]={'10E250'}
G[8103]={'10E250'}
G[8104]={'10E250'}
G[8105]={'1FD500'}
G[8106]={'10E250'}
G[8107]={'10E250'}
G[8108]={'10E250'}
G[8109]={'10E250'}
G[8110]={'10E250'}
G[8111]={'10E250'}
G[8112]={'10E250'}
G[8113]={'10E250'}
G[8114]={'1FD1000'}
G[8115]={'1FD500'}
G[8116]={'10E250'}
G[8117]={'10E250'}
G[8118]={'10E250'}
G[8119]={'10E250'}
G[8120]={'1FE500'}
G[8121]={'1FE1000'}
G[8122]={'1FE500'}
G[8141]={'10E250'}
G[8142]={'10E250'}
G[8143]={'10E250'}
G[8144]={'10E250'}
G[8145]={'10E250'}
G[8146]={'10E250'}
G[8147]={'10E250'}
G[8148]={'10E250'}
G[8149]={'1D5500','02F500','036500','045500','048500','3A2500','46E500'}
G[8166]={'1FD500'}
G[8167]={'1FD500'}
G[8168]={'1FD500'}
G[8169]={'1FE500'}
G[8170]={'1FE500'}
G[8171]={'1FE500'}
G[8183]={'10E500'}
G[8184]={'10E250'}
G[8185]={'10E250'}
G[8186]={'10E250'}
G[8187]={'10E250'}
G[8188]={'10E250'}
G[8189]={'10E250'}
G[8190]={'10E250'}
G[8191]={'10E250'}
G[8192]={'10E250'}
G[8195]={'10E25'}
G[8201]={'10E500'}
G[8238]={'10E25'}
G[8239]={'10E25'}
G[8240]={'10E350'}
G[8249]={'15D75','046-75'}
G[8262]={'1FD10'}
G[8265]={'1FE10'}
G[8271]={'2DA10','02F10'}
G[8272]={'2D910','04C10'}
G[8277]={'261150'}
G[8278]={'261250'}
G[8279]={'261250'}
G[8280]={'261150'}
G[8281]={'261250'}
G[8282]={'261250'}
G[8283]={'261250'}
G[8284]={'261250'}
G[8285]={'26175'}
G[8287]={'261250'}
G[8304]={'261250'}
G[8306]={'261350'}
G[8307]={'26110'}
G[8308]={'261250'}
G[8309]={'261250'}
G[8310]={'261250'}
G[8313]={'26175'}
G[8314]={'261150'}
G[8316]={'261250'}
G[8317]={'26175'}
G[8318]={'261250'}
G[8319]={'261250'}
G[8320]={'261250'}
G[8321]={'261350'}
G[8325]={'38F250'}
G[8326]={'38F250'}
G[8327]={'38F10'}
G[8328]={'38F75'}
G[8329]={'38F25'}
G[8330]={'38F250'}
G[8334]={'38F250'}
G[8335]={'38F350'}
G[8336]={'38F250'}
G[8338]={'38F250'}
G[8345]={'38F250'}
G[8346]={'38F250','04362','04462','04C62','05162','21262','46D62'}
G[8347]={'38F10'}
G[8350]={'38F25'}
G[8376]={'261250'}
G[8377]={'261250'}
G[8378]={'261250'}
G[8379]={'261250'}
G[8380]={'261250'}
G[8381]={'261250'}
G[8382]={'261250'}
G[8446]={'261500'}
G[8447]={'261500'}
G[8463]={'38F250'}
G[8468]={'38F250'}
G[8470]={'2401400'}
G[8472]={'38F250'}
G[8473]={'38F250'}
G[8474]={'38F250'}
G[8475]={'38F250'}
G[8476]={'38F250'}
G[8477]={'38F250'}
G[8479]={'21275'}
G[8480]={'38F250'}
G[8481]={'240500'}
G[8482]={'38F250'}
G[8483]={'38F250'}
G[8486]={'38F250'}
G[8487]={'38F250'}
G[8488]={'38F250'}
G[8490]={'38F250'}
G[8491]={'38F250'}
G[8544]={'38E500'}
G[8556]={'261250'}
G[8557]={'261250'}
G[8558]={'261250'}
G[8559]={'38E500'}
G[8560]={'38E500'}
G[8561]={'38E500'}
G[8562]={'38E500'}
G[8563]={'38F75'}
G[8564]={'38F75'}
G[8579]={'38E500','261250'}
G[8592]={'38E500'}
G[8593]={'38E500'}
G[8594]={'38E500'}
G[8595]={'38E500','261250'}
G[8596]={'38E500'}
G[8602]={'38E500'}
G[8603]={'38E500'}
G[8619]={'1D575','04375'}
G[8621]={'38E500'}
G[8622]={'38E500'}
G[8623]={'38E500'}
G[8624]={'38E500'}
G[8625]={'38E500'}
G[8626]={'38E500'}
G[8627]={'38E500'}
G[8628]={'38E500'}
G[8629]={'38E500'}
G[8630]={'38E500'}
G[8631]={'38E500'}
G[8632]={'38E500'}
G[8633]={'38E500'}
G[8634]={'38E500'}
G[8635]={'1D575','04375'}
G[8636]={'1D575','04375'}
G[8637]={'38E500'}
G[8638]={'38E500'}
G[8639]={'38E500'}
G[8640]={'38E500'}
G[8641]={'38E500'}
G[8642]={'1D575','04375'}
G[8643]={'1D575','04375'}
G[8644]={'1D575','04375'}
G[8645]={'1D575','04375'}
G[8646]={'1D575','04375'}
G[8647]={'1D575','04375'}
G[8648]={'1D575','04375'}
G[8649]={'1D575','04375'}
G[8650]={'1D575','04375'}
G[8651]={'1D575','04375'}
G[8652]={'1D575','04375'}
G[8653]={'1D575','04375'}
G[8654]={'1D575','04375'}
G[8655]={'38E500'}
G[8656]={'38E500'}
G[8657]={'38E500'}
G[8658]={'38E500'}
G[8659]={'38E500'}
G[8660]={'38E500'}
G[8661]={'38E500'}
G[8662]={'38E500'}
G[8663]={'38E500'}
G[8664]={'38E500'}
G[8665]={'38E500'}
G[8666]={'38E500'}
G[8667]={'38E500'}
G[8668]={'38E500'}
G[8669]={'38E500'}
G[8670]={'1D575','04375'}
G[8671]={'1D575','04375'}
G[8672]={'1D575','04375'}
G[8673]={'1D575','04375'}
G[8674]={'1D575','04375'}
G[8675]={'1D575','04375'}
G[8676]={'1D575','04375'}
G[8677]={'1D575','04375'}
G[8678]={'1D575','04375'}
G[8679]={'1D575','04375'}
G[8680]={'1D575','04375'}
G[8681]={'1D575','04375'}
G[8682]={'1D575','04375'}
G[8683]={'1D575','04375'}
G[8684]={'1D575','04375'}
G[8685]={'1D575','04375'}
G[8686]={'1D575','04375'}
G[8688]={'1D575','04375'}
G[8689]={'261250'}
G[8690]={'261250'}
G[8691]={'261250'}
G[8692]={'261250'}
G[8693]={'261250'}
G[8694]={'261250'}
G[8695]={'261250'}
G[8696]={'261250'}
G[8697]={'261250'}
G[8698]={'261250'}
G[8699]={'261250'}
G[8700]={'261250'}
G[8701]={'261250'}
G[8702]={'261250'}
G[8703]={'261250'}
G[8704]={'261250'}
G[8705]={'261250'}
G[8706]={'261250'}
G[8707]={'261250'}
G[8708]={'261250'}
G[8709]={'261250'}
G[8710]={'261250'}
G[8711]={'261250'}
G[8712]={'261250'}
G[8713]={'1D575','04375'}
G[8714]={'1D575','04375'}
G[8715]={'1D575','04375'}
G[8716]={'1D575','04375'}
G[8717]={'1D575','04375'}
G[8718]={'1D575','04375'}
G[8719]={'1D575','04375'}
G[8720]={'1D575','04375'}
G[8721]={'1D575','04375'}
G[8722]={'1D575','04375'}
G[8723]={'1D575','04375'}
G[8724]={'1D575','04375'}
G[8725]={'1D575','04375'}
G[8726]={'1D575','04375'}
G[8727]={'1D575','04375'}
G[8747]={'38E250'}
G[8748]={'38E250'}
G[8749]={'38E250'}
G[8750]={'38E250'}
G[8751]={'38E250'}
G[8752]={'38E250'}
G[8753]={'38E250'}
G[8754]={'38E250'}
G[8755]={'38E250'}
G[8756]={'38E250'}
G[8757]={'38E250'}
G[8758]={'38E250'}
G[8759]={'38E250'}
G[8760]={'38E250'}
G[8761]={'38E250'}
G[8784]={'38E1000'}
G[8789]={'38E500'}
G[8790]={'38E500'}
G[8791]={'261500','38E500'}
G[8801]={'261500','38E500'}
G[8802]={'261500','38E1000'}
G[8860]={'048250'}
G[8861]={'051250'}
G[8866]={'1D575','04375'}
G[8867]={'26175'}
G[8868]={'261250'}
G[8870]={'26110'}
G[8871]={'26110'}
G[8872]={'26110'}
G[8873]={'26110'}
G[8874]={'26110'}
G[8875]={'26110'}
G[8884]={'38F250'}
G[8885]={'38F350'}
G[8886]={'38F250'}
G[8887]={'38F250'}
G[8888]={'38F10'}
G[8889]={'38F150'}
G[8890]={'38F250'}
G[8891]={'38F250'}
G[8892]={'38F250'}
G[8894]={'38F250'}
G[8895]={'38F25'}
G[9035]={'38F10'}
G[9062]={'38F75'}
G[9064]={'38F25'}
G[9066]={'38F250'}
G[9067]={'38F250'}
G[9076]={'38F250'}
G[9119]={'38F250'}
G[9130]={'38F25'}
G[9133]={'38F75'}
G[9134]={'38F25'}
G[9135]={'38F250'}
G[9138]={'39A1000'}
G[9139]={'39A1000'}
G[9140]={'39A3000'}
G[9143]={'38F250'}
G[9144]={'38F75'}
G[9147]={'39A1000'}
G[9148]={'39A250'}
G[9149]={'39A1000'}
G[9150]={'39A1000'}
G[9151]={'39A250'}
G[9152]={'39A1000'}
G[9155]={'39A1000'}
G[9156]={'39A3000'}
G[9157]={'39A1000'}
G[9158]={'38F250'}
G[9159]={'38F250'}
G[9160]={'39A1000'}
G[9161]={'38F250'}
G[9162]={'38F250'}
G[9163]={'39A1000'}
G[9164]={'39A3000'}
G[9166]={'39A250'}
G[9167]={'39A8000'}
G[9169]={'39A1000'}
G[9170]={'39A3000'}
G[9171]={'39A1000'}
G[9172]={'39A250'}
G[9173]={'39A1000'}
G[9174]={'39A1000','39A1000'}
G[9175]={'39A1000'}
G[9176]={'39A2000'}
G[9177]={'044250'}
G[9180]={'044250'}
G[9192]={'39A1000'}
G[9193]={'39A2000'}
G[9199]={'39A1000'}
G[9207]={'39A1000'}
G[9208]={'10E500'}
G[9209]={'10E500'}
G[9210]={'10E500'}
G[9212]={'38F250'}
G[9214]={'38F250'}
G[9215]={'38F350'}
G[9216]={'39A500'}
G[9217]={'39A500'}
G[9218]={'39A500'}
G[9219]={'39A500'}
G[9220]={'39A3000'}
G[9250]={'38E500','211500'}
G[9251]={'38E500','211500'}
G[9252]={'38F250'}
G[9253]={'38F25'}
G[9254]={'38F75'}
G[9255]={'38F75'}
G[9256]={'38F75'}
G[9257]={'38E500','211500'}
G[9258]={'38F25'}
G[9259]={'015500','057-500'}
G[9266]={'241500','057-500'}
G[9267]={'1D6500','057-500'}
G[9268]={'171500','057-500'}
G[9269]={'38E500','211500'}
G[9270]={'38E500','211500'}
G[9271]={'38E500','211500'}
G[9272]={'05710','015-250'}
G[9274]={'38F250'}
G[9275]={'39A1000'}
G[9276]={'38F250'}
G[9277]={'38F250'}
G[9279]={'3A275','1D518','02F18','03618','04518','04818','46E18','54918'}
G[9280]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9281]={'39A1000'}
G[9283]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[9287]={'3A275'}
G[9288]={'3A275'}
G[9289]={'3A275'}
G[9290]={'3A275'}
G[9291]={'3A275'}
G[9293]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9294]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9303]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[9305]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9309]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9311]={'3A2500','1D5125','02F125','036125','045125','048125','46E125','549125'}
G[9312]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9313]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[9314]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9315]={'39A1000'}
G[9327]={'39A250'}
G[9328]={'38F75'}
G[9329]={'39A250'}
G[9340]={'38F250'}
G[9345]={'3B3250'}
G[9352]={'38F250'}
G[9355]={'3B2250'}
G[9358]={'38F10'}
G[9360]={'38F250'}
G[9363]={'38F250'}
G[9366]={'38F250'}
G[9369]={'3A2250'}
G[9370]={'38F250'}
G[9371]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9372]={'3AE250'}
G[9373]={'3AE250'}
G[9374]={'38F250'}
G[9375]={'38F250'}
G[9376]={'38F250'}
G[9381]={'38F250'}
G[9383]={'3A2250'}
G[9385]={'3B2250'}
G[9387]={'38F250'}
G[9390]={'3A225'}
G[9391]={'38F250'}
G[9392]={'38F75'}
G[9393]={'38F75'}
G[9394]={'38F10'}
G[9395]={'38F10'}
G[9396]={'38F250'}
G[9397]={'38F250'}
G[9398]={'3A2250'}
G[9399]={'3A2250'}
G[9400]={'3B3250'}
G[9401]={'3B3250'}
G[9405]={'3B375'}
G[9406]={'3B3250','3AD250'}
G[9407]={'3B3250'}
G[9409]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9410]={'3AD350'}
G[9417]={'3B2250'}
G[9419]={'261250'}
G[9420]={'3B2250'}
G[9421]={'3A275'}
G[9422]={'261250'}
G[9423]={'3A225'}
G[9426]={'3A2250'}
G[9427]={'3A2250'}
G[9430]={'3A2250'}
G[9436]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9437]={'38F250'}
G[9442]={'3AD250'}
G[9447]={'3AD250'}
G[9452]={'3A2250'}
G[9453]={'3A210'}
G[9454]={'3A2150'}
G[9455]={'3A2150'}
G[9456]={'3A2250'}
G[9457]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9463]={'3A2250'}
G[9466]={'38F350'}
G[9472]={'38F350'}
G[9473]={'3A2250'}
G[9490]={'3A2350'}
G[9505]={'3A2150'}
G[9506]={'3A2250','04875'}
G[9512]={'048150','3A2150'}
G[9513]={'045250','3A2150'}
G[9514]={'04510','3A210'}
G[9515]={'045500','3A2250'}
G[9523]={'02F250','3A2150'}
G[9527]={'045250','3A2150'}
G[9528]={'045250','3A2150'}
G[9530]={'048250','3A2150'}
G[9531]={'048500','3A2250'}
G[9537]={'3A2500'}
G[9543]={'3A210'}
G[9544]={'3A2500'}
G[9545]={'3A2350'}
G[9548]={'036250'}
G[9549]={'036250'}
G[9550]={'045250'}
G[9557]={'3A2250'}
G[9559]={'3A225'}
G[9561]={'045250'}
G[9563]={'3B2250'}
G[9567]={'3A2250'}
G[9569]={'3A2250'}
G[9574]={'3A2250'}
G[9576]={'3A2250'}
G[9578]={'3A2250'}
G[9579]={'3A2250'}
G[9580]={'3A2250'}
G[9581]={'3A2250'}
G[9582]={'3A2250'}
G[9584]={'3A2250'}
G[9585]={'3A2250'}
G[9594]={'3A2250'}
G[9602]={'3A2250'}
G[9603]={'3A275'}
G[9604]={'3A275'}
G[9605]={'3A275'}
G[9606]={'3A2250'}
G[9612]={'3A2350'}
G[9616]={'3A2250'}
G[9620]={'3A2150'}
G[9621]={'04475'}
G[9622]={'3A2250'}
G[9623]={'3A210'}
G[9624]={'3A2250'}
G[9625]={'3A225'}
G[9626]={'04C250'}
G[9627]={'38F500'}
G[9628]={'3A2250'}
G[9629]={'3A2250'}
G[9630]={'3C7250'}
G[9631]={'3C775'}
G[9632]={'04575'}
G[9634]={'3A2250'}
G[9637]={'3C7250'}
G[9638]={'3C710'}
G[9639]={'3C710'}
G[9640]={'3C7250'}
G[9641]={'3A2250'}
G[9643]={'3A2250'}
G[9644]={'3C73000'}
G[9645]={'3C7250'}
G[9646]={'3A2250'}
G[9647]={'3A2250'}
G[9648]={'3A2250'}
G[9649]={'3A2250'}
G[9663]={'3A2250'}
G[9666]={'3A2250'}
G[9667]={'3A2250'}
G[9668]={'3A210'}
G[9669]={'3A2250'}
G[9670]={'3A2250'}
G[9672]={'04825'}
G[9674]={'048250'}
G[9676]={'38F75'}
G[9680]={'3C7250'}
G[9682]={'048250'}
G[9683]={'048250'}
G[9687]={'045250'}
G[9688]={'045250'}
G[9689]={'045500'}
G[9693]={'3A210'}
G[9694]={'3A2250'}
G[9696]={'3A210'}
G[9697]={'3AE75'}
G[9698]={'3A2250'}
G[9699]={'3A225'}
G[9700]={'3A2250'}
G[9701]={'3AE250'}
G[9702]={'3AE250'}
G[9703]={'3A2250'}
G[9704]={'38F25'}
G[9705]={'38F75'}
G[9706]={'3A2150'}
G[9708]={'3AE250'}
G[9709]={'3AE350'}
G[9711]={'3A2250'}
G[9716]={'3AE250'}
G[9718]={'3AE150'}
G[9720]={'3AE350'}
G[9724]={'3AE75'}
G[9726]={'3CA250'}
G[9727]={'3CA250'}
G[9728]={'3AE350'}
G[9729]={'3CA350'}
G[9730]={'3AE350'}
G[9731]={'3AE250'}
G[9732]={'3AE250'}
G[9739]={'3CA250'}
G[9740]={'3A2250'}
G[9741]={'3A2150'}
G[9742]={'3CA250'}
G[9743]={'3CA250'}
G[9744]={'3CA250'}
G[9746]={'3A2250'}
G[9747]={'3AE250'}
G[9748]={'3A2250'}
G[9751]={'04825'}
G[9752]={'3AE250'}
G[9753]={'3A210'}
G[9756]={'3A2150'}
G[9758]={'39A250'}
G[9759]={'3A2500'}
G[9760]={'3A225'}
G[9761]={'3A2350'}
G[9762]={'3A2500'}
G[9769]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[9770]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[9771]={'212250'}
G[9772]={'212250'}
G[9773]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[9774]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[9777]={'3A2250'}
G[9779]={'3A2250'}
G[9780]={'3A2250'}
G[9781]={'3A2250'}
G[9782]={'3A2250'}
G[9783]={'3A2250'}
G[9784]={'3AE250'}
G[9785]={'3AE75'}
G[9786]={'3A2250'}
G[9787]={'3A2250'}
G[9788]={'3AE250'}
G[9790]={'3A2250'}
G[9791]={'3A2250'}
G[9798]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9799]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9801]={'3A2250'}
G[9802]={'3AE250'}
G[9803]={'3A2250'}
G[9806]={'3CA250'}
G[9807]={'3CA250'}
G[9808]={'3CA250'}
G[9809]={'3CA250'}
G[9811]={'38F75'}
G[9812]={'04475'}
G[9813]={'04C250'}
G[9814]={'212250'}
G[9816]={'212250'}
G[9817]={'3AE350'}
G[9822]={'212250'}
G[9823]={'212250'}
G[9824]={'3C7250'}
G[9825]={'3C7250'}
G[9826]={'3C775'}
G[9827]={'3A2250'}
G[9828]={'212250'}
G[9829]={'3C775'}
G[9830]={'3D2250'}
G[9831]={'3C7250'}
G[9832]={'3C7350'}
G[9833]={'3D2250'}
G[9834]={'3D2250'}
G[9835]={'3D2250'}
G[9836]={'3C7350'}
G[9837]={'3C7500'}
G[9838]={'3C775'}
G[9839]={'3D2250'}
G[9840]={'3C7250'}
G[9841]={'212250'}
G[9842]={'212250'}
G[9843]={'3C7250'}
G[9844]={'3C7250'}
G[9845]={'212250'}
G[9846]={'212250'}
G[9847]={'212250'}
G[9848]={'048250'}
G[9860]={'3C73000'}
G[9863]={'3AD250'}
G[9864]={'3AD25'}
G[9865]={'3AD250'}
G[9866]={'3AD75'}
G[9867]={'3AD250'}
G[9868]={'3AD350'}
G[9869]={'3D225'}
G[9870]={'3AD25'}
G[9871]={'3D2250'}
G[9872]={'3AD250'}
G[9873]={'3D2250'}
G[9874]={'3D2250'}
G[9875]={'3AE500'}
G[9877]={'39A250'}
G[9878]={'3D2250'}
G[9879]={'3D2350'}
G[9882]={'3A5250'}
G[9883]={'3A5250'}
G[9888]={'3AD250'}
G[9889]={'3AD500'}
G[9890]={'3AD10'}
G[9891]={'3AD250'}
G[9892]={'3A5250'}
G[9893]={'3A5250'}
G[9894]={'3AE250'}
G[9895]={'3AE250'}
G[9896]={'02F250'}
G[9898]={'212250'}
G[9899]={'212250'}
G[9900]={'3A5250'}
G[9901]={'02F250'}
G[9902]={'3D2250'}
G[9903]={'212250'}
G[9904]={'212250'}
G[9905]={'3D2250'}
G[9906]={'3AD250'}
G[9907]={'3AD350'}
G[9910]={'3AD250'}
G[9911]={'3AE250'}
G[9913]={'3A510'}
G[9914]={'3A5250'}
G[9915]={'3A5250'}
G[9916]={'3AD250'}
G[9917]={'3D2250'}
G[9918]={'3D2500'}
G[9919]={'3CA250'}
G[9920]={'3D210'}
G[9921]={'3D2250'}
G[9922]={'3D2350'}
G[9923]={'3D2250'}
G[9924]={'3D2250'}
G[9925]={'3A5250'}
G[9933]={'3D2350'}
G[9934]={'3AD350'}
G[9935]={'3AD250'}
G[9936]={'3D2250'}
G[9937]={'3AD350'}
G[9938]={'3D2350'}
G[9939]={'3AD250'}
G[9940]={'3D2250'}
G[9944]={'3AD10'}
G[9945]={'3AD250'}
G[9946]={'3AD350'}
G[9948]={'3AD350'}
G[9951]={'3AE350'}
G[9954]={'3D2250'}
G[9955]={'3D2350'}
G[9956]={'3D2350'}
G[9957]={'3AE25'}
G[9960]={'3AE25'}
G[9961]={'3AE25'}
G[9968]={'3AE250'}
G[9971]={'3AE250'}
G[9990]={'3AE250'}
G[10005]={'3AE500'}
G[10006]={'3AE500'}
G[10017]={'3A4250'}
G[10019]={'3A4250'}
G[10020]={'3A4350'}
G[10021]={'3A4250'}
G[10024]={'3A6250'}
G[10025]={'3A6250'}
G[10030]={'3F3250'}
G[10031]={'3F3250'}
G[10044]={'3AD25'}
G[10045]={'3AD350'}
G[10047]={'3A2250'}
G[10050]={'3B2250'}
G[10055]={'3B2250'}
G[10057]={'3B2250'}
G[10058]={'3B2250'}
G[10065]={'3A2250'}
G[10066]={'3A2250'}
G[10067]={'3A2250'}
G[10068]={'38F250'}
G[10069]={'38F250'}
G[10070]={'38F250'}
G[10071]={'38F250'}
G[10072]={'38F250'}
G[10073]={'38F250'}
G[10078]={'3B2250'}
G[10079]={'3B2250'}
G[10081]={'3AD10'}
G[10082]={'3AD250'}
G[10085]={'3AD250'}
G[10086]={'3B3250'}
G[10087]={'3B3250'}
G[10096]={'3AE250'}
G[10099]={'3B2250'}
G[10101]={'3AD500','3A7250'}
G[10102]={'3AD250','3A7250'}
G[10106]={'3B2150'}
G[10107]={'3AD150'}
G[10108]={'3D2150'}
G[10110]={'3B3150'}
G[10115]={'3D2250'}
G[10116]={'3D2250'}
G[10117]={'212250'}
G[10118]={'212250'}
G[10119]={'3B2250'}
G[10120]={'3B3250'}
G[10121]={'3B3250'}
G[10123]={'3B3250'}
G[10124]={'3B310'}
G[10129]={'3B3350'}
G[10132]={'3AE350'}
G[10134]={'3AE75'}
G[10136]={'3B3500'}
G[10140]={'3B2250'}
G[10141]={'3B2250'}
G[10142]={'3B2250'}
G[10143]={'3B210'}
G[10144]={'3B2250'}
G[10146]={'3B2350'}
G[10159]={'3AE250'}
G[10162]={'3B3250'}
G[10163]={'3B2250'}
G[10165]={'3A5500'}
G[10166]={'38F250'}
G[10167]={'3AD350','3A7350'}
G[10168]={'3AD350','3A7350'}
G[10170]={'3AD10'}
G[10171]={'3AD10'}
G[10172]={'3AD1000'}
G[10189]={'3A6250'}
G[10193]={'3A6250'}
G[10194]={'3A610'}
G[10197]={'3A6250'}
G[10198]={'3A6150'}
G[10202]={'3A675'}
G[10204]={'3A6250'}
G[10205]={'3A5250'}
G[10208]={'3B3250'}
G[10210]={'3A710'}
G[10216]={'3A5350'}
G[10218]={'3A5500'}
G[10220]={'3B3250'}
G[10227]={'3A710'}
G[10228]={'3A725'}
G[10229]={'3B310'}
G[10230]={'3B3250'}
G[10231]={'3A7250'}
G[10241]={'3A4250'}
G[10242]={'3B325'}
G[10243]={'3A475'}
G[10245]={'3A475'}
G[10246]={'3A4250'}
G[10250]={'3B3250'}
G[10251]={'3A775'}
G[10252]={'3A7250'}
G[10253]={'3A7500'}
G[10255]={'3AE250'}
G[10258]={'3B3250'}
G[10262]={'3A5250'}
G[10263]={'3A510'}
G[10264]={'3A510'}
G[10265]={'3A5250'}
G[10266]={'3A525'}
G[10267]={'3A5250'}
G[10268]={'3A575'}
G[10269]={'3A5250'}
G[10270]={'3A5250'}
G[10275]={'3A5250'}
G[10276]={'3A5500'}
G[10277]={'3DD250'}
G[10278]={'3B3250'}
G[10279]={'3DD10'}
G[10280]={'3A71000'}
G[10282]={'3DD10'}
G[10283]={'3DD1000'}
G[10284]={'3DD1000'}
G[10285]={'3DD3000'}
G[10286]={'38F150'}
G[10287]={'38F25'}
G[10288]={'3B2250'}
G[10289]={'3B3250'}
G[10290]={'3A5250'}
G[10293]={'3A5250'}
G[10294]={'3B3250'}
G[10295]={'3B3250'}
G[10296]={'3DD250'}
G[10297]={'3DD500'}
G[10298]={'3DD8000'}
G[10299]={'3A4250'}
G[10302]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10303]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10304]={'3A275','1D518','02F18','03618','04518','04818','46E18','54918'}
G[10308]={'3A5250'}
G[10310]={'3A5350'}
G[10311]={'3A510'}
G[10313]={'3A4250'}
G[10315]={'3A5250'}
G[10318]={'3A5250'}
G[10321]={'3A4250'}
G[10322]={'3A4250'}
G[10323]={'3A4250'}
G[10324]={'3A2150'}
G[10325]={'3A4250'}
G[10326]={'3A4250'}
G[10327]={'3A425'}
G[10328]={'3A4250'}
G[10329]={'3A6250'}
G[10330]={'3A6250'}
G[10335]={'3A5250'}
G[10336]={'3A5250'}
G[10338]={'3A6250'}
G[10339]={'3A5250'}
G[10341]={'3A6250'}
G[10345]={'3A5250'}
G[10348]={'3A5250'}
G[10349]={'3AE10'}
G[10351]={'3AE350'}
G[10353]={'3A5250'}
G[10355]={'3A2250'}
G[10365]={'3A6250'}
G[10380]={'3A4250'}
G[10381]={'3A4150'}
G[10382]={'3B225'}
G[10384]={'3A575'}
G[10385]={'3A5250'}
G[10388]={'3B375'}
G[10389]={'3B3250'}
G[10390]={'3B3250'}
G[10391]={'3B3250'}
G[10392]={'3B3250'}
G[10393]={'3B3250'}
G[10394]={'3B2250'}
G[10395]={'3B2250'}
G[10396]={'3B2250'}
G[10397]={'3B2250'}
G[10399]={'3B2250'}
G[10400]={'3B2500'}
G[10405]={'3A5250'}
G[10406]={'3A5250'}
G[10407]={'3A4350'}
G[10408]={'3A5500'}
G[10409]={'3A41000'}
G[10410]={'3A4150'}
G[10411]={'3A5250'}
G[10412]={'3A6250'}
G[10414]={'3A625'}
G[10415]={'3A6250'}
G[10416]={'3A6350'}
G[10417]={'3A5150'}
G[10418]={'3A5250'}
G[10419]={'3A6350'}
G[10420]={'3A4350'}
G[10421]={'3A4350'}
G[10422]={'3A5250'}
G[10425]={'3A5250'}
G[10426]={'3AE250'}
G[10427]={'3AE350'}
G[10429]={'3AE250'}
G[10431]={'3A425'}
G[10432]={'3A6250'}
G[10436]={'3A5250'}
G[10437]={'3A5250'}
G[10438]={'3A5250'}
G[10439]={'3A5500'}
G[10442]={'3AE10'}
G[10443]={'3AE10'}
G[10449]={'3B325'}
G[10450]={'3B3250'}
G[10460]={'3DE250'}
G[10461]={'3DE250'}
G[10462]={'3DE250'}
G[10463]={'3DE250'}
G[10464]={'3DE350'}
G[10465]={'3DE350'}
G[10466]={'3DE350'}
G[10467]={'3DE350'}
G[10468]={'3DE350'}
G[10469]={'3DE350'}
G[10470]={'3DE350'}
G[10471]={'3DE350'}
G[10472]={'3DE350'}
G[10473]={'3DE350'}
G[10474]={'3DE350'}
G[10475]={'3DE350'}
G[10476]={'3D2250'}
G[10477]={'3D2500'}
G[10478]={'3AD500'}
G[10479]={'3AD250'}
G[10482]={'3B2250'}
G[10483]={'3B225'}
G[10484]={'3B2250'}
G[10485]={'3B2250'}
G[10507]={'3A61000'}
G[10508]={'3A6350'}
G[10509]={'3A6150'}
G[10538]={'3B3250'}
G[10551]={'3A43500'}
G[10552]={'3A63500'}
G[10553]={'3A610'}
G[10554]={'3A410'}
G[10567]={'3AE250'}
G[10568]={'3A4250'}
G[10571]={'3A4250'}
G[10574]={'3A4250'}
G[10575]={'3A475'}
G[10587]={'3A4250'}
G[10607]={'3AE250'}
G[10619]={'3A4250'}
G[10622]={'3F4250'}
G[10628]={'3F425'}
G[10637]={'3A4250'}
G[10640]={'3A475'}
G[10650]={'3A475'}
G[10651]={'3A41000'}
G[10652]={'3A610'}
G[10653]={'3A4250'}
G[10654]={'3A4250'}
G[10655]={'3A425'}
G[10656]={'3A6250'}
G[10658]={'3A6250'}
G[10659]={'3A625'}
G[10682]={'3AE250'}
G[10683]={'3A6250'}
G[10684]={'3A6250'}
G[10685]={'3A6250'}
G[10686]={'3A675'}
G[10687]={'3A6250'}
G[10688]={'3A6250'}
G[10689]={'3A675'}
G[10691]={'3A675'}
G[10692]={'3A61000'}
G[10704]={'3A71000'}
G[10705]={'3F4250'}
G[10706]={'3F4150'}
G[10707]={'3F4250'}
G[10713]={'3AE250'}
G[10719]={'3AE10'}
G[10722]={'3AE250'}
G[10725]={'3C7350'}
G[10726]={'3C7350'}
G[10727]={'3C7350'}
G[10728]={'3C7350'}
G[10729]={'3C7250'}
G[10730]={'3C7250'}
G[10731]={'3C7250'}
G[10732]={'3C7250'}
G[10733]={'3C7350'}
G[10734]={'3C7350'}
G[10735]={'3C7350'}
G[10736]={'3C7350'}
G[10738]={'3C7350'}
G[10739]={'3C7350'}
G[10740]={'3C7350'}
G[10741]={'3C7350'}
G[10748]={'3AE350'}
G[10753]={'3AE150'}
G[10770]={'3AE250'}
G[10771]={'3AE250'}
G[10781]={'3A7500'}
G[10792]={'3B3250'}
G[10793]={'3A7150'}
G[10807]={'3A6250'}
G[10809]={'3B3250'}
G[10810]={'3AE25'}
G[10812]={'3AE25'}
G[10813]={'3B375'}
G[10816]={'3A4250'}
G[10817]={'3A6250'}
G[10819]={'3AE250'}
G[10820]={'3AE150'}
G[10821]={'3AE250'}
G[10822]={'3A625'}
G[10823]={'3A6250'}
G[10824]={'3A6250'}
G[10826]={'3A4250'}
G[10827]={'3A4250'}
G[10828]={'3A425'}
G[10834]={'3B3350'}
G[10835]={'3B325'}
G[10838]={'3B3350'}
G[10839]={'3F3250'}
G[10840]={'3F3250'}
G[10842]={'3F3250'}
G[10847]={'3F3250'}
G[10848]={'3F3250'}
G[10849]={'3F325'}
G[10852]={'3F3250'}
G[10855]={'3A5250'}
G[10856]={'3A5250'}
G[10857]={'3A5350'}
G[10861]={'3F3250'}
G[10862]={'3F375'}
G[10863]={'3F375'}
G[10864]={'3B3250'}
G[10870]={'3F742000'}
G[10871]={'3F738182'}
G[10873]={'3A7250'}
G[10874]={'3F3250'}
G[10875]={'3B325'}
G[10876]={'3B31000'}
G[10877]={'3A7250'}
G[10878]={'3F3250'}
G[10879]={'3F3500'}
G[10880]={'3F375'}
G[10881]={'3F3350'}
G[10882]={'3A71000'}
G[10883]={'3A710'}
G[10884]={'3A7500'}
G[10885]={'3A7500'}
G[10886]={'3A7500'}
G[10887]={'3F3250'}
G[10889]={'3F3150'}
G[10893]={'3AE250'}
G[10894]={'3AE10'}
G[10895]={'3B2250'}
G[10896]={'3AE250'}
G[10898]={'3F3350'}
G[10904]={'3AE250'}
G[10909]={'3B2250'}
G[10910]={'3AE250'}
G[10911]={'3AE250'}
G[10912]={'3AE500'}
G[10913]={'3F3250'}
G[10914]={'3F3250'}
G[10915]={'3F3250'}
G[10916]={'3B275'}
G[10917]={'3F3250'}
G[10918]={'3F3250'}
G[10920]={'3A7250'}
G[10921]={'3A7250'}
G[10922]={'3F3250'}
G[10923]={'3A7350'}
G[10926]={'3A7250'}
G[10929]={'3F3250'}
G[10930]={'3F3350'}
G[10935]={'3B2250'}
G[10937]={'3B21000'}
G[10938]={'38D350'}
G[10939]={'38D350'}
G[10940]={'38D350'}
G[10941]={'38D350'}
G[10942]={'3F310'}
G[10943]={'3F310'}
G[10944]={'3F4350'}
G[10945]={'3F3250'}
G[10946]={'3F4500'}
G[10947]={'3F4500'}
G[10948]={'3F475'}
G[10949]={'3F4150','3A7150'}
G[10950]={'3F3250'}
G[10951]={'3F3250'}
G[10952]={'3F3250'}
G[10953]={'3F3250'}
G[10954]={'3F3250'}
G[10956]={'3F375'}
G[10957]={'3F4500'}
G[10958]={'3F4350'}
G[10959]={'3F4500'}
G[10962]={'3F3250'}
G[10963]={'3F3250'}
G[10966]={'3F3500'}
G[10967]={'3F3500'}
G[10968]={'3F375'}
G[10969]={'3A510'}
G[10970]={'3A5350'}
G[10971]={'3A5250'}
G[10973]={'3A5500'}
G[10974]={'3A5500'}
G[10975]={'3A5500'}
G[10976]={'3A5500'}
G[10977]={'3A5500'}
G[10981]={'3A5500'}
G[10985]={'3A7250'}
G[11002]={'3B21000'}
G[11003]={'3B31000'}
G[11004]={'407250'}
G[11005]={'407250'}
G[11006]={'407500'}
G[11007]={'3A71000'}
G[11008]={'407350'}
G[11009]={'40E25'}
G[11010]={'407500','40E500'}
G[11013]={'3F7250'}
G[11015]={'3F7250'}
G[11016]={'3F7250'}
G[11017]={'3F7250'}
G[11018]={'3F7250'}
G[11020]={'3F7250'}
G[11021]={'40775'}
G[11023]={'407500','40E500'}
G[11024]={'40775'}
G[11025]={'40E250'}
G[11026]={'40E350','407350'}
G[11028]={'40775'}
G[11029]={'407150'}
G[11030]={'40E250'}
G[11035]={'3F7250'}
G[11038]={'3A410'}
G[11039]={'3A610'}
G[11041]={'3F7250'}
G[11049]={'3F7350'}
G[11050]={'3F7250'}
G[11051]={'40E350'}
G[11052]={'3A71000','3F41000'}
G[11053]={'3F7250'}
G[11054]={'3F7250'}
G[11055]={'3F7350'}
G[11056]={'40775'}
G[11058]={'40E250','407250'}
G[11059]={'40E500','407500'}
G[11060]={'40E10'}
G[11061]={'40E250'}
G[11062]={'40710'}
G[11064]={'3F7350'}
G[11065]={'407350','40E350'}
G[11066]={'407350','40E350'}
G[11067]={'3F7350'}
G[11068]={'3F7500'}
G[11069]={'3F7500'}
G[11070]={'3F7500'}
G[11071]={'3F71000'}
G[11073]={'4071000'}
G[11075]={'3F775'}
G[11076]={'3F7350'}
G[11077]={'3F7350'}
G[11078]={'407500'}
G[11079]={'40E500'}
G[11080]={'40E350'}
G[11081]={'3F7350'}
G[11082]={'3F7500'}
G[11083]={'3F7350'}
G[11084]={'3F7500'}
G[11085]={'407150'}
G[11086]={'3F7500'}
G[11089]={'3F7500'}
G[11090]={'3F7500'}
G[11091]={'40E10'}
G[11092]={'3F7500'}
G[11093]={'407250'}
G[11094]={'3F7250'}
G[11096]={'407250'}
G[11097]={'3F7500'}
G[11098]={'40710'}
G[11099]={'3F7250'}
G[11101]={'3F7500'}
G[11102]={'407500','40E500'}
G[11108]={'3F71000'}
G[11119]={'40710'}
G[11129]={'051250'}
G[11153]={'41A250'}
G[11154]={'41A250'}
G[11155]={'41A250'}
G[11157]={'41A250'}
G[11167]={'41C250','428125','42B125','43D125','464125'}
G[11170]={'42B250','41C125','42862','43D62','46462'}
G[11175]={'42C10'}
G[11176]={'42C10'}
G[11187]={'41A10'}
G[11188]={'41A250'}
G[11190]={'41A250'}
G[11199]={'41A10'}
G[11202]={'41A250'}
G[11208]={'171250','1D6125','241125','015125','0A9125'}
G[11211]={'17110'}
G[11216]={'3C75'}
G[11218]={'42C250'}
G[11221]={'42B150','41C75','42837','43D37','46437'}
G[11224]={'42C250'}
G[11227]={'42B250','41C125','42862','43D62','46462'}
G[11229]={'41C25','42812','42B12','43D12','46412'}
G[11230]={'41C150','42875','42B75','43D75','46475'}
G[11231]={'41A250'}
G[11232]={'42B250','41C125','42862','43D62','46462'}
G[11233]={'42B350','41C175','42887','43D87','46487'}
G[11234]={'42B75','41C37','42818','43D18','46418'}
G[11235]={'41A250'}
G[11236]={'41A350'}
G[11237]={'41A250'}
G[11238]={'41A350'}
G[11239]={'41A250'}
G[11240]={'42C250'}
G[11241]={'41C350','428175','42B175','43D175','464175'}
G[11242]={'048250'}
G[11243]={'41A250'}
G[11244]={'41A250'}
G[11245]={'41A250'}
G[11246]={'41A250'}
G[11247]={'41A250'}
G[11248]={'41A10'}
G[11249]={'41A350'}
G[11250]={'41A350'}
G[11253]={'41C150','42875','42B75','43D75','46475'}
G[11254]={'41C75','42837','42B37','43D37','46437'}
G[11255]={'41A250'}
G[11256]={'42810','41C5','42B2','43D2','4642'}
G[11257]={'428250','41C125','42B62','43D62','46462'}
G[11258]={'428250','41C125','42B62','43D62','46462'}
G[11259]={'428250','41C125','42B62','43D62','46462'}
G[11260]={'428350','41C175','42B87','43D87','46487'}
G[11261]={'428350','41C175','42B87','43D87','46487'}
G[11263]={'428250','41C125','42B62','43D62','46462'}
G[11264]={'428350','41C175','42B87','43D87','46487'}
G[11265]={'428250','41C125','42B62','43D62','46462'}
G[11266]={'428250','41C125','42B62','43D62','46462'}
G[11267]={'428350','41C175','42B87','43D87','46487'}
G[11268]={'428250','41C125','42B62','43D62','46462'}
G[11269]={'41A250'}
G[11270]={'42B250','41C125','42862','43D62','46462'}
G[11271]={'428250','41C125','42B62','43D62','46462'}
G[11272]={'41C500','428250','42B250','43D250','464250'}
G[11273]={'41A25'}
G[11274]={'41A25'}
G[11276]={'41A150'}
G[11277]={'41A250'}
G[11278]={'41A250'}
G[11279]={'42B250','41C125','42862','43D62','46462'}
G[11280]={'42B250','41C125','42862','43D62','46462'}
G[11282]={'41C250','428125','42B125','43D125','464125'}
G[11283]={'42B250','41C125','42862','43D62','46462'}
G[11284]={'41A250'}
G[11285]={'41C150','42875','42B75','43D75','46475'}
G[11286]={'428250','41C125','42B62','43D62','46462'}
G[11287]={'42810','428250','41C125','42B62','43D62','46462'}
G[11288]={'41A250'}
G[11289]={'41A75','45275'}
G[11290]={'41A250'}
G[11291]={'41A25'}
G[11295]={'41C10','4285','42B5','43D5','4645'}
G[11296]={'428250','41C125','42B62','43D62','46462'}
G[11298]={'42B250','41C125','42862','43D62','46462'}
G[11299]={'41A10'}
G[11300]={'41A250'}
G[11301]={'42B250','41C125','42862','43D62','46462'}
G[11303]={'42B350','41C175','42887','43D87','46487'}
G[11304]={'42B10','41C5','4282','43D2','4642'}
G[11305]={'42B250','41C125','42862','43D62','46462'}
G[11306]={'42B150','41C75','42837','43D37','46437'}
G[11307]={'42B250','41C125','42862','43D62','46462'}
G[11309]={'41C250','428125','42B125','43D125','464125'}
G[11310]={'41C250','428125','42B125','43D125','464125'}
G[11311]={'428250','41C125','42B62','43D62','46462'}
G[11317]={'428250','41C125','42B62','43D62','46462'}
G[11322]={'41A250'}
G[11324]={'428350','41C175','42B87','43D87','46487'}
G[11326]={'41A350'}
G[11327]={'41A250'}
G[11328]={'41A10'}
G[11329]={'41A250'}
G[11330]={'41A75'}
G[11331]={'41A10'}
G[11332]={'41A350'}
G[11333]={'41A250'}
G[11343]={'41A250'}
G[11344]={'41A250'}
G[11346]={'42C250'}
G[11348]={'42C250'}
G[11349]={'42C250'}
G[11350]={'428250','41C125','42B62','43D62','46462'}
G[11351]={'428250','41C125','42B62','43D62','46462'}
G[11352]={'428250','41C125','42B62','43D62','46462'}
G[11354]={'3A5350','3B3350','3B2350'}
G[11355]={'41A250'}
G[11356]={'04810','1D52','02F2','0362','0452','3A22','46E2'}
G[11358]={'41A250'}
G[11359]={'41A350'}
G[11360]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[11361]={'04C75'}
G[11362]={'3A5350','3B3350','3B2350'}
G[11363]={'3A5350','3B3350','3B2350'}
G[11364]={'3A5250','3B2250','3B3250'}
G[11365]={'428250','41C125','42B62','43D62','46462'}
G[11366]={'428250','41C125','42B62','43D62','46462'}
G[11367]={'428350','41C175','42B87','43D87','46487'}
G[11368]={'3A5350','3AE350'}
G[11369]={'3A5350','3AE350'}
G[11370]={'3A5350','3AE350'}
G[11371]={'3A5250','3AE250'}
G[11372]={'3A5350','3F3350'}
G[11373]={'3A5500'}
G[11374]={'3A5350','3F3350'}
G[11375]={'3A5350','3F3350'}
G[11376]={'3A5250','3F3250'}
G[11378]={'3A5350','3DD350'}
G[11382]={'3A5350','3DD350'}
G[11383]={'3A5250','3DD250'}
G[11384]={'3A5350','3A7350'}
G[11385]={'3A5250','3A7250'}
G[11386]={'3A5350','3A7350'}
G[11387]={'3A5250','3A7250'}
G[11388]={'3A5350','3A7350'}
G[11389]={'3A5250','3A7250'}
G[11390]={'42C250'}
G[11391]={'42C250'}
G[11393]={'42C10'}
G[11394]={'42C250'}
G[11395]={'42C10'}
G[11396]={'42C350'}
G[11397]={'42B250','41C125','42862','43D62','46462'}
G[11398]={'42B10'}
G[11399]={'42B350'}
G[11403]={'04C250'}
G[11406]={'41A10'}
G[11410]={'41A250'}
G[11411]={'42810','41C5','42B2','43D2','4642'}
G[11418]={'41A150'}
G[11420]={'41A250'}
G[11421]={'41A350'}
G[11423]={'41C250','428125','42B125','43D125','464125'}
G[11424]={'41C250','428125','42B125','43D125','464125'}
G[11426]={'41A250'}
G[11427]={'41A10'}
G[11429]={'41A250'}
G[11430]={'41A250'}
G[11432]={'41A250'}
G[11433]={'428250','41C125','42B62','43D62','46462'}
G[11436]={'41A10'}
G[11439]={'02F75'}
G[11440]={'3A275'}
G[11443]={'41A250'}
G[11448]={'41A10'}
G[11449]={'04475'}
G[11450]={'38F75'}
G[11452]={'41A350'}
G[11453]={'428350','41C175','42B87','43D87','46487'}
G[11456]={'431250'}
G[11457]={'431250'}
G[11458]={'431350'}
G[11460]={'41A250'}
G[11465]={'41A250','42C250'}
G[11468]={'41A250','42C250'}
G[11470]={'41A350','42C350'}
G[11472]={'431250'}
G[11474]={'41A10','42C10'}
G[11475]={'41A250','42C250'}
G[11477]={'41A250','42C250'}
G[11478]={'41A25','42C25'}
G[11481]={'43510'}
G[11482]={'43510'}
G[11483]={'42C250','41A250'}
G[11484]={'42C250','41A250'}
G[11485]={'42C10','41A10'}
G[11489]={'42C10','41A10'}
G[11491]={'42C10','41A10'}
G[11494]={'42C350','41A350'}
G[11495]={'42C350','41A350'}
G[11499]={'3A5350','435350'}
G[11500]={'3A5250','435250'}
G[11501]={'42C10','41A10'}
G[11502]={'3D2250'}
G[11503]={'3AD250'}
G[11504]={'431250'}
G[11507]={'43175'}
G[11508]={'43110'}
G[11509]={'43125'}
G[11510]={'431250'}
G[11511]={'431250'}
G[11512]={'431250'}
G[11514]={'435250'}
G[11515]={'435250'}
G[11516]={'435250'}
G[11519]={'431150'}
G[11521]={'435350'}
G[11523]={'435150'}
G[11525]={'435150'}
G[11526]={'43575'}
G[11527]={'431150'}
G[11529]={'431150'}
G[11530]={'431250'}
G[11533]={'435150'}
G[11534]={'43510'}
G[11536]={'435250'}
G[11537]={'435250'}
G[11540]={'435250'}
G[11541]={'435250'}
G[11543]={'435250'}
G[11544]={'435350'}
G[11546]={'435250'}
G[11547]={'435250'}
G[11548]={'435150'}
G[11549]={'435500'}
G[11560]={'3AE250'}
G[11565]={'3AE10'}
G[11566]={'3AE350'}
G[11567]={'431250'}
G[11568]={'431250'}
G[11570]={'3AE250'}
G[11571]={'3AE250'}
G[11572]={'431500'}
G[11573]={'43125'}
G[11576]={'442150'}
G[11582]={'442150'}
G[11585]={'43D10','41C5','4282','42B2','4642'}
G[11586]={'43D10'}
G[11587]={'442250'}
G[11590]={'442250'}
G[11591]={'42810','41C5','42B2','43D2','4642'}
G[11592]={'43D350','428350'}
G[11593]={'43D250'}
G[11594]={'43D250','41C125','42862','42B62','46462'}
G[11595]={'43D10'}
G[11596]={'43D10','41C5','4282','42B2','4642'}
G[11597]={'43D10'}
G[11598]={'43D250','41C125','42862','42B62','46462'}
G[11600]={'41A150'}
G[11601]={'41A75'}
G[11602]={'43D250','41C125','42862','42B62','46462'}
G[11603]={'41A150'}
G[11604]={'41A25'}
G[11605]={'431250'}
G[11606]={'43D250','41C125','42862','42B62','46462'}
G[11607]={'431250'}
G[11608]={'43D250','41C125','42862','42B62','46462'}
G[11609]={'431250'}
G[11610]={'431350'}
G[11611]={'43D250','41C125','42862','42B62','46462'}
G[11612]={'431250'}
G[11613]={'431350'}
G[11614]={'43D25','41C12','4286','42B6','4646'}
G[11615]={'43D25','41C12','4286','42B6','4646'}
G[11616]={'43D25','41C12','4286','42B6','4646'}
G[11617]={'431350'}
G[11618]={'43D25','41C12','4286','42B6','4646'}
G[11619]={'431250'}
G[11620]={'431150'}
G[11623]={'431250'}
G[11626]={'431500'}
G[11628]={'428250'}
G[11629]={'43D10'}
G[11630]={'428250'}
G[11631]={'43D10'}
G[11632]={'43D250'}
G[11633]={'428250'}
G[11634]={'43D10','41C5','4282','42B2','4642'}
G[11635]={'43D250'}
G[11636]={'43D10','41C5','4282','42B2','4642'}
G[11637]={'43D250'}
G[11638]={'43D350'}
G[11639]={'41C250'}
G[11640]={'428250'}
G[11641]={'428250'}
G[11642]={'43D10','41C5','4282','42B2','4642'}
G[11643]={'43D250','41C125','42862','42B62','46462'}
G[11644]={'43D250','41C125','42862','42B62','46462'}
G[11645]={'41A250'}
G[11646]={'44225'}
G[11647]={'428250'}
G[11648]={'442150'}
G[11650]={'41A250'}
G[11651]={'43D25','41C12','4286','42B6','4646'}
G[11652]={'43D500','41C250','428125','42B125','464125'}
G[11653]={'41A250'}
G[11654]={'428150'}
G[11655]={'431250'}
G[11656]={'431250'}
G[11658]={'41A250'}
G[11659]={'428250'}
G[11660]={'431250'}
G[11661]={'431250'}
G[11662]={'431250'}
G[11663]={'44210'}
G[11664]={'43D350'}
G[11670]={'41A350'}
G[11671]={'442250'}
G[11672]={'41A10'}
G[11673]={'41A350'}
G[11674]={'42810','41C5','42B2','43D2','4642'}
G[11675]={'428250'}
G[11676]={'43D250','41C125','42862','42B62','46462'}
G[11677]={'428250'}
G[11678]={'428250'}
G[11680]={'44210'}
G[11681]={'442250'}
G[11682]={'44275'}
G[11683]={'428250'}
G[11684]={'428250','41C125','42B62','43D62','46462'}
G[11685]={'428250'}
G[11686]={'43D250','41C125','42862','42B62','46462'}
G[11687]={'428250'}
G[11688]={'43D250'}
G[11689]={'428350'}
G[11690]={'43D250'}
G[11692]={'41A10'}
G[11693]={'41A250'}
G[11694]={'41A250'}
G[11695]={'428250'}
G[11697]={'41A250'}
G[11698]={'41A250'}
G[11699]={'41A250'}
G[11700]={'41A10'}
G[11701]={'41A350'}
G[11703]={'43D10','41C5','4282','42B2','4642'}
G[11705]={'43D500','41C250','428125','42B125','464125'}
G[11706]={'428350'}
G[11707]={'41A10'}
G[11708]={'41A10'}
G[11709]={'43D10','41C5','4282','42B2','4642'}
G[11710]={'41A250'}
G[11711]={'43D150','41C75','42837','42B37','46437'}
G[11712]={'41A250'}
G[11713]={'41A250'}
G[11714]={'43D250'}
G[11715]={'41A250'}
G[11716]={'43D250'}
G[11717]={'43D250'}
G[11718]={'41A250'}
G[11719]={'43D10'}
G[11720]={'43D10'}
G[11721]={'43D250'}
G[11722]={'43D150'}
G[11723]={'41A350'}
G[11724]={'43D250'}
G[11725]={'41A10'}
G[11726]={'41A250'}
G[11727]={'41A10'}
G[11728]={'41A250'}
G[11729]={'41A10'}
G[11730]={'41A350'}
G[11733]={'442150'}
G[11788]={'41A350'}
G[11789]={'41A150'}
G[11790]={'41A75'}
G[11791]={'41A10'}
G[11792]={'41A250'}
G[11793]={'41A25'}
G[11794]={'41A250'}
G[11795]={'41A250'}
G[11796]={'41A250'}
G[11797]={'41A250'}
G[11798]={'41A350'}
G[11864]={'3AE10'}
G[11865]={'3AE250'}
G[11866]={'3AE250'}
G[11867]={'3AE150'}
G[11868]={'3AE250'}
G[11869]={'3AE250'}
G[11870]={'3AE10'}
G[11871]={'3AE250'}
G[11872]={'3AE250'}
G[11873]={'41A350'}
G[11875]={'435250'}
G[11876]={'3AE250'}
G[11877]={'435250'}
G[11878]={'3AE150'}
G[11879]={'3AE350'}
G[11880]={'435150'}
G[11884]={'3AE350'}
G[11885]={'407350'}
G[11888]={'42810','41C5','42B2','43D2','4642'}
G[11889]={'41A250'}
G[11890]={'428250','41C125','42B62','43D62','46462'}
G[11892]={'3AE500'}
G[11893]={'428250'}
G[11895]={'428250'}
G[11896]={'428250'}
G[11897]={'41A250'}
G[11898]={'428350'}
G[11899]={'428250'}
G[11900]={'442250'}
G[11901]={'41A150'}
G[11902]={'41A75'}
G[11903]={'41A250'}
G[11904]={'41A250'}
G[11905]={'442350'}
G[11906]={'428250'}
G[11907]={'428350'}
G[11908]={'41A150'}
G[11909]={'428350'}
G[11910]={'442250'}
G[11911]={'442250'}
G[11912]={'442250'}
G[11913]={'41A250'}
G[11914]={'442250'}
G[11916]={'43D500'}
G[11918]={'443250'}
G[11919]={'443250'}
G[11920]={'41A75'}
G[11928]={'41A10'}
G[11929]={'42810','43D10'}
G[11930]={'428250','43D250'}
G[11931]={'443250'}
G[11932]={'41A75'}
G[11936]={'443250'}
G[11938]={'41A250'}
G[11940]={'443250'}
G[11941]={'443250'}
G[11942]={'41A250'}
G[11943]={'443250'}
G[11944]={'41A250'}
G[11945]={'431250'}
G[11946]={'44310'}
G[11949]={'431250'}
G[11950]={'431250'}
G[11951]={'443250'}
G[11956]={'41A250'}
G[11957]={'443250'}
G[11958]={'431250'}
G[11959]={'431350'}
G[11960]={'431250'}
G[11961]={'431150'}
G[11962]={'41A25'}
G[11963]={'41A25'}
G[11965]={'41A250'}
G[11967]={'44375'}
G[11968]={'431250'}
G[11969]={'443250'}
G[11973]={'443250'}
G[11975]={'3F3250'}
G[11977]={'42810','43D10'}
G[11978]={'428250','41C125','42B62','43D62','46462','43D250','41C125','42862','42B62','46462'}
G[11979]={'42810','43D10'}
G[11980]={'43D250','41C125','42862','42B62','46462'}
G[11983]={'428150','41C75','42B37','43D37','46437','43D150','41C75','42837','42B37','46437'}
G[11995]={'44210'}
G[11996]={'44210'}
G[11999]={'442250'}
G[12000]={'442250'}
G[12004]={'442350'}
G[12005]={'442350'}
G[12008]={'43D150','41C75','42837','42B37','46437'}
G[12009]={'431250'}
G[12011]={'43110'}
G[12016]={'431250'}
G[12017]={'431350'}
G[12019]={'41A500'}
G[12026]={'428250','41C125','42B62','43D62','46462'}
G[12028]={'431250'}
G[12030]={'431250'}
G[12031]={'431250'}
G[12032]={'431500'}
G[12033]={'43D150'}
G[12034]={'43D10','41C5','4282','42B2','4642'}
G[12035]={'41A250'}
G[12036]={'43D250','41C125','42862','42B62','46462'}
G[12039]={'43D250','41C125','42862','42B62','46462'}
G[12041]={'41C150'}
G[12048]={'43D250','41C125','42862','42B62','46462'}
G[12053]={'43D250'}
G[12054]={'428250','41C125','42B62','43D62','46462'}
G[12055]={'44275'}
G[12056]={'43D250','41C125','42862','42B62','46462'}
G[12057]={'43D250','41C125','42862','42B62','46462'}
G[12058]={'428250','41C125','42B62','43D62','46462'}
G[12059]={'44275'}
G[12060]={'442250'}
G[12061]={'442250'}
G[12063]={'41C150','42875','42B75','43D75','46475','428150','41C75','42B37','43D37','46437'}
G[12064]={'41C250','428125','42B125','43D125','464125','428250','41C125','42B62','43D62','46462'}
G[12065]={'442250'}
G[12066]={'442250'}
G[12067]={'41A250'}
G[12069]={'41C500','428250','42B250','43D250','464250','428500','41C250','42B125','43D125','464125'}
G[12071]={'43D10'}
G[12072]={'43D250'}
G[12073]={'43D250','41C125','42862','42B62','46462'}
G[12083]={'442250'}
G[12084]={'442250'}
G[12085]={'43D250','41C125','42862','42B62','46462'}
G[12086]={'41A250'}
G[12088]={'41A25'}
G[12089]={'43D350'}
G[12090]={'41C350'}
G[12091]={'43D350'}
G[12092]={'41A250'}
G[12095]={'43D10'}
G[12096]={'41C250','428125','42B125','43D125','464125'}
G[12097]={'43D500'}
G[12098]={'442250'}
G[12100]={'43D250','41C125','42862','42B62','46462'}
G[12101]={'43D10','41C5','4282','42B2','4642'}
G[12102]={'43D250','41C125','42862','42B62','46462'}
G[12104]={'43D10','41C5','4282','42B2','4642'}
G[12105]={'41A75'}
G[12106]={'442250'}
G[12107]={'442350'}
G[12109]={'41A25'}
G[12110]={'442350'}
G[12111]={'43D250'}
G[12115]={'43D10','41C5','4282','42B2','4642'}
G[12117]={'43110'}
G[12118]={'43110'}
G[12119]={'44325'}
G[12122]={'44325'}
G[12123]={'44310'}
G[12124]={'44310'}
G[12125]={'43D250'}
G[12126]={'43D350'}
G[12127]={'43D250'}
G[12132]={'43D250'}
G[12136]={'43D500'}
G[12140]={'43D250','41C125','42862','42B62','46462'}
G[12142]={'41A250'}
G[12143]={'41A250'}
G[12144]={'43D250'}
G[12145]={'43D250'}
G[12146]={'443250'}
G[12147]={'443250'}
G[12148]={'443250'}
G[12149]={'443250'}
G[12150]={'443350'}
G[12151]={'443350'}
G[12157]={'41A25'}
G[12165]={'428250','41C125','42B62','43D62','46462'}
G[12166]={'41A250'}
G[12167]={'41A250'}
G[12168]={'41A10'}
G[12169]={'41A350'}
G[12170]={'41C250'}
G[12171]={'41A10'}
G[12172]={'442250'}
G[12173]={'442250'}
G[12174]={'41A10'}
G[12175]={'41C250','428125','42B125','43D125','464125'}
G[12176]={'41C250','428125','42B125','43D125','464125'}
G[12177]={'41C75','42837','42B37','43D37','46437'}
G[12178]={'41C75','42837','42B37','43D37','46437'}
G[12181]={'42B10','41C5','4282','43D2','4642'}
G[12182]={'42B10','41C5','4282','43D2','4642'}
G[12188]={'42B250','41C125','42862','43D62','46462'}
G[12189]={'42B25','41C12','4286','43D6','4646'}
G[12195]={'428250','41C125','42B62','43D62','46462'}
G[12196]={'428250'}
G[12197]={'428250'}
G[12198]={'428250'}
G[12199]={'428350'}
G[12200]={'42B250'}
G[12205]={'42B250','41C125','42862','43D62','46462'}
G[12206]={'42B10','41C5','4282','43D2','4642'}
G[12207]={'43D250','41C125','42862','42B62','46462'}
G[12209]={'42B250','41C125','42862','43D62','46462'}
G[12211]={'42B250','41C125','42862','43D62','46462'}
G[12212]={'41A250'}
G[12213]={'43D250','41C125','42862','42B62','46462'}
G[12214]={'42B250'}
G[12215]={'41A150'}
G[12216]={'41A250'}
G[12217]={'41A250'}
G[12218]={'42B250'}
G[12219]={'41A250'}
G[12221]={'42B150'}
G[12222]={'41A250'}
G[12223]={'41A250'}
G[12224]={'43D25'}
G[12225]={'41A75'}
G[12226]={'41A250'}
G[12227]={'41A150'}
G[12229]={'43D350','41C175','42887','42B87','46487'}
G[12230]={'42B250'}
G[12231]={'43D150','41C75','42837','42B37','46437'}
G[12232]={'42B250'}
G[12234]={'42B250'}
G[12235]={'41A10'}
G[12236]={'43D500'}
G[12237]={'41A250'}
G[12239]={'42B250'}
G[12240]={'42B250'}
G[12241]={'43D250','41C125','42862','42B62','46462'}
G[12242]={'43D250','41C125','42862','42B62','46462'}
G[12243]={'42B250'}
G[12244]={'41A250'}
G[12245]={'42B250'}
G[12246]={'41A350'}
G[12247]={'43D150'}
G[12248]={'41A250'}
G[12249]={'41A500'}
G[12250]={'41A250'}
G[12251]={'41A10'}
G[12252]={'42B250'}
G[12253]={'41A250'}
G[12254]={'42B250'}
G[12255]={'41A250'}
G[12256]={'43D250','41C125','42862','42B62','46462'}
G[12257]={'43D250','41C125','42862','42B62','46462'}
G[12258]={'41A250'}
G[12259]={'43D250','41C125','42862','42B62','46462'}
G[12260]={'42B250'}
G[12261]={'443250'}
G[12262]={'443250'}
G[12263]={'443250'}
G[12264]={'443250'}
G[12265]={'443250'}
G[12266]={'44310'}
G[12267]={'443350'}
G[12268]={'41A250'}
G[12269]={'41A250'}
G[12270]={'43D250'}
G[12271]={'42B75'}
G[12272]={'41A250'}
G[12273]={'42B350'}
G[12274]={'42B250'}
G[12275]={'41A5'}
G[12276]={'41A250'}
G[12277]={'41A350'}
G[12280]={'43D250'}
G[12281]={'41A10'}
G[12282]={'41A250'}
G[12283]={'42B250'}
G[12284]={'43D250'}
G[12285]={'42B350'}
G[12287]={'41A25'}
G[12288]={'43D250'}
G[12289]={'41A250'}
G[12290]={'41A250','452250'}
G[12291]={'41A250','452250'}
G[12292]={'41A250'}
G[12293]={'41A25'}
G[12294]={'41A25'}
G[12295]={'41A250'}
G[12296]={'41A250'}
G[12297]={'41A10'}
G[12298]={'41A10'}
G[12301]={'41A500','452500'}
G[12302]={'41A250'}
G[12303]={'42B250','41C125','42862','43D62','46462'}
G[12304]={'42B250'}
G[12305]={'41A25'}
G[12308]={'41A250'}
G[12309]={'41A10'}
G[12310]={'41A250'}
G[12311]={'41A250'}
G[12312]={'41A25'}
G[12319]={'41A10'}
G[12320]={'41A10'}
G[12321]={'41A250'}
G[12325]={'41A25'}
G[12326]={'41A350'}
G[12372]={'443250'}
G[12413]={'43D250','41C125','42862','42B62','46462'}
G[12415]={'428250','41C125','42B62','43D62','46462'}
G[12416]={'443250'}
G[12417]={'443250'}
G[12418]={'443250'}
G[12419]={'443350'}
G[12422]={'43D25','41C12','4286','42B6','4646'}
G[12423]={'43D75','41C37','42818','42B18','46418'}
G[12424]={'43D75'}
G[12431]={'43D500'}
G[12435]={'44310'}
G[12436]={'43D250','41C125','42862','42B62','46462'}
G[12438]={'41A350'}
G[12439]={'41A10'}
G[12440]={'41A10'}
G[12441]={'41A350'}
G[12442]={'41A350'}
G[12444]={'41A250'}
G[12447]={'44310'}
G[12448]={'443250'}
G[12449]={'443250'}
G[12450]={'443250'}
G[12451]={'42825','41C12','42B6','43D6','4646'}
G[12453]={'43D150','41C75','42837','42B37','46437'}
G[12454]={'443250'}
G[12455]={'41A250'}
G[12456]={'443350'}
G[12457]={'41A350'}
G[12458]={'443250'}
G[12459]={'443500'}
G[12460]={'44310'}
G[12461]={'44310'}
G[12462]={'41A250'}
G[12463]={'41A75'}
G[12464]={'41A350'}
G[12465]={'41A250'}
G[12466]={'41A25'}
G[12467]={'41A350'}
G[12470]={'443350'}
G[12471]={'431150'}
G[12472]={'41A10'}
G[12473]={'41A250'}
G[12474]={'41A500'}
G[12475]={'41A250'}
G[12477]={'41A250'}
G[12478]={'41A350'}
G[12481]={'41C350','428175','42B175','43D175','464175'}
G[12482]={'42B250','41C125','42862','43D62','46462'}
G[12486]={'43D10','41C5','4282','42B2','4642'}
G[12487]={'43D10','41C5','4282','42B2','4642'}
G[12488]={'42B10'}
G[12495]={'41A10','44310'}
G[12496]={'43D10','44310'}
G[12498]={'443350'}
G[12499]={'41A500'}
G[12500]={'43D500'}
G[12501]={'452350'}
G[12503]={'452250'}
G[12504]={'452250'}
G[12505]={'45210'}
G[12508]={'452250'}
G[12511]={'41A25'}
G[12512]={'452250'}
G[12517]={'38D25'}
G[12518]={'38D25'}
G[12527]={'452250'}
G[12528]={'450700'}
G[12529]={'450700'}
G[12530]={'4501000'}
G[12531]={'4501000'}
G[12532]={'450700'}
G[12533]={'450700'}
G[12534]={'4501000'}
G[12535]={'450700'}
G[12536]={'450700'}
G[12537]={'4501000'}
G[12538]={'450700'}
G[12539]={'450700'}
G[12540]={'45124121'}
G[12542]={'45225'}
G[12545]={'452250'}
G[12552]={'452250'}
G[12553]={'452250'}
G[12554]={'452350'}
G[12555]={'452250'}
G[12562]={'452250'}
G[12563]={'452350'}
G[12566]={'42810','41C5','42B2','43D2','4642'}
G[12570]={'451700'}
G[12571]={'451700'}
G[12572]={'451700'}
G[12573]={'451700'}
G[12574]={'451500'}
G[12575]={'451700'}
G[12576]={'451700'}
G[12577]={'451500'}
G[12578]={'451500'}
G[12579]={'451700'}
G[12580]={'451700'}
G[12581]={'45051001'}
G[12583]={'452250'}
G[12584]={'452250'}
G[12587]={'452350'}
G[12596]={'452250'}
G[12597]={'45275'}
G[12598]={'45275'}
G[12599]={'45275'}
G[12604]={'452500'}
G[12606]={'452250'}
G[12609]={'452250'}
G[12610]={'452250'}
G[12629]={'44A250'}
G[12631]={'44A150'}
G[12633]={'44A150'}
G[12637]={'44A75'}
G[12638]={'44A75'}
G[12643]={'44A250'}
G[12648]={'44A150'}
G[12649]={'44A150'}
G[12661]={'44A250'}
G[12669]={'44A250'}
G[12676]={'44A250'}
G[12677]={'44A250'}
G[12702]={'450250'}
G[12703]={'450350'}
G[12704]={'451250'}
G[12705]={'451350'}
G[12713]={'44A500'}
G[12726]={'451250'}
G[12728]={'442350'}
G[12732]={'450250'}
G[12734]={'450250'}
G[12735]={'451250'}
G[12736]={'451250'}
G[12737]={'451250'}
G[12740]={'452250'}
G[12741]={'450250'}
G[12758]={'450250'}
G[12759]={'450350'}
G[12760]={'450350'}
G[12761]={'451350'}
G[12762]={'451350'}
G[12766]={'41A10'}
G[12767]={'43D10','41C5','4282','42B2','4642'}
G[12768]={'44310'}
G[12769]={'44310'}
G[12790]={'44210'}
G[12791]={'44210'}
G[12794]={'44210'}
G[12796]={'44210'}
G[12798]={'38D25'}
G[12801]={'44A3000'}
G[12806]={'44A10'}
G[12807]={'44A10'}
G[12810]={'44A250'}
G[12813]={'44A250'}
G[12814]={'44A250'}
G[12815]={'44A250'}
G[12838]={'44A250'}
G[12839]={'44A250'}
G[12840]={'44A250'}
G[12847]={'44A350'}
G[12852]={'44A350'}
G[12855]={'42C250'}
G[12857]={'452350'}
G[12858]={'42C250'}
G[12859]={'452250'}
G[12860]={'42C250'}
G[12863]={'46610'}
G[12864]={'466250'}
G[12865]={'466250'}
G[12866]={'466250'}
G[12867]={'466250'}
G[12868]={'466350'}
G[12869]={'466250'}
G[12870]={'42C250'}
G[12871]={'46610'}
G[12872]={'42C250'}
G[12873]={'46610'}
G[12874]={'466250'}
G[12875]={'466250'}
G[12876]={'466250'}
G[12877]={'466250'}
G[12879]={'466350'}
G[12880]={'42C10'}
G[12882]={'43D250'}
G[12883]={'452250'}
G[12884]={'44A25'}
G[12887]={'44A250'}
G[12891]={'44A250'}
G[12892]={'44A250'}
G[12893]={'44A350'}
G[12894]={'45225'}
G[12895]={'43D250'}
G[12898]={'44A10'}
G[12899]={'44A10'}
G[12901]={'452250'}
G[12902]={'452150'}
G[12903]={'452250'}
G[12904]={'452350'}
G[12909]={'43D10'}
G[12913]={'43D10'}
G[12914]={'452250'}
G[12915]={'45F22000'}
G[12916]={'45275'}
G[12917]={'43D250'}
G[12919]={'452500'}
G[12924]={'45F250'}
G[12938]={'44A10'}
G[12939]={'44A250'}
G[12943]={'44A250'}
G[12949]={'44A250'}
G[12951]={'44A25'}
G[12955]={'44A250'}
G[12956]={'45F22000'}
G[12958]={'44225'}
G[12959]={'44225'}
G[12960]={'44225'}
G[12961]={'44225'}
G[12962]={'44225'}
G[12963]={'44225'}
G[12966]={'45F75'}
G[12967]={'45F75'}
G[12973]={'42C500','466500'}
G[12975]={'45F250'}
G[12976]={'45F75'}
G[12977]={'45F350'}
G[12981]={'45F350'}
G[12982]={'44A250'}
G[12985]={'45F250'}
G[12987]={'45F150'}
G[12992]={'44A250'}
G[12994]={'45F350'}
G[12995]={'44A250'}
G[12999]={'44A10'}
G[13000]={'43D250'}
G[13001]={'45F250'}
G[13003]={'45F500'}
G[13006]={'45F350'}
G[13008]={'452250'}
G[13010]={'45F350'}
G[13011]={'45F250'}
G[13012]={'1D575','04375'}
G[13013]={'1D575','04375'}
G[13014]={'1D575','04375'}
G[13015]={'1D575','04375'}
G[13016]={'1D575','04375'}
G[13017]={'1D575','04375'}
G[13018]={'1D575','04375'}
G[13019]={'1D575','04375'}
G[13020]={'1D575','04375'}
G[13021]={'1D575','04375'}
G[13022]={'1D575','04375'}
G[13023]={'1D575','04375'}
G[13024]={'1D575','04375'}
G[13025]={'1D575','04375'}
G[13026]={'1D575','04375'}
G[13027]={'1D575','04375'}
G[13028]={'1D575','04375'}
G[13029]={'1D575','04375'}
G[13030]={'1D575','04375'}
G[13031]={'1D575','04375'}
G[13032]={'1D575','04375'}
G[13033]={'1D575','04375'}
G[13034]={'43D250'}
G[13036]={'40D10'}
G[13037]={'43D250'}
G[13038]={'43D250'}
G[13039]={'452250'}
G[13040]={'452250'}
G[13042]={'44A250'}
G[13043]={'44A350'}
G[13045]={'452350'}
G[13046]={'45F350'}
G[13048]={'43D250'}
G[13054]={'43D75'}
G[13056]={'43D250'}
G[13058]={'43D350'}
G[13059]={'44A350'}
G[13065]={'1D575','04375'}
G[13066]={'1D575','04375'}
G[13067]={'1D575','04375'}
G[13068]={'45210'}
G[13069]={'44A250'}
G[13070]={'45210'}
G[13071]={'44A250'}
G[13072]={'452250'}
G[13073]={'452150'}
G[13075]={'452250'}
G[13076]={'45210'}
G[13077]={'452150'}
G[13079]={'452250'}
G[13080]={'45210'}
G[13081]={'452150'}
G[13082]={'452250'}
G[13083]={'452500'}
G[13084]={'44A250'}
G[13085]={'44A10'}
G[13086]={'452500'}
G[13087]={'41A75'}
G[13088]={'41A75'}
G[13089]={'42B75','41C37','42818','43D18','46418'}
G[13090]={'43D75','41C37','42818','42B18','46418'}
G[13091]={'44A250'}
G[13092]={'44A250'}
G[13093]={'44A10'}
G[13094]={'442350'}
G[13095]={'442350'}
G[13100]={'442150'}
G[13101]={'442150'}
G[13102]={'442150'}
G[13103]={'442150'}
G[13104]={'45210','44A10'}
G[13105]={'45210','44A10'}
G[13106]={'44A10'}
G[13107]={'442150'}
G[13108]={'45F500'}
G[13110]={'452250'}
G[13112]={'442150'}
G[13113]={'442150'}
G[13114]={'442150'}
G[13115]={'442150'}
G[13116]={'442150'}
G[13117]={'44A150'}
G[13118]={'452250','44A250'}
G[13119]={'44A250'}
G[13120]={'44A250'}
G[13121]={'44A250'}
G[13122]={'452250','44A250'}
G[13124]={'443350'}
G[13125]={'452500','44A500'}
G[13126]={'443350'}
G[13127]={'443350'}
G[13128]={'443350'}
G[13130]={'452250'}
G[13133]={'44A250'}
G[13134]={'44A250'}
G[13135]={'452250'}
G[13136]={'452250'}
G[13137]={'44A350'}
G[13138]={'452250'}
G[13139]={'452250'}
G[13140]={'452250'}
G[13141]={'452250'}
G[13142]={'44A500'}
G[13143]={'44A250'}
G[13144]={'44A250'}
G[13145]={'44A250'}
G[13146]={'44A250'}
G[13147]={'44A250'}
G[13148]={'44225'}
G[13152]={'44A250'}
G[13155]={'44A75'}
G[13157]={'452500'}
G[13160]={'44A250'}
G[13161]={'44A350'}
G[13162]={'44A350'}
G[13163]={'44A350'}
G[13164]={'44A500'}
G[13165]={'44A10'}
G[13166]={'44A500'}
G[13168]={'44A10'}
G[13169]={'44A250'}
G[13170]={'44A250'}
G[13171]={'44A250'}
G[13172]={'44A250'}
G[13174]={'44A250'}
G[13188]={'0486000'}
G[13189]={'04C6000'}
G[13211]={'452250'}
G[13212]={'44A250'}
G[13220]={'44A250'}
G[13221]={'452250'}
G[13224]={'43D25'}
G[13225]={'41A25'}
G[13226]={'45225'}
G[13227]={'45225'}
G[13235]={'44A350'}
G[13258]={'43D75'}
G[13280]={'41A250'}
G[13283]={'43D250'}
G[13284]={'41A250'}
G[13285]={'43D350'}
G[13293]={'43D10'}
G[13296]={'41A10'}
G[13300]={'452250'}
G[13301]={'43D250'}
G[13302]={'452250'}
G[13306]={'44A250'}
G[13307]={'44A250'}
G[13309]={'41A250'}
G[13310]={'43D250'}
G[13311]={'38D25'}
G[13312]={'44A350'}
G[13313]={'43D250'}
G[13314]={'41A250'}
G[13316]={'44A350'}
G[13324]={'38D350'}
G[13325]={'38D350'}
G[13326]={'38D350'}
G[13327]={'38D350'}
G[13328]={'44A350'}
G[13329]={'44A250'}
G[13330]={'43D250'}
G[13331]={'43D250'}
G[13332]={'44A250'}
G[13333]={'41A250'}
G[13334]={'44A250'}
G[13335]={'44A250'}
G[13336]={'41A250'}
G[13337]={'44A350'}
G[13338]={'44A350'}
G[13339]={'44A350'}
G[13340]={'43D25'}
G[13341]={'41A25'}
G[13343]={'443350'}
G[13348]={'43D75'}
G[13349]={'43D250'}
G[13362]={'41A75'}
G[13364]={'452500','44A500','41A500','43D500'}
G[13372]={'443500'}
G[13375]={'443500'}
G[13384]={'443500'}
G[13385]={'4431000'}
G[13386]={'41A75'}
G[13387]={'41A250'}
G[13392]={'41A75'}
G[13396]={'41A75'}
G[13397]={'41A250'}
G[13403]={'452500','44A500','41A500','43D500'}
G[13408]={'3B2150'}
G[13409]={'3B3150'}
G[13410]={'3B2150'}
G[13411]={'3B3150'}
G[13412]={'44325'}
G[13413]={'443350'}
G[13414]={'443250'}
G[13418]={'41A25'}
G[13419]={'43D25'}
G[13420]={'45F350'}
G[13421]={'45F350'}
G[13426]={'43D10'}
G[13429]={'3A7250'}
G[13430]={'3A7500'}
G[13432]={'3DE3000'}
G[13482]={'452250'}
G[13504]={'045250'}
G[13505]={'045250'}
G[13506]={'045250'}
G[13507]={'045250'}
G[13508]={'045250'}
G[13509]={'045250'}
G[13510]={'045250'}
G[13511]={'045250'}
G[13512]={'045250'}
G[13513]={'045250'}
G[13514]={'045250'}
G[13515]={'045350'}
G[13518]={'045250'}
G[13519]={'045250'}
G[13520]={'045250'}
G[13521]={'045250'}
G[13522]={'045250'}
G[13527]={'045250'}
G[13528]={'045250'}
G[13529]={'045250'}
G[13537]={'46E250'}
G[13542]={'045250'}
G[13543]={'045250'}
G[13547]={'045250'}
G[13554]={'045250'}
G[13557]={'045250'}
G[13558]={'045350'}
G[13559]={'45F325'}
G[13560]={'045250'}
G[13561]={'045250'}
G[13562]={'045250'}
G[13563]={'045250'}
G[13564]={'045250'}
G[13565]={'045250'}
G[13566]={'045250'}
G[13569]={'045250'}
G[13570]={'045350'}
G[13573]={'04510'}
G[13578]={'045250'}
G[13579]={'04510'}
G[13581]={'04575'}
G[13583]={'04575'}
G[13587]={'04575'}
G[13588]={'045250'}
G[13589]={'045150'}
G[13590]={'045250'}
G[13591]={'045350'}
G[13592]={'048250','446250'}
G[13593]={'04810'}
G[13594]={'045250'}
G[13595]={'045250'}
G[13596]={'045250'}
G[13598]={'045250'}
G[13599]={'045150'}
G[13600]={'048250','446250'}
G[13601]={'04525'}
G[13602]={'045250'}
G[13603]={'048250','446250'}
G[13605]={'02F350','045350'}
G[13612]={'43D250','41C125','42862','42B62','46462'}
G[13613]={'43D250','41C125','42862','42B62','46462'}
G[13615]={'43D250','41C125','42862','42B62','46462'}
G[13616]={'048250','446250'}
G[13617]={'04510'}
G[13618]={'43D250','41C125','42862','42B62','46462'}
G[13619]={'43D250','41C125','42862','42B62','46462'}
G[13620]={'43D10','41C5','4282','42B2','4642'}
G[13621]={'43D350','41C175','42887','42B87','46487'}
G[13623]={'04525'}
G[13624]={'045250'}
G[13625]={'446250'}
G[13626]={'045250'}
G[13628]={'43D250'}
G[13630]={'045250'}
G[13632]={'045250'}
G[13633]={'452250'}
G[13634]={'452250'}
G[13635]={'02F150'}
G[13636]={'02F150'}
G[13639]={'02F150'}
G[13640]={'43D250'}
G[13641]={'452250'}
G[13642]={'045250'}
G[13643]={'452250'}
G[13644]={'045350'}
G[13645]={'04525'}
G[13646]={'04510'}
G[13647]={'02F250'}
G[13650]={'02F250'}
G[13651]={'43D250'}
G[13653]={'43D150'}
G[13655]={'02F250'}
G[13656]={'02F250'}
G[13657]={'02F250'}
G[13658]={'02F250'}
G[13659]={'02F250'}
G[13660]={'02F250'}
G[13661]={'02F350'}
G[13662]={'03B15'}
G[13663]={'452250'}
G[13664]={'452350'}
G[13665]={'048250','446250'}
G[13666]={'446250'}
G[13667]={'44610'}
G[13668]={'46410'}
G[13669]={'446250'}
G[13670]={'446250'}
G[13671]={'446250'}
G[13672]={'44610'}
G[13673]={'464250'}
G[13674]={'464250'}
G[13675]={'464250'}
G[13676]={'464250'}
G[13677]={'464250'}
G[13678]={'46410'}
G[13679]={'446250'}
G[13680]={'464250'}
G[13682]={'452250','446250'}
G[13683]={'3A2250'}
G[13684]={'04810','44610'}
G[13685]={'02F10','44610'}
G[13688]={'03610','44610'}
G[13689]={'04510','44610'}
G[13690]={'3A210','44610'}
G[13691]={'04C10','46410'}
G[13693]={'21210','46410'}
G[13694]={'05110','46410'}
G[13695]={'04410','46410'}
G[13696]={'38F10','46410'}
G[13697]={'04C250','464250'}
G[13698]={'045350'}
G[13699]={'048250','446250'}
G[13702]={'452350'}
G[13703]={'02F10'}
G[13704]={'03610'}
G[13705]={'3A210'}
G[13706]={'04510'}
G[13707]={'04C10'}
G[13708]={'21210'}
G[13709]={'05110'}
G[13710]={'04410'}
G[13711]={'38F10'}
G[13712]={'43D150'}
G[13713]={'02F250','446250'}
G[13714]={'02F250','446250'}
G[13715]={'036250','446250'}
G[13716]={'3A2250','446250'}
G[13717]={'045250','446250'}
G[13718]={'048250','446250'}
G[13719]={'212250','464250'}
G[13720]={'051250','464250'}
G[13721]={'044250','464250'}
G[13722]={'048250','464250'}
G[13723]={'036250','446250'}
G[13724]={'3A2250','446250'}
G[13725]={'045250','446250'}
G[13726]={'04C250','464250'}
G[13727]={'212250','464250'}
G[13728]={'051250','464250'}
G[13729]={'044250','464250'}
G[13730]={'43D250'}
G[13731]={'38F250','464250'}
G[13732]={'452350'}
G[13733]={'452350'}
G[13734]={'452350'}
G[13735]={'452350'}
G[13736]={'452350'}
G[13737]={'452350'}
G[13738]={'452350'}
G[13739]={'452350'}
G[13740]={'452350'}
G[13741]={'02F250','446250'}
G[13742]={'02F250','446250'}
G[13743]={'02F250','446250'}
G[13744]={'02F250','446250'}
G[13745]={'02F250','446250'}
G[13746]={'036250','446250'}
G[13747]={'036250','446250'}
G[13748]={'036250','446250'}
G[13749]={'036250','446250'}
G[13750]={'036250','446250'}
G[13751]={'43D25'}
G[13752]={'3A2250','446250'}
G[13753]={'3A2250','446250'}
G[13754]={'3A2250','446250'}
G[13755]={'3A2250','446250'}
G[13756]={'3A2250','446250'}
G[13757]={'045250','446250'}
G[13758]={'045250','446250'}
G[13759]={'045250','446250'}
G[13760]={'045250','446250'}
G[13761]={'045250','446250'}
G[13762]={'04C250','464250'}
G[13763]={'04C250','464250'}
G[13764]={'04C250','464250'}
G[13765]={'04C250','464250'}
G[13766]={'045250'}
G[13767]={'04C250','464250'}
G[13768]={'212250','464250'}
G[13769]={'212250','464250'}
G[13770]={'212250','464250'}
G[13771]={'212250','464250'}
G[13772]={'212250','464250'}
G[13773]={'051250','464250'}
G[13774]={'051250','464250'}
G[13775]={'051250','464250'}
G[13776]={'051250','464250'}
G[13777]={'051250','464250'}
G[13778]={'044250','464250'}
G[13779]={'044250','464250'}
G[13780]={'044250','464250'}
G[13781]={'044250','464250'}
G[13782]={'044250','464250'}
G[13783]={'38F250','464250'}
G[13784]={'38F250','464250'}
G[13785]={'38F250','464250'}
G[13786]={'38F250','464250'}
G[13787]={'38F250','464250'}
G[13788]={'44A250','446250'}
G[13789]={'452250','446250'}
G[13790]={'452250','446250'}
G[13791]={'44A250','446250'}
G[13792]={'045250'}
G[13793]={'44A250','446250'}
G[13794]={'45210'}
G[13795]={'44A10'}
G[13796]={'045350'}
G[13797]={'43D150'}
G[13801]={'43D250'}
G[13803]={'43D75'}
G[13805]={'43D250'}
G[13806]={'43D250'}
G[13808]={'43D75'}
G[13809]={'452250','464250'}
G[13810]={'452250','464250'}
G[13811]={'452250','464250'}
G[13812]={'44A250','464250'}
G[13813]={'44A250','464250'}
G[13814]={'44A250','464250'}
G[13815]={'43D250'}
G[13828]={'44675'}
G[13829]={'46475'}
G[13830]={'442250'}
G[13831]={'045250'}
G[13832]={'442250'}
G[13833]={'442250'}
G[13834]={'442250'}
G[13835]={'44675'}
G[13836]={'442250'}
G[13837]={'44675'}
G[13838]={'46475'}
G[13839]={'46475'}
G[13841]={'43D25'}
G[13844]={'045250'}
G[13845]={'442250'}
G[13846]={'452100'}
G[13847]={'048250','446250'}
G[13848]={'43D150'}
G[13849]={'045250'}
G[13851]={'02F250','446250'}
G[13852]={'036250','446250'}
G[13853]={'045350'}
G[13854]={'3A2250','446250'}
G[13855]={'045250','446250'}
G[13856]={'04C250','464250'}
G[13857]={'212250','464250'}
G[13858]={'051250','464250'}
G[13859]={'38F250','464250'}
G[13860]={'044250','464250'}
G[13861]={'452250','446250'}
G[13862]={'452250','464250'}
G[13863]={'44A250','464250'}
G[13864]={'44A250','446250'}
G[13865]={'43D250'}
G[13867]={'045250'}
G[13868]={'045250'}
G[13869]={'045250'}
G[13870]={'43D25'}
G[13871]={'43D250'}
G[13872]={'46E10'}
G[13873]={'43D150'}
G[13874]={'46E250'}
G[13875]={'43D250'}
G[13883]={'43D250'}
G[13890]={'43D250'}
G[13892]={'045250'}
G[13893]={'04525'}
G[13896]={'02F75'}
G[13897]={'045500'}
G[13898]={'045250'}
G[13900]={'045500'}
G[13901]={'43D250'}
G[13913]={'045250','036250'}
G[13919]={'04575'}
G[13920]={'43D250'}
G[13921]={'04525'}
G[13922]={'045250'}
G[13923]={'43D10'}
G[13924]={'045350'}
G[13928]={'045250'}
G[13935]={'045350'}
G[13936]={'43D10'}
G[13942]={'43D250'}
G[13943]={'43D250'}
G[13944]={'43D25'}
G[13945]={'045250'}
G[13946]={'045250'}
G[13947]={'43D250'}
G[13949]={'04C250'}
G[13953]={'04575'}
G[13962]={'43D250'}
G[13964]={'04525'}
G[13965]={'04525'}
G[13967]={'43D250','41C125','42862','42B62','46462'}
G[13974]={'43D150'}
G[13976]={'045250'}
G[13977]={'43D10'}
G[13979]={'045250'}
G[13980]={'43D250'}
G[13981]={'045250'}
G[13982]={'045250'}
G[13983]={'43D250'}
G[13985]={'045250'}
G[13987]={'045350'}
G[13989]={'045350'}
G[14001]={'46D250'}
G[14006]={'46D350'}
G[14007]={'46D75'}
G[14008]={'46D75'}
G[14009]={'46D75'}
G[14010]={'46D75'}
G[14011]={'46D75'}
G[14012]={'46D75'}
G[14013]={'46D75'}
G[14014]={'46D250'}
G[14016]={'452250'}
G[14017]={'452250'}
G[14018]={'04525'}
G[14019]={'46D250'}
G[14021]={'46D250'}
G[14022]={'04810','1D52','02F2','0362','0452','3A22','46E2'}
G[14023]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[14024]={'02F75','1D518','03618','04518','04818','3A218','46E18'}
G[14028]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[14030]={'04575','1D518','02F18','03618','04818','3A218','46E18'}
G[14031]={'46D250'}
G[14033]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[14035]={'04575','1D518','02F18','03618','04818','3A218','46E18'}
G[14036]={'04410'}
G[14037]={'04475'}
G[14039]={'045250'}
G[14040]={'04C75'}
G[14041]={'05175'}
G[14043]={'04C75'}
G[14044]={'04475'}
G[14047]={'04C75'}
G[14048]={'02F150','1D537','03637','04537','04837','3A237','46E37'}
G[14051]={'02F150','1D537','03637','04537','04837','3A237','46E37'}
G[14053]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[14054]={'045150','1D537','02F37','03637','04837','3A237','46E37'}
G[14055]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[14058]={'044150'}
G[14059]={'044150'}
G[14060]={'051150'}
G[14061]={'04C150'}
G[14062]={'04C150'}
G[14069]={'46D250'}
G[14070]={'46D250'}
G[14071]={'46D250'}
G[14075]={'46D250'}
G[14078]={'46E250'}
G[14091]={'46E250'}
G[14093]={'46E350'}
G[14094]={'46E350','1D587','02F87','03687','04587','04887','3A287'}
G[14098]={'46E350','1D587','02F87','03687','04587','04887','3A287'}
G[14099]={'46E250'}
G[14109]={'46D250'}
G[14110]={'46D250'}
G[14113]={'46D250'}
G[14115]={'46D250'}
G[14116]={'46D250'}
G[14117]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[14118]={'04C250'}
G[14120]={'46D10'}
G[14121]={'46D250'}
G[14122]={'46D10'}
G[14123]={'46D250'}
G[14124]={'46D250'}
G[14125]={'46D250'}
G[14126]={'46D350'}
G[14127]={'04C150'}
G[14128]={'38F150'}
G[14129]={'46D250'}
G[14134]={'46D250'}
G[14135]={'46D250'}
G[14138]={'46D10'}
G[14146]={'46D250'}
G[14151]={'442250'}
G[14153]={'46D250','46D75'}
G[14154]={'46E250'}
G[14155]={'46D350'}
G[14157]={'46E10'}
G[14161]={'46D250'}
G[14162]={'46D25'}
G[14165]={'46D250'}
G[14184]={'38F25','0436','0446','04C6','0516','2126','46D6','5486'}
G[14188]={'38F10','0432','0442','04C2','0512','2122','46D2','5482'}
G[14189]={'38F75','04318','04418','04C18','05118','21218','46D18','54818'}
G[14190]={'46D250'}
G[14191]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[14193]={'048250'}
G[14194]={'46D250'}
G[14195]={'38F150','04337','04437','04C37','05137','21237','46D37','54837'}
G[14196]={'38F250'}
G[14197]={'46D250'}
G[14201]={'38F250'}
G[14202]={'46D250'}
G[14203]={'442250'}
G[14204]={'46E250'}
G[14209]={'46D150'}
G[14212]={'46E150'}
G[14214]={'46E25'}
G[14215]={'38F250'}
G[14216]={'38F250'}
G[14218]={'46E250'}
G[14221]={'46E75'}
G[14222]={'46E250'}
G[14233]={'46D10'}
G[14234]={'46D10','04C10'}
G[14235]={'46D10','04C10'}
G[14236]={'46D250','04C250'}
G[14237]={'46D10','04C10'}
G[14238]={'46D250','04C250'}
G[14239]={'46D10'}
G[14240]={'46D10','04C10'}
G[14241]={'46D250','04C250'}
G[14242]={'46D75','04C75'}
G[14243]={'46D350','04C350'}
G[14244]={'46D10'}
G[14245]={'46D10'}
G[14248]={'46D10'}
G[14257]={'261250'}
G[14258]={'46D250'}
G[14260]={'26175'}
G[14261]={'46D250'}
G[14262]={'04C250'}
G[14265]={'46E250'}
G[14266]={'46E75'}
G[14268]={'261250'}
G[14269]={'46E250'}
G[14271]={'04C150'}
G[14272]={'46E75'}
G[14273]={'46E250'}
G[14274]={'46E75'}
G[14275]={'46E250'}
G[14276]={'46E75'}
G[14277]={'46E250'}
G[14278]={'46E250'}
G[14279]={'46E75'}
G[14280]={'46E250'}
G[14281]={'46E75'}
G[14282]={'261250'}
G[14283]={'46E75'}
G[14285]={'46E25'}
G[14286]={'46E25'}
G[14287]={'46E25'}
G[14288]={'46E25'}
G[14289]={'46E25'}
G[14290]={'46E25'}
G[14291]={'46E25'}
G[14292]={'26175'}
G[14293]={'46E75'}
G[14294]={'46E10'}
G[14295]={'04C350'}
G[14297]={'46D250'}
G[14301]={'261250'}
G[14302]={'26110'}
G[14303]={'46D10','04C10'}
G[14304]={'261250'}
G[14305]={'261250'}
G[14306]={'261250'}
G[14307]={'261250'}
G[14308]={'46D250'}
G[14309]={'261250'}
G[14310]={'46D250'}
G[14311]={'261250'}
G[14312]={'26110'}
G[14313]={'46E25'}
G[14314]={'261250'}
G[14316]={'261250'}
G[14320]={'46E250'}
G[14321]={'46E250'}
G[14322]={'46D250'}
G[14326]={'46D10','04C10'}
G[14332]={'261250'}
G[14336]={'46E75'}
G[14343]={'26175'}
G[14346]={'261250'}
G[14347]={'46E250'}
G[14348]={'46E250'}
G[14360]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[14366]={'46E150'}
G[14367]={'46E75'}
G[14368]={'46E250'}
G[14369]={'46E250'}
G[14370]={'46D250'}
G[14371]={'46D250'}
G[14374]={'051350'}
G[14375]={'46E250'}
G[14377]={'46D250'}
G[14381]={'261250'}
G[14382]={'46E250'}
G[14383]={'46D250'}
G[14385]={'46D250'}
G[14386]={'46E150'}
G[14388]={'46D250'}
G[14394]={'261350'}
G[14395]={'46E250'}
G[14396]={'46E75'}
G[14397]={'46E25'}
G[14398]={'46E75'}
G[14399]={'46E150'}
G[14400]={'46E75'}
G[14401]={'46E150'}
G[14402]={'46E75'}
G[14403]={'46E75'}
G[14404]={'46E150'}
G[14405]={'46E75'}
G[14406]={'46E10'}
G[14407]={'46D75'}
G[14412]={'46E150'}
G[14416]={'46E150'}
G[14423]={'46D250'}
G[14424]={'46D150'}
G[14430]={'38F150'}
G[14431]={'04C250'}
G[14432]={'04C250'}
G[14433]={'04C250'}
G[14435]={'04C350'}
G[14438]={'051250'}
G[14445]={'46D10'}
G[14452]={'05110','0432','0442','04C2','2122','38F2','46D2','5482'}
G[14455]={'051250','04362','04462','04C62','21262','38F62','46D62'}
G[14456]={'051250','04362','04462','04C62','21262','38F62','46D62'}
G[14458]={'05125','0436','0446','04C6','2126','38F6','46D6'}
G[14459]={'051250','04362','04462','04C62','21262','38F62','46D62'}
G[14460]={'051350','04387','04487','04C87','21287','38F87','46D87'}
G[14461]={'051250','04362','04462','04C62','21262','38F62','46D62'}
G[14462]={'46D10'}
G[14464]={'04C250'}
G[14465]={'46E25'}
G[14466]={'46E25'}
G[14467]={'46E25'}
G[14468]={'46D75'}
G[14469]={'46D250'}
G[14470]={'46D250'}
G[14471]={'46D250'}
G[14472]={'46D250'}
G[14473]={'46D250'}
G[14475]={'46D150'}
G[14476]={'46D250'}
G[14477]={'04C250'}
G[14478]={'46D75'}
G[14479]={'46D150'}
G[14480]={'46D250'}
G[14482]={'46F250'}
G[14484]={'46D250'}
G[14485]={'46D250'}
G[14486]={'46D250'}
G[14487]={'46D250'}
G[20440]={'051250'}
G[20441]={'051150'}
G[23733]={'051150'}
G[24215]={'051150'}
G[24428]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[24429]={'04C500'}
G[24430]={'46D250'}
G[24431]={'442250'}
G[24432]={'46F250'}
G[24433]={'04C250'}
G[24435]={'46D250'}
G[24436]={'46D250'}
G[24437]={'46D250'}
G[24438]={'46E250'}
G[24439]={'04C350'}
G[24440]={'051250'}
G[24441]={'051250'}
G[24442]={'452250'}
G[24448]={'46D250'}
G[24449]={'46D500'}
G[24452]={'46D350'}
G[24453]={'46D75'}
G[24455]={'46D75'}
G[24456]={'051250'}
G[24457]={'05125'}
G[24458]={'46D150'}
G[24468]={'46E250'}
G[24469]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24470]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24471]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24472]={'46E250'}
G[24473]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[24474]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[24475]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[24477]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[24483]={'46E75'}
G[24484]={'46E250'}
G[24486]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[24487]={'02F10','1D52','0362','0452','0482','3A22','46E2'}
G[24488]={'46D250'}
G[24489]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[24490]={'02F10','1D52','0362','0452','0482','3A22','46E2'}
G[24491]={'02F10','03610','1D52','0362','0452','0482','3A22','46E2','02F2'}
G[24492]={'02F150','036150','1D537','03637','04537','04837','3A237','46E37','02F37'}
G[24493]={'02F10','1D52','0362','0452','0482','3A22','46E2'}
G[24494]={'02F75'}
G[24495]={'46E250'}
G[24496]={'02F75'}
G[24497]={'46D75'}
G[24498]={'41A500'}
G[24499]={'41A500'}
G[24500]={'41A500'}
G[24501]={'46E250'}
G[24502]={'46D250'}
G[24503]={'46D250'}
G[24504]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24505]={'05110','0432','0442','04C2','2122','38F2','46D2','5482'}
G[24506]={'43D25'}
G[24507]={'43D500'}
G[24511]={'43D500'}
G[24512]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[24513]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[24514]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24515]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24517]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[24518]={'04C150'}
G[24519]={'04C250'}
G[24520]={'46D10'}
G[24523]={'051250'}
G[24524]={'051350'}
G[24525]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24526]={'02F75'}
G[24527]={'02F75'}
G[24528]={'02F75'}
G[24529]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24530]={'02F75'}
G[24531]={'02F75'}
G[24532]={'02F75','1D518','03618','04518','04818','3A218','46E18'}
G[24533]={'02F75'}
G[24534]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24539]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24542]={'261250'}
G[24543]={'051250'}
G[24545]={'484350'}
G[24546]={'051250'}
G[24547]={'484350'}
G[24548]={'484350'}
G[24549]={'4843000'}
G[24550]={'05175'}
G[24551]={'04C250'}
G[24552]={'051250'}
G[24553]={'446500'}
G[24564]={'464500'}
G[24567]={'46D10'}
G[24569]={'04C250'}
G[24572]={'04C250'}
G[24573]={'051250'}
G[24575]={'46E150'}
G[24577]={'04C75'}
G[24578]={'04575'}
G[24579]={'442250'}
G[24580]={'442250'}
G[24581]={'442250'}
G[24582]={'442250'}
G[24583]={'442250'}
G[24584]={'442250'}
G[24585]={'442250'}
G[24586]={'442250'}
G[24587]={'442250'}
G[24588]={'442250'}
G[24589]={'442250'}
G[24590]={'442250'}
G[24591]={'04C250'}
G[24592]={'46E250'}
G[24593]={'46E250'}
G[24594]={'464500'}
G[24595]={'446500'}
G[24598]={'464500'}
G[24602]={'46E250'}
G[24607]={'21275'}
G[24616]={'46E250'}
G[24617]={'46E250'}
G[24618]={'04C250'}
G[24619]={'044250'}
G[24620]={'044250'}
G[24621]={'044350'}
G[24622]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24623]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24624]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24625]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[24626]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[24627]={'46E250'}
G[24628]={'045150'}
G[24631]={'051250'}
G[24632]={'05175'}
G[24634]={'04C250'}
G[24637]={'04C350'}
G[24639]={'212250'}
G[24640]={'212150'}
G[24641]={'212250'}
G[24642]={'212250'}
G[24643]={'21275'}
G[24646]={'46E150'}
G[24654]={'04C250'}
G[24667]={'46F75'}
G[24671]={'46D250'}
G[24672]={'46E150'}
G[24673]={'46E75'}
G[24674]={'46E150'}
G[24675]={'46E350'}
G[24676]={'46E250'}
G[24677]={'46E75'}
G[24678]={'46E250'}
G[24679]={'46E250'}
G[24680]={'46E10'}
G[24681]={'46E350'}
G[24684]={'051250'}
G[24685]={'051250'}
G[24686]={'261250'}
G[24687]={'261250'}
G[24689]={'26110'}
G[24710]={'41A500'}
G[24712]={'43D500'}
G[24719]={'261250'}
G[24737]={'171250'}
G[24741]={'46D250'}
G[24743]={'484250'}
G[24744]={'46D350'}
G[24747]={'051350'}
G[24748]={'4843000'}
G[24749]={'484350'}
G[24750]={'21275'}
G[24751]={'212250'}
G[24752]={'212150'}
G[24753]={'212250'}
G[24754]={'212250'}
G[24755]={'21275'}
G[24756]={'484350'}
G[24757]={'484350'}
G[24758]={'21275'}
G[24759]={'212250'}
G[24760]={'212150'}
G[24761]={'212250'}
G[24762]={'212250'}
G[24763]={'21275'}
G[24764]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24765]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24766]={'212150','04337','04437','04C37','05137','38F37','46D37','54837'}
G[24767]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24768]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24769]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24770]={'21275'}
G[24771]={'212250'}
G[24772]={'212150'}
G[24773]={'212250'}
G[24774]={'212250'}
G[24775]={'21275'}
G[24776]={'21275'}
G[24777]={'212250'}
G[24778]={'212150'}
G[24779]={'212250'}
G[24780]={'212250'}
G[24781]={'21275'}
G[24782]={'21275'}
G[24783]={'212250'}
G[24784]={'212150'}
G[24785]={'212250'}
G[24786]={'212250'}
G[24787]={'21275'}
G[24802]={'43D500'}
G[24803]={'4312500'}
G[24806]={'43175'}
G[24812]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[24813]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[24814]={'212500','212250','04362','04462','04C62','05162','38F62','46D62'}
G[24815]={'484250'}
G[24816]={'46D250'}
G[24817]={'46D350'}
G[24823]={'484250'}
G[24825]={'484250'}
G[24826]={'484250'}
G[24827]={'484250'}
G[24828]={'484250'}
G[24829]={'484250'}
G[24830]={'484250'}
G[24831]={'484250'}
G[24832]={'484250'}
G[24833]={'484250'}
G[24834]={'484250'}
G[24835]={'484250'}
G[24852]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[24854]={'3AE10'}
G[24855]={'261250'}
G[24856]={'46D10'}
G[24858]={'46D250'}
G[24859]={'46D250'}
G[24861]={'05125'}
G[24862]={'048250'}
G[24863]={'048250'}
G[24864]={'46D250'}
G[24868]={'46D350'}
G[24897]={'46D10'}
G[24901]={'46D250'}
G[24902]={'46E350'}
G[24903]={'46E150'}
G[24904]={'46E500'}
G[24906]={'46D250'}
G[24910]={'46D250'}
G[24912]={'484250'}
G[24913]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[24914]={'484250'}
G[24915]={'484250'}
G[24916]={'484250'}
G[24917]={'484250'}
G[24918]={'484250'}
G[24919]={'484250'}
G[24920]={'46E350'}
G[24921]={'04875'}
G[24924]={'46D10'}
G[24925]={'46D250'}
G[24928]={'46D250'}
G[24929]={'46D250'}
G[24930]={'46E150'}
G[24932]={'1D6250','171250','241250','015250'}
G[24933]={'1D6250','171250','241250','015250'}
G[24934]={'048250'}
G[24937]={'46D10'}
G[24938]={'04875'}
G[24939]={'048250'}
G[24940]={'46D10'}
G[24941]={'048250'}
G[24942]={'46D250'}
G[24943]={'048250'}
G[24944]={'46E250'}
G[24945]={'46D250'}
G[24946]={'46D250'}
G[24948]={'048250'}
G[24949]={'46D250'}
G[24951]={'1D6250','171250','241250','015250'}
G[24952]={'46D10'}
G[24953]={'1D6350','171350','241350','015350'}
G[24954]={'46D250'}
G[24955]={'46D250'}
G[24956]={'46E350'}
G[24957]={'46D250'}
G[24958]={'46D350','04387','04487','04C87','05187','21287','38F87'}
G[24959]={'04410','0432','04C2','0512','2122','38F2','46D2'}
G[24960]={'044150','04337','04C37','05137','21237','38F37','46D37'}
G[24961]={'044150','04337','04C37','05137','21237','38F37','46D37'}
G[24962]={'04475'}
G[24963]={'46D250'}
G[24964]={'04475'}
G[24965]={'04475'}
G[24966]={'04475'}
G[24967]={'04475'}
G[24968]={'04475'}
G[24969]={'04475'}
G[24970]={'04410'}
G[24971]={'044500'}
G[24972]={'044150'}
G[24973]={'044350'}
G[24974]={'044250'}
G[24975]={'044250'}
G[24976]={'044250'}
G[24977]={'04425'}
G[24978]={'044250'}
G[24979]={'044350'}
G[24980]={'044250'}
G[24981]={'044250'}
G[24982]={'04410'}
G[24983]={'04425'}
G[24988]={'044250'}
G[24989]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[24990]={'044250'}
G[24991]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[24992]={'04475'}
G[24993]={'044250'}
G[24994]={'044250'}
G[24995]={'044250'}
G[24996]={'044250'}
G[24997]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[24998]={'044250'}
G[24999]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[25000]={'048250'}
G[25001]={'46D250'}
G[25002]={'048250'}
G[25003]={'044250'}
G[25004]={'044350'}
G[25005]={'04425'}
G[25006]={'044350'}
G[25007]={'04425','0436','04C6','0516','2126','38F6','46D6','5486'}
G[25008]={'048250'}
G[25009]={'044250'}
G[25010]={'04475'}
G[25011]={'04410'}
G[25012]={'044150'}
G[25013]={'044250'}
G[25015]={'048250'}
G[25022]={'048250'}
G[25023]={'46D10','04C10'}
G[25024]={'46D250','04C250'}
G[25027]={'048350'}
G[25028]={'261250'}
G[25029]={'044250'}
G[25030]={'04475'}
G[25031]={'04425'}
G[25034]={'04875'}
G[25035]={'21225','212250','04362','04462','04C62','05162','38F62','46D62'}
G[25036]={'048150'}
G[25037]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[25038]={'04475'}
G[25039]={'04475'}
G[25041]={'048250'}
G[25042]={'048250'}
G[25043]={'048250'}
G[25044]={'048250'}
G[25045]={'048250'}
G[25046]={'044350'}
G[25048]={'036250'}
G[25049]={'036250'}
G[25050]={'036250'}
G[25051]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25054]={'036250'}
G[25056]={'044250'}
G[25057]={'048250'}
G[25058]={'46D250'}
G[25059]={'048250'}
G[25062]={'036250'}
G[25064]={'21210','0432','0442','04C2','0512','38F2','46D2','5482'}
G[25065]={'036250'}
G[25066]={'46D350'}
G[25072]={'1D6250','171250','241250','015250'}
G[25073]={'21210','0432','0442','04C2','0512','38F2','46D2'}
G[25074]={'04875'}
G[25075]={'036250'}
G[25079]={'036250'}
G[25080]={'036250'}
G[25081]={'048350'}
G[25082]={'048250'}
G[25086]={'46F75'}
G[25087]={'02F75'}
G[25089]={'04475'}
G[25090]={'044150'}
G[25093]={'46D250','04C250'}
G[25098]={'46D10','04C10'}
G[25099]={'46D10','04C10'}
G[25100]={'46D10'}
G[25102]={'02F250'}
G[25104]={'02F75'}
G[25106]={'02F250'}
G[25108]={'02F250'}
G[25109]={'46D75'}
G[25110]={'46D250'}
G[25111]={'171250','1D6125','241125','015125'}
G[25112]={'171250','1D6125','241125','015125'}
G[25115]={'171250','1D6125','241125','015125'}
G[25118]={'02F250'}
G[25120]={'02F10'}
G[25121]={'03675'}
G[25122]={'46D250'}
G[25123]={'46D250'}
G[25125]={'46D25'}
G[25126]={'04C250'}
G[25127]={'04C250'}
G[25128]={'04C25','0436','0446','0516','2126','38F6','46D6','5486','21225'}
G[25129]={'04C250','212250'}
G[25130]={'04C25','21225','0436','0446','04C6','0516','38F6','46D6','5486'}
G[25131]={'04C350'}
G[25132]={'04C500'}
G[25133]={'04C75'}
G[25134]={'04C350'}
G[25135]={'04C350'}
G[25136]={'04C500'}
G[25138]={'21275'}
G[25139]={'04C75'}
G[25141]={'04C75'}
G[25143]={'04C75'}
G[25145]={'04C75'}
G[25147]={'04C75'}
G[25149]={'21275'}
G[25151]={'02F250'}
G[25152]={'04C75'}
G[25153]={'02F350'}
G[25163]={'02F25'}
G[25164]={'46F350'}
G[25165]={'04C250','212250'}
G[25167]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','212350','04387'}
G[25168]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','212350','04387'}
G[25169]={'04C350','04387','04487','05187','21287','38F87','46D87','54887','212500','043125'}
G[25170]={'04C250','212250','04362','04462','05162','21262','38F62','46D62'}
G[25171]={'04C150','04337','04437','05137','21237','38F37','46D37','54837','212150','04337'}
G[25172]={'04C250'}
G[25173]={'04C250','212250'}
G[25174]={'02F75'}
G[25175]={'02F75'}
G[25176]={'04C250','46D250'}
G[25177]={'04C250','212250'}
G[25178]={'04C250','46D250'}
G[25179]={'04C250','212250'}
G[25182]={'02F250'}
G[25183]={'02F350'}
G[25184]={'46D10'}
G[25185]={'02F75'}
G[25186]={'048350'}
G[25188]={'04C350'}
G[25189]={'04C250'}
G[25190]={'04C250'}
G[25191]={'03675'}
G[25192]={'04C250'}
G[25193]={'04C250'}
G[25194]={'212250'}
G[25195]={'212350'}
G[25196]={'04C25'}
G[25200]={'46D250'}
G[25201]={'46D250'}
G[25202]={'46D350'}
G[25203]={'46D350'}
G[25204]={'46D250'}
G[25205]={'04C250'}
G[25206]={'04C350'}
G[25207]={'46D250'}
G[25209]={'04C250'}
G[25210]={'051250'}
G[25211]={'02F250'}
G[25213]={'46D10'}
G[25214]={'46D250'}
G[25215]={'46F250'}
G[25217]={'46F250'}
G[25218]={'46F250'}
G[25219]={'46F250'}
G[25220]={'46F250'}
G[25221]={'46F250'}
G[25223]={'486250'}
G[25224]={'486250'}
G[25227]={'04C10','0432','0442','0512','2122','38F2','46D2','5482','46D10','0432'}
G[25230]={'051250'}
G[25232]={'04C250','212250'}
G[25233]={'486250'}
G[25234]={'486250'}
G[25235]={'048250'}
G[25236]={'04C250'}
G[25237]={'051250'}
G[25239]={'484250'}
G[25240]={'484250'}
G[25241]={'051250'}
G[25242]={'484250'}
G[25243]={'46D350'}
G[25244]={'46D350'}
G[25250]={'051250'}
G[25251]={'46D500'}
G[25252]={'04C250'}
G[25255]={'486250'}
G[25256]={'04C10'}
G[25257]={'04C150'}
G[25258]={'04C250'}
G[25259]={'04C350'}
G[25260]={'04C250'}
G[25261]={'04C10','21210'}
G[25262]={'04C250','212250'}
G[25263]={'04C75','21275'}
G[25264]={'04C75','21275'}
G[25265]={'46D25','04C25'}
G[25266]={'46D25','04C25'}
G[25267]={'46D350','04C350'}
G[25268]={'48610'}
G[25269]={'48610'}
G[25270]={'486250'}
G[25271]={'486250'}
G[25272]={'486250'}
G[25273]={'486250'}
G[25274]={'486250'}
G[25275]={'46D10','04C10'}
G[25276]={'48675'}
G[25277]={'486250'}
G[25278]={'486250'}
G[25279]={'48610'}
G[25280]={'48610'}
G[25281]={'46F250'}
G[25284]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25291]={'48675'}
G[25292]={'05175'}
G[25294]={'486250'}
G[25296]={'486250'}
G[25297]={'486250'}
G[25298]={'486250'}
G[25299]={'486250'}
G[25300]={'48675'}
G[25301]={'48675'}
G[25303]={'486250'}
G[25308]={'486250'}
G[25309]={'486250'}
G[25310]={'486350'}
G[25311]={'486250'}
G[25312]={'48675'}
G[25314]={'486250'}
G[25315]={'486500'}
G[25316]={'486150'}
G[25317]={'486250'}
G[25319]={'486250'}
G[25320]={'48675'}
G[25321]={'486150'}
G[25323]={'486250'}
G[25324]={'48675'}
G[25325]={'486150'}
G[25328]={'486250'}
G[25329]={'04C350'}
G[25330]={'486150'}
G[25332]={'486250'}
G[25333]={'46E350'}
G[25334]={'46F150'}
G[25336]={'212250'}
G[25337]={'212250'}
G[25338]={'212250'}
G[25339]={'051150'}
G[25340]={'051350'}
G[25341]={'04C250'}
G[25345]={'212250'}
G[25346]={'212250'}
G[25352]={'486250'}
G[25353]={'486250'}
G[25354]={'486250'}
G[25355]={'486250'}
G[25356]={'05125'}
G[25357]={'048250'}
G[25360]={'46F250'}
G[25361]={'04C250'}
G[25362]={'04C250'}
G[25363]={'051150'}
G[25364]={'051150'}
G[25365]={'05175'}
G[25366]={'051250'}
G[25370]={'486250'}
G[25371]={'46F350'}
G[25372]={'486350'}
G[25373]={'051150'}
G[25374]={'051350'}
G[25375]={'051150'}
G[25381]={'486250'}
G[25382]={'486250'}
G[25383]={'051350'}
G[25385]={'486250'}
G[25386]={'04C75'}
G[25387]={'051150'}
G[25391]={'212250'}
G[25392]={'486250'}
G[25394]={'045250'}
G[25395]={'02F250'}
G[25396]={'045250'}
G[25397]={'045250'}
G[25398]={'045350'}
G[25399]={'045250'}
G[25400]={'045250'}
G[25401]={'46E250'}
G[25404]={'486150'}
G[25406]={'045250'}
G[25407]={'045250'}
G[25408]={'486250'}
G[25409]={'045250'}
G[25410]={'045250'}
G[25411]={'486150'}
G[25412]={'486250'}
G[25420]={'02F250'}
G[25421]={'02F350'}
G[25424]={'486150'}
G[25426]={'045250'}
G[25427]={'46E150'}
G[25428]={'486250'}
G[25429]={'045250'}
G[25430]={'48675'}
G[25431]={'045350'}
G[25432]={'045150'}
G[25433]={'045350'}
G[25434]={'045250'}
G[25436]={'045250'}
G[25438]={'045350'}
G[25439]={'46F250'}
G[25440]={'46F250'}
G[25441]={'46F250'}
G[25442]={'46F250'}
G[25447]={'045250'}
G[25448]={'045150'}
G[25449]={'045250'}
G[25450]={'045250'}
G[25451]={'045250'}
G[25452]={'051250'}
G[25453]={'051250'}
G[25454]={'051250'}
G[25458]={'045350'}
G[25460]={'486250'}
G[25462]={'486250'}
G[25464]={'486350'}
G[25468]={'045250'}
G[25469]={'045250'}
G[25471]={'46F10'}
G[25472]={'486250'}
G[25473]={'46D10'}
G[25475]={'015250','057-250'}
G[25476]={'015350','057-350'}
G[25477]={'46F250'}
G[25478]={'05125'}
G[25479]={'04525'}
G[25481]={'04525'}
G[25486]={'045250'}
G[25487]={'051250'}
G[25488]={'03625'}
G[25489]={'46D25'}
G[25490]={'486250'}
G[25491]={'486250'}
G[25492]={'486250'}
G[25493]={'486250'}
G[25494]={'486250'}
G[25496]={'486350'}
G[25499]={'486250'}
G[25502]={'486250'}
G[25504]={'03625'}
G[25505]={'46D25'}
G[25507]={'486250'}
G[25509]={'486250'}
G[25514]={'486250'}
G[25515]={'036250'}
G[25516]={'46D250'}
G[25517]={'036250'}
G[25518]={'46D250'}
G[25519]={'486250'}
G[25520]={'48610'}
G[25521]={'171250','1D6125','241125','015125'}
G[25522]={'171250','1D6125','241125','015125'}
G[25523]={'486250'}
G[25524]={'036250'}
G[25525]={'486250'}
G[25526]={'46D250'}
G[25531]={'486250'}
G[25532]={'036250'}
G[25533]={'46D250'}
G[25534]={'46D250'}
G[25540]={'46F250'}
G[25541]={'46D250'}
G[25542]={'036250'}
G[25543]={'46D250'}
G[25544]={'486250'}
G[25545]={'048250'}
G[25546]={'048250'}
G[25547]={'048250'}
G[25548]={'486250'}
G[25549]={'486250'}
G[25550]={'486350'}
G[25551]={'486250'}
G[25552]={'486250'}
G[25553]={'486350'}
G[25554]={'486250'}
G[25555]={'486350'}
G[25558]={'048250'}
G[25559]={'02F250'}
G[25560]={'486250'}
G[25561]={'036250'}
G[25562]={'46D250'}
G[25564]={'048250'}
G[25565]={'02F250'}
G[25574]={'486250'}
G[25575]={'486250'}
G[25576]={'486250'}
G[25577]={'486250'}
G[25578]={'486250'}
G[25584]={'48675'}
G[25585]={'036250'}
G[25586]={'46D250'}
G[25588]={'036250'}
G[25589]={'46D250'}
G[25590]={'036250'}
G[25595]={'46F250'}
G[25596]={'46D250'}
G[25597]={'486150'}
G[25599]={'486250'}
G[25600]={'486350'}
G[25601]={'48675'}
G[25607]={'045250','036250'}
G[25608]={'486350'}
G[25609]={'036250'}
G[25610]={'46D250'}
G[25611]={'48625'}
G[25612]={'48625'}
G[25613]={'04510','03610'}
G[25614]={'045250','036250'}
G[25615]={'04510','03610'}
G[25616]={'045250','036250'}
G[25617]={'48625'}
G[25618]={'48625'}
G[25621]={'04525','03625'}
G[25622]={'045250','036250'}
G[25623]={'48625'}
G[25624]={'48625'}
G[25626]={'46F500'}
G[25627]={'036350'}
G[25628]={'46D350'}
G[25630]={'48625'}
G[25640]={'04510','03610'}
G[25641]={'21275'}
G[25642]={'045250','036250'}
G[25644]={'486250'}
G[25645]={'051250'}
G[25646]={'045250','036250'}
G[25647]={'045150','036150'}
G[25648]={'04C10'}
G[25649]={'045150','036150'}
G[25650]={'045150','036150'}
G[25652]={'045350','036350'}
G[25653]={'48610'}
G[25654]={'045350'}
G[25655]={'486250'}
G[25656]={'486250'}
G[25662]={'045250'}
G[25663]={'48675'}
G[25664]={'486250'}
G[25665]={'48610'}
G[25667]={'02F250','036250'}
G[25668]={'02F250','036250'}
G[25669]={'045350'}
G[25671]={'045350'}
G[25673]={'045350'}
G[25674]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25675]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25676]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[25677]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25678]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25679]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[25680]={'04C250','212250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25681]={'04C350','212350','04387','04487','05187','21287','38F87','46D87','54887'}
G[25682]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[25683]={'04C250','38F250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25684]={'38F25','0436','0446','04C6','0516','2126','46D6','5486'}
G[25685]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[25686]={'38F25','0436','0446','04C6','0516','2126','46D6','5486'}
G[25687]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[25688]={'38F500','043125','044125','04C125','051125','212125','46D125','548125'}
G[25689]={'46D25','0436','0446','04C6','0516','2126','38F6','5486'}
G[25690]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[25691]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25692]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25693]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[25694]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[25695]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25696]={'38F75','04318','04418','04C18','05118','21218','46D18'}
G[25697]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[25698]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[25699]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[25701]={'0431000','0441000','04C1000','0511000','2121000','38F1000','46D1000','5481000'}
G[25708]={'1D5350','02F350','036350','045350','048350','3A2350','46E350','549350'}
G[25709]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[25710]={'1D5150','02F150','036150','045150','048150','3A2150','46E150','549150'}
G[25711]={'1D5350','02F350','036350','045350','048350','3A2350','46E350','549350'}
G[25712]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[25713]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[25714]={'1D510','02F10','03610','04510','04810','3A210','46E10','54910'}
G[25715]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[25716]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[25717]={'38F350','04387','04487','04C87','05187','21287','46D87','54887'}
G[25718]={'38F10','0432','0442','04C2','0512','2122','46D2','5482'}
G[25719]={'38F350','04387','04487','04C87','05187','21287','46D87','54887'}
G[25720]={'38F500','043125','044125','04C125','051125','212125','46D125','548125'}
G[25721]={'02F250'}
G[25722]={'02F250'}
G[25723]={'02F250'}
G[25724]={'02F250','036250'}
G[25725]={'02F250'}
G[25726]={'02F250'}
G[25727]={'02F250'}
G[25728]={'045500'}
G[25729]={'036250'}
G[25730]={'02F500'}
G[25731]={'486150'}
G[25733]={'02F250'}
G[25734]={'02F250'}
G[25735]={'02F250'}
G[25736]={'02F250'}
G[25739]={'045250','048250'}
G[25740]={'48610'}
G[25741]={'045250'}
G[25744]={'03625'}
G[25745]={'46D25'}
G[25746]={'486250'}
G[25755]={'46F500'}
G[25756]={'036250'}
G[25757]={'46D250'}
G[25758]={'486250'}
G[25760]={'46F500'}
G[25761]={'486250'}
G[25763]={'48610'}
G[25764]={'486250'}
G[25765]={'04875'}
G[25766]={'045500'}
G[25767]={'045250'}
G[25768]={'04525'}
G[25769]={'04510'}
G[25770]={'02F75'}
G[25774]={'036250'}
G[25775]={'46D250'}
G[25776]={'486250'}
G[25777]={'02F75'}
G[25780]={'02F250'}
G[25790]={'036250'}
G[25791]={'46D250'}
G[25792]={'02F250','036250'}
G[25793]={'04810'}
G[25794]={'46F150'}
G[25795]={'48610'}
G[25796]={'036250'}
G[25797]={'46D250'}
G[25798]={'036250'}
G[25799]={'46D250'}
G[25800]={'048250'}
G[25801]={'048250'}
G[25802]={'04875'}
G[25803]={'04825'}
G[25804]={'04875'}
G[25805]={'048350'}
G[25806]={'048250'}
G[25807]={'48610'}
G[25808]={'048250'}
G[25809]={'048350'}
G[25810]={'48610'}
G[25811]={'048350'}
G[25813]={'036350'}
G[25814]={'46D350'}
G[25817]={'048250'}
G[25818]={'04875'}
G[25819]={'048250'}
G[25821]={'04810'}
G[25822]={'048250'}
G[25823]={'048250'}
G[25825]={'03625'}
G[25826]={'46D25'}
G[25830]={'48610'}
G[25832]={'486250'}
G[25834]={'04810'}
G[25835]={'04525'}
G[25836]={'05125'}
G[25837]={'048350'}
G[25838]={'02F10','03610'}
G[25839]={'02F150','036150'}
G[25840]={'02F250','036250'}
G[25841]={'02F250','036250'}
G[25842]={'486250'}
G[25843]={'48610'}
G[25844]={'04875'}
G[25845]={'04810'}
G[25846]={'04875'}
G[25849]={'02F250'}
G[25850]={'02F250'}
G[25851]={'048500'}
G[25852]={'04810'}
G[25853]={'02F250'}
G[25854]={'036250'}
G[25855]={'036250'}
G[25856]={'048250'}
G[25857]={'048350'}
G[25864]={'02F250'}
G[25865]={'02F250'}
G[25866]={'02F250'}
G[25867]={'02F250'}
G[25868]={'02F350'}
G[25869]={'045250'}
G[25870]={'051250'}
G[25871]={'045250'}
G[25872]={'051250'}
G[25873]={'045350'}
G[25874]={'051350'}
G[25875]={'04575'}
G[25876]={'045250'}
G[25877]={'04575'}
G[25878]={'048250','045250'}
G[25879]={'048250','045250'}
G[25880]={'04510'}
G[25881]={'486250'}
G[25882]={'02F10'}
G[25884]={'46F250'}
G[25886]={'486350'}
G[25887]={'46F250'}
G[25888]={'46F250'}
G[25889]={'045350'}
G[25890]={'46F10'}
G[25891]={'045250'}
G[25899]={'486250'}
G[25900]={'46F75'}
G[25901]={'486250'}
G[25904]={'486250'}
G[25905]={'02F250','036250'}
G[25906]={'48610'}
G[25907]={'46F250'}
G[25908]={'46F250'}
G[25909]={'46F150'}
G[25910]={'486250'}
G[25912]={'045250'}
G[25913]={'045350'}
G[25914]={'045250'}
G[25915]={'486250'}
G[25916]={'46F75'}
G[25921]={'46F500'}
G[25922]={'46F150'}
G[25923]={'486250'}
G[25924]={'46F250'}
G[25925]={'045500'}
G[25926]={'045250'}
G[25927]={'045250'}
G[25928]={'48610'}
G[25929]={'46F250'}
G[25930]={'46E250'}
G[25931]={'46E250'}
G[25932]={'02F250','036250'}
G[25933]={'02F10','03610'}
G[25934]={'46E250','036250'}
G[25935]={'46E250'}
G[25936]={'46F250'}
G[25937]={'02F250','036250'}
G[25938]={'46E25','04825'}
G[25939]={'045250'}
G[25940]={'48610'}
G[25941]={'46F10'}
G[25942]={'04C250'}
G[25943]={'04C250'}
G[25944]={'04C250'}
G[25945]={'04C10'}
G[25946]={'04C250'}
G[25947]={'04C250'}
G[25948]={'04C250'}
G[25957]={'46F500'}
G[25966]={'46F500'}
G[25978]={'02F250','036250'}
G[25979]={'02F250'}
G[25985]={'48610'}
G[25986]={'02F250','036250'}
G[25989]={'46F150'}
G[25990]={'46F75'}
G[25995]={'46F500'}
G[25996]={'46F150'}
G[25997]={'02F250','036250'}
G[25998]={'02F10'}
G[25999]={'04C250'}
G[26001]={'04C250'}
G[26002]={'04C250'}
G[26003]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26004]={'04C10'}
G[26009]={'04C350'}
G[26010]={'04C250'}
G[26011]={'04C250'}
G[26016]={'04C250'}
G[26020]={'04C10'}
G[26024]={'048350'}
G[26026]={'04C350'}
G[26027]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26028]={'04C500','043125','044125','051125','212125','38F125','46D125'}
G[26029]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[26030]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26031]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26032]={'044250'}
G[26033]={'04475'}
G[26035]={'02F350'}
G[26036]={'02F250'}
G[26037]={'048250'}
G[26038]={'02F350'}
G[26043]={'04C500'}
G[26044]={'04C25'}
G[26045]={'04C250'}
G[26046]={'04C250'}
G[26047]={'04C250'}
G[26048]={'04C10'}
G[26050]={'015250','057-250'}
G[26051]={'015350','057-350'}
G[26052]={'01575','057-75'}
G[26053]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26055]={'015250','057-250'}
G[26058]={'04C500'}
G[26059]={'04C25'}
G[26060]={'04C250'}
G[26061]={'04C250'}
G[26062]={'04C500'}
G[26063]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26064]={'04C250'}
G[26065]={'46F350'}
G[26066]={'04C250'}
G[26067]={'04C500'}
G[26068]={'04C250'}
G[26069]={'04C10'}
G[26072]={'46F250'}
G[26073]={'04C500'}
G[26074]={'04C75'}
G[26075]={'04C250'}
G[26076]={'04C350'}
G[26077]={'04C75'}
G[26078]={'02F250','036250'}
G[26079]={'048350'}
G[26081]={'044350'}
G[26082]={'04C350'}
G[26084]={'04C75'}
G[26085]={'02F250','036250'}
G[26093]={'048250'}
G[26094]={'02F250','036250'}
G[26095]={'048350'}
G[26096]={'46F250'}
G[26097]={'04C250'}
G[26098]={'04C250'}
G[26099]={'04C250'}
G[26100]={'04C10'}
G[26101]={'04C10'}
G[26102]={'02F250','036250'}
G[26103]={'036250'}
G[26106]={'036250'}
G[26107]={'04C250'}
G[26108]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26110]={'048250'}
G[26111]={'46F350'}
G[26112]={'02F250','036250'}
G[26113]={'04875'}
G[26115]={'04C500'}
G[26116]={'048250'}
G[26117]={'048350'}
G[26118]={'02F250','036250'}
G[26120]={'045250'}
G[26122]={'46D250'}
G[26126]={'46D250'}
G[26127]={'02F250'}
G[26128]={'02F350'}
G[26129]={'46E10'}
G[26130]={'46F250'}
G[26131]={'03610','02F2','1D52','0452','0482','3A22','46E2'}
G[26134]={'04C75'}
G[26135]={'46F500'}
G[26137]={'02F75'}
G[26145]={'02F250'}
G[26146]={'02F250'}
G[26147]={'02F250'}
G[26148]={'02F350'}
G[26150]={'04825'}
G[26152]={'048350'}
G[26153]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26157]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962','036250','1D562'}
G[26158]={'03625','1D56','02F6','0456','0486','3A26','46E6','5496'}
G[26159]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26160]={'03625','1D56','02F6','0456','0486','3A26','46E6','5496'}
G[26161]={'036250'}
G[26162]={'036500'}
G[26163]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[26164]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[26165]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[26166]={'3A275'}
G[26167]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26168]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26169]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26172]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26173]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26174]={'048250'}
G[26175]={'46E75'}
G[26176]={'02F150'}
G[26177]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26179]={'051250'}
G[26180]={'051350'}
G[26181]={'46F25'}
G[26182]={'46F25'}
G[26183]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26184]={'46E350'}
G[26185]={'26110'}
G[26186]={'46E250','3AE250'}
G[26187]={'46E500'}
G[26188]={'051250'}
G[26189]={'02F350'}
G[26190]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26192]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26193]={'048250'}
G[26194]={'04C250'}
G[26195]={'04575'}
G[26196]={'02F75'}
G[26197]={'03675'}
G[26198]={'036150'}
G[26199]={'03675'}
G[26200]={'036150'}
G[26201]={'03675'}
G[26202]={'03675'}
G[26203]={'03675'}
G[26204]={'036150'}
G[26205]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26206]={'03675'}
G[26207]={'036150'}
G[26208]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26209]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26213]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26214]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26220]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26222]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26225]={'46D250','04362','04462','04C62','05162','21262','38F62'}
G[26226]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26227]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26232]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[26233]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26234]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26235]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26244]={'46F250'}
G[26245]={'46F250'}
G[26246]={'46F75'}
G[26247]={'46F75'}
G[26248]={'46F250'}
G[26249]={'46F75'}
G[26251]={'46F250'}
G[26254]={'46F150'}
G[26255]={'46F150'}
G[26256]={'46F150'}
G[26258]={'46F150'}
G[26259]={'46F250'}
G[26260]={'46F250'}
G[26261]={'46F250'}
G[26264]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26265]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26272]={'21275'}
G[26273]={'212250'}
G[26274]={'212150'}
G[26275]={'212250'}
G[26276]={'212250'}
G[26277]={'21275'}
G[26278]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26279]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26280]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26281]={'043350','044350','04C350','051350','212350','38F350','46D350','548350'}
G[26283]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26284]={'02F250','036250','1D562','03662','04562','04862','3A262','46E62','02F62'}
G[26285]={'02F250','036250','1D562','03662','04562','04862','3A262','46E62','02F62'}
G[26286]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26287]={'048250'}
G[26288]={'048250'}
G[26289]={'04875'}
G[26290]={'048250'}
G[26291]={'048250'}
G[26292]={'04875'}
G[26293]={'04C25'}
G[26294]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26295]={'048250'}
G[26296]={'048250'}
G[26297]={'048150'}
G[26298]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[26299]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[26300]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[26301]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[26302]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[26303]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[26304]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26305]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26309]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26311]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26312]={'46F250'}
G[26313]={'46F250'}
G[26314]={'46F250'}
G[26315]={'46F250'}
G[26316]={'03610','1D52','02F2','0452','0482','3A22','46E2'}
G[26318]={'02F250','036250','1D562','03662','04562','04862','3A262','46E62','02F62'}
G[26319]={'04810'}
G[26320]={'048250'}
G[26322]={'048500'}
G[26324]={'04C150'}
G[26326]={'46F10'}
G[26327]={'02F25'}
G[26328]={'493500'}
G[26331]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26333]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26335]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26337]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26338]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[26339]={'03610','1D52','02F2','0452','0482','3A22','46E2'}
G[26342]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26346]={'02F75'}
G[26350]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[26351]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26352]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26358]={'46D10','0432','0442','04C2','0512','2122','38F2','5482'}
G[26359]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26360]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26361]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26362]={'212350','04387','04487','04C87','05187','38F87','46D87'}
G[26364]={'036350','02F350','1D587','02F87','04587','04887','3A287','46E87','03687'}
G[26365]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26368]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26370]={'04810'}
G[26372]={'46D10','0432','0442','04C2','0512','2122','38F2','5482'}
G[26373]={'02F10','1D52','0362','0452','0482','3A22','46E2'}
G[26374]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26375]={'4937000'}
G[26376]={'4937000'}
G[26377]={'4937000'}
G[26378]={'04875'}
G[26380]={'02F10'}
G[26381]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26382]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26383]={'04525'}
G[26385]={'04525'}
G[26386]={'212500','043125','044125','04C125','051125','38F125','46D125'}
G[26387]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26388]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26389]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26390]={'048350'}
G[26391]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26393]={'04825'}
G[26394]={'04875'}
G[26395]={'04825'}
G[26396]={'048350'}
G[26397]={'04C250'}
G[26399]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26400]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26401]={'045250'}
G[26402]={'04575'}
G[26403]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26404]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26405]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26406]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26407]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[26408]={'04525'}
G[26409]={'46F10'}
G[26410]={'46F250'}
G[26411]={'46F75'}
G[26412]={'46D250'}
G[26413]={'46F10'}
G[26414]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26416]={'04C25','0436','0446','0516','2126','38F6','46D6'}
G[26417]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[26418]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26419]={'044350','04387','04C87','05187','21287','38F87','46D87'}
G[26420]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26421]={'03610'}
G[26422]={'03610'}
G[26423]={'03610'}
G[26424]={'03610'}
G[26425]={'03610'}
G[26426]={'4937000'}
G[26427]={'46F150'}
G[26428]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26429]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26430]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26433]={'46D250'}
G[26434]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26435]={'38F25','0436','0446','04C6','0516','2126','46D6','5486'}
G[26436]={'493250'}
G[26437]={'493500'}
G[26438]={'493500'}
G[26439]={'493500'}
G[26440]={'493500'}
G[26441]={'493250'}
G[26442]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26443]={'3A275'}
G[26444]={'3A2250'}
G[26445]={'3A2350'}
G[26446]={'045250'}
G[26447]={'04C75'}
G[26448]={'43D250'}
G[26449]={'43D350'}
G[26450]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26453]={'3A225'}
G[26454]={'045250'}
G[26455]={'045250'}
G[26456]={'37A75'}
G[26457]={'045250'}
G[26463]={'045250'}
G[26464]={'045250'}
G[26465]={'045250'}
G[26466]={'045350'}
G[26467]={'045250'}
G[26468]={'045250'}
G[26469]={'045250'}
G[26470]={'045250'}
G[26472]={'045350'}
G[26473]={'045250'}
G[26474]={'045350'}
G[26475]={'045250'}
G[26476]={'04575'}
G[26477]={'045250'}
G[26478]={'045250'}
G[26479]={'04510'}
G[26480]={'045150'}
G[26481]={'045250'}
G[26482]={'045500'}
G[26487]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26488]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26489]={'46D250'}
G[26490]={'044250'}
G[26493]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[26494]={'46D10','0432','0442','04C2','0512','2122','38F2','5482'}
G[26495]={'46D10','0432','0442','04C2','0512','2122','38F2','5482'}
G[26503]={'048350'}
G[26504]={'048250'}
G[26505]={'04875'}
G[26506]={'048250'}
G[26507]={'493500'}
G[26508]={'048250'}
G[26509]={'048250'}
G[26510]={'048250'}
G[26511]={'048250'}
G[26512]={'048150'}
G[26513]={'048350'}
G[26514]={'048350'}
G[26520]={'048500'}
G[26533]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26534]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[26535]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[26536]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26538]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[26539]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[26540]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[26543]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26544]={'048250'}
G[26545]={'048500'}
G[26549]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26556]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26557]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26561]={'048250'}
G[26562]={'048250'}
G[26563]={'048500'}
G[26566]={'03610','1D52','02F2','0452','0482','3A22','46E2'}
G[26567]={'04810'}
G[26568]={'04810'}
G[26569]={'048250'}
G[26570]={'048250'}
G[26571]={'048250'}
G[26572]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26573]={'048250'}
G[26575]={'493500'}
G[26576]={'493250'}
G[26577]={'493250'}
G[26578]={'493500'}
G[26579]={'493500'}
G[26580]={'46F25'}
G[26581]={'46F250'}
G[26582]={'493250'}
G[26583]={'493500'}
G[26584]={'493500'}
G[26585]={'493500'}
G[26586]={'048250'}
G[26587]={'048250'}
G[26588]={'04C250'}
G[26590]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26592]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26593]={'015250','241125','171125','1D6125','057-250'}
G[26594]={'015150','24175','17175','1D675','057-150'}
G[26595]={'015250','241125','171125','1D6125','057-250'}
G[26597]={'015500','241250','171250','1D6250','057-500'}
G[26599]={'015250','241125','171125','1D6125','057-250'}
G[26600]={'015150','24175','17175','1D675','057-150'}
G[26601]={'015500','241250','171250','1D6250','057-500'}
G[26602]={'015350','241175','171175','1D6175','057-350'}
G[26607]={'04875'}
G[26609]={'015150','24175','17175','1D675','057-150'}
G[26610]={'015150','24175','17175','1D675','057-150'}
G[26611]={'01525','24112','17112','1D612','057-25'}
G[26612]={'015350','241175','171175','1D6175','057-350'}
G[26613]={'015250','241125','171125','1D6125','057-250'}
G[26614]={'015250','241125','171125','1D6125','057-250'}
G[26616]={'04825'}
G[26617]={'015150','24175','17175','1D675','057-150'}
G[26618]={'048250'}
G[26619]={'494250'}
G[26620]={'048250'}
G[26621]={'494500'}
G[26622]={'4941750'}
G[26623]={'048250'}
G[26628]={'015350','057-350'}
G[26636]={'048250'}
G[26637]={'048250'}
G[26638]={'048250'}
G[26639]={'048250'}
G[26640]={'048250'}
G[26642]={'04C75','04318','04418','05118','21218','38F18','46D18'}
G[26645]={'048250'}
G[26646]={'048350'}
G[26651]={'048250'}
G[26656]={'493500'}
G[26657]={'493500'}
G[26658]={'493500'}
G[26659]={'493500'}
G[26662]={'015250','241125','171125','1D6125'}
G[26663]={'015250','241125','171125','1D6125'}
G[26664]={'015250','241125','171125','1D6125'}
G[26665]={'015250','241125','171125','1D6125'}
G[26666]={'04825'}
G[26667]={'04875'}
G[26668]={'048500'}
G[26669]={'04875'}
G[26670]={'048250'}
G[26671]={'46E75'}
G[26674]={'46E500'}
G[26678]={'01510','2415','1715','1D65'}
G[26679]={'01575','24137','17137','1D637'}
G[26682]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26684]={'048250'}
G[26685]={'048250'}
G[26686]={'048250'}
G[26687]={'04875'}
G[26688]={'048250'}
G[26689]={'048250'}
G[26690]={'048150'}
G[26691]={'048350'}
G[26692]={'048350'}
G[26693]={'048350'}
G[26694]={'048350'}
G[26695]={'015250','241125','171125','1D6125'}
G[26697]={'015350','241175','171175','1D6175'}
G[26698]={'01510','2415','1715','1D65'}
G[26699]={'015250','241125','171125','1D6125'}
G[26700]={'015250','241125','171125','1D6125'}
G[26703]={'015500','241250','171250','1D6250'}
G[26706]={'46E500'}
G[26707]={'46E250'}
G[26708]={'048500'}
G[26709]={'493150'}
G[26710]={'493250'}
G[26711]={'46D25'}
G[26712]={'46D25'}
G[26713]={'048500'}
G[26714]={'048500'}
G[26717]={'46E250'}
G[26719]={'46E75'}
G[26720]={'46E250'}
G[26721]={'048250'}
G[26723]={'46E250'}
G[26726]={'048500'}
G[26727]={'048500'}
G[26728]={'048250'}
G[26729]={'048250'}
G[26730]={'048250'}
G[26731]={'048250'}
G[26732]={'048250'}
G[26733]={'048250'}
G[26734]={'048250'}
G[26735]={'048250'}
G[26736]={'048250'}
G[26737]={'048500'}
G[26742]={'02F250'}
G[26743]={'048250'}
G[26744]={'048250'}
G[26745]={'048250'}
G[26749]={'3A210'}
G[26750]={'493250'}
G[26751]={'048250'}
G[26752]={'46F250','493500'}
G[26754]={'46E500'}
G[26760]={'46E75'}
G[26761]={'048250'}
G[26763]={'015250','241125','171125','1D6125'}
G[26765]={'048250'}
G[26766]={'46F250'}
G[26768]={'46F150'}
G[26769]={'46D75'}
G[26771]={'46F250'}
G[26772]={'3A2250'}
G[26773]={'3A2250'}
G[26774]={'3A2250'}
G[26775]={'3A2350'}
G[26776]={'3A2500'}
G[26777]={'46E250'}
G[26778]={'46E250'}
G[26779]={'212350'}
G[26780]={'036250'}
G[26782]={'46E250'}
G[26783]={'46E250'}
G[26784]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26786]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26787]={'048250'}
G[26788]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26793]={'04825'}
G[26794]={'04825'}
G[26795]={'048150'}
G[26796]={'04825'}
G[26798]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26799]={'044350'}
G[26800]={'044350'}
G[26801]={'044250','044150','04337','04C37','05137','21237','38F37','46D37'}
G[26802]={'044250'}
G[26803]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[26804]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[26805]={'02F25'}
G[26806]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[26807]={'04C150','04337','04437','05137','21237','38F37','46D37'}
G[26808]={'02F10'}
G[26815]={'02F250'}
G[26816]={'036350'}
G[26817]={'036250'}
G[26818]={'02F250'}
G[26819]={'02F250'}
G[26820]={'02F250'}
G[26821]={'03625'}
G[26822]={'02F350'}
G[26823]={'036250'}
G[26827]={'46F250'}
G[26828]={'493250'}
G[26829]={'493500'}
G[26830]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26831]={'493500'}
G[26832]={'493500'}
G[26833]={'46F250'}
G[26840]={'04C10'}
G[26841]={'04575'}
G[26842]={'02F250'}
G[26843]={'02F250'}
G[26844]={'02F250'}
G[26845]={'02F250'}
G[26846]={'02F250'}
G[26853]={'46F350'}
G[26854]={'02F75','03675'}
G[26855]={'02F150','036150'}
G[26856]={'04C500','043125','044125','051125','212125','38F125','46D125'}
G[26857]={'46F250'}
G[26858]={'04C500','043125','044125','051125','212125','38F125','46D125'}
G[26860]={'02F250'}
G[26861]={'46F250'}
G[26862]={'04C500','043125','044125','051125','212125','38F125','46D125'}
G[26863]={'02F350'}
G[26864]={'02F250'}
G[26868]={'02F350'}
G[26869]={'4937000'}
G[26871]={'4937000'}
G[26875]={'46F250'}
G[26876]={'46F350'}
G[26881]={'045500'}
G[26882]={'045500'}
G[26883]={'045500'}
G[26884]={'045500'}
G[26885]={'045500'}
G[26886]={'036250'}
G[26887]={'036250'}
G[26888]={'212500'}
G[26890]={'04C250'}
G[26891]={'212500'}
G[26892]={'212500'}
G[26901]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[26903]={'1D6500'}
G[26904]={'02F75'}
G[26910]={'04875'}
G[26911]={'04C75'}
G[26913]={'048250'}
G[26914]={'048250'}
G[26915]={'048250'}
G[26916]={'048250'}
G[26917]={'048250'}
G[26918]={'048250'}
G[26919]={'048250'}
G[26920]={'04425'}
G[26921]={'044250'}
G[26922]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26923]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26924]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[26925]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[26926]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[26928]={'02F250'}
G[26929]={'02F250'}
G[26930]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[26931]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26932]={'02F250'}
G[26933]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26934]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26935]={'45210'}
G[26936]={'04475'}
G[26937]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26938]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[26939]={'036500','1D5125','02F125','045125','048125','3A2125','46E125','549125'}
G[26940]={'045250'}
G[26941]={'036500','1D5125','02F125','045125','048125','3A2125','46E125','549125'}
G[26942]={'036500','1D5125','02F125','045125','048125','3A2125','46E125','549125'}
G[26945]={'045250'}
G[26946]={'045250'}
G[26947]={'045250'}
G[26948]={'045250'}
G[26949]={'045250'}
G[26952]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[26953]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','261350'}
G[26954]={'3AE250'}
G[26955]={'261350'}
G[26956]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','261250'}
G[26957]={'45225'}
G[26958]={'3A2250'}
G[26960]={'04810','1D52','02F2','0362','0452','3A22','46E2'}
G[26961]={'02F250'}
G[26963]={'3A2250'}
G[26964]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26965]={'044150'}
G[26966]={'3A2250'}
G[26968]={'3A2250'}
G[26969]={'3A2250'}
G[26970]={'3A2250'}
G[26971]={'46F500','493500'}
G[26975]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[26977]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[26978]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26979]={'04475','04318','04C18','05118','21218','38F18','46D18','54818'}
G[26980]={'02F75'}
G[26981]={'02F75'}
G[26989]={'044250'}
G[26992]={'044250'}
G[26995]={'044250'}
G[26997]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[26998]={'044350'}
G[26999]={'452250','044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27000]={'452250','044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27001]={'452250'}
G[27002]={'452350'}
G[27007]={'46F75'}
G[27010]={'46F250'}
G[27013]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27014]={'05175'}
G[27015]={'05175'}
G[27017]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','452250'}
G[27020]={'05175'}
G[27021]={'05175'}
G[27023]={'05175'}
G[27025]={'036250'}
G[27026]={'036250'}
G[27027]={'05175'}
G[27028]={'02F250'}
G[27030]={'02F250'}
G[27031]={'036250'}
G[27033]={'036350'}
G[27034]={'03675'}
G[27035]={'036250'}
G[27038]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[27044]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[27045]={'044500'}
G[27046]={'493250'}
G[27047]={'493250'}
G[27048]={'493250'}
G[27049]={'493250'}
G[27050]={'493250'}
G[27051]={'493250'}
G[27053]={'45275'}
G[27054]={'452250'}
G[27055]={'452500'}
G[27056]={'04410'}
G[27057]={'452250'}
G[27060]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[27061]={'46F25'}
G[27064]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[27065]={'04410','04C10'}
G[27066]={'05175'}
G[27067]={'05175'}
G[27069]={'044250','04C250'}
G[27070]={'0A9500','015500','171500','1D6500','241500'}
G[27072]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[27073]={'044250','04C500'}
G[27074]={'02F75'}
G[27075]={'02F350'}
G[27076]={'0A9500','015500','171500','1D6500','241500'}
G[27077]={'02F350'}
G[27078]={'02F500'}
G[27082]={'044250'}
G[27083]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[27084]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27085]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27086]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27087]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[27088]={'044350'}
G[27089]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27090]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27091]={'38F250'}
G[27092]={'048350','1D587','02F87','03687','04587','3A287','46E87'}
G[27093]={'044350','04C350'}
G[27094]={'044350','04C350'}
G[27095]={'044250','04C250'}
G[27096]={'044500','04C500'}
G[27097]={'044350'}
G[27098]={'044500'}
G[27099]={'044500'}
G[27100]={'46F250'}
G[27102]={'46F350'}
G[27106]={'048350','1D587','02F87','03687','04587','3A287','46E87'}
G[27116]={'036250'}
G[27117]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27123]={'46F10'}
G[27135]={'46F250'}
G[27136]={'46F250'}
G[27139]={'46D10'}
G[27144]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27150]={'04410'}
G[27151]={'452250'}
G[27152]={'452250'}
G[27153]={'452250'}
G[27154]={'452250'}
G[27155]={'452350'}
G[27156]={'452250','044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27157]={'452250'}
G[27158]={'04825'}
G[27159]={'048250'}
G[27160]={'048350'}
G[27161]={'048250'}
G[27162]={'048500'}
G[27163]={'048500'}
G[27164]={'044350'}
G[27165]={'04810'}
G[27166]={'048250'}
G[27167]={'048250'}
G[27168]={'048250'}
G[27171]={'048350'}
G[27175]={'04410'}
G[27177]={'048250'}
G[27178]={'048250'}
G[27180]={'044350'}
G[27181]={'044250'}
G[27193]={'044250'}
G[27194]={'044250'}
G[27195]={'044500'}
G[27197]={'04810'}
G[27198]={'048350'}
G[27199]={'048250'}
G[27200]={'048250'}
G[27201]={'048350'}
G[27202]={'048350'}
G[27203]={'46F10'}
G[27204]={'048500'}
G[27205]={'04810'}
G[27206]={'048250'}
G[27210]={'048250'}
G[27211]={'048250'}
G[27212]={'048250'}
G[27213]={'048350'}
G[27222]={'048350'}
G[27225]={'04810'}
G[27226]={'04C250','044250'}
G[27229]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[27231]={'04C250','044250'}
G[27232]={'04C500','044500'}
G[27233]={'04410'}
G[27244]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[27246]={'04825'}
G[27247]={'048250'}
G[27265]={'04810'}
G[27266]={'04810'}
G[27267]={'04810'}
G[27268]={'04810'}
G[27269]={'04510'}
G[27270]={'04810'}
G[27271]={'04810'}
G[27272]={'04810'}
G[27273]={'26110'}
G[27274]={'03610'}
G[27275]={'04510'}
G[27276]={'05110'}
G[27277]={'04C10'}
G[27278]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[27279]={'04C10'}
G[27280]={'04C10'}
G[27281]={'04C10'}
G[27282]={'04C10'}
G[27283]={'26120'}
G[27290]={'044250'}
G[27297]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27298]={'38F10'}
G[27299]={'46F250'}
G[27300]={'46F250'}
G[27301]={'46F250'}
G[27302]={'46F250'}
G[27303]={'46F250'}
G[27304]={'05110'}
G[27310]={'045250'}
G[27311]={'051250'}
G[27312]={'045250'}
G[27313]={'051250'}
G[27314]={'045350'}
G[27315]={'051350'}
G[27316]={'045250'}
G[27317]={'051250'}
G[27318]={'045350'}
G[27319]={'051350'}
G[27320]={'045250'}
G[27321]={'051250'}
G[27322]={'044500'}
G[27323]={'045350'}
G[27324]={'051350'}
G[27325]={'045250'}
G[27326]={'051250'}
G[27327]={'045350'}
G[27328]={'051350'}
G[27329]={'045350'}
G[27330]={'051350'}
G[27331]={'04C10'}
G[27332]={'04C10'}
G[27333]={'044350'}
G[27334]={'04410'}
G[27335]={'38F10'}
G[27337]={'048500'}
G[27338]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[27341]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[27342]={'044250'}
G[27343]={'048500'}
G[27344]={'048500'}
G[27346]={'17110','1D65','2415','0155','0A95'}
G[27347]={'171250','1D6125','241125','015125','0A9125'}
G[27348]={'171250','1D6125','241125','015125','0A9125'}
G[27349]={'044350'}
G[27350]={'044250'}
G[27351]={'048500'}
G[27353]={'048500'}
G[27354]={'048500'}
G[27355]={'048500'}
G[27356]={'261500'}
G[27357]={'045250'}
G[27358]={'051250'}
G[27360]={'044250'}
G[27361]={'048500'}
G[27362]={'048500'}
G[27363]={'048500'}
G[27364]={'044350'}
G[27365]={'04C500'}
G[27366]={'048350','1D587','02F87','03687','04587','3A287','46E87'}
G[27374]={'46F25'}
G[27375]={'46F25'}
G[27376]={'46F250'}
G[27377]={'46F250'}
G[27378]={'46F250'}
G[27379]={'46F250'}
G[27380]={'46F500'}
G[27382]={'452350'}
G[27395]={'04C500','043125','044125','051125','212125','38F125','46D125'}
G[27396]={'04C500'}
G[27397]={'04C500'}
G[27400]={'04C500'}
G[27401]={'044350'}
G[27402]={'04C500'}
G[27403]={'04C500'}
G[27404]={'2611000'}
G[27405]={'044250'}
G[27406]={'044500'}
G[27412]={'171250','0A9125','015125','1D6125','241125'}
G[27413]={'171250','0A9125','015125','1D6125','241125'}
G[27420]={'261250'}
G[27421]={'261250'}
G[27423]={'044500'}
G[27432]={'452250'}
G[27433]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[27434]={'04C500'}
G[27435]={'04C500'}
G[27436]={'04C500'}
G[27437]={'04C500'}
G[27438]={'0441000'}
G[27439]={'04C500'}
G[27441]={'04C500'}
G[27446]={'03610'}
G[27447]={'46D10'}
G[27450]={'452250'}
G[27451]={'452250'}
G[27452]={'452250'}
G[27453]={'452250'}
G[27454]={'452250'}
G[27456]={'452250'}
G[27459]={'45210'}
G[27460]={'452250'}
G[27461]={'45210'}
G[27462]={'45210'}
G[27463]={'45210'}
G[27464]={'452500'}
G[27465]={'452350'}
G[27467]={'452250'}
G[27468]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[27472]={'0441000'}
G[27474]={'044350'}
G[27475]={'044250'}
G[27476]={'044250'}
G[27477]={'452250'}
G[27478]={'044250'}
G[27479]={'452250'}
G[27480]={'044350'}
G[27483]={'044250'}
G[27484]={'044250'}
G[27490]={'048250'}
G[27491]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27492]={'048250'}
G[27493]={'494250'}
G[27494]={'048250'}
G[27495]={'494250'}
G[27496]={'048250'}
G[27497]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27498]={'048250'}
G[27499]={'494250'}
G[27500]={'048250'}
G[27501]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27502]={'048250'}
G[27503]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27510]={'04C250','044250'}
G[27512]={'044250'}
G[27513]={'044350'}
G[27514]={'49625'}
G[27515]={'496250'}
G[27516]={'49625'}
G[27518]={'044500'}
G[27519]={'495250'}
G[27520]={'495250'}
G[27525]={'452350'}
G[27526]={'452500'}
G[27527]={'452250'}
G[27528]={'452250'}
G[27529]={'452250'}
G[27530]={'452350'}
G[27531]={'452250'}
G[27532]={'45210'}
G[27535]={'452250'}
G[27537]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[27538]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[27539]={'452350'}
G[27542]={'04410'}
G[27544]={'26110'}
G[27545]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[27547]={'044250'}
G[27548]={'044250'}
G[27550]={'044350'}
G[27551]={'452250'}
G[27574]={'044250'}
G[27575]={'044350'}
G[27576]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[27577]={'044250'}
G[27580]={'044350'}
G[27583]={'49475','04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[27584]={'494350'}
G[27586]={'46D250'}
G[27594]={'044500'}
G[27595]={'49575'}
G[27601]={'0441000'}
G[27602]={'49575'}
G[27606]={'46D250','494250','04362','04462','04C62','05162','21262','38F62','54862'}
G[27607]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[27610]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27611]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27612]={'452250'}
G[27613]={'452250'}
G[27614]={'452250'}
G[27615]={'452250'}
G[27616]={'452250'}
G[27617]={'45210'}
G[27618]={'45210'}
G[27619]={'452250'}
G[27620]={'452500'}
G[27621]={'49625'}
G[27622]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[27623]={'495250'}
G[27625]={'3A2350'}
G[27626]={'3A2350'}
G[27628]={'495150'}
G[27629]={'49575'}
G[27630]={'49510'}
G[27631]={'49575'}
G[27632]={'495150'}
G[27635]={'036150','1D537','02F37','04537','04837','3A237','46E37'}
G[27636]={'04875'}
G[27638]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[27640]={'49625'}
G[27641]={'496250'}
G[27642]={'496250'}
G[27643]={'49625'}
G[27644]={'49625'}
G[27645]={'49625'}
G[27646]={'496250'}
G[27647]={'496250'}
G[27648]={'496250'}
G[27649]={'496250'}
G[27650]={'496250'}
G[27651]={'496250'}
G[27652]={'048250'}
G[27653]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27654]={'048250'}
G[27655]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27657]={'46F75'}
G[27658]={'46F75'}
G[27659]={'46F250'}
G[27660]={'46F75'}
G[27661]={'46F250'}
G[27662]={'46F250'}
G[27664]={'38D350'}
G[27665]={'38D350'}
G[27666]={'38D350'}
G[27667]={'38D350'}
G[27670]={'036250'}
G[27671]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[27674]={'036150','1D537','02F37','04537','04837','3A237','46E37'}
G[27681]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27688]={'048350'}
G[27689]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[27690]={'49475'}
G[27695]={'048250'}
G[27696]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27700]={'048250'}
G[27701]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27702]={'048250'}
G[27703]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27706]={'495150'}
G[27707]={'495250'}
G[27708]={'46F350'}
G[27711]={'46F10'}
G[27712]={'46F10'}
G[27718]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[27719]={'048350'}
G[27720]={'46F250'}
G[27721]={'48610'}
G[27722]={'04C10'}
G[27724]={'04810'}
G[27726]={'04810'}
G[27727]={'04810','1D52','02F2','0362','0452','3A22','46E2'}
G[27733]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27738]={'495350'}
G[27742]={'46F250'}
G[27743]={'46F250'}
G[27744]={'46F250'}
G[27745]={'46F350'}
G[27746]={'044250'}
G[27747]={'494350'}
G[27750]={'494350'}
G[27751]={'494500'}
G[27752]={'496250'}
G[27753]={'496250'}
G[27754]={'496250'}
G[27755]={'495250'}
G[27756]={'048500'}
G[27758]={'048500'}
G[27764]={'0A975','01575','17175','1D675','24175'}
G[27774]={'0A9250','015250','171250','1D6250','241250'}
G[27776]={'0A9250','015250','171250','1D6250','241250'}
G[27781]={'048500'}
G[27784]={'048250'}
G[27785]={'048500'}
G[27786]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27787]={'496500','048250'}
G[27788]={'494500','04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27790]={'048500'}
G[27791]={'02F10'}
G[27792]={'02F250'}
G[27795]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27798]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[27803]={'496250'}
G[27804]={'496250'}
G[27805]={'496250'}
G[27806]={'49625'}
G[27807]={'49625'}
G[27808]={'496250'}
G[27809]={'49625'}
G[27810]={'496250'}
G[27811]={'496250'}
G[27812]={'496150'}
G[27813]={'496250'}
G[27814]={'496250'}
G[27815]={'49625'}
G[27816]={'49625'}
G[27817]={'496250'}
G[27821]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27822]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27823]={'02F250'}
G[27824]={'02F250'}
G[27825]={'048250'}
G[27833]={'048250'}
G[27836]={'495250'}
G[27837]={'495250'}
G[27838]={'495250'}
G[27839]={'495250'}
G[27840]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[27842]={'04C500'}
G[27843]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27844]={'04C500'}
G[27845]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27847]={'04C500'}
G[27848]={'04C500'}
G[27849]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27850]={'04C500'}
G[27851]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27852]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27853]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27854]={'04C250'}
G[27855]={'04C250'}
G[27856]={'04C250'}
G[27857]={'04C350'}
G[27860]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[27874]={'48675'}
G[27875]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[27876]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[27877]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[27878]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[27879]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27880]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27881]={'38F10','0432','0442','04C2','0512','2122','46D2','5482'}
G[27882]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[27902]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[27904]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[27907]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27908]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27909]={'04C250'}
G[27910]={'04C250'}
G[27917]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[27920]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[27921]={'46E500'}
G[27922]={'495250'}
G[27923]={'495250'}
G[27929]={'494350'}
G[27938]={'46F350'}
G[27944]={'499250'}
G[27945]={'494250'}
G[27948]={'499250'}
G[27949]={'499250'}
G[27958]={'03B250'}
G[27960]={'03B250'}
G[27961]={'03B250'}
G[27962]={'03B250'}
G[27963]={'03B250'}
G[27964]={'03B250'}
G[27965]={'03B10'}
G[27966]={'499250'}
G[27967]={'499250'}
G[27968]={'46E500'}
G[27970]={'499250'}
G[27971]={'499250'}
G[27972]={'499250'}
G[27973]={'499250'}
G[27974]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[27975]={'499250'}
G[27976]={'03B250'}
G[27977]={'03B250'}
G[27978]={'499250'}
G[27979]={'03B350'}
G[27980]={'03B250'}
G[27981]={'03B250'}
G[27986]={'03B10'}
G[27987]={'499250'}
G[27988]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[27989]={'2401000'}
G[27991]={'499250'}
G[27992]={'499250'}
G[27994]={'240250'}
G[27995]={'2401000'}
G[27996]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[27998]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[28001]={'49625'}
G[28035]={'03B350'}
G[28041]={'494350'}
G[28043]={'494350'}
G[28046]={'499250'}
G[28050]={'499350'}
G[28052]={'03B350'}
G[28054]={'03B250'}
G[28055]={'03B250'}
G[28056]={'03B250'}
G[28057]={'03B250'}
G[28058]={'03B250'}
G[28059]={'499250'}
G[28060]={'03B350'}
G[28061]={'03B250'}
G[28062]={'03B250'}
G[28063]={'499250'}
G[28064]={'03B500'}
G[28084]={'04C10'}
G[28089]={'044250'}
G[28090]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28091]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28092]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28094]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28096]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28097]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[28099]={'03B350'}
G[28100]={'240300'}
G[28101]={'04875'}
G[28103]={'048250'}
G[28104]={'048250'}
G[28105]={'495250'}
G[28107]={'048250'}
G[28108]={'048250'}
G[28111]={'04410'}
G[28112]={'495150'}
G[28114]={'044250'}
G[28115]={'044350'}
G[28117]={'499350'}
G[28118]={'499350'}
G[28120]={'499350'}
G[28122]={'499350'}
G[28123]={'494350'}
G[28130]={'499250'}
G[28133]={'4941750'}
G[28134]={'495250'}
G[28135]={'495150'}
G[28137]={'499250'}
G[28138]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28141]={'495250'}
G[28144]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28145]={'495250'}
G[28146]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28147]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[28149]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[28151]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[28154]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28156]={'044500'}
G[28160]={'036500'}
G[28161]={'46D500'}
G[28162]={'499350'}
G[28163]={'499350'}
G[28164]={'04C10'}
G[28165]={'499350'}
G[28166]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[28167]={'03610','1D52','02F2','0452','0482','3A22','46E2'}
G[28168]={'04410'}
G[28169]={'03610','1D52','02F2','0452','0482','3A22','46E2'}
G[28170]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[28185]={'499350'}
G[28186]={'499350'}
G[28188]={'499350'}
G[28189]={'044500'}
G[28192]={'044250'}
G[28196]={'044350'}
G[28197]={'044250'}
G[28198]={'49510'}
G[28199]={'044250'}
G[28200]={'495250'}
G[28201]={'495250'}
G[28202]={'03B350'}
G[28203]={'03B350'}
G[28204]={'03B350'}
G[28205]={'03B350'}
G[28206]={'04475'}
G[28209]={'044250'}
G[28210]={'495250'}
G[28211]={'048250'}
G[28212]={'048250'}
G[28215]={'048250'}
G[28216]={'048250'}
G[28223]={'499350'}
G[28225]={'03B250'}
G[28226]={'03B250'}
G[28227]={'03B350'}
G[28230]={'044350'}
G[28231]={'044350','38F350'}
G[28232]={'499350'}
G[28235]={'044350'}
G[28237]={'044500'}
G[28238]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[28244]={'49675'}
G[28248]={'49625'}
G[28249]={'49425'}
G[28250]={'495150'}
G[28251]={'04425'}
G[28254]={'03B10'}
G[28258]={'04810'}
G[28259]={'04810'}
G[28260]={'04810'}
G[28262]={'04810'}
G[28263]={'04810'}
G[28268]={'04810'}
G[28275]={'499250'}
G[28276]={'49575'}
G[28277]={'495250'}
G[28280]={'496250'}
G[28281]={'496250'}
G[28282]={'496250'}
G[28285]={'04810'}
G[28287]={'04810'}
G[28289]={'26110'}
G[28290]={'04C10'}
G[28291]={'495150'}
G[28294]={'49675'}
G[28297]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[28298]={'04C10'}
G[28299]={'04C10'}
G[28300]={'04C10'}
G[28301]={'04C10'}
G[28302]={'04C10'}
G[28303]={'04C10'}
G[28304]={'04410'}
G[28307]={'38F10'}
G[28309]={'21210'}
G[28323]={'46D10'}
G[28324]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28325]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28328]={'048350'}
G[28329]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28330]={'044350'}
G[28331]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[28332]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28333]={'46D250'}
G[28334]={'46D250'}
G[28335]={'46D250'}
G[28336]={'46D250'}
G[28337]={'46E250'}
G[28338]={'2401400'}
G[28339]={'46D250'}
G[28340]={'46D250'}
G[28343]={'261350'}
G[28344]={'04410'}
G[28345]={'04475','04C75'}
G[28346]={'49625'}
G[28348]={'044250','04C250'}
G[28349]={'46D10'}
G[28354]={'044250','04C250'}
G[28355]={'044350','04387','04C87','05187','21287','38F87','46D87'}
G[28356]={'044350','04387','04C87','05187','21287','38F87','46D87'}
G[28357]={'46D250'}
G[28362]={'2401000'}
G[28364]={'2401400'}
G[28366]={'2401000'}
G[28368]={'46D350'}
G[28369]={'49610'}
G[28370]={'46D250'}
G[28373]={'24025'}
G[28375]={'044250','04C250'}
G[28377]={'49625'}
G[28378]={'496250'}
G[28379]={'496250'}
G[28382]={'46E250'}
G[28383]={'045250'}
G[28384]={'46E75'}
G[28385]={'46E250'}
G[28386]={'46E250'}
G[28387]={'46E250'}
G[28388]={'46E250'}
G[28389]={'46E350'}
G[28390]={'493350'}
G[28391]={'493350'}
G[28392]={'24025'}
G[28393]={'048350'}
G[28394]={'048350'}
G[28395]={'2402000'}
G[28396]={'2402000'}
G[28397]={'044250','04C250'}
G[28398]={'048350'}
G[28399]={'048350'}
G[28400]={'044500','04C500'}
G[28401]={'048350'}
G[28405]={'048350'}
G[28406]={'048350'}
G[28407]={'49625'}
G[28408]={'496250'}
G[28409]={'496250'}
G[28410]={'496250'}
G[28411]={'496250'}
G[28413]={'49675'}
G[28414]={'46D250'}
G[28427]={'03B10'}
G[28428]={'03B350'}
G[28429]={'03B350'}
G[28430]={'03B350'}
G[28431]={'03B350'}
G[28457]={'04C350'}
G[28458]={'04C350'}
G[28459]={'04C350'}
G[28460]={'240350'}
G[28461]={'04C350','04387','04487','05187','21287','38F87','46D87'}
G[28462]={'240350'}
G[28463]={'04C350'}
G[28464]={'2401000'}
G[28465]={'04C350'}
G[28466]={'04C350'}
G[28467]={'240250'}
G[28469]={'240250'}
G[28470]={'240500'}
G[28471]={'240250'}
G[28472]={'241250','0A9125','015125','171125','1D6125'}
G[28473]={'38F350'}
G[28474]={'044350'}
G[28475]={'38F350'}
G[28477]={'212350'}
G[28478]={'46D350'}
G[28480]={'495250'}
G[28483]={'495250'}
G[28484]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28485]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[28486]={'495250'}
G[28487]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28488]={'493250'}
G[28489]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28490]={'04510'}
G[28492]={'04510'}
G[28493]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[28494]={'04C10'}
G[28495]={'044250','38F250'}
G[28496]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[28498]={'495250'}
G[28499]={'495250'}
G[28500]={'495250'}
G[28501]={'495350'}
G[28502]={'495250'}
G[28503]={'04510'}
G[28504]={'04C10'}
G[28505]={'04825'}
G[28506]={'044250','04C250'}
G[28507]={'03610'}
G[28508]={'04425'}
G[28509]={'46D10','0432','0442','04C2','0512','2122','38F2'}
G[28510]={'05110'}
G[28511]={'04510'}
G[28512]={'03B10','04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[28514]={'03B10'}
G[28515]={'03B10'}
G[28520]={'495500'}
G[28521]={'240100'}
G[28522]={'2401400'}
G[28523]={'2402000'}
G[28524]={'24075'}
G[28527]={'26110'}
G[28528]={'26110'}
G[28529]={'045500'}
G[28530]={'240350'}
G[28531]={'04810'}
G[28532]={'04C10'}
G[28533]={'495250'}
G[28538]={'044250'}
G[28539]={'04510'}
G[28542]={'26110'}
G[28543]={'26110'}
G[28548]={'38F10'}
G[28549]={'05110'}
G[28550]={'04810'}
G[28551]={'04810'}
G[28552]={'04810'}
G[28554]={'04C10'}
G[28556]={'044350','04C350'}
G[28559]={'3A210'}
G[28560]={'38F10'}
G[28561]={'495250'}
G[28562]={'04875'}
G[28563]={'048250'}
G[28564]={'04810'}
G[28565]={'02F10'}
G[28566]={'044250'}
G[28567]={'02F10'}
G[28568]={'044250'}
G[28571]={'04410'}
G[28572]={'04410'}
G[28573]={'04810'}
G[28575]={'04410'}
G[28576]={'04810'}
G[28581]={'03B10'}
G[28582]={'03B10'}
G[28583]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[28584]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28586]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28587]={'04410','04C10'}
G[28588]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28589]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[28590]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[28591]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28592]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28593]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28594]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[28595]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[28596]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[28598]={'048350','1D587','02F87','03687','04587','3A287','46E87'}
G[28599]={'49625'}
G[28600]={'044250','04C250'}
G[28603]={'044250'}
G[28604]={'044250'}
G[28605]={'044250'}
G[28608]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28610]={'241250','0A9125','015125','171125','1D6125'}
G[28611]={'495250'}
G[28614]={'2401400'}
G[28615]={'2401000'}
G[28616]={'044500','04C500'}
G[28619]={'04410','0432','04C2','0512','2122','38F2','46D2'}
G[28620]={'04425'}
G[28623]={'49575'}
G[28629]={'241250'}
G[28631]={'241150'}
G[28634]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28635]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28636]={'044250'}
G[28643]={'044350','04387','04C87','05187','21287','38F87','46D87'}
G[28644]={'044350'}
G[28645]={'044350'}
G[28646]={'044350'}
G[28647]={'044500'}
G[28655]={'496350'}
G[28657]={'49A350'}
G[28658]={'49A350'}
G[28659]={'49A350'}
G[28660]={'49A350'}
G[28661]={'49A350'}
G[28662]={'49A350'}
G[28663]={'49A350'}
G[28664]={'49A350'}
G[28665]={'49A350'}
G[28666]={'04810'}
G[28667]={'04C10'}
G[28668]={'49A350'}
G[28669]={'49A350'}
G[28670]={'49A350'}
G[28671]={'04C10'}
G[28672]={'04475','04318','04C18','05118','21218','38F18','46D18'}
G[28673]={'04810'}
G[28678]={'49A250'}
G[28679]={'49A250'}
G[28680]={'49A250'}
G[28681]={'49A350'}
G[28682]={'49A250'}
G[28683]={'49A250'}
G[28684]={'49A250'}
G[28685]={'49A250'}
G[28686]={'49A250'}
G[28687]={'49A250'}
G[28688]={'04C10'}
G[28689]={'49A250'}
G[28690]={'49A250'}
G[28691]={'49A250'}
G[28692]={'49A250'}
G[28693]={'49A250'}
G[28694]={'49A250'}
G[28695]={'49A250'}
G[28696]={'49A250'}
G[28697]={'49A250'}
G[28698]={'49A250'}
G[28699]={'04810'}
G[28700]={'49A250'}
G[28702]={'02F10'}
G[28704]={'46D10'}
G[28705]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[28708]={'04810'}
G[28709]={'41A10'}
G[28711]={'43D10'}
G[28713]={'045250'}
G[28714]={'045250'}
G[28715]={'045250'}
G[28716]={'04810','1D52','02F2','0362','0452','3A22','46E2'}
G[28717]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[28722]={'241350'}
G[28723]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[28724]={'045250'}
G[28725]={'045150'}
G[28726]={'045250'}
G[28727]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[28728]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[28729]={'045150'}
G[28730]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[28731]={'04575'}
G[28734]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[28736]={'495250'}
G[28749]={'04825'}
G[28750]={'04425'}
G[28755]={'2111000'}
G[28756]={'2111000'}
G[28757]={'048250'}
G[28759]={'048250'}
G[28760]={'495500'}
G[28762]={'048250'}
G[28763]={'048250'}
G[28764]={'048250'}
G[28765]={'048250'}
G[28766]={'048250'}
G[28767]={'048250'}
G[28769]={'048250'}
G[28770]={'048250'}
G[28771]={'048250'}
G[28772]={'048250'}
G[28773]={'048250'}
G[28774]={'048250'}
G[28779]={'495500'}
G[28780]={'04825'}
G[28781]={'495500'}
G[28783]={'495500'}
G[28784]={'04825'}
G[28785]={'04825'}
G[28786]={'04825'}
G[28787]={'04825'}
G[28788]={'04825'}
G[28789]={'04825'}
G[28791]={'048250'}
G[28792]={'048250'}
G[28793]={'048250'}
G[28794]={'048250'}
G[28795]={'048250'}
G[28796]={'048250'}
G[28797]={'048250'}
G[28806]={'048250'}
G[28807]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[28808]={'048250'}
G[28809]={'048250'}
G[28810]={'048250'}
G[28811]={'048250'}
G[28812]={'048250'}
G[28813]={'048250'}
G[28814]={'46F500'}
G[28815]={'46F500'}
G[28816]={'04C10'}
G[28817]={'04810'}
G[28818]={'04810'}
G[28819]={'04810'}
G[28820]={'04810'}
G[28821]={'04810'}
G[28822]={'04810'}
G[28823]={'04810'}
G[28824]={'493500'}
G[28827]={'04810'}
G[28832]={'04875','1D518','02F18','03618','04518','3A218','46E18'}
G[28845]={'49510'}
G[28849]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[28850]={'46E10'}
G[28853]={'46F350'}
G[28856]={'26175'}
G[28857]={'04875'}
G[28858]={'04C10','0432','0442','0512','2122','38F2','46D2'}
G[28859]={'26175'}
G[28860]={'496250'}
G[28861]={'496250'}
G[28862]={'496250'}
G[28863]={'496350'}
G[28864]={'496250'}
G[28865]={'04C25'}
G[28866]={'46F10'}
G[28867]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[28868]={'036250'}
G[28870]={'49510'}
G[28871]={'494250'}
G[28872]={'494250'}
G[28873]={'494250'}
G[28874]={'494250'}
G[28875]={'494350'}
G[28876]={'04C10'}
G[28877]={'04C75'}
G[28885]={'46F250'}
G[28909]={'04C10'}
G[29021]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[29022]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[29023]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[29024]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[29026]={'46D75'}
G[29027]={'46D250'}
G[29032]={'24D3000'}
G[29035]={'24D1500'}
G[29037]={'24D1500'}
G[29038]={'24D1500'}
G[29039]={'24D1500'}
G[29040]={'24D1500'}
G[29051]={'24D1500'}
G[29052]={'24D1500'}
G[29053]={'24D1500'}
G[29066]={'48610'}
G[29078]={'048250'}
G[29079]={'048250'}
G[29080]={'04825'}
G[29081]={'048250'}
G[29082]={'048250'}
G[29083]={'04810'}
G[29101]={'486150'}
G[29122]={'486250'}
G[29123]={'486250'}
G[29125]={'486150'}
G[29126]={'486250'}
G[29127]={'486250'}
G[29128]={'486350'}
G[29137]={'486250'}
G[29138]={'486250'}
G[29139]={'486250'}
G[29141]={'486250'}
G[29142]={'486250'}
G[29143]={'486250'}
G[29145]={'48610'}
G[29146]={'04C250'}
G[29147]={'486150'}
G[29148]={'486250'}
G[29149]={'486250'}
G[29159]={'486250'}
G[29160]={'486250'}
G[29161]={'486150'}
G[29162]={'486250'}
G[29163]={'486250'}
G[29164]={'486150'}
G[29165]={'486250'}
G[29166]={'486250'}
G[29167]={'04C250'}
G[29176]={'04C250'}
G[29177]={'48610'}
G[29179]={'486250'}
G[29181]={'486350'}
G[29182]={'48625'}
G[29189]={'486250'}
G[29191]={'04C250'}
G[29192]={'486250'}
G[29195]={'486250'}
G[29196]={'48610'}
G[29197]={'486250'}
G[29198]={'486250'}
G[29199]={'486250'}
G[29200]={'486250'}
G[29201]={'486350'}
G[29202]={'48610'}
G[29203]={'486350'}
G[29204]={'48625'}
G[29205]={'486250'}
G[29206]={'486250'}
G[29209]={'48625'}
G[29210]={'486250'}
G[29211]={'486250'}
G[29214]={'486350'}
G[29215]={'48625'}
G[29243]={'486350'}
G[29245]={'48675'}
G[29246]={'486250'}
G[29247]={'486250'}
G[29248]={'486250'}
G[29249]={'48675'}
G[29254]={'486250'}
G[29255]={'486250'}
G[29257]={'486250'}
G[29263]={'486250'}
G[29264]={'486250'}
G[29265]={'486250'}
G[29272]={'486250'}
G[29273]={'486250'}
G[29274]={'486250'}
G[29275]={'486250'}
G[29276]={'486250'}
G[29278]={'486250'}
G[29279]={'486350'}
G[29280]={'48625'}
G[29281]={'486350'}
G[29282]={'48625'}
G[29283]={'486350'}
G[29284]={'48625'}
G[29287]={'486250'}
G[29288]={'486250'}
G[29289]={'486250'}
G[29290]={'486250'}
G[29293]={'486250'}
G[29295]={'486250'}
G[29296]={'486250'}
G[29297]={'486250'}
G[29298]={'48675'}
G[29299]={'486250'}
G[29302]={'48675'}
G[29304]={'486250'}
G[29305]={'486350'}
G[29310]={'48675'}
G[29311]={'486500'}
G[29313]={'045250'}
G[29314]={'045250'}
G[29315]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[29316]={'045250'}
G[29317]={'044250'}
G[29318]={'045250'}
G[29319]={'044250'}
G[29320]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[29321]={'045250'}
G[29322]={'044250'}
G[29323]={'045250'}
G[29324]={'045250'}
G[29325]={'045250'}
G[29326]={'46F75'}
G[29327]={'46F350'}
G[29328]={'46F350'}
G[29329]={'46F350'}
G[29330]={'46F500'}
G[29331]={'46F1000'}
G[29332]={'044250'}
G[29333]={'044250'}
G[29334]={'044250'}
G[29335]={'46F75'}
G[29336]={'46F75'}
G[29337]={'46F75'}
G[29338]={'46F75'}
G[29342]={'02F250'}
G[29343]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[29344]={'02F250','1D562','03662','04562','04862','3A262','46E62'}
G[29345]={'051250'}
G[29346]={'051250'}
G[29347]={'02F250'}
G[29348]={'051250'}
G[29349]={'051250'}
G[29350]={'02F250'}
G[29351]={'02F250'}
G[29352]={'02F250'}
G[29353]={'02F250'}
G[29354]={'051250'}
G[29355]={'02F250'}
G[29356]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29357]={'045250'}
G[29358]={'051250'}
G[29359]={'045250'}
G[29360]={'044250'}
G[29361]={'044250'}
G[29362]={'051250'}
G[29363]={'051250'}
G[29364]={'051250'}
G[29365]={'051250'}
G[29386]={'04810'}
G[29392]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[29398]={'048150'}
G[29399]={'048150'}
G[29402]={'048250'}
G[29406]={'4C0250'}
G[29408]={'4C0250'}
G[29409]={'4C0250'}
G[29410]={'4C025'}
G[29411]={'048250'}
G[29414]={'4C0250'}
G[29415]={'04C150'}
G[29416]={'04C150'}
G[29417]={'4C0250'}
G[29418]={'4C0250'}
G[29419]={'4C0250'}
G[29420]={'4C025'}
G[29421]={'4C0250'}
G[29422]={'4C0250'}
G[29423]={'4C075'}
G[29424]={'4C0250'}
G[29425]={'04C150'}
G[29426]={'04C250'}
G[29428]={'04C250'}
G[29430]={'04810','1D52','02F2','0362','0452','3A22','46E2'}
G[29431]={'04410'}
G[29433]={'38D250'}
G[29434]={'38D250'}
G[29436]={'38D250'}
G[29437]={'486250'}
G[29438]={'38D250'}
G[29439]={'46F75'}
G[29440]={'46F75'}
G[29443]={'38D250'}
G[29444]={'38D250'}
G[29445]={'38D250'}
G[29446]={'38D250'}
G[29451]={'38D250'}
G[29455]={'38D250'}
G[29456]={'38D250'}
G[29457]={'38D250'}
G[29458]={'38D250'}
G[29463]={'38D250'}
G[29464]={'38D250'}
G[29506]={'38D250'}
G[29507]={'38D250'}
G[29508]={'38D250'}
G[29509]={'38D250'}
G[29510]={'38D250'}
G[29511]={'38D250'}
G[29512]={'38D250'}
G[29513]={'38D250'}
G[29514]={'38D250'}
G[29515]={'38D250'}
G[29516]={'38D250'}
G[29517]={'38D250'}
G[29518]={'38D250'}
G[29519]={'38D250'}
G[29520]={'38D250'}
G[29521]={'4C025'}
G[29522]={'4C025'}
G[29523]={'4C0250'}
G[29524]={'4C0250'}
G[29527]={'3B3350'}
G[29528]={'3B2350'}
G[29529]={'3B2350'}
G[29530]={'3B3350'}
G[29535]={'3B3350'}
G[29536]={'3B3350'}
G[29537]={'3B3350'}
G[29558]={'4DA2000'}
G[29559]={'4DA2000'}
G[29560]={'4DA2000'}
G[29562]={'4DA1000'}
G[29563]={'3AE500'}
G[29573]={'3A5250'}
G[29574]={'3A5150'}
G[29575]={'3A5250'}
G[29598]={'3DD1000'}
G[29599]={'3DD1000'}
G[29605]={'3F3350'}
G[29609]={'46410','41C5','4282','42B2','43D2'}
G[29612]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[29613]={'3AE500'}
G[29640]={'3F3250'}
G[29642]={'3F3150'}
G[29643]={'3F3350'}
G[29649]={'3B2250'}
G[29652]={'3B2250'}
G[29654]={'3B2500'}
G[29656]={'3B2350'}
G[29661]={'4C0250'}
G[29662]={'4C0250'}
G[29663]={'4C0250'}
G[29664]={'4C0250'}
G[29665]={'4C0250'}
G[29666]={'4C0250'}
G[29676]={'4C025'}
G[29677]={'4C0250'}
G[29678]={'4C025'}
G[29679]={'4C0250'}
G[29680]={'4C025'}
G[29734]={'1D575','04375'}
G[29735]={'1D575','04375'}
G[29736]={'1D575','04375'}
G[29737]={'1D575','04375'}
G[29738]={'1D575','04375'}
G[29739]={'1D575','04375'}
G[29740]={'1D575','04375'}
G[29741]={'1D575','04375'}
G[29742]={'1D575','04375'}
G[29759]={'4DA4000'}
G[29762]={'4DA2500'}
G[29768]={'4C0250'}
G[29769]={'4C0250'}
G[29770]={'4C0250'}
G[29771]={'4C0250'}
G[29772]={'4C0250'}
G[29774]={'4C0250'}
G[29775]={'4C0250'}
G[29776]={'4C0250'}
G[29777]={'4C0250'}
G[29778]={'4C0250'}
G[29779]={'4C0250'}
G[29780]={'4C0250'}
G[29781]={'4C0250'}
G[29782]={'4C0250'}
G[29783]={'4C0250'}
G[29784]={'4C0250'}
G[29785]={'4C0250'}
G[29786]={'4C0250'}
G[29787]={'4C0250'}
G[29788]={'4C0250'}
G[29789]={'4C0250'}
G[29790]={'4C0250'}
G[29791]={'4C0250'}
G[29792]={'4C0250'}
G[29793]={'4C0250'}
G[29794]={'4C0250'}
G[29795]={'4C0250'}
G[29796]={'4C0250'}
G[29797]={'4C0250'}
G[29798]={'4C0250'}
G[29799]={'4C0250'}
G[29800]={'4C0250'}
G[29830]={'442500'}
G[29879]={'4CC200'}
G[29883]={'4DA2500'}
G[29887]={'4DA2500'}
G[29894]={'4DA5000'}
G[29903]={'4DA4000'}
G[29904]={'4DA4500'}
G[29905]={'4DA5000'}
G[29906]={'4DA5000'}
G[29907]={'54710'}
G[29919]={'54775'}
G[29933]={'4CC500'}
G[29939]={'4CC500'}
G[29944]={'547250'}
G[29946]={'547350'}
G[29948]={'547250'}
G[29949]={'54725'}
G[29951]={'547250'}
G[29952]={'547350'}
G[29967]={'4CC41000'}
G[30000]={'53D250'}
G[30006]={'53D250'}
G[30027]={'4C010'}
G[30033]={'4C0250'}
G[30034]={'4C0250'}
G[30035]={'4C0250'}
G[30036]={'4C0250'}
G[30037]={'4C0250'}
G[30038]={'4C0250'}
G[30039]={'4C010'}
G[30040]={'4C010'}
G[30041]={'4C010'}
G[30042]={'4C010'}
G[30043]={'4C010'}
G[30044]={'4C010'}
G[30045]={'4C010'}
G[30046]={'547250'}
G[30048]={'54710'}
G[30049]={'54710'}
G[30051]={'547250'}
G[30053]={'547250'}
G[30055]={'547250'}
G[30063]={'53D250'}
G[30064]={'53D250'}
G[30065]={'53D250'}
G[30066]={'53D250'}
G[30067]={'53D350'}
G[30068]={'53D350'}
G[30073]={'547250'}
G[30074]={'54710'}
G[30075]={'547250'}
G[30076]={'547250'}
G[30078]={'547500'}
G[30112]={'41C500','428250','42B250','43D250','464250'}
G[30134]={'4F7500'}
G[30135]={'4F71000'}
G[30136]={'4F71000'}
G[30137]={'4F71000'}
G[30138]={'4F7500'}
G[30139]={'4F7500'}
G[30140]={'4F7500'}
G[30141]={'4F7500'}
G[30142]={'4F71500'}
G[30143]={'4F7200'}
G[30144]={'4F7400'}
G[30145]={'4F7600'}
G[30146]={'4F7125'}
G[30147]={'4F7125'}
G[30148]={'4F7125'}
G[30149]={'4F7125'}
G[30150]={'4F7450'}
G[30151]={'4F7450'}
G[30152]={'4F7600'}
G[30154]={'4F7450'}
G[30155]={'4F7450'}
G[30156]={'4F7450'}
G[30157]={'4F7450'}
G[30158]={'4F7450'}
G[30159]={'4F7450'}
G[30160]={'4FB540'}
G[30172]={'54710'}
G[30187]={'4F71200'}
G[30189]={'4FB540'}
G[30190]={'4F5100'}
G[30191]={'4F5100'}
G[30192]={'4F5100'}
G[30193]={'4F5100'}
G[30194]={'4F5100'}
G[30195]={'4F5100'}
G[30196]={'4F5100'}
G[30200]={'4F5100'}
G[30204]={'4F5100'}
G[30205]={'4F5100'}
G[30206]={'4F5100'}
G[30225]={'4F5200'}
G[30227]={'4F5200'}
G[30228]={'4F5100'}
G[30231]={'4F5100'}
G[30232]={'4F5100'}
G[30233]={'4F5200'}
G[30234]={'4F5200'}
G[30235]={'4F5200'}
G[30236]={'4F5200'}
G[30237]={'4F5100'}
G[30238]={'4F5100'}
G[30239]={'4F5200'}
G[30240]={'4F5100'}
G[30242]={'4F5100'}
G[30243]={'4F5100'}
G[30244]={'4F5100'}
G[30245]={'4F5100'}
G[30246]={'4F5100'}
G[30248]={'4F5200'}
G[30249]={'4F5200'}
G[30251]={'4F5200'}
G[30252]={'4F8900'}
G[30254]={'4F8500'}
G[30255]={'4F8500'}
G[30256]={'4F8700'}
G[30257]={'4F8999','5013000'}
G[30258]={'4F8400'}
G[30259]={'4F8400'}
G[30260]={'4F8500'}
G[30261]={'4F5200'}
G[30263]={'4F5100'}
G[30264]={'4F5200'}
G[30265]={'4F5100'}
G[30266]={'4F5100'}
G[30273]={'53D250'}
G[30277]={'4F5200'}
G[30280]={'4F5200'}
G[30281]={'4F5100'}
G[30282]={'4F5100'}
G[30283]={'4F5100'}
G[30284]={'4F5100'}
G[30285]={'4F5100'}
G[30286]={'4F5100'}
G[30287]={'4F5100'}
G[30288]={'4F5100'}
G[30289]={'4F5100'}
G[30290]={'4F5100'}
G[30291]={'4F5100'}
G[30293]={'4F5100'}
G[30296]={'4F5200'}
G[30297]={'4F5200'}
G[30298]={'4F5100'}
G[30299]={'4F5100'}
G[30301]={'4F5100'}
G[30302]={'4F5200'}
G[30304]={'4F5100'}
G[30305]={'4F5100'}
G[30306]={'4F5100'}
G[30307]={'4F5100'}
G[30308]={'4F5100'}
G[30309]={'4F5100'}
G[30310]={'4F5100'}
G[30312]={'4F5100'}
G[30314]={'4F5100'}
G[30317]={'5032000','4F8150'}
G[30318]={'4FC3000','4F8150'}
G[30319]={'4FF3300','4F8150'}
G[30320]={'4F5100'}
G[30321]={'4F92000','4F8150'}
G[30322]={'5012600','4F8150'}
G[30323]={'5002000','4F8150'}
G[30324]={'4FD2000','4F8150'}
G[30325]={'4FE2000','4F8150'}
G[30326]={'5022000','4F8150'}
G[30327]={'4FB2000','4F8150'}
G[30333]={'4F8275'}	-- reported in 16135 as 4F8350
G[30334]={'4F8275'}
G[30335]={'4F8275'}	-- reported in 16135 as 4F8350
G[30336]={'4F8275'}	-- reported in 16135 as 4F8350
G[30337]={'4F8275'}
G[30338]={'4F5100'}
G[30339]={'4F5100'}
G[30340]={'4F5100'}
G[30341]={'4F5100'}
G[30342]={'4F5100'}
G[30379]={'501540'}
G[30380]={'501540'}
G[30381]={'4FB900'}
G[30382]={'4FB540'}
G[30383]={'4FB540'}
G[30386]={'4FB1800'}
G[30387]={'501540'}
G[30388]={'501540'}
G[30389]={'501900'}
G[30390]={'5011800'}
G[30391]={'4FC540'}
G[30392]={'4FC540'}
G[30393]={'4FC540'}
G[30394]={'4FC900'}
G[30395]={'4FC540'}
G[30396]={'4FC1800'}
G[30397]={'4FD540'}
G[30398]={'4FD540'}
G[30399]={'4FD540'}
G[30400]={'4FD900'}
G[30401]={'4FD540'}
G[30402]={'4FD1800'}
G[30403]={'4FE540'}
G[30404]={'4FE900'}
G[30405]={'4FE540'}
G[30406]={'4FE540'}
G[30407]={'4FE540'}
G[30408]={'4FE1800'}
G[30409]={'4FF900'}
G[30410]={'4FF540'}
G[30411]={'4FF540'}
G[30412]={'4FF540'}
G[30413]={'4FF540'}
G[30414]={'4FF1800'}
G[30415]={'4FD540'}
G[30416]={'503540'}
G[30417]={'503540'}
G[30418]={'503540'}
G[30419]={'503540'}
G[30420]={'503900'}
G[30421]={'5031800'}
G[30422]={'502540'}
G[30423]={'502540'}
G[30424]={'502900'}
G[30425]={'502540'}
G[30426]={'502540'}
G[30427]={'5021800'}
G[30428]={'500900'}
G[30429]={'500540'}
G[30430]={'500540'}
G[30431]={'500540'}
G[30432]={'500540'}
G[30433]={'5001800'}
G[30434]={'4F9540'}
G[30435]={'4F9900'}
G[30436]={'4F9540'}
G[30437]={'4F9540'}
G[30438]={'4F9540'}
G[30439]={'4F91800'}
G[30444]={'4F5100'}
G[30470]={'5001400','4F8150'}
G[30471]={'4FD1400','4F8150'}
G[30472]={'4FE1400','4F8150'}
G[30473]={'5021400','4F8150'}
G[30474]={'4FB1400','4F8150'}
G[30475]={'5031400','4F8150'}
G[30476]={'4FC1400','4F8150'}
G[30477]={'4FF1400','4F8150'}
G[30478]={'4F91400','4F8150'}
G[30479]={'5011400','4F8150'}
G[30481]={'4F5100'}
G[30482]={'4F5200'}
G[30516]={'4F8500'}
G[30517]={'4F8250','5031000'}
G[30518]={'4F8250','5037000'}
G[30519]={'4F8400'}
G[30521]={'4F8300','4FF2000'}
G[30522]={'4F8300'}
G[30523]={'4F8500'}
G[30524]={'4F8500'}
G[30525]={'4F8300'}
G[30526]={'4F8500'}
G[30527]={'4F8300'}
G[30528]={'4F81000'}
G[30535]={'4F8500'}
G[30584]={'516500'}
G[30585]={'516500'}
G[30586]={'516500'}
G[30588]={'516500'}
G[30589]={'4C0250'}
G[30590]={'4C0250'}
G[30591]={'4C0250'}
G[30598]={'516500'}
G[30613]={'516500'}
G[30631]={'4F5150'}
G[30632]={'4F525'}
G[30633]={'4F5150'}
G[30634]={'4F5150'}
G[30635]={'4F5150'}
G[30636]={'4F5150'}
G[30637]={'4F5150'}
G[30638]={'4F525'}
G[30639]={'4F5250'}
G[30640]={'4F5150'}
G[30641]={'4F5150'}
G[30642]={'4F5150'}
G[30643]={'4F525'}
G[30644]={'4F525'}
G[30645]={'4F5150'}
G[30646]={'4F5250'}
G[30649]={'4F5150'}
G[30658]={'516500'}
G[30665]={'4F675'}
G[30670]={'4F675'}
G[30678]={'516500'}
G[30690]={'4F6100'}
G[30698]={'516500'}
G[30699]={'4F625'}
G[30700]={'516500'}
G[30701]={'516500'}
G[30715]={'4F675'}
G[30716]={'53D250'}
G[30717]={'53D250'}
G[30718]={'53D250'}
G[30723]={'4F675'}
G[30724]={'4F625'}
G[30725]={'53D350'}
G[30726]={'53D350'}
G[30727]={'53D350'}
G[30728]={'53D350'}
G[30729]={'53D350'}
G[30730]={'53D350'}
G[30731]={'53D350'}
G[30732]={'53D350'}
G[30733]={'53D350'}
G[30734]={'53D350'}
G[30735]={'53D350'}
G[30736]={'53D350'}
G[30737]={'53D350'}
G[30738]={'53D350'}
G[30739]={'53D350'}
G[30740]={'53D350'}
G[30750]={'4F675'}
G[30751]={'4F675'}
G[30752]={'4F6100'}
G[30753]={'516500'}
G[30754]={'516500'}
G[30757]={'4F6500'}
G[30763]={'516500'}
G[30767]={'4C0250'}
G[30768]={'4F625'}
G[30769]={'4F6100'}
G[30770]={'4F675'}
G[30771]={'4F675'}
G[30772]={'4F6100'}
G[30773]={'4F675'}
G[30774]={'4F675'}
G[30775]={'4F675'}
G[30776]={'4F6100'}
G[30777]={'4F675'}
G[30778]={'4F675'}
G[30779]={'4F675'}
G[30780]={'4F675'}
G[30781]={'4F6100'}
G[30782]={'4F675'}
G[30783]={'4F675'}
G[30784]={'4F6100'}
G[30785]={'4F625'}
G[30814]={'4F675'}
G[30827]={'4F675'}
G[30879]={'53D250'}
G[30880]={'53D250'}
G[30881]={'53D250'}
G[30882]={'53D250'}
G[30883]={'53D250'}
G[30884]={'4F625'}
G[30885]={'53D250'}
G[30887]={'4F675'}
G[30888]={'4F675'}
G[30889]={'4F675'}
G[30890]={'4F6100'}
G[30891]={'4F675'}
G[30892]={'4F675'}
G[30893]={'4F6100'}
G[30894]={'4F675'}
G[30895]={'4F6100'}
G[30896]={'4F675'}
G[30897]={'4F675'}
G[30898]={'4F675'}
G[30899]={'4F675'}
G[30900]={'4F6100'}
G[30901]={'4F625'}
G[30902]={'53D250'}
G[30907]={'53D250'}
G[30921]={'4F6100'}
G[30922]={'4F675'}
G[30923]={'4F675'}
G[30924]={'4F675'}
G[30925]={'4F6100','53D250'}
G[30926]={'4F6100'}
G[30927]={'4F675'}
G[30928]={'4F675'}
G[30952]={'53D350'}
G[30953]={'53D250'}
G[30954]={'53D250'}
G[30955]={'53D250'}
G[30956]={'53D350'}
G[30957]={'53D250'}
G[30958]={'53D250'}
G[30959]={'53D250'}
G[30960]={'4F625'}
G[30963]={'4F6100'}
G[30964]={'4F675'}
G[30968]={'4F6500'}
G[30970]={'4F6100'}
G[30971]={'4F675'}
G[30972]={'4F625'}
G[30973]={'4F6100'}
G[30974]={'4F6250'}
G[30975]={'4F6100'}
G[30976]={'4F625'}
G[30977]={'4F6100'}
G[30978]={'4F675'}
G[30979]={'4F6100'}
G[30980]={'4F625'}
G[30981]={'4F675'}
G[30991]={'4F675'}
G[30992]={'4F6100'}
G[30993]={'4F625'}
G[30994]={'4F625'}
G[31003]={'539250'}
G[31004]={'539500'}
G[31005]={'539250'}
G[31006]={'539250'}
G[31007]={'539250'}
G[31008]={'539250'}
G[31009]={'539250'}
G[31010]={'539500'}
G[31018]={'539250'}
G[31019]={'539250'}
G[31020]={'539250'}
G[31021]={'539250'}
G[31022]={'539250'}
G[31023]={'539250'}
G[31024]={'539130'}
G[31026]={'539500'}
G[31030]={'4F625'}
G[31032]={'4F675'}
G[31038]={'4F6350'}
G[31039]={'4F6250'}
G[31040]={'4F6250'}
G[31041]={'4F6250'}
G[31042]={'4F6250'}
G[31043]={'4F6250'}
G[31044]={'4F6250'}
G[31045]={'4F6250'}
G[31046]={'4F6250'}
G[31047]={'4F6250'}
G[31048]={'4F6250'}
G[31049]={'4F6250'}
G[31055]={'5412850'}
G[31061]={'4F6250'}
G[31062]={'4F6250'}
G[31063]={'4F675'}
G[31064]={'4F675'}
G[31065]={'4F625'}
G[31066]={'539500'}
G[31085]={'539500'}
G[31087]={'539250'}
G[31088]={'539250'}
G[31089]={'539500'}
G[31090]={'539250'}
G[31091]={'539250'}
G[31092]={'539250'}
G[31093]={'5412850'}
G[31094]={'5412850'}
G[31095]={'5412850'}
G[31096]={'5412850'}
G[31097]={'5412850'}
G[31100]={'5412850'}
G[31102]={'5412850'}
G[31103]={'5412850'}
G[31104]={'4F6350'}
G[31105]={'4F6250'}
G[31106]={'4F6250'}
G[31107]={'539250'}
G[31108]={'539250'}
G[31109]={'539130'}
G[31110]={'4F6250'}
G[31111]={'539130'}
G[31113]={'4F6250'}	-- reported in 16135 (zhTW) as 4F6125, but not consistent with enUS experience
G[31114]={'4F6250'}	-- reported in 16135 (zhTW) as 4F6125, but not consistent with enUS experience
G[31116]={'4F6250'}
G[31117]={'4F6250'}
G[31118]={'4F6250'}	-- reported in 16135 (zhTW) as 4F6125, but not consistent with enUS experience
G[31119]={'4F6250'}	-- reported in 16135 (zhTW) as 4F6125, but not consistent with enUS experience
G[31120]={'4F6250'}
G[31127]={'4F6350'}
G[31128]={'4F6350'}
G[31135]={'03675','1D518','02F18','04518','04818','3A218','46E18'}
G[31137]={'03610','1D52','02F2','0452','0482','3A22','46E2'}
G[31138]={'03610','1D52','02F2','0452','0482','3A22','46E2'}
G[31139]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[31140]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[31141]={'04875'}
G[31142]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[31143]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[31144]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[31145]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[31146]={'04475'}
G[31147]={'04475'}
G[31158]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[31160]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[31161]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[31162]={'212150','04337','04437','04C37','05137','38F37','46D37'}
G[31163]={'21275','04318','04418','04C18','05118','38F18','46D18'}
G[31165]={'05175'}
G[31166]={'05175','04318','04418','04C18','21218','38F18','46D18'}
G[31168]={'04575'}
G[31169]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[31170]={'38F25'}
G[31171]={'38F250','04362','04462','04C62','05162','21262','46D62'}
G[31173]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[31175]={'539250'}
G[31176]={'539250'}
G[31177]={'539250'}
G[31178]={'539250'}
G[31179]={'539250'}
G[31181]={'516250'}
G[31182]={'516250'}
G[31183]={'51610'}
G[31184]={'516250'}
G[31185]={'516250'}
G[31186]={'516250'}
G[31187]={'516250'}
G[31188]={'516250'}
G[31189]={'516250'}
G[31190]={'516500'}
G[31194]={'4F7600'}
G[31196]={'4F6250'}
G[31197]={'4F6250'}
G[31198]={'4F6250'}
G[31199]={'4F6250'}
G[31200]={'4F6250'}
G[31201]={'4F6250'}
G[31203]={'4F6250'}
G[31204]={'4F6250'}
G[31208]={'539250'}
G[31209]={'539250'}
G[31210]={'539250'}
G[31211]={'539250'}
G[31216]={'539130'}
G[31220]={'4F6350'}
G[31221]={'4F6350'}
G[31231]={'539130'}
G[31232]={'539130'}
G[31233]={'539130'}
G[31234]={'539130'}
G[31235]={'539130'}
G[31237]={'539130'}
G[31238]={'539130'}
G[31239]={'4CC350'}
G[31242]={'4F5250'}
G[31261]={'4CC350'}
G[31265]={'51610'}
G[31267]={'539130'}
G[31268]={'539130'}
G[31269]={'539130'}
G[31270]={'539130'}
G[31271]={'539130'}
G[31272]={'539130'}
G[31277]={'4F6500'}
G[31293]={'4F5100'}
G[31320]={'4F91000'}
G[31321]={'4F93000'}
G[31322]={'4F95000'}
G[31323]={'4F96000'}
G[31325]={'5003750'}
G[31326]={'5003750'}
G[31328]={'5003750'}
G[31329]={'5003750'}
G[31332]={'54D1000'}
G[31333]={'54D1000'}
G[31334]={'54D1000'}
G[31335]={'54D1000'}
G[31336]={'54D1000'}
G[31337]={'54D1000'}
G[31338]={'4FD3750'}
G[31339]={'4FD3750'}
G[31340]={'4FD3750'}
G[31341]={'4FD3750'}
G[31342]={'4F6500'}
G[31354]={'539500'}
G[31359]={'539250'}
G[31394]={'53D250'}
G[31395]={'53D250'}
G[31398]={'539250'}
G[31439]={'53910'}
G[31441]={'539250'}
G[31443]={'516350','54E500'}
G[31444]={'516350','54E500'}
G[31446]={'516350','54E500'}
G[31454]={'54F25'}
G[31458]={'539250'}
G[31465]={'539250'}
G[31468]={'54F75'}
G[31473]={'54F250'}
G[31481]={'54F250'}
G[31482]={'54F75'}
G[31487]={'539130'}
G[31492]={'53D250'}
G[31494]={'539130'}
G[31496]={'539130'}
G[31502]={'539130'}
G[31503]={'539130'}
G[31504]={'539130'}
G[31505]={'539130'}
G[31506]={'539130'}
G[31507]={'539130'}
G[31508]={'539130'}
G[31509]={'539130'}
G[31510]={'539130'}
G[31511]={'4F575'}
G[31512]={'4F575'}
G[31517]={'53D250'}
G[31529]={'4FE3750'}
G[31531]={'4FE3750'}
G[31532]={'4FE3750'}
G[31534]={'4FB5000'}
G[31537]={'4FB5000'}
G[31538]={'4FB5000'}
G[31576]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[31598]={'539130'}
G[31599]={'539130'}
G[31605]={'539250'}
G[31606]={'539250'}
G[31609]={'539350'}
G[31611]={'547350'}
G[31612]={'539350'}
G[31660]={'539250'}
G[31661]={'539250'}
G[31669]={'4F8350'}
G[31670]={'4F8350'}
G[31671]={'4F8350'}
G[31672]={'4F8350'}
G[31673]={'4F8350'}
G[31674]={'4F8350'}
G[31675]={'4F8350'}
G[31676]={'539250'}
G[31677]={'539130'}
G[31687]={'4F6100'}
G[31688]={'4F675'}
G[31689]={'539250'}
G[31698]={'4F7450'}
G[31699]={'4F7450'}
G[31700]={'4F7450'}
G[31701]={'4F7600'}
G[31702]={'4F7600'}
G[31703]={'4F7600'}
G[31704]={'4F7450'}
G[31705]={'4F7600'}
G[31706]={'4F7450'}
G[31707]={'4F7450'}
G[31709]={'4F7450'}
G[31711]={'4F7600'}
G[31712]={'4F7450'}
G[31713]={'4F7450'}
G[31714]={'4F7450'}
G[31715]={'4F7600'}
G[31717]={'4F7450'}
G[31718]={'4F7450'}
G[31719]={'4F7450'}
G[31736]={'4F65'}
G[31737]={'4F65'}
G[31754]={'4F5100'}
G[31755]={'4F5100'}
G[31756]={'4F5100'}
G[31757]={'4F5100'}
G[31758]={'4F5100'}
G[31760]={'4F5100'}
G[31762]={'4F5100'}
G[31771]={'4F65'}
G[31784]={'4F7500'}
G[31808]={'539130'}
G[31809]={'4F6500'}
G[31820]={'54D1000'}
G[31936]={'4F8250'}
G[31937]={'4F8250'}
G[31938]={'4F8250'}
G[31941]={'4F8350'}
G[31942]={'4F8350'}
G[31943]={'4F8350'}
G[31945]={'4F81400','5016000'}
G[31946]={'4F8400'}
G[31947]={'4F8250','5037000'}
G[31948]={'4F8400'}
G[31949]={'4F8400'}
G[31959]={'539250'}
G[32030]={'53910'}
end

if release >= 16135 then
G[8311]={'1D5250','02F250','036250','045250','048250','3A2250','46E250'}
G[8473]={'38F250','04362','04462','04C62','05162','21262','46D62'}
G[9252]={'38F250','04362','04462','04C62','05162','21262','46D62'}
G[9395]={'38F75'}
G[9845]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[9904]={'212250','04362','04462','04C62','05162','38F62','46D62'}
G[11440]={'3A275','1D518','02F18','03618','04518','04818','46E18'}
G[11449]={'04475','04318','04C18','05118','21218','38F18','46D18'}
G[12444]={'41A250','40D125','42C62','44662','46662'}
G[13646]={'04510','1D52','02F2','0362','0482','3A22','46E2'}
G[14024]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[14030]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[14036]={'04410','0432','04C2','0512','2122','38F2','46D2'}
G[25694]={'04C350','04387','04487','05187','21287','38F87','46D87'}
G[25695]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[25729]={'036250','1D562','02F62','04562','04862','3A262','46E62'}
G[26278]={'04C250','04362','04462','05162','21262','38F62','46D62'}
G[26921]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26922]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26923]={'044350','04387','04C87','05187','21287','38F87','46D87'}
G[26965]={'044150','04337','04C37','05137','21237','38F37','46D37'}
G[26989]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26992]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26995]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[26998]={'044350','04387','04C87','05187','21287','38F87','46D87'}
G[27045]={'044500','043125','04C125','051125','212125','38F125','46D125'}
G[27056]={'04410','0432','04C2','0512','2122','38F2','46D2'}
G[27082]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[27088]={'044350','04387','04C87','05187','21287','38F87','46D87'}
G[27733]={'048500','1D5125','02F125','036125','045125','3A2125','46E125'}
G[27917]={'46E500','1D5125','02F125','036125','045125','048125','3A2125'}
G[27920]={'46E500','1D5125','02F125','036125','045125','048125','3A2125'}
G[27921]={'46E500','1D5125','02F125','036125','045125','048125','3A2125'}
G[27968]={'46E500','1D5125','02F125','036125','045125','048125','3A2125'}
G[28089]={'044250','04362','04C62','05162','21262','38F62','46D62'}
G[28750]={'04425','0436','04C6','0516','2126','38F6','46D6'}
G[29398]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[29399]={'048150','1D537','02F37','03637','04537','3A237','46E37'}
G[29402]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[29411]={'048250','1D562','02F62','03662','04562','3A262','46E62'}
G[29415]={'04C150','04337','04437','05137','21237','38F37','46D37'}
G[29542]={'3B3250'}
end

if release >= 16139 then
G[32108]={'55F500','043250','044250','04C250','051250','212250','38F250','46D250','548250'}
G[32109]={'560500','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[32115]={'560150'}
G[32119]={'560150'}
G[32120]={'55F150'}
G[32121]={'560150'}
G[32122]={'560300'}
G[32123]={'55F150'}
G[32126]={'55F150'}
G[32127]={'55F300'}
G[32128]={'55F150'}
G[32130]={'55F150'}
G[32131]={'55F150'}
G[32132]={'55F150'}
G[32133]={'55F150'}
G[32135]={'55F300'}
G[32137]={'55F150'}
G[32139]={'55F150'}
G[32142]={'560150'}
G[32143]={'560150'}
G[32144]={'560150'}
G[32145]={'560300'}
G[32146]={'560150'}
G[32148]={'560150'}
G[32149]={'560150'}
G[32150]={'560150'}
G[32151]={'560150'}
G[32152]={'560150'}
G[32153]={'560300'}
G[32154]={'560150'}
G[32156]={'560150'}
G[32157]={'560150'}
G[32158]={'560300'}
G[32167]={'55F200'}
G[32168]={'55F200'}
G[32169]={'55F200'}
G[32170]={'560200'}
G[32171]={'560200'}
G[32172]={'560200'}
G[32189]={'4F810'}
G[32190]={'55F150'}
G[32191]={'55F250'}
G[32192]={'55F250'}
G[32193]={'560150'}
G[32194]={'560400'}
G[32197]={'55F150'}
G[32198]={'4F875'}
G[32199]={'55F150'}
G[32214]={'55F150'}
G[32221]={'55F150'}
G[32222]={'55F300'}
G[32223]={'55F300'}
G[32235]={'55F150'}
G[32237]={'55F150'}
G[32238]={'55F150'}
G[32242]={'55F150'}
G[32243]={'560400'}
G[32244]={'55F250'}
G[32246]={'560150','1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[32247]={'560300','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[32248]={'560150'}
G[32249]={'55F150','04310','04410','04C10','05110','21210','38F10','46D10','54810'}
G[32250]={'55F300','043250','044250','04C250','051250','212250','38F250','46D250','548250'}
G[32251]={'55F150'}
G[32256]={'55F150'}
G[32257]={'55F400'}
G[32284]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[32315]={'560200','1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[32316]={'560500','1D5500','02F500','036500','045500','048500','3A2500','46E500','549500'}
G[32318]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[32319]={'55F200','212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[32320]={'55F350','212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[32321]={'560150'}
G[32331]={'560200'}
G[32332]={'560150'}
G[32333]={'560150'}
G[32334]={'560150'}
G[32335]={'560250'}
G[32336]={'560250'}
G[32337]={'560250'}
G[32338]={'560250'}
G[32342]={'55F150'}
G[32343]={'55F300'}
G[32344]={'55F150'}
G[32345]={'55F150'}
G[32346]={'560150'}
G[32347]={'560150'}
G[32348]={'55F150'}
G[32355]={'560100'}
G[32362]={'560500','1D5350','02F350','036350','045350','048350','3A2350','46E350','549350'}
G[32370]={'560150'}
G[32371]={'560400'}
G[32372]={'55F450','212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[32373]={'54F75'}
G[32374]={'54F250'}
G[32377]={'560400'}
G[32380]={'560150'}
G[32381]={'560400'}
G[32382]={'560150'}
G[32383]={'560400'}
G[32393]={'560200','1D510','02F10','03610','04510','04810','3A210','46E10','54910'}
G[32394]={'560500','1D5350','02F350','036350','045350','048350','3A2350','46E350','549350'}
G[32397]={'560400'}
G[32414]={'560100'}
G[32416]={'560100'}
G[32417]={'560200','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[32418]={'560200','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[32419]={'560200','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[32420]={'560300','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[32421]={'560300','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[32423]={'560350','1D5350','02F350','036350','045350','048350','3A2350','46E350','549350'}
G[32426]={'560400'}
G[32446]={'560150'}
G[32455]={'1D5500','02F500','036500','045500','048500','3A2500','46E500','549500'}
G[32460]={'560200'}
G[32474]={'54F250'}
end

if release >= 16309 then
G[32151]={'560300'}
end

if release >= 16357 then
G[850]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[851]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[852]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[855]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[875]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[876]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[1453]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[4021]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[5713]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[6962]={'0A925','01525','17125','1D625','24125'}
G[7061]={'051500','043125','044125','04C125','212125','38F125','46D125','548125'}
G[7223]={'2DA250','02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[8828]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[8860]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[8861]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[9143]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9158]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9174]={'38F250','04362','04462','04C62','05162','21262','46D62','54862','39A1000'}
G[9215]={'38F350','04387','04487','04C87','05187','21287','46D87','54887'}
G[9252]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9274]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9312]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9340]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9370]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9387]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9396]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9397]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9472]={'38F350','04387','04487','04C87','05187','21287','46D87','54887'}
G[9514]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492','3A210','1D52'}
G[9528]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','3A2150','1D537'}
G[9537]={'3A2500','1D5125','02F125','036125','045125','048125','46E125','549125'}
G[9544]={'3A2500','1D5125','02F125','036125','045125','048125','46E125','549125'}
G[9559]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9602]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9603]={'3A275','1D518','02F18','03618','04518','04818','46E18','54918'}
G[9604]={'3A275','1D518','02F18','03618','04518','04818','46E18','54918'}
G[9605]={'3A275','1D518','02F18','03618','04518','04818','46E18','54918'}
G[9606]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9622]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9623]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[10286]={'38F150','04337','04437','04C37','05137','21237','46D37','54837'}
G[10287]={'38F25','0436','0446','04C6','0516','2126','46D6','5486'}
G[10324]={'3A2150','1D537','02F37','03637','04537','04837','46E37','54937'}
G[12122]={'442250'}
G[13504]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13505]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13518]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13520]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13521]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13522]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13527]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13528]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13529]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13537]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[13542]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13543]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13547]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13554]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13557]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13558]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13560]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13561]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13562]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13563]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13564]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13565]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13566]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13569]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13573]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[13578]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13579]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[13589]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13594]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13598]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13599]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937'}
G[13602]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13624]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13636]={'02F150','1D537','03637','04537','04837','3A237','46E37','54937'}
G[13682]={'452250','446250','40D125','41A62','42C62','46662'}
G[13789]={'452250','446250','40D125','41A62','42C62','46662'}
G[13790]={'452250','446250','40D125','41A62','42C62','46662'}
G[13831]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13892]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13893]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[13896]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[14117]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14118]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14127]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[14128]={'38F150','04337','04437','04C37','05137','21237','46D37','54837'}
G[14129]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14134]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14135]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14146]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14155]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[14161]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14162]={'46D25','0436','0446','04C6','0516','2126','38F6','5486'}
G[14165]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14190]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14194]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14196]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[14197]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14201]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[14202]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14209]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[14215]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[14216]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[14423]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14424]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[14468]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[14469]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14470]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14471]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14472]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14478]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[14479]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[14480]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14484]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14485]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14486]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14487]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24435]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24436]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24448]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24449]={'46D500','043125','044125','04C125','051125','212125','38F125','548125'}
G[24452]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[24453]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[24455]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[25118]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25235]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25680]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','212250','04362'}
G[25681]={'04C350','04387','04487','05187','21287','38F87','46D87','54887','212350','04387'}
G[25683]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','38F250','04362'}
G[25696]={'38F75','04318','04418','04C18','05118','21218','46D18','54818'}
G[25905]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25932]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25933]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492','03610','1D52'}
G[25937]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25945]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[25986]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25999]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26001]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26002]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26003]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26004]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26009]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26010]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26011]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26020]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26026]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26028]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[26043]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[26044]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[26045]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26046]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26047]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26048]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26058]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[26059]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26060]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26061]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26062]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[26063]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26066]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26067]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[26068]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26073]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[26074]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26075]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26076]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26077]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[26082]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26097]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26098]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26099]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26100]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26101]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26115]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[26134]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[26153]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26192]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26226]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26227]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26233]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26235]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26278]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26362]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26386]={'212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[26416]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[26465]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26473]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26488]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26509]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26557]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26561]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26562]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26563]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26572]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26573]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26588]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26593]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[26597]={'015500','0A9250','171250','1D6250','241250','057-500'}
G[26618]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26620]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26623]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26666]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[26667]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26669]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26670]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26671]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[26674]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[26688]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26689]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26690]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[26691]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26707]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26717]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26719]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[26720]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26721]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26735]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26760]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[26763]={'015250','0A9125','171125','1D6125','241125'}
G[26765]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26777]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26783]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26821]={'03625','1D56','02F6','0456','0486','3A26','46E6','5496'}
G[26824]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987'}
G[26842]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26888]={'212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[26891]={'212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[26892]={'212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[26965]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[26989]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26992]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26995]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26998]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27039]={'470150'}
G[27045]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27056]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[27082]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27088]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27097]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27098]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27099]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27180]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27181]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27193]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27194]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27195]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27290]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27322]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27333]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27342]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27349]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27350]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27360]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27364]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27401]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27405]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27406]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27423]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27438]={'0441000','043250','04C250','051250','212250','38F250','46D250','548250'}
G[27472]={'0441000','043250','04C250','051250','212250','38F250','46D250','548250'}
G[27474]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27475]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27476]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27478]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27480]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27483]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27484]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27512]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27513]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27518]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27547]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27548]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27550]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27574]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27575]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27577]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27580]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27594]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27601]={'0441000','043250','04C250','051250','212250','38F250','46D250','548250'}
G[27763]={'0A910','01510','17110','1D610','24110'}
G[27842]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27844]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27847]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27848]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27850]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27854]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27855]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27856]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27857]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[28559]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[28562]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28563]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28568]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28573]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28645]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28646]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28647]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28763]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28771]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29354]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[29358]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[29608]={'44610','40D5','41A2','42C2','4662'}
G[30251]={'4F5100'}
G[30969]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[30982]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[30984]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[31812]={'051500','043125','044125','04C125','212125','38F125','46D125','548125'}
G[32346]={'560300'}
G[32419]={'560300','1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
end

if release >= 16408 then
G[32200]={'56C250'}
G[32216]={'56C250'}
G[32217]={'56C250'}
G[32228]={'56C250'}
G[32231]={'56C250'}
G[32252]={'56C250'}
G[32285]={'56C250'}
G[32293]={'56C350'}
G[32525]={'56B250'}
G[32527]={'56B250'}
G[32533]={'56B250'}
G[32535]={'56B250'}
G[32536]={'56B250'}
G[32537]={'56B250'}
G[32539]={'56B250'}
G[32540]={'56B150'}
G[32542]={'56B250'}
G[32546]={'56B250'}
G[32547]={'56B250'}
G[32548]={'56B250'}
G[32578]={'56B350'}
end

if release >= 16446 then
G[32606]={'56B250'}
end

if release >= 16486 then
G[32134]={'55F150'}
G[32249]={'560150','1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[32669]={'560150','1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[32674]={'560150','1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[32678]={'560150','1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[32681]={'56B150'}
end

if release >= 16534 then
G[32428]={'56B350'}
G[32679]={'04C10','0432','0442','0512','2122','38F2','46D2','5482','46D10','0432'}
end

if release >= 16650 then
G[26600]={'015150','0A975','17175','1D675','24175','057-150'}
G[26601]={'015500','0A9250','171250','1D6250','241250','057-500'}
G[26602]={'015350','0A9175','171175','1D6175','241175','057-350'}
G[26732]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26805]={'02F25','1D56','0366','0456','0486','3A26','46E6','5496'}
G[26822]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[32536]={'56B150'}
G[32537]={'56B150'}
G[32538]={'56B150'}
G[32539]={'56B150'}
G[32540]={'56B150'}
G[32543]={'56B150'}
G[32546]={'56B150'}
G[32547]={'56B150'}
G[32606]={'56B150'}
G[32643]={'55F400'}
G[32646]={'560400'}
G[32648]={'4F5400'}
G[32650]={'4F6400'}
G[32657]={'53D400'}
G[32659]={'539400'}
end

if release >= 16669 then
G[25942]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25943]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25944]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[32296]={'59B500'}
G[32388]={'54F350'}
G[32389]={'54F250'}
G[32390]={'54F75'}
G[32525]={'56B150'}
G[32526]={'56B150'}
G[32527]={'56B150'}
G[32528]={'56B150'}
G[32529]={'56B150'}
G[32531]={'56B150'}
G[32532]={'56B150'}
G[32533]={'56B150'}
G[32535]={'56B150'}
G[32536]={'56B150'}
G[32537]={'56B150'}
G[32538]={'56B150'}
G[32539]={'56B150'}
G[32540]={'56B150'}
G[32541]={'56B150'}
G[32542]={'56B150'}
G[32543]={'56B150'}
G[32544]={'56B150'}
G[32545]={'56B150'}
G[32548]={'56B150'}
G[32576]={'56B200'}
G[32577]={'56B200'}
G[32591]={'54F250'}
G[32592]={'54F250'}
G[32606]={'56B150'}
G[32640]={'59B300'}
G[32679]={'38D250'}
G[32706]={'56B150'}
G[32707]={'59B200'}
G[32708]={'59B300'}
end

if release >= 16685 then
G[32571]={'56B150'}
G[32573]={'56B150'}
G[32574]={'56B150'}
G[32578]={'56B200'}
G[32644]={'56B300'}
G[32731]={'56B150'}
G[32732]={'56B150'}
end

if release >= 16709 then
G[26876]={'46F10'}
G[32530]={'56B150'}
G[32572]={'56B150'}
G[32575]={'56B150'}
G[32579]={'56B200'}
G[32581]={'56B200'}
end

if release >= 16716 then
G[28198]={'495250'}
G[32550]={'56B150'}
G[32551]={'56B150'}
G[32553]={'56B150'}
G[32582]={'56B200'}
G[32584]={'56B200'}
G[32654]={'56B300'}
end

if release >= 16733 then
G[30251]={'4F5200'}
G[30335]={'4F8275'}
G[31443]={'516350','54E600'}
G[32212]={'56C300'}
G[32301]={'56B150'}
G[32552]={'56B150'}
G[32554]={'56B150'}
G[32555]={'56B150'}
G[32559]={'56B150'}
G[32560]={'56B150'}
G[32585]={'56B200'}
G[32627]={'56B150'}
G[32633]={'56B150'}
G[32636]={'56B150'}
G[32637]={'56B150'}
G[32639]={'56B150'}
G[32680]={'56C150'}
G[32709]={'56C300'}
end

if release >= 16769 then
G[648]={'015350','0A9175','171175','1D6175','241175','057-350'}
G[1222]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[9375]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9376]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9381]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9697]={'3AE250'}
G[9769]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9770]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9773]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9774]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9814]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9816]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9820]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9822]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9823]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9841]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9842]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9845]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9846]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9898]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9903]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[9904]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[10017]={'3A4250','3A8250','3A6-275','3A7125'}
G[10117]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[10118]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[10412]={'3A6250','3A8250','3A4-275','3A7125'}
G[10416]={'3A6350','3A8350','3A4-385','3A7175'}
G[10553]={'3A610','3A810','3A4-11','3A75'}
G[24932]={'0A9250','015250','171250','1D6250','241250'}
G[24933]={'0A9250','015250','171250','1D6250','241250'}
G[24951]={'0A9250','015250','171250','1D6250','241250'}
G[24953]={'0A9350','015350','171350','1D6350','241350'}
G[25072]={'0A9250','015250','171250','1D6250','241250'}
G[25420]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25515]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25517]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25521]={'171250','0A9125','015125','1D6125','241125'}
G[25522]={'171250','0A9125','015125','1D6125','241125'}
G[25559]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25588]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25590]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25609]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25744]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[26024]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26035]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[26079]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26093]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26110]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26113]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26190]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27160]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27161]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27446]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[30333]={'4F8350'}
G[32557]={'56B150'}
G[32558]={'56B150'}
G[32568]={'56B200'}
G[32580]={'56B200'}
G[32586]={'56B150'}
G[32587]={'56B200'}
G[32588]={'56B150'}
G[32652]={'56B300'}
G[32733]={}
end

if release >= 16826 then
G[2]={'43D250','41C125','42862','42B62','46462'}
G[171]={'1D5500','02F500','036500','045500','048500','3A2500','46E500','549500'}
G[172]={'04310','04410','04C10','05110','21210','38F10','46D10','54810'}
G[1468]={'1D510','02F10','03610','04510','04810','3A210','46E10','54910'}
G[5502]={'043500','044500','04C500','051500','212500','38F500','46D500','548500'}
G[10021]={'3A4250','3A8250','3A6-275','3A7125'}
G[10325]={'3A4250','3A8250','3A6-275','3A7125'}
G[10420]={'3A4350','3A8350','3A6-385','3A7175'}
G[10554]={'3A410','3A810','3A6-11','3A75'}
G[10653]={'3A4250','3A8250','3A6-275','3A7125'}
G[10683]={'3A6250','3A8250','3A4-275','3A7125'}
G[10684]={'3A6250','3A8250','3A4-275','3A7125'}
G[10685]={'3A6250','3A8250','3A4-275','3A7125'}
G[10687]={'3A6250','3A8250','3A4-275','3A7125'}
G[10688]={'3A6250','3A8250','3A4-275','3A7125'}
G[10807]={'3A6250','3A8250','3A4-275','3A7125'}
G[10817]={'3A6250','3A8250','3A4-275','3A7125'}
G[10824]={'3A6250','3A8250','3A4-275','3A7125'}
G[10956]={'3F3250'}
G[11039]={'3A610','3A810','3A4-11','3A75'}
G[13618]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[13620]={'43D250','41C125','42862','42B62','46462'}
G[13628]={'43D250','41C125','42862','42B62','46462'}
G[13640]={'43D250','41C125','42862','42B62','46462'}
G[13651]={'43D250','41C125','42862','42B62','46462'}
G[13653]={'43D150','41C75','42837','42B37','46437'}
G[13712]={'43D150','41C75','42837','42B37','46437'}
G[13730]={'43D250','41C125','42862','42B62','46462'}
G[13751]={'43D25','41C12','4286','42B6','4646'}
G[13797]={'43D150','41C75','42837','42B37','46437'}
G[13803]={'43D75','41C37','42818','42B18','46418'}
G[13805]={'43D250','41C125','42862','42B62','46462'}
G[13841]={'43D25','41C12','4286','42B6','4646'}
G[26420]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26443]={'3A275','1D518','02F18','03618','04518','04818','46E18','54918'}
G[26444]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[26445]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[26447]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[26448]={'43D250','41C125','42862','42B62','46462'}
G[26449]={'43D350','41C175','42887','42B87','46487'}
G[26556]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[27365]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27396]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27746]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[27996]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27998]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28089]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28096]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28111]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[28485]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28493]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[28643]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28644]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28711]={'43D10','41C5','4282','42B2','4642'}
G[29146]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[29167]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[29176]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[29191]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[29363]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[29538]={'3B2350'}
G[29539]={'3B2350'}
G[29540]={'3B3350'}
G[29567]={'3CA350'}
G[29616]={'3AE250'}
G[29691]={'3CA250'}
G[30292]={'4F5100'}
G[30333]={'4F8275'}
G[30646]={'4F51000'}
G[31113]={'4F6250'}
G[31114]={'4F6250'}
G[31118]={'4F6250'}
G[31119]={'4F6250'}
G[31277]={'4F61000'}
G[31605]={'53910'}
G[31810]={'4F71000'}
G[31811]={'4F71000'}
G[32608]={'56B400'}
G[32646]={'53D400'}
G[32655]={'56B300'}
G[32656]={'56B300'}
G[32657]={'560400'}
G[32706]={'56B300'}
G[32732]={}
end

if release >= 16837 then
G[32276]={'56C300'}
G[32277]={'56C300'}
G[32278]={'56C300'}
G[32709]={'56B150'}
end

if release >= 16921 then
G[32279]={'56C300'}
end

if release >= 16965 then
G[32201]={'56C150'}
G[32206]={'56C150'}
G[32219]={'56C150'}
G[32220]={'56C150'}
G[32230]={'56C150'}
G[32493]={'56C150'}
G[32494]={'56C150'}
G[32495]={'56C150'}
end

if release >= 16992 then
G[10568]={'3A4250','3A8250','3A6-275','3A7125'}
G[10571]={'3A4250','3A8250','3A6-275','3A7125'}
G[10574]={'3A4250','3A8250','3A6-275','3A7125'}
G[10575]={'3A475','3A875','3A6-83','3A737'}
G[10587]={'3A4250','3A8250','3A6-275','3A7125'}
G[10619]={'3A4250','3A8250','3A6-275','3A7125'}
G[10637]={'3A4250','3A8250','3A6-275','3A7125'}
G[10640]={'3A475','3A875','3A6-83','3A737'}
G[10816]={'3A4250','3A8250','3A6-275','3A7125'}
G[11600]={'41A150','40D75','42C37','44637','46637'}
G[11601]={'41A75','40D37','42C18','44618','46618'}
G[11603]={'41A150','40D75','42C37','44637','46637'}
G[11645]={'41A250','40D125','42C62','44662','46662'}
G[11672]={'41A10','40D5','42C2','4462','4662'}
G[11704]={'41A250','40D125','42C62','44662','46662'}
G[11707]={'41A10','40D5','42C2','4462','4662'}
G[11710]={'41A250','40D125','42C62','44662','46662'}
G[11712]={'41A250','40D125','42C62','44662','46662'}
G[11727]={'41A10','40D5','42C2','4462','4662'}
G[11791]={'41A10','40D5','42C2','4462','4662'}
G[11889]={'41A250','40D125','42C62','44662','46662'}
G[11902]={'41A75','40D37','42C18','44618','46618'}
G[11903]={'41A250','40D125','42C62','44662','46662'}
G[11904]={'41A250','40D125','42C62','44662','46662'}
G[11908]={'41A150','40D75','42C37','44637','46637'}
G[11913]={'41A250','40D125','42C62','44662','46662'}
G[12035]={'41A250','40D125','42C62','44662','46662'}
G[12105]={'41A75','40D37','42C18','44618','46618'}
G[12109]={'41A250','40D125','42C62','44662','46662'}
G[12157]={'41A25','40D12','42C6','4466','4666'}
G[12171]={'41A10','40D5','42C2','4462','4662'}
G[12212]={'41A250','40D125','42C62','44662','46662'}
G[12216]={'41A250','40D125','42C62','44662','46662'}
G[12217]={'41A250','40D125','42C62','44662','46662'}
G[12219]={'41A250','40D125','42C62','44662','46662'}
G[12220]={'43D250','41C125','42862','42B62','46462'}
G[12222]={'41A250','40D125','42C62','44662','46662'}
G[12223]={'41A250','40D125','42C62','44662','46662'}
G[12225]={'41A75','40D37','42C18','44618','46618'}
G[12226]={'41A250','40D125','42C62','44662','46662'}
G[12227]={'41A150','40D75','42C37','44637','46637'}
G[12251]={'41A10','40D5','42C2','4462','4662'}
G[12253]={'41A250','40D125','42C62','44662','46662'}
G[12255]={'41A250','40D125','42C62','44662','46662'}
G[12258]={'41A250','40D125','42C62','44662','46662'}
G[12269]={'41A250','40D125','42C62','44662','46662'}
G[12272]={'41A250','40D125','42C62','44662','46662'}
G[12276]={'41A250','40D125','42C62','44662','46662'}
G[12277]={'41A350','40D175','42C87','44687','46687'}
G[12282]={'41A250','40D125','42C62','44662','46662'}
G[12292]={'41A250','40D125','42C62','44662','46662'}
G[12294]={'41A25','40D12','42C6','4466','4666'}
G[12295]={'41A250','40D125','42C62','44662','46662'}
G[12302]={'41A250','40D125','42C62','44662','46662'}
G[12308]={'41A250','40D125','42C62','44662','46662'}
G[12439]={'41A10','40D5','42C2','4462','4662'}
G[12631]={'44A150','449150'}
G[12637]={'44A75','44975'}
G[12806]={'44A10','44910'}
G[12807]={'44A10','44910'}
G[12810]={'44A250','449250'}
G[12814]={'44A250','449250'}
G[12885]={'46610','40D5','41A2','42C2','4462'}
G[12943]={'44A250','449250'}
G[12949]={'44A250','449250'}
G[12955]={'44A250','449250'}
G[12999]={'44A10','44910'}
G[13009]={'45F250'}
G[13085]={'44A10','44910'}
G[13137]={'44A350','449350'}
G[13142]={'44A500','449500'}
G[26209]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26213]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26214]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27402]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[28562]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[28827]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[29682]={'435150'}
G[30451]={'38D350'}
G[30772]={'4F675'}
G[30926]={'53D350'}
G[30983]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[30987]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[30988]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[30989]={'1D5500','02F500','036500','045500','048500','3A2500','46E500','549500'}
G[31087]={'53910'}
G[32152]={'560300'}
G[32657]={'59B200'}
end

if release >= 17055 then
G[6922]={'212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[24959]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[26232]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[26365]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26503]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26504]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26505]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26506]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26510]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26511]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26512]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[26513]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26514]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26520]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26544]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27756]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27758]={}
G[27974]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[27988]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28608]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[30336]={'4F8275'}
G[30995]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[30996]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[30997]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[30998]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
end

if release >= 17116 then
G[26545]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26567]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[26568]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[26569]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26570]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26571]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26586]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26587]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
end

if release >= 17128 then
G[37]={'048150'}
G[40]={'048250'}
G[62]={'04810'}
G[332]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[333]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[334]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[353]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[543]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[769]={'05175','04318','04418','04C18','21218','38F18','46D18','54818'}
G[1204]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[1258]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[9383]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9398]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9423]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9427]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9543]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[9697]={'3AE25'}
G[9776]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9777]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9780]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9781]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9782]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9783]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9786]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9791]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9793]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9827]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9896]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[9901]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[9938]={'3D2250'}
G[9982]={'3D2350'}
G[10047]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10064]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10189]={'3A6250','3A8250','3A4-275','3A7125'}
G[10193]={'3A6250','3A8250','3A4-275','3A7125'}
G[10194]={'3A610','3A810','3A4-11','3A75'}
G[10197]={'3A6250','3A8250','3A4-275','3A7125'}
G[10198]={'3A6150','3A8150','3A4-165','3A775'}
G[10202]={'3A675','3A875','3A4-83','3A737'}
G[10204]={'3A6250','3A8250','3A4-275','3A7125'}
G[10266]={'3A610','3A810','3A4-11','3A75'}
G[10268]={'3A5350'}
G[10329]={'3A6250','3A8250','3A4-275','3A7125'}
G[10330]={'3A6250','3A8250','3A4-275','3A7125'}
G[10338]={'3A6250','3A8250','3A4-275','3A7125'}
G[10339]={'3A5350'}
G[10341]={'3A6250','3A8250','3A4-275','3A7125'}
G[10355]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10365]={'3A6250','3A8250','3A4-275','3A7125'}
G[10423]={'3A5250'}
G[10432]={'3A6250','3A8250','3A4-275','3A7125'}
G[10507]={'3A61000','3A81000','3A4-1100','3A7500'}
G[10508]={'3A6350','3A8350','3A4-385','3A7175'}
G[10509]={'3A6150','3A8150','3A4-165','3A775'}
G[10686]={'3A675','3A875','3A4-83','3A737'}
G[10689]={'3A675','3A875','3A4-83','3A737'}
G[11024]={'407250'}
G[11062]={'40E350'}
G[11202]={'41A250','40D125','42C62','44662','46662'}
G[11211]={'17110','0A95','0155','1D65','2415'}
G[11231]={'41A250','40D125','42C62','44662','46662'}
G[11235]={'41A250','40D125','42C62','44662','46662'}
G[11236]={'41A350','40D175','42C87','44687','46687'}
G[11237]={'41A250','40D125','42C62','44662','46662'}
G[11238]={'41A350','40D175','42C87','44687','46687'}
G[11239]={'41A250','40D125','42C62','44662','46662'}
G[11245]={'41A250','40D125','42C62','44662','46662'}
G[11246]={'41A250','40D125','42C62','44662','46662'}
G[11247]={'41A250','40D125','42C62','44662','46662'}
G[11249]={'41A350','40D175','42C87','44687','46687'}
G[11250]={'41A350','40D175','42C87','44687','46687'}
G[11269]={'41A250','40D125','42C62','44662','46662'}
G[11284]={'41A250','40D125','42C62','44662','46662'}
G[11327]={'41A250','40D125','42C62','44662','46662'}
G[11329]={'41A250','40D125','42C62','44662','46662'}
G[11346]={'42C250','40D125','41A62','44662','46662'}
G[11349]={'42C250','40D125','41A62','44662','46662'}
G[11355]={'41A250','40D125','42C62','44662','46662'}
G[11358]={'41A250','40D125','42C62','44662','46662'}
G[11359]={'41A350','40D175','42C87','44687','46687'}
G[11410]={'41A250','40D125','42C62','44662','46662'}
G[11418]={'41A150','40D75','42C37','44637','46637'}
G[11432]={'41A250','40D125','42C62','44662','46662'}
G[11452]={'41A350','40D175','42C87','44687','46687'}
G[11490]={'435250'}
G[11546]={'435350'}
G[11592]={'43D350','41C175','42887','42B87','46487','428350','41C175','42B87','43D87','46487'}
G[11593]={'43D250','41C125','42862','42B62','46462'}
G[11650]={'41A250','40D125','42C62','44662','46662'}
G[11675]={'428250','41C125','42B62','43D62','46462'}
G[11688]={'43D250','41C125','42862','42B62','46462'}
G[11690]={'43D250','41C125','42862','42B62','46462'}
G[11692]={'41A10','40D5','42C2','4462','4662'}
G[11713]={'41A250','40D125','42C62','44662','46662'}
G[11714]={'43D250','41C125','42862','42B62','46462'}
G[11715]={'41A250','40D125','42C62','44662','46662'}
G[11716]={'43D250','41C125','42862','42B62','46462'}
G[11717]={'43D250','41C125','42862','42B62','46462'}
G[11718]={'41A250','40D125','42C62','44662','46662'}
G[11719]={'43D10','41C5','4282','42B2','4642'}
G[11720]={'43D10','41C5','4282','42B2','4642'}
G[11721]={'43D250','41C125','42862','42B62','46462'}
G[11722]={'43D150','41C75','42837','42B37','46437'}
G[11724]={'43D250','41C125','42862','42B62','46462'}
G[11725]={'41A10','40D5','42C2','4462','4662'}
G[11726]={'41A250','40D125','42C62','44662','46662'}
G[11728]={'41A250','40D125','42C62','44662','46662'}
G[11729]={'41A10','40D5','42C2','4462','4662'}
G[11730]={'41A350','40D175','42C87','44687','46687'}
G[11788]={'41A350','40D175','42C87','44687','46687'}
G[11795]={'41A250','40D125','42C62','44662','46662'}
G[11796]={'41A250','40D125','42C62','44662','46662'}
G[11798]={'41A350','40D175','42C87','44687','46687'}
G[11873]={'41A350','40D175','42C87','44687','46687'}
G[11979]={'42810','41C5','42B2','43D2','4642','43D10','41C5','4282','42B2','4642'}
G[12086]={'431250'}
G[12089]={'43D350','41C175','42887','42B87','46487'}
G[12090]={'43D350','41C175','42887','42B87','46487'}
G[12091]={'43D350','41C175','42887','42B87','46487'}
G[12095]={'43D10','41C5','4282','42B2','4642'}
G[12097]={'43D500','41C250','428125','42B125','464125'}
G[12144]={'43D250','41C125','42862','42B62','46462'}
G[12214]={'42B250','41C125','42862','43D62','46462'}
G[12230]={'42B250','41C125','42862','43D62','46462'}
G[12232]={'42B250','41C125','42862','43D62','46462'}
G[12245]={'42B250','41C125','42862','43D62','46462'}
G[12488]={'42810','41C5','42B2','43D2','4642','43D10','41C5','4282','42B2','4642'}
G[12702]={'450250','45D250','451-550'}
G[12703]={'450350','45D350','451-770'}
G[12732]={'450250','45D250','451-550'}
G[12806]={'44A250','449250'}
G[12813]={'44A250','449250'}
G[12815]={'44A250','449250'}
G[12838]={'44A250','449250'}
G[12891]={'44A250','449250'}
G[12892]={'44A250','449250'}
G[12899]={'44A10','44910'}
G[12939]={'44A250','449250'}
G[12951]={'44A25','44925'}
G[12959]={'44210'}
G[12982]={'44A250','449250'}
G[12992]={'44A250','449250'}
G[12995]={'44A250','449250'}
G[13038]={'43D250','41C125','42862','42B62','46462'}
G[13042]={'44A250','449250'}
G[13043]={'44A350','449350'}
G[13048]={'43D250','41C125','42862','42B62','46462'}
G[13058]={'43D350','41C175','42887','42B87','46487'}
G[13059]={'44A350','449350'}
G[13069]={'44A250','449250'}
G[13071]={'44A250','449250'}
G[13084]={'44A250','449250'}
G[13085]={'44A250','449250'}
G[13091]={'44A250','449250'}
G[13092]={'44A250','449250'}
G[13105]={'45210','44A10','44910'}
G[13117]={'44A150','449150'}
G[13118]={'452250','44A250','449250'}
G[13119]={'44A250','449250'}
G[13120]={'44A250','449250'}
G[13121]={'44A250','449250'}
G[13122]={'452250','44A250','449250'}
G[13125]={'452500','44A500','449500'}
G[13133]={'44A250','449250'}
G[13134]={'44A250','449250'}
G[13144]={'44A250','449250'}
G[13212]={'44A250','449250'}
G[13220]={'44A250','449250'}
G[13224]={'43D25','41C12','4286','42B6','4646'}
G[13235]={'44A350','449350'}
G[13258]={'43D75','41C37','42818','42B18','46418'}
G[13283]={'43D250','41C125','42862','42B62','46462'}
G[13293]={'43D10','41C5','4282','42B2','4642'}
G[13306]={'44A250','449250'}
G[13310]={'43D250','41C125','42862','42B62','46462'}
G[13340]={'43D250','41C125','42862','42B62','46462'}
G[13348]={'43D75','41C37','42818','42B18','46418'}
G[13349]={'43D250','41C125','42862','42B62','46462'}
G[13362]={'41A75','40D37','42C18','44618','46618'}
G[13364]={'452500','44A500','449500','41A500','40D250','42C125','446125','466125','43D500','41C250'}
G[13419]={'43D25','41C12','4286','42B6','4646'}
G[13595]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13626]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13630]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13632]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13635]={'02F150','1D537','03637','04537','04837','3A237','46E37','54937'}
G[13636]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13656]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13657]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13658]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13660]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13668]={'46410','41C5','4282','42B2','43D2'}
G[13674]={'464250','41C125','42862','42B62','43D62'}
G[13676]={'464250','41C125','42862','42B62','43D62'}
G[13677]={'464250','41C125','42862','42B62','43D62'}
G[13678]={'46410','41C5','4282','42B2','43D2'}
G[13680]={'464250','41C125','42862','42B62','43D62'}
G[13691]={'04C10','0432','0442','0512','2122','38F2','46D2','5482','46410','41C5'}
G[13697]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13710]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[13717]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','446250','40D125'}
G[13721]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13726]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13757]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','446250','40D125'}
G[13760]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','446250','40D125'}
G[13761]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','446250','40D125'}
G[13762]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13764]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13765]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13767]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13778]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13779]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13781]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13782]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13795]={'44A10','44910'}
G[13812]={'44A250','449250','464250','41C125','42862','42B62','43D62'}
G[13813]={'44A250','449250','464250','41C125','42862','42B62','43D62'}
G[13814]={'44A250','449250','464250','41C125','42862','42B62','43D62'}
G[13829]={'46475','41C37','42818','42B18','43D18'}
G[13838]={'46475','41C37','42818','42B18','43D18'}
G[13839]={'46475','41C37','42818','42B18','43D18'}
G[13849]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13855]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','446250','40D125'}
G[13856]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13860]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','464250','41C125'}
G[13863]={'44A250','449250','464250','41C125','42862','42B62','43D62'}
G[13867]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13868]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13872]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[13874]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[13913]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','036250','1D562'}
G[13979]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[14204]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14212]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14214]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[14218]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14221]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14289]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[14293]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14294]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[14313]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[14320]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14321]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14336]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14347]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14348]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14366]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14367]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14368]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14369]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14382]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14386]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14395]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14396]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14397]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[14398]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14399]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14400]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14401]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14403]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14404]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14406]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[14412]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14416]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[14455]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[14456]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[14458]={'05125','0436','0446','04C6','2126','38F6','46D6','5486'}
G[14459]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[14460]={'051350','04387','04487','04C87','21287','38F87','46D87','54887'}
G[14461]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[14465]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[14466]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[24438]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24468]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24472]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24483]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[24501]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24506]={'43D25','41C12','4286','42B6','4646'}
G[24575]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[24592]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24593]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24602]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24607]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24616]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24617]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24627]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24628]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937'}
G[24639]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24641]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24646]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[24673]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[24675]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[24676]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24677]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[24678]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24679]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24680]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[24681]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[24902]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[24903]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[24904]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[24920]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[24921]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[24934]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[24941]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[24974]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[24978]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[25048]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25049]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25050]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25054]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25062]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25065]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25111]={'171250','0A9125','015125','1D6125','241125'}
G[25112]={'171250','0A9125','015125','1D6125','241125'}
G[25115]={'171250','0A9125','015125','1D6125','241125'}
G[25121]={'03675','1D518','02F18','04518','04818','3A218','46E18','54918'}
G[25211]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25268]={'486250'}
G[25317]={'486150'}
G[25395]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25421]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[25504]={'03625','1D56','02F6','0456','0486','3A26','46E6','5496'}
G[25505]={'46D25','0436','0446','04C6','0516','2126','38F6','5486'}
G[25516]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25518]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25524]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25526]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25532]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25533]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25542]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25543]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25565]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25585]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25597]={'486250'}
G[25601]={'48610'}
G[25627]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987'}
G[25667]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25668]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25721]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25722]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25723]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25724]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25725]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25726]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25727]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25735]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25744]={'03625','1D56','02F6','0456','0486','3A26','46E6','5496'}
G[25745]={'46D25','0436','0446','04C6','0516','2126','38F6','5486'}
G[25757]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25770]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25775]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25791]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25792]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25838]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492','03610','1D52'}
G[25839]={'02F150','1D537','03637','04537','04837','3A237','46E37','54937','036150','1D537'}
G[25840]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25841]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25882]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[25946]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25947]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25948]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25978]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25979]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25997]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[25998]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[26051]={'015350','0A9175','171175','1D6175','241175','057-350'}
G[26078]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26085]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26094]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26102]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26112]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26118]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26131]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492','03610','1D52'}
G[26137]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[26145]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26146]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26147]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26148]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[26174]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26175]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[26184]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[26186]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962','3AE250'}
G[26187]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[26198]={'036150','1D537','02F37','04537','04837','3A237','46E37','54937'}
G[26249]={'46F250'}
G[26264]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26265]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26284]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26285]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26286]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26287]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26288]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26289]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26290]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26291]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26292]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26293]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[26295]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26296]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26297]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[26316]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[26318]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[26319]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[26320]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26322]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26324]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[26331]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26333]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26336]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[26339]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[26342]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26364]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987','02F350','1D587'}
G[26370]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[26373]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[26378]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26380]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[26390]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26421]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[26453]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[26454]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26476]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[26548]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[26594]={'015150','0A975','17175','1D675','24175','057-150'}
G[26595]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[26599]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[26609]={'015150','0A975','17175','1D675','24175','057-150'}
G[26610]={'015150','0A975','17175','1D675','24175','057-150'}
G[26611]={'01525','0A912','17112','1D612','24112','057-25'}
G[26612]={'015350','0A9175','171175','1D6175','241175','057-350'}
G[26613]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[26614]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[26617]={'015150','0A975','17175','1D675','24175','057-150'}
G[26645]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26684]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26686]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26702]={'1D510','02F10','03610','04510','04810','3A210','46E10','54910'}
G[26706]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[26761]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26787]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26805]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26808]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[26815]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26816]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987'}
G[26817]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26818]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26819]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26820]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26823]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26840]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26843]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26846]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26860]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26863]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[26886]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26887]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26898]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26901]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[26921]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26922]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26923]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[26953]={'261350'}
G[26956]={'261250'}
G[26960]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[26975]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[26977]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[26997]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26999]={'452250'}
G[27000]={'452250'}
G[27017]={'452250'}
G[27021]={'05175','04318','04418','04C18','21218','38F18','46D18','54818'}
G[27038]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27044]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[27060]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27064]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[27072]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27074]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[27075]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[27077]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[27078]={'02F500','1D5125','036125','045125','048125','3A2125','46E125','549125'}
G[27092]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27106]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27116]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[27156]={'452250'}
G[27159]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27162]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27163]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27164]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[27165]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27166]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27167]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27177]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27178]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27200]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27210]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27211]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27212]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27213]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27222]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27246]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[27247]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27271]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27337]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27338]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[27341]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[27351]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27361]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27366]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27433]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27446]={'03625'}
G[27468]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27537]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27538]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27545]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[27583]={'49475'}
G[27586]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[27607]={'49475'}
G[27670]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[27683]={'261350'}
G[27721]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[27726]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27733]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27758]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27781]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27785]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27790]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27791]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[27792]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[27823]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[27824]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[27825]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27833]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27917]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[27920]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[27921]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[27952]={'46F350'}
G[27953]={'46F10'}
G[27968]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[28238]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[28393]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[28398]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[28490]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[28505]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[28511]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[28512]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28539]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[28551]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[28552]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[28563]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[28564]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28576]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28596]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28598]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[28666]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28672]={'04475','04318','04C18','05118','21218','38F18','46D18','54818'}
G[28673]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28699]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28702]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[28716]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28749]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[28807]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[28832]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[28868]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[29078]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29079]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29080]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[29081]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29082]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29083]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[29177]={'486250'}
G[29570]={'3AE500'}
G[29641]={'3F3350'}
G[29644]={'3F3500'}
G[29684]={'43510'}
G[29685]={'435250'}
G[29686]={'435250'}
G[29687]={'435250'}
G[30313]={'4F5100'}
G[30321]={'4F91800'}
G[30452]={'38D350'}
G[30890]={'4F675'}
G[30923]={'4F6100'}
G[30926]={'4F6100'}
G[31446]={'516350','54E600'}
G[31612]={'5391000'}
G[31688]={'4F6100'}
G[31943]={'4F8275'}
G[32346]={'560150'}
G[32567]={'56B200'}
G[32590]={'54F10'}
G[32593]={'54F250'}
G[32594]={'54F350'}
G[32595]={'54F75'}
G[32596]={'54F350'}
G[32657]={'4F5400'}
G[32665]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[32679]={'4F575'}
G[32838]={'53D250'}
end

if release >= 17271 then
G[33335]={'5D4250'}
G[33340]={'5D4250'}
G[33341]={'5D4250'}
end

if release >= 17359 then
G[9778]={'3AE250'}
G[9787]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9801]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9803]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10443]={'3A2250'}
G[13625]={'446250','40D125','41A62','42C62','46662'}
G[13666]={'446250','40D125','41A62','42C62','46662'}
G[13667]={'44610','40D5','41A2','42C2','4662'}
G[13671]={'446250','40D125','41A62','42C62','46662'}
G[13672]={'44610','40D5','41A2','42C2','4662'}
G[13828]={'44675','40D37','41A18','42C18','46618'}
G[13835]={'44675','40D37','41A18','42C18','46618'}
G[13837]={'44675','40D37','41A18','42C18','46618'}
G[27670]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28708]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[30321]={'4F92000','4F8150'}
G[33342]={'5D4250'}
G[33374]={'5D4250'}
end

if release >= 17371 then
G[239]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[9938]={'3D2350'}
G[10349]={'3AE350'}
G[11526]={'435150'}
G[11723]={'41A350','40D175','42C87','44687','46687'}
G[12959]={'44225'}
G[13577]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[27354]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[28724]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[30188]={'4F71000'}
G[30242]={'4F5300'}
G[30243]={'4F5300'}
G[30261]={'4F5300'}
G[30266]={'4F5300'}
G[30277]={'4F5500'}
G[30306]={'4F5300'}
G[32675]={'3B210'}
end

if release >= 17399 then
G[8311]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[9790]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9848]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[9957]={'3AE75'}
G[10266]={'3A525'}
G[10268]={'3A575'}
G[10322]={'3A4250','3A8250','3A6-275','3A7125'}
G[10323]={'3A4250','3A8250','3A6-275','3A7125'}
G[10328]={'3A4250','3A8250','3A6-275','3A7125'}
G[10339]={'3A5250'}
G[10380]={'3A4250','3A8250','3A6-275','3A7125'}
G[10381]={'3A4150','3A8150','3A6-165','3A775'}
G[10407]={'3A4350','3A8350','3A6-385','3A7175'}
G[10409]={'3A41000','3A81000','3A6-1100','3A7500'}
G[10410]={'3A4150','3A8150','3A6-165','3A775'}
G[10431]={'3A425','3A825','3A6-28','3A712'}
G[11028]={'3F3250'}
G[11356]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[11360]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[11450]={'38F75','04318','04418','04C18','05118','21218','46D18','54818'}
G[11673]={'41A350','40D175','42C87','44687','46687'}
G[11693]={'41A250','40D125','42C62','44662','46662'}
G[11694]={'41A250','40D125','42C62','44662','46662'}
G[11697]={'41A250','40D125','42C62','44662','46662'}
G[11698]={'41A250','40D125','42C62','44662','46662'}
G[11699]={'41A250','40D125','42C62','44662','46662'}
G[11700]={'41A10','40D5','42C2','4462','4662'}
G[11701]={'41A350','40D175','42C87','44687','46687'}
G[11708]={'41A10','40D5','42C2','4462','4662'}
G[11789]={'41A150','40D75','42C37','44637','46637'}
G[11792]={'41A250','40D125','42C62','44662','46662'}
G[11793]={'41A25','40D12','42C6','4466','4666'}
G[11794]={'41A250','40D125','42C62','44662','46662'}
G[11797]={'41A250','40D125','42C62','44662','46662'}
G[11897]={'41A250','40D125','42C62','44662','46662'}
G[11901]={'41A150','40D75','42C37','44637','46637'}
G[11920]={'41A75','40D37','42C18','44618','46618'}
G[11928]={'41A10','40D5','42C2','4462','4662'}
G[11938]={'41A250','40D125','42C62','44662','46662'}
G[11942]={'41A250','40D125','42C62','44662','46662'}
G[11944]={'41A250','40D125','42C62','44662','46662'}
G[11956]={'41A250','40D125','42C62','44662','46662'}
G[12019]={'41A500','40D250','42C125','446125','466125'}
G[12067]={'41A250','40D125','42C62','44662','46662'}
G[12088]={'41A25','40D12','42C6','4466','4666'}
G[12092]={'41A250','40D125','42C62','44662','46662'}
G[12109]={'41A25','40D12','42C6','4466','4666'}
G[12166]={'41A250','40D125','42C62','44662','46662'}
G[12174]={'41A10','40D5','42C2','4462','4662'}
G[12215]={'41A150','40D75','42C37','44637','46637'}
G[12235]={'41A10','40D5','42C2','4462','4662'}
G[12237]={'41A250','40D125','42C62','44662','46662'}
G[12310]={'41A250','40D125','42C62','44662','46662'}
G[12464]={'41A350','40D175','42C87','44687','46687'}
G[12511]={'41A25','40D12','42C6','4466','4666'}
G[12766]={'41A10','40D5','42C2','4462','4662'}
G[12806]={'44A10','44910'}
G[12884]={'45225'}
G[12887]={'44A250','449250'}
G[12893]={'44A350','449350'}
G[12898]={'44A10','44910'}
G[12938]={'44A10','44910'}
G[13036]={'40D10','41A5','42C5','4465','4665'}
G[13087]={'41A75','40D37','42C18','44618','46618'}
G[13104]={'45210','44A10','44910'}
G[13106]={'44A10','44910'}
G[13152]={'44A250','449250'}
G[13418]={'41A25','40D12','42C6','4466','4666'}
G[13510]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13669]={'446250','40D125','41A62','42C62','46662'}
G[24498]={'41A500','40D250','42C125','446125','466125'}
G[24499]={'41A500','40D250','42C125','446125','466125'}
G[24710]={'41A500','40D250','42C125','446125','466125'}
G[25036]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25216]={'46F250'}
G[25268]={'48610'}
G[25317]={'486250'}
G[25357]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25545]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25546]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25547]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25558]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25564]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25597]={'486150'}
G[25601]={'48675'}
G[26249]={'46F75'}
G[26838]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26969]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[27490]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27492]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27494]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27496]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27498]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27500]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27502]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27595]={'495250'}
G[27629]={'49510'}
G[27636]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[27652]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27654]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27660]={'46F250'}
G[27688]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27695]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27700]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27702]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27719]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27724]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27727]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27784]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27787]={'496500','048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27808]={'49625'}
G[27952]={'46F10'}
G[28101]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[28103]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28104]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28107]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28108]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28211]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28212]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28215]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28216]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28328]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[28369]={'496250'}
G[28709]={'41A10','40D5','42C2','4462','4662'}
G[28794]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28810]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28820]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[29074]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[29392]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[29398]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[29399]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[29402]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29411]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29430]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[29547]={'46F150'}
G[29566]={'3AE250'}
G[31855]={'036500','1D5125','02F125','045125','048125','3A2125','46E125','549125'}
G[32597]={'54F350'}
G[32805]={'54F500'}
end

if release >= 17538 then
G[2]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[6441]={'1D6250','0A9125','015125','171125','241125'}
G[6503]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[6544]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[13620]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[13653]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[13712]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[13730]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13751]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[13797]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[13801]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13803]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[13805]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13806]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13808]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[13841]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[13848]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[14036]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[14037]={'04475','04318','04C18','05118','21218','38F18','46D18','54818'}
G[14040]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[14041]={'05175','04318','04418','04C18','21218','38F18','46D18','54818'}
G[14043]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[14044]={'04475','04318','04C18','05118','21218','38F18','46D18','54818'}
G[14047]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[14058]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[14059]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[14060]={'051150','04337','04437','04C37','21237','38F37','46D37','54837'}
G[14061]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[14062]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[14094]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[14098]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[14099]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14154]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[14157]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[14291]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[24930]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[24960]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[24961]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[24969]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[25089]={'044150','04337','04C37','05137','21237','38F37','46D37','54837'}
G[26032]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26033]={'04475','04318','04C18','05118','21218','38F18','46D18','54818'}
G[26050]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[26055]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[26081]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[26084]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[26107]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26129]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[26283]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26309]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26368]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26381]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26382]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26387]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26406]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26418]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26419]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[26429]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26430]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26800]={'04475'}
G[26801]={'044250'}
G[26911]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[26975]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[26977]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27995]={'240250'}
G[28100]={'24075'}
G[28114]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28115]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28168]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[28189]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28196]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28199]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28206]={'04475','04318','04C18','05118','21218','38F18','46D18','54818'}
G[28209]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28230]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28235]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28237]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28238]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28251]={'04425','0436','04C6','0516','2126','38F6','46D6','5486'}
G[28324]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28325]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28329]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28331]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28332]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28362]={'240250'}
G[28484]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28487]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28489]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28508]={'04425','0436','04C6','0516','2126','38F6','46D6','5486'}
G[28538]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28566]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28587]={'04410','0432','04C2','0512','2122','38F2','46D2','5482','04C10','0432'}
G[28603]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28604]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28605]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28850]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[29319]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[29343]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29360]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[30890]={'4F6100'}
G[31444]={'516350','54E600'}
G[32556]={'56B150'}
G[32600]={'5412850'}
G[32601]={'5412850'}
G[32602]={'5412850'}
end

if release >= 17585 then
G[32249]={'55F150','04310','04410','04C10','05110','21210','38F10','46D10','54810'}
end

if release >= 17595 then
G[32246]={}
G[32679]={}
end

if release >= 17658 then
G[12855]={'42C250','40D125','41A62','44662','46662'}
G[12858]={'42C250','40D125','41A62','44662','46662'}
G[12860]={'42C250','40D125','41A62','44662','46662'}
G[12863]={'46610','40D5','41A2','42C2','4462'}
G[12864]={'466250','40D125','41A62','42C62','44662'}
G[12865]={'466250','40D125','41A62','42C62','44662'}
G[12866]={'466250','40D125','41A62','42C62','44662'}
G[12867]={'466250','40D125','41A62','42C62','44662'}
G[12868]={'466350','40D175','41A87','42C87','44687'}
G[12870]={'42C250','40D125','41A62','44662','46662'}
G[12871]={'46610','40D5','41A2','42C2','4462'}
G[12872]={'42C250','40D125','41A62','44662','46662'}
G[12873]={'46610','40D5','41A2','42C2','4462'}
G[12874]={'466250','40D125','41A62','42C62','44662'}
G[12875]={'466250','40D125','41A62','42C62','44662'}
G[12876]={'466250','40D125','41A62','42C62','44662'}
G[12877]={'466250','40D125','41A62','42C62','44662'}
G[12879]={'466350','40D175','41A87','42C87','44687'}
G[12880]={'42C10','40D5','41A2','4462','4662'}
G[12882]={'43D250','41C125','42862','42B62','46462'}
G[12895]={'43D250','41C125','42862','42B62','46462'}
G[12909]={'43D10','41C5','4282','42B2','4642'}
G[12913]={'43D10','41C5','4282','42B2','4642'}
G[12917]={'43D250','41C125','42862','42B62','46462'}
G[12966]={'45F250'}
G[12973]={'42C500','40D250','41A125','446125','466125','466500','40D250','41A125','42C125','446125'}
G[13000]={'43D250','41C125','42862','42B62','46462'}
G[13034]={'43D250','41C125','42862','42B62','46462'}
G[13037]={'43D250','41C125','42862','42B62','46462'}
G[13054]={'43D75','41C37','42818','42B18','46418'}
G[13056]={'43D250','41C125','42862','42B62','46462'}
G[13285]={'43D350','41C175','42887','42B87','46487'}
G[13426]={'43D10','41C5','4282','42B2','4642'}
G[24989]={'04475'}
G[24991]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[24997]={'044250'}
G[25006]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[25031]={'04425','0436','04C6','0516','2126','38F6','46D6','5486'}
G[26964]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[29860]={'45F250'}
G[29861]={'45F500'}
G[29862]={'45F250'}
G[32120]={'55F300'}
G[32141]={'55F150'}
G[32236]={'55F150'}
G[32343]={'55F150'}
G[32427]={'54F75'}
G[32429]={'54F250'}
G[32476]={'54F250'}
G[32945]={'56B400'}
G[33230]={'4F5500'}
end

if release >= 17688 then
G[744]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[845]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[848]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[858]={'1D6250','0A9125','015125','171125','241125'}
G[863]={'1D6350','0A9175','015175','171175','241175'}
G[865]={'1D6250','0A9125','015125','171125','241125'}
G[866]={'1D6250','0A9125','015125','171125','241125'}
G[867]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[870]={'051150','04337','04437','04C37','21237','38F37','46D37','54837'}
G[872]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[877]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[880]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[881]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[887]={'1D6150','0A975','01575','17175','24175'}
G[891]={'1D6250','0A9125','015125','171125','241125','04375','04475','04C75','05175','21275'}
G[895]={'1D6250','0A9125','015125','171125','241125'}
G[899]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[903]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[905]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[1454]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[1455]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[1456]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[1578]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[3108]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[4512]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987'}
G[5041]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[5501]={'1D6150','0A975','01575','17175','24175'}
G[5561]={'1D6150','0A975','01575','17175','24175'}
G[8470]={'240350'}
G[9159]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[11129]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[13088]={'41A75','40D37','42C18','44618','46618'}
G[13581]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[13583]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[13587]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[13588]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13612]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13613]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13615]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13617]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[13618]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13619]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13620]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13621]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[13623]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[13628]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13640]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13642]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13644]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13645]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[13646]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[13651]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13698]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13766]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13792]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13796]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13808]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[13848]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[13869]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13919]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[13921]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[13922]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13924]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13928]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13935]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13949]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[13964]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[13965]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[13976]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13981]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13989]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[14003]={'1D6350','0A9175','015175','171175','241175'}
G[14006]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[14193]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[14258]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14261]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14262]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14271]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[14295]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[14297]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14308]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14310]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14322]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14370]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14371]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14374]={'051350','04387','04487','04C87','21287','38F87','46D87','54887'}
G[14377]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14383]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14385]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14388]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14402]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[14403]={'46E10','1D52','02F2','0362','0452','0482','3A22','5492'}
G[14407]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[14430]={'38F150','04337','04437','04C37','05137','21237','46D37','54837'}
G[14431]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14432]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14433]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14435]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[14462]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14464]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[14475]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[14476]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[14477]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[24430]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24433]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[24437]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24439]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[24458]={'46D150','04337','04437','04C37','05137','21237','38F37','54837'}
G[24490]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[24497]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[24530]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[24782]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24783]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24784]={'212150','04337','04437','04C37','05137','38F37','46D37','54837'}
G[24785]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24786]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24787]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24862]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[24863]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[24979]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[24982]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[24992]={'04475','04318','04C18','05118','21218','38F18','46D18','54818'}
G[24993]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[25000]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25002]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25008]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25015]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25022]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25027]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25034]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[25036]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[25041]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25042]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25043]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25044]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25045]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25057]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25059]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25073]={'21210','0432','0442','04C2','0512','38F2','46D2','5482'}
G[25074]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[25075]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25079]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25080]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25081]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25082]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25087]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25102]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25104]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25106]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25108]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25120]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[25151]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25153]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[25163]={'02F25','1D56','0366','0456','0486','3A26','46E6','5496'}
G[25174]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25175]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25182]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25183]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[25185]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25186]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25191]={'03675','1D518','02F18','04518','04818','3A218','46E18','54918'}
G[25261]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25333]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[25394]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25396]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25397]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25398]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25399]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25400]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25401]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[25406]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25407]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25409]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25410]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25426]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25427]={'46E150','1D537','02F37','03637','04537','04837','3A237','54937'}
G[25429]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25431]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25432]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937'}
G[25433]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25434]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25436]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25438]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25447]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25448]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937'}
G[25449]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25450]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25451]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25458]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25465]={'0A9350','015350','171350','1D6350','241350'}
G[25466]={'0A9350','015350','171350','1D6350','241350'}
G[25468]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25469]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25475]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[25476]={'015350','0A9175','171175','1D6175','241175','057-350'}
G[25504]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[25607]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','036250','1D562'}
G[25613]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492','03610','1D52'}
G[25614]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','036250','1D562'}
G[25615]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492','03610','1D52'}
G[25616]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','036250','1D562'}
G[25621]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496','03625','1D56'}
G[25622]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','036250','1D562'}
G[25640]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492','03610','1D52'}
G[25642]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','036250','1D562'}
G[25646]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','036250','1D562'}
G[25647]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937','036150','1D537'}
G[25649]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937','036150','1D537'}
G[25650]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937','036150','1D537'}
G[25652]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987','036350','1D587'}
G[25654]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25662]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25669]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25673]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25728]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[25729]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25739]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962','048250','1D562'}
G[25741]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25765]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[25766]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[25767]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25768]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[25769]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[25777]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25793]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[25806]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25808]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25809]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25811]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25821]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[25822]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25823]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25834]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[25837]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25844]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[25845]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[25846]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25851]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[25852]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[25875]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[25876]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25877]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[25878]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962','045250','1D562'}
G[25879]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962','045250','1D562'}
G[25880]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[25889]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25891]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25912]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25913]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25914]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25925]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[25930]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[25931]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[25934]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962','036250','1D562'}
G[25935]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26069]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26177]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26385]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[26401]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26402]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[26414]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26442]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26446]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26448]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26449]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[26457]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26463]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26464]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26466]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[26470]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26472]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[26474]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[26475]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26477]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26478]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26479]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[26480]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937'}
G[26481]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26482]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[26542]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26607]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26616]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[26636]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26637]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26638]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26639]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26640]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26646]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26651]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26668]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26687]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[26692]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26693]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26694]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26769]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[26803]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26804]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26806]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26807]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[26838]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[26897]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26903]={'1D6500','0A9250','015250','171250','241250'}
G[27272]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27278]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[27346]={'17110','0A95','0155','1D65','2415'}
G[27347]={'171250','0A9125','015125','1D6125','241125'}
G[27348]={'171250','0A9125','015125','1D6125','241125'}
G[27395]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27441]={'04C500','043125','044125','051125','212125','38F125','46D125','548125'}
G[27446]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[28114]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28115]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28138]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28144]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28146]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28154]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28156]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28160]={'036500','1D5125','02F125','045125','048125','3A2125','46E125','549125'}
G[28168]={'044500','043125','04C125','051125','212125','38F125','46D125','548125'}
G[28192]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28197]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[28297]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[28330]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28338]={'240350'}
G[28344]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[28364]={'240350'}
G[28366]={'240250'}
G[28397]={'044250','04362','04C62','05162','21262','38F62','46D62','54862','04C250','04362'}
G[28461]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[28464]={'240250'}
G[28472]={'240500'}
G[28492]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[28494]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[28503]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[28521]={'24025'}
G[28522]={'240350'}
G[28531]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28550]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28562]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28563]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[29026]={'46D75','04318','04418','04C18','05118','21218','38F18','54818'}
G[29027]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[29345]={'051250','04362','04462','04C62','21262','38F62','46D62','54862'}
G[29355]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[30240]={'4F5300'}
G[31087]={'539250'}
G[31166]={'05175','04318','04418','04C18','21218','38F18','46D18','54818'}
G[31720]={'4F7450'}
G[31721]={'4F7450'}
G[32673]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[32709]={'56C300'}
G[33343]={'5D4250'}
end

if release >= 17841 then
G[309]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[2039]={'03625','1D56','02F6','0456','0486','3A26','46E6','5496'}
G[13639]={'02F150','1D537','03637','04537','04837','3A237','46E37','54937'}
G[13647]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13650]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26844]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26845]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26864]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26868]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[26927]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26928]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26961]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[27025]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[27026]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[27028]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[27030]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[27031]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[27033]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987'}
G[27034]={'03675','1D518','02F18','04518','04818','3A218','46E18','54918'}
G[27035]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
end

if release >= 17859 then
G[12439]={'44210'}
G[12440]={'41A10','40D5','42C2','4462','4662'}
end

if release >= 17898 then
G[4513]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987'}
G[25037]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
end

if release >= 17930 then
G[6031]={'240250'}
G[13589]={'045150','1D537','02F37','03637','04837','3A237','46E37','54937'}
G[26020]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[27470]={'03B10'}
G[28062]={'03B350'}
G[28337]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[28382]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[28383]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[28384]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[28385]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[28386]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[28387]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[28388]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[28389]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[28529]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[28532]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[28551]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28552]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28614]={'240350'}
G[28615]={'240250'}
G[28629]={'241250','0A9125','015125','171125','1D6125'}
G[28631]={'241150','0A975','01575','17175','1D675'}
G[28702]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28722]={'241350','0A9175','015175','171175','1D6175'}
G[28857]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[30923]={'4F675'}
G[31688]={'4F675'}
G[32675]={'3B2350'}
end

if release >= 17956 then
G[9697]={'3AE75'}
G[13605]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987','045350','1D587'}
G[13655]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13659]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[13683]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[13853]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13897]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[13898]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13900]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[13953]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[13982]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13985]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13987]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[25730]={'02F500','1D5125','036125','045125','048125','3A2125','46E125','549125'}
G[25756]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25774]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25790]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25796]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25798]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25813]={'036350','1D587','02F87','04587','04887','3A287','46E87','54987'}
G[25825]={'03625','1D56','02F6','0456','0486','3A26','46E6','5496'}
G[25835]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[25869]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25871]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25873]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[26161]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26162]={'036500','1D5125','02F125','045125','048125','3A2125','46E125','549125'}
G[26166]={'3A275','1D518','02F18','03618','04518','04818','46E18','54918'}
G[26171]={'1D51000','02F1000','0361000','0451000','0481000','3A21000','46E1000','5491000'}
G[26455]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26708]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26713]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26714]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26726]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26754]={'46E500','1D5125','02F125','036125','045125','048125','3A2125','549125'}
G[26793]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[26794]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[26795]={'048150','1D537','02F37','03637','04537','3A237','46E37','54937'}
G[26796]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[27275]={'04510','1D52','02F2','0362','0482','3A22','46E2','5492'}
G[27310]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[27312]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[27314]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[27316]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[27318]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[27320]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[27323]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[27325]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[27327]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[27329]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[27357]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[28507]={'26110'}
G[29316]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29318]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29321]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29325]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29351]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29616]={'3AE150'}
G[30932]={'53D250'}
G[32675]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[32861]={'54F75'}
G[33087]={'54F25'}
G[33088]={'54F25'}
G[33098]={'54F250'}
G[33100]={'54F350'}
G[33104]={'54F75'}
G[33105]={'54F500'}
end

if release >= 18019 then
G[844]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[871]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[1582]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[5892]={'02F25','1D56','0366','0456','0486','3A26','46E6','5496'}
G[6982]={'02F25','1D56','0366','0456','0486','3A26','46E6','5496'}
G[7027]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[9369]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10349]={'3AE10'}
G[10443]={'3AE10'}
G[11472]={'43110'}
G[11508]={'431250'}
G[11512]={'431150'}
G[11519]={'431250'}
G[11546]={'435250'}
G[11979]={'42B10','41C5','4282','43D2','4642'}
G[12488]={'42B10','41C5','4282','43D2','4642'}
G[24625]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24626]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24776]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24777]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24778]={'212150','04337','04437','04C37','05137','38F37','46D37','54837'}
G[24779]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24780]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24781]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24812]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24813]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24814]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24938]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[24939]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[24943]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[24944]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[24948]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[24956]={'46E350','1D587','02F87','03687','04587','04887','3A287','54987'}
G[25035]={'21225','0436','0446','04C6','0516','38F6','46D6','5486'}
G[25073]={'212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[25165]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','212250','04362'}
G[25170]={'04C250','04362','04462','05162','21262','38F62','46D62','54862','212250','04362'}
G[25188]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[25189]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25190]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25192]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25193]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25194]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[25195]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[25196]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[25205]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25206]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[25236]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25256]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[25257]={'04C150','04337','04437','05137','21237','38F37','46D37','54837'}
G[25258]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25259]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[25260]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[25648]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[26059]={'04C25','0436','0446','0516','2126','38F6','46D6','5486'}
G[26064]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26225]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[26545]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26916]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26963]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[26966]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[28565]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[28757]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28769]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28784]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[28792]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28808]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28818]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[29122]={'486150'}
G[29596]={'3A7500'}
G[30280]={'4F5500'}
G[31943]={'4F8350'}
G[32209]={'56C150'}
G[32216]={'56C150'}
G[32217]={'56C150'}
G[32232]={'56C150'}
G[32234]={'56C150'}
G[32252]={'56C150'}
G[32274]={'56C150'}
G[32275]={'56C150'}
G[32292]={'56C200'}
G[32618]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[32646]={'560400'}
G[32650]={'56B400'}
G[32657]={'53D400'}
G[32677]={'56C200'}
end

if release >= 18291 then
G[485]={'015250','0A9125','171125','1D6125','241125','057-250'}
G[836]={'015350','0A9175','171175','1D6175','241175','057-350'}
G[1270]={'1D6250','0A9125','015125','171125','241125'}
G[9437]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9624]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9625]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9634]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9663]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9666]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[11208]={'17110','0A95','0155','1D65','2415'}
G[12528]={'450350','45D350','451-770'}
G[12529]={'450350','45D350','451-770'}
G[12530]={'450500','45D500','451-1100'}
G[12531]={'450500','45D500','451-1100'}
G[12532]={'450350','45D350','451-770'}
G[12533]={'450350','45D350','451-770'}
G[12534]={'450500','45D500','451-1100'}
G[12535]={'450350','45D350','451-770'}
G[12536]={'450350','45D350','451-770'}
G[12537]={'450500','45D500','451-1100'}
G[12538]={'450350','45D350','451-770'}
G[12539]={'450350','45D350','451-770'}
G[12570]={'451350','45D350','450-770'}
G[12571]={'451350','45D350','450-770'}
G[12572]={'451350','45D350','450-770'}
G[12573]={'451350','45D350','450-770'}
G[12574]={'451250','45D250','450-550'}
G[12575]={'451350','45D350','450-770'}
G[12576]={'451350','45D350','450-770'}
G[12577]={'451250','45D250','450-550'}
G[12578]={'451250','45D250','450-550'}
G[12579]={'451350','45D350','450-770'}
G[12580]={'451350','45D350','450-770'}
G[12704]={'451250','45D250','450-550'}
G[12705]={'451350','45D350','450-770'}
G[12735]={'451250','45D250','450-550'}
G[12736]={'451250','45D250','450-550'}
G[12737]={'451250','45D250','450-550'}
G[12741]={'450250','45D250','451-550'}
G[12761]={'451350','45D350','450-770'}
G[12762]={'451350','45D350','450-770'}
G[14286]={'46E25','1D56','02F6','0366','0456','0486','3A26','5496'}
G[24640]={'212150','04337','04437','04C37','05137','38F37','46D37','54837'}
G[24642]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24643]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
G[24814]={'212500','043125','044125','04C125','051125','38F125','46D125','548125'}
G[24906]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24910]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25128]={'04C25','0436','0446','0516','2126','38F6','46D6','5486','21225','0436'}
G[25505]={'46D10','0432','0442','04C2','0512','2122','38F2','5482'}
G[25797]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25799]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[25814]={'46D350','04387','04487','04C87','05187','21287','38F87','54887'}
G[25826]={'46D25','0436','0446','04C6','0516','2126','38F6','5486'}
G[25836]={'46D10','0432','0442','04C2','0512','2122','38F2','5482'}
G[26197]={'03675','1D518','02F18','04518','04818','3A218','46E18','54918'}
G[26199]={'03675','1D518','02F18','04518','04818','3A218','46E18','54918'}
G[26201]={'036150'}
G[26202]={'03675','1D518','02F18','04518','04818','3A218','46E18','54918'}
G[26203]={'03675','1D518','02F18','04518','04818','3A218','46E18','54918'}
G[26204]={'036150','1D537','02F37','04537','04837','3A237','46E37','54937'}
G[26205]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26208]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26222]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26424]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[26425]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[26566]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[26948]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[27020]={'05175','04318','04418','04C18','21218','38F18','46D18','54818'}
G[27447]={'46D10','0432','0442','04C2','0512','2122','38F2','5482'}
G[27535]={'45210'}
G[27635]={'036150','1D537','02F37','04537','04837','3A237','46E37','54937'}
G[27670]={'036150'}
G[27671]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[27674]={'036150','1D537','02F37','04537','04837','3A237','46E37','54937'}
G[28167]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[28169]={'03610','1D52','02F2','0452','0482','3A22','46E2','5492'}
G[28355]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
G[28356]={'044350','04387','04C87','05187','21287','38F87','46D87','54887'}
end

if release >= 18414 then
G[37]={'04825'}
G[40]={'04810'}
G[62]={'048250'}
G[182]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[218]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[923]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[2948]={'02F250','036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[3361]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962','036250','1D562'}
G[8336]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[8338]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[8345]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[8346]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[8347]={'38F350'}
G[8884]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9548]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[9549]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[9550]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[9557]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9567]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9569]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9574]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9576]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9578]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9579]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9580]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9581]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9584]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9585]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9594]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9620]={'3A2150','1D537','02F37','03637','04537','04837','46E37','54937'}
G[9628]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9629]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9632]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[9641]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9643]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9646]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9647]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9648]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9649]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9667]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9668]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[9669]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9670]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9674]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[9682]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[9683]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[9687]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[9688]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[9689]={'045500','1D5125','02F125','036125','048125','3A2125','46E125','549125'}
G[9693]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[9694]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9696]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[9698]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9699]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9700]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9703]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9705]={'38F75','04318','04418','04C18','05118','21218','46D18','54818'}
G[9706]={'3A2150','1D537','02F37','03637','04537','04837','46E37','54937'}
G[9711]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9740]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9741]={'3A2150','1D537','02F37','03637','04537','04837','46E37','54937'}
G[9746]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9748]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[9751]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[9753]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[9756]={'3A2150','1D537','02F37','03637','04537','04837','46E37','54937'}
G[9759]={'3A2500','1D5125','02F125','036125','045125','048125','46E125','549125'}
G[9760]={'3A225','1D56','02F6','0366','0456','0486','46E6','5496'}
G[9761]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[9779]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10065]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10066]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[10067]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[12734]={'450250','45D250','451-550'}
G[12758]={'450250','45D250','451-550'}
G[12759]={'450350','45D350','451-770'}
G[12760]={'450350','45D350','451-770'}
G[13636]={'02F150','1D537','03637','04537','04837','3A237','46E37','54937'}
G[13945]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13946]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[14039]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[24473]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[24474]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24475]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24477]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24486]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24487]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[24489]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[24490]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[24491]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492','03610','1D52'}
G[24492]={'02F150','1D537','03637','04537','04837','3A237','46E37','54937','036150','1D537'}
G[24493]={'02F10','1D52','0362','0452','0482','3A22','46E2','5492'}
G[24494]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[24527]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25733]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25734]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25736]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25777]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[25780]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25800]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25801]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25804]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[25805]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25817]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25818]={'04875','1D518','02F18','03618','04518','3A218','46E18','54918'}
G[25819]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25849]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25850]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25853]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25854]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25855]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[25856]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[25857]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[25864]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25865]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25866]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25867]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[25868]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[25926]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25927]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[25939]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26036]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26037]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26038]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[26052]={'01575','0A937','17137','1D637','24137','057-75'}
G[26095]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26116]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26117]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[26120]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[26127]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26128]={'02F350','1D587','03687','04587','04887','3A287','46E87','54987'}
G[26139]={'1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[26176]={'02F150','1D537','03637','04537','04837','3A237','46E37','54937'}
G[26195]={'04575','1D518','02F18','03618','04818','3A218','46E18','54918'}
G[26196]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[26327]={'02F25','1D56','0366','0456','0486','3A26','46E6','5496'}
G[26335]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[26346]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[26383]={'04525','1D56','02F6','0366','0486','3A26','46E6','5496'}
G[26389]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[26490]={'044250','04362','04C62','05162','21262','38F62','46D62','54862'}
G[26536]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26628]={'015350','0A9175','171175','1D6175','241175','057-350'}
G[26662]={'015250','0A9125','171125','1D6125','241125'}
G[26663]={'015250','0A9125','171125','1D6125','241125'}
G[26664]={'015250','0A9125','171125','1D6125','241125'}
G[26665]={'015250','0A9125','171125','1D6125','241125'}
G[26678]={'01510','0A95','1715','1D65','2415'}
G[26679]={'01575','0A937','17137','1D637','24137'}
G[26685]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26695]={'015250','0A9125','171125','1D6125','241125'}
G[26697]={'015350','0A9175','171175','1D6175','241175'}
G[26698]={'01510','0A95','1715','1D65','2415'}
G[26699]={'015250','0A9125','171125','1D6125','241125'}
G[26700]={'015250','0A9125','171125','1D6125','241125'}
G[26703]={'015500','0A9250','171250','1D6250','241250'}
G[26723]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26727]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26728]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26729]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26730]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26731]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26733]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26734]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26736]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26737]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[26742]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26743]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26744]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26745]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26749]={'3A210','1D52','02F2','0362','0452','0482','46E2','5492'}
G[26751]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26772]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[26773]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[26774]={'3A2250','1D562','02F62','03662','04562','04862','46E62','54962'}
G[26775]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[26776]={'3A2500','1D5125','02F125','036125','045125','048125','46E125','549125'}
G[26778]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26779]={'212350','04387','04487','04C87','05187','38F87','46D87','54887'}
G[26780]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[26782]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26805]={'02F25','1D56','0366','0456','0486','3A26','46E6','5496'}
G[26838]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[26918]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26929]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26932]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[26980]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[26981]={'02F75','1D518','03618','04518','04818','3A218','46E18','54918'}
G[27168]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27171]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27172]={'1D575','02F75','03675','04575','04875','3A275','46E75','54975'}
G[27173]={'1D5250','02F250','036250','045250','048250','3A2250','46E250','549250'}
G[27174]={'1D5350','02F350','036350','045350','048350','3A2350','46E350','549350'}
G[27197]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27198]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27199]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27201]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27202]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[27203]={'46F75'}
G[27204]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27205]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27206]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[27233]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[27265]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27267]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[27343]={'048500','1D5125','02F125','036125','045125','3A2125','46E125','549125'}
G[27583]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
G[27625]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[27626]={'3A2350','1D587','02F87','03687','04587','04887','46E87','54987'}
G[27670]={'036250','1D562','02F62','04562','04862','3A262','46E62','54962'}
G[27721]={'48610'}
G[28268]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28299]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[28405]={'048350','1D587','02F87','03687','04587','3A287','46E87','54987'}
G[28459]={'04C350','04387','04487','05187','21287','38F87','46D87','54887'}
G[28512]={'03B10'}
G[28514]={'03B350'}
G[28762]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28770]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28785]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[28793]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28809]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28819]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[28909]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[29313]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29314]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29323]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29324]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29342]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29344]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29347]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29350]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29352]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29353]={'02F250','1D562','03662','04562','04862','3A262','46E62','54962'}
G[29357]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29359]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[32120]={'55F150'}
G[32204]={'56C150'}
G[32213]={'56C150'}
G[32255]={'56C150'}
G[32262]={'56C150'}
G[32264]={'56C150'}
G[32265]={'56C150'}
G[32266]={'56C150'}
G[32269]={'56C150'}
G[32288]={'56C150'}
G[32299]={'56C150'}
G[32302]={'56C150'}
G[32305]={'56C150'}
G[32326]={'55F150'}
G[32327]={'55F400','043350','044350','04C350','051350','212350','38F350','46D350','548350'}
G[32328]={'55F400'}
G[32329]={'55F200','38F75','04318','04418','04C18','05118','21218','46D18','54818'}
G[32330]={'55F500','38F500','043125','044125','04C125','051125','212125','46D125','548125'}
G[32343]={'55F300'}
G[32351]={'55F200'}
G[32352]={'55F500','043500','044500','04C500','051500','212500','38F500','46D500','548500'}
G[32363]={'55F150'}
G[32368]={'55F500'}
G[32376]={'55F150'}
G[32378]={'55F200'}
G[32379]={'55F200'}
G[32384]={'55F300'}
G[32391]={'55F200','04310','04410','04C10','05110','21210','38F10','46D10','54810'}
G[32392]={'55F500','043350','044350','04C350','051350','212350','38F350','46D350','548350'}
G[32402]={'55F100'}
G[32403]={'55F200','043250','044250','04C250','051250','212250','38F250','46D250','548250'}
G[32404]={'55F200','043250','044250','04C250','051250','212250','38F250','46D250','548250'}
G[32448]={'55F300'}
G[32521]={'56C200'}
G[32524]={'56C200'}
G[32650]={'4F6400'}
G[33354]={'38D250'}
end

if release >= 18546 then
G[33344]={'5A5250'}
G[33408]={'5A5250'}
G[33410]={'5A5250'}
G[33450]={'2D9250'}
G[33454]={'2D9250'}
G[33467]={'2D9250'}
G[33469]={'5A5350'}
G[33470]={'5A510'}
G[33473]={'5A5250'}
G[33526]={'5A5250'}
G[33527]={'5A5250'}
G[33546]={'5A5250'}
G[33622]={'5A5250'}
G[33784]={'5A5250'}
G[33807]={'2D9250'}
G[33815]={'5A5250'}
G[33816]={'5A5250'}
G[34379]={'5A575'}
G[34380]={'5A5-75'}
G[34402]={'5A575'}
end

if release >= 18556 then
G[33013]={'2D9250'}
G[33119]={'5A5250'}
G[33412]={'5A5250'}
G[33468]={'5A5250'}
G[33898]={'5A5250'}
G[35251]={'5A5350'}
end

if release >= 18566 then
G[33462]={'5A5250'}
G[34344]={'5A5250'}
G[34345]={'5A5250'}
G[34346]={'5A5250'}
G[34348]={'5A5250'}
end

if release >= 18645 then
G[33125]={'5A5250'}
G[33132]={'5A5350'}
G[33145]={'5A5250'}
G[34505]={'2D9250'}
end

if release >= 18663 then
G[33579]={'5EB250'}
G[33580]={'5EB250'}
G[33581]={'5EB250'}
G[33582]={'5EB250'}
G[33734]={'6C3250'}
G[33740]={'6C3250'}
G[33761]={'6C3250'}
G[34701]={'6C310'}
G[36119]={'69275'}
end

if release >= 18702 then
G[33075]={'6C3250'}
G[34512]={'0A9250','015250','171250','1D6250','241250'}
G[34513]={'0A9350','015350','171350','1D6350','241350'}
G[34514]={'0A9250','015250','171250','1D6250','241250'}
G[34515]={'0A9250','015250','171250','1D6250','241250'}
G[34516]={'0A9250','015250','171250','1D6250','241250'}
G[34598]={'0A910','01510','17110','1D610','24110'}
G[34662]={'0A9350','015350','171350','1D6350','241350'}
G[34809]={'0A9250','015250','171250','1D6250','241250'}
G[34810]={'0A910','01510','17110','1D610','24110'}
G[34811]={'0A9250','015250','171250','1D6250','241250'}
G[35142]={'5A5350'}
G[35632]={'0A9250','015250','171250','1D6250','241250'}
G[35663]={'0A9250','015250','171250','1D6250','241250'}
end

if release >= 18716 then
G[33410]={'5A5350'}
G[33412]={'5A510'}
G[33450]={'5A5250'}
G[33454]={'5A5250'}
G[33467]={'5A5250'}
G[33484]={'5A510'}
G[33527]={'5A5500'}
G[33657]={'5A510'}
G[33721]={'5A5250'}
G[33735]={'5A5250'}
G[33736]={'5A5250'}
G[33807]={'5A5250'}
G[33919]={'5A5500'}
G[34380]={'5A5250'}
G[34505]={'5A5250'}
G[35237]={'5A5250'}
G[35251]={'5A5250'}
end

if release >= 18738 then
G[26389]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[26919]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28786]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
end

if release >= 18761 then
G[26915]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28764]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28766]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28772]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28787]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[28795]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28811]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28821]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
end

if release >= 18764 then
G[26917]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28759]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28767]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28780]={'04825','1D56','02F6','0366','0456','3A26','46E6','5496'}
G[28791]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28806]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[28817]={'04810','1D52','02F2','0362','0452','3A22','46E2','5492'}
G[32791]={'5A5250'}
G[32792]={'5A5250'}
G[32794]={'5A5250'}
G[32795]={'5A5350'}
G[32796]={'5A510'}
G[32804]={'5A5250'}
G[32929]={'5A5250'}
G[33469]={'5A5250'}
G[33470]={'5A5250'}
G[33530]={'6C3250'}
G[33815]={'5A510'}
G[33915]={'5A5250'}
G[33917]={'6C3250'}
G[33920]={'6C3250'}
G[34351]={'6C3250'}
G[34639]={'5EB250'}
G[37112]={'04825'}
end

if release >= 19027 then
G[34655]={'5EB250'}
G[34656]={'5EB250'}
G[34657]={'5EB250'}
end

if release >= 19034 then
G[8473]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[9130]={'38F25','0436','0446','04C6','0516','2126','46D6','5486'}
G[9133]={'38F75','04318','04418','04C18','05118','21218','46D18','54818'}
G[9134]={'38F25','0436','0446','04C6','0516','2126','46D6','5486'}
G[9135]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[26642]={'04C75','04318','04418','05118','21218','38F18','46D18','54818'}
end

if release >= 19057 then
G[34658]={'5EB250'}
G[34659]={'5EB250'}
G[34756]={'5EB250'}
G[34805]={'5EB250'}
G[35636]={'5EB250'}
G[35668]={'5EB250'}
G[35671]={'5EB75'}
end

if release >= 19085 then
G[34827]={'5EB250'}
G[34884]={'5EB250'}
end

if release >= 19116 then
G[7001]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[10068]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[11604]={'41A25','40D12','42C6','4466','4666'}
G[11932]={'41A75','40D37','42C18','44618','46618'}
G[11962]={'41A25','40D12','42C6','4466','4666'}
G[11963]={'41A25','40D12','42C6','4466','4666'}
G[11965]={'41A250','40D125','42C62','44662','46662'}
G[12167]={'41A250','40D125','42C62','44662','46662'}
G[12168]={'41A10','40D5','42C2','4462','4662'}
G[12169]={'41A350','40D175','42C87','44687','46687'}
G[24507]={'43D500','41C250','428125','42B125','464125'}
G[24511]={'43D500','41C250','428125','42B125','464125'}
G[24712]={'43D500','41C250','428125','42B125','464125'}
G[24802]={'43D500','41C250','428125','42B125','464125'}
G[27844]={'39A1000'}
G[28560]={'38F10','0432','0442','04C2','0512','2122','46D2','5482'}
G[28571]={'04410','0432','04C2','0512','2122','38F2','46D2','5482'}
G[28816]={'04C10','0432','0442','0512','2122','38F2','46D2','5482'}
G[29331]={'46F500'}
G[29440]={'46F10'}
G[29650]={'3B2250'}
G[29651]={'3B3250'}
G[29653]={'3B3500'}
G[29655]={'3B3350'}
G[29803]={'41C500','428250','42B250','43D250','464250'}
G[32668]={'39A3000'}
G[33059]={'6C3250'}
G[33072]={'6C375'}
G[33076]={'6C3250'}
G[33077]={'6C3250'}
G[33078]={'6C3250'}
G[33080]={'6C3250'}
G[33081]={'6C3500'}
G[33255]={'6C3250'}
G[33256]={'6C3250'}
G[33419]={'6C3250'}
G[33813]={'6C3250'}
G[33833]={'6C3500'}
G[33834]={'6C3500'}
G[33836]={'6C3350'}
G[33837]={'6C3500'}
G[33958]={'6C3250'}
G[33967]={'6C3250'}
G[33969]={'6C3250'}
G[33976]={'6C3250'}
G[33988]={'6C3250'}
G[34013]={'6C3250'}
G[34019]={'6C3250'}
G[34043]={'6C3250'}
G[34076]={'56B150'}
G[34088]={'6C3250'}
G[34089]={'6C3250'}
G[34090]={'6C3250'}
G[34091]={'6C3250'}
G[34092]={'6C3250'}
G[34094]={'6C3250'}
G[34095]={'6C3250'}
G[34096]={'6C3250'}
G[34097]={'6C3250'}
G[34098]={'6C3250'}
G[34099]={'6C3500'}
G[34154]={'6C3500'}
G[34157]={'6C375'}
G[34163]={'6C3250'}
G[34164]={'6C3250'}
G[34234]={'6C3250'}
G[34240]={'6C375'}
G[34326]={'6C310'}
G[34407]={'6C3250'}
G[34452]={'6C375'}
G[34458]={'6C3250'}
G[34496]={'6C3500'}
G[34501]={'5A5250'}
G[34504]={'6C3250'}
G[34508]={'6C3250'}
G[34512]={'6C4250'}
G[34513]={'6C4350'}
G[34514]={'6C4250'}
G[34515]={'6C4250'}
G[34516]={'6C4250'}
G[34598]={'6C410'}
G[34639]={'6C3500'}
G[34660]={'6C3250'}
G[34662]={'6C4350'}
G[34663]={'6C4350'}
G[34664]={'6C4350'}
G[34665]={'6C4350'}
G[34666]={'6C4350'}
G[34667]={'5EB250'}
G[34784]={'6C3250'}
G[34786]={'6C3250'}
G[34787]={'6C3250'}
G[34788]={'6C3250'}
G[34789]={'6C3250'}
G[34790]={'6C3250'}
G[34791]={'6C3250'}
G[34792]={'6C3250'}
G[34809]={'6AF250'}
G[34811]={'6AF250'}
G[34828]={'5EB250'}
G[34829]={'5EB250'}
G[34830]={'5EB250'}
G[34838]={'5EB250'}
G[34876]={'6C3250'}
G[34882]={'5EB250'}
G[34883]={'5EB250'}
G[34885]={'5EB250'}
G[34886]={'5EB250'}
G[34897]={'6C3250'}
G[34921]={'5EB250'}
G[34922]={'5EB250'}
G[34923]={'5EB250'}
G[34924]={'5EB250'}
G[34938]={'5EB350'}
G[34939]={'5EB250'}
G[34942]={'5EB10'}
G[34959]={'6C3250'}
G[34963]={'6C3250'}
G[34991]={'5EB250'}
G[34996]={'6C3250'}
G[34998]={'5EB10'}
G[34999]={'5EB250'}
G[35000]={'5EB250'}
G[35001]={'5EB250'}
G[35002]={'5EB250'}
G[35003]={'5EB250'}
G[35004]={'5EB250'}
G[35007]={'5EB10'}
G[35009]={'5EB250'}
G[35010]={'5EB10'}
G[35011]={'5EB250'}
G[35012]={'5EB250'}
G[35013]={'5EB250'}
G[35014]={'6C3250'}
G[35015]={'6C3250'}
G[35070]={'6C3250'}
G[35169]={'6C3500'}
G[35171]={'5A5500'}
G[35227]={'6C3250'}
G[35236]={'6C3250'}
G[35237]={'5EB10'}
G[35245]={'5EB25'}
G[35254]={'6C3250'}
G[35257]={'5EB10'}
G[35258]={'5EB250'}
G[35259]={'5EB250'}
G[35260]={'5EB250'}
G[35261]={'5EB250'}
G[35273]={'5EB250'}
G[35552]={'6C3250'}
G[35632]={'6AF250'}
G[35634]={'5EB250'}
G[35663]={'6AF250'}
G[35704]={'5EB250'}
G[35733]={'5EB10'}
G[35734]={'5EB250'}
G[35895]={'5EB250'}
G[35896]={'5EB500'}
G[35897]={'5EB250'}
G[36059]={'5EB250'}
G[36085]={'5EB250'}
G[36176]={'6C3250'}
G[36177]={'6C3250'}
G[36185]={'6C3250'}
G[36239]={'6C3250'}
G[36240]={'6C3250'}
G[36241]={'6C3250'}
G[36301]={'5A5250'}
G[36316]={'5EB500'}
G[36338]={'6AF350'}
G[36383]={'6B05000'}
G[36408]={'6C3250'}
G[36409]={'6C3250'}
G[36417]={'5A5250'}
G[36419]={'5A5250'}
G[36425]={'5EB250'}
G[36481]={'38D250'}
G[36489]={'6B05000'}
G[36505]={'5A5250'}
G[36516]={'5A5250'}
G[36590]={'6C3250'}
G[36660]={'6C3250'}
G[36701]={'6B64000'}
G[36790]={'5EB250'}
G[36808]={'6B14000'}
G[36818]={'6B012000'}
G[36819]={'6AF500'}
G[36951]={'5EB10'}
G[37295]={'691250'}
G[37422]={'6C3250'}
G[37475]={'691250'}
G[37476]={'691150'}
G[37477]={'691250'}
G[37478]={'691250'}
G[37479]={'691250'}
G[37480]={'691250'}
G[37631]={'6B012000'}
G[37632]={'6B012000'}
end

if release >= 19243 then
G[2950]={'04C250','04362','04462','05162','21262','38F62','46D62','54862'}
G[12629]={'44A250','449250'}
G[12648]={'44A150','449150'}
G[12661]={'44A250','449250'}
G[12669]={'44A250','449250'}
G[12676]={'44A250','449250'}
G[12677]={'44A250','449250'}
G[12713]={'44A500','449500'}
G[26946]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[29122]={'486250'}
G[29215]={'3DE350'}
G[33070]={'6C3250'}
G[33083]={'6C3250'}
G[33765]={'6C3250'}
G[33793]={'6C3250'}
G[33794]={'6C3250'}
G[33795]={'6C3250'}
G[33905]={'6C3250'}
G[34054]={'6C3500'}
G[34076]={'6C3500'}
G[34504]={'6C3500'}
G[34585]={'6C3250'}
G[34639]={'6C3250'}
G[34667]={'6C3250'}
G[34723]={'6C3500'}
G[34728]={'6C3350'}
G[34780]={'6C3250'}
G[34781]={'6C3250'}
G[34782]={'6C310'}
G[34783]={'6C3250'}
G[34785]={'6C3250'}
G[35032]={'6C3250'}
G[35637]={'6B212000'}
G[35945]={'6AF10'}
G[35970]={'6AF250'}
G[35972]={'6AF350'}
G[35973]={'6AF350'}
G[35974]={'6B612000'}
G[35985]={'6AF350'}
G[36309]={'6C3250'}
G[36311]={'6C3250'}
G[36571]={'54D1000'}
G[36611]={'516250'}
G[36686]={'6B012000'}
G[36699]={'6B612000'}
G[36807]={'04C75'}
G[36818]={'6AF250'}
G[36820]={'6C4250'}
G[36826]={'6B412000'}
G[36827]={'6AF350'}
G[36882]={'516250'}
G[37446]={'04C350'}
G[37511]={'6AF350'}
G[37517]={'6AF500'}
end

if release >= 19342 then
G[27203]={'46F10'}
G[27595]={'49575'}
G[27629]={'49575'}
G[33013]={'5A5250'}
G[34076]={'6C3350'}
G[34496]={'6C3250'}
G[34639]={'5EB250'}
G[34653]={'5EB10'}
G[34660]={'6C375'}
G[34723]={'6AF350'}
G[34724]={'5EB500'}
G[35237]={'6B212000'}
G[35881]={'5EB500'}
G[36123]={'40D250','41A125','42C125','446125','466125'}
G[36127]={'691250'}
G[36163]={'6C3250'}
G[36164]={'6C3250'}
G[36167]={'6C3250'}
G[36168]={'6C3250'}
G[36169]={'6C3500'}
G[36193]={'6C3250'}
G[36205]={'5A5250'}
G[36207]={'5A525'}
G[36230]={'5A5250'}
G[36236]={'6C3250'}
G[36262]={'6C3250'}
G[36266]={'6C3250'}
G[36269]={'6C3250'}
G[36473]={'5EB500'}
G[36480]={'5EB500'}
G[36490]={'6B612000'}
G[36566]={'6B012000'}
G[36571]={'5EB500'}
G[36603]={'5EB500'}
G[36669]={'6B112000'}
G[36678]={'5EB10'}
G[36699]={'6B212000'}
G[36807]={'6B212000'}
G[36815]={'6B312000'}
G[36818]={'6B012000'}
G[36822]={'6B012000'}
G[37297]={'40D250','41A125','42C125','446125','466125'}
G[37475]={'692250'}
G[37476]={'691250'}
G[37477]={'40D250','41A125','42C125','446125','466125'}
G[37478]={'40D250','41A125','42C125','446125','466125'}
G[37482]={'40D250','41A125','42C125','446125','466125'}
end

if release >= 19508 then
G[33468]={'5A510'}
G[33483]={'5A5250'}
end

if release >= 19533 then
G[32783]={'5A510'}
G[32992]={'5A5250'}
G[32993]={'5A5250'}
G[32994]={'5A5250'}
G[33010]={'5A5350'}
G[33493]={'5A5250'}
G[33785]={'5A5250'}
G[33826]={'5A5250'}
G[33828]={'5A5250'}
G[34123]={'5A510'}
G[34124]={'5A5500'}
G[36314]={'5A5250'}
G[36352]={'5A525'}
G[36378]={'5A5250'}
G[36380]={'5A5250'}
end

if release >= 19579 then
G[33132]={'5A5250'}
end

if release >= 19622 then
G[33720]={'5A5250'}
G[33722]={'5A5250'}
G[33724]={'5A5250'}
G[33728]={'5A5250'}
G[33729]={'5A5250'}
G[33730]={'5A5350'}
G[33731]={'5A5500'}
G[34950]={'5A5250'}
G[35226]={'5A5250'}
end

if release >= 19702 then
G[10070]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[13506]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13507]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13508]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13509]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13511]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13512]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13513]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13514]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13515]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13519]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13590]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13591]={'045350','1D587','02F87','03687','04887','3A287','46E87','54987'}
G[13596]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[13844]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[14405]={'46E75','1D518','02F18','03618','04518','04818','3A218','54918'}
G[26129]={'46E250','1D562','02F62','03662','04562','04862','3A262','54962'}
G[28725]={'045250'}
G[35649]={'5EB500'}
G[36123]={'692250'}
G[36125]={'692250'}
G[36127]={'692250'}
G[36130]={'692250'}
G[36133]={'692250'}
G[36660]={'5EB250'}
G[36792]={'5EB500'}
G[36823]={'6B012000'}
G[37439]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[37440]={'38F250'}
G[37442]={'38F250','04362','04462','04C62','05162','21262','46D62','54862'}
G[37443]={'38F250'}
end

if release >= 19769 then
G[24928]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
G[24949]={'46D250','04362','04462','04C62','05162','21262','38F62','54862'}
end

if release >= 19802 then
G[13573]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[36117]={'6AF350'}
G[36197]={'691150'}
G[36198]={'691250'}
G[36226]={'691250'}
G[36227]={'691250'}
G[36228]={'691250'}
G[36695]={'6AF350'}
G[36814]={'6B312000'}
G[37297]={'69225'}
G[37475]={'69225'}
G[37476]={'69225'}
G[37477]={'69225'}
G[37478]={'6B012000'}
G[37481]={'692250'}
G[37482]={'69225'}
G[37516]={'6AF500'}
G[37628]={'6AF350'}
end

if release >= 19865 then
G[35641]={'6B212000'}
G[38196]={'6B612000'}
G[38197]={'6B612000'}
end

if release >= 20157 then
G[38274]={'7371000','7381000'}
G[38562]={'7371000'}
G[39432]={'7391500'}
G[39586]={'737250'}
end

if release >= 20173 then
G[37891]={'737350'}
G[38445]={'7371500'}
G[38446]={'737350'}
G[39433]={'7391500'}
G[39581]={'737250'}
end

if release >= 20182 then
G[38440]={'73A1500'}
G[38587]={'737250'}
G[39569]={'737250'}
G[39574]={'737250'}
G[39582]={'73A1500'}
end

if release >= 20201 then
G[37938]={'737250'}
G[38045]={'737250'}
G[38223]={'7371000','7381000'}
G[38250]={'737250'}
G[38440]={'737250'}
G[39443]={'737500'}
G[39449]={'737500'}
G[39571]={'737250'}
G[39573]={'737250'}
end

if release >= 20216 then
G[35649]={'73A3500'}
G[37968]={'73A1500'}
G[38045]={'737500'}
G[38046]={'737250'}
G[38051]={'737250'}
G[38439]={'737500'}
G[38440]={'737500'}
G[39394]={'7372500'}
G[39451]={'737250'}
G[39565]={'73A3500'}
G[39568]={'737250'}
end

if release >= 20253 then
G[36648]={'6B112000'}
G[36649]={'6B212000'}
G[36674]={'737500'}
G[36675]={'6B012000'}
G[36676]={'6B112000'}
G[36678]={'6B012000'}
G[36679]={'6B012000'}
G[36680]={'6B012000'}
G[36682]={'6B012000'}
G[36684]={'6B212000'}
G[36686]={'6B612000'}
G[36822]={'737250'}
G[37629]={'6B012000'}
G[37866]={'73A1500'}
G[37891]={'737500'}
G[37968]={'737500'}
G[38045]={'7391500'}
G[38046]={'73A1500'}
G[38051]={'7391500'}
G[38195]={'6B012000'}
G[38439]={'6B612000'}
G[38585]={'7391500'}
G[38870]={'737250'}
G[38877]={'73A1500'}
G[39441]={'737250'}
G[39443]={'737250'}
G[39567]={'737250'}
G[39570]={'737250'}
end

if release >= 20338 then
G[28774]={'048250','1D562','02F62','03662','04562','3A262','46E62','54962'}
G[36069]={'6B64000'}
G[36383]={'73A3500'}
G[36649]={'6B612000'}
G[36683]={'6B012000'}
G[36685]={'6B412000'}
G[36816]={'6B412000'}
G[37819]={'38D250'}
G[37866]={'737500'}
G[37891]={'737250'}
G[37910]={'38D250'}
G[37966]={'73A1500'}
G[37968]={'7391500'}
G[38045]={'737250'}
G[38046]={'737500'}
G[38051]={'73A1500'}
G[38193]={'6B412000'}
G[38250]={'73A1500'}
G[38439]={'737500'}
G[38440]={'737250'}
G[38877]={'737500'}
G[39441]={'38D250'}
G[39443]={'38D250'}
G[39445]={'6B64000'}
G[39447]={'73A1500'}
end

if release >= 20395 then
G[37935]={'7381500'}
G[38001]={'738350'}
G[39519]={'738250'}
end

if release >= 20426 then
G[38047]={'738500'}
G[38054]={'738500'}
G[38449]={'738500'}
G[39510]={'738250'}
G[39526]={'738250'}
G[39529]={'73A1500'}
end

if release >= 20490 then
G[24758]={'04C75'}
G[24759]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24760]={'212150','04337','04437','04C37','05137','38F37','46D37','54837'}
G[24761]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24762]={'212250','04362','04462','04C62','05162','38F62','46D62','54862'}
G[24763]={'21275','04318','04418','04C18','05118','38F18','46D18','54818'}
end

if release >= 20574 then
G[28723]={'045250','1D562','02F62','03662','04862','3A262','46E62','54962'}
G[28724]={'045250'}
G[28725]={'045150'}
G[28734]={'045250'}
G[37866]={'737250'}
G[37891]={'7391500'}
G[38045]={'737500'}
G[39445]={'737250'}
end

if release >= 22566 then
G[36920]={'76C150'}
G[37256]={'76C150'}
G[37257]={'76C150'}
G[37449]={'76C250'}
G[37450]={'76C150'}
G[37467]={'76C150'}
G[37468]={'76C75'}
G[37469]={'76C150'}
G[37470]={'76C500'}
G[37486]={'76C150'}
G[37492]={'76C150'}
G[37496]={'76C150'}
G[37497]={'76C150'}
G[37507]={'76C10'}
G[37518]={'76C150'}
G[37528]={'76C150'}
G[37530]={'76C150'}
G[37542]={'76C150'}
G[37653]={'76C150'}
G[37654]={'76C10'}
G[37656]={'76C150'}
G[37657]={'76C250'}
G[37658]={'76C150'}
G[37660]={'76C150'}
G[37678]={'76C150'}
G[37690]={'76C10'}
G[37727]={'76C150'}
G[37728]={'76C150'}
G[37729]={'76C150'}
G[37730]={'76C150'}
G[37733]={'76C10'}
G[37736]={'76C150'}
G[37853]={'76C150'}
G[37855]={'76C10'}
G[37856]={'76C150'}
G[37857]={'76C150'}
G[37860]={'76C150'}
G[37861]={'76C250'}
G[37862]={'76C75'}
G[37957]={'76C150'}
G[37959]={'76C150'}
G[37960]={'76C150'}
G[37991]={'76C75'}
G[38014]={'76C150'}
G[38015]={'76C150'}
G[38407]={'76C10'}
G[38443]={'76C10'}
G[38711]={'75B10'}
G[38834]={'76C10'}
G[38862]={'75B150'}
G[40794]={'76C250'}
G[42220]={'76C150'}
G[42271]={'76C75'}
G[42370]={'76C150'}
G[42371]={'76C150'}
G[42567]={'76C10'}
G[42692]={'76C150'}
G[42693]={'76C150'}
G[42694]={'76C150'}
G[42756]={'76C250'}
end

if release >= 22624 then
G[37510]={'76C10'}
G[37536]={'76C10'}
G[37538]={'76C250'}
G[37565]={'76C150'}
G[37566]={'76C250'}
G[38142]={'75B10'}
G[38143]={'75B150'}
G[38144]={'75B150'}
G[38145]={'75B150'}
G[38146]={'75B150'}
G[38147]={'75B250'}
G[38148]={'75B10'}
G[38225]={'75B250'}
G[38235]={'75B150'}
G[38246]={'75B150'}
G[38322]={'75B10'}
G[38323]={'75B10'}
G[38377]={'75B150'}
G[38382]={'75B10'}
G[38384]={'75B10'}
G[38455]={'75B150'}
G[38582]={'75B150'}
G[38595]={'75B150'}
G[38641]={'75B10'}
G[38643]={'75B10'}
G[38644]={'75B150'}
G[38645]={'75B150'}
G[38646]={'75B150'}
G[38647]={'75B150'}
G[38655]={'75B150'}
G[38662]={'75B150'}
G[38663]={'75B10'}
G[38671]={'75B150'}
G[38684]={'75B150'}
G[38687]={'75B150'}
G[38691]={'75B10'}
G[38714]={'75B150'}
G[38715]={'75B150'}
G[38716]={'75B150'}
G[38717]={'75B150'}
G[38718]={'75B150'}
G[38719]={'75B150'}
G[38721]={'75B250'}
G[38724]={'75B150'}
G[38743]={'75B350'}
G[38748]={'75B150'}
G[38753]={'75B250'}
G[38857]={'76C150'}
G[38922]={'75B150'}
G[39029]={'75B150'}
G[39117]={'75B150'}
G[39149]={'75B10'}
G[39354]={'75B150'}
G[39383]={'75B150'}
G[39384]={'75B150'}
G[40122]={'75B10'}
G[40567]={'75B150'}
G[40573]={'75B250'}
G[40890]={'75B1000'}
G[41056]={'75B10'}
G[41707]={'75B150'}
G[41708]={'75B150'}
G[41724]={'75B150'}
G[41893]={'75B150'}
G[42857]={'75B150'}
G[42865]={'75B150'}
G[42883]={'75B150'}
G[42884]={'75B150'}
G[43702]={'75B150'}
G[44106]={'75B10'}
end

if release >= 22810 then
G[38312]={'79C150'}
G[38331]={'79C10'}
G[38442]={'79C150'}
G[39590]={'79C150'}
G[39591]={'79C150'}
G[39592]={'79C150'}
G[39593]={'79C150'}
G[39594]={'79C250'}
G[39595]={'79C150'}
G[39597]={'79C150'}
end

--	Now the reputation data gets processed into its own table to save space

for questId, reps in pairs(Grail.questReputations) do
	if reps ~= nil then
		local index, mapId, factionId
		local s = ""
		for _, v in pairs(reps) do
			index = strsub(v, 1, 3)
			factionId = tonumber(index, 16)
			mapId = factionId  + Grail.mapAreaBaseReputationChange
if (index == nil) then print("index is nil "..v) end
if (Grail.reputationMapping[index] == nil) then print("no reputation mapping for ", index) end
			Grail:AddQuestToMapArea(questId, mapId, COMBAT_TEXT_SHOW_REPUTATION_TEXT .. " - " ..Grail.reputationMapping[index])
			s = s .. Grail:_ReputationCode(v)
		end
		if "" == s then s = nil end
		Grail.questReputations[questId] = s		-- replaces the table with a string to save space
	end
end
Grail:_CleanDatabase()	-- this is called because Grail will do it before this loadable addon is loaded, which means its reputation data will be dirty

end
