--
--	Grail Quests
--	Written by scott@mithrandir.com
--
--	Version History
--		001	Initial verison.
--		002	Added all the Lunar Festival and Harvest Festival quests.
--		003	Added the Love is in the Air quests except for the following which appear to have been removed from the game
--				[14488]='HA L075 A:38208 T:36296 P:24792,24793'
--				[24792]='HA FA L078 A:38066 T:38208'
--				[24793]='HA FH L078 A:37172 T:38208'
--		004	Added yearly markers to Lunar Festival quests.
--			Added Noblegarden quests, markers for Pilgrim's Bounty and Day of the Dead quests
--			Updated a couple starting Worgen quests.
--		005	Updated a bunch of quests.
--		006	Updated a bunch of quests.
--		007	Added a bunch of quests for the last remaining holidays.
--			Updated a bunch of quest information (primarily prerequisites) based on game play.
--			Started processing new quests added in game version 4.1.
--		008	Started putting in K codes.
--			Updated quest prerequisites, etc. based on game play.
--		009	Removed the cloth donation quests.
--			Updated a lot of Alliance Twilight Highlands based on game play.
--		010	More updates including some more level information.
--		011	Added more K codes for some low-level quests.
--			Put in some I:, P: and reputation requirements for Deepholm quests.
--			Converted A:0 to the Self alias NPCs that indicate probable zones for acceptance.
--			Added a bunch of Firelands quests.
--		012	Added a lot more K codes
--			Some updates to Firelands quests.
--		013	Updates to some Horde starting areas, Gilneas and a few tweaks to Firelands.
--		014 Put all the quests in numeric order instead of keeping some of the groups for processing purposes.
--			Many updates to zones noted in the Grail.lua file.
--			Horde cooking and fishing quests updated.
--			Converted the K codes for cooking/fishing/Brewfest quests to level 0 to indicate they are actually the level of the player accepting them.
--		015	Some minor updates after some massive ones previously.
--			Hallow's End updates.
--			Introduced a few new codes.
--		016	Switched out all the ++, +D, +W, +M and +Y codes for their "bitmap values".
--
--	Known issues
--		Not all quests are present.
--		Not all quest information is accurate.
--		Need to update the Horde Children's Week quests.
--
--	UTF-8 file
--
--	Each of the Midsummer torch tossing/catching quests is marked as incompatible with the other
--	faction's same quest.  This is because this is what happens in the runtime when playing, even
--	though nowadays one cannot get the quest at the other faction's questgiver.
--
--	Entries in the quest table:
--		0	localized name of the quest
--		1	code string
--		2	cached type bit value
--		3	cached holiday bit value
--		4	cached obtainers bit value
--		5	achievement "map areas"
--		6	table of reputation changes when quest turned in
--		7	realtime computed status
--		8	A codes (NPC IDs processed for faction)
--		9	T codes (NPC IDs processed for faction)
--		10	P codes
--		11	I codes
--		12	O codes
--		13	cached level bit value
--		14	reputation requirements from P codes	(a table of tables where the internal table has the reputation code and the amount (with amount negative meaning not to exceed))
--
--		SP, rep (V & W codes), OAC codes, OBC:, OCC:, OTC:, Y (alias quests), processed T codes, processed A codes, AK, AZ, PL, PLT, PH, PC, PCT, prof
--
--      Possible codes for prerequisite info:
--		(if no code present A assumed for P: and C is assumed for I: and B:)
--			A   quest must be turned in
--			B   quest must be in log
--			C   quest must be in log or turned in
--			c	quest must NOT be in log and NOT turned in
--			D   quest must be completed in log
--			E   quest must be completed in log or turned in
--			e	quest must be in log but not completed or not turned in
--			Fx	must belong to faction x where A is Alliance and H is Horde
--			Gbbbbppp	building bbbb (with negative meaning any of that type) present in garrison, with optional ppp plot location required
--			H   quest has ever been completed
--			I   spell effect present
--			i	spell effect NOT present
--			J   achievement completed
--			j	achievement NOT completed
--			K	item possessed
--			k	item NOT possessed
--			Lxxx	player level must be >= xxx
--			lxxx	player level must be < xxx
--			M	quest has been abandoned at least once
--			m	quest has never been abandoned
--			Nx	where x is the key to a required class (see classMapping).
--			O	quest must be accepted
--			Pxyyy	profession x (see professionMapping) must have a skill value of at least yyy
--			Qxxxx	the equipped iLvl must be >= xxxx
--			qxxxx	the equipped iLvl must be < xxxx
--			R	spell effect has ever been present
--			S	skill possessed (where the value is Blizzard's spell ID of the skill)
--			s	skill not possessed (where the value is Blizzard's spell ID of the skill)
--			Txxxyyyyy	reputation xxx must be at least yyyyy value
--			Uxxxyyyyy	reputation xxx must be under yyyyy value	*** CONVERT U to t ***
--			Vxxxy	quest group xxx must have y quests accepted
--			Wxxxy	quest group xxx must have y quests completed (turned in)
--			wxxxy	quest group xxx must have y quests completed in log or turned in
--			X	quest must not be turned in
--			Y	achievement completed by this player
--			y	achievement NOT completed by this player
--			Z	spell has ever been cast by player
--			zbbbb	building bbbb (with negative meaning any of that type) needs a worker	[I will eventually unify the letters above properly to free one instead of using 'z']
--			=zzzzp	the current phase in zone zzzz must be phase p
--			>zzzzp	the current phase in zone zzzz must be more than phase p
--			<zzzzp	the current phase in zone zzzz must be less than phase p
--			!xxxx	the NPC represented by xxxx needs to be killed		*** implement this ***
--			?xxxx	when zone xxxx is entered	*** implement this ***
--
--		Note that garrison level is examined by using phase comparisons to zone 971 so, e.g., >09711 would mean a garrison of level 2 or higher.
--
--	The code string can indicate any of the following information and should not be localized:
--		A:list		where list (see below) is the list of NPCs that give this quest to anyone
--		AA:list		where list (see below) is the list of NPCs that give this quest to Alliance only
--		AH:list		where list (see below) is the list of NPCs that give this quest to Horde only
--		AK:list		where list (see below) is the list of NPCs that you can kill to automatically start the quest
--		AZ:zone		where zone is the zone ID of the zone that when entered automatically gives the quest
--		B:list		where list (see below) is the list of quests for which this quest is a breadcrumb quest	*** NO LONGER USED ***
--		Cx			where x is the key to a required class (see classMapping). if no Cx is present any class can accept the quest.  mutually exclusive with Xx codes.
--		Dxxx		where xx is the number of the group to which these daily quests belong
--		Exxxxx		where xxxxx is the Blizzard release version where this quest starts to exist
--		Fx			where x is the key to a permitted faction (A for Alliance and H for Horde).  if no Fx is present any faction can accept the quest
--		Gx			where x is the key to a permitted gender (M for male and F for female).  if no Gx is present any gender can accept the quest
--		Hx			where x is the key to a specific holiday (see holidayMapping) when this quest is available.  if no Hx is present it should be available all the time.
--		I:pat		where pat is a pattern (see below) of quests considered to invalidate the quest (they are mutually exclusive with this quest)  in other words, if the quest is in the Blizzard quest log or has ever been completed
--		J:pat		where pat is a pattern (see below) of quests considered to have caused this FLAG quest to be marked complete.  Used for UI to ignore FLAG quests and present to the user a nicer experience.
--		Kxxxyyy		where xxx is the level of the quest (or 000 if the quest has a changing quest level the same as the player level) and 
--			yyy is a number whose bits represent aspects of the quest:
--			1	repeatable
--			2	daily
--			4	weekly
--			8	monthly
--			16	yearly
--			32	escort
--			64	dungeon
--			128	raid
--			256	PVP
--			512	group
--			1024	heroic
--			2048	scenario
--			4096	legendary
--			8192	account-wide
--			16384	pet battle
--			32768	bonus objective
--			65536	rare mob
--			131072	treasure
--			262144	world quest
--		Lxxx		where xxx is the minimum level for the quest to be acceptable
--		Mxxx		where xxx is the maximum level for the quest to be acceptable
--		O:pat		where pat is a pattern (see below) of quests that are optional prerequisites
--		OAC:list	where list (see below) is the list of quests that are marked complete once this quest is accepted (On Accept Complete)
--		OBC:list	where list (see below) is the list of quests that are marked "control" complete once this quest is abandoned
--		OCC:list	where list (see below) is the list of quests that are marked complete once this quest is marked complete in the quest log
--		ODC:list	where list (see below) is the list of quests that are marked complete once this quest is turned in
--		OEC:list	where list (see below) is the list of quests that are marked complete once this quest is turned in and OPC: rules are met
--		OPC:pat		where pat is a pattern (see below) of prerequisites that need to be met before other OxC: codes that use OPC: rules will do their actions
--		OTC:pat		where pat is a comma-separated list of plus-separated pairs where the first in the pair is an NPC ID and the second is the quest ID to complete
--		P:pat		where pat is a pattern (see below) of quests considered to be prerequisites
--		DEPRECATED	Pxyyy		where x is the key to a required profession and yyy is the minimum skill (see professionMapping).
--		Qx:QualifiedPattern	is completed when a Gossip number x is peformed with the first matching NPC from the QualifiedPattern
--		Rx			where x is the key to a permitted race (see raceMapping).  if no Rx is present any race can accept the quest
--		Sx			where x is the key to an excluded race (see raceMapping).  if no Sx is present, any race can accept the quest
--		SP			indicated the quest is a special one that never appears in the quest log
--		T:list		where list (see below) is the list of NPCs where the quest is turned in by anyone
--		TA:list		where list (see below) is the list of NPCs where the quest is turned in by Alliance only
--		TH:list		where list (see below) is the list of NPCs where the quest is turned in by Horde only
--		Ux			where x is the follower ID obtained when completing the quest
--		DEPRECATED	Vxxyyyyy	where xx is the key to the required reputation and yyyyy is the minimum number of earned points in it (see reputationMapping).  note that you add 42000 to earned value.
--		DEPRECATED	Wxxyyyyy	where xx is the key to the required reputation and yyyyy is the maximum number of earned points in it (see reputationMapping).  note that you add 42000 to earned value.
--			hated: 0   hostile: 35999   unfriendly: 38999
--			neutral: 41999   friendly: 44999   honored: 50999   revered: 62999   exalted: 83999
--			Acquaintance: 50399   Buddy: 58799   Friend: 67199
--			Good Friend: 75599   Best Friend: 83999 (just like exalted)
--		Xx			where x is the key to an excluded class (see classMapping).  if no Xx is present any class can accept the quest.  mutually exclusive with Cx codes.
--		Y:questId	where questId represents the quest that this quest is an alias for
--		Zxxxxx		where xxxxx is the Blizzard release version past where this quest does not exist
--
--		Both A: and T: codes have a modification to AP: and TP: that allow a pattern to indicate a specific NPC is used when certain prequisites are matched and
--		allows a list of these NPCs.  The first NPC matching prerequisites is used.  An example:
--			AP:12345:H123+S345;23456:P12321+P45678
--			NPC 12345 is valid when H123+S345    and NPC 23456 is valid when P12321+P45678
--		Semicolon separates prerequisite phrases.  If there is no colon after the NPC id, then the NPC is always valid.
--
--		When an NPC phases, we make an alias NPC and use the AP:/TP: structure to handle this.  If we were to attempt to actually apply the prerequisite information on
--		the NPC itslef to represent the phasing we would lose the capability to map locations properly that are not in the current phase.  Therefore, alias NPCs are used
--		for the proper NPC for each quest part.
--
--	Patterns for prerequisites and invalidations is a comma-separated list of quests, any of which match.  Within the comma-separated list there
--	can be plus-separated values that indicate each of them must match.  For example, the following code:
--		123,456,789+1122,3344
--	means any of the following quests would match the pattern:
--		123
--		456
--		both 789 and 1122 (together)
--		3344
--
--	Lists are just comma-separated values.
--
Grail_Quests_File_Version = 016

if Grail.questsVersionNumber < Grail_Quests_File_Version then
Grail.questsVersionNumber = Grail_Quests_File_Version

Grail.dailyMaximums = {
	[001] = 3,	-- Anglers has 3 a day maximum
	[002] = 4,	-- Mistfall Village has 4 a day maximum (we are ignoring any perceived direct incompatibilities for now)
	[003] = 1,	-- Golden Pagoda from Kun Autumnlight
	[004] = 1,	-- Golden Pagoda from Sun Tenderheart
	[005] = 1,	-- Golden Pagoda from Anji Autumnlight (set one)
	[006] = 1,	-- Golden Pagoda from Anji Autumnlight (set two)
	[007] = 7,	-- Klaxxi Lake of Stars			(this and the other Klaxxi grouping is solely to allow detection of the right "hidden" daily based on the active group, that is why maximum count allowed)
	[008] = 7,	-- Klaxxi Terrace of Gurthan
	[009] = 7,	-- Klaxxi Clutches of Shek'zeer
	[010] = 7,	-- Klaxxi Zan'vess
	[011] = 3,	-- Ruins of Guo-Lai
	[012] = 0,	-- ***** ***** NOT USED ***** *****
	[013] = 1,	-- Whitepetal Lake one
	[014] = 1,	-- Whitepetal Lake two
	[015] = 1,	-- Whitepetal Lake three
	[016] = 1,	-- Whitepetal Lake four
	[017] = 2,	-- Cloud Serpent one [ Sweet As Honey | Pooped | Catch! ]
	[018] = 3,	-- Cloud Serpent two [ Restoring the Balance | Disarming the Enemy | Slitherscale Suppression ]
	[019] = 3,	-- Cloud Serpent three [ Thinning the Pack | On The Prowl | The Shoe Is On The Other Foot | Dark Huntress | Sprite Fright ]
	[020] = 3,	-- Cloud Serpent four [ Monkey Mischief | The Big Kah-Oona | The Big Brew-haha | Saving the Serpents ]
	[021] = 3,	-- Cloud Serpent five [ Lingering Doubt | Weeping Widows | The Seed of Doubt | A Tangled Web ]
	[022] = 3,	-- Jade Serpent
	[023] = 4,	-- Whitepetal Lake invasion
	[024] = 4,	-- Shado-Pan Master Snowdrift
	[025] = 1,	-- lead-in Jade Serpent
	[026] = 1,	-- lead-in Red Crane
	[027] = 1,	-- lead-in White Tiger
	[028] = 1,	-- lead-in Black Ox
	[029] = 2,	-- White Tiger one
	[030] = 2,	-- White Tiger two
	[031] = 3,	-- Red Crane
	[032] = 4,	-- Black Ox one
	[033] = 4,	-- Black Ox two
	[034] = 4,	-- Shado-Pan Ling
	[035] = 4,	-- Shado-Pan Ban one
	[036] = 3,	-- Cloud Serpent six [ The Sky Race | the five The Trainer's Challenge: quests ]
	[037] = 4,	-- Shado-Pan Ban two
	[038] = 4,	-- Shado-Pan Ban three
	[039] = 1,	-- Shado-Pan Challenges Ban
	[040] = 1,	-- Shado-Pan Challenges Ling
	[041] = 1,	-- Shado-Pan Challenges Snowdrift
	[042] = 1,	-- White Tiger non-brawl
	[043] = 5,	-- Ruins of Ogudei (Alliance)
	[044] = 5,	-- Dominance Point (Alliance)
	[045] = 1,	-- August Celestials
	[046] = 5,	-- Bilgewater Operations (Alliance)
	[047] = 5,	-- Lion's Landing (Horde)
	[048] = 5,	-- Bilgewater Operations (Horde)
	[049] = 3,	-- Dominance Point (Horde)
	[050] = 6,	-- Ruins of Ogudei (Horde)
	[051] = 5,	-- Lion's Landing (Alliance)
	[052] = 5,	-- Bilgewater Operations (Horde) two
	[053] = 4,	-- Za'Tual Horde
	[054] = 4,	-- Court of Bones Horde
	[055] = 4,	-- Za'Tual Alliance
	[056] = 4,	-- Court of Bones Alliance
	[057] = 4,	-- Ihgaluk Crag Alliance
	[058] = 4,	-- Ihgaluk Crag Horde
	[059] = 1,	-- Phase 1 Elite Alliance
	[060] = 1,	-- Phase 1 Elite Horde
	[061] = 11,	-- Phase 1 Starter Alliance
	[062] = 11,	-- Phase 1 Starter Horde
	[063] = 3,	-- Diremoor Alliance
	[064] = 3,	-- Diremoor Horde
	[065] = 11,	-- Phase 2 Starter Alliance
	[066] = 11,	-- Phase 2 Starter Horde
	[067] = 7,	-- Isle Of Thunder PvP Alliance
	[068] = 7,	-- Isle Of Thunder PvP Horde
	[069] = 8,	-- Phase 3 Starter Alliance
	[070] = 8,	-- Phase 3 Starter Horde
	[071] = 1,	-- Phase 3 Elite Alliance
	[072] = 1,	-- Phase 3 Elite Horde
	[073] = 3,	-- Beast Pen Alliance
	[074] = 3,	-- Beast Pen Horde
	[075] = 3,	-- Conqueror's Terrace Alliance
	[076] = 3,	-- Conqueror's Terrace Horde
	[077] = 6,	-- Phase 4 Starter Alliance
	[078] = 6,	-- Phase 4 Starter Horde
	[079] = 1,	-- Phase 4 Elite Alliance
	[080] = 1,	-- Phase 4 Elite Horde
	[081] = 1,	-- Lightning Vein Mine Alliance
	[082] = 1,	-- Lightning Vein Mine Horde
	[083] = 5,	-- Phase 5 Starter Alliance
	[084] = 5,	-- Phase 5 Starter Horde
	[085] = 1,	-- Phase 5 Extra Alliance
	[086] = 1,	-- Phase 5 Extra Horde
	[087] = 5,	-- [053] + leadin
	[088] = 5,	-- [054] + leadin
	[089] = 5,	-- [055] + leadin
	[090] = 5,	-- [056] + leadin
	[091] = 5,	-- [057] + leadin
	[092] = 5,	-- [058] + leadin
	[093] = 1,	-- Alliance Garrison Campaign quests (only the first random 8)
	[094] = 2,	-- Alliance Daily quests in garrison
	[095] = 1,	-- Alliance daily fishing garrison
	[096] = 1,	-- Nat Pagle Garrison fishing daily
	[097] = 1,	-- Horde daily fishing garrison
	[098] = 1,	-- Horde Garrison Campaign quests (only the first random 8)
	[099] = 2,	-- Horde Daily quests in garrison
	[100] = 2,	-- Inn quests
	[101] = 2,  -- Narasi Snowdawn	(Icecrown)
	[102] = 2,  -- Girana the Blooded	(Icecrown)
	[103] = 1,	-- Parvink (Lion's Watch Tanaan Jungle)
	[104] = 1,	-- Mission Table Lion's Watch Tanaan Jungle
	[105] = 1,	-- Mission Table Lion's Watch Tanaan Jungle Followon
	[106] = 1,	-- Nimi Brightcastle (Vol'mar Tanaan Jungle)
	[107] = 1,	-- Mission Table Vol'mar Tanaan Jungle
	[108] = 1,	-- Mission Table Vol'mar Tanaan Jungle Followon
	[109] = 1,	-- Mission Table Lunarfall
	[110] = 1,	-- Mission Table Frostwall
	[111] = 1,	-- Garrison weekend
	[112] = 1,	-- Alliance Talbuk training
	[113] = 1,	-- Alliance Clefthoof training
	[114] = 1,	-- Alliance Boar training
	[115] = 1,	-- Alliance Riverbeast training
	[116] = 1,	-- Alliance Elekk training
	[117] = 1,	-- Alliance Wolf training
	[118] = 1,	-- Horde Talbuk training
	[119] = 1,	-- Horde Clefthoof training
	[120] = 1,	-- Horde Boar training
	[121] = 1,	-- Horde Riverbeast training
	[122] = 1,	-- Horde Elekk training
	[123] = 1,	-- Horde Wolf training
	[124] = 1,	-- Tanaan Garrison campaign Alliance
	[125] = 1,	-- Tanaan Garrison campaign Horde
	[126] = 1,	-- Garrison Gem Boutique Jewelcrafting
	[127] = 1,	-- Druid Class Hall artifact completion quests
	[128] = 1,	-- Death Knight Class Hall artifact completion quests
	[129] = 1,	-- Hunter Class Hall artifact completion quests
	[130] = 1,	-- Mage Class Hall artifact completion quests
	[131] = 1,	-- Monk Class Hall artifact completion quests
	[132] = 1,	-- Paladin Class Hall artifact completion quests
	[133] = 1,	-- Priest Class Hall artifact completion quests
	[134] = 1,	-- Rogue Class Hall artifact completion quests
	[135] = 1,	-- Shaman Class Hall artifact completion quests
	[136] = 1,	-- Warlock Class Hall artifact completion quests
	[137] = 1,	-- Warrior Class Hall artifact completion quests
	[138] = 1,	-- Demon Hunter Class Hall artifact completion quests
	[139] = 1,	-- Pillars of Creation found quests
	}

--[3]=''
--[4]='K0900 L090 A:558646 P:3,i774'	-- need to know what rejuvenation is.  need to have another quest do ODC:3
--[4]='K0900 L090 A:558646 T:558646 P:R774+i774'	-- this would require the experience of Rejuvenation.  Once done, the quest becomes available. [appears in 4 winds]
--[4]='K0900 L090 A:59584 T:59584 P:W0013'	-- this quest becomes available when 3 Anglers quests are turned in

local _, release, _, interface = GetBuildInfo()
release = tonumber(release)
interface = tonumber(interface)

local G = Grail.questCodes

if release >= 0 then
G[2]='FH K0230 L019 A:100016305 T:12696'
G[11]='FA K0100 L007 A:963 T:963 O:239'
G[16]='FA K0011 L001 A:255 T:255'
G[23]='FH K0240 L019 A:100016303 T:34559'
G[24]='FH K0240 L019 A:100016304 T:34359'
G[25]='FH K0250 L023 A:34559 T:34559'
G[35]='FA K0100 L007 A:240 T:261 P:40'
G[37]='FA K0100 L007 A:261 T:1000055 P:35'
G[40]='FA K0100 L007 A:241 T:240'
G[45]='FA K0100 L007 A:1000055 T:1000056 P:37'
G[46]='FA K0100 L007 A:1203733 T:261'
G[47]='FA K0070 L004 A:241 T:241'
G[52]='FA K0100 L007 A:261 T:261'
G[54]='FA K0050 L001 A:197 T:240 P:26390'	-- TODO: Determine what is I: because Saab did not get this offered
G[59]='FA K0100 L007 A:261 T:278 P:71'
G[60]='FA K0070 L003 A:253 T:253'
G[62]='FA K0070 L004 A:240 T:240'
G[71]='FA K0100 L007 A:1000056 T:261 P:45'
G[76]='FA K0100 L004 A:240 T:240 P:62'
G[83]='FA K0100 L007 A:278 T:278'
G[84]='FA K0060 L005 A:246 T:247 P:86'
G[85]='FA K0060 L005 A:246 T:247'
G[86]='FA K0060 L005 A:247 T:246 P:85'
G[87]='FA K0080 L005 A:247 T:246 P:84'
G[88]='FA K0090 L006 A:244 T:244'
G[106]='FA K0060 L005 A:251 T:252 O:26150'
G[107]='FA K0060 L005 A:248 T:253 P:111'
G[111]='FA K0060 L005 A:252 T:248 P:106'
G[112]='FA K0070 L005 A:253 T:253 P:107'
G[114]='FA K0070 L005 A:253 T:251 P:112'
G[123]='FA K0100 L007 A:100001307 T:42256'
G[147]='FA K0100 L007 A:42256 T:42256 P:123'
G[171]='HC FA K0000 L010 A:14305 T:51988 P:29117+29119'
G[172]='HC FH K0000 L010 A:51989 T:14444'
G[176]='FA K0110 L007 A:1000068,1156561 T:240'
G[182]='FA K0040 L001 A:786 T:786 P:24487'
G[184]='FA K0100 L009 A:1203734 T:42308'
G[185]='K0250 L024 A:717 T:717,-37 P:583'
G[186]='K0260 L024 A:-37,717 T:-37,717 P:185'
G[187]='K0270 L024 A:-37,717 T:-37,717 P:186'
G[188]='K0280 L024 A:-37,717 T:717 P:187'
G[190]='K0250 L024 A:718 T:718,-37 P:583'
G[191]='K0260 L024 A:-37,718 T:-37,718 P:190'
G[192]='K0270 L024 A:-37,718 T:-37,718 P:191'
G[193]='K0280 L024 A:-37,718 T:718 P:192'
G[194]='K0250 L024 A:715 T:-37,715 P:583'
G[195]='K0260 L024 A:-37,715 T:-37,715 P:194'
G[196]='K0270 L024 A:-37,715 T:-37,715 P:195'
G[197]='K0280 L024 A:-37,715 T:715 P:196'
G[208]='K0290 L024 A:715 T:715 P:188+193+197'
G[216]='FH K0230 L021 A:12757 T:12757'
G[218]='FA K0050 L001 A:786 T:786 P:24489'
G[236]='FA K0804 L075 A:31108 T:31108'
G[239]='FA K0100 L007 A:240 T:963 P:76'
G[256]='FA K0220 L009 A:1000256 T:1139 Z12213'
G[257]='FA K0140 L009 Z12213'
G[264]='FH K0150 L012 A:5543 T:1024776'
G[273]='FA K0150 L010 A:1105 T:2057 P:302 Z12213'
G[287]='FA K0090 L007 A:1252 T:1252 Z12213'
G[291]='FA K0100 L001 A:1252 T:1274 P:287 Z12213'
G[298]='FA K0150 L010 A:1344 T:1105 Z12213'
G[309]='FA K0150 L012 A:2057 T:1344 P:13639'
G[313]='FA K0070 L005 A:40950 T:40950 P:25724'
G[314]='FA K0080 L006 A:1265 T:1265 P:25932'
G[315]='FA K0060 L005 A:1374 T:1374'
G[332]='FA K0020 L001 A:1432 T:1431'
G[333]='FA K0020 L001 A:1427 T:1428'
G[334]='FA K0020 L001 A:1428 T:1429'
G[351]='K0480 L043 A:100008623 T:7784'
G[353]='FA K0150 L009 A:1416 T:1343 O:1097'
G[384]='FA K0060 L005 A:1267 T:1267'
G[412]='FA K0060 L005 A:1269 T:1269 P:313+25667'
G[432]='FA K0090 L006 A:1254 T:1254'
G[433]='FA K0100 L007 A:1977 T:1977'	-- reports of this being weekly, but Nimhfree cannot reproduce this
G[475]='FA K0060 L004 A:2078 T:2107'
G[476]='FA K0060 L004 A:2107 T:2078 P:475'
G[483]='FA K0080 L004 A:2078 T:2078 P:476'
G[485]='K0350 L030 A:100008704 T:7806'
G[486]='FA K0090 L004 A:2078 T:2078 P:483'
G[487]='FA K0090 L005 A:2151 T:2151 P:483'
G[488]='FA K0050 L004 A:2150 T:2150'
G[489]='FA K0060 L004 A:2083 T:2150 P:488'
G[495]='FH K0390 L034 A:2227 T:2278 Z19033'
G[543]='FA K0400 L030 A:2285 T:2285'
G[583]='K0250 L024 A:716 T:715 O:26340'
G[648]='K0480 L043 A:7784 T:7406 P:351'
G[743]='FH K0080 L006 A:2985 T:2985'
G[744]='FH K0100 L008 A:2987 T:2987'
G[749]='FH K0080 L005 A:2988 T:1002908 O:24459'
G[751]='FH K0080 L005 A:1002908 T:2988 P:749'
G[761]='FH K0060 L004 A:2947 T:2947'
G[768]='FH K0080 L004 A:3050 T:3050 P:PS001'
G[769]='FH K0100 L004 A:3050 T:3050 P:PL010'
G[770]='FH K0120 L006 A:100004854 T:3052'
G[773]='FH K0100 L003 RT RB A:2984,3233 T:2994 P:20441'
G[822]='FH K0240 L011 A:3292 T:3292 Z16016'
G[824]='FH K0270 L023 A:12737 T:74408 P:1918'
G[833]='FH K0100 L007 A:3233 T:3233'
G[834]='K0090 L007 A:3293 T:3293'
G[835]='K0090 L007 A:3293 T:3293'
G[836]='K0350 L030 A:7806 T:7406 P:485'
G[840]='FH K0100 L010 A:3336 T:3337 P:X28494'
G[844]='FH K0120 L009 A:3338,34258 T:3338,34258'
G[845]='FH K0130 L010 A:3338 T:3338'
G[848]='FH K0150 L010 A:3390 T:3390'
G[850]='FH K0140 L011 A:3389,34841 T:3389,34841'
G[851]='FH K0160 L013 A:34638 T:34638 P:14072'
G[852]='FH K0190 L015 A:3389 T:3389 P:850+851 O:14073'
G[855]='FH K0180 L015 A:3389 T:3389'
G[858]='FH K0180 L013 A:3439 T:3439'
G[861]='FH K0100 L008 A:3052 T:3052,3441'	-- TODO: Determine if this is invalidated by something else since some cannot get it
G[863]='FH K01832 L013 A:3439 T:3442 P:858'
G[865]='K0180 L014 A:3446 T:3446'
G[866]='K0160 L009 A:3446 T:3446 P:PH040'
G[867]='FH K0170 L015 A:3449 T:-11,3449 O:29094,28877'
G[869]='FH K0154 L013 A:-11,3464 T:-100011,3464 P:14066'
G[870]='FH K0130 L010 A:3448 T:3448'
G[871]='FH K0120 L009 A:3337,3429 T:3337,3429 O:840,26642,28494'
G[872]='FH K0120 L009 A:3337,3429 T:3337,3429 P:871'
G[875]='FH K0160 L012 A:3449 T:-11,3449 O:29094,28877'
G[876]='FH K0180 L012 A:-11,3449 T:3449 P:875'
G[877]='FH K0160 L010 A:3448,34626 T:3448 P:13988'
G[880]='FH K0140 L010 A:3448,34626 T:3448 P:13988'
G[881]='FH K0130 L010 A:3338 T:3338 P:845+903'
G[887]='FH K0160 L014 A:3391,3453 T:3391,3453'
G[891]='FH K0150 L013 A:3339 T:3339'
G[895]='K0160 L014 A:1003972 T:3391'
G[899]='FH K0120 L010 A:3432 T:3432'
G[903]='FH K0130 L010 A:3338 T:3338'
G[905]='FH K0140 L010 A:3338 T:3338 P:881'
G[918]='FA K0090 L004 A:2080 T:2080 P:997'
G[919]='FA K0090 L004 A:2080 T:2080,502080 P:997'
G[922]='FA K0090 L004 A:2080 T:3517 P:918'
G[923]='FA K0090 L004 A:3517 T:3517 P:922'
G[927]='FA K0120 L005 A:100005179 T:2080'
G[929]='FA K0060 L001 RE A:3515 T:3515 P:28731'
G[930]='FA K0090 L004 A:1006751 T:2080'
G[931]='FA K0090 L004 A:1006752 T:2080,502080'
G[932]='FA K0070 L004 A:3567 T:3567 P:489'
G[933]='FA K0090 L001 A:503515 T:1992 P:7383'
G[935]='FA K0110 L001 A:1992 T:503515 P:14005'
G[937]='FA K0100 L006 A:3519 T:3519 P:E7383'
G[938]='FA K01032 L007 A:3568 T:3519'
G[941]='FA K0120 L009 A:2080 T:1007923 P:927'
G[997]='FA K0090 L004 A:2083 T:2080 P:486'
G[1036]='K0600 L055 A:2545 T:2546 P:U01535999 I:9272'
G[1097]='FA K0150 L009 A:514 T:1416'
G[1168]='FH K0410 L037 A:4502 T:4502'
G[1201]='FH K0350 L030 A:4791 T:4791'
G[1202]='FH K0350 L030 A:4791 T:4791 P:1201'
G[1204]='FA K0360 L033 A:4794 T:4794'
G[1205]='FH K0410 L035 A:3441 T:3441'
G[1222]='FA K0370 L030 A:4880 T:4794'
G[1258]='FA K0360 L033 A:4794 T:4794 P:1204'
G[1270]='FH K0370 L030 A:4880 T:3446'
G[1271]='FA K0370 L030 A:1141 T:1141 P:1222'
G[1431]='FH K0300 L030 A:5639 T:5640 Z19033'
G[1432]='FH K0300 L030 A:5640 T:5641 P:1431 Z19033'
G[1433]='FH K0330 L030 A:5641 T:4498 Z19033'
G[1434]='FH K0330 L025 A:5641 T:5641 Z19033'
G[1436]='FH K0330 L030 A:5641 T:5640 Z19033'
G[1453]='FA K0300 L027 A:5637 T:5638'
G[1454]='FA K0300 L027 A:5638 T:1035251 P:14354 O:1453'
G[1455]='FA K0300 L027 A:1035251 T:5638 P:1454'
G[1456]='FA K0300 L027 A:5638 T:5638 P:1455'
G[1468]='HC FA K0000 L010 A:51988 T:14305'
G[1578]='FA K0120 L001 A:6031 T:6030 P:PB030'
G[1581]='FA K0080 L004 A:2083 T:2083 P:PA020'
G[1582]='FA K0180 L008 A:6034 T:6034 P:PL070'
G[1618]='FA K0160 L001 A:6031 T:415 P:PB070'
G[1918]='FH K0270 L023 A:100016408 T:12737'
G[2039]='FA K0150 L012 A:6569 T:6577'
G[2158]='FA K0050 L001 A:6774 T:295 I:37112 Z18702'
G[2159]='FA K0050 L003 A:6780 T:6736'
G[2278]='K0400 L035 A:1131474 T:1131474'
G[2280]='K0400 L035 A:1131474 TA:46234 TH:3978,46236'
G[2383]='FH K0030 L002 RO CW A:3143 T:3153'
G[2399]='SP FA K0100 L004 A:1007510 T:1007510 P:931'	-- seems to be timed so the quest givers only remain for a limited time...then can not get quest at all
G[2438]='FA K0064 L001 A:3567 T:3567'
G[2459]='FA K0060 L001 A:3567 T:3567 P:2438'
G[2499]='FA K0100 L004 A:2080,502080 T:2080 P:923'
G[2518]='FA K0100 L005 A:7313 T:7313 P:E7383'
G[2541]='FA K0080 L003 A:7317 T:7317'
G[2561]='FA K0100 L003 A:7317 T:7317 P:2541'
G[2751]='FH K0320 L032 A:7790 T:7790 P:PB140'
G[2752]='FH K0320 L032 A:7790 T:7790 P:2751+PB140'
G[2753]='FH K0360 L032 A:7790 T:7790 P:2752+PB140'
G[2754]='FH K0360 L032 A:7790 T:7790 P:2753+PB140'
G[2755]='FH K0360 L032 A:7790 T:7790 P:2754+PB140'
G[2945]='K0340 L024 A:100009326 T:1142487'
G[2947]='FA K0340 L024 A:1142487 T:6826 P:2945'
G[2948]='FA K0350 L024 A:6826 T:6826 P:2947'
G[2949]='FH K0340 L024 A:1142487 T:3412 P:2945'
G[2950]='FH K0350 L024 A:3412 T:3412 P:2949'
G[2951]='K0300 L025 A:1142487 T:1142487 I:4601,4602'
G[2952]='K0300 L025 A:1142487 T:1142487 P:2951,4601,4602 I:4605,4606'
G[2953]='K0301 L025 A:1142487 T:1142487 P:2952,4605,4606 I:4603,4604'
G[3087]='FH K0030 L002 RO CH A:3143 T:3154,39214'
G[3088]='FH K0030 L002 RO CR A:3143 T:3155'
G[3089]='FH K0030 L002 RO CS A:3143 T:3157'
G[3090]='FH K0030 L002 RO RL CL A:3143 T:3156'
G[3091]='FH K0030 L002 RT CW A:44927 T:3059'
G[3092]='FH K0030 L002 RT CH A:44927 T:3061'
G[3093]='FH K0030 L002 RT CS A:44927 T:3062'
G[3094]='FH K0030 L002 RT CD A:44927 T:3060'
G[3095]='FH K0030 L002 RU CW A:1569 T:2119 P:26801'
G[3096]='FH K0030 L002 RU CR A:1569 T:2122 P:26801'
G[3097]='FH K0030 L002 RU CT A:1569 T:2123 P:26801'
G[3098]='FH K0030 L002 RU CM A:1569 T:2124 P:26801'
G[3099]='FH K0030 L002 RU CL A:1569 T:2126 P:26801'
G[3100]='FA K0030 L002 CW A:197 T:911 P:28774'
G[3101]='FA K0030 L002 CP A:197 T:925 P:28770'
G[3102]='FA K0030 L002 CR A:197 T:915 P:28772'
G[3103]='FA K0030 L002 CT A:197 T:375 P:28771'
G[3104]='FA K0030 L002 CM A:197 T:198 P:28769'
G[3105]='FA K0030 L002 CL A:197 T:459 P:28773'
G[3106]='FA K0030 L002 RF CW A:37087 T:912'
G[3107]='FA K0030 L002 RF CP A:37087 T:926'
G[3108]='FA K0030 L002 RF CH A:658,37087 T:895'
G[3109]='FA K0030 L002 RF CR A:37087 T:916 P:24473'
G[3110]='FA K0030 L002 RF CT A:37087 T:837'
G[3115]='FA K0030 L002 RF RN CL A:658,37087 T:43455'
G[3116]='FA K0030 L002 RE CW A:2077,502079 T:3593 P:28714+28715'
G[3117]='FA K0030 L002 RE CH A:2077,502079 T:3596 P:28714+28715'
G[3118]='FA K0030 L002 RE CR A:2077,502079 T:3594 P:28714+28715'
G[3119]='FA K0030 L002 RE CT A:2077,502079 T:3595 P:28714+28715'
G[3120]='FA K0030 L002 RE CD A:2077,502079 T:3597 P:28714+28715'
G[3361]='FA K0030 L001 A:8416 T:8416 P:24487'
G[3526]='FH K0000 L010 A:4586 T:8126 P:PN200'
G[3541]='FH K0520 L045 A:8587 T:8659 Z17644'
G[3561]='FH K0520 L045 A:8587 T:8379 Z17644'
G[3563]='FH K0520 L045 A:8659 T:8587 Z17644'
G[3565]='FH K0520 L045 A:8379 T:8587 Z17644'
G[3721]='K0500 L040 A:7406 T:7406 P:648+836+25476'
G[3861]='K0011 L001 A:620 T:620'
G[4021]='FH K020512 L011 A:3389 T:3389 P:852+855'	-- PM3 (recommended party members)
G[4083]='SP K0550 L040 A:1164869 T:1164869 P:PM230'
G[4295]='SP K0011 L001 A:9503 T:9503'
G[4512]='FA K0520 L048 A:9616 T:9616'
G[4513]='FA K0540 L048 A:9616 T:9616 P:4512'
G[4601]='K0300 L025 A:1175084 T:1175084 I:2951,4602'
G[4602]='K0300 L025 A:1175085 T:1175085 I:2951,4601'
G[4603]='K0301 L025 A:1175084 T:1175084 P:2952,4605,4606 I:2953,4604'
G[4604]='K0301 L025 A:1175085 T:1175085 P:2952,4605,4606 I:2953,4603'
G[4605]='K0300 L025 A:1175084 T:1175084 P:2951,4601,4602 I:2952,4606'
G[4606]='K0300 L025 A:1175085 T:1175085 P:2951,4601,4602 I:2952,4605'
G[4621]='K0600 L055 A:2546 T:2546 P:U01535999 O:1036'
G[5041]='FH K0120 L009 A:3429,34258 T:3429,34258 P:871'
G[5421]='FH K0341 L030 A:11317 T:11317'
G[5501]='K0320 L029 A:11438 T:11438'
G[5502]='HC FH K0000 L010 A:14444 T:51989 P:29190+29191'
G[5545]='FA K0100 L007 A:10616 T:10616'
G[5561]='K0340 L030 A:11596 T:11596'
G[5581]='FH K0350 L031 A:5395 T:5395,11624'
G[5713]='FA K0150 L010 A:11711 T:11806'
G[5821]='K0330 L028 A:11625 T:11596 Z16135'	-- once caravan moves quest cannot be obtained.  how to detect this?
G[5892]='FA K0000 L051 A:12096 T:12096'
G[5893]='FH K0000 L051 A:12097 T:12097'
G[5943]='K0350 L029 A:11626 T:11596 Z16135'	-- once caravan moves quest cannot be obtained.  how to detect this?
G[6031]='K0550 L050 A:11557 T:11557 P:T24044999'	-- TODO: Determine whether this is no longer available when reached Honored with Timbermaw Hold.  No, at Honored it is still available.
G[6032]='K0550 L050 A:11557 T:11557 P:T24044999+PT280'
G[6132]='K03432 L030 A:12277 T:6019'
G[6134]='K0390 L034 A:6019 T:6019'
G[6142]='FH K0350 L031 A:12031 T:12031 Z19342'
G[6143]='FH K0360 L032 A:12340 T:12340 Z19342'
G[6321]='FH K0070 L005 RU RL A:1745 T:43124'
G[6322]='FH K0070 L005 RU RL A:4556 T:4551 P:6323'
G[6323]='FH K0070 L005 RU RL A:43124 T:4556 P:6321'
G[6324]='FH K0070 L005 RU RL A:4551 T:1745 P:6322'
G[6341]='FA K0070 L005 RE A:40553 T:7316 P:6344'
G[6342]='FA K0070 L005 RE A:7316 T:40552 P:6341'
G[6343]='FA K0070 L005 RE A:40552 T:4265 P:6342'
G[6344]='FA K0070 L005 RE A:4265 T:40553'
G[6361]='FH K0070 L005 RT A:3079 T:40809'
G[6362]='FH K0070 L005 RT A:40809 T:8359 P:6361'
G[6363]='FH K0070 L005 RT A:8359 T:2995 P:6362'
G[6364]='FH K0070 L005 RT A:2995 T:3079 P:6363'
G[6365]='FH K0070 L005 RO RL A:3489,3881 T:3615,41140'
G[6384]='FH K0070 L005 RO RL A:3615,41140 T:6929 P:6365'
G[6385]='FH K0070 L005 RO RL A:6929 T:3310 P:6384'
G[6386]='FH K0070 L005 RO RL A:3310 T:3881 P:6385'
G[6387]='FA K0070 L005 RF RN A:1699 T:43701'
G[6388]='FA K0070 L005 RF RN A:4256 T:1573 P:6391'
G[6391]='FA K0070 L005 RF RN A:1699 T:43701 P:6387'
G[6392]='FA K0070 L005 RF RN A:1573 T:1699 P:6388'
G[6441]='FH K0220 L019 A:12724 T:12724'	-- removed  P:26449 because 26449 seems to be removed...need to check what P exists now
G[6442]='FH K0190 L014 A:12719 T:12719'	-- Can this still be gotten in 4.3.3?
G[6462]='FH K0230 L021 A:12721 T:12721'
G[6482]='FH K0240 L019 A:12818 T:12837'
G[6503]='FH K0210 L019 A:12867 T:12867'
G[6544]='FH K02432 L020 A:12858 T:12877'
G[6563]='FH K0220 L017 A:12736 T:12736 Z18545'	-- How does this relate to 26890 because it seems this should be removed in 4.3.3?
G[6607]='SP K0450 L034 A:12919 T:12919 P:PF225 O:6608,6609'
G[6608]='FH K0450 L035 A:3332 T:12919 P:PF225'
G[6609]='FA K0450 L035 A:5161 T:12919 P:PF225 Z15640'	-- A:5161, but no longer in game (except if you already have it)
G[6610]='K0450 L035 A:40589 T:40589 P:PC225 O:6611,6612 I:13825'
G[6611]='FH K0450 L035 A:3399 T:40589 P:PC225'
G[6612]='FA K0450 L035 A:5159 T:40589 P:PC225'
G[6621]='FH K0250 L023 A:12696,12757 T:12696,12757 P:13967'
G[6622]='FH K0000 L035 A:12920 T:12920 P:PZ225 O:6623'
G[6623]='FH K0450 L035 XK A:45540 T:12920 P:PZ225'	-- assumption Z18291 is wrong based on comment in quest 6625
G[6624]='FA K0000 L035 A:12939 T:12939 P:PZ225 O:6625'
G[6625]='FA K0450 L035 XK A:5150 T:12939 P:PZ225'	-- Z18291 was wrong based on seeing quest on 2014-11-04
G[6641]='FH K023512 L019 A:12717 T:12863'	-- PM2 (recommended party members)
G[6642]='K0601 L060 A:12944 T:12944'
G[6643]='K0601 L060 A:12944 T:12944'
G[6644]='K0601 L060 A:12944 T:12944'
G[6645]='K0601 L060 A:12944 T:12944'
G[6646]='K0601 L060 A:12944 T:12944'
G[6661]='FA K0120 L010 A:12997 T:12997'
G[6662]='FA K0120 L010 A:12997 T:13018 P:6661'
G[6741]='FH K0001 L051 A:13176 T:13176'
G[6781]='FA K0001 L051 A:13257 T:13257'
G[6801]='FH K0001 L051 A:13236 T:13236'
G[6825]='FH K0001 L051 A:13179 T:13179'
G[6826]='FH K0001 L051 A:13180 T:13180'
G[6827]='FH K0001 L051 A:13181 T:13181'
G[6881]='FA K0001 L051 A:13442 T:13442'
G[6922]='FH K0300 L021 A:100016782 T:12736 Z18545'
G[6941]='FA K0001 L051 A:13439 T:13439'
G[6942]='FA K0001 L051 A:13438 T:13438'
G[6943]='FA K0001 L051 A:13437 T:13437'
G[6961]='HV FH K0000 L010 A:13418 T:13445 I:7021'
G[6962]='HV FH K0000 L010 A:13445 T:13445 O:6961,7021'
G[6963]='HV FH K0000 L030 A:13418 T:13636 Z19243'
G[6964]='HV FH K0000 L010 A:9550 T:13417'
G[6982]='FA K0000 L051 A:12096 T:12096'
G[6983]='HV FH K0002 L080 A:13636 T:13418 P:6963'
G[6984]='HV FH K0000 L030 A:13418 T:13445 P:6983'
G[6985]='FH K0001 L051 A:12097 T:12097'
G[7001]='FH K0001 L051 A:13616 T:13616'
G[7021]='HV FH K0000 L010 A:13431 T:13445 I:6961'
G[7022]='HV FA K0000 L010 A:13433 T:13444 I:7023'
G[7023]='HV FA K0000 L010 A:13435,23010,96304 T:13444 I:7022'
G[7024]='HV FH K0000 L010 A:13429 T:13445'
G[7025]='HV FA K0000 L010 A:13444 T:13444'	-- note that the Alliance version does not have O codes.
G[7027]='FA K0001 L051 A:13617 T:13617'
G[7043]='HV FA K0002 L080 A:13433,13636 T:13433'	-- P:7042 appears incorrect
G[7045]='HV FA K0000 L030 A:13433 T:13444 P:7043'
G[7061]='HV FH K0000 L010 A:13417 T:36648 P:6964'
G[7062]='HV FA K0000 L010 A:1365 T:2916'
G[7063]='HV FA K0000 L010 A:2916 T:42928 P:7062'
G[7081]='FA K0000 L051 A:13777 T:13777'
G[7082]='FH K0000 L051 A:13776 T:13776'
G[7101]='FH K0000 L051 A:13776 T:13776'
G[7102]='FA K0000 L051 A:13777 T:13777'
G[7121]='FA K0000 L051 A:13797 T:12096'
G[7122]='FA K0000 L051 A:13777 T:13777'
G[7123]='FH K0000 L051 A:13798 T:12097'
G[7124]='FH K0000 L051 A:12097,13776 T:13776'
G[7141]='FA K0000 L051 A:13816 T:13816'
G[7142]='FH K0000 L051 A:13817 T:13817'
G[7161]='FH K0000 L051 A:13840 T:13840'
G[7162]='FA K0000 L051 A:13841 T:13841'
G[7163]='FH K0000 L051 A:13840 T:13840 P:7161+T2D944999'
G[7164]='FH K0000 L051 A:13840 T:13840 P:7163+T2D950999'
G[7165]='FH K0000 L051 A:13840 T:13840 P:7164+T2D962999'
G[7166]='SP FH K0000 L051 A:13840 T:13840 P:7165+T2D983999'
G[7167]='SP FH K0000 L051 A:13840 T:13840 P:7166+T2D984998'
G[7168]='FA K0000 L051 A:13841 T:13841 P:7162+T2DA44999'
G[7169]='FA K0000 L051 A:13841 T:13841 P:7168+T2DA50999'
G[7170]='FA K0000 L051 A:13841 T:13841 P:7169+T2DA62999'
G[7171]='SP FA K0000 L051 A:13841 T:13841 P:7170+T2DA83999'
G[7172]='SP FA K0000 L051 A:13841 T:13841 P:7171+T2DA84998'
G[7223]='FA K0000 L051 A:13257 T:13257'
G[7224]='FH K0000 L051 A:13176 T:13176'
G[7383]='FA K0090 L001 A:3515 T:503515 P:918+919'
G[7385]='FH K0001 L051 A:13236 T:13236'
G[7386]='FA K0001 L051 A:13442 T:13442'
G[7493]='FH K0600 L060 A:14392 T:14392 P:24429+PL001'
G[7497]='FA K0600 L060 A:14394 T:14394 P:24428+PL001'
G[7498]='K0600 L054 CR A:100018356 T:14383 Z13329'
G[7499]='K0600 L054 CW A:100018357 T:14383 Z13329'
G[7500]='K0600 L054 CM A:100018358 T:14383 Z13329'
G[7501]='K0600 L054 CP A:100018359 T:14382 Z13329'
G[7502]='K0600 L054 CL A:100018360 T:14382 Z13329'
G[7503]='K0600 L054 CH A:100018361 T:14382 Z13329'
G[7504]='K0600 L054 CT A:100018362 T:14381 Z13329'
G[7505]='K0600 L054 CS A:100018363 Z13329'
G[7506]='K0600 L054 CD A:100018364 T:14381 Z13329'
G[7604]='K0600 L060 A:100018628 T:12944 P:K100017203'
G[7649]='K0350 L000 A:100018769 T:14368 Z13329'
G[7650]='K0350 L000 A:100018770 T:14368 Z13329'
G[7651]='K0350 L000 A:100018771 T:14368 Z13329'
G[7737]='K0501 L046 A:14624 T:14624 P:28064+U03B83999'
G[7761]='K0600 L055 A:100018987 T:1179880 Z20338'
G[7781]='FA K0600 L060 A:100019003 T:29611'
G[7782]='FA K0600 L060 A:29611 T:14721 P:7781'
G[7783]='FH K0600 L060 A:100019002 T:39605,45530'
G[7784]='FH K0600 L060 A:4949 T:14392 P:7783'
G[7785]='K0600 L060 A:100019016 T:14347 P:1'
G[7786]='K0600 L060 A:14347 T:14347 P:7785'
G[7787]='K0600 L060 A:100019018 T:14347 P:7786'
G[7810]='K055256 L001 A:100018706 T:14508'
G[7838]='K0551 L000 A:14508 T:14508 P:7810'
G[7848]='K0600 L055 A:14387 T:14387'
G[7863]='FA K0340 L025 A:14753 T:14753 P:T37A44999'
G[7865]='FA K0700 L045 A:14753 T:14753 P:T37A44999'
G[7866]='FH K0340 L025 A:14754 T:14754 P:T37944999'
G[7868]='SP FH K0700 L045 A:14754 T:14754 P:T37944999'
G[7905]='HF FA K0000 L006 A:54334 T:14828 I:29601'
G[7907]='K0000 L001 A:100019228 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7926]='HF FH K0000 L006 A:55382 T:14828 I:29601'
G[7927]='K0000 L001 A:100019277 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7928]='K0000 L001 A:100019257 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7929]='K0000 L001 A:100019267 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7946]='SP HF K0001 L001 A:14871 T:14871'
G[8026]='K0900 A:65932 E18019'
G[8041]='K0600 L058'	-- A:14902 T:14902
G[8042]='K0600 L058'	-- A:14902 T:14902
G[8043]='K0600 L058'	-- A:14902 T:14902
G[8044]='K0600 L058'	-- A:14902 T:14902
G[8045]='K0600 L058'	-- A:14902 T:14902
G[8046]='K0600 L058'	-- A:14902 T:14902
G[8047]='K0600 L058'	-- A:14902 T:14902
G[8048]='K0600 L058'	-- A:14902 T:14902
G[8049]='K0600 L058'	-- A:14903 T:14903
G[8050]='K0600 L058'	-- A:14903 T:14903
G[8051]='K0600 L058'	-- A:14903 T:14903
G[8052]='K0600 L058'	-- A:14903 T:14903
G[8053]='K0600 L058'	-- A:14902 T:14902
G[8054]='K0600 L058'	-- A:14902 T:14902
G[8055]='K0600 L058'	-- A:14902 T:14902
G[8056]='K0600 L058'	-- A:14904 T:14904
G[8057]='K0600 L058'	-- A:14904 T:14904
G[8058]='FH K0600 L058'	-- A:14902 T:14902
G[8059]='K0600 L058'	-- A:14903 T:14903
G[8060]='K0600 L058'	-- A:14903 T:14903
G[8061]='K0600 L058'	-- A:14903 T:14903
G[8062]='K0600 L058'	-- A:14905 T:14905
G[8064]='K0600 L058'	-- A:14904 T:14904
G[8065]='K0600 L058'	-- A:14904 T:14904
G[8066]='K0600 L058'	-- A:14905 T:14905
G[8067]='K0600 L058'	-- A:14905 T:14905
G[8068]='K0600 L058'	-- A:14903 T:14903
G[8069]='K0600 L058'	-- A:14903
G[8070]='K0600 L058'	-- A:14903 T:14903
G[8071]='K0600 L058'	-- A:14903 T:14903
G[8073]='K0600 L058'	-- A:14905 T:14905
G[8074]='K0600 L058'	-- A:14904 T:14904
G[8075]='K0600 L058'	-- A:14904 T:14904
G[8076]='K0600 L058'	-- A:14903 T:14903
G[8077]='K0600 L058'	-- A:14903 T:14903
G[8078]='K0600 L058'	-- A:14902 T:14902
G[8079]='K0600 L058'	-- A:14902 T:14902
G[8101]='K0600 L058'	-- A:14903 T:14903
G[8102]='K0600 L058'	-- A:14903 T:14903
G[8103]='K0600 L058'	-- A:14903 T:14903
G[8104]='FH K0600 L058'	-- A:14903 T:14903
G[8105]='FA K0550 L050 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8106]='K0600 L058'	-- A:14903 T:14903
G[8107]='K0600 L058'	-- A:14903 T:14903
G[8108]='K0600 L058'	-- A:14903 T:14903
G[8109]='FH K0600 L058'	-- A:14903 T:14903
G[8110]='K0600 L058'	-- A:14904 T:14904
G[8111]='K0600 L058'	-- A:14904 T:14904
G[8112]='K0600 L058'	-- A:14904 T:14904
G[8113]='K0600 L058'	-- A:14904 T:14904
G[8114]='FA K0600 L060 A:14983 T:14983 Z16135'
G[8115]='FA K0600 L060 A:14983 T:14983 Z16135'
G[8116]='K0600 L058'	-- A:14904 T:14904
G[8117]='K0600 L058'	-- A:14904 T:14904
G[8118]='K0600 L058'	-- A:14904 T:14904
G[8119]='K0600 L058'	-- A:14904 T:14904
G[8120]='FH K0550 L050 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left'
G[8121]='FH K0600 L060 A:15021 T:15021'
G[8122]='FH K0600 L060 A:15021 T:15021'
G[8141]='K0600 L058'	-- A:14905 T:14905
G[8142]='K0600 L058'	-- A:14905 T:14905
G[8143]='K0600 L058'	-- A:14905 T:14905
G[8144]='FH K0600 L058'	-- A:14905 T:14905
G[8145]='K0600 L058'	-- A:14905 T:14905
G[8146]='K0600 L058'	-- A:14905 T:14905
G[8147]='K0600 L058'	-- A:14905 T:14905
G[8148]='K0600 L058'	-- A:14905 T:14905
G[8149]='HH FA K0000 L030 A:15011 T:15011'
G[8150]='HH FH K0000 L030 A:15012 T:15012'
G[8166]='FA K0450 L040 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8167]='FA K0350 L030 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8168]='FA K0250 L020 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8169]='FH K0450 L040 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left
G[8170]='FH K0350 L030 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left
G[8171]='FH K0250 L020 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left
G[8183]='K0600 L058'	-- A:100019802 T:14875
G[8184]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8185]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8186]='FH K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8187]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8188]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8189]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8190]='FH K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8191]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8192]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8193]='HX K0001 L001 A:15077 T:15077 P:PF001 I:8194'
G[8194]='HX K0001 L001 A:15078 T:15078 P:PF001 I:8193'
G[8195]='K0601 L058'	-- A:15070 T:15070
G[8196]='K0601 L058'	-- A:14921 T:14921
G[8201]='K0600 L058'	-- A:14910 T:14910
G[8221]='HX K0001 L001 A:15079 T:15079 P:PF001'
G[8224]='HX K0001 L001 A:15079 T:15079 P:PF001'
G[8225]='HX K0001 L001 A:15079 T:15079 P:PF001'
G[8227]='K0600 L058 A:1180366 T:12919'
G[8228]='SP HX FH K0001 L035 A:15116 T:15116 P:PF175'
G[8229]='SP HX FA K0001 L035 A:15119 T:15119 P:PF175'
G[8237]='T:95329'
G[8238]='K0601 L058'	-- A:15070 T:15070
G[8239]='K0601 L058'	-- A:15070 T:15070
G[8240]='K0600 L058'	-- A:15070 T:15070
G[8243]='K0601 L058'	-- A:14921 T:14921
G[8246]='K0601 L058'	-- A:14921 T:14921
G[8249]='SP K0601 L050 A:7323 T:7323'	-- interestingly, Blizzard reports this as classification Rogue which would make me put CR here, which is wrong
G[8262]='FA K0700 L045 A:15127 T:15127 P:T1FD44999'
G[8265]='FH K0700 L045 A:15126 T:15126 P:T1FE44999'
G[8271]='FA K0000 L051 A:13816 T:13816 P:7141'
G[8272]='FH K0000 L051 A:13817 T:13817 P:7142'
G[8277]='K0550 L054 A:15189 T:15189'
G[8278]='K0560 L054 A:15189 T:15189 P:8277'
G[8279]='K0560 L054 A:15194 T:15194 P:8285'
G[8280]='K0550 L054 A:15191 T:15191 O:28527,28528,28856,28859'
G[8281]='K0560 L054 A:15191 T:15191 P:8280'
G[8282]='K0560 L054 A:15190 T:15190 P:8278'
G[8283]='K0560 L054 A:1180448 T:15182'
G[8284]='K0560 L054 A:15183 T:15183 P:8321'
G[8285]='K0560 L054 A:15183 T:15194 P:8284'
G[8287]='K0560 L054 A:15194 T:15181 P:8279'
G[8304]='K0560 L054 A:15181 T:-261,15181 P:8321'
G[8306]='K0560 L054 A:15181 T:15181 P:8304'
G[8307]='K0560 L054 A:15174 T:1180503 P:PC285'
G[8308]='K0560 L054 A:100020461 T:15170 P:8304'
G[8309]='K0560 L054 A:15170 T:15170 P:8304'
G[8310]='K0560 L054 A:15171 T:15171 P:8304'
G[8311]='HW FA K0000 L010 A:15310 T:15310 I:8312'
G[8312]='HW FH K0000 L010 A:15309 T:15309 I:8311'
G[8313]='K0560 L054 A:1180503 T:15174 P:8307'
G[8314]='K0560 L054 A:15170 T:15183 P:8309+8310'
G[8316]='K0560 L054 CW A:15183 T:15183 Z12213'
G[8317]='K0560 L054 A:15174 T:15174 P:8313'
G[8318]='K0560 L054 A:15306 T:15306'
G[8319]='K0561 L054 A:15306 T:15306 P:8318'
G[8320]='K0560 L054 A:15270 T:15270'
G[8321]='K0560 L054 A:15270 T:15270 P:8320'
G[8323]='K0560 L054 A:15194 T:15194 P:8279'
G[8324]='K0561 L054 A:15194 T:15194 P:8323'
G[8325]='FH K0010 L001 RB A:15278 T:15278'
G[8326]='FH K0030 L001 RB A:15278 T:15278 P:8325'
G[8327]='FH K0030 L001 RB A:15278 T:15281 P:8326'
G[8328]='FH K0030 L002 RB CM A:15278 T:15279 P:8325'
G[8329]='FH K0030 L002 RB CW A:15278 T:43010 P:8325'
G[8330]='FH K0040 L002 RB A:15295 T:15295 Z19033'
G[8334]='FH K0040 L001 RB A:15281 T:15281 P:8326'
G[8335]='FH K0050 L001 RB A:15281 T:15281 P:8334'
G[8336]='FH K0040 L002 RB A:15296 T:15296 Z19033'
G[8338]='FH K0040 L001 RB A:100020483 T:15297'
G[8345]='FH K0040 L002 RB A:15295 T:15295 Z19033'
G[8346]='FH K0030 L002 RB A:15297 T:15297 Z19033'
G[8347]='FH K0050 L004 RB A:15281 T:15301 P:8335'
G[8350]='FH K0050 L004 A:15301 T:15433 P:9705'
G[8353]='HW FA K0000 L010 A:5111 T:5111 P:B8311'
G[8354]='HW FH K0000 L010 A:6741 T:6741 P:B8312'
G[8355]='HW FA K0000 L010 A:6826 T:6826 P:B8311'
G[8356]='HW FA K0000 L010 A:6740 T:6740 P:B8311'	-- note that this will still be available during the duration, even after completing
G[8357]='HW FA K0000 L010 A:6735 T:6735 P:B8311'
G[8358]='HW FH K0000 L010 A:11814 T:11814 P:B8312'
G[8359]='HW FH K0000 L010 A:6929 T:6929 P:B8312'
G[8360]='HW FH K0000 L010 A:6746 T:6746 P:B8312'
G[8376]='K0560 L054 CP A:15183 T:15183 Z12213'
G[8377]='K0560 L054 CH A:15183 T:15183 Z12213'
G[8378]='K0560 L054 CR A:15183 T:15183 Z12213'
G[8379]='K0560 L054 CT A:15183 T:15183 Z12213'
G[8380]='K0560 L054 CS A:15183 T:15183 Z12213'
G[8381]='K0560 L054 CM CL A:15183 T:15183 Z12213'
G[8382]='K0560 L054 CD A:15183 T:15183 Z12213'
G[8446]='K0600 L060'	-- A:100020644 T:11832	-- item no longer drops since the four dragons are removed from the game
G[8447]='K0600 L060'	-- A:11832 T:11832 P:8446	--	(see above comment)
G[8463]='FH K0050 L004 A:15403 T:15403'
G[8468]='FH K0060 L004 A:1180918 T:16924'
G[8470]='K0550 L045 A:100020741 T:11558'
G[8472]='FH K0050 L004 A:15418 T:15418'
G[8473]='FH K0090 L006 A:15398 T:15398 O:9258'
G[8474]='FH K0100 L007 A:100023228 T:15398'
G[8475]='FH K0060 L004 A:15416 T:15416'
G[8476]='FH K0100 L007 A:15399 T:15399 O:9359'
G[8477]='FH K0100 L007 A:15400 T:15400'
G[8479]='FH K0110 L008 A:15406 T:15406'
G[8480]='FH K0070 L005 A:15404 T:15404'
G[8481]='K0550 L045 A:11555 T:11555 P:T24083999'
G[8482]='FH K0060 L004 A:100020765 T:15403'
G[8483]='FH K0070 L004 A:15403 T:15403 P:8482'
G[8486]='FH K0060 L004 A:15401 T:15401 P:9119'
G[8487]='FH K0090 L007 A:15402 T:15402 O:9254'
G[8488]='FH K0090 L007 A:15402 T:15402 P:8487'	-- 7 seconds later
G[8490]='FH K0100 L008 A:16362 T:16362 O:9253'
G[8491]='FH K0070 L004 A:15417 T:15417'
G[8544]='K0601 L060 CW A:15502 T:15502'
G[8556]='K0600 L060 CW A:15498 T:15498'
G[8557]='K0600 L060 CW A:15500 T:15500'
G[8558]='K0600 L060 CW A:15499 T:15499'
G[8559]='K0601 L060 CW A:15503 T:15503'
G[8560]='K0601 L060 CW A:15503 T:15503'
G[8561]='K0601 L060 CW A:15502 T:15502'
G[8562]='K0601 L060 CW A:15504 T:15504'
G[8563]='FH K0030 L002 RB CL A:15278 T:15283 P:8325'
G[8564]='FH K0030 L002 RB CT A:15278 T:15284 P:8325'
G[8579]='K0600 L060 A:15503 T:15503'
G[8592]='K0601 L060 CT A:15502 T:15502'
G[8593]='K0601 L060 CT A:15503 T:15503'
G[8594]='K0601 L060 CT A:15502 T:15502'
G[8595]='SP K0601 L060 A:15503 T:15503 P:8579'
G[8596]='K0601 L060 CT A:15503 T:15503'
G[8602]='K0601 L060 CS A:15502 T:15502'
G[8603]='K0601 L060 CT A:15504 T:15504'
G[8619]='SP HL K00016 L001 A:15549 T:15549'
G[8621]='K0601 L060 CS A:15503 T:15503'
G[8622]='K0601 L060 CS A:15504 T:15504'
G[8623]='K0601 L060 CS A:15502 T:15502'
G[8624]='K0601 L060 CS A:15503 T:15503'
G[8625]='K0601 L060 CM A:15502 T:15502'
G[8626]='K0601 L060 CH A:15503 T:15503'
G[8627]='K0601 L060 CP A:15504 T:15504'
G[8628]='K0601 L060 CP A:15502 T:15502'
G[8629]='K0601 L060 CP A:15503 T:15503'
G[8630]='K0601 L060 CP A:15502 T:15502'
G[8631]='K0601 L060 CM A:15503 T:15503'
G[8632]='K0601 L060 CM A:15502 T:15502'
G[8633]='K0601 L060 CM A:15504 T:15504'
G[8634]='K0601 L060 CM A:15503 T:15503'
G[8635]='SP HL K00016 L001 A:15556 T:15556'
G[8636]='SP HL K00016 L001 A:15557 T:15557'
G[8637]='K0601 L060 CR A:15503 T:15503'
G[8638]='K0601 L060 CR A:15504 T:15504'
G[8639]='K0601 L060 CR A:15502 T:15502'
G[8640]='K0601 L060 CR A:15503 T:15503'
G[8641]='K0601 L060 CR A:15502 T:15502'
G[8642]='SP HL K00016 L001 A:15558 T:15558'
G[8643]='SP HL K00016 L001 A:15559 T:15559'
G[8644]='SP HL K00016 L001 A:15560 T:15560'
G[8645]='SP HL K00016 L001 A:15561 T:15561'
G[8646]='SP HL K00016 L001 A:15562 T:15562'
G[8647]='SP HL K00016 L001 A:15563 T:15563'
G[8648]='SP HL K00016 L001 A:15564 T:15564'
G[8649]='SP HL K00016 L001 A:15565 T:15565'
G[8650]='SP HL K00016 L001 A:15566 T:15566'
G[8651]='SP HL K00016 L001 A:15567 T:15567'
G[8652]='SP HL K00016 L001 A:15568 T:15568'
G[8653]='SP HL K00016 L001 A:15569 T:15569'
G[8654]='SP HL K00016 L001 A:15570 T:15570'
G[8655]='K0601 L060 CP A:15503 T:15503'
G[8656]='K0601 L060 CH A:15504 T:15504'
G[8657]='K0601 L060 CH A:15502 T:15502'
G[8658]='K0601 L060 CH A:15503 T:15503'
G[8659]='K0601 L060 CH A:15502 T:15502'
G[8660]='K0601 L060 CL A:15503 T:15503'
G[8661]='K0601 L060 CL A:15504 T:15504'
G[8662]='K0601 L060 CL A:15502 T:15502'
G[8663]='K0601 L060 CL A:15503 T:15503'
G[8664]='K0601 L060 CL A:15502 T:15502'
G[8665]='K0601 L060 CD A:15503 T:15503'
G[8666]='K0601 L060 RE RT RL CD A:15504 T:15504'
G[8667]='K0601 L060 CD A:15502 T:15502'
G[8668]='K0601 L060 CD A:15503 T:15503'
G[8669]='K0600 L060 CD A:15502 T:15502'
G[8670]='SP HL K00016 L001 A:15572 T:15572'
G[8671]='SP HL K00016 L001 A:15573 T:15573'
G[8672]='SP HL K00016 L001 A:15574 T:15574'
G[8673]='SP HL K00016 L001 A:15575 T:15575'
G[8674]='SP HL K00016 L001 A:15576 T:15576'
G[8675]='SP HL K00016 L001 A:15577 T:15577'
G[8676]='SP HL K00016 L001 A:15578 T:15578'
G[8677]='SP HL K00016 L001 A:15579 T:15579'
G[8678]='SP HL K00016 L001 A:15580 T:15580'
G[8679]='SP HL K00016 L001 A:15581 T:15581'
G[8680]='SP HL K00016 L001 A:15582 T:15582'
G[8681]='SP HL K00016 L001 A:15583 T:15583'
G[8682]='SP HL K00016 L001 A:15584 T:15584'
G[8683]='SP HL K00016 L001 A:15585 T:15585'
G[8684]='SP HL K00016 L001 A:15586 T:15586'
G[8685]='SP HL K00016 L001 A:15587 T:15587'
G[8686]='SP HL K00016 L001 A:15588 T:15588'
G[8688]='SP HL K00016 L001 A:15592 T:15592'
G[8689]='K0600 L060 CT A:15500 T:15500'
G[8690]='K0600 L060 CS A:15500 T:15500'
G[8691]='K0600 L060 CM A:15500 T:15500'
G[8692]='K0600 L060 CD A:15500 T:15500'
G[8693]='K0600 L060 CR A:15500 T:15500'
G[8694]='K0600 L060 CL A:15500 T:15500'
G[8695]='K0600 L060 CP A:15500 T:15500'
G[8696]='K0600 L060 CH A:15500 T:15500'
G[8697]='K0600 L060 CT A:15498 T:15498'
G[8698]='K0600 L060 CS A:15498 T:15498'
G[8699]='K0600 L060 CM A:15498 T:15498'
G[8700]='K0600 L060 CD A:15498 T:15498'
G[8701]='K0600 L060 CR A:15498 T:15498'
G[8702]='K0600 L060 CL A:15498 T:15498'
G[8703]='K0600 L060 CP A:15498 T:15498'
G[8704]='K0600 L060 CH A:15498 T:15498'
G[8705]='K0600 L060 CT A:15499 T:15499'
G[8706]='K0600 L060 CS A:15499 T:15499'
G[8707]='K0600 L060 CM A:15499 T:15499'
G[8708]='K0600 L060 CD A:15499 T:15499'
G[8709]='K0600 L060 CR A:15499 T:15499'
G[8710]='K0600 L060 CL A:15499 T:15499'
G[8711]='K0600 L060 CP A:15499 T:15499'
G[8712]='K0600 L060 CH A:15499 T:15499'
G[8713]='SP HL K00016 L001 A:15593 T:15593'
G[8714]='SP HL K00016 L001 A:15594 T:15594'
G[8715]='SP HL K00016 L001 A:15595 T:15595'
G[8716]='SP HL K00016 L001 A:15596 T:15596'
G[8717]='SP HL K00016 L001 A:15597 T:15597'
G[8718]='SP HL K00016 L001 A:15598 T:15598'
G[8719]='SP HL K00016 L001 A:15599 T:15599'
G[8720]='SP HL K00016 L001 A:15600 T:15600'
G[8721]='SP HL K00016 L001 A:15601 T:15601'
G[8722]='SP HL K00016 L001 A:15602 T:15602'
G[8723]='SP HL K00016 L001 A:15603 T:15603'
G[8724]='SP HL K00016 L001 A:15604 T:15604'
G[8725]='SP HL K00016 L001 A:15605 T:15605'
G[8726]='SP HL K00016 L001 A:15606 T:15606'
G[8727]='SP HL K00016 L001 A:15607 T:15607'
G[8744]='SP HZ K0000 L001 A:1180743 T:1180743'
G[8746]='HV FH K0000 L040 A:13418 T:13418 Z19243'
G[8747]='K0600 L060 A:15192 T:15192 P:1'
G[8748]='K0600 L060 A:15192 T:15192 P:8747'
G[8749]='K0600 L060 A:15192 T:15192 P:8748'
G[8750]='K0600 L060 A:15192 T:15192 P:8749'
G[8751]='K0600 L060 A:15192 T:15192 P:8750'
G[8752]='K0600 L060 A:15192 T:15192 P:1'
G[8753]='K0600 L060 A:15192 T:15192 P:8752'
G[8754]='K0600 L060 A:15192 T:15192 P:8753'
G[8755]='K0600 L060 A:15192 T:15192 P:8754'
G[8756]='K0600 L060 A:15192 T:15192 P:8755'
G[8757]='K0600 L060 A:15192 T:15192 P:1'
G[8758]='K0600 L060 A:15192 T:15192 P:8757'
G[8759]='K0600 L060 A:15192 T:15192 P:8758'
G[8760]='K0600 L060 A:15192 T:15192 P:8759'
G[8761]='K0600 L060 A:15192 T:15192 P:8760'
G[8762]='HV FA K0000 L040 A:13433 T:13433 Z19243'
G[8763]='HV FA K0000 L040 A:13433 T:1180715 Z19243'
G[8767]='SP HZ K0000 L001 CK CH CP CR CW A:1180746 T:1180746'
G[8768]='SP HZ K0000 L020 A:1180747 T:1180747'
G[8769]='SP HZ K0000 L040 A:1180748 T:1180748'
G[8784]='K0601 L060 A:100021230 T:15502'
G[8788]='SP HZ K0000 L001 CD CM CO CT CS CL A:1180746 T:1180746'
G[8789]='K0601 L060 A:15380 T:15380'
G[8790]='K0601 L060 A:15378 T:15378'
G[8791]='K0600 L060 A:100021220 T:15181'
G[8798]='K0600 L055 A:10305 T:10305 P:28722+PN250'
G[8799]='HV FH K0000 L040 A:13418 T:1180715 Z19243'
G[8801]='K0600 L060 A:100021221 T:15379'
G[8802]='K0600 L060 A:15379 T:15192 P:8801'
G[8803]='SP HZ K0000 L010 A:1180793 T:1180793'
G[8827]='HZ FA K0000 L001 A:15732 T:13444'
G[8828]='HZ FH K0000 L001 A:515732 T:13445'
G[8860]='HU FA K0000 L001 A:15732 T:6740'
G[8861]='HU FH K0000 L001 A:515732 T:6746'
G[8866]='SP HL K00016 L001 A:15871 T:15871'
G[8867]='HL K00016 L001 A:15895 T:15895 O:8870,8871,8872,8873,8874,8875'
G[8868]='HL K00016 L040 A:15864 T:15864'
G[8870]='HL FA K00016 L001 A:15892 T:15895 I:8871,8872'
G[8871]='HL FA K00016 L001 A:515892 T:15895 I:8870,8872'
G[8872]='HL FA K00016 L001 A:500088 T:15895 I:8870,8871'
G[8873]='HL FH K00016 L001 A:15891 T:15895 I:8874,8875'
G[8874]='HL FH K00016 L001 A:15891 T:15895 I:8873,8875'
G[8875]='HL FH K00016 L001 A:15891 T:15895 I:8873,8874'
G[8883]='HL K00016 L001 A:15895 T:15864 P:8867'
G[8884]='FH K0070 L005 A:15920 T:15920'
G[8885]='FH K0090 L005 A:15920 T:15920 P:8884'
G[8886]='FH K0080 L005 A:15921 T:15921'
G[8887]='FH K0080 L005 A:100021776 T:15921'
G[8888]='FH K0100 L008 A:15951 T:15924'
G[8889]='FH K0100 L008 A:15924 T:15924 O:8888'
G[8890]='FH K0100 L008 A:15924 T:15951 P:8889'
G[8891]='FH K0100 L008 A:1181011 T:15951'
G[8892]='FH K0070 L005 A:15939 T:15939 O:9256'
G[8894]='FH K0100 L008 A:15969 T:15969 O:9394'
G[8895]='FH K0060 L004 A:15418 T:15405 P:8472'
G[9035]='FH K0060 L004 A:15941 T:15945'
G[9062]='FH K0060 L004 A:15945 T:15945 O:9035'
G[9064]='FH K0060 L004 A:15945 T:15970 P:9062'
G[9066]='FH K0060 L004 A:15970 T:15970 P:9064'
G[9067]='FH K0090 L007 A:16144 T:16144 O:9395'
G[9076]='FH K0080 L005 A:15404 T:15404 P:8480'
G[9119]='FH K0050 L004 A:15405 T:15401 P:8895'
G[9130]='FH K0070 L005 RB A:16261 T:44036'
G[9133]='FH K0070 L005 RB A:44036 T:16191 P:9130'
G[9134]='FH K0070 L005 RB A:16191 T:16192 P:9133'
G[9135]='FH K0070 L005 RB A:16192 T:16261 P:9134'
G[9138]='FH K0100 L009 A:16197 T:16197 P:9758'
G[9139]='FH K0110 L009 A:16197 T:16197 P:9138'
G[9140]='FH K0140 L009 A:16197 T:16197 P:9139'
G[9143]='FH K0120 L009 A:16219 T:16219 O:9145'
G[9144]='FH K0100 L010 A:16210 T:16183 I:28560'
G[9145]='FH K0120 L009 A:16213 T:16219 P:T39A44999'
G[9146]='FH K0120 L009 A:16219 T:16220 P:9143'
G[9147]='FH K0100 L009 A:16196 T:16196 O:9144,28560'
G[9148]='FH K0100 L009 A:16183 T:16197 P:9147'
G[9149]='FH K0130 L010 A:16198 T:16198 P:9327,9329'
G[9150]='FH K0120 L009 A:16199 T:16199 P:T39A44999'
G[9151]='FH K0200 L017 A:16199 T:16204'
G[9152]='FH K0110 L009 A:16224 T:16224 P:9327,9329'
G[9155]='FH K0140 L010 A:16200 T:16200 P:T39A44999'
G[9156]='FH K021512 L009 A:1181147 T:16200'	-- PM3
G[9157]='FH K0120 L009 A:16201 T:16201'
G[9158]='FH K0140 L011 A:16202 T:16202'
G[9159]='FH K0150 L011 A:16202 T:16202 P:9158'
G[9160]='FH K0110 L011 A:16231 T:16231 P:T39A44999'
G[9161]='FH K0160 L015 A:16203 T:1181150 O:9282'
G[9162]='FH K0160 L015 A:1181150 T:16203 P:9161'
G[9163]='FH K0140 L011 A:16231 T:16231 P:9160'
G[9164]='FH K0200 L017 A:16198 T:16240 P:9877'
G[9166]='FH K0160 L011 A:16231 T:16237 P:9163'
G[9167]='FH K021512 L015 A:16239 T:16239 P:9176'	-- PM5
G[9169]='FH K0160 L011 A:16237 T:16237 P:9166'
G[9170]='FH K0200 L017 A:16204 T:16204 P:9220'
G[9171]='FH K0150 L012 A:16253 T:16253 P:T39A44999'
G[9172]='FH K0160 L015 A:16203 T:16239 P:9162'
G[9173]='FH K0150 L015 A:16252 T:16252 P:T39A50999'
G[9174]='FH K0130 L009 A:16201 T:16201 P:9157'
G[9175]='FH K0150 L015 A:100022597 T:16252'
G[9176]='FH K0170 L015 A:16239 T:16239 P:9172'
G[9177]='FH K0150 L015 SB A:16252 T:10181 P:9175 Z18019'	-- arbitrary ending...not sure when it left
G[9180]='FH K0150 L015 RB A:16252 T:10181 P:9175'
G[9192]='FH K0140 L011 A:16251 T:16251 P:T39A44999'
G[9193]='FH K0170 L014 A:16289 T:16289'
G[9199]='FH K0170 L014 A:16251 T:16251'
G[9207]='FH K0140 L011 A:16293 T:16291 P:T39A44999'
G[9208]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[9209]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[9210]='K0601 L058 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[9212]='FH K0170 L014 A:16295 T:16220'
G[9214]='FH K0180 L015 A:16220 T:16220'
G[9215]='FH K020512 L009 A:1181153 T:16220'	-- PM2
G[9216]='FH K0160 L015 A:16205 T:16205'
G[9217]='FH K0161 L015 A:16205 T:16205 P:9216'
G[9218]='FH K0180 L015 A:16205 T:16205'
G[9219]='FH K0181 L015 A:16205 T:16205 P:9218'
G[9220]='FH K0200 L017 A:16204 T:16204 O:9151'
G[9250]='K0600 L060 A:100022727 T:15192 P:K100022727'
G[9251]='K0600 L060 A:15192 T:15192 P:9250+K100022733'
G[9252]='FH K0090 L007 A:15942 T:15942 O:9358'
G[9253]='FH K0100 L008 A:15942 T:16362 P:9252'
G[9254]='FH K0090 L007 A:16210 T:15402'
G[9255]='FH K0090 L007 A:15402 T:16210 P:8488'
G[9256]='FH K0070 L006 A:15403 T:15939 P:8483'
G[9257]='K0600 L060 CT A:15192 T:15192 P:9251'
G[9258]='FH K0100 L008 A:16397 T:15398'
G[9259]='K0001 L030 A:16399 T:16399 P:U01541999'
G[9266]='K0001 L040 A:16416 T:16416 P:U24141999'
G[9267]='K0001 L015 A:16418 T:16418 P:U1D641999'
G[9268]='K0001 L040 A:16417 T:16417 P:U17141999'
G[9269]='K0600 L060 CD A:15192 T:15192 P:9251'
G[9270]='K0600 L060 CM A:15192 T:15192 P:9251'
G[9271]='K0600 L060 CL A:15192 T:15192 P:9251'
G[9272]='K0550 L049 A:2546 T:2546 P:U01535999+T05741999 I:1036'
G[9274]='FH K0120 L009 A:16462 T:16462'
G[9275]='FH K0190 L016 A:16464 T:16464'
G[9276]='FH K0180 L015 A:16463 T:16463'
G[9277]='FH K0190 L015 A:16463 T:16463 P:9276'
G[9279]='FA K0010 L001 RD A:16475 T:16477'
G[9280]='FA K0010 L001 RD A:16477 T:16477 O:9279 I:9369'
G[9281]='FH K0180 L015 A:16480 T:16480'
G[9282]='FH K0160 L015 A:16239 T:16203'
G[9283]='FA K0020 L001 RD A:16502 T:16502 P:9409'
G[9287]='FA K0030 L002 RD CP A:16501 T:16501 P:9409 Z17688'
G[9288]='FA K0030 L002 RD CH A:16499 T:16499 P:9409 Z17688'
G[9289]='FA K0030 L002 RD CW A:16503 T:16503 P:9409 Z17688'
G[9290]='FA K0030 L002 RD CM A:16500 T:16500 P:9409 Z17688'
G[9291]='FA K0030 L002 RD CT A:16502 T:16502 P:9409 Z17688'
G[9293]='FA K0020 L001 A:16514 T:16514 P:10302'
G[9294]='FA K0030 L001 A:16514 T:16514 P:9293'
G[9303]='FA K0040 L002 A:16535 T:16535 P:10302 O:10304 I:37444'
G[9305]='FA K0040 L002 A:17071 T:17071 P:10302'
G[9309]='FA K0050 L002 A:16535 T:16546 P:9303'
G[9311]='FA K0050 L002 A:16546 T:16535 P:10303'
G[9312]='FA K0050 L003 A:16535 T:17071 P:9305|37445+9311'
G[9313]='FA K0050 L002 A:17071 T:16551 P:9312'
G[9314]='FA K0050 L001 A:16554 T:16553'
G[9315]='FH K011512 L009 A:16601 T:16197 P:9327,9329'	-- PM2
G[9324]='HM FA K0000 L001 A:100023179 T:16817'
G[9325]='HM FA K0000 L001 A:100023180 T:16817'
G[9326]='HM FA K0000 L001 A:100023181 T:16817'
G[9327]='FH K0100 L009 RB A:16197 T:16252 O:9144,28560'
G[9328]='FH K0210 L015 RB A:16239 T:16802 P:9167'
G[9329]='FH K0100 L009 SB A:16197 T:16252 O:9144,28560'
G[9330]='HM FH K0000 L001 A:100023182 T:16818'
G[9331]='HM FH K0000 L001 A:100023183 T:16818'
G[9332]='HM FH K0000 L001 A:100023184 T:16818'
G[9339]='SP HM FH K0000 L001 A:16818 T:16818 P:H9330+H9331+H9332+H11933'
G[9340]='FH K0620 L060 A:16789 T:16789 O:9498,9499'
G[9345]='FH K0610 L058 A:16858 T:16858'
G[9349]='K0610 L058 A:19344 T:19344'
G[9351]='K0610 L058 A:19367 T:19367 P:10161'
G[9352]='FH K0060 L004 A:15403 T:15401 P:8463'
G[9355]='FA K0610 L058 A:16837 T:16837 P:10143,10483'
G[9356]='K0610 L058 A:19344 T:19344 P:9361'
G[9358]='FH K0090 L008 A:15397 T:15942'
G[9359]='FH K0100 L008 A:15939 T:15399 P:8892'
G[9360]='FH K0110 L008 A:100023249 T:15399'
G[9361]='K0610 L058 A:19344 T:19344 P:9349'
G[9363]='FH K0110 L008 A:15399 T:15939 P:9360'
G[9365]='SP HM FA K0000 L001 A:16817 T:16817 P:H9324+H9325+H9326+H11935'
G[9366]='FH K0620 L060 A:16791 T:16791'
G[9369]='FA K0010 L001 SD A:16477 T:16477 I:9280'
G[9370]='FH K0620 L060 A:16791 T:16791 P:9366'
G[9371]='FA K0020 L001 A:16477 T:16514 P:9409'
G[9372]='K0630 L061 A:16991 T:16991 O:10442,10443'
G[9373]='K0610 L058 A:100023338 T:16991'
G[9374]='FH K0620 L060 A:16793 T:16793'
G[9375]='FH K0630 L061 A:16993 T:17015'
G[9376]='FH K0630 L061 A:17015 T:17015 P:9375'
G[9381]='FH K0630 L061 A:16790 T:16790'
G[9383]='FA K0630 L061 A:17006 T:17006'
G[9385]='FA K0630 L060 A:16850 T:16850'
G[9387]='FH K0630 L060 A:16794 T:16794'
G[9390]='FA K0620 L060 A:16834 T:16852'
G[9391]='FH K0620 L060 A:16789 T:16789 P:9340'
G[9392]='FH K0030 L002 RB CR A:15278 T:15285 P:8325'
G[9393]='FH K0030 L002 RB CH A:15278 T:15513 P:8325 Z21691'
G[9394]='FH K0100 L008 A:15924 T:15969'
G[9395]='FH K0090 L008 A:16210 T:16144'
G[9396]='FH K0620 L060 A:16792 T:16792'
G[9397]='FH K0620 L060 A:16790 T:16790'
G[9398]='FA K0620 L060 A:16797 T:16797'
G[9399]='FA K0630 L060 A:16799 T:16799'
G[9400]='FH K0620 L060 A:3230 T:17062'
G[9401]='FH K0620 L060 A:17062 T:3230 P:9400'
G[9402]='FH K0100 L010 CM A:15970 T:15970'
G[9403]='FH K0100 L010 CM A:15970 T:15970 P:9402'
G[9404]='FH K0100 L010 CM A:15970 T:15970 P:9403'
G[9405]='FH K0620 L060 A:3230 T:16574 P:9401'
G[9406]='FH K0620 L060 A:16845 T:3230 P:9410'
G[9407]='FH K0610 L058 A:19254 T:19253 Z19116'
G[9409]='FA K0020 L001 A:16477 T:16502 P:9280,9369'
G[9410]='FH K0620 L060 A:16574 T:16845 P:9405'
G[9415]='FA K0560 L054 A:17082 T:17080'
G[9416]='FH K0560 L054 A:17081 T:17079'
G[9417]='FA K0630 L060 A:16850 T:16850 O:9558'
G[9418]='K0630 L060 A:100023580 T:17085'
G[9419]='FA K056256 L054 A:17080 T:17080 P:9415'
G[9420]='FA K0620 L060 A:16851 T:16851 P:9563'
G[9421]='FA K0030 L002 RD CS A:17089 T:17089 P:9409 Z17688'
G[9422]='FH K056256 L054 A:17079 T:17079 P:9416'
G[9423]='FA K0620 L060 A:16852 T:16834 P:9390'
G[9424]='FA K0630 L060 A:16833 T:16833 P:9423'
G[9426]='FA K0620 L060 A:16796 T:16796'
G[9427]='FA K0620 L060 A:16796 T:16796 P:9426'
G[9430]='FA K0630 L060 A:16796 T:16796 P:9543'
G[9436]='FH K0260 L024 A:17094 T:17094 P:26280'
G[9437]='FH K0370 L033 A:17095 T:17095'
G[9442]='FH K0630 L060 A:17123 T:17123 Z13329'
G[9447]='FH K0630 L060 A:17123 T:17123 P:9442 Z13329'
G[9452]='FA K0060 L004 A:17101 T:17101'
G[9453]='FA K0060 L004 A:17101 T:17110 P:9452'
G[9454]='FA K0060 L004 A:17110 T:17110'
G[9455]='FA K0070 L005 A:100023678 T:17116'
G[9456]='FA K0080 L005 A:17116 T:17116 P:9455'
G[9457]='FH K0260 L024 A:17094 T:17094 P:9436'
G[9463]='FA K0060 L004 RD A:17214 T:17214'
G[9466]='FH K0630 L058 A:1181638 T:16789'
G[9472]='FH K0620 L060 A:16793 T:16793 P:10287'
G[9473]='FA K0080 L005 RD A:17215 T:17215 P:9463'
G[9483]='FH K0621 L060 A:17226 T:17226'
G[9487]='K0160 L015 RB CM A:16197 T:16197'
G[9488]='K0160 L015 A:16197 T:16197 P:9487'
G[9490]='FA K0630 L060 A:16799 T:16799'
G[9498]='FH K0620 L060 SB A:16577 T:16789'
G[9499]='FH K0620 L060 RB A:16577 T:16789'
G[9505]='FA K0080 L005 RD A:17215 T:17240 P:9473'
G[9506]='FA K0070 L005 A:17240 T:17240 O:9505'
G[9512]='FA K0070 L005 A:17246 T:17246'
G[9513]='FA K0080 L006 A:17241 T:17241 P:9506,9512'
G[9514]='FA K0080 L006 A:100023759 T:17241 P:C9506'
G[9515]='FA K0100 L006 A:17241 T:17241 P:9514'
G[9523]='FA K0080 L006 A:17242 T:17242 P:9506,9512'
G[9527]='FA K0100 L006 A:17311 T:17311 O:10428'
G[9528]='FA K010544 L006 A:17312 T:17311'
G[9530]='FA K0090 L005 A:17240 T:17240 P:9506'
G[9531]='FA K0090 L005 A:17240 T:17240 P:9530'
G[9537]='FA K0090 L005 A:17240 T:17240 P:9531'
G[9538]='FA K0080 L008 A:17232 T:17360'
G[9539]='FA K0100 L008 A:17360 T:17361 P:9538'
G[9540]='FA K0100 L008 A:17361 T:17362 P:9539'
G[9541]='FA K0100 L008 A:17362 T:17363 P:9540'
G[9542]='FA K0100 L008 A:17363 T:17364 P:9541'
G[9543]='FA K0630 L060 A:16834 T:16796 P:9424'
G[9544]='FA K0100 L008 A:17364 T:17114 P:9542'
G[9545]='FA K0630 L060 A:16796 T:16796 P:9430'
G[9548]='FA K0170 L013 A:17421 T:17421'
G[9549]='FA K0170 L013 A:17421 T:17421 O:10063'
G[9550]='FA K0160 L013 A:100023837 T:1181756 P:9549'
G[9557]='FA K0160 L013 A:1181756 T:17424 P:9550'
G[9558]='FA K0620 L060 A:16826 T:16850 P:10143,10483'
G[9559]='FA K0100 L007 A:17114 T:17440 P:9544'
G[9560]='FA K0100 L007 A:17442 T:17442 P:9544'
G[9561]='FA K0160 L013 A:17424 T:1181758 P:9557'	-- about 10 second wait
G[9562]='FA K0100 L007 A:17441 T:17441 P:9544'
G[9563]='FA K0620 L060 A:16851 T:16851 P:T3B244999'
G[9564]='FA K0110 L007 A:100023850 T:17441 P:B9560,B9562'
G[9565]='FA K0100 L007 A:17440 T:1181748 P:9560,9562'
G[9566]='FA K0100 L007 A:1181748 T:17440 P:9565'
G[9567]='FA K0140 L013 A:17433 T:17433'
G[9569]='FA K0180 L013 A:17433 T:17433 P:9567'	-- about a 15 second delay
G[9570]='FA K0120 L007 A:17443 T:17443 P:D9566,D9573'
G[9571]='FA K0100 L007 A:17443 T:17442 P:9570'
G[9573]='FA K0110 L007 A:17445 T:17445 P:9560,9562'
G[9574]='FA K0140 L010 A:17434 T:17434 P:9629'
G[9576]='FA K0120 L009 A:100023870 T:17434'
G[9578]='FA K0180 L015 A:17434 T:17508'
G[9579]='FA K0180 L015 A:17508 T:17434 P:9578'
G[9580]='FA K0160 L014 A:17642 T:17642'
G[9581]='FA K0110 L010 A:17423 T:17423'
G[9582]='FA K0100 L010 CW A:17480 T:17480'
G[9584]='FA K0140 L010 A:17423 T:17423 P:9628'
G[9585]='FA K0180 L010 A:17423 T:17423 P:9584'
G[9594]='FA K0140 L010 A:100023900 T:17433'
G[9602]='FA K0090 L005 A:17240 T:17116 P:9537'
G[9603]='FA K0070 L005 RD A:16553 T:43991,17554'
G[9604]='FA K0070 L005 RD A:43991,17554 T:16768 P:9603'
G[9605]='FA K0070 L005 RD A:16768 T:17555 P:9604'
G[9606]='FA K0070 L005 RD A:17555 T:16553 P:9605'
G[9612]='FA K0080 L005 RD A:17587 T:17116'
G[9616]='FA K0070 L005 A:100023910 T:17116'
G[9620]='FA K0140 L010 A:17423 T:17600 P:9581'
G[9621]='FH K0210 L015 RB A:16802 T:10181 P:9328'
G[9622]='FA K0110 L007 A:17440 T:17116 P:9566+9570+9573'
G[9623]='FA K0110 L010 A:17116 T:17584'
G[9624]='FA K0120 L009 A:17599 T:17599'
G[9625]='FA K0110 L010 A:17584 T:17586 P:9623 I:28559'
G[9626]='FH K0210 L015 RB A:10181 T:39605 P:9621'
G[9627]='FH K0210 L015 RB A:39605 T:16802 P:9626'
G[9628]='FA K0140 L010 A:17600 T:17423 P:9620'
G[9629]='FA K0130 L010 A:17434 T:17434'
G[9630]='K0700 L070 A:17613 T:16813'
G[9631]='K0700 L070 A:17613 T:17636 P:9680'
G[9632]='FA K0150 L015 A:17424 T:17614'
G[9634]='FA K0110 L008 A:17586 T:17586 O:9625,28559'
G[9635]='FH K0600 L058 A:17637 T:17637 P:PN305'
G[9636]='FA K0600 L058 A:17634 T:17634 P:PN305'
G[9637]='K0700 L070 A:17636 T:17636 P:9631'
G[9638]='K0700 L070 A:16813 T:16814 P:9630'
G[9639]='K0700 L070 A:16814 T:16815 P:9638'
G[9640]='K0700 L070 A:16815 T:16815 P:9639'
G[9641]='FA K0150 L013 A:17684 T:17684'
G[9642]='FA K0151 L013 A:17684 T:17684 P:9641'
G[9643]='FA K0150 L014 A:17642 T:17642'
G[9644]='K0700 L070 A:17636 T:17613 P:9637'
G[9645]='K0700 L070 A:16815 T:17613 P:9640'
G[9646]='FA K0170 L009 A:1181889 T:17423'
G[9647]='FA K0160 L014 A:17642 T:17642 P:9580,9643'
G[9648]='FA K0140 L010 A:17663 T:17663'
G[9649]='FA K0180 L015 A:17663 T:17663 P:9648'
G[9663]='FA K0120 L010 A:17649 T:17649'
G[9666]='FA K0130 L010 A:17649 T:17649 P:9663'
G[9667]='FA K0130 L010 A:17682 T:18803 P:9559'
G[9668]='FA K0130 L010 A:17649 T:17658 P:9666'
G[9669]='FA K0190 L016 A:17676 T:17676'
G[9670]='FA K0190 L016 A:17686 T:17686'
G[9671]='SP FA K0180 L015 A:17703 T:17703 P:9506'
G[9672]='FA K0180 L015 A:100024132 T:17712 P:9671 I:9751'
G[9674]='FA K0180 L015 A:17712 T:17712 P:9672,9751'
G[9676]='FH K0030 L002 RB CP A:15278 T:15280 P:8325'
G[9680]='K0700 L070 A:17613 T:17613 P:9645'
G[9682]='FA K0180 L015 A:17712 T:17712 P:9674'
G[9683]='FA K0190 L015 A:17712 T:17712 P:9682'
G[9687]='FA K0180 L015 A:17674 T:17674'
G[9688]='FA K0190 L016 A:17674 T:17674 P:9687'
G[9689]='FA K0210 L019 A:17674 T:17674 P:9688'
G[9693]='FA K0150 L010 A:17658 T:17684 O:9668'
G[9694]='FA K0150 L010 A:17684 T:17684 P:9693'
G[9696]='FA K0160 L014 A:17684 T:17825 P:9779'
G[9697]='K0630 L061 A:17834 T:17831 P:T3AE44999'
G[9698]='FA K0160 L014 A:17825 T:17468 P:9696'
G[9699]='FA K0160 L014 A:17468 T:17684 P:9698'
G[9700]='FA K0160 L014 A:17684 T:17684 P:9699'
G[9701]='K0630 L061 A:17831 T:17831 O:9697'
G[9702]='K0640 L061 A:17831 T:17831 P:9701'
G[9703]='FA K0170 L015 A:17843 T:17843 P:9700'
G[9704]='FH K0050 L004 RB A:15301 T:17849 O:8347'
G[9705]='FH K0050 L004 A:17849 T:15301 P:9704'
G[9706]='FA K0180 L015 A:1182032 T:17843 P:9779'
G[9708]='K0630 L061 A:17831 T:17831 P:9702'
G[9709]='K0640 L061 A:17831 T:17831 P:9708'
G[9711]='FA K0180 L015 A:17843 T:17843 P:9706'
G[9716]='K0630 L061 A:17841 T:17841'
G[9718]='K0630 L061 A:17841 T:17841 P:9716'
G[9720]='K0640 L061 A:17841 T:17841 P:9718'
G[9724]='K0640 L061 A:17841 T:16885 P:9731'
G[9726]='K0640 L062 A:17856 T:17856 P:T3CA44999'
G[9727]='K0641 L062 A:17856 T:17856 P:9726+T3CA44999'
G[9728]='K0640 L061 A:17858 T:17858 O:9778'
G[9729]='K0650 L063 A:17877 T:17856 P:T3CA50999'
G[9730]='K0640 L058 A:1182115 T:17858'
G[9731]='K0630 L059 A:100024330 T:17841 P:C9720'
G[9732]='K0630 L060 A:16885 T:17841 P:9724'
G[9739]='K0630 L061 A:17923 T:17923 P:U3CA44999'
G[9740]='FA K0180 L016 A:17844 T:17844 P:9746'
G[9741]='FA K0180 L016 A:17926 T:17844'
G[9742]='SP K0631 L061 A:17923 T:17923 P:9739+U3CA44999'
G[9743]='K0640 L061 A:17923 T:17923 P:U3CA44999'
G[9744]='SP K0641 L061 A:17923 T:17923 P:9743+U3CA44999'
G[9746]='FA K0180 L016 A:17844 T:17844 P:9748'
G[9747]='K0620 L060 A:17956 T:17956'
G[9748]='FA K0180 L016 A:17844 T:17844 P:9703'
G[9751]='FA K0180 L015 A:17240 T:17712 P:9671 I:9672'
G[9752]='K0630 L060 A:17969 T:17841'
G[9753]='FA K0200 L018 A:17844 T:17658'
G[9756]='FA K0200 L018 A:17658 T:17658 P:9753'
G[9758]='FH K0100 L009 A:16252 T:16197 P:9327,9329'
G[9759]='FA K0200 L018 A:17982 T:17658 P:9753'
G[9760]='FA K0200 L018 A:17658 T:17986 P:9756'
G[9761]='FA K0200 L018 A:17986 T:17986 P:9760'
G[9762]='FA K0200 L018 RD A:17468 T:17468 P:9759'
G[9769]='FH K0620 L060 A:18016 T:18016'
G[9770]='FH K0620 L060 A:18012 T:18012'
G[9771]='FH K0620 L059 A:18011 T:18035 P:9774'
G[9772]='FH K0620 L060 A:18035 T:18011 P:9771'
G[9773]='FH K0611 L058 A:18016 T:18016'
G[9774]='FH K0620 L059 A:18011 T:18011'
G[9775]='FH K0620 L062 A:18011 T:18013'
G[9776]='FA K0640 L062 A:18003 T:18008'
G[9777]='FA K0620 L060 A:18007 T:18007'
G[9778]='K0640 L061 A:17841 T:17858'
G[9779]='FA K0160 L014 A:17684 T:17684 P:9694'
G[9780]='FA K0620 L060 A:18006 T:18006 P:9791'
G[9781]='FA K0620 L060 A:18005 T:18005'
G[9782]='FA K0620 L060 A:18004 T:18004'
G[9783]='FA K0620 L060 A:18004 T:18004 P:9782'
G[9784]='SP K0641 L060 A:17909 T:17909 P:9802+U3AE50999'
G[9785]='K0640 L059 A:18070 T:18070 P:T3AE44999'
G[9786]='FA K0620 L060 A:18003 T:18003'
G[9787]='FA K0620 L060 A:18003 T:18003 P:9786'
G[9788]='K0620 L060 A:17956 T:17956 P:9747'
G[9789]='K0660 L064 A:18180 T:18180 O:10113,10114'
G[9790]='FA K0620 L060 A:18005 T:18005 P:9781'
G[9791]='FA K0620 L060 A:18006 T:18006'
G[9792]='FA K0640 L064 A:18008 T:18408 P:T3D241999'
G[9793]='FA K0620 L062 A:18004 T:18252 I:10104'
G[9794]='FA K0650 L064 A:18019 T:18098'
G[9795]='FH K0650 L064 A:18013 T:18248'
G[9796]='FH K0620 L062 A:18011 T:18249 I:10105'
G[9797]='FH K0640 L064 A:18091 T:18090'
G[9798]='FA K0050 L002 A:100024414 T:16535 P:9309'
G[9799]='FA K0030 L001 A:20233 T:20233 P:10302'
G[9800]='K0650 L064 A:18073 T:18073'
G[9801]='FA K0620 L060 A:18003 T:18003 P:9787'
G[9802]='K0630 L060 A:17909 T:17909'
G[9803]='FA K0620 L060 A:18003 T:18003 P:9801'
G[9804]='K0650 L064 A:18073 T:18073 P:9800'
G[9805]='K0650 L064 A:18073 T:18073 P:9804'
G[9806]='K0640 L062 A:17925 T:17925 P:T3CA41999'
G[9807]='SP K0641 L062 A:17925 T:17925 P:9806+T3CA41999'
G[9808]='K0640 L062 A:17924 T:17924 P:T3CA41999+U3CA44999'
G[9809]='SP K0641 L062 A:17924 T:17924 P:9808+T3CA41999+U3CA44999'
G[9810]='K0660 L064 A:18073 T:18073 P:9805'
G[9811]='FH K0210 L015 SB A:16239 T:16802 P:9167'
G[9812]='FH K0210 L015 SB A:16802 T:10181 P:9811'
G[9813]='FH K0210 L015 SB A:10181 T:39605 P:9812'
G[9814]='FH K0640 L062 A:18014 T:18014'
G[9815]='K0660 L064 A:18073 T:18073'
G[9816]='FH K0640 L062 A:18014 T:18014 P:9814'
G[9817]='K0630 L058 A:1182115 T:17858'
G[9818]='K0650 L064 A:18071 T:18099'
G[9819]='K0650 L064 A:18099 T:18099 P:9818'
G[9820]='FH K0640 L058 A:1182165 T:18013'
G[9821]='K0660 L064 A:18099 T:18099 P:9819'
G[9822]='FH K0640 L062 A:18013 T:18013 P:9820'
G[9823]='FH K0640 L062 A:18013 T:18013 P:9822'
G[9824]='K0700 L068 A:17613 T:17613'
G[9825]='K0700 L068 A:17613 T:17613 P:9824'
G[9826]='K0700 L068 A:17613 T:18165 P:9824,9825'
G[9827]='FA K0620 L060 A:100024483 T:18007 P:C9782'
G[9828]='FH K0620 L060 A:100024484 T:18012'
G[9829]='K0700 L068 A:18165 T:18166 P:9826'
G[9830]='FA K0640 L062 A:18009 T:18009 P:T3D241999'
G[9831]='K0700 L068 A:18166 T:18166 P:9829'
G[9832]='K07064 L068 A:18166 T:18166 P:9831'
G[9833]='FA K0640 L062 A:18009 T:18009 P:T3D241999'
G[9834]='FA K0640 L062 A:18010 T:18010 P:T3D241999'
G[9835]='FA K0640 L062 A:18008 T:18008'
G[9836]='K0700 L068 A:18166 T:15608 P:9832'
G[9837]='K0700 L068 A:15608 T:18166 P:9836'
G[9838]='K0700 L068 A:18166 T:17613 P:9837'
G[9839]='FA K0640 L062 A:18008 T:18008 P:9835'
G[9840]='K0700 L068 A:17613 T:16388 P:9838'
G[9841]='FH K0640 L062 A:18015 T:18015'
G[9842]='FH K0640 L062 A:18015 T:18015 P:9841'
G[9843]='K0700 L068 A:16388 T:17613 P:9840'
G[9844]='K0700 L068 A:17613 T:17613 P:9843'
G[9845]='FH K0640 L062 A:18018 T:18018'
G[9846]='FH K0620 L060 A:18017 T:18017'
G[9847]='FH K0640 L060 A:18017 T:18017 P:9846'
G[9848]='FA K0640 L062 A:18019 T:18019'
G[9849]='K0670 L064 A:18099 T:18099 P:9821'
G[9850]='K0670 L064 A:18180 T:18180 P:9789'
G[9851]='K0670 L064 A:18180 T:18180 P:9850'
G[9852]='K0680 L064 A:18180 T:18180 P:9856+9859+9851'
G[9853]='K0670 L064 A:18099 T:18099 P:9849'
G[9854]='K0650 L064 A:18200 T:18200 O:10113,10114'
G[9855]='K0670 L064 A:18200 T:18200 P:9854'
G[9856]='K0670 L064 A:18200 T:18200 P:9855'
G[9857]='K0650 L064 A:18218 T:18218 O:10113,10114'
G[9858]='K0660 L064 A:18218 T:18218 P:9857'
G[9859]='K0660 L064 A:18218 T:18218 P:9858'
G[9860]='K0700 L068 A:17613 T:18165 P:9844'
G[9861]='K0670 L064 A:100024504 T:18074'
G[9862]='K0670 L064 A:18074 T:18074 P:9861'
G[9863]='FH K0660 L064 A:18066 T:18066'
G[9864]='FH K0670 L064 A:18067 T:18229'
G[9865]='FH K0670 L064 A:18229 T:18229 P:9864'
G[9866]='FH K0670 L064 A:18229 T:18067 P:9865'
G[9867]='FH K0670 L064 A:18068 T:18068'
G[9868]='FH K0670 L064 A:18210 T:18063'	-- Need to be neutral or higher with Mag'har so reports a player in http://us.battle.net/wow/en/forum/topic/10787819412
G[9869]='FA K0660 L064 A:18233 T:18072 P:T3D241999'
G[9870]='FH K0660 L064 A:18234 T:18072'
G[9871]='FA K0670 L064 A:100024559 T:18183'
G[9872]='FH K0670 L064 A:100024558 T:18063'
G[9873]='FA K0670 L064 A:18183 T:18183 P:9871'
G[9874]='FA K0670 L064 A:18222 T:18222 P:T3D241999'
G[9875]='K0631 L060 A:100024407 T:17909 P:U3AE62999'
G[9877]='FH K0200 L017 A:16240 T:16198 P:9220'
G[9878]='FA K0670 L064 A:18224 T:18224 P:T3D241999'
G[9879]='FA K0670 L064 A:18209 T:18183'
G[9882]='K0660 L064 A:18265 T:18265 P:U3A544999 O:9913'
G[9883]='K0661 L064 A:18265 T:18265'
G[9884]='SP K0700 L063 A:18265 T:18265'
G[9885]='SP K0700 L063 A:18265 T:18265'
G[9886]='SP K0700 L063 A:18265 T:18265'
G[9887]='SP K0700 L063 A:18265 T:18265'	-- Nimhfree gets this (exalted)
G[9888]='FH K0650 L064 A:18106 T:18273'
G[9889]='FH K0650 L064 A:18273 T:18262 P:9888'
G[9890]='FH K0650 L064 A:18262 T:18273 P:9889'
G[9891]='FH K0650 L064 A:18273 T:18106 P:9890'
G[9892]='K0671 L064 A:18265 T:18265 P:9893'
G[9893]='K0670 L064 A:18265 T:18265 P:T3A544999'
G[9894]='K0620 L060 A:18070 T:18070 P:9747'
G[9895]='K0620 L060 A:17834 T:17834'
G[9896]='FA K0620 L060 A:18295 T:18295 P:9901'
G[9897]='K0650 L064 A:18294 T:18218'
G[9898]='FH K0620 L060 A:18012 T:18012 P:9770'
G[9899]='FH K0620 L060 A:18016 T:18016'
G[9900]='K0670 L065 A:18276 T:18276'
G[9901]='FA K0620 L060 A:18295 T:18295'
G[9902]='FA K0640 L062 A:18009 T:18009 P:T3D241999'
G[9903]='FH K0640 L062 A:18018 T:18018 P:9845'
G[9904]='FH K0640 L062 A:18018 T:18018'
G[9905]='FA K0640 L062 A:18010 T:18010 P:9834'
G[9906]='FH K0650 L064 A:18106 T:18106 P:9891'
G[9907]='FH K0660 L064 A:18106 T:18106 P:9906'
G[9910]='FH K0650 L064 A:18300 T:18300'
G[9911]='K0640 L062 A:100025459 T:17831'
G[9912]='K0620 L061 A:16885 T:17841 I:39180,39181'
G[9913]='K0660 L064 A:18335 T:18265'
G[9914]='K0660 L064 A:18333 T:18333 P:U3A544999'
G[9915]='K0661 L064 A:18333 T:18333'
G[9916]='FH K0660 L064 A:18300 T:18300 P:9910'
G[9917]='FA K0650 L064 A:18353 T:18353'
G[9918]='FA K0650 L064 A:18353 T:18353 P:9917'
G[9919]='K0640 L060 A:17923 T:17924 P:T3CA41999'
G[9920]='FA K0650 L064 A:18353 T:18223 P:T3D241999,9918'
G[9921]='FA K0650 L064 A:18223 T:18223 P:9920'
G[9922]='FA K0660 L064 A:18223 T:18223 P:9921'
G[9923]='FA K0650 L064 A:18369 T:18183'
G[9924]='FA K0660 L064 A:18183 T:18183 P:9923'
G[9925]='K0660 L064 A:18276 T:18276'
G[9927]='K0660 L064 A:18261 T:18261 O:10108'
G[9928]='K0660 L064 A:18261 T:18261 O:10108'
G[9931]='K0660 L064 A:18261 T:18261 P:9928+9927'
G[9932]='K0660 L064 A:18261 T:18261 P:9928+9927'
G[9933]='FA K0660 L064 A:18261 T:18183 P:9932+9931'
G[9934]='FH K0660 L064 A:18261 T:18063'
G[9935]='FH K0660 L064 A:1182392 T:18407'
G[9936]='FA K0660 L064 A:1182393 T:18408 P:T3D241999'
G[9937]='FH K0670 L066 A:18407 T:18407'
G[9938]='FA K0670 L066 A:18408 T:18408 P:9936+9940'
G[9939]='FH K0660 L064 A:1182392 T:18407'
G[9940]='FA K0660 L064 A:1182393 T:18408 P:T3D241999'
G[9944]='FH K0670 L065 A:18302 T:18414'
G[9945]='FH K0670 L065 A:18414 T:18414 P:9944'
G[9946]='FH K0670 L065 A:18414 T:18414 P:9945'
G[9948]='FH K0670 L065 A:18415 T:18415'
G[9951]='K0640 L062 A:18424 T:18424'
G[9954]='FA K0670 L065 A:18183 T:18445 P:9924'
G[9955]='FA K0670 L065 A:18445 T:18183 P:9954'
G[9956]='FA K0670 L065 A:18416 T:18416'
G[9957]='K0630 L062 A:17834 T:18446 P:T3AE44999 I:9960,9961'
G[9960]='FH K0630 L062 A:18447 T:18446 I:9957,9961'
G[9961]='FA K0630 L062 A:18459 T:18446 I:9957,9960'
G[9962]='K067512 L065 A:18471 T:22893'	-- PM5
G[9967]='K067512 L065 A:18471 T:22893 P:9962'	-- PM5
G[9968]='K0630 L062 A:18446 T:18446 O:9957,9960,9961'
G[9970]='K067512 L065 A:18471 T:22893 P:9967'	-- PM5
G[9971]='K0630 L062 A:18446 T:18446'
G[9972]='K067512 L065 A:18471 T:22893 P:9970'	-- PM5
G[9973]='K067512 L065 A:18471 T:22893 P:9972'	-- PM5
G[9977]='K068512 L065 A:18471 T:22893 P:9973'	-- PM5
G[9978]='K0630 L062 A:18446 T:18482 P:9968,9971'
G[9979]='K0630 L062 A:18482 T:18484 P:9978'
G[9982]='FA K0680 L066 A:18416 T:18417'
G[9983]='FH K0680 L066 A:18301 T:18417'
G[9986]='FA K0640 L062 A:18389 T:18389'
G[9987]='FH K0640 L062 A:18386 T:18386'
G[9990]='K0640 L062 A:18484 T:18446 P:10112'
G[9991]='K0680 L066 A:18417 T:18417 P:9982,9983'	-- TODO: Determine if these are really O: and not P:
G[9992]='FA K0630 L062 A:18390 T:18390'
G[9993]='FH K0630 L062 A:18385 T:18385'
G[9994]='FA K0640 L062 A:18446 T:18459 P:9990'
G[9995]='FH K0640 L062 A:18446 T:18447 P:9990'
G[9996]='FA K0640 L062 A:21006 T:21006 P:10444'
G[9997]='FH K0640 L062 A:21007 T:21007 P:10448'
G[9998]='FA K0630 L062 A:18387 T:18565'
G[9999]='K0680 L066 A:18417 T:18417 P:9991'
G[10000]='FH K0630 L062 A:18383 T:18566'
G[10001]='K0680 L066 A:18417 T:18417 P:9999'
G[10002]='FA K0640 L062 A:18565 T:18565 P:9998'
G[10003]='FH K0640 L062 A:18566 T:18566 P:10000'
G[10004]='K0680 L066 A:18417 T:18584 P:10001'
G[10005]='FA K0630 L062 A:18459 T:18446 P:10446'
G[10006]='FH K0630 L062 A:18447 T:18446 P:10447'
G[10007]='FA K0640 L062 A:18565 T:18565 P:9998'
G[10008]='FH K0640 L062 A:18566 T:18566'
G[10009]='K06864 L066 A:18584 T:18584 P:10004'
G[10010]='K0680 L066 A:18584 T:18417 P:10009'
G[10011]='K0680 L066 A:18417 T:18417 P:10010'
G[10012]='FA K0640 L062 A:1182549 T:18387 P:9998'
G[10013]='FH K0640 L062 A:1182549 T:18386'
G[10016]='FA K0640 L062 A:18387 T:18387'
G[10017]='K0640 L062 A:18597 T:18597 P:U3A441999+10551|10552'
G[10018]='FH K0640 L062 A:18384 T:18384'
G[10019]='K0641 L062 A:18597 T:18597 P:10017+U3A441999'
G[10020]='K064512 L062 A:18597 T:18597 P:10551+T3A441999,10552+T3A441999'
G[10021]='K0640 L062 A:18538 T:18538 P:10551+T3A441999'
G[10022]='FA K0640 L062 A:18387 T:18387 P:10016'
G[10023]='FH K0640 L062 A:18384 T:18384 P:10018'
G[10024]='K0650 L062 A:18596 T:18596 P:U3A641999+10551|10552'
G[10025]='K0651 L062 A:18596 T:18596 P:10024+U3A641999'
G[10026]='FA K0640 L062 A:18252 T:18252'	-- needs checking regarding 10104 and/or 9793 P/O
G[10027]='FH K0640 L062 A:18383 T:18383'
G[10028]='FA K0630 L062 A:18390 T:18390 P:9992'
G[10030]='K0650 L063 A:18675 T:19417 P:10840+10842'
G[10031]='K0650 L063 A:19417 T:18675 P:10030'
G[10033]='FA K0650 L062 A:1182587 T:18704'
G[10034]='FH K0650 L062 A:1182588 T:18705'
G[10035]='FA K0650 L063 A:18704 T:18704 P:10033'
G[10036]='FH K0650 L063 A:18705 T:18705 P:10034'
G[10037]='K0640 L062 A:18653 T:18653'
G[10038]='FA K0640 L062 A:18713 T:18715'
G[10039]='FH K0640 L062 A:18712 T:18714'
G[10040]='FA K0650 L062 A:18715 T:18715 P:10038'
G[10041]='FH K0650 L062 A:18714 T:18714 P:10039'
G[10042]='FA K0650 L062 A:18715 T:18713 P:10040'
G[10043]='FH K0650 L062 A:18714 T:18712 P:10041'
G[10044]='FH K0680 L066 A:18063 T:18141 P:10011+9868'
G[10045]='FH K0680 L066 A:18141 T:18141 P:10044'
G[10047]='FA K0610 L058 A:16839 T:16839 P:10143,10483'
G[10050]='FA K0610 L058 A:16827 T:16827 P:10143,10483'
G[10051]='FA K0640 L062 A:18760 T:18745'
G[10052]='FH K0640 L062 A:18760 T:18712'
G[10055]='FA K0610 L058 A:21209 T:21209'
G[10057]='FA K0610 L058 A:16827 T:16827 P:10050'
G[10058]='FA K0610 L058 A:16825 T:16825 P:10143,10483'
G[10063]='FA K0170 L013 A:18804 T:17421'
G[10064]='FA K0180 L016 A:17423 T:17927'
G[10065]='FA K0170 L016 A:17927 T:17927'
G[10066]='FA K0180 L016 A:17986,18020,18024 T:17986'
G[10067]='FA K0190 L016 A:17986,18020,18024 T:17986'
G[10068]='FH K0030 L002 RL RB CM A:15279 T:15279 P:8328'
G[10069]='FH K0030 L002 RB CP A:15280 T:15280 P:9676'
G[10070]='FH K0030 L002 RB CH A:15513 T:15513 P:9393 Z21691'
G[10071]='FH K0030 L002 RB CR A:15285 T:15285 P:9392'
G[10072]='FH K0030 L002 RB CT A:15284 T:15284 P:8564'
G[10073]='FH K0030 L002 RB CL A:15283 T:15283 P:8563'
G[10074]='FH K0670 L064 A:18816 T:18816'
G[10075]='FH K0671 L064 A:18816 T:18816 P:10074'
G[10076]='FA K067256 L064 A:18817 T:18817'
G[10077]='FA K0671 L064 A:18817 T:18817 P:10076'
G[10078]='FA K0610 L058 A:21209 T:21209 P:10055'
G[10079]='FA K0610 L058 A:16837 T:16837 P:10143,10483'
G[10081]='FH K0680 L066 A:18141 T:18687 P:10045'
G[10082]='FH K0680 L066 A:18687 T:18687 P:10081'
G[10085]='FH K0680 L066 A:18687 T:18687 P:10082'
G[10086]='FH K0610 L058 A:21283 T:21283'
G[10087]='FH K0610 L058 A:21283 T:21283 P:10086'
G[10093]='FA K0630 L058 A:16839 T:16796 P:10047'
G[10096]='K0620 L060 A:17909 T:17909 P:9747'
G[10099]='FA K0610 L058 A:16837 T:16837 P:10079'
G[10101]='FH K0680 L066 A:18687 T:17545 P:10085'
G[10102]='FH K0680 L066 A:17545 T:18481 P:10101'
G[10103]='FH K0610 L061 A:16789 T:18011'
G[10104]='FA K0620 L062 A:18008 T:18252 I:9793'
G[10105]='FH K0620 L062 A:18013 T:18385 I:9796'
G[10106]='FA K060258 L055 A:18266 T:18266 P:13408,13410'
G[10107]='FH K0660 L064 A:18106 T:18261 P:9907'
G[10108]='FA K0660 L064 A:18223 T:18261 P:9922'
G[10109]='K0660 L064 A:19035 T:19035'
G[10110]='FH K060258 L055 A:18267 T:18267 P:13409,13411'
G[10111]='K0660 L064 A:19035 T:19035 P:10109'
G[10112]='K0640 L062 A:18484 T:18484 P:9979'
G[10113]='FA K0650 L064 A:19137 T:18180'
G[10114]='FH K0650 L064 A:19133 T:18200'
G[10115]='FA K0640 L062 A:18008 T:18008'
G[10116]='FA K0640 L058 A:1183284 T:18008'
G[10117]='FH K0640 L058 A:1182165 T:18013'
G[10118]='FH K0640 L062 A:18013 T:18013'
G[10119]='FA K0610 L058 A:16841 T:19229 I:28708 Z19116'
G[10120]='FH K0610 L058 A:19253 T:18930 P:9407,28705'
G[10121]='FH K0610 L058 A:3230 T:19256 P:10291'
G[10123]='FH K0610 L058 A:19256 T:19256 P:10121'
G[10124]='FH K0610 L058 A:19256 T:19273 P:10123'
G[10129]='FH K0620 L058 A:19273 T:19273 P:10208'
G[10132]='K0630 L061 A:19293 T:19293'
G[10134]='K0630 L061 A:100029476 T:19293'
G[10136]='FH K0630 L058 A:3230 T:3230'
G[10140]='FA K0610 L058 A:18931 T:19308 P:10288'
G[10141]='FA K0610 L058 A:16819 T:19309 O:10254'
G[10142]='FA K0610 L058 A:19309 T:19309 P:10141'
G[10143]='FA K0610 L058 A:19309 T:19310 P:10142'
G[10144]='FA K0620 L058 A:19310 T:19310 P:10143'
G[10146]='FA K0620 L058 A:19310 T:19310 P:10144'
G[10159]='K0630 L061 A:16888 T:16888'
G[10160]='FA K0610 L058 A:16819 T:16820 O:10254'
G[10161]='K0610 L058 A:19367 T:19367'
G[10162]='FH K0620 L058 A:19273 T:19273 P:10129'
G[10163]='FA K0620 L058 A:20232 T:20232 P:10344'
G[10165]='K0660 L064'	-- A:19674 T:19674  this version was removed
G[10166]='FH K0100 L007 A:15398 T:19456 P:8474'
G[10167]='FH K06864 L066 A:18481 T:19412 P:10102'
G[10168]='FH K0680 L066 A:19412 T:18687 P:10167'
G[10170]='FH K0680 L066 A:18687 T:18141 P:10168'
G[10171]='FH K0680 L066 A:18141 T:18063 P:10170'
G[10172]='FH K0680 L066 A:18063 T:18141 P:10171'
G[10173]='K0680 L067 A:19217 T:19217'
G[10174]='K0680 L067 A:19217 T:19644 P:10300'
G[10176]='K0680 L067 A:19644 T:19481 P:10209'
G[10180]='K06964 L065 A:19045 T:54840'
G[10182]='K0680 L067 A:100029233 T:19488'
G[10183]='K0680 L067 A:19569 T:19570 I:11036,11037,11040,11042,1038,1039'
G[10184]='K0680 L067 A:19488 T:19488'
G[10185]='K0680 L067 A:19488 T:19488'
G[10186]='K0680 L067 A:19570 T:19570 O:10183,11036,11037,11040,11042'
G[10188]='K0690 L067 A:19644 T:19644 P:10174'
G[10189]='K0680 L067 A:19468 T:19468 P:10551+T3A641999,10552+T3A641999 O:11039'
G[10190]='K0680 L067 A:19578 T:19578'
G[10191]='K068512 L067 A:19589 T:19578'	-- PM2
G[10192]='K0690 L067 A:19644 T:19644 P:10188'
G[10193]='K0680 L067 A:19468 T:19468 P:10189'
G[10194]='K0680 L067 A:19468 T:20162 P:10329'
G[10197]='K0680 L067 A:19840 T:19840 P:10652'
G[10198]='K0680 L067 A:19840 T:19840 P:10197'
G[10199]='K0680 L067 A:19617 T:19617 P:10342'
G[10200]='K0680 L067 A:19840 T:19468 P:10330'
G[10201]='FH K0650 L062 A:18385 T:18385 P:9993'
G[10202]='K0700 L067 A:19469 T:20920 P:10341'
G[10203]='K0690 L067 A:19570 T:19634'
G[10204]='K0680 L067 A:19469 T:19469 P:T3A641999'
G[10205]='K0690 L067 A:19880 T:19880'
G[10206]='K0680 L067 A:19645 T:19645'
G[10208]='FH K0620 L058 A:19273 T:19273 P:10124'
G[10209]='K0690 L067 A:19644 T:19644 P:10301'
G[10210]='K0650 L060 A:19684 T:18481'
G[10211]='K0650 L060 A:18166 T:18166 P:10210'
G[10213]='FH K0610 L058 A:16858 T:19367 P:9345'
G[10216]='K0660 L064'	-- A:19670 T:1183877   this one is no longer present
G[10218]='K0660 L064 A:19671 T:19674 Z20338'
G[10220]='FH K0610 L058 A:19682 T:19682'
G[10221]='K0680 L067 A:19634 T:19634'
G[10222]='K0690 L067 A:19488 T:19488'
G[10223]='K0690 L067 A:19488 T:19488 P:10222'
G[10224]='K0680 L067 A:19709 T:19709 P:10225'
G[10225]='K0680 L067 A:19570 T:19709'
G[10226]='K0680 L067 A:19709 T:19709 P:10224'
G[10227]='K0670 L064 A:19697 T:19417'
G[10228]='K0670 L064 A:19417 T:19715 P:10227'
G[10229]='FH K0610 L058 A:100028552 T:19736'
G[10230]='FH K0610 L058 A:19736 T:19736 P:10229'
G[10231]='K0670 L064 A:19715 T:19720 P:10228'
G[10232]='K0690 L067 A:19645 T:19645'
G[10233]='K0690 L067 A:19489 T:19489'
G[10234]='K0690 L067 A:19728 T:19728 P:10333'
G[10235]='K0690 L067 A:19728 T:19728 P:10234'
G[10236]='K0610 L058 A:16915 T:16915'
G[10237]='K0690 L067 A:19728 T:19570 P:10235'
G[10238]='K0610 L058 A:16915 T:16915 P:10236'
G[10239]='K0690 L067 A:19489 T:19489 P:10343'
G[10240]='K0690 L067 A:19489 T:19489 P:10239'
G[10241]='K0680 L067 A:19466 T:19466 P:10551+T3A441999,10552+T3A441999 O:11038'
G[10242]='FH K0600 L058 A:21257 T:21279'
G[10243]='K0680 L067 A:19467 T:1183770 P:T3A441999'
G[10245]='K0680 L067 A:1183770 T:19467 P:10243'
G[10246]='K0680 L067 A:19466 T:19466 P:10299+T3A441999'
G[10247]='K069512 L067 A:19570 T:19832 P:10237'	-- PM3
G[10248]='K069512 L067 A:19832 T:19832 P:10247'	-- PM3
G[10249]='K0690 L067 A:19832 T:19570 P:10248'
G[10250]='FH K0610 L058 A:19736 T:19736 P:10230'
G[10251]='K0670 L064 A:19720 T:19844 P:10231'
G[10252]='K0670 L064 A:19844 T:19844 P:10251'
G[10253]='K0670 L064 A:19844 T:19417 P:10252'
G[10254]='FA K0600 L055 A:19308 T:16819 P:10140'
G[10255]='K0630 L061 A:16991 T:16991 P:9372'
G[10256]='K069512 L067 A:19481 T:19481'	-- PM2
G[10257]='K07064 L067 A:19481 T:19481 P:10256'
G[10258]='FH K0610 L058 A:19736 T:19937 P:10250'
G[10261]='K068512 L067 A:1183811 T:19645'	-- PM2
G[10262]='K0680 L067 A:19880 T:19880 P:10265'
G[10263]='K0680 L067 A:19467 T:19880 P:T3A441999'
G[10264]='K0680 L067 A:19468 T:19880 P:T3A641999'
G[10265]='K0690 L067 A:19880 T:19880 O:10263,10264'
G[10266]='K0690 L067 A:19880 T:20066 P:10205'
G[10267]='K0690 L067 A:20066 T:20066 P:10266'
G[10268]='K0690 L067 A:20066 T:20084 P:10267'
G[10269]='K0690 L067 A:20084 T:20092 P:10268'
G[10270]='K0700 L068 A:20071 T:20518'
G[10271]='K0700 L068 A:20518 T:20154 P:10270'
G[10272]='K0700 L068 A:20110 T:20110 P:10281'
G[10273]='K0700 L068 A:20110 T:20110 P:10272'
G[10274]='K070512 L068 A:20110 T:20110 P:10273'	-- PM3
G[10275]='K0700 L067 A:20092 T:20112 P:10269'
G[10276]='K070512 L067 A:20112 T:20084 P:10275'	-- PM2
G[10277]='K0680 L066 A:20130 T:20130 O:10279'
G[10278]='FH K0610 L058 A:19683 T:19683'
G[10279]='K0660 L066 A:20142 T:20130'
G[10280]='K0700 L067 A:20084 T:18481 P:10276'
G[10281]='K0700 L068 A:20154 T:20110 P:10271'
G[10282]='K0680 L066 A:20130 T:20130 P:10277'
G[10283]='K0680 L066 A:18723 T:17876 P:10282 Z15050'
G[10284]='K0680 L066 A:17876 T:18723 P:10283 Z15050'
G[10285]='K0680 L066 A:18723 T:20130 P:10284 Z15050'
G[10286]='FH K0620 L060 A:16793 T:20159 P:9374'
G[10287]='FH K0620 L060 A:20159 T:16793 P:10286'
G[10288]='FA K0610 L058 A:19229 T:18931 O:10119,28708'
G[10289]='FH K0610 L058 A:18930 T:19255 P:10120'
G[10290]='K070512 L068 A:20067 T:20067'	-- PM2
G[10291]='FH K0610 L058 A:19255 T:3230 P:10289'
G[10293]='K069512 L067 A:20067 T:20067 P:10290'	-- PM2
G[10294]='FH K0610 L058 A:19683 T:19683 P:10278'
G[10295]='FH K0630 L058 A:19683 T:19683 P:10294'
G[10296]='K0700 L066 A:20130 T:20201'
G[10297]='K0700 L066 A:20201 T:20201 O:10296'
G[10298]='K0700 L066 A:20201 T:20130 P:10297 Z15050'
G[10299]='K0680 L067 A:19467 T:19467 P:10245'
G[10300]='K0690 L067 A:19217 T:19217 P:10173'
G[10301]='K0690 L067 A:19644 T:19644 P:10192'
G[10302]='FA K0020 L001 A:16514 T:16514 P:9280,9369 O:9371'
G[10303]='FA K0040 L001 A:16546 T:16546 P:9309'
G[10304]='FA K0040 L001 A:16514 T:16535 P:9294'
G[10305]='K0690 L067 A:100029234 T:19488'
G[10306]='K0690 L067 A:100029235 T:19488'
G[10307]='K0690 L067 A:100029236 T:19488'
G[10308]='K0681 L067 A:19880 T:19880'
G[10309]='K068512 L067 A:19690 T:19690'	-- PM3
G[10310]='K0700 L068 A:20281 T:20066 O:10311'
G[10311]='K0700 L068 A:20066 T:20281'
G[10312]='K0690 L067 A:19488 T:19488 P:10184'
G[10313]='K0680 L067 A:19466 T:19466 P:10241'
G[10314]='K0690 L067 A:1184300 T:19488 P:10316'	-- TODO: G55|Prerequisites|
G[10315]='K0700 L068 A:20341 T:20341'
G[10316]='K0690 L067 A:19488 T:1184300 P:10312'
G[10317]='K0700 L068 A:20112 T:20393'
G[10318]='K0700 L068 A:20393 T:20112 P:10317'	-- TODO: G55|Prerequisites|
G[10319]='K0690 L067 A:19488 T:19488 P:10314'
G[10320]='K069512 L067 A:19488 T:19488 P:10319'	-- PM3
G[10321]='K0690 L067 A:19467 T:19467 P:10299'
G[10322]='K0700 L067 A:19467 T:19467 P:10321'
G[10323]='K070512 L067 A:19467 T:19467 P:10322'	-- PM3
G[10324]='FA K0080 L004 A:17110 T:17110 P:9454'
G[10325]='K0650 L062 A:18537 T:18537 P:T3A441999+U3A450999+10551|10552'
G[10326]='K0651 L062 A:18537 T:18537 P:10325+T3A441999+U3A450999'
G[10327]='K0651 L062 A:18537 T:18537 P:10325+T3A441999+U3A450999'
G[10328]='K0700 L067 A:19466 T:19466 P:10321+T3A441999'
G[10329]='K0680 L067 A:19468 T:19468 P:10193'
G[10330]='K0690 L067 A:19840 T:19840 P:10198'
G[10331]='K0690 L067 A:20463 T:20463'
G[10332]='K0690 L067 A:20463 T:20463 P:10331'
G[10333]='K0690 L067 A:19645 T:19728'
G[10334]='K0690 L067 A:20464 T:20415'
G[10335]='K0700 L068 A:20470 T:20470'
G[10336]='K0700 L068 A:20471 T:20471'
G[10337]='K069512 L067 A:20415 T:20464'	-- PM2
G[10338]='K0700 L067 A:19468 T:19468 P:10200'
G[10339]='K0700 L070 A:20448 T:20482'
G[10340]='FA K0600 L058 A:19310 T:20234 P:10146'
G[10341]='K0700 L067 A:19469 T:19469 P:10330+T3A641999'
G[10342]='K0680 L067 A:19617 T:19617'
G[10343]='K0690 L067 A:19489 T:19489'
G[10344]='FA K0600 L058 A:20234 T:20232 P:10340'
G[10345]='K0700 L068 A:20551 T:20551'
G[10346]='FA K0621 L058 A:20235 T:20235 P:10163'
G[10347]='FH K0621 L058 A:19401 T:19401'
G[10348]='K0690 L067 A:20810 T:20810'
G[10349]='K0630 L061 A:19293 T:19294 P:10134'
G[10350]='FA K0100 L010 CW A:17480 T:17120 P:9582'
G[10351]='K0630 L061 A:19294 T:19294 P:10349'
G[10353]='K0700 L068 A:20552 T:20448'
G[10355]='FA K0620 L060 A:18007 T:18007 P:9827'
G[10365]='K070512 L067 A:19468 T:19468 P:10338'	-- PM3
G[10367]='K0620 L060 A:19361 T:19361 O:10403'
G[10368]='K0620 L060 A:19361 T:19361 P:10367'
G[10369]='K0620 L060 A:19361 T:19361 P:10368'
G[10380]='K0700 L067 A:20780 T:20780 P:10431'
G[10381]='K0700 L067 A:20780 T:19466 P:10380'
G[10382]='FA K0610 L058 A:20232 T:20793 P:10163'
G[10384]='K0700 L068 A:20482 T:20482 P:10339'
G[10385]='K0700 L068 A:20482 T:20482 P:10384'
G[10388]='FH K0610 L058 A:16576,19273 T:3230'
G[10389]='FH K0610 L058 A:21175 T:21175'
G[10390]='FH K0610 L058 A:3230 T:3230 P:10388'
G[10391]='FH K0610 L058 A:3230 T:3230 P:10390'
G[10392]='FH K0610 L058 A:3230 T:3230 P:10391'
G[10393]='FH K0610 L058 A:100029590 T:21175'
G[10394]='FA K0610 L058 A:20793 T:20793 P:10382'
G[10395]='FA K0610 L058 A:100029588 T:16839'
G[10396]='FA K0610 L058 A:20793 T:20793 P:10394'
G[10397]='FA K0610 L058 A:20793 T:20793 P:10396'
G[10399]='FA K0610 L058 A:16839 T:16839 P:10395'
G[10400]='FA K0630 L058 A:16819 T:16819 P:10395'
G[10403]='K0620 L060 A:20677,20678,20679 T:19361'
G[10405]='K0700 L068 A:20482 T:20482 P:10385'
G[10406]='K0700 L068 A:20482 T:20482 P:10405'
G[10407]='K070512 L067 A:19467 T:19467 P:T3A441999'	-- PM2
G[10408]='K070512 L068 A:20482 T:20482 P:10406'	-- PM5
G[10409]='K070512 L067 A:18538 T:18538 P:10410'	-- TODO: G55|Prerequisites| PM5
G[10410]='K0700 L067 A:19467 T:18538 P:10407'
G[10411]='K0700 L068 A:20449 T:20449'
G[10412]='K0650 L062 A:18531 T:18531 P:T3A641999+U3A650999+10551|10552'
G[10414]='K0701 L064 A:18531 T:18531 P:10412+T3A641999+U3A650999'
G[10415]='K0701 L064 A:18531 T:18531 P:10412+T3A641999+U3A650999'
G[10416]='K0700 L064 A:18530 T:18530 P:T3A641999'
G[10417]='K0680 L067 A:20810 T:20810'
G[10418]='K0680 L067 A:20810 T:20810 P:10417'
G[10419]='K0701 L064 A:18530 T:18530 P:10416+T3A641999'
G[10420]='K0700 L064 A:18538 T:18538 P:T3A441999'
G[10421]='SP K0701 L064 A:18538 T:18538 P:10420+T3A441999'
G[10422]='K0700 L068 A:20450 T:20450'
G[10423]='K0690 L067 A:20810 T:20811 P:10418'
G[10424]='K0690 L067 A:20811 T:20811 P:10423'
G[10425]='K0700 L068 A:20763 T:20448'
G[10426]='K0690 L067 A:20871 T:20871'
G[10427]='K0690 L067 A:20871 T:20871 P:10426'
G[10428]='FA K0100 L008 A:17488 T:17311'
G[10429]='K0690 L067 A:20871 T:20871 P:10427'
G[10430]='K0690 L067 A:20811 T:20913 P:10424'
G[10431]='K0700 L067 A:19466 T:20780 P:10328'
G[10432]='K0700 L067 A:20920 T:19468 P:10202'
G[10433]='K0690 L067 A:20921 T:20921'
G[10434]='K0690 L067 A:20921 T:20205 P:10433'
G[10435]='K0690 L067 A:20205 T:20205 P:10434'
G[10436]='K0690 L067 A:20913 T:20913 P:10430'
G[10437]='K0700 L068 A:20907 T:20907'
G[10438]='K0700 L068 A:20907 T:20907 P:10437'
G[10439]='K070512 L068 A:20907 T:20907 P:10438'	-- PM5
G[10440]='K0690 L067 A:20913 T:20811 P:10436'
G[10442]='FH K0610 L061 A:16790 T:16991'
G[10443]='FA K0610 L061 A:16796 T:16991'
G[10444]='FA K0640 L062 A:18459 T:21006 P:9994'
G[10446]='FA K0650 L062 A:21006 T:18459 P:9996'
G[10447]='FH K0650 L062 A:21007 T:18447 P:9997'
G[10448]='FH K0640 L062 A:18447 T:21007 P:9995'
G[10449]='FH K0600 L058 A:21256 T:21257 P:10450'
G[10450]='FH K0600 L058 A:21256 T:21256'
G[10451]='K070512 L068 A:21027 T:21024'	-- PM2
G[10455]='FA K0660 L065 A:21066 T:21066'
G[10456]='FA K0660 L065 A:21066 T:21066 P:10455'
G[10457]='FA K0660 L065 A:21066 T:21066 P:10456'
G[10458]='K0700 L068 A:21024 T:21024 P:10680,10681'
G[10460]='K0700 L070 A:19936 T:19935 TA:19936 P:1'
G[10461]='SP K0700 L070 A:19935 T:19935 P:1'
G[10462]='K0700 L070 A:19935 T:19935 P:1'
G[10463]='SP K0700 L070 A:19936 T:19935 TA:19936 P:1'
G[10464]='K0700 L070 A:19935,19936 T:19935 P:1'
G[10465]='K0700 L070 A:19935 T:19935 P:1'
G[10466]='K0700 L070 A:19935 AH:19936 T:19935 P:1'
G[10467]='K0700 L070 A:19935 AA:19936 T:19935 P:1'
G[10468]='K0700 L070 A:19935 AA:19936 T:19935 P:10464'
G[10469]='K0700 L070 A:19935 T:19935 P:10465'
G[10470]='K0700 L070 A:19935 AH:19936 T:19935 P:10466'
G[10471]='K0700 L070 A:19935 T:19935 P:10467'
G[10472]='K0700 L070 A:19935 AH:19936 T:19935 P:10468'
G[10473]='K0700 L070 A:19935 T:19935 P:10469'
G[10474]='K0700 L070 A:19935 T:19935 P:10470'
G[10475]='K0700 L070 A:19935 T:19935 P:10471'
G[10476]='FA K0670 L065 A:18408 T:18408 P:T3D241999'
G[10477]='FA K0681 L065 A:18408 T:18408'
G[10478]='FH K0681 L065 A:18407 T:18407'
G[10479]='FH K0670 L065 A:18407 T:18407'
G[10480]='K0700 L068 A:21024 T:21024 P:10458'
G[10481]='K0700 L068 A:21024 T:21024 P:10480'
G[10482]='FA K0580 L058 A:16820 T:16820 O:10160'
G[10483]='FA K0580 L058 A:16820 T:21133 P:10482'
G[10484]='FA K0580 L058 A:21133 T:21133 P:10483'
G[10485]='FA K0600 L058 A:21133 T:21133 P:10484'
G[10486]='FH K0660 L065 A:21117 T:21117'
G[10487]='FH K0660 L065 A:21117 T:21117 P:10486'
G[10488]='FH K0660 L065 A:21117 T:21117 P:10487'
G[10489]='FH K0660 L065 A:1184660 T:21147'
G[10502]='FA K0660 L065 A:21158 T:21158'
G[10503]='FH K0660 L065 A:21147 T:21147'
G[10504]='FA K0660 L065 A:21158 T:21158 P:10502'
G[10505]='FH K0660 L065 A:21147 T:21147 P:10503'
G[10506]='FA K0660 L065 A:21066 T:21066 P:10457'
G[10507]='K070512 L067 A:18530 T:18530 P:10509'	-- PM5
G[10508]='K070512 L067 A:19468 T:19468 P:10432'	-- PM2
G[10509]='K0700 L067 A:19468 T:18530 P:10508'
G[10510]='FA K0660 L065 A:21197 T:21197'
G[10511]='FA K0660 L065 A:21151 T:21151'
G[10512]='FA K0660 L065 A:21151 T:21151'
G[10513]='K0700 L068 A:21024 T:21183 P:10481'
G[10514]='K0700 L068 A:21183 T:21183 P:10513'
G[10515]='K0700 L068 A:21183 T:21183 P:10514'
G[10516]='FA K0660 L065 A:21277 T:21277'
G[10517]='FA K0670 L065 A:21277 T:21277 P:10516'
G[10518]='FA K0670 L065 A:21277 T:21158 P:10517'
G[10519]='K0700 L068 A:21183 T:21183 P:10515'
G[10521]='K0700 L068 A:21183 T:21291'
G[10522]='K0700 L068 A:21291 T:21291 P:10521'
G[10523]='K0700 L068 A:21291 T:21183 P:10522'
G[10524]='FH K0660 L065 A:100030431 T:21311'
G[10525]='FH K0660 L065 A:21311 T:21311 P:10524'
G[10526]='FH K0670 L065 A:21311 T:21311 P:10525'
G[10527]='K0700 L068 A:21183 T:21292'
G[10528]='K0700 L068 A:21292 T:21292 P:10527'
G[10537]='K0700 L068 A:21318 T:21318'
G[10538]='FH K0600 L058 A:21279 T:21279'
G[10540]='K0700 L068 A:21318 T:21318 P:10537'
G[10541]='K0700 L068 A:21318 T:21183 P:10540'
G[10542]='FH K0660 L065 A:21349 T:21349'
G[10543]='FH K0670 L065 A:21349 T:21349 P:10545'
G[10544]='FH K0660 L065 A:21349 T:21349 P:10543'
G[10545]='FH K0660 L065 A:21349 T:21349 P:10542'
G[10546]='K0700 L068 A:21183 T:21293'
G[10547]='K0700 L068 A:21293 T:21411 P:10546'
G[10550]='K0700 L068 A:21411 T:21293 P:10547'
G[10551]='SP K0650 L060 A:18166 T:18166 P:10211'	-- TODO: This and 10552 are I: to each other, but we want to ensure we can record which one was completed because Blizzard records both done when one is done
G[10552]='SP K0650 L060 A:18166 T:18166 P:10211'	-- TODO:  See 10551
G[10553]='K0650 L060 A:18166 T:18530 P:10552+T3A641999'
G[10554]='K0650 L060 A:18166 T:18538 P:10551+T3A441999'
G[10555]='FA K0660 L065 A:21469 T:1184825'
G[10556]='FA K0660 L065 A:1184825 T:21469 P:10555'
G[10557]='FA K0640 L062 A:21460 T:21460'
G[10562]='FA K0690 L067 A:21357 T:21357 P:11044'
G[10563]='FA K0690 L067 A:21357 T:21357 P:10562'
G[10564]='FA K0690 L067 A:21357 T:21357 P:10572'
G[10565]='FH K0660 L061 A:21496 T:21496'
G[10566]='FH K0660 L061 A:21496 T:21496 P:10565'
G[10567]='K0660 L066 A:21782 T:21782'
G[10568]='K0700 L068 A:21402 T:21402'
G[10569]='FA K0690 L067 A:22042 T:22042'
G[10570]='K0700 L068 A:21293 T:21293 P:10550'
G[10571]='K0700 L068 A:21402 T:21402 P:10568,10683'
G[10572]='FA K0690 L067 A:21357 T:21357 P:10563'
G[10573]='FA K0690 L067 A:21357 T:21471 P:10564'
G[10574]='K0700 L068 A:21402 T:21402 P:10571,10684'
G[10575]='K0700 L068 A:21402 T:21826 P:10574,10685'
G[10576]='K0700 L068 A:21293 T:21293 P:10570'
G[10577]='K0700 L068 A:21293 T:21293 P:10576'
G[10578]='K070512 L068 A:21293 T:21293 P:10577'	-- PM4
G[10579]='K0700 L068 A:21293 T:21183 P:10578'
G[10580]='FA K0670 L065 A:21158 T:21690'
G[10581]='FA K0670 L065 A:21690 T:21691 P:10580'
G[10582]='FA K0690 L067 A:21471 T:21471 P:10573'
G[10583]='FA K0690 L067 A:21471 T:21471'
G[10584]='FA K0670 L065 A:21691 T:21691'
G[10585]='FA K0690 L067 A:21471 T:21471'
G[10586]='FA K0690 L067 A:21471 T:21357'
G[10587]='K0700 L068 A:21860 T:21860 P:T3A444999'
G[10588]='K070512 L068 A:21183 T:21024'	-- PM5
G[10589]='FA K0690 L067 A:21357 T:21357 P:10586'
G[10594]='FA K0670 L065 A:21755 T:21755 P:10608'
G[10595]='FH K0690 L067 A:21359 T:21359 O:11048'
G[10596]='FH K0690 L067 A:21359 T:21359 P:10595'
G[10597]='FH K0690 L067 A:21359 T:21359 P:10596'
G[10598]='FH K0690 L067 A:21359 T:21359 P:10597'
G[10599]='FH K0690 L067 A:21359 T:21475 P:10598'
G[10600]='FH K0690 L067 A:21475 T:21475 P:10599'
G[10601]='FH K0690 L067 A:21475 T:21475'
G[10602]='FH K0690 L067 A:21475 T:21475'
G[10603]='FH K0690 L067 A:21475 T:21359'
G[10604]='FH K0690 L067 A:21359 T:21359 P:10603'
G[10606]='FA K0690 L067 A:21790 T:21790 P:10766'
G[10607]='K0680 L066 A:21782 T:21782 P:10567'
G[10608]='FA K0670 L065 A:21755 T:21755'
G[10609]='FA K0670 L065 A:21110 T:21110'
G[10611]='FH K0690 L067 A:21789 T:21789 P:10767'
G[10612]='FA K0690 L067 A:21790 T:21790 P:10606'
G[10613]='FH K0690 L067 A:21789 T:21789 P:10611'
G[10614]='FH K0660 L065 A:21984 T:22004 P:10718'
G[10615]='FH K0640 L061 A:21496 T:21782 P:10566'
G[10617]='FH K0660 L061 A:21895 T:21895'
G[10618]='FH K0650 L061 A:21896 T:21896'
G[10619]='K0700 L068 A:21822 T:21822'
G[10620]='FA K0670 L065 A:21824 T:21824'
G[10621]='FA K0690 L067 A:100030756 T:19370'
G[10622]='K0700 L068 A:21826 T:21826 P:10575,10686'
G[10623]='FH K0690 L067 A:100030579 T:19333'
G[10624]='FH K0690 L067 A:21772 T:21772 P:11046'
G[10625]='FH K0690 L067 A:21772 T:21772 P:10624'
G[10626]='FA K069512 L067 A:19370 T:19370 P:10621'	-- PM3
G[10627]='FH K069512 L067 A:19333 T:19333 P:10623'	-- PM3
G[10628]='K0700 L068 A:21826 T:21700 P:10622'
G[10629]='K0610 L058 A:16915 T:16915 P:10238'
G[10630]='K0610 L058 A:16915 T:16915 P:10629'
G[10632]='FA K0670 L065 A:21118 T:21118'
G[10633]='FH K0700 L067 A:21772 T:21797 P:10625'
G[10634]='K070512 L067 A:21797 T:21797'	-- PM5
G[10635]='K0700 L067 A:21797 T:21797'
G[10636]='K070512 L067 A:21797 T:21797'	-- PM2
G[10637]='K0700 L068 A:21860 T:21860 P:10587'
G[10639]='FH K0700 L067 A:21797 T:21772'
G[10640]='K0700 L068 A:21860 T:18417 P:10637'
G[10641]='K0700 L068 A:18417 T:18417 P:10640,10689'
G[10642]='FA K0690 L067 A:21774 T:21774 P:11045'
G[10643]='FA K0690 L067 A:21774 T:21774 P:10642'
G[10644]='FA K0700 L067 A:21774 T:21797 P:10643'
G[10645]='FA K0700 L067 A:21797 T:21774'
G[10646]='K0700 L068 A:18417 T:18417 P:10641+10668+10669'
G[10647]='FH K070512 L067 A:1184945 T:21771'	-- PM4
G[10648]='FA K070512 L067 A:1184946 T:21775'	-- PM4
G[10649]='K07064 L068 A:18417 T:18417 P:10646'
G[10650]='K0700 L068 A:18417 T:21860 P:10649+T3A444999'
G[10651]='K070512 L068 A:21860 T:21860 P:10650'	-- PM5
G[10652]='K0690 L067 A:20162 T:19840 P:10194'
G[10653]='K0700 L068 A:18537 T:18537 P:T3A441999+U3A483999+10551|10552'
G[10654]='SP K0701 L068 A:18537 T:18537 P:10653+T3A441999+U3A483999'
G[10655]='SP K0701 L068 A:18537 T:18537 P:10653+T3A441999+U3A483999'
G[10656]='K0700 L068 A:18531 T:18531 P:T3A641999+U3A683999+10551|10552 I:10824'
G[10657]='FA K0670 L065 A:21691 T:21691 P:10584'
G[10658]='K0701 L068 A:18531 T:18531 P:T3A641999+U3A683999+10656|10824'
G[10659]='K0701 L068 A:18531 T:18531 P:T3A641999+U3A683999+10656|10824'
G[10660]='FH K0690 L067 A:21770 T:21770'
G[10661]='FA K0690 L067 A:21777 T:21777'
G[10662]='FA K0690 L067 A:19370 T:21465 P:10626'
G[10663]='FH K0690 L067 A:19333 T:21465 P:10627'
G[10664]='K0690 L067 A:21465 T:21465 P:10662,10663'
G[10665]='K06964 L067 A:21465 T:21465 P:10664'
G[10666]='K06964 L067 A:21465 T:21465 P:10664'
G[10667]='K07064 L067 A:21465 T:21465 P:10665+10666'
G[10668]='K0700 L068 A:18417 T:18417 P:10640,10689'
G[10669]='K0700 L068 A:18417 T:18417 P:10640,10689'
G[10670]='K07064 L067 A:21465 T:21465 P:10665+10666'
G[10671]='FA K0670 L065 A:21824 T:21824'
G[10672]='FH K0690 L067 A:21770 T:21770 P:10660'
G[10673]='FH K0700 L067 A:21770 T:21770 P:10672'
G[10674]='FA K0670 L065 A:21691 T:21691 P:10657'
G[10675]='FA K0680 L065 A:21691 T:21691 P:10674'
G[10676]='K0700 L067 A:21465 T:21465 P:10667+10670'
G[10677]='FA K0690 L067 A:21777 T:21777 P:10661'
G[10678]='FA K0700 L067 A:21777 T:21777 P:10677'
G[10679]='K0700 L067 A:21465 T:21465 P:10676'
G[10680]='FA K0700 L068 A:21937 T:21024'
G[10681]='FH K0700 L068 A:21938 T:21024 P:10680'
G[10682]='K0670 L065 A:22007 T:22007'
G[10683]='K0700 L068 A:21955 T:21955 P:10568'
G[10684]='K0700 L068 A:21955 T:21955 P:10571'
G[10685]='K0700 L068 A:21955 T:21955 P:10574'
G[10686]='K0700 L068 A:21955 T:21826 P:10575'
G[10687]='K0700 L068 A:21954 T:21954 P:T3A644999'
G[10688]='K0700 L068 A:21954 T:21954 P:10687'
G[10689]='K0700 L068 A:21954 T:18417 P:10688'
G[10690]='FA K0660 L065 A:1185035 T:21158'
G[10691]='K0700 L068 A:18417 T:21954 P:10649+T3A644999'
G[10692]='K070512 L068 A:21954 T:21954 P:10691'	-- PM5
G[10701]='K068512 L067 A:1183811 T:19570'	-- PM2
G[10702]='FH K0690 L067 A:21769 T:21769'
G[10703]='FA K0690 L067 A:21773 T:21773'
G[10704]='K0700 L067 A:18481 T:18481 P:10280'
G[10705]='K0700 L068 A:21700 T:21962 P:10628'
G[10706]='K0700 L068 A:21962 T:21700 P:10705'
G[10707]='K070512 L068 A:21700 T:21700 P:10706'	-- PM5
G[10709]='FH K0670 L065 A:22004 T:21984 P:10614'
G[10710]='FA K0640 L062 A:21460 T:21460 P:10557'
G[10711]='FA K0640 L062 A:21460 T:21460'
G[10712]='FA K0640 L062 A:21460 T:22020'
G[10713]='K0670 L065 A:22007 T:22007 P:10682'
G[10714]='FH K0670 L065 A:21984 T:21984 P:10709'
G[10715]='FH K0670 L065 A:22103 T:22103 P:10783'
G[10717]='K0670 L065 A:21983 T:21983 P:B10713'
G[10718]='FH K0670 L065 A:21950 T:21984 P:10526'
G[10719]='K0670 L065 A:100031120 T:22007'
G[10720]='FH K0670 L065 A:21984 T:21984 P:10749'
G[10721]='FH K0670 L065 A:21984 T:22103 P:10720'
G[10722]='K0680 L065 A:22386 T:22007 P:10893'
G[10723]='FH K0680 L065 A:21984 T:21984 P:10785'
G[10724]='FH K0670 L065 A:21984 T:21984 P:10723'
G[10725]='K0700 L070 A:18253 T:18253 P:10738'
G[10726]='K0700 L070 A:18253 T:18253 P:10739'
G[10727]='K0700 L070 A:18253 T:18253 P:10740'
G[10728]='K0700 L070 A:18253 T:18253 P:10741'
G[10729]='K0700 L070 A:18253 T:18253'
G[10730]='K0700 L070 A:18253 T:18253'
G[10731]='K0700 L070 A:18253 T:18253'
G[10732]='K0700 L070 A:18253 T:18253'
G[10733]='K0700 L070 A:18253 T:18253 P:10729'
G[10734]='K0700 L070 A:18253 T:18253 P:10730'
G[10735]='K0700 L070 A:18253 T:18253 P:10731'
G[10736]='K0700 L070 A:18253 T:18253 P:10732'
G[10738]='K0700 L070 A:18253 T:18253 P:10733'
G[10739]='K0700 L070 A:18253 T:18253 P:10734'
G[10740]='K0700 L070 A:18253 T:18253 P:10735'
G[10741]='K0700 L070 A:18253 T:18253 P:10736'
G[10742]='FH K0700 L065 A:21984 T:21984 P:10724'
G[10744]='FA K0700 L067 A:21790 T:21330 P:10612'
G[10745]='FH K0700 L067 A:21789 T:21769 P:10613'
G[10747]='K0680 L065 A:21983 T:21983 P:10717'
G[10748]='K0680 L065 A:22007 T:22007 P:10722'
G[10749]='FH K0670 L065 A:22103 T:21984'
G[10750]='FH K070512 L068 A:21769 T:21998'	-- PM3
G[10751]='FH K070512 L068 A:21998 T:21998 P:10750'	-- PM3
G[10753]='K0670 L065 A:22133 T:22133'
G[10759]='FA K0690 L067 A:22042 T:22024 P:10569,10760'
G[10760]='FH K0690 L067 A:22043 T:22043 P:10569'
G[10761]='FH K0690 L067 A:22043 T:22024 P:10759'
G[10765]='FH K070512 L068 A:21998 T:21998 P:10751'	-- PM3
G[10766]='FA K0690 L067 A:21357 T:21790 P:10589'
G[10767]='FH K0690 L067 A:21359 T:21789 P:10604'
G[10768]='FH K070512 L068 A:21998 T:21998 P:10765'	-- PM3
G[10769]='FH K070512 L068 A:21998 T:21769 P:10768'	-- PM3
G[10770]='K0670 L065 A:22053 T:22053'
G[10771]='K0670 L065 A:22053 T:22053'
G[10772]='FA K070512 L068 A:21773 T:22059'	-- PM3
G[10773]='FA K070512 L068 A:22059 T:22059 P:10772'	-- PM3
G[10774]='FA K070512 L068 A:22059 T:22059 P:10773'	-- PM3
G[10775]='FA K070512 L068 A:22059 T:22059 P:10774'	-- PM3
G[10776]='FA K070512 L068 A:22059 T:21773 P:10775'	-- PM3
G[10777]='K0690 L067 A:22024 T:22024 P:10759,10761'
G[10778]='K0690 L067 A:22024 T:22024 P:10777'
G[10780]='K0690 L067 A:22024 T:22024 P:10778'
G[10781]='K070512 L068 A:1185126 T:18481 P:10793'	-- PM5
G[10782]='K0690 L067 A:22024 T:22024 P:10780'
G[10783]='FH K0670 L062 A:21984 T:22103 P:10714'
G[10784]='FH K0670 L065 A:21147 T:21147'
G[10785]='FH K0670 L065 A:22103 T:21984 P:10721'
G[10786]='FH K0680 L065 A:21147 T:21147'
G[10791]='FH K0640 L062 A:18384 T:18384 P:10023'
G[10792]='FH K0610 L058 A:22107 T:22107'
G[10793]='K070512 L068 A:100031345 T:1185126'	-- PM4
G[10795]='FA K0670 L065 A:22149 T:22149'
G[10796]='FA K0670 L065 A:22150 T:22150'
G[10797]='FA K0670 L065 A:100031363 T:22149'
G[10798]='FA K0670 L065 A:22149 T:22103 P:10797'
G[10799]='FA K0670 L065 A:22103 T:22103 P:10798'
G[10800]='FA K0670 L065 A:22103 T:22103 P:10799'
G[10801]='FA K0670 L065 A:22103 T:22149 P:10800'
G[10802]='FA K0680 L065 A:22149 T:22149 P:10801'
G[10803]='FA K0680 L065 A:22150 T:22150'
G[10804]='K0700 L070 A:22113 T:22113'
G[10805]='FA K0670 L065 A:22103 T:22103 P:10818'
G[10806]='FA K0700 L065 A:22103 T:22103 P:10805'
G[10807]='K0700 L068 A:21953 T:21953'
G[10808]='K0690 L067 A:22024 T:22024 P:10782'
G[10809]='FH K0600 L058 A:1185166 T:22107'
G[10810]='K0680 L065 A:100031384 T:22020'
G[10811]='K0700 L070 A:22113 T:21657 P:10804'
G[10812]='K0680 L065 A:22020 T:22127 P:10810'	-- TODO: G55|Prerequisites|
G[10813]='FH K0620 L058 A:22231 T:22231'
G[10814]='K0700 L070 A:21657 T:21657 P:10811'
G[10816]='K0700 L068 A:21822 T:21822 P:10619'
G[10817]='K0700 L068 A:21953 T:21953 P:10807'
G[10818]='FA K0670 L065 A:22149 T:22103 P:10802'
G[10819]='K0680 L065 A:22127 T:1185165 P:10812'
G[10820]='K0680 L065 A:1185165 T:1185165 P:10819'
G[10821]='K0680 L065 A:1185165 T:22127 P:10820'
G[10822]='K0701 L068 A:22211 T:22211 P:T3A641999+U3A683999+10656|10824'
G[10823]='K0701 L068 A:22211 T:22211 P:T3A641999+U3A683999+10656|10824'
G[10824]='K0700 L068 A:22211 T:22211 P:T3A641999+U3A683999+10551|10552 I:10656'
G[10825]='K0680 L065 A:100031489 T:22007'
G[10826]='K0700 L068 A:22214 T:22214 P:T3A441999+U3A483999+10551|10552'
G[10827]='SP K0701 L068 A:22214 T:22214 P:10826+T3A441999+U3A483999'
G[10828]='SP K0701 L068 A:22214 T:22214 P:10826+T3A441999+U3A483999'
G[10829]='K0680 L065 A:22007 T:22215 P:10825'
G[10830]='K0680 L065 A:22215 T:22215 P:10829'
G[10834]='FH K0620 L058 A:22231 T:22231 P:10813'
G[10835]='FH K0610 L058 A:21279 T:16588 P:10538'
G[10836]='K0700 L070 A:21657 T:21657 P:10814'
G[10837]='K0700 L070 A:21657 T:21657 P:10836'
G[10838]='FH K0610 L058 A:16588 T:16588 P:10864'
G[10839]='K0640 L062 A:22272 T:22272 P:10849'
G[10840]='K0650 L063 A:22278 T:22278 P:10852'
G[10842]='K0650 L063 A:22278 T:22278 P:10852'
G[10843]='FH K0680 L065 A:22004 T:22004 P:10846'
G[10845]='FH K0680 L065 A:22004 T:22004 P:10843'
G[10846]='FH K0670 L065 A:22004 T:22004 P:10565'
G[10847]='K0620 L062 A:22292 T:22292 O:10862,10863,10908'
G[10848]='K0640 L062 A:22272 T:22272 P:10839'
G[10849]='K0630 L062 A:22292 T:22272 P:10847'
G[10850]='K0701 L067 A:22293 T:22293'
G[10851]='FH K0670 L065 A:22312 T:22312 P:10846'
G[10852]='K0640 L062 A:22365 T:22365 P:10849'
G[10853]='FH K0670 L065 A:22312 T:22312 P:10851'
G[10854]='K0700 L070 A:21657 T:21657 P:10837'
G[10855]='K0690 L067 A:20471 T:20471'
G[10856]='K0690 L067 A:20471 T:20471 P:10855'
G[10857]='K0690 L067 A:20471 T:20471 P:10856'
G[10858]='K070512 L070 A:21657 T:22112 P:10854'	-- PM5
G[10859]='FH K0670 L065 A:22312 T:22312 P:10853'
G[10860]='FH K0670 L065 A:21088 T:21088'
G[10861]='K0640 L062 A:22272 T:22272 P:10848'
G[10862]='FH K0630 L062 A:18386 T:22292 I:10863,10908'
G[10863]='FA K0630 L062 A:15991 T:22292 I:10862,10908'
G[10864]='FH K0610 L058 A:16588 T:16588 P:10835'
G[10865]='FH K0680 L065 A:22312 T:22004 P:10859'
G[10866]='K070512 L070 A:22112 T:22112 P:10858'	-- PM5
G[10867]='FH K0680 L065 A:22004 T:22312 P:10865'
G[10868]='FH K0620 L060 A:18712 T:18712'
G[10869]='FA K0620 L060 A:18713 T:18713'
G[10870]='K0700 L070 A:22112 T:22113 P:10866'
G[10871]='FA K0700 L070 A:22112 T:22113'
G[10872]='FA K070512 L070 A:22112 T:22112'	-- PM5
G[10873]='K0650 L063 A:22364 T:22364'
G[10874]='K0650 L062 A:22272 T:22272 P:10861'
G[10875]='FH K0610 L058 A:16588 T:3230 P:10838'
G[10876]='FH K0630 L058 A:3230 T:3230 P:10875'
G[10877]='K0660 L063 A:22456 T:22456'
G[10878]='K0630 L062 A:22370 T:22370'
G[10879]='K0650 L062 A:22373 T:22292 P:10889'
G[10880]='K0640 L062 A:100031707 T:22370'
G[10881]='K0640 L062 A:22370 T:22370 P:10880'
G[10882]='K0700 L067 A:18481 T:18481 P:10704 Z15211'
G[10883]='K0700 L070 A:18166 T:18481 P:10588'
G[10884]='K07064 L070 A:18481 T:18481 P:10588'
G[10885]='K07064 L070 A:18481 T:18481 P:10588'
G[10886]='K07064 L070 A:18481 T:18481 P:10588'
G[10887]='K0640 L062 A:22377 T:22370'
G[10889]='K0650 L062 A:22272 T:22292 P:10874'
G[10893]='K0670 L065 A:22386 T:22386 P:10894'
G[10894]='K0670 L065 A:22007 T:22386'
G[10895]='FA K0600 L058 A:19409 T:19409'
G[10896]='K0650 L062 A:22420 T:22420'
G[10898]='K0650 L063 A:22424 T:22292'
G[10900]='FH K0700 L070 A:22421 T:22421'
G[10903]='FA K0610 L058 A:21133 T:22430 P:10485'
G[10904]='K0680 L065 A:22423 T:22423 P:10910'
G[10908]='K0630 L062 A:22272 T:22292 I:10862,10863'
G[10909]='FA K0610 L058 A:22430 T:22430 P:10903'
G[10910]='K0680 L065 A:22127 T:22423 P:10821'
G[10911]='K0680 L065 A:22423 T:22423 P:10904'
G[10912]='K0680 L065 A:22423 T:22127 P:10911'
G[10913]='K0650 L063 A:22446 T:22446'
G[10914]='K0650 L063 A:22446 T:22446 P:10913'
G[10915]='K0650 L063 A:22446 T:22446 P:10914'
G[10916]='FA K0610 L058 A:22430 T:22430 P:10903'
G[10917]='K0650 L062 A:22429 T:22429'
G[10918]='K0651 L062 A:22429 T:22429 P:10917'
G[10919]='SP FA K0611 L001 A:20206 T:20206 P:B10916'
G[10920]='K0650 L063 A:22462 T:22462'
G[10921]='K0650 L063 A:22462 T:22462 P:10920'
G[10922]='K0650 L063 A:22458 T:22481'
G[10923]='K0650 L063 A:22456 T:22456 P:10877'
G[10924]='K0690 L067 A:22479 T:22479'
G[10926]='K0650 L063 A:22462 T:22364 P:10921'
G[10927]='FA K0650 L065 A:22488 T:21158'
G[10928]='FH K0650 L065 A:22489 T:21147'
G[10929]='K0650 L063 A:22481 T:22481 P:10922'
G[10930]='K0650 L063 A:22481 T:22481 P:10929'
G[10935]='FA K0610 L058 A:22430 T:22430 P:10909+10916'
G[10936]='FA K0610 L058 A:22430 T:16819 P:10935'
G[10937]='FA K0620 L058 A:16819 T:16819 P:10936'
G[10938]='K0700 L001 A:100031890 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10939]='K0700 L001 A:100031891 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10940]='K0700 L001 A:100031907 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10941]='K0700 L001 A:100031914 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10942]='HC FH K0000 L060 A:22819 T:22914'
G[10943]='HC FA K0000 L060 A:22819 T:22818'
G[10944]='K0700 L070 A:22820 T:21700'
G[10945]='HC FH K0000 L060 A:22914 T:22823 P:10942'
G[10946]='K0700 L070 A:21700 T:21700 P:10944'
G[10947]='K0700 L070 A:21700 T:21700 P:10946'
G[10948]='K0700 L070 A:21700 T:18481 P:10947'
G[10949]='K0700 L070 A:18481 T:18528 P:10948'
G[10950]='HC FA K0000 L060 A:22818 T:22818 P:10943'
G[10951]='HC FH K0000 L060 A:22914 T:22914 P:10942'
G[10952]='HC FA K0000 L060 A:22818 T:500013 P:10943'
G[10953]='HC FH K0000 L060 A:22914 T:18072 P:10942'
G[10954]='HC FA K0000 L060 A:22818 T:22836 P:10943'
G[10956]='HC FA K0000 L060 A:22818 T:17538 P:10950+10952+10954'
G[10957]='K0700 L070 A:23158 T:23158 P:10958'
G[10958]='K0700 L070 A:18528 T:23158 P:10985,13429'
G[10959]='K0700 L070 A:23158 T:23158 P:10957'
G[10962]='HC FA K0000 L060 A:22818 T:500014 P:10950+10952+10954'
G[10963]='HC FH K0000 L060 A:22914 T:22914 P:10945+10953+10951'
G[10966]='HC FA K0000 L060 A:22818 T:22819 P:10968+10962'
G[10967]='HC FH K0000 L060 A:22914 T:22819 P:10963+11975'
G[10968]='HC FA K0000 L060 A:17538 T:17204 P:10956'
G[10969]='K0700 L070 A:22899 T:20448'
G[10970]='K0700 L070 A:20448 T:20448 O:10969'
G[10971]='K0700 L070 A:20448 T:20448'
G[10973]='K0700 L070 A:20448 T:20448'
G[10974]='K0700 L070 A:20448 T:22919 P:10973'
G[10975]='K0701 L070 A:22919 T:22919'
G[10976]='K0700 L070 A:22919 T:22919'
G[10977]='K0700 L070 A:22919 T:22919 P:10976'
G[10981]='K0701 L070 A:22919 T:22919'
G[10982]='K0700 L070 A:22919 T:22919'
G[10983]='K0700 L070 A:22940 T:22941 O:10984 I:10989'
G[10984]='K0700 L070 A:22497 T:22940'
G[10985]='K0700 L070 A:18528 T:18528 P:10949 I:13429'
G[10989]='K0700 L070 A:22995 T:22941 I:10983'
G[10995]='K0700 L070 A:22941 T:22941 P:10989'
G[10996]='K0700 L070 A:22941 T:22941 P:10989'
G[10997]='K0700 L070 A:22941 T:22941 P:10989'
G[10998]='K0700 L070 A:22941 T:22941 P:10995+10996+10997'	-- TODO: Verify requires 10995 10996
G[11000]='K0700 L070 A:22941 T:22941 P:10998'
G[11002]='FA K0700 L070 A:100032385 T:16819'
G[11003]='FH K0700 L070 A:100032386 T:3230'
G[11004]='K0700 L070 A:23042 T:23042'
G[11005]='K0700 L070 A:23038 T:23038 P:11004'
G[11006]='SP K0701 L070 A:23042 T:23042 P:11005'
G[11007]='K0700 L070 A:100032405 T:18481'
G[11008]='K0702 L070 A:23048 T:23048'
G[11009]='K0700 L070 A:22941 T:23233 P:11022'	-- TODO: G55|Invalidated, Prerequisites, Ancestor invalidated|
G[11010]='K0700 L070 A:23120 T:23120'
G[11012]='K0700 L070 A:22113 T:22113 P:T3F741999+PR300'
G[11013]='K0700 L070 A:22113 T:23139 P:11012'
G[11014]='K0700 L070 A:23139 T:23140 P:11013'
G[11015]='K0702 L070 A:23140 T:23140 P:T3F741999'
G[11016]='K0702 L070 A:23140 T:23140 P:T3F741999+PS350 I:11017,11018'
G[11017]='K0702 L070 A:23140 T:23140 P:T3F741999+PH350 I:11016,11018'
G[11018]='K0702 L070 A:23140 T:23140 P:T3F741999+PM350 I:11016,11017'
G[11019]='K0700 L070 A:23141 T:23141'
G[11020]='K0702 L070 A:23141 T:23141 P:11019+T3F741999'
G[11021]='K0700 L070 A:100032523 T:23038'
G[11022]='FA K070 L070 A:23053 T:22941 P:1'	-- this is not immediately available...no supplicant about
G[11023]='K0702 L070 A:23120 T:23120 P:11010,11102'
G[11024]='K0700 L070 A:23038 T:22292 P:11021'
G[11025]='K0700 L070 A:23233 T:23233'
G[11026]='K0700 L070 A:23253 T:23253 P:T40E50999'
G[11028]='K0700 L070 A:22292 T:23038 P:11024'
G[11029]='K0700 L070 A:23306 T:23306 P:11056'
G[11030]='K0700 L070 A:23316 T:23316'
G[11031]='K0701 L070 A:18253 T:18253'
G[11035]='K0702 L070 A:23141 T:23141 P:11019+T3F741999'
G[11036]='FH K0670 L067 A:19471 T:19570 I:10183,11037,11040,11042,1038,1039'
G[11037]='FH K0670 L067 A:23265 T:19570 I:10183,11036,11040,11042,1038,1039'
G[11038]='K0670 L067 A:23270,23271 T:19466 P:10551+T3A441999,10552+T3A441999 I:10183,11036,11037,11040,11042'
G[11039]='K0670 L067 A:23272,23273 T:19468 P:10551+T3A641999,10552+T3A641999 I:10183,11036,11037,11040,11042'
G[11040]='FA K0670 L067 A:21112 T:19570 I:10183,11036,11037,11042,1038,1039'
G[11041]='K070512 L070 A:100032621 T:23139 P:11014+T3F741999'	-- PM2
G[11042]='FA K0670 L067 A:23268 T:19570 P:T3D241999 I:10183,11036,11037,11040,1038,1039'
G[11043]='FA K0670 L067 A:21107 T:20510'
G[11044]='FA K0670 L067 A:23268 T:21357 P:T3D241999'
G[11045]='FA K0670 L067 A:19678 T:21774'
G[11046]='FH K0670 L067 A:19678 T:21772 I:11047,11048'
G[11047]='FH K0670 L067 A:23280 T:20494 I:11046,11048'
G[11048]='FH K0670 L067 A:18090 T:21359 I:11046,11047'
G[11049]='K0700 L070 A:23141 T:23141 P:11019+T3F741999'
G[11050]='K0701 L070 A:23141 T:23141 P:11049+T3F741999'
G[11051]='K0702 L070 A:23253 T:23253'
G[11052]='K0700 L068 A:21700 T:18481'
G[11053]='K0700 L070 A:23140 T:23139 P:T3F744999'
G[11054]='K0700 L070 A:23291 T:23291 P:11053+T3F744999'
G[11055]='K0702 L070 A:23291 T:23291 P:11054+T3F744999'
G[11056]='K0700 L070 A:23306 T:23306 P:11028'
G[11057]='K0700 L070 A:23233 T:22941'
G[11058]='K0700 L070 A:23233 T:23233 P:11025'
G[11059]='K0700 L070 A:23233 T:23233'
G[11060]='K0701 L070 A:23300 T:23300'
G[11061]='K0700 L070 A:23316 T:23316 P:11030'
G[11062]='K0700 L070 A:23233 T:23334'
G[11063]='K0700 L070 A:22433 T:22433 P:T3F750999'
G[11064]='K0700 L070 A:23340 T:22433 P:11063+T3F750999'
G[11065]='K0700 L070 A:23335 T:23335'
G[11066]='K0702 L070 A:23335 T:23335 P:11065'
G[11067]='K070 L070 A:23342 T:22433 P:11064+T3F750999'
G[11068]='K070 L070 A:23344 T:22433 P:11067+T3F750999'
G[11069]='K070 L070 A:23345 T:22433 P:11068+T3F750999'
G[11070]='K070 L070 A:23346 T:22433 P:11069+T3F750999'
G[11071]='K0700 L070 A:23348 T:22433 P:11070+T3F750999'
G[11072]='K070512 L070'
G[11073]='K070512 L070 A:23038 T:23038 P:11072'	-- PM5
G[11075]='K0700 L070 A:23140 T:23149 P:11053+T3F744999'
G[11076]='FA K0702 L070 A:23149 T:23149 P:11075+T3F744999'
G[11077]='K0702 L070 A:23376 T:23376 P:11075+T3F744999'
G[11078]='K0700 L070 A:23334 T:23334'
G[11079]='K0700 L070 A:23300 T:23300'
G[11080]='K0702 L070 A:23233 T:23233 P:11058'
G[11081]='K0700 L070 A:100032726 T:23149 P:11075+T3F744999'
G[11082]='K0700 L070 A:23149 T:23149 P:11081+T3F744999'
G[11083]='K0700 L070 A:23166 T:23166 P:11075+T3F744999'
G[11084]='K0700 L070 A:23140 T:23139+T3F750999'
G[11085]='K0702 L070 A:23383 T:23048'
G[11086]='K0702 L070 A:23139 T:23139 P:11084+T3F750999'
G[11089]='K0700 L070 A:23427 T:23427 P:T3F750999'
G[11090]='K0700 L070 A:23427 T:23427 P:11089+T3F750999'
G[11091]='K0700 L070 A:23233 T:23428 P:T40E44999'
G[11092]='K0700 L070 A:23140 T:23139 P:T3F762999'
G[11093]='K0700 L070 A:23415 T:23415'
G[11094]='K0700 L070 A:23139 T:21955 P:11092+T3F762999+T3A644999'
G[11095]='K070 L070 A:21955 T:23434 P:11094+T3F762999+T3A644999'
G[11096]='K0700 L070 A:23449 T:23449'
G[11097]='K070514 L070 A:23434 T:23139 P:11095+T3F762999+T3A644999'	-- PM3
G[11098]='K0700 L070 A:23449 T:23048 P:11096'
G[11099]='K0700 L070 A:23139 T:21402 P:11092+T3F762999+T3A444999'
G[11100]='K0700 L070 A:21402 T:23452 P:11099+T3F762999+T3A444999'
G[11101]='K070514 L070 A:23452 T:23139 P:11100+T3F762999+T3A444999'	-- PM3
G[11102]='K0700 L070 CD A:23120 T:23120 P:11010'
G[11103]='K0701 L070 A:19935 T:19935'
G[11104]='K0701 L070 A:19935 T:19935 P:10473'
G[11105]='K0701 L070 A:19935 T:19935'
G[11106]='K0701 L070 A:19935 T:19935'
G[11107]='K0700 L070 A:23140 T:23139 P:T3F783999'
G[11108]='K0700 L070 A:23139 T:23433 P:11107+T3F783999'
G[11109]='K0700 L070 A:23462 T:23462 P:11108+T3F783999 I:11110,11111,11112,11113,11114'
G[11110]='K0700 L070 A:23464 T:23464 P:11108+T3F783999 I:11109,11111,11112,11113,11114'
G[11111]='K0700 L070 A:23463 T:23463 P:11108+T3F783999 I:11109,11110,11112,11113,11114'
G[11112]='K0700 L070 A:23461 T:23461 P:11108+T3F783999 I:11109,11110,11111,11113,11114'
G[11113]='K0700 L070 A:23466 T:23466 P:11108+T3F783999 I:11109,11110,11111,11112,11114'
G[11114]='K0700 L070 A:23465 T:23465 P:11108+T3F783999 I:11109,11110,11111,11112,11113'
G[11117]='HB FA K00016 L001 A:23486 T:23486 I:11431'
G[11118]='HB FA K00016 L001 A:23486 T:23486'	-- note that this is not I: with 11120 for some reason
G[11119]='K0700 L070 A:23334 T:23473'
G[11120]='HB FH K00016 L001 A:24657 T:24657'
G[11122]='HB FA K0002 L001 A:23558 T:23558 P:11318'
G[11129]='FH K0070 L005 A:23618 T:23618'
G[11131]='HW FA K0002 L001 A:24519 T:24519 I:12135'
G[11135]='HW K0800 L075 Z18505'
G[11153]='FA K0712 L068 A:23895 T:23895'
G[11154]='FA K0710 L069 A:24227 T:24227'
G[11155]='FA K0710 L068 A:23773 T:23773'
G[11157]='FA K0710 L068 A:23749 T:23749'
G[11167]='FH K0710 L068 A:24126 T:24126'
G[11168]='FH K0710 L068 A:24126 T:24126 P:11167'
G[11170]='FH K0710 L068 A:24126 T:24126 P:11168'
G[11175]='FA K0710 L069 A:23831 T:23891'
G[11176]='FA K0710 L069 A:23891 T:24399 O:11175'
G[11182]='K0710 L068 A:23870 T:23870'
G[11187]='FA K0710 L068 A:23749 T:23888 P:11157'
G[11188]='FA K0710 L068 A:23888 T:23888 P:11187'
G[11190]='FA K0710 L068 A:23770 T:23770'
G[11196]='K08564 L085 A:52924 T:552924'
G[11199]='FA K0710 L068 A:23749 T:23906 P:11188'
G[11202]='FA K0710 L068 A:23906 T:23906 P:11199'
G[11208]='K0390 L035 A:23797 T:23572 P:27348'
G[11211]='K0390 L038 A:6546 T:23572'
G[11212]='FA K0370 L037 A:4921 T:6546'
G[11213]='FH K0370 L037 A:4791 T:6546'
G[11215]='FH K0390 L039 A:4791 T:23572'
G[11216]='K0700 L068 A:23948 T:17613'
G[11218]='FA K0710 L068 A:23976 T:23976 P:11188'
G[11219]='HW FH K0002 L001 A:23973 T:23973'
G[11220]='HW K0800 L075 Z18505'
G[11221]='FH K0710 L068 A:23780 T:23780 P:11270'
G[11224]='FA K0710 L068 A:23978 T:23978 P:11188'
G[11227]='FH K0710 L068 A:23938 T:23938'
G[11228]='FA K0700 L068 A:23547 T:23546'
G[11229]='FH K0710 L068 A:23780 T:24037 P:11221'
G[11230]='FH K0710 L068 A:24037 T:24037 P:11229'
G[11231]='FA K0710 L068 A:24038 T:24038 P:11250'	-- TODO: is also 11249 needed?
G[11232]='FH K0710 L068 A:24037 T:23778 P:11230'
G[11233]='FH K0710 L068 A:23778 T:23778 P:11232'
G[11234]='FH K0710 L068 A:23778 T:23780 P:11233'
G[11235]='FA K0710 L068 A:23749 T:23749 P:11250'
G[11236]='FA K0720 L068 A:23749 T:23749 P:11235'
G[11237]='FA K0720 L068 A:100033289 T:23888'
G[11238]='FA K0720 L068 A:23888 T:23888 P:11237'
G[11239]='FA K0710 L068 A:24038 T:24038 P:11231'
G[11240]='FA K0710 L068 A:23976 T:23976 P:11218'
G[11241]='FH K0710 L068 A:23784 T:24126'
G[11242]='HW FA K0000 L060 A:23904 T:24519 Z18505'
G[11243]='FA K0700 L068 A:23546 T:23546 P:11228'
G[11244]='FA K0700 L068 A:23546 T:23546 P:11243'
G[11245]='FA K0710 L068 A:24060 T:24060 P:11248'
G[11246]='FA K0710 L068 A:24060 T:24060 P:11248'
G[11247]='FA K0710 L068 A:24060 T:24060 P:11248'
G[11248]='FA K0710 L068 A:23749 T:24060 P:11332'
G[11249]='FA K0720 L068 A:100033314 T:24038'
G[11250]='FA K0720 L068 A:24060 T:23749 P:11245+11246+11247'
G[11251]='FA K0710 L068 A:24106 T:24111'	-- something is not letting Nimhfree get this so I assume there is an I code needed here
G[11252]='FA K0710 L068 A:24111 T:23546 P:11251 Z20338'
G[11253]='FH K0710 L068 A:23938 T:1186585 P:11227'
G[11254]='FH K0710 L068 A:1186585 T:23780 P:11253'
G[11255]='FA K0700 L068 A:23546 T:23546 P:11244'
G[11256]='FH K0710 L068 A:24129 T:24130 P:11281'
G[11257]='FH K0710 L068 A:24130 T:24130 P:11256'
G[11258]='FH K0710 L068 A:24130 T:24130 P:11256'
G[11259]='FH K0710 L068 A:24130 T:24130 P:11256'
G[11260]='FH K0720 L068 A:100033345 T:24135'
G[11261]='FH K0720 L068 A:24130 T:24129 P:11257+11258+11259'
G[11262]='FH K0710 L068 A:24137 T:23780'
G[11263]='FH K0710 L068 A:24129 T:24129 P:11261'
G[11264]='FH K0720 L068 A:24129 T:24129 P:11263'
G[11265]='FH K0710 L068 A:24135 T:24135 P:11261'
G[11266]='FH K0720 L068 A:100033347 T:24032'
G[11267]='FH K0720 L068 A:24032 T:24032 P:11266'
G[11268]='FH K0710 L068 A:24135 T:24135 P:11265'
G[11269]='FA K0710 L069 A:24139 T:24139'
G[11270]='FH K0710 L068 A:23780 T:23780'
G[11271]='FH K0710 L069 A:24127 T:24127'
G[11272]='FH K0710 L068 A:23780 T:23780'
G[11273]='FA K0700 L068 A:23548 T:24122 P:11244'
G[11274]='FA K0700 L068 A:24122 T:24145 P:11273'
G[11275]='FH K0710 L069 A:24123 T:24123'
G[11276]='FA K0700 L068 A:24145 T:24150 P:11274'
G[11277]='FA K0710 L068 A:24150 T:24150 P:11276'
G[11278]='FA K0710 L068 A:24150 T:23548 P:11300'
G[11279]='FH K0710 L068 A:24157 T:24157'
G[11280]='FH K0710 L068 A:24157 T:24157 P:11279'
G[11281]='FH K0710 L069 A:24123 T:24123 P:11275'
G[11282]='FH K0710 L068 A:24027 T:24027 P:11295'
G[11283]='FH K0710 L068 A:24027 T:24027 P:11282'
G[11284]='FA K0710 L068 A:24176 T:24176'
G[11285]='FH K0710 L068 A:24027 T:24027 P:11282'
G[11286]='FH K0710 L069 A:24186 T:24186 P:11287'
G[11287]='FH K0710 L069 A:24135 T:24186 P:11261'
G[11288]='FA K0710 L068 A:24189 T:24189'
G[11289]='FA K0710 L068 A:24189 T:24191 P:11288'
G[11290]='FA K0700 L068 A:23546 T:23546 P:11255'
G[11291]='FA K0700 L068 A:23546 T:23749 P:11290'
G[11292]='FA K0700 L069 A:24131 T:24131'
G[11293]='HB FA K0002 L001 A:23627 T:23627 P:11318 I:11294'
G[11294]='HB FA K0002 L001 A:23628 T:23628 P:11318 I:11293'
G[11295]='FH K0710 L068 A:23780 T:24027 P:11254'
G[11296]='FH K0720 L070 A:24209 T:24209'
G[11297]='FH K0710 L069 A:24234 T:24152 P:11271'
G[11298]='FH K0710 L069 A:24152 T:24152 P:11297'
G[11299]='FA K0710 L068 A:24150 T:24151 P:11277'
G[11300]='FA K0710 L068 A:24151 T:24150 P:11299'
G[11301]='FH K0710 L069 A:24218 T:24218'
G[11302]='FA K0700 L068 A:24282 T:24117 P:11329'
G[11303]='FH K0710 L068 A:24027 T:24458 P:11283+11285'	-- TODO: Verify requires 11283
G[11304]='FH K0710 L068 A:24126 T:24251 P:11170'
G[11305]='FH K0710 L068 A:24251 T:24251 P:11304'
G[11306]='FH K0710 L068 A:24251 T:24251 P:11305'
G[11307]='FH K0710 L068 A:24251 T:24251 P:11306'
G[11308]='FH K0710 L068 A:24251 T:24252 P:11307'
G[11309]='FH K0710 L068 A:24252 T:24252 P:11308'
G[11310]='FH K0710 L068 A:24252 T:24252 P:11309'
G[11311]='FH K0710 L069 A:24256 T:24256'
G[11312]='FH K0710 L069 A:24123 T:24117 P:11271'
G[11313]='K0710 L069 A:24117 T:24117 O:11302,11312'
G[11314]='K0710 L069 A:24117 T:24117 P:11313'
G[11315]='K0710 L069 A:24117 T:24117 P:11313'
G[11316]='K0710 L069 A:24117 T:24117 P:11314+11315'
G[11317]='FH K0710 L069 A:24186 T:24186 P:11286'
G[11318]='HB FA K00016 L001 A:23558 T:23558'
G[11319]='K0710 L069 A:24117 T:24117 P:11314+11315'
G[11322]='FA K0710 L069 A:24273 T:24273'
G[11323]='FH K0710 L069 A:24186 T:24261 P:11317'
G[11324]='FH K0710 L069 A:24261 T:24186 P:11417'
G[11325]='FA K0710 L069 A:24273 T:24261 P:11322'
G[11326]='FA K0710 L069 A:24261 T:24273 P:11416'
G[11327]='FA K0710 L068 A:23906 T:23906 P:11202'
G[11328]='FA K0710 L068 A:23906 T:24283 P:11327'
G[11329]='FA K0700 L069 A:24056 T:24056'
G[11330]='FA K0710 L068 A:24283 T:24283 P:11328'
G[11331]='FA K0710 L068 A:24283 T:23749 P:11330'
G[11332]='FA K0710 L068 A:23749 T:23749 P:11331'
G[11333]='FA K0710 L068 A:23975 T:23975 P:11244'
G[11342]='K0000 L071 E21691'
G[11343]='FA K0710 L068 A:23975 T:23975 P:11333'
G[11344]='FA K0710 L068 A:23975 T:23975 P:11343'
G[11346]='FA K0710 L069 A:24328 T:24328 P:11329'
G[11348]='FA K0710 L069 A:24328 T:24328 P:11349 I:11352'
G[11349]='FA K0710 L069 A:24328 T:24328 P:11346'
G[11350]='FH K0710 L069 A:24362 T:24362 P:11271'
G[11351]='FH K0710 L069 A:24362 T:24362 P:11350'
G[11352]='FH K0710 L069 A:24362 T:24362 P:11351 I:11348'
G[11354]='K07066 L070 A:24369 T:24369 I:11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11355]='FA K0720 L069 A:24376 T:24376 P:11329'
G[11356]='HW FA K0000 L001 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:24519'
G[11357]='HW FH K0000 L001 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:23973'
G[11358]='FA K0720 L069 A:24376 T:24376 P:11355'
G[11359]='FA K0720 L069 A:24376 T:24376 P:11358 I:11367'
G[11360]='HW FA K0000 L001 A:24519 T:24519 O:11356 I:11439,11440'
G[11361]='HW FH K0000 L001 A:23973 T:23973 I:11449,11450'
G[11362]='K07066 L070 A:24369 T:24369 I:11354,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11363]='K07066 L070 A:24369 T:24369 I:11354,11362,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11364]='K07066 L070 A:24370 T:24370 I:11371,11376,11383,11385,11387,11389,11500 Z15595'
G[11365]='FH K0720 L069 A:24390 T:24390 P:11271'
G[11366]='FH K0720 L069 A:24390 T:24390 P:11365'
G[11367]='FH K0720 L069 A:24390 T:24390 P:11366 I:11359'
G[11368]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11369]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11370]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11371]='K07066 L070 A:24370 T:24370 I:11364,11376,11383,11385,11387,11389,11500 Z15595'
G[11372]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11373]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11374]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11375]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11378,11382,11384,11386,11388,11499 Z15595'
G[11376]='K07066 L070 A:24370 T:24370 I:11364,11371,11383,11385,11387,11389,11500 Z15595'
G[11377]='K0702 L070 A:24393 T:24393 P:PC275 I:11379,11380,11381'
G[11378]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11382,11384,11386,11388,11499 Z15595'
G[11379]='K0702 L070 A:24393 T:24393 P:PC275 I:11377,11380,11381'
G[11380]='K0702 L070 A:24393 T:24393 P:PC275 I:11377,11379,11381'
G[11381]='K0702 L070 A:24393 T:24393 P:PC275 I:11377,11379,11380'
G[11382]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11384,11386,11388,11499 Z15595'
G[11383]='K07066 L070 A:24370 T:24370 I:11364,11371,11376,11385,11387,11389,11500 Z15595'
G[11384]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11386,11388,11499 Z15595'
G[11385]='K07066 L070 A:24370 T:24370 I:11364,11371,11376,11383,11387,11389,11500 Z15595'
G[11386]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11388,11499 Z15595'
G[11387]='K07066 L070 A:24370 T:24370 I:11364,11371,11376,11383,11385,11389,11500 Z15595'
G[11388]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11499 Z15595'
G[11389]='K07066 L070 A:24370 T:24370 I:11364,11371,11376,11383,11385,11387,11500 Z15595'
G[11390]='FA K0710 L069 A:24399 T:24399 P:11176'
G[11391]='FA K0712 L069 A:24399 T:24399 P:11390'
G[11392]='HW K0800 L075 Z18505'
G[11393]='FA K0710 L069 A:23891 T:23833'
G[11394]='FA K0710 L069 A:23833 T:23833 O:11393'
G[11395]='FA K0710 L069 A:100033961 T:23833'
G[11396]='FA K0710 L069 A:23833 T:23833 P:11395'
G[11397]='FH K0710 L069 A:24359 T:24359'
G[11398]='FH K0710 L069 A:100033962 T:24359'
G[11399]='FH K0710 L069 A:24359 T:24359 P:11398'
G[11401]='HW K000512 L075 Z18505'	-- PM5
G[11403]='HW FH K0000 L060 A:23904 T:23973'
G[11404]='HW K000512 L075 Z18505'	-- PM5
G[11405]='HW K000512 L075 Z18505'	-- PM5
G[11406]='FA K0700 L068 A:24494 T:24139 P:11332'
G[11407]='HB FH K0002 L001 A:24498 T:24498 P:11409 I:11408'
G[11408]='HB FH K0002 L001 A:24499 T:24499 P:11409 I:11407'
G[11409]='HB FH K00016 L001 A:24497 T:24497'
G[11410]='FA K0710 L068 A:24056 T:24056 P:11329'
G[11411]='FH K0700 L068 A:24125 T:24129'
G[11412]='HB FH K0002 L001 A:24497 T:24497 P:11409'
G[11414]='FA K0710 L069 A:24261 T:24261 P:11325'
G[11415]='FH K0710 L069 A:24261 T:24261 P:11323'
G[11416]='FA K0710 L069 A:24261 T:24261 P:11414'
G[11417]='FH K0710 L069 A:24261 T:24261 P:11415'
G[11418]='FA K0700 L068 A:24139 T:24139 P:11269'
G[11420]='FA K0710 L068 A:23728 T:23728 P:11244'
G[11421]='FA K0710 L068 A:24634 T:24634 P:11430'
G[11422]='K0710 L069 A:24544 T:24544'
G[11423]='FH K0710 L070 A:24548 T:24548'
G[11424]='FH K0710 L068 A:24252 T:24252'
G[11426]='FA K0710 L068 A:23728 T:23728 P:11420'
G[11427]='FA K0710 L068 A:23728 T:24634 P:11426'
G[11428]='K0710 L069 A:24117 T:24117 P:11316'
G[11429]='FA K0710 L068 A:24634 T:24634 P:11427'
G[11430]='FA K0710 L068 A:24634 T:24634 P:11429'
G[11431]='HB FH K00016 L001 A:24657 T:24657 I:11117'
G[11432]='FA K0710 L068 A:23888 T:23888 P:11231'
G[11433]='FH K0710 L068 A:24127 T:24127 P:11265'
G[11434]='K0710 L069 A:24537 T:24537 P:11509'
G[11436]='FA K0710 L068 A:24634 T:23728 P:11421'
G[11439]='HW FA K0000 L001 A:24519 T:24519 O:11356 I:11360,11440'
G[11440]='HW FA K0000 L001 A:24519 T:24519 O:11356 I:11360,11439'
G[11441]='HB FA K00016 L001 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173 T:24710 I:11442,11446,11447'
G[11442]='SP HB FA K00016 L001 A:24710 T:24710 I:11441,11446,11447'
G[11443]='FA K0710 L068 A:23730 T:23730'
G[11446]='HB FH K00016 L001 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:24711 I:11441,11442,11447'
G[11447]='SP HB FH K00016 L001 A:24711 T:24711 I:11441,11442,11446'
G[11448]='FA K0710 L068 A:23548 T:24717 P:11278 O:11478'
G[11449]='HW FH K0000 L001 A:23973 T:23973 I:11361,11450'
G[11450]='HW FH K0000 L001 A:23973 T:23973 I:11361,11449'
G[11451]='FA K0700 L060 A:24729 T:24727'
G[11452]='FA K0720 L068 A:100034090 T:23749'
G[11453]='FH K0720 L068 A:100034091 T:24129'
G[11455]='K0710 L069 A:24537 T:24537 P:11434'
G[11456]='K0710 L069 A:24755 T:24755'
G[11457]='K0710 L069 A:24755 T:24755 P:11456'
G[11458]='K0710 L069 A:24755 T:24755 P:11457'
G[11459]='K0710 L069 A:24525 T:24537 P:11473'
G[11460]='FA K0710 L068 A:24750 T:24750'
G[11464]='K0710 L069 A:24541 T:24541 P:11434'
G[11465]='FA K0710 L068 A:24750 T:24750 P:11460'
G[11466]='K0710 L069 A:24541 T:24541 P:11464'
G[11467]='K0710 L069 A:24541 T:24541 P:11466'
G[11468]='FA K0710 L068 A:24750 T:24750 P:11465'
G[11469]='K0710 L069 A:24784 T:24784'	-- TODO: need to verify if 11509 needs to be done first
G[11470]='FA K0710 L068 A:24750 T:24750 P:11468'
G[11471]='K0710 L069 A:24741 T:24741 P:11480'
G[11472]='K0002 L069 A:24810 T:24810 P:11469'
G[11473]='K0710 L069 A:24537 T:24525 P:11455'
G[11474]='FA K0710 L068 A:24717 T:24807 P:11448'
G[11475]='FA K0710 L068 A:24807 T:24807'	-- if one has 11474, this will not be available until that turned in
G[11476]='K0710 L069 A:24537 T:24525 P:11459'
G[11477]='FA K0700 L068 A:24811 T:24811'
G[11478]='FA K0710 L068 A:24811 T:24717'
G[11479]='K0710 L069 A:24525 T:24537 P:11476'
G[11480]='K0710 L069 A:24537 T:24741 P:11479'
G[11481]='K0700 L070 A:18537 T:24967 P:T3A441999'
G[11482]='K0700 L070 A:18594 T:24967 P:T3A641999'
G[11483]='FA K0710 L068 A:24807 T:24807 P:11475'
G[11484]='FA K0710 L068 A:24807 T:24807 P:11475'
G[11485]='FA K0710 L068 A:24807 T:24807 P:11484'	-- TODO: does this also require 11483?
G[11488]='K0700 L070 A:24813 T:24822 P:11481,11482 Z16135'
G[11489]='FA K0710 L068 A:24807 T:24807 P:11485'
G[11490]='K0700 L068 A:24822 T:24848 P:11488 Z16135'
G[11491]='FA K0710 L068 A:24807 T:24807 P:11489'
G[11492]='K0700 L070 A:24848 T:24813 P:11490 Z16135'
G[11494]='FA K0710 L068 A:24807 T:24807 P:11491'
G[11495]='FA K0710 L068 A:24807 T:24807 P:11491'
G[11499]='K07066 L070 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388 Z15595'
G[11500]='K07066 L070 A:24370 T:24370 I:11364,11371,11376,11383,11385,11387,11389 Z15595'
G[11501]='FA K0710 L068 A:24807 T:23749 P:11495'	-- TODO: does this also require 11494?
G[11502]='FA K070258 L064 A:24866 T:24866 P:T3D241999'
G[11503]='FH K070258 L064 A:24881 T:24881'
G[11504]='K0710 L068 A:23804 T:23804 O:11573'
G[11505]='FA K000258 L062 A:24885 T:24885'
G[11506]='FH K000258 L062 A:24886 T:24886'
G[11507]='K0710 L068 A:23804 T:24755 P:11504'
G[11508]='K0710 L068 A:24755 T:24643 P:11507'
G[11509]='K0710 L068 A:24643 T:24539 P:11508'
G[11510]='K0710 L068 A:24539 T:24539 P:11509'
G[11511]='K0710 L068 A:24539 T:23804 P:11510'
G[11512]='K0710 L068 A:24539 T:23804 P:11510'
G[11513]='K0702 L070 A:24932 T:24932'	-- this is replaced by 11514 after the portal to the Sunwell opens
G[11514]='K0702 L070 A:24932 T:24932'
G[11515]='K0702 L070 A:24937 T:24937 P:11526'
G[11516]='K0702 L070 A:24937 T:24937 P:11526'
G[11519]='K0710 L068 A:24539 T:24910 P:11510'
G[11521]='K0702 L070 A:24975 T:24975'
G[11523]='K0702 L070 A:24967 T:24967'
G[11525]='K0702 L070 A:24965 T:24965'
G[11526]='K0700 L070 A:24967 T:24937'
G[11527]='K0710 L068 A:24910 T:24910 P:11519'
G[11529]='K0710 L068 A:24910 T:24910 P:11527'
G[11530]='K0710 L068 A:24910 T:23804 P:11529'
G[11531]='FA K0700 L055 A:100034469 T:17634 P:PF001'
G[11533]='K0702 L070 A:25057 T:25057'
G[11534]='K0700 L070 A:25034 T:24932'	-- probably no longer available after the portal to the Sunwell opens
G[11536]='K0702 L070 A:25046 T:25046'
G[11537]='K0702 L070 A:25061 T:25061'
G[11540]='K0702 L070 A:25069 T:25069'
G[11541]='K0702 L070 A:25088 T:25088'
G[11543]='K0702 L070 A:25108 T:25108'
G[11544]='K0702 L070 A:25046 T:25046'
G[11546]='K0702 L070 A:24975 T:24975'
G[11547]='K0702 L070 A:25133 T:25133'
G[11548]='K0702 L070 A:25112 T:25112'
G[11549]='K0700 L070 A:25163 T:25163 P:T43583999'
G[11554]='K0700 L070 A:25032 T:25032 P:T43544999'
G[11555]='K0700 L070 A:25032 T:25032 P:T43550999'
G[11556]='K0700 L070 A:25032 T:25032 P:T43562999'
G[11557]='K0700 L070 A:25032 T:25032 P:T43583999'
G[11559]='K0710 L069 A:25197 T:25206 P:11571'
G[11560]='K0710 L069 A:25197 T:25197 P:11559'
G[11561]='K0710 L069 A:25199 T:25199 P:11559'
G[11562]='K0710 L069 A:25197 T:25205 P:11560'
G[11563]='K0710 L069 A:25205 T:25205 P:11562'
G[11564]='K0710 L069 A:25211 T:25211 P:11562'
G[11565]='K0710 L069 A:25205 T:25197 P:11563'
G[11566]='K0720 L069 A:25197 T:25197 P:11565'
G[11567]='K0710 L068 A:24539 T:23804 P:11510'
G[11568]='K0710 L068 A:23804 T:23804 P:11530+11567+11512+11511'
G[11569]='K0710 L069 A:28375 T:28375'
G[11570]='K0710 L069 A:25208 T:25197'
G[11571]='K0710 L069 A:25197 T:25197 P:11702,11704'
G[11572]='K0710 L068 A:23804 T:24755 P:11568'
G[11573]='FA K0710 L068 A:25233 T:23804'
G[11574]='FH K0710 L069 A:25247 T:25262 P:11595,11596,11597'
G[11575]='FA K0710 L069 A:25249 T:25262 P:T41A44999'
G[11576]='K0710 L069 A:25291 T:25291'
G[11580]='SP HM FA K0000 L001 A:1187559 T:1187559'
G[11581]='SP HM FH K0000 L001 A:1187564'
G[11582]='K0710 L069 A:25291 T:25291 P:11576'
G[11583]='SP HM FA K0000 L001 A:25910 T:25910'
G[11584]='SP HM FH K0000 L001 A:25939 T:25939'
G[11585]='FH K0710 L068 A:25273 T:25237 O:28711'	-- troll druid
G[11586]='FH K0710 L068 A:25273 T:25237 P:1'
G[11587]='K0710 L069 A:25262 T:25262 O:11574,11575'
G[11590]='K0710 L069 A:25262 T:25262 P:11587'
G[11591]='FH K0710 L068 A:25326 T:25336'
G[11592]='FH K0720 L068 A:25335 T:25326'
G[11593]='FH K0710 L068 A:25336 T:25336'
G[11594]='FH K0710 L068 A:25336 T:25336 O:11591'
G[11595]='FH K0710 L068 A:25256 T:25279 P:1 I:11596,11597'
G[11596]='FH K0710 L068 A:25256 T:25279 P:11585 I:11595,11597'	-- troll druid
G[11597]='FH K0710 L068 A:25256 T:25279 P:1 I:11595,11596'
G[11598]='FH K0710 L068 A:25279 T:25279 P:11595,11596,11597'
G[11599]='FA K0710 L068 A:25251 T:25385 P:11927'
G[11600]='FA K0710 L068 A:25385 T:25251 P:11599'
G[11601]='FA K0710 L068 A:25251 T:25245 P:11600'
G[11602]='FH K0710 L068 A:25279 T:25279 P:11598'
G[11603]='FA K0710 L068 A:25245 T:25302 P:11601'
G[11604]='FA K0710 L068 A:25302 T:25395 P:11603'
G[11605]='K0720 L068 A:1187565 T:1187565'
G[11606]='FH K0710 L068 A:25327 T:25327 P:11595,11596,11597'
G[11607]='K0720 L068 A:1187565 T:1187565 P:11605'
G[11608]='FH K0710 L068 A:25327 T:25327 P:11606'
G[11609]='K0720 L068 A:1187565 T:1187565 P:11607'
G[11610]='K0720 L068 A:1187565 T:1187565 P:11609'
G[11611]='FH K0710 L068 A:25280 T:25280 P:11595,11596,11597'
G[11612]='K0720 L068 A:25292 T:25292'
G[11613]='K0710 L068 A:25435 T:25435 O:12141'
G[11614]='FH K0710 L068 A:25394 T:25328 P:11598'
G[11615]='FH K0710 L068 A:25328 T:25394 P:11614'
G[11616]='FH K0710 L068 A:25394 T:25237 P:11615'
G[11617]='K0720 L068 A:25292 T:25292 P:11612'
G[11618]='FH K0710 L068 A:25237 T:25437 P:11616'
G[11619]='K0710 L068 A:25435 T:25435 P:11613'
G[11620]='K0710 L068 A:25435 T:25450 P:11619'
G[11623]='K0720 L068 A:25292 T:25292 P:11617'
G[11624]='FH K0710 L069 A:25339 T:25376 O:12486'
G[11625]='K0710 L068 A:25450 T:25450 P:11620'
G[11626]='K0710 L068 A:25450 T:25435 P:11625'
G[11627]='FH K0720 L069 A:25376 T:25376 P:11624'
G[11628]='FH K0720 L068 A:24703 T:24703 P:1'
G[11629]='FH K0710 L069 A:25376 T:25339 P:11649'
G[11630]='FH K0720 L068 A:24703 T:24703 P:11628'
G[11631]='FH K0710 L069 A:25339 T:25339 P:11629'
G[11632]='FH K0710 L068 A:100034777 T:25256'
G[11633]='FH K0720 L068 A:24703 T:24703 P:11630'
G[11634]='FH K0710 L068 A:25279 T:25289 P:11602'
G[11635]='FH K0710 L069 A:25339 T:25425 P:1'
G[11636]='FH K0710 L068 A:25289 T:25329 P:11634'
G[11637]='FH K0720 L069 A:25425 T:25425 P:11635'
G[11638]='FH K0710 L069 A:25425 T:25339 P:11637'
G[11639]='FH K0710 L069 A:25374 T:25374 P:1'
G[11640]='FH K0720 L068 A:24703 T:24703 P:11633'
G[11641]='FH K0720 L068 A:24706 T:24706 P:1'
G[11642]='FH K0710 L068 A:25329 T:25475 P:11636'
G[11643]='FH K0710 L068 A:25475 T:25475 P:11642'
G[11644]='FH K0710 L068 A:25475 T:25475 P:11642'
G[11645]='FA K0710 L069 A:25477 T:25477'
G[11646]='K0710 L069 A:25262 T:25480 P:11590'
G[11647]='FH K0720 L068 A:24709 T:24709 P:1'
G[11648]='K0710 L069 A:25480 T:25480 P:11646'
G[11649]='FH K0710 L069 A:25376 T:25376 P:11627'
G[11650]='FA K0710 L069 A:25477 T:25477 P:11645'
G[11651]='FH K0710 L068 A:25475 T:25329 P:11643+11644'	-- TODO: Verify requires 11643
G[11652]='FH K0710 L068 A:25329 T:25237 P:11651'
G[11653]='FA K0710 L069 A:25477 T:25477 P:11650'
G[11654]='FH K0720 L068 A:100034815 T:25516'
G[11655]='FH K0710 L068 A:25476 T:25476'
G[11656]='FH K0710 L068 A:25476 T:25476 P:11655'
G[11657]='HM FA K0000 L001 A:25975 T:25975 P:11731 I:11923'
G[11658]='FA K0710 L069 A:25477 T:25477 P:11653'
G[11659]='FH K0720 L068 A:25516 T:24733 P:11654'
G[11660]='FH K0710 L068 A:25476 T:25476'
G[11661]='FH K0710 L068 A:25476 T:25476 P:11660'
G[11662]='FH K0710 L068 A:25476 T:25435 P:1'
G[11663]='K0710 L069 A:25480 T:25262 P:11648'
G[11664]='FH K0710 L068 A:25504 T:25503'
G[11665]='K0702 L070 A:25580 T:25580 I:11666,11667,11668,11669'
G[11666]='K0702 L070 A:25580 T:25580 I:11665,11667,11668,11669'
G[11667]='K0702 L070 A:25580 T:25580 I:11665,11666,11668,11669'
G[11668]='K0702 L070 A:25580 T:25580 I:11665,11666,11667,11669'
G[11669]='K0702 L070 A:25580 T:25580 I:11665,11666,11667,11668'
G[11670]='FA K0720 L069 A:25477 T:25477 P:11658'
G[11671]='K0710 L069 A:25262 T:25262 P:11663'
G[11672]='FA K0710 L068 A:25307 T:25250 O:28709'
G[11673]='FA K0720 L069 A:25589 T:25590'
G[11674]='FH K0710 L068 A:25602 T:25604'
G[11675]='FH K0710 L068 A:25604 T:25604 P:11674'
G[11676]='FH K0710 L068 A:25438 T:25438 P:11618'
G[11677]='FH K0710 L068 A:25604 T:25604 P:11675'
G[11678]='FH K0710 L068 A:25604 T:25658 P:1'
G[11679]='K0710 L069 A:25262 T:24795 P:11671'
G[11680]='K0710 L069 A:24795 T:25356 P:11679'
G[11681]='K0710 L069 A:25356 T:25785 P:11680'
G[11682]='K0710 L069 A:25785 T:24795 P:11681'
G[11683]='FH K0710 L068 A:25604 T:25604 P:1'
G[11684]='FH K0710 L068 A:24702 T:24702'
G[11685]='FH K0710 L068 A:24702 T:24730 P:11684'
G[11686]='FH K0710 L068 A:25437 T:25437 P:11618'
G[11687]='FH K0720 L068 A:25658 T:25604 P:11678'
G[11688]='FH K0710 L068 A:25607 T:25607'
G[11689]='FH K0710 L068 A:25604 T:25602 P:11687'
G[11690]='FH K0710 L068 A:25607 T:25607 P:11688'
G[11691]='HM K070512 L065 P:11696'	-- PM5
G[11692]='FA K0710 L068 A:25702 T:25705 P:11710'
G[11693]='FA K0710 L068 A:25705 T:25705 P:11692'
G[11694]='FA K0710 L068 A:25705 T:25705 P:11693'
G[11695]='FH K0710 L068 A:24730 T:24730 P:11685'
G[11696]='HM K0700 L065'
G[11697]='FA K0710 L068 A:25705 T:25714 P:11694'
G[11698]='FA K0710 L068 A:25705 T:25705 P:11694'
G[11699]='FA K0720 L068 A:25714 T:25714 P:11697'
G[11700]='FA K0710 L068 A:25714 T:25705 P:11699'
G[11701]='FA K0710 L068 A:25705 T:25590 P:11700'
G[11702]='FH K0710 L069 A:25736 T:25197'
G[11703]='FH K0710 L068 A:25437 T:25729 P:11686'
G[11704]='FA K0710 L069 A:25702 T:25197 P:11708'
G[11705]='FH K0710 L068 A:25729 T:25237 P:11703'
G[11706]='FH K0710 L068 A:24730 T:24730 P:11695'
G[11707]='FA K0710 L068 A:25737 T:25590'
G[11708]='FA K0710 L068 A:25590 T:25747 P:11707'
G[11709]='FH K0710 L068 A:25237 T:25379 P:11705'
G[11710]='FA K0710 L068 A:25702 T:25702 P:11708'
G[11711]='FH K0710 L068 A:25379 T:25440 P:11709'
G[11712]='FA K0710 L068 A:25747 T:25747 P:11708'
G[11713]='FA K0710 L068 A:25780 T:25780'
G[11714]='FH K0710 L068 A:25440 T:25440 P:11711'
G[11715]='FA K0710 L068 A:25780 T:25780 P:11713'
G[11716]='FH K0710 L068 A:25381 T:25381'
G[11717]='FH K0710 L068 A:25381 T:25381 P:11716'
G[11718]='FA K0710 L068 A:25780 T:25780 P:11715'
G[11719]='FH K0710 L068 A:25381 T:25381 P:11717'
G[11720]='FH K0710 L068 A:25381 T:25380 P:11719'
G[11721]='FH K0710 L068 A:25380 T:25380 P:11720'
G[11722]='FH K0710 L068 A:25380 T:25237 P:11721'
G[11723]='FA K0710 L068 A:25780 T:25780 P:11718'
G[11724]='FH K0710 L068 A:1187905 T:25381'
G[11725]='FA K0710 L068 A:25590 T:25807 P:11712'
G[11726]='FA K0710 L068 A:25807 T:25807 P:11725'	-- should the P: be O: ?
G[11727]='FA K0710 L068 A:25250 T:25816 P:11672'
G[11728]='FA K0710 L068 A:25807 T:25807 P:11726'
G[11729]='FA K0710 L068 A:100034984 T:25477'
G[11730]='FA K0710 L068 A:25477 T:25477 P:11729'
G[11731]='HM FA K0000 L001 A:25975 T:25975 I:11922'
G[11732]='SP HM FH K0000 L001 A:1187914'
G[11733]='K0710 L069 A:24795 T:25314 P:11682'
G[11734]='SP HM FH K0000 L001 A:1187916 T:1187916'
G[11735]='SP HM FH K0000 L001 A:1187917 T:1187917'
G[11736]='SP HM FH K0000 L001 A:1187919 T:1187919'
G[11737]='SP HM FH K0000 L001 A:1187920 T:1187920'
G[11738]='SP HM FH K0000 L001 A:1187921 T:1187921'
G[11739]='SP HM FH K0000 L001 A:1187922 T:1187922'
G[11740]='SP HM FH K0000 L001 A:1187923 T:1187923'
G[11741]='SP HM FH K0000 L001 A:1187924 T:1187924'
G[11742]='SP HM FH K0000 L001 A:1187925 T:1187925'
G[11743]='SP HM FH K0000 L001 A:1187926 T:1187926'
G[11744]='SP HM FH K0000 L001 A:1187927 T:1187927'
G[11745]='SP HM FH K0000 L001 A:1187928 T:1187928'
G[11746]='SP HM FH K0000 L001 A:1187929 T:1187929'
G[11747]='SP HM FH K0000 L001 A:1187930 T:1187930'
G[11749]='SP HM FH K0000 L001 A:1187932 T:1187932'
G[11750]='SP HM FH K0000 L001 A:1187933 T:1187933'
G[11751]='SP HM FH K0000 L001 A:1187934 T:1187934'
G[11752]='SP HM FH K0000 L001 A:1187935 T:1187935'
G[11753]='SP HM FH K0000 L001 A:1187936 T:1187936'
G[11754]='SP HM FH K0000 L001 A:1187937 T:1187937'
G[11755]='SP HM FH K0000 L001 A:1187938 T:1187938'
G[11756]='SP HM FH K0000 L001 A:1187939 T:1187939'
G[11757]='SP HM FH K0000 L001 A:1187940 T:1187940'
G[11758]='SP HM FH K0000 L001 A:1187941 T:1187941'
G[11759]='SP HM FH K0000 L001 A:1187942 T:1187942'
G[11760]='SP HM FH K0000 L001 A:1187943 T:1187943'
G[11761]='SP HM FH K0000 L001 A:1187944 T:1187944'
G[11762]='SP HM FH K0000 L001 A:1187945 T:1187945'
G[11763]='SP HM FH K0000 L001 A:1187946 T:1187946'
G[11764]='SP HM FA K0000 L001 A:1187947 T:1187947'
G[11765]='SP HM FA K0000 L001 A:1187948 T:1187948'
G[11766]='SP HM FA K0000 L001 A:1187954 T:1187954'
G[11767]='SP HM FA K0000 L001 A:1187955 T:1187955'
G[11768]='SP HM FA K0000 L001 A:1187956 T:1187956'
G[11769]='SP HM FA K0000 L001 A:1187957 T:1187957'
G[11770]='SP HM FA K0000 L001 A:1187958 T:1187958'
G[11771]='SP HM FA K0000 L001 A:1187959 T:1187959'
G[11772]='SP HM FA K0000 L001 A:1187960 T:1187960'
G[11773]='SP HM FA K0000 L001 A:1187961 T:1187961'
G[11774]='SP HM FA K0000 L001 A:1187962 T:1187962'
G[11775]='SP HM FA K0000 L001 A:1187963 T:1187963'
G[11776]='SP HM FA K0000 L001 A:1187964 T:1187964'
G[11777]='SP HM FA K0000 L001 A:1187965 T:1187965'
G[11778]='SP HM FA K0000 L001 A:1187966 T:1187966'
G[11779]='SP HM FA K0000 L001 A:1187967 T:1187967'
G[11780]='SP HM FA K0000 L001 A:1187968 T:1187968'
G[11781]='SP HM FA K0000 L001 A:1187969 T:1187969'
G[11782]='SP HM FA K0000 L001 A:1187970 T:1187970'
G[11783]='SP HM FA K0000 L001 A:1187971 T:1187971'
G[11784]='SP HM FA K0000 L001 A:1187972 T:1187972'
G[11786]='SP HM FA K0000 L001 A:1187974 T:1187974'
G[11787]='SP HM FA K0000 L001 A:1187975 T:1187975'
G[11788]='FA K0710 L068 A:25747 T:25747 P:11712'
G[11789]='FA K0710 L068 A:25825 T:25825'
G[11790]='FA K0710 L068 A:1187851 T:25298'
G[11791]='FA K0710 L068 A:25299 T:25250 P:11920'
G[11792]='FA K0710 L068 A:25285 T:25285 P:11791'
G[11793]='FA K0710 L068 A:25285 T:25826 P:11792'
G[11794]='FA K0710 L068 A:25826 T:25826 P:11793'
G[11795]='FA K0710 L068 A:25807 T:25807 P:11728'
G[11796]='FA K0710 L068 A:25807 T:25807 P:11795'
G[11797]='FA K0710 L068 A:25816 T:25816 P:11727'
G[11798]='FA K0720 L068 A:25747 T:25590 P:11788'
G[11799]='SP HM FA K0000 L001 A:1187949 T:1187949'
G[11800]='SP HM FA K0000 L001 A:1187950 T:1187950'
G[11801]='SP HM FA K0000 L001 A:1187951 T:1187951'
G[11802]='SP HM FA K0000 L001 A:1187952 T:1187952'
G[11803]='SP HM FA K0000 L001 A:1187953 T:1187953'
G[11804]='SP HM FA K0000 L001 A:25887 T:25887'
G[11805]='SP HM FA K0000 L001 A:25883 T:25883'
G[11806]='SP HM FA K0000 L001 A:25888 T:25888'
G[11807]='SP HM FA K0000 L001 A:25889 T:25889'
G[11808]='SP HM FA K0000 L001 A:25890 T:25890'
G[11809]='SP HM FA K0000 L001 A:25891 T:25891'
G[11810]='SP HM FA K0000 L001 A:25892 T:25892'
G[11811]='SP HM FA K0000 L001 A:25893 T:25893'
G[11812]='SP HM FA K0000 L001 A:25894 T:25894'
G[11813]='SP HM FA K0000 L001 A:25895 T:25895'
G[11814]='SP HM FA K0000 L001 A:25896 T:25896'
G[11815]='SP HM FA K0000 L001 A:25897 T:25897'
G[11816]='SP HM FA K0000 L001 A:25898 T:25898'
G[11817]='SP HM FA K0000 L001 A:25899 T:25899'
G[11818]='SP HM FA K0000 L001 A:25900 T:25900'
G[11820]='SP HM FA K0000 L001 A:25902 T:25902'
G[11821]='SP HM FA K0000 L001 A:25903 T:25903'
G[11822]='SP HM FA K0000 L001 A:25904 T:25904'
G[11823]='SP HM FA K0000 L001 A:25905 T:25905'
G[11824]='SP HM FA K0000 L001 A:25906 T:25906'
G[11825]='SP HM FA K0000 L001 A:25907 T:25907'
G[11826]='SP HM FA K0000 L001 A:25908 T:25908'
G[11827]='SP HM FA K0000 L001 A:25909 T:25909'
G[11828]='SP HM FA K0000 L001 A:25911 T:25911'
G[11829]='SP HM FA K0000 L001 A:25912 T:25912'
G[11830]='SP HM FA K0000 L001 A:25913 T:25913'
G[11831]='SP HM FA K0000 L001 A:25914 T:25914'
G[11832]='SP HM FA K0000 L001 A:25915 T:25915'
G[11833]='SP HM FA K0000 L001 A:25916 T:25916'
G[11834]='SP HM FA K0000 L001 A:25917 T:25917 I:28761'
G[11835]='SP HM FH K0000 L001 A:25918 T:25918'
G[11836]='SP HM FH K0000 L001 A:25919 T:25919'
G[11837]='SP HM FH K0000 L001 A:25920 T:25920'
G[11838]='SP HM FH K0000 L001 A:25921 T:25921'
G[11839]='SP HM FH K0000 L001 A:25922 T:25922'
G[11840]='SP HM FH K0000 L001 A:25923 T:25923'
G[11841]='SP HM FH K0000 L001 A:25884 T:25884'
G[11842]='SP HM FH K0000 L001 A:25925 T:25925'
G[11843]='SP HM FH K0000 L001 A:25926 T:25926'
G[11844]='SP HM FH K0000 L001 A:25927 T:25927'
G[11845]='SP HM FH K0000 L001 A:25928 T:25928'
G[11846]='SP HM FH K0000 L001 A:25929 T:25929'
G[11847]='SP HM FH K0000 L001 A:25930 T:25930'
G[11848]='SP HM FH K0000 L001 A:25931 T:25931'
G[11849]='SP HM FH K0000 L001 A:25932 T:25932'
G[11850]='SP HM FH K0000 L001 A:25933 T:25933'
G[11851]='SP HM FH K0000 L001 A:25934 T:25934'
G[11852]='SP HM FH K0000 L001 A:25936 T:25936'
G[11853]='SP HM FH K0000 L001 A:25935 T:25935'
G[11854]='SP HM FH K0000 L001 A:25937 T:25937'
G[11855]='SP HM FH K0000 L001 A:25938 T:25938'
G[11856]='SP HM FH K0000 L001 A:25940 T:25940'
G[11857]='SP HM FH K0000 L001 A:25941 T:25941'
G[11858]='SP HM FH K0000 L001 A:25942 T:25942'
G[11859]='SP HM FH K0000 L001 A:25943 T:25943'
G[11860]='SP HM FH K0000 L001 A:25944 T:25944'
G[11862]='SP HM FH K0000 L001 A:25946 T:25946'
G[11863]='SP HM FH K0000 L001 A:25947 T:25947'
G[11864]='SP K0720 L070 A:25809 T:25809'
G[11865]='K0720 L070 A:25811 T:25811 P:11864'
G[11866]='K0720 L070 A:25809 T:25809 P:11864'
G[11867]='SP K0721 L070 A:25809 T:25809 P:11866'
G[11868]='K0720 L070 A:25811 T:25811 P:11865'
G[11869]='K0720 L070 A:25810 T:25810 P:11864'
G[11870]='K0720 L070 A:25810 T:25838 P:11869'
G[11871]='K0720 L070 A:25838 T:25838 P:11870'
G[11872]='K0720 L070 A:25838 T:25810 P:11871'
G[11873]='FA K0710 L068 A:25807 T:25590 P:11796'
G[11875]='K0702 L070 A:19202 T:19202 P:PH300,PM300,PS300'
G[11876]='K0720 L070 A:25809 T:25809 P:11864'
G[11877]='K0702 L070 A:25140 T:25140'
G[11878]='K0720 L070 A:25809 T:25862 P:11876'
G[11879]='K0720 L070 A:25862 T:25809 P:11878'
G[11880]='K0702 L070 A:19475 T:19475'
G[11881]='FH K0710 L068 A:25849 T:25849'
G[11882]='HM FA K0000 L001 A:25962 T:25975'
G[11884]='K0720 L070 A:25812 T:25812 P:11864'
G[11885]='K070512 L070 A:23306 T:23306 P:11029'	-- PM3
G[11886]='HM K0000 L016 A:26221 T:25324'	-- TODO: G64|Holiday fail|
G[11887]='FH K0710 L068 A:25984 T:25849'
G[11888]='FH K0710 L068 A:25978 T:25982 P:11595,11596,11597'
G[11889]='FA K0710 L068 A:25816 T:25816 P:11797'
G[11890]='FH K0710 L068 A:25982 T:25982 O:11888'
G[11891]='HM K0000 L016 A:25324 T:25324 P:11886'
G[11892]='K0720 L070 A:25809 T:25809 P:11879'
G[11893]='FH K0710 L068 A:25983 T:25983 P:1'
G[11894]='FH K0710 L068 A:25849 T:25849 P:1'
G[11895]='FH K0710 L068 A:25982 T:25982 P:11890'
G[11896]='FH K0710 L068 A:25982 T:25982 P:11895'
G[11897]='FA K0710 L068 A:25816 T:25816 P:11889'
G[11898]='FH K0710 L068 A:24703 T:24703 P:1'
G[11899]='FH K0710 L068 A:25602 T:25602 P:1'
G[11900]='K0710 L069 A:25314 T:25314'
G[11901]='FA K0710 L068 A:26083 T:1188085 O:11928'
G[11902]='FA K0710 L068 A:1188085 T:26083 P:11901'
G[11903]='FA K0710 L068 A:26083 T:26083 P:11902'
G[11904]='FA K0710 L068 A:26083 T:26083 P:11903'
G[11905]='K0710 L069 A:25314 T:25314 P:11900'
G[11906]='FH K0710 L068 A:26104 T:26104 P:1'
G[11907]='FH K0710 L068 A:25982 T:25982 P:11896'
G[11908]='FA K0710 L068 A:26084 T:26084 P:11902'
G[11909]='FH K0720 L068 A:25602 T:25602 P:1'
G[11910]='K0710 L069 A:25314 T:25314'
G[11911]='K0710 L069 A:25314 T:25314 P:11910'
G[11912]='K0710 L069 A:26110 T:26110'
G[11913]='FA K0710 L068 A:26085 T:26085 P:11902'
G[11914]='K0710 L069 A:26110 T:26110 P:11912'
G[11915]='HM FH K0000 L001 A:25994 T:26113'
G[11916]='FH K0710 L068 A:25237 T:24703 P:1'
G[11917]='HM K0222 L016 M028 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11918]='K0710 L069 A:26117 T:26117'
G[11919]='K0710 L069 A:26117 T:26117 P:11936'
G[11920]='FA K0710 L068 A:1187851 T:25298'
G[11921]='HM FA K0002 L001 A:25975 T:25975 P:11657 I:11926'	-- TODO: G64|Holiday fail|
G[11922]='HM FH K0000 L001 A:26113 T:26113 I:11731'
G[11923]='HM FH K0000 L001 A:26113 T:26113 P:11922 I:11657'
G[11924]='HM FA K0002 L001 A:25975 T:25975 P:11657 I:11925'	-- TODO: G64|Holiday fail|
G[11925]='HM FH K0002 L001 A:26113 T:26113 P:11923 I:11924'
G[11926]='HM FH K0002 L001 A:26113 T:26113 P:11923 I:11921'
G[11927]='FA K0710 L068 A:26155 T:25251 P:11897'
G[11928]='FA K0710 L068 A:25816 T:26083 P:11897'
G[11929]='FH K0720 L071 A:24703 T:26158 P:1'
G[11930]='FH K0720 L071 A:26158 T:26156 P:11929'
G[11931]='K0710 L069 A:26117 T:26117 P:11919'
G[11932]='FA K0710 L068 A:25395 T:26169 P:11604'
G[11933]='HM FH K0000 L001 A:100035569 T:16818'
G[11935]='HM FA K0000 L001 A:100035568 T:16817'
G[11936]='K0710 L069 A:26117 T:26117 P:11918'
G[11938]='FA K0720 L068 A:26170 T:26170 P:11956'
G[11940]='K0712 L069 A:26117 T:26117 P:11919'
G[11941]='K0710 L069 A:100035648 T:26117'
G[11942]='FA K0720 L068 A:26170 T:26170 P:11938'
G[11943]='K0710 L069 A:26117 T:26117 P:11941'
G[11944]='FA K0720 L068 A:26187 T:26187 P:12086'
G[11945]='K0722 L068 A:26213 T:26213'
G[11946]='K0710 L069 A:26206 T:26206 P:11943'
G[11947]='HM K0322 L029 M038 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11948]='HM K0432 L039 M048 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11949]='K0720 L068 A:26169 T:26169'
G[11950]='K0720 L068 A:26169 T:26218 P:11949'
G[11951]='K0710 L069 A:26206 T:26206 P:11946'
G[11952]='HM K0512 L049 M055 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11953]='HM K0602 L056 M063 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11954]='HM K0002 L064 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11955]='HM K0700 L065'
G[11956]='FA K0710 L068 A:26170 T:26170'
G[11957]='K0710 L069 A:26206 T:26206 P:11951'
G[11958]='K0720 L071 A:26194 T:26194 O:12117'
G[11959]='K0730 L071 A:26194 T:26194 P:11958'
G[11960]='K0722 L071 A:26228 T:26228'
G[11961]='K0720 L068 A:26218 T:26218 P:11950'
G[11962]='FA K0710 L068 A:26083 T:25235 P:11904'
G[11963]='FA K0710 L068 A:25235 T:26083 P:11962'
G[11964]='HM FA K0000 L001 A:16817 T:26401'
G[11965]='FA K0710 L068 A:26083 T:26083 P:11963'
G[11966]='HM FH K0000 L001 A:16818 T:26520'
G[11967]='K0710 L069 A:26206 T:26117 P:11957'
G[11968]='K0710 L068 A:26218 T:26218 P:11961'
G[11969]='K0710 L069 A:26117 T:26117 P:11967'
G[11970]='HM FA K0000 L001 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:16817'
G[11971]='HM FH K0000 L001 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:16818'
G[11972]='HM K0000 L065 A:100035723 T:25697'
G[11973]='K0710 L069 A:26117 T:26117 P:11969'
G[11975]='HC FH K0000 L060 A:22914 T:22914 P:10945+10953+10951'
G[11977]='FH K0720 L071 A:26156 T:26181 P:11930 I:11979'
G[11978]='FH K0720 L071 A:26181 T:26181 P:11977,11979'
G[11979]='FH K0720 L071 A:26415 T:26181 I:11977'
G[11980]='FH K0720 L071 A:26180 T:26180'
G[11981]='K0750 L072 A:26335 T:26260'
G[11982]='K0750 L072 A:26260 T:26260 O:11981'
G[11983]='FH K0720 L071 A:26181 T:26181 P:11978'
G[11984]='K0740 L073 A:26424 T:26424 O:12208,12210'	-- TODO: since 12210 only is available after 12212, must check if 11984 needs something like that too
G[11985]='K0750 L072 A:26260 T:26260 P:12070'
G[11986]='FA K0750 L073 A:1188261 T:26361'
G[11988]='FA K0750 L073 A:26361 T:26361 P:11986'
G[11989]='K0730 L073 A:26423 T:26423 P:11984'
G[11990]='K0740 L073 A:26423 T:26423 P:11989'
G[11991]='K0740 L073 A:26423 T:26500 P:11990'
G[11993]='FA K0750 L073 A:26361 T:26361 P:11988'
G[11995]='FA K0720 L071 A:26440 T:26673 I:12440,B12439'
G[11996]='FH K0720 L071 A:26441 T:26471'
G[11997]='K0000 L098 A:99415 T:90418 E21796'
G[11998]='FA K0750 L073 A:26212 T:26226'
G[11999]='FH K0720 L071 A:26471 T:26471 P:11996'
G[12000]='FA K0720 L071 A:26673 T:26673 O:11995,12439,12440,39204'
G[12002]='FA K0750 L073 A:26226 T:26226 P:11998'
G[12003]='FA K0750 L073 A:26226 T:26226 P:12002'
G[12004]='FA K0730 L071 A:26673 T:26673 P:12000'
G[12005]='FH K0730 L071 A:26471 T:26471 P:11999'
G[12006]='K0720 L071 A:26501 T:26501'
G[12007]='K0740 L073 A:26500 T:26543 P:11991'
G[12008]='FH K0720 L071 A:26181 T:26379 P:11983'
G[12009]='K0720 L071 A:26245 T:26245 P:11959'
G[12010]='FA K0750 L073 A:26226 T:26514 P:12003'
G[12011]='K0720 L071 A:1188364 T:26245'
G[12012]='HM K0000 L016 A:25324 T:26221 P:11891'
G[12013]='K0730 L071 A:26501 T:26501 P:12006'
G[12014]='FA K0750 L073 A:26514 T:26226 P:12010'
G[12016]='K0720 L071 A:26245 T:26245 P:12011'
G[12017]='K0730 L071 A:26245 T:26245 P:12016'
G[12019]='FA K0720 L068 A:26170 T:26170 P:11942'
G[12020]='HB FA K0002 L001 A:1189989 T:27215'
G[12022]='HB FA K00016 L001 A:27215 T:27215 I:12191'
G[12026]='FH K0750 L073 A:1188261 T:26584'
G[12027]='FA K0740 L073 A:26588 T:26371'
G[12028]='K0720 L071 A:26595 T:26595 P:11959'
G[12029]='K0740 L073 A:26604 T:26604 P:12484'
G[12030]='K0720 L071 A:26595 T:1188419 P:12028'
G[12031]='K0720 L071 A:1188419 T:1188419 P:12030'
G[12032]='K0720 L071 A:1188419 T:26595 P:12031'
G[12033]='FH K0720 L071 A:26649 T:26649'
G[12034]='FH K0720 L071 A:26379 T:26415'
G[12035]='FA K0710 L068 A:26084 T:26084 P:11908'
G[12036]='FH K0720 L071 A:26415 T:26415 P:12034'
G[12037]='K07464 L072 A:26604 T:55677 P:12029'
G[12038]='K0722 L070 A:26604 T:26604 P:12029'
G[12039]='FH K0720 L071 A:26564 T:26564'
G[12040]='FH K0720 L071 A:26653 T:26653'
G[12041]='FH K0720 L071 A:26653 T:26379 P:12040'
G[12042]='K0740 L073 A:26543 T:1188365 P:12007'
G[12043]='K0740 L072 A:26647 T:26647'
G[12044]='K0740 L072 A:26660 T:26660 O:12469'
G[12045]='K0740 L072 A:26661 T:26661'
G[12046]='K0740 L072 A:26661 T:26661 P:12045'
G[12047]='K0740 L072 A:26661 T:26661 P:12046'
G[12048]='FH K0720 L071 A:26564 T:26564 P:12039'
G[12049]='K0740 L072 A:26660 T:26660 P:12046'
G[12050]='K0740 L072 A:26660 T:26660 P:12047'
G[12052]='K0740 L072 A:26647 T:26647 P:12047'
G[12053]='FH K0720 L071 A:26415 T:26415 P:12036'
G[12054]='FH K0750 L073 A:26584 T:26584 P:12026'
G[12055]='FA K0720 L071 A:100036742 T:26673'
G[12056]='FH K0720 L071 A:26618 T:26618'
G[12057]='FH K0720 L071 A:100036744 T:26618'
G[12058]='FH K0750 L073 A:26584 T:26584'
G[12059]='FH K0720 L071 A:100036746 T:26471 P:12055'
G[12060]='FA K0720 L071 A:26673 T:26673 P:12055'
G[12061]='FH K0720 L071 A:26471 T:26471 P:12059'
G[12063]='FH K0720 L071 A:26652 T:26733'
G[12064]='FH K0720 L071 A:26733 T:26733 P:12063'
G[12065]='FA K0720 L071 A:26673 T:26673 P:12060'
G[12066]='FH K0720 L071 A:26471 T:26471 P:12061'
G[12067]='FA K0720 L071 A:100036756 T:26459'
G[12068]='K0750 L073 A:26701 T:26787 P:12802'
G[12069]='FH K0730 L071 A:26733 T:26379 P:12064'
G[12070]='K0750 L072 A:26260 T:26260 P:11982'
G[12071]='FH K0720 L071 A:26415 T:26574 P:12053'	-- 4.2 has the extra space
G[12072]='FH K0720 L071 A:26574 T:26574 P:12071'
G[12073]='FH K0750 L073 A:26666 T:26666'
G[12074]='FH K0750 L073 A:26666 T:26260'
G[12075]='K0740 L072 A:26659 T:26659 O:12112'
G[12076]='K0740 L072 A:26659 T:26659 P:12075'
G[12077]='K0740 L072 A:26659 T:26473 P:12076'
G[12078]='K0740 L072 A:26659 T:26659 P:12077'
G[12079]='K0740 L072 A:26473 T:26473 P:12075'
G[12080]='K0740 L072 A:26473 T:26473 P:12077'
G[12081]='K0750 L072 A:26260 T:26420 P:11985'
G[12082]='K0750 L073 A:26814 T:26884'
G[12083]='FA K0720 L071 A:26673 T:26673 P:12065'
G[12084]='FH K0720 L071 A:26471 T:26471 P:12066'
G[12085]='FH K0720 L071 A:100036780 T:26379'
G[12086]='FA K0720 L068 A:26169 T:26187 P:11932'
G[12088]='FA K0720 L068 A:26187 T:26170 P:11944'
G[12089]='FH K0740 L071 A:1188418 T:26618'
G[12090]='FH K0740 L071 A:1188418 T:26618'
G[12091]='FH K0740 L071 A:1188418 T:26618'
G[12092]='FA K0720 L071 A:26837 T:26837'
G[12093]='K0750 L072 A:26420 T:26420 P:12081'
G[12094]='K0750 L072 A:26420 T:26420 P:12093'
G[12095]='FH K0750 L071 A:26618 T:26859'
G[12096]='FH K0720 L071 A:26854 T:26854'
G[12097]='FH K0750 L071 A:26859 T:26618 P:12095'
G[12098]='FA K0720 L071 A:26673 T:26873 P:12083'
G[12099]='K0750 L072 A:26420 T:26420 P:12094'
G[12100]='FH K0720 L071 A:26504 T:26504'
G[12101]='FH K0720 L071 A:26504 T:26505 P:12100'
G[12102]='FH K0730 L071 A:26505 T:26505 P:12101'
G[12103]='K0000 L098 A:98519 T:99181'
G[12104]='FH K0730 L071 A:26505 T:26504 P:12102'
G[12105]='FA K0740 L073 A:100036940 T:26875'
G[12106]='FH K0720 L071 A:26471 T:26873 P:12084'
G[12107]='FA K0720 L071 A:26873 T:26673 P:12098,12106'
G[12109]='FA K0740 L073 A:26875 T:26212 P:12105'
G[12110]='FH K0720 L071 A:26873 T:26471 P:12107'
G[12111]='FH K0730 L071 A:26504 T:26504 P:12104'
G[12112]='K0740 L072 A:26647 T:26659 P:12052'
G[12113]='K0750 L073 A:26884 T:26884'
G[12114]='K0750 L073 A:26884 T:26884'
G[12115]='FH K0720 L071 A:26618 T:26581 P:12057'
G[12116]='K0750 L073 A:26886 T:26886'
G[12117]='K0720 L068 A:28382 T:26194 P:11968'
G[12118]='K0720 L068 A:24810 T:26194'
G[12119]='FA K0720 L071 A:26673 T:26443 P:12107'
G[12120]='K0750 L073 A:26886 T:26886 P:12116'
G[12121]='K0750 L073 A:26886 T:26924 P:12120'
G[12122]='FH K0720 L071 A:26471 T:26443 P:12110'
G[12123]='FA K0750 L071 A:26443 T:26917 P:12768'
G[12124]='FH K0750 L071 A:26443 T:26917 P:12769'
G[12125]='FH K0730 L071 A:26581 T:26581'
G[12126]='FH K0730 L071 A:26581 T:26581'
G[12127]='FH K0730 L071 A:26581 T:26581'
G[12128]='FA K0750 L073 A:26226 T:26883 P:12014'
G[12129]='FA K0750 L073 A:26883 T:26883 P:12128'
G[12130]='FA K0750 L073 A:26883 T:26883 P:12129'
G[12131]='FA K0750 L073 A:26883 T:26883 P:12130'
G[12132]='FH K0730 L071 A:26581 T:26581'
G[12133]='HW FA K0002 L001 A:1186887 T:24519'
G[12134]='K0750 L073 A:26935 T:26935 P:12329'
G[12135]='HW FA K0002 L001 A:24519 T:24519 I:11131'
G[12136]='FH K0730 L071 A:26581 T:26618 P:12132'
G[12137]='K0750 L073 A:26924 T:26886 P:12121'
G[12138]='FA K0750 L073 A:26883 T:26883 P:12131'
G[12139]='HW FH K0002 L001 A:23973 T:23973 P:11450'
G[12140]='FH K0730 L071 A:26379 T:26379 P:12069'
G[12141]='FA K0710 L068 A:25301 T:25435 P:11791'
G[12142]='FA K0730 L072 A:26978 T:26978'
G[12143]='FA K0730 L072 A:26978 T:26978 P:12142'
G[12144]='FH K0730 L072 A:26979 T:26979'
G[12145]='FH K0730 L072 A:26979 T:26979 P:12144'
G[12146]='FA K0730 L072 A:100036855 T:26983'
G[12147]='FH K0730 L072 A:100036856 T:26983'
G[12148]='K0730 L072 A:26983 T:26983 P:12146,12147'
G[12149]='K0730 L072 A:26983 T:26983 P:12148'
G[12150]='K0740 L072 A:26983 T:26983 P:12149'
G[12151]='K0740 L072 A:26983 T:26983 P:12150'
G[12152]='K0750 L073 A:26886 T:26886 P:12137'
G[12153]='FA K0750 L073 A:26883 T:26883 P:12138'
G[12154]='FA K0750 L073 A:26883 T:26883 P:12138'
G[12155]='HW FH K0002 L001 A:1186887 T:23973'
G[12157]='FA K0720 L071 A:26186 T:27060'
G[12158]='FA K0750 L073 A:26212 T:26932 P:12109'
G[12159]='FA K0750 L073 A:26932 T:26932 P:12158'
G[12160]='FA K0750 L073 A:26932 T:26212 P:12159'
G[12161]='FA K0750 L073 A:27582 T:27581 P:12160'
G[12164]='K075512 L073 A:526935 T:26935 P:12411'	-- PM3
G[12165]='FH K0750 L073 A:27221 T:27227 P:12195'
G[12166]='FA K0720 L071 A:26973 T:26973'
G[12167]='FA K0720 L071 A:26973 T:26973 P:12166'
G[12168]='FA K0720 L071 A:100036958 T:26973'
G[12169]='FA K0720 L071 A:26973 T:26973 P:12168'	-- ensure we do not need P:12167 as well
G[12170]='FH K0742 L073 A:27120 T:27120'
G[12171]='FA K0720 L071 A:27060 T:26881 O:12157 I:12297'
G[12172]='FA K0730 L071 CM A:26673 T:26673'
G[12173]='FH K0730 L071 CM A:26471 T:26471'
G[12174]='FA K0720 L071 A:26881 T:27136 P:12171'
G[12175]='FH K0740 L073 A:27037 T:27037'
G[12176]='FH K0740 L073 A:27037 T:27037 P:12175'
G[12177]='FH K0740 L073 A:27037 T:27037 P:12176'
G[12178]='FH K0740 L073 A:27037 T:26860 P:12177'
G[12180]='FA K0750 L073 A:26885 T:26885 P:12014'
G[12181]='FH K0720 L071 A:24251 T:24155'
G[12182]='FH K0720 L071 A:24155 T:27172 P:12181'
G[12183]='FA K0750 L073 A:26885 T:26885 P:12180'
G[12184]='FA K0750 L073 A:26885 T:26885 P:12183'
G[12185]='FA K0750 L073 A:26885 T:26885 P:12184'
G[12188]='FH K0720 L071 A:27172 T:27172 P:12182,12189'
G[12189]='FH K0720 L071 A:26505 T:27172 P:12182'
G[12190]='K0740 L073 A:26519 T:26884 P:12483'
G[12191]='HB FH K00016 L001 A:27216 T:27216 I:12022'
G[12192]='HB FH K0002 L001 A:1189990 T:27216'
G[12193]='HB FA K0000 L001 A:24468 T:23710 Z17198'
G[12194]='HB FH K0000 L001 A:24510 T:24495 Z17198'
G[12195]='FH K0750 L073 A:27221 T:27221'
G[12196]='FH K0750 L073 A:27227 T:27227 P:12165'
G[12197]='FH K0750 L073 A:27227 T:27227 P:12196'
G[12198]='FH K0750 L073 A:27227 T:27227 P:12197'
G[12199]='FH K0750 L073 A:27227 T:27221 P:12198'
G[12200]='FH K0720 L071 A:27172 T:27172 P:12188'
G[12201]='FH K0750 L073 A:26666 T:26666 P:12204'
G[12202]='FH K0750 L073 A:26666 T:26666 P:12201'
G[12203]='FH K0750 L073 A:26666 T:26666 P:12202'
G[12204]='FH K0750 L073 A:26666 T:26666'
G[12205]='FH K0720 L071 A:1188649 T:27243'
G[12206]='FH K0720 L071 A:27248 T:27248'
G[12207]='FH K0740 L072 A:27262 T:27262'
G[12208]='FH K0740 L073 A:27266 T:26424'
G[12209]='FH K0720 L071 A:27267 T:27267'
G[12210]='FA K0730 L073 A:26875 T:26424 P:12212'
G[12211]='FH K0720 L071 A:27248 T:27248'
G[12212]='FA K0740 L073 A:27277 T:27277'
G[12213]='FH K0740 L072 A:27262 T:27262'
G[12214]='FH K0720 L071 A:27028 T:27028'
G[12215]='FA K0740 L073 A:27277 T:27277'
G[12216]='FA K0740 L073 A:27277 T:27277 P:12212'
G[12217]='FA K0740 L073 A:27277 T:27277 P:12215'
G[12218]='FH K0720 L071 A:27172 T:27172 P:12200'
G[12219]='FA K0740 L073 A:27295 T:27295 P:12310'
G[12220]='FA K0740 L073 A:27295 T:27295 P:12310'
G[12221]='FH K0720 L071 A:27172 T:26505 P:12218'
G[12222]='FA K0740 L073 A:27391 T:27391 P:12294'
G[12223]='FA K0740 L073 A:27391 T:27391 P:12294'
G[12224]='FH K0730 L071 A:26379 T:25257'
G[12225]='FA K0730 L073 A:1188667 T:27277'
G[12226]='FA K0730 L073 A:27277 T:27277 P:12225'
G[12227]='FA K0730 L073 A:27277 T:27277 P:12226'
G[12229]='FH K0740 L072 A:27262 T:27262'
G[12230]='FH K0720 L071 A:27320 T:27320'
G[12231]='FH K0750 L072 A:27262 T:27262'
G[12232]='FH K0720 L071 A:27320 T:27320 P:12230'
G[12234]='FH K0720 L071 A:27337 T:27337'
G[12235]='FA K0720 L071 A:27136 T:27317 P:12174,12298'	-- verify the P: really should not be O:
G[12236]='FH K075512 L072 A:27262 T:27262'	-- PM3
G[12237]='FA K0720 L071 A:27317 T:27317 P:12235'
G[12238]='K07564 L072 A:26787 T:28016 P:12068'
G[12239]='FH K0720 L071 A:27337 T:27350 P:12234'
G[12240]='FH K0720 L071 A:27248 T:27248'
G[12241]='FH K0750 L072 A:27262 T:27262'
G[12242]='FH K0740 L073 A:27262 T:27262'
G[12243]='FH K0720 L071 A:27248 T:27248 P:12240'
G[12244]='FA K0742 L073 A:27371 T:27371'
G[12245]='FH K0720 L071 A:27337 T:27243'
G[12246]='FA K0740 L073 A:27295 T:27295 P:12219+12220'
G[12247]='FA K0750 L073 A:27295 T:27295 P:12219+12220'
G[12248]='FA K0750 L073 A:27295 T:27295 P:12246+12247'
G[12249]='FA K075512 L073 A:27295 T:27295 P:12248+12250'	-- PM3
G[12250]='FA K0750 L073 A:27295 T:27295 P:12246+12247'
G[12251]='FA K0720 L071 A:27317 T:27136 P:12237'
G[12252]='FH K0720 L071 A:27243 T:27243 P:12245'
G[12253]='FA K0720 L071 A:27136 T:27136 P:12251'
G[12254]='FH K0720 L071 A:27350 T:27350 P:12239'
G[12255]='FA K0740 L073 A:27391 T:27391 P:12222+12223'
G[12256]='FH K0740 L073 A:27388 T:27388'
G[12257]='FH K0740 L073 A:27388 T:27388 P:12468'
G[12258]='FA K0720 L071 A:27155 T:27155 P:12251'
G[12259]='FH K0740 L073 A:27388 T:27388'
G[12260]='FH K0720 L071 A:27350 T:27350 P:12254'
G[12261]='K0740 L072 A:26593 T:26593 P:12447'
G[12262]='K0740 L072 A:26593 T:26593 P:12447'
G[12263]='K0740 L072 A:26593 T:26593 P:12261'
G[12264]='K0740 L072 A:26593 T:26593 P:12263'
G[12265]='K0740 L072 A:26593 T:26593 P:12263'
G[12266]='K0740 L072 A:26593 T:27765 P:12267'
G[12267]='K0750 L072 A:26593 T:26593 P:12265'
G[12268]='FA K0742 L073 A:27416 T:27416'
G[12269]='FA K0720 L071 A:27156 T:27156 P:12275'
G[12270]='FH K0742 L073 A:27423 T:27423'
G[12271]='FH K0720 L071 A:100037432 T:27243'
G[12272]='FA K0720 L071 A:27159 T:27159 P:12275'
G[12273]='FH K0730 L071 A:27243 T:27243 P:12271'
G[12274]='FH K0730 L071 A:27350 T:27350 P:12260'
G[12275]='FA K0720 L071 A:27136 T:27159 P:12251'
G[12276]='FA K0720 L071 A:27159 T:27412 P:12275'
G[12277]='FA K0720 L071 A:27412 T:27159 P:12276'
G[12278]='HB FA K0000 L001 A:100037571 T:27478 I:12420'
G[12279]='K0750 L072 A:26484 T:26484'
G[12280]='FH K0742 L073 A:27422 T:27422'
G[12281]='FA K0720 L071 A:27159 T:27136 P:12277'	-- does this also require P:12272 ?
G[12282]='FA K0720 L071 A:27314 T:27314 P:12251'
G[12283]='FH K0720 L071 A:27350 T:27243 P:12274'
G[12284]='FH K0742 L073 A:27451 T:27451'
G[12285]='FH K0730 L071 A:27243 T:27243 P:12283'
G[12286]='SP HW FA K00016 L001 A:1189303 T:1189303'
G[12287]='FA K0720 L071 A:27314 T:27347 P:12282'
G[12288]='FH K0742 L073 A:27464 T:27464'
G[12289]='FA K0742 L073 A:27468 T:27468'
G[12290]='FA K0720 L071 A:27347 T:27347 P:12287'
G[12291]='FA K0720 L071 A:27347 T:27347 P:12290'
G[12292]='FA K0740 L073 A:26875 T:26875'
G[12293]='FA K0740 L073 A:26875 T:27469 P:12292'
G[12294]='FA K0740 L073 A:27469 T:26875 P:12293'
G[12295]='FA K0740 L073 A:26875 T:26821 P:12294'
G[12296]='FA K0742 L073 A:27484 T:27484'
G[12297]='FA K0720 L071 A:23749 T:23859 P:11250 I:12157,12171'
G[12298]='FA K0720 L071 A:23859 T:27136 P:12297 I:12174'
G[12299]='FA K0740 L073 A:27486 T:27486 P:12295'
G[12300]='FA K0740 L073 A:27486 T:27497 P:12299+12307'
G[12301]='FA K0720 L071 A:27347 T:27347 P:12291'
G[12302]='FA K0740 L073 A:27497 T:27499 P:12300'
G[12303]='FH K0720 L071 A:27267 T:27267'
G[12304]='FH K0720 L071 A:32599 T:32599'
G[12305]='FA K0720 L071 A:27347 T:27314 P:12301'
G[12306]='HB FH K0000 L001 A:100037599 T:27489 I:12421'
G[12307]='FA K0740 L073 A:27545 T:27545'
G[12308]='FA K0740 L073 A:27499 T:26875 P:12302'
G[12309]='FA K0720 L071 A:27136 T:27318 P:12253'
G[12310]='FA K0740 L073 A:26875 T:26875 P:12308'
G[12311]='FA K0720 L071 A:27318 T:27318 P:12309'
G[12312]='FA K0730 L071 A:1189311 T:27318 P:12309'
G[12314]='FA K074770 L073 A:27520 T:27520'	-- PM3
G[12315]='FH K074770 L073 A:27532 T:27532'	-- PM3
G[12316]='FA K0742 L073 A:27562 T:27562'
G[12317]='FH K0742 L073 A:27563 T:27563'
G[12319]='FA K0730 L071 A:27318 T:27136 P:12312'
G[12320]='FA K0730 L071 A:27136 T:27316 P:12319'
G[12321]='FA K0730 L071 A:27316 T:27136 P:12320'
G[12323]='FA K074258 L073 A:27602 T:27602'
G[12324]='FH K074258 L073 A:27606 T:27606'
G[12325]='FA K0730 L071 A:27136 T:27157 P:12281'
G[12326]='FA K0730 L071 A:27157 T:1293 P:12325'
G[12327]='K0750 L073 A:27581 T:27581 P:12328'
G[12328]='K0750 L073 A:27581 T:27581 P:12161,12425'
G[12329]='K0750 L073 A:27581 T:26935 P:12327'
G[12330]='K0750 L073 A:26935 T:26935 P:12329'
G[12331]='SP HW FA K00016 L001 A:1190034 T:1190034'
G[12332]='SP HW FA K00016 L001 A:1190036 T:1190036'
G[12333]='SP HW FA K00016 L001 A:1190037 T:1190037'
G[12334]='SP HW FA K00016 L001 A:1190038 T:1190038'
G[12335]='SP HW FA K00016 L001 A:1190039 T:1190039'
G[12336]='SP HW FA K00016 L001 A:1190040 T:1190040'
G[12337]='SP HW FA K00016 L001 A:1190041 T:1190041'
G[12339]='SP HW FA K00016 L001 A:1190043 T:1190043'
G[12340]='SP HW FA K00016 L001 AP:1190047:26322;500023:X26322 TP:1190047:26322;500023:X26322'
G[12341]='SP HW FA K00016 L001 A:1190045 T:1190045'
G[12342]='SP HW FA K00016 L001 A:1190046 T:1190046'
G[12343]='SP HW FA K00016 L001 A:1190044 T:1190044'
G[12344]='SP HW FA K00016 L001 A:1190048 T:1190048'
G[12345]='SP HW FA K00016 L001 A:1190035 T:1190035'
G[12347]='SP HW FA K00016 L001 A:1190050 T:1190050'
G[12348]='SP HW FA K00016 L001 A:1190051 T:1190051'
G[12350]='SP HW FA K00016 L001 A:1190053 T:1190053'
G[12351]='SP HW FA K00016 L001 A:1190054 T:1190054'
G[12352]='SP HW FA K00016 L001 A:1190055 T:1190055'
G[12353]='SP HW FA K00016 L001 A:1190056 T:1190056'
G[12354]='SP HW FA K00016 L001 A:1190057 T:1190057'
G[12355]='SP HW FA K00016 L001 A:1190058 T:1190058'
G[12356]='SP HW FA K00016 L001 A:1190059 T:1190059'
G[12357]='SP HW FA K00016 L001 A:1190060 T:1190060'
G[12358]='SP HW FA K00016 L001 A:1190061 T:1190061'
G[12359]='SP HW FA K00016 L001 A:1190062 T:1190062'
G[12360]='SP HW FA K00016 L001 A:1190063 T:1190063'
G[12361]='SP HW FH K00016 L001 A:1190064 T:1190064'
G[12362]='SP HW FH K00016 L001 A:1190065 T:1190065'
G[12363]='SP HW FH K00016 L001 A:1190066 T:1190066'
G[12364]='SP HW FH K00016 L001 A:1190067 T:1190067'
G[12365]='SP HW FH K00016 L001 A:1190068 T:1190068'
G[12366]='SP HW FH K00016 L001 A:1190069 T:1190069'
G[12367]='SP HW FH K00016 L001 A:1190070 T:1190070'
G[12368]='SP HW FH K00016 L001 A:1190071 T:1190071'
G[12369]='SP HW FH K00016 L001 A:1190072 T:1190072'
G[12370]='SP HW FH K00016 L001 A:1190073 T:1190073'
G[12371]='SP HW FH K00016 L001 A:1190074 T:1190074'
G[12372]='K0742 L071 A:27575 T:27575 P:12435'
G[12373]='SP HW FH K00016 L001 A:1190075 T:1190075'
G[12374]='SP HW FH K00016 L001 A:1190076 T:1190076'
G[12376]='SP HW FH K00016 L001 A:1190078 T:1190078'
G[12377]='SP HW FH K00016 L001 A:1190079 T:1190079'
G[12378]='SP HW FH K00016 L001 A:1190080 T:1190080'
G[12380]='SP HW FH K00016 L001 A:1190082 T:1190082'
G[12381]='SP HW FH K00016 L001 A:1190083 T:1190083'
G[12382]='SP HW FH K00016 L001 A:1190084 T:1190084'
G[12383]='SP HW FH K00016 L001 A:1190085 T:1190085'
G[12384]='SP HW FH K00016 L001 A:1190086 T:1190086'
G[12386]='SP HW FH K00016 L001 A:1190088 T:1190088'
G[12387]='SP HW FH K00016 L001 A:1190089 T:1190089'
G[12388]='SP HW FH K00016 L001 A:1190090 T:1190090'
G[12389]='SP HW FH K00016 L001 A:1190091 T:1190091'
G[12390]='SP HW FH K00016 L001 A:1190096 T:1190096'
G[12391]='SP HW FH K00016 L001 A:1190097 T:1190097'
G[12392]='SP HW FH K00016 L001 A:1190098 T:1190098'
G[12393]='SP HW FH K00016 L001 A:1190099 T:1190099'
G[12394]='SP HW FH K00016 L001 A:1190100 T:1190100'
G[12395]='SP HW FH K00016 L001 A:1190101 T:1190101'
G[12396]='SP HW K00016 L001 A:1190102 T:1190102'
G[12397]='SP HW K00016 L001 A:1190103 T:1190103'
G[12398]='SP HW K00016 L001 A:1190104 T:1190104'
G[12399]='SP HW K00016 L001 A:1190105 T:1190105'
G[12400]='SP HW K00016 L001 A:1190106 T:1190106'
G[12401]='SP HW K00016 L001 A:1190107 T:1190107'
G[12402]='SP HW K00016 L001 A:1190108 T:1190108'
G[12403]='SP HW K00016 L001 A:1190109 T:1190109'
G[12404]='SP HW K00016 L001 AP:1190110:T3A441999;1190111:T3A641999 TP:1190110:T3A441999;1190111:T3A641999'
G[12406]='SP HW K00016 L001 A:1190112 T:1190112'
G[12407]='SP HW K00016 L001 A:1190113 T:1190113'
G[12408]='SP HW K00016 L001 A:1190114 T:1190114'
G[12409]='SP HW K00016 L001 AP:1190115:T3A441999;1190116:T3A641999 TP:1190115:T3A441999;1190116:T3A641999'
G[12411]='K0750 L073 A:26935 T:27646 P:12330'
G[12412]='FH K0750 L073 A:26860 T:26860'
G[12413]='FH K0740 L073 A:26860 T:26860 P:12412'
G[12414]='FA K0750 L073 A:26377 T:26377'
G[12415]='FH K0750 L073 A:26944 T:26944'
G[12416]='FA K0740 L071 A:27506 T:27506 P:12460'
G[12417]='FA K0740 L071 A:27506 T:27506 P:12416'
G[12418]='FA K0750 L071 A:27506 T:27506 P:12417'
G[12419]='K0750 L071 A:100037833 T:27990'
G[12420]='HB FA K0000 L001 A:100037736 T:27478 I:12278'
G[12421]='HB FH K0000 L001 A:100037737 T:27489 I:12306'
G[12422]='FH K0740 L073 A:27102 T:27497 P:12424'
G[12423]='FH K0740 L073 A:100037830 T:26860'
G[12424]='FH K0740 L073 A:26860 T:27102 P:12423'
G[12425]='FH K0750 L073 A:27102 T:27581'
G[12427]='FH K074512 L073 A:27719 T:27720'	-- PM3
G[12428]='FH K074512 L073 A:27719 T:27720 P:12427'	-- PM3
G[12429]='FH K074512 L073 A:27719 T:27720 P:12428'	-- PM3
G[12430]='FH K075512 L073 A:27719 T:27720 P:12429'	-- PM3
G[12431]='FH K075512 L073 A:27719 T:27102 P:12430'	-- PM3
G[12432]='FH K0742 L073 A:27708 T:27708'
G[12433]='FH K0740 L073 A:27565 T:27565'
G[12435]='K0740 L071 A:26917 T:27575 P:12123,12124'
G[12436]='FH K0740 L073 A:26868 T:26868'
G[12437]='FA K0742 L073 A:27759 T:27759'
G[12438]='FA K0740 L071 A:1190020 T:27156'
G[12439]='FA K0720 L071 A:27158 T:26878 I:11995'
G[12440]='FA K0720 L071 A:26878 T:26673 P:12439 I:11995'
G[12441]='FA K0740 L071 A:1190020 T:27156'
G[12442]='FA K0740 L071 A:1190020 T:27156'
G[12443]='FA K0740 L073 A:27495 T:27495'
G[12444]='FA K074258 L073 A:27783 T:27783'
G[12447]='K0740 L072 A:27765 T:26593'
G[12448]='FH K0740 L071 A:27763 T:27763 P:12461'
G[12449]='FH K0740 L071 A:27763 T:27763 P:12448'
G[12450]='FH K0750 L071 A:27763 T:27763 P:12449'
G[12451]='FH K0740 L073 A:27388 T:26666'
G[12453]='FH K0740 L073 A:27262 T:27262'
G[12454]='K0740 L072 A:27255 T:27255'
G[12455]='FA K0730 L071 A:1293 T:1293 P:12326'
G[12456]='K0740 L072 A:27255 T:27255 P:12454'
G[12457]='FA K0730 L071 A:1293 T:1293 P:12455'
G[12458]='K0740 L072 A:27785 T:27785'
G[12459]='K0740 L072 A:27785 T:27785 P:12458'
G[12460]='FA K0740 L071 A:27803 T:27506 P:12766'
G[12461]='FH K0740 L071 A:27804 T:27763 P:12767'
G[12462]='FA K0730 L071 A:27319 T:27319 P:12326'
G[12463]='FA K0730 L071 A:1293 T:27828 P:12457'
G[12464]='FA K0730 L071 A:27784 T:27784 P:12237'
G[12465]='FA K0730 L071 A:27828 T:1293 P:12463'
G[12466]='FA K0730 L071 A:1293 T:27844 P:12465'
G[12467]='FA K0730 L071 A:27844 T:27136 P:12466'
G[12468]='FH K0740 L073 A:26860 T:27388 P:12487'
G[12469]='K0740 L072 A:26896 T:26660'
G[12470]='K0750 L072 A:27856 T:27856'
G[12471]='K0710 L068 A:25636 T:25435'	-- you need to kill the thing fighting the Captured Tuskarr Prisoner and then it will offer the quest.  how to simulate?
G[12472]='FA K0730 L071 A:27136 T:27857 P:12467'
G[12473]='FA K0730 L071 A:27857 T:27136 P:12472'
G[12474]='FA K0730 L071 A:27136 T:27872 P:12473'
G[12475]='FA K0730 L071 A:27314 T:27314 P:12305'
G[12476]='FA K0730 L071 A:27155 T:27155 P:12305'
G[12477]='FA K0730 L071 A:27136 T:27136 P:12305'
G[12478]='FA K0730 L071 A:27314 T:27314 P:12475'
G[12481]='FH K0710 L068 A:24458 T:24458 P:11303'
G[12482]='FH K0710 L068 A:27922 T:27922'
G[12483]='K0750 L073 A:26519 T:26519 P:12484'
G[12484]='K0740 L073 A:26519 T:26604 P:11990'
G[12486]='FH K0710 L069 A:25272 T:25339 P:11595,11596,11597'
G[12487]='FH K0740 L073 A:27243 T:26860 P:12488'
G[12488]='FH K0740 L073 A:26415 T:27243'
G[12489]='K0760 L076 A:27987 T:27986 P:12521'
G[12491]='HB K0000 L075 A:100038280 T:24710'
G[12492]='HB K0000 L075 A:100038281 T:24711'
G[12495]='FA K0740 L071 A:27872 T:26917 P:12474'
G[12496]='FH K0740 L071 A:25257 T:26917 P:12224'
G[12497]='K0740 L071 A:26917 T:26949 P:12495,12496'
G[12498]='K0740 L071 A:26949 T:26917 P:12497'
G[12499]='FA K0740 L071 A:26917 T:27872 P:12498'
G[12500]='FH K0740 L071 A:26917 T:25257 P:12498'
G[12501]='K0762 L074 A:28039 T:28039'
G[12502]='K0762 L074 A:28042 T:28042'
G[12503]='K0760 L074 A:28059 T:28059 O:12795'
G[12504]='K0760 L074 A:28056 T:28056 P:12505'
G[12505]='K0760 L074 A:28039 T:28056 P:12740'
G[12506]='K0760 L074 A:28062 T:28062 P:12740'
G[12507]='K0760 L074 A:100038321 T:28062'
G[12508]='K0760 L074 A:28099 T:28099 P:12505'
G[12509]='K0762 L074 A:28044 T:28044'
G[12510]='K0760 L074 A:28062 T:28062 P:12507'
G[12511]='FA K0730 L073 A:27317 T:26875'
G[12512]='K0760 L074 A:28125 T:28125'
G[12513]='K0680 L066 A:28126 T:28126 I:12515'	-- L72 Human DK 2014-06-15
G[12514]='K0760 L074 A:28062 T:28062 P:12510'
G[12515]='K0680 L066 A:28126 T:28126 I:12513'	-- L85 NE Hunter, Nimhfree marked complete, reports that Horde has gotten this one
G[12516]='K0760 L074 A:28062 T:28062 P:12514'
G[12517]='K0151 L010 A:100037163,100043039 T:30481'
G[12518]='K0350 L030 A:100044148 T:30481'
G[12519]='K0762 L074 A:28043 T:28043'
G[12520]='K0760 L076 A:27986 T:27986 P:12525+12523'
G[12521]='K0760 L076 A:28160 T:27987'
G[12522]='K0760 L076 A:28033 T:28033'
G[12523]='K0760 L076 A:28033 T:28033 P:12522'
G[12524]='K0760 L076 A:28032 T:28032'
G[12525]='K0760 L076 A:28032 T:28032 P:12524'
G[12526]='K0760 L076 A:27986 T:28191 P:12520'
G[12527]='K0760 L074 A:28204 T:28205 P:12510'
G[12528]='FA K0770 L076 A:28095 T:28082 O:12654'	-- TODO: Determine how to handle this.  Basically it becomes available when NPC 28097 is killed
G[12529]='K0770 L076 A:28082 T:28082 P:12528'
G[12530]='K0770 L076 A:28214 T:28082 P:12528'	-- before Whiterock input it was P:B12529
G[12531]='K0770 L076 A:28138 T:28082 P:12532'
G[12532]='K0770 L076 A:28138 T:28138 P:12533+12534'
G[12533]='K0770 L076 A:28082 T:28082 P:12529+12530'
G[12534]='K0770 L076 A:28138 T:28082 P:12529+12530'
G[12535]='K0770 L076 A:28082 T:28082 P:12532'
G[12536]='K0770 L076 A:28082 T:28216 P:12531+12535'
G[12537]='K0770 L076 A:28216 T:28216 P:12536'
G[12538]='K0770 L076 A:28216 T:28216 P:12536'
G[12539]='K0770 L076 A:28216 T:28082 P:12537+12538'
G[12540]='K0770 L076 A:28082 T:28217 P:12539'
G[12541]='K0762 L074 A:28205 T:28205'
G[12542]='K0740 L074 A:27348 T:28228'
G[12543]='K0760 L076 A:28191 T:28191 P:12526'
G[12544]='K0760 L076 A:28191 T:27986 P:12543'
G[12545]='K0740 L074 A:28228 T:28228 O:12542'
G[12546]='K0780 L077 A:27801 T:27801 P:12797'
G[12547]='K0780 L077 A:28092 T:28092 P:12548'
G[12548]='K0780 L077 A:27801 T:28092 P:12613'
G[12549]='K0760 L076 A:28031 T:28031 P:12525+12523'
G[12550]='K0760 L076 A:28031 T:28031 P:12549'
G[12551]='K0760 L076 A:28032 T:28032 P:12520+12549'
G[12552]='K0760 L074 A:28283 T:28283 P:12598'
G[12553]='K0760 L074 A:28284 T:28284 P:12598'
G[12554]='K0760 L074 A:28283 T:28283 P:12552'
G[12555]='K0760 L074 A:28284 T:28284 P:12583'
G[12556]='K0760 L076 A:27986 T:27986 P:12544'
G[12557]='K0760 L074 A:28205 T:28205 P:B12596'
G[12558]='K0760 L076 A:28031 T:28031 P:12550'
G[12559]='K0770 L077 A:27801 T:27801 P:12621'
G[12560]='K0760 L076 A:28032 T:28032 P:12551'
G[12561]='K0770 L077 A:27801 T:27801 O:12803'
G[12562]='K0760 L074 A:28309 T:28309 P:1'	-- TODO: Determine real P:
G[12563]='K0762 L074 A:28039 T:28039'
G[12564]='K0762 L074 A:28042 T:28042'
G[12565]='K0760 L074 A:28062 T:1190535'
G[12566]='FH K0710 L068 A:28314 T:24129'
G[12567]='K0761 L074 A:1190535 T:1190535 P:12565'
G[12568]='K0762 L074 A:28044 T:28044'
G[12569]='K0760 L076 A:28032 T:28032 P:12560'
G[12570]='K07732 L076 A:28217 T:28027 P:12540'
G[12571]='K0770 L076 A:28027 T:28027 P:12570'
G[12572]='K0770 L076 A:28120 T:28027 P:12570'	-- prior to Whiterock data this was  P:B12571
G[12573]='K0770 L076 A:28027 T:28027 P:12571'
G[12574]='K0770 L076 A:28027 T:28114 P:12573+12572'
G[12575]='K0770 L076 A:28114 T:28114 P:12574'
G[12576]='K0770 L076 A:28114 T:28114 P:12574'
G[12577]='K0770 L076 A:28114 T:28027 P:12575+12576'
G[12578]='K0770 L076 A:28027 T:28122 P:12577'
G[12579]='K0770 L076 A:28122 T:28122 P:12578'
G[12580]='K0770 L076 A:28122 T:28122 P:12578'
G[12581]='K0770 L076 A:28122 T:1190777 P:12579+12580'
G[12582]='SP K0772 L076 A:28668 T:28668 P:12581'
G[12583]='K0760 L074 A:28284 T:28284 P:12553'
G[12584]='K0760 L074 A:28044 T:28244 P:12552'
G[12585]='K0762 L074 A:28043 T:28043'
G[12587]='K0762 L074 A:28039 T:28039 P:12596'
G[12588]='K0762 L074 A:28042 T:28042'
G[12589]='K0760 L076 A:28328 T:28328 P:12525+12523'
G[12591]='K0762 L074 A:28044 T:28044'
G[12592]='K0760 L076 A:28328 T:28328 P:12589'
G[12593]='K0550 L055 CK A:25462 T:28357'
G[12594]='K0762 L074 A:28043 T:28043'
G[12595]='K0770 L076 A:27986 T:28376 P:12569+12556+12558'
G[12596]='K0760 L074 A:28039 T:28039 P:12740'
G[12597]='K0760 L074 A:28042 T:28042 P:B12596'
G[12598]='K0760 L074 A:28044 T:28044 P:B12596'
G[12599]='K0760 L074 A:28043 T:28043 P:B12596'
G[12603]='K0770 L076 A:28376 T:28376 P:12569+12556+12558'
G[12604]='K0762 L074 A:28039 T:28039'
G[12605]='K0770 L076 A:28376 T:28376 P:12569+12556+12558'
G[12606]='K0760 L074 A:28044 T:28044 P:12598'
G[12607]='K0770 L076 A:28374 T:28374 P:12603+12605'
G[12608]='K0780 L077 A:28464 T:27801 P:12612'
G[12609]='K0760 L074 A:28045 T:28045 P:12799'
G[12610]='K0760 L074 A:28045 T:28045 P:12799'
G[12611]='K0770 L077 A:27801 T:27801 P:12561'
G[12612]='K0770 L077 A:27801 T:28464 P:12611'
G[12613]='K0770 L077 A:27801 T:27801 P:12559'
G[12614]='K0770 L076 A:28376 T:28376 P:12607'
G[12615]='K0770 L074 A:28479 T:1190602 P:1'
G[12617]='K0770 L077 A:27801 T:27801 P:12608'
G[12618]='SP K0771 L074 A:1190602 T:1190602 P:12615'
G[12619]='K0550 L055 CK A:28357 T:28357 P:12593'
G[12620]='K0770 L077 A:27801 T:27801 P:12617+12660'
G[12621]='K0770 L077 A:27801 T:27801 P:12620'
G[12622]='K0770 L074 A:28484 T:28484 P:1'
G[12623]='K0770 L074 A:28062 T:28479 P:12516'
G[12624]='K0760 L076 A:28497 T:28497'
G[12627]='K0770 L074 A:28479 T:28479 P:12623'
G[12628]='K0770 L074 A:28479 T:28401 P:12627'
G[12629]='K0750 L074 A:28518 T:28518 P:12637'
G[12630]='K0750 L074 A:28518 T:28518 P:12884'
G[12631]='K0750 L074 A:100038660 T:28518 I:12633'	-- TODO: Determine the P:
G[12632]='K0770 L074 A:28401 T:28401 P:12628'
G[12633]='K0750 L074 A:100038673 T:28518 I:12631'	-- TODO: Determine the P: (seems you need to have gone through Drak'Tharon first, otherwise you get the other one)
G[12634]='K0760 L076 A:29157 T:29157 P:12520+12549'
G[12635]='K0770 L074 A:28527 T:28527 P:12627'
G[12636]='K0550 L055 CK A:28357 T:25462 P:12848'
G[12637]='K0750 L074 A:28518 T:28518 P:12631'
G[12638]='K0750 L074 A:28518 T:28518 P:12633'
G[12639]='K0770 L074 A:28480 T:28480 P:12622'
G[12640]='K0770 L074 A:28484 T:28484 P:12622'
G[12641]='K0550 L055 CK A:25462 T:25462 P:12636'
G[12642]='K0770 L074 A:28401 T:28561 P:12632'
G[12643]='K0750 L074 A:28518 T:28518 P:12638'
G[12644]='K0760 L076 A:29157 T:29157 P:12634'
G[12645]='K0760 L076 A:29157 T:29157 P:12644'
G[12646]='K0770 L074 A:28561 T:28561 P:12642'
G[12647]='K0770 L074 A:28561 T:28561 P:12646'
G[12648]='K0750 L074 A:28518 T:28518 P:12629'
G[12649]='K0750 L074 A:28518 T:28518 P:12643'
G[12650]='K0770 L074 A:28527 T:28527 P:12635'
G[12651]='K0770 L076 A:27986 T:28568 P:12560+12526+12550'
G[12652]='K0750 L074 A:28589 T:28589 P:B12648,B12649'
G[12653]='K0770 L074 A:28561 T:28401 P:12647'
G[12654]='K0760 L076 A:28568 T:28568 O:12651'
G[12655]='K0770 L074 A:28479 T:1190657 P:12632'
G[12656]='K0771 L074 A:1190657 T:1190657 P:12655'
G[12657]='K0550 L055 CK A:25462 T:28444 P:12641'
G[12658]='K0770 L076 A:28374 T:28374 P:12603+12605'
G[12659]='K0770 L074 A:28484 T:28484 P:12640'
G[12660]='K0770 L077 A:27801 T:27801 P:12608'
G[12661]='K0750 L074 A:28518 T:528518 P:12648,12649'
G[12662]='K0770 L074 A:28480 T:28480 P:12640'
G[12663]='K0750 L074 A:28503 T:28503 I:12664'	-- perhaps P:12238	-- need to figure out the proper P for this
G[12664]='K0750 L074 A:28503 T:28503 P:B12661 I:12663'	-- perhaps I:12238	-- and this
G[12665]='K0770 L074 A:28401 T:28401 P:12653'
G[12666]='K0770 L074 A:28401 T:28401 P:12665'
G[12667]='K0770 L074 A:28401 T:28030 P:12666'
G[12668]='K0770 L074 A:28030 T:28030 P:12672'
G[12669]='K0750 L074 A:528518 T:528518 P:12661'
G[12670]='K0550 L055 CK A:28510 T:28377 P:12850'
G[12671]='K0770 L077 A:28746 T:28746 P:12699'
G[12672]='K0770 L074 A:28030 T:28030 P:12667'
G[12673]='K0750 L074 A:28503 T:28503 P:B12669'
G[12674]='K0770 L074 A:28030 T:28030 P:12668'
G[12675]='K0770 L074 A:28030 T:28401 P:12674'
G[12676]='K0750 L074 A:528518 T:528518 P:12677'
G[12677]='K0750 L074 A:528518 T:528518 P:12669'
G[12678]='K0550 L055 CK A:28377 T:28377 P:12670'
G[12679]='K0550 L055 CK A:28647 T:28647 P:12670'
G[12680]='K0550 L055 CK A:28653 T:28653 P:12670'
G[12681]='K0770 L076 A:28771 T:28771 P:12603+12605'
G[12683]='K0770 L076 A:28771 T:28771'
G[12684]='K0770 L074 A:28401 T:28401 P:12675'
G[12685]='K0770 L074 A:28401 T:28479 P:12684'
G[12686]='K0750 L074 A:28503 T:28503 P:B12677'
G[12687]='K0550 L055 CK A:28653 T:28653 P:12680'
G[12688]='K07632 L076 A:28787 T:27986'
G[12689]='SP K0772 L076 A:28667 T:28667 P:12581'
G[12690]='K0750 L074 A:28503 T:28503 P:B12676'
G[12691]='K0780 L077 A:1190768 T:1190768'
G[12692]='K0770 L076 A:28668 T:28138 P:12582'
G[12695]='K0770 L076 A:28667 T:28027 P:12689'
G[12696]='K0770 L077 A:28266 T:28746 P:12523'
G[12697]='K0550 L055 CK A:28377 T:28658 P:12678+12679+12687+12733'
G[12698]='K0550 L055 CK A:28658 T:28658 P:12697'
G[12699]='K0770 L077 A:28746 T:28746 P:12523'
G[12700]='K0550 L055 CK A:28658 T:28377 P:12698'
G[12701]='K0550 L055 CK A:28377 T:28377 P:12700'
G[12702]='K0772 L076 A:28138 T:28138 P:12692+T45044999'
G[12703]='K0782 L076 A:29146 T:28106 P:T45044999 I:12759,12760'
G[12704]='K0772 L076 A:28027 T:28027 P:T45144999'
G[12705]='K0782 L076 A:29149 T:28107 P:T45144999 I:12761,12762'
G[12706]='K0550 L055 CK A:28377 T:28444 P:12701'
G[12707]='K0770 L074 A:28484 T:28484 P:12685'
G[12708]='K0770 L074 A:28480 T:28480 P:12662+12685'
G[12709]='K0770 L074 A:28527 T:28527 P:12685+13549'
G[12710]='K0750 L074 A:28503 T:28503 P:12690'
G[12711]='SP K0550 L055 CK A:1190917 T:1190917 P:12670'
G[12712]='K0770 L074 A:528401 T:528401 P:12685'
G[12713]='K0760 L074 A:528518 T:528518 P:12676'
G[12714]='K0550 L055 CK A:28444 T:28907 P:12706'
G[12715]='K0550 L055 CK A:28907 T:28911 P:12714'
G[12716]='K0550 L055 CK A:28919 T:28919 P:12714'
G[12717]='K0550 L055 CK A:28919 T:28919 P:12716'
G[12718]='K0551 L055 CK A:1190936 T:1190936 P:12717'
G[12719]='K0550 L055 CK A:28911 T:28911 P:12715'
G[12720]='K0550 L055 CK A:28911 T:28911 P:12719'
G[12721]='K0770 L074 A:28401 T:28479 P:12712'
G[12722]='K0550 L055 CK A:28910 T:28910 P:12715'
G[12723]='K0550 L055 CK A:28911 T:28914 P:12716+12722+12720'
G[12724]='K0550 L055 CK A:28914 T:28914 P:12723'
G[12725]='K0550 L055 CK A:28913 T:28912 P:12723'
G[12726]='K0802 L077 A:29006 T:29006 P:T45144999 I:12735,12736,12737'
G[12727]='K0550 L055 CK A:28912 T:28913 P:12725'
G[12728]='K0710 L069 A:25291 T:25291 P:11582'
G[12729]='K0770 L074 A:28479 T:528401 P:12721'
G[12730]='K0780 L074 A:528401 T:528401 P:12729'
G[12732]='K0802 L077 A:29043 T:29043 P:12692+T45044999 I:12734,12741,12758'
G[12733]='K0550 L055 CK A:29047 T:29047 P:12670'
G[12734]='K0802 L077 A:29043 T:29043 P:T45044999 I:12732,12741,12758'
G[12735]='K0802 L077 A:29006 T:29006 P:T45144999 I:12726,12736,12737'
G[12736]='K0802 L077 A:29006 T:29006 P:T45144999 I:12726,12735,12737'
G[12737]='K0802 L077 A:29006 T:29006 P:T45144999 I:12726,12735,12736'
G[12738]='K0550 L055 CK A:28913 T:29053 P:12727'
G[12739]='K0550 L055 RT CK A:29053 T:29053 P:12738'
G[12740]='K0760 L074 A:28059 T:28059'
G[12741]='K0802 L077 A:29043 T:29043 P:T45044999 I:12732,12734,12758'
G[12742]='K0550 L055 RH CK A:29053 T:29053 P:12738'
G[12743]='K0550 L055 RE CK A:29053 T:29053 P:12738'
G[12744]='K0550 L055 RF CK A:29053 T:29053 P:12738'
G[12745]='K0550 L055 RN CK A:29053 T:29053 P:12738'
G[12746]='K0550 L055 RD CK A:29053 T:29053 P:12738'
G[12747]='K0550 L055 RB CK A:29053 T:29053 P:12738'
G[12748]='K0550 L055 RO CK A:29053 T:29053 P:12738'
G[12749]='K0550 L055 RL CK A:29053 T:29053 P:12738'
G[12750]='K0550 L055 RU CK A:29053 T:29053 P:12738'
G[12751]='K0550 L055 CK A:29053 T:28913 P:12739,12742,12743,12744,12745,12746,12747,12748,12749,12750,28649,28650'
G[12754]='K0550 L055 CK A:28914 T:28914 P:12751+12724'
G[12755]='K0550 L055 CK A:28914 T:29077 P:12754'
G[12756]='K0550 L055 CK A:29077 T:28914 P:12755'
G[12757]='K0550 L055 CK A:28914 T:28444 P:12756'
G[12758]='K0802 L077 A:29043 T:29043 P:T45044999 I:12732,12734,12741'
G[12759]='K0782 L076 A:29146 T:28106 P:T45044999 I:12703,12760'
G[12760]='K0782 L076 A:29146 T:28106 P:12692+T45044999 I:12703,12759'
G[12761]='K0782 L076 A:29149 T:28107 P:T45144999 I:12705,12762'
G[12762]='K0782 L076 A:29149 T:28107 P:T45144999 I:12705,12761'
G[12763]='FH K0750 L074 A:26666 T:29137'
G[12766]='FA K0720 L071 A:26443 T:27803 P:12119'
G[12767]='FH K0720 L071 A:26443 T:27804 P:12122'
G[12768]='FA K0750 L071 A:27506 T:26443 P:12418'
G[12769]='FH K0750 L071 A:27763 T:26443 P:12450'
G[12770]='FA K0750 L074 A:26212 T:29137'
G[12778]='K0550 L055 CK A:28444 T:29110 P:12757'
G[12779]='K0550 L055 CK A:25462 T:25462 P:12778'
G[12789]='K0750 L074 A:28228 T:29137 P:12545'
G[12790]='K0740 L068 A:29156 T:29156 O:12791,12794,12796'
G[12791]='FH K0740 L074 A:26471,29155,29159,29160,29162 T:29156 I:12794,12796'
G[12792]='K0750 L074 A:28039 T:29137 P:1'
G[12793]='K0750 L074 A:28479 T:29137 P:1'
G[12794]='FA K0740 L074 A:23729,26673,27158,29158,29161 T:29156 I:12791,12796'
G[12795]='K0750 L074 A:28532 T:28059 P:12630'
G[12796]='K0740 L074 A:29169 T:29156 I:12791,12794'
G[12797]='K0780 L077 A:28092 T:27801 P:12547'
G[12798]='K0250 L020 A:100037164 T:30481'
G[12799]='K0750 L074 A:28045 T:28045'
G[12800]='K0550 L055 CK A:29110 T:31082 P:12779'
G[12801]='K0550 L055 CK A:31082 T:29173 P:12800'
G[12802]='K0740 L073 A:1188365 T:26701 P:12042'
G[12803]='K0780 L077 A:28746 T:27801'
G[12804]='K0760 L076 A:28046 T:28046 P:12520'
G[12805]='K0770 L077 A:27801 T:27801 P:12611'
G[12806]='K0800 L077 A:29343 T:29344'
G[12807]='K0800 L077 A:29344 T:29344 P:12806'
G[12810]='K0800 L077 A:29344 T:29344 P:12807'
G[12813]='K0802 L077 A:29396 T:29396'
G[12814]='K0800 L077 A:29344 T:29405 P:12810'
G[12815]='K0802 L077 A:29405 T:29405'
G[12818]='K0780 L077 A:29431 T:29431'
G[12819]='K0780 L077 A:29431 T:29431 P:12818'
G[12820]='K0780 L077 A:29428 T:29428 P:12826'
G[12821]='K0780 L077 A:29428 T:29428 P:12820+12832'
G[12822]='K0780 L077 A:29428 T:29428 P:12821'
G[12823]='K0780 L077 A:29432 T:29432 P:12821'
G[12824]='K0780 L077 A:29432 T:29428 P:12823'
G[12826]='K0780 L077 A:29431 T:29428 P:12819'
G[12827]='K0780 L077 A:29428 T:29428'
G[12828]='K0780 L077 A:29428 T:29428 P:12827+12836'
G[12829]='K0780 L077 A:29430 T:29430 P:12827+12836'
G[12830]='K0780 L077 A:29430 T:29430 P:12827+12836'
G[12831]='K0780 L077 A:29434 T:29434'
G[12832]='K07832 L077 A:29434 T:29428 P:12831'
G[12833]='K0782 L077 A:29428 T:29428 P:12824'
G[12836]='K0780 L077 A:29428 T:29428'
G[12838]='K0802 L077 A:29456 T:29456'
G[12839]='K0800 L077 A:100040666 T:29344'
G[12840]='K0800 L077 A:29344 T:29344 P:12839'
G[12841]='K0790 L077 A:29481 T:29481 P:12846'
G[12842]='K0550 L055 CK A:28357 T:28357 P:12619'
G[12843]='K0790 L077 A:29473 T:29473'
G[12844]='K0790 L077 A:29473 T:29473'
G[12846]='K0780 L077 A:29473 T:29481 P:12843'
G[12847]='K080512 L077 A:29344 T:29560 P:12840'	-- PM5
G[12848]='K0550 L055 CK A:28357 T:28357 P:12842'
G[12849]='SP K0550 L055 CK A:28472 T:28472 P:12657'
G[12850]='K0550 L055 CK A:28444 T:28510 P:12657'
G[12851]='K0800 L077 A:29592 T:29592 P:12972'
G[12852]='K080512 L077 A:29560 T:29344 P:12847'	-- PM5
G[12853]='K0780 L077 A:30490 T:29431'
G[12854]='FA K0800 L077 A:29650 T:29650'
G[12855]='FA K0800 L077 A:29650 T:29579 P:12854'
G[12856]='K0800 L077 A:29592 T:29592 P:12851'
G[12857]='K0750 L074 A:1191728 T:29690'
G[12858]='FA K0800 L077 A:29579 T:29579 P:12855'
G[12859]='K0750 L074 A:29733 T:29733'
G[12860]='FA K0800 L077 A:29579 T:29579 P:12858'
G[12861]='K0750 L074 A:29690 T:29690'
G[12862]='FA K0780 L077 A:29428 T:29744 P:12822+12824'
G[12863]='FA K0780 L077 A:29743 T:29727'
G[12864]='FA K0780 L077 A:29727 T:29727 P:12863'
G[12865]='FA K0780 L077 A:29732 T:29732 P:12863'
G[12866]='FA K0780 L077 A:29727 T:29727 P:12864'
G[12867]='FA K0780 L077 A:29732 T:29732 P:12865'
G[12868]='FA K0780 L077 A:29727 T:29727 P:12866'
G[12869]='FA K0782 L077 A:29732 T:29732'
G[12870]='FA K0780 L077 A:29744 T:29744'
G[12871]='FA K0800 L077 A:29579 T:29743 P:12872'
G[12872]='FA K0800 L077 A:1191760 T:29579 P:13415'
G[12873]='FA K0800 L077 A:29743 T:29593 P:12871'
G[12874]='FA K0800 L077 A:29593 T:29593 P:12873'
G[12875]='FA K0800 L077 A:29593 T:29751 P:12874'
G[12876]='FA K0800 L077 A:29732 T:29732 P:12874'
G[12877]='FA K0800 L077 A:29751 T:30052 P:12875'
G[12878]='FA K0800 L077 A:30052 T:30548 P:12986'
G[12879]='FA K0800 L077 A:30548 T:30082 P:12878'
G[12880]='FA K0800 L077 A:30082 T:30382 P:12879'
G[12882]='FH K0780 L077 A:30472 T:30472'
G[12883]='K0750 L074 A:1191766 T:29687 P:12902'
G[12884]='K0750 L074 A:29687 T:28518 P:12883'
G[12885]='FA K0800 L077 A:29579 T:29801 P:12872'
G[12886]='K0800 L077 A:29796 T:29445 P:13062'
G[12887]='FA K0800 L077 A:29799 T:29804'
G[12888]='K0800 L077 A:100041267 T:29806 P:PN415'
G[12889]='K0800 L077 A:29806 T:1191761 P:12888'
G[12891]='K0800 L077 A:29804 T:29804 P:12887,12892'
G[12892]='FH K0800 L077 A:29795 T:29804 P:12887'
G[12893]='K0800 L077 A:29804 T:29804 P:12891'
G[12894]='K0750 L074 A:29687 T:29689 P:12883'
G[12895]='FH K0800 L077 A:29651 T:29651'
G[12896]='FA K0800 L077 A:29804 T:29799'
G[12897]='FH K0800 L077 A:29804 T:29795 P:12896'
G[12898]='FA K0800 L077 A:29799 T:29343 P:12896,12897'
G[12899]='FH K0800 L077 A:29795 T:29343 P:12898'
G[12900]='K0800 L077 A:29839 T:29839 P:13063'
G[12901]='K0760 L074 A:29688 T:29688 P:12894'
G[12902]='K0750 L074 A:29687 T:1191766'
G[12903]='K0760 L074 A:29689 T:29689 P:12894'
G[12904]='K0760 L074 A:29455 T:29455 P:12894'
G[12905]='K0790 L077 A:29481 T:29885 P:12841'
G[12906]='K0790 L077 A:29885 T:29885 P:12905'
G[12907]='K0790 L077 A:29885 T:29885 P:12906'
G[12908]='K0790 L077 A:29885 T:29481 P:12907'
G[12909]='FH K0800 L077 A:29651 T:29855 P:12895'
G[12910]='FH K0800 L077 A:29855 T:29579 P:12909'
G[12912]='K0760 L074 A:29647 T:29688 P:12894'
G[12913]='FH K0800 L077 A:29579 T:29937 P:12910'
G[12914]='K0760 L074 A:29688 T:29688 P:12912'
G[12915]='K0800 L077 A:29445 T:29445 P:13064'
G[12916]='K0760 L074 A:29688 T:29647 P:12914'
G[12917]='FH K0800 L077 A:29937 T:29937 P:12913'
G[12919]='K0760 L074 A:29647 T:29689 P:12916'
G[12920]='FH K0800 L077 A:29651 T:29651 P:12917'
G[12921]='K0790 L077 A:29481 T:29975 P:12908'
G[12922]='K0800 L077 A:100041556 T:1192060 P:13064'
G[12924]='K0800 L077 A:29445 T:30127 P:12915+12956'
G[12925]='K0800 L077 A:30041 T:30041 P:12841'
G[12926]='FH K0800 L077 A:29651 T:29579 P:12920'
G[12927]='FH K0800 L077 A:29579 T:29579 P:12926'
G[12928]='FH K0800 L077 A:1191760 T:29579 P:13416'
G[12929]='FH K0800 L077 A:29579 T:29801 P:12928'
G[12930]='K0800 L077 A:29801 T:29801 O:12885,12929'
G[12931]='K0800 L077 A:29801 T:29801 P:12930'
G[12932]='K077512 L075 A:30007 T:30009 P:X9977 O:12974'	-- PM5
G[12933]='K077512 L075 A:30007 T:30009 P:12932,12954'	-- PM5
G[12934]='K077512 L075 A:30007 T:30009 P:12933'	-- PM5
G[12935]='K077512 L075 A:30007 T:30009 P:12934'	-- PM5
G[12936]='K077512 L075 A:30007 T:30009 P:12935'	-- PM5
G[12937]='K0800 L077 A:29801 T:29801 P:12930'
G[12938]='K0800 L077 A:29343 T:30002 P:12898,12899'
G[12939]='K0800 L077 A:30002 T:30002 P:12938'
G[12940]='SP HW K00016 L001 A:1191878 T:1191878'
G[12941]='SP HW K00016 L001 A:1191879 T:1191879'
G[12942]='K0800 L077 A:29997 T:29997 P:12841'
G[12943]='K0800 L077 A:30002 T:30002 P:12939'
G[12944]='SP HW FA K00016 L001 A:1191882 T:1191882'
G[12945]='SP HW FA K00016 L001 A:1191883 T:1191883'
G[12946]='SP HW FH K00016 L001 A:1191880 T:1191880'
G[12947]='SP HW FH K00016 L001 A:1191881 T:1191881'
G[12948]='K078512 L075 A:30007 T:30009 P:12936'	-- PM5
G[12949]='K0800 L077 A:30056 T:30056'
G[12950]='SP HW K00016 L001 A:1192018 T:1192018'
G[12951]='K0800 L077 A:30056 T:29343 P:12949'
G[12953]='K0800 L077 A:1192072 T:29997 P:1'
G[12954]='K077512 L075 A:30007 T:30009 P:9977 O:12974'	-- PM5
G[12955]='K0800 L077 A:30074 T:30074 P:12938'
G[12956]='K0800 L077 A:1192060 T:29445 P:12922'
G[12957]='K0800 L077 A:29801 T:29801 P:12931+12937'	-- TODO: Verify requires 12931
G[12958]='SP K0002 L065 A:28701 T:28701 P:13041+PJ375 I:12959,12960,12961,12962,12963'
G[12959]='K0002 L065 A:28701 T:28701 P:13041+PJ375 I:12958,12960,12961,12962,12963'
G[12960]='K0002 L065 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12961,12962,12963'
G[12961]='K0002 L065 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12960,12962,12963'
G[12962]='K0002 L065 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12960,12961,12963'
G[12963]='K0002 L065 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12960,12961,12962'
G[12964]='K0800 L077 A:29801 T:29801 P:12931+12937'	-- TODO: Verify requires 12931
G[12965]='K0800 L077 A:29801 T:29801 P:12957+12964'	-- TODO: Verify requires 12957
G[12966]='K0800 L077 A:30105 T:30099 P:T45F41999'
G[12967]='K0800 L077 A:30099 T:30099 P:12966'
G[12968]='K0800 L077 A:29997 T:29997 P:12841'
G[12969]='K0800 L077 A:29975 T:29975 P:12921'
G[12970]='K0800 L077 A:29975 T:29975 P:12969'
G[12971]='K0800 L077 A:29975 T:29975 P:12970'
G[12972]='K0800 L077 A:29975 T:29592 P:12971'
G[12973]='FA K0800 L077 A:30382 T:30401 P:12880'
G[12974]='K0770 L075 A:30137 T:30007'
G[12975]='K0800 L077 A:30105 T:30105 P:12924'
G[12976]='K0800 L077 A:30105 T:30127 P:12975'
G[12977]='K0802 L077 A:1192078 T:1192078 P:12976'
G[12978]='K0800 L077 A:30152 T:30152 P:12957+12964'	-- TODO: Verify requires 12957
G[12979]='K0800 L077 A:100042203 T:30152 P:C12978'
G[12980]='K0800 L077 A:30152 T:30152 P:12979'
G[12981]='K0802 L077 A:1192071 T:1192071 P:12967'
G[12982]='K0800 L077 A:30218 T:30218 P:13085'
G[12983]='K0800 L077 A:29839 T:29839 P:12900'
G[12984]='K0800 L077 A:29801 T:29801 P:12980'
G[12985]='K0800 L077 A:30127 T:30127 P:12967'
G[12986]='FA K0800 L077 A:30052 T:30052 P:12877'
G[12987]='K0800 L077 A:30127 T:30127 P:12985'
G[12988]='K0800 L077 A:29801 T:29801 P:12984'
G[12989]='K0800 L077 A:29839 T:29839 P:12900'
G[12991]='K0800 L077 A:30152 T:30152 P:12984'
G[12992]='K0800 L077 A:30216 T:30216'
G[12993]='K0800 L077 A:29801 T:29801 P:12988+12991'	-- TODO: Verify requires 12988
G[12994]='K0802 L077 A:30294 T:30294 P:T45F50999'
G[12995]='K0802 L077 A:29343 T:29343'
G[12996]='K0800 L077 A:29839 T:29839 P:12983'	-- note that 4.2 has the space at the end of the name
G[12997]='K0800 L077 A:29839 T:29839 P:12996'
G[12998]='K0800 L077 A:29801 T:29801 P:12993'
G[12999]='K0800 L077 A:30074 T:30232 P:12955'
G[13000]='FH K0790 L077 A:30247 T:30247'
G[13001]='K0800 L077 A:30252 T:30252 P:T45F41999'
G[13003]='K0802 L077 A:1192079 T:1192079 P:13001'
G[13005]='K0800 L077 A:30295 T:30295 P:1'
G[13006]='K0802 L077 A:1192080 T:1192080 P:12985'
G[13007]='K0800 L077 A:29801 T:29801 P:12998'
G[13008]='K0780 L077 A:30223 T:30223 P:13036'
G[13009]='K0800 L077 A:30127 T:29445 P:12924'
G[13010]='K0800 L077 A:29445 T:30390 P:13051'
G[13011]='K0800 L077 A:30105 T:30105 P:T45F41999'
G[13012]='SP HL K00016 L001 A:30348 T:30348'
G[13013]='SP HL K00016 L001 A:30357 T:30357'
G[13014]='SP HL K00016 L001 A:30358 T:30358'
G[13015]='SP HL K00016 L001 A:30359 T:30359'
G[13016]='SP HL K00016 L001 A:30360 T:30360'
G[13017]='SP HL K00016 L001 A:30531 T:30531'
G[13018]='SP HL K00016 L001 A:30362 T:30362'
G[13019]='SP HL K00016 L001 A:30363 T:30363'
G[13020]='SP HL K00016 L001 A:30375 T:30375'
G[13021]='SP HL K00016 L001 A:30536 T:30536'
G[13022]='SP HL K00016 L001 A:30533 T:30533'
G[13023]='SP HL K00016 L001 A:30534 T:30534'
G[13024]='SP HL K00016 L001 A:30365 T:30365'
G[13025]='SP HL K00016 L001 A:30367 T:30367'
G[13026]='SP HL K00016 L001 A:30368 T:30368'
G[13027]='SP HL K00016 L001 A:30369 T:30369'
G[13028]='SP HL K00016 L001 A:30370 T:30370'
G[13029]='SP HL K00016 L001 A:30371 T:30371'
G[13030]='SP HL K00016 L001 A:30372 T:30372'
G[13031]='SP HL K00016 L001 A:30373 T:30373'
G[13032]='SP HL K00016 L001 A:30374 T:30374'
G[13033]='SP HL K00016 L001 A:30364 T:30364'
G[13034]='FH K0800 L077 A:30381 T:30381 O:13426'
G[13035]='K0800 L077 A:30295 T:30295 P:1'
G[13036]='K0780 L077 A:28179 T:30223 O:13226,13227'
G[13037]='FH K0800 L077 A:30381 T:30381 P:13034'
G[13038]='FH K0800 L077 A:30395 T:30381 P:13037'
G[13039]='K0780 L077 A:30224 T:30224'
G[13040]='K0780 L077 A:30226 T:30226'
G[13041]='K0000 L065 A:28701 T:28701 P:PJ375'
G[13042]='K0800 L077 A:30232 T:30232 P:12999'
G[13043]='K0800 L077 A:100042772 T:30232'
G[13044]='K0780 L077 A:30223 T:30227 P:13008'
G[13045]='K0780 L077 A:30227 T:28179 P:13044'
G[13046]='K0802 L077 A:1192524 T:1192524 P:T45F62999'
G[13047]='K0800 L077 A:30295 T:30105 P:1'
G[13048]='FH K0800 L077 A:30381 T:30381 P:1'
G[13049]='FH K0800 L077 A:30381 T:30381 P:1'
G[13050]='K0800 L077 A:29445 T:29445 P:13009'
G[13051]='K0800 L077 A:29445 T:29445 P:13050'
G[13054]='FH K0800 L077 A:30247 T:30469'
G[13055]='FH K0800 L077 A:30469 T:30469 P:13054'
G[13056]='FH K0800 L077 A:30469 T:30469 P:13055'
G[13057]='K0800 L077 A:30390 T:30295 P:13010'
G[13058]='FH K0800 L077 A:30381 T:30381 P:1'
G[13059]='K0800 L077 A:30406 T:30406 P:12999'
G[13060]='FH K0780 L077 A:29428 T:30472 P:12823'
G[13061]='K0790 L077 A:29839 T:29975 P:12997'
G[13062]='K0800 L077 A:29975 T:29796 P:13061'
G[13063]='K0800 L077 A:29592 T:29839 P:12856'
G[13064]='K0800 L077 A:29445 T:29445 P:12886'
G[13065]='SP HL K00016 L001 A:30537 T:30537'
G[13066]='SP HL K00016 L001 A:30535 T:30535'
G[13067]='SP HL K00016 L001 A:30538 T:30538'
G[13068]='K0800 L077 A:31044 T:30562 P:13141'
G[13069]='K0802 L077 A:30074 T:30074'
G[13070]='K0780 L077 A:28179 T:30657 P:13045'
G[13071]='K0802 L077 A:30216 T:30216 P:12992'
G[13072]='K0800 L077 A:30562 T:31044 P:13068'
G[13073]='K0800 L077 A:31044 T:11832 P:13072'
G[13074]='K0800 L077 A:11832 T:11832 P:13073'
G[13075]='K0800 L077 A:11832 T:30562 P:13074'
G[13076]='K0800 L077 A:30562 T:31044 P:13075'
G[13077]='K0800 L077 A:31044 T:26917 P:13076'
G[13078]='K0800 L077 A:26917 T:26917 P:13077'
G[13079]='K0800 L077 A:26917 T:30562 P:13078'
G[13080]='K0800 L077 A:30562 T:31044 P:13079'
G[13081]='K0800 L077 A:31044 T:18481 P:13080'
G[13082]='K0800 L077 A:18481 T:30562 P:13081'
G[13083]='K0800 L077 A:1192833 T:31044 P:13082'
G[13084]='K0800 L077 A:30002 T:30002'
G[13085]='K0800 L077 A:29343 T:30218'
G[13086]='K0780 L077 A:30657 T:30657 P:13070'
G[13087]='FA K0000 L065 A:26905 T:26905 P:PC350 I:13088'
G[13088]='FA K0000 L065 A:26989 T:26989 P:PC350 I:13087'
G[13089]='FH K0000 L065 A:26953 T:26953 P:PC350 I:13090'
G[13090]='FH K0000 L065 A:26972 T:26972 P:PC350 I:13089'
G[13091]='K0800 L077 A:30232 T:30232 P:13043'
G[13092]='K0800 L077 A:30232 T:30232 P:12999'
G[13093]='K0801 L077 A:30232 T:30232 P:13092'
G[13094]='FA K0710 L068 A:26110 T:26110'
G[13095]='FH K0710 L068 A:26110 T:26110 P:1'
G[13097]='K0780 L074 A:28401 T:30671 P:12730 Z13329'
G[13099]='K0780 L074 A:28527 T:30676 Z13329'
G[13100]='FA K0002 L065 A:28705 T:29527 P:PC350 I:13101,13102,13103,13107'
G[13101]='FA K0002 L065 A:28705 T:29049 P:PC350 I:13100,13102,13103,13107'
G[13102]='FA K0002 L065 A:28705 T:29532 P:PC350 I:13100,13101,13103,13107'
G[13103]='FA K0002 L065 A:28705 T:28718 P:PC350 I:13100,13101,13102,13107'
G[13104]='K0780 L077 XK A:30677 T:30596 P:13086'
G[13105]='K0780 L077 CK A:30677 T:30596 P:13086'
G[13106]='K0800 L077 A:29343 T:30631'
G[13107]='FA K0002 L065 A:28705 T:28160 P:PC350 I:13100,13101,13102,13103'
G[13108]='K0800 L077 A:30105 T:30105 P:13047 Z13329'
G[13109]='K0800 L077 A:30105 T:30105 P:13047 Z13329'	-- should this be P:B13108 instead?
G[13110]='K0780 L077 A:30683 T:30683 P:13104,13105'
G[13112]='FH K0002 L065 A:29631 T:29527 P:PC350 I:13113,13114,13115,13116'
G[13113]='FH K0002 L065 A:29631 T:29049 P:PC350 I:13112,13114,13115,13116'
G[13114]='FH K0002 L065 A:29631 T:29532 P:PC350 I:13112,13113,13115,13116'
G[13115]='FH K0002 L065 A:29631 T:28718 P:PC350 I:13112,13113,13114,13116'
G[13116]='FH K0002 L065 A:29631 T:28160 P:PC350 I:13112,13113,13114,13115'
G[13117]='K0800 L077 A:30631 T:30631'
G[13118]='K0780 L077 A:30596 T:30596 P:13104,13105'
G[13119]='K0800 L077 A:30631 T:30631'
G[13120]='K0800 L077 A:30631 T:30631'
G[13121]='K0800 L077 A:30232 T:30232 P:13091'
G[13122]='K0780 L077 A:30596 T:30596 P:13104,13105'
G[13124]='K0800 L077 A:26117 T:27658 P:1'
G[13125]='K0790 L077 A:30596 T:30596 P:13118+13122'
G[13126]='K0800 L077 A:27658 T:28012 P:13124'
G[13127]='K0800 L077 A:28012 T:28012 P:13126'
G[13128]='K0800 L077 A:28012 T:26117 P:13127'
G[13129]='K0740 L072 A:55677 T:55677'
G[13130]='K0790 L077 A:30686 T:30686 P:13104,13105'
G[13131]='K0800 L077 A:30871 T:30871'
G[13132]='K0800 L077 A:30871 T:30871'
G[13133]='K0800 L077 A:30232 T:30232 P:13121'
G[13134]='K0800 L077 A:30631 T:30631'
G[13135]='K0790 L077 A:30714 T:30714 P:13104,13105'
G[13136]='K0800 L077 A:100043242 T:30708'
G[13137]='K080512 L077 A:30232 T:30232 P:13133'	-- PM5
G[13138]='K0800 L077 A:30708 T:30708'
G[13139]='K0790 L077 A:30683 T:30677 P:13110+13124+13130+13135'
G[13140]='K0800 L077 A:30708 T:30708'
G[13141]='K0790 L077 A:30677 T:30683 P:13139'
G[13142]='K080512 L077 A:30232 T:30232 P:13137'	-- PM5
G[13143]='K0800 L077 A:30944 T:30944 P:13155'
G[13144]='K0800 L077 A:30631 T:30631'
G[13145]='K0800 L077 A:30944 T:30944 P:13143'
G[13146]='K0800 L077 A:30944 T:30944'
G[13147]='K0800 L077 A:30944 T:30944'
G[13148]='K0001 L077 A:100043297 T:28701 P:PJ375'
G[13149]='K0800 L078 A:26527 T:27915'
G[13151]='K0800 L078 A:27915 T:30997 P:13149'
G[13152]='K0800 L077 A:30631 T:30631'
G[13153]='FA K0804 L075 A:31051 T:31051'
G[13154]='FA K0804 L075 A:31052 T:31052'
G[13155]='K0800 L077 A:30946 T:30944'
G[13156]='FA K0804 L075 A:31054 T:31054'
G[13157]='K0790 L077 A:30683 T:31044 P:13141'
G[13160]='K0800 L077 A:30944 T:30944'
G[13161]='K080512 L077 A:30944 T:30944'	-- PM5
G[13162]='K080512 L077 A:30944 T:30944'	-- PM5
G[13163]='K080512 L077 A:30944 T:30944'	-- PM5
G[13164]='K080512 L077 A:30944 T:30944'	-- PM5
G[13165]='K0550 L055 CK A:29173 T:31084 P:12801'
G[13166]='K0550 L055 CK A:31084 T:31084 P:13165'
G[13167]='K0740 L072 A:26653 T:26653 Z20338'
G[13168]='K0800 L077 A:30946 T:30946'
G[13169]='K0800 L077 A:30946 T:30946'
G[13170]='K0800 L077 A:30946 T:30946'
G[13171]='K0800 L077 A:30946 T:30946'
G[13172]='K0800 L077 A:30946 T:30946'
G[13174]='K0800 L077 A:30946 T:30946'
G[13177]='FA K1104 L085 A:31036 T:31036'
G[13178]='FH K1104 L085 A:31091 T:31091'
G[13179]='FA K1104 L085 A:31036 T:31036'
G[13180]='FH K1104 L085 A:31091 T:31091'
G[13181]='FA K1104 L085 A:31153 T:31153'
G[13182]='K0740 L072 A:26653 T:26653 Z20338'
G[13183]='FH K1104 L085 A:31151 T:31151'
G[13185]='FH K1104 L085 A:31107 T:31107'
G[13186]='FA K1104 L085 A:31109 T:31109'
G[13187]='K0760 L071 A:26653 T:26653'
G[13188]='FA K0550 L055 CK A:31084 T:29611 P:13166'
G[13189]='FH K0550 L055 CK A:31084 T:39605,45530 P:13166'
G[13191]='FH K0804 L075 A:31106 T:31106'
G[13192]='FH K0804 L075 A:31101 T:31101'
G[13193]='FH K0804 L075 A:31102 T:31102'
G[13194]='FH K0804 L075 A:31053 T:31053'
G[13195]='FA K0804 L075 A:31054 T:31054'
G[13196]='FA K0804 L075 A:31052 T:31052'
G[13197]='FA K0804 L075 A:31108 T:31108'
G[13198]='FA K0804 L075 A:31051 T:31051'
G[13199]='FH K0804 L075 A:31102 T:31102'
G[13200]='FH K0804 L075 A:31106 T:31106'
G[13201]='FH K0804 L075 A:31053 T:31053'
G[13202]='FH K0804 L075 A:31101 T:31101'
G[13204]='K0760 L073 A:100043512 T:26653 Z20338'
G[13205]='FA K0710 L068 A:24111 T:24111 Z20338'
G[13206]='FH K0710 L068 A:24137 T:23780 Z20338'
G[13207]='K0780 L075 A:28070 T:28070'
G[13211]='K0800 L077 A:30708 T:30708'
G[13212]='K0800 L077 A:30631 T:30631'
G[13213]='K0800 L077 A:30232 T:31135 P:13142'
G[13214]='K080512 L077 A:31135 T:31154'	-- PM5
G[13215]='K080512 L077 A:31135 T:31154'	-- PM5
G[13216]='K080512 L077 A:31135 T:31154'	-- PM5
G[13217]='K080512 L077 A:31135 T:31154'	-- PM5
G[13218]='K080512 L077 A:31135 T:31154'	-- PM5
G[13219]='K080512 L077 A:31135 T:31154'	-- PM5
G[13220]='K0800 L077 A:30631 T:30631 P:13212'
G[13221]='FA K0800 L077 A:31279 T:31259'
G[13222]='FA K1104 L085 A:31109 T:31109'
G[13223]='FH K1104 L085 A:31107 T:31107'
G[13224]='FH K0790 L077 A:31240 T:30824'
G[13225]='FA K0790 L077 A:31241 T:30344'
G[13226]='FA K0780 L077 A:31259 T:28179'
G[13227]='FH K0780 L077 A:31261 T:28179'
G[13228]='FH K0800 L077 A:30824 T:30824'
G[13229]='FH K0800 L077 A:31279 T:31261'
G[13230]='FH K0800 L077 A:31273 T:30824'
G[13231]='FA K0800 L077 A:30344 T:30344'
G[13232]='FA K0800 L077 A:31304 T:30344'
G[13233]='FA K080258 L077 A:30344 T:30344'
G[13234]='FH K080258 L077 A:30824 T:30824'
G[13235]='K0800 L077 A:30631 T:30631 P:13220'
G[13236]='FH K0800 L077 A:32404 T:32404 P:13305'
G[13237]='FH K0800 L077 A:29795 T:29795 P:13260,14447,14448'
G[13238]='FH K0800 L077 A:30824 T:30825'
G[13239]='FH K0800 L077 A:30825 T:30825 P:13238'
G[13258]='FH K0800 L077 A:29795 T:31440'
G[13259]='FH K0800 L077 A:31440 T:31440 P:13258'
G[13260]='FH K0800 L077 A:30824 T:29795'
G[13261]='FH K0802 L077 A:30825 T:30825'
G[13262]='FH K0800 L077 A:31440 T:1193400 P:13259'
G[13263]='FH K0800 L077 A:1193400 T:1193195 P:13262'
G[13264]='FH K0800 L077 A:29795 T:29795'
G[13265]='SP FA K0000 L000 A:27001 T:27001 P:PT325 I:13268,13269,13270,13272'
G[13268]='SP FA K0000 L000 A:26914 T:26914 P:PT325 I:13265,13269,13270,13272'
G[13269]='SP FH K0000 L000 A:26964 T:26964 P:PT325 I:13265,13268,13270,13272'
G[13270]='SP FH K0000 L000 A:26969 T:26969 P:PT325 I:13265,13268,13269,13272'
G[13271]='FH K0800 L077 A:1193195 T:31237 P:13263'
G[13272]='SP K0000 L000 A:28699 T:28699 P:PT325 I:13265,13268,13269,13270'
G[13273]='FH K0800 L077 A:29579 T:29579 P:12928'
G[13274]='FH K0800 L077 A:29579 T:29579 P:13273'
G[13275]='FH K0800 L077 A:31237 T:31237 P:13271'
G[13276]='FH K0802 L077 A:29795 T:29795'
G[13277]='FH K080512 L077 A:29795 T:29795'	-- PM3
G[13278]='FH K0800 L077 A:29795 T:29795'
G[13279]='FH K080512 L077 A:29795 T:29795 P:13277'	-- PM5
G[13280]='FA K080258 L077 A:31776 T:31776 P:13296'
G[13281]='FH K0802 L077 A:29795 T:29795'
G[13282]='FH K0800 L077 A:31237 T:29795 P:13275'
G[13283]='FH K080258 L077 A:31781 T:31781 P:13293'
G[13284]='FA K0802 L077 A:31737 T:31808'
G[13285]='FH K0800 L077 A:29579 T:29651 P:13274'
G[13286]='FA K0800 L077 A:30344 T:29799'
G[13287]='FA K0800 L077 A:29799 T:29799 P:13286'
G[13288]='FA K0800 L077 A:29799 T:29799'
G[13289]='FA K0802 L077 A:29799 T:29799'
G[13290]='FA K0800 L077 A:30344 T:30345'
G[13291]='FA K0800 L077 A:30345 T:30345 P:13290'
G[13292]='FA K0802 L077 A:30345 T:30345'
G[13293]='FH K0800 L077 A:30825 T:31781'
G[13294]='FA K080512 L077 A:29799 T:29799'	-- PM3
G[13295]='FA K080512 L077 A:29799 T:29799 P:13294'	-- PM5
G[13296]='FA K0800 L077 A:30345 T:31776'
G[13297]='FA K0802 L077 A:29799 T:29799'
G[13298]='FA K0800 L077 A:29799 T:29799'
G[13300]='FA K0802 L077 A:31259 T:31259'
G[13301]='FH K0802 L077 A:31833 T:31834'
G[13302]='FH K0802 L077 A:31261 T:31261'
G[13304]='FH K0800 L077 A:29795 T:31868 P:13282'
G[13305]='FH K0800 L077 A:32408 T:32404'
G[13306]='FH K0800 L077 A:29795 T:29795'
G[13307]='FH K0800 L077 A:29795 T:29795'
G[13308]='K080512 L077 A:31892 T:31892'	-- PM3
G[13309]='FA K0802 L077 A:31808 T:31808'
G[13310]='FH K0802 L077 A:31834 T:31834'
G[13311]='K0450 L040 A:100044158 T:30481'
G[13312]='FH K080512 L077 A:29795 T:29795'	-- PM5
G[13313]='FH K0800 L077 A:30824 T:30824'
G[13314]='FA K0800 L077 A:30344 T:30344'
G[13315]='FA K0800 L077 A:29799 T:29799'
G[13316]='FH K080512 L077 A:29795 T:29795'	-- PM5
G[13318]='FA K0800 L077 A:29799 T:29799'
G[13319]='FA K0800 L077 A:29799 T:29799'
G[13320]='FA K0800 L077 A:29799 T:30345'
G[13321]='FA K0800 L077 A:30345 T:30345 P:13320'
G[13322]='FA K0802 L077 A:30345 T:30345'
G[13323]='FA K0802 L077 A:29799 T:29799'
G[13324]='K0800 L001 A:100044259 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13325]='K0800 L001 A:100044276 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13326]='K0800 L001 A:100044326 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13327]='K0800 L001 A:100044294 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13328]='FH K080512 L077 A:29795 T:29795'	-- PM5
G[13329]='FH K080512 L077 A:29795 T:29795'	-- PM5
G[13330]='FH K0802 L077 A:32301 T:32301'
G[13331]='FH K0802 L077 A:30824 T:30824'
G[13332]='FA K0800 L077 A:29799 T:29799'
G[13333]='FA K0802 L077 A:30344 T:30344'
G[13334]='FA K0800 L077 A:29799 T:29799'
G[13335]='FA K080512 L077 A:29799 T:29799'	-- PM5
G[13336]='FA K0802 L077 A:32302 T:32302'
G[13337]='FA K080512 L077 A:29799 T:29799'	-- PM5
G[13338]='FA K080512 L077 A:29799 T:29799'	-- PM5
G[13339]='FA K080512 L077 A:29799 T:29799'	-- PM5
G[13340]='FH K0800 L077 A:32301 T:31834'
G[13341]='FA K0800 L077 A:32302 T:31808'
G[13342]='FA K0800 L077 A:29799 T:29799'
G[13343]='K0800 L080 A:27856 T:27856'
G[13344]='FA K0802 L077 A:29799 T:29799'
G[13345]='FA K080512 L077 A:29799 T:29799'	-- PM3
G[13346]='FA K080512 L077 A:29799 T:29799 P:13345'	-- PM5
G[13348]='FH K0800 L077 A:32404 T:29795 P:13236'
G[13349]='FH K0800 L077 A:29795 T:29795 P:13348'
G[13350]='FA K0802 L077 A:29799 T:29799'
G[13351]='FH K0800 L077 A:29795 T:29795'
G[13352]='FH K0800 L077 A:29795 T:29795'
G[13353]='FH K0802 L077 A:29795 T:29795'
G[13354]='FH K0800 L077 A:29795 T:29795'
G[13355]='FH K0800 L077 A:29795 T:30825'
G[13356]='FH K0800 L077 A:30825 T:30825 P:13355'
G[13357]='FH K0802 L077 A:30825 T:30825'
G[13358]='FH K0800 L077 A:29795 T:29795'
G[13359]='FH K0800 L077 A:32423 T:32423'
G[13360]='FH K0800 L077 A:32423 T:32497'
G[13361]='FH K0800 L077 A:32497 T:32497 P:13360'
G[13362]='FH K0800 L077 A:32497 T:29795 P:13361'
G[13363]='FH K0800 L077 A:29795 T:31044'
G[13364]='FH K0800 L077 A:31044 T:31044 P:13363'
G[13365]='FH K0802 L077 A:29795 T:29795'
G[13366]='FH K080512 L077 A:29795 T:29795'	-- PM3
G[13367]='FH K080512 L077 A:29795 T:29795 P:13366'	-- PM5
G[13368]='FH K0802 L077 A:29795 T:29795'
G[13372]='K0800 L080 A:100044569 T:26917'
G[13373]='FH K0800 L077 A:32430 T:32430 P:13379 Z13329'
G[13375]='K0800 L080 A:100044577 T:26917'
G[13379]='FH K0800 L077 A:30825 T:32430'
G[13380]='FA K0800 L077 A:32444 T:32444 P:13383 Z13329'
G[13384]='K0800 L080 A:27990 T:27990'
G[13385]='K0800 L080 A:27990 T:27990'
G[13386]='FA K0800 L077 A:29799 T:31444'
G[13387]='FA K0800 L077 A:31444 T:31444 P:13386'
G[13388]='FA K0800 L077 A:31444 T:1193400 P:13387'
G[13389]='FA K0800 L077 A:1193400 T:1193195 P:13388'
G[13390]='FA K0800 L077 A:1193195 T:31237 P:13389'
G[13391]='FA K0800 L077 A:31237 T:31237 P:13390'
G[13392]='FA K0800 L077 A:31237 T:29799 P:13391'
G[13393]='FA K0800 L077 A:29799 T:31868 P:13392'
G[13394]='FA K0800 L077 A:32408 T:32404'
G[13395]='FA K0800 L077 A:32404 T:32404 P:13394'
G[13396]='FA K0800 L077 A:32404 T:29799 P:13395'
G[13397]='FA K0800 L077 A:29799 T:29799 P:13396'
G[13398]='FA K0800 L077 A:32423 T:32423'
G[13399]='FA K0800 L077 A:32423 T:32497 P:13398'
G[13400]='FA K0800 L077 A:32497 T:32497 P:13399'
G[13401]='FA K0800 L077 A:32497 T:29799 P:13400'
G[13402]='FA K0800 L077 A:29799 T:31044 P:13401'
G[13403]='FA K0800 L077 A:31044 T:31044 P:13402'
G[13404]='FA K0802 L077 A:32444 T:32444 Z13329'
G[13406]='FH K0802 L077 A:32430 T:32430 Z13329'
G[13408]='FA K060256 L055 XK A:18266 T:18266 P:10143,10483'
G[13409]='FH K060256 L055 XK A:18267 T:18267'
G[13410]='FA K060256 L055 CK A:18266 T:18266 P:10143,10483'
G[13411]='FH K060256 L055 CK A:18267 T:18267'
G[13412]='K0800 L080 A:26110 T:32548 P:11919'	-- P:11919 is incorrect as it is available upon arrival in Borean Tundra
G[13413]='K0800 L080 A:32548 T:32548 P:13412'
G[13414]='K0802 L080 A:32548 T:32548 P:13413'
G[13415]='FA K0800 L077 A:29579 T:1191760 P:12860'
G[13416]='FH K0800 L077 A:29579 T:1191760 P:12927'
G[13418]='FA K0800 L077 A:31081 T:30344'
G[13419]='FH K0801 L077 A:31085 T:30824'
G[13420]='K0770 L077 A:100044725 T:32594'
G[13421]='K0771 L077 A:32594 T:32594 P:T45F44999'
G[13422]='K0792 L077 A:29796 T:29796 P:13061 I:13423,13424,13425'
G[13423]='K0802 L077 A:29796 T:29796 P:13061 I:13422,13424,13425'	-- P:13061 seems to be wrong since I am able to get the quest with in log: 12925,12851(complete but not turned in),12942 and 12968
G[13424]='K0802 L077 A:29796 T:29796 P:13061 I:13422,13423,13425'
G[13425]='K0802 L077 A:29796 T:29796 P:13061 I:13422,13423,13424'
G[13426]='FH K0800 L077 A:29651 T:30381 P:13285'
G[13429]='K0700 L070 A:18528 T:18528 P:10949 I:10985'	-- just a copy of 10985
G[13430]='K0700 L070 A:18481 T:18481 P:10588'
G[13431]='K0700 L070 M070 A:22421 T:22421'
G[13432]='K0700 L070 A:19935,19936 T:19935'
G[13433]='SP HW FA K00016 L001 A:1194056 T:1194056'
G[13434]='SP HW FA K00016 L001 A:1194057 T:1194057'
G[13435]='SP HW FA K00016 L001 A:1194058 T:1194058'
G[13436]='SP HW FA K00016 L001 A:1194059 T:1194059'
G[13437]='SP HW FA K00016 L001 A:1194060 T:1194060'
G[13438]='SP HW FA K00016 L001 A:1194061 T:1194061'
G[13439]='SP HW FA K00016 L001 A:1194062 T:1194062'
G[13440]='SP HM FH K0000 L001 A:1194032 T:1194032'
G[13441]='SP HM FA K0000 L001 A:1194033 T:1194033'
G[13442]='SP HM FH K0000 L001 A:1194035 T:1194035'
G[13443]='SP HM FH K0000 L001 A:1194036 T:1194036'
G[13444]='SP HM FH K0000 L001 A:1194038 T:1194038'
G[13445]='SP HM FH K0000 L001 A:1194041 T:1194041'
G[13446]='SP HM FH K0000 L001 A:1194044 T:1194044'
G[13447]='SP HM FH K0000 L001 A:1194045 T:1194045'
G[13448]='SP HW FA K00016 L001 A:1194063 T:1194063'
G[13449]='SP HM FH K0000 L001 A:1194049 T:1194049'
G[13450]='SP HM FA K0000 L001 A:1194034 T:1194034'
G[13451]='SP HM FA K0000 L001 A:1194037 T:1194037'
G[13452]='SP HW K00016 L001 A:1194065 T:1194065'
G[13453]='SP HM FA K0000 L001 A:1194039 T:1194039'
G[13454]='SP HM FA K0000 L001 A:1194042 T:1194042'
G[13455]='SP HM FA K0000 L001 A:1194043 T:1194043'
G[13456]='SP HW K00016 L001 A:1194066 T:1194066'
G[13457]='SP HM FA K0000 L001 A:1194046 T:1194046'
G[13458]='SP HM FA K0000 L001 A:1194048 T:1194048'
G[13459]='SP HW K00016 L001 A:1194067 T:1194067'
G[13460]='SP HW K00016 L001 A:1194068 T:1194068'
G[13461]='SP HW K00016 L001 A:1194069 T:1194069'
G[13462]='SP HW K00016 L001 A:1194070 T:1194070'
G[13463]='SP HW K00016 L001 A:1194071 T:1194071'
G[13464]='SP HW FH K00016 L001 A:1194073 T:1194073'
G[13465]='SP HW FH K00016 L001 A:1194074 T:1194074'
G[13466]='SP HW FH K00016 L001 A:1194075 T:1194075'
G[13467]='SP HW FH K00016 L001 A:1194076 T:1194076'
G[13468]='SP HW FH K00016 L001 A:1194077 T:1194077'
G[13469]='SP HW FH K00016 L001 A:1194078 T:1194078'
G[13470]='SP HW FH K00016 L001 A:1194079 T:1194079'
G[13471]='SP HW FH K00016 L001 A:1194080 T:1194080'
G[13472]='SP HW K00016 L001 A:1194072 T:1194072'
G[13473]='SP HW FA K00016 L001 A:1194064 T:1194064'
G[13474]='SP HW FH K00016 L001 A:1194081 T:1194081'
G[13479]='HN FH K0002 L001 A:32798 T:32798 O:13483'
G[13480]='HN FA K0002 L001 A:32799 T:32799 O:13484'
G[13481]='FH K0800 L077 A:32800 T:31261'
G[13482]='FA K0800 L077 A:32800 T:31259'
G[13483]='HN FH K00016 L001 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:32798'
G[13484]='HN FA K00016 L001 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:32799'
G[13485]='SP HM FA K0000 L001 A:32801 T:32801'
G[13486]='SP HM FA K0000 L001 A:32802 T:32802'
G[13487]='SP HM FA K0000 L001 A:32803 T:32803'
G[13488]='SP HM FA K0000 L001 A:32804 T:32804'
G[13489]='SP HM FA K0000 L001 A:32805 T:32805'
G[13490]='SP HM FA K0000 L001 A:32806 T:32806'
G[13491]='SP HM FA K0000 L001 A:32807 T:32807'
G[13492]='SP HM FA K0000 L001 A:32808 T:32808'
G[13493]='SP HM FH K0000 L001 A:32809 T:32809'
G[13494]='SP HM FH K0000 L001 A:32810 T:32810'
G[13495]='SP HM FH K0000 L001 A:32811 T:32811'
G[13496]='SP HM FH K0000 L001 A:32812 T:32812'
G[13497]='SP HM FH K0000 L001 A:32813 T:32813'
G[13498]='SP HM FH K0000 L001 A:32814 T:32814'
G[13499]='SP HM FH K0000 L001 A:32815 T:32815'
G[13500]='SP HM FH K0000 L001 A:32816 T:32816'
G[13501]='SP HW FH K00016 L001 A:1194084 T:1194084'
G[13502]='HN FA K00016 L001 A:32836 T:32836'
G[13503]='HN FH K00016 L001 A:32837 T:32837'
G[13504]='FA K0130 L010 A:32965 T:32965 P:13589'
G[13505]='FA K0130 L010 A:32966 T:32966 P:13589'
G[13506]='FA K0130 L010 A:100044979 T:32963'
G[13507]='FA K0130 L010 A:32965 T:32965 P:13505'
G[13508]='FA K0130 L010 A:32963 T:33055 P:13506'
G[13509]='FA K0130 L010 A:32963 T:32963 P:13504'
G[13510]='FA K0130 L010 A:32964 T:32963 P:K100045040'
G[13511]='FA K0130 L010 A:33055 T:32963 P:13508'
G[13512]='FA K0140 L010 A:32963 T:32963 P:13507+13509'
G[13513]='FA K0140 L010 A:32966 T:32966 P:13507+13509'
G[13514]='FA K0140 L010 A:33176 T:33176 P:B13590'
G[13515]='FA K0140 L010 A:33178 T:533178,33178 P:13590'
G[13518]='FA K0100 L008 A:32973 T:32973 O:26383,26385,28490'
G[13519]='FA K0130 L013 A:32912 T:32912 P:13591'
G[13520]='FA K0100 L008 A:32972 T:532972 P:13518+13522'
G[13521]='FA K0100 L008 A:32977 T:1194105 P:13518+13522'
G[13522]='FA K0100 L008 A:32971 T:32971'
G[13523]='FA K0130 L013 A:32932 T:32932'
G[13525]='FA K0190 L017 A:33250 T:32967'
G[13526]='FA K0190 L017 A:32967 T:32967 O:13525'
G[13527]='FA K0110 L008 A:1194105 T:32977 P:13521'
G[13528]='FA K0110 L008 A:32977 T:1194122 P:13527'
G[13529]='FA K0110 L008 A:32978 T:32978 P:13528'
G[13537]='FA K0110 L008 A:33175 T:33175 P:13518+13522'
G[13538]='FA K1104 L085 A:31153 T:31153'
G[13539]='FH K1104 L085 A:31151 T:31151'
G[13542]='FA K0150 L013 A:3694 T:3694'
G[13543]='FA K0150 L013 A:32987 T:32987'
G[13544]='FA K0190 L017 A:32967 T:32967 P:13526'
G[13545]='FA K0190 L017 A:32967 T:32967 P:13544'
G[13546]='FA K0190 L017 A:32967 T:32967 P:13545'
G[13547]='FA K0150 L013 A:6887 T:6887'
G[13548]='SP HW FH K00016 L001 A:1194119 T:1194119'
G[13549]='K0770 L074 A:28527 T:28527 P:12635'
G[13554]='FA K0110 L008 A:1194122 T:32977 P:13528'
G[13556]='K0770 L074 A:33025 T:33025'
G[13557]='FA K0110 L008 A:100044927 T:32978'
G[13558]='FA K0160 L013 A:6887 T:32987 P:13547'
G[13559]='SP K0801 L077 A:32540 T:32540 P:T45F41999'
G[13560]='FA K0130 L008 A:32979 T:32979 P:13569'
G[13561]='FA K0110 L008 A:33177 T:33177'
G[13562]='FA K0110 L008 A:32971 T:32971 P:13529'
G[13563]='FA K0110 L008 A:32959,532959 T:32959,532959 P:13529'
G[13564]='FA K0110 L008 A:32960 T:33048 P:13529'
G[13565]='FA K0120 L010 A:33126 T:33126 P:13564'
G[13566]='FA K0120 L010 A:33048 T:33048 P:13564'
G[13567]='SP FA K0120 L010 A:33133 T:-42 P:B13569 I:13568,13597'
G[13568]='SP FA K0120 L010 A:33131 T:-42 P:B13569 I:13567,13597'
G[13569]='FA K0120 L010 A:33048 T:33048 P:13565+13566+13598'
G[13570]='SP FA K0150 L010 A:532959 T:532959 P:13591'
G[13571]='K0800 L000 A:32516 T:32516 P:12645'
G[13572]='FA K0190 L017 A:32968 T:32968 P:13544'
G[13573]='FA K0150 L013 A:32987 T:33091'
G[13575]='FA K0150 L013 A:33091 T:33117'
G[13576]='FA K0150 L013 A:33117 T:33117 P:13575'
G[13577]='FA K0160 L013 A:33091 T:33119'
G[13578]='FA K0170 L013 A:33119 T:33119 P:13577'
G[13579]='FA K0150 L013 A:33091 T:33112'
G[13580]='FA K0170 L013 A:33117 T:33117 P:13576'
G[13581]='FA K0150 L013 A:33117 T:33091 P:13580'
G[13582]='FA K0150 L013 A:33119 T:33119 P:13578'
G[13583]='FA K0160 L013 A:33119 T:33091 P:13582'
G[13584]='FA K0160 L013 A:33112 T:33112 P:13579'
G[13585]='FA K0170 L013 A:33112 T:33091 P:13584'
G[13586]='FA K0170 L013 A:33091 T:33166 P:13581+13583+13585'
G[13587]='FA K0170 L013 A:33166 T:33166 P:13586'
G[13588]='FA K0170 L013 A:33091 T:33091 P:13940'
G[13589]='FA K0130 L010 A:32971 T:32963 P:13569'
G[13590]='FA K0140 L010 A:32963 T:33178 P:13512+13513'
G[13591]='FA K0150 L010 A:100046318 T:532971 P:C13515'
G[13592]='FA K0802 L077 A:33222 T:33222 P:B13718'
G[13593]='FA K0800 L077 A:33225 T:33225 P:13732,13733,13734,13735 I:13684,B13714,B13715,B13716,B13717'
G[13594]='FA K0210 L019 A:33187 T:33187 O:26408,28492'
G[13595]='FA K0210 L019 A:33182 T:33182'
G[13596]='FA K0130 L013 A:32912 T:32912 P:13591'
G[13597]='SP FA K0120 L010 A:33132 T:-42 P:B13569 I:13567,13568'
G[13598]='FA K0120 L010 A:33048 T:33048 P:13564'
G[13599]='FA K0120 L010 A:33048 T:32972 P:13569'
G[13600]='FA K0802 L077 A:33225 T:33225 P:B13718 I:13603,13616'
G[13601]='FA K0150 L013 A:32912 T:33107 P:13596'
G[13602]='FA K0210 L019 A:3845 T:3845'
G[13603]='FA K0802 L077 A:33225 T:33225 P:B13718 I:13600,13616'
G[13604]='K0800 L080 A:100045506 T:1194555'
G[13605]='FA K0150 L013 A:33232 T:33231'
G[13606]='K0800 L080 A:33956 T:33956'
G[13607]='K0800 L080 A:33956 T:33956'
G[13609]='K0800 L080 A:33956 T:33956'
G[13610]='K0800 L080 A:33956 T:33956'
G[13611]='K0800 L080 A:33956 T:33956'
G[13612]='FH K0210 L019 A:8582 T:8582'	-- P:28493,28876 incorrect
G[13613]='FH K0210 L019 A:33263 T:33263'
G[13614]='K0800 L080 A:33956 T:1194555'
G[13615]='FH K0210 L019 A:33284 T:33284'
G[13616]='FA K0802 L077 A:33225 T:33225 P:B13718 I:13600,13603'
G[13617]='FA K0210 L019 A:33187 T:3846 P:13594'
G[13618]='FH K0210 L019 A:8582 T:33294'
G[13619]='FH K0210 L019 A:33294 T:8582 P:13618'
G[13620]='FH K0210 L019 A:8582 T:33263 P:13619'
G[13621]='FH K0210 L019 A:33263 T:8582 P:13620'
G[13623]='FA K0210 L019 A:33204 T:3847 P:26473'
G[13624]='FA K0210 L019 A:11806 T:11806'
G[13625]='FA K0802 L077 A:33647 T:33647 P:B13672'
G[13626]='FA K0210 L019 A:11806 T:11806 P:13624'
G[13628]='FH K0210 L019 A:33284 T:33421 P:13621'
G[13630]='FA K0210 L019 A:33276 T:33276'
G[13631]='K0800 L080 A:100046052 T:16128'
G[13632]='FA K0210 L019 A:11219 T:11219'
G[13633]='FA K0800 L077 A:33417 T:33417'
G[13634]='FH K0800 L077 A:33417 T:33417 P:13633'
G[13635]='FA K0110 L010 A:1960 T:1092 P:26855'
G[13636]='FA K0130 L012 A:1340 T:1343'
G[13639]='FA K0160 L014 A:1105 T:2057 P:26868'
G[13640]='FH K0210 L019 A:33421 T:33421 P:13628'
G[13641]='K0800 L077 A:33417 T:33417 P:13633,13634'
G[13642]='FA K0210 L019 A:3847 T:3847 P:13623'
G[13643]='K0800 L077 A:33417 T:33417 P:13641'
G[13644]='FA K0220 L019 A:33443 T:33443'
G[13645]='FA K0230 L019 A:3847 T:3691 P:26464'
G[13646]='FA K0230 L019 A:33445 T:33454 P:26464'
G[13647]='FA K0160 L012 A:1345 T:1154 P:13650+26961 I:257'	-- *** I picked the I: code because it seems to be true for older characters.  Basically newer characters can get this quest and there are no issues with any of the quests at Farstrider Lodge or even with the leadin from Ironforge.  Therefore, older characters that cannot get this are assumed to have completed a hunting quest before, and that is my force of the I: code. ***
G[13648]='FA K0120 L008 A:1000256 T:1139'
G[13650]='FA K0160 L012 A:1344 T:1344 P:309'
G[13651]='FH K0210 L019 A:33421 T:33421 P:13640'
G[13653]='FH K0210 L019 A:33421 T:8582 P:13651'
G[13654]='K0800 L077 A:33417 T:33417 P:13643'
G[13655]='FA K0160 L008 A:1194378 T:1153'
G[13656]='FA K0160 L008 A:1194387 T:1153'
G[13657]='FA K0160 L008 A:1194388 T:1153'
G[13658]='FA K0160 L008 A:1194389 T:1153'
G[13659]='FA K0170 L008 A:1194390 T:1153'
G[13660]='FA K0160 L008 A:1194391 T:1153'
G[13661]='SP FA K0180 L008 A:1153,-35 T:1153 P:13655+13656+13657+13658+13659+13660'
G[13662]='K0501 L046 A:14624 T:14624 P:28064+U03B83999'
G[13663]='K0800 L077 A:33417 T:33417'
G[13664]='K0800 L077 A:33417 T:33417 P:13663+13702|13732|13733|13734|13735|13736|13737|13738|13739|13740'
G[13665]='FA K0802 L077 A:33223 T:33223 P:B13718'
G[13666]='FA K0802 L077 A:33625 T:33625 P:B13672 I:13669,13670'
G[13667]='FA K0800 L077 A:33817 T:33625'
G[13668]='FH K0800 L077 A:33817 T:33542'
G[13669]='FA K0802 L077 A:33625 T:33625 P:B13672 I:13666,13670'
G[13670]='FA K0802 L077 A:33625 T:33625 P:B13672 I:13666,13669'
G[13671]='FA K0802 L077 A:33646 T:33646 P:B13672'
G[13672]='FA K0800 L077 A:33625 T:33625 P:13828+13835+13837'
G[13673]='FH K0802 L077 A:33542 T:33542 P:B13678 I:13674,13675'
G[13674]='FH K0802 L077 A:33542 T:33542 P:B13678 I:13673,13675'
G[13675]='FH K0802 L077 A:33542 T:33542 P:B13678 I:13673,13674'
G[13676]='FH K0802 L077 A:33658 T:33658 P:B13678'
G[13677]='FH K0802 L077 A:33659 T:33659 P:B13678'
G[13678]='FH K0800 L077 A:33542 T:33542 P:13829+13838+13839'
G[13679]='FA K0800 L077 A:33625 T:33625 P:13672'
G[13680]='FH K0800 L077 A:33542 T:33542 P:13678'
G[13682]='FA K080514 L077 XK A:33759 T:33759 P:J2773+13794'	-- PM3
G[13683]='FA K0210 L019 A:33727 T:33727 P:26468'
G[13684]='FA K0800 L077 RH RA A:33625 T:33225 P:13679 I:13593'	-- AS Is this where the Tushui Pandaren start their Tournament?
G[13685]='FA K0800 L077 RF A:33625 T:33312 P:13679 I:13703'
G[13688]='FA K0800 L077 RN A:33625 T:33335 P:13679 I:13704'
G[13689]='FA K0800 L077 RE RW A:33625 T:33592 P:13679 I:13706'
G[13690]='FA K0800 L077 RD A:33625 T:33593 P:13679 I:13705'
G[13691]='FH K0800 L077 RO RG RA A:33542 T:33361 P:13680 I:13707'	-- AS Is this where the Huojin Pandaren start their Tournament?
G[13693]='FH K0800 L077 RL A:33542 T:33372 P:13680 I:13708'
G[13694]='FH K0800 L077 RT A:33542 T:33403 P:13680 I:13709'
G[13695]='FH K0800 L077 RU A:33542 T:33373 P:13680 I:13710'
G[13696]='FH K0800 L077 RB A:33542 T:33379 P:13680 I:13711'
G[13697]='FH K0800 L077 A:33361 T:33361'
G[13698]='FA K0210 L019 A:17287 T:17287 P:26457'
G[13699]='FA K0800 L077 A:33225 T:33225 P:13718'
G[13702]='FA K0800 L077 A:33225 T:33817 P:13699'
G[13703]='FA K0800 L077 A:33312 T:33312 P:13702,13733,13734,13735 I:13685,B13715,B13716,B13717,B13718'
G[13704]='FA K0800 L077 A:33335 T:33335 P:13702,13732,13734,13735 I:13688,B13714,B13716,B13717,B13718'
G[13705]='FA K0800 L077 A:33593 T:33593 P:13702,13732,13733,13735 I:13690,B13714,B13715,B13717,B13718'
G[13706]='FA K0800 L077 A:33592 T:33592 P:13702,13732,13733,13734 I:13689,B13714,B13715,B13716,B13718'
G[13707]='FH K0800 L077 A:33361 T:33361 P:13737,13738,13739,13740 I:13691,B13719,B13720,B13721,B13722'
G[13708]='FH K0800 L077 A:33372 T:33372 P:13736,13738,13739,13740 I:13693,B13697,B13720,B13721,B13722'
G[13709]='FH K0800 L077 A:33403 T:33403 P:13736,13737,13739,13740 I:13694,B13697,B13719,B13721,B13722'
G[13710]='FH K0800 L077 A:33373 T:33373 P:13736,13737,13738,13740 I:13695,B13697,B13719,B13720,B13722'
G[13711]='FH K0800 L077 A:33379 T:33379 P:13736,13737,13738,13739 I:13696,B13697,B13719,B13720,B13721'
G[13712]='FH K0210 L019 A:8582 T:33837 P:13653'
G[13713]='FA K0800 L077 A:33312 T:33312 P:13714'
G[13714]='FA K0800 L077 A:33312 T:33312 P:13679 I:B13715,B13716,B13717,B13718'
G[13715]='FA K0800 L077 A:33335 T:33335 P:13679 I:B13714,B13716,B13717,B13718'
G[13716]='FA K0800 L077 A:33593 T:33593 P:13679 I:B13714,B13715,B13717,B13718'
G[13717]='FA K0800 L077 A:33592 T:33592 P:13679 I:B13714,B13715,B13716,B13718'
G[13718]='FA K0800 L077 A:33225 T:33225 P:13679 I:B13714,B13715,B13716,B13717'
G[13719]='FH K0800 L077 A:33372 T:33372'
G[13720]='FH K0800 L077 A:33403 T:33403'
G[13721]='FH K0800 L077 A:33373 T:33373'
G[13722]='FH K0800 L077 A:33379 T:33379'
G[13723]='FA K0800 L077 A:33335 T:33335 P:13715'
G[13724]='FA K0800 L077 A:33593 T:33593 P:13716'
G[13725]='FA K0800 L077 A:33592 T:33592 P:13717'
G[13726]='FH K0800 L077 A:33361 T:33361 P:13697'
G[13727]='FH K0800 L077 A:33372 T:33372 P:13719'
G[13728]='FH K0800 L077 A:33403 T:33403 P:13720'
G[13729]='FH K0800 L077 A:33373 T:33373 P:13721'
G[13730]='FH K0210 L019 A:33726 T:33726 P:13803'
G[13731]='FH K0800 L077 A:33379 T:33379 P:13722'
G[13732]='FA K0800 L077 A:33312 T:33817 P:13713'
G[13733]='FA K0800 L077 A:33335 T:33817 P:13723'
G[13734]='FA K0800 L077 A:33593 T:33817 P:13724'
G[13735]='FA K0800 L077 A:33592 T:33817 P:13725'
G[13736]='FH K0800 L077 A:33361 T:33817'
G[13737]='FH K0800 L077 A:33372 T:33817'
G[13738]='FH K0800 L077 A:33403 T:33817'
G[13739]='FH K0800 L077 A:33373 T:33817'
G[13740]='FH K0800 L077 RB A:33379 T:33817'
G[13741]='FA K0802 L077 A:33312 T:33312 P:B13714 I:13742,13743'
G[13742]='FA K0802 L077 A:33312 T:33312 P:B13714 I:13741,13743'
G[13743]='FA K0802 L077 A:33312 T:33312 P:B13714 I:13741,13742'
G[13744]='FA K0802 L077 A:33315 T:33315 P:B13714'
G[13745]='FA K0802 L077 A:33309 T:33309 P:B13714'
G[13746]='FA K0802 L077 A:33335 T:33335 P:B13715 I:13747,13748'
G[13747]='FA K0802 L077 A:33335 T:33335 P:B13715 I:13746,13748'
G[13748]='FA K0802 L077 A:33335 T:33335 P:B13715 I:13746,13747'
G[13749]='FA K0802 L077 A:33648 T:33648 P:B13715'
G[13750]='FA K0802 L077 A:33649 T:33649 P:B13715'
G[13751]='FH K0220 L019 A:33726 T:33760 P:13730'
G[13752]='FA K0802 L077 A:33593 T:33593 P:B13716 I:13753,13754'
G[13753]='FA K0802 L077 A:33593 T:33593 P:B13716 I:13752,13754'
G[13754]='FA K0802 L077 A:33593 T:33593 P:B13716 I:13752,13753'
G[13755]='FA K0802 L077 A:33655 T:33655 P:B13716'
G[13756]='FA K0802 L077 A:33656 T:33656 P:B13716'
G[13757]='FA K0802 L077 A:33592 T:33592 P:B13717 I:13758,13759'
G[13758]='FA K0802 L077 A:33592 T:33592 P:B13717 I:13757,13759'
G[13759]='FA K0802 L077 A:33592 T:33592 P:B13717 I:13757,13758'
G[13760]='FA K0802 L077 A:33652 T:33652 P:B13717'
G[13761]='FA K0802 L077 A:33654 T:33654 P:B13717'
G[13762]='FH K0802 L077 A:33361 T:33361'
G[13763]='FH K0802 L077 A:33361 T:33361'
G[13764]='FH K0802 L077 A:33361 T:33361'
G[13765]='FH K0802 L077 A:33405 T:33405'
G[13766]='FA K0210 L019 A:17310 T:17310 P:26446'
G[13767]='FH K0802 L077 A:33544 T:33544'
G[13768]='FH K0802 L077 A:33372 T:33372'
G[13769]='FH K0802 L077 A:33372 T:33372'
G[13770]='FH K0802 L077 A:33372 T:33372'
G[13771]='FH K0802 L077 A:33540 T:33540'
G[13772]='FH K0802 L077 A:33545 T:33545'
G[13773]='FH K0802 L077 A:33403 T:33403'
G[13774]='FH K0802 L077 A:33403 T:33403'
G[13775]='FH K0802 L077 A:33403 T:33403'
G[13776]='FH K0802 L077 A:33539 T:33539'
G[13777]='FH K0802 L077 A:33549 T:33549'
G[13778]='FH K0802 L077 A:33373 T:33373'
G[13779]='FH K0802 L077 A:33373 T:33373'
G[13780]='FH K0802 L077 A:33373 T:33373'
G[13781]='FH K0802 L077 A:33541 T:33541'
G[13782]='FH K0802 L077 A:33547 T:33547'
G[13783]='FH K0802 L077 A:33379 T:33379'
G[13784]='FH K0802 L077 A:33379 T:33379'
G[13785]='FH K0802 L077 A:33379 T:33379'
G[13786]='FH K0802 L077 A:33538 T:33538'
G[13787]='FH K0802 L077 A:33548 T:33548'
G[13788]='FA K080514 L077 CK A:33762 T:33762 P:J2773+13795'	-- PM3
G[13789]='FA K0802 L077 XK A:33763 T:33763 P:13794'
G[13790]='FA K0802 L077 XK A:33771 T:33771 P:13794'
G[13791]='FA K0802 L077 CK A:33769 T:33769 P:13795'
G[13792]='FA K0210 L019 A:17310 T:33777 P:13766'
G[13793]='FA K0802 L077 CK A:33770 T:33770 P:13795'
G[13794]='K0800 L077 XK A:33817 T:33759 P:13702,13732,13733,13734,13735,13736,13737,13738,13739,13740 I:13795'
G[13795]='K0800 L077 CK A:33817 T:33762 P:13702,13732,13733,13734,13735,13736,13737,13738,13739,13740 I:13794'
G[13796]='FA K0210 L019 A:33777 T:17310 P:13792'
G[13797]='FH K0220 L019 A:33760 T:33760 P:13751'
G[13798]='FH K0220 L019 A:33760 T:33977 P:13797'
G[13801]='FH K0210 L019 A:12724 T:12724 P:13803'
G[13803]='FH K0220 L019 A:33837 T:33760 P:13712'
G[13805]='FH K0220 L019 A:33760 T:33837 P:13803'
G[13806]='FH K0220 L019 A:11820 T:11820'	-- removed  P:26449 because 26449 seems to be removed...need to check what P exists now
G[13808]='FH K0220 L019 A:33837 T:33889 P:13805'
G[13809]='FH K080514 L077 XK A:33759 T:33759 P:J2773+13794'	-- PM3
G[13810]='FH K0802 L077 XK A:33763 T:33763 P:13794'
G[13811]='FH K0802 L077 XK A:33771 T:33771 P:13794'
G[13812]='FH K080514 L077 CK A:33762 T:33762 P:J2773+13795'	-- PM3
G[13813]='FH K0802 L077 CK A:33769 T:33769 P:13795'
G[13814]='FH K0802 L077 CK A:33770 T:33770 P:13795'
G[13815]='FH K0220 L019 A:33889 T:33889 P:13808'
G[13816]='K0800 L080 A:33957 T:33957'
G[13817]='K0800 L080 A:100045857 T:1194555'
G[13818]='K0800 L080 A:33957 T:1194555'
G[13819]='K0800 L080 A:100046053 T:16128'
G[13821]='K0800 L080 A:33957 T:33957'
G[13822]='K0800 L080 A:33957 T:33957'
G[13823]='K0800 L080 A:33957 T:33957'
G[13824]='K0800 L080 A:33957 T:33957'
G[13825]='SP K0000 L000 A:40589 T:40589 P:PC225 I:6610'
G[13826]='K0000 L000 A:12919 T:12919 P:6607+k100045858'
G[13828]='FA K0800 L077 A:33625 T:33625 P:13667'
G[13829]='FH K0800 L077 A:33542 T:33542 P:13668'
G[13830]='K0002 L070 A:28742 T:28742 P:PF001 I:13832,13833,13834,13836'
G[13831]='FA K0110 L008 A:1194714 T:32978 P:13528'
G[13832]='K0002 L070 A:28742 T:28742 P:PF001 I:13830,13833,13834,13836'
G[13833]='K0002 L070 A:28742 T:28742 P:PF001 I:13830,13832,13834,13836'
G[13834]='K0002 L070 A:28742 T:28742 P:PF001 I:13830,13832,13833,13836'
G[13835]='FA K0800 L077 A:33647 T:33647'
G[13836]='K0002 L070 A:28742 T:28706 P:PF001 I:13830,13832,13833,13834'
G[13837]='FA K0800 L077 A:33646 T:33646'
G[13838]='FH K0800 L077 A:33659 T:33659'
G[13839]='FH K0800 L077 A:33658 T:33658'
G[13841]='FH K0220 L019 A:33726 T:39605 P:13798'
G[13842]='FH K0230 L019 A:39605 T:39605 P:13841'
G[13844]='FA K0140 L010 A:34041 T:34041 P:13507+13509'
G[13845]='K0800 L070 A:100046004 T:29535'
G[13846]='K0802 L077 A:34210 T:34210'
G[13847]='FA K0802 L077 A:33223 T:33223 P:B13718'
G[13848]='FH K0220 L019 A:33837 T:34122 P:13805'
G[13849]='FA K0230 L020 A:4079 T:4079'
G[13850]='FH K0530 L048 A:11701 T:11701'
G[13851]='FA K0802 L077 A:33309 T:33309 P:B13714'
G[13852]='FA K0802 L077 A:33649 T:33649 P:B13715'
G[13853]='FA K0230 L020 A:4079 T:4079 P:13849'
G[13854]='FA K0802 L077 A:33656 T:33656 P:B13716'
G[13855]='FA K0802 L077 A:33654 T:33654 P:B13717'
G[13856]='FH K0802 L077 A:33544 T:33544'
G[13857]='FH K0802 L077 A:33545 T:33545'
G[13858]='FH K0802 L077 A:33549 T:33549'
G[13859]='FH K0802 L077 A:33548 T:33548'
G[13860]='FH K0802 L077 A:33547 T:33547'
G[13861]='FA K0802 L077 XK A:33759 T:33759 P:13794'
G[13862]='FH K0802 L077 XK A:33759 T:33759 P:13794'
G[13863]='FH K0802 L077 CK A:33762 T:33762 P:13795'
G[13864]='FA K0802 L077 CK A:33762 T:33762 P:13795'
G[13865]='FH K0220 L019 A:33889 T:33889 P:13808'
G[13866]='FH K0200 L018 A:34195 T:8582 P:24463'
G[13867]='FA K0230 L021 A:3691 T:3691'
G[13868]='FA K0230 L021 A:100046128 T:3691'
G[13869]='FA K0210 L019 A:17310 T:17310 P:26454'
G[13870]='FH K0220 L019 A:33889 T:17304 P:13815+13865'
G[13871]='FH K0220 L019 A:17304 T:17304 P:13870'
G[13872]='FA K0230 L021 A:3691 T:34239 P:13868'
G[13873]='FH K0220 L019 A:34233 T:34242 P:13871'
G[13874]='FA K0230 L021 A:34239 T:34239 P:13872'
G[13875]='FH K0220 L019 A:34242 T:33726'
G[13876]='FA K0240 L021 A:34251 T:34251 P:13868'
G[13877]='FA K0230 L021 A:34239 T:34283 P:13874'
G[13878]='FH K0110 L009 A:34284 T:34284'
G[13879]='FH K0230 L021 A:34510 T:34512 P:13947'
G[13880]='K0230 L021 A:34290 T:34290 P:13877,13879'
G[13881]='FA K0180 L016 A:34301 T:34301'
G[13882]='FA K0180 L016 A:34301 T:34301 P:13881'
G[13883]='FH K0220 L019 A:34303 T:34303'
G[13884]='K0230 L021 A:34292 T:34292 P:13877,13879'
G[13885]='FA K0190 L016 A:34301 T:34301 P:13925'
G[13886]='FA K0240 L021 A:34289 T:34283 P:13880+13884'
G[13887]='FH K0530 L048 A:11701 T:11701 P:13850'
G[13888]='FH K0240 L021 A:34289 T:34512 P:13880+13884'
G[13889]='FH K0532 L048 RO RB A:34320 T:34320'
G[13890]='FH K0220 L019 A:34122 T:34122'
G[13891]='FA K0180 L016 A:34301 T:34301 P:13885'
G[13892]='FA K0190 L017 A:34402 T:34402'
G[13893]='FA K0190 L017 A:34340 T:34404 P:13896'
G[13895]='FA K0190 L017 A:33072 T:34446 P:13893'
G[13896]='FA K0190 L017 A:34404 T:34340 P:13948'
G[13897]='FA K0190 L017 A:34422 T:34402 P:13900'
G[13898]='FA K0200 L017 A:34403 T:34403 P:13953'
G[13899]='FA K0200 L017 A:34402 T:34423 P:13953'
G[13900]='FA K0200 L017 A:34423 T:34422 P:13899'
G[13901]='FH K0220 L019 A:12719 T:12719'	-- Can this still be gotten in 4.3.3?
G[13902]='FA K0180 L017 A:33091 T:34402 P:13588'
G[13903]='FH K0532 L048 RO RB A:34320 T:34320'
G[13904]='FH K0532 L048 RO RB A:34320 T:34320'
G[13905]='FH K0532 L048 RO RB A:34320 T:34320'
G[13906]='FH K0530 L048 A:11701 T:11701 P:13887'
G[13907]='FA K0180 L016 A:34340 T:34340'
G[13909]='FA K0180 L016 A:34340 T:34340 P:13907'
G[13910]='FA K0180 L016 A:34340 T:34340 P:13909'
G[13911]='FA K0180 L016 A:34343 T:34342'
G[13912]='FA K0180 L016 A:34342 T:34342'
G[13913]='FA K0250 L024 A:34354 T:34354'
G[13914]='FH K0532 L048 A:34320 T:34320'
G[13915]='FH K0532 L048 A:34320 T:34320'
G[13916]='FH K0532 L048 A:34320 T:34320'
G[13917]='FH K0532 L048 A:34320 T:34320'
G[13918]='FA K0180 L016 A:34342 T:34342 P:13912'
G[13919]='FA K0230 L019 A:3894 T:-43 P:26475'	-- after about 5 seconds
G[13920]='FH K0220 L019 A:34122 T:34122 P:13890'
G[13921]='FA K0230 L019 A:-43 T:34335 P:13919 I:14018'	-- TODO: Research if this is gotten first is the other gotten after abandoning this?
G[13922]='FA K0230 L019 A:34335 T:34335 P:13921,14018'
G[13923]='FH K0220 L019 A:34122 T:34359 P:13920'
G[13924]='FA K0230 L019 A:34358 T:3894 P:13922'	-- after a few seconds
G[13925]='FA K0180 L016 A:34301 T:34301 P:13882'
G[13926]='HC K0000 L070 A:34365 T:33533 I:13927'
G[13927]='HC K0000 L070 A:34365 T:33532 I:13926'
G[13928]='FA K0230 L021 A:3880 T:34377'
G[13929]='HC K0000 L070 A:33533 T:500039 P:13926'
G[13930]='HC K0000 L070 A:33532 T:500010 P:13927'
G[13933]='HC K0000 L070 A:33533 T:500038 P:13926'
G[13934]='HC K0000 L070 A:33532 T:500009 P:13927'
G[13935]='FA K0230 L021 A:34377 T:3880 P:13928'
G[13936]='FH K0230 L021 A:34359 T:34395 P:13923'
G[13937]='HC K0000 L070 A:33533 T:33533 P:13956+13954'
G[13938]='HC K0000 L070 A:33532 T:33532 P:13955+13957'
G[13940]='FA K0170 L013 A:33166 T:33091 P:13587'
G[13942]='FH K0230 L021 A:34395 T:34395 P:13936'
G[13943]='FH K0230 L021 A:34359 T:34359 P:13936'
G[13944]='FH K0230 L021 A:34395 T:34359 P:13942'
G[13945]='FA K0070 L004 A:2081 T:2081 P:476'
G[13946]='FA K0070 L004 A:2083 T:2083 P:489'
G[13947]='FH K0230 L021 A:34359 T:34359 P:13944'
G[13948]='FA K0190 L017 A:34402 T:34402 P:13892'
G[13949]='FH K0120 L009 A:34258 T:5907 P:872+5041'
G[13950]='HC K0000 L070 A:33533 T:533533 P:13926'
G[13951]='HC K0000 L070 A:33532 T:533532 P:13927'
G[13952]='HD FA K00016 L001 RH A:34435 T:34435 I:14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[13953]='FA K0190 L017 A:34498 T:34402 P:13895'
G[13954]='HC K0000 L070 A:33533 T:500040 P:13929+13933+13950'
G[13955]='HC K0000 L070 A:33532 T:500011 P:13930+13934+13951'
G[13956]='HC K0000 L070 A:33533 T:500041 P:13929+13933+13950'
G[13957]='HC K0000 L070 A:33532 T:500012 P:13930+13934+13951'
G[13958]='FH K0230 L021 A:34359 T:34518 P:13947'
G[13959]='HC K0000 L070 A:33533 T:34365 P:13937+k100046545+s200033530'
G[13960]='HC K0000 L070 A:33532 T:34365 P:13938+k100046544+s200033529'
G[13961]='FH K0120 L010 A:34513 T:34513'
G[13962]='FH K0240 L022 A:34518 T:34518 P:13958'
G[13963]='FH K0120 L010 A:34513 T:34513 P:13961'
G[13964]='FA K0250 L023 A:4079 T:3885 P:26478'
G[13965]='FA K0250 L023 A:3996 T:24739 P:26478'
G[13967]='FH K0250 L023 A:12696 T:12696'
G[13968]='FH K0120 L010 A:34513 T:34513 P:13963'
G[13969]='FH K0120 L010 A:5907 T:34547 P:13963'
G[13970]='FH K0120 L010 A:34547 T:34547 P:13969'
G[13971]='FH K0120 L010 A:34547 T:5907 P:13970'
G[13973]='FH K0120 L010 A:34560 T:34560'
G[13974]='FH K0230 L021 A:34395 T:34569 P:13947'
G[13975]='FH K0130 L011 A:34578 T:3429 P:13949'
G[13976]='FA K0250 L023 A:24739 T:3698 O:13965'
G[13977]='FH K0240 L021 A:34569 T:34596 P:13974'
G[13979]='FA K0250 L023 A:34354 T:34354'
G[13980]='FH K0250 L023 A:34596 T:34596 P:13977'
G[13981]='FA K0250 L023 A:1195134 T:34354'
G[13982]='FA K0260 L023 A:3698 T:3698 P:13976'
G[13983]='FH K0250 L023 A:34596 T:34596 P:13977'
G[13985]='FA K0250 L023 A:34599 T:34604 P:13982'
G[13987]='FA K0250 L023 A:34604 T:34604 P:13985'
G[13988]='FH K0130 L010 A:3448 T:34626 P:870'
G[13989]='K0260 L019 A:3897 T:3897 P:26480'
G[13991]='FH K0150 L013 A:3338 T:3464 P:905'
G[13992]='FH K0130 L011 A:34613 T:34613'
G[13995]='FH K0140 L012 A:34634 T:34638'
G[13998]='FH K0140 L010 A:3390 T:3390 P:848'
G[13999]='FH K0140 L010 A:3390 T:34651 P:13998'
G[14001]='FH K0060 L001 RG A:36600 T:35650 P:14239'
G[14003]='FH K0160 L014 A:3442 T:34674 P:29024'
G[14004]='FH K0160 L014 A:9316 T:3442 P:29027'
G[14005]='FA K0100 L001 A:1992 T:1992 P:933'
G[14006]='FH K0160 L014 A:3442 T:3442 P:14004'
G[14007]='K0030 L002 RG CH A:34673 T:34673 ODC:14137'
G[14008]='K0030 L002 RG CM A:34689 T:34689 ODC:14137'
G[14009]='K0030 L002 RG CT A:34692 T:34692 ODC:14137'
G[14010]='K0030 L002 RG CR A:34693 T:34693 ODC:14137'
G[14011]='K0030 L002 RG CS A:34695 T:34695 ODC:14137'
G[14012]='K0030 L002 RG CL A:34696 T:34696 ODC:14137'
G[14013]='K0030 L002 RG CW A:34697 T:34697 ODC:14137'
G[14014]='FH K0060 L001 RG A:35650 T:35650 P:14001'
G[14016]='K0800 L077 A:33417 T:33417 P:13664'
G[14017]='K0800 L077 A:33417 T:33417 P:14016'
G[14018]='FA K0230 L019 A:-43 T:34335 P:13919 I:13921'
G[14019]='FH K0060 L001 RG A:35758 T:35758 P:14001'
G[14021]='FH K0060 L001 RG A:35769 T:35769 P:14248'
G[14022]='HY FA K00016 L001 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:34675'
G[14023]='HY FA K00016 L001 A:34675 T:34744'
G[14024]='HY FA K0000 L001 A:34744 T:34644 P:14023'
G[14028]='HY FA K00016 L001 A:34644 T:34744 P:14024'
G[14030]='HY FA K00016 L001 A:34744 T:34676 P:14028'
G[14031]='FH K0060 L001 RG A:35769 T:35650 P:14248'
G[14033]='HY FA K00016 L001 A:34676 T:34675 P:14030'
G[14034]='FH K0160 L014 A:3391 T:3391'
G[14035]='HY FA K00016 L001 A:34675 T:34676 P:14033'
G[14036]='HY FH K0000 L001 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:34677'
G[14037]='HY FH K00016 L001 A:34677 T:34768'
G[14038]='FH K0164 L014 A:3391 T:-11,3391 P:14034'
G[14039]='FA K0110 L001 A:503515 T:7999 P:935'
G[14040]='HY FH K00016 L001 A:34768 T:34679 P:14037'	-- technically requires PC100, but one can obtain the quest prior to the skill being there, however, one can never complete the skill unless one knows the recipe which is skill 100 minimum
G[14041]='HY FH K00016 L001 A:34679 T:34678 P:14040'	-- PC160 (see 14040)
G[14042]='FH K0160 L014 A:3391 T:3391 P:14038'
G[14043]='HY FH K00016 L001 A:34678 T:34679 P:14041'	-- PC220 (see 14040)
G[14044]='HY FH K00016 L001 A:34679 T:34677 P:14043'
G[14045]='FH K0160 L014 A:3391 T:3467'
G[14046]='FH K0164 L014 A:3467 T:-11,3467 P:14045'
G[14047]='HY FH K00016 L001 A:34677 T:34679 P:14044'	-- PC280 (see 14040)
G[14048]='HY FA K0002 L001 A:34708 T:34708'
G[14049]='FH K0160 L014 A:3467 T:3391 P:14046'
G[14050]='FH K0160 L014 A:3391 T:3391 P:14049'
G[14051]='HY FA K0002 L001 A:34708 T:34708'
G[14052]='FH K0160 L014 A:3453 T:34749'
G[14053]='HY FA K0002 L001 A:34710 T:34710'
G[14054]='HY FA K0002 L001 A:34711 T:34711'
G[14055]='HY FA K0002 L001 A:34744 T:34744'
G[14056]='FH K0160 L014 A:34749 T:34749 P:14052'
G[14057]='FH K0160 L014 A:34749 T:34749 P:14056'
G[14058]='HY FH K0002 L001 A:34768 T:34768'
G[14059]='HY FH K0002 L001 A:34712 T:34712'
G[14060]='HY FH K0002 L001 A:34714 T:34714'
G[14061]='HY FH K0002 L001 A:34713 T:34713'
G[14062]='HY FH K0002 L001 A:34713 T:34713'
G[14063]='FH K0170 L014 A:34749 T:3453 P:14057'
G[14064]='HY FA K0000 L000 A:34653 T:34653'
G[14065]='HY FH K0000 L000 A:34654 T:34654'
G[14066]='FH K0154 L013 A:3464 T:-11,3464 O:13991'
G[14067]='FH K0150 L013 A:-100011,3464 T:3464 P:869'
G[14068]='FH K0160 L014 A:34828 T:34828'
G[14069]='K0010 L001 RG A:34872 T:34872 P:14138'
G[14070]='K0030 L001 RG A:34668 T:34668 P:14071'
G[14071]='K0030 L001 RG A:34874 T:34874 P:28349'
G[14072]='FH K0150 L013 A:34638 T:34638'
G[14073]='FH K0180 L016 A:34841 T:34841 P:850+851'
G[14074]='FA K0802 L077 A:34880 T:34880 P:J3676 D101'
G[14075]='K0010 L001 RG A:34872 T:34872 P:14138'
G[14076]='FA K0802 L077 A:34912 T:34912 P:J3676 I:14090,14112'
G[14077]='FA K0802 L077 A:34880 T:34880 P:J3676 D101'
G[14078]='FA K0010 L001 RW A:34850 T:34863'
G[14080]='FA K0802 L077 A:34880 T:34880 P:J3676 D101'
G[14090]='FA K0802 L077 A:34912 T:34912 P:J3676 I:14076,14112'
G[14091]='FA K0020 L001 RW A:34863 T:34913 P:14078'
G[14092]='FH K0802 L077 A:34914 T:34914 P:J3677 I:14141,14145'
G[14093]='K0020 L001 RW A:34913 T:34913 P:14091'
G[14094]='FA K0020 L001 RW A:34936 T:34936 P:14078'
G[14095]='K0802 L078 A:100046955 T:35094 P:B14108'
G[14096]='FA K0802 L077 A:34880 T:34880 P:J3676 D101'
G[14098]='K0020 L001 RW A:34913 T:34913 P:14091'
G[14099]='FA K0030 L001 RW A:34913 T:35840 P:14094+14093+14098'
G[14101]='K0802 L077 A:34882 T:34882 P:J2817,J2816'
G[14102]='K0802 L077 A:34882 T:34882 P:J2817,J2816'
G[14103]='SP K0001 L065 A:28701 T:28701 P:PJ001'	-- does this require possession of item 46849 (Titanium Powder)?
G[14104]='K0802 L077 A:34882 T:34882 P:J2817,J2816'
G[14105]='K0802 L077 A:34882 T:34882 P:J2817,J2816'
G[14107]='K0802 L077 A:35094 T:35094 P:J2817,J2816'
G[14108]='K0802 L078 A:35094 T:35094 P:J2817,J2816'
G[14109]='FH K0030 L001 RG GM A:35120,535120 T:35053 P:26712 ODC:14114'
G[14110]='FH K0030 L001 RG GF A:35120,535120 T:35054 P:26711 ODC:14114'
G[14112]='FA K0802 L077 A:34912 T:34912 P:J3676 I:14076,14090'
G[14113]='K0030 L001 RG GM A:35053 T:34668 P:14137+24520+14070+14109 ODC:14139'
G[14114]='K0000 L000 T:35054 J:A14109,A14110'
G[14115]='K0040 L001 RG A:34668 T:34668 P:14113,14153'
G[14116]='FH K0040 L001 RG A:34668 T:35222 P:14115'
G[14117]='FH K0100 L008 A:8576 T:8576'
G[14118]='FH K0100 L008 A:8576 T:8576'
G[14120]='FH K0040 L001 RG A:35222 T:534668 P:14116 ODC:14158'
G[14121]='FH K0040 L001 RG A:534874 T:34874 P:14120'
G[14122]='K0040 L001 RG A:534668 T:34668 P:14120'
G[14123]='FH K0040 L001 RG A:34693 T:34693 P:14120'
G[14124]='FH K0040 L001 RG A:534872 T:534872 P:14120'
G[14125]='K0050 L001 RG A:534668 T:37602 P:14121+14122+14123+14124'
G[14126]='FH K0050 L001 RG A:534668 T:535222 P:14125'
G[14127]='FH K0100 L008 A:100047039 T:8576'	-- there are reports that the NPC 35095 who drops the start quest item phase out at some point.  need to investigate this.
G[14128]='FH K0100 L008 A:8576 T:35087 P:14127'
G[14129]='FH K0110 L009 A:35086 T:-181,35086 O:25275,28496'
G[14130]='FH K0170 L015 A:35867 T:35142 P:14407'
G[14131]='FH K0170 L015 A:35142 T:35142 P:14130'
G[14132]='FH K0170 L015 A:35142 T:35142 P:14130'
G[14134]='FH K0110 L009 A:-181,35086 T:-181,35086 P:14129'
G[14135]='FH K0110 L009 A:-181,35086 T:-181,35086 P:14134'
G[14136]='FH K0802 L078 A:34771 T:34771 P:J3677 D102'
G[14137]='K0000 L000 T:34695 J:14007,14008,14009,14010,14011,14012,14013'
G[14138]='FH K0010 L001 RG A:34668 T:34872'
G[14139]='K0000 L000 T:34668 J:A14113,A14153'
G[14140]='FH K0802 L077 A:34771 T:34771 P:J3677 D102'
G[14141]='FH K0802 L077 A:34914 T:34914 P:J3677 I:14092,14145'
G[14142]='FH K0802 L077 A:34771 T:34771 P:J3677 D102'
G[14143]='FH K0802 L077 A:34771 T:34771 P:J3677 D102'
G[14144]='FH K0802 L077 A:34771 T:34771 P:J3677 D102'
G[14145]='FH K0802 L077 A:34914 T:34914 P:J3677 I:14092,14141'
G[14146]='FH K0110 L009 A:-181 T:-181 P:14135'
G[14151]='K0001 L065 A:28703 T:28703 P:PA450'
G[14152]='FA K0802 L078 A:34880 T:34880 P:J3676 D101'
G[14153]='K0030 L001 RG GF A:35054 T:34668 P:14137+24520+14070+14110 ODC:14139'
G[14154]='FA K0040 L001 RW A:35077 T:35077 P:28850'
G[14155]='FH K0110 L009 A:-181 T:35086 P:14146'
G[14157]='FA K0040 L001 RW A:35112 T:50371 P:14285,14286,14287,14288,14289,14290,14291'
G[14158]='K0000 L000 T:34668 J:A14120'
G[14159]='FA K0040 L001 RW A:35112 T:35369 P:24930+26129'
G[14161]='FH K0110 L009 A:35091 T:35091 P:14162'
G[14162]='FH K0110 L009 A:35086 T:35091 P:14155'
G[14165]='FH K0110 L009 A:35091 T:35091'
G[14166]='HD K00016 L001 A:35256 T:35256 I:13952,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14167]='HD FA K00016 L001 RF A:34478 T:34478 I:13952,14166,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14168]='HD FA K00016 L001 RN A:34481 T:34481 I:13952,14166,14167,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14169]='HD FA K00016 L001 RD A:34484 T:34484 I:13952,14166,14167,14168,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14170]='HD FA K00016 L001 RE A:34479 T:34479 I:13952,14166,14167,14168,14169,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14171]='HD FH K00016 L001 RB A:34483 T:34483 I:13952,14166,14167,14168,14169,14170,14172,14173,14174,14175,14176,14177,27841,27846'
G[14172]='HD K00016 L001 A:35260 T:35260 P:T3A444999 I:13952,14166,14167,14168,14169,14170,14171,14173,14174,14175,14176,14177,27841,27846'
G[14173]='HD K00016 L001 A:35261 T:35261 P:T3A644999 I:13952,14166,14167,14168,14169,14170,14171,14172,14174,14175,14176,14177,27841,27846'
G[14174]='HD FH K00016 L001 RU A:34476 T:34476 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14175,14176,14177,27841,27846'
G[14175]='HD FH K00016 L001 RO A:34477 T:34477 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14176,14177,27841,27846'
G[14176]='HD FH K00016 L001 RT A:34480 T:34480 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14177,27841,27846'
G[14177]='HD FH K00016 L001 RL A:34482 T:34482 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,27841,27846'
G[14184]='FH K0300 L027 A:35286 T:35295 P:28548,26134'
G[14188]='FH K0300 L027 A:35295 T:35298 P:14184'
G[14189]='FH K0300 L027 A:35298 T:1195433 P:14188'
G[14190]='FH K0110 L009 A:35091 T:1195431 P:14165'
G[14191]='FH K0300 L027 A:1195433 T:1195433 P:14189'
G[14192]='FH K0110 L009 A:1195431 T:1195435 P:14190'
G[14193]='FA K0300 L027 A:1195438 T:-101'	-- T is correct, but at the location of the A code because of a ceremony performed there
G[14194]='FH K0110 L009 A:1195435 T:35091 P:14192'
G[14195]='FH K0310 L027 A:1195433 T:1195445 P:14360'
G[14196]='FH K0310 L027 A:1195445 T:1195445 P:14195'
G[14197]='FH K0110 L009 A:35085 T:35085'
G[14198]='FH K0310 L027 A:35506,35510,1195445 T:35295 P:14196'
G[14201]='FH K0120 L010 A:35087 T:35087 P:24453'
G[14202]='FH K0120 L010 A:35088 T:35088 P:24453'
G[14203]='FA K0801 L070 A:100048679 T:32337 P:PF001'
G[14204]='K0040 L001 RW A:35378 T:35378'
G[14209]='FH K0120 L010 A:35088 T:35088 P:14202'
G[14212]='K0050 L001 RW A:35552 T:35618 P:14294'
G[14213]='FH K0310 L027 A:1195497 T:1195497'
G[14214]='FA K0040 L001 RW A:35378 T:35550 P:14204'
G[14215]='FH K0120 L010 A:35087 T:-181,35087 P:14201'
G[14216]='FH K0120 L010 A:-181,35087 T:35087 P:14215'
G[14217]='FH K0311 L027 A:1195497 T:1195497'
G[14218]='K0050 L001 RW A:35618 T:35618 P:14212'
G[14219]='FH K0310 L027 A:1195517 T:1195517'
G[14221]='FA K0050 L001 RW A:35618 T:35566 P:14218'
G[14222]='K0050 L001 RW A:35566 T:35566 P:14221'
G[14223]='FH K0300 L027 A:35298 T:35298 P:14198'
G[14225]='FH K0310 L027 A:35298 T:35298 P:14223'
G[14226]='FH K0180 L015 A:35187 T:35187 P:14249+14250+14263'
G[14227]='FH K0310 L027 A:35298 T:35298 P:14225'
G[14230]='FH K0180 L015 A:35756 T:35756 P:14249+14250+14263'
G[14232]='FH K0310 L027 A:100049010 T:35298'
G[14233]='FH K0060 L001 RG A:35837 T:35650 P:14248'
G[14234]='FH K0060 L001 RG A:35650 T:35875 P:14021+14031+14233'
G[14235]='FH K0060 L001 RG A:35875 T:35893 P:14234'
G[14236]='FH K0060 L001 RG A:35893 T:35893 P:14235'
G[14237]='FH K0070 L001 RG A:35875 T:35917 P:14303'
G[14238]='FH K0070 L001 RG A:35917 T:35917 P:14237'
G[14239]='SP FH K0060 L001 RG A:36608 T:36608 P:14126'
G[14240]='FH K0070 L001 RG A:35917 T:36112 P:14238'
G[14241]='FH K0070 L001 RG A:36112 T:36127 P:14240'
G[14242]='FH K0070 L001 RG A:36127 T:36145 P:14241'
G[14243]='FH K0070 L001 RG A:36161 T:36188 P:14326'
G[14244]='FH K0070 L001 RG A:36425 T:36470 P:14445'
G[14245]='FH K0070 L001 RG A:36470 T:36471 P:14244 OCC:26705'
G[14246]='K0310 L027 A:35661 T:35661'
G[14247]='K0310 L027 A:35661 T:1195600'
G[14248]='FH K0060 L001 RG A:35650 T:35769 P:14014+14019+14473'
G[14249]='FH K0180 L015 A:35648 T:35648 P:14340'
G[14250]='FH K0180 L015 A:35755 T:35755 P:14340'
G[14251]='K0310 L027 A:35757 T:35757'
G[14252]='K0310 L027 A:35757 T:35757'
G[14253]='K0310 L027 A:35757 T:35757'
G[14254]='K0310 L027 A:1195600 T:35757 P:14247'
G[14255]='FH K0310 L027 A:35295 T:35773 P:14191'
G[14256]='K0320 L028 A:35773 T:35773 O:14255,14365'
G[14257]='K0320 L028 A:35773 T:35773 P:14256'
G[14258]='FH K0120 L010 A:35817 T:35817'
G[14260]='K0320 L028 A:35773 T:35827 P:14257'
G[14261]='FH K0190 L015 A:37064 T:37064'
G[14262]='FH K0130 L011 A:35657 T:35657 P:14258'
G[14263]='FH K0180 L015 A:35754 T:35754 P:14340'
G[14264]='K0320 L028 A:35827 T:35827 P:14260'
G[14265]='FA K0020 L001 RW CW A:35840 T:35839 P:14099 ODC:14269,14273,14275,14277,14278,14280'	--	Worgen skill quests are also ODC:24464,24465,24466,24481,24485,26201,26904 if want to be crazy about it
G[14266]='FA K0030 L001 RW CW A:35839 T:35839 P:14265 ODC:14272,14274,14276,14279,14281,14283'
G[14267]='FH K0130 L011 A:35657 T:1195642 P:14258'
G[14268]='K0320 L028 A:35827 T:-101,35773 P:14264'
G[14269]='FA K0020 L001 RW CR A:35840 T:35871 P:14099 ODC:14265,14273,14275,14277,14278,14280'
G[14270]='FH K0130 L011 A:1195642 T:1195642 P:14267'
G[14271]='FH K0130 L011 A:1195642 T:35657 P:14270'
G[14272]='FA K0020 L001 RW CR A:35871 T:35871 P:14269 ODC:14266,14274,14276,14279,14281,14283'
G[14273]='FA K0020 L001 RW CL A:35840 T:35869 P:14099 ODC:14265,14269,14275,14277,14278,14280'
G[14274]='FA K0020 L001 RW CL A:35869 T:35869 P:14273 ODC:14266,14272,14276,14279,14281,14283'
G[14275]='FA K0020 L001 RW CH A:35840 T:35874 P:14099 ODC:14265,14269,14273,14277,14278,14280'
G[14276]='FA K0020 L001 RW CH A:35874 T:35874 P:14275 ODC:14266,14272,14274,14279,14281,14283'
G[14277]='FA K0020 L001 RW CM A:35840 T:35872 P:14099 ODC:14265,14269,14273,14275,14278,14280'
G[14278]='FA K0020 L001 RW CT A:35840 T:35870 P:14099 ODC:14265,14269,14273,14275,14277,14280'
G[14279]='FA K0020 L001 RW CT A:35870 T:35870 P:14278 ODC:14266,14272,14274,14276,14281,14283'
G[14280]='FA K0020 L001 RW CD A:35840 T:35873 P:14099 ODC:14265,14269,14273,14275,14277,14278'
G[14281]='FA K0020 L001 RW CM A:35872 T:35872 P:14277 ODC:14266,14272,14274,14276,14279,14283'
G[14282]='K0320 L028 A:-101,35773 T:35773 P:14268'
G[14283]='FA K0020 L001 RW CD A:35873 T:35873 P:14280 ODC:14266,14272,14274,14276,14279,14281'
G[14284]='K0320 L028 A:35902 T:35902 P:14292'
G[14285]='FA K0030 L001 RW CR A:35871 T:35112 P:14272 ODC:14286,14287,14288,14289,14290,14291'
G[14286]='FA K0030 L001 RW CW A:35839 T:35112 P:14266 ODC:14285,14287,14288,14289,14290,14291'
G[14287]='FA K0030 L001 RW CL A:35869 T:35112 P:14274 ODC:14285,14286,14288,14289,14290,14291'
G[14288]='FA K0030 L001 RW CM A:35872 T:35112 P:14281 ODC:14285,14286,14287,14289,14290,14291'
G[14289]='FA K0030 L001 RW CT A:35870 T:35112 P:14279 ODC:14285,14286,14287,14288,14290,14291'
G[14290]='FA K0030 L001 RW CH A:35874 T:35112 P:14276 ODC:14285,14286,14287,14288,14289,14291'
G[14291]='FA K0030 L001 RW CD A:35873 T:35112 P:14283 ODC:14285,14286,14287,14288,14289,14290'
G[14292]='K0320 L028 A:35773 T:35902 P:14282'
G[14293]='FA K0040 L001 RW A:35550 T:35906 P:14214'
G[14294]='FA K0040 L001 RW A:35906 T:35911 P:14293'
G[14295]='FH K0130 L011 A:35657 T:35657 P:14271'
G[14296]='FH K0180 L015 A:36334 T:36361 P:14413'
G[14297]='FH K0190 L015 A:37061 T:37061'
G[14299]='FH K0180 L015 A:36361 T:36372 P:14300+24478+24479'
G[14300]='FH K0180 L015 A:36361 T:36335,36361 P:14296'
G[14301]='K0320 L028 A:35902 T:35773 P:14284'
G[14302]='K0320 L028 A:35773 T:36034 P:14301'
G[14303]='FH K0070 L001 RG A:35893 T:35875 P:14236'
G[14304]='K0330 L029 A:36048 T:36048'
G[14305]='K0320 L029 A:36060 T:36060'
G[14306]='K0320 L029 A:36060 T:36060'
G[14307]='K0320 L029 A:36034 T:36034'
G[14308]='FH K0130 L011 A:36077 T:1195676 O:14424'
G[14309]='K0320 L029 A:36048 T:36048 P:14304'
G[14310]='FH K0130 L011 A:1195676 T:36077 P:14308'
G[14311]='K0320 L029 A:36060 T:36060 P:14305'
G[14312]='K0320 L029 A:36052 T:36056 P:14311'
G[14313]='FA K0050 L005 RW A:36170 T:36132 P:14375'
G[14314]='K0320 L029 A:36056 T:36056 P:14312'
G[14316]='K0320 L029 A:36052 T:36052 P:14312'
G[14318]='K0330 L029 A:36056 T:36163 P:14314+14316'
G[14320]='FA K0050 L005 RW A:36132 T:1196394 P:14313'
G[14321]='FA K0050 L005 RW A:36205 T:34571 P:14320'
G[14322]='FH K0130 L011 A:36146 T:36146'
G[14323]='FH K0170 L015 A:35142 T:-181,35142 P:14130'
G[14324]='FH K0170 L015 A:-181,35142 T:35142 P:14323'
G[14325]='K0330 L029 A:36163,536163 T:536163 P:14318'
G[14326]='FH K0070 L001 RG A:36145 T:36161 P:14242'
G[14327]='K0330 L029 A:536163 T:36056 P:14325'
G[14328]='K0340 L029 A:36056 T:36185 P:14327'
G[14329]='K0340 L029 A:36185 T:-101,36185 P:14328'
G[14330]='K0350 L030 A:100038567 T:36196 P:14328'
G[14332]='K0350 L030 A:36196 T:36398 P:14330'
G[14333]='K0350 L029 A:1196393 T:-101,36185 P:14328'
G[14334]='FH K0350 L030 A:12031 T:12031'
G[14335]='FH K0350 L031 A:11624 T:11624'
G[14336]='FA K0050 L005 RW A:34571 T:36140 P:14321'
G[14337]='FH K0340 L030 A:36034 T:12031 P:14327 I:6142,14334'	-- guessed at possible quests that would invalidate this.  most likely either one of those will have an O of 14337 instead.  will need to test this.
G[14338]='FH K0320 L029 A:36034 T:4498'
G[14339]='FH K0330 L029 A:4498 T:4498 O:14338'
G[14340]='FH K0180 L015 A:36210 T:35187 P:14345'
G[14341]='FH K0320 L029 A:11259 T:11596'
G[14342]='FH K0350 L031 A:5395 T:5395'
G[14343]='FH K0340 L030 A:4498 T:36034 P:14339'
G[14344]='FH K0350 L030 A:100049200 T:5395,-101'
G[14345]='FH K0170 L015 A:35142 T:36210 P:14131+14132+14324'
G[14346]='FH K0340 L030 A:36034 T:36034 P:14343,14379'
G[14347]='FA K0050 L005 RW A:36140 T:36140 P:14336'
G[14348]='FA K0050 L005 RW A:36140 T:36140 P:14336'
G[14354]='FA K0310 L027 A:5642 T:5642 P:14387'
G[14357]='FA K0310 L027 A:1195517 T:1195517'
G[14358]='FA K0310 L027 A:1195497 T:1195497'
G[14359]='FA K0311 L027 A:1195497 T:1195497 P:14358'
G[14360]='FH K0300 L027 A:1195433 T:1195433 P:14191'
G[14361]='FA K0300 L027 A:5396 T:-101,5396 P:14354'
G[14362]='FA K0310 L027 A:100049203 T:5396'
G[14363]='FA K0310 L027 A:-101,5396 T:-101,5396 P:14361'
G[14364]='FA K0310 L027 A:-101,5396 T:5396 P:14363'
G[14365]='FA K0310 L027 A:5752 T:35773 P:14354'
G[14366]='FA K0050 L005 RW A:36140 T:34571 P:14347+14348'
G[14367]='FA K0060 L005 RW A:34571 T:36290 P:14366'
G[14368]='FA K0060 L005 RW A:36291 T:36291 P:14367'
G[14369]='FA K0060 L004 RW A:36290 T:36290 P:14367'
G[14370]='FH K0130 L011 A:36077 T:36077 P:14310'
G[14371]='FH K0130 L011 A:36077 T:36077 P:14310'
G[14372]='FA K0340 L031 A:36034 T:36329 P:14327'
G[14373]='FA K0350 L031 A:36329 T:36329 O:14372'
G[14374]='FA K0350 L031 A:36329 T:36329'
G[14375]='SP FA K0050 L001 RW A:36332 T:36332 P:14222'
G[14376]='FA K0350 L030 A:100049220 T:-101,36329'
G[14377]='FH K0130 L011 A:36077 T:36077 P:14370+14371'	-- 14371 required, guessing that 14370 is also required
G[14378]='FA K0340 L031 A:36329 T:36329 P:14373+14374'
G[14379]='FA K0340 L031 A:36378 T:36378 P:14373+14374'
G[14380]='FA K0340 L031 A:36329 T:36034 P:14378'
G[14381]='FA K0340 L030 A:36034 T:36034 P:14380'
G[14382]='FA K0060 L004 RW A:36290 T:36290 P:14367'
G[14383]='FH K0140 L011 A:36379 T:36379 P:14377'
G[14384]='FA K0300 L027 A:36410 T:5752 O:25938,28531'
G[14385]='FH K0140 L011 A:36077 T:36077 P:14377'
G[14386]='FA K0060 L004 RW A:36290 T:36290 P:14368+14369+14382'
G[14387]='FA K030 L027 A:5396 T:5642 P:14384'
G[14388]='FH K0140 L011 A:36077 T:36077 P:14385'
G[14389]='FH K0190 L015 A:36372 T:-181,36436 P:14299'
G[14390]='FH K0190 L015 A:36436 T:-181,36436 P:14389'
G[14391]='FH K0190 L015 A:36436 T:535867 P:14390'
G[14392]='FH K0190 L015 A:36676 T:536210 P:14261+14297+24467'
G[14393]='K0350 L031 A:36398 T:36398 P:14332'
G[14394]='K0350 L031 A:36398 T:36444 P:14393'
G[14395]='FA K0060 L004 RW A:36451 T:36451 P:14396'
G[14396]='FA K0060 L004 RW A:36290 T:36451 P:14386'
G[14397]='FA K0070 L004 RW A:36451 T:36452 P:14395'
G[14398]='FA K0070 L004 RW A:36452 T:36458 P:14397'
G[14399]='FA K0070 L004 RW A:36458 T:36458 P:14398'
G[14400]='FA K0070 L004 RW A:36458 T:36458 P:14399'
G[14401]='FA K0070 L004 RW A:36458 T:36458 P:14400 ODC:25331'
G[14402]='FA K0070 L004 RW A:36458 T:36452 P:14401+14404+14412+14416 I:14405,14463'
G[14403]='FA K0070 L004 RW A:36452 T:36456 P:14397'
G[14404]='FA K0070 L004 RW A:36456 T:36456 P:14403'
G[14405]='FA K0070 L004 RW A:36456 T:36452 P:14401+14404+14412+14416 I:14402,14463'
G[14406]='FA K0070 L004 RW A:36452 T:36457 P:14397'
G[14407]='FH K0170 L015 A:36999 T:35867'	-- TODO: Determine the proper P code
G[14408]='FH K0140 L012 A:36500 T:36500 O:14442'
G[14410]='FA K0350 L031 A:36487 T:40032 P:14381+14394 I:28511'
G[14411]='FH K0350 L031 A:11624 Z19342'
G[14412]='FA K0070 L004 RW A:36456 T:36456 P:14403'
G[14413]='FH K0180 L015 A:35187 T:36334 P:14226+14230'
G[14416]='FA K0070 L004 RW A:36457 T:36457 P:14406'
G[14422]='FH K0140 L012 A:36500 T:36500 P:14408'
G[14423]='FH K0120 L010 A:35088 T:35088 P:14209'
G[14424]='FH K0130 L011 A:35088 T:36077 P:14423'
G[14428]='FH K0180 L016 A:36596 T:1196832'
G[14429]='FH K0180 L016 A:1196832 T:1196833 P:14428'
G[14430]='FH K0180 L016 A:1196833 T:36596 P:14429'
G[14431]='FH K0170 L015 A:8586 T:8586'
G[14432]='FH K0170 L015 A:8586 T:8586 P:14431'
G[14433]='FH K0170 L015 A:8586 T:8586 P:14431'
G[14434]='SP FA K0120 L005 RW A:36616 T:36616 P:26706'
G[14435]='FH K0170 L015 A:8586 T:8586 P:14442+14433'
G[14438]='FH K0060 L004 A:36644 T:36644'
G[14442]='FH K0130 L011 A:36146 T:36500 P:14322'
G[14443]='FA K0800 L080 A:100050379 T:36624'
G[14444]='FA K0800 L080 A:36624 T:36669 P:14443'
G[14445]='FH K0070 L001 RG A:36188 T:36425 P:14243'
G[14447]='FH K0800 L077 A:30824 T:29795'	-- this just copy of 13260 because I do not know what is actually out there now
G[14448]='FH K0800 L077 A:30824 T:29795'	-- this just copy of 13260 because I do not know what is actually out there now
G[14449]='FH K0010 L001 A:2981 T:2980'
G[14452]='FH K0020 L001 A:2980 T:2980 P:14449'
G[14455]='FH K0030 L001 A:36694 T:36694 P:14458'
G[14456]='FH K0030 L001 A:36694 T:36694 P:14458'
G[14457]='FA K0800 L080 A:36669 T:36669 P:14444'
G[14458]='FH K0020 L001 A:2980 T:36694 P:24852'
G[14459]='FH K0040 L001 A:36694 T:36694 P:14455+14456'
G[14460]='FH K0050 L001 A:36694 T:2981 P:14459+14461'
G[14461]='FH K0040 L001 A:36694 T:36694 P:14455+14456'
G[14462]='FH K0200 L018 A:36730 T:36729'
G[14463]='FA K0070 L004 RW A:36457 T:36452 P:14401+14404+14412+14416 I:14402,14405'
G[14464]='FH K0200 L018 A:36729 T:36730 P:14462'
G[14465]='FA K0070 L004 RW A:36452 T:36606 P:14402,14405,14463'
G[14466]='FA K0070 L004 RW A:36606 T:36743 P:14465'
G[14467]='SP FA K0070 L004 RW A:36743 T:36743 P:14466'
G[14468]='FH K0130 L010 A:36752 T:36749 P:14194+14197+14161'
G[14469]='FH K0130 L010 A:36749 T:36749 P:14468'
G[14470]='FH K0130 L010 A:36744 T:36744 P:14468'
G[14471]='FH K0130 L010 A:36746 T:36746 P:14468'
G[14472]='FH K0130 L010 A:36744 T:36744 P:14469+14470+14471'
G[14473]='FH K0060 L001 RG A:35786 T:35786 P:14001'
G[14475]='FH K0200 L018 A:36728 T:36785'
G[14476]='FH K0200 L018 A:36785 T:36785 P:14475'
G[14477]='FH K0200 L018 A:36785 T:36728 P:14476'
G[14478]='FH K0160 L012 A:1201578,1203755 T:536749 P:24452'
G[14479]='FH K0160 L012 A:36956 T:36920 P:24455'
G[14480]='FH K0170 L012 A:36895 T:36895 P:24448'
G[14481]='FA K0800 L078 A:36674 T:36799 I:27724,28827'
G[14482]='FA K0800 L080 A:36799 T:36915 O:14481,27724,28827'
G[14483]='HA FH K0800 L075 A:100050320 T:37172'
G[14484]='FH K0170 L012 A:36895 T:36895 P:24448'
G[14485]='FH K0170 L012 A:36895 T:36895 P:24448'
G[14486]='FH K0170 L012 A:36894 T:36894 P:24448'
G[14487]='FH K0170 L012 A:36745 T:36745 P:24448'
G[14491]='FH K0070 L005 A:36644 T:36644 P:14438'
G[20438]='FA K0800 L080 A:36669 T:36669 P:14457'
G[20439]='FA K0800 L080 A:36669 T:36669 P:20438'
G[20440]='FH K0050 L004 RT A:2948 T:2948'
G[20441]='FH K0070 L004 RT A:3054 T:37024 P:24457'
G[23733]='FH K0050 L001 A:2981 T:36803 P:24861'
G[24215]='FH K0050 L001 A:36803 T:36644 P:23733'
G[24428]='FA K0800 L080 A:100049644 T:1435'
G[24429]='FH K0800 L080 A:100049643 T:3216'
G[24430]='FH K0200 L018 A:36903 T:36903 P:14477+24433'
G[24431]='K0800 L070 A:100049667 T:32337 P:PF001'
G[24432]='FA K0810 L080 A:36915 T:36915 P:14482'
G[24433]='FH K0200 L018 A:36730 T:36730'
G[24434]='FH K0200 L018 A:36919 T:36918'
G[24435]='FH K0160 L012 A:36920 T:36920 P:14479'
G[24436]='FH K0160 L012 A:36921 T:36921'	-- need to determine proper P code
G[24437]='FH K0160 L012 A:36795 T:36795'
G[24438]='FA K0080 L004 RW A:36743 T:37065 P:14467'
G[24439]='FH K0200 L018 A:36730 T:36730 P:24430'
G[24440]='FH K0060 L004 RT A:2948 T:2948 P:20440'
G[24441]='FH K0070 L004 RT A:2948 T:2948 P:24440'
G[24442]='K0800 L077 A:100049676 T:33817 P:J3676,J3677'
G[24448]='FH K0170 L012 A:36920 T:36745 P:24435+24436'	-- 24436 is correct, and assuming 24435 also required
G[24449]='FH K0170 L012 A:36745 T:36959 P:14480+14484+14485+14486+14487'
G[24451]='FH K0800 L080 A:36670 T:36670 P:24556'
G[24452]='FH K0130 L010 A:36749 T:36749 P:14472'
G[24453]='FH K0130 L010 A:36749 T:36752 P:24452'
G[24454]='FA K0800 L080 A:36669 T:36624 P:20439'
G[24455]='FH K0160 L012 A:536749 T:36956 P:14478'
G[24456]='FH K0080 L004 RT A:2948 T:2948 P:24441'
G[24457]='FH K0060 L003 RT A:2948 T:3054 P:24456'
G[24458]='FH K0150 L013 A:36379 T:37009 P:14383+14388'	-- 14388 is correct, assuming also requires 14383
G[24459]='FH K0080 L006 A:36644 T:2988'
G[24460]='E21655'
G[24461]='FA K0800 L080 A:36624 T:36624 P:24454'
G[24463]='FH K0200 L018 A:36728 T:34195 P:24439 I:13612,13866,28493'
G[24467]='FH K0190 L015 A:535867 T:535867,36689 P:14391'
G[24468]='FA K0080 L005 RW A:37065 T:37065 P:E24438'
G[24469]='FA K0010 L001 A:37081 T:37081'	-- dwarf monk got this
G[24470]='FA K0020 L001 A:37081 T:37081 P:24469'
G[24471]='FA K0020 L001 A:658 T:658 P:24469'
G[24472]='FA K0080 L005 RW A:37065 T:37065 P:24468'
G[24473]='FA K0020 L001 A:37081 T:37087 P:24470+24471'
G[24474]='FA K0020 L001 A:37087 T:37087 P:24473'
G[24475]='FA K0020 L001 A:37087 T:37087 P:24474'
G[24476]='FA K08064 L080 A:36624 T:36624 P:24461'
G[24477]='FA K0020 L001 A:1104 T:1104 P:24473'
G[24478]='FH K0180 L015 A:36361 T:36336,36361 P:14296'
G[24479]='FH K0180 L015 A:36361 T:36337,36361 P:14296'
G[24480]='FA K0800 L080 A:36624 T:36624 P:24476'
G[24483]='FA K0080 L005 RW A:37065 T:37102 P:24472'
G[24484]='FA K0080 L005 RW A:37102 T:37102 P:24483'
G[24486]='FA K0020 L001 A:1104 T:1104 P:24477'
G[24487]='FA K0030 L001 A:37087 T:786 P:24475+24486'
G[24488]='K0030 L001 RG A:37106 T:37106 P:24567'
G[24489]='FA K0030 L001 A:1354 T:1354 P:24487'
G[24490]='FA K0050 L001 A:786 T:6782 P:218'
G[24491]='FA K0050 L001 A:6782 T:37113 P:24490'
G[24492]='FA K0050 L001 A:37113 T:37113 P:24491'
G[24493]='FA K0050 L001 A:37087 T:1872 P:B24492'
G[24494]='FA K0030 L002 RF RD CS A:37087 T:37115'
G[24495]='FA K0080 L005 RW A:37815 T:37815 P:24483'
G[24496]='FA K0030 L002 RF RE CM A:37087 T:37121'
G[24497]='FH K0200 L018 A:37142 T:36730 P:14392'
G[24498]='FA K0800 L078 A:36993 T:37591 P:24683'
G[24499]='FA K0800 L078 A:37597 T:38160 O:24510'
G[24500]='FA K0800 L078 A:37582 T:36955'
G[24501]='FA K0090 L005 RW A:37102 T:37102 P:24484'
G[24502]='K0030 L001 RG A:37106 T:-605 P:24488'
G[24503]='K0030 L001 RG A:-605 T:37106 P:24502+m24503 I:28414'
G[24504]='FH K0300 L028 A:37135 T:37137 O:26069,28549'
G[24505]='FH K0300 L028 A:37137 T:37138 P:24504'
G[24506]='FH K0800 L078 A:37780 T:37596'
G[24507]='FH K0800 L078 A:36990 T:37592 P:24682'
G[24508]='E21655'
G[24509]='E21655'
G[24510]='FA K0800 L078 A:37776 T:37597'
G[24511]='FH K0800 L078 A:37596 T:38161 O:24506'
G[24512]='FH K0300 L028 A:37153 T:37153'
G[24513]='FH K0300 L028 A:37136 T:37136'
G[24514]='FH K0300 L028 A:37138 T:37138'
G[24515]='FH K0310 L029 A:37138 T:11857'
G[24517]='FH K0310 L029 A:37154 T:37154'
G[24518]='FH K0310 L029 A:100049776 T:37154'	-- carried by target of 24517
G[24519]='FH K0310 L029 A:37154 T:37154 P:24518'
G[24520]='FH K0030 L001 RG A:37106 T:34668 P:24503,28414'
G[24521]='K0030 L001 T:37106'
G[24522]='FA K0800 L080 A:36624 T:37527 P:24480'
G[24523]='FH K0100 L004 RT A:37024 T:37024 P:20441'
G[24524]='FH K0100 L004 RT A:37024 T:37024 P:24523'
G[24525]='FH K0310 L029 A:11857 T:11857'
G[24526]='K0030 L002 RF RE CM A:37121 T:37121 P:24496'
G[24527]='K0030 L002 RF RD CS A:37115 T:37115 P:24494'
G[24528]='K0030 L002 RF CP A:926 T:926 P:3107'
G[24529]='FH K0320 L030 A:11857 T:11857'
G[24530]='K0030 L002 RF CH A:895 T:895'
G[24531]='K0030 L002 RF CW A:912 T:912 P:3106'
G[24532]='K0030 L002 CR A:916 T:916 P:3109'
G[24533]='K0030 L002 RF CT A:837 T:837 P:3110'
G[24534]='FH K0320 L030 A:11857 T:11857 P:24529'
G[24535]='FA K0800 L080 A:37527 T:37527 P:24522'
G[24536]='HA FH K0000 L001 A:37172 T:37172 O:24805'
G[24539]='FH K0310 L029 A:37515 T:37515 P:24515'
G[24540]='FH K0100 L008 RT A:36648 T:36648 P:24550'
G[24541]='HA FH K0000 L001 A:37172 T:37172 P:24536'
G[24542]='FH K0310 L029 A:37515 T:37570 P:24539'
G[24543]='FH K0320 L030 A:37516 T:3418 P:24529'
G[24544]='E21691'
G[24545]='K0800 L080 CW CP CK A:37120 T:1201742'
G[24546]='FH K0320 L030 A:3418 T:3418 P:24543'
G[24547]='K0800 L080 A:37120 T:37120 P:24743'
G[24548]='K0800 L080 A:37120 T:37120 P:24757'
G[24549]='K0800 L080 A:37120 T:37120 P:24548'
G[24550]='FH K0100 L003 RT A:37024 T:36648 P:24524'
G[24551]='FH K0320 L030 A:3433 T:37679'
G[24552]='FH K0330 L031 A:3387 T:3387'
G[24553]='FA K0800 L080 XD XT XS A:37527 T:36624 P:24535'
G[24554]='FH K0800 L080 A:100050380 T:36642'
G[24555]='FH K0800 L080 A:36642 T:36670 P:24554'
G[24556]='FH K0800 L080 A:36670 T:36670 P:24557'
G[24557]='FH K0800 L080 A:36670 T:36670 P:24555'
G[24558]='FH K0800 L080 A:36670 T:36642 P:24451'
G[24559]='FH K0800 L080 A:36642 T:36642 P:24558'
G[24560]='FH K0800 L080 A:36642 T:36642 P:24559'
G[24561]='FH K0800 L080 A:36642 T:36642 P:24560'
G[24562]='FH K0800 L080 A:36642 T:37527 P:24561'
G[24563]='FH K0800 L080 A:37527 T:37527 P:24562'
G[24564]='FH K0800 L080 SB XD XT XS A:37527 T:36642 P:24563'
G[24565]='K0310 L029 A:37570 T:37570'
G[24566]='K0310 L029 A:38314 T:38314 P:24570+24571'
G[24567]='FH K0030 L001 RG A:34874 T:37106 P:14071 ODC:24521'
G[24569]='FH K0320 L030 A:37679 T:37679 P:24546+24551'
G[24570]='K0310 L029 A:38314 T:38314'
G[24571]='K0310 L029 A:38314 T:38314'
G[24572]='FH K0330 L030 A:37679 T:37679 P:24569'
G[24573]='FH K0330 L030 A:37717 T:37717 P:24569'
G[24574]='K0320 L029 A:37570 T:37570 P:24565'
G[24575]='FA K0100 L005 RW A:37783 T:37783 P:24677'
G[24576]='HA FH K0000 L001 A:38328 T:37172 P:24851 I:24657'
G[24577]='FH K0330 L030 A:-607,37679 T:37811 P:24572'
G[24578]='FA K0080 L005 RW A:37815 T:37822 P:24495+24501'
G[24579]='K0804 L080 A:20735 T:20735'
G[24580]='K0804 L080 A:20735 T:20735'
G[24581]='K0804 L080 A:20735 T:20735'
G[24582]='K0804 L080 A:20735 T:20735'
G[24583]='K0804 L080 A:20735 T:20735'
G[24584]='K0804 L080 A:20735 T:20735'
G[24585]='K0804 L080 A:20735 T:20735'
G[24586]='K0804 L080 A:20735 T:20735'
G[24587]='K0804 L080 A:20735 T:20735'
G[24588]='K0804 L080 A:20735 T:20735'
G[24589]='K0804 L080 A:20735 T:20735'
G[24590]='K0804 L080 A:20735 T:20735'
G[24591]='K0330 L030 A:37811 T:-607 P:24577'
G[24592]='FA K0100 L005 RE RW A:37874 T:37876 P:24672'
G[24593]='FA K0090 L005 RW A:37195 T:37195 P:24628+24646'
G[24594]='FH K0800 L080 RB XD XT XS A:37527 T:36642 P:24563'
G[24595]='FA K0800 L080 CD CT CS A:37527 T:36624 P:24535'
G[24596]='FH K0800 L080 RB CD CT CS A:37527 T:36642 P:24563'
G[24597]='HA FA K0002 L000 A:37887 T:29611'
G[24598]='FH K0800 L080 SB CD CT CS A:37527 T:36642 P:24563'
G[24601]='K0320 L029 A:37570 T:537570,37570 P:24574'
G[24602]='FA K0110 L005 RW A:38144 T:38144 P:24678'
G[24603]='FH K0340 L032 A:37847 T:37847 O:24604'
G[24604]='FH K0340 L032 A:37812 T:37847'
G[24606]='K0340 L032 A:100049932 T:37812'
G[24607]='FH K0020 L001 CW A:37951 T:38037'
G[24608]='FH K0340 L032 A:37847 T:37847 P:24603'
G[24609]='HA FA K0002 L000 A:38041 T:42928'
G[24610]='HA FA K0002 L000 A:38039 T:7999'
G[24611]='HA FA K0002 L000 A:38040 T:17468'
G[24612]='HA FH K0002 L000 A:38042 T:39605'
G[24613]='HA FH K0002 L000 A:38045 T:10181'	-- TODO: G62|Holiday fail|
G[24614]='HA FH K0002 L000 A:38044 T:36648'
G[24615]='HA FH K0002 L000 A:38043 T:16802'	-- TODO: G62|Holiday fail|
G[24616]='FA K0090 L005 RW A:37822 T:37822 P:24578'
G[24617]='FA K0090 L005 RW A:37822 T:37195 P:24616'
G[24618]='FH K0340 L032 A:37837 T:37837 P:24591'
G[24619]='FH K0340 L032 A:37908 T:37908'
G[24620]='FH K0340 L032 A:37908 T:37908 P:24619'
G[24621]='FH K0340 L032 A:37908 T:37908 P:24620'
G[24622]='FH K0030 L001 A:38005 T:37969 P:25064'
G[24623]='K0030 L001 A:37969 T:37969 P:24622'
G[24624]='FH K0030 L001 A:37987 T:37987 P:24622'
G[24625]='FH K0030 L001 A:37987 T:37987 P:24622'
G[24626]='K0030 L001 A:37969 T:38005 P:24623+24624+24625'
G[24627]='FA K0090 L005 RW A:37195 T:37195 P:24617'
G[24628]='FA K0110 L005 RW A:37873 T:37873 P:24617'
G[24629]='HA K0002 L000 GF AP:37675:FA;537675:FH TP:37675:FA;537675:FH I:24635,24636'
G[24631]='FH K0340 L032 A:37909 T:37909'
G[24632]='FH K0340 L032 A:37909 T:3341 P:24631'
G[24633]='FH K0350 L033 A:37812 T:37812 P:24653'
G[24634]='FH K0340 L032 A:37837 T:37837 P:24591'
G[24635]='HA K0002 L000 GM AP:37675:FA;537675:FH TP:37675:FA;537675:FH I:24636,24629'
G[24636]='HA K0002 L000 AP:37675:FA;537675:FH TP:37675:FA;537675:FH I:24635,24629'	-- TODO: G62|Completed, Holiday fail|
G[24637]='FH K0340 L032 A:37837 T:37837 P:24634'
G[24638]='HA FH K0002 L005 M013 A:37172 T:37172 P:24576 I:24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24639]='K0020 L001 CW A:38037 T:38037 P:24607'
G[24640]='K0030 L001 CW A:38037 T:38037 P:24642'
G[24641]='FH K0030 L001 CW A:38037 T:38037 P:24639'
G[24642]='K0030 L001 CW A:38037 T:38037 P:24641'
G[24643]='FH K0030 L001 CW A:38037 T:38966 P:24640'
G[24644]='E21655'
G[24645]='HA FH K0002 L014 M022 A:37172 T:37172 P:24576 I:24638,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24646]='FA K0090 L005 RW A:37195 T:37195 P:24627'
G[24647]='HA FH K0002 L023 M031 A:37172 T:37172 P:24576 I:24638,24645,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24648]='HA FH K0002 L032 M040 A:37172 T:37172 P:24576 I:24638,24645,24647,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24649]='HA FH K0002 L041 M050 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24650]='HA FH K0002 L051 M060 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24651]='HA FH K0002 L061 M070 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24650,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24652]='HA FH K0002 L071 M080 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24650,24651,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24653]='K0350 L033 A:37812 T:37812 P:24606'
G[24654]='FH K0340 L032 A:37910 T:37910'
G[24655]='HA FA K0000 L001 A:38066 T:38066 O:24804'
G[24656]='HA FA K0000 L001 A:38066 T:38066 P:24655'
G[24657]='HA FA K0000 L001 A:38325 T:38066 P:24849 I:24576'
G[24658]='HA FA K0002 L005 M013 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24659]='HA FA K0002 L014 M022 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24660,24662,24663,24664,24665,24666,28934,28935'
G[24660]='HA FA K0002 L023 M031 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24662,24663,24664,24665,24666,28934,28935'
G[24661]='T:110024 E21655'
G[24662]='HA FA K0002 L032 M040 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24663,24664,24665,24666,28934,28935'
G[24663]='HA FA K0002 L041 M050 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24664,24665,24666,28934,28935'
G[24664]='HA FA K0002 L051 M060 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24665,24666,28934,28935'
G[24665]='HA FA K0002 L061 M070 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24666,28934,28935'
G[24666]='HA FA K0002 L071 M080 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,28934,28935'
G[24667]='FH K0340 L032 A:37910 T:37834 P:24654'
G[24671]='FH K0070 L001 RG A:38120 T:38120 P:26705 O:27139'
G[24672]='FA K0090 L005 RW A:37102 T:37874 P:24673'
G[24673]='FA K0090 L005 RW A:37195 T:37102 P:24593'
G[24674]='K0110 L005 RW A:37803 T:37803 P:24438'
G[24675]='FA K0100 L005 RW A:38143 T:38143 P:24438'
G[24676]='FA K0110 L005 RW A:37783 T:37783 P:24575+24674+24675'
G[24677]='FA K0100 L005 RW A:37876 T:37783 P:24592'
G[24678]='FA K0110 L005 RW A:38539 T:38144 P:24920'
G[24679]='FA K0110 L005 RW A:38144 T:38144 P:24602'
G[24680]='FA K0120 L005 RW A:38144 T:38149 P:24679'
G[24681]='FA K0120 L005 RW A:38149 T:38149 P:24680'
G[24682]='FH K0800 L078 A:38161 T:36990 P:24511'
G[24683]='FA K0800 L078 A:38160 T:36993 P:24499'
G[24684]='FH K0350 L032 A:3341 T:38140 P:24632'
G[24685]='FH K0350 L032 A:38140 T:38140 P:24684'
G[24686]='K0510 L049 A:38274 T:38274 P:24719'
G[24687]='K0510 L049 A:38263 T:38263 P:24689'
G[24689]='K0510 L049 A:38274 T:38263 P:24686'
G[24690]='K0530 L049 A:9270 T:9270 P:24740'
G[24691]='K0520 L049 A:10977 T:10977 P:24690'
G[24692]='K053512 L049 A:9271 T:9271 P:24690'	-- PM2
G[24693]='K0520 L049 A:10977 T:38275 P:24691'
G[24694]='K0550 L051 A:38504 T:38502 P:24721+24722+24723'
G[24695]='K0550 L051 A:38502 T:38502 P:24694'
G[24697]='K0520 L050 A:38270 T:38270'
G[24698]='K0530 L051 A:38270 T:9272 P:24693'
G[24699]='K0540 L049 A:38276 T:38276 P:24737'
G[24700]='K0520 L049 A:38276 T:38276 P:24693'
G[24701]='K0530 L049 A:38277 T:38277 P:24693'
G[24702]='K0521 L049 A:1202135 T:1202135'
G[24703]='K0540 L051 A:38237 T:38237'
G[24704]='K0540 L051 A:38237,38255 T:-201,38237,38255 P:24703'
G[24705]='K0540 L051 A:38237,38255 T:-201,38237,38255 P:24703'
G[24706]='K0540 L051 A:38237,38255 T:38237 P:24705'
G[24707]='K0550 L051 A:38237 AH:38343 T:-201,38237,38343 P:24706'
G[24708]='K0540 L051 A:9272 T:9272 P:24730'
G[24709]='K0550 L051 A:9272 T:9272 P:24708'
G[24710]='FA K0800 L078 A:37591 T:38188 P:24498'
G[24711]='FA K0800 L078 A:38188 T:37221 P:24710'
G[24712]='FH K0800 L078 A:37592 T:38189 P:24507'
G[24713]='FH K0800 L078 A:38189 T:37223 P:24712'
G[24714]='K0520 L050 A:9618 T:9623 P:24737+24700+24701'
G[24715]='K0520 L050 A:9623 T:9623 P:24714'
G[24717]='K0520 L049 A:38275 T:38275 P:C24737+C24700+C24701'
G[24718]='K0530 L049 A:-100201 T:38275 P:24737+24700+24701'
G[24719]='K0510 L049 A:38274 T:38274 O:24854'
G[24720]='K0520 L049 A:9117 T:9117'
G[24721]='K0530 L049 A:38263 T:9117 P:24855'	--	Note that with 24721, 24865 and 24911 in the quest log, the Marshall's Refuge has nothing in it except golems.
G[24722]='K0530 L049 A:38275 T:9117 P:24717'
G[24723]='K0550 L051 A:9272 T:9117 P:24709'
G[24724]='K0551 L051 A:1164955 T:1164955 P:24720'
G[24725]='K0551 L051 A:1164955 T:1164955 P:24720'
G[24726]='K0551 L051 A:1164957 T:1164957 P:24720'
G[24727]='K0551 L051 A:1164957 T:1164957 P:24720'
G[24728]='K0551 L051 A:1164956 T:1164956 P:24720'
G[24729]='K0551 L051 A:1164956 T:1164956 P:24720'
G[24730]='K0530 L051 A:9272 T:9272 O:24698'
G[24731]='K0510 L049 A:9619 T:9619'
G[24732]='K0520 L049 A:9619 T:9619 P:24731'
G[24733]='K0530 L049 A:9619 T:9619 P:24732'
G[24734]='K0520 L049 A:9997 T:1202264 P:24794 I:C24736'
G[24735]='K0520 L049 A:9999 T:9997 P:24734 I:C24736'
G[24736]='K0530 L049 A:9998 T:9998'
G[24737]='K0520 L049 A:38276 T:38276 P:24693'
G[24738]='E21655'
G[24739]='E21655'
G[24740]='K0520 L049 A:9270 T:9270 O:24911,28525,28526'
G[24741]='FH K0080 L001 RG A:38122 T:38122 P:24671'
G[24742]='K0520 L049 A:10302 T:10302'
G[24743]='K0800 L080 A:37120 T:37120 P:24545'
G[24744]='FH K0080 L001 RG A:38120 T:38120 P:24741'
G[24745]='HA FA K0800 L075 A:100050320 T:38066'
G[24746]='E21655'
G[24747]='FH K0350 L032 A:38140 T:3341 P:24685'
G[24748]='K0800 L080 A:37120 T:37120 P:24549'
G[24749]='K0800 L080 CW CP CK A:37120 T:37120 P:24547'
G[24750]='FH K0020 L001 CM A:37951 T:38246'
G[24751]='FH K0020 L001 CM A:38246 T:38246 P:24750'
G[24752]='FH K0030 L001 CM A:38246 T:38246 P:24754'
G[24753]='FH K0030 L001 CM A:38246 T:38246 P:24751'
G[24754]='FH K0030 L001 CM A:38246 T:38246 P:24753'
G[24755]='FH K0030 L001 CM A:38246 T:38966 P:24752'
G[24756]='K0800 L080 A:37120 T:37120 P:24749'
G[24757]='K0800 L080 A:37120 T:37120 P:24756'
G[24758]='FH K0020 L001 CS A:37951 T:38242'
G[24759]='K0020 L001 CS A:38242 T:38242 P:24758'
G[24760]='K0030 L002 CS A:38242 T:38242 P:24762'
G[24761]='FH K0030 L001 CS A:38242 T:38242 P:24759'
G[24762]='K0030 L001 CS A:38242 T:538242,38242 P:24761'
G[24763]='FH K0030 L001 CS A:38242 T:38966 P:24760'
G[24764]='FH K0020 L001 CD A:37951 T:38243'
G[24765]='K0020 L001 RT RL CD A:38243 T:38243 P:24764'
G[24766]='K0030 L001 RT RL CD A:538243 T:38243 P:24768'
G[24767]='FH K0030 L001 RT RL CD A:38243 T:38243 P:24765'
G[24768]='K0030 L001 RT RL CD A:38243 T:538243 P:24767'
G[24769]='FH K0030 L001 RT RL CD A:38243 T:38966 P:24766'
G[24770]='FH K0020 L001 CR A:37951 T:38244'
G[24771]='K0020 L001 RU RL RB CR A:38244 T:38244 P:24770'
G[24772]='K0030 L001 RU RL RB CR A:38244 T:38244 P:24774'
G[24773]='FH K0030 L001 RU RL RB CR A:38244 T:38244 P:24771'
G[24774]='K0030 L001 RU RL RB CR A:38244 T:38244 P:24773'
G[24775]='FH K0030 L001 RU RL RB CR A:38244 T:38966 P:24772'
G[24776]='FH K0020 L001 CH A:37951 T:38247'
G[24777]='K0020 L001 CH A:38247 T:38247 P:24776'
G[24778]='K0030 L001 CH A:38247 T:38247 P:24780'
G[24779]='FH K0030 L001 CH A:38247 T:38247 P:24777'
G[24780]='K0030 L001 CH A:38247 T:38247 P:24779'
G[24781]='FH K0030 L001 CH A:38247 T:38966 P:24778'
G[24782]='FH K0020 L001 CT A:37951 T:38245'
G[24783]='K0020 L001 CT A:38245 T:38245 P:24782'
G[24784]='K0030 L001 CT A:38245 T:38245 P:24786'
G[24785]='FH K0030 L001 CT A:38245 T:38245 P:24783'
G[24786]='K0030 L001 CT A:38245 T:38245 P:24785'
G[24787]='FH K0030 L001 CT A:38245 T:38966 P:24784'
G[24788]='K0800 L080 E21655'
G[24789]='K0800 L080 E21655'
G[24790]='K0800 L070 E21655'
G[24791]='K0800 L078 E21655'
G[24794]='K0530 L049 A:10302 T:9997 P:24742 I:C24736'
G[24795]='FA K0800 L080 CD CT CS A:36624 T:33817 P:24595'
G[24796]='FA K0800 L080 XD XT XS A:36624 T:30115 P:24553'
G[24798]='FH K0800 L080 RB CD CT CS A:36642 T:33817 P:24596'
G[24799]='FH K0800 L080 SB CD CT CS A:36642 T:33817 P:24598'
G[24800]='FH K0800 L080 RB XD XT XS A:36642 T:30116 P:24594'
G[24801]='FH K0800 L080 SB XD XT XS A:36642 T:30116 P:24564'
G[24802]='FH K0800 L078 A:37779 T:37554'
G[24803]='HK K0001 L001 A:38294 T:38294 P:PF001 I:24803'
G[24804]='HA FA K0000 L001 A:38293 T:38066'
G[24805]='HA FH K0000 L001 A:38295 T:37172'
G[24806]='HK K0001 L001 A:38294 T:38294 P:PF001 I:24806'
G[24807]='FH K0320 L029 A:537570,37570 T:37717 P:24601'
G[24808]='E21655'
G[24809]='E21655'
G[24810]='T:92031 E21655'
G[24811]='E21655'
G[24812]='FH K0040 L001 A:38442 T:38442 P:25035'
G[24813]='FH K0040 L001 A:38442 T:38442 P:25035'
G[24814]='K0050 L001 A:38442 T:38966 P:24812+24813'
G[24815]='K0800 L080 A:38316 T:38316'
G[24816]='FH K0080 L001 RG A:38120 T:38124 P:24744'
G[24817]='FH K0080 L001 RG A:38124 T:38120 P:24816'
G[24819]='K0801 L080 A:39509 T:39509'
G[24820]='K0801 L080 A:39509 T:39509'
G[24821]='K0801 L080 A:39509 T:39509'
G[24822]='K0801 L080 A:39509 T:39509'
G[24823]='K0800 L080 A:38316 T:38316'
G[24824]='K0340 L032 A:37834 T:37834'
G[24825]='K0800 L080 A:38316 T:38316'
G[24826]='K0800 L080 A:38316 T:38316'
G[24827]='K0800 L080 A:38316 T:38316'
G[24828]='K0800 L080 A:38316 T:38316'
G[24829]='K0800 L080 A:38316 T:38316'
G[24830]='K0800 L080 A:38316 T:38316'
G[24831]='K0800 L080 A:38316 T:38316'
G[24832]='K0800 L080 A:38316 T:38316'
G[24833]='K0800 L080 A:38316 T:38316'
G[24834]='K0800 L080 A:38316 T:38316'
G[24835]='K0800 L080 A:38316 T:38316'
G[24836]='K0801 L080 A:39509 T:39509'
G[24837]='K0801 L080 A:39509 T:39509'
G[24838]='K0801 L080 A:39509 T:39509'
G[24839]='K0801 L080 A:39509 T:39509'
G[24840]='K0801 L080 A:39509 T:39509'
G[24841]='K0801 L080 A:39509 T:39509'
G[24842]='K0801 L080 A:39509 T:39509'
G[24843]='K0801 L080 A:39509 T:39509'
G[24844]='K0801 L080 A:39509 T:39509'
G[24845]='K0801 L080 A:39509 T:39509'
G[24846]='K0801 L080 A:39509 T:39509'
G[24847]='K0801 L080 A:39509 T:39509'
G[24848]='HA FA K0000 L001 A:38066 T:38325 P:24656'
G[24849]='HA FA K0000 L001 A:38325 T:38325 P:24848'
G[24850]='HA FH K0000 L001 A:37172 T:38328 P:24541'
G[24851]='HA FH K0000 L001 A:38328 T:38328 P:24850'
G[24852]='FH K0020 L001 A:2980 T:2980 P:14452'
G[24854]='K0510 L049 A:38269 T:38274'
G[24855]='K0520 L049 A:38263 T:38263 P:24687'
G[24856]='FH K0080 L001 RG A:38120 T:38432 P:24817'
G[24857]='E21655'
G[24858]='FH K0080 L001 RG A:38432 T:38432 P:24856'
G[24859]='FH K0080 L001 RG A:38381 T:38381 P:24856'
G[24861]='FH K0050 L001 A:2981 T:2981 P:14460'
G[24862]='FA K0300 L028 A:38378 T:38380 O:28550'
G[24863]='FA K0300 L028 A:38378 T:38380'
G[24864]='FH K0080 L001 RG A:38432 T:38432 P:24858+24859'
G[24865]='K0510 L049 A:1161526 T:9270'
G[24866]='K0510 L049 A:1161521 T:509271'
G[24868]='FH K0080 L001 RG A:38432 T:38432 P:24864'
G[24881]='K0150 L005 E21655'
G[24882]='K0250 L015 E21655'
G[24883]='K0340 L024 E21655'
G[24884]='K0450 L035 E21655'
G[24885]='K0550 L045 E21655'
G[24886]='K0600 L055 E21655'
G[24887]='K0640 L060 E21655'
G[24888]='K0700 L064 E21655'
G[24889]='K0150 L005 E21655'
G[24890]='K0250 L015 E21655'
G[24891]='K0340 L024 E21655'
G[24892]='K0450 L035 E21655'
G[24893]='K0550 L045 E21655'
G[24894]='K0600 L055 E21655'
G[24895]='K0640 L060 E21655'
G[24896]='K0700 L064 E21655'
G[24897]='FH K0080 L001 RG A:38432 T:38387 P:24868 OAC:26902'
G[24898]='E21655'
G[24899]='E21655'
G[24900]='E21655'
G[24901]='FH K0080 L001 RG A:38387 T:38387 P:24897'
G[24902]='FA K0110 L005 RW A:38611 T:38611 P:24904'
G[24903]='FA K0110 L005 RW A:38611 T:38539 P:24902'
G[24904]='FA K0110 L005 RW A:37783 T:38611 P:24676'
G[24905]='FH K0470 L045 A:38706 T:38849 P:24953'
G[24906]='FH K0450 L043 A:38534 T:38534 O:27447'
G[24907]='FH K0450 L043 A:38534 T:38534'
G[24910]='FH K0450 L043 A:38534 T:38534 P:24906+24907'
G[24911]='K0520 L049 AA:38578 AH:44374 T:9270 I:28525,28526'
G[24912]='K0800 L080 A:37120 T:37120'
G[24913]='FA K0550 L053 A:17127 T:17127 P:27902'	-- removed +27904
G[24914]='K0800 L080 A:100051315 T:37120'
G[24915]='K0800 L080 A:37120 T:37120'
G[24916]='K0800 L080 A:38606 T:38606'
G[24917]='K0800 L080 A:38607 T:38607'
G[24918]='K0800 L080 A:38609 T:38609'
G[24919]='K0800 L080 A:38608 T:38608'
G[24920]='FA K0110 L005 RW A:38539 T:38539 P:24903'
G[24921]='FA K0300 L028 A:38623 T:38619 O:28551 I:25197'
G[24922]='K0700 L064 E21655'
G[24923]='K0700 L064 E21655'
G[24924]='FH K0080 L001 RG A:38387 T:38647 P:24901'
G[24925]='FH K0080 L001 RG A:38647 T:38647 P:24924'
G[24926]='K0520 L050 A:9623 T:9618 P:24715'
G[24927]='FH K0460 L044 A:38703 T:38703 P:24910'
G[24928]='FH K0460 L044 A:38703 T:38703 P:24910'
G[24929]='FH K0080 L001 RG A:38647 T:38647 P:24924'
G[24930]='K0030 L001 RW A:35115 T:35115 P:14285,14286,14287,14288,14289,14290,14291'
G[24931]='K0470 L045 A:11811 T:11811 P:25072'
G[24932]='K0470 L045 A:38706 T:38706 P:26889,25103'
G[24933]='K0470 L045 A:38706 T:38706 P:24932'
G[24934]='FA K0300 L028 A:38619 T:38622 O:24921,25197'
G[24937]='FH K0080 L001 RG A:38647 T:38387 P:24925+24929'
G[24938]='FA K0300 L028 A:38619 T:3454 P:24934'
G[24939]='FA K0300 L028 A:3454 T:3454 P:24938'
G[24940]='FH K0080 L001 RG A:38387 T:38738 P:24937'
G[24941]='FA K0300 L028 A:38620 T:1202335'
G[24942]='FH K0080 L001 RG A:38738 T:38738 P:24940'
G[24943]='FA K0300 L028 A:38620 T:38620 P:24941'
G[24944]='FA K0300 L028 A:38804 T:38804 P:24941'
G[24945]='FH K0090 L001 RG A:536471 T:536471 P:24940'
G[24946]='FH K0080 L001 RG A:538124 T:538124 P:24940'
G[24947]='FH K0460 L044 A:38534 T:38703 P:24910+24907'
G[24948]='FA K0300 L028 A:38620 T:38620 P:24943'
G[24949]='FH K0460 L044 A:38703 T:38703 P:24910'
G[24950]='FH K0460 L044 A:38703 T:38703 P:24928+25534+25541'
G[24951]='K0470 L045 A:38706 T:38706 P:24933'
G[24952]='FH K0080 L001 RG A:38738 T:538120 P:24942+24945+24946'
G[24953]='K0470 L045 A:38706 T:38706 P:24951'
G[24954]='FH K0080 L001 RG A:538120 T:538120 P:24952'
G[24955]='FH K0480 L045 A:38849 T:38849 O:24905'
G[24956]='FA K0310 L028 A:38804 T:38804 P:24944'
G[24957]='FH K0480 L045 A:38849 T:38849 P:24955'
G[24958]='FH K0090 L001 RG A:538120 T:38928 P:24954'
G[24959]='FH K0010 L001 RU A:49044 T:1568'
G[24960]='K0010 L001 RU A:2307 T:2307 P:28608 O:28652'
G[24961]='FH K0030 L002 A:1661 T:1661 P:26801 O:28651,31148'
G[24962]='FH K0030 L002 RU CH A:1569 T:38911 P:26801'
G[24963]='FH K0480 L045 A:38849 T:38849 P:24957'
G[24964]='K0030 L002 RU CH A:38911 T:38911 P:24962'
G[24965]='K0030 L002 RU CM A:2124 T:2124 P:3098'
G[24966]='K0030 L002 RU CT A:2123 T:2123 P:3097'
G[24967]='K0030 L002 RU CR A:2122 T:2122 P:3096'
G[24968]='K0030 L002 RU CL A:2126 T:2126 P:3099'
G[24969]='K0030 L002 RU CW A:2119 T:2119 P:3095'
G[24970]='FH K0040 L003 A:1570 T:49425 P:24973'
G[24971]='FH K0050 L002 A:49425 T:1569 P:24970'
G[24972]='FH K0050 L002 A:1569 T:1519 P:24971'
G[24973]='FH K0040 L002 A:1570 T:1570 P:26802'
G[24974]='FH K0060 L005 A:38925 T:38925'
G[24975]='FH K0060 L005 A:1518 T:1518'
G[24976]='FH K0060 L005 A:1518 T:1518 P:24975'
G[24977]='FH K0060 L005 A:1518 T:1931 P:24976'
G[24978]='FH K0060 L005 A:1519 T:1519'
G[24979]='FH K0060 L005 A:100052079 T:1519'
G[24980]='FH K0060 L005 A:1519 T:1519 P:24978'
G[24981]='FH K0080 L005 A:1515 T:1515'
G[24982]='FH K0070 L005 A:1496 T:1499'
G[24983]='FH K0080 L005 A:1499 T:1495 O:24982'
G[24988]='FH K0080 L005 A:1521 T:1521 P:24983'
G[24989]='FH K0080 L005 A:1495 T:1499 P:24988'
G[24990]='FH K0060 L006 A:10665 T:10665 P:24977'
G[24991]='FH K0080 L005 A:10665 T:38977 P:24996'
G[24992]='FH K0070 L005 AK:1547,1548 T:1515 P:C24990 I:25039 OAC:25040'	-- this autoaccepts after the kill...I cannot remember if that is the case with all AK: codes *** there is a P: needed, but not sure what it is
G[24993]='FH K0080 L005 A:1515 T:1515 P:24992,25039'
G[24994]='FH K0070 L006 A:38977 T:38977 O:24991'
G[24995]='FH K0080 L006 A:38977 T:38977 P:24994'
G[24996]='FH K0060 L005 A:10665 T:2211 P:24990'
G[24997]='FH K0070 L006 A:38978 T:38978'
G[24998]='FH K0090 L006 A:38978 T:38978 P:24997'
G[24999]='FH K0080 L006 A:38978 T:38978 P:24994'
G[25000]='FA K0310 L029 A:38621 T:38873'
G[25001]='FH K0480 L045 A:38849 T:38849 P:24963'
G[25002]='FA K0310 L029 A:38878 T:38871'
G[25003]='FH K0090 L006 A:1500 T:1500 O:25031'
G[25004]='FH K0080 L006 A:1500 T:1500 P:25003'
G[25005]='FH K0090 L006 A:1500 T:1499 P:25004+25029'
G[25006]='FH K0090 L006 A:1499 T:1499 P:25005'
G[25007]='FH K0090 L006 A:1499 T:10837 P:25006'
G[25008]='FA K0310 L029 A:38873 T:38873'
G[25009]='FH K0090 L006 A:10837 T:10837 P:25007'
G[25010]='FH K0100 L006 A:10837 T:13158 P:25009'
G[25011]='FH K0100 L006 A:10837 T:37915 P:25046'
G[25012]='FH K0100 L006 A:37915 T:1515 P:25011'
G[25013]='FH K0100 L007 A:11057 T:11057 P:25056'
G[25014]='FH K0480 L046 A:1202407 T:38849 P:E25001'	--	TODO:	Assuming available once you kill Sandscaper (while on that quest)
G[25015]='FA K0310 L029 A:38871 T:38871'
G[25016]='E21655'
G[25017]='FH K0490 L046 A:38922 T:38922 P:25019+25020'
G[25018]='FH K0480 L046 A:38849 T:38922 P:25014'
G[25019]='FH K0490 L046 A:38922 T:38922'
G[25020]='FH K0490 L046 A:38922 T:38922'
G[25021]='K0450 L043 A:38927 T:38927'
G[25022]='FA K0310 L029 A:38871 T:38871'
G[25023]='FH K0090 L001 RG A:38928 T:38935 P:24958'
G[25024]='FH K0090 L001 RG A:38935 T:38935 P:25023 OAC:28846'
G[25025]='K0450 L043 A:38927 T:38927 P:25021'
G[25026]='K0450 L043 A:38927 T:38927 P:25025'
G[25027]='FA K0310 L029 A:38871 T:38871 P:25015+25022'
G[25028]='FA K0310 L029 A:38876 T:37570 P:25015+25022'
G[25029]='FH K0090 L006 A:1500 T:1500 P:25003'
G[25030]='FH K0090 L006 A:100003082 T:1500'
G[25031]='FH K0090 L006 A:38977 T:1500 P:24995+24998+24999'
G[25032]='K0460 L044 A:38927 T:7804 P:25026'
G[25034]='FA K0310 L029 A:38871 T:38986 P:25027'
G[25035]='FH K0040 L001 A:38440 T:38442 P:24626'
G[25036]='FA K0310 L029 A:38620 T:38871 P:24948+24956'
G[25037]='FH K0030 L001 A:39007 T:39007 P:24643,24755,24763,24769,24775,24781,24787,26277,31163'
G[25038]='FH K0060 L005 A:10666 T:10665 P:24976'
G[25039]='FH K0070 L005 A:6785 T:1515 P:25040 I:24992'
G[25040]='K0000 L000 T:1548 J:O24992'
G[25041]='FA K0320 L030 A:39003 T:39003'
G[25042]='FA K0320 L030 A:39003 T:39003 P:25041'
G[25043]='FA K0320 L030 A:38323 T:38323'
G[25044]='FA K0320 L030 A:38986 T:38986 P:25022'
G[25045]='FA K0320 L030 A:38323 T:38323'
G[25046]='FH K0100 L006 A:13158 T:10837 P:25010'
G[25047]='K0000 L001 A:100052197 P:PJ475'
G[25048]='FA K0450 L043 A:38535 T:38535 O:27446,28507'
G[25049]='FA K0450 L043 A:38535 T:38535'
G[25050]='FA K0450 L043 A:38535 T:38535 P:25048+25049'
G[25051]='FH K0360 L034 A:4926 T:4926'
G[25052]='FA K0460 L044 A:38704 T:38704 P:25121'
G[25053]='FA K0460 L044 A:38704 T:38704 P:25050'
G[25054]='FA K0460 L044 A:38704 T:38704 P:25050'
G[25055]='E21655'
G[25056]='FH K0090 L007 A:11057 T:11057'
G[25057]='FA K0320 L030 A:38323 T:38323 P:25043+25045'
G[25058]='FH K0090 L001 RG A:538387 T:538387 P:28846'
G[25059]='FA K0320 L030 A:38986 T:38986 P:25043+25045'
G[25060]='FA K0480 L046 A:39059 T:39059 P:25166 O:25061'
G[25061]='FA K0470 L045 A:11811 T:39059 P:24953'
G[25062]='FA K0480 L046 A:39059 T:39059 P:25166'
G[25063]='FA K0480 L046 A:39059 T:39059 P:25060+25062'
G[25064]='FH K0030 L001 A:38966 T:38005 P:24643,24755,24763,24769,24775,24781,24787,26277,31163'
G[25065]='FA K0480 L046 A:39059 T:39059 P:25063'
G[25066]='FH K0090 L001 RG A:538387 T:538387 P:25024+25058+25093'
G[25067]='K049512 L047 A:39034 T:19860 O:26895,26896'	-- PM3
G[25068]='FH K0490 L046 A:38922 T:38922 P:25017'
G[25069]='FH K0490 L046 A:38922 T:1202474 P:25017'
G[25070]='K0490 L047 A:1202474 T:1202474 P:25069,25566'
G[25071]='E21655'
G[25072]='K0470 L045 A:38706 T:38706 P:26889,25103'
G[25073]='FH K0050 L001 A:38966 T:3188 P:24814'
G[25074]='FA K0330 L030 A:38323 T:39083 P:25057'
G[25075]='FA K0330 L031 A:39084 T:39084'
G[25079]='FA K0330 L031 A:39084 T:39084 P:25075'
G[25080]='FA K0330 L031 A:39084 T:39084 P:25079'
G[25081]='FA K0340 L032 A:39083 T:39083'
G[25082]='FA K0340 L032 A:39085 T:39085'
G[25084]='FA K0340 L032 A:37835 T:37835'
G[25085]='FA K0340 L032 A:37835 T:37835 P:25084'
G[25086]='FA K0340 L032 A:39085 T:37835 P:25082'
G[25087]='FA K0340 L032 A:39083 T:39118 P:25081'
G[25089]='FH K0010 L001 RU A:2307 T:1740 P:24960'
G[25090]='FH K0060 L004 A:1496 T:1496'
G[25091]='K0450 L043 A:39178 T:7804 P:25115'
G[25092]='E21655'
G[25093]='FH K0100 L001 RG A:39065 T:39065 P:28846'
G[25094]='K049512 L047 A:39034 T:19860 P:25067'	-- PM3
G[25095]='K049512 L047 A:39034 T:19860 P:25094'	-- PM3
G[25097]='E21655'
G[25098]='FH K0090 L001 RG A:538387 T:38935 P:25066'
G[25099]='FH K0090 L001 RG A:38935 T:39066 P:25098'
G[25100]='FH K0090 L001 RG A:39066 T:38517 P:25099'
G[25101]='E21655'
G[25102]='FA K0340 L032 A:39154 T:39154'
G[25103]='FH K0460 L044 A:38703 T:38706 P:24950'
G[25104]='FA K0340 L032 A:39118 T:39155'
G[25105]='FA K0002 L001 A:50480 T:50480 P:PJ475 I:25154,25155,25156,25157'
G[25106]='FA K0340 L032 A:39155 T:39155 P:25104'
G[25107]='FH K0490 L046 A:1202474 T:38922 P:25070'
G[25108]='FA K0340 L032 A:39155 T:39155 P:25104'
G[25109]='FH K0090 L001 RG A:38517 T:500034 P:25100'
G[25110]='FH K0090 L001 RG A:500034 T:500034 P:25109'
G[25111]='K0450 L043 A:39178 T:39178 P:25112'
G[25112]='K0450 L043 A:39178 T:39178'
G[25115]='K0450 L043 A:39178 T:39178 P:25111'
G[25117]='E21655'
G[25118]='FA K0130 L011 A:1777 T:1777'
G[25120]='FA K0340 L032 A:39155 T:39188 P:25106+25108'
G[25121]='FA K0460 L044 A:38535 T:38704 P:25050'
G[25122]='FH K0090 L001 RG A:39199 T:39199 P:25110'
G[25123]='FH K0100 L001 RG A:39199 T:39199 P:25110'
G[25125]='FH K0090 L001 RG A:39199 T:39341 P:25122+25123'
G[25126]='K0020 L001 A:3143 T:3143 P:25152'
G[25127]='FH K0030 L001 A:3143 T:3143 P:25172'
G[25128]='FH K0050 L003 A:5887 T:3287 P:25127'
G[25129]='FH K0050 L001 A:3287 T:3287'
G[25130]='FH K0050 L001 A:3287 T:3143 P:25129'
G[25131]='K0040 L003 A:3145 T:3145 P:25127'
G[25132]='K0050 L001 A:3145 T:3145 P:25131'
G[25133]='FH K0050 L001 A:3145 T:3188 P:25132'
G[25134]='FH K0040 L003 A:11378 T:11378 P:25172 Z19033'
G[25135]='FH K0040 L003 A:11378 T:11378 P:25131'
G[25136]='FH K0030 L001 A:9796 T:9796 P:25126'
G[25138]='FH K0030 L002 RO CM A:3143 T:39206'
G[25139]='K0030 L002 RO CH A:39214 T:39214 P:3087'
G[25141]='K0030 L002 RO RE CR A:3155 T:3155 P:3088'
G[25143]='K0030 L002 RO CS A:3157 T:3157 P:3089'
G[25145]='K0030 L002 RO RL CL A:3156 T:3156 P:3090'
G[25147]='K0030 L002 RO CW A:3153 T:3153 P:2383'
G[25149]='K0030 L002 RO CM A:39206 T:39206 P:25138'
G[25151]='FA K0340 L032 A:39188 T:39188 P:25120'
G[25152]='FH K0010 L001 A:10176 T:3143'
G[25153]='FA K0340 L032 A:39218 T:39218 P:25120'
G[25154]='FA K0002 L001 A:50480 T:50480 P:PJ475 I:25105,25155,25156,25157'
G[25155]='FA K0002 L001 A:50480 T:50480 P:PJ475 I:25105,25154,25156,25157'
G[25156]='FA K0002 L001 A:50480 T:50480 P:PJ475 I:25105,25154,25155,25157'
G[25157]='FA K0002 L001 A:50480 T:50480 P:PJ475 I:25105,25154,25155,25156'
G[25158]='FH K0002 L001 A:50482 T:50482 P:PJ475 I:25159,25160,25161,25162'
G[25159]='FH K0002 L001 A:50482 T:50482 P:PJ475 I:25158,25160,25161,25162'
G[25160]='FH K0002 L001 A:50482 T:50482 P:PJ475 I:25158,25159,25161,25162'
G[25161]='FH K0002 L001 A:50482 T:50482 P:PJ475 I:25158,25159,25160,25162'
G[25162]='FH K0002 L001 A:50482 T:50482 P:PJ475 I:25158,25159,25160,25161'
G[25163]='FA K0340 L032 A:39220 T:38152 P:25120'
G[25164]='K0810 L080 A:39226 T:39226 P:25334'
G[25165]='FH K0060 L004 A:10578 T:10578 P:25170'
G[25166]='FA K0460 L044 A:38704 T:38704 P:25053+26886+26887'
G[25167]='FH K0060 L004 A:3188 T:3188 O:25073,25133'
G[25168]='FH K0060 L004 A:3188 T:3188 P:25167'
G[25169]='FH K0060 L004 A:3140 T:3140 P:25167'
G[25170]='FH K0060 L004 A:10578 T:10578'
G[25171]='FH K0060 L004 A:3188 T:3139 P:25168+25169'
G[25172]='K0030 L001 A:3143 T:3143 P:25126'
G[25173]='FH K0070 L004 A:3139 T:3139 P:25171'
G[25174]='FA K0340 L032 A:38152 T:39118 P:25163'
G[25175]='FA K0340 L032 A:39188 T:39118 P:25151'
G[25176]='FH K0070 L004 A:39423 T:39423 P:25171'
G[25177]='FH K0070 L004 A:3139 T:3139 P:25173'
G[25178]='FH K0070 L004 A:39423 T:39423 P:25173+25176'
G[25179]='FH K0070 L004 A:39270 T:3139 P:25173'
G[25182]='FA K0350 L032 A:39118 T:39118 P:25174'
G[25183]='FA K0350 L032 A:39118 T:1202598 P:25174'
G[25184]='FH K0090 L001 RG A:39341 T:500035 P:25125'
G[25185]='FA K0350 L032 A:1202598 T:39118 P:25183'
G[25186]='FA K0310 L029 A:38380 T:38379 P:24862+24863'
G[25187]='FH K0080 L004 A:39323 T:39323 O:25227'
G[25188]='FH K0080 L004 A:39323 T:39323 P:25187'
G[25189]='FH K00832 L004 A:39325 T:39326 P:B25188 Z20886'
G[25190]='FH K0080 L004 A:39326 T:39326 P:B25188'
G[25191]='FA K0300 L028 A:38383 T:39322'
G[25192]='FH K0090 L004 A:39326 T:39326 P:25190'
G[25193]='FH K0080 L004 A:3193 T:3193 P:B25188'
G[25194]='FH K0080 L004 A:39324 T:39324 P:B25188'
G[25195]='FH K0090 L004 A:39324 T:39324 P:25194'
G[25196]='FH K0100 L008 A:3142 T:39379 P:25232'
G[25197]='FA K0300 L028 A:39322 T:38619 P:25191 I:24921'
G[25200]='FH K0100 L001 RG A:500035 T:500035 P:25184'
G[25201]='FH K0100 L001 RG A:538738 T:538738 P:25184'
G[25202]='FH K0110 L001 RG GF A:538647 T:538647 P:25200+25201 ODC:25226'
G[25203]='FH K0110 L001 RG GM A:38441 T:38441 P:25200+25201'
G[25204]='FH K0100 L001 RG A:500035 T:1202613 P:25200+25201'
G[25205]='FH K0100 L008 A:39380 T:39380'
G[25206]='FH K0100 L008 A:39379 T:39379 P:25205'
G[25207]='FH K0100 L001 RG A:1202613 T:500035 P:25204'
G[25208]='FA K0360 L034 A:40052 T:39653 P:25403'
G[25209]='FH K0360 L034 A:39656 T:39656 O:25386'
G[25210]='FH K0360 L034 A:39377 T:39377 O:26589'
G[25211]='FA K0210 L018 A:41074 T:41074'
G[25213]='FH K0100 L001 RG A:500035 T:500036 P:25207+25226'
G[25214]='FH K0100 L001 RG A:500037 T:500037 P:25213'
G[25215]='K0810 L080 A:39876 T:39876 P:25222'
G[25216]='K0810 L080 A:39876 T:39882 P:25222'
G[25217]='K0810 L080 A:39882 T:39882 P:25218'
G[25218]='K0810 L080 A:39882 T:39882 P:25216'
G[25219]='K0810 L080 A:39875 T:39875 TH:49920 P:25222'
G[25220]='K0810 L080 A:39878 T:39878 P:25222'
G[25221]='K0810 L080 A:39877 T:539877 P:25164'
G[25222]='K0810 L080 A:539877 T:39876 P:25221'
G[25223]='K0810 L080 A:39442 T:39442 P:25276'
G[25224]='K0810 L080 A:39442 T:39442 P:25276'
G[25226]='FH K0000 L000 RG T:538647 J:25202'
G[25227]='FH K0080 L004 A:39423 T:39323 P:25178'
G[25228]='E21655'
G[25230]='FH K0360 L034 A:39377 T:39377 P:25210'
G[25232]='FH K0100 L008 A:3142 T:3142'
G[25233]='K0810 L080 A:39427 T:39427 P:25584'
G[25234]='K0810 L080 A:39427 T:39427 P:25584'
G[25235]='FA K0220 L020 A:888 T:888 I:26137'	-- It is reported that this I: is really a glitch with Blizzard's current implementation and should be removed in the future when Blizzard fixes it.
G[25236]='FH K0100 L008 A:39379 T:39379'
G[25237]='FH K0360 L034 A:39377 T:39377 P:25230'
G[25238]='E21655'
G[25239]='K0800 L080 A:38316 T:38316'
G[25240]='K0800 L080 A:38316 T:38316'
G[25241]='FH K0360 L034 A:39377 T:39377 P:25230'
G[25242]='K0800 L080 A:38316 T:38316'
G[25243]='FH K0110 L001 RG GM A:500036 T:500036 P:25213 ODC:25244,25245'
G[25244]='FH K0110 L001 RG GF A:500036 T:500036 P:25213 ODC:25243,25245'
G[25245]='K0000 L000 T:500036 J:A25243,A25244'
G[25246]='K0801 L080 A:39509 T:39509'
G[25247]='K0801 L080 A:39509 T:39509'
G[25248]='K0801 L080 A:39509 T:39509'
G[25249]='K0801 L080 A:39509 T:39509'
G[25250]='FH K0360 L034 A:39377 T:39377 P:25237,25241'
G[25251]='FH K0100 L001 RG A:500036 T:500036 P:25214+25245'
G[25252]='FH K0370 L034 A:39656 T:39656 P:25209'
G[25255]='K0810 L080 A:39429 T:39429 P:25584'
G[25256]='FH K0100 L008 A:39604 T:39590'
G[25257]='FH K0100 L008 A:39590 T:39590 P:25256'
G[25258]='FH K0100 L008 A:39590 T:39590 P:25256'
G[25259]='FH K0100 L008 A:39590 T:39590 P:25256'
G[25260]='FH K0100 L008 A:39379 T:39379 P:25196'
G[25261]='FH K0100 L008 A:39379 T:3208 P:25260'
G[25262]='FH K0120 L004 A:3208 T:3208 P:25261'
G[25263]='FH K0120 L004 A:3208 T:3216 P:25262'
G[25264]='FH K0130 L004 A:3216 T:3521 P:25263'
G[25265]='FH K0110 L001 RG A:500036 T:538935 P:25251'
G[25266]='FH K0110 L001 RG A:538935 T:39609 P:25265'
G[25267]='FH K0110 L001 RG A:39609 T:39605 O:25266'
G[25268]='FA K0810 L080 A:39427 T:39433 P:25233'
G[25269]='FH K0810 L080 A:39429 T:39432 P:25255'
G[25270]='FH K0810 L080 A:39432 T:39432 P:25269'
G[25271]='FA K0810 L080 A:39433 T:39433 P:25268'
G[25272]='FH K0810 L080 A:39432 T:39622 P:25270'
G[25273]='FA K0810 L080 A:39433 T:39627 P:25271'
G[25274]='K0810 L080 A:39621 T:39621 P:25597'
G[25275]='FH K0110 L001 RG A:39605 T:35086 P:25267 I:28496'
G[25276]='K0810 L080 A:39621 T:39442 P:25274'
G[25277]='FH K0810 L080 A:39432 T:39432 O:25279'
G[25278]='FA K0810 L080 A:39433 T:539433 O:25280'
G[25279]='FH K0810 L080 A:39622 T:39432'
G[25280]='FA K0810 L080 A:539627 T:539433 P:25273'
G[25281]='FA K0810 L080 A:36915 T:36915 P:24432'
G[25284]='FH K0300 L028 A:37153 T:37153'
G[25291]='K0810 L080 A:39442 T:39413 P:25223+25224+25330'	-- guessed at, done in order: 25224,25223,25330.  appeared after last
G[25292]='FH K0350 L032 A:39697 T:39144 P:24747'
G[25294]='K0810 L080 A:39406 T:39406 P:25291'
G[25296]='K0810 L080 A:1202701 T:1202701 P:25291'
G[25297]='K0810 L080 A:39434 T:1202706 P:25273'
G[25298]='K0810 L080 A:1202706 T:39434 P:25297'
G[25299]='K0810 L080 A:39413 T:39413 P:25499'
G[25300]='K0810 L080 A:39435 T:1202697 P:25273'
G[25301]='K0810 L080 A:1202697 T:1202712 P:25300'
G[25303]='K0810 L080 A:1202712 T:1202712 P:25301'
G[25304]='FA K0370 L035 A:3936 T:39723 O:26402'
G[25305]='K0370 L035 E21655'
G[25306]='K0000 L001 E21655'
G[25307]='E21655'
G[25308]='K0810 L080 A:1202701 T:1202701 P:25296'
G[25309]='K0810 L080 A:39413 T:39413 P:25299'
G[25310]='K0810 L080 A:39413 T:39413 P:25309+25496'
G[25311]='K0810 L080 A:39413 T:39413 P:25309+25496'
G[25312]='K0810 L080 A:1202712 T:39435 P:25303'
G[25314]='K0810 L080 A:1202701 T:1202701 P:25308+25310+25311'
G[25315]='K0810 L080 A:39413 T:40619 P:25601'
G[25316]='K0810 L080 A:39865 T:40289 P:27721,27726'
G[25317]='K0810 L080 A:40289 T:39857 TH:45312 O:25316'
G[25318]='E21655'
G[25319]='K0810 L080 A:39857 T:39857 P:25317'
G[25320]='K0810 L080 A:38917 T:40096 P:25430'
G[25321]='K0810 L080 A:40096 T:40096 P:25320'
G[25322]='E21655'
G[25323]='K0810 L080 A:39857 T:39857 P:25472'
G[25324]='K0810 L080 A:38917 T:40139 P:25424'
G[25325]='K0810 L080 A:40139 T:40178 P:25324'
G[25326]='E21655'
G[25327]='E21655'
G[25328]='K0810 L080 A:39640 T:39640'
G[25329]='FH K0370 L034 A:39656 T:39656 P:25344'
G[25330]='K0810 L080 A:39451 T:39451 P:25276'
G[25331]='FA K0070 L004 RW T:36458'
G[25332]='K08132 L080 A:39640 T:39435 P:25328'
G[25333]='FA K0370 L035 A:39653 T:39653 P:25208+25406'
G[25334]='K0810 L080 A:39226 T:40398 P:25471'
G[25335]='E21655'
G[25336]='FH K0380 L035 A:39894 T:39894'
G[25337]='FH K0380 L035 A:39894 T:39894 P:25336'
G[25338]='FH K0370 L035 A:8115 T:8115 P:25641'
G[25339]='FH K0360 L034 A:7776 T:7776'
G[25340]='FH K0360 L034 A:7776 T:7776'
G[25341]='FH K0360 L034 A:39656 T:39656'
G[25342]='FH K0370 L035 A:39656 T:39840 P:25341'
G[25344]='FH K0370 L034 A:39840 T:39840 P:25342'
G[25345]='FH K0370 L035 A:8115 T:8115 P:25338'
G[25346]='FH K0370 L035 A:8115 T:8115 P:25345'
G[25349]='FH K0400 L038 A:39847 T:39847'
G[25350]='FA K0370 L035 A:40132 T:40129'
G[25352]='FA K0810 L080 A:539433 T:539433 P:25278'
G[25353]='FA K0810 L080 A:539433 T:500015 P:25278'
G[25354]='FH K0810 L080 A:39432 T:39432'
G[25355]='FH K0810 L080 A:39432 T:39622'	-- needs P:
G[25356]='FH K0400 L038 A:39893 T:39895 O:28504 I:25478'
G[25357]='FA K0810 L080 A:39887 T:39887 P:25405'
G[25358]='K0810 L080 A:40983 T:40983 P:25602'
G[25359]='K0810 L080 A:39876 T:40221 P:25456'
G[25360]='K0810 L080 A:40227 T:40227'
G[25361]='FH K0380 L036 A:4544 T:4544 P:25338'
G[25362]='FH K0380 L036 A:4544 T:4544 P:25361'
G[25363]='FH K0380 L036 A:7875 T:7875'
G[25364]='FH K0380 L036 A:7875 T:7875 P:25363'
G[25365]='FH K0380 L036 A:7875 T:1142195 P:25363'
G[25366]='FH K0380 L036 A:1142195 T:7875 P:25365'
G[25367]='FH K0380 L036 A:7875 T:7875 P:25364+25365'
G[25368]='K0370 L035 A:40131 T:40131 P:25422+25423'
G[25369]='FH K0380 L036 A:7875 T:7875 P:25364+25365'
G[25370]='K0810 L080 A:40278 T:40278'
G[25371]='K0810 L080 A:41248 T:41248 P:25477'
G[25372]='K0810 L080 A:41381 T:539858 P:25842'
G[25373]='FH K0390 L037 A:39847 T:39847'
G[25374]='FH K0390 L037 A:39847 T:39847 P:25373'
G[25375]='FH K0390 L037 A:39847 T:39847 P:25373'
G[25376]='E21655'
G[25377]='K0810 L080 A:100053053 T:1202759'
G[25378]='FH K0400 L038 A:39847 T:39407 P:25349'
G[25379]='K0400 L038 A:39407 T:39407 P:25378,25437'
G[25381]='K0810 L080 A:39927 T:39927 P:25584 O:25630'
G[25382]='K0810 L080 A:39927 T:39927 P:25584'
G[25383]='FH K0400 L038 A:39407 T:39847 P:25379'
G[25385]='K0810 L080 A:39930 T:39930 P:25584'
G[25386]='FH K0360 L034 A:39377 T:39656 P:25250'
G[25387]='FH K0380 L036 A:39656 T:39847 P:25329'
G[25388]='K0810 L080 A:1202871 T:39883 P:25587'
G[25389]='K0810 L080 A:39883 T:39883 P:25388+25598'
G[25390]='K0810 L080 A:39883 T:39883 P:25388+25598'
G[25391]='FH K0370 L035 A:8115 T:8115 P:25346'
G[25392]='K0810 L080 A:39930 T:39930 P:25385'
G[25394]='FA K0360 L034 A:40032 T:40032 P:25447'
G[25395]='FA K0200 L018 A:41075 T:41075 O:26137,28565'
G[25396]='FA K0360 L034 A:40032 T:40032 P:25394'
G[25397]='FA K0360 L034 A:40032 T:40032 P:25394'
G[25398]='FA K0360 L034 A:40032 T:40032 P:25396+25397'
G[25399]='FA K0370 L035 A:39723 T:3936'
G[25400]='FA K0370 L035 A:39653 T:39653'
G[25401]='FA K0370 L035 A:39653 T:39653'
G[25402]='FA K0370 L035 A:39653 T:40052 P:25401'
G[25403]='FA K0370 L034 A:40052 T:40052 P:25402'
G[25404]='K0810 L080 A:39928 T:39933 P:25584'
G[25405]='FA K0810 L080 A:36915 T:39887 P:25281'
G[25406]='FA K0370 L035 A:39653 T:39653 P:25400'
G[25407]='FA K0370 L035 A:40078 T:40078'
G[25408]='K0810 L080 A:39933 T:39933 P:25404'
G[25409]='FA K0370 L035 A:40078 T:40078 P:25407'
G[25410]='FA K0370 L035 A:40078 T:40078 P:25409'
G[25411]='K0810 L080 A:39933 T:40093 P:25408'
G[25412]='K0810 L080 A:40093 T:39933 P:25411'
G[25419]='SP K0810 L080 A:100055186 T:0 P:25459'	-- added the prerequisite based on the wowhead comment
G[25420]='FA K0490 L047 A:40109 T:40109 O:28881'
G[25421]='FA K0490 L047 A:1202474 T:40109'
G[25422]='K0370 L035 A:40131 T:40131 P:25350,25643'
G[25423]='K0370 L035 A:40131 T:40131 P:25350,25643'
G[25424]='K0810 L080 A:40096 T:38917 P:25321'
G[25426]='FA K0390 L037 A:39725 T:39725'
G[25427]='FA K0390 L037 A:39725 T:39725 P:25426'
G[25428]='K0810 L080 A:39933 T:39933 P:25412'
G[25429]='FA K0390 L037 A:39725 T:39725 P:25427'
G[25430]='K0810 L080 A:39869 T:38917 P:25464'
G[25431]='FA K0390 L037 A:39725 T:39725 P:25427'
G[25432]='FA K0390 L037 A:39725 T:39725'
G[25433]='FA K0390 L037 A:39725 T:39725 P:25432'
G[25434]='FA K0390 L037 A:39725 T:39725 P:25432'
G[25436]='FA K0400 L038 A:39725 T:39725 P:25429'
G[25437]='FA K0400 L038 A:39725 T:39407 P:25436'
G[25438]='FA K0400 L038 A:39407 T:39725 P:25379'
G[25439]='K0810 L080 A:40221 T:40221 P:25359'
G[25440]='K0810 L080 A:40221 T:40221 P:25439'
G[25441]='K0810 L080 A:40221 T:40221'
G[25442]='K0810 L080 A:100054614 T:39875'
G[25444]='K0000 L001 E21655'
G[25445]='K0780 L000'
G[25447]='FA K0360 L034 A:40032 T:40032 O:14410,28511'
G[25448]='FA K0360 L034 A:40035 T:40035'
G[25449]='FA K0360 L034 A:40226 T:40226'
G[25450]='FA K0370 L034 A:40226 T:40226 P:25449'
G[25451]='FA K0370 L035 A:100055166 T:40226 P:25449'	-- TODO: Determine if this is in fact repeatable
G[25452]='FH K0360 L034 A:7854 T:7854'
G[25453]='FH K0370 L034 A:7854 T:7854 P:25452'
G[25454]='FH K0370 L034 A:100055167 T:7854 P:25452'
G[25456]='K0810 L080 A:39882 T:39876 P:25217'
G[25457]='E21655'
G[25458]='FA K0370 L035 A:39723 T:3936'
G[25459]='K0810 L080 A:39883 T:39883 P:25602'
G[25460]='K0810 L080 A:39925 T:39925'
G[25462]='K0810 L080 A:39932 T:39932 P:25428+25382+25392 O:25940'
G[25463]='FA K0370 L035 A:3936 T:39653 P:25458'
G[25464]='K0810 L080 A:39857 T:39857 TH:45312 P:25323'
G[25465]='K0370 L035 A:14637 T:14637'
G[25466]='K0370 L035 A:14637 T:14637'
G[25467]='K0810 L080 A:100054345 T:1202859'
G[25468]='FA K0370 L035 A:40913 T:40913 P:25410'
G[25469]='FA K0370 L035 A:40913 T:40913 P:25410'
G[25471]='K0810 L080 A:41341 T:39226 P:27708'
G[25472]='K0810 L080 A:39869 T:39857 P:25317'
G[25473]='FH K0020 L001 RG A:34872 T:34668 P:14069+14075'
G[25475]='K0370 L035 A:100008705 T:7807'
G[25476]='K0370 L035 A:7807 T:7406 P:25475'
G[25477]='K0810 L080 A:41248 T:41248 P:25558,25949'
G[25478]='FH K0400 L038 A:40344 T:39895 O:28504 I:25356'
G[25479]='FA K0400 L038 A:40345 T:39946 I:25481,28503'
G[25481]='FA K0400 L038 A:40369 T:39946 I:25479,28503'
G[25482]='K0800 L075 E21655'
G[25483]='K0000 L000 E21655'
G[25484]='K0800 L075 E21655'
G[25485]='K0800 L075 E21655'
G[25486]='FA K0400 L038 A:39946 T:39992 O:25479,25481,28503'
G[25487]='FH K0400 L038 A:39895 T:39963 P:25356,25478'
G[25488]='FA K0400 L038 A:39992 T:40027 P:25486'
G[25489]='FH K0400 L038 A:39963 T:40028 P:25487'
G[25490]='K0810 L080 A:39932 T:39858 P:25462'
G[25491]='K0810 L080 A:39858 T:39858 P:25490'
G[25492]='K0810 L080 A:40331 T:40331 P:25490'
G[25493]='K0810 L080 A:39858 T:39858 P:25490'
G[25494]='K0810 L078 A:39406 T:39406 P:25294'
G[25496]='K0810 L080 A:39406 T:39406 P:25494'
G[25499]='K0810 L080 A:39413 T:39413 P:25509'
G[25501]='E21655'
G[25502]='K0810 L080 A:40331 T:40331 P:25492'
G[25503]='K0810 L078 A:100054639 T:1202916'
G[25504]='FA K040 L038 A:40027 T:40475 P:25488'
G[25505]='FH K0400 L038 A:40028 T:40487 P:25489'
G[25507]='K0810 L080 A:39858 T:39858 P:25493'
G[25509]='K0810 L080 A:39413 T:39413 P:25291'
G[25510]='K0810 L080 A:39858 T:40341 P:25507'
G[25513]='FA K049512 L047 A:39034 T:19860 P:25095+25065|25018'	-- PM3
G[25514]='K0810 L080 A:40341 T:40341 P:25510'
G[25515]='FA K040 L038 A:40475 T:40475 P:25504'
G[25516]='FH K0400 L038 A:40487 T:40487 P:25505'
G[25517]='FA K040 L038 A:40554 T:40554 P:25488'
G[25518]='FH K0400 L038 A:40556 T:40556 P:25489'
G[25519]='K0810 L080 A:40341 T:40341 P:25510'
G[25520]='K0810 L080 A:40341 T:39858 P:25514+25519'
G[25521]='K0460 L044 A:40580 T:40580'
G[25522]='K0460 L044 A:40580 T:40580 P:25521'
G[25523]='K0810 L080 A:40578 T:40578 P:25810'
G[25524]='FA K040 L038 A:1202975 T:1202975 P:25504'
G[25525]='K0810 L080 A:40578 T:40578 P:25523'
G[25526]='FH K0400 L038 A:1202975 T:1202975 P:25505'
G[25531]='K0810 L080 A:40619 T:40772 P:25315'
G[25532]='FA K0400 L038 A:40475 T:0 P:25515+25517+25524'
G[25533]='FH K0400 L038 A:40487 T:0 P:25516+25518+25526'
G[25534]='FH K0460 L044 A:38703 T:38703 P:24927'
G[25535]='FA K0810 L080 A:39881 T:40641,49408 P:25922'
G[25536]='FA K0810 L080 A:40642 T:40642 P:25922'
G[25537]='FA K0810 L080 A:40639 T:40639 P:25535'
G[25538]='FA K0810 L080 A:40639 T:40639 P:25537'
G[25539]='FA K0810 L080 A:40641 T:40641 P:25535'
G[25540]='FA K0810 L080 A:40641 T:39881 P:25538'
G[25541]='FH K0460 L044 A:38703 T:38703 P:24927+24949'	-- TODO: Verify requires 24927
G[25542]='FA K0400 L038 A:-61 T:40475 P:25532 I:25561,M25542'
G[25543]='FH K0400 L038 A:-61 T:40487 P:25533 I:25562,M25543'
G[25544]='K0810 L080 A:40578 T:40578 P:25525'
G[25545]='FA K0810 L080 A:39887 T:39887 P:25357+25546'
G[25546]='FA K0810 L080 A:39887 T:39887 P:25405'
G[25547]='FA K0810 L080 A:39887 T:40690 P:25545+25564'
G[25548]='K0810 L080 A:540772 T:540772 P:25608'
G[25549]='K0810 L080 A:540772 T:540772 P:25548'
G[25550]='K0820 L078 A:540772 T:540772 P:25549'
G[25551]='K0820 L078 A:40773 T:540772 P:25550+25553+25555'
G[25552]='K0820 L078 A:40816 T:40816 P:25644'
G[25553]='K0820 L078 A:40816 T:40816 P:25552'
G[25554]='K0810 L080 A:40773 T:40773 P:25608'
G[25555]='K0820 L078 A:40773 T:40773 P:25554'
G[25556]='K0470 L046 A:7804 T:40712 P:25032'
G[25558]='FA K0810 L080 A:40690 T:40105 P:25547'
G[25559]='FA K0490 L047 A:40109 T:40109'
G[25560]='K0810 L080 A:40578 T:40578 P:25544'
G[25561]='FA K0400 L038 A:40475 T:40475 P:25532+M25542 I:25542'
G[25562]='FH K0400 L038 A:40487 T:40487 P:25533+M25543 I:25543'
G[25564]='FA K0810 L080 A:39887 T:39887 P:25357+25546'
G[25565]='FA K0490 L047 A:40109 T:40109'
G[25566]='FA K0490 L047 A:40109 T:1202474 P:25420'
G[25574]='K0810 L080 A:40278 T:40278 P:25370'
G[25575]='K0810 L080 A:40834 T:40834'
G[25576]='K0810 L080 A:40837 T:40837'
G[25577]='K0810 L080 A:40834 T:40834'
G[25578]='K0810 L080 A:40178 T:40289 P:25325'
G[25579]='FA K0810 L080 A:40643 T:40643 P:25536+25540'
G[25580]='FA K0810 L080 A:40642 T:40642 P:25536+25540'
G[25581]='FA K0810 L080 A:40644 T:40644 P:25536+25540'
G[25582]='FA K0810 L080 A:40643 T:40643 P:25536+25540'
G[25583]='FA K0810 L080 A:1202714 T:40643 P:27393'
G[25584]='K0810 L080 A:40289 T:39429 P:25578'
G[25585]='FA K041 L038 A:40475 T:40475 P:25542,25561'
G[25586]='FH K0410 L038 A:40487 T:40487 P:25543,25562'
G[25587]='K0810 L080 A:39667 T:39883 P:25371 O:27685'
G[25588]='FA K0410 L038 A:40591 T:40591 P:25542,25561'
G[25589]='FH K0410 L038 A:40595 T:40595 P:25543,25562'
G[25590]='FA K0410 L038 A:40554 T:40885 P:25542,25561'
G[25591]='FH K049512 L047 A:39034 T:19860'	-- PM3
G[25592]='FH K0810 L080 A:40917 T:40917'
G[25593]='FH K0810 L080 A:40916 T:40916'
G[25594]='FH K0810 L080 A:40918 T:40918'
G[25595]='FH K0810 L080 A:40919 T:40919'
G[25596]='FH K0410 L038 A:40556 T:40888 P:25543,25562'
G[25597]='K0810 L080 A:40289 T:39621 P:25653'
G[25598]='K0810 L080 A:39883 T:39883 P:25587'
G[25599]='K0810 L080 A:40834 T:40834 P:25575+25576+25577'
G[25600]='K0810 L080 A:40834 T:40834 P:25599'
G[25601]='K0810 L080 A:1202701 T:39413 P:25314'
G[25602]='K0810 L080 A:39884 T:39884 P:25388+25598'
G[25607]='FA K0250 L024 A:40895 T:40895'
G[25608]='K0810 L080 A:40772 T:40772 P:25531'
G[25609]='FA K0410 L038 A:40885 T:40885 P:25590'
G[25610]='FH K0410 L038 A:40888 T:40888 P:25596'
G[25611]='FA K0810 L080 A:40834 T:539433 P:25600'
G[25612]='FH K0810 L080 A:40834 T:39432 P:25600'
G[25613]='FA K0250 L024 A:40894 T:39256 P:13913+25607+13979'
G[25614]='FA K0250 L024 A:39256 T:39256 P:25613'
G[25615]='FA K0250 L024 A:39256 T:34354 P:25614'
G[25616]='FA K0260 L024 A:34354 T:40973 P:25615'
G[25617]='FH K0810 L080 A:39622 T:40834 P:25355 I:25624'
G[25618]='FA K0810 L080 A:500015 T:40834 P:25353 I:25623'
G[25619]='K0810 L080 A:40978 T:40978 P:B25760'
G[25620]='K0810 L080 A:40978 T:40640 P:25619'
G[25621]='FA K0260 L024 A:40895 T:40895 P:25615'
G[25622]='FA K0260 L024 A:-81,40895 T:40895 P:25621'
G[25623]='FA K0810 L080 A:39433 T:40834 I:25618'
G[25624]='FH K0810 L080 A:39432 T:40834 I:25617'
G[25626]='FA K0810 L080 A:39881 T:39881 P:25911'
G[25627]='FA K0420 L038 A:40885 T:40885 P:25609'
G[25628]='FH K0420 L038 A:40888 T:40888 P:25610'
G[25629]='K0810 L080 A:42077 T:42077 P:B26135,B25626'
G[25630]='K0810 L080 A:39434 T:39927 P:25611'
G[25631]='E21655'
G[25632]='E21655'
G[25633]='E21655'
G[25634]='E21655'
G[25635]='E21655'
G[25637]='K0810 L080 A:40640 T:41049 P:25620'
G[25638]='K0810 L080 A:1203128 T:40105 P:25459'
G[25639]='E21655'
G[25640]='FA K0260 L024 A:40895 T:40879 P:25622'
G[25641]='FH K0370 L035 A:39894 T:8115 P:25337'
G[25642]='FA K0260 L024 A:40879 T:40879 P:25640'
G[25643]='FH K0370 L035 A:5390 T:1203134'
G[25644]='K0820 L078 A:1207359 T:40816 P:25608'
G[25645]='FH K0370 L035 A:1203134 T:5390 P:25368'
G[25646]='FA K0260 L024 A:40973 T:40973 P:25640'
G[25647]='FA K0260 L024 A:100055181 T:40879 P:25640'
G[25648]='FH K0100 L008 A:39379 T:8576 P:25206+25236 I:28496'
G[25649]='FA K0260 L024 A:40879 T:40881 P:25647'
G[25650]='FA K0260 L024 A:40881 T:40879 P:25649'
G[25651]='K0810 L080 A:46338 T:46338 P:25602'
G[25652]='FA K0260 L024 A:40879 T:40896 P:25650'
G[25653]='K0810 L080 A:41504 T:40289 P:25928'
G[25654]='FA K0360 L034 A:40035 T:40035'
G[25655]='K0810 L080 A:41006 T:41006 P:25578'
G[25656]='K0810 L080 A:41006 T:41006 P:25578'
G[25657]='K0810 L080 A:46338 T:0 P:25651'
G[25658]='K0810 L080 A:41050 T:41050 P:25620'
G[25659]='K0810 L080 A:41049 T:0 P:25637'
G[25660]='K0410 L038 A:41058 T:41060 P:25627,25628'
G[25661]='K0420 L038 A:41060 T:41060 P:25660'
G[25662]='FA K0260 L025 A:40896 T:41071 P:25652'
G[25663]='K0810 L080 A:41005 T:41068 O:25985,27874'
G[25664]='K0810 L080 A:41005 T:41005 P:25665'
G[25665]='K0810 L080 A:41068 T:41005 P:25663'
G[25667]='FA K0060 L005 A:40950 T:40950 P:25724'
G[25668]='FA K0060 L005 A:40951 T:40951 P:25724'
G[25669]='FA K0270 L025 A:41071 T:40896 P:25662'
G[25670]='K0810 L080 A:46338 T:46458 P:27699'
G[25671]='FA K0282 L025 M030 A:40896 T:40896 P:U04583999'
G[25672]='K0420 L038 A:41060 T:41060 P:25661'
G[25673]='FA K0270 L025 A:40908 T:40908 P:25652'
G[25674]='FH K0550 L054 A:41124 T:41124 O:28553,28671,28858,28865'
G[25675]='FH K0550 L054 A:41125 T:41125'
G[25676]='FH K0550 L054 A:41124 T:41133 P:25674'
G[25677]='FH K0550 L054 A:41133 T:41133 P:25676'
G[25678]='FH K0550 L054 A:41133 T:41133 P:25676'
G[25679]='FH K0550 L054 A:41133 T:41134 P:25677+25678'
G[25680]='FH K0550 L054 A:41134 T:41134 P:25679'
G[25681]='FH K0550 L054 A:41134 T:41134 P:25680'
G[25682]='FH K0550 L054 A:41134 T:41124 P:25681'
G[25683]='FH K0550 L054 A:41124 T:7506 P:25682 I:26157'
G[25684]='FH K0550 L054 A:7506 T:7506 P:25683 I:26158'
G[25685]='FH K0550 L054 A:7506 T:7506 P:25684 I:26159'
G[25686]='FH K0550 L054 A:7506 T:7506 P:25685+25690 I:26160'
G[25687]='FH K0550 L054 A:7506 T:7506 P:25686 I:26161'
G[25688]='FH K0550 L054 A:7506 T:7783 P:25687'
G[25689]='FH K0560 L054 A:7783 T:41159 P:25688 I:26163'
G[25690]='FH K0550 L054 A:7505 T:7505 P:25684 I:26172'
G[25691]='FH K0560 L054 A:41159 T:41159 P:25689 I:26164'
G[25692]='FH K0560 L054 A:41159 T:41159 P:25689 I:26165'
G[25693]='FH K0560 L054 A:41159 T:7783 P:25691+25692 I:26166'
G[25694]='FH K0560 L054 A:19254 T:19254 I:26173'
G[25695]='FH K0560 L054 A:19254 T:19254 P:25694 I:26174'
G[25696]='FH K0570 L055 A:19254 T:42344'
G[25697]='FH K0560 L054 A:7783 T:7506 P:25693 I:26167'
G[25698]='FH K0560 L054 A:7783 T:7506 P:25693 I:26168'
G[25699]='FH K0560 L054 A:7783 T:7506 P:25693 I:26169'
G[25700]='FH K0560 L054 A:7506 T:7783 P:25697+25698+25699 I:26170'
G[25701]='FH K0570 L054 A:7783 T:41159 P:25700 I:26171'
G[25702]='K0570 L055 A:41265 T:41354'
G[25703]='K0570 L054 A:41354 T:41354 O:25702'
G[25704]='K0420 L038 A:41060 T:41060 P:25672'
G[25705]='K0570 L054 A:41354 T:41354 P:25703'
G[25706]='K0570 L055 A:41354 T:41354 P:25703'
G[25707]='K0570 L055 A:41402 T:0 P:25703'
G[25708]='FA K0550 L054 A:9540 T:9540 P:25715'
G[25709]='FA K0550 L054 A:9540 T:9540 P:25715'
G[25710]='FA K0550 L054 A:5393 T:5393 O:28673,28857,28867'
G[25711]='FA K0550 L054 A:5393 T:5393 P:25710'
G[25712]='FA K0550 L054 A:42262 T:42262 P:25710'
G[25713]='FA K0550 L054 A:42264 T:42264 P:25710'
G[25714]='FA K0550 L054 A:5393,9540 T:5385 P:25708+25709+25711'
G[25715]='FA K0550 L054 A:9540 T:9540 O:27919'
G[25716]='FA K0550 L054 A:5385 T:5385 P:25714'
G[25717]='FH K0580 L055 A:42344 T:42344 P:25696 I:26184'
G[25718]='FH K0580 L055 A:42344 T:42348 P:25717 I:26185'
G[25719]='FH K0580 L055 A:42348 T:42344 P:25718 I:26186'
G[25720]='FH K0590 L055 A:42344 T:42344 P:25719 I:26187'
G[25721]='FA K0200 L018 A:41086 T:41086 O:25770'
G[25722]='FA K0200 L018 A:41129 T:41129'
G[25723]='FA K0200 L018 A:41128 T:41128'
G[25724]='FA K0060 L005 A:40950 T:40950 O:26373'
G[25725]='FA K0200 L018 A:41128 T:41128 P:25723'
G[25726]='FA K0200 L018 A:41129 T:41129 P:25722'
G[25727]='FA K0200 L018 A:41086 T:41086 P:25721'
G[25728]='FA K0270 L025 A:40908 T:40896 P:25673'
G[25729]='FA K0270 L025 A:40895 T:40895,-43 P:25652'
G[25730]='FA K027512 L025 A:1203186 T:41054'	-- PM2
G[25731]='K0810 L080 A:41006 T:41006 P:25655+25656'
G[25732]='K0810 L080 A:46458 T:46458 P:25670'
G[25733]='FA K0210 L018 A:41086 T:41086 P:25727'
G[25734]='FA K0210 L018 A:41129 T:41129 P:25726'
G[25735]='FA K0210 L018 A:41128 T:41128 P:25725'
G[25736]='FA K0200 L018 A:100055243 T:41086 P:K100055243'	-- technically the prerequisite is SOMEONE turns in 25734 so NPC 41167 spawns to drop the item when killed
G[25739]='FA K0270 L025 A:40897 T:40897 P:25669'
G[25740]='K0810 L080 A:40997 T:541006 P:25664+25731'
G[25741]='FA K0270 L025 A:40898 T:40898 P:25669'
G[25743]='K0810 L080 A:46458 T:46463 P:25732'
G[25744]='FA K0410 L038 A:40027 T:41190 P:25542,25561'
G[25745]='FH K0410 L038 A:40028 T:41184 P:25543,25562'
G[25746]='K0810 L080 A:541006 T:541006 P:25740'
G[25747]='FA K0810 L080 A:539881 T:540643 P:25760'
G[25748]='FA K0810 L080 A:540643 T:540643 P:25747'
G[25749]='FA K0810 L080 A:540642 T:540642 P:25747'
G[25751]='FA K0810 L080 A:540639 T:540639 P:25747'
G[25752]='FA K0810 L080 A:540643 T:500001 P:25748+25749+25751'
G[25753]='FA K0810 L080 A:500002 T:500002 P:25752 I:25964'
G[25754]='FA K0810 L080 A:500001 T:500001 P:25752 I:25965'
G[25755]='FA K0810 L080 A:500004 T:500005 P:25753+25754 I:25966'
G[25756]='FA K0410 L038 A:41190 T:41190 P:25744'
G[25757]='FH K0410 L038 A:41184 T:41184 P:25745'
G[25758]='K0810 L080 A:541006 T:541006 P:25740'
G[25760]='FA K0810 L080 A:500003 T:539881 P:25583'
G[25761]='K0810 L080 A:541006 T:541006 P:25758'
G[25762]='K0420 L038 A:40082 T:40082 P:25744,25745'
G[25763]='K0810 L080 A:1203207 T:541006 P:25740'
G[25764]='K0810 L080 A:541006 T:541006 P:25763'
G[25765]='FA K0280 L026 A:40897 T:41229 P:25739'
G[25766]='FA K0280 L025 A:40899 T:40899 P:25669'
G[25767]='FA K0280 L025 A:40900 T:40900 P:25669'
G[25768]='FA K0280 L026 A:40896 T:41233 P:25769'
G[25769]='FA K0280 L026 A:40899 T:40896 P:25766+25767'
G[25770]='FA K0200 L018 A:41075 T:41086 P:25395'
G[25771]='K0551 L054 A:100010593 T:7363'
G[25772]='K0551 L054 A:100008244 T:7363'
G[25774]='FA K0420 L038 A:41190 T:41190 P:25756'
G[25775]='FH K0420 L038 A:41184 T:41184 P:25757'
G[25776]='K0810 L080 A:541006 T:541006 P:25746+25761+25764'
G[25777]='FA K0210 L018 A:41086 T:2104 P:25733+25734+25735+25736'
G[25778]='FA K0410 L038 A:41190 T:41204 P:25774'
G[25779]='FH K0410 L038 A:41184 T:41205 P:25775'
G[25780]='FA K0210 L019 A:2104 T:2104 O:25777'
G[25790]='FA K0410 L038 A:41204 T:41190 P:25778'
G[25791]='FH K0410 L038 A:41205 T:41184 P:25779'
G[25792]='FA K0070 L005 A:40950 T:40950 P:313+25667'
G[25793]='FA K0280 L026 A:41229 T:41276 P:25765'
G[25794]='K0810 L080 A:40105 T:40105 P:25638'
G[25795]='K0810 L080 A:541006 T:41005 P:25776'
G[25796]='FA K0410 L038 A:41190 T:41190 P:25790'
G[25797]='FH K0410 L038 A:41184 T:41184 P:25791'
G[25798]='FA K0410 L038 A:41190 T:41190 P:25790'
G[25799]='FH K0410 L038 A:41184 T:41184 P:25791'
G[25800]='FA K0220 L019 A:41297 T:41297'
G[25801]='FA K0220 L019 A:41297 T:41297 P:25800'
G[25802]='FA K0220 L019 A:41297 T:1000261 P:25800'
G[25803]='FA K0220 L019 A:1000261 T:1142151 P:25802'
G[25804]='FA K0220 L019 A:1142151 T:1000259 P:25803'
G[25805]='FA K0220 L019 A:1000259 T:41297 P:25804'
G[25806]='FA K0280 L026 A:41277 T:41277 P:25793'
G[25807]='K0810 L080 A:41005 T:41308 P:25795'
G[25808]='FA K0280 L026 A:41277 T:41277 P:25806'
G[25809]='FA K0280 L026 A:41282 T:41282 P:25793'
G[25810]='K0810 L078 A:41003 T:40578 P:25807'
G[25811]='FA K0280 L026 A:41276 T:41276 P:25793'
G[25812]='FA K0810 L080 A:40105 T:41324 P:25794'
G[25813]='FA K0420 L038 A:41190 T:41190 P:25796+25798'
G[25814]='FH K0420 L038 A:41184 T:41184 P:25797+25799'
G[25815]='FA K0220 L020 A:1239 T:1239'
G[25816]='FA K0220 L020 A:1239 T:41307 P:25815'
G[25817]='FA K0220 L020 A:41307 T:41307 P:25816'
G[25818]='FA K0230 L020 A:41307 T:1112948 P:25817'
G[25819]='FA K0230 L020 A:1112948 T:1217 P:25818'
G[25820]='FA K0220 L020 A:1484 T:1484'
G[25821]='FA K0280 L026 A:41277 T:41229 P:25808+25809+25811'
G[25822]='FA K0280 L026 A:41229 T:41229 P:25845'
G[25823]='FA K0280 L026 A:41229 T:41229 P:25845'
G[25824]='FA K0810 L080 A:41341 T:41341 P:25812'
G[25825]='FA K0420 L038 A:41190 T:40027 P:25813'
G[25826]='FH K0420 L038 A:41184 T:40028 P:25814'
G[25829]='E21655'
G[25830]='K0810 L080 A:40289,46987,46998,47002 T:41381 P:25807'
G[25832]='K0810 L080 A:40578 T:41308 P:25560'
G[25834]='FA K0290 L026 A:41229 T:41278 P:25821'
G[25835]='FA K0420 L038 A:40027 T:41392 P:25704+25825'
G[25836]='FH K0420 L038 A:40028 T:41446 P:25704+25826'
G[25837]='FA K0280 L026 A:41278 T:41278 P:25834'
G[25838]='FA K0080 L005 A:40950 T:41363 P:412+25792'
G[25839]='FA K0080 L005 A:41363 T:41298 P:25838'
G[25840]='FA K0080 L005 A:41298 T:41298 P:25839'
G[25841]='FA K0080 L005 A:41298 T:41298 P:25839'
G[25842]='K0810 L080 A:41381 T:41381 P:25830'
G[25843]='K0810 L080 A:539858 T:41504 P:25372'
G[25844]='FA K0290 L026 A:41278 T:41350 P:25837'
G[25845]='FA K0290 L026 A:41350 T:41229 P:25844'
G[25846]='FA K0290 L026 A:41229 T:11858 P:25822'
G[25847]='K0300 L026 A:11858 T:11858 P:25846'
G[25848]='K0300 L026 A:11858 T:11858 P:25847'
G[25849]='FA K0230 L021 A:41411 T:41411 O:26981'
G[25850]='FA K0230 L021 A:41412 T:41412'
G[25851]='FA K0300 L026 A:11858 T:41229 P:25848'
G[25852]='FA K0300 L026 A:41229 T:38378 P:25851'
G[25853]='FA K0230 L021 A:41413 T:41413'
G[25854]='FA K0230 L021 A:41435 T:41435'
G[25855]='FA K0230 L021 A:41435 T:41435 P:25854'
G[25856]='FA K0230 L021 A:41433 T:41433'
G[25857]='FA K0230 L021 A:41433 T:41433 P:25856'
G[25858]='K0810 L080 A:42076 T:42074 P:B25755'
G[25859]='K0810 L080 A:42074 T:42074 P:25858'
G[25860]='K0810 L080 A:41456 T:41456 P:25629+25896'
G[25861]='K0810 L080 A:41457 T:41457 P:25858'
G[25862]='K0810 L080 A:41476 T:1203305 P:25858'
G[25863]='K0810 L080 A:1203305 T:542076 P:25862'
G[25864]='FA K0230 L021 A:41415 T:41415 O:26980'
G[25865]='FA K0230 L021 A:41415 T:41415 P:25864'
G[25866]='FA K0230 L021 A:41415 T:41415 P:25865'
G[25867]='FA K0230 L021 A:41415 T:41415 P:25865'
G[25868]='FA K0230 L021 A:41415 T:41415 P:25866+25867'
G[25869]='FA K0420 L038 A:41392 T:41392 P:25835'
G[25870]='FH K0420 L038 A:41446 T:41446 P:25836'
G[25871]='FA K0420 L038 A:41444 T:41444 P:25835'
G[25872]='FH K0420 L038 A:41421 T:41421 P:25836'
G[25873]='FA K0430 L038 A:45271 T:41392 P:25835'
G[25874]='FH K0430 L038 A:45271 T:41446 P:25836'
G[25875]='FA K0280 L026 A:41233 T:41434 P:25768'
G[25876]='FA K0280 L026 A:41434 T:41434 P:25875'
G[25877]='FA K0280 L026 A:41434 T:41233 P:25876'
G[25878]='FA K0280 L026 A:41441 T:41441 P:25768'
G[25879]='FA K0280 L026 A:41441 T:41441 P:25768'
G[25880]='FA K0290 L026 A:41233 T:41482 P:25877'
G[25881]='K0810 L080 A:41507 T:41492 P:25372'
G[25882]='FA K0080 L005 A:41298 T:41578 P:25840+25841'
G[25883]='K0810 L080 A:1203301 T:0 P:0'
G[25884]='K0810 L080 A:41344 T:0 P:25887'
G[25885]='FA K0810 L080 A:41340 T:41340 P:25887'
G[25886]='K0810 L080 A:41492 T:41492 P:25881'
G[25887]='K0810 L080 A:41341 T:41341 P:25824,26007'
G[25888]='FA K0810 L080 A:41347 T:41347 P:25887'
G[25889]='FA K0290 L026 A:41482 T:41482 P:25880'
G[25890]='K0810 L080 A:39875 T:41531'
G[25891]='FA K0290 L026 A:41482 T:41482 P:25889'
G[25892]='FA K0810 L080 A:500005 T:40642 P:25755 I:25967'
G[25893]='FA K0810 L080 A:40642 T:41535 P:25892 I:25968'
G[25894]='FA K0810 L080 A:40645 T:41535 P:25893'
G[25895]='FA K0810 L080 A:41535 T:41535 P:25893'
G[25896]='K0810 L080 A:41456 T:41456 P:B26135,B25626'
G[25897]='FA K0810 L080 A:41535 T:41535 P:25893'
G[25898]='FA K0810 L080 A:41535 T:540645 P:25894+25895+25897'
G[25899]='K0810 L080 A:41507 T:41492 P:25843'
G[25900]='K0810 L080 A:41531 T:41531 P:25890'
G[25901]='K0810 L080 A:41497 T:41497 P:25372'
G[25904]='K0810 L080 A:41504 T:41504 P:25843'
G[25905]='FA K0080 L005 A:1261 T:1261 P:25932'
G[25906]='K0810 L080 A:41504 T:41498 P:25904'
G[25907]='K0810 L080 A:41531 T:41531 P:25900'
G[25908]='K0810 L080 A:41531 T:41531 P:25900'
G[25909]='FA K0810 L080 A:41531 T:41531 P:25907+25908'
G[25910]='K0810 L080 A:41498 T:41498 P:25906'
G[25911]='FA K0810 L080 A:540645 T:40642 P:25898'
G[25912]='FA K0290 L026 A:41486 T:41486 P:25891'
G[25913]='FA K0290 L026 A:41488 T:41488 P:25891'
G[25914]='FA K0290 L026 A:41488 T:41488 P:25891'
G[25915]='K0810 L080 A:41498 T:41498 P:25906'
G[25916]='FA K0810 L080 A:41531 T:41531 P:25909'
G[25917]='FA K0810 L080 A:41531 T:41540 P:25916'
G[25918]='FA K0810 L080 A:41541 T:41541 P:25917'
G[25919]='FA K0810 L080 A:41540 T:41540 P:25917'
G[25920]='FA K0810 L080 A:41802 T:41802 P:25917'
G[25921]='FA K0810 L080 A:41540 T:41531 P:25918+25919+25920'
G[25922]='FA K0810 L080 A:41531 T:40642 P:25921'
G[25923]='K0810 L080 A:41498 T:41498 P:25915'
G[25924]='FH K0810 L080 A:41621 T:41618 O:27718,28816'
G[25925]='FA K0300 L026 A:41482 T:41487 P:25891'
G[25926]='FA K0250 L023 A:41503 T:41503'
G[25927]='FA K0250 L023 A:41503 T:41503 P:25926'
G[25928]='K0810 L080 A:41498 T:41504 P:25923'
G[25929]='FH K0810 L080 A:41618 T:41618 P:25924'
G[25930]='FA K0300 L026 A:41487 T:41487 P:25925'
G[25931]='FA K0300 L026 A:41487 T:41487 P:25930'
G[25932]='FA K0090 L006 A:41578 T:41578 O:25882'
G[25933]='FA K0090 L006 A:41578 T:1254 P:314+25905'
G[25934]='FA K0300 L026 A:41664 T:41664 P:25925'
G[25935]='FA K0300 L026 A:41638 T:41638 P:25925'
G[25936]='FH K0810 L080 A:41618 T:41618 P:25929'
G[25937]='FA K0100 L007 A:50631 T:50631'
G[25938]='FA K0300 L027 A:41487 T:36410 I:28531'
G[25939]='FA K0240 L022 A:41615 T:41615 P:25926'
G[25940]='K0810 L080 A:39927,39928 T:39932 P:25428+25382+25392'
G[25941]='FH K0810 L080 A:41618 T:41711 P:25936'
G[25942]='FH K0810 L080 A:41711 T:41711 P:27668'
G[25943]='FH K0810 L080 A:41711 T:41711'
G[25944]='FH K0810 L080 A:41711 T:41711 P:25942+25943+25946'
G[25945]='FH K0260 L024 A:41678 T:34341 O:28532'
G[25946]='FH K0810 L080 A:1203395 T:41711 O:27668'
G[25947]='FH K0810 L080 A:41711 T:41711 P:25942+25943+25946'
G[25948]='FH K0810 L080 A:41711 T:41750 P:25944+25947'
G[25949]='FH K0810 L080 A:41750,41769 T:40105 P:25948'
G[25950]='FA K0820 L080 A:41667 T:41667 P:26080'
G[25951]='K0810 L080 A:41456 T:542077 P:25860'
G[25952]='FH K0810 L080 A:40916 T:40916'
G[25953]='FH K0810 L080 A:40917 T:40917'
G[25954]='FH K0810 L080 A:40920 T:40920'
G[25955]='FH K0810 L080 A:40916 T:40916'
G[25956]='FH K0810 L080 A:1203140 T:40916 O:27394'
G[25957]='FH K0810 L080 A:40919 T:40919'
G[25958]='FH K0810 L080 A:40919 T:40916 P:25957'
G[25959]='FH K0810 L080 A:40916 T:40916 P:25958'
G[25960]='FH K0810 L080 A:40917 T:40917'
G[25962]='FH K0810 L080 A:40918 T:40918'
G[25963]='FH K0810 L080 A:40916 T:40916'
G[25964]='FH K0810 L080 A:40917 T:40917 I:25753'
G[25965]='FH K0810 L080 A:40916 T:40916 P:25963 I:25754'
G[25966]='FH K0810 L080 A:40919 T:40919 I:25755'
G[25967]='FH K0810 L080 A:40919 T:40917 P:25966 I:25892'
G[25968]='FH K0810 L080 A:40917 T:41770 P:25967 I:25893'
G[25969]='FH K0810 L080 A:40921 T:41770'
G[25970]='FH K0810 L080 A:41770 T:72841'
G[25971]='FH K0810 L080 A:41770 T:41770'
G[25972]='FH K0810 L080 A:41770 T:40921'
G[25973]='FH K0810 L080 A:40921 T:40917 P:25972'
G[25974]='FH K0820 L080 A:41670 T:41670'
G[25975]='FA K0820 L080 A:41665 T:41665 P:26080'
G[25976]='FH K0820 L080 A:41668 T:41668'
G[25977]='FA K0820 L080 A:41667 T:41667 P:26080'
G[25978]='FA K0100 L007 A:41786 T:41786 O:25986'
G[25979]='FA K0100 L007 A:41804 T:41804'
G[25980]='FH K0820 L080 A:41670 T:41670'
G[25981]='FA K0820 L080 A:41666 T:41666 P:26080'
G[25982]='K0820 L080 A:41669 T:41669'
G[25983]='FA K0820 L080 A:41666 T:41598 P:25987'
G[25984]='FH K0820 L080 A:41669 T:41636 P:25988'
G[25985]='K0810 L080 A:40833 T:41005 P:25578 I:27874'
G[25986]='FA K0100 L006 A:1977 T:41786 P:432+433+25937'
G[25987]='FA K0820 L080 A:41666 T:41666 P:25981'
G[25988]='FH K0820 L080 A:41669 T:41669 P:25982'
G[25989]='FH K0810 L080 A:41531 T:41531 P:25907,25908'
G[25990]='FH K0810 L080 A:41531 T:41531 P:25989'
G[25991]='FH K0810 L080 A:41531 T:41810 P:25990'
G[25992]='FH K0810 L080 A:41811 T:41811'
G[25993]='FH K0810 L080 A:41810 T:41810 P:25991'
G[25994]='FH K0810 L080 A:41813 T:41813'
G[25995]='FH K0810 L080 A:41810 T:41531'
G[25996]='FH K0810 L080 A:41531 T:40917 P:25995'
G[25997]='FA K0100 L007 A:41786 T:41786 P:25978+25979'
G[25998]='FA K0100 L007 A:41786 T:41853 P:25997'
G[25999]='FH K0260 L024 A:34341 T:34341 P:25945'
G[26000]='FH K0810 L080 A:40105 T:41863 P:25794'
G[26001]='FH K0260 L024 A:34341 T:40901 P:25999'
G[26002]='FH K0260 L024 A:40901 T:34341 P:26001'
G[26003]='FH K0260 L024 A:40926 T:40926 P:25999'
G[26004]='FH K0260 L024 A:34341 T:41023 P:26002'
G[26005]='FA K0810 L080 A:39881 T:42411 P:25626'
G[26006]='FH K0810 L080 A:40919 T:42410 P:26135'
G[26007]='FH K0810 L080 A:41341 T:41341 P:25824'
G[26008]='FH K0810 L080 A:41347 T:33536,41347'
G[26009]='FH K0272 L024 M030 A:41023 T:41023 P:26004+U04C83999'
G[26010]='FH K0270 L024 A:41023 T:41023 P:26004'
G[26011]='FH K0270 L024 A:40903 T:40903 P:26004'
G[26012]='K0820 L080 A:16128 T:27990'
G[26013]='K0820 L080 A:27990 T:40429 P:26012'
G[26014]='FA K0810 L080 A:41662 T:41910 P:26106'
G[26015]='K0810 L080 A:41910 T:46592,41910 P:26014'
G[26016]='FH K0270 L024 A:100056474 T:41023 Z16030'	-- drops from the target of 26011
G[26017]='FA K0810 L080 A:41910 T:41910 P:26015'
G[26018]='FA K0810 L080 A:41910 T:41910 P:26015'
G[26019]='FA K0810 L080 A:100056571 T:41910'
G[26020]='FH K0270 L024 A:41023 T:40902 P:26010'
G[26021]='FA K0810 L080 A:41910 T:41910 P:26019'
G[26022]='FH K0270 L025 A:41949 T:41949 O:28572,28619'
G[26023]='FH K0270 L025 A:41949 T:41944 P:26022'
G[26024]='FA K0280 L026 A:1002713 T:2700'
G[26025]='FH K0270 L025 A:41949 T:41949 P:26022'
G[26026]='FH K0270 L024 A:40907 T:40907 P:26004'
G[26027]='FH K0270 L025 A:41966 T:41949 P:26053'
G[26028]='FH K0270 L024 A:40907 T:41023 P:26026'
G[26029]='FH K0270 L025 A:41966 T:41966 P:26025+26027'
G[26030]='FH K0270 L025 A:41944 T:41944 P:26023'
G[26031]='FH K0270 L025 A:41944 T:41944 P:26030'
G[26032]='FH K0270 L025 A:41944 T:41944 P:26031'
G[26033]='FH K0270 L025 A:41944 T:41944 P:26032'
G[26034]='K0820 L080 A:40429 T:27990 P:26013'
G[26035]='FA K0260 L024 A:2789 T:2789'
G[26036]='FA K0260 L024 A:2789 T:2789 P:26035'
G[26037]='FA K0270 L024 A:2789 T:41983 P:26036'
G[26038]='FA K0270 L024 A:41983 T:2789 P:26037'
G[26039]='K0290 L027 A:1138492 T:1002701 O:26341,26909'
G[26040]='FH K0810 L080 A:41863,41885 T:41885'
G[26041]='K0290 L027 A:1002701 T:1002702 P:26039'
G[26042]='K0290 L027 A:1002702 T:1002688 P:26041'
G[26043]='FH K027512 L024 A:1203186 T:40903'	-- PM2
G[26044]='FH K0270 L024 A:40902 T:41991 P:26020'
G[26045]='FH K0270 L024 A:41991 T:41991 P:26044'
G[26046]='FH K0270 L024 A:41990 T:41990 P:26044'
G[26047]='FH K0270 L024 A:41992 T:41992 P:26044'
G[26048]='FH K0270 L024 A:41991 T:40902 P:26045+26046+26047'
G[26049]='FA K028512 L026 A:2789 T:1138492 P:26346'	-- PM2
G[26050]='K02832 L026 A:2768 T:2774'
G[26051]='K0280 L026 A:2774 T:2774 P:26050'
G[26052]='K0280 L026 A:2774 T:2610 P:26051'
G[26053]='FH K0270 L025 A:41966 T:41966'
G[26054]='FA K0800 L078 A:42443 T:466 Z13329'
G[26055]='K0280 L026 A:2769 T:2769'
G[26056]='FA K0820 L080 A:41598 T:41640'
G[26057]='FH K0820 L080 A:41636 T:41640'
G[26058]='FH K0270 L024 A:40902 T:41023 P:26048'
G[26059]='FH K0280 L026 A:41023 T:3995 P:26058'
G[26060]='FH K0280 L026 A:3995 T:3995 P:26059'
G[26061]='FH K0280 L026 A:3995 T:3995 P:26059'
G[26062]='FH K0280 L026 A:3995 T:3995 P:26060+26061'
G[26063]='FH K0270 L025 A:11821 T:11821'
G[26064]='FH K0280 L026 A:3411 T:3411 P:26059'
G[26065]='K0820 L080 A:41640 T:41640 O:26056,26057'
G[26066]='FH K0290 L026 A:42023 T:42023 P:26060+26061'
G[26067]='FH K0300 L026 A:3995 T:3995 P:26062'
G[26068]='FH K0300 L026 A:42023 T:42023 P:26066'
G[26069]='FH K0300 L028 A:3995 T:37135 I:28549'	-- this became available sometime after both 26060 and 26061 were accepted.  also accepted was 26064.  however, I did not see this available.  I may have missed it, or it became available after time or after one of these three mentioned was complete but not turned in.
G[26070]='FA K0820 L080 A:41598 T:41598 P:25983'
G[26071]='FH K0820 L080 A:41636 T:41636 P:25984'
G[26072]='K0820 L080 A:41600 T:41600'
G[26073]='FH K0300 L026 A:3995 T:41023 P:26067+26068'
G[26074]='FH K0300 L026 A:41023 T:42033 P:26073'
G[26075]='FH K0300 L026 A:42033 T:42033 P:26074'
G[26076]='FH K0300 L026 A:42033 T:42033 P:26075'
G[26077]='FH K0300 L026 A:42033 T:42050 P:26076'
G[26078]='FA K0100 L007 A:41853 T:41853 P:25998'
G[26079]='FA K0280 L026 A:1002713 T:2700'
G[26080]='FA K0810 L080 A:41910 T:41662 P:26017+26018'
G[26081]='FH K0270 L025 A:41944 T:41949 P:26033'
G[26082]='FH K0300 L026 A:42050 T:42050 P:26077'
G[26083]='FH K0270 L025 A:42088 T:2766 P:26081+T01541999'	-- TODO: Verify requires Neutral Booty Bay
G[26084]='FH K0270 L025 A:41949 T:42130 P:26081'
G[26085]='FA K0100 L007 A:41853 T:41853 P:26078'
G[26086]='FH K0810 L080 A:41663 T:41908'
G[26087]='FH K0810 L080 A:41908 T:41908 P:26086'
G[26088]='FH K0810 L080 A:41908 T:41908'
G[26089]='FH K0810 L080 A:41908 T:41908'
G[26090]='FH K0810 L080 A:100056812 T:41908'
G[26091]='FH K0810 L080 A:41908 T:41908 P:26090'
G[26092]='FH K0810 L080 A:41908 T:41663'
G[26093]='FA K0260 L024 A:2700 T:2700 O:26139,28573'
G[26094]='FA K0100 L007 A:41853 T:41853 P:26085'
G[26095]='FA K0280 L026 A:2700 T:2700 P:26093'
G[26096]='K0820 L080 A:41639 T:41639'
G[26097]='FH K0300 L026 A:42039 T:42091 P:26082'
G[26098]='FH K0300 L026 A:42091 T:42039 P:26097'
G[26099]='FH K0300 L026 A:42039 T:42047 P:26098'
G[26100]='FH K0300 L026 A:42047 T:41023 P:26099'
G[26101]='FH K0300 L026 A:41023 T:42106 P:26100'
G[26102]='FA K0100 L007 A:41853 T:41853 P:26094'
G[26103]='FA K0810 L080 A:41666 T:41666 P:26219'
G[26105]='FA K0810 L080 AK:42115 T:41665'
G[26106]='FA K0810 L080 A:41666 T:41666 P:26103'
G[26107]='FH K0280 L026 A:42130 T:42130'
G[26108]='FH K0280 L026 A:42130 T:42130 P:26107'
G[26109]='E21655'
G[26110]='FA K0280 L026 A:2712 T:2712 O:26113'
G[26111]='K0820 L080 A:41600 T:41600 P:26072+26096'	-- does this also need 26070/26071 ?
G[26112]='FA K0100 L007 A:41853 T:42129 P:26102'
G[26113]='FA K0280 L026 A:2608 T:2712'
G[26114]='FA K0280 L026 A:2712 T:2713 P:26110'
G[26115]='FH K0300 L026 A:42106 T:542039 P:26101'
G[26116]='FA K02832 L026 A:2713 T:2712 P:26114'
G[26117]='FA K0280 L026 A:2712 T:2608 P:26116'
G[26118]='FA K0100 L007 A:42129 T:42129 P:26112'
G[26119]='E21655'
G[26120]='FA K0250 L023 A:41612 T:41612'
G[26122]='FH K0810 L080 A:41669 T:41669'
G[26123]='E21655'
G[26124]='FH K0810 L080 AK:42114 T:41668 I:26125'
G[26125]='FH K0810 L080 A:41663 T:41668 I:26124'
G[26126]='FH K0810 L080 A:41669 T:41669 P:26122'
G[26127]='FA K0250 L023 A:42160 T:42160 O:26327'
G[26128]='FA K0250 L023 A:42160 T:-40,42160 P:26127'
G[26129]='FA K0030 L001 RW A:35077 T:35112 P:14154'
G[26130]='K0820 L080 A:41600 T:41600 P:26111'
G[26131]='FA K010 L010 A:1959 T:1960 I:28567'
G[26132]='FA K0820 L080 A:41598 T:41598 P:26111'
G[26133]='FH K0820 L080 A:41636 T:41636'
G[26134]='FH K0300 L027 A:500030 T:35286 P:26115'
G[26135]='FH K0810 L080 A:40919 T:40919'
G[26136]='E21655'
G[26137]='FA K0200 L018 A:1343 T:41075 I:28565,25235'	-- It is reported that the I:25235 is currently an accident Blizzard may fix in the future.
G[26138]='K0240 L022 E21655'
G[26139]='FA K0250 L023 A:-40,42160 T:2700 P:26128 I:28573'
G[26140]='K0820 L080 A:41600 T:42197 P:26130'
G[26141]='K0820 L080 A:42197 T:42197 P:26140'
G[26142]='K0820 L080 A:42197 T:42197 P:26140'
G[26143]='K0830 L080 A:-614 T:42197 P:26154'
G[26144]='FA K0820 L080 A:100057102 T:-614'
G[26145]='FA K0120 L010 A:1089 T:1089 O:13635'
G[26146]='FA K0120 L010 A:1092 T:1092 O:13635'
G[26147]='FA K0120 L010 A:1090 T:1090 P:26146'
G[26148]='FA K0120 L010 A:1092 T:1092 P:26146'
G[26149]='FH K0820 L080 A:100057118 T:-614'
G[26150]='FA K0060 L005 A:253 T:251 P:60'
G[26152]='FA K0100 L007 A:1203733 T:42256'
G[26153]='FA K0002 L010 A:42288 T:42288 P:PC001 I:26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26154]='K0820 L080 A:42197 T:-614 P:26141+26142'
G[26157]='FA K0550 L054 A:5385 T:42298 P:25716 I:25683'
G[26158]='FA K0550 L054 A:42298 T:42298 P:26157 I:25684'
G[26159]='FA K0550 L054 A:42298 T:42298 P:26158 I:25685'
G[26160]='FA K0550 L054 A:42298 T:42298 P:26159 I:25686'
G[26161]='FA K0560 L054 A:42298 T:42298 P:26166 I:25687'
G[26162]='FA K0560 L054 A:42298 T:7783 P:26161'
G[26163]='FA K0560 L054 A:42298 T:42299 P:26167+26168+26169 I:25689'
G[26164]='FA K0560 L054 A:42299 T:42299 P:26163 I:25691'
G[26165]='FA K0560 L054 A:42299 T:42299 P:26163 I:25692'
G[26166]='FA K0560 L054 A:42299 T:42298 P:26164+26165 I:25693'
G[26167]='FA K0550 L054 A:42298 T:42298 P:26160 I:25697'
G[26168]='FA K0550 L054 A:42298 T:42298 P:26160 I:25698'
G[26169]='FA K0550 L054 A:42298 T:42298 P:26160 I:25699'
G[26170]='FA K0560 L054 A:42298 T:7783 P:26162 I:25700'
G[26171]='FA K0570 L054 A:7783 T:42299 P:26170 I:25701'
G[26172]='FA K0550 L054 A:42298 T:42298 P:26158 I:25690'
G[26173]='FA K0560 L054 A:16841 T:16841 I:25694'
G[26174]='FA K0560 L054 A:16841 T:16841 P:26173 I:25695'
G[26175]='FA K0570 L055 A:16841 T:42349 P:26174'
G[26176]='FA K0120 L010 A:1092 T:1340 P:26148'
G[26177]='FA K0002 L010 A:42288 T:42288 P:PC001 I:26153,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26178]='E21655'
G[26179]='FH K0070 L005 A:2988 T:2988 P:751'
G[26180]='FH K0080 L006 A:2988 T:2988 P:751'
G[26181]='FA K0820 L080 A:42197 T:541600 P:26143'
G[26182]='FH K0820 L080 A:42197 T:41600'
G[26183]='FA K0002 L010 A:42288 T:42288 P:PC001 I:26153,26177,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26184]='FA K0580 L055 A:42349 T:42349 O:26175 I:25717'
G[26185]='FA K0580 L055 A:42349 T:42352 P:26184 I:25718'
G[26186]='FA K0580 L055 A:42352 T:42349 P:26185 I:25719'
G[26187]='FA K0590 L055 A:42349 T:42349 P:26186 I:25720'
G[26188]='FH K0080 L006 A:3055 T:3055'
G[26189]='FA K0240 L022 A:41411 T:41411 P:25849'
G[26190]='FA K0002 L010 A:42288 T:42288 P:PC001 I:26153,26177,26183,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26191]='SP K0810 L080 A:542076 T:0 P:25859+25863'
G[26192]='FA K0002 L010 A:42288 T:42288 P:PC001 I:26153,26177,26183,26190,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26193]='FA K0820 L080 A:541600 T:44490 P:26181'
G[26194]='FH K0820 L080 A:41600 T:44540'
G[26195]='FA K0240 L022 A:41411 T:41615 P:25850+25853+26189'
G[26196]='FA K0250 L023 A:41615 T:1071 P:25939'
G[26197]='FA K0010 L001 RN CM A:42396 T:42331 P:27674'
G[26198]='K0030 L001 RN CM A:42331 T:42331 P:26197'
G[26199]='FA K0010 L001 RN CT A:42396 T:42323 P:27674'
G[26200]='K0030 L002 RN CT A:42323 T:42323 P:26199'
G[26201]='K0030 L002 RN CL A:460 T:460 P:26202'
G[26202]='FA K0010 L001 RN CL A:42396 T:460 P:27674'
G[26203]='FA K0010 L001 RN CW A:42396 T:42324 P:27674'
G[26204]='K0030 L002 RN CW A:42324 T:42324 P:26203'
G[26205]='K0020 L002 RN A:42553 T:42553 P:26222'
G[26206]='FA K0010 L001 RN CR A:42396 T:42366 P:27674'
G[26207]='K0030 L002 RN CR A:42366 T:42366'
G[26208]='FA K0020 L002 RN A:42317 T:42317 P:26421,26422,26423,26424,26425,31137'
G[26209]='FA K0110 L009 A:42308 T:42308 O:26378,28562'
G[26210]='FH K0310 L029 A:14740 T:14740'
G[26211]='FH K0310 L029 A:14740 T:14740'
G[26212]='FH K0310 L029 A:14731 T:14731'
G[26213]='FA K0100 L009 A:42308 T:42308 P:26209'
G[26214]='FA K0110 L009 A:42308 T:42308 P:26209'
G[26215]='FA K0110 L009 A:42308 T:42405 P:26213+26214'
G[26219]='FA K0810 L080 A:42411 T:41662 P:26005'
G[26220]='FH K0002 L010 A:42506 T:42506 P:PC001 I:26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26221]='FH K0810 L080 A:42410 T:41663'
G[26222]='FA K0020 L002 RN A:42553 T:42553 P:26566'
G[26223]='FH K0320 L029 A:14741 T:14741'
G[26224]='FH K0320 L029 A:14741 T:14741 P:26223'
G[26225]='FH K0310 L029 A:42464 T:42464'
G[26226]='FH K0002 L010 A:42506 T:42506 P:PC001 I:26220,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26227]='FH K0002 L010 A:42506 T:42506 P:PC001 I:26220,26226,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26228]='FA K0110 L009 A:42405 T:42405 P:26215'
G[26229]='FA K0110 L009 A:42498 T:42498 P:26215'
G[26230]='FA K0120 L009 A:42497 T:42497 P:26215'
G[26232]='FA K0120 L009 A:42405 T:42558 P:26228'
G[26233]='FH K0002 L010 SL A:42506 T:42506 P:PC001 I:26220,26226,26227,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26234]='FH K0002 L010 RL A:42506 T:42506 P:PC001 I:26220,26226,26227,26233,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26235]='FH K0002 L010 A:42506 T:42506 P:PC001 I:26220,26226,26227,26233,26234,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26236]='FA K0120 L010 A:42558 T:233 P:26232'
G[26237]='FA K0120 L010 A:233 T:233 P:26236'
G[26238]='FH K0320 L030 A:42613 T:42613'
G[26239]='E21655'
G[26240]='FH K0320 L030 A:14739 T:14739'
G[26241]='FA K0120 L010 A:235 T:235 P:26236'
G[26242]='E21655'
G[26243]='K0820 L081 E21655'
G[26244]='K0820 L081 A:43397 T:43397'
G[26245]='K0820 L081 A:43065 T:43065 O:27123'
G[26246]='K0820 L081 A:1204274 T:43065 P:B26245'
G[26247]='K0820 L081 A:43065 T:42684 P:26244+26246+26245'
G[26248]='K0820 L081 A:42684 T:42684 P:26247'
G[26249]='K0820 L081 A:42684 T:43082 P:26247'
G[26250]='K0820 L081 A:42684 T:42684 P:26248'
G[26251]='K0820 L081 A:42684 T:42684 P:26248'
G[26252]='FA K0120 L010 A:100057935 T:233 P:26236'
G[26254]='K0820 L081 A:42684 T:42684 P:26250'
G[26255]='K0820 L081 A:42684 T:43065 P:26254'
G[26256]='K0820 L081 A:-640,43065 T:0,43065 P:26258'
G[26257]='FA K0130 L010 A:233 T:233 P:26252'
G[26258]='K0820 L081 A:43065 T:0,43065 P:26255'
G[26259]='K0820 L081 A:43397 T:43397 P:26255'
G[26260]='K0820 L081 A:-640,43065 T:1205134 P:26261'
G[26261]='K0820 L081 A:-640,43065 T:0,43065 P:26256'
G[26262]='E21655'
G[26263]='FH K0320 L030 A:42613 T:42613'
G[26264]='FA K0020 L002 RN A:42611 T:42611 P:26222'
G[26265]='FA K0020 L002 RN A:42630 T:42630 P:26222'	-- for some reason I commented that P:26222 was wrong, but I just checked and it was not available until I turned 26222 in.
G[26266]='FA K0130 L011 A:235 T:42575 P:26270'
G[26267]='FH K0320 L030 A:42613 T:42613 P:26238+26263'	-- TODO: Verify requires 26238
G[26268]='FH K0320 L030 A:42613 T:42613 P:26238+26263'	-- TODO: Verify requires 26238
G[26269]='K0250 L024 A:716 T:716 P:583'
G[26270]='FA K0130 L010 A:233 T:235 P:26237+26241'
G[26271]='FA K0130 L011 A:42575 T:42575 P:26266'
G[26272]='FH K0020 L001 CL A:37951 T:42618'
G[26273]='K0020 L001 CL A:42618 T:42618 P:26272'
G[26274]='K0030 L001 CL A:42618 T:42618 P:26276'
G[26275]='FH K0030 L001 CL A:42618 T:42618 P:26273'
G[26276]='K0030 L001 CL A:42618 T:42618 P:26275'
G[26277]='FH K0030 L001 CL A:42618 T:38966 P:26274'
G[26278]='FH K0250 L024 A:2464 T:2464 O:26417,28688 OCC:28855'
G[26279]='FH K0250 L024 A:2464 T:2464 P:26278'
G[26280]='FH K0250 L024 A:2464 T:2464 P:26278'
G[26281]='FH K0250 L024 A:2464 T:2464 P:26280'
G[26282]='K0330 L031 E21655'
G[26283]='FH K0320 L030 A:42612 T:42612 P:26238+26263'	-- TODO: Verify requires 26238
G[26284]='K0030 L002 RN A:42708 T:42708 P:26316'
G[26285]='FA K0030 L002 RN A:42708 T:42708 P:26316'
G[26286]='FA K0130 L011 A:234 T:234 P:26266'
G[26287]='FA K0130 L011 A:821 T:821 P:26266'
G[26288]='FA K0140 L011 A:821 T:821 P:26287'
G[26289]='FA K0140 L011 A:234 T:7024 P:26286+26271'
G[26290]='FA K0140 L011 A:7024 T:7024 P:26289'
G[26291]='FA K0140 L011 A:7024 T:234 P:26290'
G[26292]='FA K0140 L012 A:234 T:42425 P:26291'
G[26293]='FH K0840 L084 A:39605 T:42672 P:28717'
G[26294]='FH K0840 L084 A:42672 T:39605 P:26293'
G[26295]='FA K0140 L012 A:42425 T:42425 P:26292'
G[26296]='FA K0140 L012 A:100058117 T:42425 P:26292'
G[26297]='FA K0150 L012 A:42425 T:42425 P:26295'
G[26298]='FH K0260 L024 A:2497 T:2497 P:26280'
G[26299]='FH K0260 L024 A:2497 T:2497 P:26298'
G[26300]='FH K0270 L024 A:2497 T:1002076 P:26299'
G[26301]='FH K0270 L024 A:1002076 T:1002076 P:26300'
G[26302]='FH K0270 L024 A:1002076 T:2519 P:26301'
G[26303]='FH K0280 L024 A:2519 T:2519 P:26302 I:26781'
G[26304]='FH K0290 L027 A:42813 T:42813 P:26359 I:26780'
G[26305]='FH K0290 L024 A:2519 T:2497 P:26303'
G[26306]='FH K0330 L031 A:42642 T:42642 P:26432,26496'
G[26307]='FH K0330 L031 A:42642 T:42642 P:26306+26366'	-- TODO: Verify requires 26366
G[26308]='FH K0330 L031 A:42642 T:42642 P:26307'
G[26309]='FH K0330 L031 A:42622 T:42622 P:26310'
G[26310]='FH K0330 L031 A:42622 T:42622'
G[26311]='FH K0840 L084 A:42637 T:42637 O:28909'
G[26312]='K0830 L081 A:42730 T:42730 P:26326'
G[26313]='K0830 L081 A:42731 T:42731 P:26326'
G[26314]='K0830 L081 A:42730 T:42730 P:26326'
G[26315]='K0830 L081 A:42731 T:42731 P:26312+26313+26314'
G[26316]='FA K0030 L002 RN A:42489 T:42708 P:26205'
G[26317]='FH K0250 L024 AP:-37:X26738;2465:26738 T:2465 P:28855'
G[26318]='FA K0030 L002 RN A:42708 T:42708 P:26284+26285'
G[26319]='FA K0150 L012 A:42425 T:42651 P:26297'
G[26320]='FA K0150 L012 A:42651 T:234 P:26319'
G[26321]='FH K0250 L024 A:2465 T:2465 P:26317 I:26739'
G[26322]='FA K0150 L012 A:234 T:29611 P:26320'
G[26323]='FH K0260 L024 A:42736 T:2497 P:26321'	-- there is most likely another requirement.  either of the two quests turned in after 26321 was done, or the presence of any of the three quests available once 26280 was completed
G[26324]='FH K0840 L084 A:39605 T:42641 P:26311'
G[26325]='FH K0260 L024 A:1002076 T:1002076 P:26323'
G[26326]='K0830 L081 A:43065 T:42730 P:27938+26876'
G[26327]='FA K0250 L023 A:1071 T:42160'
G[26328]='K0830 L081 A:42731 T:42467 P:26315'
G[26329]='FA K0030 L002 RN A:42708 T:42317 P:26318'
G[26330]='FH K0260 L024 A:1002076 T:1002076 P:26325'
G[26331]='FA K0040 L002 RN A:42317 T:42317 P:26329'
G[26332]='FH K0260 L024 A:1002076 T:1002076 P:26330'
G[26333]='K0040 L003 RN A:42224 AA:42491 T:42491 P:26329'
G[26334]='FH K0260 L024 A:542790 T:542790 P:26332'
G[26335]='FH K0840 L084 A:42641 T:1204050 P:26324'
G[26336]='FA K0280 L026 A:2789 T:2610'
G[26337]='FH K0840 L084 A:1204050 T:42641 P:26335'
G[26338]='FH K0270 L025 A:2465 T:2465 P:26325'
G[26339]='FA K0050 L002 RN A:42366 T:42353 P:26331+26333'
G[26340]='FH K0250 L024 A:17094 T:716 P:9457'
G[26341]='FA K0290 L027 A:2789 T:1138492'
G[26342]='FA K0050 L002 RN A:42353 T:42353 P:26339'
G[26343]='K0260 L025 A:2495 T:2495'
G[26344]='K0270 L025 A:2495 T:2495 P:26343'
G[26345]='K0280 L025 A:2495 T:2495 P:26344'
G[26346]='FA K0270 L025 A:1002702 T:2789 P:26042'	-- TODO: Determine how to conceptually put in P:26042 because the Rumbling Exile that spawns when it is turned in needs to die, allowing this quest to become available.
G[26347]='FA K0140 L012 A:392 T:392'
G[26348]='FA K0150 L012 A:392 T:392 O:26371'
G[26349]='FA K0150 L012 A:392 T:392'
G[26350]='FH K0270 L024 A:2497 T:42812 P:26334 I:26749'
G[26351]='FH K0270 L024 A:42812 T:42812 P:26350 I:26772'
G[26352]='FH K0280 L026 A:42813 T:42813 P:26399,26412'
G[26353]='K0130 L009 A:100001357 T:1000035'
G[26354]='K0130 L009 A:1000035 T:1000036 P:26353'
G[26355]='K0130 L009 A:1000036 T:1000034 P:26354'
G[26356]='K0130 L009 A:1000034 T:1000033 P:26355'
G[26357]='FH K0330 L031 A:42624 T:42624'
G[26358]='FH K0840 L084 A:42640 T:42643 P:26324'
G[26359]='FH K0270 L024 A:42812 T:42812 P:26351 I:26773'
G[26360]='FH K0290 L024 A:42812 T:42812 P:26359 I:26774'
G[26361]='FH K0840 L084 A:42643 T:42643 P:26358'
G[26362]='FH K0290 L024 A:42812 T:42812 P:26360 I:26775'
G[26363]='FH K0330 L031 A:42642 T:42642 P:26308+26367'	-- TODO: Verify requires 26308 (note that in testing ensure 26368 not turned in, because in this case it was)
G[26364]='K0050 L002 RN A:42353 T:42353 P:26342'
G[26365]='FA K0150 L014 M018 A:821,29611 T:464 I:28563'
G[26366]='FH K0330 L031 A:42642 T:42642'
G[26367]='FH K0330 L031 A:42642 T:42642 P:26307'
G[26368]='FH K0330 L031 A:42622 T:42622 P:26309'
G[26369]='FH K0330 L031 A:42642 T:42642 P:26363'
G[26370]='FA K0150 L012 A:29611 T:234 P:26322'
G[26371]='FA K0150 L012 A:878 T:392'
G[26372]='FH K0840 L084 A:42643 T:42640 P:26361'
G[26373]='FA K0050 L002 RN A:42353 T:40950 P:26364'
G[26374]='FH K0840 L084 A:42641 T:42641 P:26324'
G[26375]='K0830 L081 A:42899 T:42899 P:26328'
G[26376]='K0830 L081 A:42467 T:42467 P:26328'
G[26377]='K0830 L081 A:42467 T:42467 P:26328'
G[26378]='FA K0100 L009 M015 A:240,261,294,963,42256 T:42308 I:28562'
G[26379]='K0150 L014 E21655'
G[26380]='FA K0050 L002 A:42933 T:1247'
G[26381]='FH K0340 L032 A:42898 T:42898'
G[26382]='FH K0340 L032 A:42896 T:42896'
G[26383]='FA K0100 L008 A:42936 T:32973 I:26385,28490'
G[26384]='FH K0340 L031 A:42622 T:42898 P:26369'
G[26385]='FA K0100 L008 RW A:48736 T:32973 P:28517 I:26383,28490'
G[26386]='FH K0290 L024 A:42812 T:42811 P:26362 I:26776'
G[26387]='FH K0340 L032 A:42896 T:42896 P:26382'
G[26388]='FH K0840 L084 A:50367 T:42978 P:28849'
G[26389]='FA K0040 L002 A:197 T:197 P:28817,28818,28819,28820,28821,28822,28823,29083,31145'
G[26390]='K0050 L002 A:197 T:197 P:26389'
G[26391]='FA K0040 L002 A:9296 T:9296 P:28817,28818,28819,28820,28821,28822,28823,29083,31145'
G[26393]='FA K0070 L005 RH A:514 T:42983'
G[26394]='FA K0070 L005 A:42983,43000 T:1323 P:26393'
G[26395]='FA K0070 L005 A:1323 T:352 P:26394'
G[26396]='FA K0070 L005 A:352 T:514 P:26395'
G[26397]='FH K0120 L010 RT A:36648 T:39605 P:24540'	-- also marks 26398 complete (which is another version it seems)
G[26399]='FH K0280 L026 A:42814 T:42814 I:26412,26782,26783'
G[26400]='FH K0280 L026 A:42814 T:42814 P:26399,26412'
G[26401]='FA K0370 L035 A:1203134 T:40132 P:25368'
G[26402]='FA K0360 L034 A:40032 T:3936 P:25398'
G[26403]='FH K0280 L026 A:42814 T:42814 P:26399,26412 I:26763'
G[26404]='FH K0300 L029 A:42814 T:43095'
G[26405]='FH K0290 L027 A:42811 T:42811 P:26359 I:26779'
G[26406]='FH K0340 L032 A:42898 T:42898 P:26381'
G[26407]='FH K0250 L024 A:100058491 T:2465'
G[26408]='FA K0200 L017 A:34402 T:33187 P:13897 I:28492'
G[26409]='K0820 L081 A:42573 T:42574'
G[26410]='K0820 L081 A:42574 T:42574 P:26409'
G[26411]='K0820 L081 A:42574 T:42574 P:26410,27135'
G[26412]='FH K0280 L026 I:26399,26782,26783'	--  A:42814 T:42814 just a copy of 26399 because no idea what is live
G[26413]='K0820 L081 A:42574 T:42573 P:26411'
G[26414]='FA K0002 L010 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26420,26442,26488,26536'
G[26415]='E21655'
G[26416]='FH K0250 L024 A:43063 T:43062'
G[26417]='FH K0250 L024 A:43062 T:2464 P:26416 I:28688'
G[26418]='FH K0350 L032 A:42898 T:42898 P:26406'
G[26419]='FH K0350 L032 A:43299 T:42898 P:26558'
G[26420]='FA K0002 L010 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26442,26488,26536'
G[26421]='FA K0020 L002 RN CM A:42331 T:42317 P:26197 I:26422,26423,26424,26425,31137'
G[26422]='FA K0020 L002 RN CT A:42323 T:42317 P:26199 I:26421,26423,26424,26425,31137'
G[26423]='FA K0020 L002 RN CR A:42366 T:42317 P:26206 I:26421,26422,26424,26425,31137'
G[26424]='FA K0020 L002 RN CL A:460 T:42317 P:26202 I:26421,26422,26423,26425,31137'
G[26425]='FA K0020 L002 RN CW A:42324 T:42317 P:26203 I:26421,26422,26423,26424,31137'
G[26426]='K0830 L081 A:42467 T:0,42467 P:26375+26376+26377'
G[26427]='K0820 L081 A:43082 T:43082 P:26249'
G[26428]='FH K0270 L025 A:4486 T:4486'
G[26429]='FH K0300 L028 A:2771 T:2771'
G[26430]='FH K0310 L029 A:2771 T:42613'
G[26432]='FH K0330 L031 A:42613 T:42642 P:26267,26268,26491,26492'
G[26433]='FH K0300 L026 A:43096 T:43096 I:26590,26817'	-- who gets this?
G[26434]='FH K0300 L026 A:43096 T:43096 P:26433,26590 I:26818'
G[26435]='FH K0320 L026 A:43096 T:43849 P:26434,26592 I:26821'
G[26436]='K0830 L081 A:42467 T:42469 P:26871'
G[26437]='FA K0830 L081 A:42469 T:42469 P:26436'
G[26438]='FA K0830 L081 A:42469 T:42469 P:26436'
G[26439]='K0830 L081 A:43344 T:43344 P:26436'
G[26440]='K0830 L081 A:43116 T:43116 P:26439 O:28869'
G[26441]='FA K0830 L081 A:43116 T:42469 P:26440'
G[26442]='FA K0002 L010 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26488,26536'
G[26443]='FA K0210 L019 A:100023777 T:17303 P:B13766'	-- TODO: Verify that P:C13766 is not in fact the proper prerequisite.  Basically, turn in 13766 and see if the plans still drop
G[26444]='FA K0210 L019 A:17303 T:17303'
G[26445]='FA K0220 L019 A:17303 T:17303 P:26443'
G[26446]='FA K0210 L019 A:17310 T:17310'
G[26447]='FH K0210 L019 A:100023797 T:17355'
G[26448]='FH K0210 L019 A:17355 T:17355'
G[26449]='FH K0220 L019 A:17355 T:17355 P:26447'	-- was rumored to be gone, but may be back: http://us.battle.net/wow/en/forum/topic/6490460407
G[26450]='FH K0300 L029 A:43095 T:43095 O:26404 I:26820'
G[26451]='K0000 L030 A:43099 T:43099'
G[26452]='K000258 L030 A:43099 T:43099 P:26451'
G[26453]='FA K0210 L019 A:17106 T:17291'
G[26454]='FA K0210 L019 A:17291 T:17310 O:26453'
G[26455]='FA K0210 L019 A:3848 T:3848'
G[26456]='FA K0250 L021 A:3880 T:14733 P:13935'
G[26457]='FA K0210 L019 A:17287 T:17287'
G[26459]='E21655'
G[26462]='FA K0320 L029 A:43108 T:43108'
G[26463]='FA K0210 L019 A:3847 T:3891 P:13623'
G[26464]='FA K0210 L019 A:3891 T:3847 P:26463'
G[26465]='FA K0210 L019 A:3846 T:3846 O:13617'
G[26466]='FA K0220 L019 A:3846 T:3846 P:26465'
G[26467]='FA K0210 L019 A:3901 T:3920'
G[26468]='FA K0220 L019 A:3920 T:3901 P:26467'
G[26469]='FA K0210 L019 A:3901 T:3901 P:26468'
G[26470]='FA K0260 L023 A:3885 T:3885 O:13964'
G[26472]='FA K0220 L019 A:33777 T:33777 P:13792'
G[26473]='FA K0210 L019 A:33204 T:33204'
G[26474]='FA K0230 L019 A:3847 T:3894 P:13642'
G[26475]='FA K0230 L019 A:3894 T:3894 P:26474'	-- after about 10 seconds
G[26476]='FA K0230 L021 A:3691 T:3916 P:26475'
G[26477]='FA K0230 L021 A:3916 T:3916 P:26476'
G[26478]='FA K0230 L021 A:3916 T:3916 P:26477'
G[26479]='FA K0230 L019 A:3916 T:3691 P:26478'
G[26480]='FA K0250 L019 A:3691 T:3897 P:26479'
G[26481]='K0260 L019 A:3897 T:3897 P:13989'
G[26482]='FA K0250 L019 A:3897 T:3691 P:26481'
G[26483]='FA K0320 L029 A:43108 T:43108'
G[26484]='K0820 L081 A:42573 T:43071 P:26413'
G[26485]='FA K0310 L029 A:43109 T:43109'
G[26486]='FA K0310 L029 A:43109 T:43109'
G[26487]='FH K0300 L029 A:43095 T:43095 I:26819'	-- TODO: It seems 26489 was also marked complete, by a Blood Elf Paladin when turning this in!
G[26488]='FA K0002 L010 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26536'
G[26489]='FH K0300 L029 RG A:43095 T:43095'
G[26490]='FA K0320 L029 A:43109 T:43109 P:26462+26483'
G[26491]='FA K0320 L029 A:43108 T:43108 P:26462+26483'
G[26492]='FA K0320 L029 A:43108 T:43108 P:26462+26483'
G[26493]='FH K0300 L029 A:43095 T:43095 P:26450+26487 I:26822'	-- it seems 26487 required so verify 26450 is required
G[26494]='FH K0310 L029 A:43095 T:43097 P:26493'
G[26495]='FH K0310 L029 A:43095 T:43098 P:26493 I:26808'
G[26496]='FA K0330 L029 A:43108 T:43157 P:26491+26492'
G[26497]='FA K0330 L030 A:43157 T:43157 O:26496'
G[26498]='FA K0330 L030 A:43157 T:43157 P:26497'
G[26499]='K0820 L081 A:43071 T:43071 P:27935,27936'
G[26500]='K0820 L081 A:43160 T:43160 P:27935,27936'
G[26501]='K0820 L081 A:43071 T:43168 P:26499'
G[26502]='K0820 L081 A:43160 T:43169 P:26500'
G[26503]='FA K0150 L014 A:464 T:464 O:26365,28563'
G[26504]='FA K0150 L014 A:1204344 T:464'
G[26505]='FA K0160 L014 A:464 T:344 P:26503'
G[26506]='FA K0160 L014 A:379 T:379'
G[26507]='FA K0830 L081 A:42469 T:43116 P:26441'
G[26508]='FA K0160 L014 A:8965 T:8962'
G[26509]='FA K0160 L014 A:342 T:342'
G[26510]='FA K0160 L014 A:344 T:344'
G[26511]='FA K0160 L014 A:900 T:900'
G[26512]='FA K0160 L014 A:344 T:-100036,344 P:26510'
G[26513]='FA K0160 L014 A:382 T:382 P:26510'
G[26514]='FA K0160 L014 A:-36,344 T:-36,344 P:26512'
G[26515]='FA K0330 L030 A:43157 T:43157 P:26518'
G[26516]='FA K0330 L030 A:43157 T:43157 P:26498'
G[26517]='FA K0330 L030 A:43156 T:43156 P:26515+26524'
G[26518]='FA K0330 L030 A:43157 T:43157'
G[26519]='FA K0160 L014 A:100058898 T:1204351 P:26512'	-- There is a P: because hunting tons beforehand dropped none, while afterwards item drops tons of times.  Assumption is this P:, but it could be another.
G[26520]='FA K0160 L014 A:1204351 T:344 P:26519'
G[26521]='FA K0330 L030 A:43156 T:43156'
G[26522]='E21655'
G[26523]='FA K0330 L030 A:43156 T:43156'
G[26524]='FA K0330 L030 A:43156 T:43156 P:26521'
G[26525]='FA K0330 L030 A:43156 T:43156 P:26517'
G[26526]='FA K0330 L030 A:43156 T:43156 P:26517'
G[26528]='FA K0340 L032 A:43200 T:43200 P:27625+27626'
G[26529]='FA K0340 L032 A:43200 T:43200 P:26528'
G[26530]='FA K0350 L032 A:43200 T:43200 P:26529'
G[26531]='FA K0350 L032 A:43200 T:43298 P:26530'
G[26532]='FA K0350 L032 A:43298 T:5636 P:26531'
G[26533]='FH K0310 L029 A:43097 T:43097 P:26494 I:26815'
G[26534]='FH K0310 L029 A:43097 T:43097 P:26533'
G[26535]='FH K0320 L029 A:43097 T:43097 P:26534 I:26816'
G[26536]='FA K0002 L010 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488'
G[26537]='K0820 L081 A:43168 T:43168 P:26501'
G[26538]='FH K0840 L084 A:43193 T:43191 P:26388'
G[26539]='FH K0840 L084 A:42978 T:43187 P:26388'
G[26540]='FH K0840 L084 A:43191 T:43193 P:26538'
G[26542]='FA K0300 L029 M033 A:2700,1207320 T:5636'
G[26543]='FH K0002 L010 A:43239 T:43239 P:PF001 I:26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26544]='FA K0160 L014 A:-36,344 T:-36,344 P:26514'
G[26545]='K0160 L014 A:-36,344 T:344 P:26544'
G[26546]='FA K0310 L029 A:5636 T:5636'
G[26547]='FA K0310 L029 A:5636 T:5636'
G[26548]='FA K0310 L029 A:5636 T:43108 P:26546+26547'
G[26549]='FH K0840 L084 A:43187 T:43190 P:26539'
G[26550]='FH K0310 L029 A:43098 T:43098 P:26495 I:26809'
G[26551]='FH K0320 L029 A:43098 T:0 P:26550 I:26810'
G[26552]='FH K0320 L029 A:-673 T:0 P:26551 I:26811'
G[26553]='K0320 L029 A:-100037 T:-37 P:26552 I:26812'
G[26554]='K0320 L029 A:-37 T:-37 P:26553 I:26813'
G[26555]='FH K0320 L029 A:-37 T:43098 P:26554 I:26814'
G[26556]='FH K0002 L010 A:43239 T:43239 P:PF001 I:26543,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26557]='FH K0002 L010 A:43239 T:43239 P:PF001 I:26543,26556,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26558]='FH K0350 L032 A:42898 T:43299 P:26418'
G[26559]='E21655'
G[26560]='FA K0170 L015 A:43300 T:43272 P:26587'
G[26561]='FA K0170 L015 A:43305 T:43274 P:26560'
G[26562]='FA K0170 L015 A:43303 T:43275 P:26561'
G[26563]='FA K0170 L015 A:43302 T:43221 P:26562'
G[26564]='K0820 L081 A:43169 T:43169 P:26502'
G[26566]='FA K0020 L002 RN A:42317 T:42553 P:26208'
G[26567]='FA K0170 L015 A:43221 T:43184 P:26545'
G[26568]='FA K0170 L015 A:43184 T:43221 P:26567'
G[26569]='FA K0170 L015 A:43194 T:43194 P:26520+26568'
G[26570]='FA K0170 L015 A:500382 T:500382 P:26568'
G[26571]='FA K0170 L015 A:43221 T:-36,43221 P:26568'
G[26572]='FH K0002 L010 A:43239 T:43239 P:PF001 I:26543,26556,26557,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26573]='FA K0170 L015 A:-36,43221 T:43221 P:26571'
G[26574]='FA K0380 L036 A:39653 T:39725'
G[26575]='FA K0830 L081 A:42469 T:42469 P:26441'
G[26576]='FA K0830 L081 A:42469 T:42466 P:26575+26507'
G[26577]='FA K0830 L081 A:42469 T:42472 P:26575+26507'
G[26578]='K0830 L081 A:42472 T:42472 P:26577'
G[26579]='K0830 L081 A:42472 T:42472 P:26577'
G[26580]='K0830 L081 A:42472 T:43395 P:26577'
G[26581]='K0830 L081 A:43395 T:43395 P:26580'
G[26582]='K0830 L081 A:43395 T:42472 P:26581'
G[26583]='K0830 L081 A:43442 T:43442 P:26582'
G[26584]='K0830 L081 A:42472 T:42472 P:26582'
G[26585]='K0830 L081 A:42472 T:42472 P:26582'
G[26586]='FA K0170 L015 A:43221 T:43270 P:26568'
G[26587]='FA K0170 L015 A:43270 T:43270 P:26586'
G[26588]='FH K0002 L010 A:43239 T:43239 P:PF001 I:26543,26556,26557,26572,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26589]='FH K0350 L031 A:36487 T:39377 P:14346+14394'
G[26590]='FH K0300 L026 A:43096 T:43096 I:26433,26817'	-- Belf Pally got this
G[26591]='K0820 L081 A:43319 T:43319 P:26502+26501'
G[26592]='FH K0300 L026 A:43096 T:43096 P:26433,26590'
G[26593]='K0320 L030 A:2501 T:2502'
G[26594]='K0320 L030 A:2502 T:2501 P:26593'
G[26595]='K0320 L030 A:2501 T:2501 P:26594'
G[26596]='FA K0350 L034 A:48808 T:3391'
G[26597]='K0330 L031 A:2486 T:2486'
G[26598]='SP K0331 L031 A:1449 T:1449 P:B26597'
G[26599]='K0330 L031 A:2500 T:2500'
G[26600]='K0330 L031 A:2500 T:2500 P:26599'
G[26601]='K0330 L031 A:2500 T:2500 P:26602'
G[26602]='K0330 L031 A:2500 T:2500 P:26600'
G[26603]='K0320 L030 A:1204406 T:2634'
G[26604]='K0320 L030 A:2634 T:2634 P:26603'
G[26605]='K0320 L030 A:2634 T:2634 P:26604'
G[26606]='K0330 L030 A:2634 T:2634 P:26605'
G[26607]='FA K0180 L016 A:43221 T:43184 P:26563+26573'
G[26608]='FH K0840 L084 A:43190 T:42978 P:26549'
G[26609]='K0320 L031 A:2490 T:1002083 P:26595,26601,26606'
G[26610]='K0320 L031 A:1002083 T:2490 P:26609'
G[26611]='K0320 L031 A:2490 T:2496 P:26610'
G[26612]='K0330 L031 A:2496 T:2496 P:26611'
G[26613]='K0330 L031 A:2488 T:2488 P:26611'
G[26614]='K0330 L031 A:2493 T:2493 P:26611'
G[26616]='FA K0180 L016 A:43184 T:43458 P:26607'
G[26617]='K0320 L030 A:100059143 T:2487'
G[26618]='FA K0210 L019 A:264 T:264 O:26728,28564'
G[26619]='FH K0840 L084 A:43193 T:43581 P:26540+26608'
G[26620]='FA K0210 L018 A:272 T:272'
G[26621]='FH K0840 L084 A:43581 T:43581 P:26619'
G[26622]='FH K0840 L084 A:43581 T:43943 P:26621'
G[26623]='FA K0210 L018 A:272 T:272'
G[26624]='K0330 L031 A:2496 T:43504 P:26612'
G[26625]='K0830 L081 A:43168 T:43168 P:26537+26564+26591'
G[26627]='FA K0210 L019 A:264 T:289 P:26618'
G[26628]='K0280 L026 A:2610 T:2610 P:26052'
G[26629]='K0330 L031 A:43504 T:43504 P:26624'
G[26630]='K0330 L031 A:2487 T:2487 P:B26629'
G[26631]='K0330 L031 A:43504 T:2548 P:26629'
G[26632]='K0830 L081 A:45043 T:43897 P:27126'
G[26633]='K0330 L031 A:2548 T:2548 P:26631'
G[26634]='K0330 L031 A:2549 T:2549 P:26631'
G[26635]='K0330 L031 A:2545 T:2545 P:26631'
G[26636]='FA K0180 L016 A:43461 T:43461 P:26616'
G[26637]='FA K0180 L016 A:43459 T:43459 P:26616'
G[26638]='FA K0180 L016 A:43462 T:43462 P:26616'
G[26639]='FA K0180 L016 A:43458 T:43508 P:26616'
G[26640]='FA K0180 L016 A:43508 T:43458 P:26639'
G[26641]='FA K0340 L032 A:43200 T:43200 P:27625+27626'
G[26642]='FH K0120 L009 A:35068 T:3337 I:28494'	-- Z16826
G[26643]='FA K0340 L032 A:43200 T:43200 P:26641'
G[26644]='K0340 L031 A:2548 T:2546 P:26633+26634+26635'
G[26645]='FA K0210 L019 A:264 T:264 P:26618'
G[26646]='FA K0180 L016 A:43458 T:-36,43458 P:26636+26637+26638+26640'
G[26647]='K0340 L031 A:2547 T:2547 P:26644'
G[26648]='K0340 L031 A:43556 T:-673 P:26644'
G[26649]='K0340 L031 A:2547 T:2547 P:26647'
G[26650]='K0350 L031 A:2546 T:1204450 P:26648'
G[26651]='K0180 L016 A:-36,43458 T:43611 P:26646'
G[26652]='FA K0210 L019 A:265 T:302 P:26653'
G[26653]='FA K0210 L019 A:289 T:265 O:26627'
G[26654]='FA K0210 L019 A:302 T:265 P:26652'
G[26655]='FA K0210 L019 A:265 T:289 P:26654'
G[26656]='K0830 L081 A:42466 T:42466 P:26576'
G[26657]='K0830 L081 A:42466 T:42466 P:26656'
G[26658]='K0830 L081 A:42466 T:42466 P:26656'
G[26659]='K0830 L081 A:42466 T:542466 P:26657+26658'
G[26660]='FA K0210 L019 A:289 T:273 P:26655'
G[26661]='FA K0220 L019 A:273 T:273 P:26660'
G[26662]='K0350 L031 A:1204450 T:-673,1204450 P:26650'
G[26663]='K0350 L031 A:1204450 T:-673,1204450 P:26650'
G[26664]='K0350 L031 A:1204450 T:-673,1204450 P:26650'
G[26665]='K0350 L031 A:-673,1204450 T:2496 P:26662+26663+26664'
G[26666]='FA K0230 L021 A:43453 T:267'
G[26667]='FA K0230 L021 A:267 T:267 P:26666'
G[26668]='FA K0180 L016 A:43611 T:43611 P:26651'
G[26669]='FA K0230 L021 A:267 T:267 P:26667'
G[26670]='FA K0230 L021 A:267 T:267 P:26669'
G[26671]='FA K0230 L021 A:267 T:43453 P:26670'
G[26672]='FA K0230 L021 A:43453 T:265 P:26671'
G[26673]='K0230 L021'	-- this has a tooltip that shows that it does the same as 26672, but what triggers its completion?
G[26674]='FA K0230 L021 A:265 T:43453 P:26672'
G[26675]='K0120 L009 E21655'
G[26676]='FA K0220 L019 A:273 T:289 P:26661'
G[26677]='FA K0220 L019 A:289 T:289 P:26680'
G[26678]='K0350 L031 A:2496 T:1204578 P:26665'
G[26679]='K0350 L031 A:1204578 T:2496 P:26678'
G[26680]='FA K0220 L019 A:289 T:289 P:26676'
G[26681]='FA K0220 L019 A:289 T:263 P:26677'
G[26682]='FH K0360 L034 A:4926 T:4926'	-- P:26701 not correct
G[26683]='FA K0210 L019 A:276 T:302 P:26618'
G[26684]='FA K0210 L019 A:302 T:276 P:26683'
G[26685]='FA K0220 L019 A:276 T:276 P:26684'
G[26686]='FA K0210 L018 A:264 T:264 P:26645'
G[26687]='FA K0350 L032 A:39118 T:4944 P:25182'
G[26688]='FA K0230 L021 A:663 T:663'
G[26689]='FA K0230 L021 A:663 T:663 P:26688'
G[26690]='FA K0230 L021 A:663 T:663 P:26689'
G[26691]='FA K0240 L021 A:663 T:661 P:26690'
G[26692]='FA K0190 L017 A:43607 T:-36,43607 P:26668'
G[26693]='FA K0190 L017 A:43611 T:-36,43611 P:26668'
G[26694]='K0190 L017 A:-36,43611 T:43611 P:26693'
G[26695]='K0350 L031 A:2496 T:2496 P:26679'
G[26696]='FH K0350 L034 A:48797 T:3391'
G[26697]='K0350 L031 A:2496 T:2496 P:26695'
G[26698]='K0350 L031 A:2496 T:502487 P:26679'
G[26699]='K0350 L031 A:502487 T:2496 P:26698'
G[26700]='K0350 L031 A:502487 T:2496 P:26698'
G[26701]='FH K0350 L034 A:3391 T:4926 P:26696'	-- report of this not being available after completing 26696 (could it be related to 26682)
G[26702]='FA K0350 L034 A:3391 T:23566 P:26596 I:28552'
G[26703]='K0350 L031 A:2496 T:2496 P:26697+26699+26700'
G[26705]='FH K0000 L000 RG T:36470'
G[26706]='FA K0120 L012 RW A:43727 T:43727 P:24681'
G[26707]='FA K0240 L022 A:43738 T:43738'
G[26708]='FA K0200 L017 A:43733 T:543733 P:26694'
G[26709]='K0830 L081 A:43792 T:42465 P:26971'
G[26710]='K0832 L081 A:44945 T:44945 P:26709 I:27048,28488'
G[26711]='FH K0030 L001 RG GF A:35054 T:35120,535120 P:14071'	-- this also sets 26712
G[26712]='FH K0030 L001 RG GM A:35053 T:35120,535120 P:14071'	-- this also sets 26711
G[26713]='FA K0200 L017 A:543733 T:-36,543733 P:26708'
G[26714]='K0200 L017 A:-36,543733 T:543733 P:26713'
G[26715]='E21655'
G[26717]='FA K0240 L022 A:43738 T:43738 O:26785'
G[26719]='FA K0240 L022 A:43738 T:43730 P:26717'
G[26720]='FA K0240 L022 A:43730 T:43730 P:26719'
G[26721]='FA K0240 L022 A:288 T:288'
G[26722]='FA K0250 L022 A:1204824 T:1204825 P:26753'
G[26723]='FA K0240 L022 A:43861 T:43861 P:D26760'
G[26724]='FA K0250 L022 A:43861 T:43731 P:26723'
G[26725]='FA K0250 L022 A:43731 T:1204817 P:26724'
G[26726]='FA K0200 L017 A:543733 T:344 P:26714'
G[26727]='FA K0220 L019 A:263 T:263 P:26681'
G[26728]='FA K0200 L019 M023 A:900 T:264 I:28564'
G[26729]='FA K0260 L024 A:43885 T:543885 P:26736'	-- not PC code, but P code and required to leave the area before they appear
G[26730]='FA K0260 L024 A:543885 T:543885 P:26729'
G[26731]='FA K0260 L024 A:543885 T:543885 P:26730'
G[26732]='FA K0250 L024 A:739 T:739 OCC:28855'
G[26733]='FA K0250 L024 A:739 T:739 P:26732'
G[26734]='FA K0250 L024 A:739 T:739 P:26733'
G[26735]='FA K0250 L024 A:469 T:469 O:26838,28699'
G[26736]='FA K0250 L024 A:469 T:469 P:26735'
G[26737]='FA K0250 L024 A:469 T:469 P:26736'
G[26738]='FA K0250 L024 AP:-37:X26317;1422:26317 T:1422 P:28855'
G[26739]='FA K0250 L024 A:1422 T:1422 P:26738 I:26321'
G[26740]='FA K0280 L026 A:770 T:773'
G[26742]='FA K0260 L024 A:43886 T:43886 P:26736'
G[26743]='FA K0260 L024 A:43886 T:43886 P:26742'
G[26744]='FA K0260 L024 A:1422 T:1422 P:26739'
G[26745]='FA K0260 L024 A:42736 T:43884 P:26736+26739'
G[26746]='FA K0260 L024 A:43884 T:43884 P:26745'
G[26747]='FA K0260 L024 A:43884 T:43884 P:26746'
G[26748]='FA K0260 L024 A:42790 T:42790 P:26747'
G[26749]='FA K0270 L024 A:43884 T:44017 P:26748 I:26350'
G[26750]='K0830 L081 A:42472 T:42465 P:26584+26585+26659'
G[26751]='FA K0270 L025 A:733 T:733 P:26746'
G[26752]='K0830 L081 A:42465 T:43809 P:26750'
G[26753]='FA K0250 L022 A:1204817 T:1204824 P:26725'
G[26754]='FA K0250 L022 A:1204825 T:43861 P:26722'
G[26755]='K0830 L081 A:43897 T:43897 P:26632'
G[26760]='FA K0240 L021 A:43730 T:43730 P:26720'
G[26761]='FA K0150 L012 A:234 T:344 P:26370'
G[26762]='K0830 L081 A:43897 T:43897 P:26755'
G[26763]='FA K0280 L026 A:773 T:773 P:26740 I:26403'
G[26765]='FA K0280 L026 A:773 T:770 P:26763'
G[26766]='K0820 L081 A:44010 T:44010 P:27061'
G[26767]='K0830 L081 E21655'
G[26768]='K0820 L081 A:44010 T:44010 P:27061'
G[26769]='FH K0160 L014 A:3391 T:34698 P:14050'
G[26770]='K0830 L081 A:43898 T:43898 P:26755'
G[26771]='K0820 L081 A:44010 T:44010 P:26766+26768'
G[26772]='FA K0270 L024 A:44017 T:44017 P:26749 I:26351'
G[26773]='FA K0270 L024 A:44017 T:44017 P:26772 I:26359'
G[26774]='FA K0290 L024 A:44017 T:44017 P:26773 I:26360'
G[26775]='FA K0290 L024 A:44017 T:44017 P:26774 I:26362'
G[26776]='FA K0290 L024 A:44017 T:44021 P:26775 I:26386'
G[26777]='FA K0240 L022 A:43731 T:43731'
G[26778]='FA K0240 L022 A:43731 T:43731 P:26760'
G[26779]='FA K0290 L027 A:44021 T:44021 P:26773 I:26405'
G[26780]='FA K0290 L027 A:44043 T:44043 P:26773 I:26304'
G[26781]='FA K0280 L026 A:44019 T:44019 I:26303'
G[26782]='FA K0280 L026 A:44018 T:44018 I:26399,26412,26783'	-- L85 elf hunter got this one
G[26783]='FA K0280 L026 A:44018 T:44018 I:26399,26412,26782'	-- not sure why this exists with 26782 there...draenei hunter got 26782
G[26784]='FH K0840 L084 A:44024 T:44024 P:26786'
G[26785]='FA K0240 L021 A:43453 T:43738 P:26674'
G[26786]='FH K0840 L084 A:43943 T:44024 P:26622'
G[26787]='FA K0240 L022 A:288 T:288 P:26721'
G[26788]='FH K0840 L084 A:44042 T:44042 P:26622'
G[26789]='E21655'
G[26791]='K0830 L081 A:44143 T:44143 P:26834'
G[26792]='K0830 L081 A:44143 T:44143 P:26834'
G[26793]='FA K0250 L023 A:1000061 T:268'
G[26794]='FA K0250 L023 A:268 T:264 P:26793'
G[26795]='FA K025512 L023 A:264 T:264 P:26794'	-- PM3
G[26796]='FA K0250 L023 A:264 T:576 P:26795'
G[26797]='FA K0250 L023 A:576 T:1000061 P:26796'
G[26798]='FH K0840 L084 A:44024 T:39605 P:26784+26788'
G[26799]='K0010 L001 RU A:1568 T:1568 P:28608'
G[26800]='FH K0020 L001 RU A:1740 T:1740 P:25089'
G[26801]='FH K0030 L001 A:1569 T:1569 O:28653'
G[26802]='FH K0030 L003 A:1570 T:1570 P:28672'
G[26803]='FH K0100 L005 RG A:3144 T:3310'
G[26804]='FH K0100 L005 RG A:3310 T:3139 P:26803'
G[26805]='FA K0300 L029 A:44018 T:44082 I:28702'
G[26806]='FH K0100 L005 RG A:3139 T:41140 P:26804'
G[26807]='FH K0100 L005 RG A:41140 T:3144 P:26806'
G[26808]='FA K0310 L029 A:44083 T:44084 P:26819 I:26495'
G[26809]='FA K0310 L029 A:44084 T:44084 P:26808 I:26550'
G[26810]='FA K0320 L029 A:44084 T:-100673 P:26809 I:26551'
G[26811]='FA K0320 L029 A:-673 T:-100037 P:26810 I:26552'
G[26812]='K0320 L029 A:-100037 T:-37 P:26811 I:26553'
G[26813]='K0320 L029 A:-37 T:-37 P:26812 I:26554'	-- technically turned in after porting which is at 37:82.11,35.37 (for T:)
G[26814]='FA K0320 L029 A:-37 T:44084 P:26813 I:26555'	-- the A: location is really the T: from 26813
G[26815]='FA K0310 L029 A:44099 T:44099 P:26817 I:26533'
G[26816]='FA K0320 L029 A:44099 T:44099 P:26815 I:26535'
G[26817]='FA K0300 L026 A:44099 T:44099 P:26823 I:26433,26590'
G[26818]='FA K0300 L026 A:44083 T:44083 P:26823 I:26434'
G[26819]='FA K0300 L029 A:44083 T:44083 P:26823 I:26487'
G[26820]='FA K0300 L029 A:44083 T:44083 P:26823 I:26450'
G[26821]='FA K0320 L026 A:44082 T:44112 P:26824 I:26435'
G[26822]='FA K0300 L029 A:44100 T:44100 I:26493'
G[26823]='FA K0300 L029 A:44099 T:44099 P:26825,26826'
G[26824]='FA K0320 L029 A:44099 T:44082 P:26815'
G[26825]='FA K0300 L029 A:44082 T:44099 O:28702 I:26826'	-- L85 elf hunter got this one
G[26826]='FA K0300 L029 A:44082 T:44099 I:26825'
G[26827]='K0830 L081 A:43809 T:43065 P:26752'
G[26828]='K0830 L081 A:43065 T:44025 P:26827'
G[26829]='K0830 L081 A:44025 T:44025 P:26828'
G[26830]='FH K0840 L084 A:39605 T:39605 P:26798'
G[26831]='K0830 L081 A:44080 T:44080,42614 P:26828'	-- yes, can be turned into either!
G[26832]='K0830 L081 A:44025 T:44025 P:26828'
G[26833]='K0830 L081 A:44025 T:43818 P:26829+26832+26831'
G[26834]='K0830 L081 A:43897 T:44143 P:26762+26770'
G[26835]='K0830 L081 A:44143 T:43897 P:26791+26792'
G[26836]='K0830 L081 A:43897 T:43897 P:26835'
G[26838]='FA K0250 L024 A:3885,43731 T:469 I:28699'
G[26840]='FH K0840 L084 A:39605 T:44169 P:26830'
G[26841]='FA K0030 L002 RE CM A:2077,502079 T:43006 P:28714+28715'
G[26842]='FA K0120 L010 A:1340 T:1340 O:26176'
G[26843]='FA K0130 L011 A:1343 T:1343 O:13636'
G[26844]='FA K0130 L011 A:1343 T:1343 P:26843'
G[26845]='FA K0130 L011 A:1343 T:1343 P:26844'
G[26846]='FA K0130 L011 A:44200 T:44200 P:26844'
G[26847]='K0830 L081'
G[26848]='K0830 L081'
G[26849]='K0830 L081'
G[26850]='K0830 L081'
G[26851]='K0830 L081'
G[26852]='K0830 L081'
G[26853]='K0830 L081'
G[26854]='FA K0110 L010 A:1960 T:1002059'
G[26855]='FA K0110 L010 A:1002059 T:1960 P:26854'
G[26856]='FH K0150 L013 A:44217 T:44217 P:26865,26866,26867,28003 Z16016'
G[26857]='K0820 L081 A:44010 T:44010 P:26771'
G[26858]='FH K0160 L013 A:44217 T:44217 Z16016'
G[26859]='E21655'
G[26860]='FA K0120 L010 A:1963 T:1963'
G[26861]='K0820 L081 A:44222 T:44222 P:26771'
G[26862]='FH K0150 L013 A:44216 T:44216 Z16016'
G[26863]='FA K0130 L011 A:1343 T:1343 P:26844'
G[26864]='FA K0130 L011 A:1343 T:1340 P:26845'
G[26865]='FH K01564 L015 A:39605 T:44217 I:26866,26867,28003 Z16016'
G[26866]='FH K01564 L015 A:36648 T:44217 I:26865,26867,28003 Z16016'
G[26867]='FH K01564 L015 A:10181 T:44217 I:26865,26866,28003 Z16016'
G[26868]='FA K0150 L012 A:44345 T:44345 P:26928'
G[26869]='K0830 L081 A:-640,42467 T:1204959 P:26426'
G[26870]='K0210 L015 A:5768 T:5768'
G[26871]='K0830 L081 A:1204959 T:42467 P:26869'
G[26872]='K0180 L015 A:5767 T:5767'
G[26873]='K0180 L015 A:5767 T:5767'
G[26875]='K0830 L081 A:43818 T:0,43835 P:26833'
G[26876]='K0830 L081 A:44010 T:43065 P:26857+26861'
G[26877]='K0830 L081'
G[26878]='FH K0160 L015 A:3448 T:5767'
G[26879]='K0160 L015'
G[26880]='E21655'
G[26881]='FA K0250 L020 A:33256 T:4787 Z18545'
G[26882]='FA K0280 L020 A:4787 T:33256 P:26881 Z18545'
G[26883]='FA K0280 L020 A:33260 T:33260 Z18545'
G[26884]='FA K0260 L020 A:33258 T:33258 Z18545'
G[26885]='FA K0250 L020 A:33261 T:33261 Z18545'
G[26886]='FA K0460 L044 A:38704 T:38704 P:25052'
G[26887]='FA K0460 L044 A:38704 T:38704 P:25054'
G[26888]='FH K0270 L020 A:12736 T:12736 Z18545'
G[26889]='FA K0460 L044 A:38704 T:38706 P:25166'
G[26890]='FH K0220 L017 A:34303 T:34303'
G[26891]='FH K0260 L020 A:12736 T:12736 Z18545'
G[26892]='FH K0260 L020 A:44375 T:44375 Z18545'
G[26893]='K0230 L022'
G[26894]='FH K0240 L022 A:34122 T:74408'
G[26895]='FA K0490 L047 A:38578 T:39034'
G[26896]='FH K0490 L047 A:44374 T:39034'
G[26897]='FA K0240 L022 A:3845 T:75606 I:26898'
G[26898]='FA K0240 L022 A:3691 T:75606 I:26897'
G[26899]='FH K0280 L020 A:44387 T:44387 Z18545'
G[26900]='E21655'
G[26901]='K0350 L030 A:44402 T:544402'
G[26902]='K0000 L000 T:38432 J:O24897'
G[26903]='K0350 L030 A:4508 T:504508 Z19033'
G[26904]='FA K0030 L002 RF CL A:43455 T:43455'
G[26905]='K0350 L030 A:44415 T:544415 P:26906'
G[26906]='K0350 L030 A:44402 T:44415'
G[26907]='K0350 L030 A:44402 T:544402'
G[26908]='K0330 L030 A:37812 T:44402'
G[26909]='FH K0290 L027 A:2787 T:1138492'
G[26910]='FA K0030 L002 CH A:197 T:43278 P:28759'
G[26911]='FH K0270 L025 A:1002702 T:2787 P:26042'	-- see comment in quest 26346
G[26912]='FH K028512 L026 A:2787 T:1138492 P:26911'	-- PM2
G[26913]='K0030 L002 CW A:911 T:911 P:3100'
G[26914]='K0030 L002 CL A:459 T:459 P:3105'
G[26915]='FA K0030 L002 CR A:915 T:915 P:3102'
G[26916]='K0030 L002 CM A:198 T:198 P:3104'
G[26917]='FA K0030 L002 CH A:43278 T:43278 P:26910'
G[26918]='FA K0030 L002 CP A:925 T:925 P:3101'
G[26919]='K0030 L002 CT A:375 T:375 P:3103'
G[26920]='FH K0350 L034 A:10837 T:44452 I:28508,28575,28750'
G[26921]='FH K0350 L034 A:44452 T:44452 O:26920,28508,28575,28750'
G[26922]='FH K0350 L034 A:44462 T:44462'
G[26923]='FH K0350 L034 A:44466 T:44466'
G[26924]='FH K0350 L034 A:44452 T:44452 P:26922+26923+26921'
G[26925]='FH K0350 L034 A:44462 T:44452 P:26922'
G[26926]='FH K0350 L034 A:44452 T:10837 P:26924+26925+27117'
G[26927]='FA K0140 L012 A:1340 T:44345 P:26864'
G[26928]='FA K0150 L012 A:44345 T:44345 P:26927'
G[26929]='FA K0150 L012 A:44345 T:44345 P:26927'
G[26930]='FH K0360 L034 A:10837 T:10837 P:26926'
G[26931]='FH K0360 L034 A:11055 T:11055'
G[26932]='FA K0150 L013 A:1340 T:1340 P:26927'
G[26933]='FH K0360 L034 A:11055 T:11055 P:26931'
G[26934]='FH K0360 L034 A:11057 T:11057'
G[26935]='K0370 L034 A:44454 T:11616 P:26999'
G[26936]='FH K0360 L034 A:10837 T:10837 P:26930+26978'
G[26937]='FH K0360 L034 A:44466 T:44466 P:26979'
G[26938]='K0370 L034 A:45098 AH:44466 T:44466 P:26937'
G[26939]='FA K0270 L024 A:44556 T:44560 O:26943,26944'
G[26940]='K0030 L002 RE CM A:43006 T:43006 P:26841'
G[26941]='FA K0280 L024 A:44560 T:44561 P:26939'
G[26942]='FA K0290 L024 A:44561 T:44563 P:26941'
G[26943]='FA K02664 L026 A:2789 T:44556 I:26944'
G[26944]='FA K0260 L026 A:44018 T:44556 I:26943'
G[26945]='K0030 L002 RE CW A:3593 T:3593 P:3116'
G[26946]='K0030 L002 RE CR A:3594 T:3594 P:3118'
G[26947]='K0030 L002 RE CH A:3596 T:3596 P:3117'
G[26948]='K0030 L002 RE CD A:3597 T:3597 P:3120'
G[26949]='K0030 L002 RE CT A:3595 T:3595 P:3119'
G[26950]='FH K0300 L026 A:44637 T:44637 Z15595'
G[26951]='K0100 L004 E21655'
G[26952]='FH K0370 L035 A:10839 T:44454 P:26933 I:27150'
G[26953]='K0370 L035 A:44456 T:44456'
G[26954]='K0370 L035 A:44456 T:44456 P:26953'
G[26955]='K0380 L035 A:44456 T:44456 P:27057'
G[26956]='K0370 L035 A:44457 T:44457'
G[26957]='K0380 L036 A:44905 T:44458'
G[26958]='FA K0030 L002 RD CW A:16503 T:16503 P:9289'
G[26959]='FH K0330 L029 A:44660 T:44660 Z15595'
G[26960]='FA K0840 L084 A:29611 T:29611 O:28716'
G[26961]='FA K0160 L014 A:1345 T:1345'
G[26962]='FH K0360 L032 A:44690 T:44690 Z15595'
G[26963]='FA K0030 L002 RD CH A:16499 T:16499 P:9288'
G[26964]='FH K0100 L009 A:1515 T:44615 I:28568'
G[26965]='FH K0110 L009 A:44615 T:44615 O:26964,28568'
G[26966]='FA K0030 L002 RD CP A:16501 T:16501 P:9287'
G[26967]='FH K0390 L035 A:44706 T:44706 Z15595'
G[26968]='FA K0030 L002 RD CM A:16500 T:16500 P:9290'
G[26969]='FA K0030 L002 RD CS A:17089 T:17089 P:9421'
G[26970]='FA K0030 L002 RD CT A:16502 T:16502 P:9291'
G[26971]='K0830 L081 A:-640,43835 T:43835 P:26875'
G[26972]='FA K0300 L026 A:44728 T:44728 Z15595'
G[26973]='FA K0330 L029 A:44738 T:44738 Z15595'
G[26974]='FA K0360 L032 A:44741 T:44741 Z15595'
G[26975]='FA K0840 L084 A:29611 T:44749 P:26960'
G[26976]='FA K0390 L035 A:44746 T:44746 Z15595'
G[26977]='FA K0840 L084 A:29611 T:2439 P:26960'
G[26978]='FH K0360 L034 A:11057 T:11057 P:26934'
G[26979]='FH K0360 L034 A:10837 T:44466 P:26936+26978'
G[26980]='FA K0230 L021 A:2104 T:41415 P:25801+25819'
G[26981]='FA K0230 L021 A:41415 T:41411 P:25868'
G[26982]='FA K03064 L028 A:2700 T:44728 Z15595'	-- an arbitrary date for removal
G[26983]='FA K0330 L031 A:39084 T:44738 Z15595'
G[26984]='FA K0350 L034 A:44019 T:44741 Z13329'
G[26985]='FA K0380 L037 A:3936 T:44746 Z13329'
G[26986]='FH K0300 L028 A:12920 T:44637 Z15595'
G[26987]='FH K0330 L031 A:14741 T:44660 Z15595'
G[26988]='FH K0350 L034 A:14739 T:44690 Z15595'
G[26989]='FH K0110 L009 A:44615 T:44615 P:26965'
G[26990]='FH K0800 L078 A:42600 T:5769 Z13329'
G[26991]='FH K03864 L037 A:4791 T:44706 Z15595'	-- an arbitrary date for removal
G[26992]='FH K0110 L009 A:44778 T:44778 P:26965'
G[26993]='K0330 L029 A:44800 T:44800 Z13329'
G[26994]='K0360 L032 A:44804 T:44804 Z15595'
G[26995]='FH K0110 L009 A:44784 T:44784 P:26965'
G[26996]='K0390 L035 A:44805 T:44805 Z15595'
G[26997]='FA K0840 L084 A:2439 T:44293 P:26977'
G[26998]='FH K0110 L009 A:44784 T:44784 P:26992+26995'
G[26999]='K0370 L034 A:44454 T:44454 O:26952,27150,27175,27233'
G[27000]='K0370 L034 A:11616 T:11616 O:26935'
G[27001]='K0370 L034 A:11616 T:11616 P:27000'
G[27002]='K0370 L034 A:11616 T:44441 P:27001'
G[27003]='K0830 L083 A:44833 T:46873 P:28295,28296,28557,28558'
G[27004]='FA K0830 L083 A:44799 T:44799 O:27952'
G[27005]='FH K0830 L083 A:44823 T:44823 O:27953'
G[27006]='FA K0830 L083 A:44802 T:44802'
G[27007]='K0820 L081 A:-640,43065 T:0,43065 P:26260'
G[27008]='FH K0830 L083 A:44818 T:44818'
G[27009]='K0460 L040 A:44837 T:44837 Z19033'
G[27010]='K0820 L081 A:-640,43065 T:0,43065 P:27007'
G[27011]='K0370 L035 A:44472 T:44472 P:27013'
G[27012]='K0370 L035 A:44472 T:44472 P:27013'
G[27013]='K0370 L035 A:44472 T:44472'
G[27014]='FH K0030 L002 RT CT A:44927 T:37724'
G[27015]='FH K0030 L002 RT CP A:44927 T:37737'
G[27016]='FA K0160 L014 A:1187 T:1187'
G[27017]='K0380 L036 A:44458 T:44458 P:26957'
G[27018]='E21655'
G[27019]='K0440 L040 A:8516 T:8516 Z19033'
G[27020]='FH K0030 L002 RT CW A:3059 T:3059 P:3091'
G[27021]='FH K0030 L002 RT RL CH A:3061 T:3061 P:3092'
G[27022]='K0450 L040 A:8516 T:1152097 P:27019 Z19033'
G[27023]='FH K0030 L002 RT RB CP A:37737 T:37737 P:27015'
G[27024]='K0440 L040 A:44837 T:44837 Z19033'
G[27025]='FA K0160 L014 A:44859 T:44859'
G[27026]='FA K0160 L014 A:44859 T:44859 P:27025'
G[27027]='FH K0030 L002 RT CS A:3062 T:3062 P:3093'
G[27028]='FA K0160 L014 A:1154 T:1154'
G[27029]='K0440 L040 A:44837 T:44837 Z19033'
G[27030]='FA K0160 L014 A:1154 T:1154'
G[27031]='FA K0170 L015 A:6577 T:6577'
G[27032]='FA K0180 L015 A:6577 T:44618 P:27031'
G[27033]='FA K0180 L015 A:44618 T:6577 P:27032'
G[27034]='FA K0180 L015 A:6577 T:44870 P:27033'
G[27035]='FA K0180 L014 A:44870 T:44870 P:27034'
G[27036]='FA K0170 L014 A:1156 T:1187 P:27016'
G[27037]='FA K0160 L014 A:1187 T:1156 P:27036'
G[27038]='FA K0840 L084 A:44749 T:44806 P:26975'
G[27039]='FH K0110 L009 A:44789 T:1205143 P:26989+26998'
G[27040]='FA K0830 L083 A:44799 T:0 P:27004+27006'
G[27041]='FH K0830 L083 A:44823 T:0 P:27005+27008'
G[27042]='FA K0830 L083 A:44802 T:44802 P:27004+27006'
G[27043]='FH K0830 L083 A:44818 T:44818 P:27005+27008'
G[27044]='FA K0840 L084 A:44293 T:44807 P:26975'
G[27045]='FH K0110 L009 A:1205143 T:44789 P:27039'
G[27046]='K0832 L081 A:43805 T:43805 P:26709'
G[27047]='K0832 L081 A:43805 T:43805 P:26709'
G[27048]='K0832 L081 A:44968 T:44968 P:26709 I:26710,28488'
G[27049]='K0832 L081 A:43804 T:43804 P:26709'
G[27050]='K0832 L081 A:43804 T:43804 P:26709'
G[27051]='K0832 L081 A:44973 T:44973 P:26709'
G[27053]='K0380 L036 A:44454 T:1176392 P:27002'
G[27054]='K0380 L036 A:44454 T:-22,44454 P:27057'
G[27055]='K0390 L036 A:-22,44454 T:44454 P:27054'
G[27056]='FH K0110 L009 A:44789 T:44365 P:27045'
G[27057]='K0380 L035 A:1176392 T:44454 P:27053'
G[27058]='FA K0830 L083 A:-640 T:44799 P:27040'
G[27059]='FH K0830 L083 A:-640 T:44823 P:27041'
G[27060]='FA K0840 L084 A:44807 T:44293 P:27044'
G[27061]='K0820 L081 A:-640,43065 T:44010 P:27010'
G[27062]='FH K0430 L042 A:39895 T:44837'
G[27063]='FA K0430 L042 A:40032 T:44837'
G[27064]='FA K0840 L084 A:1747,44293 T:544293 P:27038'
G[27065]='FH K0120 L010 A:44365 T:44916 P:27056'
G[27066]='FH K0030 L002 RT RL RB CT A:37724 T:37724 P:27014'
G[27067]='FH K0030 L002 RT RL CD A:3060 T:3060 P:3094'
G[27068]='K04964 L044 A:40712 T:40712 O:25556'
G[27069]='FH K0120 L010 A:44916 T:44916 P:27065'
G[27070]='K04864 L044 A:7407 T:7407'
G[27071]='K04864 L044 A:40712 T:40712'
G[27072]='FA K0840 L084 A:332 T:50049 P:28807'
G[27073]='FH K0120 L010 A:44917 T:44917 P:27065'
G[27074]='FA K0180 L014 A:44870 T:1073 P:27035'
G[27075]='FA K0180 L014 A:1073 T:1073 P:27074'
G[27076]='K04864 L044 A:44929 T:44929'
G[27077]='FA K0180 L014 A:1073 T:1073 P:27074'
G[27078]='FA K0190 L014 A:1073 T:1073 P:27075+27077'
G[27079]='E21655'
G[27080]='E21655'
G[27081]='E21655'
G[27082]='FH K0120 L010 A:44912 T:44912 P:27065'
G[27083]='FH K0400 L038 A:10837,45013 T:44452 P:26938+27150|26952'
G[27084]='FH K0400 L038 A:44452 T:44452 P:27083'
G[27085]='FH K0400 L038 A:44462 T:44462 P:27083'
G[27086]='FH K0400 L038 A:44452 T:44452 P:27084'
G[27087]='FH K0400 L038 A:44452 T:44466 P:27084,27086'
G[27088]='FH K0120 L010 A:44912 T:44912 P:27082'
G[27089]='FH K0400 L038 A:44451 T:45129 P:27087'
G[27090]='FH K0400 L038 A:45129 T:44451 P:27089'
G[27091]='K0030 L002 RB CW A:43010 T:43010 P:8329'
G[27092]='FA K0840 L084 A:50049 T:1205198 P:27072'
G[27093]='FH K0120 L010 A:44916 T:44916 P:27069+27073'
G[27094]='K0130 L010 A:-21,44917 T:44917 P:27095'
G[27095]='FH K0120 L010 A:44917 T:-21,44917 P:27069+27073'
G[27096]='FH K0130 L010 A:44916 T:44365 P:27088+27093+27094'
G[27097]='FH K0130 L011 A:44365 T:-21,44365 P:27096'
G[27098]='FH K0130 L011 A:44365 T:544365 P:27099'
G[27099]='K0130 L011 A:-21,44365 T:44365 P:27097'
G[27100]='K0820 L082 A:100060816 T:0,43397'
G[27101]='K0820 L081 A:-640,43397 T:1205207 P:27100'
G[27102]='K0820 L081 A:1205207 T:0,43397 P:27101'
G[27103]='K0410 L036 A:44969 T:44969 O:27130'
G[27104]='K0410 L036 A:44969 T:44969 O:27130'
G[27105]='K0400 L036 A:44969 T:44969 O:27130'
G[27106]='FA K0840 L084 A:1205198 T:29611 P:27092'
G[27107]='K04064 L036 A:44971 T:44971'
G[27108]='K0400 L036 A:44971 T:44971'
G[27109]='K0430 L039 A:44999 T:44999'
G[27110]='K0440 L039 A:14358 T:14358'
G[27111]='K0440 L039 A:14358 T:1179517 P:27110'
G[27112]='K0430 L039 A:44991 T:44991 O:27132'
G[27113]='K0430 L039 A:44991 T:14358 O:27132'
G[27114]='FH K0460 L042 A:14322 T:14322'
G[27115]='FA K0180 L015 A:1073 T:44870 P:27078'
G[27116]='FA K0180 L015 A:44870 T:1343 P:27115'
G[27117]='FH K0350 L034 A:44452 T:44452 P:26922'
G[27118]='K0461 L042 A:1179485 T:1179485'
G[27119]='K0461 L042 A:14338 T:14338'
G[27120]='K0461 L042 A:14338 T:14338'
G[27123]='K0820 L081 A:45042 T:43065 P:27203'
G[27124]='K0470 L042 A:14325 T:14326'
G[27125]='K0470 L042 A:45040 T:45040 O:27134'
G[27126]='K0830 L081 A:43169 T:45043 P:26625'
G[27127]='K0800 L078 E21655'
G[27128]='FH K0470 L042 A:45052 T:45052'
G[27129]='FA K0400 L038 A:40032 T:44969'
G[27130]='FH K0400 L038 A:7875 T:44969'
G[27131]='FA K0420 L041 A:40032 T:44991'
G[27132]='FH K0420 L041 A:7875 T:44991'
G[27133]='FA K0460 L044 A:3936 T:45040'
G[27134]='FH K0460 L044 A:39656 T:45052'
G[27135]='K0820 L081 A:42574 T:42574 P:26409'
G[27136]='K0820 L081 A:43397 T:43397'
G[27137]='E21655'
G[27138]='E21655'
G[27139]='FH K0070 L001 RG A:36471 T:38120 P:26705'
G[27140]='E21655'
G[27141]='K0830 L083 A:44860 T:45180 P:27993'
G[27142]='E21655'
G[27143]='E21655'
G[27144]='FH K0400 L038 A:44451 T:44451 P:27090'
G[27145]='E21655'
G[27146]='E21655'
G[27147]='E21655'
G[27148]='E21655'
G[27149]='E21655'
G[27150]='FH K0370 L035 T:44454 I:26952 Z19678'	-- TODO: Need the A: for this
G[27151]='K0370 L035 A:45147 T:-22,45147 P:27002'
G[27152]='K0370 L035 A:-22,45147 T:-22,45147 P:27151'
G[27153]='K0370 L035 A:-22,45147 T:-22,45147 P:27152'
G[27154]='K0370 L035 A:-22,45147 T:-22,45147 P:27153'
G[27155]='K0370 L035 A:-22,45147 T:44441 P:27154'
G[27156]='K0370 L035 A:45157 T:45157'
G[27157]='K0370 L035 A:45157 T:45157 P:27156'
G[27158]='FA K0350 L034 A:10838 T:44453 I:28505,28576,28749'
G[27159]='FA K0350 L034 A:44453 T:44453 O:27158,28505,28576,28749'
G[27160]='FA K0350 L034 A:44471 T:44471'
G[27161]='FA K0350 L034 A:44467 T:44467'
G[27162]='FA K0350 L034 A:44453 T:44453 P:27159+27160'
G[27163]='FA K0350 L034 A:44453 T:44453 P:27159+27160'
G[27164]='FA K0350 L034 A:44467 T:44453 P:27161'
G[27165]='FA K0350 L034 A:44453 T:10838 P:27162+27163+27164'
G[27166]='FA K0360 L034 A:10838 T:10838'
G[27167]='FA K0360 L034 A:45165 T:45165'
G[27168]='FA K0360 L034 A:11053 T:11053 P:27166+27167'
G[27169]='FA K0360 L034 A:10838 T:1854 P:27166+27167'
G[27170]='FA K0360 L034 A:1854 T:1205258 P:27169'
G[27171]='FA K0360 L034 A:1205258 T:10838 P:27170'
G[27172]='FA K0360 L034 A:10838 T:545165 P:27171'
G[27173]='FA K0360 L034 A:545165 T:545165 P:27172'
G[27174]='FA K0370 L034 A:545165 T:545165 P:27173'
G[27175]='FA K0370 L035 A:10840 T:44454 P:27168 I:27233'
G[27176]='K0830 L083 A:1205266 T:45180 P:27141'
G[27177]='FA K0840 L084 A:45170 T:45170 P:28599'
G[27178]='FA K0840 L084 A:45170 T:45170 P:28599'
G[27179]='K0830 L083 A:45186 T:45180 P:27141'
G[27180]='FH K0130 L011 A:544365 T:544365 P:27098'
G[27181]='FH K0130 L011 AK:45195 T:-21,544365 P:B27180'
G[27182]='FH K0360 L034 A:4501 T:4792'
G[27183]='K0360 L034 A:4792 T:4792 O:27182,27215'
G[27184]='K0360 L034 A:4792 T:4792 P:27183'
G[27185]='K0460 L042 A:45201 T:545201'
G[27186]='K0360 L034 A:4792 T:4792 P:27184'
G[27187]='K0830 L083 AK:45202 T:0 P:27141'
G[27188]='K0360 L034 A:23843 T:23843'
G[27189]='K0360 L034 A:23843 T:23843 P:27188'
G[27190]='K0360 L034 A:23843 T:23843 P:27189'
G[27191]='K0360 L034 A:4792 T:4792 P:27184'
G[27192]='K0460 L042 A:45323 T:545323'
G[27193]='FH K0130 L011 A:-21,544365 T:-21,544365 P:27181'
G[27194]='FH K0130 L011 A:-21,544365 T:45228 P:27193'
G[27195]='FH K0130 L011 A:45228 T:544365 P:27194'
G[27196]='K0830 L083 A:45180 T:45296 P:27176+27179'
G[27197]='FA K0400 L038 A:45012 T:544453 P:27175,27233'
G[27198]='FA K0400 L038 A:544467 T:544467 P:27197'
G[27199]='FA K0400 L038 A:544453 T:544453 P:27197'
G[27200]='FA K0840 L084 A:45171 T:45171'
G[27201]='FA K0400 L038 A:544453 T:544453 P:27205'
G[27202]='FA K0400 L038 A:500020 T:500020 P:27205'
G[27203]='K0820 L082 AA:45226 AH:45244 T:45042 O:27722,27727'
G[27204]='FA K0400 L038 A:544453 T:544453 P:27201+27202'
G[27205]='FA K0400 L038 A:544453 T:544453 P:27198+27199'
G[27206]='FA K0400 L038 A:544453 T:10838 P:27204'
G[27207]='FA K0800 L078 A:42443 T:466 Z13329'
G[27208]='K0470 L042 A:45200 T:545200'
G[27209]='FH K0800 L078 A:42600 T:5769 Z13329'
G[27210]='FA K0360 L034 A:23566 T:23566 O:26702,28552'
G[27211]='FA K0360 L034 A:23566 T:23566 P:27210'
G[27212]='FA K0360 L034 A:23566 T:23566 P:27211'
G[27213]='FA K0360 L034 A:23566 T:23566 P:27212'
G[27214]='FA K0360 L034 A:23951 T:5086 P:27213,27222'
G[27215]='FA K0360 L034 A:23835 T:4792 P:27213,27222'
G[27216]='FA K0360 L034 A:23835 T:23892'
G[27217]='FA K0360 L034 A:23892 T:23892 P:27216'
G[27218]='FA K0360 L034 A:23892 T:23896 P:27217'
G[27219]='FA K0360 L034 A:23896 T:12919 P:27218'
G[27220]='FA K0370 L034 A:12919 T:12919 P:27219'
G[27221]='FA K0370 L034 A:12919 T:23905 P:27220'
G[27222]='FA K0370 L034 A:23905 T:23905 P:27221'
G[27223]='K0470 L042 A:45200 T:545200'
G[27224]='E21655'
G[27225]='FA K0200 L020 CW A:4087,17120 T:914'
G[27226]='FH K0130 L011 A:544917 T:544917 P:27098'
G[27227]='K0510 L046 A:45329 TP:545329:E35574;45329'
G[27228]='K0500 L046 A:45206 TP:545206:E35574;45206'
G[27229]='FH K0360 L034 A:1205332 T:4926'
G[27230]='K0500 L046 A:45331 TP:545331:E35574;45331'
G[27231]='FH K0130 L011 A:544916 T:1205350 P:27098'
G[27232]='FH K0130 L011 A:1205350 T:544916 P:27231'
G[27233]='FA K0370 L035 A:45165 T:44454 P:27174 I:27175'
G[27234]='FA K0370 L034 A:5086 T:5086 O:27214'
G[27235]='FA K0370 L032 A:5086 T:23569 P:27234'
G[27236]='FA K0370 L032 A:23569 T:23569 P:27235'
G[27237]='FA K0370 L032 A:23569 T:23569 P:27236'
G[27238]='FA K0370 L034 A:23569 T:4968 P:27237'
G[27239]='FA K0370 L034 A:4968 T:4968 P:27238'
G[27240]='FA K0370 L034 A:4968 T:29611 P:27239'	-- appears 40 seconds after completion of 27239
G[27241]='FA K0370 L032 A:29611 T:4968 P:27240'
G[27242]='FA K0370 L035 A:23723 T:23723'
G[27243]='FA K0370 L035 A:23723 T:23723 P:27242'
G[27244]='FH K0360 L034 A:1020985 T:4791'
G[27245]='FA K0370 L035 A:23723 T:23723 P:27242'
G[27246]='FA K0360 L034 A:1020985 T:23951'
G[27247]='FA K0360 L034 A:23951 T:4944 P:27246'
G[27248]='FA K0390 L037 A:23951 T:23572'
G[27249]='FA K0370 L035 A:4944 T:23567 O:27251'
G[27250]='E21655'
G[27251]='FA K0370 L035 A:4921 T:4944'
G[27252]='FA K0370 L035 A:1020992 T:4944 P:27249'
G[27253]='FH K0370 L035 A:4926 T:23567'
G[27254]='FH K0350 L030 A:1020992 T:4926'
G[27255]='FH K0370 L035 A:4926 T:5087 P:27254'
G[27256]='FH K0370 L035 A:5087 T:5087 P:27255'
G[27257]='FH K0370 L035 A:5087 T:4926 P:27256'
G[27258]='FH K0370 L035 A:4926 T:4943 P:27257+27253+27259+27260+27306+27261'
G[27259]='FH K0370 L035 A:1187273 T:4926'
G[27260]='FH K0370 L035 A:1021042 T:4926'
G[27261]='FH K0370 L035 A:4983 T:4926 P:27306'
G[27262]='FA K0370 L035 A:1187273 T:4944 P:27249'
G[27263]='FA K0370 L035 A:1021042 T:4944 P:27249'
G[27264]='FA K0370 L035 A:4944 T:4948 P:27263'
G[27265]='FA K020 L020 RF RD RH CP A:5147,16761,35281 T:928'
G[27266]='FA K0200 L020 CH A:4138,5115,17122 T:44247'
G[27267]='FA K0200 L020 CR A:4214,5165 T:918'
G[27268]='FA K0200 L020 RH RF RD RW CT A:11401,11406,16756 T:376'
G[27269]='FA K0200 L020 RE CT A:11401,11406 T:7999'
G[27270]='FA K0200 L020 CS A:23127,52292 T:20407'
G[27271]='FA K020 L020 CM A:5146,16749,50690 T:331'
G[27272]='FA K0200 L020 CL A:5173 T:461'
G[27273]='FA K0200 L020 RE RW CD A:4217,5504,16721,44395 T:12042'
G[27274]='FA K0200 L020 RN CT A:11406 T:45306'
G[27275]='FA K0420 L038 A:41444 T:45277 P:25871'
G[27276]='FH K0420 L038 A:41421 T:45278 P:25872'
G[27277]='FH K0200 L020 CM A:3047,4566,16653 T:47246'
G[27278]='FH K0200 L020 CH A:3039,16674,39116 T:3352'
G[27279]='FH K0200 L020 CR A:4584,16684 T:47233'
G[27280]='FH K0200 L020 CS A:3032 T:3344'
G[27281]='FH K0200 L020 CW A:3042,4593,43009 T:3353'
G[27282]='FH K0200 L020 CL A:4563,16648,43881 T:3326'
G[27283]='FH K0200 L020 RT RL CD A:3034,44726,44978,52319 T:12042'
G[27284]='FA K0370 L035 A:4944 T:4941 P:27252'
G[27285]='FA K0370 L035 A:4941 T:4944 P:27284'
G[27286]='FA K0370 L035 A:4948 T:4944 P:27264'
G[27287]='FA K0370 L035 A:4944 T:5089 P:27286'
G[27288]='FA K0370 L035 A:5089 T:4944 P:27287'
G[27290]='FH K0140 L012 A:544365 T:45312 P:27232+27180+27195+27226'	-- This is my guess at what the quest really should have as P codes because the above has one that does not exist in the database.
G[27291]='FA K0390 L030 A:4944 T:4944 P:27430'
G[27292]='FH K0370 L034 A:4943 T:4926 P:27258'
G[27293]='FH K0380 L035 A:4926 T:4926 P:27292'
G[27294]='FH K0370 L035 A:4926 T:4926 P:27292'
G[27295]='FH K0380 L036 A:4926 T:6546 P:27293+27294'
G[27296]='FH K0380 L036 A:6546 T:6546 P:27295'
G[27297]='FH K0380 L036 A:6546 T:4926 P:27296'
G[27298]='FH K0200 L020 RB CP A:16681,20406,43795 T:23128'
G[27299]='K0840 L084 A:45332 T:45332 P:27374,27375'
G[27300]='K0840 L084 A:45332 T:45332 P:27299'
G[27301]='K0840 L084 A:45391 T:45362 P:27299'
G[27302]='K0840 L084 A:45432 T:45432 P:27299'
G[27303]='K0840 L084 A:45362 T:45386 P:27301'
G[27304]='FH K0200 L020 RT CP A:20406,43795 T:44725'
G[27305]='K0460 L042 A:45200 T:545200'
G[27306]='FH K0370 L035 A:4926 T:4983 P:27260'
G[27308]='E21655'
G[27310]='FA K0420 L038 A:45277 T:545277 P:27275'
G[27311]='FH K0420 L038 A:45278 T:545278 P:27276'
G[27312]='FA K0420 L038 A:45277 T:545277 P:27275'
G[27313]='FH K0420 L038 A:45278 T:545278 P:27276'
G[27314]='FA K0420 L038 A:45277 T:545277 P:27275'
G[27315]='FH K0420 L038 A:45278 T:545278 P:27276'
G[27316]='FA K0420 L038 A:48208 T:545277 P:27275 O:28283'
G[27317]='FH K0420 L038 A:48208 T:545278 P:27276 O:28284'
G[27318]='FA K0420 L038 A:545277 T:545277 P:27314'
G[27319]='FH K0420 L038 A:545278 T:545278 P:27315'
G[27320]='FA K0420 L038 A:545277 T:545277 P:27316'
G[27321]='FH K0420 L038 A:545278 T:545278 P:27317'
G[27322]='FH K0150 L012 A:100060956 T:45315,44640'	-- TODO: Investigate when 45315 is dead so turn in must go to 44640 to transform the T: into proper TP:
G[27323]='FA K0420 L038 A:545277 T:545277 P:27318'
G[27324]='FH K0420 L038 A:545278 T:545278 P:27319'
G[27325]='FA K0420 L038 A:545277 T:545277 P:27316'
G[27326]='FH K0420 L038 A:545278 T:545278 P:27317'
G[27327]='FA K0430 L038 A:545277 T:545277 P:27323'
G[27328]='FH K0430 L038 A:545278 T:545278 P:27324'
G[27329]='FA K0430 L038 A:45442 T:45442 P:27357'
G[27330]='FH K0430 L038 A:45442 T:45442 P:27358'
G[27331]='FH K0200 L020 RT CT A:3045,4606,43870 T:44735'
G[27332]='FH K0200 L020 RL CT A:3045,4606,16658 T:45137'
G[27333]='FH K0140 L012 A:45315 T:45315 P:27290'
G[27334]='FH K0200 L020 RU CT A:3045,4606,16658 T:45339'
G[27335]='FH K0200 L020 RB CT A:4606,16658,43870 T:45337'
G[27336]='K0380 L036 A:23601 T:23601'
G[27337]='FA K02064 L020 CW A:914 T:5511 O:27225'
G[27338]='FA K0840 L084 A:45167 T:45169 P:28599'
G[27339]='K0380 L036 A:23601 T:23601'
G[27340]='K0380 L036 A:23600 T:23600'
G[27341]='FA K0840 L084 A:45169 T:45169 P:27338'
G[27342]='FH K0140 L012 A:45312 T:45312 P:27290'
G[27343]='FA K02064 L020 RF RD RH CP A:928 T:5511 O:27265'
G[27344]='FA K02064 L020 CH A:44247 T:1298 O:27266'
G[27345]='FH K0140 L012 A:45315 T:45315 P:27290'
G[27346]='K0380 L036 A:23600 T:23797'
G[27347]='K0380 L036 A:23797 T:23797'
G[27348]='K0380 L036 A:23797 T:23797'	-- marks 11207 also complete, but we do not have that quest as no one can get it [also for some reason when I checked, 13807 is marked complete but that could have been from coming from SW]
G[27349]='FH K0140 L012 A:45315 T:45315 P:27333+27342+27345'
G[27350]='FH K0140 L012 A:-21,45315 T:45389 P:27349'
G[27351]='FA K02064 L020 CR A:13283 T:5511 O:27267'
G[27352]='K0500 L046 A:45328 TP:545328:E35574;45328'
G[27353]='FA K02064 L020 RF RD RA CS A:20407 T:5511 O:27270'
G[27354]='FA K02064 L020 CM A:331 T:1317 O:27271'
G[27355]='FA K02064 L020 CL A:461 T:1317 O:27272'
G[27356]='FA K02064 L020 RE RW CD A:12042 T:12029 O:27273'
G[27357]='FA K0430 L038 A:545277 T:45442 P:27327+27325+27320'
G[27358]='FH K0430 L038 A:545278 T:45442 P:27328+27326+27321'
G[27359]='K0500 L046 A:45330 TP:545330:E35574;45330'
G[27360]='FH K0150 L012 A:45389 T:45389 P:27350'
G[27361]='FA K02064 L020 RH RF RD RW CT A:376 T:1317 O:27268'
G[27362]='FA K02064 L020 RE CT A:7999 T:1317 O:27269'
G[27363]='FA K02064 L020 RN CT A:45306 T:1317 O:27274'
G[27364]='FH K0150 L012 A:-684,45315 T:-684,45315 P:27350'	-- auto accepted when accepting 27360
G[27365]='FH K0200 L020 CW A:3353 T:3355 O:27281'
G[27366]='FA K0840 L084 A:45169 T:45169 P:27338'
G[27367]='K0400 L039 A:45417 T:45428 O:27683'
G[27368]='K0400 L039 A:45428 T:45428 P:27367'
G[27369]='K0400 L039 A:45431 T:45417 P:27368'
G[27370]='K0400 L039 A:45417 T:45429'
G[27371]='K0400 L039 A:45429 T:-23,45429 P:27370'
G[27372]='K0400 L039 A:-23 T:45417 P:27371'
G[27373]='K0400 L039 A:45417 T:545417 P:27369+27372'
G[27374]='FA K0840 L084 A:49374 T:45332 P:28655'
G[27375]='FH K0840 L084 A:46324 T:45332 P:27945'
G[27376]='K0840 L084 A:45332 T:47991 P:27300+27302+27303'
G[27377]='K0840 L084 A:47991 T:-737,48051 P:27376'
G[27378]='K0840 L084 A:48051 T:48059 P:27377'
G[27379]='K0840 L084 A:48059 T:48059 P:27378'
G[27380]='K0850 L084 A:48059 T:45332 P:27379'
G[27381]='K0410 L039 A:545429 T:545429 P:27373'
G[27382]='K0410 L039 A:45451 T:45451'	--  P:B27381 was incorrect
G[27383]='K0410 L039 A:11063 T:10926'
G[27384]='K0410 L039 A:10926 T:10926 P:27383'
G[27385]='K0410 L039 A:10926 T:11063 P:27384+27392'
G[27386]='K0410 L039 A:11063 T:10667 P:27385'
G[27387]='K0410 L039 A:10667 T:10667 P:27386'
G[27388]='K0410 L039 A:10667 T:10667 P:27386'
G[27389]='K0410 L039 A:10667 T:10667 P:27386'
G[27390]='K0410 L039 A:10667 T:10926 P:27387+27388+27389'
G[27391]='K0410 L039 A:10926 T:1177544 P:27390'
G[27392]='K0410 L039 A:10926 T:10926 P:27383'
G[27393]='FA K0810 L080 A:39881 T:1202714 P:25580'
G[27394]='FH K0810 L080 A:40919 T:1203140 P:25953'
G[27395]='FH K0200 L020 CH A:3352 T:3355 O:27278'
G[27396]='FH K0200 L020 CR A:47233 T:3355 O:27279'
G[27397]='FH K0200 L020 CS A:3344 T:3355 O:27280'
G[27398]='FA K0820 L082 A:540772 T:45226 P:25551'
G[27399]='FH K0820 L082 A:540772 T:45244 P:25551'
G[27400]='FH K0200 L020 CM A:47246 T:3345 O:27277'
G[27401]='FH K0150 L012 A:-684,45315 T:-684,45315 P:27364'
G[27402]='FH K0200 L020 CL A:3326 T:3345 O:27282'
G[27403]='FH K0200 L020 RT CP A:44725 T:3355 O:27304'
G[27404]='FH K0200 L020 RT RL CD A:12042 T:12029 O:27283'
G[27405]='FH K0150 L012 A:-684,45315 T:545312 P:27401'
G[27406]='FH K0160 L013 A:545312 T:545474 P:27405'
G[27407]='K0390 L036 A:23579 T:23579'
G[27408]='K0390 L036 A:23579 T:23579 P:27407'
G[27409]='K0390 L036 A:23579 T:23579 P:27407'
G[27410]='K0390 L036 A:23579 T:23579 P:27408+27409'
G[27411]='K0390 L036 A:23579 T:23579 P:27410'
G[27412]='K0390 L036 A:1186426 T:23572'
G[27413]='K0390 L036 A:23570 T:23570'
G[27414]='FH K0390 L036 A:4501 T:4501'
G[27415]='FH K0390 L036 A:4501 T:4501'	-- P:27417 was incorrect.  it may be P:B or P:27416
G[27416]='FH K0390 L036 A:4501 T:4500 P:27414'	-- after a delay of 14 seconds after turnin of 27414
G[27417]='FH K0390 L037 A:4500 T:4501 P:27416'	-- this may need an SP...the acceptance was odd
G[27418]='FH K039512 L037 A:4500 T:4501 P:27415'	-- PM2
G[27419]='E21655'
G[27420]='K0410 L039 A:16135 T:16135 O:27544'
G[27421]='K0410 L039 A:16135 T:16135'
G[27422]='K0450 L044 A:45482 T:45323'
G[27423]='FH K0160 L013 A:-684 T:45474 P:B27406'
G[27424]='FH K0390 L037 A:4500 T:4500'
G[27425]='FA K0380 L035 A:4944 T:23568 P:27262+27285+27288'
G[27426]='FA K0380 L035 A:23568 T:23568 P:27425'
G[27427]='FA K0380 L035 A:23568 T:23568 P:27425'
G[27428]='FA K0380 L036 A:23568 T:6546 P:27426+27427'
G[27429]='FA K0380 L036 A:6546 T:6546 P:27428'
G[27430]='FA K0380 L036 A:6546 T:4944 P:27429'
G[27431]='K0830 L083 A:45296 T:45296 P:27549+27517,27549+28602'
G[27432]='K0410 L039 A:45500 T:45500'
G[27433]='FA K0840 L084 A:45168 T:45168 P:27338'
G[27434]='FH K0200 L020 RB CP A:23128 T:3355 O:27298'
G[27435]='FH K0200 L020 RT CT A:44735 T:3345 O:27331'
G[27436]='FH K0200 L020 RL CT A:45137 T:3345 O:27332'
G[27437]='FH K0200 L020 RU CT A:45339 T:3345 O:27334'
G[27438]='FH K0160 L013 A:500026 T:45525 P:27406'
G[27439]='FH K0200 L020 RB CT A:45337 T:3345 O:27335'
G[27440]='K0590 L055 A:10299 T:10299'
G[27441]='FH K0200 L020 RG CT A:45347 T:3345 O:28164'
G[27442]='FH K0820 L082 A:45460 T:45244'
G[27443]='FA K0820 L082 A:45462 T:45226'
G[27444]='K0590 L055 A:10299 T:10299 Z20338'
G[27445]='K0600 L055 A:10299 T:10299 Z20338'
G[27446]='FA K0430 L043 A:40027 T:38535 I:28507'
G[27447]='FH K0430 L043 A:40028 T:38534'
G[27448]='K0420 L039 A:545417 T:500045 P:27381+27382'
G[27449]='K0420 L039 A:45574 T:45574 P:27432'
G[27450]='K0420 L039 A:45575 T:45575'
G[27451]='K0420 L039 A:11035 T:-23,11035'
G[27452]='K0420 L039 A:11035 T:-23,11035'
G[27453]='K0420 L039 A:-23,11035 T:-23,11035 P:27451+27452'
G[27454]='K0420 L039 A:-23,11035 T:11035 P:27453'
G[27455]='K0420 L039 A:500045 T:45431 P:27448'
G[27456]='K0420 L039 A:16134 T:16134'
G[27457]='K0420 L039 A:16134 T:45417 P:27456+27465'
G[27458]='K0420 L039 A:11033 T:11033'
G[27459]='K0420 L039 A:11036 T:16116'
G[27460]='K0420 L039 A:16116 T:1205875 P:27459'
G[27461]='K0420 L039 A:1205875 T:16115 P:27460'
G[27462]='K0420 L039 A:1205875 T:16112 P:27460'
G[27463]='K0420 L039 A:45431 T:11034 P:27455'
G[27464]='K0420 L039 A:11034 T:11034 P:27463'
G[27465]='K0420 L039 A:11034 T:11034 P:27464'
G[27466]='K0430 L039 A:45729,545729 T:500047 P:27465'
G[27467]='K0420 L039 A:16365 T:16365 P:27464'
G[27468]='FA K0840 L084 A:45168 T:45168 P:27433'
G[27469]='K0580 L057 AA:56899 AH:9563 T:10299'	-- Note that both can give to both factions, but this is safer for players.	-- 2014-08-19 Updated to have quest given to other faction only based on feedback.
G[27470]='K0580 L057 A:14625,514625 T:10299'
G[27471]='FA K05864 L057 A:9562 T:10299'
G[27472]='FH K0160 L013 A:45525 T:45617 P:27438'
G[27474]='FH K0170 L014 A:45617 T:45617 P:27472'
G[27475]='FH K0170 L014 A:45626 T:45626 P:27472'
G[27476]='FH K0180 L014 A:45617 T:1938 P:27474+27475'
G[27477]='K0430 L039 A:45735 T:45735'
G[27478]='FH K0180 L014 A:1938 T:1938 P:27476'
G[27479]='K0430 L039 A:45736 T:45736'
G[27480]='FH K0180 L014 A:100061310 T:1938 P:C27483'
G[27481]='K0430 L039 A:545574 T:-23,545574 P:27449'
G[27482]='K0430 L039 A:-23,545574 T:-23 P:27465+27481'
G[27483]='FH K0180 L014 A:1938 T:1938 P:27476'
G[27484]='FH K0180 L014 A:1938 T:45617 P:27478'
G[27485]='FA K0850 L084 A:48265 T:45528 P:27380 I:27486'
G[27486]='FH K0850 L084 A:48264 T:45528 P:27380 I:27485'
G[27487]='K0430 L039 A:545729 T:500047 P:27466'
G[27488]='K0430 L039 A:545729 T:545729 P:27487'
G[27489]='K0430 L039 A:545729 T:500049 P:27488'
G[27490]='FA K0850 L084 A:45669 T:45669 P:28248'
G[27491]='FH K0850 L084 A:45665 T:45665 P:28249'
G[27492]='FA K0850 L084 A:45668 T:45668 P:28248'
G[27493]='FH K0850 L084 A:45658 T:45658 P:28249'
G[27494]='FA K0850 L084 A:45668 T:0 P:27490+27492+27496'
G[27495]='FH K0850 L084 A:45658 T:0 P:27491+27493+27497'
G[27496]='FA K0850 L084 A:45669 T:45669 P:28248'
G[27497]='FH K0850 L084 A:45665 T:45665 P:28249'
G[27498]='FA K0850 L084 A:-700 T:0 P:27494'
G[27499]='FH K0850 L084 A:-700 T:0 P:27495'
G[27500]='FA K0850 L084 A:-700 T:45669 P:27498'
G[27501]='FH K0850 L084 A:-700 T:45665 P:27499'
G[27502]='FA K0850 L084 A:45669 T:0 P:27500'
G[27503]='FH K0850 L084 A:45665 T:0 P:27501'
G[27504]='K0850 L084 A:45528 T:45522 P:27485,27486'
G[27505]='K0850 L084 A:45522 T:45522 P:27504'
G[27506]='K0850 L084 A:45562 T:45562 P:27504'
G[27507]='K0850 L084 A:45528 T:45528 P:27564'
G[27508]='K0850 L084 A:45518 T:45518 P:27564'
G[27509]='K0850 L084 A:45528 T:45528 P:27564'
G[27510]='FH K0180 L014 A:45631,46125 T:45631,46125 P:27484'
G[27511]='K0830 L083 A:45296 T:0,45296 P:27196'
G[27512]='FH K0180 L014 A:45617 T:45752 P:27484'
G[27513]='K0180 L014 A:-21,45752 T:-21,45617 P:27512'
G[27514]='FA K0840 L084 A:45169 T:45172 P:27341,27366'
G[27515]='FA K0840 L084 A:45172 T:45172 P:27514'
G[27516]='FA K0840 L084 A:45172 T:45167 P:27515'
G[27517]='K0830 L083 A:1205540 T:45296 P:27196 I:28602'
G[27518]='FH K0190 L014 A:-21,45617 T:45617 P:27513'
G[27519]='K0830 L083 A:45772 T:45772 P:28135'
G[27520]='K0830 L083 A:45799 T:45799 P:28135'
G[27521]='K0440 L039 A:45826 T:45826'
G[27522]='K0440 L039 A:500049 T:500050 P:27489'
G[27523]='K0440 L039 A:45816 T:45816'
G[27524]='K0440 L039 A:500050 T:500051 P:27522'
G[27525]='K0450 L039 A:500051 T:45729 P:27524'
G[27526]='K0450 L039 A:500051 T:45730 P:27551'
G[27527]='K0450 L039 A:45730,545730 T:500052 P:27526'
G[27528]='K0440 L039 A:45831 T:45831'
G[27529]='K0440 L039 A:45831 T:45831'
G[27530]='K0450 L039 A:45831 T:45831 P:27528+27529+27539'
G[27531]='K0440 L041 A:45828 T:45828 O:27532'
G[27532]='K0440 L041 A:545451 T:45828 P:27522'
G[27533]='K0440 L041 A:12384 T:12384 O:27535'
G[27534]='K0440 L041 A:12384 T:12384'
G[27535]='K0440 L041 A:45828 T:12384'
G[27536]='K0520 L051 A:45786 T:45786 P:27587'
G[27537]='FA K0840 L084 A:45167 T:45173 P:27516'
G[27538]='FA K0840 L084 A:545172 T:45173 P:27516'
G[27539]='K0440 L039 A:45831 T:45831'
G[27541]='K0830 L083 A:45874 T:45296 P:27196'
G[27542]='SP FH K0190 L015 A:45617 T:45617 P:27518'
G[27543]='E21655'
G[27544]='K0410 L039 A:45500 T:16135 P:27386'
G[27545]='FA K0840 L084 A:45173 T:45167 P:27537'
G[27547]='FH K0190 L015 A:45880 T:45880 P:27542'
G[27548]='FH K0190 L015 A:45879 T:45879 P:27542'
G[27549]='K0830 L083 A:45296 T:45296 P:27541'
G[27550]='FH K0190 L015 A:45878 T:45878 P:27542'
G[27551]='K0450 L039 A:100061378 T:500051 P:B27525'
G[27552]='E21655'
G[27553]='E21655'
G[27554]='E21655'
G[27555]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27369'
G[27556]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27369'
G[27557]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27369'
G[27558]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27390'
G[27559]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27449'
G[27560]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27382'
G[27561]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27457'
G[27562]='SP K0001 L039 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27563'
G[27563]='K0000 L000 T:46022 Q1:46022'	-- flag quest that completes when convincing Beezil Linkspanner to join Fiona's caravan
G[27564]='K0850 L084 A:45522 T:45528 P:27505+27506'
G[27565]='FA K0520 L047 A:45892 T:45898'
G[27567]='FA K0550 L047 A:45898 T:45898 P:27565'
G[27568]='FA K0540 L051 A:45891 T:45894'
G[27569]='FA K0550 L051 A:45894 T:45888 P:27568'
G[27571]='FA K0560 L051 A:45888 T:45899 P:27569'
G[27573]='FA K0570 L051 A:45899 T:45890 P:27571'
G[27574]='FH K0190 L015 A:100061505 T:-21,45878 P:27547+27548+27550'
G[27575]='FH K0190 L015 A:-21,45878 T:45878 P:27574'
G[27576]='FH K0850 L084 A:45528 T:47492 P:27507+27508+27509'
G[27577]='FH K0190 L015 A:45879 T:45879 P:27547+27548+27550'
G[27578]='FA K0580 L051 A:45890 T:45890 P:27573'
G[27579]='FH K0520 L047 A:45821 T:45818'
G[27580]='FH K0200 L015 A:45878 T:45878 P:27547+27548+27550'
G[27581]='FH K0550 L047 A:45818 T:45818 P:27579'
G[27582]='FH K0540 L051 A:45839 T:45820'
G[27583]='FH K0840 L084 A:44169 T:45982 P:26840'
G[27584]='FH K0840 L084 A:45982 T:45982 P:27583'
G[27585]='FH K0550 L051 A:45820 T:45817 P:27582'
G[27586]='FH K0840 L084 A:45983 T:45983 P:27583'
G[27587]='K0520 L051 A:45786 T:45786 O:28569,28570,28675,28677'
G[27589]='FH K0560 L051 A:45817 T:45824 P:27585'
G[27591]='FH K0570 L051 A:45824 T:45840 P:27589'
G[27592]='K0520 L051 A:46010 T:46010'
G[27593]='FH K0580 L051 A:45840 T:45840 P:27591'
G[27594]='FH K0200 L015 A:45878 T:45617 P:27577+27580'
G[27595]='K0830 L083 A:45772 T:46003 P:28135'
G[27596]='K0550 L051 A:45850 T:45850'
G[27597]='K0520 L051 A:45786 T:45948 P:27536+27656'
G[27598]='K0520 L051 A:45948 T:45948 P:27597'
G[27599]='K0520 L051 A:45948 T:45948 P:27597'
G[27600]='K0520 L051 A:45948 T:45948 P:27598+27599'
G[27601]='FH K0200 L015 A:45617 T:46124 P:27594'
G[27602]='K0830 L083 A:46003 T:1205874 P:27595'
G[27603]='K0520 L047 A:45849 T:45849'
G[27604]='K0540 L050 A:46077 T:46077 O:27915'
G[27605]='K0540 L050 A:46077 T:46077 O:27915'
G[27606]='FH K0840 L084 A:45983 T:45983 P:27584+27586'
G[27607]='FH K0840 L084 A:44169 T:46089 P:26840'
G[27610]='FH K0840 L084 A:46089 T:46089 P:27607'
G[27611]='FH K0840 L084 A:46089 T:46089 P:27607'
G[27612]='K0420 L039 A:16115 T:16115 P:27461'
G[27613]='K0420 L039 A:16115 T:16115 P:27461'
G[27614]='K0420 L039 A:16112 T:16112 P:27462'
G[27615]='K0420 L039 A:16112 T:16112 P:27462'
G[27616]='K0420 L039 A:16112 T:16112 P:27462'
G[27617]='K0420 L039 A:16115 T:516116 P:27612+27613'
G[27618]='K0420 L039 A:16112 T:516116 P:27614+27615+27616+27619'
G[27619]='K0420 L039 A:16112 T:16112 P:27462'
G[27620]='K0430 L039 A:516116 T:11036 P:27617+27618'
G[27621]='FA K0840 L084 A:545172 T:46804 P:27545'
G[27622]='FH K0840 L084 A:46090 T:46090 P:27610+27611'
G[27623]='K0830 L083 A:1205874 T:1205874 P:27602'
G[27624]='K0830 L083 A:45296 T:45296 P:27431'
G[27625]='FA K0350 L030 A:46475 T:46475 P:27725'
G[27626]='FA K0350 L030 A:46475 T:46475 P:27725'
G[27627]='K0830 L083 AK:46126,46127,46128,46129 T:-720 P:27431'
G[27628]='K0830 L083 A:45799 T:47684 P:27706'
G[27629]='K0840 L083 A:47959 T:46136 P:27628'
G[27630]='K0830 L083 A:47959 T:46135 P:27628'
G[27631]='K0830 L083 A:47959 T:46134 P:27628'
G[27632]='K0830 L083 A:46136 T:0,46136 P:27629'
G[27633]='K0540 L050 A:46077 T:46077 O:27915'
G[27635]='FA K0020 L001 RN A:46274 T:46255 P:28169'
G[27636]='FA K0850 L084 A:-700 T:45796 P:27502'
G[27638]='FH K0850 L084 A:-700 T:45675 P:27503'
G[27640]='FA K0840 L084 A:546804 T:46177 P:27817'
G[27641]='FA K0840 L084 A:46143 T:46143,46628 P:27640'	-- TODO: Verify T:46143 as well
G[27642]='FA K0840 L084 A:46143 T:46143,46628 P:27640'	-- TODO: Verify T:46143 as well
G[27643]='FA K0840 L084 A:46177 T:46176 P:27640'
G[27644]='FA K0840 L084 A:46177 T:46175 P:27640'
G[27645]='FA K0840 L084 A:46177 T:46174 P:27640'
G[27646]='FA K0840 L084 A:46176 T:46176 P:27643'
G[27647]='FA K0840 L084 A:46175 T:46583 P:27644'
G[27648]='FA K08432 L084 A:46174 T:46174 P:27645'
G[27649]='FA K0840 L084 A:46583 T:46585,46627 P:27647'
G[27650]='FA K0840 L084 A:46176,46626,46627 T:46177 P:27646'
G[27651]='FA K0840 L084 A:46177 T:46177,46628 P:27650'	-- TODO: Verify T:46177 as well
G[27652]='FA K0850 L084 A:45796 T:45796 P:27636 I:27653'
G[27653]='FH K0850 L084 A:45675 T:45675 P:27638 I:27652'
G[27654]='FA K0850 L084 A:45796 T:45796 P:27636 I:27655'
G[27655]='FH K0850 L084 A:45675 T:45675 P:27638 I:27654'
G[27656]='K0520 L051 A:45786 T:45786 P:27587'
G[27657]='FA K0850 L084 A:45796 T:46242 P:27636'
G[27658]='FH K0850 L084 A:45675 T:46242 P:27638'
G[27659]='K0850 L084 A:46242 T:46242 P:27657,27658'
G[27660]='K0850 L084 A:46242 T:46413 P:27657,27658'
G[27661]='K0850 L084 A:46413 T:46413 P:27660'
G[27662]='K0850 L084 A:46243 T:46243 P:27657,27658'
G[27663]='K0520 L051 A:46182 T:46182 P:27587'
G[27664]='K0850 L001 A:100062021 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27665]='K0850 L001 A:100062045 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27666]='K0850 L001 A:100062044 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27667]='K0850 L001 A:100062046 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27668]='FH K0810 L080 A:41711 T:1203395 P:25943'	-- probably is invalidated by one of the quests that has it as a requirement (most likely an O:)
G[27669]='K0830 L083 A:45296 T:48034 P:27624'
G[27670]='K0010 L001 RN A:45966 T:45966'
G[27671]='FA K0010 L001 RN A:47250 T:47250 P:28167'
G[27672]='FA K0390 L035 A:46234 T:46234'
G[27673]='FA K0390 L035 A:46247 T:46247'
G[27674]='FA K0020 L001 RN A:46255 T:42396 P:27635'
G[27675]='FA K0000 L001 A:100062056 T:332,3518,8670,14721,29142,43693'
G[27676]='FA K0390 L035 A:46233 T:46233'
G[27677]='FA K0400 L035 A:2748,46234 T:46234 P:27672'
G[27678]='E21655'
G[27679]='FH K0390 L035 A:46236 T:46236'
G[27680]='FH K0400 L035 A:2748,46236 T:46236 P:27679'
G[27681]='FH K0390 L035 A:46235 T:46235'
G[27682]='FH K0390 L035 A:46241 T:46241'
G[27683]='K0400 L039 A:44456,10840 T:45417 I:27684'
G[27684]='K0400 L039 A:11034 T:45417 I:27683'
G[27685]='K0810 L080 A:41252 T:39667 P:25371'
G[27686]='FH K0000 L001 A:100063276 T:14375,17098,44853,44871,46708'
G[27687]='K0810 L080 A:100062138 T:39884 P:25598'
G[27688]='FA K0850 L084 A:45796 T:45796 P:27652+27654 I:27689'
G[27689]='FH K0850 L084 A:45675 T:45675 P:27653+27655 I:27688'
G[27690]='FH K0840 L084 A:45982 T:46313 P:27606'
G[27691]='K0530 L051 A:46172 T:46172'
G[27692]='K0390 L036 AZ:750 T:12238'	-- TODO: Get location of entrance to Earth Song Falls for proper A:
G[27693]='K0460 L044 A:1206335 T:-17 P:27796'
G[27694]='K0530 L051 A:46071 T:46071 O:27869'
G[27695]='FA K0850 L084 A:45796 T:45796 P:27652+27654 I:27696'
G[27696]='FH K0850 L084 A:45675 T:45675 P:27653+27655 I:27695'
G[27697]='K0340 L032 AZ:750 T:-750,12238'
G[27698]='K0360 L034 AZ:750 T:-750,12238 Z15640'	-- TODO: Set proper A: when entering Foulspore Cavern Entrance
G[27699]='K0810 L080 A:-610 T:46338 P:25657'
G[27700]='FA K0850 L084 A:45796 T:45796 P:27688+27695 I:27701'
G[27701]='FH K0850 L084 A:45675 T:45675 P:27689+27696 I:27700'
G[27702]='FA K0850 L084 A:45796 T:45796 P:27700 I:27703'
G[27703]='FH K0850 L084 A:45675 T:45675 P:27701 I:27702'
G[27704]='K0530 L051 A:46071 T:-130038 P:27694'
G[27705]='K0530 L051 A:-130038 T:-100038 P:27704'
G[27706]='K0830 L083 A:1205874 T:45772 P:27623'
G[27707]='K0830 L083 A:-720,46136 T:0,46136 P:27632'
G[27708]='K0810 L080 A:-610 T:41341 P:25884'
G[27709]='K0460 L044 A:1206336 T:-17 P:27797'
G[27711]='FA K0850 L084 A:45796 T:46243 P:27702+27719+27659+27662 I:27712'	-- TODO: Verify 27662 required
G[27712]='FH K0850 L084 A:45675 T:46243 P:27703+27798+27659+27662 I:27711'	-- TODO: Verify 27662 required
G[27713]='K0470 L044 A:2785 T:2785 O:27927'
G[27714]='K0470 L044 A:2920 T:2920 P:27713'
G[27715]='K0470 L044 A:4618 T:4618 P:27714'
G[27716]='FA K0810 L080 A:100062281 T:40644'
G[27717]='FH K0810 L080 A:100062282 T:40920'
G[27718]='FH K0800 L080 A:1206109,1206116,1207323,1207324 T:41621 I:28816'
G[27719]='FA K0850 L084 A:46413 T:45796 P:27661 I:27798'
G[27720]='FA K0850 L084 A:46243 T:46513 P:27659+27662 O:27711 I:28885'
G[27721]='FH K0800 L080 A:1206109,1206116,1207323,1207324 T:39865'
G[27722]='FH K0820 L082 A:1206109,1206116,1207323,1207324 T:45244'	-- removed M093 because boosted to 100 can get this
G[27724]='FA K0800 L080 M093 A:1206294,1206111,1207320,1207321,1207322 T:36799 I:14481,28827'
G[27725]='FA K0340 L030 A:46476 T:46475 P:26526'
G[27726]='FA K0800 L080 M093 A:1206111,1206294,1207320,1207321,1207322 T:39865'
G[27727]='FA K0820 L082 M093 A:1206111,1206294,1207320,1207321,1207322 T:45226'
G[27729]='K0810 L080 AK:40855 T:0'
G[27733]='FA K0230 L020 A:46417 T:46417'
G[27737]='FA K0240 L020 A:46410 T:46410'
G[27738]='K0830 L083 A:-720,46136 T:46136 P:27707'
G[27739]='FA K0250 L020 A:46409 T:546409,46409'
G[27740]='K0530 L051 A:45948 T:46172 P:27600'
G[27742]='K0850 L084 A:46513 T:46513 P:27720,28885'
G[27743]='K0850 L084 A:46513 T:46513 P:27720,28885'
G[27744]='K0850 L084 A:46671 T:46513 P:27720,28885'	-- TODO: determine if the P is correct
G[27745]='K0850 L084 A:46513 T:46243 P:27742+27743+27744'
G[27746]='FH K0200 L019 A:46124 T:2215 P:27601'
G[27747]='FH K0840 L084 A:46318 T:46318 P:27690'
G[27748]='K0830 L083 A:47158 T:49151 P:28613'
G[27750]='FH K0840 L084 A:46319 T:46319 P:27690'
G[27751]='FH K0840 L084 A:46313 T:46313 P:27690'
G[27752]='FA K0840 L084 A:48010 T:48010'
G[27753]='FA K0840 L084 A:48013 T:48013 O:28369'
G[27754]='FA K0840 L084 A:46591 T:46591'
G[27755]='K0830 L083 A:48501 T:48501 P:28501'
G[27756]='FA K0160 L015 A:46612 T:-756,46612'
G[27757]='K0530 L051 A:46172 T:46172 P:27691'
G[27758]='FA K0160 L015 A:46612 T:-756,46612 P:27756'
G[27760]='K0830 L083 A:100062483 T:1206293'
G[27761]='K0830 L083 A:1206293 T:1206293 P:27760'
G[27762]='K0450 L044 A:48704 T:46650 O:28579,28580'
G[27763]='K0450 L044 A:46650 T:46652 O:27762'
G[27764]='K0450 L044 A:46652 T:46654 P:27774'
G[27765]='K0450 L044 A:46654 T:46654 P:27764'
G[27766]='K0450 L044 A:46654 T:46654 P:27764'
G[27768]='K0540 L051 A:-100038 T:-110038 P:27705'
G[27769]='K0450 L044 A:46654 T:46655 P:27771'
G[27770]='K0450 L044 A:46654 T:46654 P:27765+27766'
G[27771]='K0450 L044 A:46654 T:46654 P:27770'
G[27772]='K0450 L044 A:46655 T:46664 P:27769'
G[27773]='K0540 L051 A:-110038 T:-120038 P:27768'
G[27774]='K0450 L044 A:46652 T:46652 O:27763'
G[27775]='K0450 L044 A:46653 T:46653'
G[27776]='K0450 L044 A:46653 T:46653 P:27775'
G[27777]='K0830 L083 A:1206293 T:1206293 P:27760'
G[27778]='K0830 L083 A:1206293 T:46750 P:27761,27777'
G[27779]='K0830 L083 A:46750 T:46750 P:27778'
G[27781]='FA K0160 L015 A:46612 T:-756,46612 P:27758'
G[27782]='FA K0850 L084 A:46243 T:45796 P:27745 I:27783'
G[27783]='FH K0850 L084 A:46243 T:45675 P:27745 I:27782'
G[27784]='FA K0850 L084 A:45796 T:46717 P:27782 I:27786'
G[27785]='FA K0160 L015 A:46612 T:-756,46612 P:27781'
G[27786]='FH K0850 L084 A:45675 T:46717 P:27783 I:27784'
G[27787]='FA K0850 L084 A:46717 T:45668 P:27784 I:27788'
G[27788]='FH K0850 L084 A:46717 T:45658 P:27786 I:27787'
G[27789]='K0460 L044 A:46664 T:46664 P:27772'
G[27790]='FA K0170 L015 A:-756,46612 T:546612 P:27785'
G[27791]='FA K0460 L044 A:46664 T:46760 P:27789'
G[27792]='FA K0460 L044 A:46760 T:46760 P:27791'
G[27793]='K0460 L044 A:-17 T:-17 P:27693+27709'
G[27794]='FA K0460 L044 A:1206374 T:46664 P:27912'
G[27795]='FA K0540 L052 A:46676 T:46676 P:27821+27822'
G[27796]='FA K0460 L044 A:46760 T:1206335 P:27792'
G[27797]='FA K0460 L044 A:46760 T:1206336 P:27792'
G[27798]='FH K0850 L084 A:46413 T:45675 P:27661 I:27719'
G[27803]='FA K0840 L084 A:46804 T:46804 P:27621'
G[27804]='FA K0840 L084 A:46804 T:46804 P:27621'
G[27805]='FA K0840 L084 A:46814 T:46814 P:27803'
G[27806]='FA K0840 L084 A:46804 T:46805 P:27803+27804'
G[27807]='FA K0840 L084 A:46805 T:46811 P:27806'
G[27808]='FA K0840 L084 A:46805 T:47317 P:27806'
G[27809]='FA K0840 L084 A:46805 T:46850 P:27806'
G[27810]='FA K0840 L084 A:46811 T:46811 P:27807'
G[27811]='FA K0840 L084 A:46812 T:46812 P:27807'
G[27812]='FA K0840 L084 A:46811 T:46805 P:27810+27811'
G[27813]='FA K0840 L084 A:46850 T:46850 P:27809'
G[27814]='FA K0840 L084 A:46806 T:46806 P:27809'
G[27815]='FA K0840 L084 A:46850 T:46805 P:27813+28234'
G[27816]='FA K0840 L084 A:46805 T:546804 P:27812+27815'
G[27817]='FA K0840 L084 A:546804 T:546804 P:27816'
G[27818]='K0530 L051 A:46172 T:46172 P:27757'
G[27819]='E21655'
G[27821]='FA K0540 L052 A:46676 T:46676 O:27870'
G[27822]='FA K0540 L052 A:46676 T:46676 O:27870'
G[27823]='FA K0460 L044 A:2860 T:2860'
G[27824]='FA K0460 L044 A:2860 T:2860 P:27823'
G[27825]='FA K0470 L044 A:46930 T:46930'
G[27826]='FA K0470 L044 A:46664 T:546654 P:27794'
G[27827]='FA K0470 L044 A:546654 T:46852 P:27826'
G[27828]='FA K0470 L044 A:46852,46855 T:46855 P:27827'
G[27829]='FA K0470 L044 A:-17 T:-17,46654 P:27828+27834+27835'
G[27830]='FA K0470 L044 A:-17 T:-17,46654 P:27829'
G[27831]='FA K0470 L044 A:-17 T:46654 P:27830'
G[27832]='FA K0470 L044 A:-17 T:500021 P:27831'
G[27833]='FA K0470 L044 A:46972 T:46972'
G[27834]='FA K0470 L044 A:46853,46856 T:46856 P:27827'
G[27835]='FA K0470 L044 A:46854,46857 T:46857 P:27827'
G[27836]='K0830 L083 A:46135 T:46135 P:27630'
G[27837]='K0830 L083 A:46135 T:46135 P:27630'
G[27838]='K0830 L083 A:46135 T:46135 P:28611'
G[27839]='K0830 L083 A:46134 T:46134 P:28201'
G[27840]='FA K0540 L052 A:18221 T:18221'
G[27841]='HD FH K00016 L001 RG A:46901 T:46901 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27846'
G[27842]='FH K0160 L015 A:46889 T:46889'
G[27843]='FA K0540 L052 A:46676 T:46676 P:27821+27822'
G[27844]='FH K0160 L015 A:46906 T:46906'
G[27845]='FA K0540 L052 A:46676 T:46676 P:27821+27822'
G[27846]='HD FA K00016 L001 RW A:46908 T:46908 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841'
G[27847]='FH K0160 L015 A:46902 T:46902'
G[27848]='FH K0160 L015 A:46889 T:46889 P:27842'
G[27849]='FA K0540 L052 A:46676 T:46676 P:27795+27843+27845'
G[27850]='FH K0170 L015 A:46889 T:46889 P:27848'
G[27851]='FA K0540 L052 A:46676 T:46676 P:27795+27843+27845'
G[27852]='FH K0540 L052 A:7623 T:7623'
G[27853]='FH K0540 L052 A:7623 T:7623'
G[27854]='FH K0540 L052 A:7623 T:7623'
G[27855]='FH K0540 L052 A:7623 T:7623'
G[27856]='FH K0540 L052 A:7623 T:7623'
G[27857]='FH K0540 L052 A:7623 T:7623'
G[27858]='FA K0470 L044 A:500021 T:-17 P:27832'
G[27859]='SP K0470 L044 A:546664 T:546664 P:27930'
G[27860]='FA K0540 L052 A:18221 T:18221'
G[27861]='K0850 L084 I:27862,27863,31206'
G[27862]='K0850 L084 T:72841 I:27861,27863,31206'
G[27863]='K085512 L084 A:46935 T:0 I:27861,27862,31206'	--PM5
G[27864]='FA K085512 L084 A:46935 T:0 P:27863'	--PM5
G[27865]='FH K085512 L084 A:46935 T:0 P:27863'	--PM5
G[27866]='K085512 L084 A:46935 T:0 P:27865,27864'	--PM5
G[27867]='K085512 L084 A:46935 T:0 P:27866'	--PM5
G[27868]='K085512 L084 A:46935 T:0 P:27867'	--PM5
G[27869]='K0530 L051 A:46172 T:46071 P:27818'
G[27870]='FA K0540 L051 A:46071 T:46676 P:27914'
G[27871]='FH K0540 L051 A:46071 T:7623'
G[27872]='E21655'
G[27873]='E21655'
G[27874]='K0810 L080 A:40289,46987,46998 T:41005 P:25611 I:25985'
G[27875]='FA K0550 L053 A:17127 T:17127'
G[27876]='FA K0550 L053 A:17127 T:17127'
G[27877]='FH K0460 L044 A:46759 T:46759'
G[27878]='FH K0460 L044 A:46758 T:46758'
G[27879]='FH K0470 L044 A:46660 T:46660'
G[27880]='FH K0470 L044 A:1068 T:1068'
G[27881]='FH K0460 L044 A:46664 T:46757'
G[27882]='FH K0460 L044 A:46757 T:46757 P:27881'
G[27883]='FH K0460 L044 A:46757 T:1206335'
G[27884]='FH K0460 L044 A:46757 T:1206336'
G[27885]='K0460 L044 A:1206335 T:-17 P:27883'
G[27886]='K0460 L044 A:1206336 T:-17 P:27884'
G[27887]='FH K0460 L044 A:-17 T:-17 P:27885+27886'
G[27888]='FH K0460 L044 A:1206374 T:46664 P:27913'
G[27889]='FH K0470 L044 A:46664 T:46654'
G[27890]='FH K0470 L044 A:46654 T:47011 P:27889'
G[27891]='FH K0470 L044 A:47011,47021 T:47021'
G[27892]='FH K0470 L044 A:47018,47024 T:47024'
G[27893]='FH K0470 L044 A:47013,47022 T:47022'
G[27894]='FH K0470 L044 A:47021,47022,47024 T:46654 P:27891+27892+27893'
G[27895]='FH K0470 L044 A:46654,46860,46917,46938 T:46654 P:27894'
G[27896]='FH K0470 L044 A:46654,46861,46916 T:46654 P:27895'
G[27897]='FH K0470 L044 A:46654 T:500021 P:27896'
G[27898]='FH K0470 L044 A:500021 T:0 P:27897'
G[27899]='K0830 L083 A:47005 T:46978 P:27669'
G[27900]='K0830 L083 A:46978 T:46978 P:27669 O:27899'
G[27901]='K0830 L083 A:46978 T:46978 P:27669 O:27899'
G[27902]='FA K0550 L053 A:17127 T:17127 P:27875+27876'
G[27903]='K0830 L083 A:46978 T:50401 P:27901'
G[27904]='FA K0550 L053 A:17127 T:17127 P:27875'
G[27905]='K0830 L083 A:46978 T:48082 P:27903+27900'
G[27906]='FH K0550 L053 A:7623 T:47041'
G[27907]='FH K0550 L053 A:47041 T:47041'
G[27908]='FH K0550 L053 A:47041 T:47041'
G[27909]='FH K0550 L053 A:47041 T:47041'
G[27910]='FH K0550 L053 A:47041 T:47041'
G[27911]='FH K0550 L053 A:47041 T:47041'
G[27912]='FA K0460 L044 A:-17 T:1206374 P:27793'
G[27913]='FH K0460 L044 A:-17 T:1206374 P:27887'
G[27914]='K0540 L052 A:-120038 T:46071 P:27773'
G[27915]='K0540 L052 A:46071 T:46077 P:27914'
G[27916]='FH K0550 L053 A:47041 T:7623 P:27911'
G[27917]='FA K0180 L016 A:47006 T:547006'
G[27918]='FA K0550 L053 A:18221 T:17127 P:27840+27860'
G[27919]='FA K0550 L054 A:17127 T:9540'
G[27920]='FA K0190 L016 A:547006 T:500226 P:27917'
G[27921]='FA K0200 L016 A:500226 T:500227 P:27920'
G[27922]='K0830 L083 A:46872 T:46872 P:27003'
G[27923]='K0830 L083 A:46872 T:46872 P:27922'
G[27924]='K0830 L083 A:46875 T:46875 P:27922'
G[27925]='K0830 L086 A:100062768 T:47670 P:27669 I:28132'	-- TODO: Does this exist?  Is is Horde only?  -- Note the L086, which is what Blizzard API reports
G[27926]='K0830 L083 A:47670 T:47670 P:27669 O:27925,28132'
G[27927]='K0470 L044 AA:46930 AH:46660 T:2785'
G[27928]='K0830 L083 A:47670 T:47670 P:27926'
G[27929]='FH K0840 L084 A:46313 T:46313 P:27690'
G[27930]='K0470 L044 A:-17 T:1206504 P:27858,27898'
G[27931]='K0820 L081 A:43071 T:47195 P:26484'
G[27932]='K0820 L081 A:47195 T:47195 P:27931'
G[27933]='K0820 L081 A:47195 T:47195 P:27931'
G[27934]='K0820 L081 A:47195 T:0 P:27932+27933'
G[27935]='K0820 L081 A:-640 T:43071 P:27934'
G[27936]='K0820 L081 A:-640 T:43071 P:27934'
G[27937]='K0830 L081 A:43897 T:44204 P:26836'
G[27938]='K0830 L081 A:44204 T:42573 P:27937'
G[27939]='K0830 L083 A:47159 T:47159 P:27926'
G[27940]='K0830 L083 AK:47202 T:0 P:27926'
G[27941]='K0830 L083 A:47670 T:47670 P:27928'
G[27942]='K0830 L083 A:47159 T:47159 P:27939'
G[27943]='K0830 L083 A:47159 T:47159 P:27939'
G[27944]='FA K0852 L085 A:48255 T:48255 I:27948,28683,28684'
G[27945]='FH K0840 L084 A:46324 T:46324 P:27929'	-- TODO: Determine if any required: 27747 27750 27751
G[27946]='K0830 L086 E21655'
G[27947]='FH K0840 L084 A:46323 T:1206569 P:27929'	-- TODO: Determine if any required: 27747 27750 27751
G[27948]='FA K0852 L085 A:48255 T:48255 I:27944,28683,28684'
G[27949]='FA K0852 L085 A:48250 T:48250 I:27966,27967,28689,28690,28691'
G[27950]='K0830 L083 A:47159 T:0 P:27941+27942+27943'
G[27951]='FH K0840 L084 A:1206569 T:1206569 P:27947'
G[27952]='FA K0830 L083 A:42573 T:44799'
G[27953]='FH K0830 L083 A:42573 T:44823'
G[27954]='FH K0840 L084 A:1206569 T:46323 P:27951'
G[27955]='FH K0840 L084 A:46323 T:46323 P:27954'
G[27956]='K0470 L046 A:47269 T:47269'
G[27957]='SP K0470 L046 A:47269 T:47269 P:27956'
G[27958]='K0470 L046 A:47268 T:47268 P:27957'
G[27959]='K0470 L046 A:47280 T:-28 P:B27958'
G[27960]='K0470 L046 A:47267 T:47267'
G[27961]='K0470 L046 A:47267 T:47267 P:27960'
G[27962]='K0470 L046 A:47267 T:47267 P:27960'
G[27963]='K0470 L046 A:47266 T:47266 O:28512,28581,28582'
G[27964]='K0470 L046 A:47266 T:47266 P:27963'
G[27965]='K0480 L046 A:47266 T:14625 P:27957+27958+27961+27962+27964'	-- TODO: G64|Prerequisites|
G[27966]='FA K0852 L085 A:48250 T:48250 I:27949,27967,28689,28690,28691'
G[27967]='FA K0852 L085 A:48250 T:48250 I:27949,27966,28689,28690,28691'
G[27968]='FA K0210 L016 A:500227 T:500228 P:27921'
G[27969]='K0830 L083 A:47159 T:47159 P:27950'
G[27970]='FA K0852 L085 A:48255 T:48255 I:27971,27972,28050,28678,28679,28680,28681'
G[27971]='FA K0852 L085 A:48255 T:48255 I:27970,27972,28050,28678,28679,28680,28681'
G[27972]='FA K0852 L085 A:48255 T:48255 I:27970,27971,28050,28678,28679,28680,28681'
G[27973]='FA K0852 L085 A:48254 T:48254 I:27975,28694,28695'
G[27974]='FH K0180 L016 A:47293 T:547293'
G[27975]='FA K0852 L085 A:48254 T:48254 I:27973,28694,28695'
G[27976]='K0480 L046 A:14627 T:14627 P:27965'
G[27977]='K0480 L046 A:14626 T:14626 P:27965'
G[27978]='FA K0852 L085 A:48254 T:48254 I:27987,27991,28697,28698,28700'
G[27979]='K0480 L046 A:14627 T:14627 P:27976+27977+27982'
G[27980]='K0480 L046 A:14634 T:14634'
G[27981]='K0480 L046 A:14627 T:14627 P:27965'
G[27982]='K0480 L046 A:14626 T:14624 P:27977'	-- there is another P required that is not 28099
G[27983]='K0480 L046 A:47332 T:-28 P:B27977'
G[27984]='K0480 L046 A:8436 T:8436'	-- there is a P: of somesort or maybe Thorium rep
G[27985]='K0480 L046 A:8436 T:-100028 P:27984'
G[27986]='K0490 L046 A:14627 T:47393 P:27979+28099'
G[27987]='FA K0852 L085 A:48254 T:48254 I:27978,27991,28697,28698,28700'
G[27988]='FH K0190 L016 A:547293 T:500027 P:27974'
G[27989]='K0450 L044 A:1206585 T:1206585 P:28100'
G[27990]='K0830 L083 A:47159 T:47940 P:28002'
G[27991]='FA K0852 L085 A:48254 T:48254 I:27978,27987,28697,28698,28700'
G[27992]='FA K0852 L085 A:48250 T:48250 I:28046,28692,28693'
G[27993]='K0830 L083 A:47318 T:44860 P:28112'
G[27994]='K0450 L044 A:1206585 T:1206585 P:28100'
G[27995]='K0460 L044 A:1206585 T:11554 P:27989+27994'
G[27996]='FH K0200 L016 A:500027 T:500028 P:27988'
G[27997]='K0450 L044 A:10923 T:10923 O:28542,28543'
G[27998]='FH K0210 L016 A:500028 T:500029 P:27996'
G[27999]='FA K0840 L084 A:47317 T:46805 P:27808'
G[28000]='K0450 L044 A:47341 T:47341 O:28150'
G[28001]='FA K0840 L084 A:546804 T:46591 P:27817'
G[28002]='K0830 L083 A:47670 T:47670 P:27969'
G[28003]='FH K01564 L015 I:26865,26866,26867'
G[28028]='K0490 L046 A:47393 T:47393 P:27986'
G[28029]='K0490 L046 A:47393 T:47393 P:27986'
G[28030]='K0490 L046 A:47393 T:47393 P:27986'
G[28031]='FA K0410 L038 A:40726 T:47383 P:25542,25561'
G[28032]='K0490 L046 A:47440 T:47440 P:27986'
G[28033]='K0490 L046 A:47393 T:47429 P:28028+28029+28030'
G[28034]='K0490 L046 A:47429 T:47393 P:28033'
G[28035]='K0490 L046 A:47393 T:14625 P:28034'
G[28038]='FH K0850 L084 A:46318 T:46936 P:27929 I:27863'	-- TODO: Determine if any required: 27747 27750 27751
G[28041]='FH K0840 L084 A:46313 T:-700,46313 P:27929'	-- TODO: Determine if any required: 27747 27750 27751
G[28042]='FH K0410 L038 A:40727 T:47383 P:25543,25562'
G[28043]='FH K0840 L084 A:-700,46313 T:47417 P:28041'
G[28044]='K0460 L044 A:47366 T:47341 P:28049'
G[28045]='K0410 L038 A:47383 T:47383 P:28031,28042'
G[28046]='FA K0852 L085 A:48250 T:48250 I:27992,28692,28693'
G[28047]='K0410 L038 A:47383 T:47383 P:28045+28051'
G[28048]='K0420 L038 A:47383 T:47383 P:28045+28051'
G[28049]='K0460 L044 A:47366 T:47366 P:28000'
G[28050]='FA K085514 L085 A:48255 T:48255 I:27970,27971,27972,28678,28679,28680,28681'	-- PM3
G[28051]='K0410 L038 A:47383 T:47383 P:28031,28042'
G[28052]='K0490 L046 A:14625 T:547393 P:28035'
G[28053]='SP K0500 L046 A:547429 T:547429 P:B28064'
G[28054]='K0490 L046 A:547393 T:14628 P:28052'
G[28055]='K0490 L046 A:547393 T:14628 P:28052'
G[28056]='K0490 L046 A:547393 T:14628 P:28052'
G[28057]='K0500 L046 A:14628 T:514626 P:28054+28055+28056'
G[28058]='K0500 L046 A:100062933 T:14628'	-- seems to be triggered by someone doing 28057
G[28059]='FA K0852 L085 A:47240 T:47240 I:28063,28682,28685'
G[28060]='K0500 L046 A:514626 T:514625 P:28057'
G[28061]='K0500 L046 A:514625 T:-28 P:28060'
G[28062]='K0500 L046 A:514625 T:-28 P:28060'
G[28063]='FA K0852 L085 A:47240 T:47240 I:28059,28682,28685'
G[28064]='K0500 L046 A:-28 T:14625 P:28061+28062'
G[28068]='FA K04964 L049 M056 A:1207304 T:45903'
G[28069]='FH K0490 L049 M056 A:1207303 T:45823'
G[28084]='SP FH K0250 L024 A:42028 T:42028 P:26004'
G[28085]='K0440 L038 A:45442 T:47471 P:27329,27330'
G[28086]='K0440 L038 A:47471 T:47471 P:28085'
G[28087]='K0440 L038 A:47471 T:47471 P:28085'
G[28088]='K0440 L038 A:47471 T:47471 P:28086+28087'
G[28089]='FH K0200 L019 AP:44640:C26965+X27098;544640:27098+X27290;45631:27290+X27601;46125:27601 T:2215 P:C26965 I:28096,28571'
G[28090]='FH K0850 L084 A:47492 T:47492 P:27576'
G[28091]='FH K0850 L084 A:47492 T:47492 P:27576'
G[28092]='FH K0850 L084 A:47493 T:47374 P:28097'
G[28093]='FH K0850 L084 A:47374 T:47605 P:28092'	-- does this need 28094 as well?
G[28094]='FH K0850 L084 A:47374 T:47374 P:O28092'
G[28096]='FH K0200 L019 A:2215 T:2215 O:28089,28571'
G[28097]='FH K0850 L084 A:47492 T:47493 P:28090,28091'
G[28098]='K0440 L038 A:47471 T:47471 P:28088'
G[28099]='K0480 L046 A:14625 T:14625 P:27965'
G[28100]='K0460 L044 A:11554 T:1206585'
G[28101]='FA K0850 L084 A:45528 T:47592 P:27507+27508+27509'
G[28102]='K0460 L044 A:9116 T:9116 P:28044'
G[28103]='FA K0850 L084 A:47592 T:47592 P:28101'
G[28104]='FA K0850 L084 A:47592 T:47592 P:28101'
G[28105]='K0830 L083 A:46872 T:46872 P:27922'
G[28106]='E21655'
G[28107]='FA K0850 L084 A:47611 T:47611 P:B28108'
G[28108]='FA K0850 L084 A:47592 T:47611 P:28103+28104'
G[28109]='FA K0850 L084 A:47611 T:47605 P:28108'
G[28111]='FH K0200 L019 A:2215 T:47554 P:28096'
G[28112]='K0830 L083 A:46872 T:47684 P:27923+27924+28105'
G[28113]='K0460 L044 A:47341 T:47341 P:28044'
G[28114]='FH K0200 L019 A:47432 T:47551 P:28096'
G[28115]='FH K0200 L019 A:47432 T:47551 P:28096'
G[28116]='K0460 L044 A:10922 T:51664 O:28152'
G[28117]='FA K0852 L085 A:48039 T:48039,52015'
G[28118]='FA K0852 L085 A:48039 T:48039,52015'
G[28119]='K0460 L044 A:51664 T:51664 P:28116'
G[28120]='FA K0852 L085 A:48039 T:48039,52015'
G[28121]='K0460 L044 A:11019 T:51664'
G[28122]='FA K085514 L085 A:48066 T:48066,52015'	-- PM3
G[28123]='FH K0840 L084 A:47417 T:47417 P:28043'
G[28124]='K0450 L038 A:47471 T:47580 P:28098'
G[28125]='K0450 L038 A:47580 T:47580 P:28124'
G[28126]='K0460 L044 A:51664 T:10922 P:28119+28121'
G[28127]='K0450 L038 A:47580 T:47580 P:28124'
G[28128]='K0460 L044 A:51664 T:11019 P:28119+28121'
G[28129]='K0460 L044 A:51664 T:51664 P:28119+28121'
G[28130]='FA K0852 L085 A:47240 T:47240 I:28137,28686,28687'
G[28131]='K0460 L044 A:-182,51664 T:51664 P:28129'
G[28132]='K0830 L083 A:100062768 T:47670 P:27669 I:27925'
G[28133]='FH K0840 L084 A:47417 T:47671 P:28123'
G[28134]='K0830 L083 A:47684 T:47684 P:28112'
G[28135]='K0830 L083 A:47684 T:45799 P:28134'
G[28136]='K0450 L038 A:47580 T:47580 P:28125+28127'
G[28137]='FA K0852 L085 A:47240 T:47240 I:28130,28686,28687'
G[28138]='FH K0200 L019 A:47554 T:47554 O:28111'
G[28139]='K0450 L038 A:47580 T:47580 P:28125+28127'
G[28140]='K0450 L038 A:47580 T:-61 P:28136+28139'
G[28141]='K0830 L083 A:47715 T:47715 P:28112'
G[28142]='K0450 L038 A:-61 T:47745 P:28140'
G[28144]='FH K0200 L019 A:47554 T:47554'
G[28145]='K0830 L083 A:47715 T:47715 P:28112'
G[28146]='FH K0200 L019 A:47551 T:47551'
G[28147]='FH K0850 L084 A:47723 T:47723'
G[28148]='K0450 L044 A:10921 T:10921'
G[28149]='FH K0850 L084 A:47751 T:47751'
G[28150]='K0460 L044 A:10923 T:47341 P:27995+27997+28148'
G[28151]='FH K0850 L084 A:47723 T:47723 P:28147'
G[28152]='K0460 L044 A:9116 T:10922 P:28113+28102'
G[28153]='K0460 L044 A:-182,51664 T:51664 P:28131'
G[28154]='FH K0200 L019 A:100063090 T:47554'
G[28155]='K0460 L044 A:-182,51664 T:47617 P:28153'
G[28156]='FH K0200 L019 A:47681 T:47554 P:28096'
G[28157]='K0450 L038 A:47745 T:47745 P:28142'
G[28158]='K0450 L038 A:47745 T:47745 P:28142'
G[28159]='K0450 L038 A:47745 T:47745 P:28157+28158'
G[28160]='FA K0450 L038 A:47745 T:40027 P:28159'
G[28161]='FH K0450 L038 A:47745 T:40028 P:28159'
G[28162]='FA K0852 L085 A:48066 T:48066,52015'
G[28163]='FA K0852 L085 A:48066 T:48066,52015'
G[28164]='FH K0200 L020 RG CT A:4606,43870 T:45347'
G[28165]='FA K0852 L085 A:48061 T:48061,52015'
G[28166]='FH K0850 L084 A:47751 T:47751 P:28149'
G[28167]='FA K0010 L001 RN A:45966 T:47250 P:27670'
G[28168]='FH K0210 L019 A:47554 T:47781 P:28144'
G[28169]='FA K0010 L001 RN A:47250 T:46274 P:27671'
G[28170]='FH K0850 L084 A:47751 T:47751 P:28166'
G[28171]='K0850 L084 A:47605 T:47902 P:28758'
G[28172]='FA K0500 L049 A:47779 T:47779 O:28514'
G[28173]='K0850 L084 A:47902 T:47902 P:28171'
G[28174]='FA K0500 L049 A:47811 T:47811 I:28416,26726'
G[28175]='K0850 L084 A:47904 T:47904 P:28171'
G[28176]='K0850 L084 A:47902 T:47905 P:28173+28175+28191'
G[28177]='FA K0500 L049 A:47811 T:47811 P:28174,28416'
G[28178]='FA K0500 L049 A:47811 T:47811 P:28174,28416'
G[28179]='FA K0500 L049 A:47811 T:47811 P:28174,28416'
G[28180]='FA K0500 L049 A:47811 T:14437 P:28177+28178+28179'
G[28181]='FA K0500 L049 A:14437 T:14437 P:28180'
G[28182]='FA K0500 L049 A:14437 T:14437 P:28180'
G[28183]='FA K0500 L049 A:14437 T:47811 P:28181+28182'
G[28184]='FA K0500 L049 A:47811 T:48033 P:28172+28183'
G[28185]='FA K0852 L085 A:48061 T:48061,52015'
G[28186]='FA K0852 L085 A:48061 T:48061,52015'
G[28187]='K0830 L083 A:47940 T:47972 P:27990'
G[28188]='FA K0852 L085 A:48074 T:48074,52015'
G[28189]='FH K0200 L019 A:1206944 T:-24 P:28192'
G[28190]='K0470 L045 A:47692 T:47692'
G[28191]='K0850 L084 A:47902 T:47902 P:28171'
G[28192]='FH K0210 L019 A:47781 T:47781 P:28096 O:28168'
G[28193]='K0830 L083 A:47972 T:47972 P:28187'
G[28194]='K0830 L083 A:47967 T:47967 P:28187'
G[28195]='K0830 L083 A:47972 T:47972 P:28193'
G[28196]='FH K0210 L019 A:100063250 T:47781 P:28192'
G[28197]='FH K0210 L019 A:47781 T:47781 P:28192'
G[28198]='K0830 L083 A:46134 T:46883 P:27631'
G[28199]='FH K0210 L019 A:47899 T:47899 P:28192'
G[28200]='K0830 L083 A:48012 T:48012 P:27631'
G[28201]='K0830 L083 A:46134 T:46134 P:27631'
G[28202]='FA K0500 L049 RF RH A:48001 T:48109 P:28254'
G[28203]='FA K0500 L049 RD RW A:48001 T:48109 P:28254'
G[28204]='FA K0500 L049 RN A:48001 T:48109 P:28254'
G[28205]='FA K0500 L049 RE A:48001 T:48109 P:28254'
G[28206]='FH K0210 L019 A:47781 T:47869 P:28196+28197+28199'
G[28207]='K0470 L044 A:47696 T:47696 O:28305'
G[28208]='K0470 L044 A:47696 T:47696 P:28190+28207'
G[28209]='FH K0210 L019 A:47900 T:47900 P:28206'
G[28210]='K0830 L083 A:46883 T:48022 P:28198'
G[28211]='FA K0840 L084 A:48014 T:48014'	-- TODO: Same req: methinks 27752 and maybe 27753 and/or 27754
G[28212]='FA K0840 L084 A:48014 T:48014'	-- TODO: Same req: methinks 27752 and maybe 27753 and/or 27754
G[28213]='K0470 L044 A:47696 T:47696 P:28208'
G[28214]='K0470 L045 A:47692 T:47692 P:28208'
G[28215]='FA K0840 L084 A:48014 T:48014'	-- TODO: Same req: methinks 27752 and maybe 27753 and/or 27754
G[28216]='FA K0840 L084 A:46591 T:46591,48173 P:27754'	-- TODO: Determine which of 27752 and/or 27753 needed too
G[28217]='K0480 L046 A:47843 T:47923 P:28374'
G[28218]='K0480 L046 A:47923 T:47923 P:28217'
G[28219]='K0480 L046 A:48032 T:48032 P:28229'
G[28220]='K0480 L046 A:48032 T:48032 P:28229'
G[28221]='K0480 L046 A:48042 T:48042 P:28219+28220'
G[28222]='K0480 L046 A:48042 T:48042 P:28219+28220'
G[28223]='FA K0852 L085 A:48074 T:48074,52015'
G[28224]='K0480 L046 A:48042 T:48044 P:28221+28222'
G[28225]='K0500 L049 A:48033 T:48033 P:28184'
G[28226]='K0500 L049 A:48033 T:48033 P:28184'
G[28227]='K0500 L049 A:48033 T:48033 P:28225+28226'
G[28228]='K0480 L046 A:48044 T:0 P:28224'
G[28229]='K0480 L046 A:48126 T:-182 P:28374'
G[28230]='FH K0210 L019 A:48020 T:48020 P:28209'
G[28231]='FH K0210 L019 A:48021 T:548021 P:28209'
G[28232]='FA K0852 L085 A:48074 T:48074,52015'
G[28233]='FA K0840 L084 A:48046 T:48053 P:27809'
G[28234]='FA K0840 L084 A:48053 T:48053 P:28233'
G[28235]='FH K0210 L019 A:48020 T:548020 P:28230+28231'
G[28237]='FH K0210 L019 A:548020 T:547900 P:28235'
G[28238]='FA K0840 L084 A:29611 T:544806 P:27106'
G[28239]='FA K0500 L049 A:48109 T:48085 P:28202,28203,28204,28205'
G[28241]='FA K0840 L084 A:48010 T:1206569 P:27752+27753'
G[28242]='FA K0840 L084 A:1206569 T:1206569 P:28241'
G[28243]='FA K0840 L084 A:1206569 T:48010 P:28242'
G[28244]='FA K0840 L084 A:48010,48175 T:48010,48175 P:28243'	-- TODO: Can 48175 really do this?  what phase?
G[28245]='K0500 L049 A:48085 T:48085 P:28239'
G[28246]='K0500 L049 A:-29,48110 T:-29,48110 P:B28245'
G[28247]='K0850 L084 A:47905 T:47902 P:28176'
G[28248]='FA K0850 L084 A:47902 T:45668 P:28247'
G[28249]='FH K0850 L084 A:47902 T:45658 P:28247'
G[28250]='K0832 L083 A:46603 T:46603'
G[28251]='FH K0220 L020 A:547900 T:2391 P:28237'
G[28252]='K0500 L049 A:48085 T:-29 P:28245'
G[28253]='FA K0500 L049 A:-29,48110 T:48110 P:28246+28252'
G[28254]='FA K0500 L049 A:48109 T:48001 P:28184'	-- P:D28225+D28226 incorrect
G[28256]='K0480 L046 A:47923 T:47923 P:28218'
G[28257]='K0480 L046 A:47923 T:47923 P:28256'
G[28258]='FA K0500 L050 CW A:4087,17120 T:914'
G[28259]='FA K0500 L050 CL A:5173 T:461'
G[28260]='FA K0500 L050 CH A:4138,5115,17122 T:44247'
G[28261]='K0480 L046 A:47923 T:47923 P:28257'
G[28262]='FA K0500 L050 CR A:4214,5165 T:13283'
G[28263]='FA K0500 L050 CW CM A:5146,16749,50690 T:331'	-- TODO: Determine if we should remove the CW because it is supposed to be CM only I would guess
G[28264]='K0480 L046 A:47923 T:47843 P:28261'
G[28265]='FA K0510 L049 A:48109 T:48133 P:28227+28253'
G[28266]='FA K0510 L049 A:48133 T:48133 P:28265'
G[28267]='K0830 L083 A:47972 T:48162 P:28194+28195'
G[28268]='FA K050 L050 RF RD RH CP A:5147,16761,35281 T:928'
G[28269]='K0830 L083 A:48162 T:48186 P:28267'
G[28271]='K0830 L083 A:48186 T:48186 P:28274 O:28353'
G[28272]='K0830 L083 A:48186 T:48186 P:28274'
G[28273]='K0830 L083 A:48186 T:48203 P:28269'
G[28274]='K0830 L083 A:48203 T:48431 P:28273'
G[28275]='FA K0852 L085 A:48254 T:48254'
G[28276]='K0830 L083 A:48022 T:48237 P:28210'
G[28277]='K0830 L083 A:48237 T:48237 P:28276'
G[28278]='FA K0510 L049 A:48133 T:48133 P:28266'
G[28279]='FA K0510 L049 A:-29,48110 T:-29,48110 P:B28278'
G[28280]='FA K0840 L084 A:48174 T:48174 P:28215'
G[28281]='FA K0840 L084 A:48173 T:48173 P:28280'
G[28282]='FA K0840 L084 A:48173 T:48173 P:28281'
G[28283]='FA K0420 L038 A:545277 T:48208 P:27314'
G[28284]='FH K0420 L038 A:545278 T:48208 P:27315'
G[28285]='FA K0500 L050 CT A:11401,11406,16756 T:376'
G[28286]='FA K0510 L049 A:-29,48110 T:48110 P:28279'
G[28287]='FA K0500 L050 CS A:23127,52292 T:20407'
G[28288]='K0460 L044 A:47341 T:47341 P:28113'
G[28289]='K0500 L050 CD AA:4217,44395 AH:3034,44726,44978,52319 T:12042'
G[28290]='FH K0500 L050 CW A:3042,4593,43009 T:3353'
G[28291]='K0830 L083 A:48237 T:46134 P:28277'
G[28292]='FA K0830 L083 A:44799 T:44238 P:27058'
G[28293]='FH K0830 L083 A:44823 T:47571 P:27059'
G[28294]='FA K0840 L084 A:48173 T:48367 P:28282'
G[28295]='FA K0830 L083 A:44238 T:44833 P:28292 I:28558'	-- TODO: Discover the other I:...probably the one where you take the caravan itself
G[28296]='FH K0830 L083 A:47571 T:44833 P:28293 I:28557'
G[28297]='FH K0500 L050 CH A:3039,16674,39116 T:3352'
G[28298]='FH K0500 L050 CR A:4584,16684 T:47233'
G[28299]='FH K0500 L050 CL A:4563,16648,43881 T:3326'
G[28300]='FH K0500 L050 CM A:3047,4566,16653 T:47246'
G[28301]='FH K0500 L050 CS A:3032 T:3344'
G[28302]='FH K0500 L050 RT CP A:20406,43795 T:44725'
G[28303]='FH K0500 L050 RB CP A:16681,20406,43795 T:23128'
G[28304]='FH K0500 L050 RU CT A:3045,4606,16658,43870 T:45339'
G[28305]='K0480 L044 A:47617 T:47696 P:28126+28128+28155'
G[28306]='K0470 L044 A:47696 T:48459 P:28213+28214'
G[28307]='FH K0500 L050 RB CT A:4606,16658,43870 T:45337'
G[28308]='FH K0500 L050 RT CT A:3045,4606,16658 T:44735'
G[28309]='FH K0500 L050 RL CT A:4606,16658 T:45137'
G[28310]='FA K0510 L049 A:48110 T:9177 P:28286'
G[28311]='FA K0510 L049 A:48307 T:48307 P:28310'
G[28312]='FA K0510 L049 A:48307 T:48307 P:28310'
G[28313]='FA K0510 L049 A:48307 T:48307 P:28310'
G[28314]='FA K0510 L049 A:48306,48346 T:48346 P:28311+28312+28313'
G[28315]='FA K0510 L049 A:48306,48346 T:48346 P:28311+28312+28313'
G[28316]='FA K0510 L049 A:48306,48346 T:48292 P:28311+28312+28313'
G[28317]='FA K0510 L049 A:48307 T:48316 P:28326'
G[28318]='FA K0510 L049 A:48307 T:48314 P:28326'
G[28319]='FA K0510 L049 A:48307 T:48312 P:28326'
G[28320]='FA K0520 L049 A:548306 T:48307 P:28327'
G[28321]='FA K0520 L049 A:48307 T:48307 P:28320'
G[28322]='FA K0520 L049 A:48307 T:1207125 P:28321'
G[28323]='FH K0500 L050 RG CT A:3045,4606,16658,43870 T:45347'
G[28324]='FH K0220 L020 A:2391 T:2391 O:28251'
G[28325]='FH K0220 L020 A:2391 T:2391'
G[28326]='FA K0510 L049 A:-29 T:48307 P:28314+28315+28316'
G[28327]='FA K0520 L049 A:-29 T:48307 P:28317+28318+28319'
G[28328]='FA K05064 L050 CT A:376 T:376 O:28285'
G[28329]='FH K0220 L020 A:48319 T:2391'
G[28330]='FH K022512 L020 A:-24,2391 T:2391 P:28329'	-- PM2
G[28331]='FH K0220 L020 A:48129 T:48129'
G[28332]='FH K0220 L020 A:48129 T:48129'
G[28333]='FH K0490 L047 A:48127 T:48127'
G[28334]='FH K0490 L047 A:48127 T:48127'
G[28335]='FH K0490 L047 A:48333 T:1207104'
G[28336]='FH K0490 L047 A:48127 T:48127'
G[28337]='FA K0480 L046 A:48493 T:48493 P:28384'
G[28338]='K0490 L047 A:15395 T:15395 O:28373,28392'
G[28339]='FH K0490 L047 A:48127 T:48127'
G[28340]='FH K0490 L047 A:48333 T:48333'
G[28341]='K0480 L046 A:48339 T:48339'
G[28342]='K0480 L046 A:48339 T:48339'
G[28343]='K0500 L050 CD A:12042 T:12042 O:28289'
G[28344]='FH K0220 L020 A:48129 T:48218 P:28096+28331+28332'
G[28345]='FH K0220 L020 A:48218 T:548218 P:28096 O:28344'
G[28346]='FA K0840 L084 A:48365 T:48364 P:28294'
G[28347]='E21655'
G[28348]='FH K0220 L020 A:548218 T:548218 P:28345'
G[28349]='FH K0030 L001 RG A:34668 T:34874 P:25473'
G[28350]='K0830 L083 A:48431 T:48431 P:28274'
G[28351]='K0830 L083 A:48431 T:48431 P:28274'
G[28352]='K0830 L083 A:48431 T:48431 P:28274'
G[28353]='K0830 L083 A:48431 T:48186 P:28350'
G[28354]='FH K0220 L020 A:548218 T:548218 P:28348'
G[28355]='FH K0220 L020 AK:2372,2373 T:-24'
G[28356]='FH K0220 L020 A:100063686 T:48129'
G[28357]='FH K0490 L047 A:48127 T:48127'
G[28358]='K0480 L046 A:48349 T:48349'
G[28359]='K0480 L046 A:48349 T:48349'
G[28360]='K0480 L046 A:48459 T:48459 O:28306'
G[28361]='K0480 L046 A:48459 T:48459'
G[28362]='K0490 L047 A:48461 T:47556'
G[28363]='K0830 L083 A:48186 T:48431 P:28271+28272'
G[28364]='K0490 L047 A:47556 T:47556 P:28362'
G[28365]='E21655'
G[28366]='K0490 L047 A:15395 T:15395'
G[28367]='K0830 L083 A:48431 T:48186 P:28363'
G[28368]='FH K0490 L047 A:1207104 T:48127 P:28335'
G[28369]='FA K0840 L084 A:46591 T:48013'
G[28370]='FH K0490 L047 A:48127 T:48127 P:28357'
G[28371]='E21655'
G[28372]='FH K0490 L047 A:48469 T:48127'
G[28373]='FH K0490 L047 A:48127 T:15395 P:28368'
G[28374]='K0480 L046 A:48459 T:48459 P:28360+28361'
G[28375]='FH K02332 L020 A:548218 T:48470 P:28354'
G[28376]='K0830 L083 A:100063700 T:48431 P:28367'
G[28377]='FA K0850 L084 A:48364 T:48472 P:28346'
G[28378]='FA K0850 L084 A:48472 T:48472 P:28377'
G[28379]='FA K0850 L084 A:48472 T:48472 P:28377'
G[28380]='FH K0490 L047 A:48127 T:48333 P:28357,28370'
G[28381]='FA K0490 L047 A:48491 T:47931 P:28228+28264'
G[28382]='FA K0490 L047 A:47931 T:47931 O:28381'
G[28383]='FA K0490 L047 A:48492 T:48492'
G[28384]='FA K0490 L047 A:47931 T:48493 P:28382+28383'
G[28385]='FA K0490 L047 A:48493 T:1207104 P:28337'
G[28386]='FA K0490 L047 A:48493 T:48493 P:28337'
G[28387]='FA K0490 L047 A:48493 T:48493 P:28385+28386'
G[28388]='FA K0490 L047 A:48493 T:48493 P:28385+28386'
G[28389]='FA K0490 L047 A:48493 T:47931 P:28387+28388'
G[28390]='K0832 L081 A:44973 T:44973 P:26709+26583+T49362999 I:28391'
G[28391]='K0832 L081 A:43806 T:42466,43806 P:26709+T49362999 I:28390'
G[28392]='FA K0490 L048 A:47931 T:15395 P:28389'
G[28393]='FA K05064 L050 CW A:914 T:914 O:28258'
G[28394]='FA K05064 L050 CH A:44247 T:44247 O:28260'
G[28395]='K0501 L047 A:15395 T:15395 P:28338+28366'
G[28396]='K0501 L044 A:11554 T:11554 P:27995'
G[28397]='FH K0230 L020 A:48470 T:48470 P:28375'
G[28398]='FA K05064 L050 CM A:331 T:331 O:28263'
G[28399]='FA K05064 L050 CL A:461 T:461 O:28259'
G[28400]='FH K0230 L020 A:48503 T:48545 P:28397'
G[28401]='FA K05064 L050 RF RD CS A:20407 T:20407 O:28287'
G[28402]='K0830 L083 A:48186 T:48528 P:28367'
G[28403]='K0830 L083 A:48528 T:48558 P:28402'
G[28404]='K0830 L083 A:48558 T:48558 P:28403'
G[28405]='FA K05064 L050 RF RD RH CP A:928 T:928 O:28268'
G[28406]='FA K05064 L050 CR A:13283 T:13283 O:28262'
G[28407]='FA K0840 L084 A:48472 T:48530 P:28378+28379'
G[28408]='FA K0840 L084 A:48367 T:48367 P:28407'
G[28409]='FA K08432 L084 A:48367 T:48367 P:28407'
G[28410]='FA K0840 L084 A:48367 T:48367 P:28407'
G[28411]='FA K0840 L084 A:48367 T:48367 P:28407'
G[28413]='FA K0840 L084 A:48366 T:48366 P:28407'
G[28414]='K0030 L001 RG A:37106 T:37106 P:24502 I:24503'
G[28415]='FA K0510 L049 A:9177 T:9177 P:28310'
G[28416]='FA K0500 L049 A:47811 T:47811 P:26726 I:28174'
G[28417]='FH K0500 L049 A:47779 T:47779 P:28515'
G[28418]='FH K0500 L049 A:48559 T:48559 P:28667'
G[28419]='FH K0500 L049 A:48559 T:48559'
G[28420]='FH K0500 L049 A:48559 T:48559'
G[28421]='FH K0500 L049 A:48559 T:48559'
G[28422]='FH K0500 L049 A:48559 T:14437 P:28419+28420+28421'
G[28423]='FH K0500 L049 A:14437 T:14437'
G[28424]='FH K0500 L049 A:14437 T:14437 P:28423'
G[28425]='FH K0500 L049 A:14437 T:48559 P:28423,28424'
G[28426]='FH K0500 L049 A:48559 T:48033 P:28425'
G[28427]='FH K0500 L049 A:48568 T:48001'
G[28428]='FH K0500 L049 RO RU A:48001 T:48568'
G[28429]='FH K0500 L049 RT RB A:48001 T:48568'
G[28430]='FH K0500 L049 A:48001 T:48568'
G[28431]='FH K0500 L049 RT RL RB A:48001 T:48568'
G[28432]='FH K0500 L049 A:48568 T:48085 P:28428,28429,28430,28431'
G[28433]='FH K0500 L049 A:48085 T:48085 P:28432'
G[28434]='K0500 L049 A:9176,48099,48100 AH:48568 T:48568 P:28433'
G[28435]='FH K0500 L049 A:48085 T:48111 P:28434'
G[28436]='FH K0500 L049 A:48568 T:48568 P:28434,28435'
G[28437]='FH K0510 L049 A:48568 T:48133 P:28436'
G[28438]='FH K0510 L049 A:48133 T:48133 P:28437'
G[28439]='FH K0510 L049 A:48133 T:48133 P:28438'
G[28440]='FH K0510 L049 A:48568 T:48568'
G[28441]='FH K0510 L049 A:48568 T:48568 P:28440'
G[28442]='FH K0510 L049 A:48568 T:10260 P:28441'
G[28443]='FH K0510 L049 A:48569 T:48569'
G[28444]='FH K0510 L049 A:48569 T:48569'
G[28445]='FH K0510 L049 A:48569 T:48569'
G[28446]='FH K0510 L049 A:48565,48567 T:48567'
G[28447]='FH K0510 L049 A:48565,48567 T:48567'
G[28448]='FH K0510 L049 A:48565,48567 T:48292'
G[28449]='FH K0510 L049 A:-29 T:48569'
G[28450]='FH K0510 L049 A:48569 T:48316'
G[28451]='FH K0510 L049 A:48569 T:48314'
G[28452]='FH K0510 L049 A:48569 T:48312'
G[28453]='FH K0520 L049 A:-29 T:48569'
G[28454]='FH K0520 L049 A:48565 T:48569'
G[28455]='FH K0520 L049 A:48569 T:48569 P:28454'
G[28456]='FH K0520 L049 A:48569 T:1207125 P:28455'
G[28457]='FH K0500 L050 CW A:3353 T:3353 O:28290'
G[28458]='FH K0500 L050 CM A:47246 T:47246 O:28300'
G[28459]='FH K0500 L050 CL A:3326 T:3326 O:28299'
G[28460]='K0500 L049 A:9298 T:9298 P:28524,28544,28545,28768'
G[28461]='FH K0500 L050 CH A:3352 T:3352 O:28297'
G[28462]='K0500 L049 A:100064353 T:9298 Z13329'
G[28463]='FH K0500 L050 CR A:47233 T:47233 O:28298'
G[28464]='K0500 L049 A:9298 T:1207179 O:28462'
G[28465]='FH K0500 L050 CS A:3344 T:3344 O:28301'
G[28466]='FH K0500 L050 RT CP A:44725 T:44725 O:28302'
G[28467]='K0500 L049 A:1176091,1207179 T:9298 P:28464'
G[28469]='K0500 L049 A:9298 T:9298 P:28467'
G[28470]='K0500 L049 A:9298 T:9298 P:28469'
G[28471]='K0500 L049 A:100012842 T:9298 P:C28470'
G[28472]='K0500 L049 A:9298 T:10920 P:28471'
G[28473]='FH K0500 L050 RB CP A:23128 T:23128 O:28303'
G[28474]='FH K0500 L050 RU CT A:45339 T:45339 O:28304'
G[28475]='FH K0500 L050 RB CT A:45337 T:45337 O:28307'
G[28476]='FH K0500 L050 RT CT A:44735 T:44735 O:28308'
G[28477]='FH K0500 L050 RL CT A:45137 T:45137 O:28309'
G[28478]='FH K0500 L050 RG CT A:45347 T:45347 O:28323'
G[28479]='K0510 L049 A:10920 T:48658'
G[28480]='K0840 L083 A:48564 T:48564 P:28623'
G[28481]='E21655'
G[28482]='K0830 L083 A:48621 T:48698 P:28404'
G[28483]='K0840 L083 A:48564 T:48564 P:28623'
G[28484]='FH K0230 L021 A:2437 T:2437'
G[28485]='FH K025512 L021 A:2418 T:2418'	-- PM3
G[28486]='K0840 L083 A:49345 T:49345 P:28623'
G[28487]='FH K0230 L021 A:2419 T:2419'
G[28488]='K0832 L081 A:43805 T:43805 P:26709 I:26710,27048'
G[28489]='FH K0230 L021 A:2397 T:2397'
G[28490]='FA K0100 L009 M013 A:1207321 T:32973 I:26383,26385'
G[28491]='FH K0510 L049 A:10260 T:10260 P:28442'
G[28492]='FA K0200 L019 M023 A:1207321,1207322 T:33187 I:26408'
G[28493]='FH K0200 L019 M023 A:1206109,1206116,1207323 T:8582'
G[28494]='FH K0100 L009 M014 A:1206109,1206116,1207323 T:3337 I:26642,A840'
G[28495]='FH K0230 L021 A:17092 T:17092'
G[28496]='FH K0100 L009 M016 A:1206109,1206116,1207323 T:35086 I:25275,25648'	-- Goblins can do this AND 25275, but not in the quest log at the same time.  to implement this most likely an alias quest will need to handle it.  not for the moment.
G[28497]='K0830 L083 A:48698 T:48698 P:28482'
G[28498]='K0840 L083 A:48761 T:48761 P:28561'
G[28499]='K0840 L083 A:48501 T:48501 P:28561'
G[28500]='K0840 L083 A:48761 T:48761 P:28498+28499'
G[28501]='K0840 L083 A:48761 T:48761 P:28500'
G[28502]='K0840 L083 A:47715 T:47715 P:28141'
G[28503]='FA K0400 L039 M043 A:1207321,1207322 T:39946 I:25479,25481'
G[28504]='FH K0400 L039 M043 A:1206109,1206116,1207323 T:40344'
G[28505]='FA K0350 L034 A:5636 T:44453 I:27158,28576,28749'
G[28506]='FH K0230 L021 A:48545 T:48545 P:28600'
G[28507]='FA K0450 L044 M048 A:1207321,1207322 T:38535 I:27446'
G[28508]='FH K0350 L034 A:42898 T:44452 I:26920,28575,28750'
G[28509]='FH K0450 L044 M048 A:1206109,1206116,1207323 T:38534'
G[28510]='FH K0350 L034 M038 A:1206109,1206116,1207323 T:39377'
G[28511]='FA K0350 L034 M038 A:1207321,1207322 T:40032 I:14410'
G[28512]='K0470 L046 AA:46930 AH:46660 T:47266 I:28581,28582'
G[28513]='K0510 L049 A:48658 T:48658 P:28479'
G[28514]='FA K0500 L049 A:14625 T:47779 I:28666'
G[28515]='FH K0500 L049 A:14625 T:47779'
G[28516]='K0510 L049 E21655'
G[28517]='FA K0100 L008 RW A:42968 T:48736 P:14434'	-- should this P code be here?
G[28518]='K0510 L049 A:48659 T:48659 P:28534'
G[28519]='K0510 L049 A:48660 T:48660 P:28535'
G[28520]='K0840 L083 A:48564 T:47684 P:28480+28483+28486'
G[28521]='K0500 L049 A:15395 T:11556 P:28338+28366'
G[28522]='K0500 L049 A:11556 T:11556'
G[28523]='SP K0521 L049 A:11556 T:11556 P:28522'
G[28524]='K0500 L049 A:11556 T:9298 I:28544,28545,28768'
G[28525]='FA K0500 L049 M053 A:1207321,1207322 T:9270 I:24911'
G[28526]='FH K0500 L049 M053 A:1206109,1206116,1207323 T:9270 I:24911'
G[28527]='FH K0550 L054 M058 A:1206109,1206116,1207323 T:15191 I:28528,28856,28859'
G[28528]='FA K0550 L054 M058 A:1207321,1207322 T:15191 I:28527,28856,28859'
G[28529]='FA K0120 L010 A:100064450 T:32971'
G[28530]='K0500 L049 A:9298 T:9298 P:28467'
G[28531]='FA K0300 L029 M033 A:1207321,1207322 T:36410 I:25938'
G[28532]='FH K0250 L024 M028 A:1206109,1206116,1207323 T:41678'
G[28533]='K0840 L083 A:46134,46135,46136 T:47684 P:27738+27838+28291'
G[28534]='K0510 L049 A:48658 T:48659 P:28513'
G[28535]='K0510 L049 A:48659 T:48660 P:28518'
G[28536]='K0510 L049 A:48660 T:10920 P:28519'
G[28537]='K0510 L049 A:10920 T:10920 P:28536'
G[28538]='FH K0240 L021 A:2278 T:-24,2278 P:28587'
G[28539]='FA K0250 L024 M028 A:1207321,1207322 T:34354'
G[28540]='K0510 L049 A:10307 T:10307'
G[28542]='FH K0450 L044 M048 A:1206109,1206116,1207323 T:10923'
G[28543]='FA K0450 L044 M048 A:1207321,1207322 T:10923'
G[28544]='FA K0500 L049 M053 A:1207321,1207322 T:9298 I:28524,28545,28768'
G[28545]='FH K0500 L049 M053 A:1206109,1206116,1207323 T:9298 I:28524,28544,28768'
G[28548]='FH K0300 L029 M033 A:1206109,1206116,1207323 T:35286'	-- note that this is not incompatible with 26134 as a player has both in their log
G[28549]='FH K0300 L029 M033 A:1206109,1206116,1207323 T:37135 I:26069'
G[28550]='FA K0300 L029 M033 A:1207321,1207322 T:38378'	-- note that you can have both this and 28551
G[28551]='FA K0300 L029 M033 A:1206294,1206111 T:38623'	-- note that you can have both this and 28550
G[28552]='FA K0350 L034 M038 A:1206294,1206111,1207321,1207322 T:23566 I:26702'
G[28553]='FH K0550 L054 A:7623 T:41124 P:27196 I:28671,28858,28865'
G[28554]='FH K0350 L034 M038 A:1206109,1206116,1207323 T:4926 I:25292'
G[28556]='FH K0240 L021 A:48545 T:48545 P:28506'
G[28557]='FH K0840 L083 A:1206109,1206116,1207323,1207324 T:44833 I:28296'	-- removed M087 because boosted to 100 can get this
G[28558]='FA K0840 L083 M100 A:1206294,1206111,1207320,1207321 T:44833 I:28295'
G[28559]='FA K0100 L009 M013 A:1207322 T:17586 I:9625'
G[28560]='FH K0100 L009 M013 A:1207325 T:16197 I:9144'
G[28561]='K0840 L083 A:47684 T:48761 P:28533'
G[28562]='FA K0100 L009 M015 A:1206294,1206111 T:42308 I:26378'	-- TODO: G60|Player level too high|
G[28563]='FA K0150 L014 M018 A:1206294,1206111 T:464 I:26365'
G[28564]='FA K0200 L019 M023 A:1206294,1206111 T:264 I:26728'
G[28565]='FA K020 L019 M023 A:1207320 T:41075 I:26137'
G[28566]='FH K0240 L021 A:-24,2278 T:2278 P:28538'
G[28567]='FA K0100 L009 M013 A:1207320 T:1960 I:26131'
G[28568]='FH K0100 L009 M013 A:1207324 T:44615 I:26964'
G[28569]='FA K0520 L051 A:9177 T:45786 I:28675'
G[28570]='FH K0520 L051 A:10260 T:45786 I:28677'
G[28571]='FH K0200 L019 M023 A:1207324,1207325 T:2215 I:28089'
G[28572]='FH K0250 L024 M028 A:1207324,1207325 T:41949'
G[28573]='FA K0250 L024 M028 A:1207320 T:2700 I:26139'
G[28574]='FH K0300 L029 M033 A:1207324 T:42613'
G[28575]='FH K0350 L034 M038 A:1207324 T:44452 I:26920,28508,28750'
G[28576]='FA K0350 L034 M038 A:1206294,1206111,1207320 T:44453 I:27158,28505,28749'
G[28577]='FH K0400 L039 M043 A:1207324 T:45417'
G[28578]='FA K040 L039 M043 A:1206294,1206111,1207320 T:45417'
G[28579]='FA K0450 L044 M047 A:1206294,1206111,1207320 T:48704'
G[28580]='FH K0450 L044 M048 A:1207324 T:48704'
G[28581]='FH K0490 L047 M051 A:1207324,1207325 T:47266 I:28512,28582'
G[28582]='FA K0480 L047 M053 A:1206294,1206111,1207320 T:47266 I:28512,28581'	-- needs some other I: because level 52 hunter not available
G[28583]='FH K0840 L084 A:46090 T:48993 P:27622'
G[28584]='FH K0840 L084 A:49439 T:49439 P:28583'
G[28586]='FH K0840 L084 A:49441 T:49441 P:28583'
G[28587]='FH K0240 L021 A:48545 T:13817 P:28400'
G[28588]='FH K0840 L084 A:48993 T:48993 P:28583'
G[28589]='FH K0840 L084 A:48993 T:48993 P:28584+28586+28588'	-- TODO: Verify 28586 required
G[28590]='FH K0840 L084 A:48993 T:49378 P:28589'
G[28591]='FH K0840 L084 A:49378 T:49378 P:28590'
G[28592]='FH K0840 L084 A:49379 T:49002 P:28591'
G[28593]='FH K0840 L084 A:49378 T:49000 P:28591'
G[28594]='FH K0840 L084 A:49378 T:49000 P:28591'
G[28595]='FH K0840 L084 A:49000 T:48993 P:28592+28593+28594'
G[28596]='FA K0840 L084 A:49022 T:49022 P:28832'
G[28597]='FA K0840 L084 A:49020,49252 T:49020 P:28596'	-- yes, can accept at either, but only turn in at one.
G[28598]='FA K0840 L084 A:49020 T:549020 P:28597'
G[28599]='FA K0840 L084 A:549020 T:45167 P:28598'
G[28600]='FH K0240 L021 A:13817 T:48545 P:28587'
G[28601]='K0450 L038 E21655'
G[28602]='K0830 L083 A:45296 T:45296 P:27541 I:27517'
G[28603]='FH K0240 L021 A:-24,2278 T:2278 P:28566'
G[28604]='FH K0240 L021 A:49035 T:49035 P:28566'
G[28605]='FH K0240 L021 A:-24,2278 T:2278 P:28603+28604'
G[28607]='SP FH K0051 L001 AP:34874:X14116;534874:14116 TP:34874:X14116;534874:14116 P:C14071+k100046856 I:14116'	-- I:A14121+A14122+A14123+A14124 (put this back when the clearing code is fixed)
G[28608]='FH K0010 L001 RU A:1568 T:1568 P:24959'
G[28609]='K0520 L050 A:11191 T:48965'
G[28610]='K0520 L050 A:48965 T:48965 P:28609'
G[28611]='K0840 L083 A:46135 T:46135 P:27836+27837'
G[28612]='K0830 L083 A:49151 T:49204 P:27748'
G[28613]='K0830 L083 A:48698 T:47158 P:28497'
G[28614]='K0520 L050 A:48722 T:48722'
G[28615]='K0520 L050 A:48723 T:48723'
G[28616]='FH K0240 L021 A:48545 T:48545 P:28556+28605'
G[28617]='K0000 L020 A:49687 T:49687 P:28733'
G[28618]='K0520 L050 A:48965 T:11191 P:28610'
G[28619]='FH K0250 L024 A:1207279 T:41949 P:28572'
G[28620]='FH K0250 L023 A:2229 T:49201'
G[28621]='K0830 L083 A:49204 T:49203 P:28612'
G[28622]='K0830 L083 A:49203 T:49248 P:28621'
G[28623]='K0840 L083 A:48761 T:48564 P:28501'
G[28624]='K0520 L050 A:11192 T:48965 P:28618'
G[28625]='K0520 L050 A:48965 T:48965 P:28624'
G[28626]='K0520 L050 A:48965 T:11192 P:28625'
G[28627]='K0520 L050 A:11193 T:48965 P:28626'
G[28628]='K0520 L050 A:48965 T:11193 P:28632'
G[28629]='K0520 L050 A:10305 T:10305 P:28627'
G[28630]='K0520 L050 A:10305 T:1207291 P:28627'
G[28631]='K0520 L050 A:10305 T:10305 P:28627'	-- ODC:5163 (but we do not have 5163)
G[28632]='K0520 L050 A:48965 T:48965 P:28627'
G[28633]='K0830 L083 A:49248 T:49351 P:28622'
G[28634]='FH K0250 L023 A:49201 T:49201 O:28620'
G[28635]='FH K0250 L023 A:49243 T:49240'
G[28636]='FH K0250 L023 A:49240 T:49243 P:28635'
G[28637]='K0530 L051 A:49436 T:49436'
G[28638]='K0530 L051 A:49537 T:-281,49537'
G[28639]='K0530 L050 A:-281,49436 T:49436 P:28719'
G[28640]='K0530 L051 A:49396 T:49396 O:28718'
G[28641]='K0530 L051 A:-281,49396 T:49396 P:28640'
G[28642]='E21655'
G[28643]='FH K0250 L023 A:49243 T:-24,49243'
G[28644]='FH K0250 L023 A:-24,49243 T:-24,49243 P:28643'
G[28645]='FH K0250 L023 A:-24,49243 T:-24,49243 P:28644'
G[28646]='FH K0250 L023 A:-24,49243 T:-24,49243 P:28645'
G[28647]='FH K0250 L023 A:-24,49243 T:49243 P:28646'
G[28648]='E21655'
G[28649]='K0550 L055 RW CK A:29053 T:29053 P:12738'
G[28650]='K0550 L055 RG CK A:29053 T:29053 P:12738'
G[28651]='FH K0030 L002 RU A:2119,2122,2123,2124,2126,38911 T:1661 P:24964,24965,24966,24967,24968,24969,31147 I:31148'
G[28652]='FH K0010 L001 RU A:1568 T:2307 P:26799'
G[28653]='FH K0020 L001 RU A:1740 T:1569 P:26800'
G[28654]='K08364 L083 A:49351 T:39908 P:28633'
G[28655]='FA K0840 L084 A:48368 T:49358 P:28408+28409+28410+28411'
G[28656]='K0510 L049 A:-281 T:10307 P:I93157,I91082,I91992,I93165,I91991,I93150,I93164'	-- this becomes available once you get one of the "Juju" spell effects
G[28657]='FH K085514 L085 A:48069 T:48069'	-- PM3
G[28658]='FH K0852 L085 A:48069 T:48069'
G[28659]='FH K0852 L085 A:48069 T:48069'
G[28660]='FH K0852 L085 A:48071 T:48071'
G[28661]='FH K0852 L085 A:48071 T:48071'
G[28662]='FH K0852 L085 A:48071 T:48071'
G[28663]='FH K0852 L085 A:48070 T:48070'
G[28664]='FH K0852 L085 A:48070 T:48070'
G[28665]='FH K0852 L085 A:48070 T:48070'
G[28666]='FA K050 L049 M053 A:1206294,1206111,1207320 T:47811 I:28514'	-- needs some other I: because level 52 hunter not available
G[28667]='FH K0500 L049 M053 A:1207324 T:48559'
G[28668]='FH K0852 L085 A:48062 T:48062'
G[28669]='FH K0852 L085 A:48062 T:48062'
G[28670]='FH K0852 L085 A:48062 T:48062'
G[28671]='FH K0550 L054 M058 A:1207324 T:41124 I:28553,28858,28865'
G[28672]='FH K0030 L003 A:1661 T:1570 P:24961'
G[28673]='FA K0550 L054 M058 A:1206294,1206111,1207320 T:5393 I:28857,28867'
G[28674]='K0530 L051 A:48965 T:11079 P:28722'
G[28675]='FA K0520 L051 M058 A:1206294,1206111,1207320 T:45786 I:28569'	-- level 54 rogue cannot get this
G[28676]='K0530 L051 A:11079 T:49407 O:28674'
G[28677]='FH K0520 L051 M055 A:1207324 T:45786 I:28570'
G[28678]='FH K0852 L085 A:48360 T:48360 I:27970,27971,27972,28050,28679,28680,28681'
G[28679]='FH K0852 L085 A:48360 T:48360 I:27970,27971,27972,28050,28678,28680,28681'
G[28680]='FH K0852 L085 A:48360 T:48360 I:27970,27971,27972,28050,28678,28679,28681'
G[28681]='FH K085514 L085 A:48360 T:48360 I:27970,27971,27972,28050,28678,28679,28680'	-- PM3
G[28682]='FH K0852 L085 A:48358 T:48358 I:28059,28063,28685'
G[28683]='FH K0852 L085 A:48360 T:48360 I:27944,27948,28684'
G[28684]='FH K0852 L085 A:48360 T:48360 I:27944,27948,28683'
G[28685]='FH K0852 L085 A:48358 T:48358 I:28059,28063,28682'
G[28686]='FH K0852 L085 A:48358 T:48358 I:28130,28137,28687'
G[28687]='FH K0852 L085 A:48358 T:48358 I:28130,28137,28686'
G[28688]='FH K0250 L024 M028 A:1207324,1207325 T:2464 I:26417'
G[28689]='FH K0852 L085 A:48363 T:48363 I:27949,27966,27967,28690,28691'
G[28690]='FH K0852 L085 A:48363 T:48363 I:27949,27966,27967,28689,28691'
G[28691]='FH K0852 L085 A:48363 T:48363 I:27949,27966,27967,28689,28690'
G[28692]='FH K0852 L085 A:48363 T:48363 I:27992,28046,28693'
G[28693]='FH K0852 L085 A:48363 T:48363 I:27992,28046,28692'
G[28694]='FH K0852 L085 A:48361 T:48361 I:27973,27975,28695'
G[28695]='FH K0852 L085 A:48361 T:48361 I:27973,27975,28694'
G[28696]='FH K0852 L085 A:48361 T:48361'
G[28697]='FH K0852 L085 A:48361 T:48361 I:27978,27987,27991,28698,28700'
G[28698]='FH K0852 L085 A:48361 T:48361 I:27978,27987,27991,28697,28700'
G[28699]='FA K0250 L024 M028 A:1206294,1206111 T:469 I:26838'
G[28700]='FH K0852 L085 A:48361 T:48361 I:27978,27987,27991,28697,28698'
G[28701]='K0530 L051 A:11079 T:11079'
G[28702]='FA K0300 L029 M033 A:1206294,1206111 T:44082'
G[28703]='K0530 L051 A:49407 T:49407'
G[28704]='FH K0300 L029 M033 A:1207324 T:43095'
G[28705]='FH K0600 L058 M062 A:1206109,1206116,1207323,1207324 T:19253 P:9407'
G[28706]='K0530 L051 A:49407 T:49399'
G[28707]='K0530 L051 A:49399 T:49400 P:28706'
G[28708]='FA K0600 L058 M068 A:1206294,1206111,1207320,1207321,1207322 T:19229'	-- needs to have I:B10119
G[28709]='FA K0700 L068 M078 A:1206294,1206111,1207320,1207321 T:25307'
G[28710]='K0530 L051 A:49400 T:49402 P:28707'
G[28711]='FH K0700 L068 M072 A:1206109,1206116,1207323,1207324 T:25273'
G[28712]='K0850 L084 A:47603 T:49417 P:28109,28093'
G[28713]='FA K0020 L001 A:2079 T:2079'
G[28714]='FA K0030 L001 A:2079 T:2079 P:28713'
G[28715]='FA K0030 L001 A:2077 T:2077 P:28713 O:28734'
G[28716]='FA K0840 L084 M093 A:1206294,1206111,1207320,1207321 T:29611'
G[28717]='FH K0840 L084 A:1206109,1206116,1207323,1207324 T:39605'
G[28718]='K0530 L051 A:49402 T:49396 P:28710'
G[28719]='K0530 L051 A:-281,49436 T:-281,49436 P:28637'
G[28722]='K0520 L050 A:10305 T:10305 P:28629,28631'
G[28723]='FA K0030 L002 RE A:3593,3594,3595,3596,3597,43006,63331 T:49479 P:26940,26945,26946,26947,26948,26949,31169'
G[28724]='FA K0030 L003 RE A:49479 T:49479 P:28723'
G[28725]='FA K0030 L001 RE A:49479 T:49480 P:28724'
G[28726]='FA K0040 L003 RE A:549480 T:549480 P:28725'
G[28727]='FA K0040 L003 RE A:549480 T:549480 P:28726'
G[28728]='FA K0050 L003 RE A:549480 T:49479 P:28727'
G[28729]='FA K0050 L003 RE A:49479 T:49479 P:28728'
G[28730]='FA K0050 L003 RE A:49479 T:3514 P:28729'
G[28731]='FA K0050 L003 RE A:3514 T:3515 P:28730'
G[28732]='K0820 L080 A:49444 T:49476'
G[28733]='K0000 L020 A:49687 T:49687'
G[28734]='FA K0030 L001 A:2079 T:2077 P:28714'
G[28735]='K0820 L080 A:49476 T:-753,49476 O:28732'
G[28736]='K0832 L083 A:49523 T:49523 P:28613'
G[28737]='K0820 L080 A:-100753 T:-753,49476'
G[28738]='K0820 L080 A:49476 T:-753'
G[28739]='E21655'
G[28740]='K0820 L080 A:-110753 T:-753 P:28738'
G[28741]='K0820 L080 A:-120753 T:549476 P:28740'
G[28742]='K0530 L051 A:-281,49396 T:49396 P:28641'
G[28743]='K0830 L083 E21655'
G[28744]='K0000 L020 A:49687 T:49687 P:28617'
G[28745]='K0530 L051 A:-281,49537 T:-281,49537 P:28638'
G[28746]='K0830 L083 A:39908 T:39908 P:28654'
G[28747]='K0000 L020 A:49687 T:49687 P:28744'
G[28748]='K0000 L020 A:49687 T:49687 P:28747'
G[28749]='FA K0350 L034 A:49635 T:44453 I:27158,28505,28576'
G[28750]='FH K0350 L034 A:49636 T:44452 I:26920,28508,28575'
G[28751]='K0002 L020 A:49687 T:49687 P:28748 E18414'
G[28753]='K0830 L083 A:539908 T:49941 P:28746'
G[28755]='K0461 L042 A:49856 T:49856 P:27464'
G[28756]='K0421 L040 A:49856 T:49856 P:27464'
G[28757]='FA K0030 L001 RH CM A:197 T:197'
G[28758]='K0850 L084 A:49810 T:47605 P:28712'
G[28759]='K0030 L001 CH A:197 T:197 P:28767'
G[28760]='K0840 L081 A:49943 T:49943 O:28845'
G[28761]='K0000 L001 I:11834'
G[28762]='FA K0030 L001 RH CP A:197 T:197'
G[28763]='FA K0030 L001 RH CT A:197 T:197'
G[28764]='FA K0030 L001 RH CR A:197 T:197'
G[28765]='FA K0030 L001 RH CL A:197 T:197'
G[28766]='FA K0030 L001 RH CW A:197 T:197'
G[28767]='FA K0030 L001 RH CH A:197 T:197'
G[28768]='K0500 L049 A:15395 T:9298 I:28524,28544,28545'
G[28769]='K0030 L001 CM A:197 T:197 P:28757'
G[28770]='K0030 L001 CP A:197 T:197 P:28762'
G[28771]='K0030 L001 CT A:197 T:197 P:28763'
G[28772]='K0030 L001 CR A:197 T:197 P:28764'
G[28773]='K0030 L001 CL A:197 T:197 P:28765'
G[28774]='K0030 L001 CW A:197 T:197 P:28766'
G[28775]='K0000 L001 A:100065896 T:0 P:PJ475'
G[28776]='K0000 L001 A:100065897 T:0 P:PJ475'
G[28777]='K0000 L001 A:100065894 T:0 P:PJ475'
G[28778]='K0000 L001 CW CP CK A:100065895 T:0 P:PJ475'
G[28779]='K0840 L081 A:49943 T:49943 O:28845'
G[28780]='FA K0030 L001 A:43278 T:823 P:26917'
G[28781]='K08564 L083 A:50038 T:50038'
G[28782]='K0530 L051 A:-281,49537 T:49537 P:28745'
G[28783]='K08564 L083 A:50038 T:50038 O:28870'
G[28784]='FA K0030 L001 A:198 T:823 P:26916'
G[28785]='FA K0030 L001 A:925 T:823 P:26918'
G[28786]='FA K0030 L001 A:375 T:823 P:26919'
G[28787]='FA K0030 L001 A:915 T:823 P:26915'
G[28788]='FA K0030 L001 A:459 T:823 P:26914'
G[28789]='FA K0030 L001 A:911 T:823 P:26913'
G[28790]='FH K0800 L080 M080 AZ:321 T:45244'
G[28791]='FA K0030 L001 A:823 T:823 P:28780'
G[28792]='FA K0030 L001 A:823 T:823 P:28784'
G[28793]='FA K0030 L001 A:823 T:823 P:28785'
G[28794]='FA K0030 L001 A:823 T:823 P:28786'
G[28795]='FA K0030 L001 A:823 T:823 P:28787'
G[28796]='FA K0030 L001 A:823 T:823 P:28788'
G[28797]='FA K0030 L001 A:823 T:823 P:28789'
G[28798]='K0002 L001 A:1207406 T:1207406 P:K100063127+PX425'
G[28799]='K0002 L001 A:1207407 T:1207407 P:K100052843+PX425'
G[28800]='K0002 L001 A:1207408 T:1207408 P:K100064397+PX425'
G[28801]='K0002 L001 A:1207409 T:1207409 P:K100064397+PX425'
G[28802]='K0002 L001 A:1207410 T:1207410 P:K100064397+PX425'
G[28803]='K0002 L001 A:1207411 T:1207411 P:K100052843+PX425'
G[28804]='K0002 L001 A:1207412 T:1207412 P:K100052843+PX425'
G[28805]='FH K0800 L080 A:45244 T:45244 P:28790'
G[28806]='FA K0030 L001 A:951 T:951 P:28780'
G[28807]='FA K0840 L084 A:44293 T:332 P:27060,27064'
G[28808]='FA K0030 L001 A:951 T:951 P:28784'
G[28809]='FA K0030 L001 A:951 T:951 P:28785'
G[28810]='FA K0030 L001 A:951 T:951 P:28786'
G[28811]='FA K0030 L001 A:951 T:951 P:28787'
G[28812]='FA K0030 L001 A:951 T:951 P:28788'
G[28813]='FA K0030 L001 A:951 T:951 P:28789'
G[28814]='K0840 L082 A:50048 T:50048 P:28815'
G[28815]='K0840 L082 A:50048 T:50048'
G[28816]='FH K0800 L080 A:45244 T:41621 P:28805 I:27718'
G[28817]='FA K0040 L001 A:823 T:197 P:28791'
G[28818]='FA K0040 L001 A:823 T:197 P:28792'
G[28819]='FA K0040 L001 A:823 T:197 P:28793'
G[28820]='FA K0040 L001 A:823 T:197 P:28794'
G[28821]='FA K0040 L001 A:823 T:197 P:28795'
G[28822]='FA K0040 L001 A:823 T:197 P:28796'
G[28823]='FA K0040 L001 A:823 T:197 P:28797'
G[28824]='K08464 L082 A:42465,43792 T:42465,43792,44025 P:26871'	-- instead of P it could be V of neutral
G[28825]='FA K0800 L080 M080 AZ:301 T:45226'
G[28826]='FA K0800 L080 A:45226 T:45226 O:28825'
G[28827]='FA K0800 L080 M093 A:45226 T:36799 P:28826 I:14481,27724'
G[28828]='K0530 L051 A:49396 T:49396'
G[28829]='K0540 L053 A:50263 T:50263'
G[28830]='K0540 L053 A:50263 T:50263 P:28829'
G[28831]='K0540 L053 A:50263 T:50263 P:28829'
G[28832]='FA K0840 L084 A:544806 T:49022 P:28238'
G[28833]='FH K0820 L080 A:50272 T:40825'
G[28834]='FA K0820 L080 A:50270 T:40825'
G[28836]='FA K0820 L080 A:50270 T:50270'
G[28837]='K0540 L049 A:10929 T:10929 P:28537 O:28847'
G[28838]='K0540 L053 A:10929 T:10929 P:28837'
G[28839]='K0540 L053 A:-281,10929 T:10929 P:28838'
G[28840]='K0540 L053 A:-281,10929 T:10929 P:28839'
G[28841]='K0550 L053 A:10929 T:10929 P:28840'
G[28842]='K0550 L053 A:10929 T:10929 P:28840'
G[28843]='FH K0820 L080 A:50272 T:50272'
G[28845]='K0840 L082 A:45772 T:49943 P:27520+27706+27519'
G[28846]='K0000 L000 T:38935 J:O25024'
G[28847]='K0540 L051 A:50366 T:10929 P:28537+28722'
G[28848]='K0510 L049 A:10920 T:50366 P:28537'
G[28849]='FH K0840 L084 A:42640 T:50367 P:26337+26372+26374'	-- TODO: Verify requires 26374
G[28850]='FA K0030 L001 RW A:50371 T:35077 P:14157'
G[28852]='K08564 L084 A:50390 T:50390'
G[28853]='K08564 L084 A:50385 T:50385'
G[28854]='K08564 L084 A:50387 T:50387'
G[28855]='K0010 L001 J:D26732,D26278'
G[28856]='K0550 L054 A:11118 T:15191 I:28527,28528,28859'
G[28857]='FA K0550 L054 A:11118 T:5393 I:28673,28867'
G[28858]='FH K0550 L054 A:11118 T:41124 I:28671,28553,28865'
G[28859]='K0550 L054 A:38269 T:15191 I:28527,28528,28856'
G[28860]='FA K0842 L084 A:46591 T:46591 P:28655'
G[28861]='FA K0842 L084 A:48010 T:48010 P:28655'
G[28862]='FA K0842 L084 A:48010 T:48010 P:28655'
G[28863]='FA K084514 L084 A:49386 T:49386 P:28655'	-- PM2
G[28864]='FA K0842 L084 A:46591 T:46591 P:28655'
G[28865]='FH K0540 L054 A:50587 T:41124 I:28553,28671,28858'
G[28866]='K08364 L082 A:44010 T:50048 P:27061'
G[28867]='FA K0540 L054 A:50588 T:5393 I:28673,28857'
G[28868]='FA K0070 L005 A:50601 T:50601 P:25839'
G[28869]='FA K0830 L081 A:42469 T:43116 P:26439'
G[28870]='K08564 L083 A:47684 T:50038 P:28520'
G[28871]='FH K0842 L084 A:50622 T:50622 P:28133'
G[28872]='FH K0842 L084 A:46318 T:46318 P:28133'
G[28873]='FH K0842 L084 A:46319 T:46319 P:28133'
G[28874]='FH K0842 L084 A:46318 T:46318 P:28133'
G[28875]='FH K084514 L084 A:49387 T:49387 P:28133'	-- PM2
G[28876]='FH K0200 L019 A:3429 T:8582 P:28493'
G[28877]='FH K0150 L012 A:34698 T:3449 I:29094'
G[28878]='K0000 L010 E21655'
G[28879]='HC K0000 L070 A:33533 T:34365 P:13937+H13959|K100046545|S200033530'
G[28880]='HC K0000 L070 A:33532 T:34365 P:13938+H13960|K100046544|S200033529'
G[28881]='FA K0480 L046 A:39059 T:40109 P:25065'
G[28882]='FA K0904 L090 A:51288 T:51288'
G[28884]='FH K0904 L090 A:51287 T:51287'
G[28885]='FH K0850 L084 A:46243 T:46513 P:27659+27662 O:27712 I:27720'
G[28886]='E21655'
G[28887]='E21655'
G[28888]='E21655'
G[28889]='E21655'
G[28890]='E21655'
G[28895]='E21655'
G[28901]='E21655'
G[28903]='E21655'
G[28904]='E21655'
G[28905]='K0850 L085 E21655'
G[28906]='K0850 L085 E21655'
G[28907]='K0850 L083 E21655'
G[28908]='K0850 L083 E21655'
G[28909]='FH K0840 L084 A:39605 T:42637 P:26294'
G[28910]='SP HM FH K0000 L001 A:1207982 T:1207982'
G[28911]='SP HM FA K0000 L001 A:1207983 T:1207983'
G[28912]='SP HM FH K0000 L001 A:1207984 T:1207984'
G[28913]='SP HM FH K0000 L001 A:1207985 T:1207985'
G[28914]='SP HM FA K0000 L001 A:1207986 T:1207986'
G[28915]='SP HM FH K0000 L001 A:1207987 T:1207987'
G[28916]='SP HM FH K0000 L001 A:1207988 T:1207988'
G[28917]='SP HM FA K0000 L001 A:1207989 T:1207989'
G[28918]='SP HM FA K0000 L001 A:1207990 T:1207990'
G[28919]='SP HM FA K0000 L001 A:1207991 T:1207991'
G[28920]='SP HM FA K0000 L001 A:1207992 T:1207992'
G[28921]='SP HM FH K0000 L001 A:1207993 T:1207993'
G[28922]='SP HM FA K0000 L001 A:51574 T:51574'
G[28923]='SP HM FH K0000 L001 A:51575 T:51575'
G[28924]='SP HM FH K0000 L001 A:51582 T:51582'
G[28925]='SP HM FA K0000 L001 A:51585 T:51585'
G[28926]='SP HM FA K0000 L001 A:51586 T:51586'
G[28927]='SP HM FH K0000 L001 A:51587 T:51587'
G[28928]='SP HM FA K0000 L001 A:51588 T:51588'
G[28929]='SP HM FA K0000 L001 A:51602 T:51602'
G[28930]='SP HM FH K0000 L001 A:51603 T:51603'
G[28931]='SP HM FH K0000 L001 A:51604 T:51604'
G[28932]='SP HM FA K0000 L001 A:51606 T:51606'
G[28933]='SP HM FH K0000 L001 A:51607 T:51607'
G[28934]='HA FA K0002 L081 M100 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28935'
G[28935]='HA FH K0002 L081 M100 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934'
G[28936]='K0300 L028'
G[28937]='K0300 L028'
G[28938]='E21655'
G[28939]='K0300 L028 P:29040'
G[28940]='K0300 L028'
G[28943]='SP HM FH K0000 L001 A:1208089 T:1208089'
G[28944]='SP HM FA K0000 L001 A:1208090 T:1208090'
G[28945]='SP HM FA K0000 L001 A:51650 T:51650'
G[28946]='SP HM FH K0000 L001 A:51651 T:51651'
G[28947]='SP HM FH K0000 L001 A:1208093 T:1208093'
G[28948]='SP HM FA K0000 L001 A:1208094 T:1208094'
G[28949]='SP HM FH K0000 L001 A:51652 T:51652'
G[28950]='SP HM FA K0000 L001 A:51653 T:51653'
G[28951]='SP HW FA K00016 L001 A:1208115 T:1208115'
G[28952]='SP HW FA K00016 L001 A:1208116 T:1208116'
G[28953]='SP HW FH K00016 L001 A:1208117 T:1208117'
G[28954]='SP HW FA K00016 L001 A:1208120 T:1208120'	-- Arathi Highlands, Refuge Point
G[28955]='SP HW K00016 L001 A:1208137 T:1208137'
G[28956]='SP HW FA K00016 L001 A:1208121 T:1208121'
G[28957]='SP HW FH K00016 L001 A:1208143 T:1208143'
G[28958]='SP HW FH K00016 L001 A:1208118 T:1208118'
G[28959]='SP HW FH K00016 L001 A:1208144 T:1208144'
G[28960]='SP HW FA K00016 L001 A:1208122 T:1208122'
G[28961]='SP HW FA K00016 L001 A:1208123 T:1208123'	--  I:28997 removed because it causes headaches with current implementation
G[28962]='SP HW FH K00016 L001 A:1208145 T:1208145'
G[28963]='SP HW FA K00016 L001 A:1208124 T:1208124'
G[28964]='SP HW FA K00016 L001 A:1208125 T:1208125'
G[28965]='SP HW K00016 L001 A:1208138 T:1208138'
G[28966]='SP HW FH K00016 L001 A:1208146 T:1208146'
G[28967]='SP HW K00016 L001 A:1208139 T:1208139'
G[28968]='SP HW FA K00016 L001 A:1208126 T:1208126'
G[28969]='SP HW FH K00016 L001 A:1208147 T:1208147'
G[28970]='SP HW FA K00016 L001 A:1208127 T:1208127'
G[28971]='SP HW FH K00016 L001 A:1208148 T:1208148'
G[28972]='SP HW FH K00016 L001 A:1208149 T:1208149'
G[28973]='SP HW FH K00016 L001 A:1208150 T:1208150'
G[28974]='SP HW FH K00016 L001 A:1208151 T:1208151'
G[28975]='SP HW FH K00016 L001 A:1208152 T:1208152 P:26830'	-- Basically when one gets 28640 and returns, one sees the candy bucket available
G[28976]='SP HW FH K00016 L001 A:1208153 T:1208153'
G[28977]='SP HW FA K00016 L001 A:1208128 T:1208128'
G[28978]='SP HW FA K00016 L001 A:1208130 T:1208130'
G[28979]='SP HW FA K00016 L001 A:1208131 T:1208131'
G[28980]='SP HW FA K00016 L001 A:1208129,500022 T:1208129,500022'
G[28981]='SP HW K00016 L001 A:1208141 T:1208141'
G[28982]='SP HW K00016 L001 A:1208142 T:1208142'
G[28983]='SP HW FA K00016 L001 A:1208133 T:1208133'
G[28984]='SP HW FH K00016 L001 A:1208154 T:1208154'
G[28985]='SP HW FA K00016 L001 A:1208132 T:1208132'
G[28986]='SP HW FH K00016 L001 A:1208155 T:1208155'
G[28987]='SP HW FH K00016 L001 A:1208156 T:1208156'
G[28988]='SP HW FA K00016 L001 A:1208134 T:1208134'
G[28989]='SP HW FH K00016 L001 A:1208119 T:1208119'
G[28990]='SP HW FA K00016 L001 A:1208136 T:1208136'
G[28991]='SP HW FA K00016 L001 A:1208135 T:1208135'
G[28992]='SP HW FH K00016 L001 A:1208140 T:1208140'
G[28993]='SP HW K00016 L001 A:1208157 T:1208157'
G[28994]='SP HW K00016 L001 A:1208158 T:1208158'
G[28995]='SP HW FA K00016 L001 A:1208159 T:1208159'
G[28996]='SP HW FH K00016 L001 A:1208160 T:1208160'
G[28998]='SP HW FH K00016 L001 A:1208161 T:1208161'
G[28999]='SP HW K00016 L001 A:1208162 T:1208162'
G[29000]='SP HW K00016 L001 A:1208163 T:1208163'
G[29001]='SP HW K00016 L001 A:1208164 T:1208164'
G[29002]='SP HW FH K00016 L001 A:1208165 T:1208165'
G[29003]='SP HW FH K00016 L001 A:1208166 T:1208166'
G[29004]='SP HW FH K00016 L001 A:1208167 T:1208167'
G[29005]='SP HW FH K00016 L001 A:1208168 T:1208168'
G[29006]='SP HW FA K00016 L001 A:1208169 T:1208169'
G[29007]='SP HW FA K00016 L001 A:1208170 T:1208170'
G[29008]='SP HW FA K00016 L001 A:1208171 T:1208171'
G[29009]='SP HW FH K00016 L001 A:1208172 T:1208172'
G[29010]='SP HW FA K00016 L001 A:1208173 T:1208173'
G[29011]='SP HW FA K00016 L001 A:1208174 T:1208174'
G[29012]='SP HW FA K00016 L001 A:1208175 T:1208175'
G[29013]='SP HW FA K00016 L001 A:1208176 T:1208176'
G[29014]='SP HW K00016 L001 A:1208177 T:1208177'
G[29015]='FH K0160 L010 A:34674 T:34674 P:14004'
G[29016]='SP HW K00016 L001 A:1208178 T:1208178'
G[29017]='SP HW K00016 L001 A:1208179 T:1208179'
G[29018]='SP HW K00016 L001 A:1208180 T:1208180'
G[29019]='SP HW FH K00016 L001 A:1208181 T:1208181'
G[29020]='SP HW FA K00016 L001 A:1208183 T:1208183'
G[29021]='FH K0160 L014 A:3442 T:1004141'	-- I:894 TODO: Verify the whole Samophlange chain to see if the server marks other quests complete as well (probably to handle those that did this ages ago)
G[29022]='FH K0160 L014 A:1004141 T:1004141 P:29021'
G[29023]='FH K0160 L014 A:1004141 T:1004141 P:29022'
G[29024]='FH K0160 L014 A:1004141 T:3442 P:29023'
G[29026]='FH K0160 L014 A:34674 T:9316 P:14003'
G[29027]='FH K0160 L014 A:9316 T:9316 P:29026'
G[29029]='K0460 L044'
G[29030]='HM K0000 L001 A:51682 T:1208184'
G[29031]='SP HM K0000 L001 A:51697 T:1208187'
G[29032]='FA K0000 L050 A:10618 T:10618'
G[29034]='FA K0000 L050 A:10618 T:10618 P:29032'
G[29035]='K0002 L050 RE RD RN RW A:51677 T:51677 P:B29034 I:29037,29038,29040'
G[29036]='SP HM K0000 L001 A:51698 T:1208188'
G[29037]='K0002 L050 RE RD RN RW A:51677 T:51677 P:B29034 I:29035,29038,29040'
G[29038]='K0002 L050 RE RD RN RW A:51677 T:51677 P:B29034 I:29035,29037,29040'
G[29039]='K0002 L050 RF RW RH A:51677 T:51677 P:B29034 I:29051,29052,29053'
G[29040]='K0002 L050 RE RD RN RW A:51677 T:51677 P:B29034 I:29035,29037,29038'
G[29041]='E21655'
G[29051]='K0002 L050 RF RW RH A:51677 T:51677 P:B29034 I:29039,29052,29053'
G[29052]='K0002 L050 RF RW RH A:51677 T:51677 P:B29034 I:29039,29051,29053'
G[29053]='K0002 L050 RF RW RH A:51677 T:51677 P:B29034 I:29039,29051,29052'
G[29054]='HW FA K0002 L001 A:51934 T:51934'
G[29063]='E21655'
G[29065]='E21655'
G[29066]='K0810 L080 A:-606,39933 T:39928 P:25428'	-- there needs to be an I: for this since Nimhfree cannot get it [basically did 25428 before this quest existed]
G[29067]='K0000 L001 AA:5177,5499,16723,4160 AH:3347,3009,4611,16642 TA:5177,5499,16723,4160 TH:3347,3009,4611,16642 P:PA475'
G[29070]='E21655'
G[29071]='SP FA K0800 L080 M080 A:1208316 T:0'
G[29073]='SP FH K0800 L080 M080 A:1208317 T:0'
G[29074]='HW FA K0000 L001 A:18927,518927,500091,500092,500093,500094,500095,19148,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:51665'
G[29075]='HW FA K0002 L001 A:51665 T:51665'
G[29076]='E21655'
G[29078]='FA K0030 L001 SH A:197 T:197'
G[29079]='FA K0030 L001 A:197 T:197 P:29078'
G[29080]='FA K0030 L001 A:197 T:823 P:29079'
G[29081]='FA K0030 L001 A:823 T:823 P:29080'
G[29082]='FA K0030 L001 A:951 T:951 P:29080'
G[29083]='FA K0040 L001 A:823 T:197 P:29081'
G[29084]='K0450 L035 E21655'
G[29085]='K0450 L035 E21655'
G[29086]='FH K0160 L014 A:3442 T:3442'
G[29087]='FH K0160 L014 A:34698 T:-11'
G[29088]='FH K0160 L014 A:34698 T:34698'
G[29089]='FH K0160 L014 A:-11,34698 T:34698 P:29087'
G[29090]='FH K0160 L014 A:52192 T:52192'
G[29091]='K0170 L015'
G[29092]='HM K0000 L016 A:25324 T:26221 P:11891'
G[29093]='HC K0000 L010 A:14305 T:500007 P:1468'
G[29094]='FH K0160 L014 A:3442 T:3449 P:29015+29086 I:28877'
G[29095]='FH K0160 L014 A:3449 T:3429 P:876'
G[29096]='K0170 L015 E21655'
G[29097]='K0170 L015 E21655'
G[29099]='K0170 L015 E21655'
G[29100]='FA K0850 L085 A:52654 T:52234'
G[29101]='K0852 L085 A:52671 T:0,52671 P:29198 I:29125,29147,29161,29164'
G[29102]='FA K0850 L085 A:52654 T:52281 P:B29100'
G[29103]='FA K0850 L085 A:52281 T:52281 P:29102'
G[29104]='FA K0850 L085 A:52234 T:52234 P:29103'
G[29105]='FA K0850 L085 A:52281 T:52294 P:29104'
G[29106]='HC FA K0000 L010 A:14305 T:500006 P:1468'
G[29107]='HC FA K0000 L010 A:14305 T:514305 P:1468'
G[29108]='E21655'
G[29109]='FH K0170 L015 A:3429 T:52207 P:29095'
G[29110]='FH K0170 L015 A:52207 T:52309 P:29109'
G[29111]='FH K0170 L015 A:52207 T:8582 P:29112'
G[29112]='FH K0170 L015 A:52309 T:52207 P:29110'
G[29114]='FA K0850 L085 A:52294 T:52346 P:29105'
G[29115]='FA K0850 L085 A:52346 T:-37 P:29114'
G[29116]='FA K0850 L085 A:-37 T:52234 P:29115'
G[29117]='HC FA K0000 L010 A:14305 T:14305 P:29093+29106+29107'	-- Craggle Wobbletop wanders up and down 
G[29119]='HC FA K0000 L010 A:14305 T:500008 P:29093+29106+29107'
G[29120]='FA K0850 L085 A:52234 T:52234 P:29116'
G[29121]='FA K0850 L085 A:52371 T:52371 P:29213'
G[29122]='K0852 L085 A:52671,-606 T:52671 P:29101'
G[29123]='K0852 L085 A:52669 T:52669 P:29198 I:29127,29149,29163,29166,29246,29247,29248'	-- It appears that only one of 29123, 29127, 29149 and 29163 will be given each day.  However, you can have more than one of them in the quest log at the same time.  The I: cannot handle this situation properly.  Therefore, it is probably better to err on the side of showing the possibility instead of denying it. ***** 29163 is NOT invalidated with 29201, so I am guessing all four of them are not! ***** ***** I have a player that has both 29101 and 29147 in the log at the same time.  29101 was from the day earlier. *****
G[29124]='FA K0850 L085 A:52234 T:52410 P:29121'
G[29125]='K0852 L085 A:52669 T:0,52669 P:29198 I:29101,29147,29161,29164'
G[29126]='K0852 L085 A:52669,-606 T:52669 P:29125'
G[29127]='K0852 L085 A:52669 T:52669 P:29198 I:29123,29149,29163,29166,29246,29247,29248'	-- TODO: Determine whether any of the new stuff needs P: as well
G[29128]='K0852 L085 A:553073 T:52824 P:29201'
G[29129]='FH K0850 L085 A:52382 T:15192 P:29452'
G[29131]='FA K0850 L085 A:52410 T:52410 P:29124'
G[29132]='FA K0850 L085 A:52408 T:15192 P:29453'
G[29133]='FA K085 L085 A:52753 T:552234 P:29131'
G[29134]='K0850 L085 A:15192 T:15192 P:29129,29132'
G[29135]='K0850 L085 A:15192 T:15192 P:29134'
G[29137]='K0852 L085 A:52824 T:52824 P:29201 I:29141,29142,29304'
G[29138]='K0852 L085 A:553080,53080 T:553080 P:29201'
G[29139]='K0852 L085 A:52467 T:52467 P:29201 I:29143'
G[29141]='K0852 L085 A:52824 T:52824 P:29201 I:29137,29142,29304'
G[29142]='K0852 L085 A:52824 T:52824 P:29201 I:29137,29141,29304'
G[29143]='K0852 L085 A:52467 T:52467 P:29201 I:29139'
G[29144]='HW FA K000258 L001 A:51934 T:51934'
G[29145]='K0850 L085 A:52669 T:52838 P:25372 O:29387,29388,29389'
G[29146]='HC K00016 L010 A:14444 T:514444 P:172'
G[29147]='K0852 L085 A:52669 T:0,52669 P:29198 I:29101,29125,29161,29164'
G[29148]='K0852 L085 A:-606,52669 T:52669 P:29147'
G[29149]='K0852 L085 A:52669 T:52669 P:29198 I:29123,29127,29163,29166,29246,29247,29248'
G[29150]='FA K0850 L085 A:552234 T:552234 P:29133'
G[29151]='FA K0850 L085 A:552234 T:552234 P:29150'
G[29152]='FA K0850 L085 A:52646 T:52767 P:29151'
G[29153]='FA K0851600 L085 A:2496 T:53151 P:29152+T01544999 I:29154'	-- PM5
G[29154]='FA K0851600 L085 A:53151 T:72841 P:29152+U01544999 I:29153'	-- PM5
G[29155]='FA K0850 L085 A:2496,53151 T:1208420 P:29153,29154'
G[29156]='FA K0850 L085 A:1206111,1206294,1207320,1207321,1207322 T:53352'
G[29157]='FH K0850 L085 A:1206109,1206116 T:53081'
G[29159]='K0852 L085 A:52921 T:52921 P:29205'
G[29160]='K0852 L085 A:52921 T:52921,52476 P:29205 I:29189'
G[29161]='K0852 L085 A:52671 T:0,52671 P:29198 I:29101,29125,29147,29164'
G[29162]='K0852 L085 A:52671,-606 T:52671 P:29161'
G[29163]='K0852 L085 A:52669 T:52669 P:29198 I:29123,29127,29149,29166,29246,29247,29248'
G[29164]='K0852 L085 A:52669 T:0,52669 P:29198 I:29101,29125,29147,29161'
G[29165]='K0852 L085 A:-606,52669 T:52669 P:29164'
G[29166]='K0852 L085 A:52669 T:52669 P:29198 I:29123,29127,29149,29163,29246,29247,29248'
G[29167]='HC K00016 L010 A:14444 T:500043 P:172'
G[29168]='E21655'
G[29169]='K0850 L085 E21655'
G[29170]='E21655'
G[29171]='E21655'
G[29172]='K085512 L085 A:53023 T:53023'	-- PM5
G[29173]='K0851600 L085 A:53023 T:53023'	-- PM5
G[29174]='K0850 L085 E21655'
G[29175]='K0851600 L085 A:53023 T:53023'	-- PM5
G[29176]='HC K00016 L010 A:14444 T:500042 P:172'
G[29177]='K0812 L080 A:40578 T:40578 P:25560'
G[29178]='E21655'
G[29179]='K0852 L085 A:52824 T:52824 P:29201'
G[29180]='E21655'
G[29181]='K0850 L085 A:52135 T:50082 P:H29137,H29138,H29139,H29141,H29142,H29143,H29179,H29304'
G[29182]='K0850 L085 A:52669 T:52490 P:29181'	-- TODO: Did not show up the first day after 29181 was done
G[29183]='K0850 L085 E21655'
G[29185]='K0850 L085 E21655'
G[29186]='K08564 L085 A:52925 T:552925'
G[29189]='K0852 L085 A:52921 T:52921,52476 P:29205 I:29160'
G[29190]='HC FH K0000 L010 A:14444 T:14444 P:29146+29167+29176'
G[29191]='HC FH K0000 L010 A:14444 T:14444 P:29146+29167+29176'
G[29192]='K0852 L085 A:52494 T:52494 P:29205 I:29211'
G[29193]='K0850 L085 A:15192 T:52835 P:29135'
G[29194]='K08564 L085 A:52835 T:53567 P:29193'
G[29195]='K0850 L085 A:52838 T:52845 P:29145'
G[29196]='K0850 L085 A:52845 T:52669 P:29195'
G[29197]='K0850 L085 A:52669 T:52838 P:29196'
G[29198]='K0850 L085 A:52838 T:552845 P:29197'
G[29199]='K0850 L085 A:552838 T:552838 P:29198'
G[29200]='K0850 L085 A:552838 T:52669 P:29199'
G[29201]='K0850 L085 A:552845 T:53385 P:29200'
G[29202]='K0850 L085 A:52669 T:52986 P:29201'
G[29203]='K0850 L085 A:52135 T:52135 P:29279'
G[29204]='K0852 L085'
G[29205]='K0852 L085 A:52824 T:52494 P:29214+29138+29137|29141|29142|29304+29139|29143+29179 I:29206'
G[29206]='K0852 L085 A:52824 T:52444 P:29181+29138+29137|29141|29142|29304+29139|29143+29179 I:29205'
G[29209]='K0852 L085'
G[29210]='K0852 L085 A:52494 T:52823,552823 P:29192,29211'
G[29211]='K0852 L085 A:52494 T:52494 P:29205 I:29192'
G[29212]='E21655'
G[29213]='FA K0850 L085 A:52234 T:52371 P:29120'
G[29214]='K0850 L085 A:52135 T:52844 P:H29137,H29138,H29139,H29141,H29142,H29143,H29179,H29304'
G[29215]='K0850 L085 A:52669 T:52493 P:29214'	-- became available the day after it seems, unless I missed it for some reason
G[29216]='E21655'
G[29217]='K08564 L085 A:52933 T:52933'
G[29218]='K0850 L085'
G[29219]='FH K0850 L085 A:53081'
G[29220]='FH K0850 L085 A:53081'
G[29225]='K0850 L085 A:53567 T:52995 P:29194'
G[29228]='K0850 L085 E21655'
G[29234]='K085128 L085 A:52995 T:53009 P:29225'
G[29239]='K0850 L085 A:53009 T:54233 P:29234'
G[29240]='K0850 L085 A:53009 T:53149 P:29239'
G[29241]='K0851600 L085 A:53024 T:53024'	-- PM5
G[29242]='K0851600 L085 A:53043 T:53043'	-- PM5
G[29243]='K0852 L085 A:53056 T:52493 P:29210+29214+29283'
G[29245]='K0850 L085 A:1208535 T:52489 P:29214'	-- TODO: Deal with the fact that this only appears after killing 52122
G[29246]='K0852 L085 A:52986 T:52986 P:29198 I:29123,29127,29149,29163,29166,29247,29248'
G[29247]='K0852 L085 A:52986 T:52986 P:29198 I:29123,29127,29149,29163,29166,29246,29248'
G[29248]='K0852 L085 A:52986 T:52986 P:29198 I:29123,29127,29149,29163,29166,29246,29247'
G[29249]='K0850 L085 A:52489 T:-795,52489 P:29245'
G[29251]='FH K0851600 L085 A:2496 T:2496 P:1+T01544999 I:29252'	-- PM5
G[29252]='FH K0851600 L085 A:53151 T:53151 P:1+U01544999 I:29251'	-- PM5
G[29253]='FH K0850 L085 A:2496,53151 T:1208420 P:29251,29252'
G[29254]='K0850 L085 A:52489 T:52489 P:29249'
G[29255]='K0852 L085 A:52489 T:52489 P:29254 I:29257,29299'
G[29257]='K0852 L085 A:52489 T:52489 P:29254 I:29255,29299'
G[29258]='K0852 L085'
G[29261]='SP K00065 L001 A:1208549 P:K100063128+PX425'
G[29262]='SP K0001089 L001 A:1208550 P:K100063128+PX425'
G[29263]='K0852 L085 A:53196 T:53214 P:29281 I:29278,29295,29297'
G[29264]='K0852 L085 A:52444 T:52444 P:29206'
G[29265]='K0852 L085 A:52444 T:52492,52467 P:29206'
G[29266]='E21655'
G[29267]='SP FA K0850 L085 A:52374 T:52374 P:29121'
G[29269]='K0850 L085 A:53149 T:53210 P:29240'
G[29270]='K085128 L085 A:53210 T:53215 P:29269'
G[29271]='E21655'
G[29272]='K08532 L085 A:53233 T:52477 P:29181'
G[29273]='K0852 L085 A:52477 T:552478 P:29206+29272 I:29274'
G[29274]='K0852 L085 A:500019,52478 T:500016,52477,552477 P:29206+29272 I:29273'	-- TODO: Check if all 52477 can be handled by 552477 as well, and 500016
G[29275]='K0852 L085 A:500017,52478 T:500016,52477 P:29192+29272,29211+29272 I:29276'
G[29276]='K0852 L085 A:500018,52477 T:552478 P:29205+29272 I:29275'
G[29277]='E21655'
G[29278]='K0852 L085 A:53196 T:53214 P:29281 I:29263,29295,29297'
G[29279]='K0850 L085 A:53881 T:52669 P:29181+29214'
G[29280]='K0850 L085 A:52669 T:53881 P:29279'
G[29281]='K0850 L085 A:53214 T:52669 P:29181+29214'
G[29282]='K0850 L085 A:52669 T:53196 P:29281'
G[29283]='K0850 L085 A:53882 T:52906 P:29181+29214'
G[29284]='K0850 L085 A:52669 T:52488 P:29283'
G[29285]='K0850 L085 A:53215 T:53349 P:29270'
G[29286]='E21655'
G[29287]='K0852 L085 A:52491 T:52491 P:29265 I:29288,29289,29290'
G[29288]='K0852 L085 A:52491 T:52490,52491 P:29265 I:29287,29289,29290'
G[29289]='K0852 L085 A:52491 T:52491 P:29265 I:29293,29296'
G[29290]='K0852 L085 A:52491 T:52491,52490 P:29265 I:29287,29288,29289'
G[29291]='K0852 L085'
G[29292]='K0852 L085'
G[29293]='K0852 L085 A:53259 T:53259,52467 P:29265 I:29289,29296'
G[29294]='E21655'
G[29295]='K0852 L085 A:53304 T:53214 P:29265 I:29263,29278,29297'
G[29296]='K0852 L085 A:53259 T:53259 P:29265 I:29289,29293'
G[29297]='K0852 L085 A:54163 T:53214 P:29205 I:29263,29278,29295'
G[29298]='K0850 L085 A:100069854 T:11801'	-- need to have earned the Legacy of Leyara achievement
G[29299]='K0852 L085 A:52489 T:52489 P:29254 I:29255,29257'
G[29302]='K0850 L085 A:11801 T:11801 P:29298'
G[29303]='K0850 L085 A:11801 T:-100043 P:29302'
G[29304]='K0852 L085 A:52824 T:52824 P:29201 I:29137,29141,29142'
G[29305]='K0852 L085 A:52490,52492 T:52490 P:29181+29293+29287+29283,29181+29296+29287+29283,29181+29293+29288+29283,29181+29296+29288+29283,29181+29293+29289+29283,29181+29296+29289+29283,29181+29293+29290+29283,29181+29296+29290+29283'
G[29307]='FA K085128 L085 A:53349 T:53466 P:29285'
G[29308]='FH K085128 L085 A:53349 T:53371 P:29285'
G[29309]='FH K0850 L085 A:53371 T:53422 P:29308'
G[29310]='K0850 L085 A:-43 T:-100606 P:29303'
G[29311]='K0850 L085 A:-606 T:52135 P:29310'
G[29312]='FA K0850 L085 A:53466 T:53422 P:29307'
G[29313]='FA K0002 L010 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[29314]='FA K0002 L010 A:4210 T:1208825 P:PC001 I:26153,26177,26183,26190,26192,29313,29316,29318,29351,29352,29353,29355,29356,29357'
G[29315]='FH K0002 L010 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[29316]='FA K0002 L010 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29318,29351,29352,29353,29355,29356,29357'
G[29317]='FH K0002 L010 A:4573 T:2055 P:PF001 I:26543,26556,26557,26572,26588,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[29318]='FA K0002 L010 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29351,29352,29353,29355,29356,29357'
G[29319]='FH K0002 L010 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29320,29322,29345,29346,29348,29349,29354,29361'
G[29320]='FH K0002 L010 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29322,29345,29346,29348,29349,29354,29361'
G[29321]='FA K0002 L010 A:4156 T:4156 P:PF001 I:29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29322]='FH K0002 L010 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29345,29346,29348,29349,29354,29361'
G[29323]='FA K0002 L010 A:4156 T:4156 P:PF001 I:29321,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29324]='FA K0002 L010 A:4156 T:4156 P:PF001 I:29321,29323,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29325]='FA K0002 L010 A:4156 T:4156 P:PF001 I:29321,29323,29324,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29326]='K0850 L085 A:54313 T:54312 O:29439,29440'
G[29327]='K0850 L085 A:53524 T:53519 P:29335'
G[29328]='K0850 L085 A:53652 T:53652 P:29336'
G[29329]='K0850 L085 A:53738 T:553738 P:29337'
G[29330]='K0850 L085 A:53925 T:0 P:29338'
G[29331]='K0850 L085 A:-795 T:54168 P:29330'
G[29332]='FH K0002 L010 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29333,29334,29358,29360,29362,29363,29364,29365'
G[29333]='FH K0002 L010 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29334,29358,29360,29362,29363,29364,29365'
G[29334]='FH K0002 L010 A:4552 T:53528 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29358,29360,29362,29363,29364,29365'
G[29335]='K0850 L085 A:54312 T:53524 P:29326'
G[29336]='K0850 L085 A:53519 T:53677 P:29327'
G[29337]='K0850 L085 A:53652 T:42465 P:29328'
G[29338]='K0850 L085 A:553738 T:54014 P:29329'
G[29339]='E21655'
G[29340]='K0850 L085 E21655'
G[29341]='K0850 L085 E21655'
G[29342]='FA K0002 L010 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29343]='FA K0002 L010 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29342,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29344]='FA K0002 L010 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29342,29343,29347,29350,29359,26414,26420,26442,26488,26536'
G[29345]='FH K0002 L010 A:3028 T:3028 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29346,29348,29349,29354,29361'
G[29346]='FH K0002 L010 A:3028 T:30709 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29348,29349,29354,29361'
G[29347]='FA K0002 L010 A:5161 T:1355 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29350,29359,26414,26420,26442,26488,26536'
G[29348]='FH K0002 L010 A:3028 T:3028 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29349,29354,29361'
G[29349]='FH K0002 L010 A:3028 T:3028 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29354,29361'
G[29350]='FA K0002 L010 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29359,26414,26420,26442,26488,26536'
G[29351]='FA K0002 L010 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29352,29353,29355,29356,29357'
G[29352]='FA K0002 L010 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29353,29355,29356,29357'
G[29353]='FA K0002 L010 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29355,29356,29357'
G[29354]='FH K0002 L010 A:3028 T:52657 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29361'
G[29355]='FA K0002 L010 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29356,29357'
G[29356]='FA K0002 L010 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29357'
G[29357]='FA K0002 L010 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356'
G[29358]='FH K0002 L010 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29360,29362,29363,29364,29365'
G[29359]='FA K0002 L010 A:4156 T:4156 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,26414,26420,26442,26488,26536'
G[29360]='FH K0002 L010 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29362,29363,29364,29365'
G[29361]='FH K0002 L010 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354'
G[29362]='FH K0002 L010 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29363,29364,29365'
G[29363]='FH K0002 L010 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29364,29365'
G[29364]='FH K0002 L010 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29365'
G[29365]='FH K0002 L010 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364'
G[29368]='E21655'
G[29371]='HW FA K000258 L001 A:52064 T:52064'
G[29372]='K0850 L001'
G[29373]='K0850 L001'
G[29374]='HW FH K0002 L001 A:53763 T:53763'
G[29375]='HW FH K000258 L001 A:53763 T:53763'
G[29376]='HW FH K0002 L001 A:15197 T:15197 O:29400'
G[29377]='HW FH K000258 L001 A:15197 T:15197'
G[29378]='T:93812 E21655'
G[29379]='T:93812 E21655'
G[29380]='T:93812 E21655'
G[29381]='T:93812 E21655'
G[29382]='HV K0000 L000'
G[29383]='HV K0000 L000'
G[29385]='SP HZ K0000 L010 A:1187236 T:1187236 Z18612'
G[29386]='FA K0800 L080 M084'
G[29387]='FA K0850 L085 A:1206111,1206294 T:52669'	-- TODO: There is a P: for this
G[29388]='FH K0850 L085 A:1206116 T:52669'	-- TODO:	Look at 29387 comment
G[29389]='K0850 L085 A:-606 T:52669 P:29390,29391'
G[29390]='FH K0850 L085 A:1206109,1206116 T:0 I:25372'
G[29391]='FA K0850 L085 A:1206111,1206294,1207320,1207321,1207322 T:0 I:25372'
G[29392]='HW FA K0000 L010 A:53949 T:53950 O:29430'
G[29393]='SP HB FH K0002 L001 A:24497 T:24497 P:11412'
G[29394]='SP HB FA K0002 L001 A:23558 T:23558 P:11122'
G[29395]='T:93812 E21655'
G[29396]='HB FH K0000 L001 A:24510 T:24495 P:11409+k100056836'
G[29397]='HB FA K0000 L001 A:24468 T:23710 P:11318+k100056836'
G[29398]='HW K0000 L010 A:53950 T:8719 P:29392'
G[29399]='HW K0000 L010 A:8719 T:54021 P:29398'
G[29400]='HW FH K00016 L001 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:15197'
G[29401]='FH K0200 L010 A:54004 T:54004'
G[29402]='HW K0000 L010 A:54021 T:54021 P:29399'
G[29403]='HW K0000 L010 A:54021 T:1209072 P:29402'
G[29404]='K0010 L000 Z19033'
G[29405]='K0010 L000'
G[29406]='K0020 L000 RA A:53566 T:53566 P:30027,30033,30034,30035,30036,30037,30038'
G[29407]='K0020 L000'
G[29408]='K0020 L000 RA A:553566 T:553566 P:29524'
G[29409]='K0020 L000 RA A:553566 T:500054 P:29408'
G[29410]='K0020 L000 RA A:500054 T:54943 P:29409'
G[29411]='HW K0000 L010 A:1209072 T:53949,54118 P:29403 I:529411 OTC:53949+529411'
G[29412]='FA K0200 L010 A:54117 T:54117'
G[29413]='HW K0000 L010 AP:500024:529411;1209076:29411 TP:500024:529411;1209076:29411 P:529411,29411'
G[29414]='K0030 L000 RA A:54567 T:54608 P:29419+29424'
G[29415]='HW FH K0000 L010 A:54141 T:54142 O:29431'
G[29416]='HW K0000 L010 A:54142 T:44866 P:29415'
G[29417]='K0040 L000 RA A:54568 T:54568 P:29522'
G[29418]='K0040 L000 RA A:54568 T:54568 P:29417'
G[29419]='K0030 L000 RA A:54943 T:554943 P:29410'
G[29420]='K0040 L000 RA A:54609 T:54135 P:29418+29523'
G[29421]='K0040 L000 RA A:54135 T:54135 P:29664'
G[29422]='K0040 L000 RA A:54135 T:54787 P:29421'
G[29423]='K0050 L000 RA A:54787 T:54786 P:29422'
G[29424]='K0030 L000 RA A:54943 T:554943 P:29410'
G[29425]='HW K0000 L010 A:44866 T:54146 P:29416'
G[29426]='HW K0000 L010 A:54146 T:54146 P:29425'
G[29427]='HW K0000 L010 A:54146 T:1209094 P:29426'
G[29428]='HW K0000 L010 A:1209094 T:54141,54146 P:29427 I:529428 OTC:54141+529428'
G[29429]='HW K0000 L010 AP:1209095:29428;500025:529428 TP:1209095:29428;500025:529428 P:29428,529428'
G[29430]='HW FA K0000 L010 A:51934 T:53949'
G[29431]='HW FH K0000 L010 A:53763 T:54141'
G[29432]='K085128 L085 P:29225'	-- TODO: Determine if this is just really a Blizzard-ism for 29234
G[29433]='HF K0008 L001 A:14832 T:14832'
G[29434]='HF K0002 L001 A:54605 T:54605'
G[29436]='HF K0002 L001 A:15303 T:15303'
G[29437]='K0850 L085 A:52793 T:0 P:29326'
G[29438]='HF K0002 L001 A:14841 T:14841'
G[29439]='FA K0850 L085 A:45226 T:54313'
G[29440]='FH K0850 L085 A:45244 T:54313'
G[29441]='K0190 L015'
G[29443]='K0008 L015 A:100071635 T:14847'
G[29444]='K0008 L015 A:100071636 T:14829'
G[29445]='K0008 L015 A:100071637 T:14822'
G[29446]='K0008 L015 A:100071638 T:14847'
G[29447]='T:88674'
G[29449]='T:88674'
G[29450]='T:88674'
G[29451]='K0008 L015 A:100071715 T:14847'
G[29452]='FH K0850 L085 CD CM CT CS CL AP:52382:J4842,J4850,J4851 AK:53310 T:52382'
G[29453]='FA K0850 L085 CD CM CT CS CL AP:52408:J4842,J4850,J4851 AK:53310 T:52408'
G[29454]='T:88674'
G[29455]='HF K0002 L001 A:54485 T:54485'
G[29456]='K0008 L015 A:100071951 T:14847'
G[29457]='K0008 L015 A:100071952 T:14847'
G[29458]='K0008 L015 A:100071953 T:14847'
G[29459]='E21655'
G[29463]='HF K0002 L001 A:54601 T:54601'
G[29464]='K0608 L060 A:100071716 T:14847'
G[29466]='T:88674'
G[29470]='T:88674'
G[29472]='T:88674'
G[29473]='T:88674'
G[29475]='FH K0000 L020 A:11017 T:5174,5518,11017,11031 P:PN200'
G[29477]='K0000 L020 A:5518,11017,52651 T:5518,7944,11017,52651 P:PN200'
G[29481]='K0000 L001 AA:5177,5499,16723,4160 AH:3347,3009,4611,16642 TA:5177,5499,16723,4160 TH:3347,3009,4611,16642 P:PA475'
G[29482]='K0000 L001 AA:5177,5499,16723,4160 AH:3347,3009,4611,16642 TA:5177,5499,16723,4160 TH:3347,3009,4611,16642 P:PA475'
G[29484]='T:88674'
G[29506]='HF K0008 L001 A:14844 T:14844 P:PA075'
G[29507]='HF K0008 L001 A:14847,30481 T:14847 P:PX075'
G[29508]='HF K0008 L001 A:14829 T:14829 P:PB075'
G[29509]='HF K0008 L001 A:14845 T:14845 P:PC075'
G[29510]='HF K0008 L001 A:14822 T:14822 P:PE075'
G[29511]='HF K0008 L001 A:14841 T:14841 P:PN075'
G[29512]='HF K0008 L001 A:14833 T:14833 P:PZ075'
G[29513]='HF K0008 L001 A:14845 T:14845 P:PF075'
G[29514]='HF K0008 L001 A:14833 T:14833 P:PH075'
G[29515]='HF K0008 L001 A:14822 T:14822 P:PI075'
G[29516]='HF K0008 L001 A:14833 T:14833 P:PJ075'
G[29517]='HF K0008 L001 A:14841 T:14841 P:PL075'
G[29518]='HF K0008 L001 A:14841 T:14841 P:PM075'
G[29519]='HF K0008 L001 A:14833 T:14833 P:PS075'
G[29520]='HF K0008 L001 A:10445 T:10445 P:PT075'
G[29521]='K0050 L000 RA A:54786 T:54975 P:29423'
G[29522]='K0030 L000 RA A:54608 T:54568 P:29414'
G[29523]='K0040 L000 RA A:54568 T:54568 P:29417'
G[29524]='K0020 L000 RA A:53566 T:553566 P:29406'
G[29527]='FH K06264 L058 A:54606 T:54606'
G[29528]='FA K06264 L058 A:54603 T:54603'
G[29529]='FA K06264 L058 A:54603 T:54603'
G[29530]='FH K06264 L058 A:54606 T:54606'
G[29531]='K0850 L000'
G[29533]='E21655'
G[29534]='K0850 L000'
G[29535]='FH K06364 L059 A:54636 T:54636'
G[29536]='FH K06364 L059 A:54636 T:54636'
G[29537]='FH K06364 L059 A:54636 T:54636'
G[29538]='FA K06364 L059 A:54629 T:54629'
G[29539]='FA K06364 L059 A:54629 T:54629'
G[29540]='FA K06364 L059 A:54629 T:54629'
G[29541]='K0850 L085'
G[29542]='FH K06264 L058 A:19256 T:54606'
G[29543]='FA K06264 L058 A:19309 T:54603'
G[29544]='FH K06264 L059 T:54636'
G[29545]='FA K06264 L059 T:54629'
G[29546]='K0860 L085'
G[29547]='FA K0860 L085 AZ:301,811 T:55789'	-- this might be available anywhere when one logs in
G[29548]='K0860 L085 A:55789 T:66292 P:29547'
G[29549]='K0860 L085'
G[29550]='K0860 L085'
G[29551]='K0860 L085'
G[29552]='K0860 L085 A:54614 T:54614 P:31736+31737'
G[29553]='K0860 L085 A:54615 T:59022 P:29555+29556'
G[29554]='K0860 L085'
G[29555]='K0860 L085 A:566292 T:54615 P:31745'
G[29556]='K0860 L085 A:566292 T:54615 P:31745'
G[29557]='K0860 L085'
G[29558]='K0860 L085 A:55196 T:55196 P:29553'
G[29559]='K0860 L085 A:55196 T:55196 P:29553'
G[29560]='K0860 L085 A:55196 T:55196 P:29553'
G[29561]='K0860 L085'
G[29562]='K0860 L085 A:55196 T:56222 P:29759'
G[29563]='K06564 L062 A:54667 T:54667'
G[29564]='K06564 L062 A:54668 T:54668'
G[29565]='K06564 L062 A:54667 T:54667'
G[29566]='K06564 L062 A:17841 T:54667'
G[29567]='K06564 L063 A:54674 T:54674'
G[29568]='K06564 L063 A:54678 T:54678'
G[29569]='E21655'
G[29570]='K06564 L063 A:54675 T:54675'
G[29571]='K06564 L063 A:18074 T:54675'
G[29572]='E21655'
G[29573]='K06664 L064 A:54692 T:54692'
G[29574]='K06664 L064 A:54694 T:54694'
G[29575]='K06664 L064 A:54692 T:54692'
G[29576]='K0860 L085 A:59383 T:54697'	-- P:29922,30015 seems to be wrong, at least for Alliance, because 29922 not turned in and this available
G[29577]='K0870 L086 A:56866 T:56802 O:29871 OAC:30087'
G[29578]='K0860 L085 A:54697 T:54697 O:29576'
G[29579]='K0860 L085 A:54697 T:54697'
G[29580]='K0860 L085 A:54854 T:54854'
G[29581]='K0870 L086 A:56802 T:56773 P:29577'
G[29582]='FH K06664 L064 A:19606 T:54692'
G[29583]='FA K06664 L064 A:21400 T:54692'
G[29584]='K0860 L085'
G[29585]='K0860 L085 A:54854 T:54854'	-- correct with both factions and no obvious preqs build 15913
G[29586]='K0860 L085 A:55209 T:55009 P:29578+29579+29580+29585'	-- verify as required: 29579 29585
G[29587]='K0860 L085 A:55009 T:55009 P:29586'
G[29590]='K06764 L064 A:54725 T:54725'
G[29591]='K06764 L064 A:54698 T:54698'
G[29592]='K0000 L000 T:92031'
G[29593]='FH K06264 L058 A:54606 T:54606'
G[29594]='FA K06264 L058 A:54603 T:54603'
G[29595]='K06764 L064 A:19698 T:54725'
G[29596]='K06764 L064 A:54725 T:54725 O:29595'
G[29597]='E21655'
G[29598]='K06864 L066 A:18723 T:17876 O:10282'
G[29599]='K06864 L066 A:17876 T:18723 P:29598'
G[29600]='K0870 L086 A:56802 T:56802'
G[29601]='HF K0000 L001 AA:54334 AH:55382 I:7926,7905 Z15640'
G[29602]='K0000 L000'
G[29603]='K0000 L000'
G[29604]='K0000 L000'
G[29605]='K06964 L065 A:54840 T:54840'
G[29606]='K06964 L065 A:54840 T:54840'
G[29607]='K06964 L065 A:54847 T:54847'
G[29608]='FA K0700 L068 A:23736,26879 T:32413'
G[29609]='FH K0700 L068 A:25288,27344 T:31557'
G[29610]='K0000 L000'
G[29611]='FH K0860 L085 A:1206109,1206116 AZ:321,811 T:54870 I:29612'	-- boosted to 100 does not get this automatically entering Orgrimmar
G[29612]='FH K0860 L085 T:54870 I:29611'
G[29613]='K07064 L067 A:54848 T:54848'
G[29614]='K07064 L067 A:54849 T:54849'
G[29615]='K07064 L067 A:54851 T:54851'
G[29616]='K06964 L067 A:17841 T:54848'
G[29617]='K0850 L085 A:54998 T:54913'	-- P:29922,30015 seems to be wrong, at least for Alliance, because 29922 not turned in and this available
G[29618]='K0860 L085 A:54913 T:54914 O:29617'
G[29619]='K0860 L085 A:54913 T:54913 P:29618'
G[29620]='K0860 L085 A:54913 T:554914 P:29619'
G[29621]='K0850 L085'
G[29622]='K0860 L085 A:54926 T:54917 P:29620'
G[29623]='K0860 L085 A:54917 T:54917 P:29622'
G[29624]='K0860 L085 A:54917 T:54917 P:29623'
G[29625]='K0850 L085'
G[29626]='K0860 L085 A:54926 T:54915 P:29620'
G[29627]='K0860 L085 A:54915 T:54915 P:29626'
G[29628]='K0860 L085 A:54915 T:54915 P:29627'
G[29629]='K0860 L085 A:54915 T:54915 P:29627'
G[29630]='K0860 L085 A:54915 T:54915 P:29627'
G[29631]='K0860 L085 A:55094 T:55094 P:29627'
G[29632]='K0860 L085 A:54922 T:54922 P:29620'
G[29633]='K0860 L085 A:54922 T:54922 P:29632'
G[29634]='K0860 L085 A:54922 T:54922 P:29632'
G[29635]='K0860 L085 A:54922 T:54922 P:29633+29634'
G[29636]='K0860 L085 A:54922 T:54918 P:29635'
G[29637]='K0860 L085 A:54918 T:54918 P:29636'
G[29638]='K0850 L085 I:29639,29646,29647'	-- this was I with 29639, 29646 and 29647 but removed to make UI cleaner
G[29639]='K0860 L085 A:54917 T:54914 P:29624+29628+29629+29630+29637 I:29646,29647'
G[29640]='K07064 L067 A:54891 T:18891'
G[29641]='K0700 L067 A:18891 T:54891 P:29640'
G[29642]='K0700 L067 A:18893 T:54890'
G[29643]='K0700 L067 A:54890 T:1182947 P:29642'
G[29644]='K0700 L067 A:1182947 T:54890 P:29643'
G[29645]='K07064 L067 A:54890 T:54890'
G[29646]='K0860 L085 A:54915 T:54914 P:29624+29628+29629+29630+29637 I:29639,29647'
G[29647]='K0860 L085 A:54918 T:54914 P:29624+29628+29629+29630+29637 I:29639,29646'
G[29648]='K0850 L085'
G[29649]='FA K07064 L066 A:54933 T:55138,54933'
G[29650]='FH K07065 L066 A:54931 T:55136,54931'
G[29651]='FH K07064 L066 A:54932 T:55136'
G[29652]='FA K07064 L066 A:54934 T:55138'
G[29653]='FH K07064 L066 A:54931 T:55136'
G[29654]='FA K07064 L066 A:54933 T:55138'
G[29655]='FH K07064 L066 A:54931 T:55136'
G[29656]='FA K07064 L066 A:54933 T:55138'
G[29657]='K07064 L067 AZ:730 T:18481'	-- A:19219
G[29658]='K07064 L067 A:18481 T:0 P:29657'
G[29659]='K07064 L067 AZ:730 T:0'
G[29660]='K07064 L067 AZ:729 T:0'
G[29661]='K0050 L000 RA A:54975 T:54975 P:29521'
G[29662]='K0050 L004 RA A:55021 T:55021'
G[29663]='K0050 L000 RA A:54975 T:54975 P:29521'
G[29664]='K0040 L000 RA A:54135 T:54135 P:29420'
G[29665]='K0090 L000 RA A:55940 T:55940 P:29796'
G[29666]='K0050 L000 RA A:55020 T:555020,55020 P:29676'
G[29667]='K07064 L067 A:0 T:0 P:29660'
G[29669]='K07064 L067 A:0 T:0 P:29667'
G[29670]='K0860 L085 A:55009 T:55009 P:29586'
G[29671]='K0700 L066'	-- probably not in game
G[29672]='K0700 L066'	-- probably not in game
G[29673]='K0700 L066'	-- probably not in game
G[29674]='K07064 L067 AZ:731 T:20873'
G[29675]='K0700 L067 A:-731 T:20885'
G[29676]='K0050 L000 RA A:54975 T:55020 P:29661+29662+29663'
G[29677]='K0050 L000 RA A:55020 T:555020,55020 P:29676'
G[29678]='K0050 L000 RA A:555020,55020 T:-808 P:29666+29677'
G[29679]='K0050 L000 RA A:-808,554975 T:554975 P:29678'
G[29680]='K0050 L000 RA A:554975 T:55477 P:29679'
G[29681]='K0700 L067 A:20885 T:20912'
G[29682]='K0700 L068 A:24967 T:55007 P:11481,11482'
G[29683]='K0700 L070 A:24822 T:24848 P:29682'
G[29684]='K07064 L068 A:55007 T:24822'
G[29685]='K0700 L068 A:24848 T:55007 P:29683'
G[29686]='K07064 L068 A:55007 T:55007'
G[29687]='K07064 L068 A:55007 T:55007'
G[29688]='FH K07064 L066 A:16575 T:54931'
G[29689]='FA K07064 L066 A:16819 T:54933'
G[29690]='FH K0860 L085 A:55054 T:55135 P:31853'
G[29691]='K06564 L063 A:54674 T:54674'
G[29692]='SP K06565 L063 A:54674 T:54674 P:29691'
G[29693]='K0860 L085'
G[29694]='FH K0860 L085 A:66656 T:66845 P:31769'	-- forced acceptance when entering parts of The Jade Forest
G[29695]='K0000 L000'
G[29696]='K0860 L085'
G[29697]='K0000 L000'
G[29698]='K0000 L000'
G[29699]='K0000 L000'
G[29700]='K0000 L000'
G[29701]='K0000 L000'
G[29702]='K0000 L000'
G[29703]='K0040 L004'
G[29704]='K0000 L000'
G[29705]='K0040 L004'
G[29706]='K0040 L004'
G[29707]='K0000 L000'
G[29708]='K0000 L000'
G[29709]='K0000 L000'
G[29710]='K0000 L000'
G[29711]='K0000 L000'
G[29712]='K0860 L085'
G[29713]='K0860 L085'
G[29714]='K0860 L085'
G[29715]='K0850 L085'
G[29716]='K0860 L085 A:55234 T:55274 P:31230'
G[29717]='K0860 L085 A:55274 T:55274,55413 P:1'	-- it seems you need to be in the area for 29716 for the "companion NPC 55274" to offer this quest.  whether you need to be on 29716 is not known.
G[29718]='K0860 L085'
G[29719]='K0850 L085'
G[29720]='K0850 L085'
G[29721]='K0850 L085'
G[29722]='K0850 L085'
G[29723]='K0860 L085 A:55274 T:55413 P:29716'
G[29724]='K0860 L085'
G[29725]='K0860 L085 A:55282 T:55282 P:29733'
G[29726]='K0860 L085 A:55284 T:55284 P:29725'
G[29727]='K0860 L085 A:55283 T:55283 P:29726'
G[29728]='K0860 L085'
G[29729]='K0860 L085'
G[29730]='K0860 L085 A:55648 T:55648 P:31239 O:29971'
G[29731]='K0860 L085 A:55646 T:55646 P:29730'
G[29732]='K0860 L085'
G[29733]='K0860 L085 A:55333 T:55333 P:29894'
G[29734]='SP HL K00016 L001 A:55216 T:55216'
G[29735]='SP HL K00016 L001 A:55217 T:55217'
G[29736]='SP HL K00016 L001 A:55218 T:55218'
G[29737]='SP HL K00016 L001 A:55219 T:55219'
G[29738]='SP HL K00016 L001 A:55228 T:55228'
G[29739]='SP HL K00016 L001 A:55224 T:55224'
G[29740]='SP HL K00016 L001 A:55227 T:55227'
G[29741]='SP HL K00016 L001 A:55210 T:55210'
G[29742]='SP HL K00016 L001 A:55211 T:55211'
G[29743]='K0860 L085 A:1212181 T:0 P:31774'
G[29744]='K0860 L085'
G[29745]='K0860 L085 A:55438 T:0'
G[29746]='K0860 L085'
G[29747]='K0860 L085 A:-806 T:0 P:29745'
G[29748]='K0860 L085 A:1214871 T:0 P:29745'
G[29749]='K0860 L085 A:-806 T:55614 P:29747+29748'
G[29750]='K0860 L085 A:55614 T:55614 P:29749'
G[29751]='K0860 L085 A:55614 T:55614 P:29749'
G[29752]='K0860 L085 A:55614 T:55614 P:29749'
G[29753]='K0860 L085 A:55614 T:55614 P:29750'
G[29754]='K0860 L085 A:55963 T:0 P:29753+29756'
G[29755]='K0860 L085 A:-806 T:59492 P:29754'
G[29756]='K0860 L085 A:55614 T:55614 P:29750+29751+29752'
G[29757]='K0870 L086 A:56773 T:56773'
G[29758]='K0870 L086 A:100083767 T:56773'
G[29759]='K0860 L085 A:55196 T:55196 P:29558+29559+29560'	-- TODO: Verify required 29559
G[29760]='K0850 L001'
G[29761]='K0850 L085'
G[29762]='K0860 L085 A:56366 T:56222 P:29883+29885'
G[29763]='FA K07164 L068 A:24111 T:24111'
G[29764]='FA K07164 L068 A:24111 T:24111'
G[29765]='K0860 L085 A:55403 T:55497 P:31774'
G[29766]='K0860 L085'
G[29767]='K0860 L085'
G[29768]='K0060 L000 RA A:55477 T:55477 P:29769+29770'
G[29769]='K0060 L000 RA A:55477 T:55477 P:29680'
G[29770]='K0060 L000 RA A:55479 T:55479 P:29680'
G[29771]='K0060 L000 RA A:55478 T:55478 P:29769+29770'
G[29772]='K0060 L000 RA A:55477 T:55477 P:29768'
G[29773]='K0060 L000'
G[29774]='K0060 L000 RA A:55477 T:55477 P:29771+29772'
G[29775]='K0060 L000 RA A:55477 T:554786 P:29774'
G[29776]='K0060 L000 RA A:554786 T:55583 P:29775'
G[29777]='K0070 L000 RA A:55588 T:55588 P:29776'
G[29778]='K0070 L000 RA A:55583 T:55583 P:29776'
G[29779]='K0070 L000 RA A:55583 T:55583,65558,565558 P:29777+29778+29783'
G[29780]='K0070 L000 RA A:55583 T:55583,65558,565558 P:29777+29778+29783'
G[29781]='K0070 L000 RA A:55583 T:55583,65558,565558 P:29777+29778+29783'
G[29782]='K0070 L000 RA A:1209673 T:55585 P:29783'
G[29783]='K0070 L000 RA A:55585 T:55585 P:29776'
G[29784]='K0070 L000 RA A:55583,65558,565558 T:55595 P:29779+29780+29781+29782'
G[29785]='K0070 L000 RA A:55595 T:55592 P:29784'
G[29786]='K0070 L000 RA A:555595 T:55586 P:29785'
G[29787]='K0080 L000 RA A:55586 T:55672 P:29786'
G[29788]='K0080 L000 RA A:55672 T:55672 P:29787'
G[29789]='K0080 L000 RA A:55672 T:55672 P:29787'
G[29790]='K0080 L000 RA A:55672 T:56662 P:29788+29789'
G[29791]='K0080 L000 RA A:56662 T:56012 P:29790'
G[29792]='K0090 L000 RA A:56012 T:55943 P:29791'
G[29793]='K0090 L000 RA A:55942 T:55942 P:30589'
G[29794]='K0090 L000 RA A:55944 T:55944 P:29796'
G[29795]='K0090 L000 RA A:60042 T:60042 P:29792'
G[29796]='K0090 L000 RA A:55942 T:55944 P:29793+30590'
G[29797]='K0090 L000 RA A:55944 T:55944 P:29796'
G[29798]='K0090 L000 RA A:55940 T:56418 P:29665+29794+29797'
G[29799]='K0090 L000 RA A:56418 T:56418 P:29798'
G[29800]='K0100 L000 RA A:57739 T:56013 P:29799'
G[29801]='K0850 L085 CR'
G[29802]='K0850 L085 CR P:29801'
G[29803]='FA K07164 L068 A:24111 T:24111'
G[29804]='K0860 L085 A:55497 T:65999 P:29765'
G[29805]='K0000 L000'
G[29806]='K0000 L001'
G[29807]='K07464 L070 A:55564 T:55564'
G[29808]='K07464 L070 A:55564 T:55564'
G[29809]='K0830 L083'
G[29810]='K0760 L073'
G[29811]='K07464 L070 A:55564 T:55564'
G[29812]='K0850 L085'
G[29813]='K0850 L085'
G[29814]='K0850 L085'
G[29815]='K0860 L085 A:55180 T:55180 P:31999'
G[29816]='K0850 L085'
G[29817]='K0850 L085'
G[29818]='K0850 L085'
G[29819]='K0850 L085'
G[29820]='K0710 L069'
G[29821]='FH K0860 L085 A:555521 T:62923 P:31999'
G[29822]='K0860 L085 A:55172 T:55768 P:29827+31112'	-- removed  I:31195 as this might be a flag that Dook Ookem is killed.  TODO: Attempt to verify this
G[29823]='K0860 L085 A:55648 T:55648 P:29731'
G[29824]='K0860 L085 A:55647 T:55647 P:29823'
G[29825]='K0760 L071 A:55658 T:29309'
G[29826]='K0760 L071 A:55658 T:-522'
G[29827]='K0860 L085 A:55180 T:55180 P:29815'
G[29828]='K07464 L072 A:55677 T:55677'
G[29829]='K07764 L075 A:16128 T:30658'
G[29830]='K07764 L075 A:30658 T:30658 P:29829'
G[29831]='K0850 L085'
G[29832]='K0850 L085'
G[29833]='K07864 L074 A:528401 T:55738 I:29836'
G[29834]='K07864 L074 A:55738 T:55738'
G[29835]='K07864 L074 A:55737 T:55737'
G[29836]='K07864 L074 A:28527 T:55737 I:29833'
G[29837]='K0860 L085'
G[29838]='K07864 L074 A:55737 T:55737'
G[29839]='K07864 L074 A:55738 T:55738'
G[29840]='K07864 L074 A:55737 T:55737'
G[29841]='K0860 L085'
G[29842]='K0860 L085'
G[29843]='K0850 L085'
G[29844]='K07864 L074 A:55738 T:55738'
G[29845]='K0850 L085'
G[29846]='K0850 L085'
G[29847]='K0850 L085 CR P:29934'
G[29848]='K07864 L075 A:55835 T:55835'
G[29849]='K0850 L085'
G[29850]='K07864 L075 A:55835 T:55835'
G[29851]='K07864 L075 A:0 T:0'
G[29852]='K0850 L085'
G[29853]='K0780 L075'
G[29854]='K0850 L085'
G[29856]='K0860 L085'
G[29857]='K0850 L085'
G[29858]='K0860 L085'
G[29859]='K0850 L085'
G[29860]='K08064 L077 A:56027 T:56027'
G[29861]='K0800 L077 A:56027 T:56027'
G[29862]='K08064 L077 A:56027 T:56027'
G[29863]='K0800 L077 A:30105 T:56027 P:13047 I:29861'
G[29864]='K08064 L078 A:56072 T:56072'
G[29865]='K0860 L085 A:56062 T:56062 P:31230'
G[29866]='K0860 L085 A:59178 T:59178 P:31230'
G[29867]='K0850 L085'
G[29868]='K0850 L085'
G[29869]='K0860 L085'
G[29871]='K0870 L086 A:56110 T:56113 P:30086,30087'
G[29872]='K0870 L086 A:56110 T:56111 P:30086,30087'
G[29873]='K0850 L086 A:56110 T:56115 P:30086,30087'
G[29874]='FA K0850 L086 A:56110 T:500070,56114 P:30086,30087 I:29875'
G[29875]='FH K0850 L086 A:56110 T:56112,556112 P:30086,30087 I:29874'	-- Blizzard's quest tells you to go the first NPC, but if he has moved then you need to go to the second, even though the Blizzard map puts the ? at the first location.
G[29876]='K0850 L085'
G[29877]='K0870 L086 A:56440 T:56440 P:29907'
G[29878]='K0860 L085'
G[29879]='K0860 L085 A:63307 T:56313 P:31167'
G[29880]='K0860 L085'
G[29881]='K0860 L085 A:56064 T:56064'
G[29882]='K0860 L085 A:56063 T:56063'
G[29883]='K0860 L085 A:66949 T:66949 P:29562'
G[29884]='K0000 L000'
G[29885]='K0860 L085 A:66949 T:66949 P:29562'
G[29886]='K0860 L085'
G[29887]='K0860 L085 A:59058 T:59058 P:29883+29885'
G[29888]='K0860 L085 A:56222 T:1209845 P:29727'
G[29889]='K0860 L085 A:1209845 T:54961 P:29888'
G[29890]='K0860 L085 A:56287 T:56434 P:29891+29892+29893'	-- TODO: Verify required 29891
G[29891]='K0860 L085 A:61218 T:56287 P:31130'
G[29892]='K0860 L085 A:61218 T:56287 P:31130'
G[29893]='K0860 L085 A:61218 T:56287 P:31130'
G[29894]='K0860 L085 A:59058 T:56222 P:29762+29887'
G[29895]='K0860 L085'
G[29896]='K0860 L085'
G[29897]='K0860 L085'
G[29898]='K0860 L085 A:56434 T:56433 P:29890'
G[29899]='K0860 L085 A:56432 T:56432 P:29890'
G[29900]='K0860 L085 A:56433 T:56432 P:29890'
G[29901]='K0860 L085 A:-806 T:60970 P:29898+29899+29900'	-- TODO: Verify required 29899
G[29902]='K0860 L085'
G[29903]='K0860 L085 A:60970 T:60970 P:29727'
G[29904]='K0860 L085 A:60970 T:60970 P:29903'
G[29905]='K0860 L085 A:60970 T:54960 P:29904'
G[29906]='K0860 L085 A:60970 T:54960 P:29904'
G[29907]='K0870 L086 A:56133 T:56204'
G[29908]='K0870 L086 A:56204 T:56204 P:29907'
G[29909]='K0870 L086 A:56204 T:56207 P:29877+29908'
G[29910]='K0870 L086 A:56465 T:56465 P:29909'
G[29911]='K0870 L086 A:56207 T:56204 P:29940'
G[29912]='K0870 L086 A:56204 T:56205 P:29911'
G[29913]='K0870 L086 A:56205 T:56205 P:29912'
G[29914]='K0870 L086 A:56205 T:56205 P:29912'
G[29915]='K0870 L086 A:56205 T:56208 P:29913+29914'
G[29916]='K0870 L086 A:56208 T:56208 P:29915'
G[29917]='K0870 L086 A:56208 T:56208 P:29915'
G[29918]='K0870 L086 A:56312 T:556312 P:29916+29917'
G[29919]='K08732 L086 A:500068 T:56474 P:29918'
G[29920]='K0860 L085 A:56708 T:55788 P:29995'
G[29922]='K0860 L085 A:554960 T:63577 P:29901'
G[29923]='K0860 L085'
G[29924]='K0860 L085 A:56327 T:0 P:29879'
G[29925]='K0860 L085 A:56348 T:56345 P:29723'
G[29926]='K0860 L085 A:56346 T:56346 P:29928'
G[29927]='K0860 L085 A:56346 T:56347 P:29928'
G[29928]='K0860 L085 A:56346 T:56346 P:29925'
G[29929]='K0860 L085 A:56347 T:56467 P:29927'
G[29930]='K0860 L085 A:56467 T:56346 P:29929'
G[29931]='K0860 L085 A:56346 T:59391 P:29930'
G[29932]='K0860 L085 A:59391 T:56782 P:30495'
G[29933]='K0860 L085 A:56351 T:56336 P:29879'
G[29934]='K0850 L085 CR P:29802'
G[29935]='K0860 L085 A:56313 T:56336 P:29879'
G[29936]='K0860 L085 A:56336 T:56339 P:29935'
G[29937]='K0860 L085 A:56406 T:56406,556406 P:29941'
G[29938]='K0860 L085'
G[29939]='K0860 L085 A:56406,556406 T:556406 P:29937'
G[29940]='K0870 L086 A:56207 T:56207 P:29909'
G[29941]='K0860 L085 A:56339 T:56339 P:29936'
G[29942]='K0860 L085 A:56358 T:56358 P:29937'
G[29943]='K0860 L085 A:556339 T:56490 P:29824'
G[29944]='K0870 L086 A:556133 T:556133 P:29919'
G[29945]='K0870 L086 A:56138 T:56138 P:29919'
G[29946]='K0870 L086 A:556133 T:556133 P:29944'
G[29947]='K0870 L086 A:56138 T:56138 P:29945'
G[29948]='K0870 L086 A:56474 T:56474 P:29944'
G[29949]='K0870 L086 A:556133 T:556138 P:29946+29947+29948'
G[29950]='K0870 L086 A:556138 T:556138 P:29949'
G[29951]='K0870 L086 A:56474 T:56474 P:29949'
G[29952]='K0870 L086 A:500055 T:500055 P:29950'
G[29966]='K0860 L085 A:56490 T:56339 P:29943'
G[29967]='K0860 L085 A:556406 T:56525 P:29968'
G[29968]='FH K0860 L085 A:500083 T:556406 P:1'	-- no idea what the P is.  found it when out finishing up 29966
G[29969]='K0000 L001'
G[29970]='K0000 L001'
G[29971]='K0860 L085 A:556406 T:55647 P:29939+29942+31239'	-- TODO: Verify requires 29942
G[29981]='K0870 L086 A:56111 T:56720 O:29872 OAC:30087'
G[29982]='K0870 L086 A:56720 T:56720'
G[29983]='K0870 L086 A:56720 T:56714 P:29981+29982'
G[29984]='K0870 L086 A:56714 T:56714 P:29983'
G[29985]='K0870 L086 A:56714 T:56714 P:29984'
G[29986]='K0870 L086 A:56714 T:56714 P:29984'
G[29987]='K0870 L086 A:56714 T:56714 P:29992+29985+29986'
G[29988]='K0870 L086 A:56714 T:56714 P:29987'
G[29989]='K0870 L086 A:56714 T:56714 P:29988'
G[29990]='K0870 L086 A:556111 T:56720 P:29989'	-- OEC:30629 OPC:30117+30273+30445,30117+30273+30174
G[29992]='K0870 L086 A:556111 T:556111 P:29984'
G[29993]='K0860 L085 A:59173 T:56065 P:29866'
G[29995]='K0860 L085 A:56065 T:56708 P:29993'
G[29997]='K0860 L085 A:56782 T:56787 P:29932'
G[29998]='K0860 L085 A:56782 T:56786 P:29932'
G[29999]='K0860 L085 A:56784 T:56784 P:29932'
G[30000]='K0860 L085 A:56784 T:57242 P:29999+30004+30005+30011'	--	TODO: Verify requires 30005 30011
G[30001]='K0860 L085 A:56786 T:56786 P:29998'
G[30002]='K0860 L085 A:56786 T:56786 P:29998'
G[30003]='K0860 L085'
G[30004]='K0860 L085 A:56786 T:56782 P:30001+30002'
G[30005]='K0860 L085 A:56784 T:56784 P:29932'
G[30006]='K0902 L090 A:57324 T:57324 P:T4F562999 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30007]='K0000 L000'
G[30009]='K0850 L085'
G[30011]='K0860 L085 A:56787 T:56782 P:29997'
G[30015]='FH K0860 L085 A:556339 T:63577 P:1'	-- not sure when this is available, because I did the 29968 and 29967 since I "completed" 29966.  since the general will not be back to this location prior to completing 29966 (but not turning it in), it is either complete 29966 or something to do with the other two quests
G[30019]='K0870 L086'
G[30020]='K0870 L086'
G[30021]='K0870 L086'
G[30027]='K0010 L000 RA CO A:53566 T:53566 P:30039'
G[30028]='K0870 L086 A:57211 T:57211 P:30029+30030+30031'
G[30029]='K0870 L086 A:57211 T:57211 P:30048'
G[30030]='K0870 L086 A:57209 T:57209 P:30048'
G[30031]='K0870 L086 A:500058 T:500058 P:30048'
G[30032]='K0870 L086 A:57211 T:500058 P:30029+30030+30031'
G[30033]='K0010 L000 RA CM A:53566 T:53566 P:30040'
G[30034]='K0010 L000 RA CH A:53566 T:53566 P:30041'
G[30035]='K0010 L000 RA CT A:53566 T:53566 P:30042'
G[30036]='K0010 L000 RA CR A:53566 T:53566 P:30043'
G[30037]='K0010 L000 RA CS A:53566 T:53566 P:30044'
G[30038]='K0010 L000 RA CW A:53566 T:53566 P:30045'
G[30039]='K0010 L000 RA CO AZ:808 T:53566 Z19033'
G[30040]='K0010 L000 RA CM AZ:808 T:53566 Z19033'
G[30041]='K0010 L000 RA CH AZ:808 T:53566 Z19033'
G[30042]='K0010 L000 RA CT AZ:808 T:53566 Z19033'
G[30043]='K0010 L000 RA CR AZ:808 T:53566 Z19033'
G[30044]='K0010 L000 RA CS AZ:808 T:53566 Z19033'
G[30045]='K0010 L000 RA CW AZ:808 T:53566 Z19033'
G[30046]='K0870 L086 A:500055 T:500056 P:29951+29952'
G[30047]='K0870 L086 A:500058 T:500056 P:30032'
G[30048]='K0870 L086 A:500056 T:500058 P:30046'
G[30049]='K0870 L086 A:500056 T:556474 P:30046'
G[30050]='K0870 L086 A:62377 T:62377 P:30046'
G[30051]='K0870 L086 A:556474 T:58785 P:30049'
G[30052]='K0870 L086 A:57385 T:57385 P:30046'
G[30053]='K0870 L086 A:500056 T:-807 P:30046'
G[30054]='K0870 L086 A:57401 T:57401 P:30046'
G[30055]='K0870 L086 A:-807 T:500056 P:30050+30052+30053+30054'	-- I have a toon that did all the farmer quests first and then accepted 30053 and then when that was turned in, 30055 became available.
G[30056]='K0870 L086 A:62385 T:57408 P:30046'
G[30057]='K0870 L086 A:57408 T:57402 P:30056'
G[30058]='K0870 L086 A:57407 T:57407 P:30059'
G[30059]='K0870 L086 A:57424 T:57424'
G[30063]='K0902 L090 A:57319 T:57319 P:T4F562999 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30064]='K0902 L090 A:57319 T:57319 P:T4F562999 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30065]='K0902 L090 A:57324 T:57324 P:T4F562999 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30066]='K0902 L090 A:57324 T:57324 P:T4F562999 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30067]='K0902 L090 A:57324 T:57324 P:W0223 I:30068'
G[30068]='K0902 L090 A:57324 T:57324 P:W0223 I:30067'
G[30069]='K0860 L085 A:54616 T:54617 P:31733'
G[30070]='K0860 L085 A:554616 T:66581 P:31741+31742+31743+31744'	-- TODO: Technically should verify required: 31744
G[30072]='K0870 L086 A:57405 T:57405 O:32035'
G[30073]='K0870 L086 A:500056 T:500059 P:30047+30055+30172'
G[30074]='K0870 L086 A:500059 T:500060 P:30073'
G[30075]='K0870 L086 A:57706 T:500064 P:30074'
G[30076]='K0870 L086 A:500062 T:500065 P:30074'
G[30077]='K0870 L086 A:500063 T:500066 P:30074'
G[30078]='K0870 L086 A:500064 T:500067 P:30075+30076+30077'
G[30079]='K0860 L086 A:56115 T:56115 O:29873 OAC:30087'
G[30080]='K0860 L086 A:57744 T:58376'
G[30081]='K0860 L086 A:56115 T:56115 P:30079+30082'
G[30082]='K0860 L086 A:58376 T:57744 P:30080'
G[30083]='K0860 L086 A:57744 T:57744 P:30091'
G[30084]='K0860 L086 A:57744 T:57744 P:30091'
G[30085]='K08764 L086 A:500067 T:59704 P:30078'
G[30086]='K0870 L086 A:56110 T:56110 P:29877+29908 I:30087'
G[30087]='K0000 L000 T:56111'
G[30088]='K0860 L086 A:56115 T:56115 P:30081'
G[30089]='K0860 L086 A:56115 T:56115 P:30088'
G[30090]='K086 L086 A:56115 T:56115 P:30089'	--	It appears when 30090 was complete, the exclamation point for Nayeli Legoon appears on the Blizzard map.
G[30091]='K0860 L086 A:57744 T:57744 P:30082'
G[30092]='K0850 L085 CR'
G[30093]='K0850 L085 CR'
G[30094]='FH K0850 L085 A:52382 T:54476'
G[30095]='FA K0850 L085 A:52408 T:54476'
G[30096]='K08564 L085 A:54476 T:54751 O:30094,30095'
G[30097]='K08564 L085 A:57864 T:557864'
G[30098]='K08564 L085 A:54751 T:55624 P:30096'
G[30099]='K08564 L085 A:55624 T:555624 P:30098'
G[30100]='K08564 L085 A:555624 T:500032 P:30099'
G[30101]='K08564 L085 A:500032 T:55532 P:30100'
G[30102]='K08564 L085 A:57913 T:54548 P:30101'
G[30103]='K0850 L085 A:54548 T:54971 P:30102'
G[30104]='K08564 L085 A:500031 T:500033'
G[30105]='K08564 L085 A:100077957 T:54971'
G[30106]='K0850 L085 CR'
G[30107]='K0850 L085 CR'
G[30108]='K0850 L085 CR'
G[30109]='K0850 L085 CR'
G[30110]='K0850 L085'
G[30111]='K0850 L085'
G[30112]='FH K0710 L068 A:23961 T:24137'
G[30113]='K0850 L085 CR'
G[30116]='K0850 L085 CR'
G[30117]='K0870 L086 A:61026 T:56720 P:30078'	-- OEC:30629 OPC:29990+30273+30445,29990+30273+30174
G[30118]='K0850 L085 CR'
G[30119]='K0850 L085'
G[30120]='K07564 L072 A:58149 T:28016'
G[30121]='FH K0860 L086 A:58113 T:58160'
G[30122]='K0000 L001'
G[30123]='K0860 L086 A:56112 T:56112 P:30179'
G[30124]='K0860 L086 A:58114 T:58114 P:30179'
G[30125]='K0860 L086 I:30353'
G[30126]='K0860 L086 I:30352'
G[30127]='K0860 L086 A:58114 T:58114 P:30123+30124'
G[30128]='K0860 L086 A:58206 T:558113 P:30129'
G[30129]='K0860 L086 A:56112 T:58206 P:30123+30124'
G[30130]='K0860 L086 A:558113 T:558113 P:30124'	--	TODO: determine if we need P: of 30123 as well
G[30131]='K0860 L086 A:558113 T:500069 P:30128+30130'	-- TODO: Verify P codes here
G[30132]='K0870 L086 A:500069 T:558114 P:30131 I:30464'
G[30133]='FH K0860 L086 A:57744 T:58547 P:30090 I:30178,30461,30462'
G[30134]='K0900 L090 A:58564 T:58225'	-- P:31373,31375
G[30135]='K0900 L090 A:58225 T:58225 P:30134'
G[30136]='K0900 L090 A:58225 T:58225 P:30134'
G[30137]='K0900 L090 A:58225 T:58225 P:30134'
G[30138]='SP K0900 L090 A:58225 T:58225 P:30135+30136+30137'	-- TODO: Verify requires 30136
G[30139]='K0900 L090 A:58225 T:58228 P:30138+K100078962 I:30140,30141 ODC:30165'	-- not sure server marks the tracking quests properly, so ODC just in case
G[30140]='K0900 L090 A:58225 T:58228 P:30138+K100078960 I:30139,30141 ODC:30166'	-- not sure server marks the tracking quests properly, so ODC just in case
G[30141]='K0900 L090 A:58225 T:58228 P:30138+K100078961 I:30139,30140 ODC:30167'	-- not sure server marks the tracking quests properly, so ODC just in case
G[30142]='K0900 L090 A:58228 T:58228 P:30139,30140,30141'
G[30143]='K0900 L090 A:58564 T:58420 P:T4F762999'
G[30144]='K0900 L090 A:58420 T:58420 P:30143'
G[30145]='K0900 L090 A:58420 T:58420 P:30144'
G[30146]='K0902 L090 A:58413 T:58413 P:30142+PF525'
G[30147]='K0902 L090 A:58413 T:58413 P:30142+PX525'
G[30148]='K0902 L090 A:58413 T:58413 P:30142+PZ525'
G[30149]='K0902 L090 A:58413 T:58413 P:30142+PC525'
G[30150]='K0902 L090 A:65669,65670,65671 T:65669,65670,65671 P:30142 I:V0181,V0191,V0201,V0211,V0361 D017'
G[30151]='K0902 L090 A:65669,65670,65671 T:58564 P:30142+U4F762999 I:V0181,V0191,V0201,V0211,V0361 D017'
G[30152]='K0902 L090 A:58420 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[30153]='K0900 L090'
G[30154]='K0902 L090 A:65669,65670,65671 T:58564 P:30142 I:31698,V0171,V0181,V0201,V0211,V0361 D019'
G[30155]='K0902 L090 A:58228 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'
G[30156]='K0902 L090 A:65669,65670,65671 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'	-- I:30157,30158,30159
G[30157]='K0902 L090 A:58510 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'	-- I:30156,30158,30159
G[30158]='K0902 L090 A:58228 T:58564 P:30142 I:30156,30157,30159,V0171,V0191,V0201,V0211,V0361 D018'
G[30159]='K0902 L090 A:58510 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'	-- I:30156,30157,30158
G[30160]='SP K0901 L090 A:58647,558647 T:58647,558647 P:30257+K100079264+U4FB83999'
G[30163]='K0870 L086 A:558114 T:558114 P:30132'
G[30164]='FH K0870 L086 A:58607 T:58607 P:30230'	-- TODO: Verify the need for 30229 and/or 30163
G[30165]='K0000 L000 T:58228 I:30166,30167'
G[30166]='K0000 L000 T:58228 I:30165,30167'
G[30167]='K0000 L000 T:58228 I:30165,30166'
G[30168]='K0870 L086 A:58278 T:58278'	-- P:30273 wrong
G[30169]='K0870 L086 A:58278 T:58278'	-- P:30273 wrong
G[30172]='K0870 L086 A:58785 T:500056 P:30051'
G[30173]='K0000 L001'
G[30174]='K0870 L086 A:58607 T:558607 P:30164+30175'	-- TODO: Verify 30164 is required	-- OEC:30629 OPC:29990+30117+30273
G[30175]='K0870 L086 A:58630 T:58954 P:30163+30229+30230 I:30361'	--	TODO: Verify 30163 and 30230 are required
G[30177]='K0850 L085'
G[30178]='FA K0860 L086 A:57744 T:58547 P:30090 I:30133,30461,30462'
G[30179]='FH K0860 L086 A:58160 T:58113 O:30121'
G[30180]='K0860 L086'
G[30181]='K0870 L086 A:58422 T:58422'
G[30182]='K0870 L086 A:63822 T:63822 P:30183'
G[30183]='K0870 L086 A:63822 T:63822'
G[30184]='K0870 L086 A:58421 T:58421 P:30181'
G[30185]='K0870 L086 A:58422 T:558422 P:30182+30184'
G[30186]='K0870 L086 A:558422 T:58421 P:30185'
G[30187]='K0900 L090 A:58420 T:58420 P:30145'
G[30188]='K0900 L090 A:58564 T:58564 P:30145+30187+30166+T4F783999 I:31810,31811'	-- server completes all three (as well as all three prerequisites), what a pain
G[30189]='SP K0901 L090 A:58647,558647 T:58647,558647 P:30257+K100079267+U4FB83999'
G[30190]='K0902 L090 A:58819 T:58819 P:31242,31245 Z17128 D002'	-- I:30232
G[30191]='K0902 L090 A:58819 T:58819 P:31242,31245 Z17128 D002'	-- I:30192
G[30192]='K0902 L090 A:58819 T:58819 P:31242,31245 Z17128 D002'	-- I:30231
G[30193]='K0902 L090 A:58818 T:58818 P:31242,31245 Z17128 D002'
G[30194]='K0902 L090 A:59338 T:59338 P:31242,31245 Z17128 D002'
G[30195]='K0902 L090 A:58820 T:58820 P:31242,31245 Z17128 D002'
G[30196]='K0902 L090 A:58818 T:58818 P:31242,31245 Z17128 D002'	-- I:30193,30231
G[30197]='K0900 L090'
G[30198]='K0900 L090'
G[30199]='K0900 L090'
G[30200]='K0902 L090 A:58503 T:58503 P:31240,31248,31294,31296'
G[30201]='K0900 L090'
G[30202]='K0900 L090'
G[30203]='K0900 L090'
G[30204]='K0902 L090 A:58504 T:58504 P:31240,31248,31294,31296 Z17128 D011'
G[30205]='K0902 L090 A:63266 T:63266 P:31240,31248,31294,31296 Z17128 D011'
G[30206]='K0902 L090 A:63266 T:63266 P:31240,31248,31294,31296 Z17128 D011'
G[30207]='K0000 L000'
G[30208]='K0000 L000'
G[30209]='K0000 L000'
G[30210]='K0000 L000'
G[30211]='K0000 L000'
G[30212]='K0000 L000'
G[30215]='K0000 L000'
G[30216]='K0000 L000'
G[30217]='K0000 L000'
G[30218]='K0000 L000'
G[30219]='K0000 L000'
G[30220]='K0000 L000'
G[30221]='K0000 L000'
G[30222]='K0000 L000'
G[30223]='K0000 L000'
G[30224]='K0000 L000'
G[30225]='K0902 L090 A:58503 T:58503 P:30200+W0111 I:30227'
G[30226]='K0900 L090'
G[30227]='K0902 L090 A:58503 T:58503 P:30200+W0111 I:30225'
G[30228]='K0902 L090 A:58503 T:58503 P:31240,31248,31294,31296 Z17128 D011'
G[30229]='K0870 L086 A:558114 T:558114 P:30132'
G[30230]='K0870 L086 A:556112 T:556112 P:30132'
G[30231]='K0902 L090 A:58818 T:58818 P:31242,31245 Z17128 D002'	-- I:30192
G[30232]='K0902 L090 A:59338 T:59338 P:31242,31245 Z17128 D002'	-- I:30190
G[30233]='K0902 L090 A:59343 T:59343 P:W0131+W0141+W0151+W0161+U4F550999 I:30234'
G[30234]='K0902 L090 A:59343 T:59343 P:W0131+W0141+W0151+W0161+U4F550999 I:30233'
G[30235]='K0902 L090 A:59338 T:59338 P:W0024+U4F550999|31245 I:30236,30237 Z17128'
G[30236]='K0902 L090 A:59338 T:59338 P:W0024+U4F550999|31245 I:30235,30237 Z17128'
G[30237]='K0902 L090 A:59338 T:0 P:31242,31245 Z17128 D002'
G[30238]='K0902 L090 A:59338 T:59338 Z17128'
G[30239]='K0902 L090 A:-811 T:59338 P:30237'
G[30240]='K0902 L090 A:59340 T:59340 P:30385,31247 I:30242'
G[30241]='FH K0870 L086 A:58607 T:556720 P:29990+30117+30273+30174 I:30360,30376'	-- P:30629
G[30242]='K0902 L090 A:59340 T:59340 P:30385,31247 I:30240'
G[30243]='K0902 L090 A:58920 T:-811,58920 P:30240|30242+30306 I:30245,30246,30266,30444'
G[30244]='K0902 L090 A:-811 T:-811 P:30243'
G[30245]='K0902 L090 A:58920 T:-811,58920 P:30240|30242+30306 I:30243,30246'
G[30246]='K0902 L090 A:58919 T:-811,58919 P:30240|30242+30306 I:30243,30245'
G[30247]='K0900 L090'
G[30248]='K0902 L090 A:-811,58920 T:58920 P:30245'
G[30249]='K0902 L090 A:-811 T:58920 P:30244'
G[30250]='K0900 L090'
G[30251]='K0902 L090 A:-811 T:58919 P:30246'
G[30252]='K0870 L085 A:58721 T:58646 O:31372,31374'
G[30253]='K0870 L085'
G[30254]='K0870 L085 A:558646 T:558646 P:30535'
G[30255]='K0870 L085 A:558646 T:558646 P:30254'
G[30256]='K0870 L085 A:558646 T:558646 P:30255'
G[30257]='K0870 L085 A:558646 T:58706 P:30256'
G[30258]='K0900 L090 A:58646 T:57401 P:31945+T4F856599'	-- making this based on reputation instead, at the moment 5600 into Honored
G[30259]='K0900 L090 A:57401 T:57401 P:30258'
G[30260]='K0900 L090 A:58646 T:57385 P:T4F850999'
G[30261]='K0902 L090 A:58704 T:58704 P:30240|30242+30306+T4F562999 I:30264'
G[30262]='K0900 L090'
G[30263]='K0902 L090 A:59338 T:59338 P:31242,31245 Z17128 D002'
G[30264]='K0902 L090 A:58919 T:58919 P:30240|30242+30306+T4F562999 I:30261'
G[30265]='K0902 L090 A:59343 T:59343 P:31131 I:30291,30338 Z17128 D014'
G[30266]='K0902 L090 A:59340 T:59340 P:30240|30242+30306 I:30243,30444'
G[30267]='K0870 L086 A:58736 T:58736'
G[30268]='K0870 L086 A:58609 T:58609 P:30269 I:30375'
G[30269]='K08732 L086 A:58547 T:59138 P:30133,30178'
G[30270]='K0870 L086 A:59138 T:59138 P:30269'
G[30271]='K0870 L086 A:59188 T:59608 P:30268+30270+30694'
G[30272]='K0870 L086 A:59138 T:59608 P:30268+30270+30694'
G[30273]='K0870 L086 A:59608 T:59719 P:30271+30272+30695'	-- OEC:30629 OPC:29990+30117+30445,29990+30117+30174
G[30274]='FA K0870 L086 A:-100857 T:58745'
G[30275]='K0870 L086 T:56773'
G[30277]='K0902 L090 A:58503 T:58503 P:30642+30200+W0111 I:30280'
G[30278]='K0900 L090'
G[30279]='K0900 L090'
G[30280]='K0902 L090 A:58503 T:58503 P:30642+30200+W0111 I:30277'
G[30281]='K0902 L090 A:58470 T:-811 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,31243 Z17128 D023'
G[30282]='K0902 L090 A:58465 T:58465 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,31243 Z17128 D023'
G[30283]='K0902 L090 A:58469 T:58469 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,31243 Z17128 D023'
G[30284]='K0902 L090 A:59343 T:59343 P:31131 I:30342 Z17128 D015'
G[30285]='K0902 L090 A:59337 T:59337 P:31243,31246 I:30286'
G[30286]='K0902 L090 A:59337 T:59337 P:31243,31246 I:30285'
G[30287]='K0902 L090 A:58911 T:58911 P:31243,31246 I:31293'
G[30288]='K0902 L090 A:59336 T:59336 P:31243,31246'
G[30289]='K0902 L090 A:58911 T:58911 P:31243,31246 I:30290'
G[30290]='K0902 L090 A:58911 T:58911 P:31243,31246 I:30289'
G[30291]='K0902 L090 A:59343 T:59343 P:31131 I:30265,30338 Z17128 D014'
G[30292]='K0902 L090 A:58471 T:58471 P:30307+W0041+W0061+W0031+W0051 I:30293,31131,31242,31243 Z17128 D023'
G[30293]='K0902 L090 A:58471 T:58467 P:30307+W0041+W0061+W0031+W0051 I:30292,31131,31242,31243 Z17128 D023'
G[30294]='K0900 L090'
G[30295]='K0010 L001'
G[30296]='K0902 L090 A:58911 T:58911 P:30285|30286+30288+30289|30290+30287|31293+U4F550999|31246 I:30297'
G[30297]='K0902 L090 A:58911 T:58911 P:30285|30286+30288+30289|30290+30287|31293+U4F550999|31246 I:30296'
G[30298]='K0902 L090 A:59332 T:59332 P:31244,31295'
G[30299]='K0902 L090 A:59334 T:59334 P:31244,31295 I:30481'
G[30300]='K0902 L090 A:59334 T:59334 P:31244,31295'
G[30301]='K0902 L090 A:59332 T:59332 Z17128'
G[30302]='K0902 L090 A:59332 T:59332 P:30298+30305'
G[30303]='K0900 L090'
G[30304]='K0902 L090 A:58504 T:58504 P:31240,31248,31294,31296 Z17128 D011'
G[30305]='K0902 L090 A:59333 T:59333 P:31244,31295'
G[30306]='K0902 L090 A:58919 T:58919 P:30385,31247'
G[30307]='K0902 L090 A:58408 T:58408 P:30638 Z17128'
G[30308]='K0902 L090 A:558465 T:558465 P:30638 I:30309,30310,31757 Z17128 D005'
G[30309]='K0902 L090 A:558465 T:558465 P:30638 I:30308,30310,31757 Z17128 D005'
G[30310]='K0902 L090 A:558465 T:558465 P:30638 I:30308,30309,31757 Z17128 D005'
G[30311]='K0900 L090'
G[30312]='K0902 L090 A:558468 T:558468 P:30638 I:30320,31755 Z17128 D004'
G[30313]='K0902 L090 A:59342 T:59342 P:31131 I:30314,30341 Z17128 D016'
G[30314]='K0902 L090 A:59342 T:59342 P:31131 I:30313,30341 Z17128 D016'
G[30315]='K0010 L001'
G[30316]='K0902 L090'	-- A:58467
G[30317]='K0902 L090 A:57298 T:57298 P:30257 I:30318,30319,30321,30322'
G[30318]='K0902 L090 A:58707 T:58707 P:30257 I:30317,30319,30321,30322'
G[30319]='K0902 L090 A:557402 T:557402 P:30257 I:30317,30318,30321,30322'
G[30320]='K0902 L090 A:558468 T:558468 P:30638 I:30312,31755 Z17128 D004'
G[30321]='K0902 L090 A:58710 T:58710 P:30257 I:30317,30318,30319,30322'
G[30322]='K0902 L090 A:58706 T:58706 P:30257 I:30317,30318,30319,30321'
G[30323]='K0902 L090 A:558761 T:558761 P:30257 I:30324,30325,30326,30327'
G[30324]='K0902 L090 A:558709 T:558709 P:30257 I:30323,30325,30326,30327'
G[30325]='K0902 L090 A:58708 T:58708 P:30257 I:30323,30324,30326,30327'
G[30326]='K0902 L090 A:58705 T:58705 P:30257 I:30323,30324,30325,30327'
G[30327]='K0902 L090 A:58647 T:58647 P:30257 I:30323,30324,30325,30326'
G[30328]='K0902 L090 A:58715 T:58715 P:30257 I:30329,30330,30331,30332'
G[30329]='K0902 L090 A:58713 T:58713 P:30257 I:30328,30330,30331,30332'
G[30330]='K0902 L090 A:58716 T:58716 P:30257 I:30328,30329,30331,30332'
G[30331]='K0902 L090 A:58714 T:58714 P:30257 I:30328,30329,30330,30332'
G[30332]='K0902 L090 A:58712 T:58712 P:30257 I:30328,30329,30330,30331'
G[30333]='K0902 L090 A:58646 T:558646 P:30257 I:30334,30335,30336,30337'
G[30334]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30335,30336,30337'
G[30335]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30334,30336,30337'
G[30336]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30334,30335,30337'
G[30337]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30334,30335,30336'
G[30338]='K0902 L090 A:59343 T:59343 P:31131 I:30265,30291 Z17128 D014'
G[30339]='K0902 L090 A:59341 T:59341 P:31131 I:30340 Z17128 D013'
G[30340]='K0902 L090 A:59341 T:59341 P:31131 I:30339 Z17128 D013'
G[30341]='K0902 L090 A:59342 T:59342 P:31131 I:30313,30314 Z17128 D016'
G[30342]='K0902 L090 A:59343 T:59343 P:31131 I:30284 Z17128 D015'
G[30343]='K0850 L085'
G[30344]='K0870 L086 A:58745 T:58745 P:30274'
G[30345]='K0860 L086'
G[30346]='K0870 L086 A:58745 T:-857 P:30344+30350+30384'	-- TODO: Verify requires 30384
G[30347]='K0870 L086 A:-857 T:58745 P:30346'
G[30348]='K0870 L086 A:58745 T:58745 P:30347+30349+30351'	-- TODO: Verify requires 30347
G[30349]='K0870 L086 A:58735 T:58735 P:30344+30350+30384'	-- TODO: Verify requires 30384
G[30350]='K0870 L086 A:56114 T:56114 P:30274'
G[30351]='K0870 L086 A:56114,556114 T:58814,556114 P:30344+30350+30384'	-- TODO: Need to identify that 556114 is used if you complete 30346 and/or take 30347 because no longer will 58814 be a valid turnin	-- TODO: Verify requires 30384
G[30352]='K0870 L086 A:58779 T:58779 I:30126'
G[30353]='K0870 L086 A:58779 T:58779 I:30125'
G[30354]='K0870 L086 A:58821 T:58821 P:30363,30465'
G[30355]='K0870 L086 A:556114 T:556114 P:30363,30465'
G[30356]='K0870 L086 A:58821 T:58821 P:30363,30465'
G[30357]='FA K0870 L086 A:558745 T:558745 P:30354+30355+30356'	-- TODO: Verify requires 30354 30355 30356 (or is it the acceptance of 30361 that does it?)
G[30358]='K0850 L085'
G[30359]='K0870 L086 A:558745 T:500072 P:30357+30361'
G[30360]='FA K0870 L086 A:58821 T:556720 P:29990+30117+30273+30445 I:30241,30376'	-- P:30629
G[30361]='K0880 L086 A:558630 T:58954 P:30354+30355+30356 I:30175'	-- TODO: Verify requires 30355
G[30362]='K0850 L085'
G[30363]='K0870 L086 A:58735 T:58821 P:30348 I:30465'
G[30364]='K0850 L085'
G[30365]='K0000 L000'
G[30366]='K0000 L000'
G[30367]='K0000 L000'
G[30368]='K0000 L000'
G[30369]='K0000 L000'
G[30370]='K0000 L000'
G[30371]='K0000 L000'
G[30372]='K0000 L000'
G[30373]='K0000 L000'
G[30374]='K0000 L000'
G[30375]='K0870 L086 I:30268'
G[30376]='K0870 L086 A:59719 T:56720 P:29990+30117+30273+30445|30174 I:30241,30360'	-- P:30629
G[30377]='K0850 L085'
G[30378]='K0850 L085'
G[30379]='SP K0901 L090 A:58706 T:58706 P:30257+K100079264+U50183999'
G[30380]='SP K0901 L090 A:58706 T:58706 P:30257+K100079267+U50183999'
G[30381]='SP K0901 L090 A:58647,558647 T:58647,558647 P:30257+K100079266+U4FB83999'
G[30382]='SP K0901 L090 A:58647,558647 T:58647,558647 P:30257+K100079265+U4FB83999'
G[30383]='SP K0901 L090 A:58647,558647 T:58647,558647 P:30257+K100079268+U4FB83999'
G[30384]='K0870 L086 A:58735 T:58735 P:30274'
G[30385]='K0902 L090 A:59338 T:58919 P:W0024+31242+T4F550999 I:31294,31295 Z17128'
G[30386]='SP K0902 L090 A:58647,558647 T:58647,558647 P:30257+K100074651+U4FB83999'	-- Shrimp Dumplings Z104307
G[30387]='SP K0901 L090 A:58706 T:58706 P:30257+K100079266+U50183999'
G[30388]='SP K0901 L090 A:58706 T:58706 P:30257+K100079265+U50183999'
G[30389]='SP K0901 L090 A:58706 T:58706 P:30257+K100079268+U50183999'
G[30390]='SP K0902 L090 A:58706 T:58706 P:30257+K100074644+U50183999'	-- Swirling Mist Soup Z104304
G[30391]='SP K0901 L090 A:58707,558707 T:58707,558707 P:30257+K100079264+U4FC83999'
G[30392]='SP K0901 L090 A:58707,558707 T:58707,558707 P:30257+K100079267+U4FC83999'
G[30393]='SP K0901 L090 A:58707,558707 T:58707,558707 P:30257+K100079266+U4FC83999'
G[30394]='SP K0901 L090 A:58707,558707 T:58707,558707 P:30257+K100079265+U4FC83999'
G[30395]='SP K0901 L090 A:58707,558707 T:58707,558707 P:30257+K100079268+U4FC83999'
G[30396]='SP K0902 L090 A:58707,558707 T:58707,558707 P:30257+K100074649+U4FC83999'	-- Braised Turtle Z104305
G[30397]='SP K0901 L090 A:58709,558709 T:58709,558709 P:30257+K100079264+U4FD83999'
G[30398]='SP K0901 L090 A:58709,558709 T:58709,558709 P:30257+K100079267+U4FD83999'
G[30399]='SP K0901 L090 A:58709,558709 T:58709,558709 P:30257+K100079266+U4FD83999'
G[30400]='SP K0901 L090 A:58709,558709 T:58709,558709 P:30257+K100079265+U4FD83999'
G[30401]='SP K0901 L090 A:58709,558709 T:58709,558709 P:30257+K100079268+U4FD83999'
G[30402]='SP K0902 L090 A:58709,558709 T:58709,558709 P:30257+K100074647+U4FD83999'	-- Valley Stir Fry Z104302
G[30403]='SP K0901 L090 A:558708,58708 T:558708,58708 P:30257+K100079264+U4FE83999'
G[30404]='SP K0901 L090 A:558708,58708 T:558708,58708 P:30257+K100079267+U4FE83999'
G[30405]='SP K0901 L090 A:558708,58708 T:558708,58708 P:30257+K100079266+U4FE83999'
G[30406]='SP K0901 L090 A:558708,58708 T:558708,58708 P:30257+K100079265+U4FE83999'
G[30407]='SP K0901 L090 A:558708,58708 T:558708,58708 P:30257+K100079268+U4FE83999'
G[30408]='SP K0902 L090 A:558708,58708 T:558708,58708 P:30257+K100074645+U4FE83999'	-- Eternal Blossom Fish Z104299
G[30409]='SP K0901 L090 A:557402,57402 T:557402,57402 P:30257+K100079264+U4FF83999'
G[30410]='SP K0901 L090 A:557402,57402 T:557402,57402 P:30257+K100079267+U4FF83999'
G[30411]='SP K0901 L090 A:557402,57402 T:557402,57402 P:30257+K100079266+U4FF83999'
G[30412]='SP K0901 L090 A:557402,57402 T:557402,57402 P:30257+K100079265+U4FF83999'
G[30413]='SP K0901 L090 A:557402,57402 T:557402,57402 P:30257+K100079268+U4FF83999'
G[30414]='SP K0902 L090 A:557402,57402 T:557402,57402 P:30257+K100074642+U4FF83999'	-- Charbroiled Tiger Steak Z104298
G[30415]='SP K0901 L090'	--  A:58709,558709 T:58709,558709 P:30257+K100079264+U4FD83999
G[30416]='SP K0901 L090 A:57298,557298 T:57298,557298 P:30257+K100079264+U50383999'
G[30417]='SP K0901 L090 A:57298,557298 T:57298,557298 P:30257+K100079267+U50383999'
G[30418]='SP K0901 L090 A:57298,557298 T:57298,557298 P:30257+K100079266+U50383999'
G[30419]='SP K0901 L090 A:57298,557298 T:57298,557298 P:30257+K100079265+U50383999'
G[30420]='SP K0901 L090 A:57298,557298 T:57298,557298 P:30257+K100079268+U50383999'
G[30421]='SP K0902 L090 A:57298,557298 T:57298,557298 P:30257+K100074654+U50383999'	-- Wildfowl Roast Z104310
G[30422]='SP K0901 L090 A:58705,558705 T:58705,558705 P:30257+K100079264+U50283999'
G[30423]='SP K0901 L090 A:58705,558705 T:58705,558705 P:30257+K100079267+U50283999'
G[30424]='SP K0901 L090 A:58705,558705 T:58705,558705 P:30257+K100079266+U50283999'
G[30425]='SP K0901 L090 A:58705,558705 T:58705,558705 P:30257+K100079265+U50283999'
G[30426]='SP K0901 L090 A:58705,558705 T:58705,558705 P:30257+K100079268+U50283999'
G[30427]='SP K0902 L090 A:58705,558705 T:58705,558705 P:30257+K100074655+U50283999'	-- Twin Fish Platter Z104311
G[30428]='SP K0901 L090 A:58761 T:58761 P:30257+K100079264+U50083999'
G[30429]='SP K0901 L090 A:58761 T:58761 P:30257+K100079267+U50083999'
G[30430]='SP K0901 L090 A:58761 T:58761 P:30257+K100079266+U50083999'
G[30431]='SP K0901 L090 A:58761 T:58761 P:30257+K100079265+U50083999'
G[30432]='SP K0901 L090 A:58761 T:58761 P:30257+K100079268+U50083999'
G[30433]='SP K0902 L090 A:58761 T:58761 P:30257+K100074652+U50083999'	-- Fire Spirit Salmon Z104308
G[30434]='SP K0901 L090 A:58710 T:58710 P:30257+K100079264+U4F983999'
G[30435]='SP K0901 L090 A:58710 T:58710 P:30257+K100079267+U4F983999'
G[30436]='SP K0901 L090 A:58710 T:58710 P:30257+K100079266+U4F983999'
G[30437]='SP K0901 L090 A:58710 T:58710 P:30257+K100079265+U4F983999'
G[30438]='SP K0901 L090 A:58710 T:58710 P:30257+K100079268+U4F983999'
G[30439]='SP K0902 L090 A:58710 T:58710 P:30257+K100074643+U4F983999'	-- Sauteed Carrots Z104301
G[30442]='K0900 L090'
G[30443]='K0860 L086'
G[30444]='K0902 L090 A:58919 T:58919 P:30240|30242+30306 I:30243,30266'
G[30445]='K0870 L086 A:58970 T:58821 P:30359'	-- OEC:30629 OPC:29990+30117+30273
G[30449]='K0900 L001'
G[30450]='K0900 L001'
G[30451]='K0900 L001 A:100079326 T:14847'
G[30452]='K0900 L001 A:100079323 T:14847'
G[30453]='K0000 L000 T:63367'	-- this seems to have been completed when the boat ride happened (quest 31285)
G[30454]='K0100 L000'
G[30455]='K0100 L000'
G[30457]='K0870 L087 A:59073 T:59073'
G[30458]='K0860 L085 T:55333'
G[30459]='K0870 L087 A:59076 T:59076'
G[30460]='K0870 L087 A:59077 T:59077'
G[30461]='FH K0860 L086 A:57744 T:58547 I:30133,30178,30462'	-- why is this one triggered?
G[30462]='K0860 L086 I:30133,30178,30461'
G[30464]='K0870 L086 I:30132'
G[30465]='K0870 L086 A:58735 T:58821 P:30348 I:30363'
G[30466]='FH K0860 L085 A:57108 T:57108 P:1'
G[30467]='K0870 L087 A:59263 T:59272 O:31451,31452'
G[30468]='K0870 L087 A:59273 T:59273'
G[30469]='K0870 L087 A:59263 T:59263'
G[30470]='K0902 L090 A:64464 T:558761 P:30257 I:30471,30472,30473,30474,30475,30476,30477,30478,30479'
G[30471]='K0902 L090 A:64464 T:558709 P:30257 I:30470,30472,30473,30474,30475,30476,30477,30478,30479'
G[30472]='K0902 L090 A:64464 T:58708 P:30257 I:30470,30471,30473,30474,30475,30476,30477,30478,30479'
G[30473]='K0902 L090 A:64464 T:58705 P:30257 I:30470,30471,30472,30474,30475,30476,30477,30478,30479'
G[30474]='K0902 L090 A:64464 T:58647 P:30257 I:30470,30471,30472,30473,30475,30476,30477,30478,30479'
G[30475]='K0902 L090 A:64464 T:57298 P:30257 I:30470,30471,30472,30473,30474,30476,30477,30478,30479'
G[30476]='K0902 L090 A:64464 T:58707 P:30257 I:30470,30471,30472,30473,30474,30475,30477,30478,30479'
G[30477]='K0902 L090 A:64464 T:57402 P:30257 I:30470,30471,30472,30473,30474,30475,30476,30478,30479'
G[30478]='K0902 L090 A:64464 T:58710 P:30257 I:30470,30471,30472,30473,30474,30475,30476,30477,30479'
G[30479]='K0902 L090 A:64464 T:58706 P:30257 I:30470,30471,30472,30473,30474,30475,30476,30477,30478'
G[30480]='K0870 L087 A:560973 T:500076 P:30468+30496+30967'	-- TODO: Verify 30496 and 30967 are required
G[30481]='K0902 L090 A:59333 T:59333 P:31244,31295 I:30299'
G[30482]='K0902 L090 A:-811 T:58470 P:30281'
G[30483]='K0900 L090'
G[30484]='K0860 L085 A:57108 T:57108 P:1'
G[30485]='FH K0860 L085 A:59377 T:59411 P:1 I:31362'
G[30486]='K0000 L000'
G[30487]='K0880 L087 A:59696 T:60175 P:30601+30618+30621'
G[30488]='K0880 L087 A:59353 T:61693 O:31456,31457'
G[30489]='K0880 L087 A:59353 T:59353'
G[30490]='K0880 L087'	-- I:30587
G[30491]='K0880 L087 A:61693 T:59354 P:30488'
G[30492]='K0880 L087 A:59354 T:59371 P:30491+30587'
G[30495]='K0860 L085 A:59391 T:59391 P:29931'
G[30496]='K0870 L087 A:60973 T:560973'
G[30498]='FA K0860 L085 A:57242 T:55122 P:30000'
G[30499]='FH K0860 L085 A:57242 T:57108 P:30000'
G[30500]='K0860 L085 A:59418 T:59418 P:31303'
G[30501]='K0010 L001'
G[30502]='K0860 L085 A:59418 T:59418 P:31303'
G[30504]='FH K0860 L085 A:59418 T:59418 P:31303 I:31319'
G[30506]='FA K0870 L087 A:59076 T:59441 P:30457+30459+30460 I:30507,30508'	-- TODO: Verify requires 30457 
G[30507]='FA K0870 L087 A:59073 T:59441 P:30457+30459+30460 I:30506,30508'	-- TODO: Verify requires 30457 
G[30508]='FA K0870 L087 A:59077 T:59441 P:30457+30459+30460 I:30506,30507'	-- TODO: Verify requires 30457 
G[30509]='FH K0870 L087 A:59076 T:59442 P:30457+30459+30460 I:30510,30511'	-- TODO: Verify requires 30457
G[30510]='FH K0870 L087 A:59073 T:59442 P:30457+30459+30460 I:30509,30511'	-- TODO: Verify requires 30457
G[30511]='FH K0870 L087 A:59077 T:59442 P:30457+30459+30460 I:30509,30510'	-- TODO: Verify requires 30457
G[30512]='FA K0870 L087 A:59441 T:63542 P:30506,30507,30508'	-- I:30513
G[30513]='FH K0870 L087 A:59442 T:563535 P:30509,30510,30511'	-- I:30512
G[30514]='FA K0870 L087 A:63542 T:563542 P:30512'	-- I:30515
G[30515]='FH K0870 L087 A:563535 T:500084 P:30513'	-- I:30514
G[30516]='K0900 L090 A:57385 T:57385 P:30260 ODC:30530,30531'
G[30517]='K0900 L090 A:558646 T:57298,557298 P:T4F867250'
G[30518]='K0900 L090 A:57298,557298 T:57298,557298 P:30517'
G[30519]='K0900 L090 A:558646 T:64597 P:T4F871498'	-- Tillers rep went from 8224 to 8499 Revered, so assuming 8499 for now
G[30520]='K0900 L090'
G[30521]='K0900 L090 A:558646 T:57402,557402 P:T4F879799'
G[30522]='K0900 L090 A:57402,557402 T:558646 P:30521'
G[30523]='K0900 L090 A:558646 T:58705,558705 P:T4F862999'
G[30524]='K0900 L090 A:58705,558705 T:58705,558705 P:30523 ODC:30532,30533'
G[30525]='K0900 L090 A:558646 T:558646 P:30522'
G[30526]='K0900 L090 A:59533 T:59533 P:T4F875599'	-- Revered +12600
G[30527]='K0900 L090 A:558646 T:558646 P:30525'
G[30528]='K0900 L090 A:558646 T:558646 P:30527+T4F882999'	-- reports are Tillers Revered +20000. I know for a fact I had +20053 and it was available 
G[30529]='K0900 L090 A:558646 T:57402,557402 P:30528+T4F883999 ODC:30573,30574'
G[30530]='K0000 L000 T:57385'
G[30531]='K0000 L000 T:57385 J:30516'
G[30532]='K0000 L000 T:58705'
G[30533]='K0000 L000 T:58705 J:30524'
G[30534]='K0900 L090 A:1215705 T:1215705 P:30574+R114624+i114624+J6551+T4F883999'
G[30535]='K0870 L085 A:558646 T:558646 P:30252'
G[30536]='K0000 L000'
G[30537]='K0000 L000'
G[30538]='K0000 L000'
G[30539]='K0000 L000'
G[30540]='K0000 L000'
G[30541]='K0000 L000'
G[30542]='K0000 L000'
G[30543]='K0000 L000'
G[30544]='K0000 L000'
G[30545]='K0000 L000'
G[30546]='K0000 L000'
G[30547]='K0000 L000'
G[30548]='K0000 L000'
G[30549]='K0000 L000'
G[30550]='K0000 L000'
G[30551]='K0000 L000'
G[30552]='K0000 L000'
G[30553]='K0000 L000'
G[30554]='K0000 L000'
G[30555]='K0000 L000'
G[30556]='K0000 L000'
G[30557]='K0000 L000'
G[30558]='K0000 L000'
G[30559]='K0000 L000'
G[30560]='K0000 L000'
G[30561]='K0000 L000 T:72841'
G[30562]='K0000 L000'
G[30564]='K0000 L000'
G[30565]='FA K0860 L085 A:59550 T:59550 P:30000'	-- this was available when I was done with the Jade Temple...maybe earlier...who knows?
G[30566]='K0000 L000 T:72761'
G[30567]='K0902048 L090 A:59569 T:59569'
G[30568]='FA K0860 L085 A:55122 T:55122 P:30000'	-- this was available when I was done with the Jade Temple...maybe earlier...who knows?
G[30569]='K0870 L087 A:63754 T:59573 P:30514 I:30570'
G[30570]='K0870 L087 A:63751 T:59573 P:30515 I:30569'
G[30571]='K0870 L087 A:59573 T:59573 P:30569,30570'
G[30573]='K0000 L000 T:57402'
G[30574]='K0000 L000 T:57402 J:30529'
G[30575]='K0870 L087 A:559441 T:559441 P:30514 I:31256'
G[30581]='K0870 L087 A:59636 T:59636 P:30569,30570'
G[30582]='K0880 L087 A:100080241 T:59353'
G[30583]='K0870 L087 A:59450 T:59450 P:30514 I:31251'
G[30584]='K0002 L090 A:59584 T:59584 P:PF001 D001'
G[30585]='K0002 L090 A:60673 T:60673 P:PF001 D001'
G[30586]='K0002 L090 A:59584 T:59584 P:PF001 D001'
G[30587]='K0880 L087 A:59353 T:59353 P:30488'	-- I:30490
G[30588]='K0002 L090 A:59586 T:59586 P:PF525 D001'
G[30589]='K0090 L000 RA A:60042 T:60055 P:29795+30591'
G[30590]='K0090 L000 RA A:60055 T:60055 P:30589'
G[30591]='K0090 L000 RA A:55943 T:55943 P:29792'
G[30592]='K0880 L087 A:59701 T:59703'
G[30593]='K0870 L087 A:59451 T:59451 P:30514 I:30594'
G[30594]='K0870 L087 A:59449 T:59449 P:30515 I:30593'
G[30595]='K0870 L087 A:59821 T:59821 P:31256 I:30766'
G[30596]='K0870 L087'	-- I:30615,30619,30620
G[30597]='K0000 L085 A:100080240 T:66845 P:K100080240+PA500'
G[30598]='K0002 L090 A:60673 T:60673 P:PF001 D001'
G[30599]='K0880 L087 A:59452 T:59452 P:30602+30603'
G[30600]='K0880 L087 A:59452 T:59452 P:30603'
G[30601]='K0880 L087 A:59696 T:59696 P:30999'
G[30602]='K0880 L087 A:59701,59703,59755 T:59452 P:30592'
G[30603]='K0880 L087 A:59452 T:59452 P:30592'
G[30604]='K0880 L087 A:59452 T:59452 P:30603'
G[30605]='K0880 L087 A:59452 T:59894 P:30599+30600'
G[30606]='K0880 L087 A:59894 T:59452 P:30605'
G[30607]='K0880 L087 A:59894 T:59894 P:30605'
G[30608]='K0880 L087 A:59894 T:59894 P:30605'
G[30609]='K0880 L087'
G[30610]='K0880 L087 A:59894 T:59894 P:30607+30608'
G[30611]='K0880 L087 A:59452 T:59452 P:30607+30608'
G[30612]='K0880 L087 A:59452 T:59452 P:30607+30608'
G[30613]='K0002 L090 A:60135 T:60135 P:PF001 D001'
G[30614]='K0880 L087 A:59402 T:59402'
G[30615]='K0870 L087'	-- I:30596,30619,30620
G[30616]='K0880 L087 A:59597 T:59597'
G[30617]='K0880 L087 A:59597 T:59701 P:30614+30616+30808'
G[30618]='K0880 L087 A:59695 T:59695 P:30999'
G[30619]='K0870 L087 A:500071 T:500071 P:30514'	-- I:30596,30615,30620
G[30620]='K0870 L087 A:63535 T:63535 P:30515'	-- I:30596,30615,30619
G[30621]='K0880 L087 A:59716 T:59716 P:30999'
G[30622]='K0870 L086 A:556720 T:57198 P:30241,30360,30376'
G[30623]='K0870 L086 A:59855 T:-807 P:30241,30360,30376'
G[30624]='FA K0870 L086 A:500057 T:-807 P:30241,30360,30376 I:30653'
G[30625]='K0870 L086 A:57198 T:57198 P:30622+30623+30624|30653'
G[30626]='K0870 L086 A:57198 T:556720 P:30625'
G[30627]='K0870 L086 A:559856 T:556720 P:30626'
G[30628]='K0870 L086 A:556720 T:1211316 P:30627'
G[30629]='K0000 L000 J:29990+30117+30273+30445,29990+30117+30273+30174'	-- TODO: Verify requires 29990.  Later can verify requires 30445(Alliance)/30174(Horde)
G[30630]='K0870 L087'
G[30631]='K0870 L087 A:58468 T:58468 P:31512'
G[30632]='K0900 L090 A:58408 T:58465 P:30631+31384+S115913,30649+31385+S115913 Z17128'
G[30633]='K0900 L090 A:58465 T:58465 P:30632'
G[30634]='K0900 L090 A:58471 T:58471 P:30632'
G[30635]='K0900 L090 A:58465 T:58465 P:30633+30634'
G[30636]='K0900 L090 A:58465 T:58465 P:30633+30634'
G[30637]='K0900 L090 A:-100811 T:58465 P:30633+30634 I:30654'
G[30638]='K0900 L090 A:66769 T:58408 P:30635+30636+30637|30654'	-- TODO: Verify requires 30635
G[30639]='K0900 L090 A:59332,58408,59340 T:59332,58408,59340 P:T4F550999'
G[30640]='K0900 L090 A:59905 T:59905 P:T4F562999 Z17128'
G[30641]='K0900 L090 A:59905 T:59905 P:30640 Z17128'
G[30642]='K0900 L090 A:59905 T:559905 P:30641 Z17128'
G[30643]='K0900 L090 A:58408 T:559905 P:30642+T4F583999'
G[30644]='K0900 L090 A:559905 T:500084 P:30643'
G[30645]='K0900 L090 A:500084 T:59906 P:30644'
G[30646]='K0900 L090 A:59906 T:558465 P:30645'
G[30647]='K0000 L000'
G[30648]='K0860 L085 A:59899 T:-807 P:30500+30502+30504|31319'
G[30649]='K0870 L087 A:58468 T:58468 P:31511 Z17056'	-- an arbitrary date for removal
G[30650]='K0870 L087 A:500071 T:559441,500073 P:30619+31252'	-- I:30655
G[30651]='K0870 L087 A:59450 T:59450 P:30619+31252'	-- I:30656
G[30652]='K0870 L087 A:559441 T:-809 P:30619+31252'	-- I:30657
G[30653]='FH K0870 L086 A:60021 T:-807 P:30241,30360,30376 I:30624'
G[30654]='K0900 L090 A:58465 T:58465 P:30633+30634 I:30637'
G[30655]='K0870 L087 A:63535 T:59442 P:30620+31253'	-- I:30650
G[30656]='K0870 L087 A:59448 T:59448 P:30620+31253'	-- I:30651
G[30657]='K0870 L087 A:59442 T:-809 P:30620+31253'	-- I:30652
G[30658]='K0002 L090 A:60135 T:60135 P:PF001 D001'
G[30660]='K0870 L087 A:-809 T:500073 P:30652 I:30662'	-- I:30661,30662,30663
G[30661]='K0870 L087 A:-809 T:59442 P:30657 I:30663'	-- I:30660,30662,30663
G[30662]='K0870 L087 A:500073 T:500073 P:30652 I:30660'	-- I:30660,30661,30663
G[30663]='K0870 L087 A:59442 T:59442 P:30657 I:30661'	-- I:30660,30661,30662
G[30665]='K0870 L087 A:60161 T:60161 P:30514 O:31455'
G[30666]='K0870 L086 A:60173 T:60173'
G[30667]='K0870 L086 A:60182 T:60182'
G[30668]='K0870 L086 A:60173 T:60173 P:30666'
G[30669]='K087 L086 A:60173 T:60139 P:30668'
G[30670]='K0870 L087 A:60161 T:60161 P:30514'
G[30671]='K0870 L086 A:60139 T:60139 P:30669'
G[30672]='K0870 L086 A:60139 T:60173 P:30671'
G[30673]='K0870 L087 I:30680,30681,30682'
G[30674]='K0870 L086 A:-110857 T:-857 P:B30672'	-- TODO: See if this requires me to be on 30672 currently.  It seems like it would. P:B30672
G[30675]='K0870 L086 A:100080827 T:-857'
G[30677]='K0870 L086'
G[30678]='K0002 L090 A:60136 T:60136 P:PF001 D001'
G[30680]='K0870 L087 T:72841 I:30673,30681,30682'
G[30681]='K0870 L087 I:30673,30680,30682'
G[30682]='K0870 L087 A:60178 T:60161'	--  I:30673,30680,30681 (from beta server checks)
G[30683]='K0880 L087 A:60175 T:60175 P:30487'
G[30684]='K0880 L087 A:60175 T:60795 P:30683 ODC:31306'
G[30690]='K0870 L087 A:60161 T:60161 P:30670'
G[30691]='K0870 L086 A:60139 T:-857,60139 P:30669'
G[30692]='K0880 L087 A:59703 T:59755 P:30612'
G[30694]='K0870 L086 A:59138 T:59138 P:30269'
G[30695]='K0870 L086 A:59138 T:59608 P:30268+30270+30694'
G[30698]='K0002 L090 A:60136 T:60136 P:PF001 D001'
G[30699]='K0880 L087 A:60161 T:61816 P:30690'
G[30700]='K0002 L090 A:59586 T:59586 P:PF001 D001'
G[30701]='K0002 L090 A:60675 T:60675 P:PF001 D001'
G[30704]='K0000 L000'
G[30705]='K0000 L000'
G[30706]='K0000 L000'
G[30710]='K0870 L087'
G[30714]='K0870 L087'
G[30715]='K0880 L087 A:500080 T:500080 P:30699'
G[30716]='K0902 L090 A:60528 T:60528 P:T4F562999 I:V0221,V0251,V0271,V0281,V0291,V0301,V0321,V0331,V0421 D031'
G[30717]='K0902 L090 A:60529 T:60529 P:T4F562999 I:V0221,V0251,V0271,V0281,V0291,V0301,V0321,V0331,V0421 D031'
G[30718]='K0902 L090 A:60506 T:60506 P:T4F562999 I:V0221,V0251,V0271,V0281,V0291,V0301,V0321,V0331,V0421 D031'
G[30719]='K0900 L090'	-- It appears the way Blizzard records where you are in the progress with the Chi-Ji battles
G[30720]='K0900 L090'	-- is by recording the 15 different completions in the "bits" of the quests 30719 - 30722,
G[30721]='K0900 L090 T:72763'	-- which we can use, but the UI would be horrible as it would not mean anything to the user.
G[30722]='K0900 L090'	-- Therefore, using having ever completed works, except of course if someone comes into the middle of the chain without having used Grail before.
G[30723]='K0880 L087 A:61816 T:61816 P:30699'
G[30724]='K0880 L087 A:61816 T:61454 P:30715+30723'	--  I:30765 (which is what the server did on beta)
G[30725]='K0902 L090 A:60506 T:60506 P:W0313 I:H30725'
G[30726]='K0902 L090 A:60506 T:60506 P:W0313+H30725 I:H30726'
G[30727]='K0902 L090 A:60506 T:60506 P:W0313+H30726 I:H30727'
G[30728]='K0902 L090 A:60506 T:60506 P:W0313+H30727 I:H30728'
G[30729]='K0902 L090 A:60506 T:60506 P:W0313+H30728 I:H30729'
G[30730]='K0902 L090 A:60506 T:60506 P:W0313+H30729 I:H30730'
G[30731]='K0902 L090 A:60506 T:60506 P:W0313+H30730 I:H30731'
G[30732]='K0902 L090 A:60506 T:60506 P:W0313+H30731 I:H30732'
G[30733]='K0902 L090 A:60506 T:60506 P:W0313+H30732 I:H30733'
G[30734]='K0902 L090 A:60506 T:60506 P:W0313+H30733 I:H30734'
G[30735]='K0902 L090 A:60506 T:60506 P:W0313+H30734 I:H30735'
G[30736]='K0902 L090 A:60506 T:60506 P:W0313+H30735 I:H30736'
G[30737]='K0902 L090 A:60506 T:60506 P:W0313+H30736 I:H30737'
G[30738]='K0902 L090 A:60506 T:60506 P:W0313+H30737 I:H307308'
G[30739]='K0902 L090 A:60506 T:60506 P:W0313+H30738 I:H30739'
G[30740]='K0902 L090 A:60506 T:60506 P:W0313+H30739'
G[30742]='K0880 L087 A:60596 T:60596 I:30823'
G[30743]='K0880 L087 A:60596 T:60596 I:30824'
G[30744]='K0880 L087 A:60503 T:-809,60503 I:30825'
G[30745]='K0880 L087 A:60503 T:60503 I:30826'
G[30746]='K0880 L087 A:-809 T:560679 P:30744,30825'
G[30747]='K0880 L087 A:60679 T:60679 P:30746'
G[30750]='K0880 L087 A:61454 T:61454 P:30724'
G[30751]='K0880 L087 A:61820 T:61820 P:30724'
G[30752]='K0880 L087 A:561819 T:62227 P:30993'
G[30753]='K0002 L090 A:60674 T:60674 P:PF001 D001'
G[30754]='K0002 L090 A:60674 T:60674 P:PF001 D001'
G[30757]='K0890 L087 A:62236 T:56884 O:31030'
G[30759]='K0010 L001'
G[30763]='K0002 L090 A:60675 T:60675 P:PF001 D001'
G[30765]='K0880 L087 I:30724'
G[30766]='K0870 L087 P:1 I:30595'
G[30767]='K0090 L000 RA A:56416 T:56418 P:29798'
G[30768]='K0890 L088 A:62216 T:60684 P:30992 I:31386,31388,31695'
G[30769]='K0890 L088 A:60688 T:60684 P:30814'
G[30770]='K0890 L088 A:60688 T:60687 P:30814'
G[30771]='K0890 L088 A:60871 T:60687 P:30814'
G[30772]='K0890 L088 A:60684 T:60687 P:30769+30770+30771'
G[30773]='K0890 L088 A:60687 T:60687 P:30769+30770+30771'
G[30774]='K0890 L088 A:60684 T:60687 P:30769+30770+30771'
G[30775]='K0890 L088 A:60735 T:60735 P:30769+30770+30771'
G[30776]='K0890 L088 A:60684 T:560687 P:30772+30773+30774'
G[30777]='K0890 L088 A:560687 T:61261 P:30776'
G[30778]='K0890 L088 A:61261 T:61261 P:30777'
G[30779]='K0890 L088 A:60864 T:61261 P:30777'
G[30780]='K0890 L088 A:60864 T:60864 P:30777'
G[30781]='K08932 L088 A:60903 T:61261 P:30777'
G[30782]='K0890 L088 A:61261 T:61261 P:30827'	-- OEC:31607 OPC:30783
G[30783]='K0890 L088 A:60864 T:60864 P:30827'	-- OEC:31607 OPC:30782
G[30784]='K0890 L088 A:61261 T:61261 P:30782+30783'	--  P:31607
G[30785]='K0890 L088 A:61261 T:61066 P:30784'
G[30786]='K0890 L088 A:60857 T:60857 O:31894'
G[30787]='K0890 L088 A:60857 T:60857 P:30786'
G[30788]='K0890 L088 A:60857 T:60857 P:30787'
G[30789]='K0890 L088 A:60857 T:60857 P:30787'
G[30790]='K0890 L088 A:60622 T:60622 P:30815'
G[30791]='K0890 L088 A:60622 T:60622 P:30815'
G[30792]='K0890 L088 A:60622 T:60622 P:30815'
G[30793]='K0890 L088 A:60622 T:560622 P:30790+30791+30792'
G[30794]='K0870 L087 A:60694 T:60785 O:30816'	-- TODO: Determine if this really should be P 31298 instead
G[30795]='K0880 L087 A:560795 T:61297 P:30829'
G[30796]='K0880 L087 A:61297 T:61297 P:30795'
G[30797]='K0880 L087 A:1211754 T:61297 P:30684'
G[30798]='K0880 L087 A:61297 T:61297 P:30799'
G[30799]='K0880 L087 A:61297 T:61297 P:30797'	-- TODO: Verify that 30796 is not required
G[30800]='K0880 L087 A:61297 T:61297 P:30798'
G[30801]='K0880 L087 A:61297 T:61297 P:30800'
G[30802]='K0880 L087 A:61297 T:61297 P:30801'
G[30804]='K0880 L087 A:59353 T:59353 P:30582'
G[30805]='K0870 L087 A:60785 T:60785 P:30794'
G[30806]='K0870 L087 A:60785 T:60785 P:30794'
G[30807]='K0870 L087 A:60785 T:60785 P:30794'
G[30808]='K0880 L087 A:59371 T:59371'
G[30814]='K0890 L088 A:60688 T:60688 O:30768,31386,31388,31695'
G[30815]='K0890 L088 A:60857 T:60622 P:30788+30789'
G[30816]='K0870 L087 A:60436 T:60694 P:30935'
G[30817]='K0090 L000'
G[30818]='K0100 L000'
G[30819]='K0870 L087 A:60785 T:60436 P:30805+30806+30807'	-- TODO: Verify requires 30805 30806
G[30820]='K0870 L087 A:60436 T:60757 P:30819'
G[30821]='K0882 L087 A:60679 T:60679 P:30747'
G[30823]='K0880 L087 A:60678 T:60596 I:30742'
G[30824]='K0880 L087 A:60678 T:60596 I:30743'
G[30825]='K0880 L087 A:60677 T:60503 I:30744'
G[30826]='K0880 L087 A:60677 T:60503 I:30745'
G[30827]='K0890 L088 A:60864 T:60864 P:30778+30779+30780+30781'	-- TODO: Verify requires 30779 30781
G[30828]='K0870 L087 A:500076 T:61065 P:30480'
G[30829]='K0880 L087 A:60795 T:560795 P:30684'
G[30834]='K08732 L087 A:59272 T:59263 P:30467'
G[30854]='K0000 L000'
G[30855]='K0870 L087 A:61065 T:500076 P:30828'
G[30879]='K0902 L090 A:60968 T:60968 P:T4F562999 I:30880,V0221,V0251,V0261,V0281,V0301,V0311,V0321,V0331 D029'
G[30880]='K0902 L090 A:60968 T:60968 P:T4F562999 I:30879,V0221,V0251,V0261,V0281,V0291,V0311,V0321,V0331 D030'
G[30881]='K0902 L090 A:60968 T:60968 P:30879'
G[30882]='K0902 L090 A:60968 T:60968 P:30880'
G[30883]='K0902 L090 A:60968 T:60968 P:30881'
G[30884]='K0890 L088 A:61066 T:61469 O:30785 I:30936'
G[30885]='K0902 L090 A:60968 T:60968 P:30882'
G[30886]='K0000 L000'
G[30887]='K0890 L088 A:61469 T:61468 P:30884'
G[30888]='K0890 L088 A:61468 T:61468 P:30887'
G[30889]='K0890 L088 A:61467 T:61467 P:30887'
G[30890]='K0890 L088 A:61468 T:61468 P:30887'
G[30891]='K0890 L088 A:61470 T:61470'
G[30892]='K0890 L088 A:61470 T:61470 P:30891+30960'
G[30893]='K0890 L088 A:61066 T:61066 P:30960'
G[30894]='K0890 L088 A:61470 T:61470 P:30891+30960'
G[30895]='K0890 L088 A:61066 T:61066 P:30892+30893+30894'
G[30896]='K0890 L088 A:61881 T:61881 P:30960'
G[30897]='K0890 L088 A:61880 T:61880 P:30960'
G[30898]='K0890 L088 A:61066 T:561021 P:30895'
G[30899]='K0890 L088 A:62274 T:61020 P:30976'
G[30900]='K0890 L088 A:561021 T:61066 P:30898'
G[30901]='K0890 L088 A:61066 T:62436 P:30900'
G[30902]='K0902 L090 A:60968 T:60968 P:30885'
G[30907]='K0902 L090 A:60968 T:60968 P:30883'
G[30910]='K0900 L090'
G[30918]='K0900 L090'
G[30921]='K0890 L088 A:61482 T:61482'
G[30922]='K0890 L088 A:61625 T:61625'
G[30923]='K0890 L088 A:61482 T:61482'
G[30924]='K0890 L088 A:62547 T:61581 P:30921+30923'
G[30925]='K0890 L088 A:61581 T:61581 P:30924'
G[30926]='K0890 L088 A:61580 T:561482 P:30925'
G[30927]='K0890 L088 A:61584 T:61584 P:30925'
G[30928]='K0890 L088 A:61585 T:61585 P:30925'
G[30929]='K0890 L088 A:61161 T:61161 P:30921+30923'	-- at the moment the assumption is the same requirements as 30924
G[30930]='K0890 L088 A:561161 T:561161 P:30929'
G[30931]='K0890 L088 A:61539 T:61539 P:30921+30923'	-- TODO: Verify requires 30923
G[30932]='K0890 L088 A:61584 T:561539 P:30931'
G[30933]='K0900 L090 A:65341 T:65341 P:30932'
G[30934]='K0850 L085'
G[30935]='K0880 L087 A:61297 T:61371 P:30802 ODC:31205'
G[30936]='K0890 L088 T:72841 I:30884'
G[30941]='K0880 L087'
G[30942]='K0880 L087 A:61503 T:61534 P:30935'
G[30943]='K0880 L087 A:61495 T:61495 P:30935'
G[30944]='K0880 L087 A:61371 T:61371 P:30935'
G[30945]='K0880 L087 A:61496 T:61496 P:30935'
G[30946]='K0880 L087 A:63784 T:63784 P:31011'
G[30952]='K0902 L090 A:61580 T:61580 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30953]='K0902 L090 A:61585 T:61585 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30954]='K0902 L090 A:61581 T:61581 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30955]='K0902 L090 A:61583 T:61583 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30956]='K0902 L090 A:61580 T:61580 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30957]='K0902 L090 A:61584 T:61584 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30958]='K0902 L090 A:61583 T:61585 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30959]='K0902 L090 A:61581 T:61581 P:T4F562999 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30960]='K0890 L088 A:61468 T:61066 P:30888+30890'
G[30961]='K0000 L000'
G[30963]='K0890 L088 A:61625 T:61625'
G[30964]='K0890 L088 A:61625 T:61625'
G[30965]='K0900 L090'
G[30967]='K0870 L087 A:60973 T:60973'
G[30968]='K0890 L088 A:62275 T:62802 P:30981+31063+31064'	-- TODO: Verify requires 30981
G[30969]='FH K0160 L015 A:61716 T:61716'
G[30970]='K0890 L088 A:62436 T:62436 P:30901'
G[30971]='K0890 L088 A:62124 T:62124 P:30901'
G[30972]='K0890 L088 A:62124 T:61016 P:30970+30971'
G[30973]='K0890 L088 A:62273 T:62273 P:30972'
G[30974]='K0890 L088 A:61016 T:61016 P:1'	-- TODO: Figure out the rules governing this
G[30975]='K0890 L088 A:62730 T:62736 P:30973'
G[30976]='K0890 L088 A:62736 T:62274 P:30975'
G[30977]='K0890 L088 A:62278 T:62278 P:30976'
G[30978]='K0890 L088 A:61020 T:61020 P:30899'
G[30979]='K0890 L088 A:65690 T:62786 P:30978'
G[30980]='K0890 L088 A:62788 T:562274 P:30979'
G[30981]='K0890 L088 A:562274 T:62275 P:31065'
G[30982]='FH K0160 L015 A:61724 T:61724'
G[30983]='FH K0160 L015 A:61716 T:61716'
G[30984]='FH K0160 L015 A:61724 T:61724'
G[30986]='K0000 L000'
G[30987]='FA K0100 L000 RA A:60566 T:29611 P:31450'
G[30988]='K0100 L000 RA A:29611 T:61796 P:30987'
G[30989]='K0100 L000 RA A:61796 T:29611 P:30988'
G[30990]='K0000 L000'
G[30991]='K0880 L087 A:561820 T:561820 P:30994'
G[30992]='K0880 L087 A:561820 T:61819 P:30991'
G[30993]='K0880 L087 A:61819 T:561819 P:30992'
G[30994]='K0880 L087 A:61454 T:561820 P:30750+30751'	-- TODO: Verify required 30750
G[30995]='K0160 L015 A:61822 T:561822'
G[30996]='K0160 L015 A:61823 T:561823'
G[30997]='K0160 L015 A:61822 T:561822'
G[30998]='K0160 L015 A:61823 T:561823'
G[30999]='K0880 L087 A:61850 T:59696'	-- if 31460 is in the quest log one cannot see this quest until it is turned in
G[31000]='K0900 L089 A:62667 T:62112 I:31390,31391,31656,31847,31886,31895'
G[31001]='K0900 L089 A:62112 T:62166 O:31000,31390,31391,31656,31847,31886,31895'
G[31002]='K0900 L089 A:62112 T:62166'
G[31003]='K0900 L089 A:62166 T:62203 P:31001+31002'
G[31004]='K0900 L089 A:62203 T:62202 P:31003'
G[31005]='K0900 L089 A:62202 T:62202 P:31004'
G[31006]='K0900 L089 A:62202 T:62538 P:31005+31676'
G[31007]='K0900 L089 A:62538 T:62538 P:31006'
G[31008]='K0900 L089 A:64599 T:64599 P:31006'
G[31009]='K0900 L089 A:64815 T:-858 P:31006'	-- when this is completed, the Ancient Amber Chunk (44.77,41.58) becomes active [Malik the Unscathed]
G[31010]='K0900 L089 A:-858 T:62774 P:31009'
G[31011]='K0880 L087 A:61371 T:63750 P:30942+30943+30944+30945'	-- TODO: Verify requires 30942 30943 30944
G[31012]='FH K0100 L000 RA A:60570 T:39605 P:31450'	-- gets cleared when the Alliance version is done
G[31013]='K0100 L000 RA A:39605 T:62092 P:31012'	-- gets cleared when the Alliance version is done
G[31014]='K0100 L000 RA A:62092 T:39605,62092 P:31013'	-- gets cleared when the Alliance version is done
G[31015]='K0900 L090 A:61962 T:61962'
G[31016]='K0900 L090 I:31367,31368'
G[31017]='K0900 L090'
G[31018]='K0900 L089 A:62538 T:562151 P:T53962999+31005+31676'
G[31019]='K0900 L089 A:62538 T:65354 P:31066 ODC:31174'
G[31020]='K0900 L089 A:62232,562180 T:63328,562180 P:31019'
G[31021]='K0900 L089 A:62232,562180 T:63328,562180 P:31019'
G[31022]='K0900 L089 A:63328,562180 T:63328,562180 P:31020+31021'
G[31023]='K0900 L089 A:100082870 T:62232,562180'
G[31024]='K0902 L089 A:63758 T:63758 P:31092+31359 I:31238,31494,31506,V0081,V0091,V0101 D007'
G[31025]='K0900 L089'
G[31026]='K0900 L089 A:63328,562180 T:63328,562180 P:31022'
G[31027]='K0000 L000'
G[31028]='K0900 L089'
G[31030]='K0880 L087 A:62227 T:62236 P:30752 I:31031'
G[31031]='K0880 L087 I:31030'
G[31032]='K0890 L088 A:62573 T:62573 P:30976'	-- is this P correct?
G[31033]='K0150 L015'
G[31034]='FH K0150 L015 A:39605 T:61724 I:31036,31037'
G[31035]='FH K0150 L015'	-- seems does not really exist
G[31036]='FH K0150 L015 A:36648 T:61724 I:31034,31037'	-- tauren only?
G[31037]='FH K0150 L015 A:10181 T:61724 I:31034,31036'	-- undead only?
G[31038]='K0900 L090 A:62304 T:62304 P:T4F650999 I:V0241,V0341,V0401,V0411 D039'	-- only given when D035 quests are available
G[31039]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31040]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31041]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31042]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31043]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31044]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31045]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31046]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31047]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31048]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31049]='K0902 L090 A:-810 T:62304 P:31039+31040+31041+31046'	-- TODO: Verify requires 31046
G[31050]='K0900 L090'
G[31051]='K0900 L090'
G[31052]='K0900 L090'
G[31053]='K0900 L090'	-- when I accepted some dailies from Master Snowdrift *** TODO: Mark these dailies as setting this flag
G[31054]='K0900 L090'
G[31055]='K0900 L090 A:100083769 T:61962 P:J6716'
G[31058]='K0902048 L090 A:65289 T:62491'
G[31060]='K0000 L000'
G[31061]='K0902 L090 A:-810 T:62304 P:31042+31043+31047+31105'
G[31062]='K0902 L090 A:-810 T:62304 P:31044+31045+31048+31106'
G[31063]='K0890 L088 A:562274 T:62275 P:31065'
G[31064]='K0890 L088 A:562274 T:62275 P:31065'
G[31065]='K0890 L088 A:562274 T:562274 P:30980'
G[31066]='K0900 L089 A:64815 T:64815 P:31007+31010+31660'	-- TODO: Verify requires 31660
G[31067]='K0900 L089 A:62666 T:62666 P:31066 O:31730'
G[31068]='K0900 L089 A:1212389 T:62667 P:31066'
G[31069]='K0900 L089 A:62666 T:62666 P:31067+31068'
G[31070]='K0900 L089 A:62668 T:62668 P:31068'
G[31071]='K0900 L089 A:62859 T:62859 P:31068'
G[31072]='K0900 L089 A:62667 T:62667 P:31068'
G[31073]='K0900 L089 A:62666 T:62666 P:31069+31070'
G[31074]='K0900 L089 A:62667 T:62667 P:31072'
G[31075]='K0900 L089 A:62666 T:562666 P:31071+31073+31074+31078'
G[31076]='K0900 L089 I:31129'
G[31077]='K0900 L089 A:562779 T:67138 P:31076,31129'	-- TODO: Change 562779 to 567138
G[31078]='K0900 L089 A:67138 T:500077 P:31077'
G[31079]='K0900 L089 A:62772 T:62772 P:31075'
G[31080]='K0900 L089 A:562668 T:562668 P:31075'
G[31081]='K0900 L089 A:562667 T:562667 P:31075'
G[31082]='K0900 L089 A:62771 T:62771 P:31075'
G[31083]='K0900 L089 AK:62767 T:62771'
G[31084]='K0900 L089 A:62771 T:62771 P:31079+31080+31081+31082'	-- TODO: Verify requires 31079 31082
G[31085]='K0900 L089 A:562667 T:500078 P:31084'
G[31086]='K0900 L089 A:562666 T:500079 P:31084'
G[31087]='K0900 L089 A:64815 T:65365 P:31066'
G[31088]='K0900 L089 A:65365 T:65365 P:31087'
G[31089]='K0900 L089 A:65365 T:62540 P:31088+31090 ODC:31282'
G[31090]='K0900 L089 A:65365 T:65365 P:31087'
G[31091]='K09032 L089 A:63876 T:64344 P:31089,31682 ODC:31343'
G[31092]='K0900 L089 A:64490 T:63758 P:31091'
G[31093]='K0900 L090 A:100083770 T:61962 P:J6850'
G[31094]='K0900 L090 A:100083771 T:61962 P:J6846'
G[31095]='K0900 L090 A:100083772 T:61962 P:J6754'
G[31096]='K0900 L090 A:100083774 T:61962 P:J6858'
G[31097]='K0900 L090 A:100083773 T:61962 P:J6857'
G[31098]='K0900 L090'
G[31099]='K0900 L090'
G[31100]='K0900 L090 A:100083777 T:61962 P:J6847'
G[31101]='K0900 L090'
G[31102]='K0900 L090 A:100083779 T:61962 P:J6855'
G[31103]='K0900 L090 A:100083780 T:61962 P:J6856'
G[31104]='K0900 L090 A:62304 T:62304 P:T4F662999 I:V0241,V0341,V0401,V0411 D039'	-- available with D035
G[31105]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31106]='K0902 L090 A:62304 T:62304,62295,62378,62379,562295,562378,562379 P:T4F562999 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31107]='K0900 L089 A:562774 T:562774 P:31007+31010+31660'	-- TODO: Verify requires 31660
G[31108]='K0900 L089 A:64599 T:64599 P:31661'	-- TODO: Determine if this needs 31008 as well
G[31109]='K0902 L089 A:62538 T:62538 P:31066 I:31111,31231,31267,V0071,V0081,V0101 D009'
G[31110]='K0900 L090 A:62810 T:62810 P:T4F644999'	-- TODO: This is not the proper prerequisite as on 5.2 PTR Wholly shows it available when it is not actually.
G[31111]='K0902 L089 A:62538 T:62538 P:31066 I:31109,31231,31267,V0071,V0081,V0091 D010'
G[31112]='K0860 L085 A:62923 T:555521 P:29821'
G[31113]='K0902 L090 A:63009 T:63009,63195,63196,63197,563195,563196,563197 P:T4F562999 I:V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31114]='K0902 L090 A:63009 T:63009,63195,63196,63197,563195,563196,563197 P:T4F562999 I:V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31115]='K0010 L000'
G[31116]='K0902 L090 A:63009 T:63009,63195,63196,63197,563195,563196,563197 P:T4F562999 I:31118,V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31117]='K0902 L090 A:-810,63009 T:63009 P:31114+31116|31118 I:31120'
G[31118]='K0902 L090 A:63009,63195,63196,63197,563195,563196,563197 T:63197 P:T4F562999 I:31116,V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31119]='K0902 L090 A:63009 T:63009,63195,63196,63197,563195,563196,563197 P:T4F562999 I:V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31120]='K0902 L090 A:-810 T:63009 P:31113+31119 I:31117'
G[31121]='K0860 L085 A:55768 T:55768 P:29822'
G[31122]='K0900 L090'
G[31123]='K0900 L090'	-- This is marked on the server after having chosen Chao the Voice (63196), which of course is available after defeating her in combat.
G[31124]='K0900 L090'
G[31125]='K0900 L090'
G[31126]='K0900 L090'
G[31127]='K0900 L090 A:63009 T:63009 P:T4F650999 I:V0341,V0351,V0371,V0381,V0391,V0401 D041'	-- available with D024
G[31128]='K0900 L090 A:63009 T:63009 P:T4F662999 I:V0341,V0351,V0371,V0381,V0391,V0401 D041'	-- available with D024
G[31129]='K0900 L089 A:62779 T:62779 P:29907+31068 I:31076'
G[31130]='K0860 L085 A:54961 T:61218 P:29889'
G[31131]='K0902 L090 A:58408 T:59342 P:30307+W0041+W0061+W0031+W0051 I:31242,31243,V0231 Z17128'
G[31132]='K0860 L085 A:63193 T:63217 P:31121'
G[31133]='K0900 L089 A:63218 T:63218 P:31069+31070'
G[31134]='K0860 L085 A:63217 T:63217 P:31132'
G[31135]='K0010 L001 RN CO A:42396 T:63238 P:27674'
G[31136]='K0902 L090 A:58408 P:W0234+U4F550999'
G[31137]='K0020 L002 A:63238 T:42317 P:31135 I:26421,26422,26423,26424,26425'
G[31138]='K0030 L001 A:63238 T:63238 P:31135'
G[31139]='FA K0030 L001 RH CO A:197 T:197'
G[31140]='FA K0030 L001 RH CO A:197 T:197 P:31139'
G[31141]='FA K0030 L002 RH CO A:197 T:63258 P:31140'
G[31142]='FA K0030 L002 RH CO A:63258 T:63258 P:31141'
G[31143]='FA K0030 L001 RH CO A:63258 T:823 P:31142'
G[31144]='FA K0030 L001 RH CO A:823 T:823 P:31143'
G[31145]='FA K0040 L001 RH CO A:823 T:197 P:31144'
G[31146]='K0030 L002 RU CO A:1569 T:63272 P:26801'
G[31147]='K0030 L002 RU CO A:63272 T:63272 P:31146'
G[31148]='K0030 L002 RU A:63272 T:1661 P:24964,24965,24966,24967,24968,24969,31147 I:28651'
G[31150]='K0030 L002 RF CO A:37087 T:63285'
G[31151]='K0030 L002 A:63285 T:63285 P:31150'
G[31152]='K0860 L085 A:63217 T:63307 P:31134'
G[31153]='K0000 L000'
G[31154]='K0000 L000'
G[31155]='K0000 L000'
G[31156]='K0030 L002 CO A:3143 T:63296 P:25126'
G[31157]='K0030 L002 CO A:63296 T:63296 P:31156'
G[31158]='K0020 L001 CO A:63310 T:63310 P:31159'
G[31159]='K0020 L001 CO A:37951 T:63310'
G[31160]='K0030 L001 CO A:63310 T:63310 P:31158'
G[31161]='K0030 L001 CO A:63310 T:563310,63310 P:31160'
G[31162]='K0030 L001 CO A:563310,63310 T:63310 P:31161'
G[31163]='K0030 L001 CO A:63310 T:38966 P:31162'
G[31165]='FH K0030 L002 RT CO A:44927 T:63327'
G[31166]='K0030 L002 A:63327 T:63327 P:31165'
G[31167]='K0860 L085 A:63307 T:63307 P:31152'
G[31168]='FA K0030 L002 RE CO A:2077 T:63331 P:28714+28715'
G[31169]='K0030 L002 A:63331 T:63331 P:31168'
G[31170]='K0030 L002 RB CO A:15278 T:63332'
G[31171]='K0030 L002 A:63332 T:63332 P:31170'
G[31172]='K0030 L002'
G[31173]='FA K0030 L002 RD CO A:63335 T:63335 P:9409'
G[31174]='K0900 L089 T:65354'
G[31175]='K0900 L089 A:62538 T:63071 P:T53950999+31066'
G[31176]='K0900 L089 A:63071 T:63071 P:31175'
G[31177]='K0900 L089 A:63071 T:63071 P:31175'
G[31178]='K0900 L089 A:63071 T:63071 P:31175'
G[31179]='K0900 L089 A:63071 T:62538 P:31176+31177+31178'	-- TODO: Verify requires 31176
G[31181]='K0900 L089 A:63349 T:63349 P:31265 O:31727'
G[31182]='K0900 L089 A:63349 T:63349 P:31265'
G[31183]='K0900 L089 A:63349 T:63317 P:31181+31182'
G[31184]='K0900 L089 A:63317 T:63317 P:31183'
G[31185]='K0900 L089 A:63317 T:63317 P:31183'
G[31186]='K0900 L089 A:63955 T:63955 P:31183'	--	need to see if you need to summon Dog first, which would imply P:B31185 is correct
G[31187]='K0900 L089 A:63349 T:63349 P:31183'
G[31188]='K0900 L089 A:63349 T:63349 P:31183'
G[31189]='K0900 L089 A:63349 T:63349 P:31184+31187'
G[31190]='K0900 L089 A:563317 T:500075 P:31189'
G[31194]='K0902 L090 A:58564 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'
G[31195]='K0850 L085'	-- removed  I:29822 ... see comment there
G[31196]='K0902 L090 A:63614 T:63614,63622,63623,63624,563622,563623,563624 P:T4F562999 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31197]='K0902 L090 A:63614 T:63614,63622,63623,63624,563622,563623,563624 P:T4F562999 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31198]='K0902 L090 A:63614 T:63614,63622,63623,63624,563622,563623,563624 P:T4F562999 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31199]='K0902 L090 A:63614 T:63614,63622,63623,63624,563622,563623,563624 P:T4F562999 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31200]='K0902 L090 A:63614 T:63623 P:T4F562999 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31201]='K0902 L090 A:63614 T:63614,63622,63623,63624,563622,563623,563624 P:T4F562999 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31203]='K0902 L090 A:-810 T:63614 P:W0344 I:31204'
G[31204]='K0902 L090 A:-810 T:63614 P:W0344 I:31203'
G[31205]='K0000 L000 T:61371'
G[31206]='K0850 L084 I:27861,27862,27863'
G[31207]='K0900 L090 A:63315 T:63314 P:1'
G[31208]='K0900 L089 A:562151 T:562151 P:31018'
G[31209]='K0900 L089 A:562151 T:562151 P:31018'
G[31210]='K0900 L089 A:562151 T:562151 P:31018'
G[31211]='K0900 L089 A:562151 T:62151 P:31208+31209+31210'
G[31212]='K0000 L000'
G[31213]='K0000 L000'
G[31214]='K0000 L000'	-- When he is your companion for the dailies
G[31216]='K0902 L089 A:62151 T:62151 P:31208+31209+31210 I:31808'
G[31218]='K0000 L000'
G[31219]='K0000 L000'
G[31220]='K0900 L090 A:63614 T:63614 P:T4F650999 I:V0241,V0351,V0371,V0381,V0391,V0411 D040'	-- available with D034
G[31221]='K0900 L090 A:63614 T:63614 P:T4F662999 I:V0241,V0351,V0371,V0381,V0391,V0411 D040'	-- available with D034
G[31228]='K0880 L087 A:63784 T:63784 P:30946'
G[31230]='K0860 L085 A:56348 T:56348 P:29922,30015'
G[31231]='K0902 L089 A:62538 T:62538 P:31066 I:31109,31111,31267,V0071,V0091,V0101 D008'
G[31232]='K0902 L089 A:62180 T:62180 P:31026 I:31270,31496,31507,V0071,V0091,V0101 D008'
G[31233]='K0902 L089 A:62180 T:62180 P:31026 I:31269,31502,31508,V0071,V0091,V0101 D008'
G[31234]='K0902 L089 A:63072 T:63072 P:31606 I:31271,31503,31509,V0071,V0091,V0101 D008'
G[31235]='K0902 L089 A:62538 T:62538 P:31066 I:31268,31487,31505,V0071,V0091,V0101 D008'
G[31237]='K0902 L089 A:63785 T:63785 P:31458+31465 I:31272,31504,31510,V0071,V0091,V0101 D008'
G[31238]='K0902 L089 A:63758 T:63758 P:31092+31359 I:31024,31494,31506,V0071,V0091,V0101 D008'
G[31239]='FH K0860 L085 A:56336 T:56336 P:29941'
G[31240]='K0902 L090 A:59343 T:58503 P:W0131+W0141+W0151+W0161+T4F550999 I:31244,31245,31246,31247 Z17128'
G[31241]='K0860 L085 A:63748 T:56336 P:29879'
G[31242]='K0902 L090 A:58408 T:59338 P:30307+W0041+W0061+W0031+W0051 I:31131,31243,V0231 Z17128'
G[31243]='K0902 L090 A:58408 T:59337 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,V0231 Z17128'
G[31244]='K0902 L090 A:59343 T:59332 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31245,31246,31247 Z17128'
G[31245]='K0902 L090 A:59343 T:59338 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31244,31246,31247 Z17128'
G[31246]='K0902 L090 A:59343 T:58911 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31244,31245,31247 Z17128'
G[31247]='K0902 L090 A:59343 T:58919 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31244,31245,31246 Z17128'
G[31248]='K0902 L090 A:58408 T:58503 P:W0234+T4F550999 I:31249,31250 Z17128'
G[31249]='K0902 L090 A:58408 T:59338 P:W0234+T4F550999 I:31248,31250 Z17128'
G[31250]='K0902 L090 A:58408 T:58919 P:W0234+T4F550999 I:31248,31249 Z17128'
G[31251]='K0870 L087 A:59448 T:59448 P:30515 I:30583'
G[31252]='FA K0870 L087 A:59573 T:63754 P:30571+30581'	-- I:31253
G[31253]='FH K0870 L087 A:59573 T:63751 P:30571+30581'	-- I:31252
G[31254]='FA K0870 L087 A:63778 T:59073'
G[31255]='FH K0870 L087 A:63778 T:59073'
G[31256]='K0870 L087 A:59442 T:59442 P:30515 I:30575'
G[31260]='K0860 L086 A:58779 T:58779 P:30353'
G[31261]='FH K0860 L085 A:100085783 T:56336'	-- available immediately, but cannot turn in until Grookin are friendly
G[31262]='K0860 L086 A:58779 T:58779 P:30352'
G[31265]='K0900 L089 A:63349 T:63349 P:31066 O:31727'
G[31266]='K0900 L090 A:63009 T:63009 P:T4F683999'
G[31267]='K0902 L089 A:62538 T:62538 P:31066 I:31109,31111,31231,V0081,V0091,V0101 D007'
G[31268]='K0902 L089 A:63758 T:63758 P:31092+31359 I:31235,31487,31505,V0081,V0091,V0101 D007'
G[31269]='K0902 L089 A:62180 T:62180 P:31026 I:31233,31502,31508,V0081,V0091,V0101 D007'
G[31270]='K0902 L089 A:62180 T:62180 P:31026 I:31232,31496,31507,V0081,V0091,V0101 D007'
G[31271]='K0902 L089 A:63072 T:63072 P:31606 I:31234,31503,31509,V0081,V0091,V0101 D007'
G[31272]='K0902 L089 A:63785 T:63785 P:31458+31465 I:31237,31504,31510,V0081,V0091,V0101 D007'
G[31273]='K0900 L090'
G[31274]='K0900 L090'
G[31275]='K0900 L090'
G[31277]='K0900 L090 A:63009 T:562304 P:31266'
G[31278]='K0830 L081'
G[31279]='K0900 L085 A:59405,62322,65528,64041 T:64231 I:31486'
G[31280]='K0900 L085'
G[31281]='K0900 L085 A:64231 T:64231'	-- I:31485 turns out to be clutter that is unneeded
G[31282]='K0000 L000 T:62540'
G[31283]='K0000 L000'
G[31284]='K0010 L000'
G[31285]='K0870 L087 A:563367 T:63367,563367 OCC:30453'
G[31286]='K0870 L087 A:63484 T:63484'
G[31287]='K0870 L087 A:63484 T:63484'
G[31288]='K0902 L090 A:63984 T:63984 I:31291'	-- on PTR PX525 is wrong, as someone without Archaeology skill can pick it up
G[31289]='K0900 L090 T:72841'
G[31291]='K0902 L090 A:63983 T:63983 P:PX525 I:31288'
G[31292]='K0010 L000 T:72761'
G[31293]='K0902 L090 A:58911 T:58911 P:31243,31246 I:30287'
G[31294]='K0902 L090 A:59338 T:58503 P:W0024+31242+T4F550999 I:30385,31295 Z17128'
G[31295]='K0902 L090 A:59338 T:59332 P:W0024+31242+T4F550999 I:30385,31294 Z17128'
G[31296]='K0902 L090 A:59337 T:58503 P:30285|30286+30288+30289|30290+30287|31293+31243+T4F550999 I:31297'
G[31297]='K0902 L090 A:59337 T:58919 P:30285|30286+30288+30289|30290+30287|31293+31243+T4F550999 I:31296'
G[31298]='K0000 L000'	-- This gets set once it is discovered.  Perhaps we need to monitor those alerts in the UI.
G[31299]='K0000 L000'
G[31300]='K0000 L000'
G[31301]='K0000 L000'
G[31302]='K0900 L085 A:64231 T:64231 P:31281'
G[31303]='K0860 L085 A:59411 T:59418 P:30485,31362'
G[31304]='K0010 L000'
G[31305]='K0900 L085'
G[31306]='K0880 L087 T:60795'
G[31307]='K0010 L000'
G[31308]='FA K0008192 L001 A:63014 T:63014 P:S119467 I:31548,31552,31556,31571,31573,31576,31579,31582,31585,31588,31591'
G[31309]='FA K0008192 L001 A:63014 T:63014 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592'
G[31310]='K0000 L000'
G[31311]='K0900 L085 A:64231 T:58712 P:31302 I:31469'
G[31312]='K0900 L090 A:100086404 T:58705,558705 P:J6552+T4F883999'
G[31313]='K0900 L090 A:58705,558705 T:58705,558705 P:31312'
G[31314]='K0900 L090 A:58705,558705 T:1213767 P:31313'
G[31315]='K0900 L090 A:1213767 T:64314 P:31314'
G[31316]='FA K00024576 L001 A:63596 T:64330 P:J7433 O:32008,31878,31879,31880,31881,31990'
G[31317]='K0000 L000'
G[31318]='K0000 L000 T:72841'
G[31319]='FA K0860 L085 A:59418 T:59418 P:31303 I:30504'
G[31320]='K0900 L090 A:58710 T:58710 P:T4F950399'
G[31321]='K0900 L090 A:58710 T:58710 P:31320+T4F958799'
G[31322]='K0900 L090 A:58710 T:58710 P:31321+T4F967199'
G[31323]='K0900 L090 A:58710 T:58710 P:31322+T4F975599'	-- TODO: When I first got to be Good Friend (1764) it did not appear, but the next day at 3654 (after turning in carrots) it did
G[31324]='K08764 L085 A:59822 T:59074'
G[31325]='K0900 L090 A:100086433 T:58761'
G[31326]='K0900 L090 A:100086434 T:58761'
G[31327]='K08764 L085 A:59704 T:64361 O:30085'
G[31328]='K0900 L090 A:100086435 T:58761'
G[31329]='K0900 L090 A:100086436 T:58761'
G[31331]='K0830 L081'
G[31332]='K0902 L085 A:64337 T:64337 P:31521+K100086425+U54D50399'
G[31333]='K0902 L085 A:64337 T:64337 P:31521+K100086425+T54D50399+U54D58799'
G[31334]='K0902 L085 A:64337 T:64337 P:31521+K100086425+T54D58799+U54D67199'
G[31335]='K0902 L085 A:64337 T:64337 P:31521+K100086425+T54D67199+U54D75599'
G[31336]='K0902 L085 A:64337 T:64337 P:31521+K100086425+T54D75599+U54D83999'
G[31337]='SP K0902 L085 A:64337 T:64337 P:31820+K100086425'
G[31338]='K0900 L090 A:58709,558709 T:58709,558709 P:T4FD58799'
G[31339]='K0900 L090 A:58709,558709 T:58709,558709 P:31338+T4FD67199'
G[31340]='K0900 L090 A:58709,558709 T:58709,558709 P:31339+T4FD75599'
G[31341]='K0900 L090 A:58709,558709 T:58709,558709 P:31340'
G[31342]='K0890 L087 A:56541 T:64387'
G[31343]='K0000 L000 T:64344 P:31091 J:31091'
G[31344]='K0000 L000'
G[31345]='K0000 L000'
G[31346]='K0000 L000'
G[31347]='K0000 L000'
G[31348]='K0000 L000'
G[31349]='K0000 L000'
G[31350]='K0000 L000'
G[31351]='K0000 L000'
G[31352]='K0000 L000'
G[31353]='K0000 L000'
G[31354]='K0900 L089 A:563349,63349 T:64259,564259 P:31190'
G[31355]='K08764 L085 A:60578 T:60578'
G[31356]='K08764 L085 A:64399 T:64399'
G[31357]='K08964 L087 A:64432 T:564432'
G[31359]='K0900 L089 A:64344 T:63758 P:31091'
G[31360]='K08964 L087 A:64432 T:564432'
G[31362]='FA K0860 L085 A:59620 T:59411 P:30565+30568 I:30485'
G[31363]='K0901088 L088 A:64467 T:64467'
G[31364]='K0901088 L088 A:64467 T:64467'
G[31365]='K0900 L088 A:64517 T:64517'
G[31366]='K0900 L088 A:64517 T:64517'
G[31367]='FA K0900 L090 A:64508 T:61962 I:31016,31368 Z17128'
G[31368]='FH K0900 L090 A:64531 T:61962 I:31016,31367 Z17128'
G[31369]='FA K0900 L090'	-- A:64033 T:59584 I:31370,31445
G[31370]='FH K0900 L090'	-- A:64010 T:59584 I:31369,31445
G[31371]='K0000 L000'
G[31372]='FA K0900 L090 A:64036 T:58721 I:31374,31281'
G[31373]='FA K0900 L090 A:64484 T:58228 I:31375 Z16357'
G[31374]='FH K0900 L090 A:64011 T:58721 I:31372,31281'
G[31375]='FH K0900 L090 A:64533 T:58228 I:31373 Z16357'
G[31376]='FA K0902 L090 A:64032 T:57324 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D025 D045'
G[31377]='FH K0902 L090 A:64001 T:57324 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D025 D045'
G[31378]='FA K0902 L090 A:64032 T:60506 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D026 D045'
G[31379]='FH K0902 L090 A:64001 T:60506 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D026 D045'
G[31380]='FA K0902 L090 A:64032 T:60968 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D027 D045'
G[31381]='FH K0902 L090 A:64001 T:60968 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D027 D045'
G[31382]='FA K0902 L090 A:64032 T:61580 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D028 D045'
G[31383]='FH K0902 L090 A:64001 T:61580 P:T4F562999 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D028 D045'
G[31384]='FA K0900 L090 A:64031 T:58408 I:31385'
G[31385]='FH K0900 L090 A:64007 T:58408 I:31384'	-- still available even after accepting some dailies for them.  still available even after turning in a daily and getting 300 rep.
G[31386]='K0890 L088 A:64030 T:60688 I:30768,31388,31695'
G[31387]='FA K0900 L090 A:64030 T:62304 Z17128'
G[31388]='K0890 L088 A:64002 T:60688 I:30768,31386,31695'
G[31389]='FH K0900 L090 A:64002 Z17128'
G[31390]='FA K0900 L089 A:64488 T:62112 I:31000,31391,31656,31847,31886,31895'
G[31391]='FH K0900 L089 A:64534 T:62112 I:31000,31390,31656,31847,31886,31895'
G[31392]='FA K0870 L087 AP:63754:30514;563754:X30514;64521;55809;64448;60289 T:64540 I:31393'
G[31393]='FH K0870 L087 A:64521,55809,563751,564521 T:64542 I:31392'	-- reported that Farmhand Ko not immediately available, so this would be a great use of qualified NPCs...correct, not immediately available for him
G[31394]='FA K0870 L087 A:64540 T:64540 O:31392 I:31395'
G[31395]='FH K0870 L087 A:64542 T:64542 O:31393 I:31394'
G[31396]='K0010 L000'
G[31397]='K0010 L000'
G[31398]='K0900 L089 A:1214062 T:63758 P:31091'
G[31399]='K0010 L000'
G[31400]='K0010 L000'
G[31401]='K0010 L000'
G[31402]='K0010 L000'
G[31403]='K0010 L000'
G[31404]='K0010 L000'
G[31405]='K0010 L000'
G[31406]='K0010 L000'
G[31407]='K0010 L000'
G[31408]='K0010 L000 T:72762'
G[31409]='K0010 L000'
G[31410]='K0010 L000'
G[31411]='K0010 L000'
G[31412]='K0010 L000'
G[31413]='K0010 L000'
G[31414]='K0010 L000'
G[31415]='SP K0010 L000'	-- A:1213770 T:1213770
G[31416]='SP K0010 L000'	-- A:1213771 T:1213771
G[31417]='K0010 L000'
G[31418]='K0010 L000'
G[31419]='SP K0010 L000'	-- A:1213793 T:1213793
G[31420]='SP K0010 L000'	-- A:1214438 T:1214438
G[31421]='K0010 L000'
G[31422]='K0010 L000'
G[31423]='K0010 L000'
G[31424]='K0010 L000'
G[31425]='K0010 L000'
G[31426]='K0010 L000'
G[31427]='K0010 L000'
G[31428]='K0010 L000'
G[31429]='K0010 L000'
G[31430]='K0010 L000'
G[31431]='K0010 L000'
G[31432]='K0010 L000'
G[31433]='K0010 L000'
G[31434]='K0010 L000'
G[31435]='K0010 L000'
G[31436]='K0010 L000'
G[31437]='K0010 L000'
G[31438]='K0010 L000'
G[31439]='K0900 L089 A:64815 T:64672 P:T53962999+31066'
G[31440]='K0430 L038 A:64562 T:564562,500086'
G[31441]='K0900 L089 A:64672 T:64705 P:31439'
G[31442]='K0900 L090 A:64563 T:564563,500085'
G[31443]='K0002 L085 A:100086542 T:63721 P:K100086542'
G[31444]='K0002 L085 A:100086544 T:63721 P:K100086544'
G[31445]='K0900 L090 T:72841 I:31369,31370'
G[31446]='K0002 L085 A:100086545 T:63721 P:K100086545'
G[31447]='K0430 L038 A:64562 T:500086'
G[31448]='K0900 L090 A:64563 T:500085'
G[31450]='K0100 L000 RA A:56013 TA:60566 TH:60570 P:29800'
G[31451]='FH K0870 L087 A:63535 T:59263 P:30655+30656+30661|30663'	-- I:31452
G[31452]='FA K0870 L087 A:563542 T:59263 P:30650+30651+30660|30662'	-- I:31451
G[31453]='K0870 L087 A:59442 T:60161 P:30655+30656+30661|30663'
G[31454]='K0904096 L090 A:64616 T:64616 P:31488'
G[31455]='K0870 L087 A:59441 T:60161 P:30650+30651+30660|30662'
G[31456]='FA K0870 L087 A:63754 T:59353 P:30660,30662'	-- I:31457
G[31457]='FH K0870 L087 A:63751 T:59353 P:30661,30663'	-- I:31456
G[31458]='K0900 L089 A:64705 T:63785 P:31441'
G[31459]='FH K0870 L087 A:59449 T:61847 P:30655+30656+30661|30663'	-- I:31460
G[31460]='FA K0870 L087 A:59451 T:61847 P:30650+30651+30660|30662'	-- I:31459
G[31461]='K0000 L000'	-- these get cleared as you are doing a Celestial Experience to keep track of what you have done
G[31462]='K0000 L000'
G[31463]='K0000 L000'
G[31464]='K0000 L000'
G[31465]='K0900 L089 A:64705 T:63785 P:31441'
G[31466]='K0000 L000 T:83746'
G[31467]='K0900 L085 A:58712 T:58712 P:31311'
G[31468]='K0904096 L090 A:64616 T:64616 P:31454'
G[31469]='K0900 L084 I:31311'
G[31470]='K0900 L085 A:64231 T:58713 P:31302'
G[31471]='K0900 L085 A:58713 T:58713 P:31470'
G[31472]='K0900 L085 A:64231 T:58714 P:31302'
G[31473]='K0904096 L090 A:64616 T:64616 P:31454'
G[31474]='K0900 L085 A:58714 T:58714 P:31472'
G[31475]='K0900 L085 A:64231 T:58715 P:31302'
G[31476]='K0900 L085 A:58715 T:58715 P:31475'
G[31477]='K0900 L085 A:58716 T:58716 P:31478'
G[31478]='K0900 L085 A:64231 T:58716 P:31302'
G[31479]='K0900 L085 A:64231 T:58717 P:31302'
G[31480]='K0900 L085 A:58717 T:58717 P:31479'
G[31481]='K0900 L090 A:64616 T:64616 P:31473'
G[31482]='K0900 L090 A:64616 T:64822 P:31481'
G[31483]='K0900 L090 A:64822 T:64616 P:31482'
G[31484]='K0000 L000'
G[31485]='K0900 L085 I:31281'
G[31486]='K0900 L085 A:56707,62872,63013 T:64231 I:31279'
G[31487]='K0902 L089 A:63758 T:63758 P:31092+31359 I:31235,31268,31505,V0071,V0081,V0101 D009'
G[31488]='K0904096 L090 A:60422,62871,63218,64457,66409,66415 AA:64144,65908 AH:64047,66225 T:64616 Z19033'	-- PTR recorded I:31489 but we will not clutter the UI with it
G[31489]='K0904096 L090'	-- This seems not to be used.   A:60422,63218,64047,64144,64457,65908,66409,66415 T:64616 I:31488
G[31490]='K0310 L026 A:564738 T:64738 E15640'
G[31491]='K0902 L090 A:60981 P:1'
G[31492]='K0902 L090 A:60981 T:60981 P:T4F562999 I:V0221,V0251,V0261,V0281,V0311,V0321,V0331,31517 D042'
G[31493]='K0310 L026 A:564738 T:64738 E15640'
G[31494]='K0902 L089 A:63758 T:63758 P:31092+31359 I:31024,31238,31506,V0071,V0081,V0101 D009'
G[31495]='K0900 L090 A:564764 T:64764 E15640'
G[31496]='K0902 L089 A:62180 T:62180 P:31026 I:31232,31270,31507,V0071,V0081,V0101 D009'
G[31497]='K0900 L090 A:564764 T:64764 E15640'
G[31498]='K0900 L090'
G[31499]='K0900 L090'
G[31500]='K0900 L090'
G[31501]='K0900 L090'
G[31502]='K0902 L089 A:63072,67091 T:63072,67091 P:31606 I:31233,31269,31508,V0071,V0081,V0101 D009'
G[31503]='K0902 L089 A:63072 T:63072 P:31606 I:31234,31271,31509,V0071,V0081,V0101 D009'
G[31504]='K0902 L089 A:63785 T:63785 P:31458+31465 I:31237,31272,31510,V0071,V0081,V0101 D009'
G[31505]='K0902 L089 A:62538 T:62538 P:31066 I:31235,31268,31487,V0071,V0081,V0091 D010'
G[31506]='K0902 L089 A:63758 T:63758 P:31092+31359 I:31024,31238,31494,V0071,V0081,V0091 D010'
G[31507]='K0902 L089 A:62180 T:62180 P:31026 I:31232,31270,31496,V0071,V0081,V0091 D010'
G[31508]='K0902 L089 A:63072 T:63072 P:31606 I:31233,31269,31502,V0071,V0081,V0091 D010'
G[31509]='K0902 L089 A:63072 T:63072 P:31606 I:31234,31271,31503,V0071,V0081,V0091 D010'
G[31510]='K0902 L089 A:63785 T:63785 P:31458+31465 I:31237,31272,31504,V0071,V0081,V0091 D010'
G[31511]='K0870 L087 A:64542 T:59905 P:31395 I:31512'
G[31512]='K0870 L087 A:64540 T:59905 P:31394 I:31511'
G[31513]='K0340 L028 A:64827 T:64854 E15640'
G[31514]='K0340 L028 A:64854 T:64841 P:31513 E15640'
G[31515]='K0900 L090 A:64838 T:64855 E15640'
G[31516]='K0900 L090 A:64855 T:64842 P:31515'
G[31517]='K0902 L090 A:60968 T:60968 P:T4F562999 I:V0221,V0251,V0261,V0281,V0311,V0321,V0331,31492 D042'
G[31518]='K0870 L087'
G[31519]='FH K0901026 L090 A:63994 T:63994 I:31520,31522,31523,31524,31525,31526,31527,31528'
G[31520]='FH K0901026 L090 A:63994 T:63994 I:31519,31522,31523,31524,31525,31526,31527,31528'
G[31521]='K0900 L085 A:64231 T:64231 P:PC600'
G[31522]='FH K0901026 L090 A:63994 T:63994 I:31519,31520,31523,31524,31525,31526,31527,31528'
G[31523]='FH K0901026 L090 A:63994 T:63994 I:31519,31520,31522,31524,31525,31526,31527,31528'
G[31524]='FH K0901026 L090 A:63994 T:63994 I:31519,31520,31522,31523,31525,31526,31527,31528'
G[31525]='FH K0901026 L090 A:63994 T:63994 I:31519,31520,31522,31523,31524,31526,31527,31528'
G[31526]='FH K0901026 L090 A:63994 T:63994 I:31519,31520,31522,31523,31524,31525,31527,31528'
G[31527]='FH K0901026 L090 A:63994 T:63994 I:31519,31520,31522,31523,31524,31525,31526,31528'
G[31528]='FH K0901026 L090 A:63994 T:63994 I:31519,31520,31522,31523,31524,31525,31526,31527'
G[31529]='K0900 L090 A:58708 T:58708 P:T4FE55439 I:31530'	-- Acquaintance +5040 (at least more than 4095)
G[31530]='K0900 L090 I:31529'
G[31531]='K0900 L090 A:58708 T:58708 P:T4FE71430'	-- Friend +4231 (at least more than 2761)
G[31532]='K0900 L090 A:58708 T:58708 P:T4FE79925'	-- Good Friend +4326 (at least more than 2436)
G[31533]='K0900 L090'
G[31534]='K0900 L090 A:58647,558647 T:58647,558647 P:T4FB58799'
G[31535]='SP K0901 L085 A:64395 T:64395 P:31536'
G[31536]='K0900 L085 A:64395 T:64395 P:31467+31471+31474+31476+31477+31480'
G[31537]='K0900 L090 A:58647,558647 T:58647,558647 P:31534+T4FB67199'
G[31538]='K0900 L090 A:58647,558647 T:58647,558647 P:31537+T4FB75599'
G[31539]='K0904 L085 A:56065 T:56065 P:PI600 I:31540,31541,31542,31543,31544'
G[31540]='K0904 L085 A:56065 T:56065 P:PI600 I:31539,31541,31542,31543,31544'
G[31541]='K0904 L085 A:56065 T:56065 P:PI600 I:31539,31540,31542,31543,31544'
G[31542]='K0904 L085 A:56065 T:56065 P:PI600 I:31539,31540,31541,31543,31544'
G[31543]='K0904 L085 A:56065 T:56065 P:PI600 I:31539,31540,31541,31542,31544'
G[31544]='K0904 L085 A:56065 T:56065 P:PI600 I:31539,31540,31541,31542,31543'
G[31545]='K0000 L001'
G[31548]='FA K0008192 L001 A:63075 T:63075 P:S119467 I:31308,31552,31556,31571,31573,31576,31579,31582,31585,31588,31591'
G[31549]='FA K0008192 L001 A:63075 T:63075 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592'
G[31550]='FA K0008192 L001 A:63014 T:63014 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31551,31555,31569,31570,31575,31578,31581,31584,31587,31590,31593'
G[31551]='FA K0008192 L001 A:63075 T:63075 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31555,31569,31570,31575,31578,31581,31584,31587,31590,31593'
G[31552]='FA K0008192 L001 A:63070 T:63070 P:S119467 I:31308,31548,31556,31571,31573,31576,31579,31582,31585,31588,31591'
G[31553]='FA K0008192 L001 A:63070 T:63070 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31568,31572,31574,31577,31580,31583,31586,31589,31592'
G[31554]='K0008192 L005'
G[31555]='FA K0008192 L001 A:63070 T:63070 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31569,31570,31575,31578,31581,31584,31587,31590,31593'
G[31556]='FA K0008192 L001 A:63077 T:63077 P:S119467 I:31308,31548,31552,31571,31573,31576,31579,31582,31585,31588,31591'
G[31557]='K0000 L001'
G[31558]='K0000 L001'
G[31559]='K0000 L001'
G[31560]='K0000 L001'
G[31561]='K0000 L001'
G[31562]='K0000 L001'
G[31563]='K0000 L001'
G[31564]='K0000 L001'
G[31565]='K0000 L001'
G[31566]='K0000 L001'
G[31567]='K0000 L001'
G[31568]='FA K0008192 L001 A:63077 T:63077 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31572,31574,31577,31580,31583,31586,31589,31592'
G[31569]='FA K0008192 L001 A:63077 T:63077 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31570,31575,31578,31581,31584,31587,31590,31593'
G[31570]='FH K0008192 L001 A:63061 T:63061 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31575,31578,31581,31584,31587,31590,31593'
G[31571]='FH K0008192 L001 A:63061 T:63061 P:S119467 I:31308,31548,31552,31556,31573,31576,31579,31582,31585,31588,31591'
G[31572]='FH K0008192 L001 A:63061 T:63061 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31574,31577,31580,31583,31586,31589,31592'
G[31573]='FH K0008192 L001 A:63067 T:63067 P:S119467 I:31308,31548,31552,31556,31571,31576,31579,31582,31585,31588,31591'
G[31574]='FH K0008192 L001 A:63067 T:63067 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31577,31580,31583,31586,31589,31592'
G[31575]='FH K0008192 L001 A:63067 T:63067 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31578,31581,31584,31587,31590,31593'
G[31576]='FH K0008192 L001 A:63073 T:63073 P:S119467 I:31308,31548,31552,31556,31571,31573,31579,31582,31585,31588,31591'
G[31577]='FH K0008192 L001 A:63073 T:63073 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31580,31583,31586,31589,31592'
G[31578]='FH K0008192 L001 A:63073 T:63073 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31581,31584,31587,31590,31593'
G[31579]='FH K0008192 L001 A:63080 T:63080 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31582,31585,31588,31591'
G[31580]='FH K0008192 L001 A:63080 T:63080 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31583,31586,31589,31592'
G[31581]='FH K0008192 L001 A:63080 T:63080 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31584,31587,31590,31593'
G[31582]='FA K0008192 L001 A:63083 T:63083 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31585,31588,31591'
G[31583]='FA K0008192 L001 A:63083 T:63083 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31580,31586,31589,31592'
G[31584]='FA K0008192 L001 A:63083 T:63083 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31587,31590,31593'
G[31585]='FH K0008192 L001 A:63086 T:63086 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31582,31588,31591'
G[31586]='FH K0008192 L001 A:63086 T:63086 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31580,31583,31589,31592'
G[31587]='FH K0008192 L001 A:63086 T:63086 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31584,31590,31593'
G[31588]='FH K0008192 L001 A:63626 T:63626 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31591'	-- Troll druid [what is really scary is the NE druid now has this in the log]
G[31589]='FH K0008192 L001 A:63626 T:63626 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31592'
G[31590]='FH K0008192 L001 A:63626 T:63626 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31584,31587,31593'
G[31591]='FA K0008192 L001 A:63596 T:63596 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588'	-- NE druid
G[31592]='FA K0008192 L001 A:63596 T:63596 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,3158 I:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589'
G[31593]='FA K0008192 L001 A:63596 T:63596 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31584,31587,31590'
G[31598]='K0902 L089 A:100087871 T:64599 P:V0101'
G[31599]='K0902 L089 A:100087878 T:64599 P:V0091'
G[31600]='K0000 L000'
G[31603]='SP K0901 L089 A:64599 T:64599 P:31108'
G[31604]='K0900 L089'
G[31605]='K0900 L089 A:64815 T:65253,67091,63072 P:T53950999+31066'
G[31606]='K0900 L089 A:65253 T:67091 P:31066'
G[31607]='K0000 L000 J:30782+30783'
G[31609]='K0900 L089 A:-858 T:62538 P:31959'
G[31611]='K0902048 L090 A:63367,563367 T:64901'	-- you get this from 563367 if you have not already done 31285 (since 63367 is at 563367 location)
G[31612]='K0900 L089 A:62538 T:62538 P:31609'
G[31613]='K0902048 L090 A:62321 T:61203'
G[31614]='K0900 L090'
G[31615]='K0900 L090'
G[31616]='K0900 L090'
G[31617]='K0900 L090'
G[31618]='K0900 L090'
G[31619]='K0900 L090'
G[31620]='K0900 L090'
G[31621]='K0900 L090'
G[31622]='K0900 L090'
G[31623]='K0900 L090'
G[31624]='K0900 L090'
G[31625]='K0900 L090'
G[31626]='K0900 L090'
G[31627]='K0900 L090'
G[31628]='K0900 L090'
G[31629]='K0900 L090'
G[31630]='K0900 L090'
G[31631]='K0900 L090'
G[31632]='K0900 L090'
G[31633]='K0900 L090'
G[31634]='K0900 L090'
G[31635]='K0900 L090'
G[31636]='K0900 L090'
G[31637]='K0900 L090'
G[31638]='K0900 L090'
G[31639]='K0900 L090'
G[31640]='K0900 L090'
G[31641]='K0900 L090'
G[31642]='K0900 L090'
G[31643]='K0900 L090'
G[31644]='K0900 L090'
G[31645]='K0900 L090'
G[31646]='K0900 L090'
G[31647]='K0900 L090'
G[31648]='K0900 L090'
G[31649]='K0900 L090'
G[31650]='K0900 L090'
G[31651]='K0900 L090'
G[31652]='K0900 L090'
G[31654]='K0870 L087'
G[31655]='K0000 L000'
G[31656]='K0900 L089 A:62802 T:62112 P:30968 I:31000,31390,31391,31847,31886,31895'
G[31660]='K0900 L089 A:62538 T:62538 P:31006'
G[31661]='K0900 L089 A:1214562 T:64599 P:31006'
G[31664]='K0000 L000 T:0'
G[31665]='K0010 L000'
G[31666]='K0010 L000'
G[31668]='K0000 L000'
G[31669]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31670,31671,31672,31673,31674,31675,31941,31942,31943,32682'
G[31670]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31671,31672,31673,31674,31675,31941,31942,31943,32682'
G[31671]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31672,31673,31674,31675,31941,31942,31943,32682'
G[31672]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31673,31674,31675,31941,31942,31943,32682'
G[31673]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31674,31675,31941,31942,31943,32682'
G[31674]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31675,31941,31942,31943,32682'
G[31675]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31941,31942,31943,32682'
G[31676]='K0900 L089 A:62202 T:62202 P:31004'
G[31677]='K0902 L089 A:100088715 T:62538 P:V0081'
G[31679]='K0900 L089 P:31441'
G[31680]='K0900 L089 P:31441+31087|31679'
G[31681]='K0900 L089 P:31441+31087|31679'
G[31682]='K0900 L089 P:31441+31088|31680+31090|31681'
G[31685]='K0870 L085 E21655'
G[31687]='K0890 L088 A:62278 T:62278 P:31065'
G[31688]='K0890 L088 A:62278 T:62278 P:31065'
G[31689]='K0900 L089 A:62774,562774 T:562774 P:31661'
G[31690]='K0900 L085 T:56065 P:PI560'
G[31691]='K0900 L085 T:56065 P:PI560'
G[31692]='K0900 L085 T:56065 P:PI560'
G[31693]='K0008194 L001 AA:64330 T:64330 P:J6603'
G[31694]='K0000 L001'
G[31695]='K0880 L088 A:563542 T:60688 P:30650+30651+30660|30662,30655+30656+30661|30663 I:30768,31386,31388'
G[31697]='K0890 L088'	-- I missed which quest sets this...30898 or 30900 I think.
G[31698]='K0902 L090 A:58228 T:58564 P:30142 I:30154,V0171,V0181,V0201,V0211,V0361 D019'
G[31699]='K0902 L090 A:58509 T:58564 P:30142 I:31700,V0171,V0181,V0201,V0211,V0361 D019'
G[31700]='K0902 L090 A:58509 T:58564 P:30142 I:31699,V0171,V0181,V0201,V0211,V0361 D019'
G[31701]='K0902 L090 A:58564 T:58564 P:30142 I:31702,31703,V0171,V0181,V0201,V0211,V0361 D019'
G[31702]='K0902 L090 A:58564 T:58564 P:30142 I:31701,31703,V0171,V0181,V0201,V0211,V0361 D019'
G[31703]='K0902 L090 A:58564 T:58564 P:30142+U4F762999 I:31701,31702'
G[31704]='K0902 L090 A:65669 T:65669 P:30142+U4F762999 I:V0181,V0191,V0201,V0211,V0361 D017'	-- I:31716
G[31705]='K0902 L090 A:58564 T:58564 P:30150+31704+U4F762999'
G[31706]='K0902 L090 A:58228 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0201,V0361 D021'
G[31707]='K0902 L090 A:58228 T:58564 P:T4F762999 I:31709,V0171,V0181,V0191,V0201,V0361 D021'
G[31708]='K0900 L090'
G[31709]='K0902 L090 A:58508 T:58564 P:T4F762999 I:31707,V0171,V0181,V0191,V0201,V0361 D021'
G[31710]='K0900 L090'
G[31711]='K0902 L090 A:58564 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0201,V0361 D021'
G[31712]='K0902 L090 A:58228 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0211,V0361 D020'
G[31713]='K0902 L090 A:58506 T:58506 P:T4F762999 I:31714,V0171,V0181,V0191,V0211,V0361 D020'
G[31714]='K0902 L090 A:58511 T:58564 P:T4F762999 I:31713,V0171,V0181,V0191,V0211,V0361 D020'
G[31715]='K0902 L090 A:58564 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0211,V0361 D020'
G[31716]='K0902 L090 T:72763 I:31704'
G[31717]='K0902 L090 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31718]='K0902 L090 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31719]='K0902 L090 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31720]='K0902 L090 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31721]='K0902 L090 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31723]='K0870 L085 E21655'
G[31724]='K00024576 L001 AA:64330 T:65648 P:31316'
G[31725]='K00024576 L001 AA:65648 T:65651 P:31724'
G[31726]='K00024576 L001 AA:65651 T:65655 P:31725'
G[31727]='K0900 L089 A:64599 T:63349 P:31026+31398'
G[31728]='K00024576 L001 AA:63194 T:65656 P:31729'
G[31729]='K00024576 L001 AA:65655 T:63194 P:31726'	-- note that you cannot interact with him if you have Bwemba's spirit as he is not even there
G[31730]='K0900 L089 A:62538 T:62666 P:31026+31398'
G[31731]='K0860 L085'
G[31732]='FA K0860 L085 A:66292 T:66292 P:29548'
G[31733]='K0860 L085 A:66292 T:54616 P:31732'
G[31734]='K0860 L085 A:54616 T:54617 P:31733'
G[31735]='K0860 L085 A:54617 T:554617 P:30069+31734'
G[31736]='K0860 L085 A:500081 T:65910 P:31735'
G[31737]='K0860 L085 A:500081 T:66296 P:31735'
G[31738]='K0860 L085 A:65910 T:65910 P:31736+31737'
G[31739]='K0860 L085 A:66209 T:66199 P:31736+31737'
G[31740]='K0860 L085 A:66199 T:65910 P:31739'
G[31741]='K0860 L085 A:65910 T:554616 P:29552+31738+31740'
G[31742]='K0860 L085 A:500082 T:554616 P:29552+31738+31740'
G[31743]='K0860 L085 A:500082 T:554616 P:29552+31738+31740'
G[31744]='K0860 L085 A:65910 T:554616 P:29552+31738+31740'
G[31745]='K0860 L085 A:66581 T:566292 P:30070'
G[31752]='SP K0008194 L001 A:43929 T:43929 I:34774'
G[31754]='K0902 L090 A:558471 T:558471 P:30638 I:31756,31758 Z17128 D003'
G[31755]='K0902 L090 A:558468 T:558468 P:30638 I:30312,30320 Z17128 D004'
G[31756]='K0902 L090 A:558471 T:558471 P:30638 I:31754,31758 Z17128 D003'
G[31757]='K0902 L090 A:558465 T:558465 P:30638 I:30308,30309,30310 Z17128 D005'
G[31758]='K0902 L090 A:558471 T:558471 P:30638 I:31754,31756 Z17128 D003'
G[31759]='K0900 L090'
G[31760]='K0902 L090 A:558465 T:558465 P:30638 I:31762 Z17128 D006'
G[31761]='K0900 L090'
G[31762]='K0902 L090 A:558465 T:558465 P:30638 I:31760 Z17128 D006'
G[31763]='K0900 L090'
G[31764]='K0860 L085'
G[31765]='K0860 L085 A:55135 T:66667 P:29690'
G[31766]='K0860 L085 A:66667 T:66190 P:31765'
G[31767]='K0860 L085 A:66190 T:66646 P:31766'
G[31768]='K0860 L085 A:66190 T:66646 P:31766'
G[31769]='FH K0860 L085 A:66646 T:66656 P:31767+31768'
G[31770]='FH K0860 L085 A:66656 T:66220 P:31769'	-- forced acceptance when entering parts of The Jade Forest
G[31771]='FH K0860 L085 A:66657 T:66665 P:31769'	-- forced acceptance when entering parts of The Jade Forest
G[31772]='FH K0860 L085 A:66660 T:66848 P:31769 I:31978 ODC:31969'
G[31773]='FH K0860 L085 A:66659,66853 T:66665 P:31769'
G[31774]='FH K0860 L085 A:66845 T:55403 P:29694+31771+31773'
G[31775]='K0860 L085 A:65999 T:65999 P:29804'
G[31776]='K0860 L085 A:65999 T:65999 P:29804'
G[31777]='K0860 L085 A:55521 T:55521,555521 P:29804'	-- once the phasing at Strongarm Airstrip has happened, 55521 is no longer a valid T
G[31778]='K0860 L085 A:65998 T:65998 P:29804'
G[31779]='K0860 L085 A:65999 T:1215844 P:31775+31776+31777+31778'	-- TODO: Verify requires 31776
G[31780]='K0008194 L001 AA:65648 T:0,65648 P:J6603'
G[31781]='K0008194 L001 AA:65651 T:0,65651 P:J6603'
G[31782]='K0900 L087 A:65395 T:62519 P:32030'
G[31784]='SP K0901 L090 A:58564 T:58564 P:K100089155'
G[31785]='FA K0008192 L001 A:63014 T:63014 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832'
G[31786]='K0900 L085 A:100089169 T:1214205 P:K100089169+PX525'
G[31787]='K0900 L085 A:100089170 T:1214206 P:K100089170+PX525'
G[31788]='K0900 L085 A:100089171 T:1214207 P:K100089171+PX525'
G[31789]='K0900 L085 A:100089172 T:1214208 P:K100089172+PX525'
G[31790]='K0900 L085 A:100089173 T:1214209 P:K100089173+PX525'
G[31791]='K0900 L085 A:100089174 T:1214210 P:K100089174+PX525'
G[31792]='K0900 L085 A:100089175 T:1214211 P:K100089175+PX525'
G[31793]='K0900 L085 A:100089176 T:1214212 P:K100089176+PX525'
G[31794]='K0900 L085 A:100085477 T:1214213 P:K100085477+PX525'
G[31795]='K0900 L085 A:100085557 T:1214217 P:K100085557+PX525'
G[31796]='K0900 L085 A:100085558 T:1214218 P:K100085558+PX525'
G[31797]='K0900 L085 A:100089178 T:1214219 P:K100089178+PX525'
G[31798]='K0900 L085 A:100089179 T:1214220 P:K100089179+PX525'
G[31799]='K0900 L085 A:100089180 T:1214221 P:K100089180+PX525'
G[31800]='K0900 L085 A:100089181 T:1214222 P:K100089181+PX525'
G[31801]='K0900 L085 A:100089182 T:1214223 P:K100089182+PX525'
G[31802]='K0900 L085 A:100089183 T:1214224 P:K100089183+PX525'
G[31803]='K0900 L085 A:100089184 T:1214225 P:K100089184+PX525'
G[31804]='K0900 L085 A:100089185 T:1214226 P:K100089185+PX525'
G[31805]='K0900 L085 A:100089209 T:1214214 P:K100089209+PX525'
G[31806]='K0900 L085'
G[31807]='K0000 L000'
G[31808]='K0902 L089 A:63758 T:63758 P:31092+31359+T53955999 I:31216'	-- assuming 5000 into honored for now
G[31809]='K0900 L090 A:100089317 T:62304'
G[31810]='K0900 L090 A:58564 T:58564 P:30145+30187+30165+T4F783999 I:30188,31811'	-- server completes all three (as well as all three prerequisites), what a pain
G[31811]='K0900 L090 A:58564 T:58564 P:30145+30187+30167+T4F783999 I:30188,31810'	-- server completes all three (as well as all three prerequisites), what a pain
G[31812]='FH K00024576 L001 A:63626 T:66126 O:31882,31883,31884,31885,32009'
G[31813]='K00024576 L001 AH:66126 T:66135 P:31812'
G[31814]='K00024576 L001 AH:66135 T:66136 P:31813'
G[31815]='K00024576 L001 AH:66136 T:66137 P:31814'
G[31816]='K0000 L005'	-- seems never to have been implemented - he's not in the chain
G[31817]='K00024576 L001 AH:66137 T:66372 P:31815'
G[31818]='K0008194 L001 AH:66126 T:66126 P:J6602'
G[31819]='K0008194 L001 AH:66135 T:66135 P:J6602'
G[31820]='K0900 L085 A:64337 T:64337 P:T54D83999'
G[31821]='FA K0008192 L001 A:63596 T:63596 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832'
G[31822]='FA K0008192 L001 A:63075 T:63075 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31823,31824,31825,31826,31827,31828,31830,31831,31832'
G[31823]='FH K0008192 L001 A:63073 T:63073 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31824,31825,31826,31827,31828,31830,31831,31832'
G[31824]='FH K0008192 L001 A:63080 T:63080 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31825,31826,31827,31828,31830,31831,31832'
G[31825]='FA K0008192 L001 A:63077 T:63077 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31826,31827,31828,31830,31831,31832'
G[31826]='FA K0008192 L001 A:63070 T:63070 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31827,31828,31830,31831,31832'
G[31827]='FH K0008192 L001 A:63626 T:63626 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31828,31830,31831,31832'
G[31828]='FH K0008192 L001 A:63086 T:63086 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31830,31831,31832'
G[31829]='K0000 L000'
G[31830]='FH K0008192 L001 A:63061 T:63061 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31828,31831,31832'
G[31831]='FH K0008192 L001 A:63067 T:63067 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31832'
G[31832]='FH K0008192 L001 A:63083 T:63083 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831'
G[31833]='K0000 L030 CO A:66260 T:66260 P:31834'
G[31834]='K0000 L020 CO A:66260 T:66260 P:31856'
G[31835]='K0000 L040 CO A:66260 T:66260 P:31833'
G[31836]='K0000 L050 CO A:66260 T:66260 P:31835'
G[31837]='K0000 L060 CO A:66260 T:66260 P:31836'
G[31838]='K0000 L070 CO A:66260 T:66260 P:31837'
G[31839]='K0000 L080 CO A:66260 T:66260 P:31838'
G[31840]='K0002 L020 CO A:66260 T:66260 P:31834'
G[31841]='K0002 L030 CO A:66260 T:66260 P:31833'
G[31842]='K0002 L040 CO A:66260 T:66260 P:31835'
G[31843]='K0002 L050 CO A:66260 T:66260 P:31836'
G[31844]='K0002 L060 CO A:66260 T:66260 P:31837'
G[31845]='K0002 L070 CO A:66260 T:66260 P:31838'
G[31846]='K0002 L080 CO A:66260 T:66260 P:31839'
G[31847]='K0900 L089 A:61512 T:62112 I:31000,31390,31391,31656,31886,31895'
G[31850]='K0008194 L001 AA:65655 T:0,65655 P:J6603'
G[31851]='K0008194 L001 AA:65656 T:0,65656 P:J6603'
G[31852]='K0008194 L001 AA:63194 T:0,63194 P:J6603'
G[31853]='FH K0860 L085 A:54870 T:55054 P:29611'
G[31854]='K0008194 L001 AH:66136 T:66136 P:J6602'
G[31855]='K0000 L030 CO A:0 T:66260'
G[31856]='K0000 L020 CO A:0 T:66260'
G[31857]='K0000 L040 CO A:0 T:66260'
G[31858]='K0000 L050 CO A:0 T:66260'
G[31859]='K0000 L060 CO T:66260'
G[31860]='K0000 L070 CO A:21774 T:66260'
G[31861]='K0000 L080 CO A:29432 T:66260'
G[31862]='K0008194 L001 AH:66137 T:66137 P:J6602'
G[31863]='K0010 L000'
G[31864]='K0010 L000'
G[31865]='K0010 L000'
G[31866]='K0010 L000'
G[31867]='K0010 L000'
G[31868]='K0010 L000'
G[31869]='K0010 L000'
G[31870]='K0008192 L001 AH:66372 T:66422 P:31817'
G[31871]='K0008194 L001 AH:66352 T:66352 P:J6602'
G[31872]='K0008194 L001 AH:66372 T:66372 P:J6602'
G[31876]='K0900 L085 A:64691 T:56065 P:PI001'
G[31877]='K0900 L085 P:PI001'
G[31878]='K0000 L001 I:31879,31880,31881,31990,32008'
G[31879]='K0000 L001 I:31878,31880,31881,31990,32008'
G[31880]='K0000 L001 I:31878,31879,31881,31990,32008'
G[31881]='K0000 L001 I:31878,31879,31880,31990,32008'
G[31882]='FH K0008192 L001 T:63626 I:31883,31884,31885,32009'
G[31883]='FH K0008192 L001 T:63626 I:31882,31884,31885,32009'
G[31884]='FH K0008192 L001 T:63626 I:31882,31883,31885,32009'
G[31885]='FH K0008192 L001 T:63626 I:31882,31883,31884,32009'
G[31886]='K0900 L089 A:63498 T:62112 I:31000,31390,31391,31656,31847,31895'
G[31887]='K0000 L005'
G[31888]='K0000 L005'
G[31889]='FA K00024576 L001 A:63596 T:0 P:31728'
G[31890]='K0000 L005'
G[31891]='FH K00024576 L001 A:63626 T:-182 P:31870'
G[31892]='K0000 L005'
G[31893]='K0000 L005'
G[31894]='K0890 L088 A:60864 T:60857 P:30784'
G[31895]='K0900 L089 P:30926+30927+30928 I:31000,31390,31391,31656,31847,31886'
G[31897]='K00024576 L001 A:0,66466 T:66466 P:31889,31891'
G[31902]='FA K00024576 L001 A:63596 T:0 P:31728'
G[31903]='K00024576 L001 A:63626 T:0 P:31870'
G[31904]='K0008194 L001 AH:66422 T:66422 P:J6602'
G[31905]='K0008194 L001 AH:66436 T:66436 P:J6602'
G[31906]='K0008194 L001 AH:66452 T:66452 P:J6602'
G[31907]='K0008194 L001 AH:66442 T:66442 P:J6602'
G[31908]='K0008194 L001 AH:66412 T:66412 P:J6602'
G[31909]='K0008194 L001 A:66466 T:66466 P:31897'
G[31910]='K0008194 L001 AA:66478 T:66478 P:J6603'
G[31911]='K0008194 L001 AA:66512 T:66512 P:J6603'
G[31912]='K0008194 L001 AA:66515 T:66515 P:J6603'
G[31913]='K0008194 L001 AA:66518 T:66518 P:J6603'
G[31914]='K0008194 L001 AA:66520 T:66520 P:J6603'
G[31915]='K00024576 L001 A:0,66522 T:66522 P:31902,31903'
G[31916]='K0008194 L001 A:66522 T:66522 P:31915'
G[31917]='K0008192 L001 AA:65656 T:63596 P:31728'
G[31918]='K0008192 L001 AH:66422 T:63626 P:31870'
G[31919]='K00024576 L001 A:63596 T:0 P:31975+31976'
G[31920]='K00024576 L001 A:0,66557 T:66557 P:31919,31921'
G[31921]='K00024576 L001 A:63626 T:0 P:31977+31980'
G[31922]='K0008194 L001 A:66550 T:66550 P:31920'
G[31923]='K0008194 L001 A:66551 T:66551 P:31920'
G[31924]='K0008194 L001 A:66552 T:66552 P:31920'
G[31925]='K0008194 L001 A:66553 T:66553 P:31920'
G[31926]='K0008194 L001 A:66557 T:66557 P:31920'
G[31927]='K0000 L001 A:63596 T:66635'
G[31928]='K0000 L001 A:66635 T:66675'
G[31929]='K0000 L001 A:63626'
G[31930]='K0000 L001 T:-810'
G[31931]='K0000 L001 A:66635 T:66635'
G[31932]='K0000 L001 A:66636 T:66636'
G[31933]='K0000 L001 A:66638 T:66638'
G[31934]='K0000 L001 A:66639 T:66639'
G[31935]='K0000 L001 A:66675 T:66675'
G[31936]='K0900 L090 A:100089812 T:558646 P:30531+R114431+i114431'
G[31937]='K0900 L090 A:100089813 T:558646 P:30533+R114483+i114483'
G[31938]='K0900 L090 A:100089814 T:558646 P:30574+R114624+i114624'
G[31939]='K0860 L085'
G[31940]='K0000 L005'
G[31941]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31675,31942,31943,32682'
G[31942]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31675,31941,31943,32682'
G[31943]='K0902 L090 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31675,31941,31942,32682'
G[31944]='K0000 L090 CO A:66260 T:66260 P:31839'
G[31945]='K0870 L085 A:58706 T:58706 P:30257 ODC:31950,31960'
G[31946]='K0900 L090 A:57401 T:57401 P:30259 ODC:31961'
G[31947]='K0900 L090 A:57298,557298 T:57298,557298 P:30518 ODC:31962'
G[31948]='K0900 L090 A:64597 T:64597 P:30519'
G[31949]='K0900 L090 A:64597 T:64597 P:31948'
G[31950]='K0860 L085 T:58706'
G[31951]='K0000 L001 A:-810 T:66741'
G[31952]='K0000 L001 A:63626'
G[31953]='K0000 L001 A:66730 T:66730 P:0'	-- TODO: pet battle needs P: because cannot get immediately
G[31954]='K0000 L001 A:66733 T:66733'
G[31955]='K0000 L001 A:66734 T:66734'
G[31956]='K0000 L001 A:66738 T:66738'
G[31957]='K0008194 L001 A:66739 T:66739'
G[31958]='K0000 L001 A:66741 T:66741'
G[31959]='K0900 L089 A:66875 T:-858 P:T53983999+31026+31085+31179+31211+31354+31398+31439+31606'
G[31960]='K0000 L000 T:58706'
G[31961]='K0000 L000 T:57401'
G[31962]='K0000 L000 T:57298'
G[31963]='K0000 L000 T:72841'
G[31964]='K0000 L000 T:72841'
G[31965]='K0000 L000 T:72841'
G[31966]='K0000 L001 T:72841'
G[31967]='K0000 L001 A:63626'
G[31968]='K0860 L085'
G[31969]='K0000 L000 T:66848'
G[31970]='K0000 L001 T:72841'
G[31971]='K0000 L001 A:66824 T:66824'
G[31972]='K0000 L001 A:66819 T:66819'
G[31973]='K0000 L001 A:66815 T:66815'
G[31974]='K0008194 L001 A:66822 T:66822 P:J7525'
G[31975]='FA K0008192 L001 A:0,66466 T:63596 P:31897'
G[31976]='FA K0008192 L001 A:0,66522 T:63596 P:31915'
G[31977]='FH K0008192 L001 A:0,66466 T:63626 P:31897'
G[31978]='FH K0860 L085 A:66662 T:66848 P:31769 I:31772'
G[31979]='K0000 L005'
G[31980]='FH K0008192 L001 A:0,66522 T:63626 P:31915'
G[31981]='FA K0000 L001 A:66557 T:63596'
G[31982]='FH K0000 L001 A:66557 T:63626'
G[31983]='K0000 L001 A:66675'
G[31984]='K0000 L001'
G[31985]='K0000 L001'
G[31986]='K0000 L001'
G[31987]='K0850 L083'
G[31988]='K0900 L090'
G[31989]='K0000 L090 CO'
G[31990]='K0000 L005 I:31878,31879,31880,31881,32008'
G[31991]='K0000 L001 A:66918 T:66918'
G[31992]='K0000 L000'
G[31993]='K0000 L000'
G[31994]='K0000 L000'
G[31995]='K0000 L000'
G[31996]='K0000 L000'
G[31997]='K0000 L000'
G[31998]='FA K0901026 L090 A:64028 T:64028 I:32000,32001,32002,32003,32004,32005,32006,32007'
G[31999]='K0860 L085 A:1215844 T:55172 P:31779'
G[32000]='FA K0901026 L090 A:64028 T:64028 I:31998,32001,32002,32003,32004,32005,32006,32007'
G[32001]='FA K0901026 L090 A:64028 T:64028 I:31998,32000,32002,32003,32004,32005,32006,32007'
G[32002]='FA K0901026 L090 A:64028 T:64028 I:31998,32000,32001,32003,32004,32005,32006,32007'
G[32003]='FA K0901026 L090 A:64028 T:64028 I:31998,32000,32001,32002,32004,32005,32006,32007'
G[32004]='FA K0901026 L090 A:64028 T:64028 I:31998,32000,32001,32002,32003,32005,32006,32007'
G[32005]='FA K0901026 L090 A:64028 T:64028 I:31998,32000,32001,32002,32003,32004,32006,32007'
G[32006]='FA K0901026 L090 A:64028 T:64028 I:31998,32000,32001,32002,32003,32004,32005,32007'
G[32007]='FA K0901026 L090 A:64028 T:64028 I:31998,32000,32001,32002,32003,32004,32005,32006'
G[32008]='K00008192 L001 A:0 T:63596 P:J7433 I:31878,31879,31880,31881,31990'	-- NE druid.
G[32009]='FH K0008192 L001 A:0,63626 T:63626 I:31882,31883,31884,31885'
G[32010]='FH K0900 L090 A:64001 T:64001 P:U4F562999'
G[32011]='FA K0900 L090 A:64032 T:64032 P:U4F562999'
G[32012]='K0000 L000'
G[32013]='K0900 L090'
G[32014]='K0900 L090'
G[32015]='K0900 L090'
G[32016]='FA K0904 L090 A:64029 T:64029 I:32017 Z17056'	-- an arbitrary date for removal
G[32017]='FH K0904 L090 A:63996 T:63996 I:32016 Z17056'	-- an arbitrary date for removal
G[32018]='K0870 L086 A:56774 T:56133 I:32019'
G[32019]='K0870 L086 A:56782 T:56133 P:1 I:32018'	-- only available before Jade Temple becomes an instance?
G[32020]='SP HW FH K00016 L001 A:1215873 T:1215873'
G[32021]='SP HW K00016 L001 A:1215874 T:1215874'
G[32022]='SP HW FH K00016 L001 A:1215875 T:1215875'
G[32023]='SP HW K00016 L001 A:1215876 T:1215876'
G[32024]='SP HW K00016 L001 A:1215877 T:1215877'
G[32026]='SP HW K00016 L001 A:1215879 T:1215879'
G[32027]='SP HW K00016 L001 A:1215880 T:1215880'
G[32028]='SP HW FH K00016 L001 A:1215881 T:1215881 P:31195'
G[32029]='SP HW K00016 L001 A:1215884 T:1215884'
G[32030]='K0900 L087 A:-858 T:65395 P:31026+31085+31354+31398'	-- TODO: Verify requires 31026 31085 31398
G[32031]='SP HW K00016 L001 A:1215886 T:1215886'
G[32032]='SP HW K00016 L001 A:1215889 T:1215889'
G[32033]='SP HW FA K00016 L001 A:1215891 T:1215891'
G[32034]='SP HW K00016 L001 A:1215892 T:1215892'
G[32035]='K0870 L086 A:59585 T:57405'
G[32036]='SP HW K00016 L001 A:1215894 T:1215894'
G[32037]='SP HW K00016 L001 A:1215895 T:1215895'
G[32038]='K0870 L086 A:58434 T:58434'
G[32039]='SP HW K00016 L001 A:1215897 T:1215897'
G[32040]='SP HW FH K00016 L001 A:1215898 T:1215898 P:30515'
G[32041]='SP HW K00016 L001 A:1215899 T:1215899'
G[32042]='SP HW FA K00016 L001 A:1215900 T:1215900 P:30514'
G[32043]='SP HW K00016 L001 A:1215902 T:1215902'
G[32044]='SP HW K00016 L001 A:1215903 T:1215903 P:30637'
G[32045]='K0870 L086 A:64315 T:64315'
G[32046]='SP HW K00016 L001 A:1215906 T:1215906'
G[32047]='SP HW FH K00016 L001 A:1215904 T:1215904'
G[32048]='SP HW K00016 L001 A:1215905 T:1215905'
G[32049]='SP HW FA K00016 L001 A:1215907 T:1215907'
G[32050]='SP HW FH K00016 L001 A:1215908 T:1215908 P:E31769'
G[32051]='SP HW K00016 L001 A:1215914 T:1215914'
G[32052]='SP HW FA K00016 L001 A:1215915 T:1215915'
G[32097]='K0900 L090'
G[32098]='K0900 L090'
G[32099]='K0900 L090'
G[32105]='K0900 L085'
G[32106]='K0000 L010 E16139'
G[32107]='K0000 L085'
G[32108]='FH K0900 L090 A:68072 T:1216274 P:32250 E16139'
G[32109]='FA K0900 L090 A:68399,568399 T:1216609 P:32247 E16139'
G[32112]='K0010 L000 E16139'
G[32113]='K0010 L000 E16139'
G[32114]='K0900 L090'
G[32115]='FA K0902 L090 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,32119,V0511 E16139 D043'
G[32116]='FA K0902 L090 A:67631 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139'
G[32118]='K0902 L090 A:67847 T:68274 P:32449 E16139'
G[32119]='FA K0902 L090 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,32115,V0511 E16139 D043'
G[32120]='FH K0902 L090 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32121]='FA K0902 L090 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32122]='FA K0902 L090 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32123]='FH K0902 L090 A:67618 T:67618 P:32108 I:V0471,32450,V0481,V0501,V0521 E16139 D049'
G[32125]='K0900 L090 E16139'
G[32126]='FH K0902 L090 A:67767 T:67767 P:32108 I:V0471,32450,V0481,V0501,V0521 E16139 D049'
G[32127]='K0902 L090 A:67767 T:67767 P:32126+32235 E16139'
G[32128]='K0902 L090 A:67880 T:67880 P:32126+32235 E16139'
G[32129]='K0900 L090 E16139'
G[32130]='FH K0902 L090 A:67402 T:67402 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32131]='FH K0902 L090 A:67402 T:67402 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32132]='FH K0902 L090 A:67628 T:67628 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32133]='FH K0902 L090 A:67628 T:67628 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32134]='FH K0902 L090 A:67402 T:67402 P:32108 E16139'
G[32135]='FH K0902 L090 A:67628 T:67628 P:32108 O:32450 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32136]='FH K0902 L090 A:67535 T:67542 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32137]='K0902 L090 A:67542 T:67535 P:32136 E16139'
G[32138]='FH K0902 L090 A:67535 T:67534 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32139]='K0902 L090 A:67534 T:67534 P:32138 E16139'
G[32140]='K0902 L090 A:67535 T:67537 E16139'
G[32141]='K0902 L090 A:67537 T:67535 E16139'
G[32142]='FA K0902 L090 A:67386 T:67386 P:32109 O:32451 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32143]='FA K0902 L090 A:67976 T:-857 P:32109 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32144]='FA K0902 L090 A:67444 T:67444 P:32109 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32145]='K0902 L090 A:-857 T:67976 P:32143 E16139'
G[32146]='FA K0902 L090 A:67386 T:67386 P:32109 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32147]='K0900 L090 E16139'
G[32148]='FA K0902 L090 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32149]='FA K0902 L090 A:67630 T:67630 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32150]='FA K0902 L090 A:67630 T:67630 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32151]='FA K0902 L090 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32152]='FA K0902 L090 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32153]='FA K0902 L090 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32154]='FA K0902 L090 A:68166 T:68166 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32155]='K0900 L090 E16139'
G[32156]='FA K0902 L090 A:67444 T:67444 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32157]='FA K0902 L090 A:67386 T:67386 P:32109 O:32452 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32158]='FA K0902 L090 A:68182 T:68182 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32159]='K0900 L090 E16139'
G[32161]='FH K0902 L090 A:100091819 T:1216161 P:32108 E16139'
G[32162]='FH K0902 L090 A:100091821 T:1216162 P:32108 E16139'
G[32163]='FH K0902 L090 A:100091822 P:32108 E16139'
G[32164]='FA K0902 L090 A:100091854 T:1216161 P:32109 E16139'
G[32165]='FA K0902 L090 A:100091855 T:1216162 P:32109 E16139'
G[32166]='FA K0902 L090 A:100091856 T:1216163 P:32109 E16139'
G[32167]='FH K0902 L090 AK:67555 T:67447 I:32168,32169 E16139'	-- A:-857
G[32168]='FH K0902 L090 AK:67556 T:67447 I:32167,32169 E16139'	-- A:-857
G[32169]='FH K0902 L090 AK:67557 T:67447 I:32167,32168 E16139'	-- A:-857
G[32170]='FA K0902 L090 AK:67555 T:67558 I:32171,32172 E16139'	-- A:-857
G[32171]='FA K0902 L090 AK:67556 T:67558 I:32170,32172 E16139'	-- A:-857
G[32172]='FA K0902 L090 AK:67557 T:67558 I:32170,32171 E16139'	-- A:-857
G[32173]='K0900 L090 E16139'
G[32174]='K0900 L090 E16139'
G[32175]='K0008194 L001 A:67370 T:67370 E16139'
G[32181]='K0902 L090 A:67503 T:67447 P:32161 E16139'
G[32182]='K0902 L090 A:67498 T:67447 P:32162 E16139'
G[32183]='K0902 L090 A:67508 T:67447 P:32163 E16139'
G[32184]='K0902 L090 A:67436 T:67558 P:32164 E16139'
G[32185]='K0902 L090 A:67438 T:67558 P:32165 E16139'
G[32186]='K0902 L090 A:67508 T:67558 P:32166 E16139'
G[32189]='K0900 L090 A:58718 T:67565 E16139'	-- only available when Barnaby Fletcher at the market.  How to model?
G[32190]='K0900 L090 A:67939 T:67581 P:32372+T55F53849 E16139'
G[32191]='K0900 L090 A:67603 T:67603 P:32190 E16139'
G[32192]='K0900 L090 A:67581 T:67581 P:32190 E16139'
G[32193]='K0900 L090 A:67940 T:67682 P:32362+T56057799 E16139'
G[32194]='K0900 L090 A:67734 T:67734 P:32193 E16139'
G[32195]='K0900 L090 E16139'
G[32196]='K0900 L090 E16139'
G[32197]='FH K0902 L090 A:67562 T:67536 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'	-- TODO: Probably need to merge 048 and 052 because I got all the 052 quests in one day except for 32199.  Instead of 32199 I got 32197 which is marked 048.
G[32198]='SP K0900 L090 A:67565 T:67565 P:32189 E16139'
G[32199]='FH K0902 L090 A:67562 T:67536 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32200]='FH K0902 L090 A:70520 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32201]='K0902 L090 A:67989 T:67989 P:32259 O:32728 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32202]='K0900 L090 E16408'
G[32203]='K0900 L090 E16408'
G[32204]='K0902 L090 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32205]='K0900 L090 E16408'
G[32206]='K0902 L090 A:567985 T:567985 P:32524 E16408 D076'
G[32207]='K0902 L090 A:567986 T:567986 P:32523 E16408 D074'
G[32208]='K0902 L090 P:32277+W0743,32277+W0763 E16408 D082'
G[32209]='K0902 L090 A:67986 T:0 P:32277+W0743,32277+W0763 E16408 D082'
G[32210]='K0900 L090 E16408'
G[32211]='K0900 L090 E16408'
G[32212]='FH K0900 L090 A:67990 T:67990 P:>09281 E16408'	-- cleared when 32644 turned in
G[32213]='K090258 L090 A:67990 T:67990 P:32258 E16408 D068'
G[32214]='FH K0902 L090 A:67608 T:67608 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32215]='K0902 L090 A:569418 T:569418 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32216]='FH K0902 L090 A:567984 T:567984 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32217]='FH K0902 L090 A:569418 T:569418 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32218]='K0902 L090 A:67983 T:67983 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32219]='K0902 L090 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32220]='K0902 L090 A:67983 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32221]='FH K0902 L090 A:67608 T:67608 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32222]='FH K0902 L090 A:1216322 T:67880 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32223]='FH K0902 L090 A:1216322 T:67880 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32224]='K0902 L090 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32225]='K0902 L090 A:67989 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32226]='K0902 L090 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32227]='K0902 L090 A:567984 T:567984 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32228]='FH K0902 L090 A:67673 T:67673 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32229]='K0900 L090 E16408'
G[32230]='K0902 L090 A:67673 T:67673 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32231]='FH K0902 L090 A:67663 E16408'
G[32232]='K0902 L090 A:567985 T:567985 P:32524 E16408 D076'
G[32233]='K0902 L090 A:567985 T:567985 P:32524 E16408 D076'
G[32234]='K0902 L090 A:67986 T:67986 P:32524 E16408 D076'
G[32235]='FH K0902 L090 A:67880 T:67880 P:32108 I:V0471,32450,V0481,V0501,V0521 E16139 D049'
G[32236]='K0902 L090 A:67554 T:67554 E16139'
G[32237]='FH K0902 L090 A:67553 T:67553 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32238]='FH K0902 L090 A:67533 T:67533 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32242]='K0900 L090 A:67840 T:67834 P:32256 E16139'
G[32243]='K0900 L090 A:67716 T:67716 P:32193 E16139'
G[32244]='K0900 L090 A:67603 T:67603 P:32190 E16139'
G[32246]='FA K0900 L090 A:64610 AZ:811 T:68311 E16139'
G[32247]='FA K0900 L090 A:68392,568399 T:68399,568399 P:32246 E16139'
G[32248]='FA K0900 L090 A:67940 T:69026 P:32109 E16139'	-- TODO: This was autoaccepted after hearing their speeches
G[32249]='FH K0900 L090 A:64566 AZ:811 T:67812 E16139'
G[32250]='FH K0900 L090 A:67867,568072 T:68072,568072 P:32249 E16139'
G[32251]='FH K0900 L090 A:-857,67939 T:67414 P:32108 E16139'
G[32252]='K0902 L090 A:70520 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32253]='K0900 L090 E16408'
G[32254]='K0902 L090 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32255]='K0902 L090 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32256]='FH K0900 L090 A:67939 T:67840 P:32108+T55F45949 E16139'
G[32257]='K0900 L090 A:67834 T:67834 P:32242 E16139'
G[32258]='SP FH K0902 L090 A:70561 T:70561 P:32212+=09282,32276+=09283,32277+=09284,32278+=09285,32279+=09286 I:32259 E16408'
G[32259]='SP FH K0902 L090 A:70561 T:70561 P:32212+=09282,32276+=09283,32277+=09284,32278+=09285,32279+=09286 I:32258 E16408'
G[32260]='SP FA K0902 L090 A:70567 T:70567 P:32644+=09282,32654+=09283,32652+=09284,32655+=09285,32656+=09286 I:32261 E16408'
G[32261]='SP FA K0902 L090 A:70567 T:70567 P:32644+=09282,32654+=09283,32652+=09284,32655+=09285,32656+=09286 I:32260 E16408'
G[32262]='K090258 L090 A:67663 T:67663 P:32258 E16408 D068'
G[32263]='K0900 L090 E16408'
G[32264]='K090258 L090 A:67662 T:67662 P:32258 E16408 D068'
G[32265]='K090258 L090 A:67662 T:67662 P:32258 E16408 D068'
G[32266]='K090258 L090 A:67673 T:67673 P:32258 E16408 D068'
G[32267]='K0900 L090 E16408'
G[32268]='K090258 L090 A:67673 T:67673 P:32258 E16408 D068'
G[32269]='K090258 L090 A:67673 T:67673 P:32258 E16408 D068'
G[32270]='K0900 L090 E16408'
G[32271]='K0900 L090 E16408'
G[32272]='K0900 L090 E16408'
G[32273]='K0900 L090 E16408'
G[32274]='K0902 L090 A:69425 T:69425 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32275]='K0902 L090 A:70520 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32276]='K0900 L090 A:67990 T:67990 P:32212+>09282 E16408'
G[32277]='K0900 L090 A:67990 T:69742 P:32276+>09283 E16408'
G[32278]='K0900 L090 A:570297 T:67990 P:32277+>09284 E16408'
G[32279]='K0900 L090 A:67990 T:67990 P:32278+>09285 E16408'
G[32280]='K0900 L090 E16408'
G[32281]='K0900 L090 E16408'
G[32282]='K0902 L090 A:502081 T:502081 P:32523 E16408 D074'
G[32283]='K0902 L090 A:567986 T:567986 P:32523 E16408 D074'
G[32284]='K0900 L090 A:67865 T:67866 P:32242+T55F49899 E16139'
G[32285]='FH K0902 L090 A:67662 T:67662 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32286]='K0900 L090 E16408'
G[32287]='K0902 L090 A:67662 T:67662 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32288]='K090258 L090 A:67663 T:67663 P:32258 E16408 D068'
G[32289]='K0900 L090 T:72762 E16408'
G[32290]='K0900 L090 E16408'
G[32291]='K0900 L090 E16408'
G[32292]='K0902 L090 T:70551 P:W0821 E16408'
G[32293]='FH K0902 L090 A:67990 P:=09281+W06211,=09282+W06611,=09284+W0786,32278+W0845 E16408 D080 D060'
G[32294]='K0902 L090 P:=09283+W0743,=09283+W0763 E16408 D072'	-- TODO: Need to get both pens and terrace location for 67985 to handle this properly
G[32295]='K0900 L090 CL A:100092441 T:0 E16139'
G[32296]='K0900 L090 A:70316 T:70320 E16408'
G[32297]='K0902 L090 A:567986 T:567986 P:32523 E16408 D074'
G[32298]='K0902 L090 A:502081 T:502081 P:32523 E16408 D074'
G[32299]='K0902 L090 A:69371 T:69371 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32300]='K090258 L090 A:67663 T:67663 P:32258 E16408 D068'
G[32301]='K090258 L090 A:567993 T:567993 P:32261 E16408 D067'
G[32302]='K090258 L090 A:67673 T:67673 P:32258 E16408 D068'
G[32303]='K090258 L090 A:67662 T:67662 P:32258 E16408 D068'
G[32304]='K090258 L090 A:67990 T:67990 P:W0687 E16408'
G[32305]='K090258 L090 A:67663 T:67663 P:32258 E16408 D068'
G[32306]='K0000 L000 E16139'
G[32307]='K0900 L090 A:0 TA:5496 TH:3326 P:32295 E16139'
G[32309]='FH K0900 L090 A:3326 T:3326 P:32307 E16139'
G[32310]='FA K0900 L090 A:5496 T:5496 P:32307 E16139'
G[32311]='K0900 L090 E16139'
G[32312]='K0900 L090 E16139'
G[32313]='K0900 L090 E16139'
G[32314]='K0900 L090 E16139'
G[32315]='K0900 L090 A:67940 T:67948 P:32194+T56061749 E16139'
G[32316]='K0900 L090 A:68017 T:68242 P:32315 E16139'
G[32317]='K0900 L090 AA:5496 AH:3216 T:0 P:32309,32310 E16139'
G[32318]='K0900 L090 A:67866 T:67866 P:32284 E16139'
G[32319]='K0900 L090 A:68023 T:68025 P:32318 E16139'
G[32320]='K0900 L090 A:68025 T:568025 P:32319 E16139'
G[32321]='K0900 L090 A:68004 T:68003 P:32355 E16139'
G[32324]='K0900 L090 A:0 T:0 E16139'
G[32325]='K0900 L090 E16139'
G[32326]='K0900 L090 A:67939 T:68077 P:32392+T55F77549 E16139'
G[32327]='K0900 L090 A:68077 T:68077 P:32326 E16139'
G[32328]='K0900 L090 A:68077 T:67939 P:32327 E16139'
G[32329]='K0900 L090 A:67939 T:16802 P:32352+T55F65699 E16139'
G[32330]='K0900 L090 A:16802 T:68084 P:32329 E16139'
G[32331]='K0900 L090 A:67940 T:68106 P:32397+T56053849 E16139'	-- Honored + 2850
G[32332]='K0900 L090 A:68003 T:68538 P:32321 E16139'
G[32333]='K0900 L090 A:68003 T:68538 P:32321 E16139'
G[32334]='K0900 L090 A:68003 T:68538 P:32321 E16139'
G[32335]='K0900 L090 A:68538 T:568004 P:32332+32333+32334 E16139'
G[32336]='K0900 L090 A:68538 T:68544 P:32335+T56081499 E16139'
G[32337]='K0900 L090 A:68538 T:68538 P:32335+T56081499 E16139'
G[32338]='K0900 L090 A:68538 T:68538 P:32335+T56081499 E16139'
G[32339]='K0900 L090 E16139'
G[32340]='K0900 L090 E16139'
G[32341]='K0900 L090 E16139'
G[32342]='FH K0902 L090 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32343]='FH K0902 L090 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32344]='FH K0902 L090 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32345]='FH K0902 L090 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32346]='FA K0902 L090 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32347]='FA K0902 L090 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32348]='FH K0902 L090 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32351]='K0900 L090 A:67939 T:68287 P:32378+32379+32384+T55F61749 E16139'
G[32352]='K0900 L090 A:68287 T:67840 P:32351 E16139'
G[32355]='K0900 L090 A:67940 T:68004 P:32423+T56077549 E16139'	-- 14542 < x <= 14700 : if this turns out to be 14550, then the 3950 pattern still holds except for the quest before this one...going to set the value at 14550 just in case it is correct
G[32356]='K0000 L000 E16139'
G[32357]='K0000 L000 E16139'
G[32358]='K0900 L090 E16139'
G[32359]='K0900 L090 E16139'
G[32360]='K0900 L090 E16139'
G[32361]='K0000 L000 E16139'
G[32362]='K0900 L090 A:68106 T:68106 P:32331 E16139'
G[32363]='K0900 L090 A:67939 T:68287 P:32330+T55F69649 E16139'
G[32364]='K0900 L090 E16139'
G[32365]='K0000 L000 E16139'
G[32366]='K0900 L090 E16139'
G[32367]='K0900 L090 E16139'
G[32368]='K0900 L090 A:68287 T:68287 P:32448 E16139'
G[32369]='K0900 L090 E16139'
G[32370]='K0900 L090 A:67940 T:68375 P:32316+T56065699 E16139'
G[32371]='K0900 L090 A:-809,68375 T:68375 P:32377 E16139'
G[32372]='K0900 L090 A:568025 T:500087 P:32320 E16139'
G[32373]='FA K0904096 L090 A:64616 T:64616 P:31481 E16139'	-- this prereq may be bogus.  basically it should be completion of fleet invasion
G[32374]='K0900 L090 A:64616 T:64616 P:32373 E16139'
G[32375]='K0900 L090 E16139'
G[32376]='K0900 L090 A:67939 T:68370 P:32191+32244+T55F57799 E16139'
G[32377]='K0900 L090 A:68375 T:-809,68375 P:32370 E16139'
G[32378]='K0900 L090 A:68370 T:68370 P:32376 E16139'
G[32379]='K0900 L090 A:68370 T:68370 P:32376 E16139'
G[32380]='FA K0900 L090 A:67940 T:68526 P:32109+T56045949 E16139'	--	Friendly + 950
G[32381]='K0900 L090 A:68526 T:68526 P:32380 E16139'
G[32382]='K0900 L090 A:67940 T:68417 P:32426+T56049899 E16139'	-- Friendly + 4900
G[32383]='K0900 L090 A:68417 T:68417 P:32382 E16139'
G[32384]='K0900 L090 A:68370 T:68370 P:32376 E16139'
G[32388]='K0904096 L090 A:64616 T:64616 P:32474 E16139'
G[32389]='K0904096 L090 A:64616 T:64616 P:32474 E16139'
G[32390]='K0904096 L090 A:64616 T:1216837 P:32388+32389 E16139'
G[32391]='K0900 L090 A:67939 T:68337 P:32368+T55F71661 E16139'
G[32392]='K0900 L090 A:68337 T:68337 P:32391 E16139'
G[32393]='K0900 L090 A:67940 T:567734 P:32371+T56069649 E16139'
G[32394]='K0900 L090 A:567734 T:67951 P:32393 E16139'
G[32395]='K0000 L000 E16139'
G[32396]='K0100 L000 E16139'
G[32397]='K0900 L090 A:68417 T:68417 P:32382 E16139'
G[32398]='K0900 L090 A:67939 T:67844 P:32412+T55F83999 E16139'
G[32399]='K0900 L090 A:67844 T:68223 P:32398 E16139'
G[32400]='K0900 L090 A:67940 T:68939 P:T56083999 E16139'
G[32401]='K0900 L090 A:68939 T:68987 P:32400 E16139'
G[32402]='K0900 L090 A:67939 T:68586 P:32328+T55F81499 E16139'
G[32403]='K0900 L090 A:68586 T:68586 P:32402 E16139'
G[32404]='K0900 L090 A:68586 T:68586 P:32403 E16139'
G[32405]='K0900 L090 A:68586 T:68586 P:32404 E16139'
G[32406]='K0900 L090 A:68586 T:68586 P:32405 E16139'
G[32407]='K0900 L090 E16139'
G[32408]='K0900 L090 A:68586 T:68586 P:32406 E16139'
G[32409]='K0900 L090 A:68586 T:68586 P:32406 E16139'
G[32410]='K0900 L090 A:68586 T:68586 P:32406 E16139'
G[32411]='K0900 L090 A:68586 T:68586 P:32408+32409+32410 E16139'
G[32412]='K0900 L090 A:68586 T:16802 P:32411 E16139'
G[32413]='K0900 L090 E16139'
G[32414]='K0900 L090 A:67940 T:68651 P:32394+T56071661 E16139'	-- rep was only 8662 into revered at the time
G[32415]='K0900 L090 E16139'
G[32416]='K0900 L090 A:568651 T:68687 P:32460 E16139'
G[32417]='K0900 L090 A:68687 T:68687 P:32416 E16139'
G[32418]='K0900 L090 A:68687 T:68687 P:32416 E16139'
G[32419]='K0900 L090 A:68687 T:68687 P:32416 E16139'
G[32420]='K0900 L090 A:68687 T:68687 P:32416 E16139'
G[32421]='K0900 L090 A:68687 T:68687 P:32416 E16139'
G[32422]='K0900 L090 E16139'
G[32423]='K0900 L090 A:68687 T:68690 P:32417+32418+32419+32420+32421 E16139'
G[32424]='K0900 L090 E16139'
G[32425]='K0900 L090 E16139'
G[32426]='K0900 L090 A:68526 T:68531 P:32381 E16139'
G[32427]='FH K0904096 L090 A:64616 T:64616 E16139'
G[32428]='K0008192 L001 AA:64572 AH:64582 TA:64572 TH:64582 P:S119467 E16139'
G[32429]='FH K0900 L090 A:64616 T:64616 E16139'
G[32430]='K0904096 L090 A:64616 T:64616 P:32476 E16139'
G[32431]='K0904096 L090 A:64616 T:64616 P:32476 E16139'
G[32432]='K0904096 L090 A:64616 T:1216837 P:32430+32431 E16139'
G[32433]='K0900 L090 E16139'
G[32434]='K0000 L001 A:68463 T:68463 E16139'
G[32435]='K0000 L001 E16139'
G[32436]='K0000 L001 E16139'
G[32437]='K0000 L000 E16139'
G[32438]='K0000 L000 E16139'
G[32439]='K0000 L001 A:68462 T:68462 E16139'
G[32440]='K0000 L001 A:68464 T:68464 P:0 E16139'	-- TODO: Determine P: for this pet battle quest
G[32441]='K0000 L001 A:68465 T:68465 P:0 E16139'	-- TODO: Determine P: for this pet battle quest
G[32442]='K0000 L110 E16139'
G[32444]='K0010 L000 E16139'
G[32446]='FA K0902 L090 A:68166 T:68166 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32448]='K0900 L090 A:68287 T:68287 P:32363 E16139'
G[32449]='FH K0902 L090 A:67880 T:67847 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32450]='FH K0902 L090 A:67880 T:67628 P:32108 I:V0481,V0491,V0501,V0521 E16139'
G[32451]='FA K0902 L090 A:68908 T:67386 P:32109 I:V0431,32116,V0461,32452,V0511 E16139'
G[32452]='FA K0902 L090 A:68908 T:67386 P:32109 I:V0431,32116,V0441,32451,V0511 E16139'
G[32455]='K0900 L090 A:68987 T:69090 P:32401 E16139'
G[32457]='K0900 L090 T:69782 E16139'
G[32458]='K0900 L090 E16139'
G[32459]='K0900 L090 E16139'
G[32460]='K0900 L090 A:68651 T:568651 P:32414 E16139'
G[32461]='K0900 L090 E16139'
G[32467]='K0900 L090 E16408'
G[32468]='K0900 L090 E16408'
G[32469]='K0900 L090 E16408'
G[32470]='K0900 L090 E16408'
G[32471]='K0900 L090 E16408'
G[32472]='K0900 L090 E16408'
G[32474]='FA K0904096 L090 A:64616 T:64616 P:32373 E16309'
G[32475]='K0900 L090 E16408'
G[32476]='FH K0904096 L090 A:64616 T:64616 P:32427 E16309'
G[32477]='K0900 L090 E16309'
G[32482]='K0900 L090 E16408'
G[32485]='K090258 L090 A:67992 T:67992 P:32261 E16408 D067'
G[32489]='K0902 L090 A:69371 T:69371 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32490]='K0900 L090 E16408'
G[32491]='K0902 L090 A:69371 T:69371 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32492]='K0900 L090 E16408'
G[32493]='K0902 L090 A:67986 T:67986 P:32524 E16408 D076'
G[32494]='K0902 L090 A:67986 T:67986 P:32524 E16408 D076'
G[32495]='K0902 L090 A:67989 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32496]='SP HM FA K0000 L001 A:1217852 T:1217852 E16408'
G[32497]='SP HM K0000 L001 A:69522 T:1217845 E16408'
G[32498]='SP HM K0000 L001 A:69529 T:1217846 E16408'
G[32499]='SP HM K0000 L001 A:69533 T:1217847 E16408'
G[32500]='SP HM K0000 L001 A:69535 T:1217848 E16408'
G[32501]='SP HM K0000 L001 A:69536 T:1217849 E16408'
G[32502]='SP HM K0000 L001 A:69550 T:1217850 E16408'
G[32503]='SP HM FH K0000 L001 A:1217851 T:1217851 E16408'
G[32504]='K0200 L015 E16408'
G[32505]='K0900 L090 A:1218072 T:1218077 E16408'
G[32506]='K0902 L090 A:67663 T:67663 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32507]='FH K0900 L090 A:69433 T:69227 E16408'
G[32508]='K0900 L090 E16408'
G[32509]='SP HM FH K0000 L001 A:69551 T:69551 E16408'
G[32510]='SP HM FA K0000 L001 A:69572 T:69572 E16408'
G[32516]='K0900 L090 E16408'
G[32517]='K0902 L090 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32518]='K0900 L090 E16408'
G[32519]='K0900 L090 E16408'
G[32520]='K0902 L090 P:=09281+W06111,=09282+W06511,=09284+W0776,32655+W0835 E16408 D079 D059'
G[32521]='K0902 L090 A:67660 T:67990 P:=09283+W0743,=09283+W0763,=09284+W0786,32278+W0845 E16408 D080 D072'	-- TODO: Need to get both pens and terrace location for 67985 (and the four other possible questgivers) to handle this properly
G[32522]='K0902 L090 P:=09283+W0743,=09283+W0763,=09284+W0786,32278+W0845 E16408 D080 D072'	-- TODO: Need to get both pens and terrace location for 67985 (and the four other possible questgivers) to handle this properly
G[32523]='K0902 L090 P:=09283+W0708,=09284+W0786,32278+W0845 I:32524 E16408'
G[32524]='K0902 L090 A:70520,567660 T:567985 P:=09283+W0708,=09284+W0786,32278+W0845 I:32523 E16408'
G[32525]='FA K0902 L090 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32526]='K0902 L090 AP:67997:X32644;567997:32644 TP:67997:X32644;567997:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32527]='FA K0902 L090 AP:67997:X32644;567997:32644 TP:67997:X32644;567997:32644 P:X32644,32644+32260 O:32731 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32528]='K0902 L090 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32529]='K0902 L090 A:69670 T:69670 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32530]='K0902 L090 A:69670 T:69670 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32531]='K0902 L090 A:69670 T:69670 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32532]='K0902 L090 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32533]='FA K0902 L090 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32534]='K0900 L090 T:72762 E16408'
G[32535]='FA K0902 L090 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 O:32732 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32536]='FA K0902 L090 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32537]='FA K0902 L090 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32538]='K0902 L090 AP:69674:X32644;569674:32644 TP:69674:X32644;569674:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32539]='FA K0902 L090 AP:69674:X32644;569674:32644 TP:69674:X32644;569674:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32540]='FA K0902 L090 AP:70517:X32644;570517:32644 TP:70517:X32644;570517:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32541]='K0902 L090 AP:69673:X32644;569673:32644 TP:69673:X32644;569673:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32542]='FA K0902 L090 A:67992 T:70517 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32543]='K0902 L090 AP:70517:X32644;570517:32644 TP:70517:X32644;570517:32644 P:X32644,32644+32260 O:32733 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32544]='K0902 L090 AP:69673:X32644;569673:32644 TP:69673:X32644;569673:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32545]='K0902 L090 AP:69675:X32644;569675:32644 TP:69675:X32644;569675:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32546]='FA K0902 L090 AP:69677:X32644;569677:32644 TP:69677:X32644;569677:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32547]='FA K0902 L090 AP:69677:X32644;569677:32644 TP:69677:X32644;569677:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32548]='K0902 L090 AP:69677:X32644;569677:32644 TP:69677:X32644;569677:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32549]='FA K0900 L090 AP:69678:X32644;569678:32644 T:-928 P:X32644,32644+32260 E16408'	-- T at 45.03,67.89 (at least for early phases)
G[32550]='K0902 L090 A:67998 T:67998 P:32567 E16408 D073'
G[32551]='K0902 L090 A:67998 T:67998 P:32567 E16408 D073'
G[32552]='K0902 L090 A:67999 T:67999 P:32567 E16408 D073'
G[32553]='K0902 L090 A:67999 T:67999 P:32567 E16408 D073'
G[32554]='K0902 L090 A:67998 T:67998 P:32567 E16408 D073'
G[32555]='K0902 L090 A:567999 T:567999 P:32568 E16408 D075'
G[32556]='K0902 L090 A:567999 T:567999 P:32568 E16408 D075'
G[32557]='K0902 L090 A:567998 T:567998 P:32568 E16408 D075'
G[32558]='K0902 L090 A:567999 T:567999 P:32568 E16408 D075'
G[32559]='K0902 L090 A:567998 T:567998 P:32568 E16408 D075'
G[32560]='K0902 L090 A:567998 T:567998 P:32568 E16408 D075'
G[32561]='K0902 L090 P:=09281+W06211,=09282+W06611,=09284+W0786,32278+W0845 E16408 D080 D060'
G[32562]='K0900 L090 E16408'
G[32563]='K0900 L090 E16408'
G[32564]='K0902 L090 P:=09283+W0743,=09283+W0763 E16408 D072'	-- TODO: Need to get both pens and terrace location for 67985 to handle this properly
G[32565]='K0900 L090 E16408'
G[32566]='K0900 L090 E16408'
G[32567]='K0902 L090 A:567997,570517,567996,67992 T:67998 P:=09283+W0698,=09284+W0776,32655+W0835 I:32568 E16408'
G[32568]='K0902 L090 A:567997,570517,567996,67992 T:567998 P:=09283+W0698,=09284+W0776,32655+W0835 I:32567 E16408'
G[32569]='K0900 L090 E16408'
G[32570]='K0900 L090 E16408'
G[32571]='K0902 L090 A:67994 T:67994 P:32644+32260 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32572]='K0902 L090 A:567995 T:567995 P:32644+32260 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32573]='K0902 L090 A:567995 T:567995 P:32644+32260 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32574]='K0902 L090 A:567993 T:567993 P:32260+32644 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32575]='K0902 L090 A:567993 T:567993 P:32260+32644 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32576]='K0902 L090 AP:67997:X32644;567997:32644 T:67992 P:32529,32533 E16408'	-- TODO:	Determine proper P: code !!! this is Competing Magic for Alliance definitely
G[32577]='K0902 L090 AP:67998:=09283+32567;567998:=09283+32568;567997:32652;570517:32652;567996:32652;67992:32652 T:67992 P:=09283+W0733,=09283+W0753,=09284+W0776,32655+W0835 E16408 D079 D071'
G[32578]='FA K0902 L090 A:67992 T:67992 P:=09281+W06111,=09282+W06511,=09284+W0776,32655+W0835 E16408 D079 D059'
G[32579]='K0902 L090 AP:67997:X32644;567997:32644 T:67992 P:X32644,32644+32260 E16408'
G[32580]='K0902 L090 AP:67998:=09283+32567;567998:=09283+32568;567997:32652;570517:32652;567996:32652;67992:32652 T:67992 P:=09283+W0733,=09283+W0753,=09284+W0776,32655+W0835 E16408 D079 D071'
G[32581]='K0902 L090 AP:67997:X32644;567997:32644 T:67992 P:X32644,32644+32260 E16408'
G[32582]='K0902 L090 AP:67998:=09283+32567;567998:=09283+32568 TP:67998:=09283+32567;567998:=09283+32568 P:=09283+W0733,=09283+W0753 E16408 D071'
G[32583]='K0902 L090 AP:67998:=09283+32567;567998:=09283+32568 TP:67998:=09283+32567;567998:=09283+32568 P:=09283+W0733,=09283+W0753 E16408 D071'
G[32584]='K0902 L090 A:67998 T:67998 P:X32644,32644+32260 E16408'
G[32585]='K0902 L090 A:67998 T:67998 P:X32644,32644+32260 E16408'
G[32586]='K0902 L090 AP:67999:32567;567999:32568 T:-928 P:32652+W0733,32652+W0753 E16408 D081'
G[32587]='K0902 L090 A:-928 T:70552 P:W0811 E16408'
G[32588]='K0902 L090 AP:67999:32567;567999:32568 T:0 P:32652+W0733,32652+W0753 E16408 D081'
G[32589]='K090128 L090 A:67990 T:67990 P:T56C83999 E16408'
G[32590]='K0904096 L090 A:64616 T:69782 P:32390,32432 E16446'
G[32591]='K0904096 L090 A:69782 T:69782 P:32590+32592 E16446'	-- TODO: Verify requires 32592
G[32592]='K0904096 L090 A:69782 T:69782 P:32390,32432 E16446'	-- technically one might have to have accepted 32590 for Wrathion to move
G[32593]='K0904096 L090 A:69782 T:70100 P:32591 E16446'
G[32594]='K0904096 L090 A:70100 T:69782 P:32593 E16446'
G[32595]='K0904096 L090 A:69782 T:70476 P:32594 E16446'
G[32596]='K0904096 L090 A:70476 T:69782 P:32595 E16446'
G[32597]='K0904096 L090 A:69782 T:69782 P:32596 E16446'	-- finished Chapter III: Two Princes
G[32598]='K0900 L090 E16446'
G[32599]='K090128 L090 A:67992 T:67992 P:T56B83999 E16446'
G[32600]='K0900 L090 T:61962 E16446'
G[32601]='K0900 L090 T:61962 E16446'
G[32602]='K0900 L090 T:61962 E16446'
G[32603]='K0008192 L001 AA:64572 AH:64582 TA:64572 TH:64582 P:S119467 E16446'
G[32604]='K0000 L001 A:64572 T:64572 E16446'
G[32605]='K0902 L090 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16446 D058 D092 D062 D066 D070 D078 D084'
G[32606]='FA K0902 L090 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16446 D057 D091 D061 D065 D069 D077 D083'
G[32607]='K0902 L090 A:69413 T:67992 P:32587+32655 E16446 D085'
G[32608]='K0902 L090 A:69413 T:67992 P:32587+32655 E16446 D085'
G[32609]='K0900 L090 T:64337 E16446'
G[32610]='K0900 L090 T:64337 E16446'
G[32611]='K0900 L090 T:72763 E16446'
G[32613]='SP K0901 L089 A:70022 T:70022 E16446'
G[32614]='SP K0901 L089 A:70022 T:70022 E16446'
G[32615]='SP K0901 L089 A:70022 T:70022 E16446'
G[32616]='SP K0901 L089 A:70022 T:70022 E16446'
G[32617]='SP K0901 L089 A:70022 T:70022 E16446'
G[32618]='FA K0000 L001 RH XP XL XD A:0 T:4732 P:L020 I:Y891 E16446'
G[32621]='K0900 L090 A:100094721 P:PB500 E16467'
G[32622]='K0900 L090 E16467'
G[32626]='K0900 L090 T:64337 E16467'
G[32627]='K090258 L090 A:67994 T:67994 P:32261 E16467 D067'
G[32628]='K090258 L090 A:567995 T:567995 P:32261 E16467 D067'
G[32629]='K0900 L090 E16467'
G[32630]='K0900 L090 A:100094862 P:PN500 E16467'
G[32631]='K090258 L090 A:67992 T:67992 P:W0677 E16467'
G[32632]='K090258 L090 A:67994 T:67994 P:32261 E16467 D067'
G[32633]='K090258 L090 A:67994 T:67994 P:32261 E16467 D067'
G[32634]='K090258 L090 A:567995 T:567995 P:32261 E16467 D067'
G[32635]='K090258 L090 A:67992 T:67992 P:32261 E16467 D067'
G[32636]='K090258 L090 A:67992 T:67992 P:32261 E16467 D067'
G[32637]='K090258 L090 A:67992 T:67992 P:32261 E16467 D067'
G[32638]='K090258 L090 A:567995 T:567995 P:32261 E16467 D067'
G[32639]='K090258 L090 A:567995 T:567995 P:32261 E16467 D067'
G[32640]='K090512 L090 A:70160 T:70160 E16486'
G[32641]='K0900 L090 E16486'
G[32642]='FH K0900 L090 A:1218750 T:-807 P:FH+32682 E16486'
G[32643]='FH K0902 L090 A:-807,1218765 T:1218765 P:32642 E16486'
G[32644]='FA K0900 L090 A:70370 T:67992 P:>09281 E16486'
G[32645]='FA K0900 L090 A:1218750 T:-807 P:FA+32682 E16486'
G[32646]='FA K0902 L090 A:-807,1218765 T:1218765 P:32645 E16486'
G[32647]='K0900 L090 A:1218750 T:-807 P:32682 E16486'
G[32648]='K0902 L090 A:-807,1218765 T:1218765 P:32647 E16486'
G[32649]='K0900 L090 A:1218750 T:-807 P:32682 E16486'
G[32650]='K0902 L090 A:-807,1218765 T:1218765 P:32649 E16486'
G[32651]='K0900 L090 E16486'
G[32652]='K0900 L090 A:67992 T:69741 P:32654+>09283 E16486'
G[32653]='K0900 L090 A:1218750 T:-807 P:32682 E16486'
G[32654]='K0900 L090 A:67992 T:67992 P:32644+>09282 E16486'
G[32655]='K0900 L090 A:70297 T:67992 P:32652+>09284 E16486'
G[32656]='K0900 L090 A:67992 T:67992 P:32655+>09285 E16486'
G[32657]='K0902 L090 A:-807,1218765 T:1218765 P:32653 E16486'
G[32658]='K0900 L090 A:1218750 T:-807 P:32682 E16486'
G[32659]='K0902 L090 A:-807,1218765 T:1218765 P:32658 E16486'
G[32661]='FA K0000 L001 RD XP XD A:0 P:L020 I:Y891 E16486'
G[32662]='FA K0000 L001 RF XP XL XD A:0 T:4772 P:L020 I:Y891 E16486'
G[32663]='FA K0000 L001 RN XL XD A:0 T:7954 P:L020 I:Y891 E16486'
G[32664]='FA K0000 L001 RE XD A:0 T:4753 P:L020 I:Y891 E16486'
G[32665]='FA K0000 L001 RA A:0 T:70296 P:L020 I:Y891 E16486'
G[32666]='K0010 L000 E16486'
G[32667]='FH K0000 L001 RA A:0 T:70301 P:L020 I:Y891 E16486'
G[32668]='FH K0000 L001 RB XP XL XD A:0 T:16280 P:L020 I:Y891 E16486'
G[32669]='FH K0000 L001 RO XL XD A:0 T:4752 P:L020 I:Y891 E16486'
G[32670]='FH K0000 L001 RT XP XD A:0 T:3690 P:L020 I:Y891 E16486'
G[32671]='FH K0000 L001 RL XL XD A:0 T:7953 P:L020 I:Y891 E16486'
G[32672]='FH K0000 L001 RU XL XD A:0 T:4773 P:L020 I:Y891 E16486'
G[32673]='FH K0000 L001 RG XL XD A:0 T:48513 P:L020 I:Y891 E16486'
G[32674]='FH K0000 L001 A:0 T:44919 P:PR150+L060 I:J5180'
G[32675]='FA K0000 L001 A:0 T:43769 P:L060 I:Y5180'	-- TODO: Technically this was offered to a level 60 without 150 riding, and the I: should probably be Y and not J since account wide is true but the level 60 gets it offered	-- remnoved P:PR150+
G[32676]='K0902 L090 T:72762 P:32292+32278 E16486 D086'
G[32677]='K0902 L090 A:69413 T:67990 P:32292+32278 E16486 D086'
G[32678]='FH K0900 L090 A:64566 AZ:811 T:70358 I:32679 E16486'	-- TODO: Determine whether this requires Dominance Offensive Campaign achievement.  Does not appear to since one can not have done Meet The Scount and have this available.
G[32679]='FA K0900 L090 A:64610 AZ:811 T:70360 I:32678 E16486'	-- TODO: Determine whether this requires Operation: Shieldwall Campaign achievement
G[32680]='FH K0900 L090 A:70358 T:567990 O:32678 I:32681 E16486'
G[32681]='FA K0900 L090 A:70360 T:567992 O:32679 I:32680 E16486'
G[32682]='K0900 L090 A:64597 T:64597 P:T4F883999+30574+R114624+i114624 E16486'	-- requires Exalted with Tillers and all plots at farm available
G[32683]='FA K0850 L085 A:64085 T:64085 E16486'	-- why does a Grail.lua have this as K0850?
G[32684]='K0900 L090 A:64231 T:70398 P:31281 E16486'
G[32685]='K0900 L085 A:70398 T:70398 E16486'
G[32686]='K0900 L085 A:100095383 T:1218958 P:K100095383+PX525 E16486'
G[32687]='K0900 L085 A:100095384 T:1218957 P:K100095384+PX525 E16486'
G[32688]='K0900 L085 A:100095385 T:1218956 P:K100095385+PX525 E16486'
G[32689]='K0900 L085 A:100095386 T:1218955 P:K100095386+PX525 E16486'
G[32690]='K0900 L085 A:100095387 T:1218954 P:K100095387+PX525 E16486'
G[32691]='K0900 L085 A:100095388 T:1218953 P:K100095388+PX525 E16486'
G[32692]='K0900 L085 A:100095389 T:1218952 P:K100095389+PX525 E16486'
G[32693]='K0900 L085 A:100095390 T:1218951 P:K100095390+PX525 E16486'
G[32694]='K0900 L090 E16486'
G[32695]='K0900 L090 E16486'
G[32696]='K0900 L090 E16486'
G[32697]='K0900 L090 E16486'
G[32698]='K0900 L090 E16486'
G[32699]='K0900 L090 E16486'
G[32700]='K0900 L090 E16486'
G[32701]='K0900 L090 E16486'
G[32702]='K0900 L090 E16486'
G[32703]='K0900 L090 E16486'
G[32704]='K0900 L090 E16486'
G[32705]='K0900 L090 E16486'
G[32706]='K0900 L090 A:70370 T:70160 P:32681 E16486'
G[32707]='K0900 L090 A:70160 T:70160 P:32706 E16486'	-- TODO: Determine if it is an O: instead of P:
G[32708]='K090512 L090 A:70160 T:70160 P:32707 E16486'
G[32709]='K0900 L090 A:67990 T:70160 P:32680 E16486'	-- marked complete when 32706 is completed
G[32710]='K0930 L090 E16486'
G[32711]='K0930 L090 T:-930 E16486'
G[32712]='K0930 L090 E16486'
G[32713]='K0930 L090 E16486'
G[32714]='K0930 L090 E16486'
G[32715]='K0930 L090 T:-930 E16486'
G[32716]='K0930 L090 E16486'
G[32717]='K0930 L090 E16486'
G[32718]='FH K0904 L090 A:63996 T:63996 E16486 Z17227'
G[32719]='FA K0904 L090 A:64029 T:64029 E16486 Z17227'
G[32720]='K0900 L090 E16503'
G[32721]='K0900 L090 E16503'
G[32722]='K0900 L090 T:72762 E16503'
G[32723]='K0900 L090 T:72762 E16503'
G[32724]='K0900 L090 T:72762 E16503'
G[32725]='K0010 L000 E16503'
G[32726]='K0850 L085 E16503'
G[32727]='K0900 L090 E16539'
G[32728]='K0900 L090 A:67673 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16539 D088'
G[32729]='K0900 L090 A:67990 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16539 D087'	-- this one marked complete when 32733 is
G[32730]='K0900 L090 A:67663 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16539 D092'
G[32731]='K0902 L090 AP:67993:X32644;567993:32644 TP:67997:X32644;567997:32644 P:32681+X32644,32260+32644 I:V0911+V0891,V0911+V0631,V0891+V0631 E16539 D090'
G[32732]='K0902 L090 AP:67995:X32644;567995:32644 TP:67996:X32644;567996:32644 P:32681+X32644,32260+32644 I:V0901+V0891,V0901+V0631,V0891+V0631 E16539 D091'
G[32733]='FA K0902 L090 AP:70370:X32644;67992:32644 TP:70517:X32644;570517:32644 P:32681+X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16539 D089'
G[32744]='K0900 L090 T:73025 E16539'
G[32745]='K0900 L090 T:73025 E16539'
G[32746]='K0900 L090 T:73025 E16539'
G[32747]='K0900 L090 E16539'
G[32748]='K0900 L090 E16539'
G[32749]='K0900 L090 T:72763 E16539'
G[32750]='K0900 L090 E16539'
G[32751]='K0900 L090 T:72762 E16539'
G[32752]='K0900 L090 T:72841 E16539'
G[32753]='K0900 L090 E16539'
G[32754]='K0900 L090 T:73293 E16539'
G[32755]='K0900 L090 T:73293 E16539'
G[32756]='K0900 L090 T:73293 E16539'
G[32758]='K0900 L090 E16562'	-- I just checked and this is not used in 16562 as a replacement for 32307 for either faction.  I hope Blizzard does not make use of this quest because Grail handles turning in a quest to different NPCs based on faction without problems, and this is just a waste of space as far as I can tell.
G[32783]='K0910 L090 A:70860 T:70909 P:33473 E18546'
G[32784]='E19027'
G[32791]='K0910 L090 A:70909 T:74000 P:32783 E18546'
G[32792]='K0910 L090 A:74000 T:70910 P:32791 E18546'
G[32793]='E19634'
G[32794]='K0910 L090 A:70910 T:70941 P:32792+32929 E18546'	-- TODO: Verify requires 32792
G[32795]='K0910 L090 A:70941 T:570941 P:32794 E18546'
G[32796]='K0910 L090 A:570941 T:574163 P:32795 E18546'
G[32797]='E19634'
G[32799]='E18546'
G[32800]='E18546'
G[32801]='E18546'
G[32802]='E18546'
G[32803]='T:93812 E18546'
G[32804]='K0910 L090 A:74223 T:74223 P:32792 E18546'	-- TODO: Verify P: correct
G[32805]='K0904096 L090 A:69782 T:71352 P:32597 E16758'
G[32806]='K0900 L090 A:61962 T:61962 E16758'	-- "Blood in the Snow" scenario
G[32807]='K0900 L090 A:61962 T:61962 P:32806 E16758'	-- "Dark Heart of Pandaria" scenario
G[32808]='FA K0900 L090 A:61962 T:71027 P:32807 E16758'
G[32809]='K0900 L090 A:71027 T:71027 P:32808 E16758'
G[32810]='K0900 L090 A:71027 T:71320 P:32809 E16758 Z17056'	-- an arbitrary date for removal
G[32811]='K0900 L090 A:70978 T:70978 P:32871 E16758'
G[32812]='FH K0900 L090 A:61962 T:71333 P:32807 E16758 Z17056'	-- an arbitrary date for removal
G[32813]='K0900 L090 A:71148 T:71148 P:32819 E16758'
G[32814]='K0900 L090 A:71148 T:70978 P:32813 E16758'
G[32815]='K0900 L090 A:71150 T:70980 P:32811,32814 E16758'
G[32816]='K0900 L090 A:70980 T:570980 P:32815 E16758'
G[32817]='K0900 L090 T:90066 E16758'
G[32818]='K0900 L090 E16758'
G[32819]='K0900 L090 A:71148 T:71148 P:32867 E16758'
G[32825]='K0900 L090 E16758'
G[32826]='K0900 L090 E16758'
G[32827]='K0900 L090 E16758'
G[32832]='K0900 L090 E16758'
G[32836]='K1000 L100 E16758'
G[32837]='K1000 L100 E16758'
G[32838]='K1000 L100 A:100097979 TA:70752 TH:70751 E16758'
G[32839]='K1000 L100 A:70752 T:70752 P:32838 E16758'
G[32840]='K1000 L100 E16758'
G[32841]='K1000 L100 E16758'
G[32842]='K1000 L100 A:63054 T:70752 E16758'
G[32843]='K1000 L100 A:70751 E16758'
G[32844]='K1000 L100 A:100097982 TA:70752 TH:70751 E16758'
G[32845]='K1000 L100 A:70751 E16758'
G[32846]='K1000 L100 E16758'
G[32847]='K1000 L100 A:70752 E16758'
G[32848]='K1000 L100 E16758'
G[32849]='K1000 L100 E16758'
G[32850]='K1000 L100 A:100097985 TA:70752 TH:70751 E16758'
G[32851]='K1000 L100 A:70752 T:70752 P:32850 E16758'
G[32852]='K1000 L100 A:100097986 TA:70752 TH:70751 E16758'
G[32853]='K1000 L100 A:70752 E18019'
G[32854]='K1000 L100 A:54485 T:70752 E16758'
G[32855]='K1000 L100 A:70752 E16758'
G[32856]='K1000 L100 A:100097988 T:70752 E16758'
G[32857]='K1000 L100 A:70752 E16758'
G[32858]='K1000 L100 A:71226 T:70752 E16758'
G[32859]='K1000 L100 A:70752 T:70752 E16758'
G[32860]='K0000 L000 E16758'
G[32861]='K0900 L090 A:71352 T:71426 P:0 E16758'
G[32862]='FH K0904 L090 A:571333 T:571333 P:32814 E16758'
G[32863]='K0008196 L001 AA:64572,63596 AH:63626,64582 TA:64572,63596 TH:63626,64582 E16758'	-- Cannot used AP:64572,63596:FA;63626,64582:FH TP:64572,63596:FA;63626,64582:FH because we cannot have more than one NPC id for each qualifier.  If we change the routine that processes this to go through the , separated NPC ids it should work.
G[32864]='K0000 L000 E16758'
G[32865]='K0000 L000 E16758'
G[32866]='K0000 L000 E16758'
G[32867]='K0900 L090 A:71333 T:71148 P:32812 E16758'
G[32868]='K00024580 L001 AA:64572,63596 AH:64582,63626 TA:64572,63596 TH:64582,63626 E16758'
G[32869]='K0000 L001 A:64572 T:64572 E16758'
G[32870]='K0900 L090 E16758'
G[32871]='K0900 L090 A:71322 T:70978 P:32810 E16758'
G[32872]='FA K0904 L090 A:571333 T:571333 P:32811 E16758'
G[32873]='K090 L090 E16790'
G[32874]='K090 L090 E16790'
G[32890]='K090 L090 E16790'
G[32891]='K090 L090 E16790'
G[32892]='K090 L090 A:61962 AZ:811 T:61962 E16790 Z17271'	--	32806 is offered immediately upon turnin, but is available before hand as well -- TODO: Research the rumor that one needs gear good enough to be able to do scenarios to get this quest
G[32893]='K090 L090 E16790'
G[32894]='K090 L090 E16790'
G[32895]='FA K0904 L090 A:71336 T:71333 E16837 Z17128'
G[32896]='FH K0904 L090 A:71483 T:71333 E16837 Z17128'
G[32897]='K090 L090 E16837'
G[32898]='K090 L090 T:67426 E16837'
G[32899]='K090 L090 E16837'
G[32900]='FA K090 L090 A:64101 T:64101 P:Q480 E16837'
G[32901]='FH K090 L090 A:66998 T:66998 P:Q480 E16837'
G[32910]='K090 L090 E17056'
G[32911]='E18546'
G[32913]='E18546'
G[32914]='E19634'
G[32917]='E18546'
G[32918]='E18546'
G[32919]='K090 L090 E17056'
G[32920]='E18546'
G[32921]='E18546'
G[32922]='K090 L090 E17056'
G[32923]='K090 L090 E17056'
G[32924]='K090 L090 E17056'
G[32929]='K0910 L090 A:74222 T:74223 P:32791 E18546'
G[32934]='E18546'
G[32935]='E18546'
G[32936]='E18546'
G[32941]='T:93812 E18546'
G[32942]='K090 L090 E17056'
G[32943]='K090 L090 E17056'
G[32944]='FA K090 L090 A:1218750 T:-807 P:32682 E17056'
G[32945]='FA K090 L090 A:-807,1218765 T:1218765 P:32944 E17056'
G[32946]='K0850 L085 E18546'
G[32949]='K0000 L000 E17056'
G[32952]='K0000 L000 E17056'
G[32956]='SP K0004 L000 A:1220986 T:1220986 E17056'
G[32957]='SP K0004 L000 A:1220832 T:1220832 E17056'
G[32958]='SP K0004 L000 A:1221036 T:1221036 E17056'
G[32959]='K0000 L000 T:71919 E17056'
G[32960]='K0000 L000 T:71864 E17056'
G[32961]='K0000 L000 T:71823 E17056'
G[32962]='K0000 L000 T:73162 E17056'	-- trying to find the lost body
G[32964]='K0000 L000 E17056'
G[32965]='K0000 L000 E17056'
G[32966]='K0000 L000 T:72045 E17056'
G[32967]='K0000 L000 T:71143 E17056'
G[32968]='SP K0004 L000 A:1220902 T:1220902 E17056'
G[32969]='SP K0004 L000 A:1220901 T:1220901 E17056'
G[32970]='K0000 L000 T:73703 E17056'	-- me jumping onto the mast?
G[32971]='SP K0004 L000 A:1220903 T:1220903 P:32968+32969 E17056'
G[32972]='K0000 L000 E17056'
G[32973]='K0000 L000 E17056'
G[32974]='K090 L090 A:100102225 T:72751 E17056'
G[32975]='K090 L090 A:72751 T:72754 P:32974 E17056'
G[32976]='K090 L090 A:72754 T:72755 P:32975 E17056'
G[32979]='FH K1000 L100 A:74808 T:72230 P:>09761 E18912 D098'
G[32980]='K1000 L100 A:72230 T:74253 P:32979 E18912'
G[32981]='FH K0920 L090 A:79229 T:79229 E18546'
G[32982]='E19533'
G[32983]='K1000 L100 A:574253 T:500249 P:32980 E18912'
G[32984]='K1000 L100 A:500249 T:74330 P:32983+33444 E18912'
G[32985]='K1000 L100 A:74330 T:74330 P:32984 E18912'
G[32989]='K0910 L090 A:70860 T:72274 P:33473 E18546'
G[32990]='K0910 L090 A:72274 T:72274 P:32989 E18546'
G[32991]='K0910 L090 A:72274 T:572274 P:32990 E18546'
G[32992]='K0910 L090 A:572274 T:500153 P:32991 E18546'
G[32993]='K0910 L090 A:500153 T:72373 P:32992 E18546'
G[32994]='K0910 L090 A:73097 T:73097 P:33826 E18546'
G[32995]='K0000 L090 E17056'
G[32996]='K0000 L090 E17056'
G[32997]='K0000 L000 T:72245 E17056'
G[33000]='K0000 L090 E17056'
G[33001]='K0000 L090 E17056'
G[33002]='K0000 L090 E17056'
G[33003]='K0000 L090 E17056'
G[33007]='K0000 L090 E17056'
G[33008]='K0870 L087 E17056'
G[33010]='K0920 L090 A:574163 T:76720 P:37291 E18663'
G[33011]='E18556'
G[33012]='E18556'
G[33013]='FH K0910 L090 A:74358 T:-941 E18556'	-- no known preqs
G[33014]='E18556'
G[33015]='E18556'
G[33016]='E18556'
G[33017]='T:93812 E18556'
G[33018]='K090 L090 A:1221376 T:72426 P:31467+31471+31474+31476+31477+31480+33231|33232 E17056'
G[33019]='K090 L090 E17056'
G[33020]='K090 L090 A:72426 T:1221413 P:33018 E17056'
G[33021]='K090 L090 A:-867 T:64231 P:33107 E17056'	-- marks 33139 complete as well
G[33022]='K090 L090 A:64231 T:64231 P:33021 E17056'
G[33023]='K090 L090 E17056'
G[33024]='K090 L090 A:64231 T:64231 P:33022 E17056'
G[33025]='K090 L090 E17056'
G[33026]='K090 L090 A:64231 T:64231 P:33024 E17056'
G[33027]='K090 L090 A:64231 T:64231 P:33026 E17056'
G[33028]='E18556'
G[33034]='E18556'
G[33035]='E18556'
G[33036]='E18556'
G[33037]='SP K000131072 A:1224783 T:1224783 E18556'
G[33038]='E18556'
G[33039]='E18556'
G[33041]='SP K000131072 A:1227134 T:1227134 E18556'
G[33042]='E18556'
G[33043]='E18556'
G[33044]='E18556'
G[33045]='E18556'
G[33046]='SP K000131072 A:1232591 T:1232591 E18556'
G[33047]='K090 L090 E17056'
G[33051]='E18546'
G[33052]='E18546'
G[33053]='E18546'
G[33054]='E18546'
G[33055]='T:76561 E18546'
G[33056]='E18546'
G[33057]='E18546'
G[33058]='E18546'
G[33059]='K0910 L090 A:579043 T:79043 P:33076 E18546'
G[33060]='E18546'
G[33061]='E18546'
G[33062]='FA K0940 L094 A:577184 T:577184 O:33359 E18546'	--	TODO: It appears you need the garrison (or something along that line for this to be available)
G[33063]='E18546'
G[33064]='E18546'
G[33065]='E18546'
G[33066]='K0940 L094 A:77184 T:77417 P:33112 E18546'
G[33067]='E18546'
G[33068]='E18546'
G[33069]='T:90429 E18546'
G[33070]='K0910 L090 A:80196 T:74043 P:33075 I:33073 E18546'
G[33071]='E21570'
G[33072]='K0910 L090 A:74043 T:79043 P:34019 E18546'	-- when you meet with Velen for 33072 turnin 34599 completes
G[33073]='I:33070 E18546'
G[33074]='E18546'
G[33075]='K0910 L090 A:80568 T:75005 P:34692 E18546'
G[33076]='K0910 L090 A:79043 T:579043 P:33072 E18546'
G[33077]='FA K0910 L090 A:71641 T:71641 E18546'
G[33078]='FA K0910 L090 A:74121 T:74121 E18546'
G[33079]='E18663'
G[33080]='K0910 L090 A:73425 T:74877 P:33072 E18546'
G[33081]='K09132 L090 A:74877 T:76067 P:33080 E18546'
G[33082]='FA K0910 L090 A:75884 T:575884 P:33586 E18546'
G[33083]='K0910 L090 A:81176 T:77282 P:34043 E18546'
G[33084]='FA K0910 L090 A:74233 T:74233 E18546'
G[33085]='E18663'
G[33086]='E18546'
G[33087]='K090 L090 A:71426 T:69782 E17227 Z19033'
G[33088]='K090 L090 A:69782 T:72695 E17227'
G[33089]='K0010 L000 E17227'
G[33090]='K0010 L000 E17227'
G[33091]='K0010 L000 E17227'
G[33092]='K0010 L000 E17227'
G[33093]='K0010 L000 E17227'
G[33094]='K0010 L000 E17227'
G[33095]='K0010 L000 E17227'
G[33096]='K0010 L000 E17227'
G[33097]='K0010 L000 E17227'
G[33098]='K090 L090 A:72695 T:72695 E17227'
G[33100]='K090 L090 A:72695 T:72695 E17227'
G[33104]='K090 L090 A:72695 T:72723 E17227'
G[33105]='K090 L090 A:72723 T:73138 E17227'
G[33107]='K090 L090 A:1221413 T:-867 P:33020 E17227'
G[33108]='E18546'
G[33109]='K090 L090 E17227'
G[33110]='K090 L090 E17227'
G[33111]='FA K0940 L094 A:1232398 TP:77209:=09711;577209:=09712;500138:=09713 E18546'
G[33112]='K0940 L094 A:577184 T:577184 P:33115 E18546'
G[33113]='FA K0940 L094 A:72623 T:72623 O:33359 E18546'	--	TODO: It appears you need the garrison (or something along that line for this to be available) (also 33062)
G[33114]='K0940 L094 A:77417 T:77417 P:33168 E18546'
G[33115]='K0940 L094 A:577184 T:577184 P:33062 E18546'
G[33116]='K0940 L094 A:77417 T:577184 P:33114 E18546'
G[33117]='K090 L090 T:71955 E17227'
G[33118]='K090 L090 T:72807 E17227'
G[33119]='K0910 L090 A:78222 T:72890 P:33657 E18556'
G[33120]='K0940 L094 A:72623 T:72623 P:33113 E18546'
G[33121]='K0000 L090 E17227'
G[33122]='K0000 L090 E17227'
G[33123]='K0000 L090 E17227'
G[33124]='K0000 L000 E17227'
G[33125]='FH K0920 L090 A:72976 T:72976 E18546'
G[33126]='E19027'
G[33129]='E18546'
G[33130]='E18546'
G[33131]='E18546'
G[33132]='FH K0920 L090 A:72976 T:72976 E18546'
G[33133]='FH K0904 L090 A:63996 T:63996 E17227'
G[33134]='FA K0904 L090 A:64029 T:64029 E17227'
G[33135]='E18663'
G[33136]='K090 L090 T:73082 E17227'
G[33137]='K000192 L090 A:73082 T:73082 E17227'	-- No preqs known...just get to the island
G[33138]='K090 L090 A:73318 T:73136 E17227'
G[33139]='K090 L090 E17227'	-- marked complete when 33021 is done
G[33145]='FH K09232768 L090 A:-110941 T:-941 E18546'
G[33146]='K0902 L090 A:64231 T:64231 P:33027 E17227'
G[33147]='K090 L090 A:73335 T:73318 E17227'
G[33148]='E19027'
G[33149]='E18663'
G[33150]='E18546'
G[33151]='E18546'
G[33154]='E18546'
G[33155]='E18546'
G[33156]='FH K090 L090 A:73353 T:72870 O:33232 E17227'
G[33157]='E18546'
G[33158]='E18546'
G[33159]='E18546'
G[33160]='FA K090 L090 A:73348 T:72870 O:33231 E17227'	-- marks 33156 complete as well
G[33161]='K090 L090 A:72870 T:72870 P:33156,33160 E17227'
G[33162]='K0004 L000 T:72908 E17227'	-- Cinder death (though it was first of the week for me), another death as well
G[33163]='SP K0004 L000 T:73703 E17227'	-- seems to be the first weekly chest you loot.  verified for ghost and spectral so far.
G[33164]='K0004 L000 T:71919 E17227'
G[33165]='E18546'
G[33166]='E18546'
G[33167]='E18546'
G[33168]='K0940 L094 A:77417 T:77417 P:33066 E18546'
G[33170]='SP K0000 L000 A:600000 T:600000 E17227'
G[33171]='SP K0000 L000 A:600001 T:600001 E17227'
G[33172]='SP K0000 L000 A:600002 T:600002 E17227'
G[33173]='SP K0000 L000 A:600003 T:600003 E17227'
G[33174]='SP K0000 L000 A:600004 T:600004 E17227'
G[33175]='SP K0000 L000 A:600005 T:600005 ODC:33216 E17227'
G[33176]='SP K0000 L000 A:600006 T:600006 E17227'
G[33177]='SP K0000 L000 A:600007 T:600007 E17227'
G[33178]='SP K0000 L000 A:600008 T:600008 E17227'
G[33179]='SP K0000 L000 A:600009 T:600009 E17227'
G[33180]='SP K0000 L000 A:600010 T:600010 E17227'
G[33181]='SP K0000 L000 A:600011 T:600011 E17227'
G[33182]='SP K0000 L000 A:600012 T:600012 E17227'
G[33183]='SP K0000 L000 A:600013 T:600013 E17227'
G[33184]='SP K0000 L000 A:600014 T:600014 E17227'
G[33185]='SP K0000 L000 A:600015 T:600015 ODC:33217 E17227'
G[33186]='SP K0000 L000 A:600016 T:600016 ODC:33218 E17227'
G[33187]='SP K0000 L000 A:600017 T:600017 E17227'
G[33188]='SP K0000 L000 A:600018 T:600018 E17227'
G[33189]='SP K0000 L000 A:600019 T:600019 E17227'
G[33190]='SP K0000 L000 A:600020 T:600020 E17227'
G[33191]='SP K0000 L000 A:600021 T:600021 E17227'
G[33192]='SP K0000 L000 A:600022 T:600022 E17227'
G[33193]='SP K0000 L000 A:600023 T:600023 E17227'
G[33194]='SP K0000 L000 A:600024 T:600024 ODC:33219 E17227'
G[33195]='SP K0000 L000 A:600025 T:600025 E17227'
G[33196]='SP K0000 L000 A:600026 T:600026 E17227'
G[33197]='SP K0000 L000 A:600027 T:600027 E17227'
G[33198]='SP K0000 L000 A:600028 T:600028 E17227'
G[33199]='SP K0000 L000 A:600029 T:600029 E17227'
G[33200]='SP K0000 L000 A:600030 T:600030 E17227'
G[33201]='SP K0000 L000 A:600031 T:600031 E17227'
G[33202]='SP K0000 L000 A:600032 T:600032 E17227'
G[33203]='SP K0000 L000 A:1221617 T:1221617 E17227'
G[33204]='SP K0000 L000 A:600034 T:600034 E17227'
G[33205]='SP K0000 L000 A:600035 T:600035 E17227'
G[33206]='SP K0000 L000 A:600036 T:600036 ODC:33220 E17227'
G[33207]='SP K0000 L000 A:600037 T:600037 E17227'
G[33208]='SP K0000 L000 A:600038 T:600038 E17227'
G[33209]='SP K0000 L000 A:600039 T:600039 E17227'
G[33210]='SP K0000 L000 A:600040 T:600040 E17227'
G[33211]='K0902 L090 A:73570 T:73570 E17227'	-- No preqs known...just get to the island
G[33216]='K0000 L000 T:72763 E17227'
G[33217]='K0000 L000 T:72841 E17227'
G[33218]='K0000 L000 T:72807 E17227'
G[33219]='K0000 L000 T:72841 E17227'
G[33220]='K0000 L000 T:72777 E17227'
G[33221]='K0000 L000 T:72875 E17227'
G[33222]='K0000 L001 A:73626 T:73626 E17227'
G[33223]='E18546'
G[33224]='E18546'
G[33225]='K090 L090 T:72807 E17227'
G[33226]='K090 L090 T:71955 E17227'	-- killed Niuzao first in the week
G[33227]='SP K0000 L000 A:600041 T:600041 E17227'
G[33228]='K090 L090 A:72870 T:72870 P:33156,33160 E17227'
G[33229]='FA K090 L090 A:59894 AZ:811 T:73691 E17227'
G[33230]='FH K090 L090 AZ:811 T:73691 E17227'
G[33231]='FA K090 L090 A:73691 T:73348 P:33229 E17227'
G[33232]='FH K090 L090 A:73691 T:73353 P:33230 E17227'
G[33233]='K090 L090 E17227'
G[33234]='SP K0901 L090 A:73657 T:73657 P:K100104264 E17227'
G[33235]='SP K0901 L090 A:73657 T:73657 P:K100104265 E17227'
G[33236]='SP K0901 L090 A:73657 T:73657 P:K100104266 E17227'
G[33238]='SP K0901 L090 A:73657 T:73657 P:K100104267 E17227'
G[33239]='SP K0901 L090 A:73657 T:73657 P:K100104257 E17227'
G[33248]='FA K090 L090 A:64101 T:61636 E17227'
G[33249]='FH K090 L090 A:66998 T:61636 E17227'
G[33250]='SP K0901 L090 A:58564 T:58564 E17227'
G[33252]='K0000 L010 E17227'
G[33253]='E18546'
G[33255]='K0920 L090 A:75145 T:72413 P:33837 E18546'
G[33256]='K0920 L090 A:72413 T:73395 P:33255 E18546'
G[33257]='K0000 L000 E1721'
G[33258]='K0000 L000 T:72193 E1721'
G[33259]='K0000 L000 T:72769 E1721'
G[33260]='K0000 L000 T:72908 E1721'	-- first time killed Gu'chi
G[33261]='K0000 L000 T:73158 E1721'
G[33263]='K0910 L090 A:79966 T:73877 P:34820 E18546'
G[33264]='E19027'
G[33265]='E18663'
G[33266]='E18546'
G[33267]='E18546'
G[33268]='E18663'
G[33269]='K0940 L094 A:72637 T:72637 P:33112 E18546'
G[33270]='K0000 L000 T:73160 E1721'
G[33271]='FA K0910 L090 A:73877 T:76748 P:33263 E18546'
G[33272]='K0000 L000 T:73161 E1721'
G[33273]='K0000 L000 T:73277 E1721'
G[33274]='K0000 L000 T:73171 E1721'
G[33275]='K0000 L000 T:73282 E1721'
G[33276]='K0000 L000 T:72775 E1721'
G[33277]='K0000 L000 T:73166 E1721'
G[33278]='K0000 L000 T:73163 E1721'
G[33279]='K0000 L000 T:72808 E1721'
G[33280]='K0000 L000 T:73704 E1721'
G[33281]='K0000 L000 T:73169 E1721'
G[33282]='E19342'
G[33283]='K0000 L000 T:72771 E1721'
G[33284]='K0000 L000 T:73173 E1721'
G[33285]='K0000 L000 E1721'
G[33286]='K0000 L000 T:73175 E1721'
G[33287]='K0000 L000 T:73167 E1721'
G[33288]='K0000 L000 T:73666 E1721'
G[33289]='K0000 L000 T:73279 E1721'	-- first time killed Evermaw
G[33290]='K0000 L000 T:73281 E1721'
G[33291]='K0000 L000 E1721'
G[33292]='K0000 L000 T:0 E1721'
G[33293]='K0000 L000 T:72769 E1721'
G[33294]='K0000 L000 T:72908 E1721'
G[33295]='K0000 L000 T:73158 E1721'
G[33296]='K0000 L000 E1721'
G[33297]='K0000 L000 T:73161 E1721'
G[33298]='K0000 L000 T:73277 E1721'
G[33299]='K0000 L000 T:73171 E1721'
G[33300]='K0000 L000 T:73282 E1721'
G[33301]='K0000 L000 T:72775 E1721'
G[33302]='K0000 L000 T:73166 E1721'
G[33303]='K0000 L000 T:73163 E1721'
G[33304]='K0000 L000 T:72808 E1721'
G[33305]='K0000 L000 T:73703 E1721'
G[33306]='K0000 L000 T:73169 E1721'
G[33307]='K0000 L000 T:73157 E1721'
G[33308]='K0000 L000 T:73173 E1721'
G[33309]='K0000 L000 T:73172 E1721'
G[33310]='K0000 L000 T:73175 E1721'
G[33311]='K0000 L000 T:73167 E1721'
G[33312]='K0000 L000 T:73666 E1721'
G[33313]='K0000 L000 T:73279 E1721'
G[33314]='K0000 L000 T:73281 E1721'
G[33315]='K0000 L000 T:72809 E1721'
G[33316]='K0000 L000 T:72245 E1721'
G[33317]='K0000 L000 T:71919 E1721'
G[33318]='K0000 L000 T:72045 E1721'
G[33319]='K0000 L000 T:72049 E1721'
G[33320]='E18663'
G[33321]='K0000 L000 T:73170 E1721'
G[33322]='K0000 L000 T:73170 E1721'
G[33323]='E18546'
G[33327]='E18663'
G[33330]='E18546'
G[33331]='K0910 L090 A:77270 T:-947 P:33263 E18546'
G[33332]='K090 L090 A:72870 T:72870 P:33228 E1721'
G[33333]='K090 L090 A:72870 T:72870 P:33332 E1721'
G[33334]='K090516 L090 A:72870 T:72870 P:33333 E1721'
G[33335]='K090 L090 A:72870 T:73303 P:33228 E1721'
G[33336]='K090 L090 A:72870 T:72870 P:33161 E1721'
G[33337]='K090 L090 A:72870 T:72870 P:33338 E1721'
G[33338]='K0904 L090 A:72870 T:72870 P:33336 E1721'
G[33340]='K090 L090 A:73303 T:73303 P:33335 E1721'
G[33341]='K090 L090 A:73303 T:73303 P:33340 E1721'
G[33342]='K090 L090 A:73303 T:73303 P:33374 E1721'
G[33343]='K090 L090 A:73303 T:73303 P:33342 E1721'
G[33344]='K0910 L090 A:75186 T:575177 P:33410 E18546'
G[33345]='K0000 L000 E1721'
G[33346]='K0000 L000 E1721'
G[33347]='K0000 L000 E1721'
G[33348]='K0000 L000 T:72762 E1721'	-- trying to find the lost body
G[33349]='K0000 L001 E18546'
G[33350]='E18546'
G[33351]='E18663'
G[33352]='E18546'
G[33354]='K090 L090 A:71992 T:14829 E1721'
G[33358]='K0902 L090 A:64231 T:64231 P:33027 E1721'
G[33359]='K0940 L094 A:80645 T:577184 E18546'
G[33360]='K0000 L000 E1721'
G[33361]='K0000 L000 E1721'
G[33362]='K0000 L000 E1721'
G[33363]='K0000 L000 E1721'
G[33364]='K0000 L000 E1721'
G[33365]='K0000 L000 E1721'
G[33366]='K0000 L000 E1721'
G[33367]='K0000 L000 E1721'
G[33368]='K0000 L000 E1721'
G[33369]='K0000 L000 E1721'
G[33370]='K0000 L000 E1721'
G[33371]='K0000 L000 E1721'
G[33372]='K0000 L000 E1721'
G[33373]='K0000 L000 E1721'
G[33374]='K0902 L090 A:73303 T:73303 P:33341 E1721'
G[33375]='K090 L090 A:72870 T:72870 P:33337+33338 E1721'
G[33376]='K090 L090 A:72870 T:72870 P:33375+33338 E1721'
G[33377]='K090 L090 A:72870 T:72870 P:33376+33338 E1721'
G[33378]='K090 L090 A:72870 T:72870 P:33377+33338 E1721'
G[33379]='K090 L090 A:72870 T:72870 P:33378+33338 E1721'
G[33380]='E18716'
G[33381]='E19533'
G[33382]='E18546'
G[33383]='E18546'
G[33384]='SP K000131072 A:1223533 T:1223533 E18546'
G[33385]='K0000 L000 T:0 E1721'	-- TODO: Determine if this is set when 33338 is turned in.  ensure 33338 is reset each week, otherwise check whether this is to put the proper weekly requirements for the other follow-on quests.  if this needs to be used, must resurrect J codes.
G[33389]='E18546'
G[33395]='E19027'
G[33398]='K0000 L002 E18546'
G[33400]='E18546'
G[33401]='E18546'
G[33402]='E18546'
G[33407]='E18716'
G[33408]='K0910 L090 A:75177 T:75186 P:33546 E18546'
G[33409]='K0050 L004 E18546'
G[33410]='K0910 L090 A:75186 T:75186 P:33408 E18546'
G[33412]='K0910 L090 A:81678 T:74635 P:33657 E18556'
G[33416]='K0000 L001 E18546'
G[33418]='E18546'
G[33419]='FA K0910 L090 A:70902 T:70902 E18546'
G[33422]='K0000 L001 E18546'
G[33424]='K0000 L001 E18546'
G[33425]='K0000 L001 E18546'
G[33427]='K1000 L100 A:76622 T:579740 P:32985 E18912'	-- completes achievement "Ours is the Fury"
G[33429]='K0000 L001 E18546'
G[33431]='K0000 L001 E18546'
G[33432]='K0000 L001 E18546'
G[33434]='E18546'
G[33438]='E18546'
G[33439]='E18546'
G[33440]='E18546'
G[33441]='E18546'
G[33442]='E18546'
G[33443]='E18546'
G[33444]='K1000 L100 A:572230 T:500248 P:32980 E18912'
G[33445]='E18546'
G[33446]='E18546'
G[33447]='E18546'
G[33448]='E18546'
G[33449]='E19634'
G[33450]='K0910 L090 A:74635 T:574635 P:33412 E18546'
G[33454]='K0910 L090 A:74635 T:574635 P:33412 E18546'
G[33455]='E18546'
G[33456]='E18546'
G[33457]='E18546'
G[33458]='E18546'
G[33461]='K0910 L090 AP:1230865:=09711;500135:>09711;79966 TP:580159:=09711;80159:>09711 P:33059 E18546'	-- OTC:33267
G[33462]='K0920 L090 A:1224306 T:1224305 E18566'
G[33463]='E18546'
G[33464]='E18546'
G[33467]='K0910 L090 A:574635 T:81678 P:33450+33454 E18546'
G[33468]='K0910 L090 A:70860 T:74651 P:33527 E18556'
G[33469]='K0910 L090 A:74651 T:74272 P:33468+33807 E18546'	-- TODO: Verify requires 33807
G[33470]='K0910 L090 A:74272 T:74272 P:33469 E18546'
G[33473]='K0910 L090 A:74272 T:70860 P:33470 E18546'
G[33483]='FH K0910 L090 A:72890 T:79047 P:33119 E18556'
G[33484]='K0910 L090 A:79047 T:78222 P:33483 E18556'
G[33485]='K0000 L001 E18546'
G[33492]='K0000 L001 E18546'
G[33493]='K0910 L090 A:72940 T:574163 P:32994 E18546'
G[33496]='E18546'
G[33497]='E18546'
G[33498]='E18546'
G[33499]='E18546'
G[33500]='T:93812 E18546'
G[33501]='T:93812 E18546'
G[33502]='T:93812 E18546'
G[33504]='T:84460 E18546'
G[33505]='T:93812 E18546'
G[33509]='E18612'
G[33510]='E19027'
G[33511]='T:93812 E18546'	-- Devourer's Gutstone	941:60.91,42.62   after feeding orgres to the Devourer
G[33512]='E18546'
G[33513]='K0440 L040 A:74367 T:74888 E18546'	-- TODO: Determine OTC: 27024
G[33514]='K0460 L040 A:74367 T:74888 E18546'	-- TODO: Determine OTC: 27009
G[33516]='E18546'
G[33521]='E18612'
G[33522]='E19027'
G[33525]='E18546'
G[33526]='K0910 L090 A:500152 T:74273 P:33784 E18546'
G[33527]='K0910 L090 A:575177 T:75188 P:33344+33622 E18546'
G[33529]='E19027'
G[33530]='K0960 L095 A:76790 TA:75119 TH:75121 P:34458,35249 E18546'	-- T:75273
G[33531]='T:93812 E18546'
G[33532]='E18546'
G[33533]='FA K0930 L092 A:73395 T:80978 I:35556 E18546'
G[33534]='E18546'
G[33536]='E19027'
G[33540]='SP K000131072 A:1232587 T:1232587 E18546'
G[33543]='FH K0930 L092 A:74594 T:84176 O:35557 E18566'
G[33544]='K0930 L092 A:84176 T:-949 P:33543 E18566'
G[33545]='E19027'
G[33546]='K0910 L090 A:74273 T:75177 P:33526 E18546'	-- removed A:75176
G[33547]='E18612'
G[33548]='K0930 L092 A:76987 T:74606 P:33543 E18566'
G[33549]='E18546'
G[33550]='T:-947 E18546'
G[33557]='E18546'
G[33560]='E19890'
G[33561]='K0000 L001 E18546'
G[33562]='K0910 L090 E18546'
G[33563]='K0930 L092 A:74611 T:574611 P:33543 E18566'
G[33564]='SP K000131072 A:1224750 T:1224750 E18546'
G[33565]='SP K000131072 A:1224753 T:1224753 E18546'
G[33566]='SP K000131072 A:1224754 T:1224754 E18546'
G[33567]='SP K000131072 A:1224755 T:1224755 E18546'
G[33568]='SP K000131072 A:1232579 T:1232579 E18546'
G[33569]='SP K000131072 A:1232583 T:1232583 E18546'
G[33570]='SP K000131072 A:1224770 T:1224770 E18546'
G[33571]='E18546'
G[33572]='SP K000131072 A:1224781 T:1224781 E18546'
G[33573]='SP K000131072 A:1232586 T:1232586 E18546'
G[33574]='SP K000131072 A:1224784 T:1224784 E18546'
G[33575]='SP K000131072 A:1224785 T:1224785 E18546'
G[33577]='E18546'
G[33578]='K0950 L094 A:75311 T:75311 P:34571+34573+34624,34609+34612+34619 E18546'
G[33579]='K0950 L094 A:75311 T:75469 P:33578 E18546'
G[33580]='K0950 L094 A:75288 T:75288 P:33579 E18546'	-- is this supposed to be OAC:33645 such that the following two are P:33645 instead of P:33579?
G[33581]='K0950 L094 A:75323 T:75323 P:33579+O33580 E18546'
G[33582]='K0950 L094 A:75324 T:75324 P:33579+O33580 E18546'
G[33583]='E19890'
G[33584]='SP K000131072 A:1232582 T:1232582 E18546'
G[33586]='K0910 L090 A:79043 T:75884 P:33059 E18546'
G[33588]='E18546'
G[33592]='E19634'
G[33593]='K0930 L092 A:574594 T:574594 P:33548+33544+33563 E18566'
G[33597]='E18546'
G[33602]='E18546'
G[33603]='E18546'
G[33609]='K0000 L001 E18546'
G[33610]='SP K000131072 A:1225501 T:1225501 E18546'
G[33611]='SP K000131072 A:1225502 T:1225502 E18546'
G[33612]='SP K000131072 A:1225503 T:1225503 E18546'
G[33613]='SP K000131072 A:1224228 T:1224228 E18546'
G[33614]='SP K000131072 A:1232588 T:1232588 E18546'
G[33622]='K0910 L090 A:75186 T:575177 P:33410 E18546'
G[33633]='K1000 L100 A:75593 T:75593 E18546'
G[33634]='E18546'
G[33635]='E18546'
G[33637]='E19890'
G[33638]='E18612'
G[33640]='E18546'
G[33641]='E18546'
G[33642]='E18546'
G[33643]='E18546'
G[33644]='E18546'
G[33645]='T:77750 E18546'
G[33649]='E18546'
G[33656]='E18612'
G[33657]='K0910 L090 A:75188 T:70860 P:33527 E18546'
G[33658]='E18612'
G[33659]='E18612'
G[33660]='K0930 L093 A:1234474 T:82225 P:33662,33663 E18546'
G[33661]='K0930 L093 A:82222 T:82225 P:33662,33663 E18546'
G[33662]='K0930 L093 A:85089 T:82222 P:33689+33685+35149 E18546'	--I:36438
G[33663]='K0930 L093 A:85089 T:82222 P:33689+33685+34992 E18546'
G[33664]='E18546'
G[33685]='K0930 L093 A:81731 T:85089 P:33694 E18546'
G[33686]='E18612'
G[33689]='K0930 L093 A:81731 T:85089 P:34992 E18546'
G[33693]='E18546'
G[33694]='K0930 L093 A:82732 T:81731 P:35151 E18546'	-- TODO: Does this require Lumber Mill choice?
G[33695]='K0930 L093 A:82225 T:82302 P:33661 E18546'
G[33706]='K0930 L093 A:82302 T:82302 P:33695 E18546'
G[33707]='E21570'
G[33709]='E19634'
G[33713]='E18546'
G[33720]='FH K0950 L094 A:500164 T:75924 P:33754 E18546'	--I:34091
G[33721]='FH K0950 L094 A:75873 T:75924 E18546'
G[33722]='K0950 L094 A:75806 T:75958 P:33754 E18546'
G[33724]='FH K0950 L094 A:75924 T:75941 P:33720+33721 E18546'	-- TODO: Verify requires 33720, I:34094
G[33725]='E19634'
G[33726]='E18612'
G[33727]='K0950 L094 E18612'
G[33728]='FH K0950 L094 A:75941 T:75941 P:33724+33736+34950 E18546'	-- TODO: Verify requires 33724 34950 ,I:34096
G[33729]='K0950 L094 A:75941 T:75942 P:33728 E18546'
G[33730]='K0950 L094 A:75942 T:75959 P:33729 E18546'
G[33731]='K0950 L094 A:75805 T:79604 P:34962 E18546'
G[33732]='K0950 L094 E18612'
G[33733]='E18612'
G[33734]='K0950 L094 A:75896 T:75913 P:34571+34573+34624,34609+34612+34619,34576+34577+34579 E18546'
G[33735]='FH K0950 L094 A:575808 T:75808 E18546'
G[33736]='K0950 A:75808 T:500165 P:33735+33720+33721 E18546'	-- TODO: Verify requires 33720 33721
G[33737]='E18612'
G[33740]='K0950 L094 A:75896 T:75913 P:34571+34573+34624,34609+34612+34619,34576+34577+34579 O:34685,36843 E18546'
G[33746]='E18546'
G[33748]='E18546'
G[33749]='E18546'
G[33750]='E18546'
G[33753]='E19634'
G[33754]='K0950 L094 A:75806 T:75806 P:34683 E18546'
G[33755]='K0000 L001 E18546'
G[33756]='K0001 L001 A:74056 T:74056 P:37910 E19658'
G[33761]='K0950 L094 A:1225778 T:75913 P:34571+34573+34624,34609+34612+34619 E18546'
G[33765]='K0910 L090 A:75005 T:74043 P:33075 E18546'
G[33766]='E18546'
G[33767]='E19027'
G[33772]='E18546'
G[33781]='E18546'
G[33782]='E18546'
G[33783]='E18612'
G[33784]='K0900 L090 A:76557 T:76240 P:34380 E18546'
G[33785]='K0910 L090 A:73097 T:73097 P:32993 E18546'
G[33786]='FA K0910 L090 A:76200 T:76204 O:35459,35444,35450 E18546'
G[33787]='FA K0910 L090 A:76204 T:76204 O:33786 E18546'
G[33788]='K0910 L090 A:76204 T:76204 P:33787+33808 E18546'
G[33789]='E18663'
G[33793]='K0910 L090 A:81176 T:77282 P:34043 E18546'
G[33794]='K0910 L090 A:81176 T:73395 P:34043 E18546'
G[33795]='K0910 L090 A:81173 T:77282 P:34043 E18546'
G[33800]='E18546'
G[33807]='K0910 L090 A:79415 T:74651 P:33527 E18546'	-- TODO: P:33527 is wrong
G[33808]='FA K0910 L090 A:76204 T:76204 E18546'
G[33813]='K0910 L090 A:71502 T:71502 P:B33070 E18546'
G[33814]='K0920 L090 A:81152,581152 T:78564 P:33059 E18546'	-- technically this can be P:33151 as long as 33059 has OTC:33151
G[33815]='K0910 L090 A:576411 T:78272 P:33868 I:34582 E18546'
G[33816]='K0900 L090 A:80456 T:80456,76616 P:E34379 E18546'
G[33817]='E18546'
G[33820]='E18546'
G[33822]='E18546'
G[33823]='E18546'
G[33824]='E18546'
G[33825]='E18546'
G[33826]='K0910 L090 A:73097 T:73097 P:32993 E18546'
G[33828]='K0910 L090 A:72940 T:72940 P:33826 E18546'
G[33829]='E19533'
G[33833]='FA K091512 L090 A:1237016 T:76447 E18546'	-- A:1226702 removed
G[33834]='FA K091512 L090 A:1237021 T:81292 E18546'	-- A:1226702 removed
G[33836]='FA K091512 L090 A:1232405 T:82227 E18546'
G[33837]='K0920 L090 A:77282 T:573395 P:34054+33083+33793+33795+33794 E18546'	-- TODO: Verify requires 33083 33793
G[33838]='FH K0920 L090 A:74977 T:74977 P:36793 U179 E18612'
G[33839]='E18546'
G[33840]='E18546'
G[33843]='T:93812 E18546'
G[33844]='E18546'
G[33846]='E18546'
G[33847]='E18546'
G[33866]='SP K000131072 A:1232589 T:1232589 E18546'
G[33867]='SP K000131072 A:1226831 T:1226831 E18546'
G[33868]='FH K0900 L090 A:78563 T:576411 P:34446 E18546'
G[33869]='E18546'
G[33871]='FA K0950 L094 A:79724 T:76665 E18546'	-- I:34721 removed in production WoD release
G[33872]='K0950 L094 A:76665 T:76665 O:33871,34721 E18546'
G[33873]='K0950 L094 A:76665 T:76665 E18546'
G[33874]='K0950 L094 A:76665 T:76665 P:33872+33873 E18546'
G[33875]='E18612'
G[33877]='E18612'
G[33878]='E18612'
G[33879]='E19027'
G[33880]='E18612'
G[33881]='E19027'
G[33882]='K0950 L094 A:76826 T:76826 E18546'	-- FA at least
G[33883]='T:74373 E18546'
G[33884]='K0950 L094 A:76826 T:76826 E18546'	-- FA at least
G[33885]='SP K000131072 A:1226865 T:1226865 E18546'
G[33886]='SP K000131072 A:1226861 T:1226861 E18546'
G[33887]='E18546'
G[33888]='E18546'
G[33889]='E18546'
G[33890]='E18546'
G[33891]='SP K000131072 A:1226862 T:1226862 E18546'
G[33898]='K0910 L090 A:76662 T:76662 P:33657 E18556'
G[33899]='E18546'
G[33900]='E18546'
G[33901]='E18546'
G[33903]='E18546'
G[33904]='E18663'
G[33905]='K0910 L090 A:74343 T:74043 P:33075 E18546'
G[33906]='E18546'
G[33907]='E18612'
G[33908]='E19027'
G[33909]='E18546'
G[33910]='E18546'
G[33911]='E19890'
G[33913]='E19027'
G[33914]='E19342'
G[33915]='K0910 L090 A:76862 T:76862 P:1 E18546'	-- I thought it was P:33470, but was wrong
G[33916]='T:93812 E18546'
G[33917]='K0960 L095 A:78482 T:78482 P:34971,34981,34711,34712 I:33923 E18546'
G[33918]='K092512 L090 A:1233291 T:78487 P:L091+1 E18546'
G[33919]='K091514 L090 A:1226961 T:76746 P:33527 E18546'
G[33920]='K0960 L095 A:78519 T:78519 P:34971,34981,34711,34712 E18546'
G[33921]='E18546'
G[33923]='I:33917 E19342'
G[33924]='E18546'
G[33925]='E18546'
G[33926]='T:93812 E18546'
G[33927]='T:75815 E18546'	-- got completed automatically when I saw draeneis blown up (saw a questgiver among them)
G[33928]='K0980 L098 A:100113080 T:80593 P:0 E18612'	--TODO: still in game? does it require conditions?
G[33929]='K0910 L090 A:76889 T:76889 P:33955 E18546'
G[33930]='E18546'
G[33931]='SP K0900 L090 A:76904 T:76904 E18546'	-- also completed when 33927 was, reward is Deceptia's Smoldering Boots
G[33933]='T:-946 E18546'
G[33938]='E18546'
G[33940]='T:93812 E18546'
G[33942]='T:93812 E18546'
G[33943]='E18546'
G[33944]='K0950 L094 A:1226987 T:76826 E18546'	-- TODO: Determine whether you need to be on quests from Caleb to get this : no you dont :) (no known prequests)
G[33945]='E18546'
G[33946]='T:93812 E18546'
G[33947]='T:90286 E18546'
G[33948]='T:93812 E18546'
G[33949]='E18546'
G[33950]='E19890'
G[33951]='E19750'
G[33952]='E18546'
G[33954]='E19027'
G[33955]='K0910 L090 A:76941 T:76889 P:1 E18546'	-- I thought it was P:33470, but was wrong
G[33956]='E19027'
G[33957]='K0920 L090 E18546'
G[33958]='K0960 L095 A:75256 T:75256 P:34452 I:33970 E18546'
G[33959]='E19027'
G[33960]='E18546'
G[33961]='E18546'
G[33962]='E18546'
G[33963]='E18546'
G[33964]='E18612'
G[33965]='E18546'
G[33966]='E18546'
G[33967]='K0960 L095 A:78028 T:78028 P:34452 I:33971 E18546'
G[33968]='E18612'
G[33969]='K0960 L095 A:78102 T:78102 P:34452 I:33972 E18546'
G[33970]='K0960 L095 A:575256 T:575256 P:34451 I:33958 E18546'
G[33971]='K0960 L095 A:578028 T:578028 P:34451 I:33967 E18546'
G[33972]='K0960 L095 A:75249 T:75249 P:34451 I:33969 E18546'
G[33973]='K0950 L094 A:77031 T:77031 E18546'	-- OTC:33974, which does not seem to exist
G[33974]='K0950 L094 T:75753'
G[33975]='E18612'
G[33976]='K0960 L095 A:77082 T:77082 P:34508 E18546'
G[33977]='E18546'
G[33978]='E18546'
G[33979]='E18612'
G[33980]='E18612'
G[33981]='E18546'
G[33982]='E18546'
G[33987]='E18546'
G[33988]='K0960 L095 A:1227069 T:-946 P:34240,34242 E18546'
G[33989]='E18546'
G[33990]='E18546'
G[33991]='E18546'
G[33995]='E18546'
G[33996]='E18546'
G[33997]='E18546'
G[33998]='E18546'
G[34004]='E18546'
G[34006]='E19027'
G[34008]='E19027'
G[34012]='K0930 L092 A:75008 T:75008 P:35064,35149 E18566'
G[34013]='K0960 L095 A:78083 T:78083 P:34240,34242 E18546'
G[34014]='E19750'
G[34015]='E19750'
G[34016]='E19750'
G[34019]='K0910 L090 A:74043 T:574043 P:33070+33765+33905 E18546'
G[34024]='E18663'
G[34025]='E18546'
G[34026]='FA K1000 L100 A:500138 T:77217 P:>09711 E18702 D093'
G[34027]='K1000 L100 A:77217 T:77217 P:34026 E18702'
G[34028]='K1000 L100 A:77217 T:577160 P:34027 E18612'
G[34029]='K1000 L100 A:577160 T:77160 P:34028 E18738'
G[34030]='K1000 L100 A:77160 T:577161 P:34029 E18738'
G[34031]='K1000 L100 A:77167 T:77167 P:34030 E18738'
G[34032]='K1000 L100 A:77167 T:77167 P:34031+34048 E18738'	-- TODO: Verify requires 34031
G[34033]='K1000 L100 A:77167 T:77161 P:34032 E18738'
G[34034]='FH K1000 L100 A:578487 T:77928 P:>09761 E18612 D098'
G[34035]='K1000 L100 A:77928 T:577928 P:34034 E18764'
G[34039]='K1000 L100 A:578323 T:78323 P:34042 E18764'
G[34040]='K1000 L100 A:577928 T:78323 P:34035 E18764'
G[34041]='K1000 L100 A:577928 T:78323 P:34035 E18764'
G[34042]='K1000 L100 A:78323 T:578323 P:34040 E18764'
G[34043]='K0910 L090 A:575884 T:577282 P:33082 E18546'
G[34047]='E18546'
G[34048]='K1000 L100 A:77167 T:77167 P:34030 E18738'
G[34053]='E18546'
G[34054]='K0910 L090 A:-947 T:73395 P:35032 E18546'
G[34055]='E18546'
G[34059]='E18546'
G[34060]='E18546'
G[34061]='E18546'
G[34062]='E18546'
G[34063]='K0920 L090 E19027'
G[34064]='E18546'
G[34066]='FH K0920 L090 A:77210 T:577210 E18566'	-- no known preqs
G[34067]='FH K0920 L090 A:100109121 T:577210 I:34264 E18546'	-- TODO: Deal with the fact that this can be picked up before 77210 moves to become 577210, and one can turn it in to 77210 as well.  he moves when you accept 34066
G[34068]='E18546'
G[34069]='K0920 L090 A:1227504 T:577210 P:O34066 I:34093 E18566'
G[34070]='K0920 L090 A:577210 T:577210 P:34067+34069 E18566'
G[34071]='E19342'
G[34072]='K0920 L090 A:577210 T:577210 P:34067+34069 E18566'
G[34073]='K0920 L090 A:577210 T:500131 P:34072 E18566'
G[34074]='E18546'
G[34075]='K0920 L090 A:500131 T:500131 P:34073+34102 E18546'
G[34076]='FA K09132768 L090 A:-130947 T:-947 E18546'
G[34077]='E18663'
G[34078]='K1000 L100 A:78323 T:500229 P:34039 E18764'	-- turn in completes achievement "Iron Siegeworks"
G[34079]='K0920 L090 E19596'
G[34080]='E18546'
G[34083]='E19027'
G[34084]='E18546'
G[34087]='K0950 L094 A:575803 T:575803 P:36801 E18546'	-- removed P:34874,34875
G[34088]='K0950 L094 A:575803 T:575803 P:34087 E18546'
G[34089]='K0950 L094 A:575804 T:575804 P:34087 E18546'
G[34090]='K0950 L094 A:575874 T:575874 P:34087 E18546'
G[34091]='FA K0950 L094 A:1225726 T:575874 P:34087 E18546'	-- ? I:34803 ;I:33720
G[34092]='K0960 L095 A:77799 T:77799 P:34326 E18546'
G[34093]='K0920 L090 I:34069 E18546'	-- removed A:577210 T:577210 because I cannot seem to get this at all
G[34094]='FA K0950 L094 A:575874 T:575874 P:34090+34091 E18546'	--I:33724
G[34095]='K0950 A:575804 T:575804 P:34089 E18546'
G[34096]='FA K0950 L094 A:575874 T:575874 P:34094+34095+34959 E18546'	--I:33728
G[34097]='K0950 L094 A:575874 T:75942 P:34096 E18546'
G[34098]='K0950 L094 A:75942 T:575803 P:34097 E18546'
G[34099]='K0950 L094 A:75805 T:79608 P:34963 E18546'
G[34100]='E19750'
G[34101]='T:76668 E18546'
G[34102]='K0920 L090 A:1227806 T:500131 P:34070+34072 E18546'
G[34103]='FA K095512 L094 A:80854 T:80854 P:34874,34875,34571+34573+34624 E18546'
G[34104]='FA K095512 L094 A:80854 T:80854 P:34874,34875,34571+34573+34624 E18546'
G[34105]='FA K095512 L094 A:80854 T:80854 P:34874,34875,34571+34573+34624 E18546'
G[34106]='K095512 L094 A:80833 T:80833 P:34576+34577+34579 E18546'	-- see comment in 34683
G[34107]='K095512 L094 A:80833 T:80833 P:34576+34577+34579 E18546'	-- see comment in 34683
G[34108]='K095512 L094 A:80833 T:80833 P:34576+34577+34579 E18546'	-- see comment in 34683
G[34110]='T:76947 E18546'
G[34111]='T:77973 E18546'
G[34112]='T:77441 E18546'
G[34113]='T:76969 E18546'
G[34114]='T:76969 E18546'
G[34115]='E18546'
G[34116]='E18546'
G[34117]='E18546'
G[34118]='E18546'
G[34119]='E18546'
G[34120]='E19890'
G[34121]='E19027'
G[34122]='K0950 L094 A:75389 T:75389 P:34326 I:35227 E18546'
G[34123]='K0920 L090 A:76720 T:76487 P:33010 E18702'
G[34124]='K0920 L090 A:76487 T:76484 P:34123 E18702'
G[34127]='E18546'
G[34128]='E18546'
G[34129]='T:84460 E18546'
G[34130]='T:78151 E18546'
G[34131]='T:93812 E18546'
G[34132]='T:93812 E18546'
G[34133]='E18546'
G[34134]='T:86682 E18546'
G[34135]='E18546'
G[34140]='E18546'
G[34141]='E19027'
G[34142]='T:77561 E18546'
G[34143]='E18546'
G[34144]='K0960 L095 A:75389 T:77580 P:34092 I:35254 E18546'
G[34145]='T:77614 E18546'
G[34146]='E18546'
G[34147]='E18546'
G[34148]='E18546'
G[34149]='E18546'
G[34150]='E18546'
G[34151]='E18546'
G[34152]='E18546'
G[34153]='E18546'
G[34154]='FA K0960 L095 A:77582 T:79434 P:34157 I:34564 E18546'
G[34155]='E18546'
G[34157]='K0960 L095 A:75392 T:77582 P:34092 E18546'
G[34158]='E19027'
G[34159]='E19769'
G[34160]='E18546'
G[34162]='E18546'
G[34163]='K0960 L095 A:1227737 T:-946 P:34092+35227|34122 E18546'	-- TODO: Verify requires 35227|34122
G[34164]='K0960 L095 A:77629 T:77629 P:34092+35227 E18546'	-- TODO: Verify requires 35227
G[34165]='E18546'
G[34167]='E18546'
G[34168]='E18546'
G[34170]='E18546'
G[34171]='T:77634 E18546'
G[34172]='E18546'
G[34173]='E18546'
G[34174]='SP K000131072 A:1227743 T:1227743 E18546'
G[34175]='E18546'
G[34176]='E18546'
G[34177]='E18546'
G[34178]='E18546'
G[34179]='E18546'
G[34180]='E18546'
G[34181]='E19027'
G[34182]='SP K0000 A:1227793 T:1227793 P:34184 E18546'
G[34183]='E18546'
G[34184]='T:-946 E18546'
G[34185]='E18546'
G[34189]='E18546'
G[34191]='E18546'
G[34192]='FA K0000 L092 A:77730 T:77730 P:>09711 I:35154 E18546'
G[34193]='FH K0000 L096 A:81981 T:81981 P:>09711 I:36404 E18546'
G[34194]='FA K0000 L094 A:77733 T:84372 P:PF001 I:34758 E18546'
G[34195]='E18546'
G[34196]='T:77741 E18546'
G[34197]='E18546'
G[34198]='E18546'
G[34199]='T:77750 E18546'
G[34200]='E18546'
G[34201]='E18546'
G[34204]='T:77776 E18546'
G[34205]='T:77776 E18546'
G[34206]='E18546'
G[34207]='E18546'
G[34208]='SP K00065536 A:77784 T:77784 E18546'
G[34209]='FH K0940 L094 A:79252 T:72814 E18546'
G[34210]='E18546'
G[34211]='E18546'
G[34212]='E18546'
G[34213]='K1000 L100 E18612'
G[34214]='E18546'
G[34215]='E18546'
G[34216]='K0940 L094 A:72814 T:72837 P:34209 E18546'
G[34217]='K1000 L100 E18612'
G[34218]='E18546'
G[34219]='E18546'
G[34220]='E18546'
G[34221]='E18546'
G[34222]='E18546'
G[34223]='E18546'
G[34224]='E18546'
G[34225]='E18546'
G[34227]='K0940 L094 A:72837 T:72874 P:34216 E18546'
G[34228]='K0940 L094 A:72836 T:72837 P:34216 E18546'
G[34229]='K0940 L094 A:72837 T:72837 P:34228 E18546'
G[34230]='K0940 L094 A:72874 T:72874 P:34227+34228 E18546'	-- TODO: Verify requires 34228
G[34231]='E18546'
G[34232]='SP K000131072 A:1227951 T:1227951 E18546'
G[34233]='SP K000131072 A:1227953 T:1227953 E18546'
G[34234]='K0960 L095 A:78082 T:78082 P:34240,34242 E18546'
G[34235]='SP K000131072 A:1227954 T:1227954 E18546'
G[34236]='SP K000131072 A:1227955 T:1227955 E18546'
G[34237]='E19750'
G[34238]='SP K000131072 A:1227956 T:1227956 E18546'
G[34239]='SP K000131072 A:1227996 T:1227996 E18546'
G[34240]='K0960 L095 A:75250 T:77869 P:33958+33967+33969 I:34242 E18546'	-- TODO: Verify requires 33958 33967
G[34241]='T:77870 E18546'
G[34242]='K0960 L095 A:75246 T:77869 P:33970+33971+33972 I:34240 E18546'	-- TODO: Verify requires 33970 33971
G[34243]='E18546'
G[34244]='K1000 L100 E18612'
G[34248]='SP K000131072 A:1228012 T:1228012 E18546'
G[34249]='SP K000131072 A:1228013 T:1228013 E18546'
G[34250]='SP K000131072 A:1228014 T:1228014 E18546'
G[34251]='SP K000131072 A:1228015 T:1228015 E18546'
G[34252]='SP K000131072 A:1228016 T:1228016 E18546'
G[34253]='SP K000131072 A:1228017 T:1228017 E18546'
G[34254]='SP K000131072 A:1228018 T:1228018 E18546'
G[34255]='SP K000131072 A:1228019 T:1228019 E18546'
G[34256]='SP K000131072 A:1228020 T:1228020 E18546'
G[34257]='SP K000131072 A:1228021 T:1228021 E18546'
G[34258]='SP K000131072 A:1228022 T:1228022 E18546'
G[34259]='SP K000131072 A:1228023 T:1228023 E18546'
G[34260]='SP K000131072 A:1228024 T:1228024 E18546'	-- ? FA for sure...what is 34262?
G[34261]='SP K000131072 A:1228025 T:1228025 E18546'
G[34262]='E18546'
G[34263]='SP K000131072 A:1228026 T:1228026 E18546'
G[34264]='K0920 L090 A:77210 T:577210 P:34096+34066 I:34067 E18566'
G[34267]='E18612'
G[34268]='E18546'
G[34269]='E18546'
G[34271]='FH K0990 L098 A:81953 T:80595 P:0 I:35395 E18612'
G[34276]='SP K000131072 A:1228483 T:1228483 E18546'	-- Also 34760 was turned in when 34276 was turned in
G[34277]='FH K0940 L094 A:72836 T:72836 P:34227+34228 E18546'	-- TODO: Verify requires 34228
G[34278]='FH K0940 L094 A:72837 T:72837 P:34227+34228 E18546'	-- TODO: Verify requires 34228
G[34279]='K0930 L090 T:78030 E18546'
G[34280]='K0940 L094 A:72874 T:72874 P:34230+34277+34278+34229 E18546'	-- TODO: Verify requires 34277 34278 34229
G[34281]='K1000 L100 A:78056 T:78056 P:34284 E18912'
G[34282]='E18612'
G[34283]='E18612'
G[34284]='FA K1000 L100 A:81492 T:78056 P:>09711 E18850 D093'
G[34285]='K1000 L100 A:78056 T:78056 P:34281 E18912'
G[34286]='K1000 L100 A:78185 T:78239 P:34285 E18912'
G[34287]='K1000 L100 A:78428 T:78428 P:34362 E18912'
G[34288]='K1000 L100 A:78428 T:78428 P:34362 E18912'
G[34289]='K1000 L100 A:78428 T:78810 P:34287+34288 E18912'	-- TODO: Verify requires 34287
G[34290]='T:78061 E18546'	-- the stash is located in cave at 946:53.98,27.70
G[34291]='K0940 L094 A:72874 T:73480 P:34280 E18546'
G[34292]='K0940 L094 A:72836 T:72836 P:34280 E18546'
G[34293]='E18645'
G[34294]='K0940 L094 A:73480 T:573480 P:34291 E18546'
G[34295]='K0940 L094 A:573480 T:72874 P:34294 E18546'
G[34299]='E18612'
G[34304]='E18612'
G[34307]='E18612'
G[34308]='E18612'
G[34309]='FH K1000 L100 A:578487,78985 T:78659 P:>09761 E18912 D098'
G[34311]='E18546'
G[34312]='T:101700 E18546'
G[34313]='T:101700 E18546'
G[34314]='K1000 L100 A:78659 T:78659 P:34309 E18912'
G[34315]='K1000 L100 A:78659 T:78659 P:34314 E18912'
G[34316]='K1000 L100 A:78659 T:78785 P:34315 E18912'
G[34317]='E18612'
G[34318]='K1000 L100 A:78428 T:78428 P:34381 E18912'
G[34319]='K1000 L100 A:78428 T:78821 P:34318+34469 E18912'	-- completes achievement "Bloodmaul Compound"
G[34321]='K1000 L100 A:77998 T:77998 E18612'	-- available to FA when on the Garrison campaign
G[34325]='K1000 L100 A:77998 T:77998 P:34321 E18612'
G[34326]='K0960 L095 A:77082 T:77799 P:33976 E18546'
G[34327]='K00032768 E18546'
G[34328]='E18546'
G[34329]='E18546'
G[34330]='E18546'
G[34331]='E18546'
G[34332]='E18546'
G[34333]='E18546'
G[34335]='FH K1000 L100 A:78192 T:78187 P:35842 E18764 D098'
G[34336]='K1000 L100 A:78187 T:78187 P:34409,34335 E18738'
G[34337]='K1000 L100 A:78187 T:78251 P:34347+34336 E18738'
G[34338]='K1000 L100 A:78251 T:78251 P:34337 E18738'
G[34339]='K1000 L100 A:89179 T:89179 P:34337 E18738'
G[34340]='K1000 L100 A:74125 T:74125 P:34337 E18738'
G[34341]='FH K1000 L100 A:78251 T:579740 P:34338+34339+34340 E18764'	-- completes Heart of the Breakers, the Warlord's Council
G[34343]='K00032768 E18546'
G[34344]='FH K0920 L090 A:78208 T:78208 O:34736 E18566'	-- no known preqs
G[34345]='FH K0920 L090 A:78208 T:78208 E18566'	-- no known preqs
G[34346]='FH K0920 L090 A:78209 T:78209 E18566'	-- no known preqs
G[34347]='K1000 L100 A:1237821 T:78187 P:34409,34335 E18738'
G[34348]='K0920 L090 A:78208 T:78208 P:34344+34345+34346 E18566'	-- TODO: Verify requires 34345
G[34351]='K0960 L095 A:577737 T:78520 P:34458,35249 E18546'
G[34352]='K1000 L100 A:83494 T:-947 P:35861,35876 E18612'
G[34353]='K1000 L100 A:77982 T:77982 P:35861,35876 E18612'
G[34354]='K1000 L100 A:77982 T:77982 P:35876 I:35861,35876 E18612'	-- Nimhfree did not get this one
G[34355]='K1000 L100 A:77982 T:78258 P:34353 E18612'
G[34359]='E18546'
G[34360]='E18612'
G[34361]='E18546'
G[34362]='K1000 L100 A:78239 T:78470 P:34286 E18912'
G[34364]='FH K0900 L090 A:70859 T:578466 P:34402 I:34583 E18546'
G[34365]='K1000 L100 A:78258 T:78258 P:34355 E18612'
G[34375]='K0900 L090 A:578466 T:578466 P:34364 E18546'
G[34376]='E18988'
G[34377]='E18988'
G[34378]='K0910 L090 A:578466 T:78466 P:34765 E18546'
G[34379]='K0900 L090 A:76411 T:570860 P:34775 E18546'
G[34380]='K0900 L090 A:570860 T:76557 P:34379 E18546'
G[34381]='K1000 L100 A:78785 T:78792 P:34316 E18912'
G[34382]='E18546'
G[34392]='K0900 L090 A:-970 T:78558 P:35933 E18546'
G[34393]='K0900 L090 A:78558 T:78558 P:34392 E18546'
G[34397]='K1000 L100 A:78258 T:78258 P:34355 E18612'
G[34398]='K0890 L090 A:1206111 T:78558 I:36881 E18546'	-- TODO: If you abandon this, you get offered 36881
G[34399]='K0960 L095 A:78534 T:78538 P:34776,34777 E18546'	-- TODO: P:34776,34777 is wrong, you can go around once you hit Auch.
G[34400]='K0960 L095 A:78534 T:78534 P:34776,34777 E18546'	-- TODO: P:34776,34777 is wrong, you can go around once you hit Auch.
G[34401]='FH K0960 L095 A:78515 T:78515 P:34399 E18546'
G[34402]='K0900 L090 A:78272 T:70859 P:33815 E18546'
G[34403]='FA K0960 L095 A:78513 T:78513 P:34399 E18546'
G[34404]='FH K0960 L095 A:78515 T:78515 P:34399 E18546'
G[34405]='E18612'
G[34406]='FA K0960 L095 A:78513 T:78513 P:34399 E18546'
G[34407]='K0960 L095 A:75119 T:75119 P:34981 I:34418 E18546'
G[34409]='FA K1000 L100 A:88112 T:78187 P:35841 E18738'
G[34410]='FA K1000 L100 A:78251 T:88112 P:34338+34339+34340 E18738'	-- TODO: Verify requires 34338 34340
G[34411]='E18546'
G[34412]='E18546'
G[34413]='E18546'
G[34414]='K0960 L095 A:78515 T:78515 P:34401+34404 E18546'
G[34415]='K0960 L095 A:78513 T:78513 P:34403+34406 E18546'	-- TODO: Verify requires 34403
G[34418]='K0960 L095 A:75121 T:75121 P:34971,34981,34711,34712 O:34696 I:34407 E18546'
G[34420]='K0900 L090 A:78558 T:78559 P:34393 E18546'
G[34421]='FH K0900 L090 A:78573 T:578559 P:34420 I:35240 E18546'
G[34422]='K0900 L090 A:78559 T:578559 P:34420 E18546'
G[34423]='K0900 L090 A:578559 T:78560 P:34422+35240+35242,34421+34422+35241 E18546'	-- OCC:34817
G[34424]='E19533'
G[34425]='K0900 L090 A:78560 T:578560 P:34423 E18546'
G[34426]='E19342'
G[34427]='FH K0900 L090 A:578560 T:578996 P:34425 E18546'
G[34428]='E19342'
G[34429]='K0900 L090 A:578560 T:78561 P:34478,34427 E18546'
G[34431]='FA K0900 L090 A:79661 T:579537 P:34429 I:34737 E18546'
G[34432]='FA K0900 L090 A:578554 T:79316 P:34429 I:34739 E18546'
G[34433]='E19342'
G[34434]='FA K09032 L090 A:78994 T:578994 P:34431 I:34740 E18546'	-- /grail cb reveals as well: OCC:34435	-- becomes available once entering the area and completing "Ankova the Fallen slain" part of 34431
G[34435]='E19342'
G[34436]='K0900 L090 A:579537 T:78562 P:34431+34432+34434 I:34741 E18546'
G[34437]='K0900 L090 A:79917 T:78996 P:34925 E18546'
G[34438]='E19342'
G[34439]='K090 L090 A:78430 T:78996 P:35019,35005 E18546'
G[34440]='E18546'
G[34441]='E19342'
G[34442]='K0900 L090 A:78996 T:79917 P:34439 E18546'
G[34445]='K0900 L090 A:80521 T:80521 P:35747 E18546'
G[34446]='FH K0900 L090 A:80521 T:78563 P:34445 E18546'
G[34447]='K0960 L095 A:78515 T:78538 P:34414 E18546'
G[34448]='K0960 L095 A:78513 T:78538 P:34415 E18546'
G[34449]='E18663'
G[34450]='K1000 L100 A:78258 T:78937 P:34397+34365 E18612'	-- technically it is A:78882 but they are both the same.	-- completing this finishes achievement "Darktide Roost"
G[34451]='FH K0960 L095 A:75121 T:75246 P:33917+33920+34418 I:34452 E18546'	-- TODO: Verify requires 33920 34418
G[34452]='FA K0960 L095 A:75119 T:75250 P:33530+34351 I:34451 E18546'	-- TODO: Verify requires 33530
G[34453]='E18546'
G[34454]='E18612'
G[34455]='K1000 L100 A:1229314 T:-947 P:34355 E18612'
G[34456]='E18546'
G[34457]='K00032768 E18612'
G[34458]='K0960 L095 A:81789 T:577737 P:34701 I:35249 E18546'
G[34459]='E19027'
G[34461]='FH K0900 L090 A:78466 T:500151 P:34822+34823+34824 I:34587 E18546'	-- TODO: Verify requires 34822
G[34462]='FH K0910 L090 A:79740 T:79740 P:34461+36793 I:34646 U34 E18546'
G[34463]='K1000 L100 A:1229330 T:86949 E18546'
G[34464]='K1000 L100 A:1229333 T:86949 E18546'
G[34465]='K1000 L100 A:1229331 T:86949 E18546'
G[34466]='K1000 L100 A:1229344 T:86949 E18546'
G[34469]='K1000 L100 A:78428 T:78428 P:34381 E18912'
G[34470]='T:93812 E18546'	-- killing Pale Fish Monger 78606 in cave 941:28.29,66.62
G[34471]='SP K000131072 A:1229354 T:1229354 E18546'
G[34472]='K1000 L100 A:86949 T:77853 P:34463+34464+34465+34466 E18546'
G[34473]='T:93812 E18546'
G[34474]='E18612'
G[34475]='E18663'
G[34476]='T:93812 E18546'	-- kill all the Frozen Fury near the Frozen Treasure and reveal the Frozen Orc 941:57.16,52.14
G[34477]='T:87538 E18546'
G[34478]='FA K0900 L090 A:578560 T:79537 P:34425 E18546'
G[34483]='E18546'
G[34496]='FA K09132768 L090 A:-120947 T:-947 E18546'
G[34497]='E18546'
G[34498]='T:78872 E18546'
G[34499]='K00032768 E18546'
G[34500]='K00032768 E18546'
G[34501]='FH K09232768 L090 A:-120941 T:-941 E18546'
G[34502]='K00032768 E18546'
G[34503]='T:77434 E18546'
G[34504]='FA K09132768 L090 A:-100947 T:-947 E18546'	-- TODO:	Determine how to detect this being removed from log when leaving area before doing anything for it
G[34505]='FH K09132768 L090 A:-100941 T:-941 E18546'
G[34506]='K00032768 E18546'
G[34507]='T:93812 E18546'
G[34508]='K0960 L095 A:77869 T:77082 P:34240,34242 E18546'
G[34509]='E19342'
G[34510]='E18546'
G[34511]='E18546'
G[34512]='K0980 L098 A:79310 T:79310 P:0 E18612'
G[34513]='K0980 L098 A:79188 T:79310 P:0 E18612'
G[34514]='K0980 L098 A:79312 T:79310 P:34598 E18612'
G[34515]='K0980 L098 A:79312 T:79310 P:34598 E18612'
G[34516]='K0980 L098 A:79899 T:79897 P:0 E18612'
G[34517]='T:101700 E18546'
G[34518]='E18546'
G[34519]='T:101700 E18546'
G[34520]='T:93812 E18546'
G[34521]='T:93812 E18546'
G[34522]='T:101700 E18546'
G[34523]='T:79125 E18546'
G[34524]='K1000 L100 E18612'
G[34525]='K1000 L100 E18612'
G[34526]='K1000 L100 E18612'
G[34527]='K1000 L100 E18612'
G[34528]='K1000 L100 E18612'
G[34529]='K1000 L100 E18612'
G[34530]='E18612'
G[34531]='K1000 L100 E18612'
G[34532]='E18612'
G[34533]='K1000 L100 E18612'
G[34534]='K1000 L100 E18612'
G[34535]='E18612'
G[34536]='K1000 L100 E18612'
G[34537]='K1000 L100 E18612'
G[34538]='E18612'
G[34539]='K1000 L100 E18612'
G[34540]='K1000 L100 E18612'
G[34541]='E18612'
G[34542]='K1000 L100 E18612'
G[34543]='K1000 L100 E18612'
G[34544]='E18612'
G[34545]='K1000 L100 E18612'
G[34546]='K1000 L100 E18612'
G[34547]='E18612'
G[34548]='K1000 L100 E18612'
G[34549]='K1000 L100 E18612'
G[34550]='E18612'
G[34551]='E18612'
G[34552]='E18612'
G[34553]='E18612'
G[34554]='K1000 L100 E18612'
G[34555]='K1000 L100 E18612'
G[34556]='E18612'
G[34557]='E18546'	-- Frostfire Ridge treasure map
G[34558]='FA K0940 L094 A:79133 T:79133 O:34676 E18546'	-- Changed P: to O: (and made it FA) because toon has this available without even having a garrison in Shadowmoon Valley
G[34559]='E18546'
G[34560]='T:1230665 I:34561 E18546'
G[34561]='T:1230665 I:34560 E18546'
G[34562]='E18546'
G[34563]='K0940 L094 A:79133 T:79159 P:34558+34560+X34561 E18546'	-- TODO: Verify requires 34560 X34561
G[34564]='FH K0960 L095 A:77582 T:79434 P:34157+36793 I:34154 U205 E18546'
G[34565]='I:34884 E19027'
G[34566]='FH K0940 L094 A:79176 T:79176 O:36953 E18546'	-- changed P:36953 to O: because Horde boosted to 100 has this available immediately.
G[34567]='E18546'	-- automatically completed when Horde chose Made Tower in Talador
G[34568]='E18546'	-- automatically completed when Horde chose Arsenal in Talador
G[34569]='FH K0940 L094 A:79176 T:79210 P:34566+34568+X34567 E18546'
G[34570]='T:79544 E19342'
G[34571]='FA K0940 L094 A:79329 T:79329 P:35045 E18546'	--I:34577
G[34572]='FA K0990 L098 A:79282 T:81144 P:35148 E18612'	-- removed  I:35155
G[34573]='FA K0940 L094 A:79329 T:79329 P:35045 E18546'	--I:34576
G[34574]='T:79190 E18546'
G[34575]='K0900 L090 A:-970 T:79206 P:35884 E18546'	-- if you abandon this, not sure you can get it back
G[34576]='FH K0940 L094 A:79356 T:79356 P:35102 E18546'	--I:34573
G[34577]='FH K0940 L094 A:79356 T:79356 P:35102 E18546'	--I:34571
G[34578]='FA K0940 L094 A:79329 T:80627 P:34571+34573+34624 E18546'	-- TODO: Verify requires 34571 34573 ,I:34837
G[34579]='FH K0940 L094 A:79356 T:79356 P:35102 E18546'
G[34580]='E18546'
G[34581]='E18546'
G[34582]='K0900 L090 A:79206 T:79470 O:34575 I:33815 E18546'	-- probably this not available until 34575 turned in or abandoned.  Note that A:79635 is also possible.  Must recheck this without dropping, and with dropping.
G[34583]='K0900 L090 A:79470 T:79243 P:34582 I:34364 E18546'
G[34584]='K0900 L090 A:79243 T:79243 P:34583 E18546'
G[34585]='K0900 L090 A:79567 T:79567 P:34584+34616 I:34765 E18546'
G[34586]='K0900 L090 A:79243 T:77209 P:34585 E18546'
G[34587]='K0900 L090 A:77209 T:79457 P:35166+35174+35176 I:34461 E18546'	-- TODO: Verify requires 35166
G[34588]='E19533'
G[34589]='E18546'
G[34591]='E18546'
G[34592]='FH K0900 L090 A:578466 T:578466 P:34364 I:34616 E18546'
G[34593]='FA K0990 L098 A:79282 T:81144 P:35148 E18612'	-- removed I:35157
G[34596]='FA K1000 L098 A:81144 T:79576 P:34593 E18612'	-- removed  I:35158
G[34597]='FA K0990 L098 A:1231901 T:81144 P:35148 I:35156 E18612'
G[34598]='K0980 L098 A:79310 T:79312 P:0 E18612'
G[34599]='E18546'
G[34600]='E18546'
G[34601]='E19890'
G[34602]='E18546'
G[34609]='K0940 L094 A:79392 T:80260 P:34815 I:34634 E18546'
G[34610]='E21463'
G[34612]='K0940 L094 A:79392 T:80260 P:34815 I:34635 E18546'
G[34616]='K0900 L090 A:79243 T:79243 P:34583 I:34592 E18546'
G[34617]='E18546'
G[34619]='K0940 L094 A:79392 T:80260 P:34815 I:34636 E18546'
G[34622]='E18546'
G[34623]='E19027'
G[34624]='K0940 L094 A:79329 T:79329 P:35045 I:34577 E18546'
G[34631]='K0940 L094 A:79133 T:80142 P:34558+34561+X34560 I:34632 E18546'
G[34632]='K0940 L094 A:79176 T:80142 P:34566+34567+X34568 I:34631 E18546'
G[34633]='E18612'
G[34634]='FH K0940 L094 A:79393 T:80193 P:34814 I:34609 E18546'
G[34635]='FH K0940 L094 A:79393 T:80193 P:34814 I:34612 E18546'
G[34636]='FH K0940 L094 A:79393 T:80193 P:34814 I:34619 E18546'
G[34637]='E18546'
G[34639]='K09532768 L094 A:75311 T:79432 E18546'
G[34640]='E18612'
G[34641]='T:93812 E18546'
G[34642]='T:93812 E18546'
G[34645]='E18546'
G[34646]='FA K0900 L090 A:79457 T:81948 P:34587+36797 I:34462 U34 E18546'
G[34647]='T:93812 E18546'
G[34648]='T:93812 E18546'
G[34649]='E18546'
G[34650]='E19634'
G[34651]='E18546'
G[34652]='E18546'
G[34653]='K0960 L096 A:81492 T:79539 P:35554 I:36951 E18546'
G[34654]='E18546'
G[34655]='K0960 A:79539 T:79519 O:34653 E18612'
G[34656]='K0960 L096 A:79519 T:79519 P:34655 E18612'
G[34657]='K0960 L096 A:79519 T:79519 P:34655 E18612'
G[34658]='K0960 L096 A:79519 T:579519 P:34657+34656 E18612'
G[34659]='K0960 L096 A:579519 T:79890 P:34658 E18612'
G[34660]='K09532768 L094 A:87125 T:79544 E18546'
G[34661]='E19342'
G[34662]='K0980 L098 A:79188 T:79188 P:0 E18612'
G[34663]='K0980 L098 A:79188 T:79188 P:34662 E18612'
G[34664]='K0980 L098 A:79188 T:79188 P:34663 E18612'
G[34665]='K0980 L098 A:79188 T:79188 P:34664 E18612'
G[34666]='K0980 L098 A:79188 T:79188 P:34665 E18612'
G[34667]='K09532768 L094 A:-130946 T:-946 E18546'
G[34668]='E18546'
G[34670]='E18988'
G[34671]='E18546'
G[34672]='FA K0250 L020 A:75606 T:75606,575606 E18546'
G[34673]='FH K0250 L020 A:74009 T:74009,574009 E18546'
G[34674]='FA K0980 L098 A:1232400 T:79263 E18612'	-- TODO: Verify only FA
G[34675]='FA K0980 L098 A:79263 T:79576 P:34674 E18612'	--I:34795
G[34676]='FA K0940 L094 A:81492 T:79133 O:36495 I:37183 E18546'
G[34677]='K0950 L094 E18612'
G[34678]='K0980 L098 A:79576 T:79674 P:34675 E18612'
G[34679]='T:79674 E18546'
G[34680]='T:1230741 E18546'
G[34681]='K0940 L094 A:78487 T:79176 P:36573,36574 O:36494 E18546'
G[34682]='K0980 L098 A:79674 T:79722 P:34678 E18612'
G[34683]='FH K0940 L094 A:79627 T:75806 P:34576+34577+34579 I:36801 E18546'	-- removed P:34874 because boosted to 100 Horde gets this after completing these three (picked Armory)
G[34684]='E18612'
G[34685]='K0940 L094 AA:79573 AH:579573 T:75896 P:FA+34711,FH+34712,FH+34971,FA+34981 E18546'	-- seems 36843 also completed when this did
G[34686]='E19890'
G[34688]='E19027'
G[34690]='E18663'
G[34691]='K0950 L094 E19634'
G[34692]='K0900 L090 A:79953 T:79953 P:34646 I:34775 E18546'
G[34693]='E18612'
G[34694]='E18612'
G[34696]='FH K0950 L095 A:79612 T:75121 P:34712,34971 I:34701 E18546'
G[34697]='K0930 L092 A:76688 T:79320 P:35151+35149 I:34992 E18566'
G[34698]='K0930 L092 A:79320 T:79320 P:34704,34697 E18566'
G[34699]='K0930 L092 A:79322 T:77014 P:34704,34697 E18566'
G[34700]='K0930 L092 A:79320 T:79320 P:34704,34697 E18566'
G[34701]='K0950 L095 A:79618 T:75119 P:34711,34981 I:34696 E18546'
G[34702]='K0930 L092 A:79331 T:79331 P:34704,34697 E18566'
G[34703]='K0930 L092 A:77014 T:79322 P:34699 E18566'
G[34704]='K0930 L092 A:81076 T:79322 P:35063+35064 E18546'
G[34705]='E18546'
G[34706]='K0960 L094 A:77580 T:79612 P:34564 I:34707 E18663'
G[34707]='K0960 L094 A:77581 T:79618 P:34154 I:34706 E18612'
G[34708]='E18546'
G[34709]='K0960 L095 A:79689 T:78534 P:1 E18546'
G[34710]='FH K0960 L095 A:79696 T:78534 E18546'
G[34711]='FA K0940 L094 A:80617 T:80672 P:34912 E18546'
G[34712]='FH K0940 L094 A:80389 T:80553 P:34890 E18546'
G[34713]='E18546'
G[34714]='E18546'
G[34715]='E18546'
G[34716]='K0980 L098 A:79722 T:79743 P:34682 E18612'
G[34717]='K0980 L098 A:79722 T:79576 P:34682 E18612'	-- OTC: 34720
G[34718]='K0980 L098 A:79743 T:79743 P:34716 E18612'
G[34719]='K0980 L098 A:79743 T:79743 P:34716 E18612'
G[34720]='E18702'
G[34721]='FH K0950 L094 A:79724 T:76665 E18546'	-- removed I:33871 for production WoD
G[34722]='E18702'
G[34723]='K09932768 L098 A:-100950 T:-950 E18612'
G[34724]='K09332768 L092 A:-150949 T:-949 E18566'
G[34725]='T:80122 E18546'
G[34726]='T:76473 E18546'
G[34727]='T:79725 E18546'
G[34728]='FA K09132768 L090 A:-110947 T:-947 E18546'
G[34729]='K0920 L090 T:76452 E18612'
G[34730]='E18702'
G[34731]='SP FH K0920 L090 A:78208 T:78208 P:34348+36793 U180 E18546'
G[34732]='SP FH K0920 L090 A:79047 T:79047 P:33483+36793 U182 E18546'
G[34733]='K0920 L090 T:79492 U32 E18645'
G[34734]='E19027'
G[34735]='E19634'
G[34736]='K0920 L090 A:78487 T:78208 P:33527 E18556'
G[34737]='FH K0900 L090 A:79661 T:79675 P:34429 I:34431 E18546'
G[34738]='E19533'
G[34739]='FH K0900 L090 A:500150 T:79315 P:34429 I:34432 E18546'
G[34740]='FH K09032 L090 A:78994 T:578994 I:34434 E18546'	-- see note about preqs in 34434
G[34741]='K0900 L090 A:79675 T:78562 P:34737+34739+34740 I:34436 E18546'
G[34742]='E18612'
G[34743]='T:-947 E18546'
G[34746]='FA K0980 L098 A:79743 T:79674 P:34718+34719 E18612'
G[34747]='SP FA K0980 L098 A:581790 T:581790 P:34957+36797 I:34770 U157 E18612'
G[34751]='FH K0950 L094 A:79870 T:79870 I:34761 E18546'
G[34755]='E18546'
G[34756]='K0960 L096 A:79890 T:81770 P:34659 E18612'
G[34757]='E18663'
G[34758]='FH K0000 L094 A:79892 T:79896 P:PF001 I:34194 E18546'	-- availalbe for Horde boost to 100
G[34760]='T:-946 E18546'
G[34761]='FA K0950 L094 A:79901 T:79901 I:34751 E18546'
G[34765]='FH K0900 L090 A:578466 T:578466 P:34375+34592 I:34585 E18546'
G[34766]='FH K0940 L094 A:79921 T:79921 P:34576+34577+34579 I:34773 E18546'	-- TODO: See comment in 34683
G[34769]='FA K0980 L098 A:79674 T:79576 P:34746 E18612'	--I:34899
G[34770]='SP FH K0980 L098 A:81790 T:81790 P:34868+36793 I:34747 U157 E18612'
G[34771]='E18546'
G[34772]='E18546'
G[34773]='FA K0940 L094 A:79963 T:79963 P:34874,34875,34571+34573+34624 I:34766 E18546'
G[34774]='SP K0002 L001 A:77789 T:77789 I:31752 E18546'
G[34775]='FH K0910 L090 A:79740 T:79740 P:34462 I:34692 E18546'
G[34776]='FH K0950 L094 A:79978 T:79978 I:34777 E18546'
G[34777]='FA K0950 L094 A:79979 T:79979 I:34776 E18546'
G[34778]='K0910 L090 A:79457 T:81912 P:34692 E18546'
G[34779]='K09132 L090 A:81912 T:80078 P:34778 E18546'
G[34780]='K0910 L090 A:80075 T:1230933 P:34779 E18546'
G[34781]='K0910 L090 A:1230933 T:1230933 P:34780 E18546'
G[34782]='K0910 L090 A:82348 T:80076 P:34781 E18546'
G[34783]='K0910 L090 A:80076 T:80079 P:34782 E18546'
G[34784]='K0910 L090 A:80079 T:80079 P:34783 E18546'
G[34785]='K0910 L090 A:80076 T:80075 P:34782 E18546'
G[34786]='K0910 L090 A:81140 T:81140 P:34785 E18546'
G[34787]='K0910 L090 A:80078,580078 T:80073 P:34784 E18546'
G[34788]='K0910 L090 A:580079 T:580079 P:34792 E18546'
G[34789]='K0910 L090 A:580073 T:88972 P:34791 E18546'
G[34790]='K0910 L090 A:82537 T:82537 P:34782 E18546'
G[34791]='K0910 L090 A:1233229 T:580073 P:35552 E18546'
G[34792]='K0910 L090 A:88972 T:500134 P:34789 E18546'
G[34793]='T:78390 E18546'
G[34794]='FH K0980 L098 A:78487 T:80001 P:1 I:36952 E18612'	-- this also reports 13807 complete
G[34795]='FH K0980 L098 A:80001 T:80003 O:34794 E18612'	--I:34675	-- changed P:34794 to O: because Horde boosted to 100 can get this immediately.
G[34801]='FH K0950 L094 A:80028 T:80028 I:34802 E18546'
G[34802]='FA K0950 L094 A:80028 T:80028 I:34801 E18612'
G[34803]='K0940 L094 A:79921 T:79921 P:34766 E18546'	-- I:34804 removed in production WoD
G[34804]='FA K0940 L094 A:79963 T:79963 P:34773 E18546'	-- I:34803 removed in production WoD
G[34805]='K0960 L096 A:500143 T:81770 P:34659 E18612'
G[34806]='K0910 L090 A:74547 T:-947 P:33263 E18546'
G[34807]='E18546'
G[34808]='K0980 L098 A:80003 T:80140 P:34795 E18612'
G[34809]='K0980 L098 A:79201 T:1230882 P:34810 E18612'
G[34810]='K0980 L098 A:80184 T:79201 P:0 E18612'
G[34811]='K0980 L098 A:82658 T:82658 P:34810 E18612'
G[34812]='T:1230977 E18546'
G[34813]='T:80140 E18546'
G[34814]='FH K0940 L094 A:80142 T:79393 P:34632 I:34815 E18546'
G[34815]='FA K0940 L094 A:80142 T:79392 P:34631 I:34814 E18546'
G[34816]='E19342'
G[34817]='E19342'
G[34818]='FH K0980 L098 A:80140 T:80161 P:34808 E18612'	--I:34951
G[34819]='K0990 L098 A:81955 T:81955 P:34869 E18612'
G[34820]='K0900 L090 AP:80163:=09711;580163:>09711 T:79966 P:33059 E18546'
G[34821]='E18546'
G[34822]='FH K0910 L090 A:78466 T:78466 P:34378 I:35166 E18546'
G[34823]='FH K0910 L090 A:78487 T:78487 P:34378 I:35174 E18546'
G[34824]='FH K0910 L090 A:78466 T:78466 P:34378 I:35176 E18546'
G[34825]='E18546'
G[34826]='FH K0980 L098 A:80003 T:80003 P:34808 I:35143 E18612'
G[34827]='K0960 L096 A:580153 T:80232 P:35611 E18612'
G[34828]='K0960 L096 A:80232 T:80232 P:34827 E18612'
G[34829]='K0960 L096 A:80232 T:80232 P:34827 E18612'
G[34830]='K0960 L096 A:80232 T:80508 P:34828 E18612'
G[34831]='E18546'
G[34833]='T:79335 E18546'
G[34834]='T:79335 E18546'
G[34835]='T:79335 E18546'
G[34836]='FA K0910 L090 A:80248 T:80248 E18546'
G[34837]='FH K0940 L094 A:79356 T:80229 P:34576+34577+34579 E18546'	-- TODO: Verify requires 34576 34577
G[34838]='K0960 L096 A:80470 T:80469 P:E34884 E18612'
G[34839]='E18546'
G[34840]='FH K0940 L094 A:80229 T:80339 P:34837 E18546'	--I:34976
G[34841]='T:93812 E18546'	-- also marks 34968 complete	Frozen Supplies 941:43.67,55.61  in tower
G[34842]='E18546'
G[34843]='E18546'
G[34844]='E18546'
G[34845]='K0930 A:76186 T:76186 P:1 E18546 Z19033'
G[34846]='K0000 L090 E19342'
G[34847]='FA K0930 L090 A:77211 T:77211 E18546'
G[34848]='E19533'
G[34849]='FH K0980 L098 A:80161 T:80161 P:34818 E18612'	--I:34954
G[34850]='K0980 L098 A:80161 T:80161 P:34818 E18612'
G[34851]='E18546'
G[34855]='FH K0940 L094 A:80339,80341 T:80341 P:34840 E18546'
G[34856]='E18546'
G[34857]='E18546'
G[34858]='FH K0940 L094 A:80341 T:80341 P:34840 E18546'
G[34859]='T:79334 E18546'
G[34860]='FH K0940 L094 A:80341 T:80341 P:34840 E18546'	--  I:34977
G[34861]='K0900 L090 A:500151 T:79740 P:34461 E18546'
G[34862]='T:80205 E18546'
G[34865]='E18546'
G[34866]='FH K0980 L098 A:80161 T:80319 P:34849+34850 E18612'	--I:34956
G[34867]='K0920 L092 I:35557 E18702'
G[34868]='FH K0980 L098 A:80319 T:80140 P:34866 E18612'
G[34869]='K0990 L098 A:81955 T:81955 P:0 E18612'	--TODO: find P
G[34870]='FH K0940 L094 A:80341 T:80342 P:34855+34858+34860 E18546'	-- TODO: Verify requires 34855 34858	-- removed  I:34980
G[34871]='E18546'
G[34872]='E18546'
G[34873]='E18546'
G[34874]='FH K0940 L094 A:80193 T:80965 P:34634+34635+34636 I:34875 E18546'	-- TODO: Verify requires 34634 34635
G[34875]='FA K0940 L094 A:80260 T:80966 P:34609+34612+34619 I:34874 E18546'	-- TODO: Verify requires 34612
G[34876]='FA K0920 L090 A:71641 T:71641 E18546'
G[34877]='FA K1000 L098 A:81144 T:79674 P:34593 E18612'	-- removed  I:35159
G[34878]='FH K0940 L094 A:80965 T:80396 P:34874 I:34908 E18546'
G[34879]='K0940 L094 A:80396 T:80390 P:34878 E18546'
G[34881]='K0980 L098 A:80593 T:80593 P:35331 E18612'
G[34882]='K0960 L096 A:80508 T:80508 P:34830 E18612'
G[34883]='K0960 L096 A:80508 T:80508 P:34830 E18612'
G[34884]='K0960 L096 A:581770 T:581770 P:35611 I:34565 E18612'
G[34885]='K0960 L096 A:80233 T:581770 P:E34884 E18612'
G[34886]='K0960 L096 A:80469 T:80469 P:34838 E18612'
G[34887]='K0940 L094 A:80390 T:80389 P:34879 I:34909 E18546'
G[34888]='K0940 L094 A:80390 T:80389 P:34879 I:34910 E18546'
G[34889]='K0940 L094 A:80390 T:80389 P:34879 I:34911 E18546'
G[34890]='K0940 L094 A:80389 T:80389 P:34887+34888+34889 I:34912 E18546'	-- TODO: Verify requires 34887 34888
G[34891]='K0980 L098 A:80597 T:80597 P:0 I:35333 E18612'
G[34893]='K0980 L098 A:80593 T:80593 P:35331 E18612'
G[34894]='K0980 L098 A:80434 T:80434 P:34943 E18612'
G[34895]='E18546'
G[34896]='T:90071 E18546'
G[34897]='FA K0930 L090 A:80378 T:73425 E18546'
G[34898]='SP K0970 L096 A:85320 T:85320 P:34886 E18612'
G[34899]='FH K0980 L098 A:80140 T:80003 P:34868 E18612'	--I:34769
G[34900]='K0990 L098 A:81955 T:81955 P:34819 E18612'
G[34904]='E18546'
G[34905]='E18546'
G[34906]='E18546'
G[34907]='E18546'
G[34908]='FA K0940 L094 A:80966 T:80607 P:34875 I:34878 E18546'
G[34909]='K0940 L094 A:80608 T:80617 P:34913 I:34887 E18546'
G[34910]='K0940 L094 A:80608 T:80617 P:34913 I:34888 E18546'
G[34911]='K0940 L094 A:80608 T:80617 P:34913 I:34889 E18546'
G[34912]='K0940 L094 A:80617 T:80617 P:34909+34910+34911 I:34890 E18546'	-- TODO: Verify requires 34909
G[34913]='K0940 L094 A:80607 T:80608 P:34908 E18546'
G[34914]='K0980 L098 A:81189 T:80429 P:34899 E18612'
G[34915]='K0980 L098 A:80429 T:80429 P:0 E18612'
G[34916]='K0980 L098 A:80429 T:80429 P:0 E18612'
G[34917]='K0980 L098 A:80451 T:80429 P:0 E18612'
G[34918]='FH K0980 L098 A:80429 T:80003 P:1 E18612'
G[34920]='T:79234 E18546'
G[34921]='K0960 L096 A:80648 T:80639 P:35634+35012 E18612'	-- TODO: Verify P:, may also need 35013
G[34922]='K0960 L096 A:80740 T:80740 P:35007 E18612'
G[34923]='K0960 L096 A:80740 T:80740 P:35007 E18612'
G[34924]='K0960 L096 A:80863 T:80746 P:34923+34922 E18612'	-- TODO: Verify requires 34923
G[34925]='K0900 L090 A:79917 T:79917 P:34442 E18546'
G[34926]='E19342'
G[34929]='E18546'
G[34931]='T:93812 E18546'
G[34932]='K0980 L098 A:80434 T:80434 P:34894 E18612'
G[34934]='T:79231 E18546'
G[34935]='E18546'
G[34936]='E18546'
G[34937]='E18546'
G[34938]='K0960 L096 A:80740 T:80481 P:34923+34922 E18612'	-- TODO: Verify requires 34923
G[34939]='K0960 L096 A:80860 T:80481 P:34923+34922 E18612'	-- TODO: Verify requires 34923
G[34940]='T:76534 E18546'	-- Strange Looking Dagger 949:52.97,79.96 (in cave)
G[34941]='K0980 L098 A:80434 T:80595 P:34932 E18612'
G[34942]='K0960 L096 A:80508 T:80153 P:34882+34883 E18612'	-- TODO: Verify requires 34882
G[34943]='K0980 L098 A:80595 T:80434 P:35331 E18612'
G[34944]='E18612'
G[34945]='T:80524 E18546'
G[34946]='T:77973 E18546'
G[34947]='FA E18546'
G[34948]='K0950 A:75924 T:1225726 P:1 E18702'
G[34949]='SP FH K0940 L094 A:80553 T:80553 P:34712+36793 U154 E18546'
G[34950]='K0950 L094 A:75958 T:75959 P:33722+35226 E18546'	-- TODO: Verify requires 33722, could also require 33735+33720+33721 as well
G[34951]='FA K0980 L098 A:80624 T:80161 P:34769 E18612'	--I:34818
G[34952]='FA K0980 L098 A:79954 T:79954 P:34769 E18612'
G[34953]='K0980 A:80161 T:79954 P:0 E18702'
G[34954]='FA K0980 L098 A:80161 T:80161 P:34951 E18612'	--I:34849
G[34955]='K0980 L098 A:80161 T:80161 P:34951 E18612'
G[34956]='FA K0980 L098 A:80161 T:80319 P:34954+34955 E18612'	--I:34866 , TODO: Verify requires 34954
G[34957]='FA K0980 L098 A:80319 T:79576 P:34956 E18612'
G[34958]='K0900 L090 A:78568 T:78568 P:34439 E18546'	-- OCC:34438
G[34959]='K0950 L094 A:575803 T:575803 P:34088 E18546'
G[34960]='FH K0900 L090 A:1231100 T:500154 E18546'	-- TODO: Is there a P:? -- return is garrison level 2 position
G[34962]='FH K0950 L094 A:75959 T:75805 P:33730 E18546'
G[34963]='FA K0950 L094 A:575803 T:75805 P:34098 E18546'
G[34964]='FH K0980 L098 A:80003 T:80597 P:0 I:35332 E18612'	--TODO: find P:
G[34965]='FH K0980 L098 A:80597 T:80597 O:34964 I:35331 E18612'	-- changed  P:34964 into O: because Horde boosted to 100 can get immediately
G[34966]='E18546'
G[34967]='E18546'	-- "Radided Loot" is top of tower 941:37.26,59.15
G[34968]='T:93812 E18546'	-- see comments for 34841
G[34969]='E18546'
G[34970]='E18546'
G[34971]='FH K0940 L094 A:80342 T:80623 P:36793+34870 E18546'	-- completes achievement "Establishing your Armory"
G[34972]='SP K0940 L094 A:80623 T:80623 P:34971 U155 E18546'
G[34973]='E18546'
G[34974]='E18546'
G[34975]='E18546'
G[34976]='FA K0940 L094 A:80627 T:80628 P:34578 E18546'	--I:34840
G[34977]='FA K0940 L094 A:80628 T:80632 P:34976 I:34860 E18546'
G[34978]='K0940 L094 A:80628 T:80632 P:34976 E18546'
G[34979]='K0940 L094 A:80628 T:80632 P:34976 E18546'
G[34980]='FA K0940 L094 A:80632 T:80630 P:34977+34978+34979 I:34870 E18546'	-- TODO: Verify requires 34977 34979
G[34981]='K0940 L094 A:80630 T:80968 P:34980 E18546'
G[34982]='SP FA K0940 L094 A:80968 T:80968 P:34981+36797 U155 E18546'
G[34983]='E18546'
G[34984]='E18546'
G[34985]='T:79231 E18546'
G[34986]='E18546'
G[34987]='K0900 L090 A:78569 T:78569 P:34439 E18546'
G[34991]='K0960 L096 A:80639 T:80639 P:34921 E18612'
G[34992]='FH T:74594 I:35149 E18546'
G[34993]='SP FA K0940 L094 A:80672 T:80672 P:34711+36797 U154 E18546'
G[34994]='K0900 L090 A:80761 T:80761 P:33788 E18546'
G[34995]='K0900 L090 A:80865 T:80865 P:33788 E18546'
G[34996]='FA K0900 L090 A:80859 T:80859 E18546'
G[34997]='FA K0900 L090 A:80707 T:-947 E18546'
G[34998]='K0960 L096 A:581770 T:80758 P:35611 E18612'
G[34999]='K0960 L096 A:81514 T:81514 P:1 E18612'
G[35000]='K0960 L096 A:80758 T:80758 P:34998 E18612'	-- TODO: verify the P: 
G[35001]='K0960 L096 A:80758 T:1231183 P:35000 E18612'
G[35002]='K0960 L096 A:80758 T:1231184 P:35000 E18612'
G[35003]='K0960 L096 A:580648 T:86355 P:35001+35002 E18612'	-- TODO: verify requires 35002
G[35004]='K0960 L096 A:580648 T:86355 P:35001+35002 E18612'	-- TODO: verify requires 35002	-- if you accept 35012 before turning this in, you need to turn it in before he returns
G[35005]='FH K0900 L090 A:78553 T:78553 P:34741 I:35019 E18546'
G[35006]='K0900 L090 A:76204 T:76204 P:33788 E18546'
G[35007]='K0960 L096 A:80481 T:80740 P:35010 E18612'
G[35008]='E18612'
G[35009]='K0960 L096 A:80481 T:77857 P:34939+34938+36790+34924 E18645'	-- TODO: Verify requires 34938 36790 34924
G[35010]='K0960 L096 A:80639 T:80481 P:34991 E18612'
G[35011]='K0960 L096 A:586475 T:86475 P:35001+35002 E18612'	-- TODO: verify requires 35002
G[35012]='K0960 L096 A:86355 T:500144 P:35003 E18612'	-- after this was accepted NPC 86355 disappears so cannot turn in 35004
G[35013]='K0960 L096 A:86475 T:80834 P:35011 E18612'
G[35014]='K0900 L090 A:80727 T:80635 P:33788 E18546'
G[35015]='FA K0900 L090 A:80635 T:80635 P:35014 E18546'
G[35016]='FH K0930 L092 A:81218 T:80757 O:35667 E18566'	-- no known preqs, but Yoshimo reports the P:	-- changed P:35667 to O: because Horde boost to 100 can get this
G[35017]='FH K0930 L092 A:81185 T:80757 E18566'	-- no known preqs
G[35018]='E18546'
G[35019]='FA K0900 L090 A:500090 T:500090 P:34436 I:35005 E18546'
G[35020]='E18546'
G[35021]='FH K0930 L092 A:100112378 T:80757 P:C35016 E18566'	-- TODO: Horde boost to 100 tried killing lots of Fungal Lurchers but quest starting item never drops.  however, when accepted 35016 (and NOT 35017), but after interacting with 35017 quest giver, this became available on first Lurcher kill
G[35022]='K0990 L098 A:80864 T:80864 P:35393 E18612'
G[35023]='K0990 L098 A:80866 T:80866 P:35393 E18612'
G[35024]='K0990 L098 A:80864 T:80864 P:35022+35023 E18612'	-- TODO: Verify requires 35022
G[35025]='K0930 L092 A:81202 T:82832 P:35248+35035 E18566'	-- TODO: Verify requires 35248
G[35026]='K0930 L092 A:82832 T:81674 P:35730 E18566'
G[35027]='K0930 L092 A:80757 T:80757 P:35016+35017+35021 E18546'
G[35028]='E18546'
G[35029]='K0930 L092 A:80757 T:80757 P:35016+35017+35021 E18566'
G[35030]='K0930 L092 A:80757 T:81241 TP:80757:e35031;81241:E35031 P:35027+35029 E18566'
G[35031]='K0930 L092 A:80757 T:81241 P:35027+35029 E18546'
G[35032]='K0910 L090 A:577282 T:-947 P:34043 E18546'
G[35033]='FA K0930 L092 A:80978 T:80921 O:33533,35556 E18546'
G[35035]='K0930 L092 A:81202 T:81202 P:35880 E18566'
G[35036]='FH K0930 L092 A:83569 T:84743 P:35730 E18566'
G[35037]='K0930 L092 A:80856 T:80856 P:36508,35036 E18566'
G[35038]='K0930 L092 A:84743 T:84743 P:35036 E18566'
G[35040]='K0930 L092 A:81241 T:82732 P:35030+35031 E18566'
G[35041]='K0930 L092 A:84743 T:80856 P:35038+35202 E18546'	-- TODO: Verify requires 35038
G[35044]='E18546'
G[35045]='K0940 L094 A:79159 T:79329 P:34563 E18546'
G[35047]='T:79231 E18546'
G[35049]='FA T:75136 I:35064 E18546'
G[35050]='K0930 L092 A:75146 T:75146,575146 P:35828|36595+35065+35834 E18546'	-- TODO: Verify requires 35065	-- Blizzard has a problem since it will put a yellow ? on the map at 53.31,59.89 before you have chosen to build the outpost and allow D'kaan to stand there.
G[35051]='T:77892 E18546'
G[35055]='K0930 L092 A:75136 T:75136,575136 P:35828|36595+35065+35834 E18546'	-- TODO: Verify requires 35065	-- Note that completing 35055 (or both 35055 and 35050) allows the new locations of NPCs for turnin, but originals also are still present
G[35056]='T:81240 E18546'
G[35057]='K0910 L090 E18546'
G[35058]='FH K0900 L090 A:100112566 T:81166 P:PA001 E18556'
G[35059]='FA K0990 L098 A:79576 T:81039 P:34596 E18612'	--I:35095
G[35060]='K1000 L098 A:81039 T:81086 P:35059 E18612'
G[35061]='K1000 L098 A:81086 T:81039 P:35060 E18612'
G[35062]='K1000 L098 A:81039 T:79576 P:35061+35067+35068 E18612'	-- TODO: Verify requires 35067 35068
G[35063]='FA K0930 L092 A:575136 T:500136 P:35055+35050 E18546'
G[35064]='FA T:75136 I:35049 E18546'
G[35065]='K0930 L092 A:80921 T:75146 P:35033 E18546'
G[35066]='K0002 L090 A:79892 T:79892 P:36132 E19027 D097'
G[35067]='K0990 L098 A:81097 T:81123 P:35060 E18612'
G[35068]='K0990 L098 A:81097 T:81123 P:35060 E18612'
G[35069]='K1000 L098 A:81134 T:81123 P:35060 E18612'
G[35070]='K0910 L090 A:80075 T:80075 P:34785 E18546'
G[35071]='K0002 L090 A:79892 T:79892 P:36132 E19027 D097'
G[35072]='K0002 L090 A:79892 T:79892 P:36132 E19027 D097'
G[35073]='K0002 L090 A:79892 T:79892 P:36132 E19027 D097'
G[35074]='K0002 L090 A:79892 T:79892 P:36132 E19027 D097'
G[35075]='K0002 L090 A:79892 T:79892 P:36132 E19027 D097'
G[35077]='K0970 L096 A:81109 T:81109 E18612'
G[35079]='K0970 L096 A:81128 T:81128 E18612'
G[35080]='K0970 L096 A:81109 T:81773 P:35077+35079+36179 E18612'	-- TODO: Verify requires 35079
G[35081]='K0970 L096 A:81784 T:81784 P:35080 E18612'
G[35082]='K0970 L096 A:81773 T:81773 P:35080 E18612'
G[35083]='K0990 L098 A:1233263 T:1233263 P:35372 E18612'	-- OTC:35391
G[35084]='K0990 L098 A:1233263 T:1233263 P:35372 E18612'	-- OTC:35389
G[35085]='K0990 L098 A:1233263 T:1233263 P:35083+35084 E18612'	-- TODO: Verify requires 35083	-- OTC:35387
G[35086]='K0990 L098 A:1233263 T:1233263 P:35085 E18612'	-- OTC:35388
G[35087]='K0990 L098 A:1233263 T:1233263 P:35085 E18612'	-- OTC:35392
G[35088]='K0990 L098 A:1233263 T:1233263 P:35086+35087 E18612'	-- TODO: Verify requires 35086	-- OTC:35390
G[35089]='K0970 L096 A:81972 T:81978 P:35285 E18612'
G[35090]='K0970 L096 A:81972 T:81978 P:35285 E18612'
G[35091]='K0970 L096 A:81978 T:81978 P:35089+35090+36384 E18612'	-- TODO: Verify requires 35090 36384
G[35092]='E19342'
G[35093]='E18663'
G[35094]='E19342'
G[35095]='FH K0990 L098 A:80003 T:81186 P:34899+0 E18612'	--I:35059
G[35096]='K1000 L098 A:81186 T:81086 P:35095 E18612'
G[35097]='K1000 L098 A:81086 T:81186 P:0 E18612'
G[35098]='K1000 L098 A:81186 T:80003 P:0 E18612'
G[35099]='K0990 L098 A:81194 T:81193 P:1 E18612'
G[35100]='K0990 L098 A:81194 T:81193 P:1 E18612'
G[35101]='K1000 L098 A:81195 T:81193 P:0 E18612'
G[35102]='K0940 L094 A:79210 T:79356 P:34569 E18546'
G[35103]='K0900 L090 A:81166 T:81209 P:35058 E18556'
G[35104]='K0900 L090 A:81209 T:81210 P:35103 E18556'
G[35106]='K0900 L090 A:81210 T:81210 P:35104 E18556'
G[35128]='K0930 L092 A:80856 T:84131 P:36209,35041 E18546'
G[35129]='K0930 L092 A:80856 T:84131 P:35041 E18546'
G[35136]='FH K0930 L092 A:84131 T:74594 P:35139+36793 U212 E18546'
G[35137]='K0930 L092 A:79322 T:81076 P:34698+34700+34702+34703 E18546'	-- TODO: Verify requires 34698 34703
G[35139]='K0930 L092 A:84131 T:84131 P:36223|35129+35128+35210 E18546'	-- TODO: Verify requires 35128
G[35140]='K0980 L098 A:81039 T:81039 P:35061+35067+35068 E18612'	-- TODO: Verify requires 35067 35068
G[35141]='K0980 L098 A:81039 T:81280 P:35140 E18612'
G[35142]='K1000 L100 A:79774 E18612'
G[35143]='K0980 A:80161 P:0 I:34826 E18612'
G[35144]='FH K0990 L098 A:81335 T:81953 P:0 I:35398 E18612'
G[35145]='FH K0990 L098 A:81335 T:81953 P:0 I:35397 E18612'
G[35146]='K0980 L098 A:84632 T:84861 E18612'	--no known prequest
G[35147]='SP K1001 L098 A:87393 T:87393 E18612'
G[35148]='FA K0990 L098 A:79954 T:79282 P:34769 E18612'	--I:35150
G[35149]='FH T:74594 I:34992 E18546'
G[35150]='FH K0990 L098 A:81319 T:79281 P:34899 E18612'	--I:35148 
G[35151]='FH K0930 L092 A:500132 T:500133 P:36460 E18566'
G[35152]='FH K0930 L092 A:79320 T:76688 P:34700 E18566'
G[35153]='E18546'
G[35154]='FH K0000 L092 A:81688 T:81688 P:>09761 E18566'
G[35155]='FH K0990 L098 A:79281 T:81361 P:35150 E18612'	-- removed  I:34572
G[35156]='FH K0990 L098 A:1231901 T:81361 P:0 I:34597 E18612'	-- TODO: Determine whether you need to be on 35155 or 35157 to get this
G[35157]='FH K0990 L098 A:79281 T:81361 P:35150 E18612'	-- removed  I:34593
G[35158]='FH K1000 L098 A:81361 T:80003 P:35157 E18612'	-- removed  I:34596
G[35159]='FH K1000 L098 A:81361 T:80003 P:35157 E18612'	-- removed  I:34877
G[35161]='K0940 L094 E18612'
G[35162]='E18546'
G[35166]='K0900 L090 A:77209 T:77209 P:34586 I:34822 E18546'
G[35167]='FH K0990 L098 A:72822 T:82688 E18612'	--no known prequests
G[35168]='FA K0900 L090 AP:77359:G-060018;577359:G-060019;500221:G-060020 TP:77792:G-060018;577792:G-060019;500222:G-060020 P:G-060 E18566'
G[35169]='K1000 L098 A:79576 T:81412 P:35062 E18612'
G[35170]='K0990 L098 A:82688 T:72822 P:35167 E18612'
G[35171]='K1000 L098 A:80003 T:81415 P:0 E18612'
G[35172]='K0900 L090 AP:77359:G-060018;577359:G-060019;500221:G-060020 TP:77792:G-060018;577792:G-060019;500222:G-060020 P:G-060+35168 E18546'
G[35174]='K0900 L090 A:79457 T:79457 P:34586 I:34823 E18546'
G[35176]='K0900 L090 A:77209 T:77209 P:34586 I:34824 E18546'
G[35185]='FA K1000 L100 A:83858 T:88276 P:>09711 I:35186 E18612 D093'
G[35186]='FH K1000 L100 A:583858 T:88276 P:>09761 I:35185 E18663 D098'
G[35187]='K1000 L100 A:88276 T:81530 P:35185,35186 E18612'
G[35188]='K1000 L100 A:81499 T:81499 P:35187 E18612'
G[35189]='K1000 L100 A:81530 T:81530 P:35187 E18612'
G[35190]='K1000 L100 A:81499 T:81499 P:35187 E18612'
G[35191]='K1000 L100 A:81530 T:81530 P:35187 E18612'
G[35192]='E18546'
G[35193]='E18716'
G[35194]='K1000 L100 A:81530 T:1231918 P:35188+35189+35190+35191 E18716'	-- TODO: Verify requires 35188 35189
G[35195]='K1000 L100 A:1231918 T:581530 P:35194 E18716'
G[35196]='FA K1000 L100 A:581530 T:83858 P:35195 I:35197 E18716'
G[35197]='FH K1000 L100 A:581530 T:583858 P:35195 I:35196 E18716'	-- turning in completes achievement "The Sargerei"
G[35201]='E18546'
G[35202]='K0930 L092 A:84743 T:84743 P:35036 E18566'
G[35203]='E18612'
G[35204]='K0930 L092 A:81589 T:81589 P:35215+35216 I:35429 E18546'	-- TODO: Verify requires 35215
G[35205]='K0930 L092 A:81600 T:81601 P:35208 E18546'	-- OTC: 35431
G[35206]='K0930 L092 A:81590 T:81590 P:35215+35216 I:35432 E18546'	-- TODO: Verify requires 35215
G[35207]='K0930 L092 A:81601 T:81601 P:35205+36523 I:35433 E18546'	-- TODO: Verify requires 35205
G[35208]='K0930 L092 A:81588 T:81600 P:35215+35216 I:35430 E18546'	-- TODO: Verify requires 35215
G[35209]='K0930 L092 A:81601 T:81590 P:35207 I:35434 E18546'
G[35210]='K0930 L092 A:1236140 T:84131 P:D35128 E18612'
G[35211]='K0970 L096 A:81443 T:81443 P:35089+35090+36384 E18612'	-- TODO: Verify requires 35090 36384
G[35212]='K0930 L092 A:75136 T:81588 P:35063+35049 E18546'
G[35213]='K0930 L092 A:81588 T:81588 P:35212 I:35399 E18546'
G[35214]='K0930 L092 A:81589 T:81589 P:35213 I:35400 E18546'
G[35215]='FA K0930 L092 A:1231903 T:81588 P:35213 I:35402 E18546'
G[35216]='FA K0930 L092 A:81634 T:81588 P:E35215 I:35406 E18546'	-- TODO: Verify prerequisite is killing Voice of Iyu
G[35217]='E18612'
G[35218]='K0920 A:80856 T:1233391 P:35934+35037 E18566'	-- TODO Verify requires 35037
G[35219]='T:78457 E18546'
G[35220]='E18546'
G[35221]='E18546'
G[35222]='E18612'
G[35225]='K0940 L092 A:81588 T:75710 P:35204+35206+35209 E18546'	-- TODO: Verify requires 35204 35209
G[35226]='K0950 L094 A:75806 T:75958 P:33754 E18546'
G[35227]='K0950 L094 A:75392 T:75392 P:34326 I:34122 E18546'
G[35228]='E18612'
G[35229]='FA K0940 L092 A:75710 TP:75710:e35234;81751:E35234 P:35225 I:35507 E18546'
G[35231]='FH K0990 L098 A:81335 T:80864 P:0 I:35393 E18612'
G[35232]='FH K0980 L098 A:80597 T:81335 P:0 E18612'	--I:35372 , P: seems to require throne of element quests
G[35233]='FA K0940 L092 A:75710 TP:75710:e35234;81751:E35234 P:35225 I:35501 E18546'
G[35234]='FA K0940 L092 A:75710 T:81751 P:35225 I:35509 E18546'
G[35235]='FA K0940 L092 A:81751 T:75878 P:35229+35233+35234 I:35510 E18546'	-- TODO: Verify requires 35229 35233
G[35236]='FA K09532768 L094 A:-100946 T:-946 E18546'
G[35237]='K09532768 L094 A:79921 E18546'	-- available to Horde boost to 100
G[35238]='SP FH K0940 L094 A:79853 T:79853 P:34751+36793 U171 E18546'
G[35239]='SP FA K0940 L094 A:79853 T:79853 P:34761+36797 U171 E18546'
G[35240]='FA K0900 L090 A:81762 T:578559 P:34420 I:34421 E18546'
G[35241]='FH K0900 L090 A:81761 T:578553 P:34420 I:35242 E18546'
G[35242]='FA K0900 L090 A:81763 T:78554 P:34420 I:35241 E18546'
G[35243]='SP FH K0920 L090 A:81765 T:81765 P:36709+36793 U216 E18546'
G[35244]='E18546'
G[35245]='K0960 L096 A:80834 T:581770 P:35013 E18612'
G[35247]='K0930 L092 A:84748 T:85980 P:35149 E18612'
G[35248]='K0930 L092 A:81202 T:81202 P:35880 E18566'
G[35249]='FH K0960 L095 A:78577 T:577737 P:34971,34712 I:34458 E18546'
G[35250]='E18546'
G[35251]='K0910 A:70860 T:70860 P:0 E18556'
G[35252]='E18546'
G[35253]='E18546'
G[35254]='K0960 L095 A:75392 T:75392,77581 P:34092+35227 I:34144 E18612'	-- TODO: Verify requires 35227	-- 77581 is while still doing 34154
G[35255]='K0940 L092 A:75878 T:75127 P:35235 I:35416 E18546'
G[35256]='E19890'
G[35257]='K0960 L096 A:85598 T:80157 P:O34942 E18612'
G[35258]='K0960 L096 A:80157 T:80157 P:35257 E18612'
G[35259]='K0960 L096 A:80155 T:82123 P:35611 E18612'
G[35260]='K0960 L096 A:80157 T:80157 P:1 E18612'
G[35261]='K0960 L096 A:82123 T:1232353 P:35259 E18612'
G[35262]='SP FA K0940 L092 A:81772 T:81772 P:35235+36797 U159 E18716'
G[35264]='SP K1001 L100 A:81870 T:81870 P:36133 E18702'
G[35265]='FH K0980 L098 A:80597 T:80597 P:0 I:35330 E18612'	--TODO P: seems to require throne of element quests
G[35266]='E18546'
G[35267]='E18612'
G[35271]='FH K0990 L098 A:1232024 T:81193 I:35386 E18612'	-- no known prequest
G[35272]='FH K0960 L096 A:81890 T:81890 P:1 I:35274 E18612'
G[35273]='K0960 L096 A:1232353 T:80155 P:35261 E18612'
G[35274]='K0960 L096 A:81891 T:81891 P:35671 I:35272 E18612'
G[35275]='K0960 L096 A:81890 T:81913 P:35272 I:35276 E18612'
G[35276]='K0960 L096 A:81891 T:81915 P:35274 I:35275 E18612'
G[35277]='K0960 L096 A:81920 T:81920 P:35275 I:35286 E18612'
G[35279]='E18546'
G[35280]='E18546'
G[35281]='E18546'	-- kill NPC 81406, Bahameye, 947:29.44,7.12
G[35282]='E18546'
G[35283]='T:1232089 I:35284 E18546'
G[35284]='I:35283 E18546'
G[35285]='K0970 L096 A:81784 T:81972 P:35081+35082 E18612'
G[35286]='K0960 L096 A:81929 T:81929 P:35276 I:35277 E18612'
G[35287]='K0150 L015 T:61528 E18546'
G[35288]='K0220 L020 T:46254 E18546'
G[35289]='E18546'
G[35290]='E18546'
G[35291]='E18546'
G[35293]='K0960 L096 A:81949 T:81960 P:35286 I:35295 E18612'
G[35294]='E18546'
G[35295]='K0960 L096 A:81959 T:81961 P:35277 I:35293 E18612'
G[35296]='E18612'
G[35297]='E18546'	-- this seems to complete when you move forward through Tanaan Jungle to turn in 35240 & 35242
G[35298]='K0970 L096 A:81443 T:82468 P:35091+35211+36428 E18612'	-- TODO: Verify requires 35091 35211
G[35303]='K0170 L015 T:3654 E18546'
G[35304]='K0180 L016 T:46964 E18546'
G[35305]='K0180 L016 T:3887 E18546'
G[35306]='E18546'
G[35307]='K0170 L015 T:3674 E18546'
G[35308]='E18546'
G[35309]='K0850 L085 T:46964 E18546'
G[35310]='E18546'
G[35311]='K0850 L085 T:3887 E18546'
G[35312]='K0900 L088 T:62205 E18546'
G[35313]='E18546'
G[35314]='E18546'
G[35315]='K0890 L088 T:56877 E18546'
G[35316]='K0900 L090 E18546'
G[35317]='K0990 L098 A:81953 T:82070 P:0 I:35396 E18612'
G[35318]='K0890 L087 T:61398 E18546'
G[35319]='K0870 L087 T:56884 E18546'
G[35320]='K0900 L090 T:700062 E18546'
G[35321]='K0900 L090 T:61398 E18546'
G[35322]='K0960 L096 A:81961 T:82100 P:35295 I:35329 E18612'
G[35323]='K0850 L085 T:59479 E18546'
G[35324]='K0900 L090 T:59479 E18546'
G[35325]='K0850 L085 T:56439 E18546'
G[35326]='E18546'
G[35327]='K0900 L090 T:56439 E18546'
G[35329]='FA K0960 L096 A:81960 T:82100 P:35293 I:35322 E18612'
G[35330]='FA K0980 L098 A:82138 T:82138 P:34941 I:35265 E18612'
G[35331]='FA K0980 L098 A:82138 T:82138 P:35332 I:34965 E18612'
G[35332]='K0980 L098 A:79576 T:82138 P:34596 I:34964 E18612'
G[35333]='K0980 L098 A:82138 T:82138 P:35331 I:34891 E18612'
G[35334]='E18546'
G[35335]='E18546'
G[35337]='FA K0990 L098 A:82092 T:82092 P:34769 E18612'	--I:35374
G[35338]='FA K0990 L098 A:82094 T:82094 P:34769 E18612'	--I:35376
G[35339]='K0960 L096 A:82101 T:82124 P:35329 E18612'	-- OTC:35340, removed P:35322
G[35340]='E19342'
G[35341]='SP FH K0920 L090 A:79229 T:79229 P:32981+36793 U183 E18546'
G[35342]='FA K0900 L090 A:100113103 T:82466 P:PA001+E34019 E18546'
G[35343]='K0900 L090 A:82466 T:82497 P:35342 E18546'
G[35344]='K0900 L090 A:82497 T:82496 P:35343 E18546'
G[35345]='K0900 L090 A:82496 T:82497 P:35344 E18546'
G[35347]='E18546'
G[35348]='K0800 L080 E18546'
G[35349]='K0800 L080 E18546'
G[35350]='FA K1000 L098 A:82092 T:82092 P:35337 E18612'	--I:35375
G[35351]='K0850 L085 E18546'
G[35352]='K0850 L085 E18546'
G[35353]='K0960 L096 A:82124 T:82126 P:35339 E18612'
G[35356]='FA K1000 L098 A:100113107 T:82094 E18612'
G[35357]='K1000 L098 A:82094 T:82094 P:35356 E18612'
G[35358]='K0850 L085 T:54432 E18546'
G[35359]='E18546'
G[35360]='E18546'
G[35361]='E18546'
G[35362]='E18546'
G[35363]='K0800 L080 T:44566 E18546'
G[35364]='K0800 L080 T:40788 E18546'
G[35365]='K0850 L085 T:44566 E18546'
G[35366]='K0850 L085 T:40788 E18546'
G[35367]='E18546'
G[35368]='E18546'
G[35369]='E18546'
G[35370]='E18546'
G[35371]='E18546'
G[35372]='FA K0980 L098 A:82138 T:82179 P:35330 E18612'	--I:35232
G[35373]='E18546'
G[35374]='FH K0990 L098 A:82078 T:82078 P:34899 E18612'	--I:35337
G[35375]='FH K1000 L098 A:82078 T:82078 P:35374 E18612'	--I:35350
G[35376]='FH K0990 L098 A:82080 T:82080 P:34899 E18612'	--I:35338
G[35377]='FH K1000 L098 A:100113109 T:82080 E18612'
G[35378]='K1000 L098 A:82080 T:82080 P:35377 E18612'
G[35379]='K09932768 L098 A:86979 T:81902 E18612'
G[35380]='K0960 L096 A:82126 T:82194 P:35353 E18612'
G[35381]='E18546'
G[35382]='E18546'
G[35383]='E18546'
G[35384]='E18546'
G[35385]='E18546'
G[35386]='FA K0990 L098 A:1232024 T:82252 I:35271 E18612'
G[35387]='T:700211 E19342'
G[35388]='E19342'
G[35389]='T:700209 E19342'
G[35390]='T:81409 E19342'
G[35391]='T:700211 P:1 E19342'
G[35392]='T:81216 E19342'
G[35393]='FA K0990 L098 A:82179 T:80864 P:35372 I:35231 E18612'
G[35394]='E19890'
G[35395]='FA K0990 L098 AA:82181 AH:86393 T:80595 P:35397+35398 I:34271 E18612'	-- TODO: Verify requires 35397
G[35396]='FA K0990 L098 AA:82181 AH:86393 T:82214 P:35397+35398 I:35317 E18612'	-- TODO: Verify requires 35397
G[35397]='FA K0990 L098 A:82179 T:82181 P:35372 I:35145 E18612'
G[35398]='FA K0990 L098 A:82179 T:82181 P:35372 I:35144 E18612'
G[35399]='FH K0930 L092 A:574606 T:574606 P:36474 I:35213 E18546'
G[35400]='FH K0930 L092 A:74593 T:74593 P:36474 I:35214 E18546'
G[35401]='K0820 L081 T:52019 E18546'
G[35402]='K0930 L092 A:574606 T:574606 P:36474 I:35215 E18546'
G[35403]='K0850 L085 T:43875 E18546'
G[35404]='K0840 L084 E18546'
G[35405]='K0850 L085 T:40484 E18546'
G[35406]='FH K0930 L092 A:1235129 T:574606 P:E35402 I:35216 E18546'	-- TODO: Verify prerequisite is killing Voice of Iyu
G[35407]='K0960 A:82194 T:82194 P:35380 E18612'
G[35408]='K0960 L096 A:82212 T:82212 P:35380 E18612'
G[35411]='K0850 L085 T:52730 E18546'
G[35412]='K0850 L085 T:52053 E18546'
G[35413]='K0840 L084 E18546'
G[35414]='K0850 L085 T:44819 E18546'
G[35415]='K0850 L084 E18546'
G[35416]='K0940 L092 A:82337 T:500133 P:35510 I:35255 E18546'	-- completes In the Land of Giants
G[35417]='E18546'
G[35418]='E18546'
G[35419]='E18546'
G[35420]='K0850 L084 E18546'
G[35421]='E18546'
G[35422]='E18546'
G[35423]='E18546'
G[35424]='K0850 L085 T:39378 E18546'
G[35425]='E18546'
G[35426]='K0850 L085 E18546'
G[35427]='E18546'
G[35428]='E18546'
G[35429]='K0930 L092 A:574606 T:82228 P:35402+35406 I:35204 E18546'
G[35430]='K0930 L092 A:574606,82228 T:82254 P:35400+35402+35399+35406 I:35208 E18546'
G[35431]='T:81942 E19634'
G[35432]='K0930 L092 A:74593,82233 T:82233 P:35402+35406 I:35206 E18546'
G[35433]='K0930 L092 A:82233 T:82233 P:35536+35429+35432 I:35207 E18546'
G[35434]='K0930 L092 A:82228 T:82228 P:35536+35429+35432 I:35209 E18546'
G[35435]='K0850 L085 T:54969 E18546'
G[35436]='K0800 L078 T:36666 E18546'
G[35437]='K0800 L080 T:36502 E18546'
G[35438]='K0800 L080 T:36658 E18546'
G[35439]='K0850 L085 T:54938 E18546'
G[35440]='K0800 L080 T:36658 E18546'
G[35441]='K0800 L080 T:36954 E18546'
G[35442]='K0800 L080 E18546'
G[35443]='K0850 L085 T:23574 E18546'
G[35444]='K0910 L090 A:82256 T:76200 P:34019 I:35450,35459 E18546'
G[35446]='K0790 L077 E18546'
G[35447]='K0800 L080 E18546'
G[35448]='E18546'	-- killing Darkmaster Go'vid (82268) at 947:42.42,83.76 though he wanders about
G[35449]='K0790 L077 E18546'
G[35450]='K0910 A:81126 T:76200 P:34019 I:35444,35459 E18546'
G[35452]='K0790 L077 E18546'
G[35453]='K0800 L080 T:26861 E18546'
G[35454]='K0800 L080 E18546'
G[35456]='K0790 L077 T:28923 E18546'
G[35457]='K0800 L080 E18546'
G[35458]='K0800 L080 T:700167 E18546'
G[35459]='K0910 A:1232397 T:76200 P:34019 I:35444,35450 E18546'
G[35460]='FA K0900 L090 A:82270 T:82270 P:36498+37196+i176111,35884+i176111 I:35745 E18546'
G[35461]='K0900 L090 T:62205 E18546'
G[35462]='FA K0900 A:82270 T:82270 P:35884|37196+i176111 I:35746 E18546'
G[35463]='K0900 L090 A:82270 T:82270 P:35460+35462+i176111 I:35748 E18612'	-- TODO: Verify needs 35460
G[35464]='K0900 L090 A:85213 T:85213 P:35460+35462+i176111 I:35744 E18612'	-- TODO: Verify needs 35460
G[35465]='K0770 L075 E18546'
G[35466]='E18546'
G[35467]='E18546'
G[35468]='K0800 L080 T:27978 E18546'
G[35469]='E18546'
G[35470]='E18546'
G[35472]='K0790 L078 E18546'
G[35473]='K0800 L080 T:32273 E18546'
G[35474]='K0800 L080 T:26533 E18546'
G[35475]='K0760 L074 T:29306 E18546'
G[35476]='K0800 L080 T:29306 E18546'
G[35477]='K0800 L080 E18546'
G[35478]='T:31134 E18546'
G[35479]='E18546'
G[35480]='T:700155 E18546'
G[35481]='T:82303 E18546'
G[35482]='FA K0960 L096 A:82278 T:82375 P:35407+35408 E18612'	--	OTC:36183 -- TODO: Verify requires 35407
G[35483]='K0740 L072 T:27483 E18546'
G[35484]='K0800 L080 T:26632 E18546'
G[35486]='K0900 L090 A:84929 T:84929 P:36307+i176111 I:35750 E18612'
G[35487]='K0940 L092 A:82274 T:82274 P:35430 E18546'
G[35488]='K0900 L090 A:84929 T:84929 P:35486+35492+35494+i176111 I:35762 E18612'	-- TODO: Verify needs 35486 35492
G[35489]='T:29310 E18546'
G[35490]='T:29311 E18546'
G[35491]='T:80524 E18546'
G[35492]='K0900 L090 A:84929 T:84929 P:36307+i176111 I:35751 E18612'
G[35493]='T:30258 E18546'
G[35494]='K0900 L090 A:82447 T:82447 P:36307+i176111 I:35761 E18612'
G[35495]='K0900 L090 A:84929 T:84929 P:35486+35492+35494+i176111 I:35760 E18612'	-- TODO: Verify needs 35486 35492
G[35496]='K0900 L090 A:76111 T:76111 P:35486+35492+35494+i176111 I:35764 E18612'	-- TODO: Verify needs 35486 35492
G[35497]='K0720 L070 T:29120 E18546'
G[35498]='K0800 L080 T:29120 E18546'
G[35499]='K0900 L090 E19103'
G[35500]='K0900 L090 A:84929 T:84929 P:35488+35495+35496+i176111 I:35763 E18546'	-- TODO: Verify needs 35488 35495
G[35501]='K0940 L092 A:1232492 T:1232489 P:36488 I:35233 E18546'	-- removed T:82334
G[35502]='K0690 L068 T:23954 E18546'
G[35503]='T:82311 E18546'
G[35504]='K0000 L001 E18546'
G[35505]='K0920 L092 A:84811 T:82569 P:35707 I:36368 E18546'	-- 35653 also mark completed
G[35506]='K0920 L092 A:82574 T:582574 P:35707 I:35652 E18546'
G[35507]='K0940 L092 A:85601 T:82334 P:36488 I:35229 E18546'
G[35508]='K0920 A:82569 T:582574 P:35505 I:35654 E18546'
G[35509]='K0940 L092 A:85601 T:82334 P:36488 I:35234 E18546'
G[35510]='K0940 L092 A:82334 T:82337 P:35507+35509+35501 I:35235 E18546'
G[35511]='SP FH K0940 L092 A:82338 T:82338 P:35510+36793 U159 E18546'
G[35512]='K0800 L080 E18546'
G[35513]='K0710 L069 T:26723 E18546'
G[35514]='K0800 L080 T:26723 E18546'
G[35515]='K0800 L080 T:26796 E18546'
G[35517]='K0690 L067 T:16808 E18546'
G[35518]='K0700 L070 T:16808 E18546'
G[35519]='K0690 L067 T:18708 E18546'
G[35520]='K0700 L070 T:18708 E18546'
G[35521]='K0700 L068 E18546'
G[35522]='K0700 L070 T:17881 E18546'
G[35523]='T:82362 E18546'
G[35524]='K0920 L092 A:82569 T:582574 P:35505 I:35650 E18546'
G[35525]='K0690 L067 E18546'
G[35526]='K0700 L070 T:17977 E18546'
G[35527]='K0920 L092 A:82569 T:582574 P:35505 I:35651 E18546'
G[35528]='K0690 L067 T:19220 E18546'
G[35529]='K0700 L070 E18546'
G[35530]='E18546'
G[35531]='K0700 L068 E18546'
G[35532]='K0700 L070 T:-798 E18546'
G[35533]='K0700 L069 E18546'
G[35534]='K0700 L070 E18546'
G[35535]='K0700 L068 E18546'
G[35536]='K0940 L092 A:82274 T:82228 P:35487+36482 E18546'
G[35537]='FH K0960 L096 A:79627 T:78487 E18546'
G[35538]='K0700 L070 T:20912 E18546'
G[35539]='K0670 L065 T:18473 E18546'
G[35540]='K0700 L070 T:18473 E18546'
G[35541]='K0700 L070 E18546'
G[35542]='E18546'
G[35543]='T:18096 E18546'
G[35544]='K0650 L063 E18546'
G[35545]='K0700 L070 T:18373 E18546'
G[35546]='K0640 L062 T:18343 E18546'
G[35547]='K0700 L070 T:18344 E18546'
G[35548]='K0700 L070 E18546'
G[35549]='K0960 L096 A:82403 T:81929 P:35482 I:35550 E18612'
G[35550]='K0960 L096 A:82402 T:81920 P:36183 I:35549 E18612'
G[35551]='E18612'
G[35552]='K0910 L090 A:80073 T:1233229 P:34787 E18546'
G[35553]='E18546'
G[35554]='FA K0960 L096 A:79618 T:81492 E18546'
G[35555]='E18546'
G[35556]='FA K0930 L092 A:1232400 T:80978 I:33533 E18546'
G[35557]='FH K0920 L092 A:1232416 T:74594 P:1 I:34867 E18566'	-- removed A:78487
G[35558]='E18546'
G[35559]='K0630 L061 T:17882 E18546'
G[35560]='K0700 L070 T:700126 E18546'
G[35561]='K0620 L060 T:17942 E18546'
G[35562]='K0700 L070 T:17942 E18546'
G[35563]='K0440 L042 T:10813 E18546'	-- completed automatically killing 10813 (Balnazzar) at 765[1]:18.86,83.63
G[35564]='K0440 L042 T:10558 E18546'	-- completed automatically killing 10997 (Willey Hopebreaker) at 765[1]:3.60,50.18...actually it gets marked completed whenever any of the bonus objective bosses are completed
G[35565]='K0610 L059 T:17377 E18546'
G[35566]='K0700 L070 T:17377 E18546'
G[35567]='E18546'
G[35568]='E18546'
G[35569]='E18546'
G[35570]='E18546'
G[35571]='K1000 L000 E18546'
G[35572]='K0590 L058 T:17308 E18546'
G[35573]='K0700 L070 T:700099 E18546'
G[35574]='K0480 L046 T:45412 E18546'
G[35575]='K0480 L046 T:10435 E18546'
G[35576]='SP K000131072 A:1232571 T:1232571 E18546'
G[35577]='SP K000131072 A:1232584 T:1232584 E18546'
G[35578]='K1000 L100 E19027'
G[35579]='SP K000131072 A:1232590 T:1232590 E18546'
G[35580]='SP K000131072 A:1232592 T:1232592 E18546'
G[35581]='SP K000131072 A:1224756 T:1224756 E18546'
G[35582]='K0520 L050 T:5709 E18546'
G[35583]='SP K000131072 A:1232595 T:1232595 E18546'
G[35584]='SP K000131072 A:1232596 T:1232596 E18546'
G[35586]='K0150 L015 T:47739 E18546'
G[35587]='K0850 L085 E18546'
G[35588]='K0460 L044 E18546'
G[35589]='K0460 L044 T:7272 E18546'
G[35590]='E18546'
G[35591]='SP K000131072 A:1232598 T:1232598 E18546'
G[35592]='K0000 L000 E18546'
G[35593]='T:79708 E18546'
G[35594]='K0400 L038 T:59080 E18546'
G[35595]='K0900 L090 T:59080 E18546'
G[35596]='K1000 L099 T:80083 U170 E18612'
G[35597]='SP K000131072 A:1232406 T:1232406 E18546'
G[35598]='K0420 L040 T:74434 E18546'
G[35599]='E18546'
G[35600]='SP K000131072 A:1232621 T:1232621 E18546'
G[35601]='K0260 L024 T:7800 E18546'
G[35602]='K0260 L024 T:7361 E18546'
G[35603]='SP K000131072 A:1232624 T:1232624 E18546'
G[35604]='K0000 L000 E18546'
G[35605]='K0390 L035 E18546'
G[35606]='K0280 L026 T:59150 E18546'
G[35607]='K0280 L026 T:58632 E18546'
G[35608]='K0900 L090 T:59150 E18546'
G[35609]='K0900 L090 T:58632 E18546'
G[35610]='K0390 L035 T:7023 E18546'
G[35611]='K0960 L096 AA:579748 AH:79748 T:581770 P:35277,35286 E18612'
G[35612]='K0300 L028 T:-874 E18546'
G[35613]='K0900 L090 E18546'
G[35614]='SP FA K0910 L090 A:74741 T:74741 P:33038+36797 U179 E18546'
G[35615]='K0320 L030 T:700226 E18546'
G[35616]='SP K000131072 A:1232985 T:1232985 E18546'
G[35617]='SP FA K0910 L090 A:76204 T:76204 P:35015+36797 U180 E18546'
G[35618]='E18663'
G[35619]='K0970 L096 A:85550 T:81109 P:35286 I:35620,36861,36862 E18612'
G[35620]='K0970 L096 A:85566 T:81109 P:35277 I:35619,36861,36862 E18612'
G[35621]='K0910 L090 E18663'
G[35622]='T:82202 E18546'
G[35623]='T:82486 E18546'
G[35624]='SP A:70902 T:70902 P:33419 E18546 Z19033'
G[35625]='SP FA K0910 L090 A:76748 T:76748 P:33271+36797 U182 E18546'
G[35626]='E18612'
G[35627]='E18546'
G[35628]='E18612'
G[35629]='E18612'
G[35630]='E18546'
G[35631]='SP FA K0910 L090 A:575884 T:575884 P:33082+36797 U183 E18663'
G[35632]='K0980 L098 A:79201 T:79201 P:34809+34811 E18612'	-- TODO: Verify requires 34811
G[35633]='FA K0930 L092 A:80762 T:82476 O:35666 E18546'
G[35634]='K0960 L096 A:80157 T:82509 P:35273 E18612'	--TODO likely more prequests required
G[35635]='E19890'
G[35636]='K0960 L096 A:79890 T:82621 P:34659 E18612'
G[35637]='K1002 A:-941 T:77988 E18612'
G[35638]='SP K1001 L100 A:81870 T:81870 P:36133 E18702'
G[35639]='SP K1001 L100 A:81870 T:81870 P:36133 E18702'
G[35640]='FA K0930 L092 A:82499 T:82476 E18546'	--  P:O35633 was removed because the quest was available before accepting quest
G[35641]='K1002 A:79892 T:78578 E18612'
G[35642]='FA K0930 L092 A:100113260 T:82476 P:C35016,C35633 E18546'
G[35643]='E18546'
G[35644]='K0930 L092 A:82476 T:82476 P:35642+35640+35633 E18546'
G[35645]='K0930 L092 A:82476 T:82476 P:35642+35640+35633 E18546'
G[35646]='SP K000131072 A:1233033 T:1233033 E18546'
G[35647]='K0930 L092 A:82476 TP:82476:e35656;82477:E35656 P:35644+35645 E18546'
G[35648]='SP K000131072 A:1233034 T:1233034 E18546'
G[35649]='K09732768 L096 A:82403 T:85219 E18546'
G[35650]='K0920 L092 A:82569 T:85130 P:36368 I:35524 E18546'
G[35651]='K0920 L092 A:82569 T:85130 P:36368 I:35527 E18546'
G[35652]='K0920 L092 A:82575 T:85130 P:35708 I:35506 E18546'
G[35654]='K0920 A:82569 T:85130 P:36368 I:35508 E18546'
G[35656]='K0930 L092 A:82476 T:82477 P:35644+35645 E18546'
G[35659]='K0930 L092 A:82477 T:500137 P:35647+35656 E18546'
G[35660]='E18546'
G[35661]='T:78278 E18546'
G[35662]='E18546'
G[35663]='K0980 L098 A:79201 T:79201 P:34809+34811 E18612'	-- TODO: Verify requires 34811
G[35664]='K0930 L092 A:82610 T:582610 P:35686 E18546'
G[35665]='K0930 L092 A:582610 T:82832 P:35664+35693 E18546'
G[35666]='K0930 L092 AP:500136:35049;500137:35064 T:80762 P:35063 E18546'
G[35667]='K0930 L092 A:82732 T:81218 P:35151+0 E18566'	-- TODO: Does this need to be P:35151+34992 ?
G[35668]='K0960 L096 A:82621 T:81770 P:35636 E18612'
G[35669]='FH K097512 L096 A:1233099 T:81920 P:1 E18612'
G[35670]='FH K097512 L096 A:1233099 T:82622 P:1 I:35675 E18612'
G[35671]='K0960 L096 A:81770 T:80153 P:35668+34805+34756 E18612'	-- TODO: Verify requires 34805
G[35672]='FH K097512 L096 A:1233099 T:82612 P:1 E18612'
G[35673]='E18546'
G[35674]='FA K097512 L096 A:1233100 T:81929 P:35283 I:35669 E18612'	-- A:81929 removed
G[35675]='FA K097512 L096 A:1233100 T:82664 P:35283 I:35670 E18612'	-- A:81929 removed
G[35676]='FA K097512 L096 A:1233100 T:82669 P:35283 I:35672 E18612'	-- A:81929 removed
G[35677]='SP K000131072 A:1233101 T:1233101 E18546'
G[35678]='T:86398 E18546'
G[35679]='FA K1000 L100 A:83858 T:75028 P:>09711 E18912 D093'
G[35680]='FH K1000 L100 A:583858 T:76804 P:>09761 E18912 D098'
G[35681]='E18702'
G[35682]='E18546'
G[35683]='K1000 L100 A:75028 T:75028 P:35679 E18912'
G[35684]='K1000 L100 A:76804 T:76804 P:35680 E18912'
G[35685]='K1000 L100 A:75028 T:75028 P:35683 E18912'
G[35686]='K0930 L092 A:75127 T:82610 P:35063+35064 E18546'
G[35687]='K1000 L100 A:76804 T:76804 P:35684 E18912'	-- completes achievement "Fall of Shattrath"
G[35688]='P:35636 E18546'
G[35689]='SP K1001 L100 A:82660 T:82660 P:36133 E18716'
G[35690]='SP K1001 L100 A:82660 T:82660 P:36133 E18702'
G[35691]='SP K1001 L100 A:82660 T:82660 P:36133 E18702'
G[35692]='T:80595 E18546'
G[35693]='K0930 L092 A:82610 T:582610 P:35686 E18546'
G[35694]='SP K000131072 A:1233134 T:1233134 E18546'
G[35695]='SP K000131072 A:1233135 T:1233135 E18546'
G[35696]='E18546'
G[35697]='FH K0960 L096 A:82691 T:82574 P:1 I:37326 E18612'	-- TODO: Verify this still exists and I: correct
G[35698]='E19890'
G[35699]='FA K0960 L096 A:82709 T:82574 I:37327 E18612'	-- TODO: Verify this still exists and I: correct
G[35700]='E21463'
G[35701]='E18546'
G[35702]='FA K0930 L092 A:84131 T:75127 P:35139 E18546'
G[35703]='E18546'
G[35704]='K0960 L096 A:84262 T:500145 P:36085 E18645'
G[35705]='FH K0960 L096 A:82691 T:82713 P:1 E18612'
G[35706]='K0960 L096 A:82713 T:82713 P:35705 E18612'
G[35707]='K0920 L092 A:85077 T:82574 P:34992 E18546'
G[35708]='K0920 L092 A:85119 T:82575 P:35049 E18546'
G[35709]='E18546'
G[35711]='E18546'
G[35712]='T:82755 E18546'
G[35713]='FA K0960 L096 A:82709 T:82759 P:37329+35284 E18612'	-- TODO: requires picking the Alliance Smuggler's Den
G[35714]='T:82758 E18546'
G[35715]='SP K00065536 AK:82764 T:82764 E18546'
G[35716]='K0960 L096 A:82759 T:82759 P:35713 E18612'
G[35717]='T:82778 E18546'
G[35718]='K0960 L096 A:82713 T:82786 P:35706 E18612'
G[35719]='K0960 L096 A:82759 T:82788 P:1 E18612'
G[35720]='E18716'
G[35721]='E18546'
G[35722]='E18546'
G[35723]='E18716'
G[35724]='E18702'
G[35725]='E18546'
G[35726]='E18716'
G[35727]='E18546'
G[35728]='E18546'
G[35729]='E18702'
G[35730]='K0930 L092 A:82832 T:82832 P:35025,35665 E18566'
G[35731]='T:82326 E18546'
G[35732]='T:82415 E18546'
G[35733]='K0970 L096 A:500145 T:82813 P:34942 E18612'
G[35734]='K0970 L096 A:82813 T:500145 P:35733 E18612'
G[35735]='T:82826 E18546'
G[35736]='K1000 A:77995 T:78487 E18702'
G[35737]='K1000 A:82833 T:81492 E18612'
G[35738]='K0960 L096 A:82786 T:82786 P:35718 E18612'
G[35739]='K0960 L096 A:82788 T:82788 P:1 E18612'
G[35740]='E18716'
G[35741]='E18702'
G[35742]='E18546'
G[35743]='T:83439 E18546'
G[35744]='K0900 L090 A:85247 T:85247 P:35745+35746+i176111 I:35464 E18612'
G[35745]='FH K0900 L090 A:82851 T:82851 P:36499+37190+i176111,34446+i176111 I:35460 E18546'
G[35746]='FH K0900 A:82851 T:82851 P:34446|37190+i176111 I:35462 E18546'
G[35747]='K0900 L090 A:578563 T:80521 P:34437+34958+34987 E18546'
G[35748]='K0900 L090 A:82851 T:82851 P:35745+35746+i176111 I:35463 E18612'
G[35749]='E18546'
G[35750]='K0900 L090 A:84928 T:84928 P:36292+i176111 I:35486 E18612'
G[35751]='K0900 L090 A:84928 T:84928 P:36292+i176111 I:35492 E18612'
G[35752]='E18546'
G[35753]='E18546'
G[35754]='E18764'
G[35756]='E18764'
G[35758]='E18716'
G[35759]='SP K000131072 A:1233206 T:1233206 E18546'
G[35760]='K0900 L090 A:84928 T:84928 P:35750+35751+35761+i176111 I:35495 E18612'
G[35761]='K0900 L090 A:76609 T:76609 P:36292+i176111 I:35494 E18612'
G[35762]='K0900 L090 A:84928 T:84928 P:35750+35751+35761+i176111 I:35488 E18612'
G[35763]='K0900 L090 A:84928 T:84928 P:35760+35762+35764+i176111 I:35500 E18612'
G[35764]='K0900 L090 A:76609 T:76609 P:35750+35751+35761+i176111 I:35496 E18612'
G[35765]='T:82866 E18546'
G[35766]='K0960 L096 A:82786 T:82786 P:35718 E18612'
G[35767]='E18546'
G[35768]='E18702'
G[35770]='E18546'
G[35771]='E18546'
G[35772]='E18546'
G[35773]='E18738'
G[35774]='E18702'
G[35775]='E18702'
G[35777]='E18764'
G[35778]='E18546'
G[35779]='E18702'
G[35780]='E18702'
G[35781]='E18546'
G[35782]='K0960 L096 A:82788 T:82788 P:1 E18612'
G[35783]='E18546'
G[35784]='T:82912 E18546'
G[35785]='E18764'
G[35786]='K1000 L100 E18546'
G[35787]='K1000 L100 E18546'
G[35788]='E18546'
G[35789]='E18546'
G[35790]='E18702'
G[35792]='E18546'
G[35793]='E18833'
G[35794]='E18716'
G[35795]='E18716'
G[35796]='E18716'
G[35797]='K0960 L096 A:82786 T:82786 P:1 E18612'
G[35798]='SP K000131072 A:1233241 T:1233241 E18546'
G[35799]='E18702'
G[35800]='E18918'
G[35801]='E18702'
G[35802]='E18716'
G[35803]='E18702'
G[35804]='E18702'
G[35805]='E18702'
G[35807]='FH K0930 L092 A:81540 T:74594 P:35151 E18612'
G[35808]='FA K0930 L092 A:81540 T:75127 P:35063 E18546'
G[35809]='FA K0930 L092 A:81529 T:75127 P:35063 E18546'
G[35810]='FH K0930 L092 A:81529 T:74594 P:35151 E18546'
G[35811]='FH K0930 L092 A:100113448 T:74594 P:35151 E18546'
G[35812]='FA K0930 L092 A:100113449 T:75127 P:35063 E18546'
G[35813]='FA K0930 L092 A:100113453 T:75127 P:35063 E18546'
G[35814]='FH K0930 L092 A:100113454 T:74594 P:35151 E18546'
G[35815]='FH K0930 L092 A:81548 T:74594 P:35151 E18546'
G[35816]='FA K0930 L092 A:81548 T:75127 P:35063 E18546'
G[35817]='FA K0930 L092 A:75127 T:75127 P:35063 E18546'
G[35818]='FH K0930 L092 A:75127 T:74594 P:35151 E18546'
G[35819]='FH K0930 L092 A:100113461 T:74594 P:35151 E18546'
G[35820]='FA K0930 L092 A:100113461 T:75127 P:35063 E18546'
G[35821]='E18546'
G[35822]='E19027'
G[35823]='E18716'
G[35824]='E18546'
G[35826]='E18702'
G[35827]='E18716'
G[35828]='K0930 L092 A:80874 T:75136 P:35033 I:36595 E18546'
G[35829]='E18546'
G[35831]='E18716'
G[35833]='E18716'
G[35834]='K0930 L092 A:80922 T:80987 P:35033 E18546'
G[35835]='K0960 L096 A:82788 T:82788 P:1 E18612'
G[35836]='T:82975 E18546'
G[35837]='FA K1000 L100 A:81492 T:83051 P:34289+37517+34450+35685+34033+36290+35196+36169 I:35843 E18612'
G[35838]='K1000 L100 A:83051 T:83053 P:35837 I:35844 E18612'
G[35839]='K1000 L100 A:83053 T:81492 P:35838 I:35845 E18612'
G[35840]='K1000 L100 A:83053 T:81492 P:35838 I:35846 E18612'
G[35841]='K1000 L100 A:83053 T:81492 P:35838 I:35842 E18612'
G[35842]='K1000 L100 A:83054 T:578487 P:35844 I:35841 E18612'
G[35843]='FH K1000 L100 A:578487 T:83052 P:34319+37516+34450+33427+35687+34078+36290+35197 I:35837 E18612 D098'
G[35844]='K1000 L100 A:83052 T:83054 P:35843 I:35838 E18612'
G[35845]='K1000 L100 A:83054 T:578487 P:35844 I:35839 E18612'
G[35846]='K1000 L100 A:83054 T:578487 P:35844 I:35840 E18612'
G[35847]='E18546'
G[35848]='T:83504 E18702'
G[35849]='T:83504 E18702'
G[35850]='E18702'
G[35851]='E18702'
G[35852]='E18702'
G[35853]='E18702'
G[35854]='E18702'
G[35855]='E18702'
G[35856]='E18546'
G[35857]='E18546'
G[35858]='E18546'
G[35859]='E18702'
G[35860]='E18546'
G[35861]='FA K1000 L100 A:81492 T:77982 P:>09711 E18663 D093'
G[35862]='E18716'
G[35863]='E18716'
G[35865]='E18546'
G[35866]='E18612'
G[35867]='SP K1001 L100 A:82966 T:82966 P:36133 E18716'
G[35868]='SP K1001 L100 A:82966 T:82966 P:36133 E18716'
G[35869]='SP K1001 L100 A:82966 T:82966 P:36133 E18702'
G[35870]='K0930 L092 A:82816 T:81674 P:35730 E18566'
G[35871]='SP K1001 L100 A:82893 T:82893 P:36127 E18702'
G[35872]='SP K1001 L100 A:82893 T:82893 P:36127 E18702'
G[35873]='SP K1001 L100 A:82893 T:82893 P:36127 E18702'
G[35874]='E18546'
G[35875]='T:83409 E18546'
G[35876]='FH K1000 L100 A:578487 T:77982 P:>09761 E18645 D098'
G[35877]='T:83428 E18546'
G[35878]='K0960 L096 A:82759 T:82759 P:1 E18612'
G[35879]='K0960 L096 A:82713 T:82713 P:1 E18612'
G[35880]='K0930 L092 A:500133 T:81202 P:35151+35149 I:34992 E18566'
G[35881]='K09332768 L092 A:-140949 T:-949 E18566'
G[35882]='SP FH K0920 L092 A:77014 T:77014 P:34703+36793 U176 E18546'
G[35883]='SP FA K0920 L092 A:79337 T:79337 P:34703+36797 U176 E18546'	-- TODO: Needs more P: unless requiring the garrison is correct, then we are ok, as the Alliance toon testing has no garrison
G[35884]='FA K0900 L090 A:80521 T:78563 P:34445 E18546'
G[35885]='K0320 L030 AZ:750 T:-750 E18546'
G[35886]='K0340 L032 AZ:750 T:-750 E18546'
G[35887]='K0360 L034 AZ:750 T:-750 E18546'
G[35888]='K0360 L034 AZ:750 T:-750 E18546'
G[35889]='K0360 L034 AZ:750 T:-750 E18546'
G[35890]='K0380 L036 E18546'
G[35891]='K0410 L039 E18546'
G[35892]='K0440 L042 E18546'
G[35893]='T:83483 E18546'
G[35894]='K0410 L039 T:14368 E18546'
G[35895]='K0970 L096 A:82813 T:500145 P:35897 E18612'
G[35896]='K0970 L096 A:84122 T:500145 P:36059 E18702'
G[35897]='K0970 L096 A:500145 T:82813 P:35734 E18612'
G[35898]='T:83509 E18546'
G[35899]='K0490 L047 E18546'
G[35900]='T:83526 E18546'
G[35901]='K0490 L047 E18546'
G[35902]='K0530 L051 E18546'
G[35903]='K0530 L051 T:9029 E18546'
G[35904]='K0530 L051 T:8904 E18546'
G[35905]='K0910 L090 A:580079 T:77209 P:34788 E18546'
G[35906]='T:77310 E18546'
G[35907]='FH K0960 L096 A:83529 T:83608 P:37328 I:35915 E18612'
G[35908]='E18546'
G[35909]='E18546'
G[35910]='E18546'
G[35911]='K0820 L081 T:42333 E18546'
G[35912]='T:83542 E18546'
G[35913]='K0850 L085 T:42333 E18546'
G[35914]='K0900 L090 T:79609 E18612'
G[35915]='K0960 L096 A:83549 T:83609 P:37329+35283 I:35907 E18612'
G[35919]='SP K000131072 A:1224780 T:1224780 E18546'
G[35920]='E18546'
G[35921]='FA K0980 L098 A:583606 T:79188 P:35062 I:35922 E18612'
G[35922]='FH K0980 L098 A:83606 P:0 I:35921 E18612'	--TODO: Find P:
G[35923]='T:83603 E18546'
G[35924]='FH K0960 L096 A:83608 T:83772 P:35907 I:35926 E18612'
G[35925]='K0930 L092 A:1233391 T:80856 P:35026+35870 O:35218 E18546'
G[35926]='K0960 L096 A:83609 T:83773 P:35915 I:35924 E18612'
G[35927]='K1000 L100 E18716'
G[35928]='SP K1001 L098 A:82727 T:82727 E18612'	-- TODO: Inidcates probably needs in the inventory "Heart Soup Bone"
G[35929]='K0221 L020 AZ:688 T:-688 E18546'	-- TODO: Make available again once instance resets
G[35930]='K0221 L020 AZ:688 T:-688 E18546'	-- TODO: Make available again once instance resets
G[35931]='T:83634 E18546'
G[35932]='T:83643 E18546'
G[35933]='K0900 L090 A:78558 T:-970 P:34398,36881 I:34398 E18546'
G[35934]='K0930 L092 A:80856 T:80856 P:36508,35036 E18566'
G[35935]='K1000 L100 A:79774 T:79774 E18546'
G[35937]='K1000 L100 E18716'
G[35938]='K1000 L100 E18912'
G[35939]='K1000 L100 E18702'
G[35940]='K1000 L100 E18716'
G[35941]='K1000 L100 E18918'
G[35942]='K1000 L100 E18918'
G[35943]='T:83680 E18546'	-- kill Outrider Duretha (83680) 950:61.78,69.00
G[35944]='FA K0930 L092 A:100113586 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[35945]='K1000 L100 A:83686 T:83734 P:35985,36117 E18612'
G[35946]='T:75835 E18546'
G[35947]='FH K0960 L096 A:83772 T:83772 P:35924 I:35959 E18612'
G[35948]='FH K0930 L092 A:100113590 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[35950]='K0800 L080 T:35451 E18546'
G[35951]='T:80379 E18546'
G[35952]='E18546'
G[35953]='E18546'
G[35954]='T:86934 E18546'
G[35955]='E18546'
G[35956]='K0440 L042 E18546'
G[35957]='K0920 L090 T:74790 E18546'
G[35958]='K0940 L091 E18546'
G[35959]='K0960 L096 A:83773 T:83773 P:35926 I:35947 E18612'
G[35960]='K0960 L094 T:77734 E18546'
G[35961]='K0990 L096 T:76266 E18546'
G[35962]='K1000 L100 T:76407 E18612'
G[35963]='K1000 L100 T:77120 E18612'
G[35964]='T:76668 E18546'
G[35965]='E18546'
G[35966]='E18546'
G[35967]='E18546'
G[35968]='E18546'
G[35969]='SP K000131072 A:1233511 T:1233511 E18546'
G[35970]='K1000 L100 A:83734 T:83734 P:35945 E18612'
G[35971]='E18546'
G[35972]='K1000 L100 A:83734 T:83734 P:35945 E18612'
G[35973]='K1000 L100 A:76508 T:76508 P:37511 E18612'
G[35974]='K1002 L100 A:-971 T:78550 E18716'
G[35975]='SP K000131072 A:1233520 T:1233520 P:35049,34992 E18546'
G[35976]='T:83791 E18546'
G[35977]='K1000 L100 A:83823 T:78999 P:1 E18716'
G[35979]='E18546'
G[35980]='E18546'
G[35981]='SP K000131072 A:1233505 T:1233505 P:35049,34992 E18546'
G[35982]='SP K000131072 A:1233525 T:1233525 P:35049,34992 E18546'
G[35983]='E18546'
G[35984]='E18546'
G[35985]='FA K1000 L100 A:88892 T:83686 P:>09711 E18850 D093'
G[35986]='E18546'
G[35987]='SP K000131072 A:1233539 T:1233539 E18546'
G[35988]='K1004096 L098 AA:83858 AH:583858 T:83823 I:39018 E18912'	-- OTC:36426
G[35989]='K1000 L098 A:83823 T:83823 P:36157 E18912'
G[35990]='K1000 L098 A:83823 T:83823 P:35989 E18912'
G[35991]='K1000 L098 A:83823 T:83823 P:35989 E18912'
G[35992]='K1000 L098 A:83823 T:83823 P:35989 E18912'
G[35993]='K1004096 L098 A:83823 T:83823 P:35990+35991+35992 E18912'
G[35994]='K1004096 L098 A:83823 T:83823 P:35993+36158 E18912'
G[35995]='K1004096 L098 A:584702 T:584702 P:36206 E18912'
G[35996]='E18546'
G[35997]='K1004096 L100 A:83823 T:83823 P:36004 E18912'
G[35998]='K1004096 L100 A:83823 T:83823 P:36004 E18912'
G[35999]='SP K000131072 A:1233549 T:1233549 E18546'
G[36000]='K1004096 L098 A:83823 T:84702 P:35994 E18912'
G[36001]='E18546'
G[36002]='SP K000131072 A:1233551 T:1233551 E18546'
G[36003]='E18546'
G[36004]='K1004096 L100 A:584702 T:83823 P:35995 E18912'
G[36005]='K1004096 L100 A:83823 T:83929 P:35998 E19342'
G[36006]='K1004096 L100 A:83929 T:83929 P:36005 E19342'
G[36007]='K1004096 L100 A:583823 T:83823 P:36006 E19342'
G[36008]='SP K000131072 A:1233555 T:1233555 E18546'
G[36009]='K1004224 L100 A:83823 T:83823 P:36007 E19342'
G[36010]='K1004224 L100 A:83823 T:83823 P:36007 E19342'
G[36011]='SP K000131072 A:1233557 T:1233557 P:35049,34992 E18546'
G[36012]='K1004224 L100 A:83823 T:83823 P:36007 E19342'
G[36013]='K1004224 L100 A:83823 T:83823 P:36007 E19342'
G[36014]='K1004224 L100 A:83823 T:83823 P:36009+36010+36012 E19596'	-- TODO: Verify requires 36009 36010
G[36015]='E18546'
G[36016]='K1004096 L100 A:83823 T:83823 P:36013+36014 E19906'	-- TODO: Verify requires 36014
G[36017]='K1004096 L100 A:83823 T:83823 P:36016 E19890'
G[36018]='K1004096 L100 E19906'
G[36019]='SP K000131072 A:1233559 T:1233559 P:35049,34992 E18546'
G[36020]='SP K000131072 A:1233560 T:1233560 E18546'
G[36021]='SP K000131072 A:1233561 T:1233561 E18546'
G[36022]='FH K0960 L096 A:83772 T:83772 P:35924 I:36023 E18612'
G[36023]='K0960 L096 A:83773 T:83773 P:35926 I:36022 E18612'
G[36024]='K1000 L100 E18702'
G[36025]='K1000 L100 E18716'
G[36026]='K1000 L100 E18702'
G[36027]='SP K1000 L100 A:77853 T:77853 P:34472 U190 E18702'
G[36028]='FH K0960 L096 A:83772 T:83899 P:35947+36022 I:36029 E18612'	-- TODO: verify if both are needed
G[36029]='K0960 L096 A:83773 T:83900 P:36023+35959 I:36028 E18612'	-- TODO: Verify requires 35959
G[36030]='K1000 L100 E18702'
G[36031]='K1000 L100 E18716'
G[36032]='K1000 L100 E18716'
G[36033]='K1000 L100 E18833'
G[36034]='K1000 L100 E18918'
G[36035]='E18546'
G[36036]='E18546'
G[36037]='SP K0930 L092 A:83820 T:83820 U193 E18546'
G[36038]='K1000 L100 E19027'
G[36039]='SP K000131072 A:1233611 T:1233611 E18546'
G[36040]='K1000 L100 E18912'
G[36041]='K1000 L100 E18850'
G[36042]='K1000 L100 E18702'
G[36046]='SP K000131072 A:1233613 T:1233613 E18546'
G[36047]='FH K0960 L096 A:83899 T:83903 P:36028 I:36048 E18612'
G[36048]='K0960 L096 A:83900 T:83904 P:36029 I:36047 E18612'
G[36049]='E18546'
G[36050]='SP K000131072 A:1233623 T:1233623 E18546'
G[36051]='T:86946 E18546'
G[36052]='E18546'
G[36053]='E18546'
G[36054]='SP K1002 L100 A:87391 T:87391 E18612'
G[36055]='SP K1002 L100 A:87391 T:87391 E18612'
G[36056]='SP K1002 L100 A:87391 T:87391 E18612'
G[36057]='SP K1002 L100 A:87391 T:87391 E18612'
G[36058]='T:80964 E18612'
G[36059]='K0960 L096 A:80153 T:84122 P:35895 E18702'
G[36060]='E19027'
G[36061]='E19890'
G[36062]='SP K0960 L096 A:82468 T:82468 P:35298 U192 E18612'	-- TODO: Can both factions get this?  if so, put both garrisons...
G[36063]='FH K1001 L100 A:83995 T:83995 P:36198 E18645'
G[36064]='FH K1001 L100 T:83995 P:36198 E18702'
G[36065]='FH K1001 L100 P:36198 E18702'
G[36066]='SP FH K1001 L100 A:83997 T:83997 E18702'
G[36067]='SP FH K1001 L100 A:83997 T:83997 E18702'
G[36068]='SP FH K1001 L100 A:83997 T:83997 E18702'
G[36069]='K1000 L100 A:87992 T:89063 E18612'
G[36070]='K1000 L100 E18702'
G[36071]='SP K000131072 A:1233641 T:1233641 E18546'
G[36072]='SP K000131072 A:1233642 T:1233642 E18546'
G[36073]='SP K000131072 A:1233645 T:1233645 E18546'
G[36074]='SP K000131072 A:1233649 T:1233649 E18546'
G[36075]='FA K0930 L092 A:100114018 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36076]='FH K0930 L092 A:100114019 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18912'
G[36077]='T:86934 E18546'
G[36078]='FA K0930 L092 A:100114020 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36079]='E18546'	-- TODO:	Determine how this was magically completed when wandering SMV before doing quests, but accepting automatically 34575, and having it automatically dropped when leaving area
G[36080]='FH K0930 L092 A:100114021 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36081]='FA K0930 L092 A:100114022 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36082]='SP K000131072 A:1233651 T:1233651 E18546'
G[36083]='FH K0930 L092 A:100114023 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18702'
G[36084]='FA K0930 L092 A:100114024 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36085]='K0960 L096 A:84276 T:84262 P:35009 E18612'
G[36086]='FH K0930 L092 A:100114025 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18716'
G[36088]='SP K000131072 A:1233658 T:1233658 E18546'
G[36089]='E18546'
G[36090]='FA K0930 L092 A:100114026 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36091]='FH K0930 L092 A:100114027 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36092]='FA K0930 L092 A:100114029 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36094]='FH K0930 L092 A:100114030 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36095]='K1000 L100 E18612'
G[36096]='FA K0930 L092 A:100114031 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36097]='FH K0930 L092 A:100114032 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18702'
G[36098]='FA K0930 L092 A:100114033 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36099]='T:82561 E18546'
G[36100]='FA K0900 L090 AP:77209:=09711;577209:=09712;500138:=09713 TP:77209:=09711;577209:=09712;500138:=09713 P:K100109258,K100111812,K100111813,K100111814,K100111815,K100111816,K100111817,K100111818,Z156522,Z161386,Z161387,Z161388,Z161389,Z161390,Z161391,Z161392 I:37667,37669 E18546'
G[36101]='FH K0930 L092 A:100114034 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18912'
G[36102]='T:80056 E18546'
G[36103]='FA K0930 L092 A:100114035 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36104]='FH K0930 L092 A:100114036 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36105]='FA K0930 L092 A:100114037 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36106]='FH K0930 L092 A:100114038 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36107]='K0930 L092 T:81076 E19342'
G[36108]='K0930 L092 E19342'
G[36109]='SP K000131072 A:1233715 T:1233715 P:K100114054 E18546'
G[36111]='T:90851 E18546'
G[36112]='T:90851 E18546'
G[36113]='E18612'
G[36115]='SP K000131072 A:1233768 T:1233768 E18546'
G[36116]='SP K000131072 A:1233773 T:1233773 E18546'
G[36117]='FH K1000 L100 A:588892 T:83686 P:>09761 E18912 D098'
G[36118]='E18546'
G[36119]='FA K1000 L100 A:-100978 T:84173 E18546'
G[36123]='K1000 L100 A:82909 T:82909 E18546'
G[36124]='E18546'
G[36125]='K1000 L100 A:82909 T:82909 E18546'	-- TODO: Make available once the specific requirement to talk to Chris Clarkie in quest 36130 is satisfied
G[36127]='K1000 L100 A:82901 T:82901 E18546'	-- TODO: Make available once the specific requirement to talk to Farseer Kylanda in quest 36130 is satisfied
G[36128]='T:80057 E18546'
G[36129]='E18546'
G[36130]='K1000 L100 A:84173 T:84173 E18546'
G[36131]='K0000 L094 A:79896 T:79896 P:36141 I:36201 E18546'
G[36132]='K0000 L094 A:79896 T:79892 P:36131 I:36202 E18546'
G[36133]='K1000 L100 A:84223 T:82966 E18612'
G[36134]='FA K1000 L100 A:81492 T:84145 P:36162 E19445'
G[36135]='E18546'
G[36136]='FH K1000 L100 A:578487 T:88530 P:36248 E19445'
G[36137]='FH K0000 L090 A:84247 T:84247 P:G-040 E18546'	-- for the Horde boost to 100, not available until Tanaan output founded, so P:37935 needs to be added.  how to detect boosted?
G[36138]='K0000 L090 A:84247 T:84247 P:36137+G-040 E18546'
G[36139]='K0860 L085 E18546'
G[36140]='K0880 L085 E18546'
G[36141]='K0000 L094 A:79896 T:79896 P:34758 I:36199 E18546'
G[36142]='FH K0000 L090 A:84247 T:84247 P:36138+G-041 E18612'
G[36143]='K0710 L068 E18546'
G[36144]='K0750 L073 E18546'
G[36145]='K0810 L080 E18546'
G[36146]='K0840 L080 E18546'
G[36147]='K0860 L085 E18546'
G[36148]='K0880 L085 E18546'
G[36149]='K0710 L068 E18546'
G[36150]='K0750 L073 E18546'
G[36151]='K0810 L080 E18546'
G[36152]='K0840 L080 E18546'
G[36153]='T:94472 E18612'
G[36154]='E18612'
G[36155]='E18612'
G[36157]='K1004096 L098 A:83823 T:83823 P:35988 E18912'
G[36158]='K1004096 L098 A:83823 T:83823 P:35989 E18912'
G[36159]='T:84263 E18546'
G[36160]='FA K1000 L100 AP:77209:=09711;577209:=09712;500138:=09713 T:84270 P:34410 E19533'
G[36161]='K1000 L100 A:84684 T:84511 P:36160 E19533'
G[36162]='K1000 L100 A:84511 T:84268 P:36161 E19533'
G[36163]='FA K1000 L100 A:82776 T:500160 P:>09711 E18912 D093'
G[36164]='K1000 L100 A:500161 T:84973 P:36163 E18912'
G[36165]='K0960 L096 A:83904 T:84261 P:36048 I:36166 E18612'
G[36166]='FH K0960 L096 A:83903 T:84259 P:36047 I:36165 E18612'
G[36167]='K1000 L100 A:500162 T:84975 P:36163 E18912'
G[36168]='K1000 L100 A:500163 T:84974 P:36163 E18912'
G[36169]='K1000 L100 A:84974 T:84974 P:36164+36167+36168 E18912'	-- TODO: Verify requires 36167 36168
G[36170]='E18546'
G[36171]='K1000 L100 E19342'
G[36172]='E18612'
G[36174]='T:84347 E18546'
G[36176]='FA K0900 L090 A:100114877 T:84385 P:PL001+E34019 E18546'
G[36177]='K0900 L090 A:84385 T:84385 P:36176 E18546'
G[36178]='T:84406 E18546'
G[36179]='K0970 L096 A:85062 T:81128 E18612'
G[36182]='FH K0000 L090 A:84247 T:84247 P:G0138 E18716'
G[36183]='K0960 L096 A:82278 T:82375 P:35407+35408 E18612'	--very likely both quests required
G[36184]='E18546'
G[36185]='K0900 L090 A:84385 T:84492 P:36177 E18702'
G[36186]='T:84431 E18546'
G[36188]='E18546'
G[36189]='FA K0000 L090 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:G-040 E18546'
G[36192]='K0000 L090 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:36189+G-040 E18546'
G[36193]='FA K1000 L100 A:84459 T:84459 E18912'
G[36194]='FA K0000 L090 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:36189+G-041 E18612'
G[36195]='FA K0000 L090 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:G0138 E18716'
G[36196]='K1000 L100 T:84473 E18546'	-- TODO: Autoaccept entering Ashran combat zone
G[36197]='K1000 L100 A:84473 T:84473 P:36196 E18546'
G[36198]='FH K1000 L100 A:88448 T:83995 E18546'
G[36199]='K0000 L094 A:84372 T:84372 P:34194 I:36141 E18546'
G[36201]='K0000 L094 A:84372 T:84372 P:36199 I:36131 E18546'
G[36202]='K0000 L094 A:84372 T:77733 P:36201 I:36132 E18546'
G[36203]='T:81548 E18546'
G[36204]='T:80868 E18546'
G[36205]='FH K0900 L090 A:100114965 T:78989 P:PB001 E18546'
G[36206]='K1004096 L098 A:84702 T:584702 P:36000 E18912'
G[36207]='K0900 L090 A:78989 T:84494 P:36205 E18612'
G[36208]='K0930 L092 A:500159 T:500159 P:36508 E18546'
G[36209]='K0930 L092 A:500159 T:500159 P:36208+36210+35925 E18546'	-- TODO: Verify requires 36208
G[36210]='K0930 L092 A:500159 T:500159 P:36508 E18546'
G[36211]='E18546'
G[36212]='E18546'
G[36213]='E18546'
G[36214]='E18546'
G[36219]='K1000 L100 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:X34666+X36566+>09711|>09761 I:36280,36281,36282 E18612 D093 D098'
G[36220]='K1000 L100 A:84637 T:84720 P:36219,36280,36281,36282 E18612'
G[36221]='K1000 L100 A:84720 T:84784 P:36220 E18612'
G[36222]='K1000 L100 A:84784 T:84784 P:36221 E18612'
G[36223]='K0930 L092 A:500159 T:84131 P:36209 E18546'
G[36226]='K1000 L100 A:84660 T:84660 E18612'
G[36227]='K1000 L100 A:83869 T:83869 E18612'
G[36228]='K1000 L100 A:83869 T:83869 P:36227 E18702'
G[36229]='T:84435 E18546'
G[36230]='K0900 L090 A:84494 T:84494 P:36207 E18612'
G[36236]='FA K0900 L090 A:100114972 T:84776 P:PT001+E34019 E18546'
G[36238]='K0900 L090 A:84494 T:78989 P:36230 E18612'
G[36239]='FA K0900 L090 A:100114984 T:84724 P:PI001+E34019 E18546'
G[36240]='K0900 L090 A:84724 T:84724 P:36239 E18702'
G[36241]='K0900 L090 A:84724 T:84728 P:36240 E18716'
G[36242]='K1000 L100 A:-100976 T:579740 P:36261 E19533'
G[36243]='T:-948 E18546'
G[36244]='SP K000131072 A:1234154 T:1234154 E18546'
G[36245]='E18546'
G[36246]='SP K000131072 A:1234157 T:1234157 E18546'
G[36247]='SP K000131072 A:1234159 T:1234159 E18546'
G[36248]='K1000 L100 A:579740 T:579740 P:36242 E19533'	-- A Strike at the Heart, the Warlord Council completed
G[36249]='E18546'
G[36250]='E18546'
G[36251]='E18546'
G[36252]='E18546'
G[36254]='E18546'
G[36255]='FH K0900 L090 A:100115008 T:83482 P:PE001 E18546'
G[36256]='K0900 L090 A:83482 T:84739 P:36255 E18612'
G[36257]='K0900 L090 A:84739 T:84747 P:36256 E18612'
G[36260]='K0900 L090 A:84747 T:84739 P:36257 E18612'
G[36261]='FH K1000 L100 A:579740 T:-100976 P:34341 E19533'
G[36262]='K0900 L090 A:84776 T:84523 P:36236 E18612'
G[36263]='E18546'
G[36265]='T:84805 E18546'
G[36266]='K0900 L090 A:84523 T:84523 P:36262 E18612'
G[36267]='T:84807 E18546'
G[36268]='E18546'
G[36269]='K0900 L090 A:84523 T:84523 P:36266 E18702'
G[36271]='FA K0000 L090 AP:84524:G-024022;584524:G-024025 TP:84524:G-024022;584524:G-024025 P:G-024 E18612'
G[36272]='FA K0000 L093 AP:84524:G-024022;584524:G-024025 TP:84524:G-024022;584524:G-024025 P:G-025 E18702'
G[36273]='K0980 L098 A:84632 T:84632 E18612'	-- no known prequest
G[36274]='FA K0000 L098 AP:84524:G-024022;584524:G-024025 TP:84524:G-024022;584524:G-024025 P:G0133 E18833'
G[36275]='K0980 L098 A:84861 T:84861 P:35146 E18612'
G[36276]='E18546'
G[36277]='K1000 L100 T:84554 E18612'
G[36278]='T:84836 E18546'
G[36279]='T:84838 E18546'
G[36280]='K1000 L100 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:34666+X36566+>09711|>09761 I:36219,36281,36282 E18612 D093 D098'
G[36281]='K1000 L100 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:X34666+36566+>09711|>09761 I:36219,36280,36282 E18612 D093 D098'
G[36282]='K1000 L100 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:34666+36566+>09711|>09761 I:36219,36280,36281 E18612 D093 D098'
G[36283]='E18546'
G[36284]='K0980 L098 A:84861 T:84861 P:35146 E18612'
G[36285]='K0980 L098 A:84861 T:84861 P:36275+36284 E18612'
G[36286]='K0900 L090 A:100115278 T:84825 P:PN001+E34019 E18546'
G[36287]='K0900 L090 A:84825 T:84825 P:36286 E18612'
G[36288]='E18546'
G[36289]='FA K1000 L100 A:84784 T:81492 P:36222 E18612'
G[36290]='FH K1000 L100 A:84784 T:78487 P:36222 E18612'	-- completes achievement "The Ring of Blood"
G[36291]='E18546'
G[36292]='K0900 L090 A:82851 T:84928 P:35744+35748+i176111 I:36307 E18612'
G[36293]='E19342'
G[36294]='K0900 L090 T:79703 E18546'
G[36295]='K0900 L090 T:94399 E18546'
G[36296]='K0000 L090 T:84892 E18716'
G[36297]='T:84890 E18546'
G[36298]='E18546'
G[36301]='FH K0900 L090 A:100114973 T:84689 P:PT001 E18546'
G[36303]='E18546'
G[36304]='E18546'
G[36305]='T:84951 E18546'
G[36306]='E18546'
G[36307]='K0900 L090 A:82270 T:84929 P:35463+35464+i176111 I:36292 E18612'	-- TODO: Verify needs 35463
G[36308]='K0900 L090 A:100115281 T:83491 P:PE001+E34019 E18546'
G[36309]='FA K0900 L090 A:100115343 T:80827 P:PB001+E34019 E18546'
G[36310]='K0900 L090 A:83491 T:84966 P:36308 E18612'
G[36311]='K0900 L090 A:80827 T:80827 P:36309 E18612'
G[36312]='E18546'
G[36313]='K0900 L090 A:84966 T:84963 P:36310 E18645'
G[36314]='FH K0900 L090 A:100115287 T:84967 P:PJ001 E18546'
G[36315]='K0900 L090 A:84963 T:84966 P:36313 E18645'
G[36316]='K09764 L097 A:500145 T:500145 P:35704 E18612'
G[36317]='E18546'
G[36318]='E18546'
G[36319]='E18546'
G[36320]='E18546'
G[36321]='E18546'
G[36322]='E18546'
G[36323]='E18546'
G[36324]='E18546'
G[36325]='E18546'
G[36326]='E18546'
G[36327]='E18546'
G[36328]='E18546'
G[36329]='E18546'
G[36330]='E18546'
G[36331]='E18546'
G[36332]='E18546'
G[36333]='E18546'
G[36334]='E18546'
G[36335]='E18546'
G[36336]='E18546'
G[36337]='E18546'
G[36338]='K1002 L100 A:79892 E18612'
G[36340]='SP K000131072 A:1234432 T:1234432 E18546'
G[36341]='K1000 L100 A:84185 T:84268 P:36134 U217 E19533'
G[36342]='K1000 L100 A:88530 T:579740 P:36136 U217 E19533'
G[36343]='E18612'
G[36344]='FH K0000 L093 AP:85048:G-024022;585048:G-024025 TP:85048:G-024022;585048:G-024025 P:G-025 E18663'
G[36345]='FH K0000 L090 AP:85048:G-024022;585048:G-024025 TP:85048:G-024022;585048:G-024025 P:G-024 E18612'
G[36346]='FH K0000 L098 AP:85048:G-024022;585048:G-024025 TP:85048:G-024022;585048:G-024025 P:G0133 E18833'
G[36347]='K1000 L100 E18716'
G[36348]='K1000 L100 A:84784 E18702'
G[36352]='K0900 L090 A:84967 T:85106 P:36314 E18612'
G[36353]='SP K0960 L096 A:85080 T:85080 P:35482+36797|36793 I:36864 U204 E18612'
G[36354]='E18546'
G[36355]='SP K000131072 A:1234449 T:1234449 E18546'
G[36356]='E18546'
G[36358]='E18546'
G[36359]='SP K000131072 A:1234454 T:1234454 E18546'
G[36360]='SP K000131072 A:1234455 T:1234455 E18546'
G[36361]='SP K000131072 A:1234456 T:1234456 E18546'
G[36362]='SP K000131072 A:1234458 T:1234458 E18546'
G[36363]='E18546'
G[36364]='SP K000131072 A:1234461 T:1234461 E18546'
G[36365]='SP K000131072 A:1234471 T:1234471 E18546'
G[36366]='SP K000131072 A:1234472 T:1234472 E18546'
G[36367]='SP K000131072 A:1234473 T:1234473 E18546'
G[36368]='K0920 L092 A:82575 T:82569 P:35708 I:35505 E18546'	-- OTC:35653
G[36374]='E18546'
G[36375]='SP K000131072 A:85190 T:85190 E18546'
G[36376]='K1000 L100 A:78564 T:-971 E18612'
G[36377]='SP K000131072 A:85206 T:85206 E18546'
G[36378]='K0900 L090 A:85106 T:85106 P:36352 E18645'
G[36379]='FA K0900 L090 A:85213 T:85213 P:35884|37196+i176111 I:37677,36382 E18612'
G[36380]='K0900 L090 A:85106 T:85106 P:36378 E18612'
G[36381]='SP K000131072 A:1234618 T:1234618 P:I170183 E18546'
G[36382]='K0900 L090 A:85247 T:85247 P:34446|37190+i176111 E18612'
G[36383]='FA K1002 L100 A:-947 T:85124 E19116'
G[36384]='K0970 L096 A:81443 T:81443 P:35285 E18612'
G[36385]='K0000 L090 A:100115467 TA:84248 TH:84247 P:0 E18612'	--TODO: still in game? does it require conditions?
G[36386]='E18546'
G[36387]='E18546'
G[36388]='SP K000131072 A:3234618 T:3234618 P:I170183 E18546'
G[36389]='T:79598 E18546'
G[36390]='E18546'
G[36391]='T:81038 E18546'
G[36392]='E18546'
G[36393]='E18546'
G[36394]='E18546'
G[36395]='SP K000131072 A:1234703 T:1234703 E18546'
G[36396]='T:84417 E18546'
G[36397]='SP K000131072 A:1234704 T:1234704 E18546'
G[36398]='SP K000131072 A:1234705 T:1234705 E18546'
G[36399]='SP K000131072 A:1234734 T:1234734 E18546'
G[36400]='SP K000131072 A:1234735 T:1234735 E18546'
G[36401]='SP K000131072 A:1234736 T:1234736 E18546'
G[36402]='SP K000131072 A:1234740 T:1234740 E18546'
G[36403]='SP K000131072 A:1234744 T:1234744 E18546'
G[36404]='FA K0000 L096 A:85344 T:85344 P:>09711 I:34193 E18546'
G[36405]='SP K000131072 A:1234746 T:1234746 E18546'
G[36406]='SP K000131072 A:1234748 T:1234748 E18546'
G[36407]='SP K000131072 A:1235073 T:1235073 E18546'
G[36408]='K0900 L090 A:100115507 T:84830 P:PJ001+E34019 E18546'
G[36409]='K0900 L090 A:84830 T:84830 P:36408 E18702'
G[36410]='SP K000131072 A:1235090 T:1235090 E18546'
G[36411]='SP K000131072 A:1235091 T:1235091 E18546'
G[36412]='K1000 L100 A:78564 T:78564 E19243'
G[36413]='E18546'
G[36414]='K1000 L100 E19342'
G[36415]='E18546'
G[36416]='SP K000131072 A:1235095 T:1235095 E18546'
G[36417]='K0900 L090 A:84689 T:84689 P:36301 E18612'
G[36418]='SP K000131072 A:1235097 T:1235097 E18546'
G[36419]='K0900 L090 A:84689 T:84689 P:36417 E18612'
G[36420]='SP K000131072 A:1235103 T:1235103 E18546'
G[36421]='SP K000131072 A:1235104 T:1235104 E18546'
G[36422]='SP K000131072 A:1235105 T:1235105 E18546'
G[36423]='FA K00016384 L098 A:85418 T:85418 P:>09712 E18612'
G[36424]='E18546'
G[36425]='K0960 L096 A:85425 T:-948 P:34827 E18612'
G[36426]='T:700081 E18546'
G[36427]='SP FH K0000 L090 A:85379 T:85379 P:G-040+36793 U195 E18612'
G[36428]='K0970 L096 A:81443 T:81443 P:35089+35090+36384 E18612'	-- TODO: Verify requires 35090 36384
G[36429]='SP FA K0000 L090 A:85378 T:85378 P:G-040+36797 U195 E18546'
G[36430]='E18546'
G[36431]='E18546'
G[36432]='K0930 L092 A:75146 AP:500136:35049;500137:35064 T:85426 P:35063 E18546'
G[36433]='SP K000131072 A:1235135 T:1235135 E18546'
G[36434]='K0930 L092 A:574594 T:85147 P:33593 E18566'
G[36435]='FH K0900 L090 A:100115593 T:85439 P:PI001 E18546'
G[36436]='K0930 L093 A:85426 T:85432 E18546'
G[36437]='K0930 L093 A:85426 T:85432 O:36432 E18546'
G[36438]='K0930 L093 A:85432 T:85431 P:36436+36437+35064 E18546'	-- TODO: Verify requires 36437--I:33662
G[36439]='K0930 L093 A:85432 T:85431 P:36436+36437+35049 E18546'	-- TODO: Verify requires 36437
G[36440]='K0930 L093 AP:85431:35064;585431:35049 T:85436 P:36438,36439 E18546'
G[36441]='K0930 L093 AP:1234474:35064;500257:35049 T:85436 P:36438,36439 E18546'	-- TODO: note that when this was complete before 36440 was also complete, it appeared in the world that it could be turned in to T:85431 (at least for the Sparring Arena path), but once both complete, NPC moved
G[36442]='K0930 L093 A:85436 T:82302 P:36440 E18546'
G[36443]='K0930 L093 A:82302 T:82302 P:36442 E18546'
G[36444]='SP K000131072 A:1235141 T:1235141 E18546'
G[36445]='SP K000131072 A:1235143 T:1235143 E18546'
G[36446]='SP K000131072 A:1235168 T:1235168 E18546'
G[36447]='SP K000131072 A:1235172 T:1235172 E18546'
G[36448]='K0000 L090 AP:85413:G-040025;585413:G-040022 TP:85413:G-040025;585413:G-040022 P:36429+G-040 E18546'
G[36449]='K0000 L090 AP:85414:G-040025;585414:G-040022 TP:85414:G-040025;585414:G-040022 P:36427+G-040 E18546'
G[36450]='SP K000131072 A:1235282 T:1235282 E18546'
G[36451]='SP K000131072 A:1235289 T:1235289 E18546'
G[36452]='E18546'
G[36453]='SP K000131072 A:1235299 T:1235299 E18546'
G[36454]='SP K000131072 A:1235300 T:1235300 E18546'
G[36455]='SP K000131072 A:1235307 T:1235307 E18546'
G[36456]='SP K000131072 A:1235310 T:1235310 E18546'
G[36457]='K0900 L090 A:85439 T:85440 P:36435 E18612'
G[36458]='SP K000131072 A:1235313 T:1235313 E18546'
G[36459]='E18546'
G[36460]='K0930 L092 A:85147 T:500132 P:36434 E18566'
G[36461]='E19596'
G[36462]='SP K000131072 A:1235365 T:1235365 P:K100116120 E18546'
G[36463]='E18546'
G[36464]='E18546'	-- completes when you use the treasure map for Shadowmoon Valley
G[36465]='E18546'	-- completes when you use the treasure map for Gorgrond (FA definitely)
G[36466]='E18546'	-- Talador treasure map
G[36467]='E18546'	-- completes when you use the treasure map for spires of arak (FA definitely)
G[36468]='E18546'	-- completes when you use the treasure map for Nagrand
G[36469]='K0000 L098 A:79858 P:38242 E18612'
G[36470]='E18546'
G[36471]='K0008194 L001 A:85519 T:85519 E18546'
G[36472]='SP K00065536 A:85520 T:85520 E18546'
G[36473]='K09232768 L092 A:-110949 T:-949 P:35049,34992 E18546'
G[36474]='K0930 L092 A:500133 T:74593 P:35151+34992 I:35149 E18546'
G[36475]='K0900 L090 A:85440 T:85440 P:36457 E18716'
G[36476]='K09232768 L092 A:-100949 T:-949 P:35049,34992 E18546'
G[36477]='K1000 L100 E18612'
G[36478]='E18546'
G[36479]='E18546'
G[36480]='K09332768 L092 A:-130949 T:-949 E18546'
G[36481]='K0002 L001 A:85546 T:85546 E18546'
G[36482]='K0940 L092 A:82274 T:82274 P:35430 I:36523 E18546'
G[36483]='K0000 L098 A:85418 T:86144 E18612'
G[36488]='K0940 L092 A:82228 T:85601 P:35434+35433 E18546'
G[36489]='K1000 L100 A:75593 T:86499 P:1 E18702'
G[36490]='K1002 L100 A:88026 T:85043 E18702'
G[36491]='K1000 L100 E18702'
G[36492]='T:90071 E18546'
G[36493]='T:81858 E18546'
G[36494]='FH K0940 L094 A:74594 T:78487 O:36573,36574 E18546'	-- TODO: This can also be accepted from 574594, 500132 and 500133	-- changed P:36573,36574 to O: because Horde boost to 100 gets this
G[36495]='FA K0940 L094 A:75127 T:81492 P:36576 E18546'	-- Blizzard gives this out even if you do not have a garrison.  And Blizzard marks the map with a yellow ? even if you do not have a garrison, course with no NPC present.
G[36496]='E19342'
G[36497]='E19533'
G[36498]='FA K0900 L090 A:1206111,1206294,1207320,1207321,1207322,1208316 T:82270 E18546'	-- TODO: Add the ability for this quest to be automatically accepted when attaining level 90, no matter where one is.
G[36499]='FH K0900 L090 A:1206109,1206116,1207279,1207323,1207324,1207325,1208317 T:82851 E18546'	-- same comment from 36498
G[36500]='K09232768 L092 A:82302 T:-949 P:35064,35149 E18566'
G[36501]='T:72761 E18546'
G[36502]='FA K0930 L092 A:100116159 T:75127 P:35063 E18546'
G[36503]='FH K0930 L092 A:100116159 T:74594 P:35151 E18546'
G[36504]='K09232768 L092 A:85418 T:-949 P:35064,35149 E18546'
G[36505]='FH K0900 L090 A:100116173 T:85751 P:PL001 E18546'
G[36506]='T:81729 E18546'
G[36507]='SP K000131072 A:1235860 T:1235860 E18546'
G[36508]='FA K0930 L092 A:83569 T:500159 P:35730+E35870|E35026 E18546'
G[36509]='T:86934 E18546'
G[36510]='K0002 L090 A:77733 T:77733 P:36202 E18612 D095'
G[36511]='K0002 L090 A:77733 T:77733 P:36202 E19027 D095'
G[36512]='SP K0940 L094 A:79434 T:79434 P:34154+36797,34564+36793 U205 E18612'
G[36513]='K0002 L090 A:77733 T:77733 P:36202 E18612 D095'
G[36514]='K0002 L090 A:77733 T:77733 P:36202 E18612 D095'
G[36515]='K0002 L090 A:77733 T:77733 P:36202 E18612 D095'
G[36516]='K0900 L090 A:85751 T:85751 P:36505 E18612'
G[36517]='K0002 L090 A:77733 T:77733 P:36202 E18612 D095'
G[36518]='SP FH K0940 L094 A:79979 T:79979 P:34776+36793 I:36519 U207 E18612'
G[36519]='SP FA K0940 L094 A:79979 T:79979 P:34777+36797 I:36518 U207 E18546'
G[36520]='K09332768 L092 A:-180949 T:-949 E18546'
G[36521]='E18546'
G[36522]='SP K0940 L094 AP:585777:=09711;85777:=09712 TP:585777:=09711;85777:=09712 P:33973+36797 U208 E18663'
G[36523]='K0940 L092 A:81600 T:81601 P:35208 I:36482 E18546'
G[36524]='E18546'
G[36525]='E18546'
G[36526]='E18546'
G[36527]='T:88674 E18546'
G[36528]='E18546'
G[36529]='T:92766 E18546'
G[36530]='E18546'
G[36531]='E18546'
G[36532]='T:-947 E18546'
G[36533]='T:92819 E18546'
G[36534]='E18546'
G[36535]='E18546'
G[36536]='E18546'
G[36537]='FA K1002 L100 A:1236206 T:500220 E18546 D109'
G[36538]='E18546'
G[36539]='T:86144 E18546'
G[36540]='E18546'
G[36541]='E18546'
G[36542]='E18546'
G[36543]='E18546'
G[36544]='E18546'
G[36545]='T:-947 E18546'
G[36546]='E18546'
G[36547]='E18546'
G[36548]='E18546'
G[36549]='T:88674 E18546'
G[36550]='E18546'
G[36551]='T:92766 E18546'
G[36552]='T:92819 E18546'
G[36553]='E18546'
G[36554]='E18546'
G[36555]='E18546'
G[36556]='FA K1002 L100 A:1236206 T:500220 E18546 D109'
G[36557]='T:86144 E18546'
G[36558]='E18546'
G[36559]='E18546'
G[36560]='T:90309 E18546'
G[36561]='T:90309 E18546'
G[36563]='K09232768 L092 A:-110949 T:-949 E18546'
G[36564]='K09232768 L092 A:81241 T:-949 P:35064,35149 E18546'
G[36566]='K09232768 L092 A:-170949 T:-949 P:35049,34992 E18546'
G[36567]='FH K0920 L090 A:78466 T:500154 P:L093 I:36592,J9545 E18566'	-- TODO: reported should be P:32795
G[36568]='E18546'
G[36569]='T:90071 E18546'
G[36570]='T:90071 E20444'
G[36571]='K09232768 L092 A:-160949 T:-949 E18546'
G[36572]='E19533'
G[36573]='FH K0930 L092 A:74594 T:74594 P:35152+35136 E18663'
G[36574]='FH K0920 L092 A:500133 T:500133 P:35416+35506+35508+35527+35524 E18663'
G[36575]='FA K0920 L092 A:75127 T:75127 P:35255+35652+35654+35651+35650 E18702'
G[36576]='FA K0930 L092 A:75127 T:75127 P:35702+35137 E18702'
G[36577]='E18546'
G[36587]='T:72761 E18546'
G[36588]='E18546'
G[36589]='FH K0900 L090 A:100116438 T:85882 P:PN001 E18612'
G[36590]='K09732768 L096 A:-140948 T:-948 E18612'	-- OTC:36859
G[36592]='FA K0920 L090 A:77209 T:577209 P:33814,L093 I:36567,J9100 E18612'	-- TODO: reported should be P:33586
G[36593]='E19027'
G[36594]='K0900 L090 A:85882 T:85882 P:36589 E18612'
G[36595]='K0930 A:75146 T:75136 P:E35065 I:35828 E18612'	-- TODO: This is available after NPC 75146 has moved to the spot near the tank...guessing when quest complete, but not turned in
G[36596]='T:81548 E18612'
G[36597]='T:85907 E18612'
G[36600]='E18612'
G[36601]='FA K0980 L098 A:580153 T:81492 I:36606 E18612'	-- seems 36602 and 36607 marked complete as well
G[36602]='FH K0980 L098 A:80153 T:78487 P:1 E18612'
G[36603]='K09332768 L092 A:-120949 T:-949 E18612'
G[36604]='E18612'
G[36605]='E18612'
G[36606]='FA K0980 L098 A:81929 T:81492 I:36601 E18612'
G[36607]='K0980 L098 A:81920 T:78487 E18612'
G[36608]='K0000 L094 AA:85708 AH:79971 T:63721 P:36870,36612 E18716'
G[36609]='FH K0000 L094 A:63721 T:79971 P:36608 E19342'
G[36610]='T:81548 E18612'
G[36611]='K0000 L094 AA:85984 AH:585984 TA:85984 TH:585984 P:36882,36609 E18716'	-- TODO: Make the Alliance/Horde separation for Nat
G[36612]='FH K0000 L094 A:79971 T:79971 P:PF700+G0135 E19027'
G[36614]='FH K1000 L100 A:78466 T:78466 I:36615 E18612'
G[36615]='FA K1000 L100 A:577209 T:500138 P:36592 I:36614 E18612'	-- TODO: available entering garrison at level 100
G[36616]='SP K0000 L094 AA:85984 AH:585984 TA:85984 TH:585984 P:36611+36797|36793 U202 E18716'
G[36617]='SP HZ K0000 L010 A:1187236 T:1187236 E18612'
G[36618]='T:84503 E18612'
G[36619]='E19027'
G[36620]='E18612'
G[36621]='E18612'
G[36623]='K1000 L100 E19342'
G[36624]='K0900 L090 A:79953 T:86065 P:34692 E18612'
G[36625]='SP K000131072 A:1236141 T:1236141 E18612'
G[36626]='K0900 L090 A:86065 T:86069 P:36624 I:36707 E18612'
G[36627]='K0900 L090 A:85882 T:85882 P:36594 E18612'
G[36628]='E18612'
G[36629]='K0900 L090 A:86069 T:86069 P:36626 I:36708 E18612'
G[36630]='FA K0900 L090 A:86069 T:86084 P:36629 I:36709 E18612'
G[36631]='E18612'
G[36632]='K0930 L092 E18702'
G[36633]='SP FA K0900 L090 A:86084 T:86084 P:36630+36797 U216 E18612'
G[36634]='T:81548 E18612'
G[36635]='E18612'
G[36636]='E18612'
G[36639]='E19890'
G[36640]='E18612'
G[36641]='FA K0900 L090 AP:77363:G-076018;577363:G-076019;500218:G-076020 TP:77791:G-076018;577791:G-076019;500219:G-076020 P:G-076 E18612'
G[36642]='FA K0900 L090 AP:77383:G-090018;577383:G-090019;500139:G-090020 TP:78207:G-090018;578207:G-090019;500140:G-090020 P:G-090 I:37574 E18612'
G[36643]='FA K0900 L090 AP:77382:G-094018;577382:G-094019;500223:G-094020 TP:77778:G-094018;577778:G-094019;500224:G-094020 P:G-094 E18612'
G[36644]='FA K0900 L090 AP:77356:G-096018;577356:G-096019;500157:G-096020 TP:77775:G-096018;577775:G-096019;500158:G-096020 P:G-096 E18612'
G[36645]='FA K0900 L090 AP:77354:G-093018;577354:G-093019;500155:G-093020 TP:77781:G-093018;577781:G-093019;500156:G-093020 P:G-093 I:37570 E18612'
G[36646]='FA K0900 L090 AP:77365:G-091018;577365:G-091019;500141:G-091020 TP:77831:G-091018;577831:G-091019;500142:G-091020 P:G-091 E18612'
G[36647]='K0900 L090 AP:77372:G-095018;577372:G-095019;500148:G-095020 TP:77777:G-095018;577777:G-095019;500149:G-095020 P:G-095 E18612'
G[36648]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36649]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36650]='K1000 L100 E19342'
G[36651]='T:80868 E18612'
G[36653]='K1000 L100 E19342'
G[36654]='T:86134 E18612'
G[36655]='K1000 L100 A:78564 T:-971,578564 E19116'	-- the A: can be 578564 for garrison level 3 as well
G[36656]='E18612'
G[36657]='T:-948 E18612'
G[36658]='T:81575 E18612'
G[36659]='E18702'
G[36660]='K09732768 L096 A:84122 T:85892 E18612'
G[36661]='E19533'
G[36662]='K0000 L098 A:79858 T:79858 P:0 E18612'
G[36663]='E18612'
G[36664]='T:90309 E18612'
G[36665]='E18612'
G[36666]='E18612'
G[36667]='K1000 L100 A:79892 T:78495 E18612'
G[36669]='FH K1000 L100 A:88026 T:78495 E18612'
G[36670]='K1000 L100 E18612'
G[36671]='K1000 L100 E18612'
G[36672]='K1000 L100 E18716'
G[36673]='K1000 L100 E18702'
G[36674]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36675]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36676]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36677]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36678]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36679]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36680]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36681]='K1000 L100 T:92819 E18612'
G[36682]='FA K1002 L100 A:1236206 T:500220 P:>09711 E18612 D109'
G[36683]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36684]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36685]='FA K1002 L100 A:1236206 T:500220 E18612 D109'
G[36686]='FA K1002 L100 A:1236206 T:500220 P:>09711 E18612 D109'
G[36687]='K1000 L100 T:92819 E18612'
G[36688]='K1000 L100 T:92819 E18612'
G[36689]='K1000 L100 T:92819 E18612'
G[36690]='K1000 L100 T:92819 E18612'
G[36691]='K1000 L100 A:89793 T:92819 E18612'
G[36692]='K1000 L100 T:78495 E18612'
G[36693]='K1000 L100 T:78495 E18612'
G[36694]='K1000 L100 A:89753 T:92819 E18612'
G[36695]='K1000 L100 A:83734 T:78495 P:33661 E18612'
G[36696]='K1000 L100 A:91195 T:78495 E18612'
G[36697]='K1000 L100 A:78487 T:78495 E18612'
G[36698]='K1000 L100 A:91195 T:78495 E18612'
G[36699]='K1000 L100 A:79892 T:78495 E18612'
G[36700]='K1000 L100 T:92819 E18612'
G[36701]='K1000 L100 A:87996 T:78495 E18612'
G[36702]='K1000 L100 T:86272 E18716'
G[36705]='K1000 L100 E18702'
G[36706]='K0900 L090 A:78466 T:86315 P:L091 E18612'
G[36707]='K0900 L090 A:86315 T:86312 P:36706 I:36626 E18612'
G[36708]='K0900 L090 A:86312 T:86312 P:36707 I:36629 E18612'
G[36709]='K0900 L090 A:86312 T:81765 P:36708 I:36630 E18612'
G[36710]='T:86934 E18612'
G[36711]='K0980 L090 T:82746 U209 E18716'
G[36712]='E18612'
G[36713]='E18612'
G[36714]='E18612'
G[36715]='E18612'
G[36716]='E18612'
G[36717]='E18612'
G[36718]='E18612'
G[36720]='E18612'
G[36721]='T:86934 E18612'
G[36722]='T:86934 E18612'
G[36723]='T:86303 E18612'
G[36724]='E18612'
G[36725]='K1000 L100 E18612'
G[36726]='T:81548 E18612'
G[36727]='T:86934 E18612'
G[36728]='E18612'
G[36729]='T:86946 E18612'
G[36730]='T:86934 E18612'
G[36731]='T:86934 E18612'
G[36732]='T:81240 E18612'
G[36733]='T:81548 E18612'
G[36734]='T:81540 E18612'
G[36735]='E18612'
G[36736]='E18612'
G[36737]='E18612'
G[36738]='E18612'
G[36739]='E18612'
G[36740]='E18612'
G[36741]='SP K1001 L100 A:85749 T:85749 P:36133 E18612'
G[36742]='FH K1001 L100 A:86366 E18702'
G[36743]='K1000 L100 T:-971 E18612'
G[36744]='K1000 L100 A:100114146 TP:-110971:FA;-976:FH E18612'
G[36745]='K1000 L100 T:-971 E18612'
G[36746]='K1000 L100 T:-976 E18612'
G[36747]='K1000 L100 E18612'
G[36748]='K1000 L100 T:-971 E18612'
G[36749]='K1000 L100 E18612'
G[36750]='K1000 L100 T:-971 E18612'
G[36751]='K1000 L100 T:-971 E18612'
G[36752]='K1000 L100 E18612'
G[36753]='K1000 L100 E18612'
G[36754]='K1000 L100 E18612'
G[36755]='K1000 L100 E18612'
G[36756]='K1000 L100 T:-971 E18612'
G[36757]='K1000 L100 E18612'
G[36758]='K1000 L100 T:-971 E18612'
G[36759]='K1000 L100 E18612'
G[36760]='K1000 L100 E18612'
G[36761]='K1000 L100 T:-971 E18612'
G[36762]='K1000 L100 E18612'
G[36763]='K1000 L100 T:-971 E18612'
G[36764]='K1000 L100 E18612'
G[36765]='K1000 L100 E18612'
G[36766]='K1000 L100 T:-971 E18663'
G[36767]='K1000 L100 A:77795 T:-971 E18612'
G[36768]='K1000 L100 T:-971 E18612'
G[36769]='K1000 L100 T:-971 E18612'
G[36770]='K1000 L100 A:100235344 TP:-100971:FA;-976:FH E18612'
G[36771]='K1000 L100 E18612'
G[36772]='K1000 L100 T:-971 E18612'
G[36773]='K1000 L100 E18612'
G[36774]='K1000 L100 T:76872 E18612'
G[36775]='K1000 L100 T:-971 E18612'
G[36776]='K1000 L100 T:-971 E18612'
G[36777]='K1000 L100 T:-976 E18612'
G[36778]='K1000 L100 E18612'
G[36779]='K1000 L100 E18612'
G[36780]='K1000 L100 T:-971 E18612'
G[36781]='T:84852 E18612'
G[36782]='T:85564 E18612'
G[36783]='E18612'
G[36784]='E18612'
G[36787]='E18612'
G[36789]='E18612'
G[36790]='K0960 L096 A:86381 T:80746 P:34923+34922 E18612'	-- TODO: Verify requires 34923	-- OTC:36796
G[36791]='SP K1001 L100 A:85749 T:85749 P:36133 E18612'
G[36792]='K00032768 A:84122 T:85429 E18612'
G[36793]='FH I:36797 E18612'
G[36794]='E18612'
G[36796]='E19342'
G[36797]='FA I:36793 E18612'	-- this is marked complete after Alliance sees the screen about being allowed to found the garrison
G[36798]='T:-948 E18663'	-- SP K000131072 A:XXX T:XXX   948:37.30,50.66	-- fee Rooby Roo the dog, and loot the poop here
G[36799]='T:90071 E18663'
G[36800]='K0000 L090 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36801]='K0940 L094 A:86442 T:575803 P:34571+34573+34624,34875 I:34683 E18663'	-- TODO: Verify requires 34571 34573
G[36802]='K0000 L090 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36803]='K0000 L090 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36804]='K0000 L090 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36805]='K0000 L090 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36806]='K0000 L090 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36807]='K1000 L100 A:85882 T:83011 E18912'
G[36808]='K1000 L100 A:77733 T:84367 E18663'
G[36809]='K1000 L100 A:78564 E18833'
G[36810]='E21655'
G[36811]='SP K00032768 L098 A:90255 T:-1015 P:40815,44140,36920 E21570'	-- given when 40815 or 44140 or 36920 is turned in
G[36812]='FH K0920 L090 A:85077 T:85077 P:35506+35524+35527+35508+36793 U211 E18702'
G[36813]='FA K1000 L100 A:84889 T:84889 E18702'
G[36814]='K1000 L100 E19027'
G[36815]='K1000 L100 A:84248 T:88394 E18912'
G[36816]='K1000 L100 A:78564 T:83848 E18850'
G[36817]='K1002 L100 A:89753 E20216'
G[36818]='K1002 L100 A:80866 T:72571 E18912'
G[36819]='K1000 L100 E18850'
G[36820]='K1000 L100 A:84637 T:88906 P:0 E18702'
G[36821]='K1000 L100 A:84637 T:88478 P:1 E18702'
G[36822]='K1000 L100 A:85413 T:78210 E18850'	-- automatically turned in when doing 36674 and all the requirements met
G[36823]='K1000 L100 A:1229330 T:77945 P:1 E18833'
G[36825]='E18663'
G[36826]='K1000 L100 A:-962 T:72348 E19027'
G[36827]='K1000 L100 A:88892 T:72297 E18988'
G[36828]='SP FA K0920 L090 A:85119 T:85119 P:36797+35652+35654+35651+35650 U211 E18716'
G[36829]='SP K000131072 A:1236483 T:1236483 E18663'
G[36830]='K1000 L100 E19342'
G[36831]='K1000 L100 A:79774 T:-976 E19342'
G[36832]='K0930 L090 T:85980 E18702'
G[36833]='SP FA K0930 L090 A:85278 T:85278 P:35702 U212 E18702'	-- removed from P: +36797 because it is not required (tested with Alliance without garrison)
G[36834]='E18663'
G[36837]='T:85564 E18663'
G[36838]='K0900 L090 E18663'
G[36839]='K0900 L090 E18663'
G[36840]='K0900 L090 E18716'
G[36841]='K0900 L090 E18702'
G[36842]='FA K0900 L090 AP:77356:G-096018;577356:G-096019;500157:G-096020 TP:77775:G-096018;577775:G-096019;500158:G-096020 P:G-096+36644 E18663 Z18663'	-- [I do not believe this is in game]
G[36843]='K0940 L094 A:86522 T:75896 P:34576+34577+34579 E18702'	-- at least this is for boosted to 100 Horde
G[36844]='K0900 L090 E18702'
G[36845]='K0900 L090 E18702'
G[36846]='SP K000131072 A:1236610 T:1236610 E18663'
G[36847]='E18663'
G[36848]='K0000 L090 AP:77367:G-037024;577367:G-037023 TP:77367:G-037024;577367:G-037023 P:G-037 E18663'
G[36849]='E18663'
G[36850]='E18663'
G[36851]='E18663'
G[36852]='E18663'
G[36853]='E18663'
G[36854]='E18663'
G[36855]='E18663'
G[36856]='E18663'
G[36857]='E18663'
G[36858]='E18663'
G[36859]='T:86044 E18663'
G[36860]='K1000 L100 A:87123 T:86155 E18833'
G[36861]='FA K0970 L096 A:86589 T:81109 I:35619,35620,36862 E18663'
G[36862]='FH K0970 L096 A:86614 T:81109 I:35619,35620,36861 E18663'
G[36863]='T:93812 E18663'
G[36864]='FH K0960 L096 T:86597 P:36793 I:36353 U204 E18702'
G[36865]='K0900 L090 E18663'
G[36866]='K0580 L055 T:9736 E18663'
G[36867]='K0580 L055 E18663'
G[36870]='FA K0000 L094 A:85708 T:85708 P:PF700+G0135 E18716'
G[36872]='E18663'
G[36873]='E18663'
G[36874]='FH K0000 L090 AP:86629:G-159022;586629:G-159025 TP:86629:G-159022;586629:G-159025 P:G-159 E18663'
G[36876]='K0000 L090 A:86677 T:86677 E18663'
G[36877]='T:90443 E18663'
G[36878]='E18663'
G[36879]='E18663'
G[36880]='T:86689 E18663'
G[36881]='K0900 L090 E18663'	-- TODO: Make this offered to you at Dark Portal if you abandon 34398
G[36882]='FA K0000 L094 A:63721 T:85708 P:36608 E18716'
G[36884]='K1000 L100 E18912'
G[36885]='E18663'
G[36886]='E18663'
G[36887]='E18663'
G[36889]='K0000 L090 E18912'
G[36890]='E18663'
G[36891]='E18663'
G[36892]='E18663'
G[36893]='E18663'
G[36894]='E18663'
G[36895]='E18663'
G[36896]='E18663'
G[36897]='K0000 L090 E18738'
G[36898]='T:75819 E18663'
G[36899]='T:90066 E18663'
G[36900]='T:92819 E18663'
G[36901]='E18663'
G[36902]='E18663'
G[36903]='E18663'
G[36904]='T:90286 E18663'
G[36905]='E18663'
G[36906]='E18663'
G[36907]='E18663'
G[36911]='FA K0000 L091 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:G-065 E18702 D112'
G[36912]='FH K0000 L091 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:G-065 E18702 D119'
G[36913]='K0000 L093 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36916+G-065 E18702 D114'
G[36914]='K0000 L099 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36915+G-065 E18702 D117'
G[36915]='K0000 L097 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36918+G-065 E18702 D116'
G[36916]='K0000 L091 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36911+G-065 E18702 D113'
G[36917]='K0000 L091 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36912+G-065 E18702 D118'
G[36918]='K0000 L095 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36913+G-065 E18702 D115'
G[36919]='T:85572 E18663'
G[36920]='K0000 L098 A:89362 T:90255 P:37660 E21570'	-- Night Elf Druid
G[36921]='K0000 L090 E18764'
G[36922]='E18663'
G[36923]='K0000 L090 E18833'
G[36924]='K0000 L090 E18912'
G[36925]='K0000 L090 E18738'
G[36926]='K0000 L090 E18738'
G[36927]='K0000 L090 E18912'
G[36928]='K0000 L090 E18764'
G[36929]='K0000 L090 E18912'
G[36930]='K0000 L090 E18918'
G[36931]='K0000 L090 E18912'
G[36932]='K0000 L090 E18912'
G[36933]='K0000 L090 E18912'
G[36934]='K0000 L090 E18918'
G[36935]='FH K1001 L100 A:86366 E18702'
G[36936]='T:75819 E18663'
G[36937]='SP K000131072 A:1236935 T:1236935 E18663'
G[36939]='E21570'
G[36940]='FH K0900 L090 A:84928 T:86832 P:35763+i176111 I:36941 E18702'
G[36941]='FA K0900 L090 A:84929 T:29611 P:35500+i176111 I:36940 E18663'
G[36942]='T:75273 E18663'
G[36943]='T:86978 E18663'
G[36944]='K0000 L093 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36917+G-065 E18702 D120'
G[36945]='K0000 L095 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36944+G-065 E18716 D121'
G[36946]='K0000 L097 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36945+G-065 E18716 D122'	-- note that all the base beast taming quests are available one after the other just by logging out and back in after the previous one is completed
G[36947]='K1000 L100 T:86682 E18716'
G[36948]='K1000 L096 E18716'
G[36949]='E21953'
G[36950]='K0000 L099 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36946+G-065 E18716 D123'
G[36951]='K0960 L096 A:1232400 T:79539 I:34653 E18702'
G[36952]='K0980 L098 A:1232416 T:80001 P:1 I:34794 E18702'
G[36953]='FH K0940 L094 A:1233291 T:79176 P:36573,36574 O:36494 E18702'
G[36955]='K0000 L090 A:86677 T:86677 E18716'
G[36956]='E18702'
G[36957]='K0000 L090 A:86677 E18912'
G[36958]='K0000 L090 E18918'
G[36959]='K0000 L090 E18716'
G[36960]='K0000 L090 E18716'
G[36961]='K0000 L090 E18912'
G[36962]='K0000 L090 E18912'
G[36963]='K0000 L090 E18716'
G[36964]='K0000 L090 E18738'
G[36965]='K0000 L090 E18912'
G[36966]='K0000 L090 E18912'
G[36967]='K0000 L090 E18912'
G[36968]='K0000 L090 E18918'
G[36969]='K0000 L090 E19342'
G[36970]='K0000 L090 E19027'
G[36971]='K0000 L092 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36972+G-065 E18702 D112'
G[36972]='K0000 L092 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36911+G-065 E18702 D112'
G[36973]='K0000 L094 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36971+G-065 E18716 D112'
G[36974]='K0000 L096 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36973+G-065 E18716 D112'
G[36975]='K0000 L097 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36974+G-065 E18716 D112'
G[36976]='K0000 L098 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36975+G-065 E18716 D112'
G[36977]='K0000 L099 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36976+G-065 E18716 D112'
G[36978]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36977+G-065 E18716 D112'
G[36979]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36978+G-065 E18716 D112'
G[36980]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36979+G-065 E18738 D112'
G[36981]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36980+G-065 E18738 D112'
G[36982]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36981+G-065 E18764 D112'
G[36983]='K0000 L092 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36984+G-065 E18702 D113'
G[36984]='K0000 L092 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36916+G-065 E18702 D113'
G[36985]='K0000 L094 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36983+G-065 E18716 D113'
G[36986]='K0000 L096 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36985+G-065 E18716 D113'
G[36987]='K0000 L097 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36986+G-065 E18716 D113'
G[36988]='K0000 L098 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36987+G-065 E18716 D113'
G[36989]='K0000 L099 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36988+G-065 E18716 D113'
G[36990]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36989+G-065 E18716 D113'
G[36991]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36990+G-065 E18716 D113'
G[36992]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36991+G-065 E18738 D113'
G[36993]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36992+G-065 E18738 D113'
G[36994]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36993+G-065 E18764 D113'
G[36995]='K0000 L094 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36913+G-065 E18702 D114'
G[36996]='K0000 L096 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36995+G-065 E18702 D114'
G[36997]='K0000 L097 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36996+G-065 E18716 D114'
G[36998]='K0000 L098 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36997+G-065 E18716 D114'
G[36999]='K0000 L099 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36998+G-065 E18716 D114'
G[37000]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36999+G-065 E18716 D114'
G[37001]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37000+G-065 E18716 D114'
G[37002]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37001+G-065 E18716 D114'
G[37003]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37002+G-065 E18738 D114'
G[37004]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37003+G-065 E18738 D114'
G[37005]='K0000 L096 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36918+G-065 E18702 D115'
G[37006]='K0000 L097 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37005+G-065 E18716 D115'
G[37007]='K0000 L098 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37006+G-065 E18716 D115'
G[37008]='K0000 L099 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37007+G-065 E18716 D115'
G[37009]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37008+G-065 E18716 D115'
G[37010]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37009+G-065 E18716 D115'
G[37011]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37010+G-065 E18716 D115'
G[37012]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37011+G-065 E18738 D115'
G[37013]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37012+G-065 E18738 D115'
G[37014]='K1000 L096 E18716'
G[37015]='K0000 L098 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36915+G-065 E18702 D116'
G[37016]='K0000 L099 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37015+G-065 E18716 D116'
G[37017]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37016+G-065 E18716 D116'
G[37018]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37017+G-065 E18716 D116'
G[37019]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37018+G-065 E18716 D116'
G[37020]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37019+G-065 E18716 D116'
G[37021]='K0000 L100 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37020+G-065 E18716 D116'
G[37022]='K0000 L098 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36914+G-065 E18702 D117'
G[37023]='K0000 L099 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37022+G-065 E18716 D117'
G[37024]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37023+G-065 E18716 D117'
G[37025]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37024+G-065 E18716 D117'
G[37026]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37025+G-065 E18716 D117'
G[37027]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37026+G-065 E18716 D117'
G[37028]='K0000 L100 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37027+G-065 E18716 D117'
G[37029]='K1000 L100 E19533'
G[37030]='K1000 L100 A:87225 E18716'
G[37031]='K1000 L100 E18833'
G[37032]='K0000 L094 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36944+G-065 E18716 D120'
G[37033]='K0000 L096 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37032+G-065 E18716 D120'
G[37034]='K0000 L097 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37033+G-065 E18716 D120'
G[37035]='K0000 L098 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37034+G-065 E18716 D120'	-- when all the mounts have killed Beast-Lasher an achievement is completed "Beast-Lasher killed"
G[37036]='K0000 L099 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37035+G-065 E18716 D120'
G[37037]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37036+G-065 E18738 D120'
G[37038]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37037+G-065 E18833 D120'
G[37039]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37038+G-065 E18764 D120'
G[37040]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37039+G-065 E18764 D120'
G[37041]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37040+G-065 E18833 D120'
G[37042]='E21463'
G[37043]='FH K0000 L090 AP:79815:G-008024;579815:G-008023 TP:79815:G-008024;579815:G-008023 P:G-008 E18702'
G[37044]='K0000 L090 E18702'
G[37045]='FH K0000 L090 AP:79857:G-052018;579857:G-052019;500251:G-052020 TP:79857:G-052018;579857:G-052019;500251:G-052020 P:G-052 E18702'
G[37046]='FH K0000 L090 AP:87305:G-035022;587305:G-035025 TP:87305:G-035022;587305:G-035025 P:G-035 E18702'
G[37047]='K1000 L100 T:86934 E18833'
G[37048]='K0000 L092 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37049+G-065 E18702 D119'
G[37049]='K0000 L092 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36912+G-065 E18702 D119'
G[37050]='K0000 L094 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37048+G-065 E18716 D119'
G[37051]='K0000 L096 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37050+G-065 E18716 D119'
G[37052]='K0000 L097 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37051+G-065 E18716 D119'
G[37053]='K0000 L098 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37052+G-065 E18716 D119'
G[37054]='K0000 L099 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37053+G-065 E18716 D119'
G[37055]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37054+G-065 E18716 D119'
G[37056]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37055+G-065 E18716 D119'
G[37057]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37056+G-065 E18738 D119'
G[37058]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37057+G-065 E18738 D119'
G[37059]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37058+G-065 E18764 D119'
G[37060]='FH K0000 L090 AP:79862:G-051018;579862:G-051019 TP:79862:G-051018;579862:G-051019 P:G-051 E18702'
G[37062]='FH K0000 L090 AP:87121:G-111022;587121:G-111025 TP:87121:G-111022;587121:G-111025 P:G-111 E18702'
G[37063]='K0000 L098 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36946+G-065 E18716 D122'
G[37064]='K0000 L099 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37063+G-065 E18716 D122'
G[37065]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37064+G-065 E18716 D122'
G[37066]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37065+G-065 E18716 D122'
G[37067]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37066+G-065 E18716 D122'
G[37068]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37067+G-065 E18738 D122'
G[37069]='K0000 L100 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37068+G-065 E18738 D122'
G[37070]='SP FH K1000 L100 P:T6CC51999 E18738'	-- need A: and T: (also 37128)
G[37071]='K0000 L096 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36945+G-065 E18716 D121'
G[37072]='K0000 L097 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37071+G-065 E18716 D121'
G[37073]='K0000 L098 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37072+G-065 E18716 D121'
G[37074]='K0000 L099 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37073+G-065 E18716 D121'
G[37075]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37074+G-065 E18716 D121'
G[37076]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37075+G-065 E18716 D121'
G[37077]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37076+G-065 E18738 D121'
G[37078]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37077+G-065 E18738 D121'
G[37079]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37078+G-065 E18738 D121'
G[37080]='SP FA K1000 L100 A:86927 T:86927 P:T6C551999 E18738'
G[37081]='K1000 L100 E18738'
G[37082]='K1000 L100 E18702'
G[37083]='K1000 L100 E18702'
G[37084]='SP K1000 L100 A:586946 T:586946 P:T6C951999 E18738'
G[37085]='K1000 L100 T:86964 E18833'
G[37086]='FA K0000 L090 AP:77378:G-052018;577378:G-052019;500252:G-052020 TP:77378:G-052018;577378:G-052019;500252:G-052020 P:G-052 E18702'
G[37087]='FA K0000 L090 AP:84857:G-051018;584857:G-051019;500217:G-051020 TP:84857:G-051018;584857:G-051019;500217:G-051020 P:G-051 E18702'
G[37088]='FA K0000 L090 AP:87217;G-111022;587217:G-111025 TP:87217;G-111022;587217:G-111025 P:G-111 E18702'
G[37091]='K0000 L090 A:84286 T:84286 E18702'
G[37092]='FA K0000 L090 AP:77377:G-008024;577377:G-008023 TP:77377:G-008024;577377:G-008023 P:G-008 E18702'
G[37093]='K0000 L092 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37094+G-065 E18702 D118'
G[37094]='K0000 L092 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36917+G-065 E18702 D118'
G[37095]='K0000 L094 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37093+G-065 E18716 D118'
G[37096]='K0000 L096 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37095+G-065 E18716 D118'
G[37097]='K0000 L097 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37096+G-065 E18716 D118'
G[37098]='K0000 L098 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37097+G-065 E18716 D118'
G[37099]='K0000 L099 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37098+G-065 E18716 D118'
G[37100]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37099+G-065 E18716 D118'
G[37101]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37000+G-065 E18716 D118'
G[37102]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37101+G-065 E18738 D118'
G[37103]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:38102+G-065 E18738 D118'
G[37104]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:38103+G-065 E18764 D118'
G[37105]='K0000 L098 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36950+G-065 E18716 D123'
G[37106]='K0000 L099 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37105+G-065 E18716 D123'
G[37107]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37106+G-065 E18716 D123'
G[37108]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37107+G-065 E18716 D123'
G[37109]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37108+G-065 E18716 D123'
G[37110]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37109+G-065 E18738 D123'
G[37111]='K0000 L100 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37110+G-065 E18738 D123'
G[37112]='K0050 L004 A:6774 T:295 I:2158 E18702'
G[37113]='K1000 L100 E19890'
G[37114]='K1000 L100 E19890'
G[37119]='FA K0000 L090 AP:84947:G-035022;584947:G-035025 TP:84947:G-035022;584947:G-035025 P:G-035 E18702'
G[37120]='E18702'
G[37121]='FA K0000 L090 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:G-066 E18702'
G[37122]='FA K0000 L090 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:G0067 E18912'
G[37123]='FH K0000 L090 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:G-066 E18702'
G[37124]='FH K0000 L090 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:G0067 E19342'
G[37125]='SP K1001 L098 A:87393 T:87393 E18702'
G[37126]='K1000 L100 A:86682 T:86682 E18716'
G[37127]='K1000 L100 A:86934 T:86934 E18833'
G[37128]='FH K1000 L100 P:T6CC61999 E18716'
G[37129]='FA K1000 L100 A:86927 T:86927 P:T6C561999 E18833'
G[37130]='E18716'
G[37131]='K1000 L100 E18738'
G[37132]='T:86657 E18716'
G[37133]='E18716'
G[37134]='T:86657 E18716'
G[37135]='E18716'
G[37136]='E18716'
G[37137]='K1000 L100 A:586946 T:586946 P:T6C961999 E18912'
G[37140]='K1000 L100 A:86964 T:86964 E18764'
G[37141]='SP K0980 L096 A:83959 T:83959 P:Y8925+36797,Y8926+36793 U218 E18738'
G[37142]='K0922 L090 AP:88013:FA+G-034022;588013:FA+G-034025;500166:FH+G-034022;500167:FH+G-034025 TP:88013:FA+G-034022;588013:FA+G-034025;500166:FH+G-034022;500167:FH+G-034025 P:G-034 E18716'
G[37144]='SP K0980 L096 A:580758 T:580758 P:37177 U224 E19342'
G[37145]='K0942 L092 AP:88017:FA+G-034022;588017:FA+G-034025;500168:FH+G-034022;500169:FH+G-034025 TP:88017:FA+G-034022;588017:FA+G-034025;500168:FH+G-034022;500169:FH+G-034025 P:G-034 E18716'
G[37146]='K0960 L094 AP:88022:FA+G-034022;588022:FA+G-034025;500170:FH+G-034022;500171:FH+G-034025 TP:88022:FA+G-034022;588022:FA+G-034025;500170:FH+G-034022;500171:FH+G-034025 P:G-034 E18716'
G[37147]='K0990 L097 AP:88023:FA+G-034022;588023:FA+G-034025;500172:FH+G-034022;500173:FH+G-034025 TP:88023:FA+G-034022;588023:FA+G-034025;500172:FH+G-034022;500173:FH+G-034025 P:G-034 E18716'
G[37148]='K1000 L098 AP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 TP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 P:G-034 E18716'
G[37149]='K1001088 L098 AP:88027:FA+G-034022;588027:FA+G-034025;500176:FH+G-034022;500177:FH+G-034025 TP:88027:FA+G-034022;588027:FA+G-034025;500176:FH+G-034022;500177:FH+G-034025 P:G-034 E18716'
G[37150]='K1000 L098 AP:88025:FA+G-034022;588025:FA+G-034025;500178:FH+G-034022;500179:FH+G-034025 TP:88025:FA+G-034022;588025:FA+G-034025;500178:FH+G-034022;500179:FH+G-034025 P:G-034 E18716'
G[37151]='K1000 L098 AP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 TP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 P:G-034 E18716'
G[37152]='K1001088 L100 AP:87991:FA+G-034022;587991:FA+G-034025;500182:FH+G-034022;500183:FH+G-034025 TP:87991:FA+G-034022;587991:FA+G-034025;500182:FH+G-034022;500183:FH+G-034025 P:G-034 E18716'
G[37153]='K1001088 L100 AP:87992:FA+G-034022;587992:FA+G-034025;500184:FH+G-034022;500185:FH+G-034025 TP:87992:FA+G-034022;587992:FA+G-034025;500184:FH+G-034022;500185:FH+G-034025 P:G-034 E18716'
G[37154]='K1000 L100 AP:87997:FA+G-034022;587997:FA+G-034025;500186:FH+G-034022;500187:FH+G-034025 TP:87997:FA+G-034022;587997:FA+G-034025;500186:FH+G-034022;500187:FH+G-034025 P:G-034 E18716'
G[37155]='K1001088 L100 AP:87995:FA+G-034022;587995:FA+G-034025;500188:FH+G-034022;500189:FH+G-034025 TP:87995:FA+G-034022;587995:FA+G-034025;500188:FH+G-034022;500189:FH+G-034025 P:G-034 E18716'
G[37156]='K1000 L100 AP:87996:FA+G-034022;587996:FA+G-034025;500190:FH+G-034022;500191:FH+G-034025 TP:87996:FA+G-034022;587996:FA+G-034025;500190:FH+G-034022;500191:FH+G-034025 P:G-034 E18716'
G[37157]='K1001088 L100 AP:87994:FA+G-034022;587994:FA+G-034025;500192:FH+G-034022;500193:FH+G-034025 TP:87994:FA+G-034022;587994:FA+G-034025;500192:FH+G-034022;500193:FH+G-034025 P:G-034 E18716'
G[37158]='K1000 L100 AP:87998:FA+G-034022;587998:FA+G-034025;500194:FH+G-034022;500195:FH+G-034025 TP:87998:FA+G-034022;587998:FA+G-034025;500194:FH+G-034022;500195:FH+G-034025 P:G-034 E18716'
G[37159]='K1000 L100 AP:87999:FA+G-034022;587999:FA+G-034025;500196:FH+G-034022;500197:FH+G-034025 TP:87999:FA+G-034022;587999:FA+G-034025;500196:FH+G-034022;500197:FH+G-034025 P:G-034 E18716'
G[37160]='K1001088 L100 AP:88007:FA+G-034022;588007:FA+G-034025;500198:FH+G-034022;500199:FH+G-034025 TP:88007:FA+G-034022;588007:FA+G-034025;500198:FH+G-034022;500199:FH+G-034025 P:G-034 E18716'
G[37161]='K1000 L100 AP:88000:FA+G-034022;588000:FA+G-034025;500200:FH+G-034022;500201:FH+G-034025 TP:88000:FA+G-034022;588000:FA+G-034025;500200:FH+G-034022;500201:FH+G-034025 P:G-034 E18716'
G[37162]='K1000 L100 AP:88001:FA+G-034022;588001:FA+G-034025;500202:FH+G-034022;500203:FH+G-034025 TP:88001:FA+G-034022;588001:FA+G-034025;500202:FH+G-034022;500203:FH+G-034025 P:G-034 E18716'
G[37163]='K1001088 L100 AP:88002:FA+G-034022;588002:FA+G-034025;500204:FH+G-034022;500205:FH+G-034025 TP:88002:FA+G-034022;588002:FA+G-034025;500204:FH+G-034022;500205:FH+G-034025 P:G-034 E18716'
G[37164]='K1001088 L100 AP:88003:FA+G-034022;588003:FA+G-034025;500206:FH+G-034022;500207:FH+G-034025 TP:88003:FA+G-034022;588003:FA+G-034025;500206:FH+G-034022;500207:FH+G-034025 P:G-034 E18716'
G[37165]='K1001088 L100 AP:88004:FA+G-034022;588004:FA+G-034025;500208:FH+G-034022;500209:FH+G-034025 TP:88004:FA+G-034022;588004:FA+G-034025;500208:FH+G-034022;500209:FH+G-034025 P:G-034 E18716'
G[37166]='K1001088 L100 AP:88005:FA+G-034022;588005:FA+G-034025;500210:FH+G-034022;500211:FH+G-034025 TP:88005:FA+G-034022;588005:FA+G-034025;500210:FH+G-034022;500211:FH+G-034025 P:G-034 E18716'
G[37167]='K1001088 L100 AP:88006:FA+G-034022;588006:FA+G-034025;500212:FH+G-034022;500213:FH+G-034025 TP:88006:FA+G-034022;588006:FA+G-034025;500212:FH+G-034022;500213:FH+G-034025 P:G-034 E18716'
G[37168]='SP K0970 L096 A:87561 T:87561 U219 E18716'
G[37169]='E18716'
G[37175]='E21570'
G[37177]='K1000 L096 AZ:948 T:84122 P:T5EB83999 E19342'	-- completes Mantle of the Talon King
G[37179]='K1000 L100 AP:88009:FA+G-034022;588009:FA+G-034025;500214:FH+G-034022;500215:FH+G-034025 TP:88009:FA+G-034022;588009:FA+G-034025;500214:FH+G-034022;500215:FH+G-034025 P:G-034 U455 E18716'
G[37180]='K1000 L100 T:90066 E18716'
G[37181]='K1000 L100 E18764'
G[37182]='K1000 L100 E18738'
G[37183]='K0940 L094 A:81492 T:79133 O:36495 I:34676 E18716'
G[37184]='K0980 L098 A:81492 T:79263 E18716'
G[37185]='E18738'
G[37186]='E18738'
G[37187]='E18738'
G[37188]='E18738'
G[37189]='E18738'
G[37190]='FH L090 E18738'	-- See comment for quest 37196
G[37191]='FA K1000 L100 A:87764 T:84268 P:1 E18738'	-- TODO: This becomes available when in 36341 Azuka Bladefury is slain
G[37192]='FH K1000 L100 A:87764 T:579740 P:1 E18738'	-- TODO: This becomes available when in 36342 Azuka Bladefury is slain (basically the last item in the quest list becomes available:  Speak to Choluna)
G[37193]='E18738'
G[37194]='E18738'
G[37195]='E18738'
G[37196]='FA L090 E18738'	-- This indicates for the Alliance character that Blasted Lands is phased for Iron Horde, but seemingly not for boosted level 90 characters
G[37197]='T:78999 E18738'
G[37198]='E18738'
G[37199]='E18738'
G[37201]='K00016386 L001 A:83837 T:83837 E18738'
G[37202]='E18738'
G[37203]='K00016386 L001 A:87124 T:87124 E18738'
G[37204]='K1002 A:87971 T:87971 E19027'
G[37205]='K0000 L001 A:87122 T:87122 E18738'
G[37206]='K00016386 L001 A:87110 T:87110 E18738'
G[37207]='K00016386 L001 A:87123 T:87123 E18738'
G[37208]='K00016386 L001 A:87125 T:87125 E18738'
G[37209]='K10066 L098 AP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 TP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 P:G-034+37151 E18764 D100'
G[37210]='SP K1001 L098 A:87706 T:87706 E18738'
G[37211]='SP K1001 L098 A:87706 T:87706 E18738'
G[37212]='E18738'
G[37213]='E18738'
G[37214]='E18738'
G[37215]='T:92819 E18738'
G[37216]='T:92819 E18738'
G[37217]='E18738'
G[37218]='E18738'
G[37219]='E18738'
G[37220]='E18738'
G[37221]='SP K1001 L098 A:87706 T:87706 E18738'
G[37222]='SP K1001 L098 A:87706 T:87706 E18738'
G[37223]='SP K1001 L098 A:87706 T:87706 E18738'
G[37224]='SP K1001 L098 A:87706 T:87706 E18738'
G[37225]='SP K1001 L098 A:87706 T:87706 E18738'
G[37226]='SP K1001 L098 A:87706 T:87706 E18738'
G[37227]='K10066 L098 A:88025 T:88025 P:G-034 E18912'
G[37228]='K1001090 L100 A:87991 T:87991 P:G-034 E18833'
G[37229]='K1001090 L100 A:87992 T:87992 P:G-034 E18912'
G[37230]='K1001090 L100 A:87994 T:87994 P:G-034 E19027'
G[37231]='K1000 L100 A:87995 T:87995 P:G-034 E19027'
G[37232]='K1001090 L100 A:87996 T:87996 P:G-034 E18912'
G[37233]='K1001090 L100 A:87997 T:87997 P:G-034+37154 E18912'
G[37234]='K1000 L100 A:87998 T:87998 P:G-034 E18918'
G[37235]='K1000 L100 A:87999 T:87999 P:G-034 E18912'
G[37236]='K1001090 L100 A:88000 T:88000 P:G-034 E18912'
G[37237]='K1001090 L100 A:88001 T:88001 P:G-034 E19027'
G[37238]='K1001090 L100 A:88002 T:88002 P:G-034 E18912'
G[37239]='K1000 L100 A:88003 T:88003 P:G-034 E19027'
G[37240]='K1001090 L100 A:88004 T:88004 P:G-034 E18912'
G[37241]='K1001090 L100 A:88005 T:88005 P:G-034 E18912'
G[37242]='K1001090 L100 A:88006 T:88006 P:G-034 E18912 D100'
G[37243]='K1001090 L100 A:88007 T:88007 P:G-034 E18912'
G[37244]='K10066 L098 AP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 TP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 P:G-034 E18764'
G[37245]='K10066 L098 A:88027 T:88027 P:G-034 E18764'
G[37246]='E18738'
G[37247]='E18738'
G[37248]='E18833'
G[37249]='E18738'
G[37250]='E18738'
G[37251]='E18738'
G[37252]='E18738'
G[37253]='E18738'
G[37254]='SP K000131072 A:1232494 T:1232494 E18738'
G[37255]='E18738'
G[37256]='K0000 L098 A:89023 T:89023 P:37690 E21570'
G[37257]='K0000 L098 A:88115 T:88115 P:37733 E21570'
G[37258]='E21655'
G[37259]='K1000 L100 A:88161 E18738'
G[37260]='K1000 L100 E18833'
G[37261]='K1000 L100 E18738'
G[37262]='K1000 L100 E18764'
G[37263]='K1000 L100 E18764'
G[37264]='K1000 L100 E18764'
G[37265]='K1000 L100 E18764'
G[37266]='K1000 L100 E18912'
G[37268]='E18738'
G[37269]='E18738'
G[37270]='K0002 L001 AP:88145:G-119018+FA;588145:G-119019+FA;500255:G-119020+FA;88392:G-119018+FH;588392:G-119019+FH;500256:G-119020+FH TP:88145:G-119018+FA;588145:G-119019+FA;500255:G-119020+FA;88392:G-119018+FH;588392:G-119019+FH;500256:G-119020+FH P:z-119 E18738'
G[37271]='K1000 L100 E18738'
G[37272]='K1000 L100 E18833'
G[37273]='K1000 L100 E18738'
G[37274]='K1000 L100 E18764'
G[37275]='K1000 L100 T:88155 E18764'	-- removed A:32639
G[37276]='FH K0960 L096 T:88179 P:36166+36793 U453 E18764'
G[37277]='K1002 L100 A:88155 T:88155 E18764'
G[37278]='K1000 L100 E18764'
G[37279]='K1000 L100 A:88155 E18764'
G[37280]='K09932768 L098 A:84632 T:88811 E18738'
G[37281]='SP FA K0960 L096 A:88195 T:88195 P:36165+36797 U453 E18738'
G[37282]='E18738'
G[37283]='E18738'
G[37284]='K1000 L090 A:83006 T:83006 E18850'
G[37285]='K1000 L090 E18912'
G[37286]='K1000 L100 E19342'
G[37287]='K0960 L096 A:84291 T:84291 P:36165 I:37292 E18738'
G[37288]='K1000 L092 AP:77209:=09711;577209:=09712;500138:=09713 T:85849 P:36575,36576 E18738'
G[37289]='K0900 L090 A:88223 T:88223 P:E36592 E18738'
G[37290]='K1000 L092 A:500154,500250 T:85840 P:K100116395 E18738'
G[37291]='FH K0900 L090 A:574163,88228 T:88228 P:32796 E18738'
G[37292]='K0960 L096 A:84292 T:84292 P:36166 I:37287 E18738'
G[37293]='FH K1000 L100 A:88240 T:88240 E18738'
G[37294]='E18738'
G[37295]='K10032768 L100 A:83869 E18738'
G[37296]='K0960 L096 A:83463 T:83463 P:37326,37327 E18738'
G[37297]='K10032768 L100 A:88155 T:79269 E18738'
G[37298]='K10032768 L110 E18738'
G[37299]='K10032768 L100 E18738'
G[37300]='E18738'
G[37301]='E18738'	-- automatically completed when Horde chose Arsenal in Talador
G[37302]='T:79190 E18738'
G[37303]='T:79190 E18738'
G[37304]='E18738'	-- automatically completed when Horde chose Arsenal in Talador
G[37305]='K1000 L100 E18738'
G[37306]='K1000 L100 E18738'
G[37307]='E18738'
G[37308]='E18738'
G[37309]='E18738'
G[37310]='E18738'
G[37311]='E18738'
G[37312]='T:83008 E18738'
G[37313]='E18738'
G[37314]='E18738'
G[37315]='E18738'
G[37316]='E18738'
G[37317]='E18738'
G[37318]='K0990 L098 A:88500 T:1237705 E18738'	-- no known prequest
G[37319]='K0902 L090 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18738 D126'
G[37320]='K0902 L090 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18738 D126'
G[37321]='K0902 L090 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18738 D126'
G[37322]='K0920 L090 A:100119208 T:1237790 P:33256 E18764'
G[37323]='K0902 L090 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18764 D126'
G[37324]='K0902 L090 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18764 D126'
G[37325]='K0902 L090 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E19342 D126'
G[37326]='FH K0960 L096 A:81920 T:83463 P:35277 I:37327 E18764'
G[37327]='K0960 L096 A:81929 T:83463 P:35286 I:37326 E18764'
G[37328]='FH K0960 L096 A:83463 T:81920 P:37296 I:37329 E18764'
G[37329]='FA K0960 L096 A:83463 T:81929 P:37296 I:37328 E18764'
G[37330]='FH K0960 L096 E18764'	--	A:83463 T:81920  TODO: Does this exist?  How differs from 37328?
G[37331]='FA K0960 L096 E18764'	--	A:83463 T:81929  TODO: Does this exist?  How differs from 37329?
G[37332]='FA K0920 L090 A:100119317 T:81324 E18764'
G[37333]='K1000 L100 E18764'
G[37334]='K1000 L100 E18764'
G[37335]='K1000 L071 E18764'
G[37336]='K1000 L071 E18764'
G[37337]='E18764'
G[37338]='E18764'
G[37339]='E18764'
G[37340]='T:83019 E18764'
G[37341]='T:82992 E18764'
G[37342]='E18764'
G[37343]='E18764'
G[37344]='T:87668 E18764'
G[37345]='T:82920 E18764'
G[37346]='T:82942 E18764'
G[37347]='T:82930 E18764'
G[37348]='T:82988 E18764'
G[37349]='T:87341 E18764'
G[37350]='E18764'
G[37351]='T:84911 E18764'
G[37352]='T:84925 E18764'
G[37353]='E18764'
G[37354]='E18764'
G[37355]='E18764'
G[37356]='T:86213 E18764'	-- killling Aqualir at 947:50.98,78.99
G[37357]='E18764'
G[37358]='T:85026 E18764'
G[37359]='T:85073 E18764'
G[37360]='E18764'
G[37361]='E18764'
G[37362]='T:86566 E18764'
G[37363]='T:86562 E18764'
G[37364]='E18764'
G[37365]='T:700134 E18764'
G[37366]='T:86571 E18764'
G[37367]='T:86574 E18764'
G[37368]='T:86579 E18764'
G[37369]='E18764'
G[37370]='E18764'
G[37371]='E18764'
G[37372]='E18764'
G[37373]='E18764'
G[37374]='T:88582 E18764'
G[37375]='T:88583 E18764'
G[37376]='T:88586 E18764'
G[37377]='E18764'
G[37378]='E18764'
G[37379]='E18764'
G[37380]='E18764'
G[37381]='E18764'
G[37382]='E18764'
G[37383]='E18764'
G[37384]='E18764'
G[37385]='T:90286 E18764'
G[37386]='T:82616 E18764'
G[37387]='E18764'
G[37388]='E18764'
G[37389]='E18764'
G[37390]='E18764'
G[37391]='E18764'
G[37392]='E18764'
G[37393]='E18764'
G[37394]='T:83990 E18764'
G[37395]='T:87788 E18764'
G[37396]='T:700354 E18764'
G[37397]='E18764'
G[37398]='E18764'
G[37399]='T:86959 E18764'
G[37400]='T:87234 E18764'
G[37401]='E18764'
G[37402]='E18764'
G[37403]='E18764'
G[37404]='E18764'
G[37405]='E18764'
G[37406]='E18764'
G[37407]='T:80398 E18764'
G[37408]='E18764'
G[37409]='E18764'
G[37410]='T:85568 E18764'
G[37411]='E18764'
G[37412]='E18764'
G[37413]='T:78269 E18764'
G[37416]='K0960 L096 E19027'
G[37417]='K0960 L096 E18764'
G[37418]='K0000 L090 E18833'
G[37420]='K0000 L090 A:84286 T:84286 P:G0164 E18912'
G[37421]='K09532768 L094 A:-110946 T:-946 P:34561 E18764'
G[37422]='K09532768 L094 A:-120946 T:-946 P:34560 E18764'
G[37423]='E18764'
G[37424]='E18764'
G[37425]='E18764'
G[37426]='E18764'
G[37427]='E18764'
G[37428]='E18764'
G[37429]='E18764'
G[37430]='E18764'
G[37431]='E18764'
G[37432]='E18764'
G[37433]='FA K1000 L100 AP:79953:=09711;579953:=09712;500146:=09713 TP:79953:=09711;579953:=09712;500146:=09713 E18764'
G[37434]='FH K1000 L100 A:79740 T:79740 E18764'
G[37435]='SP K000131072 A:1237946 T:1237946 E18764'
G[37439]='FH K0030 L002 RB A:15297 T:15297 E19103'
G[37440]='FH K0040 L002 RB A:15296 T:15296 E19103'
G[37441]='E20444'
G[37442]='FH K0040 L002 RB A:15295 T:15295 E19103'
G[37443]='FH K0040 L002 RB A:15295 T:15295 E19103'
G[37444]='FA K0040 L002 A:16535 T:16535 P:10302 O:10304 I:9303 E18918'
G[37445]='FA K0040 L002 A:17071 T:17071 P:10302 E18918'
G[37446]='FH K0040 L003 A:11378 T:11378 P:25172 E19103'
G[37447]='K0000 L103 A:103761 T:107723 P:42682 E21570'	-- TODO: Probably needs prereq for Altruis
G[37448]='K0000 L110 E21796'
G[37449]='K0000 L098 A:90474 TP:89362:40374;101927:40375 P:37450+37656 E21570'	-- TODO: Turn in is also 89362 if you are Night Elf Druid (probably all non demon hunter...not sure of faction though)
G[37450]='K0000 L098 A:90474 T:90474 P:40815,44140,36920 E21570'
G[37451]='E18816'	-- when found Qiana Moonshadow during quest 34646, but when 34692 turned in this goes away...(as does she on her mission)
G[37452]='K1000 L100 T:87391 E18912'
G[37453]='K1000 L100 T:87391 E19342'
G[37454]='T:87391 E18833'
G[37455]='E18833'
G[37456]='K1000 L100 T:87391 E18833'
G[37457]='K1000 L100 E19342'
G[37458]='K1000 L100 T:87391 E18833'
G[37459]='K1000 L100 E18912'
G[37460]='E18816'
G[37461]='E18816'
G[37462]='E18816'
G[37463]='E18816'
G[37464]='T:83746 E18816'
G[37465]='E18816'
G[37466]='K00032768 L098 A:-131015 T:-1015 E21570'
G[37467]='K00032 L098 A:88867 T:88890 P:37486 E21570'
G[37468]='K0000 L098 A:88890 T:89660 P:37467 E21570'
G[37469]='K0000 L098 A:89660 T:1240552 P:37730 E21570'
G[37470]='K0000 L098 A:89009 T:91403 P:37530 E21570'
G[37471]='E18816'
G[37472]='T:90066 E18816'
G[37473]='T:90066 E18816'
G[37474]='K0000 L000 E18833'
G[37475]='K10032768 L100 A:88155 T:78557 E18816'
G[37476]='K10032768 L100 A:88155 E18816'
G[37477]='K10032768 L100 A:88155 E18816'
G[37478]='K10032768 L100 A:88155 T:84837 E18816'
G[37479]='K10032768 L100 A:83869 E18833'
G[37480]='K10032768 L100 A:84660 E18833'
G[37481]='K10032768 L100 A:88155 E18833'
G[37482]='K10032768 L100 A:88155 E18833'
G[37483]='K1000 L100 E18833'
G[37484]='K1000 L100 E18833'
G[37485]='E18816'
G[37486]='K0000 L098 A:88867 T:88867 P:37497 E21570'
G[37492]='K0000 L098 A:88798 T:88798 P:37256 E21570'
G[37493]='E18816'
G[37494]='K0000 L110 E21796'
G[37495]='K0000 L098 M109 A:1239120 T:-1015 P:37538 E21570'	-- automatically accepted when 37538 turned in
G[37496]='K0000 L098 A:88798 T:88873 P:38407+37257 E21570'	-- TODO: Verify requires 37257
G[37497]='K00032 L098 A:88115 T:88867 P:37257 E21570'
G[37501]='K1000 L100 E18816'
G[37502]='K1000 L100 E18816'
G[37503]='E18816'
G[37504]='K1000 L100 E18816'
G[37505]='K1000 L100 E18816'
G[37506]='K1000 L100 E18816'
G[37507]='K0000 L098 A:88873 T:88873 P:37496 E21570'	-- determine if P: should be O:
G[37508]='T:96538 E18816'
G[37509]='T:92766 E18816'
G[37510]='K0000 L098 A:88873 T:88923 P:37528+37542 E21570'
G[37511]='K1000 L100 A:83734 T:76508 P:35970+35972 E18912'
G[37512]='E18816'
G[37513]='E18816'
G[37514]='E18816'
G[37515]='E18816'
G[37516]='FH K1000 L100 A:76508 T:588892 P:35973 E18912'	-- completes achievement "Broken Precipice"
G[37517]='FA K1000 L100 A:76508 T:88892 P:35973 E18912'
G[37518]='K0000 L098 A:89660 T:89661 P:37736+37678 E21570'
G[37519]='E21655'
G[37520]='SP K1001 L098 A:87706 T:87706 E18850'
G[37523]='K1000 L100 E18850'
G[37524]='K1000 L100 E18850'
G[37525]='E18850'
G[37526]='T:88855 E21570'
G[37528]='K0000 L098 A:88873 T:88873 P:37507 E21570'
G[37529]='E21655'
G[37530]='K0000 L098 A:89009 T:-111015 P:37469 E21570'
G[37531]='E18850'
G[37532]='E21655'
G[37536]='K0000 L098 A:88923 T:89048 P:37510 E21570'
G[37537]='T:89016 E21570'
G[37538]='K0000 L098 A:89048 T:1239120 P:37536 E21570'
G[37539]='E18850'
G[37540]='K1000 L100 E18850'
G[37541]='K1000 L100 E18850'
G[37542]='K0000 L098 A:88873 T:88873 P:37507 E21570'
G[37543]='K1000 L100 E18850'
G[37544]='E18850'
G[37545]='E18850'
G[37546]='E18850'
G[37547]='K1000 L100 E18850'
G[37548]='K1000 L100 E18850'
G[37549]='K1000 L100 E18850'
G[37550]='K1000 L100 E18850'
G[37551]='K1000 L100 E18850'
G[37552]='K1000 L100 E18850'
G[37553]='K1000 L100 E18850'
G[37554]='K1000 L100 E18850'
G[37555]='K1000 L100 E18850'
G[37556]='E18850'
G[37557]='K1000 L100 E18850'
G[37558]='K1000 L100 E18850'
G[37559]='K1000 L100 E18850'
G[37560]='K1000 L100 E18850'
G[37561]='K1000 L100 E18850'
G[37562]='K1000 L100 E18850'
G[37563]='K0920 L090 A:76730 T:76730 P:34124 E18912'	-- choose 1 of 3 followers
G[37564]='E18912'
G[37565]='K0000 L098 A:1239120 T:89051 P:37538 E21570'
G[37566]='K0000 L098 A:89051 T:109334 P:37565 E21570'
G[37567]='E18912'
G[37568]='FH K0900 AP:79813:G-076018;579813:G-076019;500231:G-076020 TP:79814:G-076018;579814:G-076019;500232:G-076020 P:G-076 E18912'	--Alchemy
G[37569]='FH K0900 AP:79867:G-060018;579867:G-060019;500233:G-060020 TP:79817:G-060018;579817:G-060019;500234:G-060020 P:G-060 E18912'	--Blacksmith
G[37570]='FH K0900 AP:79821:G-093018;579821:G-093019;500235:G-093020 TP:79820:G-093018;579820:G-093019;500236:G-093020 P:G-093 E18912'	--Enchant
G[37571]='FH K0900 AP:79826:G-091018;579826:G-091019;500237:G-091020 TP:86696:G-091018;586696:G-091019;500238:G-091020 P:G-091 E18912'	--Engineer
G[37572]='FH K0900 AP:79829:G-095018;579829:G-095019;500239:G-095020 TP:79831:G-095018;579831:G-095019;500240:G-095020 P:G-095 E18912'	--Inscription
G[37573]='FH K0900 AP:79832:G-096018;579832:G-096019;500241:G-096020 TP:79830:G-096018;579830:G-096019;500242:G-096020 P:G-096 E18912'	--Jewel
G[37574]='FH K0900 AP:79834:G-090018;579834:G-090019;500243:G-090020 TP:79833:G-090018;579833:G-090019;500244:G-090020 P:G-090 I:36642 E18912'	--Leather	-- TODO: Need to determine what other requirement is present because Horde boosted to 100 with only 1 in leatherworking cannot get this --- most likely this will become P:G-090+X40416,G-090+40416+37935 -- well it is not completion of the leatherworking quest 36516.  nor is it getting all the recipes in leatherworking for draenor.  nor is it the blueprint, because as a boosted toon I already know it, and could not learn it again.  now having unlearned leatherworking, no quest is available.
G[37575]='FH K0900 AP:79864:G-094018;579864:G-094019;500245:G-094020 TP:79863:G-094018;579863:G-094019;500246:G-094020 P:G-094 E18912'	--Tailor
G[37584]='E18912'
G[37585]='K1000 L100 A:77160 T:77940 P:0 E18912'
G[37587]='E18912'
G[37589]='E18912'
G[37590]='E18912'
G[37591]='E18912'
G[37592]='FH K0900 AP:79832:G-096018;579832:G-096019;500241:G-096020 TP:79830:G-096018;579830:G-096019;500242:G-096020 P:G-096+37573 E18912 Z18912'	--Jewel [I do not believe this is in game]
G[37593]='E18912'
G[37594]='E18912'
G[37595]='E18912'
G[37596]='E21570'
G[37597]='E18912'
G[37598]='T:73161 E18912'
G[37599]='T:73161 E18912'
G[37600]='T:700255 E18912'
G[37601]='T:73161 E18912'
G[37602]='T:700255 E18912'
G[37603]='T:700255 E18912'
G[37604]='E18912'
G[37605]='T:93812 E18912'
G[37606]='T:93812 E18912'
G[37607]='T:73325 E18912'
G[37608]='T:93812 E18912'
G[37609]='T:93812 E18912'
G[37610]='T:93812 E18912'
G[37611]='T:93812 E18912'
G[37612]='T:93812 E18912'
G[37613]='T:89706 E18912'
G[37614]='T:89706 E18912'
G[37622]='K1000 L100 A:77928 P:0 E18912'
G[37623]='K1000 A:81492 T:77979 E18912'
G[37624]='K1000 A:78985 E18912'
G[37626]='K1000 L100 A:74253 P:0 E18912'
G[37627]='K1000 L100 A:86949 T:87788 P:1 E18912'
G[37628]='K1000 L100 A:88892 T:83848 E18912'
G[37629]='K1000 L100 A:83051 P:0 E18912'
G[37630]='K1000 L100 A:83052 E18912'
G[37631]='K1000 L100 A:83858 T:-947 E18912'
G[37632]='K1000 L100 A:94789 T:86024 E18912'
G[37633]='K1000 L100 A:81492 T:78168 E18912'
G[37634]='K1000 L100 E18912'
G[37635]='K1000 L100 A:83858 T:84871 E18912'
G[37636]='K1000 L100 A:86979 E18912'
G[37637]='T:88208 E18912'
G[37638]='E18912'
G[37639]='E18912'
G[37640]='E18912'
G[37644]='K0000 L000 A:85418 T:90071 E18912'
G[37645]='K0000 L000 T:90071 E18912'
G[37646]='E18912'
G[37647]='E18912'
G[37648]='E18912'
G[37649]='SP K000131072 A:1240645 T:1240645 E21570'
G[37650]='E18912'
G[37652]='T:82616 E18912'
G[37653]='K0000 L098 A:89398 T:89398 P:44137,38834 E21570'
G[37654]='K0000 L098 A:91419 T:106881 E21570'	-- obviously no prequests
G[37656]='K0000 L098 A:90474 T:90474 P:40815,44140,36920 E21570'
G[37657]='K0000 L098 A:91419 T:91419 E21570'	-- obviously no prequests
G[37658]='K0000 L098 A:90317 T:90317 P:44137,38834 E21570'
G[37659]='K0000 L098 A:106881 T:1239328 P:37654 E21570'
G[37660]='K0000 L098 A:89398 T:89398 P:37653 E21570'
G[37666]='K0000 L110 E21796'
G[37667]='I:36100,37669 E19342'
G[37669]='FH K0900 A:78466 T:78466 P:K100109258,K100111812,K100111813,K100111814,K100111815,K100111816,K100111817,K100111818,Z156522,Z161386,Z161387,Z161388,Z161389,Z161390,Z161391,Z161392 I:36100,37667 E19027'
G[37670]='E18988'
G[37671]='T:86682 E18988'
G[37672]='E18988'
G[37673]='E18988'
G[37674]='E18988'
G[37675]='E18988'
G[37676]='E18988'
G[37677]='T:72761 E18988'
G[37678]='K0000 L098 A:89849 T:89849 P:37468 E21570'
G[37681]='E18988'
G[37682]='E18988'
G[37683]='E18988'
G[37684]='E18988'
G[37687]='FA K1000 L100 A:91290 T:91290 P:38446 E19890 D124'
G[37688]='FH K1000 L100 A:91292 T:91292 P:38001 E19890 D125'
G[37689]='K0000 L110 E21796'
G[37690]='K0000 L098 A:89975 T:89023 P:42271 E21570'
G[37691]='E21570'
G[37697]='E21570'
G[37713]='T:88084 E21570'
G[37726]='T:89650 E21570'
G[37727]='K0000 L098 A:89341 T:89341 P:37256 E21570'
G[37728]='K0000 L098 A:89341 T:89341 P:37256 E21570'
G[37729]='K0000 L098 A:89661 T:89661 P:42371 E21570'
G[37730]='K0000 L098 A:89661 T:89660 P:37729 E21570'
G[37733]='K0000 L098 A:89023 T:589023 P:37256 E21570'
G[37736]='K0000 L098 A:89660 T:89660 P:37468 E21570'
G[37749]='E19890'
G[37750]='K1000 L100 E19533'
G[37751]='K1000 L100 E19906'
G[37752]='K1000 L100 E19953'
G[37753]='K1000 L100 E19890'
G[37754]='K1000 L100 E20173'
G[37756]='K1000 L100 A:91195 T:78487 E19750'
G[37757]='K1000 L100 T:90851 E19750'
G[37758]='K1000 L100 A:89753 T:90851 E19890'
G[37762]='K1000 L100 T:90851 E19890'
G[37763]='K1000 L100 T:90851 E20157'
G[37764]='K1000 L100 T:90851 E19890'
G[37765]='K1000 L100 T:90851 E19906'
G[37766]='FA K100132 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37767]='FA K100132 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37768]='K1000 L100 A:91196 T:81492 E19890'
G[37769]='K1004 L100 A:91196 T:81492 E19890'
G[37770]='K1004 L100 A:91196 T:90851 E20157'
G[37771]='K1000 L100 T:90851 E19890'
G[37772]='K1000 L100 T:90851 E19906'
G[37773]='FA K100514 L100 A:89805 T:81492 P:=09713 E19445 D094'
G[37774]='FA K100514 L100 A:89805 T:81492 P:=09713 E19445 D094'
G[37775]='FA K100514 L100 A:89805 T:81492 P:=09713+X36222 E19445 D094'
G[37776]='FA K100514 L100 A:89805 T:81492 P:=09713 E19445 D094'
G[37777]='FA K100514 L100 A:89805 T:81492 P:=09713 E19445 D094'
G[37778]='FA K100514 L100 A:89805 T:81492 P:=09713 E19445 D094'
G[37779]='K0000 L098 M109 T:-1015 P:0 E21570'	-- bonus objective quest gotten when entering area about 1015:59.18,41.73 -- also completed 42020
G[37780]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37781]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37782]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37783]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37784]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37785]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37786]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37787]='FH K10066 L100 A:89753 T:78487 P:=09763 E19533 D099'
G[37788]='K1002 L100 AA:89793 AH:589793 T:-950 P:=09713,=09763 E19551 D094 D099'
G[37789]='FA K10066 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37790]='FA K10066 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37791]='FA K10066 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37792]='FA K10066 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37793]='FA K10066 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37794]='FA K10066 L100 A:89763 T:81492 P:=09713 E19533 D094'
G[37795]='FA K10066 L100 A:89763 T:81492 P:=09713 E19445 D094'
G[37796]='FA K10066 L100 A:89763 T:81492 P:=09713 E19596 D094'
G[37797]='K1002 L100 A:-950,1239791 T:-110950 P:37788 E19596'
G[37798]='K1002 L100 A:-110950,1239791 T:-120950 P:37797 E19551'
G[37799]='K1002 L100 A:-120950,1239791 T:-130950 P:37798 E19596'
G[37800]='E19551'
G[37802]='E19551'
G[37803]='E19551'
G[37804]='E19551'
G[37805]='E19551'
G[37811]='FA K1002 L100 A:-130950,1239791 T:81492 P:37799 E19596'
G[37812]='E21570'
G[37813]='FH K100514 L100 A:89806 T:78487 P:=09763 E19445 D099'
G[37814]='FH K100514 L100 A:89806 T:78487 P:=09763 E19445 D099'
G[37815]='FH K100514 L100 A:89806 T:78487 P:=09763+X36222 E19445 D099'
G[37816]='FH K100514 L100 A:89806 T:78487 P:=09763 E19445 D099'
G[37817]='FH K100514 L100 A:89806 T:78487 P:=09763 E19445 D099'
G[37818]='FH K100514 L100 A:89806 T:78487 P:=09763 E19445 D099'
G[37819]='K0000 L001 A:74056 T:74056 P:PR001+L020 E19551'
G[37820]='T:89816 E21570'	-- gotten killing Golza the Iron Fin (89816) 1015:65.63,40.19
G[37821]='T:88086 E21570'
G[37822]='T:89850 E21570'
G[37823]='T:89865 E21570'
G[37824]='SP A:89884 T:89884 E21570'
G[37825]='E21570'
G[37826]='E21570'
G[37827]='E21570'
G[37828]='SP K000131072 A:1240643 T:1240643 E21570'
G[37829]='SP K000131072 A:1240629 T:1240629 E21570'
G[37830]='SP K000131072 A:1240639 T:1240639 E21570'
G[37831]='SP K000131072 A:1240630 T:1240630 E21570'
G[37832]='E21570'
G[37833]='E21570'
G[37834]='K1004096 L100 A:83823 T:83823 P:36017 E19750'
G[37835]='K1004096 L100 A:-947 T:92213 E19750'	-- 947:54.89,15.26 -- while doing 37834
G[37836]='K1004096 L100 A:83823 T:83823 P:37834 E19750'
G[37837]='K1004096 L100 A:90233 T:90233 P:37964 E19750'
G[37838]='SP K1004096 L100 A:90237 T:90237 P:37837 U466 E19890'
G[37839]='FA K1000 L100 A:92213 T:591913 P:39003 E20444'
G[37840]='FH K1000 L100 T:96130 P:39003 E20444'
G[37841]='K1004096 L100 A:90233 TA:92213 TH:592213 P:37837 E19750'
G[37842]='E19551'
G[37843]='E21570'
G[37844]='E21570'
G[37845]='E21570'
G[37848]='K1002 L100 AA:89793 AH:589793 T:-948 P:=09713,=09763 E19551 D094 D099'
G[37849]='K1000 L100 A:-948 T:-150948 P:37848 E19658'
G[37850]='K1000 L100 A:-150948 T:-160948 P:37849 E19658'
G[37851]='K1000 L100 A:-160948 T:-170948 P:37850 E19658'
G[37852]='FA K1000 L100 A:-170948 T:81492 P:37851 E19658'
G[37853]='K0000 L098 A:93354 T:89794 P:38443 E21570'
G[37854]='E21655'
G[37855]='K0000 L098 A:89975 T:89978 P:42271 E21570'
G[37856]='K0000 L098 A:90916 T:90916 P:37855 E21570'
G[37857]='K00032 L098 A:700004 T:89978 P:37957+37859+37856 E21570'
G[37858]='K0000 L098 E21570'
G[37859]='K0000 L098 A:90423 T:89978 P:37855 E21570'
G[37860]='K0000 L098 A:90383 T:-1015 P:37960+37959 E21570'
G[37861]='K0000 L098 A:89978 T:107995 P:37960+37959 E21570'
G[37862]='K0000 L098 A:107995 T:90738 P:37861 E21570'
G[37864]='E19551'
G[37865]='T:700295 E19906'
G[37866]='K1002 A:84286 T:89936 E19953'
G[37867]='E21570'
G[37868]='K0001 L001 A:90473 T:90473 P:37911 E19658'
G[37869]='T:90057 E21570'
G[37881]='K1002 L100 AA:89793 AH:589793 T:-947 P:=09713,=09763 E19551 D094 D099'
G[37882]='K1000 L100 A:-947 T:-140947 P:37881 E19551'
G[37883]='K1000 L100 A:-140947 T:-150947 P:37882 E19551'
G[37884]='K1000 L100 A:-150947 T:-947 P:37883 E19551'
G[37885]='FA K1000 L100 A:-947 T:81492 P:37884 E19551'
G[37886]='T:92766 E19890'
G[37887]='T:92766 E19890'
G[37888]='E19890'
G[37889]='K1000 L100 A:594429 T:89822 P:39242 I:38435 E19934'
G[37890]='K1000 L100 A:89822 T:90238 P:37889 I:38436 E19890'
G[37891]='FA K1002 A:1239902 T:90309 P:38446 E19890 D104'
G[37892]='T:90620 E19890'
G[37908]='T:90139 E21570'
G[37909]='T:90164 E21570'
G[37910]='K0002 L001 A:74056 T:74056 P:37819 E19658'
G[37911]='K0002 L001 A:90473 T:90473 P:37819 E19658'
G[37914]='FA K1002 L100 AA:89793 AH:589793 T:-130941 P:=09713,=09763 E19551 D094 D099'
G[37916]='K1000 L100 A:-130941 T:-941 P:37914 E19658'
G[37917]='K1002 L100 A:-941 T:-140941 P:37916 E19658'
G[37918]='K1000 L100 A:-140941 T:-150941 P:37917 E19769'
G[37919]='K1002 L100 A:-150941 T:81492 P:37918 E19769'
G[37921]='FA K1000 L100 A:90180 T:91593 E19890'
G[37924]='K1000 L100 E19890'
G[37927]='E21570'
G[37928]='T:90217 E21570'
G[37930]='E21570'
G[37932]='T:90244 E21570'
G[37933]='E19890'
G[37934]='K1000 L100 A:90238 T:590238 P:37890 I:38444 E19890'
G[37935]='K1000 L100 A:590238 T:90481 P:37934 I:38445 E19890'	-- this marks achievement "The Invasion of Tanaan"
G[37937]='T:92451 E19890'
G[37938]='K1002 L100 A:96147 T:89686 E19934'
G[37939]='T:92766 E19890'
G[37940]='FH K1002 L100 A:1241725 T:90481 P:38001 E19890 D107'
G[37941]='K1002 L100 AA:89793 AH:589793 T:-949 P:=09713,=09763 E19551 D094 D099'
G[37942]='K1000 L100 A:-949 T:-190949 P:37941 E19769'
G[37943]='K1000 L100 A:-190949 T:-200949 P:37942 E19769'
G[37944]='K1000 L100 A:-200949 T:-210949 P:37943 E19769'
G[37945]='FA K1000 L100 A:-210949 T:78487 P:37944 I:37996 E19769'
G[37946]='E19890'
G[37947]='E19890'
G[37948]='FA K100514 L100 A:89805 T:81492 P:=09713+36222 E19445 D094'
G[37949]='FH K100514 L100 A:89806 T:78487 P:=09763+36222 E19445 D099'
G[37953]='T:90024 E19890'
G[37956]='SP K000131072 A:1240003 T:1240003 E19890'
G[37957]='K0000 L098 A:90065 T:89978 P:37855 E21570'
G[37958]='SP K000131072 A:1240634 T:1240634 E21570'
G[37959]='K0000 L098 A:90383 T:90383 P:37857 E21570'
G[37960]='K0000 L098 A:89978 T:89978 P:37857 E21570'
G[37961]='FH K1000 L100 A:91072 T:91072 P:37935 E19658'
G[37962]='E21570'
G[37963]='K0000 L098 A:89978 T:-1015 P:37857 E21570'	-- automatically gotten when turning in 37857
G[37964]='K1004096 L100 A:83823 T:90233 P:37836 E19890'
G[37965]='K00032768 L098 M109 A:-121015 T:-1015 E21570'
G[37966]='K1002 L100 A:96147 T:92546 E19890'
G[37967]='T:92819 E19890'
G[37968]='K1002 L100 A:1239902 T:90309 P:38446 E19890 D104'
G[37969]='T:91695 E19890'	-- Vol'mar is built (also causes 38433 to be marked complete even though that is building Lion's Watch)
G[37970]='K1000 L100 A:90481 T:92616 E19934'
G[37972]='K1000 L100 E19890'
G[37973]='K1002 L100 AA:89793 AH:589793 T:-100948 P:=09713,=09763 E19551 D094 D099'
G[37974]='K1000 L100 E19658'
G[37975]='K1000 L100 E19934'
G[37976]='K1000 L100 A:-100948 T:-110948 P:37973 E19658'
G[37977]='K1000 L100 A:-110948 T:-120948 P:37976 E19658'
G[37978]='K1000 L100 A:-120948 T:-130948 P:37977 E19658'
G[37979]='FA K1000 L100 A:-130948 T:81492 P:37978 E19658'
G[37980]='E21570'
G[37981]='K1000 L100 E19658'
G[37982]='E21570'
G[37983]='E21570'
G[37984]='E21570'
G[37985]='E21570'
G[37986]='E21570'
G[37987]='E21570'
G[37988]='E21570'
G[37989]='T:90505 E21570'
G[37990]='T:90519 E19890'
G[37991]='K0000 L098 A:89795 T:90543 P:37853 E21570'
G[37992]='FH K1002 L100 A:-130950 T:78487 P:37799 E19596'
G[37993]='FH K1000 L100 A:-170948 P:37851 E19658'
G[37994]='FH K1000 L100 A:-947 T:78487 P:37884 E19551'
G[37995]='K1000 L100 E19658'
G[37996]='FH K1000 L100 A:-210949 T:578487 P:37944 I:37945 E19769'	-- turnin completes achievement "Taking from the Taker"
G[37997]='FH K1000 L100 A:-130948 T:578487 P:37978 E19658'
G[38000]='E21570'
G[38001]='K1000 L100 A:90553 T:90481 P:38577 E19890'	-- war table appears after completing this quest
G[38003]='E19658'
G[38004]='E19658'
G[38005]='K0000 L000 E19658'
G[38006]='K0000 L000 E19658'
G[38007]='E19658'
G[38008]='E19890'
G[38009]='K1000 L100 A:91291 T:90482 E19906'
G[38010]='T:92766 E19890'
G[38014]='K0000 L098 A:102988 T:102988 P:37862 E21570'
G[38015]='K0000 L098 A:90738 T:90738 P:37862 E21570'
G[38016]='E21796'
G[38020]='K1000 L100 T:92910 E19906'
G[38021]='T:92819 E19890'
G[38022]='E19890'
G[38026]='T:90429 E19890'
G[38028]='T:90777 E19890'
G[38029]='T:90438 E19890'
G[38030]='T:90437 E19890'
G[38031]='T:90434 E19890'
G[38032]='T:90442 E19890'
G[38034]='T:90782 E19890'
G[38035]='K0000 L098 A:96644 T:596644 P:39735 E21570'
G[38036]='K0000 L098 A:90783 T:90783 P:B39800 E21570'
G[38037]='T:90803 E21570'	-- Cache of infernals located at 1015:35.32,50.38
G[38038]='E19890'
G[38039]='T:92766 E19890'
G[38040]='K1000 L100 E19906'
G[38041]='E19890'
G[38042]='T:92819 E19890'
G[38043]='K1002 L100 A:96147 T:95235 E19906'
G[38044]='FH K1002 L100 A:1241725 T:90481 P:38001 E19953 D107'
G[38045]='FA K1002 L100 A:1239902 T:90309 P:38446 E19906 D104'
G[38046]='FA K1002 L100 A:1239902 T:90309 P:38446 E19934 D104'
G[38047]='FH K1002 L100 A:1241725 T:90481 P:38001 E19953 D107'
G[38051]='K1002 L100 A:96147 T:90482 E19934'
G[38052]='K0000 L098 A:90749 T:90749 P:B39800 E21570'
G[38053]='K0000 L098 A:90866 T:90866 P:B39800 E21570'
G[38054]='K1002 L100 A:95424 T:90585 E19953'
G[38057]='K0000 L098 A:90783 T:92414 P:38558+38053+38052 E21570'	-- TODO: Verify requires 38053 38052
G[38058]='K0000 L098 A:90866 T:-1017 P:38558+38053+38036+38052 E21570'	-- TODO: Verify requires 38053 38052
G[38059]='K0000 L098 A:92414 T:-1017 P:38057 E21570'
G[38060]='K0000 L098 A:-1017 T:590749 P:38058 E21570'
G[38061]='T:90901 E21570'
G[38063]='E19658'
G[38064]='E19658'
G[38065]='T:92031 E19658'
G[38066]='T:93812 E19658'
G[38067]='E19658'
G[38068]='E19658'
G[38069]='E19658'
G[38070]='E19658'
G[38071]='E19658'	-- FA I:38072 buy Music Roll: High Seas from 67881 Proveditor Grantley 857:89.53,33.55
G[38072]='E19658'	-- FH I:38071
G[38073]='E19658'
G[38074]='E19658'
G[38075]='E19658'
G[38076]='E19658'
G[38077]='E19658'
G[38078]='E19658'
G[38079]='E19658'
G[38080]='E19658'
G[38081]='E19658'
G[38082]='E19658'
G[38083]='E19658'
G[38084]='E19658'
G[38085]='E19658'
G[38086]='E19658'
G[38087]='E19658'
G[38088]='E19658'	-- Music Roll: Ghost, available only when dead from interacting with Forlorn Composer (91592) 34:23.65,33.12
G[38089]='SP A:100122224 T:100122224 P:38356,37961 E19658'
G[38090]='SP A:100122226 T:100122226 P:38356,37961 E19658'
G[38091]='T:93812 E19658'
G[38092]='E19658'
G[38093]='E19658'
G[38094]='E19658'
G[38095]='E19658'
G[38096]='E19658'	-- loot Music Roll: Faerie Dragon from "Faerie Dragon Nest" (240624)" at 20:17.56,67.56 during periodic event
G[38097]='E19658'	-- Music Roll: Totems of the Grizzlemaw, gotten when interacting with Remington Brode (91632) in Zone 490 (his path is huge)
G[38098]='T:92031 E19658'
G[38099]='E19658'	-- buy 122238 Music Roll: Darkmoon Carousel from 85484 Chester 823:51.50,75.08
G[38100]='SP A:100122239 T:100122239 P:38356,37961 E19658'
G[38101]='E19658'
G[38102]='E19658'	-- buy 122221 (Music Roll: Song of Liu Lang) from 64605 Tan Shin Tiao 811:82.22,29.30, need revered with Lorewalkers
G[38103]='E19658'
G[38104]='E19658'
G[38105]='E19658'
G[38106]='E19658'
G[38107]='E19658'
G[38108]='E19658'
G[38109]='K0000 L010 E19658'
G[38110]='K0000 L020 E19658'
G[38111]='K0000 L030 E19658'
G[38112]='K0000 L040 E19658'
G[38113]='K0000 L050 E19658'
G[38114]='K0000 L060 E19658'
G[38115]='K0000 L060 E19658'
G[38116]='K0000 L060 E19658'
G[38117]='K0000 L090 E19658'
G[38118]='K0000 L090 E19658'
G[38119]='K0000 L090 E19658'
G[38120]='K0000 L010 E19658'
G[38121]='K0000 L020 E19658'
G[38122]='K0000 L030 E19658'
G[38123]='K0000 L040 E19658'
G[38124]='K0000 L050 E19658'
G[38125]='K0000 L060 E19658'
G[38126]='K0000 L060 E19658'
G[38127]='K0000 L060 E19658'
G[38128]='K0000 L090 E19658'
G[38129]='K0000 L090 E19658'
G[38130]='K0000 L090 E19658'
G[38131]='K0000 L010 E19658'
G[38132]='K0000 L020 E19658'
G[38133]='K0000 L030 E19658'
G[38134]='K0000 L040 E19658'
G[38135]='K0000 L050 E19658'
G[38136]='K0000 L060 E19658'
G[38137]='K0000 L060 E19658'
G[38138]='K0000 L060 E19658'
G[38139]='K0000 L090 E19658'
G[38140]='K0000 L090 E19658'
G[38141]='K0000 L090 E19658'
G[38142]='K0000 L098 A:94179 T:73426 P:38384 E21570'
G[38143]='K0000 L098 A:73426 T:700274 P:38455+38246+38146 E21570'	-- TODO: Verify requires 38455 38146
G[38144]='K0000 L098 A:700274 T:591223 P:38143 E21570'
G[38145]='K0000 L098 A:700274 T:591223 P:38143 E21570'
G[38146]='K0000 L098 A:100128340 T:93890 E21570'	-- verified do not need to turn in 38142 for this to be available, so for now assuming always available
G[38147]='K0000 L098 A:591223 T:700282 P:38144+38145 E21570'
G[38148]='K0000 L098 A:700282 T:91109 P:38235+38225+38147+40573 I:38322,38323 E21570'
G[38149]='K0000 L010 E19658'
G[38150]='K0000 L020 E19658'
G[38151]='K0000 L030 E19658'
G[38152]='K0000 L040 E19658'
G[38153]='K0000 L050 E19658'
G[38154]='K0000 L060 E19658'
G[38155]='K0000 L060 E19658'
G[38156]='K0000 L060 E19658'
G[38157]='K0000 L090 E19658'
G[38158]='K0000 L090 E19658'
G[38159]='K0000 L090 E19658'
G[38160]='K0000 L010 E19658'
G[38161]='K0000 L020 E19658'
G[38162]='K0000 L030 E19658'
G[38163]='K0000 L040 E19658'
G[38164]='K0000 L050 E19658'
G[38165]='K0000 L060 E19658'
G[38166]='K0000 L060 E19658'
G[38167]='K0000 L060 E19658'
G[38168]='K0000 L090 E19658'
G[38169]='K0000 L090 E19658'
G[38170]='K0000 L090 E19658'
G[38171]='K0000 L090 E19658'
G[38172]='K0000 L090 E19658'
G[38173]='K0000 L090 E19658'
G[38174]='K0000 L090 E19658'
G[38175]='FA K0002 L090 AP:77377:G-008024;577377:G-008023 TP:77377:G-008024;577377:G-008023 P:G0010 E19658'
G[38176]='FH K1000 L100 A:100122405 T:78495 E19658'
G[38177]='FH K1000 L100 A:100122403 T:78495 E19658'
G[38178]='FH K1000 L100 A:100122402 T:78495 E19658'
G[38179]='FH K1000 L100 A:100122400 T:78495 E19658'
G[38180]='FH K1000 L100 A:100122424 T:78495 E19658'
G[38181]='FH K1000 L100 A:100122421 T:78495 E19658'
G[38182]='FH K1000 L100 A:100122418 T:78495 E19658'
G[38183]='FH K1000 L100 A:100122416 T:78495 E19658'
G[38184]='FH K1000 L100 A:100122413 T:78495 E19658'
G[38185]='FH K1000 L100 A:100122411 T:78495 E19658'
G[38186]='FH K1000 L100 A:100122408 T:78495 E19658'
G[38187]='FH K1000 L100 A:100122412 T:78495 E19658'
G[38188]='FH K0002 L090 AP:79815:G-008024;579815:G-008023 TP:79815:G-008024;579815:G-008023 P:G0010 E19658'
G[38189]='FA K1000 L100 A:100122401 T:500220 E19658'
G[38190]='FA K1000 L100 A:100122399 T:500220 E19658'
G[38191]='FA K1000 L100 A:100122406 T:500220 E19658'
G[38192]='FA K1000 L100 A:100122404 T:500220 E19658'
G[38193]='FA K1000 L100 A:100122423 T:500220 E19658'
G[38194]='K1000 L100 E19658'	-- missive (Nimhfree cannot buy the Gorian proving grounds so not sure which is FA and which is FH)
G[38195]='FA K1000 L100 A:100122422 T:500220 E19658'
G[38196]='FA K1000 L100 A:100122417 T:500220 E19658'
G[38197]='FA K1000 L100 A:100122415 T:500220 E19658'
G[38198]='FA K1000 L100 A:100122414 T:500220 E19658'
G[38199]='FA K1000 L100 A:100122409 T:500220 E19658'
G[38200]='FA K1000 L100 A:100122407 T:500220 E19658'
G[38201]='FA K1000 L100 A:100122410 T:500220 E19658'
G[38202]='K1000 L100 E19658'	-- missive (Nimhfree cannot buy the Gorian proving grounds so not sure which is FA and which is FH)
G[38203]='K0000 L098 A:91065 T:91061 E21570'	-- NPC appears when you get to the spot
G[38204]='K1000 L100 E19769'
G[38206]='K0000 L098 A:596644 T:96663 P:38035 E21570'
G[38207]='T:91087 E19890'
G[38208]='SP K000131072 A:1240289 T:1240289 E19890'
G[38209]='T:91093 E19890'
G[38210]='K0000 L098 A:97306 T:96254 P:38060 E21570'
G[38211]='T:92396 E19890'
G[38212]='T:93679 E21570'
G[38213]='K1000 L100 A:91291 T:1240317 P:38267,38269 E19890'
G[38214]='E19890'
G[38215]='E21570'
G[38217]='T:91115 E21570'
G[38218]='E21655'
G[38219]='E21655'
G[38220]='E21570'
G[38221]='E19890'
G[38222]='E19890'
G[38223]='K1000 L100 A:1240317 T:89400 P:38213 E19890'	-- turning in completes achievement "Dark Ascension"
G[38224]='E19890'
G[38225]='K0000 L098 A:91066 T:91066 P:38381,44106 E21570'
G[38231]='T:90312 E19890'
G[38232]='K0000 L098 A:91166 T:91165 P:38460 E21570'
G[38234]='T:700220 E19890'
G[38235]='K0000 L098 A:91066 T:91066 P:38381,44106 E21570'
G[38236]='T:95236 E19890'
G[38237]='K0000 L098 A:91165 T:591166 P:38232 E21570'
G[38238]='T:91187 E21570'
G[38239]='E21570'
G[38240]='K1000 L100 E19934'
G[38241]='K0000 L098 A:85418 T:85418 P:=09713 E19658'
G[38242]='K0000 L098 A:79858 T:79858 P:=09763 E19658'	-- available for Horde boost to 100
G[38243]='SP K0002 L090 AA:90894 AH:91030 TA:90894 TH:91030 P:=09713,=09763 E19658 D094 D099'
G[38246]='K0000 L098 A:93581 T:93890 P:38142 O:38922 E21570'
G[38250]='K1002 L100 A:1239902 T:90309 P:38446 E19934 D104'
G[38251]='SP K000131072 A:1240642 T:1240642 E21570'
G[38252]='FH K1002 L100 A:1241725 T:90481 P:38001 E19906 D107'
G[38253]='FA K1000 L100 AZ:971 T:92219 P:>09712 E19890'	-- TODO: Should this be I:40418 ?
G[38254]='K1000 L100 A:90180 T:90177 P:38257 I:38570 E19890'
G[38255]='K1000 L100 A:90177 T:91242 P:38254 I:38571 E19890'
G[38256]='K1000 L100 A:91242 T:591242 P:38255 I:38572 E19890'
G[38257]='K1000 L100 A:92219 T:90180 P:38253,40418 I:38568 E19890'
G[38258]='FA K1000 L100 A:591242 T:92219 P:38256 I:38573 E19890'
G[38259]='K1000 L100 A:92219 T:500216 P:38258 I:38574 E19890'
G[38260]='E19934'
G[38261]='E19890'
G[38262]='T:90884 E19890'
G[38263]='T:90885 E19890'
G[38264]='T:90888 E19890'
G[38265]='T:90887 E19890'
G[38266]='T:90936 E19890'
G[38267]='K1000 L100 A:91290 T:91291 P:37687 E19890'
G[38268]='T:91289 E21570'
G[38269]='K1000 L100 A:91292 T:91291 P:37688 E19906'
G[38270]='K1000 L100 A:-945 T:91299 P:38560,38453 E19890'
G[38271]='K1000 L100 A:91299 T:91351 P:38270 E19890'
G[38272]='K1000 L100 A:91351 T:91324 P:38271 E19890'
G[38273]='K1000 L100 A:1240547 T:-945 P:38271 E19890'
G[38274]='K1000 L100 A:91324 T:92317 P:38272 E19890'	-- completes achievement "Band of the Bleeding Hollow"
G[38275]='E21570'
G[38276]='E19658'
G[38277]='SP K000131072 A:1240519 T:1240519 E21570'
G[38278]='E21570'
G[38279]='E21570'
G[38280]='E19890'
G[38281]='E21570'
G[38282]='T:91374 E19890'
G[38283]='SP K000131072 A:1240543 T:1240543 E19890'
G[38284]='E21655'
G[38285]='E21655'
G[38286]='K0000 L098 A:91403 T:96028 P:37470 E21570'
G[38287]='SP K0002 L090 AA:91024 AH:91033 TA:91024 TH:91033 P:=09713,=09763 E19658 D094 D099'
G[38290]='SP K0002 L090 AA:91020 AH:91029 TA:91020 TH:91029 P:=09713,=09763 E19658 D094 D099'	-- just like 39225, this is available to Horde boost to 100
G[38293]='SP K0002 L090 AA:91025 AH:91034 TA:91025 TH:91034 P:=09713,=09763 E19658 D094 D099'
G[38296]='SP K0002 L090 AA:91404 AH:91031 TA:91404 TH:91031 P:=09713,=09763 E19658 D094 D099'
G[38299]='FA K00016386 L001 A:91017 T:91017 E19658 D094'
G[38300]='FH K0008194 L001 A:91364 T:91364 E19658 D099'	-- available for Horde boost to 100
G[38304]='K0000 L098 E21570'
G[38305]='K0000 L098 E21570'
G[38306]='K0000 L100 A:91072 P:37935 E19658'	-- for the Horde boost to 100, not available until Tanaan output founded
G[38307]='K0000 L098 A:596683 T:96683 P:39864 E21570'
G[38308]='K0000 L098 A:1244453 T:-1017 P:38362 E21570'
G[38309]='E21570'
G[38310]='E21570'
G[38311]='E21570'
G[38312]='FA K0000 L098 A:91222 T:91481 P:38473 E21570'
G[38313]='E21691'
G[38314]='E21570'
G[38315]='E19890'
G[38316]='T:-1015 E21570'
G[38317]='K0000 L098 A:113911 T:97250 P:38308 E21570'
G[38318]='K0000 L098 A:91481 T:91519 P:38312 E21570'
G[38320]='SP K000131072 A:1240577 T:1240577 E19890'
G[38321]='E21570'
G[38322]='K0000 L098 A:91066 T:91109 P:38235+38225+38147+40573 I:38148,38323 E21570'	-- TODO: Verify requires 38235 (same with other quests in I: code)
G[38323]='K0000 L098 A:100573 T:91109 P:38235+38225+38147+40573 I:38148,38322 E21570'
G[38324]='K0000 L098 A:91531 T:91531 P:39837 E21570'
G[38331]='K1000 A:96254 T:96254 P:38210,38459 E21570'
G[38332]='K0000 L098 A:91473 T:91158 P:39801 E21570'
G[38333]='T:108526 E21570'
G[38334]='SP K000131072 A:1240580 T:1240580 E19890'
G[38337]='K0000 L098 A:91486 TP:91553:c38342;91558:C38342 E21570'	-- gotten from Storm Drake Scale dropped from Stormwing Drake
G[38339]='K0000 L098 A:91531 T:91531 P:39837 E21570'
G[38341]='E21655'
G[38342]='K0000 L098 A:91553 T:91558 P:38410 E21570'
G[38343]='K0000 L098 A:97319 T:93377 E21570'
G[38344]='FA K0000 L100 A:91589 T:6294 E19658'
G[38345]='K0000 L100 A:6294 T:6294 P:38344 E19658'
G[38346]='K0000 L100 T:93812 E19658'
G[38347]='K0000 L098 A:91531 T:97419 P:38324+38339 E21570'	-- TODO: verify 38339
G[38348]='E19658'
G[38351]='K0000 L090 T:90286 E19750'
G[38352]='T:91579 E21570'
G[38353]='E21655'
G[38354]='K0000 L090 AP:77367:G-037024;577367:G-037023 TP:77367:G-037024;577367:G-037023 P:G-037 E19658'
G[38355]='SP K000131072 A:1240605 T:1240605 E21570'
G[38356]='FA K1000 L100 A:91589 T:91589 E19658'
G[38357]='K0000 L098 A:91590 T:91590 P:39801 E21570'
G[38358]='K0000 L098 A:91590 T:91590 P:39801 E21570'
G[38359]='T:91462 E21570'
G[38360]='K0000 L098 A:700621 T:91158 P:38332 E21570'
G[38361]='K0000 L098 A:700621 T:91158 P:38332 E21570'
G[38362]='K0000 L098 A:700630 T:91158 P:38361+38360 E21570'	--TODO: Yoshimo: verify 38360
G[38364]='E21953'
G[38365]='SP K000131072 A:1240638 T:1240638 E21570'
G[38366]='E21570'
G[38367]='SP K000131072 A:1240637 T:1240637 E21570'
G[38368]='E21570'
G[38369]='SP K000131072 A:1240614 T:1240614 E21570'
G[38370]='SP K000131072 A:1240641 T:1240641 E21570'
G[38371]='E21570'
G[38372]='SP K00032768 L098 M109 A:-101018 T:-1018 E21570'
G[38374]='SP K00032768 L098 A:-101017 T:-1017 P:B38318 E21570'
G[38376]='K0000 L098 A:3000002 T:91144 P:42774 E21531'
G[38377]='K0000 L098 A:91109 T:100387 P:38148,38322,38323 E21570'
G[38380]='E21570'
G[38381]='K0000 L098 XD A:94179 T:91066 P:38384 E21570'
G[38382]='K0000 L098 A:94179 T:95395 P:38384 E21570'
G[38383]='E21570'
G[38384]='K0000 L098 A:91109 T:94179 P:40122 E21570'
G[38386]='SP K000131072 A:1240651 T:1240651 E21570'
G[38387]='E21570'
G[38388]='E21570'
G[38389]='E21570'
G[38390]='E21570'
G[38391]='E21570'
G[38392]='E21570'
G[38393]='E21570'
G[38394]='K0000 L100 A:6294 T:6294 P:38345 E19658'
G[38395]='K0000 L100 T:93812 E19658'
G[38396]='K0000 L100 A:6294 T:6294 P:38394 I:38397 E19658'
G[38397]='K0000 L100 T:6566 I:38396 E19750'
G[38398]='E21570'
G[38399]='K0000 L000 E20363'
G[38400]='T:91695 E19890'
G[38401]='E19890'
G[38402]='K0000 L100 A:6294 T:6294 P:38396 E19750'
G[38404]='K0000 L100 A:6566 E19750'
G[38405]='K0000 L098 A:91481 T:91519 P:38312 E21570'
G[38406]='K0000 L090 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E19658 D096'
G[38407]='K0000 L098 A:97319 T:88798 E21570'	-- gotten from "Okuna's Message" dropped from Salteye Spearguard
G[38408]='FA K0000 L100 A:500146 T:-971 E19658'
G[38410]='K1010 A:91519 T:91553 P:38405+38318 E21570'	-- TODO: Verify requires 38318
G[38411]='T:91727 E19890'
G[38412]='K0000 L098 A:91558 T:91249 P:38342 E21570'
G[38413]='K0000 L098 A:91249 T:96465 P:38618,38412 E21570'
G[38414]='K0000 L098 A:91249 T:96465 P:38618,38412 E21570'
G[38415]='FH K1000 L100 A:90481 T:91750 P:38001 I:38421 E19890 D125'
G[38416]='K1000 L100 A:91750 T:591750 P:38415 E19906'	-- completes achievement "The Fate of Teron'gor"
G[38417]='K1000 L100 A:91750 T:-946 P:38415 I:38565 E19906'
G[38418]='E21953'
G[38419]='SP K000131072 A:1240690 T:1240690 E21570'
G[38420]='T:97091 E21911'
G[38421]='FA K1000 L100 A:90309 T:91751 P:38446 I:38415 E19890 D124'
G[38422]='T:91780 E21570'
G[38423]='T:91795 E21570'
G[38424]='T:91892 E21570'
G[38425]='T:91803 E21570'
G[38426]='SP K000131072 A:1240855 T:1240855 E19890'
G[38427]='K0000 L100 A:79740 T:-994 E19658'
G[38428]='K1000 L100 T:90426 E19890'
G[38430]='T:91871 E19890'
G[38431]='T:91874 E21570'
G[38433]='T:91695 E19890'	-- technically FA but also 37969 which should be FH is also complete.  this is complete when 38445 ready to turn in
G[38434]='E21570'
G[38435]='K1000 L100 A:95002 T:91913 P:39055 I:37889 E19890'
G[38436]='K1000 L100 A:91913 T:91923 P:38435 I:37890 E19890'
G[38437]='E19890'
G[38438]='T:92766 E19890'
G[38439]='K1002 L100 A:-945 T:-945 E19906'
G[38440]='FA K1002 L100 A:1239902 T:90309 P:38446 E19906 D104'
G[38441]='FH K1002 L100 A:1241725 T:90481 P:38001 E19934 D107'	-- completes the achievement "The Fel Forge"
G[38442]='SP K00032768 L098 M109 A:96254 T:-1017 P:38331 E21570'	-- TODO: This is accepted when 39590 is accepted
G[38443]='K0000 L098 A:93326 T:93354 P:37449 E21570'
G[38444]='K1000 L100 A:91923 T:591923 P:38436 I:37934 E19890'
G[38445]='K1000 L100 A:591923 T:90309 P:38444 I:37935 E19890'	-- achievement Invasion of Tanaan
G[38446]='K1000 L100 A:91935 T:90309 P:38581 E19890'
G[38449]='FH K1002 L100 A:1241725 T:90481 P:38001 E19890 D107'
G[38451]='E21570'
G[38452]='E21570'
G[38453]='FH K1000 L100 A:90481 T:-945 P:38001 I:38560 E19890 D125'
G[38454]='E21570'
G[38455]='K0000 L098 A:73426 T:73426 P:38142 E21570'
G[38457]='T:91009 E19890'
G[38458]='FH K1000 L100 A:90481 T:92055 P:38274+38223+38416 E20008'
G[38459]='K0000 L098 A:97305 T:96254 P:38362 E21570'
G[38460]='K0000 L098 A:91166 T:91166 O:42238 E21570'
G[38461]='T:92040 E21570'
G[38462]='K1000 L100 A:92055 T:92120 P:38458,38561 E20008'
G[38463]='FH K1000 L100 A:92120 T:93659 P:38462 E20008'
G[38465]='E21570'
G[38466]='T:-1018 E21570'
G[38468]='T:92117 E21570'
G[38469]='E21655'
G[38470]='E21570'
G[38471]='E21570'
G[38472]='T:92152 E21570'
G[38473]='FA K0000 L098 A:96254 T:91222 P:39597 E21570'
G[38474]='SP K000131072 A:1241146 T:1241146 E21570'
G[38475]='SP K000131072 A:1241147 T:1241147 E21570'
G[38476]='SP K000131072 A:1241148 T:1241148 E21570'
G[38477]='SP K000131072 A:1241149 T:1241149 E21570'
G[38478]='SP K000131072 A:1241150 T:1241150 E21570'
G[38479]='T:92180 E21570'
G[38480]='SP K000131072 A:1241151 T:1241151 E21570'
G[38481]='SP K000131072 A:1241152 T:1241152 E21570'
G[38482]='E19658'
G[38483]='SP K000131072 A:1241153 T:1241153 E21570'
G[38485]='SP K000131072 A:1241154 T:1241154 E21570'
G[38486]='SP K000131072 A:1241155 T:1241155 E21570'
G[38487]='SP K000131072 A:1241180 T:1241180 E21570'
G[38488]='SP K000131072 A:1241206 T:1241206 E21570'
G[38489]='SP K000131072 A:1241207 T:1241207 E21570'
G[38490]='SP K000131072 A:1241208 T:1241208 E21570'
G[38491]='E21570'
G[38494]='E21570'
G[38495]='SP K000131072 A:1241212 T:1241212 E21570'
G[38496]='T:92197 E19890'
G[38498]='SP K000131072 A:1241213 T:1241213 E21570'
G[38499]='K1000 L100 A:92183 T:92183 E21570'
G[38500]='K1020 L102 E21570'
G[38501]='K1000 L100 A:97261 E21570'
G[38502]='K1000 L100 A:97261 E21570'
G[38503]='E21570'
G[38504]='E21570'
G[38505]='K1020 L102 E21570'
G[38506]='K1020 L102 E21570'
G[38507]='K1020 L102 E21570'
G[38508]='E21570'
G[38509]='E21570'
G[38510]='E21570'
G[38511]='E21570'
G[38512]='E21570'
G[38513]='K1040 L104 E21570'
G[38514]='K1040 L104 E21570'
G[38515]='K1020 L102 E21570'
G[38516]='SP K000131072 A:1241272 T:1241272 E21570'
G[38517]='E21570'
G[38518]='K1040 L104 E21570'
G[38519]='K1040 L104 E21570'
G[38520]='E21953'
G[38521]='E21570'
G[38522]='K1060 L106 E21570'
G[38523]='K1060 L106 E21570'
G[38524]='K1100 L110 E21570'
G[38525]='K1100 L110 E21570'
G[38526]='K1100 L110 E21655'
G[38527]='K1100 L110 E21570'
G[38528]='K1100 L110 E21570'
G[38529]='SP K000131072 A:1241280 T:1241280 E21570'
G[38530]='K1100 L110 E21570'
G[38531]='K1100 L110 E21570'
G[38532]='K1100 L110 E21570'
G[38533]='K1100 L110 E21655'
G[38534]='K1100 L110 E21655'
G[38535]='E21570'
G[38536]='K1100 L110 E21737'
G[38537]='K1100 L110 E21737'
G[38538]='K1100 L110 E21737'
G[38539]='K1100 L110 E21737'
G[38540]='K1100 L110 E21911'
G[38541]='K1100 L110 E21796'
G[38542]='K1100 L110 E21737'
G[38543]='E21570'
G[38544]='E21570'
G[38545]='E21570'
G[38546]='E21570'
G[38547]='E21570'
G[38548]='E21570'
G[38549]='E21570'
G[38550]='E21570'
G[38551]='E21570'
G[38552]='K0000 L098 E21570'
G[38557]='T:92274 E19890'
G[38558]='K0000 L098 A:90866 T:90866 P:B39800 E21570'
G[38559]='K1100 L110 E21655'
G[38560]='FA K1000 L100 A:90309 T:-945 P:38446 I:38453 E19890 D124'
G[38561]='FA K1000 L100 A:90309 T:92055 P:38274+38223+38562 E20008'
G[38562]='K1000 L100 A:91751 T:591751 P:38421 E19890'
G[38563]='K1020 L102 E21570'
G[38564]='K1080 L108 E21655'
G[38565]='K1000 L100 A:91751 T:-946 P:38421 I:38417 E19890'
G[38566]='K0000 L098 A:100031 T:91866 P:42811 E21570'
G[38567]='K1000 L100 AZ:976 T:92400 P:>09762 E19890'	-- TODO: Should this be I:40417 ?
G[38568]='FH K1000 L100 A:92400 T:89937 P:38567,40417 I:38257 E19890'
G[38569]='FH K1000 L100 A: T:91596 E19890'
G[38570]='K1000 L100 A:89937 T:92401 P:38568 I:38254 E19890'
G[38571]='K1000 L100 A:92401 T:91242 P:38570 I:38255 E19890'
G[38572]='K1000 L100 A:91242 T:591242 P:38571 I:38256 E19890'
G[38573]='K1000 L100 A:591242 T:92400 P:38572 I:38258 E19890'
G[38574]='K1000 L100 A:92400 T:500230 P:38573 I:38259 E19890'	-- turning this in, completes the achievement "Set Sail!"
G[38575]='E19934'
G[38576]='K0000 L098 I:42811 E21570'
G[38577]='FH K1000 L100 A:90481 T:90553 P:37935 I:38581 E19890'
G[38578]='K1000 L100 A:90584 T:90644 E19890'	-- removed  P:FA+E38445,FH+E37935 because newly boosted Horde level 100 able to get this without any Tanaan quests done
G[38579]='T:92408 E19890'
G[38580]='T:92397 E19890'
G[38581]='K1000 L100 A:90309 T:91935 P:38445 I:38577 E19890'
G[38582]='K0000 L098 A:92420 T:92710 P:38595 E21570'
G[38583]='T:92031 E19890'
G[38584]='E19890'
G[38585]='FA K1002 L100 A:1239902 T:90309 P:38446 E19906 D104'
G[38586]='FH K1002 L100 A:1241725 T:90481 P:38001 E19906 D107'
G[38587]='K1002 L100 A:90309 T:92083 E19906'
G[38588]='K1000 L100 T:92026 E19906'
G[38589]='T:92429 E19890'
G[38591]='SP K000131072 A:1241433 T:1241433 E19890'
G[38592]='E19890'
G[38593]='SP K000131072 A:1241434 T:1241434 E19890'
G[38594]='E19890'
G[38595]='K0000 L098 A:92742 T:92420 P:38663 E21570'
G[38596]='T:92326 E21570'
G[38597]='T:92465 E19890'
G[38599]='FH K1000 L100 A:90991 T:90991 P:E37935 E19890'
G[38600]='T:92495 E19890'
G[38601]='SP K000131072 A:1241449 T:1241449 E19890'
G[38602]='SP K000131072 A:1241450 T:1241450 E19890'
G[38603]='K1000 L100 A:92545 T:92545 P:E38445 E19890'
G[38604]='T:92508 E19890'
G[38605]='T:92517 E19890'
G[38607]='K1080 L108 E21570'
G[38608]='E21570'
G[38609]='T:92552 E19890'
G[38610]='E21570'
G[38611]='FH K0000 L098 A:96254 T:92561 P:39597 E21570'
G[38612]='FH K0000 L098 A:92561 T:92566 P:38611 E21570'
G[38613]='K0000 L098 A:92566 T:92567 P:38612 E21570'
G[38614]='K0000 L098 A:92566 T:92567 P:38612 E21570'
G[38615]='K1010 A:92567 T:92573 P:38613+38614 E21570'	-- TODO: verify 38613
G[38616]='K0000 L098 E21570'
G[38617]='K0000 L098 A:92573 T:92569 P:38615 E21570'
G[38618]='K0000 L098 A:92569 T:91249 P:38617 E21570'
G[38620]='T:92574 E19890'
G[38624]='K0000 L098 A:92218 T:97074 P:39652 E21570'
G[38625]='T:92590 E21570'
G[38626]='T:92599 E21570'
G[38627]='T:92604 E21570'
G[38628]='T:92606 E19890'
G[38629]='SP K000131072 A:1241504 T:1241504 E19890'
G[38630]='T:92626 E21570'
G[38631]='T:92627 E19890'
G[38632]='T:92636 E19890'
G[38633]='K1000 L100 E19890'
G[38634]='SP K00065536 A:92647 T:92647 E19890'
G[38637]='SP K000131072 A:1241518 T:1241518 E21570'
G[38638]='SP K000131072 A:1241521 T:1241521 E19890'
G[38639]='T:-945 E19890'
G[38640]='SP K000131072 A:1241524 T:1241524 E19890'
G[38641]='K0000 L098 A:98584 T:92680 P:38377 E21570'
G[38642]='T:92685 E21570'
G[38643]='K1030 A:92688 T:92619 I:39149 E21570'	-- seems to be no prerequisites
G[38644]='K1030 A:92683 T:92619 P:38643,39149 E21570'
G[38645]='K1030 A:92620 T:92620 P:38643,39149 E21570'
G[38646]='K1030 A:92618 T:92618 P:38643,39149 E21570'
G[38647]='K1030 A:92618 T:92618 P:38643,39149 E21570'
G[38648]='E21570'
G[38649]='E21655'
G[38654]='T:92694 E19890'
G[38655]='K0000 L098 A:92697 T:92697 P:38641 E21570'
G[38656]='K0000 L098 A:100124131 T:700567 E21570'
G[38657]='SP K000131072 A:1241533 T:1241533 E19890'
G[38658]='E21655'
G[38660]='E21655'
G[38661]='E21655'
G[38662]='K0000 L098 A:92680 T:92680 P:38641 E21570'
G[38663]='K0000 L098 A:92680 T:98584 P:38662 E21570'
G[38664]='E21570'
G[38665]='E21570'
G[38666]='E21570'
G[38667]='E21570'
G[38668]='E21570'
G[38669]='K1000 L098 E21691'
G[38670]='E21570'
G[38671]='K0000 L098 A:94863 T:94863 P:41056 E21570'
G[38672]='K1000 L098 A:92718 T:1244923 P:38729 E21570'
G[38673]='E21691'
G[38674]='SP A:93125 T:93125'
G[38675]='K0000 L098 A:103022 T:104728 P:1 E21570'
G[38676]='SP K000131072 A:1241557 T:1241557 E21570'
G[38677]='SP K000131072 A:1241558 T:1241558 E21570'
G[38678]='SP K000131072 A:1241560 T:1241560 E19890'
G[38679]='SP K000131072 A:1241561 T:1241561 E19890'
G[38680]='SP K000131072 A:1241562 T:1241562 E21570'
G[38681]='SP K000131072 A:1241564 T:1241564 E21570'
G[38682]='SP K000131072 A:1241563 T:1241563 E19890'
G[38683]='SP K000131072 A:1241565 T:1241565 E19890'
G[38684]='K0000 L098 A:92783 T:92783 P:41724 E21570'
G[38685]='T:92763 E21570'
G[38686]='SP K000131072 A:1241566 T:1241566 E19890'
G[38687]='A:500262 T:104799 P:43702 E21570'
G[38688]='E21570'
G[38689]='K1000 L098 A:92986 T:592986 P:38672 E21570'
G[38690]='K1000 L098 A:92980 T:96665 P:38672 E21570'
G[38691]='K1030 A:92620 T:92842 P:39117+38711+38645+38644+38646+38647 E21570'	-- TODO: Verify requires 38711 38645 38646 38647
G[38692]='E21655'
G[38693]='E21655'
G[38694]='E21655'
G[38695]='E21655'
G[38696]='T:92657 E19890'
G[38697]='E21655'
G[38699]='E21570'
G[38700]='T:92887 E19890'
G[38701]='SP K000131072 A:1241599 T:1241599 E19890'
G[38702]='SP K000131072 A:1241600 T:1241600 E19890'
G[38703]='SP K000131072 A:1241601 T:1241601 E19890'
G[38704]='SP K000131072 A:1241602 T:1241602 E19890'
G[38705]='SP K000131072 A:1241605 T:1241605 E19890'
G[38706]='E20008'
G[38707]='E19890'
G[38708]='K0000 L000 E21570'
G[38709]='T:92941 E19890'	-- Gorabosh (92941) 945:33.28,35.91
G[38710]='K0000 L098 CP A:92909 T:90369 P:43635 E21531'
G[38711]='K1040 A:94366 T:92620 E21570'	-- gotten from "Warden's Signet" which drops from Lelyn Swiftshadon (94366) about 1018:38.86,64.80
G[38712]='T:92956 E21570'
G[38713]='E21570'
G[38714]='K1030 A:92850 T:592842 P:38718 E21570'
G[38715]='K1030 A:92850 T:592842 P:38718 E21570'
G[38716]='SP K10332768 M109 A:-131018 T:-1018 P:38718 E21570'
G[38717]='K1040 A:592842 T:592850 P:38714+38715 E21570'
G[38718]='K1030 A:92842 T:92850 P:38691 E21570'
G[38719]='XE A:700068 T:95028 P:38717 E21570'
G[38720]='E21953'
G[38721]='A:93027 T:93149 P:44457,38724 E21570'
G[38723]='K1000 L098 A:592718 T:596665 P:38690+38689+39517 E21570'
G[38724]='XE A:592850 T:92987 P:38717 E21570'
G[38725]='K0990 L098 A:96655 T:98711 P:39495 E21570'
G[38726]='T:93002 E19890'
G[38727]='K0990 L098 A:93127 T:93127 P:39495 E21570'
G[38728]='K0990 L098 A:97297 T:97303 P:39663 E21570'
G[38729]='K0990 L098 A:97303 T:1244466 P:38728 E21570'
G[38730]='E21570'
G[38731]='SP K000131072 A:1241656 T:1241656 E19890'
G[38732]='SP K000131072 A:1241657 T:1241657 E19890'
G[38733]='E19890'
G[38734]='E21570'
G[38735]='E19890'	-- 945:25.30,50.26
G[38736]='T:93028 E19890'
G[38738]='SP K000131072 A:1241665 T:1241665 E21570'
G[38739]='SP K000131072 A:1241666 T:1241666 E19890'	-- TODO: Really should probably mark this one requiring the campaign quest to be done so the cave is opened up
G[38740]='SP K000131072 A:1241671 T:1241671 E19890'
G[38741]='SP K000131072 A:1241673 T:1241673 E19890'
G[38742]='SP K000131072 A:1241674 T:1241674 E19890'
G[38743]='K0000 L098 A:104799 T:104921 P:38687 E21570'
G[38744]='E21570'
G[38745]='E21655'
G[38746]='T:91232 E19890'
G[38747]='T:91243 E19890'
G[38748]='SP K00032768 L098 M109 A:500262 T:-1018 P:43702 E21570'	-- gotten when 43702 is turned in
G[38749]='T:89675 E19890'
G[38750]='T:93057 E19890'
G[38751]='T:92977 E19890'
G[38752]='T:90482 E19890'
G[38753]='K0000 L098 A:92710 T:102938 P:38582 E21570'
G[38754]='SP K000131072 A:1241692 T:1241692 E19890'
G[38755]='SP K000131072 A:1241699 T:1241699 E19890'
G[38756]='SP K00065536 A:93076 T:93076 E19890'
G[38757]='SP K000131072 A:1241713 T:1241713 E19890'
G[38758]='E19890'
G[38759]='K0980 L098 A:94410 T:93759 P:40378 E21570'
G[38760]='E19890'
G[38761]='T:92623 E19890'
G[38762]='SP K000131072 A:1241716 T:1241716 E19890'
G[38763]='SP K000131072 A:1241717 T:1241717 E21570'
G[38764]='T:93125 E19890'
G[38765]='K0980 L098 A:93759 T:93127 P:39050 E21570'
G[38766]='K0980 L098 A:93759 T:93127 P:39050 E21570'
G[38767]='T:92965 E21570'
G[38771]='SP K000131072 A:1241742 T:1241742 E19890'
G[38772]='T:92423 E21570'
G[38773]='SP K000131072 A:1241745 T:1241745 E19890'
G[38774]='T:93166 E21570'
G[38775]='T:93168 E19890'
G[38776]='SP K000131072 A:1241760 T:1241760 E19890'
G[38777]='K0000 L098 A:-1017 T:93189 E21570'
G[38778]='K0000 L098 A:93231 T:93231 P:39796 E21570'
G[38779]='SP K000131072 A:1241764 T:1241764 E19890'
G[38780]='SP A:93205 T:93205 E21570'
G[38781]='T:97671 E21570'
G[38782]='SP K000131072 A:1241772 T:1241772 E21570'
G[38783]='T:700395 E21570'
G[38784]='K0000 L098 A:90109 T:93189 P:PM001 E21570'
G[38785]='K0000 L098 T:93189 E21570'
G[38786]='K0000 L098 P:38888 E21570'
G[38787]='K0000 L098 E21570'
G[38788]='SP K000131072 A:1241775 T:1241775 E19890'
G[38789]='K0000 L098 E21570'
G[38790]='K0000 L098 E21570'
G[38791]='K0000 L098 E21570'
G[38792]='K0000 L098 E21570'
G[38793]='K0000 L098 E21570'
G[38794]='K0000 L098 E21570'
G[38795]='K0000 L098 T:93189 E21570'
G[38796]='K0000 L098 E21570'
G[38797]='K0000 L098 T:93189 E21570'
G[38798]='K0000 L098 P:38901 E21570'
G[38799]='K0000 L098 P:38798 E21570'
G[38800]='K0000 L098 E21570'
G[38801]='K0000 L098 E21570'
G[38802]='K0000 L098 E21570'
G[38803]='K0000 L098 E21570'
G[38804]='K0000 L098 E21570'
G[38805]='K0000 L098 E21570'
G[38806]='K1100 L110 E21570'
G[38807]='K1100 L110 E21655'
G[38808]='K0000 L098 A:93231 T:93231 P:38778+39788 E21570'	-- TODO: verify 39788
G[38809]='SP K000131072 A:1241835 T:1241835 E19890'
G[38810]='K0000 L098 A:93231 T:93231 P:38778+39788 E21570'	-- TODO: verify 39788
G[38811]='K0000 L098 A:93231 T:93446 P:38808+38810 E21570'	-- TODO: verify 38810
G[38812]='T:93236 E19890'
G[38813]='K0990 L098 A:93127 T:93127 P:38765+38766 E21570'
G[38814]='SP K000131072 A:1241841 T:1241841 E19890'
G[38815]='K0000 L098 A:97270 T:93234 P:38823 E21570'	-- TODO: verify 38823
G[38816]='K0000 L098 A:93446 T:97270 P:38811 E21570'
G[38817]='K0000 L098 A:93446 T:97270 P:38811 E21570'
G[38818]='K0000 L098 A:93234 T:97319 P:38815,38816 E21570'	--TODO: verify 38816
G[38819]='K0990 L098 A:96420 T:93127 P:39495 E21570'
G[38820]='T:93264 E19890'
G[38821]='T:89857 E19890'
G[38822]='SP K000131072 A:1241848 T:1241848 E19890'
G[38823]='K0000 L098 A:1241840 T:97270 P:1 E21570'	-- TODO: Yoshimo: check if there is a prequest
G[38825]='T:93279 E19890'
G[38833]='K1100 L110 E21655'
G[38834]='K0000 L098 A:93337 T:89362 P:41220 E21570'	-- TODO: Given to Night Elf Priest
G[38836]='T:92766 E19890'
G[38837]='T:93371 E21570'
G[38838]='E21570'
G[38839]='E21570'
G[38840]='E21570'
G[38841]='E21570'
G[38842]='SP K00032768 L098 M109 A:-111018 T:-1018 E21570'
G[38844]='E21570'
G[38845]='E22289'
G[38847]='T:93401 E21570'
G[38850]='E21570'
G[38855]='E20395'
G[38856]='E21570'
G[38857]='K0000 L098 A:88863 T:91419 E21570'	-- so far no prequests
G[38861]='E21570'
G[38862]='K0000 L098 T:93600 E21570'	-- in looting a Lunarwing Egg we get this quest automatically (in area for 38842), probably from Thistleleaf Ruffian
G[38863]='SP K000131072 A:1242249 T:1242249 E19890'
G[38864]='E21570'
G[38865]='FH K1000 L100 A:90481 T:90585 I:38866 E19890'
G[38866]='FA K1000 L100 A:-945 T:-945 I:38865 E19890'	-- This was completed as Alliance when attempting to get to the area for 38581 (if you go there without a quest you do not get this)
G[38868]='K1000 L100 A:91291 T:90265 E19890'
G[38869]='K1000 L100 A:94870 T:90265 E19906'
G[38870]='K1000 L100 A:94870 T:90851 E19890'
G[38871]='K1000 L100 A:96014 E19890'
G[38872]='K0000 L098 P:39855 E21570'	-- TODO: verify 39855 , likely a breadcrumb quest
G[38873]='K0000 L098 A:93603 T:93603 P:1 E21570'
G[38874]='E19890'
G[38875]='E21953'
G[38876]='K1000 L100 A:92055 T:700419 E20008'
G[38877]='K1000 L100 A:96147 T:-945 E20008'	--  A:92055 is wrong
G[38878]='K0000 L098 A:94227 T:95611 P:39154 E21570'
G[38879]='E21953'
G[38880]='E21953'
G[38881]='E21953'
G[38882]='K0000 L098 A:94228 T:95755 P:39155 E21570'
G[38885]='E21570'
G[38886]='E21570'
G[38887]='T:93654 E21570'
G[38888]='K0000 L098 A:93189 E21570'
G[38889]='K0000 L098 T:93677 E21570'
G[38890]='E21570'
G[38892]='E21570'
G[38893]='T:108327 E21570'
G[38894]='E21570'
G[38895]='E21570'
G[38896]='E21570'
G[38900]='E21570'
G[38901]='K0000 L098 P:38796 E21570'
G[38902]='E21570'
G[38903]='E21570'
G[38904]='K0000 L098 E21570'
G[38907]='K0000 L098 A:97666,700346,700347 T:93826 P:1 O:39733 E21570'
G[38909]='K0000 L098 A:593805 T:93826 P:39027 E21570'
G[38910]='K0000 L098 A:93841 T:95410 P:39318 E21570'
G[38911]='K0000 L098 A:93826 T:93833 P:38907,39989 E21570'	-- TODO: Yoshimo: very if 39989 is really needed
G[38912]='K0000 L098 A:93826 T:95256 P:38909 E21570'
G[38913]='K0000 L098 A:93826 T:93841 P:38909 E21570'
G[38914]='E21570'
G[38915]='K0000 L098 A:108434 T:93846 P:39580 E21570'
G[38916]='K0000 L098 A:700109 T:94571 P:39992 E21570'
G[38922]='K0000 L098 A:93890 T:93581 P:38142 E21570'
G[38923]='K1000 L100 E19906'	-- TODO: Autoaccept entering Ashran combat zone
G[38924]='K1000 L100 E19906'
G[38925]='K1000 L100 A:94870 T:82909 E19906'
G[38926]='K1000 L100 A:84223 E19906'
G[38927]='K1000 L100 E20363'
G[38929]='K1000 L100 E19906'
G[38932]='K1000 L100 A:100126950 TA:93812 TH:94801 P:j10372+FA+39665,j10372+FH+39676 E19906'
G[38933]='K0000 L098 A:91866 T:90250 P:39722 E21570'
G[38934]='K0000 L015 E19906'
G[38935]='K0870 L086 E19906'
G[38936]='K0870 L087 E19906'
G[38937]='E21570'
G[38938]='E21570'
G[38939]='K0000 L098 A:94227 T:98955 E21570'	--automatically accepted on turnin of 39154
G[38940]='E21570'
G[38943]='E21570'
G[38944]='K1000 L100 E21570'
G[38945]='K1000 L100 E21570'
G[38946]='K1000 L100 E21570'
G[38947]='K1000 L100 E21570'
G[38948]='K1000 L100 E21570'
G[38949]='K1000 L100 E21570'
G[38950]='K1000 L100 E21570'
G[38951]='K1020 L102 E21570'
G[38952]='K1020 L102 E21570'
G[38953]='K1020 L102 E21570'
G[38954]='K1040 L104 E21570'
G[38955]='K1040 L104 E21570'
G[38956]='K1060 L106 E21691'
G[38957]='K1060 L106 E21570'
G[38958]='K1060 L106 E21570'
G[38959]='K1080 L108 E21691'
G[38960]='K1080 L108 E21691'
G[38961]='K1080 L108 E21570'
G[38962]='K1100 L110 E21570'
G[38963]='K1080 L108 E21691'
G[38964]='K1100 L110 E21691'
G[38965]='E21570'
G[38966]='K1100 L110 E21570'
G[38967]='K1100 L110 E21691'
G[38968]='K1100 L110 E21691'
G[38969]='K1100 L110 E21691'
G[38970]='K1100 L110 E21691'
G[38971]='K1100 L110 E21691'
G[38974]='K1100 L110 E21691'
G[38975]='K1100 L110 E21691'
G[38976]='E21570'
G[38977]='E21570'
G[38978]='E21570'
G[38979]='E21570'
G[38980]='E21570'
G[38981]='E21570'
G[38982]='E21570'
G[38983]='E21570'
G[38989]='FH K1000 L100 A:1 E19906'	-- sends one to Tanann for daily.
G[38990]='K0000 L098 A:700602 T:93437 E21570'
G[38993]='E21570'
G[38994]='T:92335 E21570'
G[38995]='E21570'
G[38996]='FA K1000 L100 A:1 T:90309 E19906'	-- sends one to Tanaan for daily.  find out what makes it no longer present.  the bounty board in garrison opens the adventure guide
G[38999]='E21655'
G[39000]='K1000 L100 AA:92213 AH:592213 TA:92213 TH:592213 P:37841 E19906'	-- the question is once we turn in 39000 and another is available, does it also require 39697 as well?
G[39001]='K1000 L100 E19906'
G[39002]='K1000 L100 E19906'
G[39003]='K1000 L100 AA:92213 AH:592213 TA:92213 TH:592213 P:39000 E19906'
G[39004]='K1000 L100 AA:500225 TA:92213 P:FA+37839,FH+37840 E20363'	-- That P: is for Alliance...assuming there is something similar for Horde
G[39005]='E21570'
G[39006]='E21570'
G[39009]='E21570'
G[39010]='E21570'
G[39011]='K0000 L098 E21570'
G[39015]='K0000 L098 E21570'
G[39016]='E21570'
G[39017]='E21570'
G[39018]='K1000 L098 T:83823 I:35988 E19906'	-- TODO: Horde boosted to 100 can get this before doing things.  Also available from Command Board in Frostwall
G[39019]='K1000 L098 E19906'
G[39020]='Hg K1004 L100 AA:94870 AH:594870 TA:94870 TH:594870 E19953 D111'
G[39021]='Hh K1004 L100 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39022]='K1000 L098 E19906'
G[39023]='K1000 L098 E19906'
G[39024]='K1000 L098 E19906'
G[39025]='K0000 L098 A:593805 T:97553 P:42104 E21570'
G[39026]='K0000 L098 A:593805 T:97553 P:42104 E21570'
G[39027]='K0000 L098 A:597553 T:593805 P:39043 E21570'
G[39028]='E21655'
G[39029]='SP K00032768 L098 M109 A:92680 T:-1018 P:38641 E21570'
G[39030]='E21570'
G[39031]='T:92751 E21570'
G[39032]='K0000 L098 E21570'
G[39033]='Ha K1004 L100 AA:94870 AH:594870 TA:94870 TH:594870 P:FA+E38445,FH+E37935 E20008 D111'
G[39034]='Hd K1004 L100 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39035]='E19906'
G[39036]='E19906'
G[39037]='E19906'
G[39038]='E19906'
G[39040]='Hc K1004 L100 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39041]='Hb K1004 L100 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39042]='He K1004 L090 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39043]='K0000 L098 A:97553 T:597553 P:39025+39026 E21570'
G[39044]='E21570'
G[39045]='T:90122 E19906'
G[39046]='T:90094 E19906'
G[39047]='K0000 L098 A:99343 T:99254 P:39689+40375 E21570'
G[39048]='E21570'
G[39049]='K0980 L098 A:94410 T:93759 P:40378 E21570'
G[39050]='K0980 L098 A:93759 T:93759 P:40379+39049+38759 E21570'
G[39051]='K0004096 L098 A:594902 T:94902 P:40819 E21570'
G[39052]='E19934'
G[39054]='K0000 L100 A:94429 T:94429 P:39082 I:39241 E19906'
G[39055]='K0000 L100 A:95002 T:95002 P:39276 I:39242 E19906'
G[39056]='FA K0000 L100 A:93822 T:593822 I:39243 E19906'	-- this appears after I have been to Tanaan, but not sure about any other requirements.
G[39057]='K1000 L100 AA:92213 TA:92213 P:37841 E20157'
G[39058]='T:101700 E19906'
G[39059]='K0000 L098 A:94346 T:94318 E21570'
G[39060]='A:94318 T:94318 E21570'
G[39061]='K0000 L098 A:94318 T:94318 E21570'
G[39062]='K0000 L098 A:94318 T:93779 E21570'
G[39063]='K0000 L098 A:93779 T:95921 E21570'
G[39066]='E21691'
G[39067]='K0000 L100 A:593822 T:593822 P:39056 E19953'
G[39068]='K0000 L100 A:593822 T:593822 P:39067 E20008'
G[39069]='T:-1018 E21570'	-- small treasure chest located at 1018:62.71,70.38
G[39070]='T:-1018 E21570'	-- small treasure chest located at 1018:63.04,76.96
G[39071]='E21570'
G[39072]='T:100459 E21570'
G[39073]='T:32638 E21570'
G[39074]='E21570'
G[39075]='SP K000131072 A:1242649 T:1242649 E19906'
G[39076]='K0000 L000 E19906'
G[39077]='T:700283 E21570'
G[39079]='E21570'
G[39080]='SP K000131072 A:1242663 T:1242663 E21570'
G[39081]='T:94414 E21570'
G[39082]='K0000 L100 A:93822 T:94429 P:38259 I:39236 E19906'
G[39083]='T:94117 E21570'	-- small treasure chest located at 1018:36.97,57.34
G[39084]='E21570'
G[39085]='SP K000131072 A:1242667 T:1242667 E21570'
G[39086]='E21570'
G[39087]='T:95617 E21570'
G[39088]='E21570'
G[39089]='E21570'
G[39090]='K1000 L100 AZ:978 T:80297 E19906'
G[39092]='K0000 L098 A:95921 T:95804 E21570'
G[39093]='E21570'
G[39094]='E21570'
G[39095]='E21570'
G[39096]='E19906'
G[39097]='E21570'
G[39098]='E21570'
G[39099]='E21570'
G[39100]='E21570'
G[39101]='E21570'
G[39102]='T:700352 E21570'
G[39103]='E21570'
G[39104]='E21570'
G[39105]='E21570'
G[39106]='E21570'
G[39107]='K1000 L090 A:83006 T:83006 E19906'
G[39108]='E21570'
G[39109]='E21570'
G[39110]='E21570'
G[39111]='E21570'
G[39112]='E21570'
G[39113]='E21570'
G[39114]='E21570'
G[39116]='E21570'
G[39117]='K0000 L098 A:94117 T:94117 P:38643,39149 E21570'
G[39118]='E21570'
G[39119]='K0000 L098 T:94856 E21570'
G[39120]='T:94413 E21570'
G[39121]='T:94414 E21570'
G[39122]='K0000 L098 A:95804 T:95932 E21570'
G[39123]='K0000 L098 A:94409 T:94409 P:40170 E21570'
G[39124]='K0000 L098 A:94409 T:94409 P:40170 E21570'
G[39125]='K1080 L108 E21570'
G[39126]='E21570'
G[39127]='K0880 L088 T:60688 E19906'
G[39128]='E19906'
G[39129]='K1000 L100 E19934'
G[39130]='T:94485 E21570'
G[39131]='K0000 L098 E21570'
G[39132]='E21570'
G[39133]='K0000 L098 A:94561 T:94561 P:38909 E21570'	-- after getting some quests, attempting to get the tears these appear --TODO: Yoshimo: check if the P: assumption is true
G[39134]='K0000 L098 A:94561 T:94561 P:38909 E21570'	-- after getting some quests, attempting to get the tears these appear --TODO: Yoshimo: check if the P: assumption is true
G[39135]='E21570'
G[39136]='E21570'
G[39142]='K0000 L103 E21570'
G[39147]='E19906'
G[39149]='A:94594 T:92619 I:38643 E21570'
G[39151]='E21916'
G[39152]='E21570'
G[39153]='K0000 L098 A:93603 T:93603 P:1 E21570'
G[39154]='K0000 L098 A:93603 T:94227 P:38873+39153 E21570'	-- TODO: Yoshimo: verify 39153
G[39155]='K0000 L098 A:95611 T:94228 P:38878 E21570'
G[39156]='E21570'
G[39157]='E19906'
G[39158]='E21570'
G[39159]='T:91227 E19906'
G[39160]='E19906'
G[39161]='E19906'
G[39162]='E19906'
G[39163]='E19906'
G[39164]='E19906'
G[39165]='E19906'
G[39166]='E19906'
G[39167]='E19906'
G[39168]='E19906'
G[39169]='E19906'
G[39170]='T:95056 E19906'
G[39171]='E19906'
G[39172]='E19906'
G[39173]='E19906'
G[39174]='E21570'
G[39175]='K1000 L100 E19906'
G[39176]='K1000 L100 A:94686 T:94605 E19906'
G[39177]='K1000 L100 A:94605 T:94686 E19906'
G[39178]='K000512 L098 A:94101 T:94101 P:39124 E21570'
G[39179]='K0000 L103 E21570'
G[39180]='FH K0620 L061 A:0 T:17841 I:9912,39181 E19906'
G[39181]='FA K0620 L061 A:0 T:17841 I:9912,39180 E19906'
G[39182]='FH K0620 L061 A:1 T:18446 E19906'
G[39183]='E19906'
G[39184]='E19906'
G[39185]='E19906'
G[39186]='E19906'
G[39187]='E19906'
G[39188]='FA K0620 L061 A:1 T:18446 E19906'
G[39190]='E21570'
G[39191]='K0000 L098 E21570'
G[39192]='K0004096 L098 A:96586 T:96586 P:39530 E21570'
G[39195]='K1000 L100 A:77209 T:94686 E20008'
G[39196]='K0640 L064 E19906'
G[39197]='K0640 L064 E19906'
G[39198]='K0650 L064 E19934'
G[39199]='K0650 L064 E19906'
G[39200]='E21916'
G[39201]='K0670 L067 E20008'
G[39202]='K0670 L067 E20173'
G[39203]='K0720 L071 E19934'
G[39204]='K0720 L071 A:1207320,1207321,1207322 T:26673 E19953'
G[39205]='E21570'
G[39206]='K0740 L073 E20157'
G[39207]='K0730 L073 E20157'
G[39208]='K0750 L074 E19934'
G[39209]='K0760 L076 E19934'
G[39210]='K0740 L074 E19934'
G[39212]='K0760 L076 A:28674 E19934'
G[39214]='K0000 L098 A:100622 T:100635 P:39192 E21570'
G[39216]='E21570'
G[39217]='FA K1000 L100 A:84223 T:84223 E19934'
G[39221]='K1000 L100 A:89753 T:78487 P:=09763 E20157'
G[39225]='K100132 L100 A:89753 T:578487 E20157'	-- available to Horde boost to 100
G[39228]='K1000 L100 T:90851 E20157'
G[39231]='FH K10066 L100 A:89753 T:78487 P:=09763 E20363'
G[39232]='K1000 L100 T:90851 E20157'
G[39233]='FH K1000 L100 A:88448 T:88448 E19934'
G[39234]='E21570'
G[39235]='T:94877 E21570'
G[39236]='K0000 L100 A:94789 T:594429 P:38574 I:39082 E19934'
G[39241]='K0000 L100 A:594429 T:594429 P:39236 I:39054 E19934'
G[39242]='K0000 L100 A:594429 T:594429 P:39241 I:39055 E19934'
G[39243]='K0000 L100 A:94789 T:594789 P:37889 O:39423 I:39056 E19934'	-- I thought  P:37935, but updated based on other comments
G[39245]='K0000 L100 A:594789 T:594789 P:39676 E19953'
G[39246]='K0000 L100 A:594789 T:94789 P:39245 E20157'
G[39247]='K0004096 L098 A:94902 T:102799 P:39051 E21570'
G[39250]='K1004 L100 A:91196 T:81492 E20157'
G[39253]='K1000 L100 A:89763 T:90851 E20157'
G[39256]='K1000 L100 T:90851 E20157'
G[39259]='K1000 L100 T:90851 E20157'
G[39260]='K1000 L100 T:90851 E20157'
G[39261]='K0004096 L098 CE A:99343 T:99247 P:43635,44091 E21570'	-- TODO: Does this need P:40374 as well?
G[39262]='K0990 L098 A:93127 T:96436 P:38813 E21570'
G[39263]='K1000 L100 A:88448 E19934'
G[39264]='K1000 L100 E19934'
G[39265]='E19934'
G[39266]='E19934'
G[39267]='E19934'
G[39268]='E19934'
G[39269]='E21691'
G[39271]='E21570'
G[39272]='K0000 L098 A:95191 T:95191 P:38911 E21570'
G[39273]='E21570'
G[39274]='SP K00032768 L098 A:95186 T:-1024 P:39496 E21570'
G[39276]='K0000 L100 A:94429 T:95002 P:39054 E19953'
G[39277]='K0000 L098 A:95956 T:95956 P:39496 E21570'
G[39278]='K0000 L100 A:100127989 T:83888 E19953'	-- Waterlogged Manifest comes from completing naval mission Black Market Journal
G[39279]='SP K09832768 L098 A:98229 T:-1028 P:40077 E21570'	-- autoaccepted immediately upon turnin of 40077
G[39282]='E21570'
G[39283]='K0000 L090 T:85984 E20008'
G[39285]='E21570'
G[39286]='E21570'
G[39287]='T:95053 E19953'
G[39288]='T:95044 E19953'
G[39289]='T:95056 E19953'
G[39290]='T:95054 E19953'
G[39292]='K1000 L100 E20395'
G[39294]='K1000 L100 E19953'
G[39296]='K1100 L110 E21570'
G[39299]='K0000 L100 A:83888 T:-971 P:39278 E20008'
G[39303]='E21570'
G[39304]='E21570'
G[39305]='K0000 L098 A:94068 T:94068 P:40070 E21570'	-- TODO: Yoshimo: might require other quests from that NPC as well
G[39306]='E20157'
G[39307]='E20157'
G[39308]='E20157'
G[39309]='T:90024 E20157'
G[39310]='FA E20157'	-- set when you pick Artillery Strike from NPC 90963 when doing quest 39313
G[39311]='E21570'
G[39312]='K1100 L110 E21570'
G[39313]='K0000 L090 A:90963 T:90963 P:E38445 E19953'
G[39315]='FH K0000 L090 A:90993 T:90993 P:E37935 E20157'
G[39316]='K0000 L098 A:95186 T:95186 P:39496 E21570'
G[39317]='K0000 L098 A:93841 T:700552 P:1 E21570'
G[39318]='K0000 L098 A:93841 T:93841 P:38913 E21570'
G[39319]='E21691'
G[39321]='K0000 L098 A:95410 T:95410 P:38910 E21570'
G[39322]='K0000 L098 A:95410 T:95410 P:39429+39321 E21570'	--TODO: Yoshimo: check if 39321 is needed
G[39323]='K0000 L098 A:96083 T:95130 P:39490+39272+39491 E21570'	--TODO: Yoshimo: check if conditions are correct (assumed to be equal to 39496
G[39324]='E21570'
G[39325]='K1000 L100 E21570'
G[39326]='K1000 L100 E21570'
G[39327]='K1000 L100 E21570'
G[39328]='K1000 L100 E21570'
G[39329]='K1000 L100 E21570'
G[39330]='K1000 L100 E21570'
G[39331]='K1020 L102 E21570'
G[39332]='K1020 L102 E21570'
G[39333]='K1040 L104 E21737'
G[39334]='K1040 L104 E21570'
G[39335]='K1060 L106 E21570'
G[39336]='K1060 L106 E21570'
G[39337]='K1080 L108 E21570'
G[39338]='K1080 L108 E21570'
G[39339]='K1100 L110 E21570'
G[39340]='K1100 L110 E21570'
G[39341]='K1100 L110 E21570'
G[39342]='K1100 L110 E21737'
G[39343]='K1100 L110 E21655'
G[39344]='K1100 L110 E21737'
G[39345]='K1100 L110 E21737'
G[39346]='K1100 L110 E21570'
G[39347]='K1100 L110 E21570'
G[39348]='K1100 L110 E21570'
G[39349]='E21570'
G[39350]='K1100 L110 E21570'
G[39351]='K1100 L110 E21655'
G[39352]='E21570'
G[39353]='E21570'
G[39354]='K0000 L098 A:95202 T:95202 P:38384 E21570'
G[39355]='K1000 L100 A:100128231 TA:93812 TH:94801 P:j10378+FA+39665,j10378+FH+39676 E20157'
G[39356]='K1000 L100 A:100128232 TA:93812 TH:94801 P:j10374+FA+39665,j10374+FH+39676 E20157'
G[39357]='T:100409 E21570'
G[39358]='K1000 L100 A:100128250 TA:93812 TH:94801 P:FA+T73762999,FH+T73862999 E20157'
G[39359]='K1000 L100 A:100128491 TA:93812 TH:94801 P:FA+T73750999,FH+T73850999 E20157'
G[39360]='K1000 L100 A:100128252 TA:93812 TH:94801 P:j10379+FA+39665,j10379+FH+39676 E20157'
G[39361]='K1000 L100 E20157'
G[39362]='K1000 L100 E20157'
G[39363]='K1000 L100 A:100128255 TA:93812 TH:94801 P:j10377+FA+39665,j10377+FH+39676 E20157'
G[39364]='K1000 L100 A:100128256 TA:93812 TH:94801 P:j10376+FA+39665,j10376+FH+39676 E20157'
G[39365]='K1000 L100 A:100128257 TA:93812 TH:94801 P:j10375+FA+39665,j10375+FH+39676 E20157'
G[39366]='K1000 L100 A:100128258 TA:93812 TH:94801 P:j10373+FA+39665,j10373+FH+39676 E20157'
G[39367]='K1000 L100 E20157'
G[39368]='K1000 L100 E20157'
G[39369]='K1000 L100 E20157'
G[39370]='K1000 L100 E20157'
G[39371]='SP K00032768 L098 M109 A:-101024 T:-1024 E21570'
G[39372]='K0000 L098 A:95256 T:95256 P:38912 E21570'
G[39373]='K0000 L098 A:95256 T:95256 P:38912 E21570'
G[39374]='K0000 L098 A:95256 T:95256 P:39873+39373+39372 E21570'	--TODO: Yoshimo: check if 39372 & 39373 are required
G[39375]='T:91871 E20173'	-- Suspiciously glowing chest	945:46.23,46.93
G[39376]='T:93125 E20173'
G[39377]='T:92606 E20173'
G[39378]='T:93001 E20157'
G[39379]='T:92819 E20173'	-- Eyepiercer
G[39380]='T:90429 E20173'
G[39381]='K0000 L098 A:96286 T:95421 P:39860 E21570'
G[39382]='E21570'
G[39383]='K0000 L098 A:95395 T:95396 P:38382 E21570'
G[39384]='K0000 L098 A:95396 T:91650 P:39383 E21570'
G[39385]='K0000 L098 A:1243454 T:93603 P:1 E21570'
G[39386]='K0000 L098 A:94409 T:96513 P:40228 E21570'
G[39387]='K0000 L098 A:95410 T:93826 P:39322 E21570'
G[39388]='K0000 L098 E21655'
G[39389]='K0000 L103 E21570'
G[39390]='K1000 L100 E21570'
G[39391]='K0000 L098 A:95421 T:95421 P:39381 E21570'
G[39392]='K0000 L098 A:94409 T:94409 P:40170 E21570'
G[39393]='K00032768 L098 M109 A:95395 T:-1018 P:38382 E21570'	-- gotten automatically when turning in 38382
G[39394]='FA K1000 L100 A:92120 T:93658 P:38462 E20157'
G[39395]='SP K1000 L100 A:92338 T:92338 P:38463,39394 U468 E20157'
G[39396]='T:92338 E20157'
G[39397]='E21570'
G[39398]='E20157'
G[39399]='T:92766 E20157'	-- Akrrilo
G[39400]='T:92817 E20157'	-- Rendarr
G[39401]='K0000 L100 A:594789 T:594789 P:39243 I:39404 E20157'
G[39404]='K0000 L100 A:593822 T:593822 P:39056 I:39401 E20008'
G[39405]='K0000 L098 A:1251571 T:-1017 P:1 E21570'
G[39406]='T:92817 E20157'
G[39407]='T:92817 E20157'
G[39408]='T:95056 E20157'
G[39409]='SP K000131072 A:1234147 T:1234147 E20157'
G[39410]='T:93812 E20157'
G[39411]='T:92766 E20157'
G[39412]='T:85514 E20157'
G[39413]='T:92817 E20157'
G[39414]='T:85514 E20157'	-- ?? treasure... "Young Orc Traveler" 75072 941:54.84,35.45
G[39415]='T:92817 E20157'
G[39416]='T:92766 E20157'
G[39417]='K0000 L098 E21570'
G[39418]='E21570'
G[39419]='K0000 L098 A:94522 T:94522 E21570'
G[39420]='E21570'
G[39422]='K0000 L100 A:90309 TP:93822:X39056;593822:C39056 P:38445 E20157'	-- X39056 is as close as we can get....really it should be not accepted which we do not have
G[39423]='FH K0000 L100 A:90481 T:94789 P:37935 E20157'	-- TODO: Make T:594789 assuming 39243 has been accepted/turned in
G[39424]='K1100 L110 A:103155 P:0 E21655'	-- TODO: Yoshimo : check for WQ & nightfallen rep
G[39425]='K0000 L098 A:95421 T:95421 P:39381 E21570'
G[39426]='K0000 L098 A:95421 T:96453 P:39391+39425+39588 E21570'	--TODO: Yoshimo: verify 39425 39391
G[39427]='K0000 L098 E21570'
G[39428]='E21570'
G[39429]='K0000 L098 A:95410 T:95410 P:38910 E21570'
G[39430]='K1040 L104 E21570'
G[39431]='K1080 L108 E21570'
G[39432]='K1000 L100 AA:95424 AH:595424 TA:95424 TH:595424 P:FA+E38445,FH+E37935 E20157'
G[39433]='K1002 L100 AA:95424 AH:595424 TA:95424 TH:595424 P:39432 E20157'
G[39434]='T:92977 E20157'
G[39435]='T:95204 E21570'
G[39436]='K1100 L110 E21570'
G[39437]='K0000 L098 A:95799 T:95799 P:39440 E21570'
G[39438]='K0000 L098 A:95799 T:95799 P:39440 E21570'
G[39439]='K0000 L098 A:95799 T:95799 P:39440 E21570'
G[39440]='K0000 L098 A:95799 T:95799 P:40229 E21570'
G[39441]='K1002 L100 A:90974 T:90851 E20157'
G[39442]='K1000 L100 E20157'
G[39443]='K1002 L100 A:90974 T:92873 E20157'
G[39444]='K1000 L100 A:96014 T:90497 E20157'
G[39445]='K1002 L100 A:96147 T:91721 E20157'
G[39446]='K1000 L100 A:96014 E20157'
G[39447]='SP K1002 L100 A:-945 T:-945 E20157'
G[39448]='K1000 L100 E20157'
G[39449]='K1002 L100 A:-945 T:90286 E20157'
G[39450]='K1000 L100 A:91324 E20157'
G[39451]='K1002 A:90974 T:90074 E20157'
G[39452]='K1002 A:91324 E20157'
G[39453]='K1000 L100 A:90974 T:92396 E20157'
G[39454]='K1000 L100 E20157'
G[39455]='K0000 L098 A:95256 T:93836 P:39374 E21570'
G[39456]='K0000 L098 A:95392 T:93826 P:40229 E21570'
G[39460]='E21570'
G[39461]='E20157'
G[39462]='K1100 L110 A:103155 T:101997 P:0 E21655'	-- TODO: Yoshimo : check for WQ & nightfallen rep
G[39463]='E20157'
G[39464]='E21570'
G[39465]='T:95872 E21570'
G[39466]='T:94986 E21570'
G[39467]='E21570'
G[39468]='T:92766 E20157'
G[39469]='SP K000131072 A:1243690 T:1243690 E20157'
G[39470]='SP K000131072 A:1243693 T:1243693 E20157'
G[39471]='E21570'
G[39472]='K0000 L098 A:1243700 T:94318 E21570'
G[39473]='T:92817 E20157'
G[39474]='T:92817 E20157'
G[39475]='T:92817 E20157'
G[39476]='T:90977 E20157'
G[39477]='T:90977 E20157'
G[39478]='T:90977 E20157'
G[39479]='T:90885 E20157'
G[39480]='T:90885 E20157'
G[39481]='T:90885 E20157'
G[39482]='T:95056 E20157'
G[39483]='T:95056 E20157'
G[39484]='T:80005 E20157'
G[39485]='T:80005 E20157'
G[39487]='K0000 L098 A:96038 T:96038 P:39488+39489 E21570'
G[39488]='K0000 L098 A:96520 T:96038 P:39661 E21570'
G[39489]='K0000 L098 A:96038 T:96038 P:39661 E21570'
G[39490]='K0000 L098 A:95191 T:95191 P:38911 E21570'
G[39491]='K0000 L098 A:93833 T:93833 P:38911 E21570'
G[39493]='K1100 L110 E21570'
G[39494]='E21570'
G[39495]='K0990 L098 A:96436 T:93127 P:39262 E21570'
G[39496]='K0000 L098 A:93833 T:95186 P:39490+39272+39491 E21570'	-- TODO: Verify requires 39272 39491
G[39497]='T:95976 E20157'
G[39498]='K0000 L098 A:96038 T:97662 P:39487 E21570'
G[39499]='K1000 L100 A:95659 T:95659 E20157'
G[39500]='K1000 L100 A:95659 T:95659 E20173'
G[39501]='K1000 L100 E20363'
G[39502]='K1000 L100 A:95659 T:95659 E20363'
G[39503]='T:94147 E21570'
G[39504]='K1000 L100 A:95659 T:95659 E20363'
G[39505]='K1000 L100 E20395'
G[39506]='K1100 L110 E21570'
G[39507]='E21570'
G[39508]='K1100 L110 E21570'
G[39509]='FH K1002 L100 A:96014 T:96014 P:w1071 I:39567 E20157 D108'
G[39510]='FH K1002 A:96014 T:96014 P:w1071 I:39568 E20157 D108'
G[39511]='FH K1002 L100 A:96014 T:96014 P:w1071 I:39569 E20157 D108'
G[39512]='FH K1002 L100 A:96014 T:96014 P:w1071 I:39570 E20157 D108'
G[39513]='FH K1002 L100 A:96014 T:96014 P:w1071 I:39571 E20157 D108'
G[39514]='FH K1002 L100 A:96014 T:96014 P:w1071 I:39573 E20157 D108'
G[39515]='K0980 L098 A:93127 T:93127 P:40051+39518 E21570'	-- Night Elf
G[39516]='K0990 L098 A:93127 T:93127 P:40051+39517 E21570'	-- Night Elf
G[39517]='CE T:99045 I:39518 E21570'
G[39518]='CE T:99045 I:39517 E21570'
G[39519]='FH K1002 L100 A:93396 T:93396 P:E37935 I:39581 E20157 D106'
G[39520]='K1000 L100 E20157'
G[39521]='K1000 L100 E20157'
G[39522]='K1000 L100 E20157'
G[39523]='K1000 L100 E20157'
G[39524]='K1000 L100 E20157'
G[39525]='E20157'
G[39526]='K1002 L100 A:96014 T:96014 P:w1071 I:39574 E20157'
G[39527]='E21570'
G[39528]='E21570'
G[39529]='FH K1002 L100 A:93396 T:93396 P:E37935 I:39582 E20157 D106'
G[39530]='K0004096 L098 A:96469 T:96586 P:41105 E21570'
G[39531]='E21570'
G[39532]='FH K1002 L100 A:93396 T:93396 P:E37935 I:39586 E20157 D106'
G[39533]='E21570'
G[39534]='E21570'
G[39535]='E21570'
G[39536]='E21570'
G[39537]='E21570'
G[39538]='E21570'
G[39539]='E21570'
G[39540]='E21570'
G[39541]='E21570'
G[39542]='E21570'
G[39543]='E21570'
G[39544]='E21570'
G[39545]='E21570'
G[39546]='E21570'
G[39547]='E21570'
G[39548]='E21570'
G[39549]='E21570'
G[39550]='E21570'
G[39551]='E21570'
G[39552]='E21570'
G[39553]='E21570'
G[39554]='E21570'
G[39555]='E21570'
G[39556]='E21570'
G[39557]='E21570'
G[39558]='E21570'
G[39559]='E21570'
G[39560]='E21570'
G[39561]='T:93003 E20157'
G[39564]='T:92766 E20157'
G[39565]='K1004 L100 A:92805 T:92805 P:FA+E38445,FH+E37935 E20157'
G[39566]='K1000 L100 E21570'
G[39567]='FA K1002 L100 A:90974 T:90974 P:w1041 I:39509 E20157 D105'
G[39568]='FA K1002 A:90974 T:90974 P:w1041 I:39510 E20157 D105'
G[39569]='FA K1002 L100 A:90974 T:90974 P:w1041 I:39511 E20157 D105'
G[39570]='FA K1002 L100 A:90974 T:90974 P:w1041 I:39512 E20157 D105'
G[39571]='FA K1002 L100 A:90974 T:90974 P:w1041 I:39513 E20157 D105'
G[39572]='K0000 L098 A:95130 T:96084 P:39323 E21570'
G[39573]='FA K1002 L100 A:90974 T:90974 P:w1041 I:39514 E20157 D105'
G[39574]='K1002 L100 A:90974 T:90974 P:w1041 I:39526 E20157'
G[39575]='K0000 L098 A:94571 T:99153 P:38916 E21570'
G[39576]='K0000 L098 A:99153 T:98957 E21570'
G[39577]='K0000 L098 A:99190 T:96270 P:39578 E21570'
G[39578]='K0000 L098 A:108069 T:99190 P:40219 E21570'
G[39579]='K0000 L098 A:96270 T:108305 P:39577 E21570'
G[39580]='K0000 L098 A:108305 T:108434 P:39579 E21570'
G[39581]='K1002 L100 A:96147 T:96147 P:E38445 I:39519 E20157 D103'
G[39582]='K1002 L100 A:96147 T:96147 P:E38445 I:39529 E20157 D103'
G[39586]='K1002 L100 A:96147 T:96147 P:E38445 I:39532 E20157 D103'
G[39588]='K0000 L098 A:95421 T:95421 P:39381 E21570'
G[39589]='E21570'
G[39590]='K0000 L098 A:96254 T:1243836 P:38331 E21570'
G[39591]='K0000 L098 A:1243836 T:93110 TP:1243836:X39593;96257:39593 P:39590 E21570'
G[39592]='K0000 L098 A:1243836 T:93110 TP:1243836:X39593;96257:39593 P:39590 E21570'
G[39593]='K0000 L098 A:1243836 T:1243836 P:39590 E21570'
G[39594]='K0000 L098 A:96257 T:96258 P:39591+39592+39593 E21570'
G[39595]='K0000 L098 A:100128511 TP:96258:E39594;1243836 E21570'
G[39596]='T:95318 E21570'
G[39597]='K0000 L098 A:96258 T:96254 P:39594 E21570'
G[39601]='K0000 L100 A:593822 T:90974 P:39056 E20157'
G[39602]='K1100 L110 E21570'
G[39604]='K0000 L100 A:594789 T:96014 P:39676 E20157'
G[39605]='K1100 L110 E21655'
G[39606]='SP K000131072 A:1251124 T:1251124 E21570'
G[39607]='T:96135 E21570'
G[39608]='E20395'
G[39609]='E20395'
G[39610]='E20395'
G[39611]='E20395'
G[39612]='E20395'
G[39613]='E20395'
G[39614]='K0000 L098 A:95186 T:95186 P:39496 E21570'
G[39615]='E20395'
G[39616]='E20395'
G[39617]='E20395'	-- Arachnis 971:73.09,363.37
G[39618]='E21570'
G[39619]='E21570'
G[39620]='E21570'
G[39621]='E21570'
G[39622]='E21570'
G[39623]='E21570'
G[39624]='E21570'
G[39625]='E21570'
G[39626]='E21570'
G[39627]='E21570'
G[39628]='E21570'
G[39629]='E21570'
G[39630]='E21570'
G[39631]='E21570'
G[39632]='E21570'
G[39633]='E21570'
G[39634]='E21570'
G[39635]='E21570'
G[39636]='E21570'
G[39637]='E21570'
G[39638]='E21570'
G[39639]='E21570'
G[39640]='E21570'
G[39641]='E21570'
G[39642]='E21570'
G[39643]='E21570'
G[39644]='E21570'
G[39645]='K1100 L110 E21737'
G[39646]='T:96410 E21570'
G[39647]='K1000 L090 E21570'
G[39648]='HV K0002 L100 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39649]='HV K0002 L100 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39651]='HV K0002 L100 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39652]='K0000 L098 A:96465 T:92218 P:38413+38414+40568 E21570'	-- TODO: vrify 40568
G[39654]='K0004096 L098 A:93823 T:96469 P:42815 E21570'
G[39655]='K0000 L100 A:593822 T:593822 P:39404 I:39674 E20157'
G[39656]='K0000 L098 A:96513 T:96513 P:39670 E21570'
G[39657]='SP HW K0000 L001 AA:1243912 AH:3243912 TA:1243912 TH:3243912 E20395'
G[39658]='K0000 L010 T:1180746 E20395'
G[39659]='K0000 L010 T:1187236 E20395'
G[39661]='K0000 L098 A:95956 T:96520 P:39277+39614+39316 E21570'	-- TODO: Verify requires 39614
G[39663]='K0990 L098 A:93127 T:97297 P:38819+38727+39516|39515 E21570'
G[39665]='K0000 L100 A:93812 T:593822 P:39666 I:39676 E20157'
G[39666]='K0000 L100 A:593822 T:93812 P:39655 I:39675 E20157'
G[39667]='K1100 L110 E21655'
G[39668]='HV K0002 L100 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39670]='K0000 L098 A:96513 T:96513 O:39386 E21570'	-- TODO: Was P:39386, but changed to breadcrumb because it was found available while exploring
G[39671]='E20395'
G[39674]='K0000 L100 A:594789 T:594789 P:39401 I:39655 E20157'
G[39675]='K0000 L100 A:594789 T:94801 P:39674 I:39666 E20157'
G[39676]='K0000 L100 A:94801 T:594789 P:39675 I:39665 E20157'
G[39680]='K1080 L108 E21655'
G[39681]='K1000 L100 A:92183 T:97261 E21570'
G[39682]='K1000 L098 A:596665 T:97643 P:38723,40253 E21570'
G[39683]='K1000 L098 A:96675 T:96675 P:39682+39517 E21570'
G[39684]='K1000 L098 A:97643 T:96675 P:39682 E21570'
G[39685]='K1000 L098 A:97643 T:96675 P:39682 E21570'
G[39686]='K1000 L098 A:96675 T:97644 P:39683|40254+39684+39685 E21570'
G[39687]='E21570'
G[39688]='FA K1000 L098 A:97644 TP:96669:40375;96666:40374 P:40373+39517 E21570'	-- Night Elf Havoc Sunfury
G[39689]='K1000 L098 A:97978 T:97978 P:39688,40255 E21570'
G[39690]='K1000 L098 A:97978 T:97978 P:39694,40256 E21570'
G[39691]='FA K1000 L098 A:97296 T:102585 P:39689 E21691'
G[39692]='K1000 L098 E21655'
G[39693]='E21691'
G[39694]='FH K1000 L098 A:97644 TP:96669:40375;96666:40374 P:40373+39517 E21570'
G[39695]='E21570'
G[39696]='K0000 L101 E21691'
G[39697]='K1000 L100 AA:92213 TA:92213 P:39057 E20157'
G[39698]='K0000 L098 A:96686 T:596686 P:38307 E21570'
G[39699]='K1040 L104 E21655'
G[39702]='K1080 L108 E21570'
G[39709]='T:93812 E20157'
G[39710]='E20157'
G[39711]='T:90977 E20157'
G[39712]='E20395'
G[39713]='E20157'
G[39714]='E20395'
G[39715]='E20395'
G[39716]='HW K0002 L100 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=09713,FH+=09763 E20395'	-- why is =09763 failed for Horde, but =09713 true for the same Horde?  is there only really 971 internally?
G[39717]='E21570'
G[39718]='K0000 L098 AP:98000:ND;98613:NE;98695:NM;102669:NH;102589:NT;98093:NR;97389:NW;93787:NP T:86563 P:B40653+ND,B39756+NP,B40585+NW,B40997+NR,B41019+NT,B41141+NM,B41099,B41069 E21570'	-- now we cannot accept them all (at least in live)
G[39719]='HW K0002 L100 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=09713,FH+=09763 E20395'
G[39720]='HW K0002 L100 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=09713,FH+=09763 E20395'
G[39721]='HW K0002 L100 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=09713,FH+=09763 E20395'
G[39722]='K0000 L098 A:91866 T:91866 P:38566 E21570'
G[39723]='E20157'
G[39724]='T:89741 E20157'
G[39725]='T:93812 E20157'
G[39726]='K1080 L108 E21655'
G[39727]='E20157'
G[39728]='E20157'
G[39729]='K1080 L108 E21655'
G[39730]='E21570'
G[39731]='K0000 L098 AP:98613:NE;98695:NM;102669:NH;102589:NT;98093:NR T:91172 E21570'	-- TODO: Determine prerequisite...started with the initial one...got the quest to return back to here.  2016-09-09:  When you accept one of these, the others on the map are not permitted.  However, if you drop it, all are once again available.  To get the map quests back you need to complete something based on each zone.  For this chain, turning in 39861 makes the board available again.
G[39732]='E21570'
G[39733]='K0000 L098 A:98613 T:97666 E21570'	-- TODO: Determine quest that clears it. table quest.  cannot determine what clears this from Nimhfree because this is the last one.
G[39734]='E21570'
G[39735]='FA K0000 L098 A:98613 T:96644 E21570'	-- All these table quests, A:98613 seem to have a prerequisite that says you need to have completed any you have selected previously before you can get another one.  However, if you do not close the map, you can select more than one.  This should allow you to get them all, except perhaps for the very first one you get while you are on a quest to get from the table.  *** previous comment from Demon Hunter line.  same quest available from Druid "table" as well. *** the Hunter quest starts at NPC 102669.  98613 is the Demon Hunter quest giver.  2016-09-09:  When this one is turned in, the map table is open again.
G[39736]='E20157'
G[39737]='E20157'
G[39738]='E20157'
G[39739]='E20157'
G[39740]='E20157'
G[39741]='K0000 L103 A:108571 T:98632 E21570'	--also completes 42665
G[39742]='K10032768 L098 A:-1032 T:-1032 E21570'
G[39743]='E21570'
G[39744]='E21570'
G[39745]='E21570'
G[39746]='K0000 L098 E21570'
G[39748]='T:77789 E20157'
G[39749]='T:93812 E20157'
G[39750]='E20157'
G[39751]='E20157'
G[39752]='E20157'
G[39753]='E20157'
G[39756]='K0000 L098 A:90250 T:90250 P:39787,38933 E21570'
G[39757]='K0000 L098 A:97111 T:97072 E21570'
G[39758]='E20395'
G[39759]='E20395'
G[39761]='K0000 L098 A:97072 T:97072 E21570'
G[39762]='T:97093 E21570'
G[39763]='K1100 L110 E21655'
G[39764]='K0000 L098 A:97094 T:97846 E21570'	--TODO: Yoshimo : check for prequests (so far looks like none are needed)
G[39765]='K1010 A:96984 T:96984 E21570'	--TODO: Yoshimo : check for prequests (so far looks like none are needed)
G[39766]='SP K000131072 A:1244446 T:1244446 E21570'
G[39767]='E20395'
G[39768]='K1010 A:96984 T:96984 E21570'	--TODO: Yoshimo : check for prequests (so far looks like none are needed)
G[39769]='K1010 A:96984 T:97130 P:39765 E21570'	--TODO: Yoshimo : 39768 might be needed too
G[39771]='K0000 L098 E21570'
G[39772]='K1010 A:97130 T:96984 P:40345 E21570'
G[39773]='K0000 L098 A:97094 T:97846 E21570'
G[39774]='K0000 L098 A:97846 T:97193 P:39764+39773 E21570'	-- TODO: Verify requires 39773
G[39775]='K0000 L098 A:107840 T:91222 E21570'	--TODO: Yoshimo: verify P:, as alliance  P:38362 is wrong
G[39776]='K0000 L098 A:93846 T:93846 P:38915 E21570'
G[39777]='K0000 L098 A:97344 T:97344 P:38915 E21570'
G[39778]='E21953'
G[39779]='E21953'
G[39780]='K0000 L098 A:97407 T:93846 P:40594 E21570'	--TODO: Yoshimo: seems to also complete 41245 & 42478
G[39781]='K0000 L098 A:93846 T:1250548 P:39780 E21570'
G[39782]='T:111578 E21570'
G[39783]='T:96637 E20395'
G[39784]='E21570'
G[39785]='E21655'
G[39786]='K0000 L098 A:107674 T:107674 P:39787+39793 E21570'	-- TODO: verify 39793
G[39787]='K0000 L098 A:107674 T:107674 P:39789 E21570'
G[39788]='K0000 L098 A:93231 T:93231 P:39796 E21570'
G[39789]='K0000 L098 A:97258 T:107675 E21570'
G[39790]='K1100 L110 E21655'
G[39791]='K0000 L098 A:93231 T:93446 P:38808+38810 E21570'	-- TODO: verify 38810
G[39792]='K0000 L098 A:107675 T:-1017 P:39787+39793 E21570'	-- TODO: verify 39793
G[39793]='K0000 L098 A:107675 T:107675 P:39789 E21570'
G[39794]='E21570'
G[39795]='E21570'
G[39796]='K0000 L098 A:92539 T:93231 P:39804 E21570'
G[39797]='E21570'
G[39798]='E21570'
G[39799]='K0000 L098 A:93568 T:93568 E21570'
G[39800]='K0000 L098 A:96663 T:90749 P:38206 E21570'	-- TODO: Also T:590749 when you are about to turn in 38060
G[39801]='K0000 L098 A:596686 T:0,91473 P:39698 E21570'
G[39802]='T:97326 E21570'
G[39803]='K0000 L098 A:97074 T:92539 P:38624 E21570'
G[39804]='K0000 L098 A:92539 T:92539 P:39803 E21570'
G[39805]='E21570'
G[39806]='T:97345 E21570'
G[39807]='E21570'
G[39808]='K1100 L110 E21570'
G[39809]='K1100 L110 E21570'
G[39810]='K1100 L110 E21570'
G[39811]='K1100 L110 E21570'
G[39812]='E21570'
G[39813]='K1100 L110 E21570'
G[39814]='K1100 L110 E21570'
G[39815]='K1100 L110 E21570'
G[39816]='K0000 L101 T:93456 E21691'
G[39817]='K1100 L110 E21655'
G[39818]='K0000 L101 T:109890 E21691'
G[39819]='K1100 L110 E21570'
G[39820]='K1100 L110 E21570'
G[39821]='K1100 L110 E21570'
G[39822]='K1100 L110 E21570'
G[39823]='K1100 L110 E21570'
G[39824]='E21570'
G[39825]='K1100 L110 E21570'
G[39826]='K1100 L110 E21570'
G[39827]='K1100 L110 E21570'
G[39828]='E20395'
G[39829]='E20395'
G[39830]='K1100 L110 E21570'
G[39832]='K0000 L098 A:97072 T:93568 E21570'
G[39837]='K0000 L098 A:97319 T:91531 P:38818 E21570'
G[39838]='K1100 L110 A:97429 T:97429 P:44616 E21570'
G[39839]='K1100 L110 A:1244555 T:93531 P:39838 E21570'
G[39840]='FA K1100 L110 A:97718 T:90463 P:39863 E21691'
G[39841]='K1100 L110 A:90463 T:97361 P:39840 E21691'
G[39842]='K1100 L110 A:97361 T:97361 E21691'
G[39843]='K1100 L110 A:97361 T:97361 E21691'
G[39844]='K1100 L110 A:97361 T:97361 P:39841 E21691'
G[39845]='K1100 L110 A:97361 T:700356 E21796'
G[39846]='E21570'
G[39847]='K1000 L098 E21570'
G[39848]='K0000 L098 A:97480 T:1244559 P:38347 E21570'
G[39849]='K0000 L098 A:97480 T:97480 P:39857 E21570'
G[39850]='K0000 L098 A:97480 T:97480 P:39849 E21570'
G[39851]='K0000 L098 A:97480 T:97480 P:39849 E21570'
G[39852]='E21953'
G[39853]='K0000 L098 A:97480 T:97558 P:39850+39851 E21570'
G[39854]='E21570'
G[39855]='K0000 L098 A:97558 T:92539 P:39853 E21570'
G[39856]='T:97504 E21570'
G[39857]='K0000 L098 A:1244559 T:97480 P:39848 E21570'
G[39858]='T:97517 E21570'
G[39859]='K0000 L098 A:94434 T:94409 E21570'	-- no obvious prequests
G[39860]='K0000 L098 A:93836 T:96286 P:39455 E21570'
G[39861]='K0000 L098 A:91172 T:91462 P:39731 E21570'	-- I am guessing turning this in (and doing nothing else in the zone), allow my quest board to give me more quests to do...
G[39862]='K0000 L098 A:97301 T:97301 P:38915 E21570'
G[39863]='K1100 L110 A:97718 T:97718 P:39839 E21570'
G[39864]='FH K0000 L098 A:98632 T:596683 E21570'
G[39865]='E20395'
G[39866]='T:97593 E21570'
G[39867]='K000512 L098 A:95438 T:95438 P:39123 E21570'
G[39868]='E21570'
G[39869]='K0000 L098 E21570'
G[39870]='T:97630 E21570'
G[39871]='E21570'
G[39872]='P:40609 E21570'	-- you need to challenge and defeat Taurson first
G[39873]='K0000 L098 A:97667 T:1243402 P:38912 E21570'
G[39874]='K1000 L100 A:93531 T:93530 P:0 E21570'	-- TODO: Enchanter only
G[39875]='K1000 L100 A:93530 P:39874 E21570'
G[39876]='K1000 L100 E21655'
G[39877]='K1000 L100 E21655'
G[39878]='K1020 L102 E21655'
G[39879]='K1020 L102 E21655'
G[39880]='K1020 L102 E21655'
G[39881]='K1040 L104 E21655'
G[39882]='K1040 L104 E21655'
G[39883]='K1020 L102 E21655'
G[39884]='K1040 L104 E21655'
G[39889]='K1040 L104 E21655'
G[39891]='K1080 L108 E21655'
G[39896]='E21570'
G[39903]='K1060 L106 E21655'
G[39904]='K1060 L106 E21655'
G[39905]='K1000 L100 E21655'
G[39906]='K1080 L108 E21655'
G[39907]='K1080 L108 E21655'
G[39910]='K1080 L108 E21655'
G[39914]='K1080 L108 E21655'
G[39916]='K1080 L108 E21655'
G[39918]='K1080 L108 E21655'
G[39920]='K1100 L110 E21655'
G[39921]='K1100 L110 E21655'
G[39923]='K1100 L110 E21655'
G[39925]='E21570'
G[39926]='E21570'
G[39927]='E21570'
G[39928]='E21570'
G[39929]='E21570'
G[39930]='E21570'
G[39931]='K1000 L098 E21570'
G[39932]='K1000 L098 E21570'
G[39933]='K1000 L098 E21570'
G[39934]='K1020 L102 E21570'
G[39935]='K1020 L102 E21570'
G[39936]='K1020 L102 E21570'
G[39937]='K1020 L102 E21570'
G[39938]='K1020 L102 E21570'
G[39939]='K1020 L102 E21570'
G[39940]='K1020 L102 E21570'
G[39941]='K1020 L102 E21570'
G[39942]='K1080 L108 E21570'
G[39943]='K1020 L102 E21570'
G[39944]='K1040 L104 E21570'
G[39945]='K1040 L104 E21570'
G[39946]='K1040 L104 E21570'
G[39947]='K1040 L104 E21570'
G[39948]='K1060 L106 E21570'
G[39949]='K1060 L106 E21570'
G[39950]='K1060 L106 E21570'
G[39951]='K1080 L108 E21570'
G[39952]='K1060 L106 E21570'
G[39953]='K1060 L106 E21570'
G[39954]='K1080 L108 E21570'
G[39955]='K1080 L108 E21570'
G[39956]='K1080 L108 E21655'
G[39957]='K1100 L110 E21655'
G[39958]='K1000 L098 A:93523 T:93523 P:0 E21570'	--TODO: Yoshimo: probably leatherworking
G[39959]='K1080 L108 E21570'
G[39960]='K1080 L108 E21570'
G[39961]='K1080 L108 E21570'
G[39962]='K0000 L098 E21570'
G[39963]='T:97793 E21570'
G[39964]='K1100 L110 E21570'
G[39965]='K1100 L110 E21570'
G[39966]='K1100 L110 E21570'
G[39967]='K1100 L110 E21570'
G[39968]='K1100 L110 E21570'
G[39969]='K0000 L098 E21570'
G[39970]='T:105316 E21570'
G[39971]='T:96400 E21570'
G[39972]='SP K000131072 A:1244692 T:1244692 E21570'
G[39973]='SP K000131072 A:1244694 T:1244694 E21570'
G[39974]='T:700612 E21570'
G[39975]='T:97706 E21570'
G[39976]='E21570'
G[39977]='T:99759 E21570'
G[39978]='E21570'
G[39979]='E21570'
G[39980]='E21570'
G[39981]='E21570'
G[39982]='E21570'
G[39983]='K0000 L098 A:98825 T:97891 P:40520 E21570'
G[39984]='K0000 L098 A:1244708 T:97973 E21570'
G[39985]='K1100 L110 A:95688 T:90417 E21570'
G[39986]='K1100 L110 A:90417 T:90417 P:39985 E21570'
G[39987]='K1100 L110 A:90417 T:98312 P:39986 E21570'
G[39988]='K0000 L098 A:98794 T:97892 P:40112 E21570'
G[39989]='E21691'
G[39990]='K0000 L098 A:97892 T:97892 P:39988 E21570'
G[39991]='T:700556 E21570'
G[39992]='K0000 L098 A:97903 T:98825 P:40388 E21570'
G[39993]='E21570'
G[39994]='T:97933 E21570'
G[39995]='K1100 L110 E21570'
G[39996]='K1100 L110 E21570'
G[39997]='K1100 L110 E21570'
G[39998]='K0000 L098 A:97979 T:97851 P:0 E21570'	--TODO: Yoshimo: find conditions
G[39999]='K1100 L110 E21570'
G[40000]='K0000 L098 A:97974 T:97974 E21570'	-- no obvious prequest
G[40001]='K0000 L098 A:92539 T:97979 P:40078 E21570'
G[40002]='K0000 L098 A:97979 T:97979 P:40001 E21570'
G[40003]='K1040 A:97979 T:97986 P:40002 E21570'
G[40004]='K0000 L098 A:97979 T:97986 P:40002 E21570'	-- TODO: Yoshimo: verify 40002
G[40005]='K0000 L098 A:97986 T:97988 P:40004+40003 E21570'	-- TODO: Yoshimo: verify 40004
G[40006]='K1100 L110 E21570'
G[40007]='K1100 L110 E21570'
G[40008]='K1100 L110 A:98312 T:700118 P:39987 E21570'
G[40009]='K1100 L110 A:700118 T:700118 P:40123 E21570'
G[40010]='K1100 L110 A:97140 T:102600 P:40956 E21570'
G[40011]='K1100 L110 A:97140 T:101499 P:42229 E21570'
G[40012]='K1100 L110 A:93446 T:1245328 P:42229 E21570'
G[40013]='K0000 L098 T:92464 E21570'
G[40014]='K0000 L098 A:92464 T:92464 P:1 E21570'	-- Nimhfree not given immediately in Dalaran, Yoshimo: add herbalism as condition, maybe also a quest
G[40015]='K0000 L098 E21570'
G[40016]='K0000 L098 E21570'
G[40017]='K0000 L098 E21570'
G[40018]='K0000 L098 E21570'
G[40019]='K0000 L098 P:40018 E21570'
G[40020]='K0000 L098 E21570'
G[40021]='K0000 L098 E21570'
G[40022]='K0000 L098 E21570'
G[40023]='K0000 L098 E21570'
G[40024]='K0000 L098 E21570'
G[40025]='K0000 L098 E21570'
G[40026]='K0000 L098 E21570'
G[40028]='K0000 L098 E21570'
G[40029]='K0000 L098 E21570'
G[40030]='K0000 L098 E21570'
G[40031]='K0000 L098 E21570'
G[40032]='K0000 L098 E21570'
G[40033]='K0000 L098 E21570'
G[40034]='K0000 L098 E21570'
G[40035]='K0000 L098 P:40034 E21570'
G[40036]='K0000 L098 E21570'
G[40037]='K0000 L098 E21570'
G[40038]='K0000 L098 E21570'
G[40039]='K0000 L098 E21570'
G[40040]='K0000 L098 E21570'
G[40041]='K0000 L098 E21570'
G[40042]='K0000 L098 E21570'
G[40043]='K0000 L098 E21570'
G[40044]='K0000 L098 A:97973 T:97973 P:39984 E21570'
G[40045]='K0000 L098 A:98067 T:98067 O:40244 E21570'	-- TODO: Originally was P:40244 which is wrong.  Verify.
G[40046]='K0000 L098 A:97973 T:97973 P:39984 E21570'
G[40047]='K0000 L098 A:98067 T:98067 O:40244 E21570'	-- TODO: Originally was P:40244 which is wrong.  Verify.
G[40048]='K1000 L100 E21655'
G[40049]='K0000 L098 A:98067 T:98067 O:40244 E21570'	-- TODO: Originally was P:40244 which is wrong.  Verify.
G[40050]='K0000 L098 M109 A:-121024 T:-1024 E21570'
G[40051]='K0990 L098 A:99045 T:93127 P:40222 E21570'
G[40052]='K1040 L104 E21570'
G[40056]='K1020 L102 E21570'
G[40057]='K1020 L102 E21570'
G[40058]='K1020 L102 E21570'
G[40059]='K1020 L102 E21570'
G[40060]='K1020 L102 E21570'
G[40061]='K1020 L102 E21570'
G[40062]='K1080 L108 E21570'
G[40063]='K1020 L102 E21570'
G[40064]='K1080 L108 E21570'
G[40065]='K1080 L108 E21570'
G[40066]='E21570'
G[40067]='E21570'
G[40068]='T:98188 E21570'
G[40069]='K0000 L098 A:94068 T:94068 E21570'	--no obvious prequest
G[40070]='K0000 L098 A:94068 T:94068 E21570'	--no obvious prequest
G[40071]='K0000 L098 A:94068 T:94068 E21570'	--no obvious prequest
G[40072]='K0000 L098 A:97988 T:1251991 P:40005 E21570'
G[40073]='T:98199 E20490'
G[40074]='E20490'
G[40075]='T:98198 E20490'
G[40076]='T:98486 E21570'
G[40077]='K0980 L098 CE A:93011 T:98229 E21531'
G[40078]='K0000 L098 A:92539 T:92539 P:39855 E21570'
G[40079]='T:98241 E21570'
G[40080]='T:700284 E21570'
G[40081]='T:98268 E21570'
G[40082]='SP K000131072 A:1244887 T:1244887 E21570'
G[40083]='SP K000131072 A:1233107 T:1233107 E21570'
G[40084]='T:98299 E21570'
G[40085]='SP K000131072 A:1244899 T:1244899 E21570'
G[40086]='SP K000131072 A:1244901 T:1244901 E21570'
G[40087]='T:-1028 E21570'	-- you get this when you sacrifice Sevis
G[40088]='SP K000131072 A:1244902 T:1244902 E21570'
G[40089]='SP K000131072 A:1244903 T:1244903 E21570'
G[40090]='SP K000131072 A:1244904 T:1244904 E21570'
G[40091]='SP K000131072 A:1244905 T:1244905 E21570'
G[40093]='SP K000131072 A:1244909 T:1244909 E21570'
G[40094]='SP K000131072 A:1244912 T:1244912 E21570'
G[40095]='SP K000131072 A:1244913 T:1244913 E21570'
G[40096]='T:98311 E21570'
G[40097]='E21570'
G[40098]='E21655'
G[40099]='SP K000131072 A:1244917 T:1244917 E21570'
G[40100]='E21570'
G[40101]='E21655'
G[40102]='K0000 L098 A:98067 T:98067 P:40045 E21570'	-- TODO: Yoshimo: check prequest (possible 440045 &440047)
G[40103]='E21570'
G[40104]='T:98285 E20490'
G[40105]='T:98283 E20490'
G[40106]='T:98284 E20490'
G[40107]='T:98408 E20490'
G[40108]='E21570'
G[40109]='T:98421 E21570'
G[40111]='K0000 L098 A:98587 T:98498 E21570'
G[40112]='K0000 L098 A:97891 T:98794 P:39983 E21570'	-- if you abandon this, you will no longer get it from 97891 but rather from 98825
G[40113]='T:98503 E21570'
G[40114]='K1100 L110 E21570'
G[40115]='K1100 L110 E21570'
G[40116]='K1100 L110 E21570'
G[40120]='K0000 L098 A:98587 T:98587 E21570'
G[40121]='K0000 L098 E21570'
G[40122]='K0000 L098 A:91462 T:91109 P:39861 E21570'
G[40123]='K1100 L110 A:700118 T:700118 P:40008 E21570'
G[40124]='E21570'
G[40125]='K1100 L110 E21570'
G[40126]='T:95123 E21570'
G[40127]='E21570'
G[40129]='K1100 L110 E21570'
G[40130]='K1080 L108 E21655'
G[40131]='K0000 L098 A:91824 T:93541 P:PS001 E21570'
G[40132]='K0000 L098 A:93541 T:93541 P:40131 E21570'
G[40133]='K0000 L098 A:578564 T:94409 E21570'
G[40134]='K0000 L098 A:94409 T:94409 P:1 E21570'
G[40135]='K0000 L098 A:94409 T:94409 P:1 E21570'
G[40136]='K0000 L098 A:98969 T:93541 E21655'
G[40137]='K0000 L098 A:93541 T:98720 E21570'
G[40138]='K0000 L098 A:98720 T:98720 E21570'
G[40139]='K0000 L098 A:98720 T:98720 E21570'
G[40140]='K0000 L098 A:98720 E22197'
G[40141]='K0000 L098 A:92414 T:93541 E21570'
G[40142]='K0000 L098 A:93541 T:93541 P:40141+PS001 E21570'
G[40143]='K0000 L098 A:98109 T:93541 E21570'
G[40144]='K0000 L098 A:93541 T:98791 P:PS001 E21570'
G[40145]='K0000 L098 A:98791 T:98791 P:40144 E21570'
G[40146]='K0000 L098 A:93541 T:98721 P:PS001 E21570'
G[40147]='K0000 L098 A:98721 T:98721 P:PS001 O:40146 E21570'
G[40148]='K0000 L098 A:98721 T:98721 P:PS001 E21570'
G[40149]='K0000 L098 A:98721 T:98721 P:PS001 E21570'
G[40151]='K0000 L098 E21570'
G[40152]='K0000 L098 E21570'
G[40153]='K0004096 L098 P:40955 E21570'
G[40154]='K0000 L098 E21570'
G[40155]='K0000 L098 E21916'
G[40156]='K1100 L110 A:98648 T:93541 E21570'
G[40157]='K1100 L110 A:93541 T:98720 P:0 E21570'
G[40158]='K1100 L110 A:98720 T:98720 P:0 E21570'
G[40159]='K1100 L110 A:93541 P:0 E21796'
G[40160]='K0000 L098 E21570'
G[40161]='K0000 L098 E21570'
G[40162]='K1100 L110 E21570'
G[40163]='K1100 L110 E21570'
G[40164]='E21570'
G[40166]='K0000 L098 E21570'
G[40167]='K0000 L098 A:98825 T:98825 P:40515 E21570'
G[40168]='Hf K0000 L071 A:100129747 T:98685 E20490'
G[40169]='K1080 L108 E21655'
G[40170]='K0000 L098 A:94409 T:94409 E21570'	--no obvious prequest
G[40173]='Hf K0000 L081 A:100129928 T:98690 E20490'
G[40175]='T:98890 E21570'
G[40176]='K1000 L098 A:93523 T:93523 E21570'
G[40177]='K1000 L098 A:93523 T:93522 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40178]='K1000 L098 A:93522 T:93522 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40179]='K1000 L098 A:93522 T:93522 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40180]='K1000 L098 A:93523 T:98931 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40181]='K1000 L098 A:98931 T:98931 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40182]='K1000 L098 A:98931 T:98931 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40183]='K1000 L098 A:93523 T:93523 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40184]='K1020 L102 A:93522 T:98948 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40185]='K1020 L102 A:98948 T:98948 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40186]='K1020 L102 A:98948 T:98948 P:0 E21570'	-- TODO: Yoshimo: looks like a leatherworking quest
G[40187]='K1020 L102 A:98931 T:98964 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40188]='K1020 L102 A:98964 T:98964 P:0 E21570'	-- TODO: Yoshimo: looks like a leatherworking quest
G[40189]='K1020 L102 A:98964 T:98964 P:0 E21570'	-- TODO: Yoshimo: looks like a leatherworking quest
G[40190]='K1040 L104 E21570'
G[40191]='K1040 L104 A:98948 T:98948 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40192]='K1040 L104 A:98948 T:98948 P:0 E21570'	-- TODO: Yoshimo: looks like a leatherworking quest
G[40193]='K1040 L104 E21655'
G[40194]='K1040 L104 A:98964 T:98964 P:0 E21570'	-- TODO: Yoshimo: looks like a leatherworking quest
G[40195]='K1040 L104 A:98964 T:99689 P:0 E21570'	-- TODO: Yoshimo: looks like a leatherworking quest
G[40196]='K1040 L104 A:93523 T:93523 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40197]='K1040 L104 A:93523 T:93523 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40198]='K1060 L106 A:93522 T:93522 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40199]='K1060 L106 A:98931 T:98931 E21570'
G[40200]='K1060 L106 A:93523 T:93523 P:0 E21570'
G[40201]='K1060 L106 A:93523 T:93523 E21570'
G[40202]='K1080 L108 A:93522 T:98948 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40203]='K1080 L108 A:98948 T:98948 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40204]='K1080 L108 A:98948 T:98948 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40205]='K1080 L108 A:98948 T:98948 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40206]='K1080 L108 A:98931 T:98964 E21570'
G[40207]='K1080 L108 A:98964 T:98964 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40208]='K1080 L108 A:98964 T:98964 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40209]='K1080 L108 A:98964 T:98964 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40210]='K1080 L108 A:98964 T:93523 P:0 E21570'	--TODO: Yoshimo: check if leatherworking only
G[40211]='K1100 L110 A:93523 T:98969 P:PL001 E21570'
G[40212]='K1100 L110 A:98969 T:98969 P:0 E21570'	-- TODO: Yoshimo : find P: (leatherworking)
G[40213]='K1100 L110 A:98969 T:98969 P:0 E21570'	-- TODO: Yoshimo : find P:
G[40214]='K1100 L110 A:98969 T:98969 P:0 E21655'	-- TODO: Yoshimo : find P:
G[40215]='K1100 L110 A:93523 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40216]='K0000 L098 A:94409 T:94409 P:39859+40170 E21570'
G[40217]='K0000 L098 A:99905 T:94409 P:1 E21570'
G[40218]='K0000 L103 E21570'
G[40219]='K0000 L098 A:99153 T:108069 P:39575 E21570'
G[40220]='K0000 L098 A:93600 T:93600 E21570'
G[40221]='K0000 L098 A:93600 T:93600 E21570'
G[40222]='K0990 L098 A:98711 T:99045 P:38725 E21570'
G[40223]='T:700598 E21570'
G[40224]='K0000 L098 E21570'
G[40225]='K0000 L098 E21570'
G[40227]='K1100 L110 A:99093 T:99093 P:40266+40744 E21570'	--TODO: Yoshimo : verify 40266 40744
G[40228]='K0000 L098 A:94409 T:94409 P:39392+39124+40216+39123 E21570'	-- TODO: Verify requires 39124 39123
G[40229]='K0000 L098 A:96453 T:95392 P:39426 E21570'
G[40230]='K0000 L098 A:98067 T:98067 P:40045 E21570'	-- TODO: Yoshimo: check prequest (possible 40047& 40045)
G[40231]='E21570'
G[40232]='T:97059 E21570'
G[40233]='T:97057 E21570'
G[40234]='T:97370 E21570'
G[40235]='K0000 L100 A:99180 E20490'
G[40236]='K0000 L098 A:99181 T:100438 P:12103 E21570'
G[40237]='K0000 L100 A:99183 T:99183 E20490'
G[40240]='E21570'
G[40241]='K1060 L106 E21570'
G[40242]='T:95290 E21570'
G[40243]='E21691'
G[40244]='K0000 L098 A:94409 T:98067 P:40228 E21570'	-- TODO: Yoshimo: check if needed for all quests at Shipwreck Cove
G[40245]='E21570'
G[40246]='E21570'
G[40247]='K0004096 L098 A:99247 T:90417 P:40814+40818 E21570'
G[40249]='K0004096 L098 A:99247 T:102799 P:41807+40374 E21570'
G[40250]='E21570'
G[40251]='SP A:96997 T:96997 E21570'
G[40252]='E21570'
G[40253]='K1000 L098 A:592718 T:596665 P:38690+38689+39518 E21570'
G[40254]='K1000 L098 A:96675 T:96675 P:39682+39518 E21570'
G[40255]='FA K1000 L098 A:97644 TP:96669:40375;96666:40374 P:40373+39518 E21570'	-- Night Elf Tank Altruis, Night Elf Tank Kayn
G[40256]='FH K1000 L098 A:97644 TP:96669:40375;96666:40374 P:40373+39518 E21570'	-- Blood Elf Tank Kayn
G[40257]='K1100 L110 E21570'
G[40258]='E21570'
G[40259]='K1100 L110 E21570'
G[40260]='E21570'
G[40261]='K1100 L110 E21570'
G[40265]='K1060 L106 E21655'
G[40266]='K1100 L110 A:94346 T:99093 E21570'
G[40267]='K0004096 L098 A:102700 T:99398 P:41085+41080 E21570'
G[40268]='K1100 L110 E21570'
G[40269]='K1100 L110 E21570'
G[40270]='K0004096 L098 A:99398 T:99415 P:40267 E21570'
G[40272]='E21570'
G[40273]='E21570'
G[40274]='T:700606 E21570'
G[40276]='K0000 L098 E21570'
G[40277]='K1100 L110 E21691'
G[40278]='K1100 L110 T:103245 E21796'
G[40279]='K1100 L110 E21570'
G[40280]='K1100 L110 E21570'
G[40282]='K1100 L110 E21655'
G[40296]='E21570'
G[40297]='K1100 L110 A:98801 T:99514 E21570'
G[40298]='K1100 L110 A:98648 T:94691 E21737'
G[40299]='K1100 L110 E21570'
G[40300]='K1100 L110 A:99093 T:99483 P:40227 E21570'
G[40301]='T:97069 E21570'
G[40302]='E21570'
G[40303]='E21570'
G[40304]='E21570'
G[40305]='E21570'
G[40306]='K1100 L110 A:99483 P:40300 E21570'
G[40307]='K1100 L110 A:99514 T:99514 P:40297 E21570'
G[40308]='K1100 L110 A:1245688 T:99483 E21570'
G[40310]='K0000 L001 E21570'
G[40311]='E21691'
G[40313]='E21570'
G[40314]='E21570'
G[40315]='K1100 L110 A:99575 P:40306+40578 E21570'	--TODO: Yoshimo: verify 40578
G[40316]='K0000 L098 M109 A:-111024 T:-1024 E21570'
G[40317]='E21570'
G[40319]='K1100 L110 A:99575 T:99575 P:40315 E21570'
G[40320]='K1100 L110 A:99544 T:102334 E21570'
G[40321]='K1100 L110 A:99575 T:100779 P:40319 E21570'
G[40322]='K1100 L110 E21570'
G[40323]='K1100 L110 E21570'
G[40324]='K1100 L110 A:97140 T:97140 P:41138 E21570'
G[40325]='K1100 L110 A:97140 T:97140 P:40324 E21570'
G[40326]='K1100 L110 A:1245328 T:1247694 P:40012 E21570'	-- Yoshimo: turning this in also completes 41212
G[40327]='K1040 L104 A:99689 T:98964 E21570'
G[40328]='K1100 L110 A:99890 T:99890 P:40901 E21570'
G[40329]='K1000 L090 A:85418 T:85418 E20490'
G[40331]='K1100 L110 A:99544 T:102334 E21570'
G[40332]='K1100 L110 A:99559 T:102334 E21570'
G[40333]='K1100 L110 E21570'
G[40334]='K1100 L110 A:102334 T:102381 E21570'
G[40335]='K1100 L110 E21570'
G[40336]='K1100 L110 A:102410 T:102410 E21570'
G[40337]='K1100 L110 E21911'
G[40338]='T:700610 E21570'
G[40339]='K1010 A:97130 T:97130 P:39769 E21570'
G[40340]='E21570'
G[40341]='K0000 L098 E21570'
G[40342]='K1100 L110 E21570'
G[40343]='E21570'
G[40345]='A:97130 T:97130 P:40339 E21570'
G[40347]='T:96590 E21570'
G[40348]='K1100 L110 A:99788 T:99788 P:40368 E21570'
G[40349]='K1100 L098 E21737'
G[40350]='K1100 L098 E21737'
G[40351]='K1100 L098 E21737'
G[40352]='K1100 L098 T:-1014 E21737'
G[40353]='K1100 L098 E21737'
G[40354]='K1100 L098 E22197'
G[40355]='K1100 L098 E21691'
G[40356]='K1100 L098 E22197'
G[40357]='K1100 L098 E22197'
G[40358]='K1100 L098 E22197'
G[40359]='K1100 L098 E21570'
G[40360]='K1100 L098 E21570'
G[40361]='K1100 L098 E21570'
G[40362]='K1100 L098 E21570'
G[40363]='K1100 L098 E21655'
G[40364]='K1100 L110 A:104406 T:104406 E21570'
G[40368]='K1100 L110 A:99788 T:99788 E21570'
G[40369]='E21570'
G[40370]='K1100 L110 A:99788 T:99788 P:40368 E21570'
G[40373]='K1000 L098 A:97644 T:97644 P:39686 E21570'
G[40374]='T:97644 I:40375 E21570'
G[40375]='T:97644 I:40374 E21570'
G[40378]='K0980 L098 A:98229 T:94410 P:40077 E21570'
G[40379]='K0980 L098 A:100982 T:93759 P:40378 E21570'
G[40380]='E21570'
G[40381]='E21570'
G[40382]='E21570'
G[40383]='E21570'
G[40384]='K0004096 L098 CH A:100786 T:102478 P:43635 E21570'
G[40385]='K0000 L098 E21570'
G[40386]='E21570'
G[40388]='K0000 L098 A:97892 T:97903 P:39990 E21570'
G[40389]='T:96691 E21570'
G[40390]='E21570'
G[40391]='E21570'
G[40392]='K0000 L098 E21570'
G[40395]='K1000 L100 E20490'
G[40397]='E21570'
G[40398]='E21570'
G[40399]='E21570'
G[40400]='K0000 L098 E21570'
G[40401]='K1100 L110 A:100185 T:100192 E21570'
G[40402]='K0000 L098 E21570'
G[40403]='K0000 L098 E21570'
G[40404]='E21570'
G[40405]='T:97449 E21570'
G[40406]='T:98024 E21570'
G[40408]='K00004096 L098 A:90369 T:90369 P:38710 E21531'
G[40409]='E21570'
G[40410]='E21570'
G[40411]='E21570'
G[40412]='K1100 L110 A:100823 T:100878 P:41097+41098 E21570'
G[40413]='P:40612 E21570'	-- you can only see the treasure if you killed the hunters in the cave before
G[40414]='T:100495 E21570'
G[40415]='K1080 L108 A:98948 T:93523 P:0 E21570'	-- TODO: Yoshimo: probably leatherworking
G[40416]='E20490'	-- I am assuming this is the quest that marks a boosted to 100 level character
G[40417]='FH K1000 L100 T:92400 E20726'	-- automatically given to boosted Horde character
G[40418]='FA K1000 L100 E20490'
G[40419]='K0000 L098 E21570'
G[40420]='E21570'
G[40422]='T:97069 E21570'
G[40423]='T:109498 E21570'
G[40424]='K1100 L110 A:100185 T:100301 P:40469 E21570'
G[40425]='E21570'
G[40426]='E21570'
G[40427]='E21570'
G[40428]='E21570'
G[40429]='E21570'
G[40430]='E21570'
G[40431]='E21570'
G[40432]='E21570'
G[40433]='E21570'
G[40434]='E21570'
G[40435]='E21570'
G[40436]='E21570'
G[40437]='E21570'
G[40438]='E21570'
G[40439]='E21570'
G[40440]='E21570'
G[40441]='E21570'
G[40442]='E21570'
G[40443]='E21570'
G[40444]='E21570'
G[40445]='E21570'
G[40446]='E21570'
G[40447]='E21570'
G[40448]='E21570'
G[40449]='E21570'
G[40450]='E21570'
G[40451]='E21570'
G[40452]='E21570'
G[40453]='E21570'
G[40454]='E21570'
G[40455]='E21570'
G[40456]='E21570'
G[40457]='K1100 L110 E21570'
G[40458]='K1100 L110 E21570'
G[40459]='K1100 L110 E21570'
G[40460]='K1100 L110 E21570'
G[40461]='K1100 L110 E21570'
G[40462]='K1100 L110 E21570'
G[40463]='K1100 L110 E21570'
G[40464]='K1100 L110 E21570'
G[40465]='K1100 L110 E21570'
G[40466]='K1100 L110 E21570'
G[40467]='K1100 L110 E21570'
G[40468]='E21570'
G[40469]='K1100 L110 A:100192 T:100185 P:40401 E21570'
G[40470]='K1100 L110 A:100331 T:97140 P:40424 E21570'
G[40471]='T:700495 E21570'
G[40472]='E21570'
G[40473]='E21570'
G[40474]='E21570'
G[40475]='E21570'
G[40476]='E21570'
G[40477]='SP K000131072 A:1245531 T:1245531 E21570'
G[40478]='SP K000131072 A:1245532 T:1245532 E21570'
G[40479]='SP K000131072 A:1245533 T:1245533 E21570'
G[40480]='E21570'
G[40481]='E21570'
G[40482]='SP K000131072 A:1245536 T:1245536 E21570'
G[40483]='SP K000131072 A:1245537 T:1245537 E21570'
G[40484]='T:96986 E21570'
G[40485]='K1100 L110 E21570'
G[40486]='K1100 L110 E21570'
G[40487]='E21570'
G[40488]='E21570'
G[40489]='E21570'
G[40490]='K1100 L110 E21570'
G[40491]='T:95078 E21570'
G[40492]='K1100 L110 E21570'
G[40493]='T:94507 E21570'
G[40494]='SP K000131072 A:1245548 T:1245548 E21570'
G[40495]='K0000 L098 E21570'
G[40496]='T:700060 E21570'
G[40497]='T:98003 E21570'
G[40498]='E21570'
G[40499]='T:700528 E21570'
G[40500]='E21570'
G[40501]='E22289'
G[40502]='E21570'
G[40504]='K1100 L110 E21570'
G[40505]='E21570'
G[40506]='T:95196 E21570'
G[40507]='E21570'
G[40508]='T:108009 E21570'
G[40509]='T:108489 E21570'
G[40510]='T:96072 E21570'
G[40512]='K1100 L110 E21570'
G[40513]='K1100 L110 E21570'
G[40514]='E21570'
G[40515]='K0000 L098 A:93826 T:98825 P:38909 E21570'
G[40516]='E21570'
G[40517]='K0000 L098 A:100395 T:100429 P:42740 E21570'
G[40518]='K0000 L098 A:113547 T:100453 P:44281 E21570'
G[40519]='FA K0000 L098 AZ:301 T:107934 E21570'	-- Night Elf Druid given this automatically in Legion beta when appearing in SW, and actually Nimhfree got immediately logging in while in Lunarfall
G[40520]='K0000 L098 A:98825 T:98825 P:40167 E21570'
G[40521]='E21570'
G[40522]='K0000 A:100453 T:100866 P:40518 E21691'
G[40523]='K1000 L098 E21570'
G[40524]='K1000 L098 E21570'
G[40525]='K1000 L098 E21570'
G[40526]='K1000 L098 E21570'
G[40527]='K1000 L098 E21570'
G[40528]='K1000 L098 E21570'
G[40529]='K1000 L098 E21570'
G[40530]='K1000 L098 E21570'
G[40531]='K1000 L098 E21570'
G[40532]='K1000 L098 E21570'
G[40533]='K1000 L098 E21570'
G[40534]='K1000 L098 E21570'
G[40535]='K1020 L102 E21570'
G[40536]='K1020 L102 E21570'
G[40538]='K1040 L104 E21570'
G[40539]='K1040 L104 E21570'
G[40540]='K1060 L106 E21570'
G[40541]='K1060 L106 E21570'
G[40542]='K1060 L106 E21570'
G[40543]='K1060 L106 E21570'
G[40544]='K1060 L106 E21570'
G[40545]='K1000 L098 A:93539 T:102193 P:PN001 E21570'
G[40546]='K1060 L106 E21570'
G[40547]='K1080 L108 E21570'
G[40554]='E21570'
G[40556]='K1080 L108 E21570'
G[40557]='E21570'
G[40558]='K1100 L110 E21570'
G[40559]='K1100 L110 E21570'
G[40560]='K1100 L110 E21570'
G[40561]='K1100 L110 E21570'
G[40562]='K1100 L110 E21570'
G[40564]='E21570'
G[40565]='E21570'
G[40566]='E21953'
G[40567]='K0000 L098 A:104921 T:104921 P:38743 E21570'
G[40568]='K0000 L098 A:91249 T:96465 P:38618,38412 E21570'
G[40569]='K0000 L098 A:100438 T:100475 E21570'
G[40570]='K0000 L098 A:47684 T:101046 P:40634 E21570'
G[40571]='E21570'
G[40572]='E21570'
G[40573]='K0000 L098 A:91650 T:100573 P:39384 E21570'
G[40574]='E21570'
G[40578]='K1100 L110 A:99483 P:40300 E21570'
G[40579]='K0004096 L098 A:96469 T:96469 P:39654 E21570'
G[40580]='E21570'
G[40581]='E21570'
G[40582]='E21570'
G[40584]='T:109326 E21570'
G[40585]='K0000 L098 A:100635 T:100635 P:39214 E21570'
G[40588]='K0000 L098 E21570'
G[40590]='E21570'
G[40591]='E21570'
G[40593]='K0000 L098 A:100675 T:100973 P:40517 E21570'
G[40594]='K0000 L098 A:97407 T:97407 P:42512 E21570'	--TODO: Yoshimo: seems to also complete 41245 & 42478
G[40595]='E21570'
G[40596]='E21570'
G[40597]='K1100 L110 E21570'
G[40598]='K1000 L098 E21570'
G[40601]='E21570'
G[40604]='K0000 L098 E21570'
G[40605]='K0000 L098 A:101035 T:95234 P:40607 E21691'
G[40606]='K0000 L098 E21570'
G[40607]='K0000 L098 A:100873 T:101035 P:40760 E21691'
G[40609]='E21570'
G[40610]='T:97102 E21570'
G[40611]='K0000 L098 E21570'
G[40612]='E21570'
G[40616]='E21570'
G[40617]='K1100 L110 A:100775 T:100775 E21570'
G[40618]='K0004096 L098 A:102478 T:102478 P:41415 E21570'
G[40619]='E21570'
G[40620]='E21570'
G[40621]='E21570'
G[40622]='E21570'
G[40623]='K0000 L098 E21570'
G[40625]='K1100 L110 A:101076 T:101076 E21570'
G[40627]='E21570'
G[40628]='E21570'
G[40629]='E21570'
G[40630]='E21570'
G[40632]='K1100 L110 E21570'
G[40633]='K0000 L098 A:100475 T:100571 P:40569 E21570'
G[40634]='K0000 L098 A:47684 T:47684 E21570'
G[40636]='K0000 L098 A:100438 T:100438 E21570'
G[40638]='E21570'
G[40639]='E21570'
G[40640]='E21570'
G[40641]='E21570'
G[40642]='A:101076 T:101076 P:40694 E21570'
G[40643]='K0004096 L098 CD A:101061 T:101064 P:44663 E21570'	-- in beta we had: P:43635
G[40644]='K0004096 L098 A:101064 T:103875 P:41106 E21570'
G[40645]='K0004096 L098 A:103875 T:101195 P:40644 E21570'
G[40646]='K0004096 L098 A:101195 T:101195 P:40645 E21570'
G[40647]='K0004096 L098 A:104535 T:104535 P:41792 E21570'
G[40649]='K0004096 L098 A:103832 T:113525 P:43979 E21570'	-- here the experiment is to require only the quest that selects the artifact and not the other quest that was just completed to be able to pick an artifact.  hopefully this proves true as it means one could pick the artifacts in any order and all would work out properly.
G[40650]='SP K0000 L101 A:98013 T:98013 P:B42583 E21691'	-- TODO: Need U code for Zen'tabra
G[40651]='K0004096 L098 A:97923 T:97923 P:41255 E21570'
G[40652]='K0000 L098 A:104241 T:98002 P:41332 E21570 D127'
G[40653]='K0000 L098 A:98002 T:98002 P:40652 E21570'
G[40654]='K0000 L103 A:101195 T:106442 P:42036 E21570'
G[40655]='E21570'
G[40657]='K1100 L110 A:101076 T:101076 P:40625 E21570'
G[40658]='E21570'
G[40659]='K1100 L110 E21570'
G[40661]='K0000 L098 A:101004 T:101004 P:44120 E21874'	-- this was not available to human warrior when I got the other...another preq needed
G[40662]='E21570'
G[40663]='E21570'
G[40664]='E21570'
G[40668]='K0000 L110 A:100482 P:0 E21570'
G[40674]='K1100 L110 E21570'
G[40680]='T:103183 E21570'
G[40681]='T:101077 E21570'
G[40683]='K1100 L110 A:101076 T:101076 P:40625 E21570'
G[40684]='K0000 L098 E21570'
G[40685]='E21570'
G[40686]='E21570'
G[40687]='E21570'
G[40688]='E21570'
G[40689]='E21570'
G[40690]='E21570'
G[40691]='E21570'
G[40692]='E21570'
G[40694]='K1100 L110 A:101076 T:101076 P:40657+40683 E21570'	-- TODO: Yoshimo : verify 40683
G[40698]='K0000 L098 A:100438 T:100438 E21570'
G[40699]='E21570'
G[40700]='E21570'
G[40701]='E21570'
G[40702]='T:101195 E21570'
G[40703]='E21570'
G[40704]='K0000 L101 T:101046 E21570'
G[40705]='K0004096 L098 CT A:102333 T:101314 P:43635 E21570'
G[40706]='K0004096 L098 A:101314 T:101314 P:40705 E21570'
G[40707]='E21570'
G[40708]='E21570'
G[40709]='E21570'
G[40710]='K0004096 L098 A:101314 T:101310 P:40706+40707 E21570'
G[40711]='SP K000131072 A:1246037 T:1246037 E21570'
G[40712]='K0000 L098 E21570'
G[40713]='K1100 L110 A:101076 T:101076 P:40694 E21570'
G[40714]='K0000 L098 A:111109 T:101441 E21570'
G[40715]='K0000 L098 A:101441 T:101441 E21570'
G[40716]='K0000 L098 E21570'
G[40717]='K0000 L098 A:101004 T:113637 P:44120 E21846'
G[40718]='K0000 L098 A:95234 T:113655 P:40605 E21570'
G[40719]='E21570'
G[40720]='E21570'
G[40721]='E21570'
G[40722]='E21570'
G[40723]='E21570'
G[40724]='E21570'
G[40725]='E21570'
G[40726]='E21570'
G[40727]='K1130 L110 A:107225 T:107598 E21570'
G[40728]='E21570'
G[40729]='K0000 L098 E21570'
G[40730]='K1130 L110 A:107225 T:107225 E21570'
G[40731]='K0000 L098 E21570'
G[40732]='E21570'
G[40733]='E21570'
G[40734]='E21570'
G[40735]='E21570'
G[40736]='E21570'
G[40737]='E21570'
G[40738]='E21570'
G[40739]='E21570'
G[40740]='K0000 L098 E21570'
G[40743]='E21570'
G[40744]='K1100 L110 A:99065 T:99093 E21570'
G[40745]='K1130 L110 A:107997 T:108063 P:40947 E21570'
G[40746]='K1130 L110 A:107632 T:107598 P:41877 E21570'
G[40747]='K1100 L110 A:101499 T:101499 P:40011 E21570'
G[40748]='K1100 L110 A:101499 T:102142 P:40747 E21570'
G[40749]='K1100 L110 E21570'
G[40751]='T:109349 E21570'
G[40752]='SP K000131072 A:1246206 T:1246206 E21570'
G[40753]='K0000 L001 T:92031 E21570'
G[40755]='K0000 L098 A:101547 T:113836 P:42970 E21846'
G[40759]='E21570'
G[40760]='K0000 L098 A:100866 T:100873 P:40522 E21691'
G[40761]='E21570'
G[40762]='T:101768 E21570'
G[40763]='K1130 L110 E21570'
G[40764]='E21570'
G[40765]='T:102242 E21570'
G[40766]='E21570'
G[40767]='T:700515 E21570'
G[40768]='E21570'
G[40769]='E21570'
G[40770]='E21570'
G[40771]='E21570'
G[40772]='E21570'
G[40773]='E21570'
G[40775]='E21570'
G[40776]='E21570'
G[40777]='E21570'
G[40780]='E21570'
G[40781]='E21570'
G[40782]='E21570'
G[40783]='K0004096 L098 A:700439 T:101656 P:44444 E21570'	-- TODO: And whatever choosing quest is completed (like 44443 in Nimhfree case)
G[40784]='K0004096 L098 A:101656 T:101651 P:40783 E21570'
G[40785]='K0004096 L098 A:101651 T:100323 P:40784 E21570'
G[40786]='Hf FH K0000 L086 A:100133377 T:501759 E20726'
G[40787]='Hf FA K0000 L086 A:100133378 T:101759 E20726'
G[40788]='E21570'
G[40790]='E21570'
G[40792]='Hi K1004 L100 AA:94870 AH:594870 TA:94870 TH:594870 E20779 D111'
G[40793]='K0000 L098 A:100438 T:99179 E21570'
G[40794]='FA K0000 L098 A:1239328 T:106930 P:37659 E21570'
G[40795]='K0000 L098 A:99179 T:99179 P:40793 E21570'
G[40796]='K1100 L110 A:101848 T:101848 E21570'
G[40797]='E21570'
G[40798]='K1100 L110 A:700326 T:111318 P:40796 E21570'
G[40803]='E21570'
G[40804]='E21570'
G[40805]='E21570'
G[40806]='E21737'
G[40807]='E21737'
G[40808]='E21737'
G[40810]='E21570'
G[40811]='E21570'
G[40812]='E21570'
G[40813]='E21570'
G[40814]='K0004096 L098 A:99247 T:99247 P:39261 E21570'
G[40815]='K0000 L098 A:101927 T:90255 P:37658+37660+40375 E21570'	--obviously also needs reignite the wards 37658
G[40816]='K0000 L098 A:99254 T:99254 P:39047 E21570'
G[40817]='T:99247 E21570'
