--
--	Grail Achievements
--	Written by scott@mithrandir.com
--
--	Version History
--		001	Initial version
--		002	Converted to be a load-on-demand addon.
--		003	Added the cooking and fishing achievements.
--		004	Added the Just Another Day in Tol Barad achievements.
--		005	Removed the version check since live now has MoP data in it.
--		006 Changes the internal structure to reduce memory consumption by over 0.6 MB.
--			Basically after the quests are added to the map areas associated with the
--			achievements the data is removed, except a new table is created to map the
--			questId to the loremaster map area appropriate for the quest.
--		007 Interface 50300
--		008	Adds some achievements for Wrathion.
--			Moves some achievements from The Maelstrom into Kalimdor and Eastern Kingdoms.
--			Splits Grail.achievements into Grail.loremasterAchievements and Grail.extraAchievements for those that want finer grain control.
--		009	Makes it so the Pandaria "loremaster" achievements are fleshed out to include all the prerequisite quests for each sub achievement.
--		010	Switches to not rely on Grail.quests any more.
--			Corrects a lack of populating the Loremaster only quests data for the Pandaria quests (which Loremaster uses for pins).
--
--	Known Issues
--
--	UTF-8 file
--

local pairs, tContains, tinsert, tonumber, wipe = pairs, tContains, tinsert, tonumber, wipe
local GetAchievementInfo, GetBuildInfo = GetAchievementInfo, GetBuildInfo

local Grail_Achievements_File_Version = 010

if Grail.achievementsVersionNumber < Grail_Achievements_File_Version then
	Grail.achievementsVersionNumber = Grail_Achievements_File_Version

--	These are the achievements organized by zone for completing the "loremaster" achievements (basically completing a specific number of quests in each zone).
Grail.loremasterAchievements = {
	['Alliance'] = {
		[1] = { 504925, 504926, 504928, 504930, 504929, 504931, 504932, 504934, 504937, 504936, 504935, 504938, 504939, 504940, 504870, 504872, },
		[2] = { 504896, 504900, 504909, 504901, 504905, 504892, 504897, 504899, 504906, 504902, 504910, 504904, 504893, 504903, 504873, 504869, },
		[3] = { 501194, 501190, 501192, 501193, 501195, 501191, 501189, },
		[4] = { 500037, 500034, 500040, 500039, 500035, 500033, 500036, 500038, },
		[5] = { 504871, },
		[6] = { 506300, 506301, 506535, 506537, 506539, 506540, },
		},
	['Horde'] = {
		[1] = { 504976, 504927, 504930, 504978, 504931, 504979, 504933, 504934, 504981, 504980, 504935, 504938, 504939, 504940, 504870, 504872, },
		[2] = { 504896, 504900, 504909, 504901, 504905, 504892, 504908, 504895, 504897, 504906, 504910, 504894, 504904, 504893, 505501, 504982, },
		[3] = { 501194, 501190, 501273, 501193, 501195, 501272, 501271, },
		[4] = { 501357, 501356, 500040, 500039, 501359, 501358, 500036, 500038, },
		[5] = { 504871, },
		[6] = { 506301, 506534, 506536, 506538, 506539, 506540, },
		},
	}

--	These are the achievements organized by zone for completing special sets of quests that are not "loremaster" but extra.
Grail.extraAchievements = {
	['Alliance'] = {
		[1] = { 505453, 504961, 505859, 505866, },
		[2] = { 500940, 505318, 505320, 504960, 505452, },
		[3] = { 500939, },
		[4] = { 500561, 501596, 500961, 500962, 500938, 500547, },
		[5] = { },
		[6] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, },
		},
	['Horde'] = {
		[1] = { 504961, 505859, 505866, },
		[2] = { 500940, 504960, 505452, 505319, 505321, },
		[3] = { 500939, },
		[4] = { 500561, 501596, 500961, 500962, 500938, 500547, },
		[5] = { },
		[6] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, },
		},
	}

--	Grail.achievements is a combination of Grail.loremasterAchievements and Grail.extraAchievements and will be created at the end

--	These are the achievements organized by world event.
Grail.worldEventAchievements = {
	['Alliance'] = {
		['A'] = { 501695, },
		['B'] = { 501186, },
		['F'] = { 506027, 506028, 506029, },
		['L'] = { 506006, 500912, 500911, 501396, 500915, 500910, 500914, },
		['M'] = { 501028, 501029, 506007, 501030, 506013, 506011, 501022, 501023, 506008, 501024, 501145, 508042, 508045, },
		['V'] = { 500279, },
		['W'] = { 501040, 500289, 500966, 500963, 505836, 500969, 505837, 507601, },
		['Y'] = { 503596, },
		},
	['Horde'] = {
		['A'] = { 501695, },
		['B'] = { 501186, },
		['F'] = { 506027, 506028, 506029, },
		['L'] = { 506006, 500912, 500911, 501396, 500915, 500910, 500914, },
		['M'] = { 501031, 501032, 506010, 501033, 506014, 506012, 501025, 501026, 506009, 501027, 501145, 508043, 508044, },
		['V'] = { 500279, },
		['W'] = { 501041, 500289, 500967, 500965, 505835, 500968, 505838, 507602, },
		['Y'] = { 503597, },
		},
	}

--	These are the achievements organized by profession.
Grail.professionAchievements = {
	['Alliance'] = {
		['C'] = { 500906, 505842, 505841, 505474, 501782, },
		['F'] = { 503217, 505848, 505847, 505476, 500905, },
		},
	['Horde'] = {
		['C'] = { 500906, 505475, 505843, 505844, 501783, },
		['F'] = { 503217, 505477, 505849, 505850, 500905, },
		},
	}

--	These are the achievements for pet battles.
Grail.petBattleAchievements = {
	['Alliance'] = { 506603, },
	['Horde'] = { },
	}

local G = {}

G[2]={43,504925,504976}
G[23]={43,504925,504976}
G[24]={43,504925,504976}
G[25]={43,504925,504976}
G[184]={39,504903}
G[185]={37,504906}
G[186]={37,504906}
G[187]={37,504906}
G[188]={37,504906}
G[190]={37,504906}
G[191]={37,504906}
G[192]={37,504906}
G[193]={37,504906}
G[194]={37,504906}
G[195]={37,504906}
G[196]={37,504906}
G[197]={37,504906}
G[208]={37,504906,500940}
G[216]={43,504925,504976}
G[309]={35,504899}
G[351]={161,504935}
G[485]={26,504897}
G[583]={37,504906}
G[648]={161,504935}
G[824]={43,504925,504976}
G[836]={26,504897}
G[844]={11,504933}
G[845]={11,504933}
G[848]={11,504933}
G[850]={11,504933}
G[851]={11,504933}
G[852]={11,504933}
G[855]={11,504933}
G[858]={11,504933}
G[863]={11,504933}
G[865]={11,504933}
G[867]={11,504933}
G[869]={11,504933}
G[870]={11,504933}
G[871]={11,504933}
G[872]={11,504933}
G[875]={11,504933}
G[876]={11,504933}
G[877]={11,504933}
G[880]={11,504933}
G[881]={11,504933}
G[887]={11,504933}
G[891]={11,504933}
G[895]={11,504933}
G[899]={11,504933}
G[903]={11,504933}
G[905]={11,504933}
G[1036]={37,504906}
G[1168]={141,504929,504978}
G[1201]={141,504929,504978}
G[1202]={141,504929,504978}
G[1204]={141,504929,504978}
G[1205]={141,504929,504978}
G[1222]={141,504929,504978}
G[1258]={141,504929,504978}
G[1270]={141,504929,504978}
G[1271]={141,504929,504978}
G[1918]={43,504925,504976}
G[2278]={504956}
G[3861]={39,504903}
G[4021]={11,504933}
G[4601]={504956}
G[4602]={504956}
G[4621]={37,504906}
G[5041]={11,504933}
G[5713]={42,504928}
G[6031]={182,504931}
G[6132]={101,504930}
G[6441]={43,504925,504976}
G[6442]={43,504925,504976}
G[6462]={43,504925,504976}
G[6482]={43,504925,504976}
G[6503]={43,504925,504976}
G[6544]={43,504925,504976}
G[6621]={43,504925,504976}
G[6641]={43,504925,504976}
G[6984]={500279}
G[7045]={500279}
G[7498]={504956}
G[7499]={504956}
G[7501]={504956}
G[7502]={504956}
G[7503]={504956}
G[7604]={504956}
G[7761]={504956}
G[7838]={37,504906}
G[7863]={43,504925}
G[7865]={43,504925}
G[8183]={504956}
G[8184]={504956}
G[8185]={504956}
G[8187]={504956}
G[8189]={504956}
G[8191]={504956}
G[8192]={504956}
G[8227]={504956}
G[8277]={261,504934}
G[8278]={261,504934}
G[8279]={261,504934}
G[8280]={261,504934}
G[8281]={261,504934}
G[8282]={261,504934}
G[8283]={261,504934}
G[8284]={261,504934}
G[8285]={261,504934}
G[8287]={261,504934}
G[8304]={261,504934}
G[8306]={261,504934}
G[8308]={261,504934}
G[8309]={261,504934}
G[8310]={261,504934}
G[8314]={261,504934}
G[8316]={261,504934}
G[8318]={261,504934}
G[8320]={261,504934}
G[8321]={261,504934}
G[8323]={261,504934}
G[8376]={261,504934}
G[8377]={261,504934}
G[8378]={261,504934}
G[8379]={261,504934}
G[8380]={261,504934}
G[8381]={261,504934}
G[8382]={261,504934}
G[8470]={182,504931}
G[8481]={281,504940}
G[8619]={500910}
G[8635]={500910}
G[8636]={500912}
G[8642]={500912}
G[8643]={500912}
G[8644]={500910}
G[8645]={500912}
G[8646]={500915}
G[8647]={500912}
G[8648]={500914}
G[8649]={500912}
G[8650]={500912}
G[8651]={500912}
G[8652]={500912}
G[8653]={500912}
G[8654]={500911}
G[8670]={500911}
G[8671]={500911}
G[8672]={500911}
G[8673]={500911}
G[8674]={500912}
G[8675]={500912}
G[8676]={500910}
G[8677]={500914}
G[8678]={500914}
G[8679]={500911}
G[8680]={500911}
G[8681]={500911}
G[8682]={500911}
G[8683]={500912}
G[8684]={500911}
G[8685]={500911}
G[8686]={500911}
G[8688]={500912}
G[8713]={500910}
G[8714]={500912}
G[8715]={500911}
G[8716]={500912}
G[8717]={500911}
G[8718]={500915}
G[8719]={500911}
G[8720]={500911}
G[8721]={500911}
G[8722]={500912}
G[8723]={500911}
G[8724]={500911}
G[8725]={500911}
G[8726]={500911}
G[8727]={500910}
G[8748]={161,504935}
G[8749]={161,504935}
G[8758]={161,504935}
G[8759]={161,504935}
G[8866]={500915}
G[9138]={463,504908}
G[9139]={463,504908}
G[9140]={463,504908}
G[9143]={463,504908}
G[9145]={463,504908}
G[9146]={463,504908}
G[9147]={463,504908}
G[9148]={463,504908}
G[9149]={463,504908}
G[9150]={463,504908}
G[9151]={463,504908}
G[9152]={463,504908}
G[9155]={463,504908}
G[9156]={463,504908}
G[9157]={463,504908}
G[9158]={463,504908}
G[9159]={463,504908}
G[9160]={463,504908}
G[9161]={463,504908}
G[9162]={463,504908}
G[9163]={463,504908}
G[9164]={463,504908}
G[9166]={463,504908}
G[9167]={463,504908}
G[9169]={463,504908}
G[9170]={463,504908}
G[9171]={463,504908}
G[9172]={463,504908}
G[9173]={463,504908}
G[9174]={463,504908}
G[9175]={463,504908}
G[9176]={463,504908}
G[9192]={463,504908}
G[9193]={463,504908}
G[9199]={463,504908}
G[9207]={463,504908}
G[9212]={463,504908}
G[9214]={463,504908}
G[9215]={463,504908}
G[9216]={463,504908}
G[9217]={463,504908}
G[9218]={463,504908}
G[9220]={463,504908}
G[9272]={37,504906}
G[9274]={463,504908}
G[9275]={463,504908}
G[9276]={463,504908}
G[9277]={463,504908}
G[9281]={463,504908}
G[9282]={463,504908}
G[9315]={463,504908}
G[9327]={463,504908}
G[9328]={463,504908}
G[9329]={463,504908}
G[9339]={501145}
G[9340]={465,501189,501271}
G[9345]={465,501189,501271}
G[9349]={465,501189,501271}
G[9351]={465,501189,501271}
G[9355]={465,501189,501271}
G[9356]={465,501189,501271}
G[9361]={465,501189,501271}
G[9365]={501145}
G[9366]={465,501189,501271}
G[9370]={465,501189,501271}
G[9372]={465,501189,501271}
G[9373]={465,501189,501271}
G[9374]={465,501189,501271}
G[9375]={465,501189,501271}
G[9376]={465,501189,501271}
G[9381]={465,501189,501271}
G[9383]={465,501189,501271}
G[9385]={465,501189,501271}
G[9387]={465,501189,501271}
G[9390]={465,501189,501271}
G[9391]={465,501189,501271}
G[9396]={465,501189,501271}
G[9397]={465,501189,501271}
G[9398]={465,501189,501271}
G[9399]={465,501189,501271}
G[9400]={465,501189,501271}
G[9401]={465,501189,501271}
G[9405]={465,501189,501271}
G[9406]={465,501189,501271}
G[9407]={465,501189,501271}
G[9410]={465,501189,501271}
G[9415]={261,504934}
G[9416]={261,504934}
G[9417]={465,501189,501271}
G[9418]={465,501189,501271}
G[9419]={261,504934}
G[9420]={465,501189,501271}
G[9422]={261,504934}
G[9423]={465,501189,501271}
G[9424]={465,501189,501271}
G[9426]={465,501189,501271}
G[9427]={465,501189,501271}
G[9430]={465,501189,501271}
G[9436]={37,504906}
G[9437]={141,504929,504978}
G[9442]={465,501189,501271}
G[9447]={465,501189,501271}
G[9457]={37,504906}
G[9466]={465,501189,501271}
G[9483]={465,501189,501271}
G[9490]={465,501189,501271}
G[9498]={465,501189,501271}
G[9499]={465,501189,501271}
G[9543]={465,501189,501271}
G[9545]={465,501189,501271}
G[9548]={476,504926}
G[9549]={476,504926}
G[9550]={476,504926}
G[9557]={476,504926}
G[9558]={465,501189,501271}
G[9561]={476,504926}
G[9563]={465,501189,501271}
G[9567]={476,504926}
G[9569]={476,504926}
G[9574]={476,504926}
G[9576]={476,504926}
G[9578]={476,504926}
G[9579]={476,504926}
G[9580]={476,504926}
G[9581]={476,504926}
G[9584]={476,504926}
G[9585]={476,504926}
G[9594]={476,504926}
G[9620]={476,504926}
G[9624]={476,504926}
G[9628]={476,504926}
G[9629]={476,504926}
G[9632]={476,504926}
G[9634]={476,504926}
G[9641]={476,504926}
G[9643]={476,504926}
G[9646]={476,504926}
G[9647]={476,504926}
G[9648]={476,504926}
G[9649]={476,504926}
G[9663]={476,504926}
G[9666]={476,504926}
G[9667]={476,504926}
G[9668]={476,504926}
G[9669]={476,504926}
G[9670]={476,504926}
G[9671]={476,504926}
G[9672]={476,504926}
G[9674]={476,504926}
G[9682]={476,504926}
G[9683]={476,504926}
G[9687]={476,504926}
G[9688]={476,504926}
G[9689]={476,504926}
G[9693]={476,504926}
G[9694]={476,504926}
G[9696]={476,504926}
G[9697]={467,501190}
G[9698]={476,504926}
G[9699]={476,504926}
G[9700]={476,504926}
G[9701]={467,501190}
G[9702]={467,501190}
G[9703]={476,504926}
G[9706]={476,504926}
G[9708]={467,501190}
G[9709]={467,501190}
G[9711]={476,504926}
G[9716]={467,501190}
G[9718]={467,501190}
G[9720]={467,501190}
G[9724]={467,501190}
G[9726]={467,501190}
G[9728]={467,501190}
G[9730]={467,501190}
G[9731]={467,501190}
G[9732]={467,501190}
G[9739]={467,501190}
G[9740]={476,504926}
G[9741]={476,504926}
G[9742]={467,501190}
G[9743]={467,501190}
G[9744]={467,501190}
G[9746]={476,504926}
G[9747]={467,501190}
G[9748]={476,504926}
G[9751]={476,504926}
G[9752]={467,501190}
G[9753]={476,504926}
G[9756]={476,504926}
G[9758]={463,504908}
G[9759]={476,504926}
G[9760]={476,504926}
G[9761]={476,504926}
G[9762]={476,504926}
G[9769]={467,501190}
G[9770]={467,501190}
G[9771]={467,501190}
G[9772]={467,501190}
G[9773]={467,501190}
G[9774]={467,501190}
G[9775]={467,501190}
G[9776]={467,501190}
G[9777]={467,501190}
G[9778]={467,501190}
G[9779]={476,504926}
G[9780]={467,501190}
G[9781]={467,501190}
G[9782]={467,501190}
G[9783]={467,501190}
G[9785]={467,501190}
G[9786]={467,501190}
G[9787]={467,501190}
G[9788]={467,501190}
G[9789]={477,501192,501273}
G[9790]={467,501190}
G[9791]={467,501190}
G[9792]={467,501190}
G[9793]={467,501190}
G[9794]={475,501193}
G[9795]={475,501193}
G[9796]={467,501190}
G[9797]={467,501190}
G[9800]={477,501192,501273}
G[9801]={467,501190}
G[9802]={467,501190}
G[9803]={467,501190}
G[9804]={477,501192,501273}
G[9805]={477,501192,501273}
G[9806]={467,501190}
G[9808]={467,501190}
G[9809]={467,501190}
G[9810]={477,501192,501273}
G[9811]={463,504908}
G[9814]={467,501190}
G[9815]={477,501192,501273}
G[9816]={467,501190}
G[9817]={467,501190}
G[9818]={477,501192,501273}
G[9819]={477,501192,501273}
G[9820]={467,501190}
G[9821]={477,501192,501273}
G[9822]={467,501190}
G[9823]={467,501190}
G[9827]={467,501190}
G[9828]={467,501190}
G[9830]={467,501190}
G[9833]={467,501190}
G[9834]={467,501190}
G[9835]={467,501190}
G[9839]={467,501190}
G[9841]={467,501190}
G[9842]={467,501190}
G[9845]={467,501190}
G[9846]={467,501190}
G[9847]={467,501190}
G[9848]={467,501190}
G[9849]={477,501192,501273}
G[9850]={477,501192,501273}
G[9851]={477,501192,501273}
G[9852]={477,501192,501273,500939}
G[9853]={477,501192,501273}
G[9854]={477,501192,501273}
G[9855]={477,501192,501273}
G[9856]={477,501192,501273}
G[9857]={477,501192,501273}
G[9858]={477,501192,501273}
G[9859]={477,501192,501273}
G[9861]={477,501192,501273}
G[9862]={477,501192,501273}
G[9863]={477,501192,501273}
G[9864]={477,501192,501273}
G[9865]={477,501192,501273}
G[9866]={477,501192,501273}
G[9867]={477,501192,501273}
G[9868]={477,501192,501273}
G[9869]={477,501192,501273}
G[9870]={477,501192,501273}
G[9871]={477,501192,501273}
G[9872]={477,501192,501273}
G[9873]={477,501192,501273}
G[9874]={477,501192,501273}
G[9877]={463,504908}
G[9878]={477,501192,501273}
G[9879]={477,501192,501273}
G[9882]={477,501192,501273}
G[9884]={477,501192,501273}
G[9886]={477,501192,501273}
G[9888]={478,501191,501272}
G[9889]={478,501191,501272}
G[9890]={478,501191,501272}
G[9891]={477,501192,501273}
G[9893]={477,501192,501273}
G[9894]={467,501190}
G[9895]={467,501190}
G[9896]={467,501190}
G[9897]={477,501192,501273}
G[9898]={467,501190}
G[9899]={467,501190}
G[9900]={477,501192,501273}
G[9901]={467,501190}
G[9902]={467,501190}
G[9903]={467,501190}
G[9904]={467,501190}
G[9905]={467,501190}
G[9906]={477,501192,501273}
G[9907]={477,501192,501273}
G[9910]={477,501192,501273}
G[9911]={467,501190}
G[9912]={467,501190}
G[9913]={477,501192,501273}
G[9914]={477,501192,501273}
G[9916]={477,501192,501273}
G[9917]={477,501192,501273}
G[9918]={477,501192,501273}
G[9919]={467,501190}
G[9920]={477,501192,501273}
G[9921]={477,501192,501273}
G[9922]={477,501192,501273}
G[9923]={477,501192,501273}
G[9924]={477,501192,501273}
G[9925]={477,501192,501273}
G[9927]={477,501192,501273}
G[9928]={477,501192,501273}
G[9931]={477,501192,501273}
G[9932]={477,501192,501273}
G[9933]={477,501192,501273}
G[9934]={477,501192,501273}
G[9935]={477,501192,501273}
G[9936]={477,501192,501273}
G[9937]={477,501192,501273}
G[9938]={477,501192,501273}
G[9939]={477,501192,501273}
G[9940]={477,501192,501273}
G[9944]={477,501192,501273}
G[9945]={477,501192,501273}
G[9946]={477,501192,501273}
G[9948]={477,501192,501273}
G[9951]={478,501191,501272}
G[9954]={477,501192,501273}
G[9955]={477,501192,501273}
G[9956]={477,501192,501273}
G[9957]={478,501191,501272}
G[9960]={478,501191,501272}
G[9961]={478,501191,501272}
G[9962]={477,501192,501273}
G[9967]={477,501192,501273}
G[9968]={478,501191,501272}
G[9970]={477,501192,501273}
G[9971]={478,501191,501272}
G[9972]={477,501192,501273}
G[9973]={477,501192,501273}
G[9977]={477,501192,501273}
G[9978]={478,501191,501272}
G[9982]={477,501192,501273}
G[9983]={477,501192,501273}
G[9986]={478,501191,501272}
G[9987]={478,501191,501272}
G[9990]={478,501191,501272}
G[9991]={477,501192,501273}
G[9992]={478,501191,501272}
G[9993]={478,501191,501272}
G[9994]={478,501191,501272}
G[9995]={478,501191,501272}
G[9996]={478,501191,501272}
G[9997]={478,501191,501272}
G[9998]={478,501191,501272}
G[9999]={477,501192,501273}
G[10000]={478,501191,501272}
G[10001]={477,501192,501273}
G[10002]={478,501191,501272}
G[10003]={478,501191,501272}
G[10004]={477,501192,501273}
G[10005]={478,501191,501272}
G[10006]={478,501191,501272}
G[10007]={478,501191,501272}
G[10008]={478,501191,501272}
G[10009]={478,501191,501272}
G[10010]={478,501191,501272}
G[10011]={477,501192,501273}
G[10012]={478,501191,501272}
G[10013]={478,501191,501272}
G[10016]={478,501191,501272}
G[10018]={478,501191,501272}
G[10022]={478,501191,501272}
G[10023]={478,501191,501272}
G[10026]={478,501191,501272}
G[10027]={478,501191,501272}
G[10028]={478,501191,501272}
G[10030]={478,501191,501272}
G[10031]={478,501191,501272}
G[10033]={478,501191,501272}
G[10034]={478,501191,501272}
G[10035]={478,501191,501272}
G[10036]={478,501191,501272}
G[10037]={478,501191,501272}
G[10038]={478,501191,501272}
G[10039]={478,501191,501272}
G[10040]={478,501191,501272}
G[10041]={478,501191,501272}
G[10042]={478,501191,501272}
G[10043]={478,501191,501272}
G[10044]={477,501192,501273}
G[10045]={477,501192,501273}
G[10047]={465,501189,501271}
G[10050]={465,501189,501271}
G[10051]={478,501191,501272}
G[10052]={478,501191,501272}
G[10055]={465,501189,501271}
G[10057]={465,501189,501271}
G[10058]={465,501189,501271}
G[10063]={476,504926}
G[10064]={476,504926}
G[10065]={476,504926}
G[10066]={476,504926}
G[10067]={476,504926}
G[10074]={477,501192,501273}
G[10076]={477,501192,501273}
G[10078]={465,501189,501271}
G[10079]={465,501189,501271}
G[10081]={477,501192,501273}
G[10082]={477,501192,501273}
G[10085]={477,501192,501273}
G[10086]={465,501189,501271}
G[10087]={465,501189,501271}
G[10093]={465,501189,501271}
G[10096]={467,501190}
G[10099]={465,501189,501271}
G[10101]={477,501192,501273}
G[10102]={477,501192,501273}
G[10103]={465,501189,501271}
G[10104]={467,501190}
G[10105]={467,501190}
G[10106]={465,501189,501271}
G[10107]={477,501192,501273}
G[10108]={477,501192,501273}
G[10109]={477,501192,501273}
G[10110]={465,501189,501271}
G[10111]={477,501192,501273}
G[10112]={478,501191,501272}
G[10113]={477,501192,501273}
G[10114]={477,501192,501273}
G[10115]={467,501190}
G[10116]={467,501190}
G[10117]={467,501190}
G[10118]={467,501190}
G[10119]={465,501189,501271}
G[10120]={465,501189,501271}
G[10121]={465,501189,501271}
G[10123]={465,501189,501271}
G[10124]={465,501189,501271}
G[10129]={465,501189,501271}
G[10132]={465,501189,501271}
G[10134]={465,501189,501271}
G[10136]={465,501189,501271}
G[10140]={465,501189,501271}
G[10141]={465,501189,501271}
G[10142]={465,501189,501271}
G[10143]={465,501189,501271}
G[10144]={465,501189,501271}
G[10146]={465,501189,501271}
G[10159]={465,501189,501271}
G[10160]={465,501189,501271}
G[10161]={465,501189,501271}
G[10162]={465,501189,501271}
G[10163]={465,501189,501271}
G[10167]={504956}
G[10170]={477,501192,501273}
G[10171]={477,501192,501273}
G[10172]={477,501192,501273}
G[10173]={479,501194}
G[10174]={479,501194}
G[10176]={479,501194}
G[10180]={478,501191,501272}
G[10182]={479,501194}
G[10183]={479,501194}
G[10184]={479,501194}
G[10185]={479,501194}
G[10186]={479,501194}
G[10188]={479,501194}
G[10189]={479,501194}
G[10190]={479,501194}
G[10191]={479,501194}
G[10192]={479,501194}
G[10193]={479,501194}
G[10194]={479,501194}
G[10197]={479,501194}
G[10198]={479,501194}
G[10199]={479,501194}
G[10200]={479,501194}
G[10201]={478,501191,501272}
G[10202]={479,501194}
G[10203]={479,501194}
G[10204]={479,501194}
G[10205]={479,501194}
G[10206]={479,501194}
G[10208]={465,501189,501271}
G[10209]={479,501194}
G[10210]={478,501191,501272}
G[10213]={465,501189,501271}
G[10216]={504956}
G[10220]={465,501189,501271}
G[10221]={479,501194}
G[10222]={479,501194}
G[10223]={479,501194}
G[10224]={479,501194}
G[10225]={479,501194}
G[10226]={479,501194}
G[10227]={478,501191,501272}
G[10229]={465,501189,501271}
G[10230]={465,501189,501271}
G[10232]={479,501194}
G[10233]={479,501194}
G[10234]={479,501194}
G[10235]={479,501194}
G[10236]={465,501189,501271}
G[10237]={479,501194}
G[10238]={465,501189,501271}
G[10239]={479,501194}
G[10240]={479,501194}
G[10241]={479,501194}
G[10242]={465,501189,501271}
G[10243]={479,501194}
G[10245]={479,501194}
G[10246]={479,501194}
G[10247]={479,501194}
G[10248]={479,501194}
G[10249]={479,501194}
G[10250]={465,501189,501271}
G[10252]={477,501192,501273}
G[10253]={504956}
G[10254]={465,501189,501271}
G[10255]={465,501189,501271}
G[10256]={479,501194}
G[10257]={479,501194}
G[10258]={465,501189,501271}
G[10261]={479,501194}
G[10262]={479,501194}
G[10263]={479,501194}
G[10264]={479,501194}
G[10265]={479,501194}
G[10266]={479,501194}
G[10267]={479,501194}
G[10268]={479,501194}
G[10269]={479,501194}
G[10270]={479,501194}
G[10271]={479,501194}
G[10272]={479,501194}
G[10273]={479,501194}
G[10274]={479,501194}
G[10275]={479,501194}
G[10276]={479,501194}
G[10278]={465,501189,501271}
G[10281]={479,501194}
G[10286]={465,501189,501271}
G[10287]={465,501189,501271}
G[10288]={465,501189,501271}
G[10289]={465,501189,501271}
G[10290]={479,501194}
G[10291]={465,501189,501271}
G[10293]={479,501194}
G[10294]={465,501189,501271}
G[10295]={465,501189,501271}
G[10299]={479,501194}
G[10300]={479,501194}
G[10301]={479,501194}
G[10305]={479,501194}
G[10306]={479,501194}
G[10307]={479,501194}
G[10309]={479,501194}
G[10310]={479,501194}
G[10311]={479,501194}
G[10312]={479,501194}
G[10313]={479,501194}
G[10314]={479,501194}
G[10315]={479,501194}
G[10316]={479,501194}
G[10317]={479,501194}
G[10318]={479,501194}
G[10319]={479,501194}
G[10320]={479,501194}
G[10321]={479,501194}
G[10322]={479,501194}
G[10323]={479,501194}
G[10328]={479,501194}
G[10329]={479,501194}
G[10330]={479,501194}
G[10331]={479,501194}
G[10332]={479,501194}
G[10333]={479,501194}
G[10334]={479,501194}
G[10335]={479,501194}
G[10336]={479,501194}
G[10337]={479,501194}
G[10338]={479,501194}
G[10339]={479,501194}
G[10340]={465,501189,501271}
G[10341]={479,501194}
G[10342]={479,501194}
G[10343]={479,501194}
G[10344]={465,501189,501271}
G[10345]={479,501194}
G[10346]={465,501189,501271}
G[10347]={465,501189,501271}
G[10348]={479,501194}
G[10349]={465,501189,501271}
G[10351]={465,501189,501271}
G[10353]={479,501194}
G[10355]={467,501190}
G[10365]={479,501194}
G[10367]={465,501189,501271}
G[10368]={465,501189,501271}
G[10369]={465,501189,501271}
G[10380]={479,501194}
G[10381]={479,501194}
G[10382]={465,501189,501271}
G[10384]={479,501194}
G[10385]={479,501194}
G[10388]={465,501189,501271}
G[10389]={465,501189,501271}
G[10390]={465,501189,501271}
G[10391]={465,501189,501271}
G[10392]={465,501189,501271}
G[10393]={465,501189,501271}
G[10394]={465,501189,501271}
G[10395]={465,501189,501271}
G[10396]={465,501189,501271}
G[10397]={465,501189,501271}
G[10399]={465,501189,501271}
G[10400]={465,501189,501271}
G[10403]={465,501189,501271}
G[10405]={479,501194}
G[10406]={479,501194}
G[10407]={479,501194}
G[10408]={479,501194}
G[10410]={479,501194}
G[10411]={479,501194}
G[10417]={479,501194}
G[10418]={479,501194}
G[10422]={479,501194}
G[10423]={479,501194}
G[10424]={479,501194}
G[10425]={479,501194}
G[10426]={479,501194}
G[10427]={479,501194}
G[10429]={479,501194}
G[10430]={479,501194}
G[10431]={479,501194}
G[10432]={479,501194}
G[10433]={479,501194}
G[10434]={479,501194}
G[10435]={479,501194}
G[10436]={479,501194}
G[10437]={479,501194}
G[10438]={479,501194}
G[10439]={479,501194}
G[10440]={479,501194}
G[10442]={465,501189,501271}
G[10443]={465,501189,501271}
G[10444]={478,501191,501272}
G[10446]={478,501191,501272}
G[10447]={478,501191,501272}
G[10448]={478,501191,501272}
G[10449]={465,501189,501271}
G[10450]={465,501189,501271}
G[10451]={473,501195}
G[10455]={475,501193}
G[10456]={475,501193}
G[10457]={475,501193}
G[10458]={473,501195}
G[10476]={477,501192,501273}
G[10479]={477,501192,501273}
G[10480]={473,501195}
G[10481]={473,501195}
G[10482]={465,501189,501271}
G[10483]={465,501189,501271}
G[10484]={465,501189,501271}
G[10485]={465,501189,501271}
G[10486]={475,501193}
G[10487]={475,501193}
G[10488]={475,501193}
G[10489]={475,501193}
G[10502]={475,501193}
G[10503]={475,501193}
G[10504]={475,501193}
G[10505]={475,501193}
G[10506]={475,501193}
G[10508]={479,501194}
G[10510]={475,501193}
G[10511]={475,501193}
G[10512]={475,501193}
G[10513]={473,501195}
G[10514]={473,501195}
G[10515]={473,501195}
G[10516]={475,501193}
G[10517]={475,501193}
G[10518]={475,501193}
G[10519]={473,501195}
G[10521]={473,501195}
G[10522]={473,501195}
G[10523]={473,501195}
G[10524]={475,501193}
G[10525]={475,501193}
G[10526]={475,501193}
G[10527]={473,501195}
G[10528]={473,501195}
G[10537]={473,501195}
G[10538]={465,501189,501271}
G[10540]={473,501195}
G[10541]={473,501195}
G[10542]={475,501193}
G[10543]={475,501193}
G[10544]={475,501193}
G[10545]={475,501193}
G[10546]={473,501195}
G[10547]={473,501195}
G[10550]={473,501195}
G[10555]={475,501193}
G[10556]={475,501193}
G[10557]={475,501193}
G[10562]={473,501195}
G[10563]={473,501195}
G[10564]={473,501195}
G[10565]={475,501193}
G[10566]={475,501193}
G[10567]={475,501193}
G[10568]={473,501195}
G[10569]={473,501195}
G[10570]={473,501195}
G[10571]={473,501195}
G[10572]={473,501195}
G[10573]={473,501195}
G[10574]={473,501195}
G[10575]={473,501195}
G[10576]={473,501195}
G[10577]={473,501195}
G[10578]={473,501195}
G[10579]={473,501195}
G[10580]={475,501193}
G[10581]={475,501193}
G[10582]={473,501195}
G[10583]={473,501195}
G[10584]={475,501193}
G[10585]={473,501195}
G[10586]={473,501195}
G[10587]={473,501195}
G[10588]={473,501195}
G[10589]={473,501195}
G[10594]={475,501193}
G[10595]={473,501195}
G[10596]={473,501195}
G[10597]={473,501195}
G[10598]={473,501195}
G[10599]={473,501195}
G[10600]={473,501195}
G[10601]={473,501195}
G[10602]={473,501195}
G[10603]={473,501195}
G[10604]={473,501195}
G[10606]={473,501195}
G[10607]={475,501193}
G[10608]={475,501193}
G[10609]={475,501193}
G[10611]={473,501195}
G[10612]={473,501195}
G[10613]={473,501195}
G[10614]={475,501193}
G[10615]={475,501193}
G[10617]={475,501193}
G[10618]={475,501193}
G[10619]={473,501195}
G[10620]={475,501193}
G[10621]={473,501195}
G[10622]={473,501195}
G[10623]={473,501195}
G[10624]={473,501195}
G[10625]={473,501195}
G[10626]={473,501195}
G[10627]={473,501195}
G[10628]={473,501195}
G[10629]={465,501189,501271}
G[10630]={465,501189,501271}
G[10632]={475,501193}
G[10633]={473,501195}
G[10634]={473,501195}
G[10635]={473,501195}
G[10636]={473,501195}
G[10637]={473,501195}
G[10639]={473,501195}
G[10640]={477,501192,501273}
G[10641]={477,501192,501273}
G[10642]={473,501195}
G[10643]={473,501195}
G[10644]={473,501195}
G[10645]={473,501195}
G[10646]={477,501192,501273}
G[10647]={473,501195}
G[10648]={473,501195}
G[10652]={479,501194}
G[10657]={475,501193}
G[10660]={473,501195}
G[10661]={473,501195}
G[10662]={473,501195}
G[10663]={473,501195}
G[10664]={473,501195}
G[10668]={477,501192,501273}
G[10669]={477,501192,501273}
G[10671]={475,501193}
G[10672]={473,501195}
G[10673]={473,501195}
G[10674]={475,501193}
G[10675]={475,501193}
G[10677]={473,501195}
G[10678]={473,501195}
G[10680]={473,501195}
G[10681]={473,501195}
G[10682]={475,501193}
G[10683]={473,501195}
G[10684]={473,501195}
G[10685]={473,501195}
G[10686]={473,501195}
G[10687]={473,501195}
G[10688]={473,501195}
G[10689]={477,501192,501273}
G[10690]={475,501193}
G[10692]={473,501195}
G[10701]={479,501194}
G[10702]={473,501195}
G[10703]={473,501195}
G[10705]={504956}
G[10709]={475,501193}
G[10710]={475,501193}
G[10711]={475,501193}
G[10712]={475,501193}
G[10713]={475,501193}
G[10714]={475,501193}
G[10715]={475,501193}
G[10717]={475,501193}
G[10718]={475,501193}
G[10719]={475,501193}
G[10720]={475,501193}
G[10721]={475,501193}
G[10722]={475,501193}
G[10723]={475,501193}
G[10724]={475,501193}
G[10742]={475,501193}
G[10744]={473,501195}
G[10745]={473,501195}
G[10747]={475,501193}
G[10748]={475,501193}
G[10749]={475,501193}
G[10750]={473,501195}
G[10751]={473,501195}
G[10753]={475,501193}
G[10759]={473,501195}
G[10760]={473,501195}
G[10761]={473,501195}
G[10765]={473,501195}
G[10766]={473,501195}
G[10767]={473,501195}
G[10768]={473,501195}
G[10769]={473,501195}
G[10770]={475,501193}
G[10771]={475,501193}
G[10772]={473,501195}
G[10773]={473,501195}
G[10774]={473,501195}
G[10775]={473,501195}
G[10776]={473,501195}
G[10777]={473,501195}
G[10778]={473,501195}
G[10780]={473,501195}
G[10781]={473,501195}
G[10782]={473,501195}
G[10783]={475,501193}
G[10784]={475,501193}
G[10785]={475,501193}
G[10786]={475,501193}
G[10791]={478,501191,501272}
G[10792]={465,501189,501271}
G[10793]={473,501195}
G[10795]={475,501193}
G[10796]={475,501193}
G[10797]={475,501193}
G[10798]={475,501193}
G[10799]={475,501193}
G[10800]={475,501193}
G[10801]={475,501193}
G[10802]={475,501193}
G[10803]={475,501193}
G[10804]={473,501195}
G[10805]={475,501193}
G[10806]={475,501193}
G[10807]={473,501195}
G[10808]={473,501195}
G[10809]={465,501189,501271}
G[10810]={475,501193}
G[10811]={473,501195}
G[10812]={475,501193}
G[10813]={465,501189,501271}
G[10814]={473,501195}
G[10816]={473,501195}
G[10817]={473,501195}
G[10818]={475,501193}
G[10819]={475,501193}
G[10820]={475,501193}
G[10821]={475,501193}
G[10824]={473,501195}
G[10825]={475,501193}
G[10826]={473,501195}
G[10829]={475,501193}
G[10830]={475,501193}
G[10834]={465,501189,501271}
G[10835]={465,501189,501271}
G[10836]={473,501195}
G[10837]={473,501195}
G[10838]={465,501189,501271}
G[10839]={478,501191,501272}
G[10840]={478,501191,501272}
G[10842]={478,501191,501272}
G[10843]={475,501193}
G[10845]={475,501193}
G[10846]={475,501193}
G[10847]={478,501191,501272}
G[10848]={478,501191,501272}
G[10849]={478,501191,501272}
G[10850]={479,501194}
G[10851]={475,501193}
G[10852]={478,501191,501272}
G[10853]={475,501193}
G[10854]={473,501195}
G[10855]={479,501194}
G[10856]={479,501194}
G[10857]={479,501194}
G[10858]={473,501195}
G[10859]={475,501193}
G[10860]={475,501193}
G[10861]={478,501191,501272}
G[10862]={478,501191,501272}
G[10863]={478,501191,501272}
G[10864]={465,501189,501271}
G[10865]={475,501193}
G[10866]={473,501195}
G[10867]={475,501193}
G[10868]={478,501191,501272}
G[10869]={478,501191,501272}
G[10870]={473,501195}
G[10871]={473,501195}
G[10872]={473,501195}
G[10873]={478,501191,501272}
G[10874]={478,501191,501272}
G[10875]={465,501189,501271}
G[10876]={465,501189,501271}
G[10877]={478,501191,501272}
G[10878]={478,501191,501272}
G[10879]={478,501191,501272}
G[10880]={478,501191,501272}
G[10881]={478,501191,501272}
G[10887]={478,501191,501272}
G[10889]={478,501191,501272}
G[10893]={475,501193}
G[10894]={475,501193}
G[10895]={465,501189,501271}
G[10896]={478,501191,501272}
G[10898]={478,501191,501272}
G[10900]={504956}
G[10903]={465,501189,501271}
G[10904]={475,501193}
G[10908]={478,501191,501272}
G[10909]={465,501189,501271}
G[10910]={475,501193}
G[10911]={475,501193}
G[10912]={475,501193}
G[10913]={478,501191,501272}
G[10914]={478,501191,501272}
G[10915]={478,501191,501272}
G[10916]={465,501189,501271}
G[10917]={478,501191,501272}
G[10919]={465,501189,501271}
G[10920]={478,501191,501272}
G[10921]={478,501191,501272}
G[10922]={478,501191,501272}
G[10923]={478,501191,501272}
G[10924]={479,501194}
G[10926]={478,501191,501272}
G[10927]={475,501193}
G[10928]={475,501193}
G[10929]={478,501191,501272}
G[10930]={478,501191,501272}
G[10935]={465,501189,501271}
G[10936]={465,501189,501271}
G[10937]={465,501189,501271}
G[10969]={479,501194}
G[10970]={479,501194}
G[10971]={479,501194}
G[10983]={475,501193}
G[10989]={475,501193}
G[10995]={475,501193}
G[10996]={475,501193}
G[10997]={475,501193}
G[11000]={475,501193}
G[11002]={465,501189,501271}
G[11003]={465,501189,501271}
G[11009]={475,501193}
G[11010]={475,501193}
G[11012]={473,501195}
G[11013]={473,501195}
G[11014]={473,501195}
G[11019]={473,501195}
G[11022]={475,501193}
G[11025]={475,501193}
G[11030]={475,501193}
G[11036]={475,501193}
G[11037]={477,501192,501273}
G[11040]={475,501193}
G[11042]={477,501192,501273}
G[11043]={475,501193}
G[11044]={477,501192,501273}
G[11047]={475,501193}
G[11048]={477,501192,501273}
G[11057]={475,501193}
G[11058]={475,501193}
G[11059]={475,501193}
G[11061]={475,501193}
G[11062]={475,501193}
G[11063]={473,501195}
G[11064]={473,501195}
G[11065]={475,501193}
G[11067]={473,501195}
G[11068]={473,501195}
G[11069]={473,501195}
G[11070]={473,501195}
G[11075]={473,501195}
G[11079]={475,501193}
G[11091]={475,501193}
G[11095]={473,501195}
G[11102]={475,501193}
G[11108]={473,501195}
G[11119]={475,501193}
G[11131]={500289}
--G[11132]={504956}
G[11153]={491,500034,501356}
G[11154]={491,500034,501356}
G[11155]={491,500034,501356}
G[11157]={491,500034,501356}
G[11167]={491,500034,501356}
G[11168]={491,500034,501356}
G[11170]={491,500034,501356}
G[11175]={491,500034,501356}
G[11176]={491,500034,501356}
--G[11178]={504956}
G[11182]={491,500034,501356}
G[11187]={491,500034,501356}
G[11188]={491,500034,501356}
G[11190]={491,500034,501356}
G[11199]={491,500034,501356}
G[11202]={491,500034,501356}
G[11208]={141,504929,504978}
G[11211]={141,504929,504978}
G[11212]={141,504929,504978}
G[11213]={141,504929,504978}
G[11215]={141,504929,504978}
G[11218]={491,500034,501356}
G[11219]={500289}
G[11221]={491,500034,501356}
G[11224]={491,500034,501356}
G[11227]={491,500034,501356}
G[11228]={491,500034,501356}
G[11229]={491,500034,501356}
G[11230]={491,500034,501356}
G[11231]={491,500034,501356}
G[11232]={491,500034,501356}
G[11233]={491,500034,501356}
G[11234]={491,500034,501356}
G[11235]={491,500034,501356}
G[11236]={491,500034,501356}
G[11237]={491,500034,501356}
G[11238]={491,500034,501356}
G[11239]={491,500034,501356}
G[11240]={491,500034,501356}
G[11241]={491,500034,501356}
G[11243]={491,500034,501356}
G[11244]={491,500034,501356}
G[11245]={491,500034,501356}
G[11246]={491,500034,501356}
G[11247]={491,500034,501356}
G[11248]={491,500034,501356}
G[11249]={491,500034,501356}
G[11250]={491,500034,501356}
G[11251]={491,500034,501356}
G[11252]={504956}
G[11253]={491,500034,501356}
G[11254]={491,500034,501356}
G[11255]={491,500034,501356}
G[11256]={491,500034,501356}
G[11257]={491,500034,501356}
G[11258]={491,500034,501356}
G[11259]={491,500034,501356}
G[11260]={491,500034,501356}
G[11261]={491,500034,501356}
G[11263]={491,500034,501356}
G[11264]={491,500034,501356}
G[11265]={491,500034,501356}
G[11266]={491,500034,501356}
G[11267]={491,500034,501356}
G[11268]={491,500034,501356}
G[11269]={491,500034,501356}
G[11270]={491,500034,501356}
G[11271]={491,500034,501356}
G[11272]={504956}
G[11273]={491,500034,501356}
G[11274]={491,500034,501356}
G[11275]={491,500034,501356}
G[11276]={491,500034,501356}
G[11277]={491,500034,501356}
G[11278]={491,500034,501356}
G[11279]={491,500034,501356}
G[11280]={491,500034,501356}
G[11281]={491,500034,501356}
G[11282]={491,500034,501356}
G[11283]={491,500034,501356}
G[11284]={491,500034,501356}
G[11285]={491,500034,501356}
G[11286]={491,500034,501356}
G[11287]={491,500034,501356}
G[11288]={491,500034,501356}
G[11289]={491,500034,501356}
G[11290]={491,500034,501356}
G[11291]={491,500034,501356}
G[11292]={491,500034,501356}
G[11295]={491,500034,501356}
G[11296]={491,500034,501356}
G[11297]={491,500034,501356}
G[11298]={491,500034,501356}
G[11299]={491,500034,501356}
G[11300]={491,500034,501356}
G[11301]={491,500034,501356}
G[11302]={491,500034,501356}
G[11303]={491,500034,501356}
G[11304]={491,500034,501356}
G[11305]={491,500034,501356}
G[11306]={491,500034,501356}
G[11307]={491,500034,501356}
G[11308]={491,500034,501356}
G[11309]={491,500034,501356}
G[11310]={491,500034,501356}
G[11311]={491,500034,501356}
G[11312]={491,500034,501356}
G[11313]={491,500034,501356}
G[11314]={491,500034,501356}
G[11315]={491,500034,501356}
G[11316]={491,500034,501356}
G[11317]={491,500034,501356}
G[11319]={491,500034,501356}
G[11322]={491,500034,501356}
G[11323]={491,500034,501356}
G[11324]={491,500034,501356}
G[11325]={491,500034,501356}
G[11326]={491,500034,501356}
G[11327]={491,500034,501356}
G[11328]={491,500034,501356}
G[11329]={491,500034,501356}
G[11330]={491,500034,501356}
G[11331]={491,500034,501356}
G[11332]={491,500034,501356}
G[11333]={491,500034,501356}
G[11343]={491,500034,501356}
G[11344]={491,500034,501356}
G[11346]={491,500034,501356}
G[11348]={491,500034,501356}
G[11349]={491,500034,501356}
G[11350]={491,500034,501356}
G[11351]={491,500034,501356}
G[11352]={491,500034,501356}
G[11355]={491,500034,501356}
G[11358]={491,500034,501356}
G[11359]={491,500034,501356}
G[11365]={491,500034,501356}
G[11366]={491,500034,501356}
G[11367]={491,500034,501356}
G[11377]={500906}
G[11379]={500906}
G[11380]={500906}
G[11381]={500906}
G[11390]={491,500034,501356}
G[11391]={491,500034,501356}
G[11393]={491,500034,501356}
G[11394]={491,500034,501356}
G[11395]={491,500034,501356}
G[11396]={491,500034,501356}
G[11397]={491,500034,501356}
G[11398]={491,500034,501356}
G[11399]={491,500034,501356}
G[11406]={491,500034,501356}
G[11410]={491,500034,501356}
G[11411]={491,500034,501356}
G[11414]={491,500034,501356}
G[11415]={491,500034,501356}
G[11416]={491,500034,501356}
G[11417]={491,500034,501356}
G[11418]={491,500034,501356}
G[11420]={491,500034,501356}
G[11421]={491,500034,501356}
G[11422]={491,500034,501356}
G[11423]={491,500034,501356}
G[11424]={491,500034,501356}
G[11426]={491,500034,501356}
G[11427]={491,500034,501356}
G[11428]={491,500034,501356}
G[11429]={491,500034,501356}
G[11430]={491,500034,501356}
G[11432]={491,500034,501356}
G[11433]={491,500034,501356}
G[11434]={491,500034,501356}
G[11436]={491,500034,501356}
G[11443]={491,500034,501356}
G[11448]={491,500034,501356}
G[11452]={491,500034,501356}
G[11453]={491,500034,501356}
G[11455]={491,500034,501356}
G[11456]={491,500034,501356}
G[11457]={491,500034,501356}
G[11458]={491,500034,501356}
G[11459]={491,500034,501356}
G[11460]={491,500034,501356}
G[11464]={491,500034,501356}
G[11465]={491,500034,501356}
G[11466]={491,500034,501356}
G[11467]={491,500034,501356}
G[11468]={491,500034,501356}
G[11469]={491,500034,501356}
G[11470]={491,500034,501356}
G[11471]={491,500034,501356}
G[11473]={491,500034,501356}
G[11474]={491,500034,501356}
G[11475]={491,500034,501356}
G[11476]={491,500034,501356}
G[11477]={491,500034,501356}
G[11478]={491,500034,501356}
G[11479]={491,500034,501356}
G[11480]={491,500034,501356}
G[11483]={491,500034,501356}
G[11484]={491,500034,501356}
G[11485]={491,500034,501356}
G[11489]={491,500034,501356}
G[11491]={491,500034,501356}
G[11494]={491,500034,501356}
G[11495]={491,500034,501356}
G[11501]={491,500034,501356}
G[11502]={477,501192,501273}
G[11504]={491,500034,501356}
G[11505]={478,501191,501272}
G[11506]={478,501191,501272}
G[11507]={491,500034,501356}
G[11508]={491,500034,501356}
G[11509]={491,500034,501356}
G[11510]={491,500034,501356}
G[11511]={491,500034,501356}
G[11512]={491,500034,501356}
G[11519]={491,500034,501356}
G[11527]={491,500034,501356}
G[11529]={491,500034,501356}
G[11530]={491,500034,501356}
G[11559]={486,500033,501358}
G[11560]={486,500033,501358}
G[11561]={486,500033,501358}
G[11562]={486,500033,501358}
G[11563]={486,500033,501358}
G[11564]={486,500033,501358}
G[11565]={486,500033,501358}
G[11566]={486,500033,501358}
G[11567]={491,500034,501356}
G[11568]={491,500034,501356}
G[11569]={486,500033,501358}
G[11570]={486,500033,501358}
G[11571]={486,500033,501358}
G[11572]={491,500034,501356}
G[11573]={491,500034,501356}
G[11574]={486,500033,501358}
G[11575]={486,500033,501358}
G[11576]={486,500033,501358}
G[11580]={501028}
G[11581]={501031}
G[11582]={486,500033,501358}
G[11583]={501022}
G[11584]={501025}
G[11585]={486,500033,501358}
G[11586]={486,500033,501358}
G[11587]={486,500033,501358}
G[11590]={486,500033,501358}
G[11591]={486,500033,501358}
G[11592]={486,500033,501358}
G[11593]={486,500033,501358}
G[11594]={486,500033,501358}
G[11595]={486,500033,501358}
G[11596]={486,500033,501358}
G[11598]={486,500033,501358}
G[11599]={486,500033,501358}
G[11600]={486,500033,501358}
G[11601]={486,500033,501358}
G[11602]={486,500033,501358}
G[11603]={486,500033,501358}
G[11604]={486,500033,501358}
G[11605]={486,500033,501358}
G[11606]={486,500033,501358}
G[11607]={486,500033,501358}
G[11608]={486,500033,501358}
G[11609]={486,500033,501358}
G[11610]={486,500033,501358}
G[11611]={486,500033,501358}
G[11612]={486,500033,501358}
G[11613]={486,500033,501358}
G[11614]={486,500033,501358}
G[11615]={486,500033,501358}
G[11616]={486,500033,501358}
G[11617]={486,500033,501358}
G[11618]={486,500033,501358}
G[11619]={486,500033,501358}
G[11620]={486,500033,501358}
G[11623]={486,500033,501358}
G[11624]={486,500033,501358}
G[11625]={486,500033,501358}
G[11626]={486,500033,501358}
G[11627]={486,500033,501358}
G[11628]={486,500033,501358}
G[11629]={486,500033,501358}
G[11630]={486,500033,501358}
G[11631]={486,500033,501358}
G[11632]={486,500033,501358}
G[11633]={486,500033,501358}
G[11634]={486,500033,501358}
G[11635]={486,500033,501358}
G[11636]={486,500033,501358}
G[11637]={486,500033,501358}
G[11638]={486,500033,501358}
G[11639]={486,500033,501358}
G[11640]={486,500033,501358}
G[11641]={486,500033,501358}
G[11642]={486,500033,501358}
G[11643]={486,500033,501358}
G[11644]={486,500033,501358}
G[11645]={486,500033,501358}
G[11646]={486,500033,501358}
G[11647]={486,500033,501358}
G[11648]={486,500033,501358}
G[11649]={486,500033,501358}
G[11650]={486,500033,501358}
G[11651]={486,500033,501358}
G[11652]={486,500033,501358}
G[11653]={486,500033,501358}
G[11654]={486,500033,501358}
G[11655]={486,500033,501358}
G[11656]={486,500033,501358}
G[11658]={486,500033,501358}
G[11659]={486,500033,501358}
G[11660]={486,500033,501358}
G[11661]={486,500033,501358}
G[11662]={486,500033,501358}
G[11663]={486,500033,501358}
G[11664]={486,500033,501358}
G[11665]={500905}
G[11666]={500905}
G[11667]={500905}
G[11668]={500905}
G[11669]={500905}
G[11670]={486,500033,501358}
G[11671]={486,500033,501358}
G[11672]={486,500033,501358}
G[11673]={486,500033,501358}
G[11674]={486,500033,501358}
G[11675]={486,500033,501358}
G[11676]={486,500033,501358}
G[11677]={486,500033,501358}
G[11678]={486,500033,501358}
G[11679]={486,500033,501358}
G[11680]={486,500033,501358}
G[11681]={486,500033,501358}
G[11682]={486,500033,501358}
G[11683]={486,500033,501358}
G[11684]={486,500033,501358}
G[11685]={486,500033,501358}
G[11686]={486,500033,501358}
G[11687]={486,500033,501358}
G[11688]={486,500033,501358}
G[11689]={486,500033,501358}
G[11690]={486,500033,501358}
G[11692]={486,500033,501358}
G[11693]={486,500033,501358}
G[11694]={486,500033,501358}
G[11695]={486,500033,501358}
G[11697]={486,500033,501358}
G[11698]={486,500033,501358}
G[11699]={486,500033,501358}
G[11700]={486,500033,501358}
G[11701]={486,500033,501358}
G[11702]={486,500033,501358}
G[11703]={486,500033,501358}
G[11704]={486,500033,501358}
G[11705]={486,500033,501358}
G[11706]={486,500033,501358}
G[11707]={486,500033,501358}
G[11708]={486,500033,501358}
G[11709]={486,500033,501358}
G[11710]={486,500033,501358}
G[11711]={486,500033,501358}
G[11712]={486,500033,501358}
G[11713]={486,500033,501358}
G[11714]={486,500033,501358}
G[11715]={486,500033,501358}
G[11716]={486,500033,501358}
G[11717]={486,500033,501358}
G[11718]={486,500033,501358}
G[11719]={486,500033,501358}
G[11720]={486,500033,501358}
G[11721]={486,500033,501358}
G[11722]={486,500033,501358}
G[11723]={486,500033,501358}
G[11724]={486,500033,501358}
G[11725]={486,500033,501358}
G[11726]={486,500033,501358}
G[11727]={486,500033,501358}
G[11728]={486,500033,501358}
G[11729]={486,500033,501358}
G[11730]={486,500033,501358}
G[11732]={501031}
G[11733]={486,500033,501358}
G[11734]={501032}
G[11735]={501032}
G[11736]={501033}
G[11737]={501031}
G[11738]={501032}
G[11739]={501031}
G[11740]={501032}
G[11741]={501032}
G[11742]={501031}
G[11743]={501031}
G[11744]={501032}
G[11745]={501031}
G[11746]={501032}
G[11747]={501033}
G[11749]={501031}
G[11750]={501033}
G[11751]={501031}
G[11752]={501033}
G[11753]={501032}
G[11754]={501033}
G[11755]={501031}
G[11756]={501031}
G[11757]={501031}
G[11758]={501033}
G[11759]={501033}
G[11760]={501032}
G[11761]={501031}
G[11762]={501032}
G[11763]={501032}
G[11764]={501028}
G[11765]={501029}
G[11766]={501028}
G[11767]={501030}
G[11768]={501028}
G[11769]={501029}
G[11770]={501029}
G[11771]={501029}
G[11772]={501028}
G[11773]={501029}
G[11774]={501028}
G[11775]={501030}
G[11776]={501028}
G[11777]={501029}
G[11778]={501030}
G[11779]={501030}
G[11780]={501029}
G[11781]={501028}
G[11782]={501030}
G[11783]={501029}
G[11784]={501028}
G[11786]={501028}
G[11787]={501030}
G[11788]={486,500033,501358}
G[11789]={486,500033,501358}
G[11790]={486,500033,501358}
G[11791]={486,500033,501358}
G[11792]={486,500033,501358}
G[11793]={486,500033,501358}
G[11794]={486,500033,501358}
G[11795]={486,500033,501358}
G[11796]={486,500033,501358}
G[11797]={486,500033,501358}
G[11798]={486,500033,501358}
G[11799]={501030}
G[11800]={501029}
G[11801]={501028}
G[11802]={501029}
G[11803]={501029}
G[11804]={501022}
G[11805]={501023}
G[11806]={501023}
G[11807]={501024}
G[11808]={501022}
G[11809]={501023}
G[11810]={501022}
G[11811]={501023}
G[11812]={501023}
G[11813]={501022}
G[11814]={501022}
G[11815]={501023}
G[11816]={501022}
G[11817]={501023}
G[11818]={501024}
G[11820]={501022}
G[11821]={501024}
G[11822]={501022}
G[11823]={501024}
G[11824]={501023}
G[11825]={501024}
G[11826]={501022}
G[11827]={501022}
G[11828]={501022}
G[11829]={501024}
G[11830]={501024}
G[11831]={501023}
G[11832]={501022}
G[11833]={501023}
G[11834]={501023}
G[11835]={501027}
G[11836]={501026}
G[11837]={501025}
G[11838]={501026}
G[11839]={501026}
G[11840]={501025}
G[11841]={501026}
G[11842]={501025}
G[11843]={501027}
G[11844]={501025}
G[11845]={501026}
G[11846]={501026}
G[11847]={501026}
G[11848]={501025}
G[11849]={501026}
G[11850]={501025}
G[11851]={501027}
G[11852]={501026}
G[11853]={501025}
G[11854]={501027}
G[11855]={501027}
G[11856]={501026}
G[11857]={501025}
G[11858]={501027}
G[11859]={501026}
G[11860]={501025}
G[11862]={501025}
G[11863]={501027}
G[11864]={486,500033,501358}
G[11865]={486,500033,501358}
G[11866]={486,500033,501358}
G[11868]={486,500033,501358}
G[11869]={486,500033,501358}
G[11870]={486,500033,501358}
G[11871]={486,500033,501358}
G[11872]={486,500033,501358}
G[11873]={486,500033,501358}
G[11876]={486,500033,501358}
G[11878]={486,500033,501358}
G[11879]={486,500033,501358}
G[11881]={486,500033,501358}
G[11884]={486,500033,501358}
G[11887]={486,500033,501358}
G[11888]={486,500033,501358}
G[11889]={486,500033,501358}
G[11890]={486,500033,501358}
G[11892]={486,500033,501358,500561}
G[11893]={486,500033,501358}
G[11894]={486,500033,501358}
G[11895]={486,500033,501358}
G[11896]={486,500033,501358}
G[11897]={486,500033,501358}
G[11898]={486,500033,501358}
G[11899]={486,500033,501358}
G[11900]={486,500033,501358}
G[11901]={486,500033,501358}
G[11902]={486,500033,501358}
G[11903]={486,500033,501358}
G[11904]={486,500033,501358}
G[11906]={486,500033,501358}
G[11907]={486,500033,501358}
G[11908]={486,500033,501358}
G[11909]={486,500033,501358}
G[11910]={486,500033,501358}
G[11912]={486,500033,501358}
G[11913]={486,500033,501358}
G[11914]={486,500033,501358}
G[11916]={486,500033,501358}
G[11918]={486,500033,501358}
G[11919]={486,500033,501358}
G[11920]={486,500033,501358}
G[11927]={486,500033,501358}
G[11928]={486,500033,501358}
G[11929]={486,500033,501358}
G[11930]={486,500033,501358}
G[11931]={486,500033,501358}
G[11932]={486,500033,501358}
G[11936]={486,500033,501358}
G[11938]={486,500033,501358}
G[11940]={486,500033,501358}
G[11941]={486,500033,501358}
G[11942]={486,500033,501358}
G[11943]={486,500033,501358}
G[11944]={486,500033,501358}
G[11946]={486,500033,501358}
G[11949]={486,500033,501358}
G[11950]={486,500033,501358}
G[11951]={486,500033,501358}
G[11956]={486,500033,501358}
G[11957]={486,500033,501358}
G[11959]={488,500035,501359}
G[11961]={486,500033,501358}
G[11962]={486,500033,501358}
G[11963]={486,500033,501358}
G[11965]={486,500033,501358}
G[11967]={486,500033,501358}
G[11968]={486,500033,501358}
G[11969]={486,500033,501358}
G[11977]={488,500035,501359}
G[11978]={488,500035,501359}
G[11979]={488,500035,501359}
G[11980]={488,500035,501359}
G[11981]={490,500037,501357}
G[11982]={490,500037,501357}
G[11983]={488,500035,501359}
G[11984]={490,500037,501357}
G[11985]={490,500037,501357}
G[11986]={490,500037,501357}
G[11988]={490,500037,501357}
G[11989]={490,500037,501357}
G[11990]={490,500037,501357}
G[11991]={490,500037,501357}
G[11993]={490,500037,501357}
G[11995]={488,500035,501359}
G[11996]={488,500035,501359}
G[11998]={490,500037,501357}
G[11999]={488,500035,501359}
G[12000]={488,500035,501359}
G[12002]={490,500037,501357}
G[12003]={490,500037,501357}
G[12004]={488,500035,501359}
G[12005]={488,500035,501359}
G[12006]={488,500035,501359}
G[12007]={490,500037,501357}
G[12008]={488,500035,501359}
G[12009]={488,500035,501359}
G[12010]={490,500037,501357}
G[12011]={488,500035,501359}
G[12013]={488,500035,501359}
G[12014]={490,500037,501357}
G[12016]={488,500035,501359}
G[12017]={488,500035,501359}
G[12019]={486,500033,501358}
G[12020]={501186}
G[12026]={490,500037,501357}
G[12027]={490,500037,501357}
G[12028]={488,500035,501359}
G[12029]={490,500037,501357}
G[12030]={488,500035,501359}
G[12031]={488,500035,501359}
G[12032]={488,500035,501359}
G[12033]={488,500035,501359}
G[12034]={488,500035,501359}
G[12035]={486,500033,501358}
G[12036]={488,500035,501359}
G[12037]={504956}
G[12038]={490,500037,501357}
G[12039]={488,500035,501359}
G[12040]={488,500035,501359}
G[12041]={488,500035,501359}
G[12042]={490,500037,501357}
G[12043]={488,500035,501359}
G[12044]={488,500035,501359}
G[12045]={488,500035,501359}
G[12046]={488,500035,501359}
G[12047]={488,500035,501359}
G[12048]={488,500035,501359}
G[12049]={488,500035,501359}
G[12050]={488,500035,501359}
G[12052]={488,500035,501359}
G[12053]={488,500035,501359}
G[12054]={490,500037,501357}
G[12055]={488,500035,501359}
G[12056]={488,500035,501359}
G[12057]={488,500035,501359}
G[12058]={490,500037,501357}
G[12059]={488,500035,501359}
G[12060]={488,500035,501359}
G[12061]={488,500035,501359}
G[12063]={488,500035,501359}
G[12064]={488,500035,501359}
G[12065]={488,500035,501359}
G[12066]={488,500035,501359}
G[12067]={488,500035,501359}
G[12068]={490,500037,501357}
G[12069]={488,500035,501359}
G[12070]={490,500037,501357}
G[12071]={488,500035,501359}
G[12072]={488,500035,501359}
G[12073]={490,500037,501357}
G[12074]={490,500037,501357}
G[12075]={488,500035,501359}
G[12076]={488,500035,501359}
G[12077]={488,500035,501359}
G[12078]={488,500035,501359}
G[12079]={488,500035,501359}
G[12080]={488,500035,501359}
G[12081]={490,500037,501357}
G[12082]={490,500037,501357}
G[12083]={488,500035,501359}
G[12084]={488,500035,501359}
G[12085]={488,500035,501359}
G[12086]={486,500033,501358}
G[12088]={486,500033,501358}
G[12089]={488,500035,501359}
G[12090]={488,500035,501359}
G[12091]={488,500035,501359}
G[12092]={488,500035,501359}
G[12093]={490,500037,501357}
G[12094]={490,500037,501357}
G[12095]={488,500035,501359}
G[12096]={488,500035,501359}
G[12097]={488,500035,501359}
G[12098]={488,500035,501359}
G[12099]={490,500037,501357}
G[12100]={488,500035,501359}
G[12101]={488,500035,501359}
G[12102]={488,500035,501359}
G[12104]={488,500035,501359}
G[12105]={490,500037,501357}
G[12106]={488,500035,501359}
G[12107]={488,500035,501359}
G[12109]={490,500037,501357}
G[12110]={488,500035,501359}
G[12111]={488,500035,501359}
G[12112]={488,500035,501359}
G[12113]={490,500037,501357}
G[12114]={490,500037,501357}
G[12115]={488,500035,501359}
G[12116]={490,500037,501357}
G[12117]={488,500035,501359}
G[12118]={488,500035,501359}
G[12119]={488,500035,501359}
G[12120]={490,500037,501357}
G[12121]={490,500037,501357}
G[12122]={488,500035,501359}
G[12123]={488,500035,501359}
G[12124]={488,500035,501359}
G[12125]={488,500035,501359}
G[12126]={488,500035,501359}
G[12127]={488,500035,501359}
G[12128]={490,500037,501357}
G[12129]={490,500037,501357}
G[12130]={490,500037,501357}
G[12131]={490,500037,501357}
G[12132]={488,500035,501359}
G[12134]={490,500037,501357}
G[12135]={500289}
G[12136]={488,500035,501359}
G[12137]={490,500037,501357}
G[12138]={490,500037,501357}
G[12139]={500289}
G[12140]={488,500035,501359}
G[12141]={486,500033,501358}
G[12142]={488,500035,501359}
G[12143]={488,500035,501359}
G[12144]={488,500035,501359}
G[12145]={488,500035,501359}
G[12146]={488,500035,501359}
G[12147]={488,500035,501359}
G[12148]={488,500035,501359}
G[12149]={488,500035,501359}
G[12150]={488,500035,501359}
G[12151]={488,500035,501359}
G[12152]={490,500037,501357}
G[12153]={490,500037,501357}
G[12154]={490,500037,501357}
G[12157]={488,500035,501359}
G[12158]={490,500037,501357}
G[12159]={490,500037,501357}
G[12160]={490,500037,501357}
G[12161]={490,500037,501357}
G[12164]={490,500037,501357}
G[12165]={490,500037,501357}
G[12166]={488,500035,501359}
G[12167]={488,500035,501359}
G[12168]={488,500035,501359}
G[12169]={488,500035,501359}
G[12170]={490,500037,501357}
G[12171]={488,500035,501359}
G[12174]={488,500035,501359}
G[12175]={490,500037,501357}
G[12176]={490,500037,501357}
G[12177]={490,500037,501357}
G[12178]={490,500037,501357}
G[12180]={490,500037,501357}
G[12181]={491,500034,501356}
G[12182]={488,500035,501359}
G[12183]={490,500037,501357}
G[12184]={490,500037,501357}
G[12185]={490,500037,501357}
G[12188]={488,500035,501359}
G[12189]={488,500035,501359}
G[12190]={490,500037,501357}
G[12192]={501186}
G[12195]={490,500037,501357}
G[12196]={490,500037,501357}
G[12197]={490,500037,501357}
G[12198]={490,500037,501357}
G[12199]={490,500037,501357}
G[12200]={488,500035,501359}
G[12201]={490,500037,501357}
G[12202]={490,500037,501357}
G[12203]={490,500037,501357}
G[12204]={490,500037,501357}
G[12205]={488,500035,501359}
G[12206]={488,500035,501359}
G[12207]={490,500037,501357}
G[12208]={490,500037,501357}
G[12209]={488,500035,501359}
G[12210]={490,500037,501357}
G[12211]={488,500035,501359}
G[12212]={490,500037,501357}
G[12213]={490,500037,501357}
G[12214]={488,500035,501359}
G[12215]={490,500037,501357}
G[12216]={490,500037,501357}
G[12217]={490,500037,501357}
G[12218]={488,500035,501359}
G[12219]={490,500037,501357}
G[12220]={490,500037,501357}
G[12221]={488,500035,501359}
G[12222]={490,500037,501357}
G[12223]={490,500037,501357}
G[12224]={488,500035,501359}
G[12225]={490,500037,501357}
G[12226]={490,500037,501357}
G[12227]={490,500037,501357}
G[12229]={490,500037,501357}
G[12230]={488,500035,501359}
G[12231]={490,500037,501357}
G[12232]={488,500035,501359}
G[12234]={488,500035,501359}
G[12235]={488,500035,501359}
G[12236]={490,500037,501357}
G[12237]={488,500035,501359}
G[12238]={501596}
G[12239]={488,500035,501359}
G[12240]={488,500035,501359}
G[12241]={490,500037,501357}
G[12242]={490,500037,501357}
G[12243]={488,500035,501359}
G[12245]={488,500035,501359}
G[12246]={490,500037,501357}
G[12247]={490,500037,501357}
G[12248]={490,500037,501357}
G[12249]={490,500037,501357}
G[12250]={490,500037,501357}
G[12251]={488,500035,501359}
G[12252]={488,500035,501359}
G[12253]={488,500035,501359}
G[12254]={488,500035,501359}
G[12255]={490,500037,501357}
G[12256]={490,500037,501357}
G[12257]={490,500037,501357}
G[12258]={488,500035,501359}
G[12259]={490,500037,501357}
G[12260]={488,500035,501359}
G[12261]={488,500035,501359}
G[12262]={488,500035,501359}
G[12263]={488,500035,501359}
G[12264]={488,500035,501359}
G[12265]={488,500035,501359}
G[12266]={488,500035,501359}
G[12267]={488,500035,501359}
G[12269]={488,500035,501359}
G[12271]={488,500035,501359}
G[12272]={488,500035,501359}
G[12273]={488,500035,501359}
G[12274]={488,500035,501359}
G[12275]={488,500035,501359}
G[12276]={488,500035,501359}
G[12277]={488,500035,501359}
G[12279]={490,500037,501357}
G[12281]={488,500035,501359}
G[12282]={488,500035,501359}
G[12283]={488,500035,501359}
G[12285]={488,500035,501359}
G[12286]={500966}
G[12287]={488,500035,501359}
G[12290]={488,500035,501359}
G[12291]={488,500035,501359}
G[12292]={490,500037,501357}
G[12293]={490,500037,501357}
G[12294]={490,500037,501357}
G[12295]={490,500037,501357}
G[12297]={488,500035,501359}
G[12298]={488,500035,501359}
G[12299]={490,500037,501357}
G[12300]={490,500037,501357}
G[12301]={488,500035,501359}
G[12302]={490,500037,501357}
G[12303]={488,500035,501359}
G[12304]={488,500035,501359}
G[12305]={488,500035,501359}
G[12307]={490,500037,501357}
G[12308]={490,500037,501357}
G[12309]={488,500035,501359}
G[12310]={490,500037,501357}
G[12311]={488,500035,501359}
G[12312]={488,500035,501359}
G[12319]={488,500035,501359}
G[12320]={488,500035,501359}
G[12321]={488,500035,501359}
G[12325]={488,500035,501359}
G[12326]={488,500035,501359}
G[12327]={490,500037,501357}
G[12328]={490,500037,501357}
G[12329]={490,500037,501357}
G[12330]={490,500037,501357}
G[12331]={500963}
G[12332]={500966}
G[12333]={500963}
G[12334]={500963}
G[12335]={500966}
G[12336]={500966}
G[12337]={500963}
G[12339]={500966}
G[12340]={500966}
G[12341]={500963}
G[12342]={500966}
G[12343]={500966}
G[12344]={500966}
G[12345]={500963}
G[12348]={500963}
--G[12349]={500963}	-- Theramore...now destroyed
G[12350]={500963}
G[12351]={500966}
G[12352]={500969}
G[12353]={500969}
G[12354]={500969}
G[12355]={500969}
G[12356]={500969}
G[12357]={500969}
G[12358]={500969}
G[12359]={500969}
G[12360]={500969}
G[12361]={500965}
G[12362]={500965}
G[12363]={500967}
G[12364]={500967}
G[12365]={500967}
G[12366]={500965}
G[12367]={500965}
G[12368]={500967}
G[12369]={500967}
G[12370]={500967}
G[12371]={500967}
G[12372]={488,500035,501359}
G[12373]={500967}
G[12374]={500965}
G[12376]={500967}
G[12377]={500965}
G[12378]={500965}
G[12380]={500967}
G[12381]={500965}
G[12382]={500967}
G[12383]={500965}
G[12384]={500967}
G[12386]={500965}
G[12387]={500967}
G[12388]={500968}
G[12389]={500968}
G[12390]={500968}
G[12391]={500968}
G[12392]={500968}
G[12393]={500968}
G[12394]={500968}
G[12395]={500968}
G[12396]={500963,500965}
G[12397]={500966,500967}
G[12398]={500963,500965}
G[12399]={500963,500965}
G[12400]={500963,500965}
G[12401]={500963,500965}
G[12402]={500966,500967}
G[12403]={500969,500968}
G[12404]={500969,500968}
G[12406]={500969,500968}
G[12407]={500969,500968}
G[12408]={500969,500968}
G[12409]={500969,500968}
G[12411]={490,500037,501357}
G[12412]={490,500037,501357}
G[12413]={490,500037,501357}
G[12414]={490,500037,501357}
G[12415]={490,500037,501357}
G[12416]={488,500035,501359}
G[12417]={488,500035,501359}
G[12418]={488,500035,501359}
G[12419]={488,500035,501359}
G[12422]={490,500037,501357}
G[12423]={490,500037,501357}
G[12424]={490,500037,501357}
G[12425]={490,500037,501357}
G[12427]={490,500037,501357}
G[12428]={490,500037,501357}
G[12429]={490,500037,501357}
G[12430]={490,500037,501357}
G[12431]={490,500037,501357}
G[12435]={488,500035,501359}
G[12436]={490,500037,501357}
G[12438]={488,500035,501359}
G[12439]={488,500035,501359}
G[12440]={488,500035,501359}
G[12441]={488,500035,501359}
G[12442]={488,500035,501359}
G[12447]={488,500035,501359}
G[12448]={488,500035,501359}
G[12449]={488,500035,501359}
G[12450]={488,500035,501359}
G[12451]={490,500037,501357}
G[12453]={490,500037,501357}
G[12454]={488,500035,501359}
G[12455]={488,500035,501359}
G[12456]={488,500035,501359}
G[12457]={488,500035,501359}
G[12458]={488,500035,501359}
G[12459]={488,500035,501359}
G[12460]={488,500035,501359}
G[12461]={488,500035,501359}
G[12462]={488,500035,501359}
G[12463]={488,500035,501359}
G[12464]={488,500035,501359}
G[12465]={488,500035,501359}
G[12466]={488,500035,501359}
G[12467]={488,500035,501359}
G[12468]={490,500037,501357}
G[12469]={488,500035,501359}
G[12470]={488,500035,501359}
G[12471]={486,500033,501358}
G[12472]={488,500035,501359}
G[12473]={488,500035,501359}
G[12474]={488,500035,501359}
G[12475]={488,500035,501359}
G[12476]={488,500035,501359}
G[12477]={488,500035,501359}
G[12478]={488,500035,501359}
G[12481]={491,500034,501356}
G[12482]={491,500034,501356}
G[12483]={490,500037,501357}
G[12484]={490,500037,501357}
G[12486]={486,500033,501358}
G[12487]={490,500037,501357}
G[12488]={488,500035,501359}
G[12489]={493,500039}
G[12495]={488,500035,501359}
G[12496]={488,500035,501359}
G[12497]={488,500035,501359}
G[12498]={488,500035,501359}
G[12499]={488,500035,501359,500547}
G[12500]={488,500035,501359,500547}
G[12503]={496,500036}
G[12504]={496,500036}
G[12505]={496,500036}
G[12506]={496,500036}
G[12507]={496,500036}
G[12508]={496,500036}
G[12510]={496,500036}
G[12511]={490,500037,501357}
G[12512]={496,500036}
G[12514]={496,500036}
G[12516]={496,500036}
G[12520]={493,500039}
G[12521]={493,500039}
G[12522]={493,500039}
G[12523]={493,500039}
G[12524]={493,500039}
G[12525]={493,500039}
G[12526]={493,500039}
G[12527]={496,500036}
G[12528]={493,500039}
G[12529]={493,500039}
G[12530]={493,500039}
G[12531]={493,500039}
G[12532]={493,500039}
G[12533]={493,500039}
G[12534]={493,500039}
G[12535]={493,500039}
G[12536]={493,500039}
G[12537]={493,500039}
G[12538]={493,500039}
G[12539]={493,500039}
G[12540]={493,500039}
G[12542]={488,500035,501359}
G[12543]={493,500039}
G[12544]={493,500039}
G[12545]={488,500035,501359}
G[12546]={493,500039}
G[12547]={201,504939}
G[12548]={493,500039}
G[12549]={493,500039}
G[12550]={493,500039}
G[12551]={493,500039}
G[12552]={496,500036}
G[12553]={496,500036}
G[12554]={496,500036}
G[12555]={496,500036}
G[12556]={493,500039}
G[12557]={496,500036}
G[12558]={493,500039}
G[12559]={493,500039}
G[12560]={493,500039}
G[12561]={493,500039}
G[12562]={496,500036}
G[12565]={496,500036}
G[12566]={491,500034,501356}
G[12567]={496,500036}
G[12569]={493,500039}
G[12570]={493,500039}
G[12571]={493,500039}
G[12572]={493,500039}
G[12573]={493,500039}
G[12574]={493,500039}
G[12575]={493,500039}
G[12576]={493,500039}
G[12577]={493,500039}
G[12578]={493,500039}
G[12579]={493,500039}
G[12580]={493,500039}
G[12581]={493,500039}
G[12582]={493,500039}
G[12583]={496,500036}
G[12584]={496,500036}
G[12589]={493,500039}
G[12592]={493,500039}
G[12595]={493,500039}
G[12596]={496,500036}
G[12597]={496,500036}
G[12598]={496,500036}
G[12599]={496,500036}
G[12603]={493,500039}
G[12605]={493,500039}
G[12606]={496,500036}
G[12607]={493,500039}
G[12608]={493,500039}
G[12609]={496,500036}
G[12610]={496,500036}
G[12611]={493,500039}
G[12612]={493,500039}
G[12613]={493,500039}
G[12614]={493,500039,500938}
G[12615]={496,500036}
G[12617]={493,500039}
G[12618]={496,500036}
G[12620]={493,500039}
G[12621]={493,500039}
G[12622]={496,500036}
G[12623]={496,500036}
G[12624]={493,500039}
G[12627]={496,500036}
G[12628]={496,500036}
G[12629]={496,500036}
G[12630]={496,500036}
G[12631]={496,500036}
G[12632]={496,500036}
G[12633]={496,500036}
G[12634]={493,500039}
G[12635]={496,500036}
G[12637]={496,500036}
G[12638]={496,500036}
G[12639]={496,500036}
G[12640]={496,500036}
G[12642]={496,500036}
G[12643]={496,500036}
G[12644]={493,500039}
G[12645]={493,500039}
G[12646]={496,500036}
G[12647]={496,500036}
G[12648]={496,500036}
G[12649]={496,500036}
G[12650]={496,500036}
G[12651]={493,500039}
G[12652]={496,500036}
G[12653]={496,500036}
G[12654]={493,500039}
G[12655]={496,500036}
G[12656]={496,500036}
G[12658]={493,500039}
G[12659]={496,500036}
G[12660]={493,500039}
G[12661]={496,500036}
G[12662]={496,500036}
G[12663]={496,500036}
G[12664]={496,500036}
G[12665]={496,500036}
G[12666]={496,500036}
G[12667]={496,500036}
G[12668]={496,500036}
G[12669]={496,500036}
G[12671]={493,500039}
G[12672]={496,500036}
G[12673]={496,500036}
G[12674]={496,500036}
G[12675]={496,500036}
G[12676]={496,500036}
G[12677]={496,500036}
G[12681]={493,500039}
G[12683]={493,500039}
G[12684]={496,500036}
G[12685]={496,500036}
G[12686]={496,500036}
G[12688]={493,500039}
G[12689]={493,500039}
G[12690]={496,500036}
G[12691]={493,500039}
G[12696]={493,500039}
G[12699]={493,500039}
G[12702]={500961}
G[12703]={500961}
G[12704]={500962}
G[12705]={500962}
G[12707]={496,500036}
G[12708]={496,500036}
G[12709]={496,500036}
G[12710]={496,500036}
G[12712]={496,500036}
G[12713]={496,500036,501596}
G[12721]={496,500036}
G[12726]={500962}
G[12728]={486,500033,501358}
G[12729]={496,500036}
G[12730]={496,500036}
G[12732]={500961}
G[12734]={500961}
G[12735]={500962}
G[12736]={500962}
G[12737]={500962}
G[12740]={496,500036}
G[12741]={500961}
G[12758]={500961}
G[12759]={500961}
G[12760]={500961}
G[12761]={500962}
G[12762]={500962}
G[12763]={490,500037,501357}
G[12766]={488,500035,501359}
G[12767]={488,500035,501359}
G[12768]={488,500035,501359}
G[12769]={488,500035,501359}
G[12770]={490,500037,501357}
G[12789]={496,500036}
G[12792]={496,500036}
G[12793]={496,500036}
G[12795]={496,500036}
G[12797]={493,500039}
G[12799]={496,500036}
G[12802]={490,500037,501357}
G[12803]={493,500039}
G[12804]={493,500039}
G[12805]={493,500039}
G[12806]={492,500040}
G[12807]={492,500040}
G[12810]={492,500040}
G[12814]={492,500040}
G[12818]={495,500038}
G[12819]={495,500038}
G[12820]={495,500038}
G[12821]={495,500038}
G[12822]={495,500038}
G[12823]={495,500038}
G[12824]={495,500038}
G[12826]={495,500038}
G[12827]={495,500038}
G[12828]={495,500038}
G[12829]={495,500038}
G[12830]={495,500038}
G[12831]={495,500038}
G[12832]={495,500038}
G[12833]={495,500038}
G[12836]={495,500038}
G[12839]={492,500040}
G[12840]={492,500040}
G[12841]={495,500038}
G[12843]={495,500038}
G[12844]={495,500038}
G[12846]={495,500038}
G[12847]={492,500040}
G[12851]={495,500038}
G[12852]={492,500040}
G[12853]={495,500038}
G[12854]={495,500038}
G[12855]={495,500038}
G[12856]={495,500038}
G[12857]={496,500036}
G[12858]={495,500038}
G[12859]={496,500036}
G[12860]={495,500038}
G[12861]={496,500036}
G[12862]={495,500038}
G[12863]={495,500038}
G[12864]={495,500038}
G[12865]={495,500038}
G[12866]={495,500038}
G[12867]={495,500038}
G[12868]={495,500038}
G[12870]={495,500038}
G[12871]={495,500038}
G[12872]={495,500038}
G[12873]={495,500038}
G[12874]={495,500038}
G[12875]={495,500038}
G[12876]={495,500038}
G[12877]={495,500038}
G[12878]={495,500038}
G[12879]={495,500038}
G[12880]={495,500038}
G[12882]={495,500038}
G[12883]={496,500036}
G[12884]={496,500036}
G[12885]={495,500038}
G[12886]={495,500038}
G[12887]={492,500040}
G[12888]={495,500038}
G[12889]={495,500038}
G[12891]={492,500040}
G[12892]={492,500040}
G[12893]={492,500040}
G[12894]={496,500036}
G[12895]={495,500038}
G[12896]={492,500040}
G[12897]={492,500040}
G[12898]={492,500040}
G[12899]={492,500040}
G[12900]={495,500038}
G[12901]={496,500036}
G[12902]={496,500036}
G[12903]={496,500036}
G[12904]={496,500036}
G[12905]={495,500038}
G[12906]={495,500038}
G[12907]={495,500038}
G[12908]={495,500038}
G[12909]={495,500038}
G[12910]={495,500038}
G[12912]={496,500036}
G[12913]={495,500038}
G[12914]={496,500036}
G[12915]={495,500038}
G[12916]={496,500036}
G[12917]={495,500038}
G[12919]={496,500036}
G[12920]={495,500038}
G[12921]={495,500038}
G[12922]={495,500038}
G[12924]={495,500038}
G[12925]={495,500038}
G[12926]={495,500038}
G[12927]={495,500038}
G[12928]={495,500038}
G[12929]={495,500038}
G[12930]={495,500038}
G[12931]={495,500038}
G[12932]={496,500036}
G[12933]={496,500036}
G[12934]={496,500036}
G[12935]={496,500036}
G[12936]={496,500036}
G[12937]={495,500038}
G[12938]={492,500040}
G[12939]={492,500040}
G[12940]={505836,505835}
G[12941]={505836,505835}
G[12942]={495,500038}
G[12943]={492,500040}
G[12944]={505836}
G[12945]={505836}
G[12946]={505835}
G[12947]={505835}
G[12948]={496,500036}
G[12949]={492,500040}
G[12950]={505836,505835}
G[12951]={492,500040}
G[12953]={495,500038}
G[12954]={496,500036}
G[12955]={492,500040}
G[12956]={495,500038}
G[12957]={495,500038}
G[12964]={495,500038}
G[12965]={495,500038}
G[12966]={495,500038}
G[12967]={495,500038}
G[12968]={495,500038}
G[12969]={495,500038}
G[12970]={495,500038}
G[12971]={495,500038}
G[12972]={495,500038}
G[12973]={495,500038}
G[12974]={496,500036}
G[12975]={495,500038}
G[12976]={495,500038}
G[12978]={495,500038}
G[12979]={495,500038}
G[12980]={495,500038}
G[12982]={492,500040}
G[12983]={495,500038}
G[12984]={495,500038}
G[12985]={495,500038}
G[12986]={495,500038}
G[12987]={495,500038}
G[12988]={495,500038}
G[12989]={495,500038}
G[12991]={495,500038}
G[12992]={492,500040}
G[12993]={495,500038}
G[12996]={495,500038}
G[12997]={495,500038}
G[12998]={495,500038}
G[12999]={492,500040}
G[13000]={495,500038}
G[13001]={495,500038}
G[13005]={495,500038}
G[13007]={495,500038}
G[13008]={492,500040}
G[13009]={495,500038}
G[13010]={495,500038}
G[13011]={495,500038}
G[13012]={501396}
G[13013]={501396}
G[13014]={501396}
G[13015]={501396}
G[13016]={501396}
G[13017]={500910}
G[13018]={501396}
G[13019]={501396}
G[13020]={501396}
G[13021]={500910}
G[13022]={500910}
G[13023]={500910}
G[13024]={501396}
G[13025]={501396}
G[13026]={501396}
G[13027]={501396}
G[13028]={501396}
G[13029]={501396}
G[13030]={501396}
G[13031]={501396}
G[13032]={501396}
G[13033]={501396}
G[13034]={495,500038}
G[13035]={495,500038}
G[13036]={492,500040}
G[13037]={495,500038}
G[13038]={495,500038}
G[13039]={492,500040}
G[13040]={492,500040}
G[13042]={492,500040}
G[13043]={492,500040}
G[13044]={492,500040}
G[13045]={492,500040}
G[13047]={495,500038}
G[13048]={495,500038}
G[13049]={495,500038}
G[13050]={495,500038}
G[13051]={495,500038}
G[13054]={495,500038}
G[13055]={495,500038}
G[13056]={495,500038}
G[13057]={495,500038}
G[13058]={495,500038}
G[13059]={492,500040}
G[13060]={495,500038}
G[13061]={495,500038}
G[13062]={495,500038}
G[13063]={495,500038}
G[13064]={495,500038}
G[13065]={500910}
G[13066]={500910}
G[13067]={500910}
G[13068]={492,500040}
G[13070]={492,500040}
G[13072]={492,500040}
G[13073]={492,500040}
G[13074]={492,500040}
G[13075]={492,500040}
G[13076]={492,500040}
G[13077]={492,500040}
G[13078]={488,500035,501359}
G[13079]={492,500040}
G[13080]={492,500040}
G[13081]={492,500040}
G[13082]={492,500040}
G[13083]={492,500040}
G[13084]={492,500040}
G[13085]={492,500040}
G[13086]={492,500040}
G[13091]={492,500040}
G[13092]={492,500040}
G[13097]={496,500036}
G[13099]={496,500036}
G[13100]={501782}
G[13101]={501782}
G[13102]={501782}
G[13103]={501782}
G[13104]={492,500040}
G[13105]={492,500040}
G[13106]={492,500040}
G[13107]={501782}
G[13110]={492,500040}
G[13112]={501783}
G[13113]={501783}
G[13114]={501783}
G[13115]={501783}
G[13116]={501783}
G[13117]={492,500040}
G[13118]={492,500040}
G[13119]={492,500040}
G[13120]={492,500040}
G[13121]={492,500040}
G[13122]={492,500040}
G[13124]={504956}
G[13125]={492,500040}
G[13130]={492,500040}
G[13131]={504956}
G[13133]={492,500040}
G[13134]={492,500040}
G[13135]={492,500040}
G[13136]={492,500040}
G[13137]={492,500040}
G[13138]={492,500040}
G[13139]={492,500040}
G[13140]={492,500040}
G[13141]={492,500040}
G[13142]={492,500040}
G[13143]={492,500040}
G[13144]={492,500040}
G[13145]={492,500040}
G[13146]={492,500040}
G[13147]={492,500040}
G[13149]={504956}
G[13152]={492,500040}
G[13155]={492,500040}
G[13157]={492,500040}
G[13160]={492,500040}
G[13161]={492,500040}
G[13162]={492,500040}
G[13163]={492,500040}
G[13164]={492,500040}
G[13168]={492,500040}
G[13169]={492,500040}
G[13170]={492,500040}
G[13171]={492,500040}
G[13172]={492,500040}
G[13174]={492,500040}
G[13205]={504956}
G[13207]={504956}
G[13211]={492,500040}
G[13212]={492,500040}
G[13213]={492,500040}
G[13214]={492,500040}
G[13215]={492,500040}
G[13216]={492,500040}
G[13217]={492,500040}
G[13218]={492,500040}
G[13219]={492,500040}
G[13220]={492,500040}
G[13221]={492,500040}
G[13224]={492,500040}
G[13225]={492,500040}
G[13226]={492,500040}
G[13227]={492,500040}
G[13228]={492,500040}
G[13229]={492,500040}
G[13230]={492,500040}
G[13231]={492,500040}
G[13232]={492,500040}
G[13235]={492,500040}
G[13236]={492,500040}
G[13237]={492,500040}
G[13238]={492,500040}
G[13239]={492,500040}
G[13258]={492,500040}
G[13259]={492,500040}
G[13260]={492,500040}
G[13263]={492,500040}
G[13264]={492,500040}
G[13271]={492,500040}
G[13273]={495,500038}
G[13274]={495,500038}
G[13275]={492,500040}
G[13277]={492,500040}
G[13278]={492,500040}
G[13279]={492,500040}
G[13280]={492,500040}
G[13282]={492,500040}
G[13283]={492,500040}
G[13285]={495,500038}
G[13286]={492,500040}
G[13287]={492,500040}
G[13288]={492,500040}
G[13290]={492,500040}
G[13291]={492,500040}
G[13293]={492,500040}
G[13294]={492,500040}
G[13295]={492,500040}
G[13296]={492,500040}
G[13298]={492,500040}
G[13304]={492,500040}
G[13305]={492,500040}
G[13306]={492,500040}
G[13307]={492,500040}
G[13308]={492,500040}
G[13312]={492,500040}
G[13313]={492,500040}
G[13314]={492,500040}
G[13315]={492,500040}
G[13316]={492,500040}
G[13318]={492,500040}
G[13319]={492,500040}
G[13320]={492,500040}
G[13321]={492,500040}
G[13328]={492,500040}
G[13329]={492,500040}
G[13332]={492,500040}
G[13334]={492,500040}
G[13335]={492,500040}
G[13337]={492,500040}
G[13338]={492,500040}
G[13339]={492,500040}
G[13340]={492,500040}
G[13341]={492,500040}
G[13342]={492,500040}
G[13343]={488,500035,501359}
G[13345]={492,500040}
G[13346]={492,500040}
G[13348]={492,500040}
G[13349]={492,500040}
G[13351]={492,500040}
G[13352]={492,500040}
G[13354]={492,500040}
G[13355]={492,500040}
G[13356]={492,500040}
G[13358]={492,500040}
G[13359]={492,500040}
G[13360]={492,500040}
G[13361]={492,500040}
G[13362]={492,500040}
G[13363]={492,500040}
G[13364]={492,500040}
G[13366]={492,500040}
G[13367]={492,500040}
G[13372]={488,500035,501359}
G[13373]={492,500040}
G[13375]={488,500035,501359}
G[13379]={492,500040}
G[13380]={492,500040}
G[13386]={492,500040}
G[13387]={492,500040}
G[13389]={492,500040}
G[13390]={492,500040}
G[13391]={492,500040}
G[13392]={492,500040}
G[13393]={492,500040}
G[13394]={492,500040}
G[13395]={492,500040}
G[13396]={492,500040}
G[13397]={492,500040}
G[13398]={492,500040}
G[13399]={492,500040}
G[13400]={492,500040}
G[13401]={492,500040}
G[13402]={492,500040}
G[13403]={492,500040}
G[13408]={465,501189,501271}
G[13409]={465,501189,501271}
G[13410]={465,501189,501271}
G[13411]={465,501189,501271}
G[13413]={486,500033,501358}
G[13415]={495,500038}
G[13416]={495,500038}
G[13418]={492,500040}
G[13419]={492,500040}
G[13420]={495,500038}
G[13426]={495,500038}
G[13431]={504956}
G[13433]={505836}
G[13434]={505836}
G[13435]={505836}
G[13436]={505836}
G[13437]={505836}
G[13438]={505836}
G[13439]={505836}
G[13440]={506010}
G[13441]={506007}
G[13442]={506010}
G[13443]={506010}
G[13444]={506010}
G[13445]={506010}
G[13446]={506010}
G[13447]={506010}
G[13448]={505836}
G[13449]={506010}
G[13450]={506007}
G[13451]={506007}
G[13452]={505836,505835}
G[13453]={506007}
G[13454]={506007}
G[13455]={506007}
G[13456]={505836,505835}
G[13457]={506007}
G[13458]={506007}
G[13459]={505836,505835}
G[13460]={505836,505835}
G[13461]={505836,505835}
G[13462]={505836,505835}
G[13463]={505836,505835}
G[13464]={505835}
G[13465]={505835}
G[13466]={505835}
G[13467]={505835}
G[13468]={505835}
G[13469]={505835}
G[13470]={505835}
G[13471]={505835}
G[13472]={505836,505835}
G[13473]={505836}
G[13474]={505835}
G[13481]={492,500040}
G[13482]={492,500040}
G[13485]={506008}
G[13486]={506008}
G[13487]={506008}
G[13488]={506008}
G[13489]={506008}
G[13490]={506008}
G[13491]={506008}
G[13492]={506008}
G[13493]={506009}
G[13494]={506009}
G[13495]={506009}
G[13496]={506009}
G[13497]={506009}
G[13498]={506009}
G[13499]={506009}
G[13500]={506009}
G[13501]={505835}
G[13504]={42,504928}
G[13505]={42,504928}
G[13506]={42,504928}
G[13507]={42,504928}
G[13508]={42,504928}
G[13509]={42,504928}
G[13510]={42,504928}
G[13511]={42,504928}
G[13512]={42,504928}
G[13513]={42,504928}
G[13514]={42,504928}
G[13515]={42,504928}
G[13518]={42,504928}
G[13519]={42,504928}
G[13520]={42,504928}
G[13521]={42,504928}
G[13522]={42,504928}
G[13523]={42,504928}
G[13525]={42,504928}
G[13526]={42,504928}
G[13527]={42,504928}
G[13528]={42,504928}
G[13529]={42,504928}
G[13537]={42,504928}
G[13542]={42,504928}
G[13543]={42,504928}
G[13544]={42,504928}
G[13545]={42,504928}
G[13546]={42,504928}
G[13547]={42,504928}
G[13548]={505835}
G[13549]={496,500036}
G[13554]={42,504928}
G[13556]={496,500036}
G[13557]={42,504928}
G[13558]={42,504928}
G[13560]={42,504928}
G[13561]={42,504928}
G[13562]={42,504928}
G[13563]={42,504928}
G[13564]={42,504928}
G[13565]={42,504928}
G[13566]={42,504928}
G[13567]={42,504928}
G[13568]={42,504928}
G[13569]={42,504928}
G[13570]={42,504928}
G[13572]={42,504928}
G[13573]={42,504928}
G[13575]={42,504928}
G[13576]={42,504928}
G[13577]={42,504928}
G[13578]={42,504928}
G[13579]={42,504928}
G[13580]={42,504928}
G[13581]={42,504928}
G[13582]={42,504928}
G[13583]={42,504928}
G[13584]={42,504928}
G[13585]={42,504928}
G[13586]={42,504928}
G[13587]={42,504928}
G[13588]={42,504928}
G[13589]={42,504928}
G[13590]={42,504928}
G[13591]={42,504928}
G[13594]={43,504925}
G[13595]={43,504925}
G[13596]={42,504928}
G[13597]={42,504928}
G[13598]={42,504928}
G[13599]={42,504928}
G[13601]={42,504928}
G[13602]={43,504925}
G[13605]={42,504928}
G[13612]={43,504925,504976}
G[13613]={43,504925,504976}
G[13615]={43,504925,504976}
G[13617]={43,504925}
G[13618]={43,504925,504976}
G[13619]={43,504925,504976}
G[13620]={43,504925,504976}
G[13621]={43,504925,504976}
G[13623]={43,504925}
G[13624]={43,504925}
G[13626]={43,504925}
G[13628]={43,504925,504976}
G[13630]={43,504925}
G[13632]={43,504925}
G[13636]={35,504899}
G[13639]={35,504899}
G[13640]={43,504925,504976}
G[13642]={43,504925}
G[13644]={43,504925}
G[13645]={43,504925}
G[13646]={43,504925}
G[13647]={35,504899}
G[13648]={35,504899}
G[13650]={35,504899}
G[13651]={43,504925,504976}
G[13653]={43,504925,504976}
G[13655]={35,504899}
G[13656]={35,504899}
G[13657]={35,504899}
G[13658]={35,504899}
G[13659]={35,504899}
G[13660]={35,504899}
G[13661]={35,504899}
G[13683]={43,504925}
G[13698]={43,504925}
G[13712]={43,504925,504976}
G[13730]={43,504925,504976}
G[13751]={43,504925,504976}
G[13766]={43,504925}
G[13792]={43,504925}
G[13796]={43,504925}
G[13797]={43,504925,504976}
G[13798]={43,504925,504976}
G[13801]={43,504925,504976}
G[13803]={43,504925,504976}
G[13805]={43,504925,504976}
G[13806]={43,504925,504976}
G[13808]={43,504925,504976}
G[13815]={43,504925,504976}
G[13830]={503217}
G[13831]={42,504928}
G[13832]={503217}
G[13833]={503217}
G[13834]={503217}
G[13836]={503217}
G[13841]={43,504925,504976}
G[13842]={43,504925,504976}
G[13844]={42,504928}
G[13848]={43,504925,504976}
G[13849]={43,504925}
G[13850]={201,504939}
G[13853]={43,504925}
G[13865]={43,504925,504976}
G[13866]={43,504925,504976}
G[13867]={43,504925}
G[13868]={43,504925}
G[13869]={43,504925}
G[13870]={43,504925,504976}
G[13871]={43,504925,504976}
G[13872]={43,504925}
G[13873]={43,504925,504976}
G[13874]={43,504925}
G[13875]={43,504925,504976}
G[13876]={43,504925}
G[13877]={43,504925}
G[13878]={11,504933}
G[13879]={43,504925,504976}
G[13880]={43,504925}
G[13881]={42,504928}
G[13882]={42,504928}
G[13883]={43,504925,504976}
G[13884]={43,504925}
G[13885]={42,504928}
G[13886]={43,504925}
G[13887]={201,504939}
G[13888]={43,504925,504976}
G[13889]={201,504939}
G[13890]={43,504925,504976}
G[13891]={42,504928}
G[13892]={42,504928}
G[13893]={42,504928}
G[13895]={42,504928}
G[13896]={42,504928}
G[13897]={42,504928}
G[13898]={42,504928}
G[13899]={42,504928}
G[13900]={42,504928}
G[13901]={43,504925,504976}
G[13902]={42,504928}
G[13903]={201,504939}
G[13904]={201,504939}
G[13905]={201,504939}
G[13907]={42,504928}
G[13909]={42,504928}
G[13910]={42,504928}
G[13911]={42,504928}
G[13912]={42,504928}
G[13913]={43,504925}
G[13914]={201,504939}
G[13915]={201,504939}
G[13916]={201,504939}
G[13917]={201,504939}
G[13918]={42,504928}
G[13920]={43,504925,504976}
G[13921]={43,504925}
G[13922]={43,504925}
G[13923]={43,504925,504976}
G[13924]={43,504925}
G[13925]={42,504928}
G[13928]={43,504925}
G[13935]={43,504925}
G[13936]={43,504925,504976}
G[13940]={42,504928}
G[13942]={43,504925,504976}
G[13943]={43,504925,504976}
G[13944]={43,504925,504976}
G[13947]={43,504925,504976}
G[13948]={42,504928}
G[13949]={11,504933}
G[13953]={42,504928}
G[13958]={43,504925,504976}
G[13961]={11,504933}
G[13962]={43,504925,504976}
G[13963]={11,504933}
G[13964]={43,504925}
G[13965]={43,504925}
G[13967]={43,504925,504976}
G[13968]={11,504933}
G[13969]={11,504933}
G[13970]={11,504933}
G[13971]={11,504933}
G[13973]={11,504933}
G[13974]={43,504925,504976}
G[13975]={11,504933}
G[13976]={43,504925}
G[13977]={43,504925,504976}
G[13979]={43,504925}
G[13980]={43,504925,504976}
G[13981]={43,504925}
G[13982]={43,504925}
G[13983]={43,504925,504976}
G[13985]={43,504925}
G[13987]={43,504925}
G[13988]={11,504933}
G[13989]={43,504925}
G[13991]={11,504933}
G[13992]={11,504933}
G[13995]={11,504933}
G[13998]={11,504933}
G[13999]={11,504933}
G[14003]={11,504933}
G[14004]={11,504933}
G[14006]={11,504933}
G[14034]={11,504933}
G[14038]={11,504933}
G[14042]={11,504933}
G[14045]={11,504933}
G[14046]={11,504933}
G[14048]={503596}
G[14049]={11,504933}
G[14050]={11,504933}
G[14051]={503596}
G[14052]={11,504933}
G[14053]={503596}
G[14054]={503596}
G[14055]={503596}
G[14056]={11,504933}
G[14057]={11,504933}
G[14058]={503597}
G[14059]={503597}
G[14060]={503597}
G[14061]={503597}
G[14062]={503597}
G[14063]={11,504933}
G[14066]={11,504933}
G[14067]={11,504933}
G[14068]={11,504933}
G[14072]={11,504933}
G[14073]={11,504933}
G[14117]={181,504927}
G[14118]={181,504927}
G[14127]={181,504927}
G[14128]={181,504927}
G[14129]={181,504927}
G[14130]={181,504927}
G[14131]={181,504927}
G[14132]={181,504927}
G[14134]={181,504927}
G[14135]={181,504927}
G[14155]={181,504927}
G[14161]={181,504927}
G[14162]={181,504927}
G[14165]={181,504927}
G[14190]={181,504927}
G[14192]={181,504927}
G[14193]={101,504930}
G[14194]={181,504927}
G[14196]={101,504930}
G[14197]={181,504927}
G[14201]={181,504927}
G[14202]={181,504927}
G[14209]={181,504927}
G[14215]={181,504927}
G[14216]={181,504927}
G[14226]={181,504927}
G[14230]={181,504927}
G[14246]={101,504930}
G[14247]={101,504930}
G[14249]={181,504927}
G[14250]={181,504927}
G[14251]={101,504930}
G[14252]={101,504930}
G[14253]={101,504930}
G[14254]={101,504930}
G[14256]={101,504930}
G[14257]={101,504930}
G[14258]={181,504927}
G[14260]={101,504930}
G[14261]={181,504927}
G[14262]={181,504927}
G[14263]={181,504927}
G[14264]={101,504930}
G[14267]={181,504927}
G[14268]={101,504930}
G[14270]={181,504927}
G[14271]={181,504927}
G[14282]={101,504930}
G[14284]={101,504930}
G[14292]={101,504930}
G[14295]={181,504927}
G[14296]={181,504927}
G[14297]={181,504927}
G[14299]={181,504927}
G[14300]={181,504927}
G[14301]={101,504930}
G[14302]={101,504930}
G[14304]={101,504930}
G[14305]={101,504930}
G[14306]={101,504930}
G[14307]={101,504930}
G[14308]={181,504927}
G[14309]={101,504930}
G[14310]={181,504927}
G[14311]={101,504930}
G[14312]={101,504930}
G[14314]={101,504930}
G[14316]={101,504930}
G[14318]={101,504930}
G[14322]={181,504927}
G[14323]={181,504927}
G[14324]={181,504927}
G[14325]={101,504930}
G[14327]={101,504930}
G[14328]={101,504930}
G[14329]={101,504930}
G[14330]={101,504930}
G[14333]={101,504930}
G[14340]={181,504927}
G[14345]={181,504927}
G[14354]={101,504930}
G[14357]={101,504930}
G[14358]={101,504930}
G[14361]={101,504930}
G[14362]={101,504930}
G[14363]={101,504930}
G[14364]={101,504930}
G[14365]={101,504930}
G[14370]={181,504927}
G[14371]={181,504927}
G[14372]={101,504930}
G[14376]={101,504930}
G[14377]={181,504927}
G[14383]={181,504927}
G[14384]={101,504930}
G[14385]={181,504927}
G[14388]={181,504927}
G[14389]={181,504927}
G[14390]={181,504927}
G[14391]={181,504927}
G[14392]={181,504927}
G[14407]={181,504927}
G[14408]={181,504927}
G[14410]={121,504932,504979}
G[14413]={181,504927}
G[14422]={181,504927}
G[14423]={181,504927}
G[14424]={181,504927}
G[14428]={181,504927}
G[14429]={181,504927}
G[14430]={181,504927}
G[14431]={181,504927}
G[14432]={181,504927}
G[14433]={181,504927}
G[14435]={181,504927}
G[14442]={181,504927}
G[14443]={492,500040}
G[14462]={181,504927}
G[14464]={181,504927}
G[14468]={181,504927}
G[14469]={181,504927}
G[14470]={181,504927}
G[14471]={181,504927}
G[14472]={181,504927}
G[14475]={181,504927}
G[14476]={181,504927}
G[14477]={181,504927}
G[14478]={181,504927}
G[14479]={181,504927}
G[14480]={181,504927}
G[14484]={181,504927}
G[14485]={181,504927}
G[14486]={181,504927}
G[14487]={181,504927}
G[24430]={181,504927}
G[24433]={181,504927}
G[24434]={181,504927}
G[24435]={181,504927}
G[24436]={181,504927}
G[24437]={181,504927}
G[24439]={181,504927}
G[24448]={181,504927}
G[24449]={181,504927}
G[24452]={181,504927}
G[24453]={181,504927}
G[24455]={181,504927}
G[24458]={181,504927}
G[24463]={181,504927}
G[24467]={181,504927}
G[24478]={181,504927}
G[24479]={181,504927}
G[24497]={181,504927}
G[24504]={607,504937,504981}
G[24505]={607,504937,504981}
G[24506]={504956}
G[24510]={504956}
G[24512]={607,504937,504981}
G[24513]={607,504937,504981}
G[24514]={607,504937,504981}
G[24515]={607,504937,504981}
G[24517]={607,504937,504981}
G[24518]={607,504937,504981}
G[24519]={607,504937,504981}
G[24525]={607,504937,504981}
G[24529]={607,504937,504981}
G[24534]={607,504937,504981}
G[24539]={607,504937,504981}
G[24542]={607,504937,504981}
G[24543]={607,504937,504981}
G[24546]={607,504937,504981}
G[24551]={607,504937,504981}
G[24552]={607,504937,504981}
G[24554]={492,500040}
G[24565]={607,504937,504981}
G[24566]={607,504937,504981}
G[24569]={607,504937,504981}
G[24570]={607,504937,504981}
G[24571]={607,504937,504981}
G[24572]={607,504937,504981}
G[24573]={607,504937,504981}
G[24574]={607,504937,504981}
G[24577]={607,504937,504981}
G[24591]={607,504981}
G[24601]={607,504937,504981}
G[24603]={607,504937,504981}
G[24604]={607,504937,504981}
G[24606]={607,504937,504981}
G[24608]={607,504937,504981}
G[24618]={607,504937,504981}
G[24619]={607,504937,504981}
G[24620]={607,504937,504981}
G[24621]={607,504937,504981}
G[24631]={607,504937,504981}
G[24632]={607,504937,504981}
G[24633]={607,504937,504981}
G[24634]={607,504937,504981}
G[24637]={607,504937,504981}
G[24638]={501695}
G[24645]={501695}
G[24647]={501695}
G[24648]={501695}
G[24649]={501695}
G[24650]={501695}
G[24651]={501695}
G[24652]={501695}
G[24653]={607,504937,504981}
G[24654]={607,504937,504981}
G[24658]={501695}
G[24659]={501695}
G[24660]={501695}
G[24662]={501695}
G[24663]={501695}
G[24664]={501695}
G[24665]={501695}
G[24666]={501695}
G[24667]={607,504937,504981}
G[24684]={607,504937,504981}
G[24685]={607,504937,504981}
G[24686]={201,504939}
G[24687]={201,504939}
G[24689]={201,504939}
G[24690]={201,504939}
G[24691]={201,504939}
G[24692]={201,504939}
G[24693]={201,504939}
G[24694]={201,504939}
G[24695]={201,504939}
G[24697]={201,504939}
G[24698]={201,504939}
G[24699]={201,504939}
G[24700]={201,504939}
G[24701]={201,504939}
G[24703]={201,504939}
G[24704]={201,504939}
G[24705]={201,504939}
G[24706]={201,504939}
G[24707]={201,504939}
G[24708]={201,504939}
G[24709]={201,504939}
G[24714]={201,504939}
G[24715]={201,504939}
G[24717]={201,504939}
G[24719]={201,504939}
G[24720]={201,504939}
G[24721]={201,504939}
G[24722]={201,504939}
G[24723]={201,504939}
G[24730]={201,504939}
G[24731]={201,504939}
G[24732]={201,504939}
G[24733]={201,504939}
G[24734]={201,504939}
G[24735]={201,504939}
G[24736]={201,504939}
G[24737]={201,504939}
G[24740]={201,504939}
G[24742]={201,504939}
G[24747]={607,504937,504981}
G[24794]={201,504939}
G[24807]={607,504937,504981}
G[24824]={607,504937,504981}
G[24854]={201,504939}
G[24855]={201,504939}
G[24862]={607,504937}
G[24863]={607,504937}
G[24865]={201,504939}
G[24866]={201,504939}
G[24905]={161,504935}
G[24906]={161,504935}
G[24907]={161,504935}
G[24910]={161,504935}
G[24911]={201,504939}
G[24913]={38,504904}
G[24921]={607,504937}
G[24926]={201,504939}
G[24927]={161,504935}
G[24928]={161,504935}
G[24931]={161,504935}
G[24932]={161,504935}
G[24933]={161,504935}
G[24934]={607,504937}
G[24938]={607,504937}
G[24939]={607,504937}
G[24941]={607,504937}
G[24943]={607,504937}
G[24944]={607,504937}
G[24947]={161,504935}
G[24948]={607,504937}
G[24949]={161,504935}
G[24950]={161,504935}
G[24951]={161,504935}
G[24953]={161,504935}
G[24955]={161,504935}
G[24956]={607,504937}
G[24957]={161,504935}
G[24963]={161,504935}
G[25000]={607,504937}
G[25001]={161,504935}
G[25002]={607,504937}
G[25008]={607,504937}
G[25014]={161,504935}
G[25015]={607,504937}
G[25017]={161,504935}
G[25018]={161,504935}
G[25019]={161,504935}
G[25020]={161,504935}
G[25021]={161,504935}
G[25022]={607,504937}
G[25025]={161,504935}
G[25026]={161,504935}
G[25027]={607,504937}
G[25028]={607,504937}
G[25032]={161,504935}
G[25034]={607,504937}
G[25036]={607,504937}
G[25041]={607,504937}
G[25042]={607,504937}
G[25043]={607,504937}
G[25044]={607,504937}
G[25045]={607,504937}
G[25048]={161,504935}
G[25049]={161,504935}
G[25050]={161,504935}
G[25051]={141,504929,504978}
G[25052]={161,504935}
G[25053]={161,504935}
G[25054]={161,504935}
G[25057]={607,504937}
G[25059]={607,504937}
G[25060]={161,504935}
G[25061]={161,504935}
G[25062]={161,504935}
G[25063]={161,504935}
G[25065]={161,504935}
G[25067]={161,504935}
G[25068]={161,504935}
G[25069]={161,504935}
G[25070]={161,504935}
G[25072]={161,504935}
G[25074]={607,504937}
G[25075]={607,504937}
G[25079]={607,504937}
G[25080]={607,504937}
G[25081]={607,504937}
G[25082]={607,504937}
G[25084]={607,504937}
G[25085]={607,504937}
G[25086]={607,504937}
G[25087]={607,504937}
G[25091]={161,504935}
G[25094]={161,504935}
G[25095]={161,504935}
G[25102]={607,504937}
G[25103]={161,504935}
G[25104]={607,504937}
G[25106]={607,504937}
G[25107]={161,504935}
G[25108]={607,504937}
G[25111]={161,504935}
G[25112]={161,504935}
G[25115]={161,504935}
G[25118]={35,504899}
G[25120]={607,504937}
G[25121]={161,504935}
G[25151]={607,504937}
G[25153]={607,504937}
G[25163]={607,504937}
G[25164]={615,504869,504982}
G[25166]={161,504935}
G[25174]={607,504937}
G[25175]={607,504937}
G[25182]={607,504937}
G[25183]={607,504937}
G[25185]={607,504937}
G[25186]={607,504937}
G[25191]={607,504937}
G[25197]={607,504937}
G[25208]={121,504932,504979}
G[25209]={121,504932,504979}
G[25210]={121,504932,504979}
G[25211]={40,504899}
G[25215]={615,504869,504982}
G[25216]={615,504869,504982}
G[25217]={615,504869,504982}
G[25218]={615,504869,504982}
G[25219]={615,504869,504982}
G[25220]={615,504869,504982}
G[25221]={615,504869,504982}
G[25222]={615,504869,504982}
G[25223]={606,504870}
G[25224]={606,504870}
G[25230]={121,504932,504979}
G[25233]={606,504870}
G[25234]={606,504870}
G[25235]={34,504903}
G[25237]={121,504932,504979}
G[25241]={121,504932,504979}
G[25250]={121,504932,504979}
G[25252]={121,504932,504979}
G[25255]={606,504870}
G[25268]={606,504870}
G[25269]={606,504870}
G[25270]={606,504870}
G[25271]={606,504870}
G[25272]={606,504870}
G[25273]={606,504870}
G[25274]={606,504870}
G[25276]={606,504870}
G[25277]={606,504870}
G[25278]={606,504870}
G[25279]={606,504870}
G[25280]={606,504870}
G[25281]={610,504869,504982}
G[25284]={607,504937,504981}
G[25291]={606,504870}
G[25292]={141,504929,504978}
G[25294]={606,504870}
G[25296]={606,504870}
G[25297]={606,504870}
G[25298]={606,504870}
G[25299]={606,504870}
G[25300]={606,504870}
G[25301]={606,504870}
G[25303]={606,504870}
G[25304]={121,504932,504979}
G[25308]={606,504870}
G[25309]={606,504870}
G[25310]={606,504870}
G[25311]={606,504870}
G[25312]={606,504870}
G[25314]={606,504870}
G[25315]={606,504870}
G[25317]={606,504870}
G[25319]={606,504870}
G[25320]={606,504870}
G[25321]={606,504870}
G[25323]={606,504870}
G[25324]={606,504870}
G[25325]={606,504870}
G[25328]={606,504870}
G[25329]={121,504932,504979}
G[25330]={606,504870}
G[25332]={606,504870}
G[25333]={121,504932,504979}
G[25334]={615,504869,504982}
G[25336]={121,504932,504979}
G[25337]={121,504932,504979}
G[25338]={121,504932,504979}
G[25339]={121,504932,504979}
G[25340]={121,504932,504979}
G[25341]={121,504932,504979}
G[25342]={121,504932,504979}
G[25344]={121,504932,504979}
G[25345]={121,504932,504979}
G[25346]={121,504932,504979}
G[25349]={121,504932,504979}
G[25350]={121,504932,504979}
G[25352]={606,504870}
G[25353]={606,504870}
G[25354]={606,504870}
G[25355]={606,504870}
G[25356]={61,504938}
G[25357]={610,504869,504982}
G[25358]={610,504869,504982}
G[25359]={615,504869,504982}
G[25360]={615,504869,504982}
G[25361]={121,504932,504979}
G[25362]={121,504932,504979}
G[25363]={121,504932,504979}
G[25364]={121,504932,504979}
G[25365]={121,504932,504979}
G[25366]={121,504932,504979}
G[25367]={121,504932,504979}
G[25368]={121,504932,504979}
G[25369]={121,504932,504979}
G[25370]={606,504870}
G[25371]={610,504869,504982}
G[25372]={606,504870}
G[25373]={121,504932,504979}
G[25374]={121,504932,504979}
G[25375]={121,504932,504979}
G[25377]={610,504869,504982}
G[25378]={121,504932,504979}
G[25379]={121,504932,504979}
G[25381]={606,504870}
G[25382]={606,504870}
G[25383]={121,504932,504979}
G[25385]={606,504870}
G[25386]={121,504932,504979}
G[25387]={121,504932,504979}
G[25388]={610,504869,504982}
G[25389]={610,504869,504982}
G[25390]={610,504869,504982}
G[25391]={121,504932,504979}
G[25392]={606,504870}
G[25394]={121,504932,504979}
G[25395]={40,504899}
G[25396]={121,504932,504979}
G[25397]={121,504932,504979}
G[25398]={121,504932,504979}
G[25399]={121,504932,504979}
G[25400]={121,504932,504979}
G[25401]={121,504932,504979}
G[25402]={121,504932,504979}
G[25403]={121,504932,504979}
G[25404]={606,504870}
G[25405]={610,504869,504982}
G[25406]={121,504932,504979}
G[25407]={121,504932,504979}
G[25408]={606,504870}
G[25409]={121,504932,504979}
G[25410]={121,504932,504979}
G[25411]={606,504870}
G[25412]={606,504870}
G[25420]={161,504935}
G[25421]={161,504935}
G[25422]={121,504932,504979}
G[25423]={121,504932,504979}
G[25424]={606,504870}
G[25426]={121,504932,504979}
G[25427]={121,504932,504979}
G[25428]={606,504870}
G[25429]={121,504932,504979}
G[25430]={606,504870}
G[25431]={121,504932,504979}
G[25432]={121,504932,504979}
G[25433]={121,504932,504979}
G[25434]={121,504932,504979}
G[25436]={121,504932,504979}
G[25437]={121,504932,504979}
G[25438]={121,504932,504979}
G[25439]={615,504869,504982}
G[25440]={615,504869,504982}
G[25441]={615,504869,504982}
G[25442]={615,504869,504982}
G[25447]={121,504932,504979}
G[25448]={121,504932,504979}
G[25449]={121,504932,504979}
G[25450]={121,504932,504979}
G[25451]={121,504932,504979}
G[25452]={121,504932,504979}
G[25453]={121,504932,504979}
G[25454]={121,504932,504979}
G[25456]={615,504869,504982}
G[25458]={121,504932,504979}
G[25459]={610,504869,504982}
G[25460]={606,504870}
G[25462]={606,504870}
G[25463]={121,504932,504979}
G[25464]={606,504870}
G[25465]={121,504932,504979}
G[25466]={121,504932,504979}
G[25467]={610,504869,504982}
G[25468]={121,504932,504979}
G[25469]={121,504932,504979}
G[25471]={615,504869,504982}
G[25472]={606,504870}
G[25475]={121,504932,504979}
G[25476]={121,504932,504979}
G[25477]={610,504869,504982}
G[25478]={61,504938}
G[25479]={121,504932,504979}
G[25481]={121,504932,504979}
G[25486]={121,504932,504979}
G[25487]={61,504938}
G[25488]={61,504938}
G[25489]={61,504938}
G[25490]={606,504870}
G[25491]={606,504870}
G[25492]={606,504870}
G[25493]={606,504870}
G[25494]={606,504870}
G[25496]={606,504870}
G[25499]={606,504870}
G[25502]={606,504870}
G[25503]={610,504869,504982}
G[25504]={61,504938}
G[25505]={61,504938}
G[25507]={606,504870}
G[25509]={606,504870}
G[25510]={606,504870}
G[25513]={161,504935}
G[25514]={606,504870}
G[25515]={61,504938}
G[25516]={61,504938}
G[25517]={61,504938}
G[25518]={61,504938}
G[25519]={606,504870}
G[25520]={606,504870}
G[25521]={161,504935}
G[25522]={161,504935}
G[25523]={606,504870}
G[25524]={61,504938}
G[25525]={606,504870}
G[25526]={61,504938}
G[25531]={606,504870}
G[25534]={161,504935}
G[25535]={615,504869,504982}
G[25536]={615,504869,504982}
G[25537]={615,504869,504982}
G[25538]={615,504869,504982}
G[25539]={615,504869,504982}
G[25540]={615,504869,504982}
G[25541]={161,504935}
G[25542]={61,504938}
G[25543]={61,504938}
G[25544]={606,504870}
G[25545]={610,504869,504982}
G[25546]={610,504869,504982}
G[25547]={610,504869,504982}
G[25548]={606,504870}
G[25552]={606,504870}
G[25554]={606,504870}
G[25555]={606,504870}
G[25556]={504956}
G[25558]={610,504869,504982}
G[25559]={161,504935}
G[25560]={606,504870}
G[25561]={61,504938}
G[25562]={61,504938}
G[25564]={610,504869,504982}
G[25565]={161,504935}
G[25566]={161,504935}
G[25574]={606,504870}
G[25575]={606,504870}
G[25576]={606,504870}
G[25577]={606,504870}
G[25578]={606,504870}
G[25579]={615,504869,504982}
G[25580]={615,504869,504982}
G[25581]={615,504869,504982}
G[25582]={615,504869,504982}
G[25583]={615,504869,504982}
G[25584]={606,504870}
G[25585]={61,504938}
G[25586]={61,504938}
G[25587]={610,504869,504982}
G[25588]={61,504938}
G[25589]={61,504938}
G[25590]={61,504938}
G[25591]={161,504935}
G[25592]={615,504869,504982}
G[25593]={615,504869,504982}
G[25594]={615,504869,504982}
G[25595]={615,504869,504982}
G[25596]={61,504938}
G[25597]={606,504870}
G[25598]={610,504869,504982}
G[25599]={606,504870}
G[25600]={606,504870}
G[25601]={606,504870}
G[25602]={610,504869,504982}
G[25607]={43,504925}
G[25608]={606,504870}
G[25609]={61,504938}
G[25610]={61,504938}
G[25611]={606,504870}
G[25612]={606,504870}
G[25613]={81,504936,504980}
G[25614]={81,504936,504980}
G[25615]={81,504936,504980}
G[25616]={81,504936,504980}
G[25617]={606,504870}
G[25618]={606,504870}
G[25619]={615,504869,504982}
G[25620]={615,504869,504982}
G[25621]={81,504936,504980}
G[25622]={81,504936,504980}
G[25623]={606,504870}
G[25624]={606,504870}
G[25626]={615,504869,504982}
G[25627]={61,504938}
G[25628]={61,504938}
G[25629]={615,504869,504982}
G[25630]={606,504870}
G[25637]={615,504869,504982}
G[25638]={610,504869,504982}
G[25640]={81,504936,504980}
G[25641]={121,504932,504979}
G[25642]={81,504936,504980}
G[25643]={121,504932,504979}
G[25644]={606,504870}
G[25645]={121,504932,504979}
G[25646]={81,504936,504980}
G[25647]={81,504936,504980}
G[25649]={81,504936,504980}
G[25650]={81,504936,504980}
G[25651]={610,504869,504982}
G[25652]={81,504936,504980}
G[25653]={606,504870}
G[25654]={121,504932,504979}
G[25655]={606,504870}
G[25656]={606,504870}
G[25657]={610,504869,504982}
G[25658]={615,504869,504982}
G[25659]={615,504869,504982}
G[25660]={61,504938}
G[25661]={61,504938}
G[25662]={81,504936,504980}
G[25663]={606,504870}
G[25664]={606,504870}
G[25665]={606,504870}
G[25669]={81,504936,504980}
G[25670]={610,504869,504982}
G[25671]={81,504936,504980}
G[25672]={61,504938}
G[25673]={81,504936,504980}
G[25674]={19,504909}
G[25675]={19,504909}
G[25676]={19,504909}
G[25677]={19,504909}
G[25678]={19,504909}
G[25679]={19,504909}
G[25680]={19,504909}
G[25681]={19,504909}
G[25682]={19,504909}
G[25683]={19,504909}
G[25684]={19,504909}
G[25685]={19,504909}
G[25686]={19,504909}
G[25687]={19,504909}
G[25688]={19,504909}
G[25689]={19,504909}
G[25690]={19,504909}
G[25691]={19,504909}
G[25692]={19,504909}
G[25693]={19,504909}
G[25694]={19,504909}
G[25695]={19,504909}
G[25696]={19,504909}
G[25697]={19,504909}
G[25698]={19,504909}
G[25699]={19,504909}
G[25700]={19,504909}
G[25701]={19,504909}
G[25702]={19,504909}
G[25703]={19,504909}
G[25704]={61,504938}
G[25705]={19,504909}
G[25706]={19,504909}
G[25708]={19,504909}
G[25709]={19,504909}
G[25710]={19,504909}
G[25711]={19,504909}
G[25712]={19,504909}
G[25713]={19,504909}
G[25714]={19,504909}
G[25715]={19,504909}
G[25716]={19,504909}
G[25717]={19,504909}
G[25718]={19,504909}
G[25719]={19,504909}
G[25720]={19,504909}
G[25721]={40,504899}
G[25722]={40,504899}
G[25723]={40,504899}
G[25725]={40,504899}
G[25726]={40,504899}
G[25727]={40,504899}
G[25728]={81,504936,504980}
G[25729]={81,504936,504980}
G[25730]={81,504936,504980}
G[25731]={606,504870}
G[25732]={610,504869,504982}
G[25733]={40,504899}
G[25734]={40,504899}
G[25735]={40,504899}
G[25736]={40,504899}
G[25739]={81,504936,504980}
G[25740]={606,504870}
G[25741]={81,504936,504980}
G[25743]={610,504869,504982}
G[25744]={61,504938}
G[25745]={61,504938}
G[25746]={606,504870}
G[25747]={615,504869,504982}
G[25748]={615,504869,504982}
G[25749]={615,504869,504982}
G[25751]={615,504869,504982}
G[25752]={615,504869,504982}
G[25753]={615,504869,504982}
G[25754]={615,504869,504982}
G[25755]={615,504869,504982}
G[25756]={61,504938}
G[25757]={61,504938}
G[25758]={606,504870}
G[25760]={615,504869,504982}
G[25761]={606,504870}
G[25762]={61,504938}
G[25763]={606,504870}
G[25764]={606,504870}
G[25765]={81,504936,504980}
G[25766]={81,504936,504980}
G[25767]={81,504936,504980}
G[25768]={81,504936,504980}
G[25769]={81,504936,504980}
G[25770]={40,504899}
G[25771]={19,504909}
G[25774]={61,504938}
G[25775]={61,504938}
G[25776]={606,504870}
G[25777]={40,504899}
G[25778]={61,504938}
G[25779]={61,504938}
G[25780]={40,504899}
G[25790]={61,504938}
G[25791]={61,504938}
G[25793]={81,504936,504980}
G[25794]={610,504869,504982}
G[25795]={606,504870}
G[25796]={61,504938}
G[25797]={61,504938}
G[25798]={61,504938}
G[25799]={61,504938}
G[25800]={40,504899}
G[25801]={40,504899}
G[25802]={40,504899}
G[25803]={40,504899}
G[25804]={40,504899}
G[25805]={40,504899}
G[25806]={81,504936,504980}
G[25807]={606,504870}
G[25808]={81,504936,504980}
G[25809]={81,504936,504980}
G[25810]={606,504870}
G[25811]={81,504936,504980}
G[25812]={610,504869,504982}
G[25813]={61,504938}
G[25814]={61,504938}
G[25815]={40,504899}
G[25816]={40,504899}
G[25817]={40,504899}
G[25818]={40,504899}
G[25819]={40,504899}
G[25820]={40,504899}
G[25821]={81,504936,504980}
G[25822]={81,504936,504980}
G[25823]={81,504936,504980}
G[25824]={610,504869,504982}
G[25825]={61,504938}
G[25826]={61,504938}
G[25830]={606,504870}
G[25832]={606,504870}
G[25834]={81,504936,504980}
G[25835]={61,504938}
G[25836]={61,504938}
G[25837]={81,504936,504980}
G[25842]={606,504870}
G[25843]={606,504870}
G[25844]={81,504936,504980}
G[25845]={81,504936,504980}
G[25846]={81,504936,504980}
G[25847]={81,504936,504980}
G[25848]={81,504936,504980}
G[25849]={40,504899}
G[25850]={40,504899}
G[25851]={81,504936,504980}
G[25852]={81,504936,504980}
G[25853]={40,504899}
G[25854]={40,504899}
G[25855]={40,504899}
G[25856]={40,504899}
G[25857]={40,504899}
G[25858]={615,504869,504982}
G[25859]={615,504869,504982}
G[25860]={615,504869,504982}
G[25861]={615,504869,504982}
G[25862]={615,504869,504982}
G[25863]={615,504869,504982}
G[25864]={40,504899}
G[25865]={40,504899}
G[25866]={40,504899}
G[25867]={40,504899}
G[25868]={40,504899}
G[25869]={61,504938}
G[25870]={61,504938}
G[25871]={61,504938}
G[25872]={61,504938}
G[25873]={61,504938}
G[25874]={61,504938}
G[25875]={81,504936,504980}
G[25876]={81,504936,504980}
G[25877]={81,504936,504980}
G[25878]={81,504936,504980}
G[25879]={81,504936,504980}
G[25880]={81,504936,504980}
G[25881]={606,504870}
G[25883]={610,504869,504982}
G[25884]={610,504869,504982}
G[25885]={610,504869,504982}
G[25886]={606,504870}
G[25887]={610,504869,504982}
G[25888]={610,504869,504982}
G[25889]={81,504936,504980}
G[25890]={615,504869,504982}
G[25891]={81,504936,504980}
G[25892]={615,504869,504982}
G[25893]={615,504869,504982}
G[25894]={615,504869,504982}
G[25895]={615,504869,504982}
G[25896]={615,504869,504982}
G[25897]={615,504869,504982}
G[25898]={615,504869,504982}
G[25899]={606,504870}
G[25900]={615,504869,504982}
G[25901]={606,504870}
G[25904]={606,504870}
G[25906]={606,504870}
G[25907]={615,504869,504982}
G[25908]={615,504869,504982}
G[25909]={615,504869,504982}
G[25910]={606,504870}
G[25911]={615,504869,504982}
G[25912]={81,504936,504980}
G[25913]={81,504936,504980}
G[25914]={81,504936,504980}
G[25915]={606,504870}
G[25916]={615,504869,504982}
G[25917]={615,504869,504982}
G[25918]={615,504869,504982}
G[25919]={615,504869,504982}
G[25920]={615,504869,504982}
G[25921]={615,504869,504982}
G[25922]={615,504869,504982}
G[25923]={606,504870}
G[25925]={81,504936,504980}
G[25926]={40,504899}
G[25927]={40,504899}
G[25928]={606,504870}
G[25930]={81,504936,504980}
G[25931]={81,504936,504980}
G[25934]={81,504936,504980}
G[25935]={81,504936,504980}
G[25936]={610,504869,504982}
G[25938]={81,504936,504980}
G[25939]={40,504899}
G[25940]={606,504870}
G[25941]={610,504869,504982}
G[25942]={610,504869,504982}
G[25943]={610,504869,504982}
G[25944]={610,504869,504982}
G[25945]={81,504936,504980}
G[25946]={610,504869,504982}
G[25947]={610,504869,504982}
G[25948]={610,504869,504982}
G[25949]={610,504869,504982}
G[25950]={614,504869,504982}
G[25951]={615,504869,504982,505452}
G[25952]={615,504869,504982}
G[25953]={615,504869,504982}
G[25954]={615,504869,504982}
G[25955]={615,504869,504982}
G[25956]={615,504869,504982}
G[25957]={615,504869,504982}
G[25958]={615,504869,504982}
G[25959]={615,504869,504982}
G[25960]={615,504869,504982}
G[25962]={615,504869,504982}
G[25963]={615,504869,504982}
G[25964]={615,504869,504982}
G[25965]={615,504869,504982}
G[25966]={615,504869,504982}
G[25967]={615,504869,504982}
G[25968]={615,504869,504982}
G[25969]={615,504869,504982}
G[25970]={615,504869,504982}
G[25971]={615,504869,504982}
G[25972]={615,504869,504982}
G[25973]={615,504869,504982}
G[25974]={614,504869,504982}
G[25975]={614,504869,504982}
G[25976]={614,504869,504982}
G[25977]={614,504869,504982}
G[25980]={614,504869,504982}
G[25981]={614,504869,504982}
G[25982]={614,504869,504982}
G[25983]={614,504869,504982}
G[25984]={614,504869,504982}
G[25985]={606,504870}
G[25987]={614,504869,504982}
G[25988]={614,504869,504982}
G[25989]={615,504869,504982}
G[25990]={615,504869,504982}
G[25991]={615,504869,504982}
G[25992]={615,504869,504982}
G[25993]={615,504869,504982}
G[25994]={615,504869,504982}
G[25995]={615,504869,504982}
G[25996]={615,504869,504982}
G[25999]={81,504936,504980}
G[26000]={610,504869,504982}
G[26001]={81,504936,504980}
G[26002]={81,504936,504980}
G[26003]={81,504936,504980}
G[26004]={81,504936,504980}
G[26005]={615,504869,504982}
G[26006]={615,504869,504982}
G[26007]={610,504869,504982}
G[26008]={610,504869,504982}
G[26009]={81,504936,504980}
G[26010]={81,504936,504980}
G[26011]={81,504936,504980}
G[26014]={614,504869,504982}
G[26015]={614,504869,504982}
G[26016]={81,504936,504980}
G[26017]={614,504869,504982}
G[26018]={614,504869,504982}
G[26019]={614,504869,504982}
G[26020]={81,504936,504980}
G[26021]={614,504869,504982}
G[26022]={16,504896}
G[26023]={16,504896}
G[26024]={16,504896}
G[26025]={16,504896}
G[26026]={81,504936,504980}
G[26027]={16,504896}
G[26028]={81,504936,504980}
G[26029]={16,504896}
G[26030]={16,504896}
G[26031]={16,504896}
G[26032]={16,504896}
G[26033]={16,504896}
G[26035]={16,504896}
G[26036]={16,504896}
G[26037]={16,504896}
G[26038]={16,504896}
G[26039]={16,504896}
G[26040]={610,504869,504982}
G[26041]={16,504896}
G[26042]={16,504896}
G[26043]={81,504936,504980}
G[26044]={81,504936,504980}
G[26045]={81,504936,504980}
G[26046]={81,504936,504980}
G[26047]={81,504936,504980}
G[26048]={81,504936,504980}
G[26049]={16,504896}
G[26050]={16,504896}
G[26051]={16,504896}
G[26052]={16,504896}
G[26053]={16,504896}
G[26055]={16,504896}
G[26056]={614,504869,504982}
G[26057]={614,504869,504982}
G[26058]={81,504936,504980}
G[26059]={81,504936,504980}
G[26060]={81,504936,504980}
G[26061]={81,504936,504980}
G[26062]={81,504936,504980}
G[26063]={81,504936,504980}
G[26064]={81,504936,504980}
G[26065]={614,504869,504982}
G[26066]={81,504936,504980}
G[26067]={81,504936,504980}
G[26068]={81,504936,504980}
G[26069]={81,504936,504980}
G[26070]={614,504869,504982}
G[26071]={614,504869,504982}
G[26072]={614,504869,504982}
G[26073]={81,504936,504980}
G[26074]={81,504936,504980}
G[26075]={81,504936,504980}
G[26076]={81,504936,504980}
G[26077]={81,504936,504980}
G[26079]={16,504896}
G[26080]={614,504869,504982}
G[26081]={16,504896}
G[26082]={81,504936,504980}
G[26083]={16,504896}
G[26084]={16,504896}
G[26086]={614,504869,504982}
G[26087]={614,504869,504982}
G[26088]={614,504869,504982}
G[26089]={614,504869,504982}
G[26090]={614,504869,504982}
G[26091]={614,504869,504982}
G[26092]={614,504869,504982}
G[26093]={16,504896}
G[26095]={16,504896}
G[26096]={614,504869,504982}
G[26097]={81,504936,504980}
G[26098]={81,504936,504980}
G[26099]={81,504936,504980}
G[26100]={81,504936,504980}
G[26101]={81,504936,504980}
G[26103]={614,504869,504982}
G[26105]={614,504869,504982}
G[26106]={614,504869,504982}
G[26107]={16,504896}
G[26108]={16,504896}
G[26110]={16,504896}
G[26111]={614,504869,504982}
G[26113]={16,504896}
G[26114]={16,504896}
G[26115]={81,504936,504980}
G[26116]={16,504896}
G[26117]={16,504896}
G[26120]={40,504899}
G[26122]={614,504869,504982}
G[26125]={614,504869,504982}
G[26126]={614,504869,504982}
G[26127]={40,504899}
G[26128]={40,504899}
G[26130]={614,504869,504982}
G[26132]={614,504869,504982}
G[26133]={614,504869,504982}
G[26134]={81,504936,504980}
G[26135]={615,504869,504982}
G[26137]={40,504899}
G[26139]={16,504896}
G[26140]={614,504869,504982}
G[26141]={614,504869,504982}
G[26142]={614,504869,504982}
G[26143]={614,504869,504982}
G[26145]={35,504899}
G[26146]={35,504899}
G[26147]={35,504899}
G[26148]={35,504899}
G[26153]={505474}
G[26157]={19,504909}
G[26158]={19,504909}
G[26159]={19,504909}
G[26160]={19,504909}
G[26161]={19,504909}
G[26162]={19,504909}
G[26163]={19,504909}
G[26164]={19,504909}
G[26165]={19,504909}
G[26166]={19,504909}
G[26167]={19,504909}
G[26168]={19,504909}
G[26169]={19,504909}
G[26170]={19,504909}
G[26171]={19,504909}
G[26172]={19,504909}
G[26173]={19,504909}
G[26174]={19,504909}
G[26175]={19,504909}
G[26176]={35,504899}
G[26177]={505474}
G[26182]={614,504869,504982}
G[26183]={505474}
G[26184]={19,504909}
G[26185]={19,504909}
G[26186]={19,504909}
G[26187]={19,504909}
G[26189]={40,504899}
G[26190]={505474}
G[26191]={615,504869,504982}
G[26192]={505474}
G[26193]={614,504869,504982,505318}
G[26194]={614,504869,504982,505319}
G[26195]={40,504899}
G[26196]={40,504899}
G[26209]={39,504903}
G[26210]={26,504897}
G[26211]={26,504897}
G[26212]={26,504897}
G[26213]={39,504903}
G[26214]={39,504903}
G[26215]={39,504903}
G[26219]={614,504869,504982}
G[26220]={505475}
G[26221]={614,504869,504982}
G[26223]={26,504897}
G[26224]={26,504897}
G[26225]={26,504897}
G[26226]={505475}
G[26227]={505475}
G[26228]={39,504903}
G[26229]={39,504903}
G[26230]={39,504903}
G[26232]={39,504903}
G[26233]={505475}
G[26234]={505475}
G[26235]={505475}
G[26236]={39,504903}
G[26237]={39,504903}
G[26238]={26,504897}
G[26240]={26,504897}
G[26241]={39,504903}
G[26244]={640,504871}
G[26245]={640,504871}
G[26246]={640,504871}
G[26247]={640,504871}
G[26248]={640,504871}
G[26249]={640,504871}
G[26250]={640,504871}
G[26251]={640,504871}
G[26252]={39,504903}
G[26254]={640,504871}
G[26255]={640,504871}
G[26256]={640,504871}
G[26257]={39,504903}
G[26258]={640,504871}
G[26259]={640,504871}
G[26260]={640,504871}
G[26261]={640,504871}
G[26263]={26,504897}
G[26266]={39,504903}
G[26267]={26,504897}
G[26268]={26,504897}
G[26269]={37,504906}
G[26270]={39,504903}
G[26271]={39,504903}
G[26278]={37,504906}
G[26279]={37,504906}
G[26280]={37,504906}
G[26281]={37,504906}
G[26283]={26,504897}
G[26286]={39,504903}
G[26287]={39,504903}
G[26288]={39,504903}
G[26289]={39,504903}
G[26290]={39,504903}
G[26291]={39,504903}
G[26292]={39,504903}
G[26295]={39,504903}
G[26296]={39,504903}
G[26297]={39,504903}
G[26298]={37,504906}
G[26299]={37,504906}
G[26300]={37,504906}
G[26301]={37,504906}
G[26302]={37,504906}
G[26303]={37,504906}
G[26304]={37,504906}
G[26305]={37,504906}
G[26306]={26,504897}
G[26307]={26,504897}
G[26308]={26,504897}
G[26309]={26,504897}
G[26310]={26,504897}
G[26312]={640,504871}
G[26313]={640,504871}
G[26314]={640,504871}
G[26315]={640,504871}
G[26317]={37,504906}
G[26319]={39,504903}
G[26320]={39,504903}
G[26321]={37,504906}
G[26322]={39,504903}
G[26323]={37,504906}
G[26325]={37,504906}
G[26326]={640,504871}
G[26327]={40,504899}
G[26328]={640,504871}
G[26330]={37,504906}
G[26332]={37,504906}
G[26334]={37,504906}
G[26335]={181,504927}
G[26336]={16,504896}
G[26337]={181,504927}
G[26338]={37,504906}
G[26340]={37,504906}
G[26341]={16,504896}
G[26343]={37,504906}
G[26344]={37,504906}
G[26345]={37,504906}
G[26346]={16,504896}
G[26347]={39,504903}
G[26348]={39,504903}
G[26349]={39,504903}
G[26350]={37,504906}
G[26351]={37,504906}
G[26352]={37,504906}
G[26353]={39,504903}
G[26354]={39,504903}
G[26355]={39,504903}
G[26356]={39,504903}
G[26357]={26,504897}
G[26359]={37,504906}
G[26360]={37,504906}
G[26361]={181,504927}
G[26362]={37,504906}
G[26363]={26,504897}
G[26365]={36,504902}
G[26366]={26,504897}
G[26367]={26,504897}
G[26368]={26,504897}
G[26369]={26,504897}
G[26370]={39,504903}
G[26371]={39,504903}
G[26372]={181,504927}
G[26374]={181,504927}
G[26375]={640,504871}
G[26376]={640,504871}
G[26377]={640,504871}
G[26381]={26,504897}
G[26382]={26,504897}
G[26384]={26,504897}
G[26386]={37,504906}
G[26387]={26,504897}
G[26388]={181,504927}
G[26399]={37,504906}
G[26400]={37,504906}
G[26401]={121,504932,504979}
G[26402]={121,504932,504979}
G[26403]={37,504906}
G[26404]={37,504906}
G[26405]={37,504906}
G[26406]={26,504897}
G[26407]={37,504906}
G[26408]={43,504925}
G[26409]={640,504871}
G[26410]={640,504871}
G[26411]={640,504871}
G[26413]={640,504871}
G[26414]={505476}
G[26416]={37,504906}
G[26417]={37,504906}
G[26418]={26,504897}
G[26419]={26,504897}
G[26420]={505476}
G[26426]={640,504871}
G[26427]={640,504871}
G[26428]={16,504896}
G[26429]={16,504896}
G[26430]={26,504897}
G[26432]={26,504897}
G[26433]={673,504905}
G[26434]={673,504905}
G[26435]={673,504905}
G[26436]={640,504871}
G[26437]={640,504871}
G[26438]={640,504871}
G[26439]={640,504871}
G[26440]={640,504871}
G[26441]={640,504871}
G[26442]={505476}
G[26443]={43,504925}
G[26444]={43,504925}
G[26445]={43,504925}
G[26446]={43,504925}
G[26447]={43,504925,504976}
G[26448]={43,504925,504976}
G[26449]={43,504925,504976}
G[26450]={673,504905}
G[26451]={673,504905}
G[26452]={673,504905}
G[26453]={43,504925}
G[26454]={43,504925}
G[26455]={43,504925}
G[26456]={43,504925}
G[26457]={43,504925}
G[26462]={26,504897}
G[26463]={43,504925}
G[26464]={43,504925}
G[26465]={43,504925}
G[26466]={43,504925}
G[26467]={43,504925}
G[26468]={43,504925}
G[26469]={43,504925}
G[26470]={43,504925}
G[26472]={43,504925}
G[26473]={43,504925}
G[26474]={43,504925}
G[26475]={43,504925}
G[26476]={43,504925}
G[26477]={43,504925}
G[26478]={43,504925}
G[26479]={43,504925}
G[26480]={43,504925}
G[26481]={43,504925}
G[26482]={43,504925}
G[26483]={26,504897}
G[26484]={640,504871}
G[26485]={26,504897}
G[26486]={26,504897}
G[26487]={673,504905}
G[26488]={505476}
G[26489]={673,504905}
G[26490]={26,504897}
G[26491]={26,504897}
G[26492]={26,504897}
G[26493]={673,504905}
G[26494]={673,504905}
G[26495]={673,504905}
G[26496]={26,504897}
G[26497]={26,504897}
G[26498]={26,504897}
G[26499]={640,504871}
G[26500]={640,504871}
G[26501]={640,504871}
G[26502]={640,504871}
G[26503]={36,504902}
G[26504]={36,504902}
G[26505]={36,504902}
G[26506]={36,504902}
G[26507]={640,504871}
G[26508]={36,504902}
G[26509]={36,504902}
G[26510]={36,504902}
G[26511]={36,504902}
G[26512]={36,504902}
G[26513]={36,504902}
G[26514]={36,504902}
G[26515]={26,504897}
G[26516]={26,504897}
G[26517]={26,504897}
G[26518]={26,504897}
G[26519]={36,504902}
G[26520]={36,504902}
G[26521]={26,504897}
G[26523]={26,504897}
G[26524]={26,504897}
G[26525]={26,504897}
G[26526]={26,504897}
G[26528]={26,504897}
G[26529]={26,504897}
G[26530]={26,504897}
G[26531]={26,504897}
G[26532]={26,504897}
G[26533]={673,504905}
G[26534]={673,504905}
G[26535]={673,504905}
G[26536]={505476}
G[26537]={640,504871}
G[26538]={700,504873,505501}
G[26539]={700,504873,505501}
G[26540]={700,504873,505501}
G[26542]={26,504897}
G[26543]={505477}
G[26544]={36,504902}
G[26545]={36,504902}
G[26546]={26,504897}
G[26547]={26,504897}
G[26548]={26,504897}
G[26549]={700,504873,505501}
G[26550]={673,504905}
G[26553]={673,504905}
G[26554]={673,504905}
G[26555]={673,504905}
G[26556]={505477}
G[26557]={505477}
G[26558]={26,504897}
G[26560]={36,504902}
G[26561]={36,504902}
G[26562]={36,504902}
G[26563]={36,504902}
G[26564]={640,504871}
G[26567]={36,504902}
G[26569]={36,504902}
G[26570]={36,504902}
G[26571]={36,504902}
G[26572]={505477}
G[26573]={36,504902}
G[26574]={121,504932,504979}
G[26575]={640,504871}
G[26576]={640,504871}
G[26577]={640,504871}
G[26578]={640,504871}
G[26579]={640,504871}
G[26580]={640,504871}
G[26581]={640,504871}
G[26582]={640,504871}
G[26583]={640,504871}
G[26584]={640,504871}
G[26585]={640,504871}
G[26586]={36,504902}
G[26587]={36,504902}
G[26588]={505477}
G[26590]={673,504905}
G[26591]={640,504871}
G[26592]={673,504905}
G[26593]={673,504905}
G[26594]={673,504905}
G[26595]={673,504905}
G[26596]={141,504929,504978}
G[26597]={673,504905}
G[26598]={673,504905}
G[26599]={673,504905}
G[26600]={673,504905}
G[26601]={673,504905}
G[26602]={673,504905}
G[26603]={673,504905}
G[26604]={673,504905}
G[26605]={673,504905}
G[26606]={673,504905}
G[26607]={36,504902}
G[26608]={700,504873,505501}
G[26609]={673,504905}
G[26610]={673,504905}
G[26611]={673,504905}
G[26612]={673,504905}
G[26613]={673,504905}
G[26614]={673,504905}
G[26616]={36,504902}
G[26617]={673,504905}
G[26618]={34,504903}
G[26619]={700,504873,505501}
G[26620]={34,504903}
G[26621]={700,504873,505501}
G[26622]={700,504873,505501}
G[26623]={34,504903}
G[26624]={673,504905}
G[26625]={640,504871}
G[26627]={34,504903}
G[26628]={16,504896}
G[26630]={673,504905}
G[26631]={673,504905}
G[26632]={640,504871}
G[26633]={673,504905}
G[26634]={673,504905}
G[26635]={673,504905}
G[26636]={36,504902}
G[26637]={36,504902}
G[26638]={36,504902}
G[26639]={36,504902}
G[26640]={36,504902}
G[26641]={26,504897}
G[26643]={26,504897}
G[26644]={673,504905}
G[26645]={34,504903}
G[26646]={36,504902}
G[26647]={673,504905}
G[26648]={673,504905}
G[26649]={673,504905}
G[26650]={673,504905}
G[26651]={36,504902}
G[26652]={34,504903}
G[26653]={34,504903}
G[26654]={34,504903}
G[26655]={34,504903}
G[26656]={640,504871}
G[26657]={640,504871}
G[26658]={640,504871}
G[26659]={640,504871}
G[26660]={34,504903}
G[26661]={34,504903}
G[26662]={673,504905}
G[26663]={673,504905}
G[26664]={673,504905}
G[26665]={673,504905}
G[26666]={34,504903}
G[26667]={34,504903}
G[26668]={36,504902}
G[26669]={34,504903}
G[26670]={34,504903}
G[26671]={34,504903}
G[26672]={34,504903}
G[26674]={34,504903}
G[26676]={34,504903}
G[26677]={34,504903}
G[26678]={673,504905}
G[26679]={673,504905}
G[26680]={34,504903}
G[26681]={34,504903}
G[26682]={141,504929,504978}
G[26683]={34,504903}
G[26684]={34,504903}
G[26685]={34,504903}
G[26686]={34,504903}
G[26687]={141,504929,504978}
G[26688]={34,504903}
G[26689]={34,504903}
G[26690]={34,504903}
G[26691]={34,504903}
G[26692]={36,504902}
G[26693]={36,504902}
G[26694]={36,504902}
G[26695]={673,504905}
G[26696]={141,504929,504978}
G[26697]={673,504905}
G[26698]={673,504905}
G[26699]={673,504905}
G[26700]={673,504905}
G[26701]={141,504929,504978}
G[26702]={141,504929,504978}
G[26703]={673,504905}
G[26707]={34,504903}
G[26708]={36,504902}
G[26709]={640,504871}
G[26713]={36,504902}
G[26714]={36,504902}
G[26717]={34,504903}
G[26719]={34,504903}
G[26720]={34,504903}
G[26721]={34,504903}
G[26722]={34,504903}
G[26723]={34,504903}
G[26724]={34,504903}
G[26725]={34,504903}
G[26726]={36,504902}
G[26727]={34,504903}
G[26728]={34,504903}
G[26729]={37,504906}
G[26730]={37,504906}
G[26731]={37,504906}
G[26732]={37,504906}
G[26733]={37,504906}
G[26734]={37,504906}
G[26735]={37,504906}
G[26736]={37,504906}
G[26737]={37,504906}
G[26738]={37,504906}
G[26739]={37,504906}
G[26740]={37,504906}
G[26742]={37,504906}
G[26743]={37,504906}
G[26744]={37,504906}
G[26745]={37,504906}
G[26746]={37,504906}
G[26747]={37,504906}
G[26748]={37,504906}
G[26749]={37,504906}
G[26750]={640,504871}
G[26751]={37,504906}
G[26752]={640,504871}
G[26753]={34,504903}
G[26754]={34,504903}
G[26755]={640,504871}
G[26760]={34,504903}
G[26761]={36,504902}
G[26762]={640,504871}
G[26763]={37,504906}
G[26765]={37,504906}
G[26766]={640,504871}
G[26768]={640,504871}
G[26769]={11,504933}
G[26770]={640,504871}
G[26771]={640,504871}
G[26772]={37,504906}
G[26773]={37,504906}
G[26774]={37,504906}
G[26775]={37,504906}
G[26776]={37,504906}
G[26777]={34,504903}
G[26778]={34,504903}
G[26779]={37,504906}
G[26780]={37,504906}
G[26781]={37,504906}
G[26782]={37,504906}
G[26783]={37,504906}
G[26784]={700,504873,505501}
G[26785]={34,504903}
G[26786]={700,504873,505501}
G[26787]={34,504903}
G[26788]={700,504873,505501}
G[26791]={640,504871}
G[26792]={640,504871}
G[26793]={34,504903}
G[26794]={34,504903}
G[26795]={34,504903}
G[26796]={34,504903}
G[26797]={34,504903}
G[26798]={700,504873,505501}
G[26805]={673,504905}
G[26808]={673,504905}
G[26809]={673,504905}
G[26812]={673,504905}
G[26813]={673,504905}
G[26814]={673,504905}
G[26815]={673,504905}
G[26816]={673,504905}
G[26817]={673,504905}
G[26818]={673,504905}
G[26819]={673,504905}
G[26820]={673,504905}
G[26821]={673,504905}
G[26822]={673,504905}
G[26823]={673,504905}
G[26824]={673,504905}
G[26825]={673,504905}
G[26826]={673,504905}
G[26827]={640,504871}
G[26828]={640,504871}
G[26829]={640,504871}
G[26831]={640,504871}
G[26832]={640,504871}
G[26833]={640,504871}
G[26834]={640,504871}
G[26835]={640,504871}
G[26836]={640,504871}
G[26838]={37,504906}
G[26842]={35,504899}
G[26843]={35,504899}
G[26844]={35,504899}
G[26845]={35,504899}
G[26846]={35,504899}
G[26857]={640,504871}
G[26860]={35,504899}
G[26861]={640,504871}
G[26863]={35,504899}
G[26864]={35,504899}
G[26865]={504956}
G[26866]={504956}
G[26868]={35,504899}
G[26869]={640,504871}
G[26871]={640,504871}
G[26875]={640,504871}
G[26876]={640,504871}
G[26878]={504956}
G[26886]={161,504935}
G[26887]={161,504935}
G[26889]={161,504935}
G[26890]={43,504925,504976}
G[26894]={504956}
G[26895]={161,504935}
G[26896]={161,504935}
G[26897]={504956}
G[26898]={504956}
G[26906]={504956}
G[26908]={504956}
G[26909]={16,504896}
G[26911]={16,504896}
G[26912]={16,504896}
G[26920]={22,504893}
G[26921]={22,504893}
G[26922]={22,504893}
G[26923]={22,504893}
G[26924]={22,504893}
G[26925]={22,504893}
G[26926]={22,504893}
G[26927]={35,504899}
G[26928]={35,504899}
G[26929]={35,504899}
G[26930]={22,504893}
G[26931]={22,504893}
G[26932]={35,504899}
G[26933]={22,504893}
G[26934]={22,504893}
G[26935]={22,504893}
G[26936]={22,504893}
G[26937]={22,504893}
G[26938]={22,504893}
G[26943]={504956}
G[26944]={504956}
G[26950]={504956}
G[26952]={22,504893}
G[26953]={22,504893}
G[26954]={22,504893}
G[26955]={22,504893}
G[26956]={22,504893}
G[26957]={22,504893}
G[26961]={35,504899}
G[26965]={21,504894}
G[26971]={640,504871}
G[26972]={504956}
G[26978]={22,504893}
G[26979]={22,504893}
G[26980]={40,504899}
G[26981]={40,504899}
G[26982]={504956}
G[26986]={504956}
G[26989]={21,504894}
G[26992]={21,504894}
G[26995]={21,504894}
G[26998]={21,504894}
G[26999]={22,504893}
G[27000]={22,504893}
G[27001]={22,504893}
G[27002]={22,504893}
G[27004]={640,504871}
G[27005]={640,504871}
G[27006]={640,504871}
G[27007]={640,504871}
G[27008]={640,504871}
G[27010]={640,504871}
G[27011]={22,504893}
G[27012]={22,504893}
G[27013]={22,504893}
G[27016]={35,504899}
G[27017]={22,504893}
G[27025]={35,504899}
G[27026]={35,504899}
G[27028]={35,504899}
G[27030]={35,504899}
G[27031]={35,504899}
G[27032]={35,504899}
G[27033]={35,504899}
G[27034]={35,504899}
G[27035]={35,504899}
G[27036]={35,504899}
G[27037]={35,504899}
G[27039]={21,504894}
G[27042]={640,504871}
G[27043]={640,504871}
G[27045]={21,504894}
G[27053]={22,504893}
G[27054]={22,504893}
G[27055]={22,504893}
G[27056]={21,504894}
G[27057]={22,504893}
G[27058]={640,504871}
G[27059]={640,504871}
G[27061]={640,504871}
G[27062]={504956}
G[27065]={21,504894}
G[27069]={21,504894}
G[27073]={21,504894}
G[27074]={35,504899}
G[27075]={35,504899}
G[27077]={35,504899}
G[27078]={35,504899}
G[27082]={21,504894}
G[27083]={22,504893}
G[27084]={22,504893}
G[27085]={22,504893}
G[27086]={22,504893}
G[27087]={22,504893}
G[27088]={21,504894}
G[27089]={22,504893}
G[27090]={22,504893}
G[27093]={21,504894}
G[27094]={21,504894}
G[27095]={21,504894}
G[27096]={21,504894}
G[27097]={21,504894}
G[27098]={21,504894}
G[27099]={21,504894}
G[27100]={640,504871}
G[27101]={640,504871}
G[27102]={640,504871}
G[27115]={35,504899}
G[27116]={35,504899}
G[27117]={22,504893}
G[27123]={640,504871}
G[27126]={640,504871}
G[27135]={640,504871}
G[27136]={640,504871}
G[27141]={720,504872}
G[27144]={22,504893}
G[27151]={22,504893}
G[27152]={22,504893}
G[27153]={22,504893}
G[27154]={22,504893}
G[27155]={22,504893}
G[27156]={22,504893}
G[27157]={22,504893}
G[27158]={22,504893}
G[27159]={22,504893}
G[27160]={22,504893}
G[27161]={22,504893}
G[27162]={22,504893}
G[27163]={22,504893}
G[27164]={22,504893}
G[27165]={22,504893}
G[27166]={22,504893}
G[27167]={22,504893}
G[27168]={22,504893}
G[27169]={22,504893}
G[27170]={22,504893}
G[27171]={22,504893}
G[27172]={22,504893}
G[27173]={22,504893}
G[27174]={22,504893}
G[27175]={22,504893}
G[27176]={720,504872}
G[27177]={700,504873,505501}
G[27178]={700,504873,505501}
G[27179]={720,504872}
G[27180]={21,504894}
G[27181]={21,504894}
G[27182]={141,504929,504978}
G[27183]={141,504929,504978}
G[27184]={141,504929,504978}
G[27186]={141,504929,504978}
G[27188]={141,504929,504978}
G[27189]={141,504929,504978}
G[27190]={141,504929,504978}
G[27191]={141,504929,504978}
G[27193]={21,504894}
G[27194]={21,504894}
G[27195]={21,504894}
G[27196]={720,504872}
G[27197]={22,504893}
G[27198]={22,504893}
G[27199]={22,504893}
G[27200]={700,504873,505501}
G[27201]={22,504893}
G[27202]={22,504893}
G[27204]={22,504893}
G[27205]={22,504893}
G[27206]={22,504893}
G[27210]={141,504929,504978}
G[27211]={141,504929,504978}
G[27212]={141,504929,504978}
G[27213]={141,504929,504978}
G[27214]={141,504929,504978}
G[27215]={141,504929,504978}
G[27216]={141,504929,504978}
G[27217]={141,504929,504978}
G[27218]={141,504929,504978}
G[27219]={141,504929,504978}
G[27220]={141,504929,504978}
G[27221]={141,504929,504978}
G[27222]={141,504929,504978}
G[27226]={21,504894}
G[27229]={141,504929,504978}
G[27231]={21,504894}
G[27232]={21,504894}
G[27233]={22,504893}
G[27234]={141,504929,504978}
G[27235]={141,504929,504978}
G[27236]={141,504929,504978}
G[27237]={141,504929,504978}
G[27238]={141,504929,504978}
G[27239]={141,504929,504978}
G[27240]={141,504929,504978}
G[27241]={141,504929,504978}
G[27242]={141,504929,504978}
G[27243]={141,504929,504978}
G[27244]={141,504929,504978}
G[27245]={141,504929,504978}
G[27246]={141,504929,504978}
G[27247]={141,504929,504978}
G[27248]={141,504929,504978}
G[27249]={141,504929,504978}
G[27251]={141,504929,504978}
G[27252]={141,504929,504978}
G[27253]={141,504929,504978}
G[27254]={141,504929,504978}
G[27255]={141,504929,504978}
G[27256]={141,504929,504978}
G[27257]={141,504929,504978}
G[27258]={141,504929,504978}
G[27259]={141,504929,504978}
G[27260]={141,504929,504978}
G[27261]={141,504929,504978}
G[27262]={141,504929,504978}
G[27263]={141,504929,504978}
G[27264]={141,504929,504978}
G[27275]={61,504938}
G[27276]={61,504938}
G[27284]={141,504929,504978}
G[27285]={141,504929,504978}
G[27286]={141,504929,504978}
G[27287]={141,504929,504978}
G[27288]={141,504929,504978}
G[27290]={21,504894}
G[27291]={141,504929,504978}
G[27292]={141,504929,504978}
G[27293]={141,504929,504978}
G[27294]={141,504929,504978}
G[27295]={141,504929,504978}
G[27296]={141,504929,504978}
G[27297]={141,504929,504978}
G[27299]={700,504873,505501}
G[27300]={700,504873,505501}
G[27301]={700,504873,505501}
G[27302]={700,504873,505501}
G[27303]={700,504873,505501}
G[27306]={141,504929,504978}
G[27310]={61,504938}
G[27311]={61,504938}
G[27312]={61,504938}
G[27313]={61,504938}
G[27314]={61,504938}
G[27315]={61,504938}
G[27316]={61,504938}
G[27317]={61,504938}
G[27318]={61,504938}
G[27319]={61,504938}
G[27320]={61,504938}
G[27321]={61,504938}
G[27322]={21,504894}
G[27323]={61,504938}
G[27324]={61,504938}
G[27325]={61,504938}
G[27326]={61,504938}
G[27327]={61,504938}
G[27328]={61,504938}
G[27329]={61,504938}
G[27330]={61,504938}
G[27333]={21,504894}
G[27336]={141,504929,504978}
G[27338]={700,504873,505501}
G[27339]={141,504929,504978}
G[27340]={141,504929,504978}
G[27341]={700,504873,505501}
G[27342]={21,504894}
G[27345]={21,504894}
G[27346]={141,504929,504978}
G[27347]={141,504929,504978}
G[27348]={141,504929,504978}
G[27349]={21,504894}
G[27350]={21,504894}
G[27357]={61,504938}
G[27358]={61,504938}
G[27360]={21,504894}
G[27364]={21,504894}
G[27366]={700,504873,505501}
G[27367]={23,504892}
G[27368]={23,504892}
G[27369]={23,504892}
G[27370]={23,504892}
G[27371]={23,504892}
G[27372]={23,504892}
G[27374]={700,504873,505501}
G[27375]={700,504873,505501}
G[27376]={700,504873,505501}
G[27377]={700,504873,505501}
G[27378]={700,504873,505501}
G[27379]={700,504873,505501}
G[27380]={700,504873,505501}
G[27381]={23,504892}
G[27382]={23,504892}
G[27383]={23,504892}
G[27384]={23,504892}
G[27385]={23,504892}
G[27386]={23,504892}
G[27387]={23,504892}
G[27388]={23,504892}
G[27389]={23,504892}
G[27390]={23,504892}
G[27391]={23,504892}
G[27392]={23,504892}
G[27393]={615,504869,504982}
G[27394]={615,504869,504982}
G[27401]={21,504894}
G[27405]={21,504894}
G[27406]={21,504894}
G[27407]={141,504929,504978}
G[27408]={141,504929,504978}
G[27409]={141,504929,504978}
G[27410]={141,504929,504978}
G[27411]={141,504929,504978}
G[27412]={141,504929,504978}
G[27413]={141,504929,504978}
G[27414]={141,504929,504978}
G[27415]={141,504929,504978}
G[27416]={141,504929,504978}
G[27417]={141,504929,504978}
G[27418]={141,504929,504978}
G[27420]={23,504892}
G[27421]={23,504892}
G[27422]={504956}
G[27423]={21,504894}
G[27424]={141,504929,504978}
G[27425]={141,504929,504978}
G[27426]={141,504929,504978}
G[27427]={141,504929,504978}
G[27428]={141,504929,504978}
G[27429]={141,504929,504978}
G[27430]={141,504929,504978}
G[27431]={720,504872}
G[27432]={23,504892}
G[27433]={700,504873,505501}
G[27438]={21,504894}
G[27446]={161,504935}
G[27447]={161,504935}
G[27448]={23,504892}
G[27449]={23,504892}
G[27450]={23,504892}
G[27451]={23,504892}
G[27452]={23,504892}
G[27453]={23,504892}
G[27454]={23,504892}
G[27455]={23,504892}
G[27456]={23,504892}
G[27457]={23,504892}
G[27458]={23,504892}
G[27459]={23,504892}
G[27460]={23,504892}
G[27461]={23,504892}
G[27462]={23,504892}
G[27463]={23,504892}
G[27464]={23,504892}
G[27465]={23,504892}
G[27466]={23,504892}
G[27467]={23,504892}
G[27468]={700,504873,505501}
G[27470]={504956}
G[27472]={21,504894}
G[27474]={21,504894}
G[27475]={21,504894}
G[27476]={21,504894}
G[27477]={23,504892}
G[27479]={23,504892}
G[27480]={24,504895}
G[27481]={23,504892}
G[27485]={700,504873,505501}
G[27486]={700,504873,505501}
G[27487]={23,504892}
G[27488]={23,504892}
G[27489]={23,504892}
G[27490]={700,504873,505501}
G[27491]={700,504873,505501}
G[27492]={700,504873,505501}
G[27493]={700,504873,505501}
G[27496]={700,504873,505501}
G[27497]={700,504873,505501}
G[27500]={700,504873,505501}
G[27501]={700,504873,505501}
G[27504]={700,504873,505501}
G[27505]={700,504873,505501}
G[27506]={700,504873,505501}
G[27507]={700,504873,505501}
G[27508]={700,504873,505501}
G[27509]={700,504873,505501}
G[27510]={21,504894}
G[27511]={720,504872}
G[27512]={21,504894}
G[27513]={21,504894}
G[27514]={700,504873,505501}
G[27515]={700,504873,505501}
G[27516]={700,504873,505501}
G[27517]={720,504872}
G[27518]={21,504894}
G[27519]={720,504872}
G[27520]={720,504872}
G[27521]={23,504892}
G[27522]={23,504892}
G[27523]={23,504892}
G[27524]={23,504892}
G[27525]={23,504892}
G[27526]={23,504892}
G[27527]={23,504892}
G[27528]={23,504892}
G[27529]={23,504892}
G[27530]={23,504892}
G[27531]={23,504892}
G[27532]={23,504892}
G[27533]={23,504892}
G[27534]={23,504892}
G[27535]={23,504892}
G[27536]={38,504904}
G[27537]={700,504873,505501}
G[27538]={700,504873,505501}
G[27539]={23,504892}
G[27541]={720,504872}
G[27542]={21,504894}
G[27544]={23,504892}
G[27545]={700,504873,505501}
G[27547]={21,504894}
G[27548]={21,504894}
G[27549]={720,504872}
G[27550]={21,504894}
G[27551]={23,504892}
G[27555]={23,504892}
G[27558]={23,504892}
G[27560]={23,504892}
G[27562]={23,504892}
G[27564]={700,504873,505501}
G[27576]={700,504873,505501}
G[27577]={21,504894}
G[27580]={21,504894}
G[27583]={700,504873,505501}
G[27584]={700,504873,505501}
G[27586]={700,504873,505501}
G[27587]={38,504904}
G[27592]={38,504904}
G[27595]={720,504872}
G[27597]={38,504904}
G[27598]={38,504904}
G[27599]={38,504904}
G[27600]={38,504904}
G[27602]={720,504872}
G[27606]={700,504873,505501}
G[27607]={700,504873,505501}
G[27610]={700,504873,505501}
G[27611]={700,504873,505501}
G[27612]={23,504892}
G[27613]={23,504892}
G[27614]={23,504892}
G[27615]={23,504892}
G[27616]={23,504892}
G[27617]={23,504892}
G[27618]={23,504892}
G[27619]={23,504892}
G[27620]={23,504892}
G[27621]={700,504873,505501}
G[27622]={700,504873,505501}
G[27623]={720,504872}
G[27624]={720,504872}
G[27625]={26,504897}
G[27626]={26,504897}
G[27628]={720,504872}
G[27629]={720,504872}
G[27630]={720,504872}
G[27631]={720,504872}
G[27632]={720,504872}
G[27636]={700,504873,505501}
G[27640]={700,504873,505501}
G[27641]={700,504873,505501}
G[27642]={700,504873,505501}
G[27643]={700,504873,505501}
G[27644]={700,504873,505501}
G[27645]={700,504873,505501}
G[27646]={700,504873,505501}
G[27647]={700,504873,505501}
G[27648]={700,504873,505501}
G[27649]={700,504873,505501}
G[27650]={700,504873,505501}
G[27651]={700,504873,505501}
G[27652]={700,504873,505501}
G[27653]={700,504873,505501}
G[27654]={700,504873,505501}
G[27655]={700,504873,505501}
G[27656]={38,504904}
G[27657]={700,504873,505501}
G[27658]={700,504873,505501}
G[27659]={700,504873,505501}
G[27660]={700,504873,505501}
G[27661]={700,504873,505501}
G[27662]={700,504873,505501}
G[27663]={38,504904}
G[27668]={610,504869,504982}
G[27669]={720,504872}
G[27683]={23,504892}
G[27684]={23,504892}
G[27685]={610,504869,504982}
G[27687]={610,504869,504982}
G[27688]={700,504873,505501}
G[27689]={700,504873,505501}
G[27690]={700,504873,505501}
G[27691]={38,504904}
G[27692]={504956}
G[27694]={38,504904}
G[27696]={700,504873,505501}
G[27699]={610,504869,504982}
G[27701]={700,504873,505501}
G[27703]={700,504873,505501}
G[27704]={38,504904}
G[27705]={38,504904}
G[27706]={720,504872}
G[27708]={610,504869,504982}
G[27713]={17,504900}
G[27714]={17,504900}
G[27715]={17,504900}
G[27716]={615,504869,504982}
G[27717]={615,504869,504982}
G[27725]={26,504897}
G[27738]={720,504872}
G[27740]={38,504904}
G[27747]={700,504873,505501}
G[27750]={700,504873,505501}
G[27751]={700,504873,505501}
G[27752]={700,504873,505501}
G[27753]={700,504873,505501}
G[27754]={700,504873,505501}
G[27755]={720,504872}
G[27756]={504956}
G[27757]={38,504904}
G[27760]={720,504872}
G[27761]={720,504872}
G[27762]={17,504900}
G[27763]={17,504900}
G[27764]={17,504900}
G[27765]={17,504900}
G[27766]={17,504900}
G[27769]={17,504900}
G[27770]={17,504900}
G[27771]={17,504900}
G[27772]={17,504900}
G[27774]={17,504900}
G[27775]={17,504900}
G[27776]={17,504900}
G[27777]={720,504872}
G[27778]={720,504872}
G[27779]={720,504872}
G[27787]={505320}
G[27788]={505321}
G[27789]={17,504900}
G[27790]={504956}
G[27791]={17,504900}
G[27792]={17,504900}
G[27794]={17,504900}
G[27795]={38,504904}
G[27796]={17,504900}
G[27797]={17,504900}
G[27798]={700,504873,505501}
G[27803]={700,504873,505501}
G[27804]={700,504873,505501}
G[27805]={700,504873,505501}
G[27806]={700,504873,505501}
G[27807]={700,504873,505501}
G[27808]={700,504873,505501}
G[27809]={700,504873,505501}
G[27810]={700,504873,505501}
G[27811]={700,504873,505501}
G[27812]={700,504873,505501}
G[27813]={700,504873,505501}
G[27814]={700,504873,505501}
G[27815]={700,504873,505501}
G[27816]={700,504873,505501}
G[27817]={700,504873,505501}
G[27818]={38,504904}
G[27821]={38,504904}
G[27822]={38,504904}
G[27823]={17,504900}
G[27824]={17,504900}
G[27825]={17,504900}
G[27826]={17,504900}
G[27827]={17,504900}
G[27828]={17,504900}
G[27829]={17,504900}
G[27830]={17,504900}
G[27831]={17,504900}
G[27832]={17,504900}
G[27833]={17,504900}
G[27834]={17,504900}
G[27835]={17,504900}
G[27836]={720,504872}
G[27837]={720,504872}
G[27838]={720,504872}
G[27839]={720,504872}
G[27840]={38,504904}
G[27843]={38,504904}
G[27845]={38,504904}
G[27849]={38,504904}
G[27851]={38,504904}
G[27852]={38,504904}
G[27853]={38,504904}
G[27854]={38,504904}
G[27855]={38,504904}
G[27856]={38,504904}
G[27857]={38,504904}
G[27859]={17,504900}
G[27860]={38,504904}
G[27863]={700,504873,505501}
G[27864]={700,504873,505501}
G[27865]={700,504873,505501}
G[27867]={700,504873,505501}
G[27868]={700,504873,505501,504960}
G[27869]={38,504904}
G[27870]={38,504904}
G[27871]={38,504904}
G[27874]={606,504870}
G[27875]={38,504904}
G[27876]={38,504904}
G[27877]={17,504900}
G[27878]={17,504900}
G[27879]={17,504900}
G[27880]={17,504900}
G[27881]={17,504900}
G[27882]={17,504900}
G[27883]={17,504900}
G[27884]={17,504900}
G[27888]={17,504900}
G[27889]={17,504900}
G[27890]={17,504900}
G[27891]={17,504900}
G[27892]={17,504900}
G[27893]={17,504900}
G[27894]={17,504900}
G[27895]={17,504900}
G[27896]={17,504900}
G[27897]={17,504900}
G[27899]={720,504872}
G[27900]={720,504872}
G[27901]={720,504872}
G[27902]={38,504904}
G[27903]={720,504872}
G[27904]={38,504904}
G[27905]={720,504872}
G[27906]={38,504904}
G[27907]={38,504904}
G[27908]={38,504904}
G[27909]={38,504904}
G[27910]={38,504904}
G[27911]={38,504904}
G[27912]={17,504900}
G[27913]={17,504900}
G[27914]={38,504904}
G[27915]={504956}
G[27916]={38,504904}
G[27917]={504956}
G[27918]={38,504904}
G[27919]={19,504909}
G[27922]={720,504872}
G[27923]={720,504872}
G[27924]={720,504872}
G[27926]={720,504872}
G[27927]={17,504900}
G[27928]={720,504872}
G[27929]={700,504873,505501}
G[27930]={17,504900}
G[27931]={640,504871}
G[27932]={640,504871}
G[27933]={640,504871}
G[27935]={640,504871}
G[27936]={640,504871}
G[27937]={640,504871}
G[27938]={640,504871}
G[27939]={720,504872}
G[27941]={720,504872}
G[27942]={720,504872}
G[27943]={720,504872}
G[27944]={505718}
G[27945]={700,504873,505501}
G[27947]={700,504873,505501}
G[27948]={505718}
G[27949]={505718}
G[27951]={700,504873,505501}
G[27952]={640,504871}
G[27953]={640,504871}
G[27954]={700,504873,505501}
G[27955]={700,504873,505501}
G[27956]={28,504910}
G[27957]={28,504910}
G[27958]={28,504910}
G[27960]={28,504910}
G[27961]={28,504910}
G[27962]={28,504910}
G[27963]={28,504910}
G[27964]={28,504910}
G[27965]={28,504910}
G[27966]={505718}
G[27967]={505718}
G[27969]={720,504872}
G[27970]={505718}
G[27971]={505718}
G[27972]={505718}
G[27973]={505718}
G[27974]={504956}
G[27975]={505718}
G[27976]={28,504910}
G[27977]={28,504910}
G[27978]={505718}
G[27979]={28,504910}
G[27980]={28,504910}
G[27981]={28,504910}
G[27982]={28,504910}
G[27984]={28,504910}
G[27986]={28,504910}
G[27987]={505718}
G[27989]={182,504931}
G[27990]={720,504872}
G[27991]={505718}
G[27992]={505718}
G[27993]={720,504872}
G[27994]={182,504931}
G[27995]={182,504931}
G[27997]={182,504931}
G[27999]={700,504873,505501}
G[28000]={182,504931}
G[28001]={700,504873,505501}
G[28002]={720,504872}
G[28028]={28,504910}
G[28029]={28,504910}
G[28030]={28,504910}
G[28031]={61,504938}
G[28032]={28,504910}
G[28033]={28,504910}
G[28034]={28,504910}
G[28035]={28,504910}
G[28038]={700,504873,505501}
G[28041]={700,504873,505501}
G[28042]={61,504938}
G[28043]={700,504873,505501}
G[28044]={182,504931}
G[28045]={61,504938}
G[28046]={505718}
G[28047]={61,504938}
G[28048]={61,504938}
G[28049]={182,504931}
G[28050]={505718}
G[28051]={61,504938}
G[28052]={28,504910}
G[28053]={28,504910}
G[28054]={28,504910}
G[28055]={28,504910}
G[28056]={28,504910}
G[28057]={28,504910}
G[28058]={28,504910}
G[28059]={505718}
G[28060]={28,504910}
G[28063]={505718}
G[28064]={28,504910}
G[28068]={504956}
G[28069]={504956}
G[28084]={81,504936,504980}
G[28085]={61,504938}
G[28086]={61,504938}
G[28087]={61,504938}
G[28088]={61,504938}
G[28090]={700,504873,505501}
G[28091]={700,504873,505501}
G[28092]={700,504873,505501}
G[28093]={700,504873,505501}
G[28094]={700,504873,505501}
G[28096]={24,504895}
G[28097]={700,504873,505501}
G[28098]={61,504938}
G[28099]={28,504910}
G[28100]={182,504931}
G[28101]={700,504873,505501}
G[28102]={182,504931}
G[28103]={700,504873,505501}
G[28104]={700,504873,505501}
G[28105]={720,504872}
G[28107]={700,504873,505501}
G[28108]={700,504873,505501}
G[28109]={700,504873,505501}
G[28111]={24,504895}
G[28112]={720,504872}
G[28113]={182,504931}
G[28114]={24,504895}
G[28115]={24,504895}
G[28116]={182,504931}
G[28117]={505718}
G[28118]={505718}
G[28119]={182,504931}
G[28120]={505718}
G[28121]={182,504931}
G[28122]={505718}
G[28123]={700,504873,505501}
G[28124]={61,504938}
G[28125]={61,504938}
G[28126]={182,504931}
G[28127]={61,504938}
G[28128]={182,504931}
G[28129]={182,504931}
G[28130]={505718}
G[28131]={182,504931}
G[28132]={720,504872}
G[28133]={700,504873,505501}
G[28135]={720,504872}
G[28136]={61,504938}
G[28137]={505718}
G[28138]={24,504895}
G[28139]={61,504938}
G[28141]={720,504872}
G[28142]={61,504938}
G[28144]={24,504895}
G[28145]={720,504872}
G[28146]={24,504895}
G[28147]={700,504873,505501}
G[28148]={182,504931}
G[28149]={700,504873,505501}
G[28150]={182,504931}
G[28151]={700,504873,505501}
G[28152]={182,504931}
G[28153]={182,504931}
G[28154]={24,504895}
G[28155]={182,504931}
G[28156]={24,504895}
G[28157]={61,504938}
G[28158]={61,504938}
G[28159]={61,504938}
G[28160]={61,504938}
G[28161]={61,504938}
G[28162]={505718}
G[28163]={505718}
G[28165]={505718}
G[28166]={700,504873,505501}
G[28168]={24,504895}
G[28170]={700,504873,505501}
G[28171]={700,504873,505501}
G[28172]={29,504901}
G[28173]={700,504873,505501}
G[28174]={29,504901}
G[28175]={700,504873,505501}
G[28176]={700,504873,505501}
G[28177]={29,504901}
G[28178]={29,504901}
G[28179]={29,504901}
G[28180]={29,504901}
G[28181]={29,504901}
G[28182]={29,504901}
G[28183]={29,504901}
G[28184]={29,504901}
G[28185]={505718}
G[28186]={505718}
G[28187]={720,504872}
G[28188]={505718}
G[28190]={182,504931}
G[28191]={700,504873,505501}
G[28192]={24,504895}
G[28193]={720,504872}
G[28194]={720,504872}
G[28195]={720,504872}
G[28196]={24,504895}
G[28197]={24,504895}
G[28198]={720,504872}
G[28199]={24,504895}
G[28200]={720,504872}
G[28201]={720,504872}
G[28202]={29,504901}
G[28203]={29,504901}
G[28204]={29,504901}
G[28205]={29,504901}
G[28206]={24,504895}
G[28207]={182,504931}
G[28208]={182,504931}
G[28209]={24,504895}
G[28210]={720,504872}
G[28211]={700,504873,505501}
G[28212]={700,504873,505501}
G[28213]={182,504931}
G[28214]={182,504931}
G[28215]={700,504873,505501}
G[28216]={700,504873,505501}
G[28217]={182,504931}
G[28218]={182,504931}
G[28219]={182,504931}
G[28220]={182,504931}
G[28221]={182,504931}
G[28222]={182,504931}
G[28223]={505718}
G[28224]={182,504931}
G[28225]={29,504901}
G[28226]={29,504901}
G[28227]={29,504901}
G[28230]={24,504895}
G[28231]={24,504895}
G[28232]={505718}
G[28233]={700,504873,505501}
G[28234]={700,504873,505501}
G[28235]={24,504895}
G[28237]={24,504895}
G[28239]={29,504901}
G[28241]={700,504873,505501}
G[28242]={700,504873,505501}
G[28243]={700,504873,505501}
G[28244]={700,504873,505501}
G[28245]={29,504901}
G[28246]={29,504901}
G[28247]={700,504873,505501}
G[28248]={700,504873,505501}
G[28249]={700,504873,505501}
G[28250]={720,504872}
G[28251]={24,504895}
G[28253]={29,504901}
G[28254]={29,504901}
G[28256]={182,504931}
G[28257]={182,504931}
G[28261]={182,504931}
G[28264]={182,504931}
G[28265]={29,504901}
G[28266]={29,504901}
G[28267]={720,504872}
G[28269]={720,504872}
G[28271]={720,504872}
G[28272]={720,504872}
G[28273]={720,504872}
G[28274]={720,504872}
G[28275]={505718}
G[28276]={720,504872}
G[28277]={720,504872}
G[28278]={29,504901}
G[28279]={29,504901}
G[28280]={700,504873,505501}
G[28281]={700,504873,505501}
G[28282]={700,504873,505501}
G[28283]={61,504938}
G[28284]={61,504938}
G[28286]={29,504901}
G[28288]={182,504931}
G[28291]={720,504872}
G[28294]={700,504873,505501}
G[28305]={182,504931}
G[28306]={182,504931}
G[28310]={29,504901}
G[28311]={29,504901}
G[28312]={29,504901}
G[28313]={29,504901}
G[28314]={29,504901}
G[28315]={29,504901}
G[28316]={29,504901}
G[28317]={29,504901}
G[28318]={29,504901}
G[28319]={29,504901}
G[28320]={29,504901}
G[28321]={29,504901}
G[28322]={29,504901}
G[28324]={24,504895}
G[28325]={24,504895}
G[28326]={29,504901}
G[28327]={29,504901}
G[28329]={24,504895}
G[28330]={24,504895}
G[28331]={24,504895}
G[28332]={24,504895}
G[28333]={182,504931}
G[28334]={182,504931}
G[28335]={182,504931}
G[28336]={182,504931}
G[28337]={182,504931}
G[28338]={182,504931}
G[28339]={182,504931}
G[28340]={182,504931}
G[28341]={182,504931}
G[28342]={182,504931}
G[28344]={24,504895}
G[28345]={24,504895}
G[28346]={700,504873,505501}
G[28348]={24,504895}
G[28350]={720,504872}
G[28351]={720,504872}
G[28352]={720,504872}
G[28353]={720,504872}
G[28354]={24,504895}
G[28356]={24,504895}
G[28357]={182,504931}
G[28358]={182,504931}
G[28359]={182,504931}
G[28360]={182,504931}
G[28361]={182,504931}
G[28362]={182,504931}
G[28363]={720,504872}
G[28364]={182,504931}
G[28366]={182,504931}
G[28367]={720,504872}
G[28368]={182,504931}
G[28369]={700,504873,505501}
G[28370]={182,504931}
G[28372]={182,504931}
G[28373]={182,504931}
G[28374]={182,504931}
G[28375]={24,504895}
G[28376]={720,504872}
G[28377]={700,504873,505501}
G[28378]={700,504873,505501}
G[28379]={700,504873,505501}
G[28380]={182,504931}
G[28381]={182,504931}
G[28382]={182,504931}
G[28383]={182,504931}
G[28384]={182,504931}
G[28385]={182,504931}
G[28386]={182,504931}
G[28387]={182,504931}
G[28388]={182,504931}
G[28389]={182,504931}
G[28392]={182,504931}
G[28397]={24,504895}
G[28400]={24,504895}
G[28402]={720,504872}
G[28403]={720,504872}
G[28404]={720,504872}
G[28407]={700,504873,505501}
G[28408]={700,504873,505501}
G[28409]={700,504873,505501}
G[28410]={700,504873,505501}
G[28411]={700,504873,505501}
G[28413]={700,504873,505501}
G[28415]={29,504901}
G[28416]={29,504901}
G[28417]={29,504901}
G[28418]={29,504901}
G[28419]={29,504901}
G[28420]={29,504901}
G[28421]={29,504901}
G[28422]={29,504901}
G[28423]={29,504901}
G[28424]={29,504901}
G[28425]={29,504901}
G[28426]={29,504901}
G[28427]={29,504901}
G[28428]={29,504901}
G[28429]={29,504901}
G[28430]={29,504901}
G[28431]={29,504901}
G[28432]={29,504901}
G[28433]={29,504901}
G[28434]={29,504901}
G[28436]={29,504901}
G[28437]={29,504901}
G[28438]={29,504901}
G[28439]={29,504901}
G[28440]={29,504901}
G[28441]={29,504901}
G[28442]={29,504901}
G[28443]={29,504901}
G[28444]={29,504901}
G[28445]={29,504901}
G[28446]={29,504901}
G[28447]={29,504901}
G[28448]={29,504901}
G[28450]={29,504901}
G[28451]={29,504901}
G[28452]={29,504901}
G[28454]={29,504901}
G[28455]={29,504901}
G[28456]={29,504901}
G[28460]={281,504940}
G[28464]={281,504940}
G[28467]={281,504940}
G[28469]={281,504940}
G[28470]={281,504940}
G[28471]={281,504940}
G[28472]={281,504940}
G[28479]={281,504940}
G[28480]={720,504872}
G[28482]={720,504872}
G[28483]={720,504872}
G[28484]={24,504895}
G[28485]={24,504895}
G[28486]={720,504872}
G[28487]={24,504895}
G[28489]={24,504895}
G[28491]={29,504901}
G[28492]={43,504925}
G[28493]={43,504925,504976}
G[28495]={24,504895}
G[28497]={720,504872}
G[28498]={720,504872}
G[28499]={720,504872}
G[28500]={720,504872}
G[28501]={720,504872}
G[28502]={720,504872}
G[28503]={61,504938}
G[28504]={61,504938}
G[28505]={22,504893}
G[28506]={24,504895}
G[28507]={161,504935}
G[28508]={22,504893}
G[28509]={161,504935}
G[28510]={121,504932,504979}
G[28512]={28,504910}
G[28513]={281,504940}
G[28514]={29,504901}
G[28515]={29,504901}
G[28518]={281,504940}
G[28519]={281,504940}
G[28520]={720,504872}
G[28521]={281,504940}
G[28522]={281,504940}
G[28524]={281,504940}
G[28525]={201,504939}
G[28526]={201,504939}
G[28527]={261,504934}
G[28528]={261,504934}
G[28529]={42,504928,505453}
G[28530]={281,504940}
G[28531]={101,504930}
G[28532]={81,504936,504980}
G[28533]={720,504872}
G[28534]={281,504940}
G[28535]={281,504940}
G[28536]={281,504940}
G[28537]={281,504940}
G[28538]={24,504895}
G[28539]={81,504936,504980}
G[28540]={281,504940}
G[28542]={182,504931}
G[28543]={182,504931}
G[28544]={281,504940}
G[28545]={281,504940}
G[28548]={101,504930}
G[28549]={607,504937,504981}
G[28550]={607,504937}
G[28551]={607,504937}
G[28552]={607,504937}
G[28553]={19,504909}
G[28554]={141,504929,504978}
G[28556]={24,504895}
G[28560]={463,504908}
G[28561]={720,504872}
G[28562]={39,504903}
G[28563]={36,504902}
G[28564]={34,504903}
G[28565]={40,504899}
G[28566]={24,504895}
G[28568]={21,504894}
G[28569]={38,504904}
G[28570]={38,504904}
G[28571]={24,504895}
G[28572]={16,504896}
G[28574]={26,504897}
G[28575]={22,504893}
G[28576]={22,504893}
G[28577]={23,504892}
G[28578]={23,504892}
G[28579]={17,504900}
G[28580]={17,504900}
G[28581]={28,504910}
G[28582]={28,504910}
G[28583]={700,504873,505501}
G[28584]={700,504873,505501}
G[28586]={700,504873,505501}
G[28587]={24,504895}
G[28588]={700,504873,505501}
G[28589]={700,504873,505501}
G[28590]={700,504873,505501}
G[28591]={700,504873,505501}
G[28592]={700,504873,505501}
G[28593]={700,504873,505501}
G[28594]={700,504873,505501}
G[28595]={700,504873,505501}
G[28596]={700,504873,505501}
G[28597]={700,504873,505501}
G[28598]={700,504873,505501}
G[28599]={700,504873,505501}
G[28600]={24,504895}
G[28602]={720,504872}
G[28603]={24,504895}
G[28604]={24,504895}
G[28605]={24,504895}
G[28609]={281,504940}
G[28610]={281,504940}
G[28611]={720,504872}
G[28612]={720,504872,504961}
G[28613]={720,504872}
G[28614]={281,504940}
G[28615]={281,504940}
G[28616]={24,504895}
G[28618]={281,504940}
G[28619]={16,504896}
G[28620]={24,504895}
G[28622]={720,504872}
G[28623]={720,504872}
G[28624]={281,504940}
G[28625]={281,504940}
G[28626]={281,504940}
G[28627]={281,504940}
G[28628]={281,504940}
G[28629]={281,504940}
G[28630]={281,504940}
G[28631]={281,504940}
G[28632]={281,504940}
G[28633]={720,504872}
G[28634]={24,504895}
G[28635]={24,504895}
G[28636]={24,504895}
G[28637]={281,504940}
G[28639]={281,504940}
G[28640]={281,504940}
G[28641]={281,504940}
G[28643]={24,504895}
G[28644]={24,504895}
G[28645]={24,504895}
G[28646]={24,504895}
G[28647]={24,504895}
G[28654]={504956}
G[28655]={700,504873,505501}
G[28656]={281,504940}
G[28657]={505719}
G[28658]={505719}
G[28659]={505719}
G[28660]={505719}
G[28661]={505719}
G[28662]={505719}
G[28663]={505719}
G[28664]={505719}
G[28665]={505719}
G[28666]={29,504901}
G[28667]={29,504901}
G[28668]={505719}
G[28669]={505719}
G[28670]={505719}
G[28671]={19,504909}
G[28673]={19,504909}
G[28674]={281,504940}
G[28675]={38,504904}
G[28676]={281,504940}
G[28677]={38,504904}
G[28678]={505719}
G[28679]={505719}
G[28680]={505719}
G[28681]={505719}
G[28682]={505719}
G[28683]={505719}
G[28684]={505719}
G[28685]={505719}
G[28686]={505719}
G[28687]={505719}
G[28688]={37,504906}
G[28689]={505719}
G[28690]={505719}
G[28691]={505719}
G[28692]={505719}
G[28693]={505719}
G[28694]={505719}
G[28695]={505719}
G[28696]={505719}
G[28697]={505719}
G[28698]={505719}
G[28699]={37,504906}
G[28700]={505719}
G[28701]={281,504940}
G[28702]={673,504905}
G[28703]={281,504940}
G[28704]={673,504905}
G[28705]={19,504909}
G[28706]={281,504940}
G[28707]={281,504940}
G[28708]={465,501189,501271}
G[28709]={486,500033,501358}
G[28710]={281,504940}
G[28711]={486,500033,501358}
G[28712]={700,504873,505501}
G[28718]={281,504940}
G[28719]={281,504940}
G[28722]={281,504940}
G[28732]={504956}
G[28733]={24,504895}
G[28735]={504956}
G[28737]={504956}
G[28741]={504956}
G[28742]={281,504940}
G[28744]={24,504895}
G[28747]={24,504895}
G[28749]={22,504893}
G[28750]={22,504893}
G[28758]={700,504873,505501}
G[28768]={281,504940}
G[28781]={504956}
G[28782]={281,504940}
G[28814]={504956}
G[28815]={504956}
G[28828]={281,504940}
G[28829]={281,504940}
G[28830]={281,504940}
G[28831]={281,504940}
G[28836]={504956}
G[28837]={281,504940}
G[28838]={281,504940}
G[28839]={281,504940}
G[28840]={281,504940}
G[28841]={281,504940}
G[28842]={281,504940}
G[28843]={504956}
G[28845]={504956}
G[28847]={281,504940}
G[28848]={281,504940}
G[28849]={181,504927}
G[28852]={504956}
G[28856]={261,504934}
G[28857]={19,504909}
G[28858]={19,504909}
G[28859]={261,504934}
G[28865]={19,504909}
G[28866]={504956}
G[28867]={19,504909}
G[28869]={640,504871}
G[28870]={504956}
G[28876]={43,504925,504976}
G[28877]={11,504933}
G[28881]={161,504935}
G[28910]={501031}
G[28911]={501028}
G[28913]={501032}
G[28914]={501029}
G[28922]={501022}
G[28924]={501025}
G[28926]={501023}
G[28927]={501026}
G[28934]={501695}
G[28935]={501695}
G[28943]={506014}
G[28944]={506013}
G[28945]={506011}
G[28946]={506012}
G[28947]={506014}
G[28948]={506013}
G[28949]={506012}
G[28950]={506011}
G[28951]={500963}
G[28952]={500963}
G[28953]={500965}
G[28954]={500966}
G[28955]={500966,500967}
G[28956]={500966}
G[28957]={500967}
G[28958]={500965}
G[28959]={500967}
G[28960]={500966}
G[28961]={500966}
G[28962]={500967}
G[28963]={500966}
G[28964]={500966}
G[28965]={500966,500967}
G[28966]={500967}
G[28967]={500966,500967}
G[28968]={500966}
G[28969]={500967}
G[28970]={500966}
G[28971]={500967}
G[28972]={500967}
G[28973]={505838}
G[28974]={505838}
G[28976]={505838}
G[28977]={505837}
G[28978]={505837}
G[28979]={505837}
G[28980]={505837}
G[28981]={505837,505838}
G[28982]={505837,505838}
G[28983]={505837}
G[28984]={505838}
G[28985]={505837}
G[28986]={505838}
G[28987]={500967}
G[28988]={500966}
G[28989]={500965}
G[28990]={500966}
G[28991]={500966}
G[28992]={500965}
G[28993]={500963,500965}
G[28994]={500963,500965}
G[28995]={500963}
G[28996]={500965}
G[28998]={500965}
G[28999]={505837,505838}
G[29000]={505837,505838}
G[29001]={505837,505838}
G[29002]={500965}
G[29003]={500965}
G[29004]={500965}
G[29005]={500965}
G[29006]={500963}
G[29007]={500963}
G[29008]={500963}
G[29009]={500965}
G[29010]={500963}
G[29011]={500963}
G[29012]={500963}
G[29013]={500963}
G[29014]={500963,500965}
G[29016]={505837,500838}
G[29017]={505837,505838}
G[29018]={500963,500965}
G[29019]={505838}
G[29020]={505837}
G[29030]={506011,506012}
G[29031]={506011,506012}
G[29032]={281,504940}
G[29035]={281,504940}
G[29036]={506011,506012}
G[29037]={281,504940}
G[29038]={281,504940}
G[29039]={281,504940}
G[29040]={281,504940}
G[29051]={281,504940}
G[29052]={281,504940}
G[29053]={281,504940}
G[29054]={501040}
G[29066]={606,504870}
G[29075]={501040}
G[29086]={11,504933}
G[29088]={11,504933}
G[29090]={11,504933}
G[29144]={501040}
G[29181]={505866}
G[29195]={505859}
G[29198]={505866}
G[29200]={505859}
G[29201]={505866}
G[29203]={505859}
G[29214]={505866}
G[29254]={505866}
G[29272]={505866}
G[29279]={505866}
G[29281]={505866}
G[29283]={505866}
G[29313]={505842}
G[29314]={505842}
G[29315]={505844}
G[29316]={505842}
G[29317]={505850}
G[29318]={505842}
G[29319]={505850}
G[29320]={505850}
G[29321]={505848}
G[29322]={505850}
G[29323]={505848}
G[29324]={505848}
G[29325]={505848}
G[29332]={505844}
G[29333]={505844}
G[29334]={505844}
G[29342]={505847}
G[29343]={505847}
G[29344]={505847}
G[29345]={505849}
G[29346]={505849}
G[29347]={505847}
G[29348]={505849}
G[29349]={505849}
G[29350]={505847}
G[29351]={505841}
G[29352]={505841}
G[29353]={505841}
G[29354]={505849}
G[29355]={505841}
G[29356]={505841}
G[29357]={505842}
G[29358]={505843}
G[29359]={505848}
G[29360]={505844}
G[29361]={505850}
G[29362]={505843}
G[29363]={505843}
G[29364]={505843}
G[29365]={505843}
G[29371]={501040}
G[29374]={501041}
G[29375]={501041}
G[29376]={501041}
G[29377]={501041}
G[29443]={506027,506029}
G[29444]={506027,506029}
G[29445]={506027,506029}
G[29446]={506027,506029}
G[29451]={506027,506029}
G[29456]={506028,506029}
G[29457]={506028,506029}
G[29458]={506028,506029}
G[29464]={506029}
G[29647]={506300}	-- need for the Tian Monastery part				-- ** Logically one could also turn in 29639 or 29646 instead.  Cannot currently handle this. **
G[29670]={506300,506534}	-- needed for Nectarbreeze Orchard part
G[29694]={506534}	-- needed for The Remains of Hellscream's Fist part
G[29734]={506006}
G[29735]={506006}
G[29736]={506006}
G[29737]={506006}
G[29738]={506006}
G[29739]={506006}
G[29740]={506006}
G[29741]={506006}
G[29742]={506006}
G[29755]={506300,506534}	-- needed for Ruins of Gan-Shi part
G[29822]={506534}	-- needed for First Contact part
G[29879]={506534}	-- needed for Strange Bedfellows part
G[29882]={506300,506534}	-- needed for Dawn's Blossom part
G[29894]={506300}	-- needed for The Waterspeaking Ceremony part
G[29901]={506300}	-- needed for The White Pawn part
G[29905]={506300}	-- needed for Pearlfin Village part
G[29906]={506300}	-- needed for Pearlfin Village part
G[29918]={506301}	-- needed for Thunderfoot Fields part
G[29920]={506300,506534}	-- needed for Dawn's Blossom part
G[29930]={506300,506534}	-- needed for Greenstone Quarry part
G[29952]={506301}	-- needed for Mudmug's Place part
G[29967]={506534}	-- needed for Grookin Hill part
G[29990]={506301}	-- needed for The Hidden Master part
G[30000]={506300,506534}	-- needed for The Temple of the Jade Serpent part
G[30073]={506301}	-- needed for Chen's Masterpiece part
G[30078]={506301}	-- needed for Stormstout Brewery part
G[30090]={506535,506536}	-- needed for Zhu's Watch part
G[30131]={506536}	-- needed for Thunder Cleft part
G[30174]={506536}	-- needed for Dawnchaser Retreat part
G[30186]={506301}	-- needed for Nesingwary's Safari part
G[30273]={506535,506536} -- needed for Temple of the Red Crane part
G[30348]={506535}	-- needed for The Incursion part
G[30445]={506535}	-- needed for The Waters of Youth part
G[30485]={506534}	-- needed for The Battle for the Forest part
G[30492]={506537,506538}	-- needed for The Yak Wash part
G[30500]={506300,506534}	-- needed for Overcoming Doubt part
G[30502]={506300,506534}	-- needed for Overcoming Doubt part
G[30504]={506534}	-- needed for Overcoming Doubt part
G[30514]={506537}	-- needed for Westwind Rest part
G[30515]={506538}
G[30637]={507315}	-- needed for ??? part
G[30639]={507315}	-- needed for The Jade Army part
G[30642]={507315}	-- needed for Weapons of the Thunder King part
G[30646]={507315}	-- needed for Welcome Home part
G[30660]={506537}	-- needed for The Yaungol Invasion part
G[30672]={506535,506536}	-- needed for Nayeli Lagoon part
G[30675]={506535,506536}	-- needed for Nayeli Lagoon part
G[30784]={506539}	-- needed for Fire Camp Osul part
G[30793]={506539}	-- needed for Mistlurkers in the Sumprushes part
G[30800]={506537,506538} -- needed for The Thunder King part
G[30855]={506537,506538} -- needed for Inkgill Mere part
G[30900]={506539}	-- needed for On Hatred's Path part
G[30926]={506539}	-- needed for Tai Ho's Investigation part
G[30946]={506537,506538}	-- needed for Zouchin Village part
G[30968]={506539}	-- needed for The Sha of Hatred part
G[31006]={507312}	-- needed for Kil'ruk the Wind-Reaver part
G[31010]={507312}	-- needed for Malik the Unscathed part
G[31026]={507312}	-- needed for Korven the Prime part
G[31038]={507297}
G[31066]={506540}	-- needed for The First Paragons part
G[31085]={507312}	-- needed for Iyyokuk the Lucid part
G[31086]={506540}	-- needed for Taste of Amber part
G[31104]={507297}
G[31127]={507297}
G[31128]={507297}
G[31179]={507312}	-- needed for Skeer the Bloodseeker part
G[31220]={507297}
G[31221]={507297}
G[31277]={507310}
G[31315]={507296}
G[31316]={506603}
G[31319]={506300}	-- needed for Overcoming Doubt part
G[31354]={506540,507312} -- needed for Like a Deck Boss part of Dread Haste Makes Dread Waste and Ka'roz the Locust part of Amber is the Color of My Energy
G[31362]={506300}	-- needed for The Battle for the Forest part
G[31394]={506537}	-- needed for Temple of the White Tiger part
G[31398]={506540,507312}	-- needed for Might of the Klaxxi part of Dread Haste Makes Dread Waster and Kaz'tik the Manipulator part of Amber is the Color of My Energy
G[31606]={507312}	-- needed for Rik'kal the Dissector part
G[31724]={506603}
G[31725]={506603}
G[31726]={506603}
G[31728]={506603}
G[31729]={506603}
G[31745]={506300}	-- needed for Paw'don Village part
G[31779]={506534}	-- needed for First Contact part
G[31786]={507612}
G[31787]={507612}
G[31788]={507612}
G[31789]={507612}
G[31790]={507612}
G[31791]={507612}
G[31792]={507612}
G[31793]={507612}
G[31794]={507612}
G[31795]={507612}
G[31796]={507612}
G[31797]={507612}
G[31798]={507612}
G[31799]={507612}
G[31800]={507612}
G[31801]={507612}
G[31802]={507612}
G[31803]={507612}
G[31804]={507612}
G[31805]={507612}
G[31808]={507314}
G[32020]={507602}
G[32021]={507601,507602}
G[32022]={507602}
G[32023]={507601,507602}
G[32024]={507601,507602}
G[32026]={507601,507602}
G[32027]={507601,507602}
G[32028]={507602}
G[32029]={507601,507602}
G[32031]={507601,507602}
G[32032]={507601,507602}
G[32033]={507601}
G[32034]={507601,507602}
G[32036]={507601,507602}
G[32037]={507601,507602}
G[32039]={507601,507602}
G[32040]={507602}
G[32041]={507601,507602}
G[32042]={507601}
G[32043]={507601,507602}
G[32044]={507601,507602}
G[32046]={507601,507602}
G[32047]={507602}
G[32048]={507601,507602}
G[32049]={507601}
G[32050]={507602}
G[32051]={507601,507602}
G[32052]={507601}

-- 15851 is the 5.0.3 release dated 2012-07-10
local _, release = GetBuildInfo()
release = tonumber(release)

if release >= 16139 then
Grail.extraAchievements['Alliance'][6] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507928, }
Grail.extraAchievements['Horde'][6] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507929, }

G[32108]={507929}	-- needed for Domination Point part
G[32109]={507928}	-- needed for Lion's Landing part
G[32191]={507929}	-- needed for Blood for Blood part
G[32194]={507928}	-- needed for The Korune part		*** TODO: Determine if also need 32243 as well for this ***
G[32244]={507929}	-- needed for Blood for Blood part
G[32257]={507929}	-- needed for The Voice of the Gods part
G[32316]={507928}	-- needed for Heart of the Alliance part
G[32328]={507929}	-- needed for The Darnassus Operation part
G[32330]={507929}	-- needed for Rise of the Blood Elves part
G[32335]={507928}	-- needed for An Ancient Ally part
G[32336]={507928}	-- needed for In Search of Harmony part
G[32337]={507928}	-- needed for In Search of Harmony part
G[32338]={507928}	-- needed for In Search of Harmony part
G[32352]={507929}	-- needed for Pride part
G[32362]={507928}	-- needed for Jaina's Hope part
G[32368]={507929}	-- needed for Secrets of the Past part
G[32371]={507928}	-- needed for Secrets of the Past part
G[32372]={507929}	-- needed for The Horde is Family part
G[32378]={507929}	-- needed for The Korune part
G[32379]={507929}	-- needed for The Korune part
G[32384]={507929}	-- needed for The Korune part
G[32392]={507929}	-- needed for The Divine Bell part
G[32394]={507928}	-- needed for The Divine Bell part
G[32397]={507928}	-- needed for The Voice of the Gods part
G[32399]={507929}	-- needed for The Breath of Darkest Shadow part
G[32412]={507929}	-- needed for The Purge of Dalaran part
G[32423]={507928}	-- needed for The Purge of Dalaran part
G[32426]={507928}	-- needed for The Man With a Thousand Faces part
G[32455]={507928}	-- needed for 
end

if release >= 16486 then
Grail.extraAchievements['Alliance'][6] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507928, 507533, 507534, 507535, 507536, 508099, }
Grail.extraAchievements['Horde'][6] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507929, 507533, 508008, 507535, 507536, 508099, }
Grail.extraAchievements['Alliance'][2] = { 500940, 505318, 505320, 504960, 505452, 508306, }
Grail.extraAchievements['Horde'][2] = { 500940, 504960, 505452, 505319, 505321, 508307, }

G[31482]={507533}
G[32212]={508099}	-- needed for Build a Base part of Isle of Thunder (Horde)
G[32277]={508099}	-- needed for Take the Forge of Isle of Thunder (Horde)
G[32278]={508099}	-- needed for Assault the Shipyard of Isle of Thunder (Horde)
G[32279]={508099}	-- needed for The Fall of Shan Bu of Isle of Thunder (Horde)
G[32390]={507534}
G[32432]={508008}
G[32496]={508042}
G[32497]={508044,508045}
G[32498]={508044,508045}
G[32499]={508044,508045}
G[32500]={508044,508045}
G[32501]={508044,508045}
G[32502]={508044,508045}
G[32503]={508043}
G[32597]={507535}
G[32680]={508099}	-- needed for First Landing part of Isle of Thunder (Horde)
G[32681]={508099}	-- needed for First Landing part of Isle of Thunder (Alliance)
G[32644]={508099}	-- needed for Build a Base part of Isle of Thunder (Alliance)
G[32654]={508099}	-- needed for Break Down the Wall of Isle of Thunder
G[32652]={508099}	-- needed for Take the Forge of Isle of Thunder (Alliance)
G[32655]={508099}	-- needed for Assault the Shipyard of Isle of Thunder (Alliance)
G[32656]={508099}	-- needed for The Fall of Shan Bu of Isle of Thunder (Alliance)
G[32807]={508307,508306}	-- needed for The Lorewalker's Counsel of Darkspear Revolutionary and Hordebreaker
G[32811]={508306}	-- needed for Battlefield: Barrens of Hordebreaker
G[32814]={508307}	-- needed for Durotar Liberation of Darkspear Revolutionary
G[32816]={508307,508306}	-- needed for The Path of the Last Emperor of Darkspear Revolutionary and Hordebreaker
G[32861]={507536}
G[32862]={508307}	-- needed for Battlefield: Barrens (Weekly) of Darkspear Revolutionary
G[32872]={508306}	-- needed for Battlefield: Barrens (Weekly) of Hordebreaker
end

if release >= 17359 then
Grail.extraAchievements['Alliance'][6] = { 507296, 507297, 507312, 507314, 507310, 507612, 507928, 507533, 507534, 507535, 507536, 508099, 508726, 508727, 508729, 508730, }
Grail.extraAchievements['Horde'][6] = { 507296, 507297, 507312, 507314, 507310, 507612, 507929, 507533, 508008, 507535, 507536, 508099, 508726, 508727, 508729, 508730, }
Grail.extraAchievements['Alliance'][2] = { 500940, 505318, 505320, 504960, 505452, }
Grail.extraAchievements['Horde'][2] = { 500940, 504960, 505452, 505319, 505321, }
G[32956]={508727}
G[32957]={508727}
G[32958]={508727}
G[32968]={508726}
G[32969]={508726}
G[32971]={508726}
G[32974]={508730}
G[32975]={508730}
G[32976]={508730}
G[33203]={508729}	-- Skull-Covered
G[33204]={508729}	-- Sturdy
G[33205]={508729}	-- Sturdy
G[33206]={508729}	-- Sturdy
G[33207]={508729}	-- Sturdy
G[33208]={508729}	-- Smoldering
G[33209]={508729}	-- Smoldering
G[33210]={508729}	-- Blazing
-- 8729 requires 17 of the Moss-Covered chests, but there are many more than that on the island.  So basically it would be really great if we could transform
-- the way prerequisites work to have the same P: concepts that quests use.  This would allow us to specify 17 of a group that contains all the Moss-Covered
-- chests.  However, it would be interesting to present the data in something like Wholly.
end

if release >= 18645 then
Grail.loremasterAchievements['Alliance'][7] = { 508845, 508920, 508923, 508925, 508927, 509528, 509618, }
Grail.loremasterAchievements['Horde'][7] = { 508671, 508919, 508924, 508926, 508928, 509529, 509618, }
Grail.extraAchievements['Alliance'][7] = { 509602, 509605, 509607, 509615, 509674, }
Grail.extraAchievements['Horde'][7] = { 509605, 509606, 509607, 509615, 509674, }
G[32796]={508671}	-- needed for Ga'nar's Vengeance part of You'll Get Caught Up In The... Frostfire!
G[33116]={509528}	-- needed for On the Shadow's Trail
G[33145]={509606}
G[33256]={508845}	-- needed for The Light Prevails part of As I Walk Through the Valley of the Shadow of Moon
G[33271]={508845}	-- needed for Gloomshade Grove of As I Walk Through the Valley of the Shadow of Moon
G[33473]={508671}	-- needed for Defense of Wor'gol part of You'll Get Caught Up In The... Frostfire!
G[33527]={508671}	-- needed for Die Belagerung der Speerspießerfestung part of Ein Lied von Frost und Feuer
G[33582]={508919,508920}	-- needed for The Plight of the Arakkoa of Tala-done With This
G[33731]={508919}	-- needed for The Battle for Shattrath part of Don't Let the Tala-door Hit You on the Way Out
G[33828]={508671}	-- needed for Thunder's Fall part of You'll Get Caught Up In The... Frostfire!
G[34019]={508845}	-- needed for Shadows Awaken part of As I Walk Through the Valley of the Shadow of Moon
G[34054]={508845}	-- needed for A Sister's Sacrifice part of As I Walk Through the Valley of the Shadow of Moon
G[34076]={509602}
G[34099]={508920}	-- needed for The Battle for Shattrath part of Tala-done With This
G[34124]={508671}	-- needed for The Battle of Thunder Pass part of You'll Get Caught Up In The... Frostfire!
G[34154]={508920}	-- needed for In the Shadows of AUchindown part of Don't Let the Tala-door Hit You on the Way Out
G[34295]={509529}
G[34496]={509602}
G[34501]={509606}
G[34504]={509602}
G[34505]={509606}
G[34564]={508919}	-- needed for In the Shadows of Auchindoun part of Don't Let the Tala-door Hit You on the Way Out
G[34596]={508927}	-- needed for Trouble at the Overwatch part of Nagrandeur
G[34639]={509674}
G[34660]={509674}
G[34666]={508927,508928}	-- needed for The Ring of Trials part of Nagrandeur
G[34667]={509674}
G[34692]={508845}	-- needed for Establishing a Foothold ofAs I Walk Through the Valley of the Shadow of Moon
G[34711]={508920}	-- needed for Establishing your Mage Tower of Tala-done With This
G[34712]={508919}	-- needed for Establishing your Outpost part of Don't Let the Tala-door Hit You on the Way Out
G[34723]={509615}
G[34724]={509607}
G[34728]={509602}
G[34769]={508927}	-- needed for The Might of Steel and Blood part of Nagrandeur
G[34775]={508671}	-- needed for Foothold in a Savage Land part of You'll Get Caught Up In The... Frostfire!
G[34792]={508845}	-- needed for The Pursuit of Justice part of As I Walk Through the Valley of the Shadow of Moon
G[34899]={508928}	-- needed for Die Macht von Stahl und Blut part of Nagrandeur
G[34918]={508928}
G[34942]={508925,508926}	-- needed for Secrets of the Talonpriests part of Between Arak and a Hard Place
G[34957]={508927}	-- needed for A Blademaster's Honor part of Nagrandeur
G[34971]={508919}	-- needed for Establishing your Outpost part of Don't Let the Tala-door Hit You on the Way Out
G[34981]={508920}
G[35012]={508925,508926}	-- needed for The Gods of Arak parts of Between...
G[35015]={508845}	-- needed for Purifying the Gene Pool part of As I Walk Through the Valley of the Shadow of Moon
G[35061]={508927}	-- needed for The Taking of Lokrath part of Nagrandeur
G[35063]={508923}	-- needed for We Need an Outpost of Putting the Gore in Gorgrond
G[35088]={508927,508928}	-- needed for The Shadow of the Void part of Nagrandeur
G[35097]={508928}
G[35136]={508924}
G[35137]={508923}	-- The Sparring Arena
G[35151]={508924}	-- needed for Your Base, Your Choice part of Putting the Gore in Gorgrond
G[35152]={508924}
G[35158]={508928}	-- needed for Trouble at the Overwatch of Nagrandeur
G[35169]={508927}	-- needed for The Legacy of Garrosh Hellscream part of Nagrandeur
G[35171]={508928}
G[35236]={509674}
G[35237]={509674}
G[35245]={508925}	-- needed for The Gods of Arak part of Between Arak and a Hard Place
G[35255]={508923}	-- needed for Power of the Genasaur of
G[35298]={508925,508926}	-- needed for Pinchwhistle Gearworks part of Between Arak and a Hard Place
G[35317]={508928}
G[35379]={509615}
G[35396]={508927}	-- needed for The Dark Heart of Oshu'Gun part of Nagrandeur
G[35416]={508924}
G[36473]={509607}
G[36476]={509607}
G[35482]={508925}	-- needed for Admiral Taylor's Garrison part of Between Arak and a Hard Place
G[35634]={508925,508926}	-- needed for Legacy of the Apexis part of Between Arak and a Hard Place
G[35649]={509605}
G[35671]={508925,508926}	-- needed for Shadows Gather part of Between Arak and a Hard Place
G[35702]={508923}	--	needed for In the Land of Giants  -  Chains of Iron
G[35704]={508925,508926}	-- needed for When the Raven Swallows the Day part of Between Arak and a Hard Place
G[35881]={509607}
G[35884]={508921}	-- needed for Welcome to Draenor
G[35896]={508925,508926}	-- needed for Terrok's Legend part of Between Arak and a Hard Place
G[36183]={508926}
G[36480]={509607}
G[36500]={509607}
G[36504]={509607}
G[36563]={509607}
G[36564]={509607}
G[36566]={509607}
G[36571]={509607}
G[36573]={508924}
G[36574]={508924}	-- needed for The Iron Approach part of Putting the Gore in Gorgrond
G[36575]={508923}	-- needed for The Iron Approach part of Putting the Gore in Gorgrond
G[36576]={508923}	-- needed for The Iron Approach part of Putting the Gore in Gorgrond
G[36590]={509605}
G[36603]={509607}
G[36660]={509605}
G[36792]={509605}
G[36940]={509618}	-- needed for The Iron Invasion
G[36941]={509618}	-- needed for The Iron Invasion
G[37280]={509615}
G[37421]={509674}
G[37422]={509674}
end

if Grail.inLegion then
Grail.loremasterAchievements['Alliance'][8] = { 510698, 510763, 510059, 510790, }
Grail.loremasterAchievements['Horde'][8] = { 510698, 510763, 510059, 510790, }
G[37449]={510763}	-- needed for Behind Legion Lines part of Azsuna Matata
G[37470]={510763}	-- needed for Azsuna vs Azshara part of Azsuna Matata
G[37566]={510763}	-- needed for Against the Giants part of Azsuna Matata
G[38060]={510790}	-- needed for The Aftermath of Vrykul Story, Bro
G[38147]={510698}	-- needed for Archdruid of the Claw part of That's 'Val'sharah Folks!
G[38225]={510698}	-- needed for Archdruid of Lore part of That's 'Val'sharah Folks!
G[38235]={510698}	-- needed for Archdruid of Lore part of That's 'Val'sharah Folks!
G[38624]={510790}	-- needed for The Trial of Will part of Vrykul Story, Bro
G[38691]={510698}	-- needed for Bradensbrook part of That's 'Val'sharah Folks!
G[38721]={510698}	-- needed for Black Rook Hold part of That's 'Val'sharah Folks!
G[38743]={510698}	-- needed for All Nightmare Long part of That's 'Val'sharah Folks!
G[38753]={510698}	-- needed for Into the Nightmare part of That's 'Val'sharah Folks!
G[38818]={510790}	-- needed for The Trial of Valor of Vrykul Story, Bro
G[38882]={510790}	-- needed for Secrets of the Shieldmaidens of Vrykul Story, Bro
G[38909]={510059}	-- needed for Riverbend of Ain't No Mountain High Enough
G[39387]={510059}	-- needed for The Skyhorn Tribe of Ain't No Mountain High Enough
G[39426]={510059}	-- needed for The Bloodtotem Tribe of Ain't No Mountain High Enough
G[39487]={510059}	-- needed for The Rivermane Tribe of Ain't No Mountain High Enough
G[39579]={510059}	-- needed for Secrets of Highmountain of Ain't No Mountain High Enough
G[39597]={510790}	-- needed for The Trial of Might of Vrykul Story, Bro
G[39780]={510059}	-- needed for Battle of Snowblind Mesa of Ain't No Mountain High Enough
G[39800]={510790}	-- needed for Greymane's Gambit part of Vrykul Story, Bro
G[39801]={510790}	-- needed for Greymane's Gambit of Vrykul Story, Bro
G[39992]={510059}	-- needed for Huln's War of Ain't No Mountain High Enough
G[40573]={510698}	-- needed for Archdruid of the Vale part of That's 'Val'sharah Folks!
G[40794]={510763}	-- needed for Mak'rana and the Fate of the Queen's Reprisal part of Azsuna Matata
G[42244]={510763}	-- needed for Mak'rana and the Fate of the Queen's Reprisal part of Azsuna Matata
G[42756]={510763}	-- needed for Defending Azurewing Repose part of Azsuna Matata
end

Grail.questsLoremaster = {}

-- TODO: Need to delay this until after combat

-- Now create Grail.achievements by combining Grail.loremasterAchievements and Grail.extraAchievements
Grail.achievements = {}
for _, faction in pairs({'Alliance','Horde'}) do
	Grail.achievements[faction] = {}
	for index, table in pairs(Grail.loremasterAchievements[faction]) do
		Grail.achievements[faction][index] = Grail:_TableAppend({}, table)
	end
	for index, table in pairs(Grail.extraAchievements[faction]) do
		Grail.achievements[faction][index] = Grail:_TableAppend(Grail.achievements[faction][index], table)
	end
end

local debugStartTime = debugprofilestop()
for questId, achs in pairs(G) do
	if achs ~= nil then
		-- Add this quest to its achievements
		for _, achievementId in pairs(achs) do
			if achievementId < Grail.mapAreaBaseAchievement and achievementId > 0 then
				if nil == Grail.loremasterQuests[achievementId] then Grail.loremasterQuests[achievementId] = {} end
				if not Grail.experimental then
					if not tContains(Grail.loremasterQuests[achievementId], questId) then tinsert(Grail.loremasterQuests[achievementId], questId) end
				else
					Grail:_MarkQuestInDatabase(questId, Grail.loremasterQuests[achievementId])
				end
				Grail.questsLoremaster[questId] = achievementId
			else
				local _, title = GetAchievementInfo(achievementId - Grail.mapAreaBaseAchievement)
				Grail:AddQuestToMapArea(questId, achievementId, title)
			end
		end
	end
end

wipe(G)
G = nil
Grail.timings.AchievementsInternalConversion = debugprofilestop() - debugStartTime

-- Now we generate the contents of the Loremaster achievements for Pandaria by looking at the specific quests
-- that are required and add all the quests that are prerequisites for those.
debugStartTime = debugprofilestop()
local achievementsDone = {}
local achievementsToZoneMapping = { [506300] = 806, [506301] = 807, [506534] = 806, [506535] = 857, [506536] = 857, [506537] = 809, [506538] = 809, [506539] = 810, [506540] = 858, [508671] = 941, [508845] = 947, [508919] = 946, [508920] = 946, [508923] = 949, [508924] = 949, [508925] = 948, [508926] = 948, [508927] = 950, [508928] = 950, [509528] = 947, [509529] = 941, [509602] = 947, [509605] = 948, [509606] = 941, [509607] = 949, [509615] = 950, [509618] = 19, [509674] = 946, [510698] = 1018, [510763] = 1015, [510059] = 1024, [510790] = 1017, }
local expansions = { 6 }
if release >= 18505 then
	tinsert(expansions, 7)
end
if Grail.inLegion then
	tinsert(expansions, 8)
end
for _, faction in pairs({'Alliance', 'Horde'}) do
	for _, expansion in pairs(expansions) do
		for _, achievement in pairs(Grail.loremasterAchievements[faction][expansion]) do
			if not tContains(achievementsDone, achievement) then
				local newTable = {}
				for _, questId in pairs(Grail.indexedQuests[achievement]) do
					--	This check is made because processing of something earlier in the "master" list could result in a prerequisite being
					--	evaluated that occurs later in the "master" list and we do not want to add it and do more work than we need.
					if not tContains(newTable, questId) then
						tinsert(newTable, questId)
						local controlTable = { ["result"] = {}, ["preq"] = newTable, ["lastIndexUsed"] = 0, ["doMath"] = true }
						-- Get the entire list of prerequisites for questId and add them to newTable
						Grail._PreparePrerequisiteInfo(Grail:QuestPrerequisites(questId, true), controlTable)
					end
				end
				Grail.indexedQuests[achievement] = newTable
				Grail.loremasterQuests[achievementsToZoneMapping[achievement]] = newTable
				tinsert(achievementsDone, achievement)
			end
		end
	end
end
wipe(achievementsDone)
achievementsDone = nil
Grail.timings.AchievementsPandariaLoremaster = debugprofilestop() - debugStartTime

end
