-------------------------------------------------------------------------------
-- DungeonList ver.2.0
-- 日期: 2014-12-10
-- 作者: 独孤傲雪
-- 描述: 魔兽世界副本一句话攻略
-- 版权所有 (c) duowan.com
-------------------------------------------------------------------------------
local DWChat = LibStub('AceAddon-3.0'):GetAddon('DuowanChat')
local L = LibStub("AceLocale-3.0"):GetLocale("DuowanChat")
local MODNAME = "Gonglue"
local DungeonList = DWChat:NewModule(MODNAME, "AceHook-3.0", "AceEvent-3.0")
DungeonList.data = {};
DungeonList._DEBUG = false;

if (GetLocale() == "zhCN") then
	DungeonList.data = {
		["黑石岩窟"]	= {
			{name = "摧骨者罗姆欧格", text = "开Boss前清光附近小怪，被\"苦痛之链\"锁住时DPS第一时间打掉锁链，然后远离Boss"},
			{name = "暮光信使柯尔拉", text = "分三个人挡三道光线，身上的Debuff叠到80层时离开光线，Debuff一消失继续去挡。一定要打断Boss的恐惧技能。"},
			{name = "卡尔什·断钢", text = "当Boss有减伤Buff时，坦克将其拉到中央火圈处烫一下就立即拉出，Debuff最好保留一层为佳。"},
			{name = "如花", text = "控两小狗，直接Boss，注意及时解除恐惧。"},
			{name = "升腾者领主奥西迪斯", text = "一个远程DPS风筝三分身（冰DK、LR或冰法都可以风筝），别让他们靠近Boss。T只拉Boss，注意Boss换影子时重新风筝三分身。"},
		},
		["旋云之巅"]	= {
			{name = "大宰相埃尔坦", text = "躲好旋风，旋风收拢时从间隙中躲出（T也要躲，不然会被弹飞）。"},
			{name = "阿尔泰鲁斯", text = "所有人躲好旋风，分散站，如果你是逆风，跑到Boss的另一面就变成顺风。"},
			{name = "阿萨德", text = "分散站位，第一时间驱散\"静滞之握\"（跳起可避免）。Boss在地上画三角的时候所有人都要跑到三角力场里。"},
		},
		["潮汐王座"]	= {
			{name = "纳兹夏女士", text = "分散站位，躲好脚下的喷泉，第一时间打断\"震爆\"。第二阶段控制2个法系怪，杀近战，躲好旋风。"},
			{name = "指挥官乌尔索克", text = "坦克拉着Boss绕屋子走，躲开Boss砸地，不要待在黑圈里！加好被抓住的人。"},
			{name = "屈心魔哥尔萨", raiders = "p1阶段T把Boss背对人群，驱散好罩子，注意躲开地刺；p2阶段狠打被控制的人，不要呆在绿雾里。"},
			{name = "厄祖玛特", text = "p1阶段近战注意恐兽跳起后，躲开黑水；p2阶段T风筝血兽，DPS击杀工兵，注意躲开黑水；p3阶段全力输出章鱼。"},
		},
		["巨石之核"]	= {
			{name = "克伯鲁斯", text = "躲开红色水晶喷射，远程A掉水晶，Boss钻地后注意躲开粉尘区域，治疗注意驱散Debuff。"},
			{name = "岩皮", text = "地上出黑圈躲开，不然会被掉下来石头砸死。地上扬尘躲开，不然会被岩浆烫到。Boss放水晶风暴AOE时躲到石头后面。"},
			{name = "欧泽鲁克", text = "坦克拉好Boss背对人群，躲好扇形椎刺（地上起尘，Boss有读条）。Boss放法术反射时远程放DOT。然后Boss喊“感受大地之力”时，所有人迅速远离Boss。"},
			{name = "高阶女祭司艾苏尔", text = "将刷出的小怪引到重力井里。打断Boss的强力之握技能。Boss跑到祭坛上时会砸石头，地上会有灰尘显示石头落点，注意闪躲。"},
		},
		["格瑞姆巴托"]	= {
			{name = "乌比斯将军", text = "Boss盯人冲锋时要及时避开。坦克把Boss拉至背对人群，治疗注意刷掉坦克身上的流血效果。小怪杀掉，注意英雄模式紫色小怪控制好不要杀。"},
			{name = "铸炉之主索朗格斯", text = "三种随机形态。盾形态时Boss会向前方喷火，靠近Boss站位，及时跑Boss身后；剑形态时治疗加好，原地输出；锤形态时风筝Boss，躲开地上的火焰。"},
			{name = "达加·燃影者", text = "被火元素连线的人迅速远离火元素，同时所有DPS集火秒掉火元素。打龙时，龙会半屏喷火，注意跑到Boss的背后，不要站光圈里。"},
			{name = "埃鲁达克", text = "Boss对人放定身时驱散。Boss放暗影强风时，所有人躲到风眼里。强风完后，门口会刷两只小怪，分配好左右减速和击杀人员，必须在小怪跑进来开蛋之前击杀两个小怪。"},
		},
		["托维尔失落之城"]	= {
			{name = "胡辛姆将军", text = "远离陷阱，躲好十字冲击波，坦克要保持移动为DPS和治疗腾出站位空间。"},
			{name = "锁喉", text = "近战不要站在鳄鱼后面，远程分散站位，治疗尽量驱散毒液。DPS要帮忙清掉小鳄鱼，能减速的做好减速。躲好奥各的旋风斩。"},
			{name = "高阶预言者巴林姆", text = "P1躲开光柱，风筝火凤凰，治疗驱散瘟疫。P2速度Rush黑凤凰，灵魂碎片出现后，坦克将黑暗凤凰拉开，避免融合，灵魂碎片可以减速。"},
			{name = "希亚梅特", text = "杀小怪时优先杀仆从，杀三只后，Boss身上的偏斜之风就会不见，火力全开Rush掉Boss。注意躲好雷云。"},
		},
		["死亡矿井"]	= {
			{name = "格拉布托克", text = "开局狠打，别和坦克站一起。二阶段躲好转动的火墙，坦克拉小怪，其他人全力打Boss。"},
			{name = "赫利克斯·破甲", text = "中间的轨道不要站人，中炸弹的远离人群，躲开地上的炸弹。"},
			{name = "死神5000", text = "一个近战去下面开伐木机，用技能杀死火炉中出的火元素，千万不要让火元素上来！其他人在上面通道打Boss，躲开Boss的旋转爪子挠人，不躲必死！"},
			{name = "里普斯纳将军", text = "出小怪杀小怪，最后10%阶段放弃小怪全力输出Boss。"},
			{name = "\"船长\"曲奇", text = "Boss无仇恨，点地上的食物，躲开绿水全力输出，坏食物的debuff可以用好食物消除。"},
			{name = "梵妮莎·范克里夫", text = "闯关阶段：躲好地上的火，天上的冰，死了释放跑本。Boss战：打好小怪，Boss烧船时，点船旁边的绳子逃避爆炸。"},
		},
		["影牙城堡"]	= {
			{name = "埃什博瑞男爵", text = "p1分配一人打断单体抓人技能，群体抓人时所有人空血后，注意要让Boss的死亡缓刑爆1下再打断，p2黑暗大天使时全力输出。"},
			{name = "席瓦莱恩男爵", text = "集火杀Boss，坦克拉好召唤的小怪，治疗注意驱散诅咒。"},
			{name = "指挥官斯普林瓦尔", text = "可风筝到1号Boss后的喷泉广场杀掉,先杀小怪，近战躲开亵渎和Boss的喷吐（此Boss可跳过）。"},
			{name = "沃登勋爵", text = "分散站位，躲开地上的冰圈。绿毒时要保持移动，红毒时全力输出（不要移动）。"},
			{name = "高弗雷勋爵", text = "驱散好诅咒，否则必死。漫天弹幕时跑开（千万别上高台），食尸鬼不用理会，坦克拉好即可。"},
		},
		["起源大厅"]	= {
			{name = "神殿守护者安努尔", text = "Boss无敌时，左右各安排两人下台阶，一人引蛇一人开机关，注意脚底下的蓝火。"},
			{name = "地怒者塔赫", text = "坦克拉Boss背对人群，其他人不要站正面。躲开地上的土圈。"},
			{name = "安拉斐特", text = "第一时间离开地上的黑圈，DPS全开！"},
			{name = "伊希斯特", text = "出小怪近战帮助打一下，Boss放闪光弹时背对之，Boss分身只需集火打掉一个即可。"},
			{name = "阿穆纳伊", text = "驱散枯萎，出花苞必须及时打，否则变成大花后压力很大。"},
			{name = "塞特斯", text = "Boss无仇恨，注意打好混沌之门，杀掉浮蛇，控制守卫后，全力输出Boss。"},
			{name = "拉夏", text = "打断一切可以打断的技能（可读条即可打断），太阳祝福时所有技能全开击杀Boss。"},
		},
		["祖阿曼"] = {
			{name = "埃基尔松", text = "出白鹰抓人时杀掉白鹰，出电荷风暴时躲到云下。"},
			{name = "纳洛拉克", text = "人形态会冲锋最远距离目标三次，安排好顺序轮流吃，熊形态会沉默，加好坦克。"},
			{name = "加亚莱", text = "第一波小怪，杀左放右，让他去孵化右边的小龙鹰，A掉。躲好线性火墙和地上出现的球形炸弹。"},
			{name = "哈尔拉兹", text = "Boss会召唤水之图腾、小山猫、闪电图腾，坦克立即把BOSS拉离水之图腾范围，其他人水图腾中回蓝，T不用管小山猫，治疗奶好就行，这里不缺蓝。闪电图腾必须第一时间打掉。"},
			{name = "妖术领主", text = "控制好boss身边的两只小怪，不能控制的话优先击杀。boss吸取灵魂模拟玩家技能时，注意驱散他身上的回血buff，同时躲好他模拟的AOE技能，如火雨、奉献等。"},
			{name = "达卡拉", text = "系统随机从熊-山鹰/山猫-龙鹰的组合中选取一种。熊：会有三次冲锋以及熊形态的切换，麻痹技能要驱散。猫：随机点名的连续撕咬，注意自保，坦克可嘲讽。山鹰：法系自保，物理dps猛抽。龙鹰：躲开火圈和火柱，rush掉。"},
		},
		["祖尔格拉布"] = {
			{name = "小怪技巧", text = "多吃冰锅，打小怪很省心，小怪附近有锅的都去吃，冰锅加伤害毒锅减毒伤害"},
			{name = "毒蛇（高阶祭司温诺西斯）", text = "第一阶段坦克记得把BOSS背对人群，喷吐时候坦克也要躲开，时刻注意好脚下的毒，最好提前移动；毒连线要快速跑远（远离中毒的另外一个）"},
			{name = "血領主（血领主曼多基尔）", text = "往死里打，死了npc会复活你，不做成就的话第一时间打复活的迅猛龙"},
			{name = "考古隐藏boss", text = "随机boss，和老版本一样，狂暴的需要解缠绕和风筝，梦境的要第一时间aoe"},
			{name = "豹女（高阶祭司基尔娜拉）", text = "四个笼子的小豹，一个一个开笼子拉住aoe掉再打boss"},
			{name = "赞吉尔", text = "毒全部人都要吃毒锅，冰推荐让移动能力强的职业吃比如猎人术士，大胖子要第一时间打,出僵尸群坦克吃火锅去烧 "},
			{name = "金度", text = "第一阶段boss拉到罩子外面，aoe之前全部人都要进去，第二阶段全部人站在链子附近吸引胖子撞过来，被胖子点名的人跑去和锁链重叠，鬼魂最好2个dps打（远程近战都可以），锁链一个dps打就可以了，保护好治疗，不要贪dps，打鬼魂第一位"},
		},
		["时光之末"] = {
			{name = "贝恩的残影", text = "分散站位，被击飞后迅速游上岸，捡BOSS投掷过来的图腾然后扔回去。"},
			{name = "吉安娜的残影", text = "收集16个碎片后珍娜才会出现，注意打断寒冰箭，躲避寒冰之刃，BOSS丢光核后，迅速跑过去踩爆。"},
			{name = "希尔瓦娜斯的残影", text = "BOSS召唤食尸鬼后，标记其中一个，迅速将其击杀，然后逃出食尸鬼的包围圈。"},
			{name = "泰兰德的残影", text = "只有将小怪拉到光柱下才能击杀，躲好月能枪，注意打断“星尘”施法技能，最后注意躲避天上掉下来的露恩之泪。"},
			{name = "姆诺兹多", text = "战斗开始后DPS职业开启所有大技能对BOSS输出，躲避地上的扭曲炸弹，英勇/嗜血结束后点击中间的沙漏开启倒转时间功能，然后再次开启所有大技能对BOSS输出。"},
		},
		["永恒之井"] = {
			{name = "佩罗萨恩", text = "躲地上的火焰，玩家中了魔化腐朽后，治疗不要轻易刷血，否则会受到反伤。BOSS小时候，尽可能的躲避眼睛的追捕。"},
			{name = "艾萨拉女王", text = "迅速击杀被激活的NPC，躲避地上的蓝色火焰，注意打断BOSS的大招。"},
			{name = "玛诺洛斯与瓦罗森", text = "坦克拉住瓦罗森和小怪即可，马诺洛斯交个伊利丹。躲好地上的绿色火焰，击杀瓦罗森后再打马诺洛斯。"},
		},
		["暮光审判"] = {
			{name = "阿奎里恩", text = "注意躲避天上掉下来的巨石，BOSS血量降到30%后，开启所有大技能尽全力输出。"},
			{name = "埃希拉•黎明克星", text = "BOSS施放烟雾弹后，坦克迅速将BOSS拉出烟雾弹的范围，dps和治疗尽量在图腾范围内站位。"},
			{name = "大主教本尼迪塔斯", text = "注意躲避地上的净化圣光和腐败暮光，跑到水盾后面躲避道德之波，净化冲击和暮光冲击出现后，迅速走开。"},
		},
		["巨龙之魂"] = {
			{name = "莫卓克", text = "坦克五层要换坦，被水晶连线的人要马上跑去水晶那里集合分担伤害，BOSS拉人后要迅速跑到石头背后躲避黑水。"},
			{name = "督军佐诺兹", text = {"BOSS必须背对人群，安排（最好指定）多个玩家一起撞击黑球8次左右，当BOSS身上的集中怒火叠加到8层左右，坦克必须调整位置，让BOSS撞击黑球；", "治疗（暗牧也可以协助）注意驱散魔法“干扰之影”，黑水阶段要集中集中站位用力刷血，DPS职业开大技能用力输出。"}},
			{name = "不眠的约萨希", text = {"集中火力击杀BOSS召唤出来的软泥，优先击杀顺序：紫>绿>黄>蓝>红>黑。绿色软泥合体后，分散站位，其他颜色合体集中站位用力刷血即可；", "如果出蓝色球，远程集火第一时间打掉；如果出小怪，人群集中快速aoe掉，务必在软泥出现之前aoe完。"}},
			{name = "哈格拉", text = {"BOSS施放集中攻击技能时，坦克稍微后退几步躲避伤害。闪电风暴阶段，人群集中，在水晶导体附近击杀元素后，给团长或者坦克标记，全团跟着一起沿边缘跑动传导闪电（建议顺时针），摧毁水晶导体；", "寒冰暴雨阶段，给团长或者坦克标记，全团跟着沿边缘跑（建议顺时针），在躲避寒冰之潮和冰锥的同时，（主要靠远程）迅速打掉场边的四根水晶。"}},
			{name = "奥卓克希昂", text = {"全团平台上集中站位，黯淡之光点名后就换坦，每次BOSS施放\"暮光审判\"技能时，当前坦开技能硬抗；", "其他人在倒计时3秒左右使用英勇意志（屏幕中央偏下方的紫色按键）来躲避伤害。", "PC丢在地上的红、绿、蓝球，安排治疗和DPS拾取，可以获得很好的BUFF。"}},
			{name = "战争大师黑角", text = {"船上的近战小怪坦克一人拉一个一共两个，小漩涡要躲，大漩涡要全团迅速跑到上面分摊伤害，远程优先击杀船两侧的暮光龙，近战打船上小怪；", "P2所有人注意躲黑圈，法系和治疗不要靠近BOSS，否则容易打断治疗导致倒坦。冲击波观察好方向就很好躲。"}},
			{name = "死亡之翼的背脊", text = {"触须只打一个就行了，打掉后刷新熔合体，坦克拉住带到盔甲附近，小软泥另外一个坦克拉住带到融合体附近，全团dps打融合体到400万血；", "注意不要用aoe技能打到软泥，融合体到400万血开始aoe，把小软泥aoe掉；拉融合体的坦克注意观察debuff层数，9层通知dps打掉；", "打掉后会爆炸，所有人记得跑开，然后重复前面的步骤，直到炸掉三块盔甲即结束。"}},
			{name = "疯狂的死亡之翼", text = {"面对大漩涡，正面会刷新爪子，很快背后会刷新触须，打了一会触须后会刷新源质箭，击杀优先顺序是源质箭>触须>爪子；", "爪子打掉后往左边平台跳继续刚才的顺序打，一直到最后一个平台打完后全部人最快速度回到第一个平台，全部打掉后打之翼本体，打完结束。"}},
		},
		["青龙寺"] = {
			{name = "贤者马里", text = {"第一阶段优先击杀腐化之水，并躲开腐化之水留下来的残渣，别长时间停留在堕落之水中。", "第二阶段在躲避BOSS的喷涌的同时进行输出。"}},
			{name = "游学者石步", text = "如果碰到的是野牛人的试炼，当其中的一个BOSS的强烈buff叠加到10层后，迅速切换目标攻击另一个BOSS。如果是射日勇士，迅速击杀天上的太阳和地上的恶煞，然后干掉BOSS。"},
			{name = "刘·焰心", text = "治疗注意驱散坦克身上的Debuff，所有人注意躲避红色和青色的火焰波。BOSS的血量到30%后就会召唤青龙，这时注意躲避地上的火焰，然后迅速击杀青龙即可。"},
			{name = "疑之煞", text = "治疗注意驱散虚无之触，BOSS施放猜忌幻镜后，DPS优先击杀治疗的臆像，然后逐个干掉剩下的臆像。臆像不能被嘲讽，所以不要乱跑。"},
		},
		["风暴烈酒酿造厂"] = {
			{name = "乌克乌克", text = "注意躲避BOSS正面的震地攻击，每次酒桶一出现，DPS一定要控制酒桶去撞击BOSS，每撞击一次能让BOSS受到的伤害提高10%，效果可以叠加。撞击10次左右基本就能完成击杀。"},
			{name = "跳跳大王", text = "BOSS旋转和喷吐胡萝卜的时候，所有人都注意躲开。优先击杀跳舞兔，然后拾取它掉在地上的大棒槌，使用特殊技能迅速干掉周围的小怪。"},
			{name = "破桶而出的炎诛", text = "中了“膨胀”后注意转动方向，保证自己的左右两边没有队友。迅速击杀小怪，不然会恢复boss的血量。碳酸饱和出现后，点击水泡漂浮到上空。幻灭酒雾出现后，保持移动或跳跃。泡沫之墙出现后注意躲避。"},
		},
		["围攻砮皂寺"] = {
			{name = "宰相金巴卡", text = "轮流去踩毒液缩小它的面积，降低BOSS引爆的伤害，治疗注意照看踩毒液的玩家血量，远程DPS迅速转目标击杀小软泥。"},
			{name = "指挥官沃加克", text = "将焦油桶扔向虫群，远程优先击杀毁灭者让其自爆，注意躲开琥珀飞翼的高空轰炸。BOSS战时，将焦油桶丢向BOSS，让其debuff叠高，战斗中注意躲好冲刺打击和千刃。"},
			{name = "将军帕克拉克", text = "注意躲好BOSS的利刃冲锋和空中丢下来的炸药，BOSS躲进壁垒时，坦克将小怪拉到BOSS身边，其他人将炸药投向BOSS，叠加易伤debuff的同时炸死小怪。"},
			{name = "首领尼诺洛克", text = "躲开地上的粘稠沥青，中了加热的树脂后可以通过跳跃来移除该效果，BOSS施放尘风时，使用快速移动技能到桥的另外一边，打断它。"},
		},
		["影踪禅院"] = {
			{name = "古·穿云", text = "P1注意躲开地上的“静电力场”，P2直接去打天上的龙，P3直接开大技能rush。玩家中了“磁力帷幕”后，治疗直接将其刷爆。"},
			{name = "雪流大师", text = "P1坦克和近战注意躲避“怒雷破”，BOSS施放此技能时不会移动。P2打掉两个假身，然后对真身输出。P3阶段BOSS进入招架姿态后立即停手。"},
			{name = "狂之煞", text = "治疗注意驱散坦克身上的魔法效果，击杀小怪或者躲避小怪的自爆，BOSS激怒后使用特殊技能将其驱散，坦克注意使用防御技能。"},
			{name = "祝踏岚", text = "仇恨值高的时候使用冥思技能将其清除，注意打断BOSS的渐燃之恨技能，优先击杀怨恨畸体，躲避地上的怨恨之环。"},
		},
		["魔古山宫殿"] = {
			{name = "国王的试炼", text = {"库乌艾：坦克将BOSS背对人群，躲好震荡波，拉好穆辛巴，治疗刷好穆辛巴的毁灭目标。", "明谷子：躲开回旋风暴和磁场，打断好闪电箭。", "哈伊岩：施放流星时集中分担伤害或者远远的躲开，施放燃烧时分散。"}},
			{name = "杰翰", text = "坦克拉好四只小怪，优先击杀神谕师和铁皮战士，再击杀其他两种小怪，最后击杀BOSS。"},
			{name = "武器大师席恩", text = "坦克让BOSS背对人群，BOSS施放地面猛击时，离开BOSS正面躲避。所有人都要躲好烈焰之环、旋风之斧、利刃陷阱。"},
		},
		["残阳关"] = {
			{name = "吉普提拉克", text = "注意永远不要和稳定的军火站在一条线上。"},
			{name = "突袭者加杜卡", text = "躲开地上的火焰（扫射），躲开地上的酸液炸弹，治疗和DPS注意跟着坦克集中。"},
			{name = "指挥官瑞魔克", text = "躲开地上的流毒物质，在BOSS施放狂乱攻击的时候，不要站在BOSS正面。"},
			{name = "莱公", text = {"第一阶段：坦克拉好小怪，DPS在BOSS撞墙之前跳上边上的炮台，跳到BOSS头部，攻击BOSS的弱点，注意撞墙之前一定要下来。", "第二阶段：被BOSS凝视的玩家注意远离BOSS，其他人全力RUSH BOSS。"}},
		},
		["血色修道院"] = {
			{name = "裂魂者萨尔诺斯", text = "注意打断灵魂强风，如果没打断，注意躲开，坦克拉好小怪，迅速A掉。"},
			{name = "科洛夫修士", text = "躲好正面的炙炎拳，火焰风暴踢时近战让开，躲好地上的火焰（炙灼之土）。"},
			{name = "怀特迈恩", text = "第一阶段，躲好冲刺打击。第二阶段，优先打断怀特迈恩的群体复活技能，击杀怀特迈恩。"},
		},
		["血色大厅"] = {
			{name = "驯犬者布兰恩", text = "远程注意分散站位，坦克拉好召唤出来的狗，BOSS血量高于50%之前把狗先干掉，等血量降低50%后坦克拉好狗，DPS全力攻击BOSS。"},
			{name = "武器大师哈兰", text = "坦克将BOSS拉好背对人群，并拉好召唤的小怪，BOSS跳到场中间施放光明之刃时，注意闪开别被光明之刃带进去。"},
			{name = "织焰者孔格勒", text = "躲开焚烧书籍的火焰，BOSS施放巨龙之息的时绕着BOSS躲开巨龙之息，打断职业及时打断BOSS的连珠火球和炎爆术。"},
		},
		["通灵学院"] = {
			{name = "指导者寒心", text = {"第一阶段，在冰墙合拢之前击杀BOSS，分散站的时候不要碰到冰墙，冰墙会从前后两个方向往BOSS方向压过来，要尽快把BOSS打入第二阶段。", "第二阶段，全力击杀护命匣，远程分散站开。"}},
			{name = "詹迪斯·巴罗夫", text = "坦克将BOSS背对人群，施放奇能迅击时，远离BOSS正面，BOSS施放扭曲幻象时，迅速击杀分身，寻找真身，找到后坦克迅速接住BOSS，重复循环此过程。"},
			{name = "血肉傀儡", text = "躲开灵魂烈焰，玩家可以在周围地上找到骨堆，点击骨堆获得骨甲术效果然后去打BOSS，坦克在BOSS生锈效果达到10层以上时，风筝BOSS，直到生锈效果消失。"},
			{name = "莉莉安·沃斯", text = {"第一阶段，远程分散站位，BOSS施放死亡之握之后，注意分散跑起来，直到黯焰效果结束。", "第二阶段，被凝视的玩家远离BOSS绕着场地跑，如果BOSS击中玩家施放黯焰，其他人保持移动，躲开黯焰。", "第三阶段，注意躲开黯焰、被凝视的玩家注意跑，此阶段只是重复第一第二的打法，场面会比较混乱治疗注意加好。"}},
		},
		["恐惧之心"] = {
			{name = "皇家宰相佐尔洛克", text = "躲好音波圈，进入光罩内降低AOE伤害，迅速将被控制的玩家打醒。玩家被连线后，坦克去分档一下伤害。"},
			{name = "刀锋领主塔亚克", text = {"P1躲好地上的龙卷风，BOSS消失后集中站位分档致命的伤害。", "P2全团风骚跑位，向BOSS前进的同时，左右躲避移动的龙卷风。"}},
			{name = "加拉隆", text = "不要站在BOSS底部的紫圈内，躲好地上的黄水。远程打BOSS的身体，近战打BOSS的腿，坦克或其他远程带着BOSS移动跑位。"},
		},
		["奥金顿"] = {
			{ ["name"] = "警戒者凯萨尔", ["text"] = "躲在BOSS扔出的盾牌后面，避免全图AOE.",},
			{ ["name"] = "缚魂者尼娅米", ["text"] = "注意打断，躲在BOSS的漩涡中间.",},
			{ ["name"] = "阿扎凯尔", ["text"] = "迅速击杀BOSS转阶段小怪，大个子小鬼>大恶魔>小鬼.",},
			{ ["name"] = "塔隆戈尔", ["text"] = "分散站位，远程风筝好地狱火，不用击杀，吃任何控制.",},
		},
		["影月墓地"] = {
			{ ["name"] = "莎达娜·血怒", ["text"] = "躲好天上掉下的剑，BOSS放AOE，吃地上的白圈.",},
			{ ["name"] = "纳利什", ["text"] = "打好自己的幻影，打完之后记得点一下.",},
			{ ["name"] = "骨喉", ["text"] = "注意BOSS吸气，开加速第一时间跑开，如果不幸被吃掉入水中，请点水泡上来.",},
			{ ["name"] = "耐奥祖", ["text"] = "全队集火迅速解决尸墙中的其中一只小怪.",},
		},
		["恐轨车站"] = {
			{ ["name"] = "箭火和波尔卡", ["name1"] = "箭火", ["name2"] = "波尔卡", ["text"] = "坦克注意调整大个子体位，地精AOE的时候，大个子可以把地精从箱子上撞下来。尽量两个BOSS同时死，先杀大个子.",},
			{ ["name"] = "尼托格·雷塔", ["text"] = "背上背着炮筒的小怪，死亡后点击，会随机获得上炮台或者扔手榴弹的BUFF，炮台1号键亮了是打小怪技能，2号键亮了是打BOSS技能.",},
			{ ["name"] = "啸天者托瓦拉", ["text"] = "注意躲开地上的雷电以及冰冻陷阱.",},
		},
		["永茂林地"] = {
			{ ["name"] = "枯木", ["text"] = "BOSS拉到墙边离水最远的地方，强行rush.",},
			{ ["name"] = "远古的保卫者", ["name1"] = "高拉", ["name2"] = "特鲁", ["name3"] = "杜尔胡", ["text"] = "先击杀蓝色BOSS，打断好活力之水，注意进攻驱散.",},
			{ ["name"] = "大法师索尔", ["text"] = "第一时间打好小怪，不要站在毒圈里.",},
			{ ["name"] = "艾里塔克", ["text"] = "打断好寄生增长，烈焰火环跳起来可以避免伤害.",},
			{ ["name"] = "雅努", ["text"] = "第一时间打掉缠藤，地上出小花的时候，全团分散踩光(还可拿到成就).",},
		},
		["血槌炉渣矿井"] = {
			{ ["name"] = "玛格莫拉图斯", ["text"] = "躲开正面AOE，注意打断凶猛咆哮，第一时间击杀小怪，矿工.",},
			{ ["name"] = "守奴人库鲁斯托", ["text"] = "第一时间击杀所有BOSS召唤出的小怪.",},
			{ ["name"] = "罗托尔", ["text"] = "躲好石头，因为是来回两次，注意记好掉落顺序.",},
			{ ["name"] = "戈洛克", ["text"] = "打断好熔岩爆裂，第一时间击杀小怪.",},
		},
		["通天峰"] = {
			{ ["name"] = "兰吉特", ["text"] = "跟随风的方向.",},
			{ ["name"] = "阿拉卡纳斯", ["text"] = "注意挡好黄线.",},
			{ ["name"] = "鲁克兰", ["text"] = "BOSS飞羽AOE，躲到柱子后面，击杀小怪要挑地面上没有残骸的地方。后期可以控制风筝小怪，强行RUSH boss.",},
			{ ["name"] = "高阶贤者维里克斯", ["text"] = "第一时间击杀所有小怪，放好火线.",},
		},
		["钢铁码头"] = {
			{ ["name"] = "血肉撕裂者诺格加尔", ["text"] = "BOSS身上有球的时候注意停手.",},
			{ ["name"] = "恐轨押运员", ["text"] = "先打女兽人，如果女兽人身上有鲜血之球，注意转换其他目标，不然打破球，BOSS会回血.",},
			{ ["name"] = "奥舍尔", ["text"] = "第一时间打好小怪，BOSS扑到人的时候，法师骑士可以冰箱无敌，其他人需要第一时间集火BOSS，否则回血.",},
			{ ["name"] = "斯古洛克", ["text"] = "第一时间rush掉兽人，BOSS击飞后找好掩体，在间歇时间冲上去，盗贼，骑士可开斗篷或者无敌强行冲上去，打一下BOSS，AOE结束.",},
		},
		["黑石塔上层"] = {
			{ ["name"] = "折铁者高尔山", ["text"] = "优先移速快，减伤高的职业下去开能量导管.",},
			{ ["name"] = "奇拉克", ["text"] = "先击杀两只小龙兽，注意脚下绿水.",},
			{ ["name"] = "指挥官萨贝克", ["text"] = "优先击杀奇美拉，躲好飞刀，全力打BOSS，小怪坦克拉到蓝龙面向，喷掉.",},
			{ ["name"] = "狂野的怒翼", ["text"] = "尽量中间站位，第一时间躲好BOSS喷火，迅速清理小怪.",},
			{ ["name"] = "督军扎伊拉", ["text"] = "躲好旋风斩，第一时间快速清理小怪，注意观察龙喷火的位置.",},
		},
		["悬槌堡"] = {
			{ ["name"] = "卡加斯•刃拳", ["text"] = "坦克注意穿刺2层换T,有debuff的坦克在击飞人群后站在BOSS脚下就行.DPS注意躲火柱,远程被点名冲锋时把BOSS带到火柱。治疗注意给被火柱烧到的人加血。.",},
			{ ["name"] = "屠夫", ["text"] = "坦克注意正常2-3层换T.DPS吃到BOSS旋风斩注意debuff层数,7-8层就赶紧离开BOSS消debuff,达到10层会被秒杀（随机模式）.治疗注意BOSS唯一的高伤害是冲锋跳劈,保证满血就行。.",},
			{ ["name"] = "布兰肯斯波", ["text"] = "坦克注意DEBUFF7-10层换T,DPS注意有小怪打小怪,没小怪杀BOSS,打断真菌食肉者的AOE读条.治疗有蘑菇就把蘑菇奶起来.其他时间刷血就行。",},
		},
	};
elseif (GetLocale() == "zhTW") then
	DungeonList.data = {
		["黑石洞穴"]	= {
			{name = "羅姆歐格•裂骨者", text = "開Boss前清光附近小怪，被\"苦痛之鏈\"鎖住時DPS第一時間打掉鎖鏈，然後遠離Boss"},
			{name = "暮光信使柯爾拉", text = "分三個人擋三道光線，身上的Debuff疊到80層時離開光線，Debuff一消失繼續去擋。一定要打斷Boss的恐懼技能。"},
			{name = "卡爾許•控鋼者", text = "當Boss有減傷Buff時，坦克將其拉到中央火圈處燙一下就立即拉出，Debuff最好保留一層為佳。"},
			{name = "美麗", text = "控兩小狗，直接Boss，注意及時解除恐懼。"},
			{name = "卓越者統領奧希迪厄斯", text = "一個遠端DPS風箏三分身（冰DK、LR或冰法都可以風箏），別讓他們靠近Boss。T只拉Boss，注意Boss換影子時重新風箏三分身。"},
		},
		["漩渦尖塔"]	= {
			{name = "首相伊爾丹", text = "躲好旋風，旋風收攏時從間隙中躲出（T也要躲，不然會被彈飛）。"},
			{name = "艾塔伊洛斯", text = "所有人躲好旋風，分散站，如果你是逆風，跑到Boss的另一面就變成順風。"},
			{name = "亞沙德", text = "分散站位，第一時間驅散\"靜滯之握\"（跳起可避免）。Boss在地上畫三角的時候所有人都要跑到三角力場裡。"},
		},
		["海潮王座"]	= {
			{name = "納茲賈爾女士", text = "分散站位，躲好腳下的噴泉，第一時間打斷\"震爆\"。第二階段控制2個法系怪，殺近戰，躲好旋風。"},
			{name = "指揮官烏索克", text = "坦克拉著Boss繞屋子走，躲開Boss砸地，不要待在黑圈裡！加好被抓住的人。"},
			{name = "屈心魔哥爾薩", raiders = "p1階段T把Boss背對人群，驅散好罩子，注意躲開地刺；p2階段狠打被控制的人，不要呆在綠霧裡。"},
			{name = "歐蘇瑪特", text = "p1階段近戰注意恐獸跳起後，躲開黑水；p2階段T風箏血獸，DPS擊殺工兵，注意躲開黑水；p3階段全力輸出章魚。"},
		},
		["石岩之心"]	= {
			{name = "寇伯拉斯", text = "躲開紅色水晶噴射，遠程A掉水晶，Boss鑽地後注意躲開粉塵區域，治療注意驅散Debuff。"},
			{name = "岩革", text = "地上出黑圈躲開，不然會被掉下來石頭砸死。地上揚塵躲開，不然會被岩漿燙到。Boss放水晶風暴AOE時躲到石頭後面。"},
			{name = "歐茲魯克", text = "坦克拉好Boss背對人群，躲好扇形椎刺（地上起塵，Boss有讀條）。Boss放法術反射時遠程放DOT。然後Boss喊“感受大地之力”時，所有人迅速遠離Boss。"},
			{name = "高階祭司艾吉兒", text = "將刷出的小怪引到重力井裡。打斷Boss的強力之握技能。Boss跑到祭壇上時會砸石頭，地上會有灰塵顯示石頭落點，注意閃躲。"},
		},
		["格瑞姆巴托"]	= {
			{name = "昂布里斯將軍", text = "Boss盯人衝鋒時要及時避開。坦克把Boss拉至背對人群，治療注意刷掉坦克身上的流血效果。小怪殺掉，注意英雄模式紫色小怪控制好不要殺。"},
			{name = "鍛造大師瑟隆葛斯", text = "三種隨機形態。盾形態時Boss會向前方噴火，靠近Boss站位，及時跑Boss身後；劍形態時治療加好，原地輸出；錘形態時風箏Boss，躲開地上的火焰。"},
			{name = "德拉卡•燃影者", text = "被火元素連線的人迅速遠離火元素，同時所有DPS集火秒掉火元素。打龍時，龍會半屏噴火，注意跑到Boss的背後，不要站光圈裡。"},
			{name = "伊魯達克斯", text = "Boss對人放定身時驅散。Boss放暗影強風時，所有人躲到風眼裡。強風完後，門口會刷兩隻小怪，分配好左右減速和擊殺人員，必須在小怪跑進來開蛋之前擊殺兩個小怪。"},
		},
		["托維爾的失落之城"]	= {
			{name = "胡薩姆將軍", text = "遠離陷阱，躲好十字衝擊波，坦克要保持移動為DPS和治療騰出站位空間。"},
			{name = "鎖喉", text = "近戰不要站在鱷魚後面，遠端分散站位，治療儘量驅散毒液。DPS要幫忙清掉小鱷魚，能減速的做好減速。躲好奧各的旋風斬。"},
			{name = "高階預言者巴瑞姆", text = "P1躲開光柱，風箏火鳳凰，治療驅散瘟疫。P2速度Rush黑鳳凰，靈魂碎片出現後，坦克將黑暗鳳凰拉開，避免融合，靈魂碎片可以減速。"},
			{name = "希亞梅特", text = "殺小怪時優先殺僕從，殺三隻後，Boss身上的偏斜之風就會不見，火力全開Rush掉Boss。注意躲好雷雲。"},
		},
		["死亡礦坑"]	= {
			{name = "格魯巴托克", text = "開局狠打，別和坦克站一起。二階段躲好轉動的火牆，坦克拉小怪，其他人全力打Boss。"},
			{name = "赫利克斯•破輪者", text = "中間的軌道不要站人，中炸彈的遠離人群，躲開地上的炸彈。"},
			{name = "敵人收割者5000", text = "一個近戰去下面開伐木機，用技能殺死火爐中出的火元素，千萬不要讓火元素上來！其他人在上面通道打Boss，躲開Boss的旋轉爪子撓人，不躲必死！"},
			{name = "利普斯納爾上將", text = "出小怪殺小怪，最後10%階段放棄小怪全力輸出Boss。"},
			{name = "『船長』餅乾", text = "Boss無仇恨，點地上的食物，躲開綠水全力輸出，壞食物的debuff可以用好食物消除。"},
			{name = "凡妮莎•范克里夫", text = "闖關階段：躲好地上的火，天上的冰，死了釋放跑本。Boss戰：打好小怪，Boss燒船時，點船旁邊的繩子逃避爆炸。"},
		},
		["影牙城堡"]	= {
			{name = "艾胥柏利男爵", text = "p1分配一人打斷單體抓人技能，群體抓人時所有人空血後，注意要讓Boss的死亡緩刑爆1下再打斷，p2黑暗大天使時全力輸出。"},
			{name = "席瓦萊恩男爵", text = "集火殺Boss，坦克拉好召喚的小怪，治療注意驅散詛咒。"},
			{name = "指揮官斯普林瓦爾", text = "可風箏到1號Boss後的噴泉廣場殺掉,先殺小怪，近戰躲開褻瀆和Boss的噴吐（此Boss可跳過）。"},
			{name = "瓦爾登領主", text = "分散站位，躲開地上的冰圈。綠毒時要保持移動，紅毒時全力輸出（不要移動）。"},
			{name = "高弗雷領主", text = "驅散好詛咒，否則必死。漫天彈幕時跑開（千萬別上高臺），食屍鬼不用理會，坦克拉好即可。"},
		},
		["起源大廳"]	= {
			{name = "神殿守護者安胡爾", text = "Boss無敵時，左右各安排兩人下臺階，一人引蛇一人開機關，注意腳底下的藍火。"},
			{name = "地怒者普塔", text = "坦克拉Boss背對人群，其他人不要站正面。躲開地上的土圈。"},
			{name = "安拉斐特", text = "第一時間離開地上的黑圈，DPS全開！"},
			{name = "伊希賽特", text = "出小怪近戰幫助打一下，Boss放閃光彈時背對之，Boss分身只需集火打掉一個即可。"},
			{name = "安姆內", text = "驅散枯萎，出花苞必須及時打，否則變成大花後壓力很大。"},
			{name = "塞特胥", text = "Boss無仇恨，注意打好混沌之門，殺掉浮蛇，控制守衛後，全力輸出Boss。"},
			{name = "拉頡", text = "打斷一切可以打斷的技能（可讀條即可打斷），太陽祝福時所有技能全開擊殺Boss。"},
		},
		["祖阿曼"] = {
			{name = "阿奇爾森", text = "出白鷹抓人時殺掉白鷹，出電荷風暴時躲到雲下。"},
			{name = "納羅拉克", text = "人形態會衝鋒最遠距離目標三次，安排好順序輪流吃，熊形態會沉默，加好坦克。"},
			{name = "賈納雷", text = "第一波小怪，殺左放右，讓他去孵化右邊的小龍鷹，A掉。躲好線性火牆和地上出現的球形炸彈。"},
			{name = "哈拉齊", text = "Boss會召喚水之圖騰、小山貓、閃電圖騰，坦克立即把BOSS拉離水之圖騰範圍，其他人水圖騰中回藍，T不用管小山貓，治療奶好就行，這裡不缺藍。閃電圖騰必須第一時間打掉。"},
			{name = "妖術領主", text = "控制好boss身邊的兩隻小怪，不能控制的話優先擊殺。boss吸取靈魂模擬玩家技能時，注意驅散他身上的回血buff，同時躲好他模擬的AOE技能，如火雨、奉獻等。"},
			{name = "達卡拉", text = "系統隨機從熊-山鷹/山貓-龍鷹的組合中選取一種。熊：會有三次衝鋒以及熊形態的切換，麻痹技能要驅散。貓：隨機點名的連續撕咬，注意自保，坦克可嘲諷。山鷹：法系自保，物理dps猛抽。龍鷹：躲開火圈和火柱，rush掉。"},
		},
		["祖爾格拉布"] = {
			{name = "小怪技巧", text = "多吃冰鍋，打小怪很省心，小怪附近有鍋的都去吃，冰鍋加傷害毒鍋減毒傷害"},
			{name = "毒蛇（高階祭司溫諾希斯）", text = "第一階段坦克記得把BOSS背對人群，噴吐時候坦克也要躲開，時刻注意好腳下的毒，最好提前移動；毒連線要快速跑遠（遠離中毒的另外一個）"},
			{name = "血領主（血領主曼多基爾）", text = "往死裡打，死了npc會復活你，不做成就的話第一時間打復活的迅猛龍"},
			{name = "考古隱藏boss", text = "隨機boss，和老版本一樣，狂暴的需要解纏繞和風箏，夢境的要第一時間aoe"},
			{name = "豹女（高階祭司基爾娜拉）", text = "四個籠子的小豹，一個一個開籠子拉住aoe掉再打boss"},
			{name = "贊吉爾", text = "毒全部人都要吃毒鍋，冰推薦讓移動能力強的職業吃比如獵人術士，大胖子要第一時間打,出僵屍群坦克吃火鍋去燒 "},
			{name = "破神者金度", text = "第一階段boss拉到罩子外面，aoe之前全部人都要進去，第二階段全部人站在鏈子附近吸引胖子撞過來，被胖子點名的人跑去和鎖鏈重疊，鬼魂最好2個dps打（遠端近戰都可以），鎖鏈一個dps打就可以了，保護好治療，不要貪dps，打鬼魂第一位"},
		},
		["终焉之刻"] = {
			{name = "貝恩的回音", text = "分散站位，被擊飛後迅速遊上岸，撿BOSS投擲過來的圖騰然後扔回去。"},
			{name = "珍娜的回音", text = "收集16個碎片後珍娜才會出現，注意打斷寒冰箭，躲避寒冰之刃，BOSS丟光核後，迅速跑過去踩爆。"},
			{name = "希瓦娜斯的回音", text = "BOSS召喚食屍鬼後，標記其中一個，迅速將其擊殺，然後逃出食屍鬼的包圍圈。"},
			{name = "泰蘭妲的回音", text = "只有將小怪拉到光柱下才能擊殺，躲好月能槍，注意打斷“星塵”施法技能，最後注意躲避天上掉下來的露恩之淚。"},
			{name = "姆多茲諾", text = "戰鬥開始後DPS職業開啟所有大技能對BOSS輸出，躲避地上的扭曲炸彈，英勇/嗜血結束後點擊中間的沙漏開啟倒轉時間功能，然後再次開啟所有大技能對BOSS輸出。"},
		},
		["永恆之井"] = {
			{name = "佩洛薩恩", text = "躲地上的火焰，玩家中了魔化腐朽後，治療不要輕易刷血，否則會受到反傷。BOSS小時候，盡可能的躲避眼睛的追捕。"},
			{name = "艾薩拉女王", text = "迅速擊殺被啟動的NPC，躲避地上的藍色火焰，注意打斷BOSS的大招。"},
			{name = "瑪諾洛斯", text = "坦克拉住瓦羅森和小怪即可，馬諾洛斯交個伊利丹。躲好地上的綠色火焰，擊殺瓦羅森後再打馬諾洛斯。"},
		},
		["暮光之時"] = {
			{name = "阿奇里森", text = "注意躲避天上掉下來的巨石，BOSS血量降到30%後，開啟所有大技能盡全力輸出。"},
			{name = "阿希拉黎明殺戮者", text = "BOSS施放煙霧彈後，坦克迅速將BOSS拉出煙霧彈的範圍，dps和治療儘量在圖騰範圍內站位。"},
			{name = "大主教本尼迪塔斯", text = "注意躲避地上的淨化聖光和腐敗暮光，跑到水盾後面躲避道德之波，淨化衝擊和暮光衝擊出現後，迅速走開。"},
		},
		["玉蛟寺"] = {
			{name = "贤者马里", text = {"第壹階段優先擊殺腐化之水，並躲開腐化之水留下來的殘渣，別長時間停留在墮落之水中。", "第二階段在躲避BOSS的噴湧的同時進行輸出。"}},
			{name = "博學行者石步", text = {"如果碰到的是野牛人的試煉，當其中的壹個BOSS的強烈buff疊加到10層後，迅速切換目標攻擊另壹個BOSS。", "如果是射日勇士，迅速擊殺天上的太陽和地上的惡煞，然後幹掉BOSS。"}},
			{name = "劉·焰心", text = "治療注意驅散坦克身上的Debuff，所有人注意躲避紅色和青色的火焰波。BOSS的血量到30%後就會召喚青龍，這時注意躲避地上的火焰，然後迅速擊殺青龍即可。"},
			{name = "疑惑之煞", text = "治療注意驅散虛無之觸，BOSS施放猜忌幻鏡後，DPS優先擊殺治療的臆像，然後逐個幹掉剩下的臆像。臆像不能被嘲諷，所以不要亂跑。"},
		},
		["風暴烈酒酒坊"] = {
			{name = "歐克·歐克", text = "注意躲避BOSS正面的震地攻擊，每次酒桶壹出現，DPS壹定要控制酒桶去撞擊BOSS，每撞擊壹次能讓BOSS受到的傷害提高10%，效果可以疊加。撞擊10次左右基本就能完成擊殺。"},
			{name = "跳跳巨兔妖", text = "BOSS旋轉和噴吐胡蘿蔔的時候，所有人都注意躲開。優先擊殺跳舞兔，然後拾取它掉在地上的大棒槌，使用特殊技能迅速幹掉周圍的小怪。"},
			{name = "-『破罈者』嚴祝", text = "中了“膨脹”後注意轉動方向，保證自己的左右兩邊沒有隊友。迅速擊殺小怪，不然會恢複boss的血量。碳酸飽和出現後，點擊水泡漂浮到上空。幻滅酒霧出現後，保持移動或跳躍。泡沫之牆出現後注意躲避。"},
		},
		["圍攻怒兆寺"] = {
			{name = "大臣金巴克", text = "輪流去踩毒液縮小它的面積，降低BOSS引爆的傷害，治療注意照看踩毒液的玩家血量，遠程DPS迅速轉目標擊殺小軟泥。"},
			{name = "指揮官沃賈克", text = "將焦油桶扔向蟲群，遠程優先擊殺毀滅者讓其自爆，注意躲開琥珀飛翼的高空轟炸。BOSS戰時，將焦油桶丟向BOSS，讓其debuff疊高，戰鬥中注意躲好沖刺打擊和千刃。"},
			{name = "帕伐拉克將軍", text = "注意躲好BOSS的利刃沖鋒和空中丟下來的炸藥，BOSS躲進壁壘時，坦克將小怪拉到BOSS身邊，其他人將炸藥投向BOSS，疊加易傷debuff的同時炸死小怪。"},
			{name = "飛翼領袖紐若納克", text = "躲開地上的粘稠瀝青，中了加熱的樹脂後可以通過跳躍來移除該效果，BOSS施放塵風時，使用快速移動技能到橋的另外壹邊，打斷它。"},
		},
		["影潘僧院"] = {
			{name = "古·雲擊", text = "P1注意躲開地上的“靜電力場”，P2直接去打天上的龍，P3直接開大技能rush。玩家中了“磁力帷幕”後，治療直接將其刷爆。"},
			{name = "雪迅大師", text = "P1坦克和近戰注意躲避“怒雷破”，BOSS施放此技能時不會移動。P2打掉兩個假身，然後對真身輸出。P3階段BOSS進入招架姿態後立即停手。"},
			{name = "暴力之煞", text = "治療注意驅散坦克身上的魔法效果，擊殺小怪或者躲避小怪的自爆，BOSS激怒後使用特殊技能將其驅散，坦克注意使用防禦技能。"},
			{name = "塔蘭·祝", text = "仇恨值高的時候使用冥思技能將其清除，注意打斷BOSS的漸燃之恨技能，優先擊殺怨恨畸體，躲避地上的怨恨之環。"},
		},
		["魔古山宮"] = {
			{name = "帝王的試煉", text = {"庫烏艾：坦克將BOSS背對人群，躲好震蕩波，拉好穆辛巴，治療刷好穆辛巴的毀滅目標。", "明谷子：躲開回旋風暴和磁場，打斷好閃電箭。", "哈伊岩：施放流星時集中分擔傷害或者遠遠的躲開，施放燃燒時分散。"}},
			{name = "蓋肯", text = "坦克拉好四只小怪，優先擊殺神谕師和鐵皮戰士，再擊殺其他兩種小怪，最後擊殺BOSS。"},
			{name = "『武器大師』辛", text = "坦克讓BOSS背對人群，BOSS施放地面猛擊時，離開BOSS正面躲避。所有人都要躲好烈焰之環、旋風之斧、利刃陷阱。"},
		},
		["落陽關"] = {
			{name = "『破壞者』奇普提拉克", text = "注意永遠不要和穩定的軍火站在壹條線上。"},
			{name = "打擊者卡多克", text = "躲開地上的火焰（掃射），躲開地上的酸液炸彈，治療和DPS注意跟著坦克集中。"},
			{name = "指揮官黎莫克", text = "躲開地上的流毒物質，在BOSS施放狂亂攻擊的時候，不要站在BOSS正面。"},
			{name = "雷剛", text = {"第壹階段：坦克拉好小怪，DPS在BOSS撞牆之前跳上邊上的炮台，跳到BOSS頭部，攻擊BOSS的弱點，注意撞牆之前壹定要下來。", "第二階段：被BOSS凝視的玩家注意遠離BOSS，其他人全力RUSH BOSS。"}},
		},
		["血色修道院"] = {
			{name = "『靈魂撕裂者』薩爾諾斯", text = "注意打斷靈魂強風，如果沒打斷，注意躲開，坦克拉好小怪，迅速A掉。"},
			{name = "克羅夫修士", text = "躲好正面的炙炎拳，火焰風暴踢時近戰讓開，躲好地上的火焰（炙灼之土）。"},
			{name = "高階審判官懷特邁恩", text = "第壹階段，躲好沖刺打擊。第二階段，優先打斷懷特邁恩的群體複活技能，擊殺懷特邁恩。"},
		},
		["血色大廳"] = {
			{name = "馴犬者布勞恩", text = "遠程注意分散站位，坦克拉好召喚出來的狗，BOSS血量高于50%之前把狗先幹掉，等血量降低50%後坦克拉好狗，DPS全力攻擊BOSS。"},
			{name = "武器大師哈倫", text = "坦克將BOSS拉好背對人群，並拉好召喚的小怪，BOSS跳到場中間施放光明之刃時，注意閃開別被光明之刃帶進去。"},
			{name = "織焰者喀格勒", text = "躲開焚燒書籍的火焰，BOSS施放巨龍之息的時繞著BOSS躲開巨龍之息，打斷職業及時打斷BOSS的連珠火球和炎爆術。"},
		},
		["通靈學院"] = {
			{name = "講師冷心", text = {"第壹階段，在冰牆合攏之前擊殺BOSS，分散站的時候不要碰到冰牆，冰牆會從前後兩個方向往BOSS方向壓過來，要盡快把BOSS打入第二階段。", "第二階段，全力擊殺護命匣，遠程分散站開。"}},
			{name = "詹迪斯·巴羅夫", text = "坦克將BOSS背對人群，施放奇能迅擊時，遠離BOSS正面，BOSS施放扭曲幻象時，迅速擊殺分身，尋找真身，找到後坦克迅速接住BOSS，重複循環此過程。"},
			{name = "血骨傀儡", text = "躲開靈魂烈焰，玩家可以在周圍地上找到骨堆，點擊骨堆獲得骨甲術效果然後去打BOSS，坦克在BOSS生鏽效果達到10層以上時，風筝BOSS，直到生鏽效果消失。"},
			{name = "莉莉安·佛斯", text = {"第壹階段，遠程分散站位，BOSS施放死亡之握之後，注意分散跑起來，直到黯焰效果結束。", "第二階段，被凝視的玩家遠離BOSS繞著場地跑，如果BOSS擊中玩家施放黯焰，其他人保持移動，躲開黯焰。", "第三階段，注意躲開黯焰、被凝視的玩家注意跑，此階段只是重複第壹第二的打法，場面會比較混亂治療注意加好。"}},
		},
		["天槌"] = {
			{ ["name"] = "卡加斯•刃拳", ["text"] = "坦克注意穿刺2層換T,在擊飛人群後站在BOSS腳下就行.DPS躲火柱,遠程被點名衝鋒時把BOSS帶到火柱。治療注意給被火柱燒到的人加血。.",},
			{ ["name"] = "屠夫", ["text"] = "坦克注意正常2-3層換T.DPS吃到BOSS旋風斬注意debuff層數,3-4層就趕緊離開BOSS消debuff,達到5層秒殺.治療注意BOSS唯一的高傷害是衝鋒跳劈,保證滿血就行。.",},
			{ ["name"] = "綠蕨孢子巨人", ["text"] = "坦克注意死疽吐息前換T,DPS注意有小怪打小怪,沒小怪殺BOSS,打斷真菌食肉者的AOE讀條.治療有蘑菇就把蘑菇奶起來.其他時間刷血就行。",},
		},
	}
end

function DungeonList:OnInitialize()
	self.lastZone = "";
	self.menuFrame = CreateFrame("Frame", "dwChatDungeonListMenuFrame", DWCDungeonListButton, "UIDropDownMenuTemplate");
	self.menuFrame:Hide();
	DWCDungeonListButton:SetScript("OnClick", function(this, button)
		ToggleDropDownMenu(nil, nil, self.menuFrame, "cursor",  -2, -2, self.menuFrame.menuList);
	end);
end

function DungeonList:OnEnable()
	self:RawHook("SetItemRef", true);
	self:RegisterEvent("ZONE_CHANGED", "OnEvent");
	self:RegisterEvent("ZONE_CHANGED_INDOORS", "OnEvent");
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "OnEvent");

	self:OnEvent("ZONE_CHANGED");
end

function DungeonList:OnDisable()
	self:Unhook("SetItemRef");
	self:UnregisterAllEvents();
end

function DungeonList:SendChatMessage(text, chattype, language, destination)
	if (not chattype) then
		if (IsInRaid()) then
			chattype = IsPartyLFG() and "INSTANCE_CHAT" or "RAID";
		elseif (IsInGroup()) then
			chattype = IsPartyLFG() and "INSTANCE_CHAT" or "PARTY";
		else
			chattype = "say";
		end
	end

	local nlen = string.len(text);
	while (nlen > 0) do
		if (nlen > 255) then
			local msg = string.sub(text, 1, 255);
			SendChatMessage(msg, chattype);
			text = string.sub(text, 255, nlen);
			nlen = string.len(text);
		else
			nlen = 0;
			SendChatMessage(text, chattype);
		end
	end
end

function DungeonList:SetItemRef(link, text, button)
	if (link:find("DungeonList:%d")) then
		local id, zone = link:match("DungeonList:(%d+):(%S+)");
		if (id and self.data[zone]) then
			local index = tonumber(id);
			local info = self.data[zone][index];
			if (not info) then return	end

			if (type(info.text) == "string") then
				self:SendChatMessage(L["WoWBox GongLue"]);
				self:SendChatMessage(info.name.."："..info.text);
			elseif (type(info.text) == "table") then
				self:SendChatMessage(L["WoWBox GongLue"]);
				self:SendChatMessage(info.name.."：");
				for i=1, #(info.text) do
					self:SendChatMessage( i .. "、" .. info.text[i]);
				end
			end
		end

		return;
	elseif (link:find("WoWBoxShare:")) then
		if (IsInRaid() or IsInGroup()) then
			self:SendChatMessage(DUOWAN_BLIZZARD_REPORT);
		else
			self:SendChatMessage(DUOWAN_BLIZZARD_REPORT, "guild");
		end
	end
	self.hooks.SetItemRef(link, text, button);
end

function DungeonList:OnEvent(event, ...)
	local zoneName = GetZoneText();
	if (self._DEBUG) then
		zoneName = "巨龙之魂";
	end
	if (self.lastZone ~= zoneName) then
		self.lastZone = zoneName;
		if (self.data[zoneName]) then
			-- 显示攻略按钮
			DWCDungeonListButton:Show();
			local menuList = {
				{
					text = L["DungeonList"],
					isTitle = 1,
					notCheckable = 1,
				},
			};

			for index, v in ipairs(self.data[zoneName]) do
				local info = {};
				info.text = "· "..v.name;
				info.arg1 = v.text;
				info.index = index;
				info.notCheckable = 1;
				info.func = function(self, arg1, ...)
					local text;
					local linkString = "|CFF00B4FF|HDungeonList:"..TEXT(index)..":"..zoneName.."|h[发送攻略]|h|r";
					if (type(arg1) == "string") then
						text = info.text.."：".. linkString .. "\n" .. arg1;
					elseif (type(arg1) == "table") then
						text = info.text.."：" .. linkString;
						for i=1, #(arg1) do
							text = text .. "\n".. i .. "、" .. arg1[i];
						end
					end

					DEFAULT_CHAT_FRAME:AddMessage(text, 1, 0.9, 0.4);
				end

				tinsert(menuList, info);
			end

			------------
			-- 插入关闭
			local spaceInfo = { text = "", isTitle = 1, notCheckable = 1, };
			local closeInfo = { text = CLOSE, func=function() end, notCheckable = 1, };
			tinsert(menuList, spaceInfo);
			tinsert(menuList, closeInfo);

			dwEasyMenu(menuList, self.menuFrame, "cursor", -2, -2, "MENU");
		else
			DWCDungeonListButton:Hide();
		end
	end

end

--if (DungeonList._DEBUG) then
--	DungeonList:SendChatMessage("死亡之翼的背脊: 触须只打一个就行了，打掉后刷新熔合体，坦克拉住带到盔甲附近，小软泥另外一个坦克拉住带到融合体附近，全团dps打融合体到400万血，注意不要用aoe技能打到软泥，融合体到400万血开始aoe，把小软泥aoe掉，拉融合体的坦克注意观察debuff层数，9层通知dps打掉，打掉后会爆炸，所有人记得跑开，然后重复前面的步骤，直到炸掉三块盔甲即结束。");
--end
