local mod	= DBM:NewMod("Saviana", "DBM-ChamberOfAspects", 2)
local L		= mod:GetLocalizedStrings()

mod:SetRevision(("$Revision: 209 $"):sub(12, -3))
mod:SetCreatureID(39747)
mod:SetEncounterID(1149)
mod:SetModelID(31577)
mod:SetUsedIcons(8, 7, 6, 5, 4)

mod:RegisterCombat("combat")

mod:RegisterEventsInCombat(
	"SPELL_CAST_START",
	"SPELL_AURA_APPLIED",
	"SPELL_AURA_REMOVED"
)

local warningWarnBeacon		= mod:NewTargetAnnounce(74453, 4)--Will change to a target announce if possible. need to do encounter
local warningWarnEnrage		= mod:NewSpellAnnounce(78722, 3)
local warningWarnBreath		= mod:NewSpellAnnounce(74403, 3)

local specWarnBeacon		= mod:NewSpecialWarningYou(74453)--Target scanning may not even work since i haven't done encounter yet it's just a guess.
local specWarnTranq			= mod:NewSpecialWarningDispel(78722, "RemoveEnrage")

local timerBeacon			= mod:NewBuffActiveTimer(5, 74453)
local timerConflag			= mod:NewBuffActiveTimer(5, 74456)
local timerConflagCD		= mod:NewNextTimer(50, 74452, nil, nil, nil, 3)
local timerBreath			= mod:NewCDTimer(25, 74403, nil, "Tank|Healer", nil, 5)
local timerEnrage			= mod:NewBuffActiveTimer(10, 78722)

mod:AddBoolOption("RangeFrame", true)
mod:AddBoolOption("BeaconIcon", true)

local beaconTargets = {}
local beaconIcon 	= 8

local function warnConflagTargets()
	warningWarnBeacon:Show(table.concat(beaconTargets, "<, >"))
	table.wipe(beaconTargets)
	beaconIcon = 8
end

function mod:OnCombatStart(delay)
	timerConflagCD:Start(32-delay)--need more pulls to verify consistency
	timerBreath:Start(12-delay)--need more pulls to verify consistency
	table.wipe(beaconTargets)
	beaconIcon = 8
	if self.Options.RangeFrame then
		DBM.RangeCheck:Show(10)
	end
end

function mod:OnCombatEnd()
	if self.Options.RangeFrame then
		DBM.RangeCheck:Hide()
	end
end

function mod:SPELL_CAST_START(args)
	if args.spellId == 74403 then
		warningWarnBreath:Show()
		timerBreath:Start()
	end
end

function mod:SPELL_AURA_APPLIED(args)
	if args.spellId == 78722 then
		warningWarnEnrage:Show()
		specWarnTranq:Show()
		timerEnrage:Start()
	elseif args.spellId == 74453 then
		beaconTargets[#beaconTargets + 1] = args.destName
		timerConflagCD:Start()
		timerBeacon:Start()
		timerConflag:Schedule(5)
		if args:IsPlayer() then
			specWarnBeacon:Show()
		end
		if self.Options.BeaconIcon then
			self:SetIcon(args.destName, beaconIcon, 11)
			beaconIcon = beaconIcon - 1
		end
		self:Unschedule(warnConflagTargets)
		self:Schedule(0.3, warnConflagTargets)
	end
end

function mod:SPELL_AURA_REMOVED(args)
	if args.spellId == 78722 then
		timerEnrage:Cancel()
	end
end