﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.users, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="users">
<head runat="server">
    <title>用户管理</title><meta http-equiv="X-UA-Compatible" content="IE=edge" />
</head>
<body>
    <form id="form1" runat="server">
    <asp:HiddenField ID="curUserName" runat="server" /><asp:HiddenField ID="curUnit" Value="0" runat="server" />
    <asp:ScriptManager ID="s1" runat="server" EnablePageMethods="True" OnAsyncPostBackError="AsyncError" />
    
    <table id="main"><tr><td id="tdUnits" class="vtop">
        <asp:UpdatePanel ID="divUnits" runat="server" UpdateMode="conditional" RenderMode="Block">
        <ContentTemplate>
            <asp:TreeView ID="tv" NodeWrap="false" LineImagesFolder="images/tree" OnSelectedNodeChanged="ShowUnit" SelectedNodeStyle-CssClass="selected" ExpandDepth="1" NodeStyle-HorizontalPadding="3" runat="server" ShowLines="true" CssClass="tree">
                <Nodes>
                    <asp:TreeNode Text="公司" Selected="true" Value="0"></asp:TreeNode>
                    <asp:TreeNode Text="相关操作" SelectAction="Expand">
                        <asp:TreeNode Text="搜索用户" ImageUrl="images/find.png" NavigateUrl="javascript:ShowSearch();"></asp:TreeNode>
                        <asp:TreeNode Text="高级搜索" ImageUrl="images/userQuery.gif" NavigateUrl="javascript:toQuery();"></asp:TreeNode>
                        <asp:TreeNode Text="导入导出" ImageUrl="images/port.gif" NavigateUrl="javascript:showIo()"></asp:TreeNode>
                        <asp:TreeNode Text="设置组织机构级别称谓" ImageUrl="images/levels.gif" NavigateUrl="javascript:ShowLevels();"></asp:TreeNode>
                        <asp:TreeNode Text="设置默认用户信息" ImageUrl="images/builder.gif" NavigateUrl="reg.aspx?mode=init"></asp:TreeNode>
                        <asp:TreeNode Text="角色管理" ImageUrl="images/users.gif" NavigateUrl="roles.aspx"></asp:TreeNode>
                        <asp:TreeNode Text="帮助" ImageUrl="images/help.gif" NavigateUrl="javascript:toShowHelp();"></asp:TreeNode>
                    </asp:TreeNode>
                </Nodes>
            </asp:TreeView>
        </ContentTemplate>
        </asp:UpdatePanel>
    </td><td id="tdObjs" class="vtop">
        <asp:UpdatePanel ID="upObjs" runat="server" OnPreRender="AttObjEvent" UpdateMode="conditional" RenderMode="Block">
            <ContentTemplate>
                <div runat="server" id="divLocation"></div>
                <div id="objsDiv" runat="server"></div>
            </ContentTemplate>
        </asp:UpdatePanel>
    </td></tr>
    </table>
    <div class="menu" id="menu_obj">
        <a accesskey="D" href="#" onclick="return del();">删除 　　　Alt+D</a>
        <a accesskey="X" href="#" onclick="return cut('User');">剪切 　　　Alt+X</a>
        <div></div>
        <a accesskey="R" href="#" runat="server" onserverclick="ShowAttributes" id="showAttributes">属性 　　　Alt+R</a>
    </div>
    <div class="menu" id="menu_unit">
        <a accesskey="O" href="#" onclick="ShowUnit();" id="openUnit">打开 　　　Alt+O</a>
        <a accesskey="X" href="#" onclick="cut('Unit');">剪切 　　　Alt+X</a>
        <a accesskey="N" href="#" onclick="return renameUnit()">重命名　　 Alt+N</a>
        <a accesskey="D" href="#" runat="server" id="delUnit" onserverclick="DelUnit" onclick="return delUnit();">删除 　　　Alt+D</a>
    </div>
    <div class="menu" id="menu_body">
        <a accesskey="N" href="#" onclick="return createUser();">添加用户　 Alt+N</a>
        <a accesskey="U" href="#" onclick="return createUnit();">添加机构　 Alt+U</a>
        <a accesskey="V" href="#" id="paste" runat="server" onserverclick="Paste">粘贴 　　　Alt+V</a>
        <div></div>
        <a accesskey="R" href="roles.aspx">角色管理 　Alt+R</a>
    </div>    
    <ims:Pop runat="server" ID="attr" Width="480" ShowOkButton="false" ShowCancelButton="false" CustomCss="noline" ShowProgress="false">
    <ContentTemplate>
        <fieldset runat="server" id="rolesArea"><legend>角色</legend>
            <div class="padbox">
            <asp:CheckBoxList ID="roles" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal"></asp:CheckBoxList>
            </div>
        </fieldset>
        <asp:HyperLink runat="server" Visible="false" ID="rolesAdmin" NavigateUrl="roles.aspx" Target="_self" Text="系统中尚未定义角色！点此新建角色 &gt;&gt;"></asp:HyperLink>
        <div class="padbox notfocus" id="ulAttrs">
        <ul>
            <li runat="server" id="divRelaName">真实姓名： <asp:TextBox runat="server" ID="tbRealName"></asp:TextBox></li>
            <li>所在机构： <asp:HyperLink runat="server" ID="hlUnit"></asp:HyperLink></li>
            <li>是否机构负责人： <asp:CheckBox runat="server" ID="cbRector" Text="是" /></li>
            <li id="managed" runat="server">分管的下级机构： <asp:CheckBoxList runat="server" ID="cblUnits" RepeatLayout="Flow" RepeatDirection="Horizontal"></asp:CheckBoxList></li>
            <li>兼任以下机构负责人： <asp:TextBox runat="server" ID="tbAnnex" Width="312" acfid="UnitNameWithID" chars=";；,，、" ondblclick="showUserTree(this.id,true);" ToolTip="双击弹出机构选择窗口。多项之间以逗号、分号或顿号分隔。"></asp:TextBox>
            </li>
        </ul>
        <div class="sepline2"></div>
        <ul>
            <li runat="server" id="liWx">微信帐号： <asp:TextBox runat="server" ID="tbWx"></asp:TextBox><img src="images/what.gif" title="说明" onclick="ShowMsgPop('指企业号通讯录中的用户帐号，不是微信号。建议在企业号中将二者设为一致。', 90000, 'what');" class="what" /></li>
            <asp:PlaceHolder runat="server" ID="userInfo"></asp:PlaceHolder>
        </ul>
        </div>
        <div class="footBtnArea">
            <asp:Button runat="server" ID="btnSave" OnClick="saveAttributes" Text="确定" CssClass="btn" />
            <asp:Button runat="server" ID="btnUnlock" OnClick="UnlockUser" Text="解除锁定" CssClass="btn" />
            <asp:Button runat="server" ID="btnResetPwd" OnClick="ResetPass" Text="重置密码" OnClientClick="return confirm('确定要将该用户的密码重置为初始密码吗？');" ToolTip="将该用户的密码重置为当前默认初始密码" CssClass="btn" />
            <input type="button" onclick="HideDialog();" value="取消" class="btn" />
        </div>
    </ContentTemplate>
    </ims:Pop>    
    <ims:Pop runat="server" ID="popSearch" Title="搜索用户" OkButtonText="搜索" OnOkClientClick="return searchUser();" ShowProgress="false">
    <ContentTemplate>
        <br />
        <asp:DropDownList runat="server" ID="ddlNameType" onchange="$('#keyword').attr('acfid', $(this).val());"><asp:ListItem Selected="True" Value="UserIdenName">用户名</asp:ListItem><asp:ListItem Value="UserRealName">用户实名</asp:ListItem></asp:DropDownList> 包含：<input type="text" id="keyword" acfid="UserIdenName" onkeydown="return enterTo('popSearch_btnOK');" style="width:180px" />
    </ContentTemplate>
    </ims:Pop> 
    <ims:Pop runat="server" ID="au" Title="高级搜索" Width="555" OkButtonText="搜索" OnOkClick="FindUsers" CustomCss="noline" ShowProgress="false">
        <ContentTemplate>
            <fieldset><legend><asp:RadioButtonList runat="server" ID="rblMode" RepeatLayout="Flow" RepeatDirection="Horizontal" ValidationGroup="mode"><asp:ListItem Value="1" Selected="True">以下用户</asp:ListItem><asp:ListItem Value="4">所有用户中排除以下用户</asp:ListItem></asp:RadioButtonList></legend>
                <div class="padbox notfocus">
                    <input type="checkbox" runat="server" id="cbUser" /><label for="au_cbUser">用户：</label><asp:TextBox runat="server" id="tbUsers" acfid="UserName" chars=";；,，、" ondblclick="showUserTree(this.id);" ToolTip="双击弹出用户选择窗口。多项之间以逗号、分号或顿号分隔" /><br />
                    <input type="checkbox" runat="server" id="cbRole" /><label for="au_cbRole">角色：</label><asp:TextBox runat="server" id="tbRoles" acfid="RoleName" chars=";；,，、" ToolTip="多项之间以逗号、分号或顿号分隔" /><br />
                    <input type="checkbox" runat="server" id="cbUnit" /><label for="au_cbUnit">机构：</label><asp:TextBox runat="server" id="tbUnits" acfid="UnitNameWithID" chars=";；,，、" ondblclick="showUserTree(this.id,true);" ToolTip="双击弹出机构选择窗口。多项之间以逗号、分号或顿号分隔" /> <input runat="server" type="checkbox" id="cb_Rector" value="1" checked="checked" /><label for="au_cb_Rector">负责人</label> <input runat="server" type="checkbox" id="cbDirectly" value="2" /><label for="au_cbDirectly">直属成员</label> <input runat="server" type="checkbox" id="cbIndirect" value="4" /><label for="au_cbIndirect">非直属成员</label><br />
                    <div id="related">
                    <input type="checkbox" runat="server" id="cbRel" /><asp:TextBox runat="server" ID="tbBase" Width="90" ToolTip="输入用户名" acfid="UserName" ondblclick="showUserTree(this.id);"></asp:TextBox> 的： <input runat="server" type="checkbox" id="cbLateral" value="2" /><label for="au_cbLateral">平级</label> <input runat="server" type="checkbox" id="cbSuperior" value="4" /><label for="au_cbSuperior">上级</label> <input runat="server" type="checkbox" id="cbDirectUnderling" value="8" /><label for="au_cbDirectUnderling">直接下级</label> <input runat="server" type="checkbox" id="cbUnderling" value="16" /><label for="au_cbUnderling">所有下级</label><br />
                    <span runat="server" id="spanLevels"><span class="hidden"><input type="checkbox" /><input type="text" style="width:90px" /> 的： </span><input runat="server" type="checkbox" id="cbLevel" value="32" /><asp:DropDownList runat="server" ID="ddlLevels"></asp:DropDownList><span class="subItems">的： <input runat="server" type="checkbox" id="cbLevelRector" value="1" checked="checked" class="levelMember" /><label for="au_cbLevelRector">负责人</label> <input runat="server" type="checkbox" class="levelMember" id="cbLevelDirectly" value="2" /><label for="au_cbLevelDirectly">直属成员</label></span></span>
                    <img src="images/what.gif" title="相关说明" onclick="What('Colleague')" class="what" />
                    </div>
                </div>
            </fieldset>
        </ContentTemplate>
    </ims:Pop>   
    <ims:Pop runat="server" ID="lev" Title="设置组织机构级别称谓" OkButtonText="确定" OnOkClick="SaveLevels" Width="420" CustomCss="noline" ShowProgress="false">
    <ContentTemplate>
        <asp:TextBox runat="server" ID="tbLevels" Width="98%"></asp:TextBox>
        <div id="mentLevels">
            设置组织机构纵向各层次级别的称谓，有助于直观地定位各个层次。请按从顶至底的顺序依次填写，确保与机构设置相匹配，以逗号或顿号分隔。<br />
            示例： 集团、公司、子公司、部门、科室、小组。
        </div>
    </ContentTemplate>
    </ims:Pop>
    <ims:Pop runat="server" ID="io" ShowOkButton="false" ShowCancelButton="false" Title="用户导入导出" Width="414" ShowProgress="false">
        <ContentTemplate>
            <div class="center mtop_l">
                <input runat="server" type="button" id="uploadXls" onclick="return false;" onserverclick="ShowUnit" class="btn" value="导入用户" />
                <div id="fu" runat="server"><input id="xlsToUpload" type="file" contenteditable="false" title="从一个Excel文件中导入用户" onclick="return preImport();" onchange="return xlsUpload();" name="xlsToUpload" /></div>
                <asp:Button ID="btnToExcel" runat="server" class="btn" OnClick="ToExcel" ToolTip="将数据导出到一个Excel文件" Text="导出用户" />
                <asp:Button ID="excel" runat="server" class="btn" OnClick="MakeExcelTemplet" ToolTip="下载具有标题行的Excel空白表，便于整理用户数据供导入" Text="下载Excel表单" />
                <input type="button" class="btn" value="帮助" onclick="showHelp('batchUser');" />
                <input type="button" class="btn" value="关闭" onclick="HideDialog();" />
            </div>
        </ContentTemplate>
    </ims:Pop>
    <div class="hide">
        <asp:Button runat="server" ID="refreshTree" OnClick="ReloadTree" CssClass="hide" />
        <asp:UpdatePanel ID="upInfo" runat="server" UpdateMode="conditional">
        <ContentTemplate>
            <ul id="AttributeInfo">
                <li>用户总数：<asp:Literal ID="usersCount" runat="server"></asp:Literal></li>
                <li runat="server" id="inRole"></li>
            </ul>
            <input type="button" runat="server" id="updateUsersCount" onserverclick="RefreshUsersCount" />
        </ContentTemplate>
        </asp:UpdatePanel>
    </div>
    <script src="js/comm.js"></script><script src="js/users.js"></script>
    </form>
</body>
</html>