﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.setup, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html>
<head runat="server">
    <title>配置数据库</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <style type="text/css">
        *{font-family:微软雅黑,Arial,宋体;margin:0}
        a:link,a:visited{color:#02d}
        table{width:100%;border-collapse:collapse}
        p{margin:2px 0}
        .right{text-align:right}
        .indent{margin-left:20px}
        .description{color:#999;margin-left:6px}
        .prompt{color:#666;line-height:1.6}
        #rbs{line-height:19px}
        #rbs *{vertical-align:middle;margin-right:4px}
        #btnOk,#btnBack{font-size:9pt;*height:23px}
    </style>
</head>
<body style="margin:3em 8%;font-size:9pt;font-family:Arial;">
    <form id="form1" runat="server">
        <asp:ScriptManager ID="s1" AsyncPostBackTimeout="300" runat="server" OnAsyncPostBackError="AsyncError" />
        
        <div id="mainArea">
        <div style="float:left;font-weight:bold;font-weight:bold;height:22px;line-height:22px;font-size:10.5pt">选择数据库：</div>
        <div id="loading" style="float:right;background:url(images/loading_ov.gif) no-repeat 0 50%;padding-left:20px;height:22px;line-height:22px;display:none">请稍候…</div>
        <div style="border:1px #ccc solid;border-width:1px 0;padding:3px 2em 12px;clear:both;">
            <div id="rbs">
                <asp:RadioButton GroupName="dbs" ID="rbAccess" Checked="true" Text="Access" runat="server" /><span class="description">（系统内置的默认数据库，小巧方便）</span><br />
                <asp:RadioButton GroupName="dbs" ID="rbSqlServer" Text="SQL Server" runat="server" /><span class="description">（速度快，容量大，需单独安装）</span>
            </div>
            <div id="sqlserver" style="display:none;">
            <div style="border:1px #dfdfdf solid;background:#f8f8f8;margin:2px 0 0 20px;padding:4px 0;">
                <table>
                    <tr>
                        <td style="width:75px" class="right">服务器：</td>
                        <td>
                            <asp:UpdatePanel ID="upServers" runat="server" RenderMode="inline" UpdateMode="conditional">
                            <ContentTemplate>
                            <asp:TextBox ID="tbServer" Width="200" runat="server"></asp:TextBox>
                                <asp:DropDownList runat="server" ID="ddlServers" Visible="false"></asp:DropDownList>
                                <asp:LinkButton ID="lbFind" runat="server" OnClick="BindServers">查找可用的服务器</asp:LinkButton>
                            </ContentTemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                    <tr><td class="right">身份验证：</td><td><asp:DropDownList ID="ddlAuthmodes" runat="server" Width="206"><asp:ListItem Value="windows" Selected="True">Windows 身份验证</asp:ListItem><asp:ListItem Value="sqlserver">SQL Server 身份验证</asp:ListItem></asp:DropDownList></td></tr>
                    <tr id="trName" style="display:none"><td class="right">用户名：</td><td><asp:TextBox ID="tbUserName" runat="server" Width="200"></asp:TextBox></td></tr>
                    <tr id="trPass" style="display:none"><td class="right">密　码：</td><td><asp:TextBox ID="tbPassword" TextMode="Password" runat="server" Width="200"></asp:TextBox></td></tr>
                </table>
            </div>
            </div>
        </div>
        <div runat="server" id="msg" style="color:Red;margin-bottom:1em" visible="false"></div>
        <div class="prompt">
            <p><img src="images/info.gif" align="absMiddle" /> 若要使用SQL Server，有两种方法： </p>
            <p class="indent">A. 使用 <a href="http://landian.cc/download/SqlSetup.exe" target="_blank">SQL Server自动安装工具</a> 安装后，在本页用<span runat="server" id="authTxt">"Windows身份验证"</span>连接（服务器默认是".\SQLEXPRESS"）。</p>
            <p class="indent">B. 安装 <a runat="server" id="sqlLink" target="_blank">SQL Server 2008 Express</a>，然后用 SQL Server Management Studio 打开，在左侧展开"安全性"，右键点击"登录名"，新建登录名，填入"<span style="color:Red"><%= AspNetUser %></span>"，切换到"服务器角色"，勾选所有角色，点"确定"。在本页用"Windows身份验证"连接（服务器默认是".\SQLEXPRESS"）。</p>
        </div>
        <asp:UpdatePanel ID="up" runat="server" RenderMode="Block" UpdateMode="conditional" style="text-align:center;margin-top:48px">
        <ContentTemplate>
            <asp:Button ID="btnOk" runat="server" OnClick="btnOk_Clicked" Text="确 定" />　<asp:Button ID="btnBack" runat="server" OnClientClick="location='maint.aspx';" Text="返 回" Visible="false" />
        </ContentTemplate>
        </asp:UpdatePanel>
        
        </div>
        <div style="display:none;text-align:center;margin:10em auto 4em" id="loading2"><img src="images/loading.gif" style="vertical-align:middle;margin-right:0.5em" />正在载入页面，请稍候…</div>
   <script src="js/comm.js"></script>
   <script>
        function setSqlArea() {
            $f('sqlserver').style.display = $f('rbSqlServer').checked ? 'block' : 'none';
        }
        function setSqlNamePass() {
            var e = $f("ddlAuthmodes");
            $f('trName').style.display = $f('trPass').style.display = e.options[e.selectedIndex].value == 'sqlserver' ? '' : 'none';
        }
        function setSqlServer(e) {
            var value = e.options[e.selectedIndex].value;
            if (value != "") $f("tbServer").value = value;
        }
        window.onload = function () {
            try {
                setSqlArea();
                setSqlNamePass();
                var prm = Sys.WebForms.PageRequestManager.getInstance();
                prm.add_initializeRequest(function () {
                    $f("loading").style.display = "block";
                    $("#up :submit").prop("disabled", true);
                });
                prm.add_endRequest(function () {
                    $f("loading").style.display = "none";
                    $("#up :submit").prop("disabled", false);
                });
            } catch (e) { }
        }
        function toRedirect() {
            $f('mainArea').style.display = 'none';
            $f('loading2').style.display = 'block';
            parent.location = "login.aspx";
        }
       //覆盖自定义alert函数，因本页面没有相应CSS
        function alert(msg) {
            winalert(msg);
        }
    </script>
    </form>
</body>
</html>