﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.Filters, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="filters">
<head runat="server">
    <title>过滤器管理</title><meta http-equiv="X-UA-Compatible" content="IE=edge" />
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="sm" runat="server" OnAsyncPostBackError="AsyncError" />
        <asp:validationsummary id="ValSum" runat="server" ShowMessageBox="True" ShowSummary="False" ValidationGroup="add"></asp:validationsummary>
        <div runat="server" id="pageTitle" class="pageTitle"></div>
        <asp:UpdatePanel ID="up" runat="server" RenderMode="inline" OnPreRender="AddScript" UpdateMode="Conditional">
        <ContentTemplate>
            <div runat="server" id="EmptyPrompt" visible="false" class="highlight corner"></div>
            <table class="hr">
            <asp:Repeater ID="rptFilters" runat="server" OnItemCommand="rptFilters_Command" OnItemDataBound="rptFilters_ItemBound">
            <HeaderTemplate><tr><th style="width:28px">序号</th><th style="width:120px">名称</th><th>筛选条件</th><th style="width:36px">隐藏</th><th style="width:48px">操作</th></tr></HeaderTemplate>
            <ItemTemplate>
                <tr runat="server" id="ItemTr">
                    <td runat="server" title="拖动调整顺序" class="moveable"></td>
                    <td runat="server" title="拖动调整顺序" class="moveable"></td>
                    <td runat="server"></td>
                    <td runat="server"></td>
                    <td runat="server"><asp:ImageButton CommandName="edit" ToolTip="编辑" ID="ibEdit" ImageAlign="Bottom" ImageUrl="images/edit.gif" runat="server" /> <asp:ImageButton ImageAlign="Bottom" CommandName="del" ID="ibDel" ToolTip="删除" runat="server" ImageUrl="images/del.gif" OnClientClick="return confirm('确定要删除此过滤器吗？');" /></td>
                </tr>
            </ItemTemplate>
            </asp:Repeater>
            </table>
        </ContentTemplate>
        </asp:UpdatePanel>
        <div class="footBtnArea bigger">
            <asp:Button runat="server" ID="btnAdd" Text="添加过滤器" OnClick="toAdd" CssClass="btn" />
            <input type="button" onclick="back();" value="返回" class="btn" />
            <asp:Button runat="server" id="btnSort" OnClick="SaveOrder" CssClass="hide" />
        </div>
    <script src="js/comm.js"></script>
    <script>
        var editable = false;
        $(function () {
            $("table.hr").sortable({
                items: "tr[FilterName]",
                handle: "td.moveable",
                helper: 'clone',
                opacity: 0.7,
                ghosting: true,
                scroll: false,
                update: function () {
                    var orders = "";
                    $("table.hr:first tr[FilterName]").each(function () {
                        orders += Base64($(this).attr("FilterName")) + ",";
                    });
                    __doPostBack("btnSort", orders);
                    parent.leftFrame.reloadTabs('browse');
                }
            });
        });
        function confirmDel(ctlid, msg) {
            if (confirm(msg)) {
                setTimeout(function () { __doPostBack(ctlid, "Confirmed"); }, 0);
            } else {
                return false;
            }
        }
        function Init() {
            var trs = $("table.hr tr:gt(0)").hover(function () { $(this).toggleClass("RowMouseOver"); });
            if (editable) trs.dblclick(function () {
                $(this).find(":image:first").click();
            }).attr("title", "双击编辑过滤器");
        }
    </script>
    </form>
</body>
</html>