/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *    CostMatrixLoader.java
 *    Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package wekaexamples.classifiers;

import weka.classifiers.CostMatrix;

import java.io.BufferedReader;
import java.io.FileReader;

/**
 * Loads the cost matrix "args[0]" and prints its content to the console.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 5876 $
 */
public class CostMatrixLoader {
  
  public static void main(String[] args) throws Exception {
    CostMatrix matrix = new CostMatrix(
	new BufferedReader(new FileReader(args[0])));
    System.out.println(matrix);
  }
}
