# object.defaults [![NPM version](https://badge.fury.io/js/object.defaults.svg)](http://badge.fury.io/js/object.defaults)  [![Build Status](https://travis-ci.org/jonschlinkert/object.svg)](https://travis-ci.org/jonschlinkert/object) 

> Like `extend` but only copies missing properties/values to the target object.


## Install with [npm](npmjs.org)

```bash
npm i object.defaults --save
```
## Install with [bower](https://github.com/bower/bower)

```bash
bower install object.defaults --save
```


## Usage

```js
var defaults = require('object.defaults');

var obj = {a: 'c'};
defaults(obj, {a: 'bbb', d: 'c'}));
console.log(obj);
//=> {a: 'c', d: 'c'}
```

## Related projects
 * [deep-defaults](https://github.com/d5/deep-defaults): Recursive version of _.defaults
 * [object.filter](https://github.com/jonschlinkert/object.filter): Create a new object filtered to have only properties for which the callback returns true.
 * [object.map](https://github.com/jonschlinkert/object.map): Similar to map for arrays, this creates a new object by calling the callback on each property of the original object.
 * [object.omit](https://github.com/jonschlinkert/object.omit): Return a copy of an object without the given key, or array of keys.
 * [object.pick](https://github.com/jonschlinkert/object.pick): Returns a filtered copy of an object with only the specified keys, like `pick` from lo-dash / underscore.
 * [object.reduce](https://github.com/jonschlinkert/object.reduce): Reduces an object to a value that is the accumulated result of running each property in the object through a callback.
 * [mixin-deep](https://github.com/jonschlinkert/mixin-deep): Deeply mix the properties of objects into the first object. Like merge-deep, but doesn't clone.
 * [extend-shallow](https://github.com/jonschlinkert/extend-shallow): Extend an object with the properties of additional objects. node.js/javascript util.

## Running tests
Install dev dependencies:

```bash
npm i -d && npm test
```

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/object.defaults/issues)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014-2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on April 19, 2015._") %}