var imageinfo = require('../index.js'),
	assert = require('assert'),
	tests = {};

function test(type) {
	var data = tests[type].data;
	var expect = tests[type].expect;
	info = imageinfo(data);
	assert.deepEqual(info, expect);
	console.log("  Decoded as:", info.mimeType);
	console.log("  Dimensions:", info.width, "x", info.height);
}

module.exports = function () {
	console.log("Beginning tests")
	for (var type in tests) {
		if (tests.hasOwnProperty(type)) {
			console.log("Testing", type, "data:");
			test(type);
		}
	}
}

tests.png = {expect:{type:'image', format:'PNG', mimeType:'image/png', width:16, height:32}, data: new Buffer([
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20,
  0x08, 0x06, 0x00, 0x00, 0x00, 0x1b, 0x89, 0xf8, 0xcc, 0x00, 0x00, 0x02,
  0x91, 0x49, 0x44, 0x41, 0x54, 0x48, 0xc7, 0x7d, 0x95, 0x41, 0x8e, 0xe3,
  0x56, 0x0c, 0x44, 0x1f, 0xf9, 0xff, 0x97, 0x48, 0x1b, 0xc8, 0x04, 0x01,
  0x7a, 0x99, 0x13, 0x64, 0x9b, 0x0b, 0xcc, 0xd1, 0xfa, 0x1a, 0x73, 0x9a,
  0xac, 0x73, 0x82, 0xac, 0xb3, 0x99, 0x6d, 0x02, 0x64, 0x80, 0x4c, 0xc7,
  0xfa, 0x95, 0xc5, 0xb7, 0x6c, 0xd9, 0x2d, 0xb5, 0x01, 0xc3, 0x10, 0xe0,
  0x22, 0x8b, 0xc5, 0x62, 0xc9, 0x24, 0xf1, 0xee, 0xf3, 0xe5, 0xd7, 0xc6,
  0xf7, 0xbf, 0x7f, 0xa4, 0x97, 0x9f, 0x7e, 0xf9, 0x52, 0xfe, 0x68, 0xad,
  0xd1, 0x5a, 0x63, 0x9a, 0x26, 0xce, 0xe7, 0x33, 0xd3, 0x34, 0xdd, 0x9e,
  0x7d, 0x17, 0xfc, 0xd7, 0x3f, 0x41, 0x51, 0xe0, 0x8a, 0x2d, 0x78, 0xfd,
  0xae, 0xcf, 0xad, 0xb5, 0x9d, 0x02, 0x97, 0x3f, 0x67, 0x72, 0x09, 0xa4,
  0x84, 0x9e, 0xad, 0x35, 0xe6, 0x79, 0xbe, 0x01, 0xb6, 0xe0, 0xf7, 0x0c,
  0x5e, 0x3f, 0x57, 0x96, 0x4f, 0x89, 0x7a, 0xe2, 0x0a, 0x8c, 0xd8, 0xfe,
  0xf9, 0x99, 0xc1, 0x63, 0x81, 0x57, 0xab, 0xfc, 0xfc, 0x35, 0x29, 0x0a,
  0x0a, 0xc1, 0xa5, 0x9c, 0xe8, 0x8a, 0x6d, 0xe7, 0xf3, 0xf9, 0xfc, 0x00,
  0x7e, 0x1c, 0xe1, 0xe5, 0x25, 0xf8, 0xb6, 0x04, 0xff, 0xd5, 0xd3, 0xda,
  0x1d, 0x27, 0x9e, 0x29, 0x6f, 0x0b, 0xb6, 0xd6, 0xa8, 0x00, 0xfc, 0xf6,
  0xb9, 0xe2, 0x3f, 0x9c, 0x40, 0x33, 0xbc, 0x05, 0xbd, 0x06, 0xbd, 0x07,
  0xe6, 0xb9, 0x07, 0x7a, 0xcf, 0xe0, 0xf7, 0xaf, 0xc9, 0x9b, 0x82, 0x7f,
  0x95, 0x78, 0x0d, 0xa4, 0x5c, 0x20, 0x41, 0xb9, 0x05, 0x3e, 0x83, 0x87,
  0x06, 0xaf, 0x56, 0x87, 0xea, 0x2d, 0x69, 0x35, 0x91, 0x92, 0xae, 0x28,
  0xe6, 0x81, 0xc8, 0xad, 0x78, 0xfb, 0x22, 0xbe, 0xbc, 0x04, 0xea, 0xc9,
  0xf4, 0x36, 0xd3, 0xdf, 0x62, 0x41, 0x49, 0x29, 0x89, 0x2d, 0x81, 0xdd,
  0x7d, 0xb0, 0x0a, 0xb8, 0xd5, 0x64, 0x68, 0xb0, 0x7c, 0x4a, 0x54, 0x92,
  0xde, 0x93, 0xa2, 0x2c, 0x5d, 0x81, 0x5d, 0xa2, 0xcb, 0x4f, 0xee, 0x63,
  0x0b, 0x7b, 0x06, 0xba, 0x6b, 0xb0, 0x76, 0xbf, 0x52, 0xc7, 0x7c, 0x6c,
  0xc0, 0x14, 0x30, 0x46, 0x78, 0xee, 0xba, 0x65, 0x52, 0x29, 0x53, 0xd0,
  0x97, 0xa4, 0xf7, 0x00, 0x12, 0x57, 0x22, 0x0f, 0xc7, 0x72, 0x1d, 0x61,
  0x9a, 0x26, 0x6a, 0xad, 0x07, 0x1a, 0x5c, 0xbe, 0x5f, 0x6d, 0x4b, 0x2e,
  0xee, 0x89, 0x08, 0x3a, 0x81, 0xf5, 0xa0, 0xf7, 0x58, 0xe7, 0xdf, 0x5b,
  0xe7, 0xd5, 0x07, 0x4a, 0xf0, 0xc4, 0x2e, 0x81, 0x14, 0xa0, 0xc4, 0x89,
  0x2e, 0x4b, 0xcc, 0x4e, 0x2b, 0xb0, 0xd6, 0xca, 0x9e, 0xa9, 0x2a, 0xa5,
  0x26, 0x7d, 0x09, 0xcc, 0xb3, 0x18, 0x81, 0x3c, 0x51, 0x9f, 0x11, 0xe1,
  0xc6, 0x7c, 0x24, 0xde, 0x86, 0x81, 0x27, 0xa6, 0xc0, 0x96, 0x40, 0x63,
  0xee, 0x2e, 0x4b, 0x37, 0x02, 0x78, 0x60, 0xb0, 0x57, 0xcc, 0xe9, 0x4b,
  0x2c, 0x2c, 0x89, 0x2c, 0xc1, 0xb3, 0xcb, 0x86, 0x0e, 0x46, 0x20, 0x62,
  0xef, 0x84, 0x1f, 0x19, 0x98, 0xc2, 0xe4, 0xe3, 0x7c, 0xd5, 0x67, 0x47,
  0x33, 0xc5, 0x03, 0x29, 0x85, 0xe5, 0x36, 0x81, 0x0e, 0xf2, 0xc0, 0xd3,
  0x4d, 0x01, 0x9e, 0xf8, 0x95, 0x45, 0x57, 0x02, 0x61, 0xc6, 0x61, 0x22,
  0x6d, 0x18, 0x5c, 0xd7, 0xc6, 0x30, 0x0e, 0x46, 0x38, 0x04, 0xb2, 0xd3,
  0x36, 0x50, 0x8e, 0xce, 0xda, 0xbb, 0x94, 0xb8, 0x27, 0xf4, 0x40, 0x43,
  0x38, 0x58, 0x35, 0x18, 0x46, 0x9a, 0xe7, 0x79, 0xf7, 0x0e, 0x1e, 0xb6,
  0xd0, 0xf1, 0x93, 0xc3, 0x2c, 0x29, 0xcc, 0x2c, 0x46, 0x11, 0xcb, 0x23,
  0x0b, 0xdf, 0x1c, 0xea, 0xf4, 0xb9, 0x2f, 0x36, 0x74, 0x30, 0x56, 0x70,
  0x4a, 0x4a, 0xc3, 0xf2, 0x23, 0xfa, 0x57, 0x06, 0x96, 0x5e, 0x08, 0xfa,
  0x6d, 0x7d, 0x89, 0x46, 0x21, 0xf1, 0x98, 0x07, 0x37, 0xd0, 0xc6, 0x13,
  0x15, 0xfa, 0x00, 0x1b, 0x33, 0x22, 0x24, 0x72, 0xb0, 0x50, 0x98, 0x2c,
  0x3e, 0x4a, 0xa4, 0xf3, 0xf9, 0xbc, 0x6a, 0x40, 0x5e, 0x37, 0x90, 0x48,
  0x81, 0x08, 0x61, 0x27, 0x83, 0xba, 0x97, 0x05, 0x4f, 0x2f, 0x16, 0xe5,
  0x08, 0xd3, 0x3b, 0xf5, 0x6b, 0x16, 0x04, 0xc0, 0x47, 0xb7, 0x30, 0x8e,
  0xc9, 0x7c, 0x5c, 0xa0, 0x18, 0xbf, 0x58, 0x22, 0x0b, 0xb3, 0x91, 0xd8,
  0x47, 0x02, 0xde, 0xaf, 0x51, 0x3d, 0x30, 0x4b, 0x6c, 0x58, 0xd7, 0xee,
  0x77, 0x80, 0xd0, 0x61, 0xf7, 0x35, 0x23, 0x2b, 0x46, 0x4a, 0x96, 0xc6,
  0x8d, 0x76, 0x22, 0x2a, 0x06, 0x86, 0x1d, 0xde, 0x41, 0x6b, 0x8d, 0x52,
  0xca, 0x58, 0x23, 0xf4, 0x00, 0x4b, 0x1b, 0x0e, 0xac, 0x92, 0x30, 0x19,
  0x42, 0xbb, 0x1a, 0xd4, 0x5a, 0x29, 0xa5, 0x00, 0xf0, 0x3f, 0xf1, 0x0a,
  0xe7, 0x17, 0xab, 0x56, 0xad, 0x04, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
])};

tests.jpeg = {expect:{type:'image', format:'JPG', mimeType:'image/jpeg', width:16, height:32}, data: new Buffer([
  0xff, 0xd8, 0xff, 0xe0, 0x00, 0x10, 0x4a, 0x46, 0x49, 0x46, 0x00, 0x01,
  0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0xff, 0xdb, 0x00, 0x43,
  0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x03,
  0x03, 0x02, 0x03, 0x05, 0x04, 0x05, 0x05, 0x05, 0x04, 0x05, 0x05, 0x05,
  0x06, 0x08, 0x06, 0x05, 0x06, 0x07, 0x06, 0x05, 0x05, 0x07, 0x09, 0x07,
  0x07, 0x08, 0x08, 0x08, 0x09, 0x08, 0x05, 0x06, 0x09, 0x0a, 0x09, 0x08,
  0x0a, 0x08, 0x08, 0x08, 0x08, 0xff, 0xdb, 0x00, 0x43, 0x01, 0x01, 0x01,
  0x01, 0x02, 0x02, 0x02, 0x04, 0x02, 0x02, 0x04, 0x08, 0x05, 0x05, 0x05,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x08, 0xff, 0xc0, 0x00, 0x11, 0x08, 0x00, 0x20, 0x00, 0x10, 0x03,
  0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xff, 0xc4, 0x00,
  0x18, 0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0b, 0x06, 0x08, 0x09, 0xff,
  0xc4, 0x00, 0x29, 0x10, 0x00, 0x01, 0x02, 0x03, 0x06, 0x05, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x00,
  0x03, 0x07, 0x05, 0x06, 0x11, 0x12, 0x21, 0x71, 0x14, 0x23, 0x41, 0x42,
  0x51, 0x32, 0x34, 0x52, 0xb1, 0xf1, 0xff, 0xc4, 0x00, 0x16, 0x01, 0x01,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x06, 0x07, 0xff, 0xc4, 0x00, 0x21, 0x11, 0x00,
  0x00, 0x04, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x05, 0x00, 0x06, 0x11, 0x12, 0x13,
  0xa1, 0x08, 0x21, 0xd1, 0x03, 0xff, 0xda, 0x00, 0x0c, 0x03, 0x01, 0x00,
  0x02, 0x11, 0x03, 0x11, 0x00, 0x3f, 0x00, 0x3b, 0x1b, 0xfb, 0x79, 0x25,
  0xd9, 0x8c, 0x1c, 0x48, 0x4c, 0xc0, 0x17, 0x94, 0xe6, 0xd7, 0x68, 0x57,
  0x55, 0x07, 0xa2, 0xf8, 0x22, 0x4a, 0xf8, 0x5c, 0x71, 0x29, 0x1e, 0x9f,
  0x1f, 0xb0, 0xc6, 0xfa, 0xb1, 0x7d, 0xb5, 0x7d, 0xce, 0x3d, 0xdd, 0x76,
  0x80, 0xfc, 0xa1, 0xd4, 0x5c, 0xcb, 0x6f, 0x67, 0x8e, 0x10, 0x02, 0x40,
  0x24, 0x84, 0xf9, 0x8c, 0xfe, 0x52, 0x99, 0xca, 0xe0, 0xbd, 0x59, 0x0a,
  0x3d, 0x7c, 0xec, 0xdd, 0xfe, 0x45, 0xbc, 0xcd, 0x2f, 0x19, 0x0a, 0x24,
  0xc7, 0x30, 0x76, 0x7b, 0xf5, 0x67, 0xb0, 0x48, 0xb5, 0x62, 0xfb, 0x7b,
  0xfe, 0x7f, 0xcb, 0xae, 0xd1, 0x49, 0xa8, 0xc5, 0x19, 0x09, 0x4b, 0x34,
  0xa5, 0xa6, 0x00, 0x04, 0xf6, 0xc4, 0x9e, 0xa5, 0x5e, 0xb5, 0xbd, 0x74,
  0xe5, 0xbc, 0xb9, 0xa4, 0x95, 0x12, 0x3e, 0xa3, 0x50, 0xa8, 0x9d, 0x19,
  0x49, 0x9a, 0xc7, 0x3b, 0x64, 0x84, 0x02, 0x09, 0xcc, 0x9d, 0x30, 0x1a,
  0x98, 0x34, 0xf1, 0x2e, 0x6a, 0x17, 0x47, 0x17, 0x83, 0x56, 0xb6, 0xe0,
  0xde, 0x6f, 0x21, 0x01, 0xc9, 0xa9, 0x6c, 0x1b, 0x90, 0xb5, 0x85, 0x28,
  0x26, 0xcd, 0xac, 0x51, 0xff, 0xd9
])};

tests['jpg progressive'] = {expect:{type:'image', format:'JPG', mimeType:'image/jpeg', width:16, height:32}, data: new Buffer([
  0xff, 0xd8, 0xff, 0xe0, 0x00, 0x10, 0x4a, 0x46, 0x49, 0x46, 0x00, 0x01,
  0x02, 0x00, 0x00, 0x64, 0x00, 0x64, 0x00, 0x00, 0xff, 0xec, 0x00, 0x11,
  0x44, 0x75, 0x63, 0x6b, 0x79, 0x00, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x50, 0x00, 0x00, 0xff, 0xee, 0x00, 0x26, 0x41, 0x64, 0x6f, 0x62, 0x65,
  0x00, 0x64, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x15, 0x04, 0x03,
  0x06, 0x0a, 0x0d, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x02, 0x07, 0x00,
  0x00, 0x02, 0x4e, 0x00, 0x00, 0x02, 0xa0, 0xff, 0xdb, 0x00, 0x84, 0x00,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02,
  0x02, 0x02, 0x03, 0x04, 0x03, 0x02, 0x02, 0x03, 0x04, 0x05, 0x04, 0x04,
  0x04, 0x04, 0x04, 0x05, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06,
  0x06, 0x07, 0x07, 0x08, 0x07, 0x07, 0x06, 0x09, 0x09, 0x0a, 0x0a, 0x09,
  0x09, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
  0x0c, 0x0c, 0x0c, 0x0c, 0x01, 0x03, 0x03, 0x03, 0x05, 0x04, 0x05, 0x09,
  0x06, 0x06, 0x09, 0x0d, 0x0b, 0x09, 0x0b, 0x0d, 0x0f, 0x0e, 0x0e, 0x0e,
  0x0e, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x0c, 0x0c,
  0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
  0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
  0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xff, 0xc2, 0x00,
  0x11, 0x08, 0x00, 0x20, 0x00, 0x10, 0x03, 0x01, 0x11, 0x00, 0x02, 0x11,
  0x01, 0x03, 0x11, 0x01, 0xff, 0xc4, 0x00, 0x8e, 0x00, 0x00, 0x02, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x09, 0x04, 0x06, 0x07, 0x01, 0x00, 0x03, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x06, 0x07, 0x05, 0x10, 0x00, 0x02, 0x03, 0x00, 0x03, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x00, 0x10,
  0x02, 0x01, 0x11, 0x21, 0x12, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x21, 0x31, 0x02, 0x12, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x13, 0x01, 0x00,
  0x02, 0x01, 0x04, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x11, 0x10, 0x21, 0x31, 0x41, 0x51, 0x20, 0x61,
  0x71, 0xa1, 0xc1, 0xf1, 0xff, 0xda, 0x00, 0x0c, 0x03, 0x01, 0x00, 0x02,
  0x11, 0x03, 0x11, 0x00, 0x00, 0x01, 0x3b, 0x05, 0x21, 0x5d, 0x14, 0x3b,
  0x1b, 0x5e, 0xdc, 0x0f, 0xd8, 0x70, 0xc9, 0x14, 0x47, 0x2a, 0x4b, 0xda,
  0x6c, 0x99, 0x5d, 0x23, 0x51, 0xaa, 0x4d, 0xff, 0x00, 0xff, 0xda, 0x00,
  0x08, 0x01, 0x01, 0x00, 0x01, 0x05, 0x02, 0x39, 0x3e, 0x72, 0x82, 0x51,
  0xb3, 0x44, 0x52, 0xf1, 0xb3, 0x44, 0xd3, 0x8c, 0x97, 0xbe, 0x52, 0x4e,
  0x7f, 0xff, 0xda, 0x00, 0x08, 0x01, 0x02, 0x00, 0x01, 0x05, 0x02, 0x26,
  0xba, 0xa3, 0x6e, 0x8d, 0xba, 0x2e, 0xeb, 0xff, 0xda, 0x00, 0x08, 0x01,
  0x03, 0x00, 0x01, 0x05, 0x02, 0xc6, 0x68, 0x58, 0xa1, 0x62, 0x87, 0x9a,
  0xff, 0xda, 0x00, 0x08, 0x01, 0x02, 0x02, 0x06, 0x3f, 0x02, 0x0f, 0xff,
  0xda, 0x00, 0x08, 0x01, 0x03, 0x02, 0x06, 0x3f, 0x02, 0x0f, 0xff, 0xda,
  0x00, 0x08, 0x01, 0x01, 0x01, 0x06, 0x3f, 0x02, 0xae, 0x2b, 0xce, 0x2a,
  0x62, 0xc4, 0xc7, 0xff, 0xda, 0x00, 0x08, 0x01, 0x01, 0x03, 0x01, 0x3f,
  0x21, 0x32, 0x5f, 0xcc, 0xd0, 0x18, 0xed, 0xca, 0x21, 0xed, 0xe3, 0x94,
  0x87, 0x79, 0xaf, 0xc5, 0x3f, 0xff, 0xda, 0x00, 0x08, 0x01, 0x02, 0x03,
  0x01, 0x3f, 0x21, 0xa5, 0xe4, 0xb6, 0x38, 0xff, 0xda, 0x00, 0x08, 0x01,
  0x03, 0x03, 0x01, 0x3f, 0x21, 0xb9, 0xf2, 0x0a, 0xf1, 0xff, 0xda, 0x00,
  0x0c, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x00, 0x10, 0xa3,
  0x0a, 0x30, 0xff, 0xda, 0x00, 0x08, 0x01, 0x01, 0x03, 0x01, 0x3f, 0x10,
  0x20, 0xd1, 0xa6, 0x3d, 0x8a, 0x85, 0x57, 0x5f, 0xd9, 0xf6, 0xff, 0x00,
  0x93, 0xdc, 0x14, 0xad, 0x77, 0x3e, 0xdf, 0x9f, 0x88, 0x60, 0x0d, 0x20,
  0x71, 0x35, 0x98, 0x24, 0x82, 0xde, 0x40, 0x8b, 0x67, 0x06, 0xb3, 0xff,
  0xda, 0x00, 0x08, 0x01, 0x02, 0x03, 0x01, 0x3f, 0x10, 0x24, 0x31, 0xbb,
  0xae, 0x37, 0x75, 0xc3, 0x30, 0x63, 0xff, 0xda, 0x00, 0x08, 0x01, 0x03,
  0x03, 0x01, 0x3f, 0x10, 0x42, 0x71, 0xb7, 0x8d, 0xbc, 0x00, 0x1c, 0x7f,
  0xff, 0xd9
])};

tests['null'] = {expect:false, data: new Buffer([
  0x00
])};

tests.gif = {expect:{type:'image', format:'GIF', mimeType:'image/gif', width:16, height:32}, data: new Buffer([
  0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x10, 0x00, 0x20, 0x00, 0xf4, 0x1c,
  0x00, 0xfe, 0x92, 0x23, 0x34, 0x34, 0x34, 0x3a, 0x3a, 0x3a, 0x42, 0x42,
  0x42, 0x4b, 0x4b, 0x4b, 0x53, 0x53, 0x53, 0x5b, 0x5b, 0x5b, 0x63, 0x63,
  0x63, 0x6c, 0x6c, 0x6c, 0x73, 0x73, 0x73, 0x7c, 0x7c, 0x7c, 0x83, 0x83,
  0x83, 0x8a, 0x8a, 0x8a, 0x92, 0x92, 0x92, 0x9b, 0x9b, 0x9b, 0xa3, 0xa3,
  0xa3, 0xab, 0xab, 0xab, 0xb4, 0xb4, 0xb4, 0xbb, 0xbb, 0xbb, 0xc4, 0xc4,
  0xc4, 0xcb, 0xcb, 0xcb, 0xd3, 0xd3, 0xd3, 0xdb, 0xdb, 0xdb, 0xe3, 0xe3,
  0xe3, 0xeb, 0xeb, 0xeb, 0xf4, 0xf4, 0xf4, 0xfe, 0xfe, 0xfe, 0x2d, 0x2d,
  0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x21, 0xf9, 0x04, 0x05, 0x00, 0x00, 0x1c, 0x00, 0x2c, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x05, 0xb9, 0x20, 0x27, 0x8e,
  0xe2, 0xb6, 0x05, 0xc2, 0x40, 0x14, 0x05, 0x09, 0xbc, 0x40, 0x61, 0x1c,
  0x48, 0x92, 0x28, 0x0b, 0xac, 0x03, 0x0b, 0xd3, 0x38, 0x8e, 0x07, 0x04,
  0xb2, 0x83, 0x45, 0x24, 0x93, 0x09, 0x85, 0x52, 0xb1, 0x90, 0x46, 0x80,
  0x81, 0x4a, 0x76, 0xa0, 0x89, 0x8a, 0x35, 0x1c, 0xc3, 0xe7, 0x28, 0xbe,
  0x82, 0xc3, 0x63, 0xd2, 0x0b, 0x60, 0x36, 0x2f, 0x17, 0x4c, 0xe6, 0x39,
  0x42, 0x49, 0x59, 0x33, 0xf6, 0x6b, 0x55, 0xa8, 0xd6, 0x12, 0x50, 0x5d,
  0xd5, 0xa6, 0x65, 0x70, 0xbc, 0x09, 0x0b, 0x3d, 0x3f, 0x41, 0x64, 0x84,
  0x42, 0x10, 0x47, 0x64, 0x61, 0x12, 0x48, 0x4c, 0x64, 0x8e, 0x15, 0x67,
  0x18, 0x64, 0x67, 0x69, 0x19, 0x1a, 0x1a, 0x6c, 0x25, 0x6e, 0x74, 0x06,
  0x9b, 0x00, 0x29, 0x53, 0x33, 0x07, 0x72, 0x51, 0x2b, 0xa4, 0x35, 0x4f,
  0x30, 0x70, 0x34, 0x7c, 0x2e, 0x30, 0x33, 0x77, 0x5a, 0x57, 0x3b, 0x34,
  0x0a, 0x38, 0x83, 0x7f, 0x45, 0x37, 0x3d, 0x5c, 0x5d, 0x5e, 0x0a, 0x5b,
  0x87, 0x44, 0x5e, 0xbf, 0x88, 0x11, 0x64, 0x40, 0xc8, 0x8d, 0x64, 0xcc,
  0x8e, 0x8b, 0x47, 0x91, 0x15, 0x90, 0xd3, 0x16, 0x17, 0x64, 0x4a, 0x92,
  0xd7, 0x17, 0x19, 0x64, 0x4c, 0xdc, 0x6a, 0x1a, 0x64, 0xe1, 0x19, 0x98,
  0x1a, 0x21, 0x00, 0x3b
])};

tests.swf = {expect:{type:'flash', format:'SWF', mimeType:'application/x-shockwave-flash', width:16, height:32}, data: new Buffer([
  0x46, 0x57, 0x53, 0x0a, 0x92, 0x00, 0x00, 0x00, 0x58, 0x00, 0x28, 0x00,
  0x01, 0x40, 0x00, 0x00, 0x19, 0x01, 0x00, 0x44, 0x11, 0x08, 0x00, 0x00,
  0x00, 0x43, 0x02, 0xff, 0xff, 0xff, 0xbf, 0x15, 0x0b, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x53, 0x63, 0x65, 0x6e, 0x65, 0x20, 0x31, 0x00, 0x00, 0x3f,
  0x08, 0x51, 0x00, 0x00, 0x00, 0x01, 0x00, 0x58, 0x00, 0x28, 0x00, 0x01,
  0x40, 0x00, 0x02, 0x10, 0xb3, 0x40, 0xee, 0x32, 0xbd, 0x00, 0x8e, 0x94,
  0x78, 0x28, 0x00, 0x02, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
  0x00, 0xff, 0x10, 0xb3, 0x43, 0x2e, 0x1a, 0xbd, 0x14, 0x8d, 0x94, 0x28,
  0x28, 0x00, 0x02, 0x00, 0xff, 0x99, 0x00, 0xff, 0xff, 0xff, 0x98, 0x00,
  0x00, 0x00, 0x20, 0x1d, 0x62, 0x81, 0x40, 0x4f, 0x2d, 0x80, 0x10, 0xdc,
  0xb0, 0x72, 0xa8, 0x0d, 0xc5, 0x00, 0x4e, 0xe2, 0x83, 0x96, 0xc0, 0x6e,
  0x58, 0x00, 0x86, 0x06, 0x06, 0x01, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00,
  0x00, 0x00
])};

tests['swf compressed'] = {expect:{type:'flash', format:'SWF', mimeType:'application/x-shockwave-flash', width:null, height:null}, data: new Buffer([
  0x43, 0x57, 0x53, 0x0a, 0x92, 0x00, 0x00, 0x00, 0x78, 0x9c, 0x8b, 0x60,
  0xd0, 0x60, 0x60, 0x74, 0x60, 0x60, 0x90, 0x64, 0x64, 0x70, 0x11, 0xe4,
  0x60, 0x60, 0x60, 0x70, 0x66, 0xfa, 0xff, 0xff, 0xff, 0x7e, 0x51, 0x6e,
  0x20, 0x93, 0x91, 0x21, 0x38, 0x39, 0x35, 0x2f, 0x55, 0xc1, 0x90, 0x81,
  0xc1, 0x9e, 0x23, 0x10, 0x2c, 0x10, 0x01, 0x51, 0xce, 0x24, 0xb0, 0xd9,
  0xe1, 0x9d, 0xd1, 0x5e, 0x86, 0xbe, 0x29, 0x15, 0x1a, 0x0c, 0x4c, 0x0c,
  0xff, 0x41, 0x00, 0x28, 0xff, 0x5f, 0x60, 0xb3, 0xb3, 0x9e, 0xd4, 0x5e,
  0x91, 0xde, 0x29, 0x1a, 0x60, 0xe1, 0x99, 0x20, 0x99, 0x19, 0x40, 0x09,
  0x05, 0xd9, 0xa4, 0x46, 0x07, 0x7f, 0xdd, 0x06, 0x81, 0x3b, 0x1b, 0x8a,
  0x56, 0xf0, 0x1e, 0x65, 0xf0, 0x7b, 0xd4, 0x3c, 0xed, 0x40, 0x5e, 0x04,
  0x43, 0x1b, 0x1b, 0x1b, 0x23, 0xd0, 0x54, 0x06, 0xa0, 0x03, 0x18, 0x00,
  0x77, 0xaf, 0x26, 0xda
])};
