// Generated by CoffeeScript 1.12.1
(function() {
  var Adapter, Babel, W, path, pick, sourcemaps,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  W = require('when');

  pick = require('lodash.pick');

  Adapter = require('../../adapter_base');

  sourcemaps = require('../../sourcemaps');

  Babel = (function(superClass) {
    var compile;

    extend(Babel, superClass);

    function Babel() {
      return Babel.__super__.constructor.apply(this, arguments);
    }

    Babel.prototype.name = 'babel';

    Babel.prototype.extensions = ['js', 'jsx'];

    Babel.prototype.output = 'js';

    Babel.prototype.isolated = true;

    Babel.prototype.supportedEngines = ['babel-core'];

    Babel.prototype._render = function(str, options) {
      var allowed_keys, filename, sanitized_options;
      filename = options.filename;
      if (options.sourcemap === true) {
        options.sourceMaps = true;
      }
      options.sourceFileName = filename;
      delete options.sourcemap;
      allowed_keys = ['filename', 'filenameRelative', 'presets', 'plugins', 'highlightCode', 'only', 'ignore', 'auxiliaryCommentBefore', 'auxiliaryCommentAfter', 'sourceMaps', 'inputSourceMap', 'sourceMapTarget', 'sourceRoot', 'moduleRoot', 'moduleIds', 'moduleId', 'getModuleId', 'resolveModuleSource', 'code', 'babelrc', 'ast', 'compact', 'comments', 'shouldPrintComment', 'env', 'retainLines', 'extends'];
      sanitized_options = pick(options, allowed_keys);
      return compile((function(_this) {
        return function() {
          return _this.engine.transform(str, sanitized_options);
        };
      })(this));
    };

    compile = function(fn) {
      var data, dirname, err, res;
      try {
        res = fn();
      } catch (error) {
        err = error;
        return W.reject(err);
      }
      data = {
        result: res.code
      };
      if (res.map) {
        if (res.map.sources) {
          dirname = path.dirname(res.options.filename);
          res.map.sources = res.map.sources.map(function(source) {
            return path.join(dirname, source);
          });
        }
        return sourcemaps.inline_sources(res.map).then(function(map) {
          data.sourcemap = map;
          return data;
        });
      } else {
        return W.resolve(data);
      }
    };

    return Babel;

  })(Adapter);

  module.exports = Babel;

}).call(this);
