/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import vazkii.neat.NeatConfig;

public class HealthBarRenderer {
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!NeatConfig.renderInF1 && !Minecraft.func_71382_s()) {
            return;
        }
        EntityLivingBase cameraEntity = mc.field_71451_h;
        Vec3 renderingVector = cameraEntity.func_70666_h(event.partialTicks);
        Frustrum frustrum = new Frustrum();
        double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)event.partialTicks;
        double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)event.partialTicks;
        double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)event.partialTicks;
        frustrum.func_78547_a(viewX, viewY, viewZ);
        WorldClient client = mc.field_71441_e;
        Set entities = (Set)ReflectionHelper.getPrivateValue(WorldClient.class, (Object)client, (String[])new String[]{"entityList", "field_73032_d", "J"});
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof EntityLiving) || !entity.func_145770_h(renderingVector.field_72450_a, renderingVector.field_72448_b, renderingVector.field_72449_c) || !entity.field_70158_ak && !frustrum.func_78546_a(entity.field_70121_D) || !entity.func_70089_S()) continue;
            this.renderHealthBar((EntityLivingBase)((EntityLiving)entity), event.partialTicks, (Entity)cameraEntity);
        }
    }

    public void renderHealthBar(EntityLivingBase passedEntity, float partialTicks, Entity viewPoint) {
        if (passedEntity.field_70153_n != null) {
            return;
        }
        EntityLivingBase entity = passedEntity;
        while (entity.field_70154_o != null && entity.field_70154_o instanceof EntityLivingBase) {
            entity = (EntityLivingBase)entity.field_70154_o;
        }
        Minecraft mc = Minecraft.func_71410_x();
        float pastTranslate = 0.0f;
        while (entity != null) {
            Entity riddenBy;
            float distance = passedEntity.func_70032_d(viewPoint);
            if (!(distance > (float)NeatConfig.maxDistance || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || !NeatConfig.showOnBosses && entity instanceof IBossDisplayData || !NeatConfig.showOnPlayers && entity instanceof EntityPlayer)) {
                double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
                double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
                double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
                float scale = 0.026666673f;
                float maxHealth = entity.func_110138_aP();
                float health = Math.min(maxHealth, entity.func_110143_aJ());
                if (!(maxHealth <= 0.0f)) {
                    float namel;
                    boolean useHue;
                    float percent = (int)(health / maxHealth * 100.0f);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)(x - RenderManager.field_78725_b)), (float)((float)(y - RenderManager.field_78726_c + (double)passedEntity.field_70131_O + NeatConfig.heightAbove)), (float)((float)(z - RenderManager.field_78723_d)));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
                    GL11.glDisable((int)2896);
                    GL11.glDepthMask((boolean)false);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3553);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    float padding = NeatConfig.backgroundPadding;
                    int bgHeight = NeatConfig.backgroundHeight;
                    int barHeight = NeatConfig.barHeight;
                    float size = NeatConfig.plateSize;
                    int r = 0;
                    int g = 255;
                    int b = 0;
                    ItemStack stack = null;
                    if (entity instanceof IMob) {
                        r = 255;
                        g = 0;
                        EnumCreatureAttribute attr = entity.func_70668_bt();
                        switch (attr) {
                            case ARTHROPOD: {
                                stack = new ItemStack(Items.field_151070_bp);
                                break;
                            }
                            case UNDEAD: {
                                stack = new ItemStack(Items.field_151078_bh);
                                break;
                            }
                            default: {
                                stack = new ItemStack(Items.field_151144_bL, 1, 4);
                            }
                        }
                    }
                    if (entity instanceof IBossDisplayData) {
                        stack = new ItemStack(Items.field_151144_bL);
                        size = NeatConfig.plateSizeBoss;
                        r = 128;
                        g = 0;
                        b = 128;
                    }
                    int armor = entity.func_70658_aO();
                    boolean bl = useHue = !NeatConfig.colorByType;
                    if (useHue) {
                        float hue = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
                        Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                        r = color.getRed();
                        g = color.getGreen();
                        b = color.getBlue();
                    }
                    GL11.glTranslatef((float)0.0f, (float)pastTranslate, (float)0.0f);
                    float s = 0.5f;
                    String name = StatCollector.func_74838_a((String)("entity." + EntityList.func_75621_b((Entity)entity) + ".name"));
                    if (entity instanceof EntityLiving && ((EntityLiving)entity).func_94056_bM()) {
                        name = EnumChatFormatting.ITALIC + ((EntityLiving)entity).func_94057_bL();
                    }
                    if ((namel = (float)mc.field_71466_p.func_78256_a(name) * s) + 20.0f > size * 2.0f) {
                        size = namel / 2.0f + 10.0f;
                    }
                    float healthSize = size * (health / maxHealth);
                    if (NeatConfig.drawBackground) {
                        tessellator.func_78382_b();
                        tessellator.func_78370_a(0, 0, 0, 64);
                        tessellator.func_78377_a((double)(-size - padding), (double)(-bgHeight), 0.0);
                        tessellator.func_78377_a((double)(-size - padding), (double)((float)barHeight + padding), 0.0);
                        tessellator.func_78377_a((double)(size + padding), (double)((float)barHeight + padding), 0.0);
                        tessellator.func_78377_a((double)(size + padding), (double)(-bgHeight), 0.0);
                        tessellator.func_78381_a();
                    }
                    tessellator.func_78382_b();
                    tessellator.func_78370_a(127, 127, 127, 127);
                    tessellator.func_78377_a((double)(-size), 0.0, 0.0);
                    tessellator.func_78377_a((double)(-size), (double)barHeight, 0.0);
                    tessellator.func_78377_a((double)size, (double)barHeight, 0.0);
                    tessellator.func_78377_a((double)size, 0.0, 0.0);
                    tessellator.func_78381_a();
                    tessellator.func_78382_b();
                    tessellator.func_78370_a(r, g, b, 127);
                    tessellator.func_78377_a((double)(-size), 0.0, 0.0);
                    tessellator.func_78377_a((double)(-size), (double)barHeight, 0.0);
                    tessellator.func_78377_a((double)(healthSize * 2.0f - size), (double)barHeight, 0.0);
                    tessellator.func_78377_a((double)(healthSize * 2.0f - size), 0.0, 0.0);
                    tessellator.func_78381_a();
                    GL11.glEnable((int)3553);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(-size), (float)-4.5f, (float)0.0f);
                    GL11.glScalef((float)s, (float)s, (float)s);
                    mc.field_71466_p.func_78276_b(name, 0, 0, 0xFFFFFF);
                    GL11.glPushMatrix();
                    float s1 = 0.75f;
                    GL11.glScalef((float)s1, (float)s1, (float)s1);
                    int h = NeatConfig.hpTextHeight;
                    String maxHpStr = EnumChatFormatting.BOLD + "" + (double)Math.round((double)maxHealth * 100.0) / 100.0;
                    String hpStr = "" + (double)Math.round((double)health * 100.0) / 100.0;
                    String percStr = (int)percent + "%";
                    if (maxHpStr.endsWith(".0")) {
                        maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 2);
                    }
                    if (hpStr.endsWith(".0")) {
                        hpStr = hpStr.substring(0, hpStr.length() - 2);
                    }
                    if (NeatConfig.showCurrentHP) {
                        mc.field_71466_p.func_78276_b(hpStr, 2, h, 0xFFFFFF);
                    }
                    if (NeatConfig.showMaxHP) {
                        mc.field_71466_p.func_78276_b(maxHpStr, (int)(size / (s * s1) * 2.0f) - 2 - mc.field_71466_p.func_78256_a(maxHpStr), h, 0xFFFFFF);
                    }
                    if (NeatConfig.showPercentage) {
                        mc.field_71466_p.func_78276_b(percStr, (int)(size / (s * s1)) - mc.field_71466_p.func_78256_a(percStr) / 2, h, -1);
                    }
                    GL11.glPopMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int off = 0;
                    s1 = 0.5f;
                    GL11.glScalef((float)s1, (float)s1, (float)s1);
                    GL11.glTranslatef((float)(size / (s * s1) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
                    mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
                    if (stack != null && NeatConfig.showAttributes) {
                        RenderItem.getInstance().func_94149_a(off, 0, stack.func_77954_c(), 16, 16);
                        off -= 16;
                    }
                    if (armor > 0 && NeatConfig.showArmor) {
                        int i;
                        int ironArmor = armor % 5;
                        int diamondArmor = armor / 5;
                        if (!NeatConfig.groupArmor) {
                            ironArmor = armor;
                            diamondArmor = 0;
                        }
                        stack = new ItemStack((Item)Items.field_151030_Z);
                        for (i = 0; i < ironArmor; ++i) {
                            RenderItem.getInstance().func_94149_a(off, 0, stack.func_77954_c(), 16, 16);
                            off -= 4;
                        }
                        stack = new ItemStack((Item)Items.field_151163_ad);
                        for (i = 0; i < diamondArmor; ++i) {
                            RenderItem.getInstance().func_94149_a(off, 0, stack.func_77954_c(), 16, 16);
                            off -= 4;
                        }
                    }
                    GL11.glPopMatrix();
                    GL11.glEnable((int)2929);
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2896);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                    pastTranslate = -((float)(bgHeight + barHeight) + padding);
                }
            }
            if ((riddenBy = entity.field_70153_n) instanceof EntityLivingBase) {
                entity = (EntityLivingBase)riddenBy;
                continue;
            }
            return;
        }
    }
}

