﻿--变量
local id = 1;
local _G = _G;

--BOSS生命值百分比
for id = 1, MAX_BOSS_FRAMES, 1 do
    local BossHPPct = CreateFrame("Frame", "UFP_Boss"..id.."HPPct", _G["Boss"..id.."TargetFrameHealthBar"]);
    BossHPPct:SetWidth(50)
    BossHPPct:SetHeight(20)
    BossHPPct:ClearAllPoints();
    BossHPPct:SetPoint("LEFT", _G["Boss"..id.."TargetFrameHealthBar"], "LEFT", -51, 0)
    BossHPPct.Text = BossHPPct:CreateFontString("UFP_Boss"..id.."HPPctText", "ARTWORK", "TextStatusBarText")
    BossHPPct.Text:SetAllPoints(BossHPPct)
    BossHPPct.Text:SetFont(GameFontNormal:GetFont(), 12, "OUTLINE");
    BossHPPct.Text:SetTextColor(1, 0.75, 0);
    BossHPPct.Text:SetJustifyH("RIGHT")
end

function UnitFramesPlus_BossHealthPct()
    if UnitFramesPlusDB["extra"]["bosshppct"] == 1 then
        for id = 1, MAX_BOSS_FRAMES, 1 do
            _G["UFP_Boss"..id.."HPPct"]:RegisterEvent("INSTANCE_ENCOUNTER_ENGAGE_UNIT");
            _G["UFP_Boss"..id.."HPPct"]:RegisterUnitEvent("UNIT_HEALTH_FREQUENT", "boss"..id)
            _G["UFP_Boss"..id.."HPPct"]:SetScript("OnEvent", function(self, event, ...)
                UnitFramesPlus_BossHealthPctDisplayUpdate(id);
            end)
        end
    else
        for id = 1, MAX_BOSS_FRAMES, 1 do
            _G["UFP_Boss"..id.."HPPct"].Text:SetText("");
            if _G["UFP_Boss"..id.."HPPct"]:IsEventRegistered("INSTANCE_ENCOUNTER_ENGAGE_UNIT") then
                _G["UFP_Boss"..id.."HPPct"]:UnregisterEvent("INSTANCE_ENCOUNTER_ENGAGE_UNIT");
                _G["UFP_Boss"..id.."HPPct"]:UnregisterEvent("UNIT_HEALTH_FREQUENT");
                _G["UFP_Boss"..id.."HPPct"]:SetScript("OnEvent", nil);
            end
        end
    end
end

--刷新目标生命值百分比显示
function UnitFramesPlus_BossHealthPctDisplayUpdate(id)
    local PctText = "";
    if UnitExists("boss"..id) and UnitFramesPlusDB["extra"]["bosshppct"] == 1 then
        local CurHP = UnitHealth("boss"..id);
        local MaxHP = UnitHealthMax("boss"..id);
        if MaxHP > 0 then
            PctText = math.floor(100*CurHP/MaxHP).."%";
        end
    end
    _G["UFP_Boss"..id.."HPPct"].Text:SetText(PctText);
end

--治疗职业距离检测
local function UnitFramesPlus_RangeCheckInit()
    local class = select(2, UnitClass("player"));
    local spellname = "";
    local enable = 0;
    if class == "SHAMAN" then
        enable = 1;
        spellname = GetSpellInfo(8004);--治疗之涌,7+
    elseif class == "DRUID" then
        enable = 1;
        spellname = GetSpellInfo(774);--回春术,10+
    elseif class == "PALADIN" then
        enable = 1;
        spellname = GetSpellInfo(19750);--圣光闪现,8+
    elseif class == "PRIEST" then
        enable = 1;
        spellname = GetSpellInfo(2061);--快速治疗,10+
    elseif class == "MONK" then
        enable = 1;
        spellname = GetSpellInfo(116694);--真气贯通,8+
    end
    UnitFramesPlusVar["rangecheck"]["enable"] = enable;
    UnitFramesPlusVar["rangecheck"]["spellname"] = spellname;
end

local rcframes = {
    TargetFrame,
    FocusFrame,
    PartyMemberFrame1,
    PartyMemberFrame2,
    PartyMemberFrame3,
    PartyMemberFrame4,
}

local rc = CreateFrame("Frame");
function UnitFramesPlus_RangeCheck()
    if UnitFramesPlusVar["rangecheck"]["enable"] == 1 then
        if UnitFramesPlusDB["global"]["rangecheck"] == 1 then
            rc:SetScript("OnUpdate", function(self, elapsed)
                self.timer = (self.timer or 0) + elapsed;
                if self.timer >= 0.2 then
                    for i, frame in pairs(rcframes) do
                        if frame:IsShown() and frame.unit then
                            local inRange = IsSpellInRange(UnitFramesPlusVar["rangecheck"]["spellname"], frame.unit);
                            local _, instanceType = IsInInstance();
                            if (inRange == 0 or not UnitIsVisible(frame.unit)) and not (instanceType == "none" and UnitFramesPlusDB["global"]["instanceonly"] == 1) then
                                frame:SetAlpha(0.5);
                            else
                                frame:SetAlpha(1);
                            end
                        else
                            frame:SetAlpha(1);
                        end
                    end
                end
            end)
        else
            rc:SetScript("OnUpdate", nil);
        end
    end
end

--状态条数值显示为万亿
local function UnitFramesPlus_AbbreviateLargeNumbers(value)
    if GetLocale() == "zhCN" then
        unitbig = "亿";
        unitsmall = "万";
    elseif GetLocale() == "zhTW" then
        unitbig = "億";
        unitsmall = "萬";
    end
    local retString = value;
    if value >= 100000000 then
        retString = (math.floor(value/10000000)/10)..unitbig;
    elseif value >= 10000 then
        retString = math.floor(value/10000)..unitsmall;
    end
    return retString;
end
 
function UnitFramesPlus_TextStatusBar_UpdateTextStringWithValues(statusFrame, textString, value, valueMin, valueMax)
    if UnitFramesPlusDB["global"]["textunit"] == 1 then
        if( statusFrame.LeftText and statusFrame.RightText ) then
            statusFrame.LeftText:SetText("");
            statusFrame.RightText:SetText("");
            statusFrame.LeftText:Hide();
            statusFrame.RightText:Hide();
        end
     
        if ( ( tonumber(valueMax) ~= valueMax or valueMax > 0 ) and not ( statusFrame.pauseUpdates ) ) then
            statusFrame:Show();
         
            if ( (statusFrame.cvar and GetCVar(statusFrame.cvar) == "1" and statusFrame.textLockable) or statusFrame.forceShow ) then
                textString:Show();
            elseif ( statusFrame.lockShow > 0 and (not statusFrame.forceHideText) ) then
                textString:Show();
            else
                textString:SetText("");
                textString:Hide();
                return;
            end
     
            local valueDisplay = value;
            local valueMaxDisplay = valueMax;
            if ( statusFrame.capNumericDisplay ) then
                valueDisplay = UnitFramesPlus_AbbreviateLargeNumbers(value);
                valueMaxDisplay = UnitFramesPlus_AbbreviateLargeNumbers(valueMax);
            else
                valueDisplay = BreakUpLargeNumbers(value);
                valueMaxDisplay = BreakUpLargeNumbers(valueMax);
            end
     
            local textDisplay = GetCVar("statusTextDisplay");
            if ( value and valueMax > 0 and ( textDisplay ~= "NUMERIC" or statusFrame.showPercentage ) and not statusFrame.showNumeric) then
                if ( value == 0 and statusFrame.zeroText ) then
                    textString:SetText(statusFrame.zeroText);
                    statusFrame.isZero = 1;
                    textString:Show();
                elseif ( textDisplay == "BOTH" and not statusFrame.showPercentage) then
                    if( statusFrame.LeftText and statusFrame.RightText ) then
                        if(not statusFrame.powerToken or statusFrame.powerToken == "MANA") then
                            statusFrame.LeftText:SetText(math.ceil((value / valueMax) * 100) .. "%");
                            statusFrame.LeftText:Show();
                        end
                        statusFrame.RightText:SetText(valueDisplay);
                        statusFrame.RightText:Show();
                        textString:Hide();
                    else
                        valueDisplay = "(" .. math.ceil((value / valueMax) * 100) .. "%) " .. valueDisplay .. " / " .. valueMaxDisplay;
                    end
                    textString:SetText(valueDisplay);
                else
                    valueDisplay = math.ceil((value / valueMax) * 100) .. "%";
                    if ( statusFrame.prefix and (statusFrame.alwaysPrefix or not (statusFrame.cvar and GetCVar(statusFrame.cvar) == "1" and statusFrame.textLockable) ) ) then
                        textString:SetText(statusFrame.prefix .. " " .. valueDisplay);
                    else
                        textString:SetText(valueDisplay);
                    end
                end
            elseif ( value == 0 and statusFrame.zeroText ) then
                textString:SetText(statusFrame.zeroText);
                statusFrame.isZero = 1;
                textString:Show();
                return;
            else
                statusFrame.isZero = nil;
                if ( statusFrame.prefix and (statusFrame.alwaysPrefix or not (statusFrame.cvar and GetCVar(statusFrame.cvar) == "1" and statusFrame.textLockable) ) ) then
                    textString:SetText(statusFrame.prefix.." "..valueDisplay.." / "..valueMaxDisplay);
                else
                    textString:SetText(valueDisplay.." / "..valueMaxDisplay);
                end
            end
        else
            textString:Hide();
            textString:SetText("");
            if ( not statusFrame.alwaysShow ) then
                statusFrame:Hide();
            else
                statusFrame:SetValue(0);
            end
        end
    end
end

function UnitFramesPlus_ExtraInit()
    UnitFramesPlus_BossHealthPct();
    UnitFramesPlus_RangeCheckInit();
    UnitFramesPlus_RangeCheck();
    if GetLocale() == "zhCN" or GetLocale() == "zhTW" then
        hooksecurefunc("TextStatusBar_UpdateTextStringWithValues", UnitFramesPlus_TextStatusBar_UpdateTextStringWithValues);
    end
end
