/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.java2d.opengl.WGLSurfaceData;

public class WGLVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public WGLVolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        int n = sunVolatileImage.getTransparency();
        WGLGraphicsConfig wGLGraphicsConfig = (WGLGraphicsConfig)sunVolatileImage.getGraphicsConfig();
        this.accelerationEnabled = n == 1 || n == 3 && (wGLGraphicsConfig.isCapPresent(16) || wGLGraphicsConfig.isCapPresent(2));
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        WGLSurfaceData.WGLOffScreenSurfaceData wGLOffScreenSurfaceData;
        Component component = this.vImg.getComponent();
        WComponentPeer wComponentPeer = component != null ? (WComponentPeer)component.getPeer() : null;
        try {
            boolean bl = false;
            if (this.context instanceof Boolean) {
                bl = (Boolean)this.context;
            }
            if (bl) {
                wGLOffScreenSurfaceData = WGLSurfaceData.createData(wComponentPeer, this.vImg);
            } else {
                WGLGraphicsConfig wGLGraphicsConfig = (WGLGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel colorModel = wGLGraphicsConfig.getColorModel(this.vImg.getTransparency());
                int n = wGLGraphicsConfig.isCapPresent(16) ? 5 : 2;
                wGLOffScreenSurfaceData = WGLSurfaceData.createData(wGLGraphicsConfig, this.vImg.getWidth(), this.vImg.getHeight(), colorModel, this.vImg, n);
            }
        }
        catch (NullPointerException nullPointerException) {
            wGLOffScreenSurfaceData = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            wGLOffScreenSurfaceData = null;
        }
        return wGLOffScreenSurfaceData;
    }

    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration == this.vImg.getGraphicsConfig();
    }
}

