/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContextReceiver;
import com.sun.xml.internal.ws.client.sei.BodyBuilder;
import com.sun.xml.internal.ws.client.sei.MessageFiller;
import com.sun.xml.internal.ws.client.sei.MethodHandler;
import com.sun.xml.internal.ws.client.sei.ResponseBuilder;
import com.sun.xml.internal.ws.client.sei.SEIStub;
import com.sun.xml.internal.ws.client.sei.ValueGetter;
import com.sun.xml.internal.ws.client.sei.ValueSetter;
import com.sun.xml.internal.ws.encoding.soap.DeserializationException;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

final class SyncMethodHandler
extends MethodHandler {
    private final BodyBuilder bodyBuilder;
    private final MessageFiller[] inFillers;
    private final String soapAction;
    private final boolean isOneWay;
    private final JavaMethodImpl javaMethod;
    final ValueGetter[] valueGetters;
    private final ResponseBuilder responseBuilder;
    private final Map<QName, CheckedExceptionImpl> checkedExceptions = new HashMap<QName, CheckedExceptionImpl>();

    /*
     * WARNING - void declaration
     */
    public SyncMethodHandler(SEIStub sEIStub, JavaMethodImpl javaMethodImpl) {
        super(sEIStub);
        void var4_12;
        void var4_6;
        for (CheckedExceptionImpl object2 : javaMethodImpl.getCheckedExceptions()) {
            this.checkedExceptions.put(object2.getBridge().getTypeReference().tagName, object2);
        }
        this.soapAction = javaMethodImpl.getInputAction() != null && !javaMethodImpl.getBinding().getSOAPAction().equals("") ? javaMethodImpl.getInputAction() : javaMethodImpl.getBinding().getSOAPAction();
        this.javaMethod = javaMethodImpl;
        List<ParameterImpl> list = javaMethodImpl.getRequestParameters();
        Object var4_5 = null;
        ArrayList<MessageFiller> arrayList = new ArrayList<MessageFiller>();
        this.valueGetters = new ValueGetter[list.size()];
        block21: for (ParameterImpl parameterImpl : list) {
            ValueGetter valueGetter = ValueGetter.get(parameterImpl);
            switch (parameterImpl.getInBinding().kind) {
                case BODY: {
                    if (parameterImpl.isWrapperStyle()) {
                        if (parameterImpl.getParent().getBinding().isRpcLit()) {
                            BodyBuilder.RpcLit rpcLit = new BodyBuilder.RpcLit((WrapperParameter)parameterImpl, sEIStub.soapVersion);
                            continue block21;
                        }
                        BodyBuilder.DocLit docLit = new BodyBuilder.DocLit((WrapperParameter)parameterImpl, sEIStub.soapVersion);
                        continue block21;
                    }
                    BodyBuilder.Bare bare = new BodyBuilder.Bare(parameterImpl, sEIStub.soapVersion);
                    continue block21;
                }
                case HEADER: {
                    arrayList.add(new MessageFiller.Header(parameterImpl.getIndex(), parameterImpl.getBridge(), valueGetter));
                    continue block21;
                }
                case ATTACHMENT: {
                    arrayList.add(MessageFiller.AttachmentFiller.createAttachmentFiller(parameterImpl, valueGetter));
                    continue block21;
                }
                case UNBOUND: {
                    continue block21;
                }
            }
            throw new AssertionError();
        }
        if (var4_6 == null) {
            switch (sEIStub.soapVersion) {
                case SOAP_11: {
                    BodyBuilder bodyBuilder = BodyBuilder.EMPTY_SOAP11;
                    break;
                }
                case SOAP_12: {
                    BodyBuilder bodyBuilder = BodyBuilder.EMPTY_SOAP12;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.bodyBuilder = var4_12;
        this.inFillers = arrayList.toArray(new MessageFiller[arrayList.size()]);
        list = javaMethodImpl.getResponseParameters();
        ArrayList<ResponseBuilder> arrayList2 = new ArrayList<ResponseBuilder>();
        block22: for (ParameterImpl parameterImpl : list) {
            ValueSetter valueSetter = ValueSetter.get(parameterImpl);
            switch (parameterImpl.getOutBinding().kind) {
                case BODY: {
                    if (parameterImpl.isWrapperStyle()) {
                        if (parameterImpl.getParent().getBinding().isRpcLit()) {
                            arrayList2.add(new ResponseBuilder.RpcLit((WrapperParameter)parameterImpl));
                            continue block22;
                        }
                        arrayList2.add(new ResponseBuilder.DocLit((WrapperParameter)parameterImpl));
                        continue block22;
                    }
                    arrayList2.add(new ResponseBuilder.Body(parameterImpl.getBridge(), valueSetter));
                    continue block22;
                }
                case HEADER: {
                    arrayList2.add(new ResponseBuilder.Header(sEIStub.soapVersion, parameterImpl, valueSetter));
                    continue block22;
                }
                case ATTACHMENT: {
                    arrayList2.add(ResponseBuilder.AttachmentBuilder.createAttachmentBuilder(parameterImpl, valueSetter));
                    continue block22;
                }
                case UNBOUND: {
                    arrayList2.add(new ResponseBuilder.NullSetter(valueSetter, ResponseBuilder.getVMUninitializedValue(parameterImpl.getTypeReference().type)));
                    continue block22;
                }
            }
            throw new AssertionError();
        }
        switch (arrayList2.size()) {
            case 0: {
                this.responseBuilder = ResponseBuilder.NONE;
                break;
            }
            case 1: {
                this.responseBuilder = (ResponseBuilder)arrayList2.get(0);
                break;
            }
            default: {
                this.responseBuilder = new ResponseBuilder.Composite(arrayList2);
            }
        }
        this.isOneWay = javaMethodImpl.getMEP().isOneWay();
    }

    public JavaMethodImpl getJavaMethod() {
        return this.javaMethod;
    }

    public Object invoke(Object object, Object[] objectArray) throws Throwable {
        return this.invoke(object, objectArray, this.owner.requestContext, this.owner);
    }

    public Object invoke(Object object, Object[] objectArray, RequestContext requestContext, ResponseContextReceiver responseContextReceiver) throws Throwable {
        Packet packet = new Packet(this.createRequestMessage(objectArray));
        packet.soapAction = this.soapAction;
        packet.expectReply = !this.isOneWay;
        packet.getMessage().assertOneWay(this.isOneWay);
        Packet packet2 = this.owner.doProcess(packet, requestContext, responseContextReceiver);
        Message message = packet2.getMessage();
        if (message == null) {
            return null;
        }
        try {
            if (message.isFault()) {
                SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
                throw sOAPFaultBuilder.createException(this.checkedExceptions);
            }
            return this.responseBuilder.readResponse(message, objectArray);
        }
        catch (JAXBException jAXBException) {
            throw new DeserializationException("failed.to.read.response", new Object[]{jAXBException});
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException("failed.to.read.response", new Object[]{xMLStreamException});
        }
    }

    private Message createRequestMessage(Object[] objectArray) {
        Message message = this.bodyBuilder.createMessage(objectArray);
        for (MessageFiller messageFiller : this.inFillers) {
            messageFiller.fillIn(objectArray, message);
        }
        return message;
    }
}

