/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.Timer;
import tianyuan.games.base.GoBbsDataRequest;
import tianyuan.games.base.GoQiPu;
import tianyuan.games.base.Level;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseInputStream;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.base.TyBaseOutputStream;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.commonbbs.CommonBbsDataRequest;
import tianyuan.games.base.commonbbs.CommonBbsItem;
import tianyuan.games.base.innermail.InnerMail;
import tianyuan.games.base.innermail.InnerMailRequest;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.UpdateProcessDisplay;
import tianyuan.games.gui.goe.editor.maptree.QiPu;
import tianyuan.games.net.ClientMessage;
import tianyuan.games.net.ClientRequest;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.client.GoNetCommand;
import tianyuan.games.net.client.NetResponseSink;
import tianyuan.games.net.update.DirectoryCopy;
import tianyuan.games.net.update.Update;
import tianyuan.games.sound.AudioFormatParamters;

public class NetResponse {
    private NetSender sender = new NetSender();
    public LinkedBlockingQueue<ClientRequest> clientEventQueue = new LinkedBlockingQueue();
    public GoNetCommand go = new GoNetCommand(this.clientEventQueue);
    private String serverAddress;
    private String userName;
    private String passwd;
    private Level goLevel = new Level(1);
    private NetResponseSink sink;
    private NetListener listener = null;
    private TyBaseOutput dout = null;
    private Socket dataChannel = null;
    private TyBaseInput din;
    private int tcpPort = 7703;
    Timer timer;
    SendNoop noopSender;
    MessageCount messageCount = new MessageCount();

    public NetResponse(String string, String string2, String string3) {
        this.serverAddress = string;
        this.userName = string2;
        this.passwd = string3;
        this.sink = Global.netSink;
        this.listener = new NetListener();
        this.listener.setPriority(10);
        this.listener.start();
    }

    private void senderStart() {
        this.sender.start();
        this.noopSender = new SendNoop();
        this.timer = new Timer(15000, this.noopSender);
        this.timer.start();
    }

    public NetResponse(String string, String string2, String string3, Level level) {
        this.serverAddress = string;
        this.userName = string2;
        this.passwd = string3;
        this.goLevel = level;
        this.sink = Global.netSink;
        this.listener = new NetListener();
        this.listener.setPriority(10);
        this.listener.start();
    }

    public NetResponse(String string, String string2, String string3, Level level, int n) {
        this.serverAddress = string;
        this.userName = string2;
        this.passwd = string3;
        this.goLevel = level;
        this.tcpPort = n;
        this.sink = Global.netSink;
        this.listener = new NetListener();
        this.listener.setPriority(10);
        this.listener.start();
    }

    private boolean put(ClientRequest clientRequest) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.clientEventQueue.put(clientRequest);
                return true;
            }
            catch (InterruptedException interruptedException) {
                Global.sleepSec(1);
                System.out.println("clientEventQueue.put error.");
                continue;
            }
        }
        return false;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void reset() {
        try {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.passwd = null;
            this.userName = null;
            this.serverAddress = null;
            this.clientEventQueue.clear();
            this.dataChannel.close();
            this.dout.close();
            this.din.close();
            this.sink = null;
            this.listener = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean processResponse(TyBaseInput tyBaseInput) {
        ServerResponse serverResponse = new ServerResponse();
        if ((serverResponse = serverResponse.readResponse(tyBaseInput)) == null) {
            return false;
        }
        this.sink.put(serverResponse);
        return true;
    }

    public boolean login(String string, String string2, String string3, String string4, String string5) {
        if (string.length() > Global.publicSetting.userNameMaxLength) {
            string = string.substring(0, Global.publicSetting.userNameMaxLength - 1);
        } else if (string.length() <= Global.publicSetting.userNameMinLength) {
            string = string + "00000";
        }
        if (string2.length() > Global.publicSetting.passwdMaxLength - 1) {
            string2 = string2.substring(0, Global.publicSetting.passwdMaxLength - 1);
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = 1;
        clientRequest.login_name = string;
        clientRequest.login_passwd = string2;
        clientRequest.login_nickName = string3;
        clientRequest.login_clientVersionLang = string4;
        clientRequest.login_clientVersionNumber = string5;
        clientRequest.login_clientOsName = System.getProperty("os.name") + System.getProperty("os.arch") + System.getProperty("os.version");
        clientRequest.login_level = this.goLevel;
        clientRequest.login_p2p_daemon_port = Global.p2pDaemon.getSocketPort();
        return this.put(clientRequest);
    }

    public boolean login(String string, String string2, String string3, Level level, String string4, String string5) {
        if (string.length() > Global.publicSetting.userNameMaxLength) {
            string = string.substring(0, Global.publicSetting.userNameMaxLength - 1);
        } else if (string.length() <= Global.publicSetting.userNameMinLength) {
            string = string + "00000";
        }
        if (string2.length() > Global.publicSetting.passwdMaxLength - 1) {
            string2 = string2.substring(0, Global.publicSetting.passwdMaxLength - 1);
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = 1;
        clientRequest.login_name = string;
        clientRequest.login_passwd = string2;
        clientRequest.login_nickName = string3;
        clientRequest.login_clientVersionLang = string4;
        clientRequest.login_clientVersionNumber = string5;
        clientRequest.login_clientOsName = System.getProperty("os.name") + System.getProperty("os.arch");
        clientRequest.login_level = level;
        return this.put(clientRequest);
    }

    public boolean logout() {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)2;
        return this.put(clientRequest);
    }

    public boolean createRoom(byte by, String string, String string2, String string3) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)5;
        clientRequest.createRoomTitle = string;
        clientRequest.createRoomInfo = string2;
        clientRequest.createRoomPasswd = string3;
        clientRequest.createRoomStatus = by;
        return this.put(clientRequest);
    }

    public boolean enterRoom(int n) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)6;
        clientRequest.enterRoomNumber = n;
        return this.put(clientRequest);
    }

    public boolean quitRoom(int n) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)7;
        clientRequest.quitRoomNumber = n;
        return this.put(clientRequest);
    }

    public boolean sendHallMessage(String string) {
        if (string.length() > Global.publicSetting.messageMaxLength) {
            string = string.substring(0, Global.publicSetting.messageMaxLength - 1);
        }
        if (!this.messageCount.canSend()) {
            return false;
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)8;
        clientRequest.clientMessage = new ClientMessage();
        clientRequest.clientMessage.type = 1;
        clientRequest.clientMessage.message = string;
        return this.put(clientRequest);
    }

    public boolean sendRoomMessage(String string, int n) {
        if (string.length() > Global.publicSetting.messageMaxLength) {
            string = string.substring(0, Global.publicSetting.messageMaxLength - 1);
        }
        if (!this.messageCount.canSend()) {
            return false;
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)8;
        clientRequest.clientMessage = new ClientMessage();
        clientRequest.clientMessage.type = (byte)2;
        clientRequest.clientMessage.message = string;
        clientRequest.clientMessage.roomNumber = n;
        return this.put(clientRequest);
    }

    public boolean sendToPerson(String string, String string2) {
        if (string.length() > Global.publicSetting.messageMaxLength) {
            string = string.substring(0, Global.publicSetting.messageMaxLength - 1);
        }
        if (!this.messageCount.canSend()) {
            return false;
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)8;
        clientRequest.clientMessage = new ClientMessage();
        clientRequest.clientMessage.type = (byte)3;
        clientRequest.clientMessage.message = string;
        clientRequest.clientMessage.sendTo = string2;
        return this.put(clientRequest);
    }

    public boolean sendSystemInfo(String string) {
        if (string.length() > Global.publicSetting.messageMaxLength) {
            string = string.substring(0, Global.publicSetting.messageMaxLength - 1);
        }
        if (!this.messageCount.canSend()) {
            return false;
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)8;
        clientRequest.clientMessage = new ClientMessage();
        clientRequest.clientMessage.type = 1;
        clientRequest.clientMessage.message = string;
        return this.put(clientRequest);
    }

    public boolean addFriend(String string) {
        if (Global.myUserInfo.friendTotal() >= Global.publicSetting.friendLimit) {
            return false;
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)9;
        clientRequest.modifyRelationshipType = 1;
        clientRequest.modifyRelationshipUsername = string;
        return this.put(clientRequest);
    }

    public boolean delFriend(String string) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)9;
        clientRequest.modifyRelationshipType = (byte)2;
        clientRequest.modifyRelationshipUsername = string;
        return this.put(clientRequest);
    }

    public boolean addDislike(String string) {
        if (Global.myUserInfo.dislikeTotal() >= Global.publicSetting.dislikeLimit) {
            return false;
        }
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)9;
        clientRequest.modifyRelationshipType = (byte)3;
        clientRequest.modifyRelationshipUsername = string;
        return this.put(clientRequest);
    }

    public boolean delDislike(String string) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)9;
        clientRequest.modifyRelationshipType = (byte)4;
        clientRequest.modifyRelationshipUsername = string;
        return this.put(clientRequest);
    }

    public boolean newPasswd(String string) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)3;
        clientRequest.newPasswd = string;
        return this.put(clientRequest);
    }

    public boolean addNetManager(String string) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)10;
        clientRequest.addNetManagerUserName = string;
        return this.put(clientRequest);
    }

    public boolean delUser(String string) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)11;
        clientRequest.delUserName = string;
        return this.put(clientRequest);
    }

    public boolean modifyInfo(UserInfo userInfo) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)12;
        clientRequest.modifyUserInfo = userInfo;
        return this.put(clientRequest);
    }

    public boolean searchUserDetial(String string, int n) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)14;
        clientRequest.beSearchedUser = string;
        clientRequest.beSearchedSourceRoomNumber = n;
        return this.put(clientRequest);
    }

    public boolean getUserTableByPage(int n) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)15;
        clientRequest.pageOfUserTable = n;
        return this.put(clientRequest);
    }

    public boolean serverCommand(String string) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)30;
        clientRequest.serverManagerCommand = string;
        return this.put(clientRequest);
    }

    public boolean audioTalkRts(String string, Vector<AudioFormatParamters> vector) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)16;
        clientRequest.audioTalkRtsRequestDestUser = string;
        clientRequest.audioTalkRtsUserSupportFormatList = vector;
        return this.put(clientRequest);
    }

    public boolean audioTalkCts(String string, byte by, byte by2, Vector<AudioFormatParamters> vector, AudioFormatParamters audioFormatParamters) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)17;
        clientRequest.audioTalkCtsRequestDestUser = string;
        clientRequest.audioTalkCtsUserResult = by;
        clientRequest.audioTalkCtsFormatResult = by2;
        clientRequest.audioTalkCtsUserSupportFormatList = vector;
        clientRequest.ctsUserSelectFormat = audioFormatParamters;
        return this.put(clientRequest);
    }

    public boolean audioTalkRrts(String string, byte by, AudioFormatParamters audioFormatParamters) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)18;
        clientRequest.audioTalkRrtsDestUser = string;
        clientRequest.audioTalkRrtsFormatResult = by;
        clientRequest.rrtsUserSelectFormat = audioFormatParamters;
        return this.put(clientRequest);
    }

    public boolean bbsAddBbsTopic(String string) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = 1;
        goBbsDataRequest.topicName = string;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsDelBbsTopic(String string) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)2;
        goBbsDataRequest.topicName = string;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsModifyMyCollectionGoQiPu(int n, GoQiPu goQiPu) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)13;
        goBbsDataRequest.qiPu = goQiPu;
        goBbsDataRequest.isMyCollectionData = true;
        goBbsDataRequest.qiPuNumber = n;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsModifyGoQiPu(String string, int n, GoQiPu goQiPu) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)13;
        goBbsDataRequest.topicName = string;
        goBbsDataRequest.qiPu = goQiPu;
        goBbsDataRequest.isMyCollectionData = false;
        goBbsDataRequest.qiPuNumber = n;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public String bbsAddGoQiPu(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("");
        try {
            File file = new File(string2);
            if (!file.exists()) {
                stringBuilder.append(string2 + "do not exists !");
            } else if (!file.isDirectory()) {
                stringBuilder.append(string2 + "is not a directory !");
            } else {
                File[] fileArray = file.listFiles();
                int n = 0;
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isFile()) continue;
                    ++n;
                    GoQiPu goQiPu = new GoQiPu();
                    goQiPu.qp = new QiPu(fileArray[i]);
                    this.bbsAddGoQiPu(string, goQiPu);
                }
                stringBuilder.append("upload " + n + " sgf file complete !");
            }
        }
        catch (Exception exception) {
            stringBuilder.append(exception.toString());
        }
        return stringBuilder.toString();
    }

    public boolean bbsAddGoQiPu(String string, GoQiPu goQiPu) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)3;
        goBbsDataRequest.topicName = string;
        goBbsDataRequest.qiPu = goQiPu;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsDelGoQiPu(String string, int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)4;
        goBbsDataRequest.topicName = string;
        goBbsDataRequest.qiPuNumber = n;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsDelMyCollectionGoQiPu(int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)4;
        goBbsDataRequest.qiPuNumber = n;
        goBbsDataRequest.isMyCollectionData = true;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsReadMyCollectionGoQiPu(int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)5;
        goBbsDataRequest.qiPuNumber = n;
        goBbsDataRequest.getQiPuOperationType = 1;
        goBbsDataRequest.getQiPuOperationMode = (byte)2;
        goBbsDataRequest.isMyCollectionData = true;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsGetGoQiPuReadAndPay(String string, int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)5;
        goBbsDataRequest.topicName = string;
        goBbsDataRequest.qiPuNumber = n;
        goBbsDataRequest.getQiPuOperationType = 1;
        goBbsDataRequest.getQiPuOperationMode = 1;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsGetGoQiPuReadNoPay(String string, int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)5;
        goBbsDataRequest.topicName = string;
        goBbsDataRequest.qiPuNumber = n;
        goBbsDataRequest.getQiPuOperationType = 1;
        goBbsDataRequest.getQiPuOperationMode = (byte)2;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsGetGoQiPuBuyAndPay(String string, int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)5;
        goBbsDataRequest.topicName = string;
        goBbsDataRequest.qiPuNumber = n;
        goBbsDataRequest.getQiPuOperationType = (byte)2;
        goBbsDataRequest.getQiPuOperationMode = 1;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsGetGoQiPuBuyNoPay(String string, int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)5;
        goBbsDataRequest.topicName = string;
        goBbsDataRequest.qiPuNumber = n;
        goBbsDataRequest.getQiPuOperationType = (byte)2;
        goBbsDataRequest.getQiPuOperationMode = (byte)2;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsCopyGoQiPu(String string, String string2, int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)8;
        goBbsDataRequest.sourceTopicName = string;
        goBbsDataRequest.destTopicName = string2;
        goBbsDataRequest.qiPuNumber = n;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsGetAllTopic() {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)6;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsGetQiPuIndexInTopic(String string, int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)7;
        goBbsDataRequest.pageNumber = n;
        goBbsDataRequest.topicName = string;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    public boolean bbsGetMyCollectionQiPuIndex(int n) {
        GoBbsDataRequest goBbsDataRequest = new GoBbsDataRequest();
        goBbsDataRequest.type = (byte)7;
        goBbsDataRequest.pageNumber = n;
        goBbsDataRequest.isMyCollectionData = true;
        return this.postGoBbsDataRequest(goBbsDataRequest);
    }

    private boolean postGoBbsDataRequest(GoBbsDataRequest goBbsDataRequest) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)19;
        clientRequest.goBbsDataRequest = goBbsDataRequest;
        return this.put(clientRequest);
    }

    public boolean commonBbsAddBbsTopic(String string) {
        CommonBbsDataRequest commonBbsDataRequest = new CommonBbsDataRequest();
        commonBbsDataRequest.type = 1;
        commonBbsDataRequest.topicName = string;
        return this.postCommonBbsDataRequest(commonBbsDataRequest);
    }

    public boolean commonBbsDelBbsTopic(String string) {
        CommonBbsDataRequest commonBbsDataRequest = new CommonBbsDataRequest();
        commonBbsDataRequest.type = (byte)2;
        commonBbsDataRequest.topicName = string;
        return this.postCommonBbsDataRequest(commonBbsDataRequest);
    }

    public boolean commonBbsGetAllTopic() {
        CommonBbsDataRequest commonBbsDataRequest = new CommonBbsDataRequest();
        commonBbsDataRequest.type = (byte)6;
        return this.postCommonBbsDataRequest(commonBbsDataRequest);
    }

    public boolean commonBbsGetIndexInTopic(String string, int n) {
        CommonBbsDataRequest commonBbsDataRequest = new CommonBbsDataRequest();
        commonBbsDataRequest.type = (byte)7;
        commonBbsDataRequest.pageNumber = n;
        commonBbsDataRequest.topicName = string;
        return this.postCommonBbsDataRequest(commonBbsDataRequest);
    }

    public boolean commonBbsReadItem(String string, int n) {
        CommonBbsDataRequest commonBbsDataRequest = new CommonBbsDataRequest();
        commonBbsDataRequest.type = (byte)5;
        commonBbsDataRequest.topicName = string;
        commonBbsDataRequest.itemNumber = n;
        return this.postCommonBbsDataRequest(commonBbsDataRequest);
    }

    public boolean commonBbsDelItem(String string, int n) {
        CommonBbsDataRequest commonBbsDataRequest = new CommonBbsDataRequest();
        commonBbsDataRequest.type = (byte)4;
        commonBbsDataRequest.topicName = string;
        commonBbsDataRequest.itemNumber = n;
        return this.postCommonBbsDataRequest(commonBbsDataRequest);
    }

    public boolean commonBbsAddItem(String string, CommonBbsItem commonBbsItem) {
        CommonBbsDataRequest commonBbsDataRequest = new CommonBbsDataRequest();
        commonBbsDataRequest.type = (byte)3;
        commonBbsDataRequest.topicName = string;
        commonBbsDataRequest.item = commonBbsItem;
        return this.postCommonBbsDataRequest(commonBbsDataRequest);
    }

    public boolean exitStudyRoomStatus(int n) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)23;
        clientRequest.exitStudyRoomNumber = n;
        return this.put(clientRequest);
    }

    public boolean publishStudyRef(int n, int n2, int n3, QiPu qiPu) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)24;
        clientRequest.publishStudyRefRoomNumber = n;
        clientRequest.publishStudyRefMotherNumber = n2;
        clientRequest.publishStudyRefMotherPosition = n3;
        clientRequest.publishStudyRef = qiPu;
        return this.put(clientRequest);
    }

    public boolean delStudyRef(int n, int n2) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)25;
        clientRequest.delPublishStudyRefRoomNumber = n;
        clientRequest.delPublishStudyRefNumber = n2;
        return this.put(clientRequest);
    }

    private boolean postCommonBbsDataRequest(CommonBbsDataRequest commonBbsDataRequest) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)21;
        clientRequest.commonBbsDataRequest = commonBbsDataRequest;
        return this.put(clientRequest);
    }

    public boolean innerMailSend(InnerMail innerMail) {
        InnerMailRequest innerMailRequest = new InnerMailRequest();
        innerMailRequest.type = 1;
        innerMailRequest.mail = innerMail;
        return this.postInnerMailDataRequest(innerMailRequest);
    }

    public boolean innerMailRead(byte by, int n) {
        InnerMailRequest innerMailRequest = new InnerMailRequest();
        innerMailRequest.type = (byte)2;
        innerMailRequest.mailBoxType = by;
        innerMailRequest.mailIndex = n;
        return this.postInnerMailDataRequest(innerMailRequest);
    }

    public boolean innerMailDel(byte by, int n) {
        InnerMailRequest innerMailRequest = new InnerMailRequest();
        innerMailRequest.type = (byte)3;
        innerMailRequest.mailBoxType = by;
        innerMailRequest.mailIndex = n;
        return this.postInnerMailDataRequest(innerMailRequest);
    }

    public boolean innerMailGetIndex(byte by, int n) {
        InnerMailRequest innerMailRequest = new InnerMailRequest();
        innerMailRequest.type = (byte)4;
        innerMailRequest.mailBoxType = by;
        innerMailRequest.pageNumber = n;
        return this.postInnerMailDataRequest(innerMailRequest);
    }

    public boolean innerMailInBoxGetIndex(int n) {
        InnerMailRequest innerMailRequest = new InnerMailRequest();
        innerMailRequest.type = (byte)4;
        innerMailRequest.mailBoxType = InnerMail.READING_MAIL_BOX;
        innerMailRequest.pageNumber = n;
        return this.postInnerMailDataRequest(innerMailRequest);
    }

    public boolean innerMailOutBoxGetIndex(int n) {
        InnerMailRequest innerMailRequest = new InnerMailRequest();
        innerMailRequest.type = (byte)4;
        innerMailRequest.mailBoxType = InnerMail.SENDING_MAIL_BOX;
        innerMailRequest.pageNumber = n;
        return this.postInnerMailDataRequest(innerMailRequest);
    }

    private boolean postInnerMailDataRequest(InnerMailRequest innerMailRequest) {
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.type = (byte)22;
        clientRequest.innerMailRequest = innerMailRequest;
        return this.put(clientRequest);
    }

    private static void sleepSec(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ void access$200(int n) {
        NetResponse.sleepSec(n);
    }

    static /* synthetic */ TyBaseOutput access$300(NetResponse netResponse) {
        return netResponse.dout;
    }

    private class MessageCount {
        private long beginTime = System.currentTimeMillis();
        private int count = 0;

        MessageCount() {
        }

        boolean canSend() {
            if (System.currentTimeMillis() < this.beginTime) {
                return false;
            }
            ++this.count;
            if (this.count >= Global.publicSetting.messageInputSpeed_msg_count) {
                long l = System.currentTimeMillis();
                if (l - this.beginTime > (long)(Global.publicSetting.messageInputSpeed_time * 1000)) {
                    this.beginTime = l;
                    this.count = 0;
                    return true;
                }
                this.beginTime = l + 30000L;
                this.count = 0;
                return false;
            }
            return true;
        }
    }

    class SendNoop
    implements ActionListener {
        SendNoop() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClientRequest clientRequest = new ClientRequest();
            clientRequest.type = (byte)-1;
            NetResponse.this.put(clientRequest);
        }
    }

    private class NetListener
    extends Thread {
        private NetListener() {
        }

        @Override
        public void run() {
            try {
                NetResponse.this.dataChannel = new Socket(NetResponse.this.serverAddress, NetResponse.this.tcpPort);
                DataInputStream dataInputStream = new DataInputStream(NetResponse.this.dataChannel.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(NetResponse.this.dataChannel.getOutputStream());
                NetResponse.this.din = new TyBaseInputStream(dataInputStream);
                NetResponse.this.dout = new TyBaseOutputStream(dataOutputStream);
                int n = 0;
                String string = System.getProperty("os.name") + System.getProperty("os.arch") + System.getProperty("os.version");
                String string2 = string.toLowerCase();
                n = string2.indexOf("windows") >= 0 ? 0 : 1;
                Update update = new Update();
                boolean bl = update.clientUpdateSupport(1010, n, dataInputStream, dataOutputStream, new File("./file/tmp"), new UpdateProcessDisplay());
                if (bl) {
                    Object object;
                    DirectoryCopy.moveTree(new File("./file/tmp"), new File("."));
                    File file = new File("client.exe");
                    if (file.exists()) {
                        object = new ProcessBuilder("client.exe", "").start();
                    } else {
                        object = new File("client.sh");
                        if (((File)object).exists()) {
                            Process process = new ProcessBuilder("client.sh", "").start();
                        }
                    }
                    System.exit(0);
                }
                NetResponse.this.senderStart();
            }
            catch (IOException iOException) {
                NetResponse.this.sink.connectError();
                try {
                    if (NetResponse.this.dataChannel != null) {
                        NetResponse.this.dataChannel.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return;
            }
            try {
                NetResponse.this.login(NetResponse.this.userName, NetResponse.this.passwd, NetResponse.this.userName, NetResponse.this.goLevel, Global.lang.getKey("6_versionLang"), Global.lang.getKey("6_versionNum"));
                while (NetResponse.this.processResponse(NetResponse.this.din)) {
                }
            }
            catch (Exception exception) {
                NetResponse.this.sink.netWorkBroken();
                try {
                    if (NetResponse.this.dataChannel != null) {
                        NetResponse.this.dataChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (exception instanceof InterruptedException) {
                    return;
                }
                return;
            }
            if (NetResponse.this.serverAddress != null) {
                NetResponse.this.sink.netWorkBroken();
                try {
                    if (NetResponse.this.dataChannel != null) {
                        NetResponse.this.dataChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class NetSender
    extends Thread {
        private NetSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = new ByteArrayOutputStream();
            var2_2 = new TyBaseOutputStream(new DataOutputStream(var1_1));
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        if ((var3_3 = NetResponse.this.clientEventQueue.take()) == null) {
                            NetResponse.access$200(1);
                            continue;
                        }
                        try {
                            var3_3.writeRequest(NetResponse.access$300(NetResponse.this));
                        }
                        catch (Exception var4_5) {
                            var4_5.printStackTrace();
                        }
                        finally {
                            if (var3_3.type != 2) continue;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException var3_4) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }
}

