/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.table.TableColumn;
import tianyuan.games.base.GoGameIndex;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.MyJPanel;
import tianyuan.games.gui.goe.goeroom.GoeSeeGameRecordPane;
import tianyuan.games.gui.goe.hall.PagePane;
import tianyuan.games.gui.goe.table.MyTable;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.TableSorter;

public class GoGameRecordIndexTable
extends MyJPanel {
    protected JLabel title = new JLabel();
    Pager pagePane = new Pager();
    protected MyTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm = new MyTableModel();
    protected TableSorter sorter = new TableSorter(this.mtm);
    protected String[] columnNames = new String[]{Global.lang.getKey("129_number"), Global.lang.getKey("129_black"), Global.lang.getKey("129_white"), Global.lang.getKey("129_result"), Global.lang.getKey("129_use_time"), Global.lang.getKey("129_begin_time"), Global.lang.getKey("129_title")};
    private GoeSeeGameRecordPane myContext;
    protected JPopupMenu popup = new JPopupMenu();
    protected SeeGameRecordAction seeAction;
    private SizeListener seeSize = new SizeListener();

    public void add(Vector<GoGameIndex> vector, int n) {
        this.delAll();
        this.pagePane.setNumber(n + 1);
        for (GoGameIndex goGameIndex : vector) {
            this.addALine(goGameIndex);
        }
    }

    protected static void myLimitSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
    }

    private void addALine(GoGameIndex goGameIndex) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(goGameIndex.number + 1);
        vector.add(goGameIndex.blackNameWithLevel(Global.lang));
        vector.add(goGameIndex.whiteNameWithLevel(Global.lang));
        vector.add(goGameIndex.result.toString(Global.lang));
        vector.add(goGameIndex.getUseTime(Global.lang));
        vector.add(goGameIndex.getBeginTime());
        vector.add(goGameIndex.title);
        this.mtm.addRow(vector);
    }

    private void delAll() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
    }

    public GoGameRecordIndexTable(GoeSeeGameRecordPane goeSeeGameRecordPane) {
        this.myContext = goeSeeGameRecordPane;
        this.title.setText(Global.lang.getKey("129_game_record"));
        this.table = new MyTable(this.sorter);
        this.table.setSelectionMode(0);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new DoubleClickAdapter());
        this.table.addMouseListener(new PopupActionAdapter(this.popup, this.table));
        this.setPopupMenu();
        this.sp = new JScrollPane(this.table);
        this.myReLayout();
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.addComponentListener(this.seeSize);
        this.table.setModel(this.sorter);
    }

    private void layout1() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.title, "North");
        this.add((Component)this.sp, "Center");
    }

    @Override
    protected void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = dimension.width / 6;
        int n2 = dimension.width - n;
        int n3 = 17;
        this.myAddComp(this.title, 0, 0, n, n3);
        this.myAddComp(this.pagePane, n + 1, 0, n2 - 1, n3);
        this.myAddComp(this.sp, 0, n3 + 1, dimension.width, dimension.height - n3 - 1);
        this.revalidate();
    }

    public void setPopupMenu() {
        this.seeAction = new SeeGameRecordAction();
        this.popup.add(this.seeAction);
    }

    private void sendGetRecordCommand() {
        if (Global.netDaemon == null) {
            return;
        }
        Global.netDaemon.go.getGoGameRecord(this.myContext.getMyName(), this.getSelectNumber() - 1);
    }

    private int getSelectNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("129_number").equals(this.sorter.getColumnName(i))) continue;
            Integer n3 = (Integer)this.sorter.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    private void setAllSize() {
        this.setColumnWidth();
        this.pagePane.myReLayout();
    }

    private void setColumnWidth() {
        TableColumn tableColumn = this.table.getColumn(this.columnNames[3]);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.columnNames[5]);
        tableColumn.setPreferredWidth(250);
        this.table.doLayout();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoGameRecordIndexTable.this.setAllSize();
        }
    }

    class SeeGameRecordAction
    extends AbstractAction {
        SeeGameRecordAction() {
            super(Global.lang.getKey("129_see"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoGameRecordIndexTable.this.sendGetRecordCommand();
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                GoGameRecordIndexTable.this.sendGetRecordCommand();
            }
        }
    }

    class Pager
    extends PagePane {
        Pager() {
        }

        @Override
        protected void doOperation(int n) {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.go.getGoGameIndex(GoGameRecordIndexTable.this.myContext.getMyName(), n - 1);
        }
    }
}

