/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.qipubbs;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tianyuan.games.base.BbsTopics;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.qipubbs.BbsContentTabbedPane;
import tianyuan.games.gui.goe.qipubbs.BbsMenuTreeCellEditor;
import tianyuan.games.gui.goe.qipubbs.BbsMenuTreeCellRenderer;
import tianyuan.games.gui.goe.qipubbs.BbsMenuTreeModel;
import tianyuan.games.gui.goe.qipubbs.BbsMenuTreeNode;
import tianyuan.games.gui.goe.qipubbs.BbsTopicsMenu;
import tianyuan.games.gui.goe.qipubbs.MyTransferHandler;

public class BbsMenu
extends JPanel
implements CellEditorListener,
TreeSelectionListener {
    private JTree tree;
    private BbsMenuTreeModel treeModel;
    private BbsMenuTreeCellRenderer nodeRenderer;
    private BbsMenuTreeCellEditor nodeEditor;
    private boolean isManager = false;
    private BbsTopics topics;
    private BbsMenuTreeNode treeModelRoot = new BbsMenuTreeNode("root");
    private BbsContentTabbedPane tabbedView = null;
    private BbsMenuTreeNode beSelectedNode = null;
    private TreePath beSelectedPath = null;
    private final JPopupMenu popup = new JPopupMenu();
    private AddSubTreeAction addSubTreeAction = new AddSubTreeAction();
    private DelSubTreeAction delSubTreeAction = new DelSubTreeAction();

    private BbsMenuTreeNode getRoot() {
        return (BbsMenuTreeNode)this.treeModel.getRoot();
    }

    public BbsMenu(BbsContentTabbedPane bbsContentTabbedPane) {
        this.tabbedView = bbsContentTabbedPane;
        this.init();
        this.setManagerFlag(true);
    }

    public BbsMenu(boolean bl) {
        this.init();
        this.setManagerFlag(bl);
    }

    public String getCurrentTopic() {
        if (this.beSelectedNode == null) {
            return "";
        }
        return this.beSelectedNode.getKey();
    }

    protected void myReset() {
        this.isManager = false;
        this.beSelectedNode = null;
        this.beSelectedPath = null;
        BbsMenuTreeNode bbsMenuTreeNode = this.getRoot();
        Enumeration<TreeNode> enumeration = bbsMenuTreeNode.children();
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            BbsMenuTreeNode bbsMenuTreeNode2 = (BbsMenuTreeNode)enumeration.nextElement();
            vector.add(bbsMenuTreeNode2);
        }
        for (BbsMenuTreeNode bbsMenuTreeNode3 : vector) {
            this.treeModel.removeNodeFromParent(bbsMenuTreeNode3);
        }
    }

    private void init() {
        this.treeModel = new BbsMenuTreeModel(this.treeModelRoot);
        this.tree = new JTree(this.treeModel);
        this.beSelectedNode = (BbsMenuTreeNode)this.treeModel.getRoot();
        this.beSelectedPath = new TreePath(this.beSelectedNode);
        this.tree.addTreeSelectionListener(this);
        this.nodeRenderer = new BbsMenuTreeCellRenderer();
        this.nodeEditor = new BbsMenuTreeCellEditor(this.tree, this.nodeRenderer);
        this.nodeEditor.addCellEditorListener(this);
        this.tree.setCellEditor(this.nodeEditor);
        this.tree.setCellRenderer(this.nodeRenderer);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jScrollPane.getViewport().add(this.tree);
        this.setLayout(new BorderLayout());
        this.add("Center", jScrollPane);
        this.popup.add(this.addSubTreeAction);
        this.popup.add(this.delSubTreeAction);
        this.tree.addMouseListener(new PopupActionAdapter(this.popup, this.tree));
    }

    public BbsMenuTreeNode getMenuNode(String string) {
        BbsMenuTreeNode bbsMenuTreeNode = this.getRoot();
        Enumeration<TreeNode> enumeration = bbsMenuTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            BbsMenuTreeNode bbsMenuTreeNode2 = (BbsMenuTreeNode)enumeration.nextElement();
            if (!bbsMenuTreeNode2.getKey().equals(string)) continue;
            return bbsMenuTreeNode2;
        }
        return null;
    }

    public void selectTopic(BbsMenuTreeNode bbsMenuTreeNode) {
        if (bbsMenuTreeNode == null) {
            return;
        }
        if (this.beSelectedNode == null) {
            return;
        }
        if (bbsMenuTreeNode.equals(this.beSelectedNode)) {
            return;
        }
        Object[] objectArray = this.treeModel.getPathToRoot(bbsMenuTreeNode);
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.beSelectedPath = treeSelectionEvent.getPath();
        this.beSelectedNode = (BbsMenuTreeNode)this.beSelectedPath.getLastPathComponent();
        if (this.beSelectedNode != null) {
            BbsMenuTreeNode bbsMenuTreeNode = (BbsMenuTreeNode)this.treeModel.getRoot();
            if (this.beSelectedNode.equals(bbsMenuTreeNode)) {
                return;
            }
            if (this.beSelectedNode.getTopicView() != null) {
                this.tabbedView.setSelectedComponent(this.beSelectedNode.getTopicView());
                return;
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.bbsGetQiPuIndexInTopic(this.beSelectedNode.getKey(), Integer.MAX_VALUE);
            }
        }
    }

    public void setTopics(BbsTopics bbsTopics) {
        this.topics = bbsTopics;
        BbsTopicsMenu bbsTopicsMenu = new BbsTopicsMenu(bbsTopics);
        bbsTopicsMenu.setMenuTreeData(this.treeModel);
        if (!this.treeModelRoot.isLeaf()) {
            Object[] objectArray = this.treeModel.getPathToRoot(this.treeModelRoot.getChildAt(0));
            TreePath treePath = new TreePath(objectArray);
            this.tree.setSelectionPath(treePath);
        }
    }

    public void setManagerFlag(boolean bl) {
        this.isManager = bl;
        if (bl) {
            this.tree.setEditable(true);
            this.tree.setTransferHandler(new MyTransferHandler());
        } else {
            this.tree.setEditable(false);
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        BbsMenuTreeNode bbsMenuTreeNode = (BbsMenuTreeNode)this.treeModel.getRoot();
        if (this.beSelectedNode.equals(bbsMenuTreeNode)) {
            return;
        }
        if (!this.beSelectedNode.isLeaf()) {
            return;
        }
        String string = this.nodeEditor.getCellEditorValue().toString();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return;
        }
        this.beSelectedNode.setDisplayStr(string);
        Global.netDaemon.bbsAddBbsTopic(this.beSelectedNode.getKey());
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    private BbsMenuTreeNode insertChild(String string, BbsMenuTreeNode bbsMenuTreeNode) {
        if (bbsMenuTreeNode == null || string == null) {
            return null;
        }
        BbsMenuTreeNode bbsMenuTreeNode2 = new BbsMenuTreeNode(bbsMenuTreeNode.getKey() + '.' + string);
        int n = bbsMenuTreeNode.getChildCount();
        this.treeModel.insertNodeInto(bbsMenuTreeNode2, bbsMenuTreeNode, n);
        Object[] objectArray = this.treeModel.getPathToRoot(bbsMenuTreeNode2);
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
        return bbsMenuTreeNode2;
    }

    public void addBbsTopic() {
        if (!this.isManager) {
            return;
        }
        this.insertChild(Global.lang.getKey("240_menu_new_topic"), this.beSelectedNode);
    }

    public void delBbsTopic() {
        if (!this.isManager) {
            return;
        }
        if (Global.netDaemon == null) {
            return;
        }
        String string = this.beSelectedNode.getKey();
        if (!this.removeNode(this.beSelectedNode)) {
            return;
        }
        Global.netDaemon.bbsDelBbsTopic(string);
        if (this.tabbedView != null) {
            this.tabbedView.removeTopicView(string);
        }
    }

    private boolean removeNode(BbsMenuTreeNode bbsMenuTreeNode) {
        if (bbsMenuTreeNode == null) {
            return false;
        }
        BbsMenuTreeNode bbsMenuTreeNode2 = (BbsMenuTreeNode)bbsMenuTreeNode.getParent();
        if (bbsMenuTreeNode2 == null) {
            return false;
        }
        if (bbsMenuTreeNode.getChildCount() > 0) {
            return false;
        }
        BbsMenuTreeNode bbsMenuTreeNode3 = (BbsMenuTreeNode)bbsMenuTreeNode2.getChildBefore(bbsMenuTreeNode);
        BbsMenuTreeNode bbsMenuTreeNode4 = (BbsMenuTreeNode)bbsMenuTreeNode2.getChildAfter(bbsMenuTreeNode);
        this.treeModel.removeNodeFromParent(bbsMenuTreeNode);
        Object[] objectArray = bbsMenuTreeNode3 != null ? this.treeModel.getPathToRoot(bbsMenuTreeNode3) : (bbsMenuTreeNode4 != null ? this.treeModel.getPathToRoot(bbsMenuTreeNode4) : this.treeModel.getPathToRoot(bbsMenuTreeNode2));
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
        return true;
    }

    class PopupActionAdapter
    extends MouseAdapter {
        protected JPopupMenu popup;
        protected JComponent comp;

        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            this.comp = jComponent;
            this.popup = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (!BbsMenu.this.isManager) {
                    return;
                }
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class DelSubTreeAction
    extends AbstractAction {
        DelSubTreeAction() {
            super(Global.lang.getKey("210_del_sub_tree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BbsMenu.this.delBbsTopic();
        }
    }

    class AddSubTreeAction
    extends AbstractAction {
        AddSubTreeAction() {
            super(Global.lang.getKey("210_add_sub_tree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BbsMenu.this.addBbsTopic();
        }
    }
}

