/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom.clk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.Sound;
import tianyuan.games.gui.goe.goeroom.clk.ClockSnap;
import tianyuan.games.gui.goe.goeroom.clk.NewClockAlarmed;

public class MyNewClock
implements ActionListener {
    Timer timer;
    private int blackBreakLineCount = 300;
    private int whiteBreakLineCount = 300;
    public static final int BREAK_LINE_COUNT_TOTAL = 300;
    private int readSecLimit = 0;
    private int readTimeLimit = 0;
    private int hourLimit = 0;
    private int minLimit = 0;
    private int secLimit = 0;
    private int blackHour = 0;
    private int blackMin = 0;
    private int blackSec = 0;
    private int blackTime = 0;
    private int blackSec2 = 0;
    private int whiteHour = 0;
    private int whiteMin = 0;
    private int whiteSec = 0;
    private int whiteTime = 0;
    private int whiteSec2 = 0;
    private boolean blackTimeOut = false;
    private boolean whiteTimeOut = false;
    private int timeFlag = 0;
    public static final int DO_NOT_TIME = 0;
    public static final int OPEN_BLACK = 1;
    public static final int OPEN_WHITE = 2;
    public static final int OPEN_BLACK_BREAK_LINE = 3;
    public static final int OPEN_WHITE_BREAK_LINE = 4;
    private int beRecoveredTimeFlag = 0;
    private int oldTimeFlag = 1;
    private boolean stopFlag = false;
    public boolean quiet = false;
    private NewClockAlarmed alarm;

    public MyNewClock(int n, int n2, int n3, int n4, int n5, NewClockAlarmed newClockAlarmed) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        this.whiteHour = this.hourLimit = n;
        this.blackHour = this.hourLimit;
        this.whiteMin = this.minLimit = n2;
        this.blackMin = this.minLimit;
        this.whiteSec = this.secLimit = n3;
        this.blackSec = this.secLimit;
        this.whiteTime = this.readTimeLimit = n4;
        this.blackTime = this.readTimeLimit;
        this.blackSec2 = this.whiteSec2 = n5;
        this.readSecLimit = this.whiteSec2;
        this.alarm = newClockAlarmed;
    }

    public void start() {
        this.timeFlag = 1;
        this.timer = new Timer(1000, this);
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getStop()) {
            return;
        }
        this.minus();
        if (this.blackTimeOut) {
            this.alarm.reportBlackTimeOut();
        } else if (this.whiteTimeOut) {
            this.alarm.reportWhiteTimeOut();
        }
        this.paint();
    }

    public synchronized void setTimeFlag(int n) {
        this.beRecoveredTimeFlag = this.timeFlag;
        this.timeFlag = n;
        if (n == 3) {
            this.blackBreakLineCount = 300;
        } else if (n == 4) {
            this.whiteBreakLineCount = 300;
        }
    }

    public synchronized int getTimeFlag() {
        return this.timeFlag;
    }

    public synchronized void recoverFromBreakLine() {
        this.blackBreakLineCount = 300;
        this.whiteBreakLineCount = 300;
        this.timeFlag = this.beRecoveredTimeFlag;
    }

    public synchronized void click() {
        if (this.timeFlag == 1) {
            this.timeFlag = 2;
        } else if (this.timeFlag == 2) {
            this.timeFlag = 1;
        }
    }

    public synchronized void pause() {
        this.oldTimeFlag = this.timeFlag;
        this.timeFlag = 0;
    }

    public synchronized void contin() {
        this.timeFlag = this.oldTimeFlag;
    }

    private synchronized boolean getStop() {
        return this.stopFlag;
    }

    public synchronized void setStop() {
        this.stopFlag = true;
    }

    public synchronized ClockSnap getClockSnap() {
        ClockSnap clockSnap = new ClockSnap();
        clockSnap.blackHour = this.blackHour;
        clockSnap.blackMin = this.blackMin;
        clockSnap.blackSec = this.blackSec;
        clockSnap.blackReadTime = this.blackTime;
        clockSnap.blackReadSec = this.blackSec2;
        clockSnap.whiteHour = this.whiteHour;
        clockSnap.whiteMin = this.whiteMin;
        clockSnap.whiteSec = this.whiteSec;
        clockSnap.whiteReadTime = this.whiteTime;
        clockSnap.whiteReadSec = this.whiteSec2;
        clockSnap.flag = this.timeFlag == 0 ? 2 : (this.timeFlag == 1 ? 0 : 1);
        return clockSnap;
    }

    private synchronized void minus() {
        int n = this.getTimeFlag();
        if (n == 0) {
            this.blackSec2 = this.whiteSec2 = this.readSecLimit;
            return;
        }
        if (n == 3) {
            if (this.blackBreakLineCount > 0) {
                --this.blackBreakLineCount;
            }
        } else if (n == 4) {
            if (this.whiteBreakLineCount > 0) {
                --this.whiteBreakLineCount;
            }
        } else if (n == 1) {
            this.whiteSec2 = this.readSecLimit;
            if (this.blackSec == 0 && this.blackMin == 0 && this.blackHour == 0) {
                if (this.blackSec2 == 0 && this.blackTime == 1) {
                    if (!this.blackTimeOut) {
                        this.playSound(0);
                    }
                    this.blackTimeOut = true;
                } else if (this.blackSec2 > 0) {
                    --this.blackSec2;
                } else {
                    this.blackSec2 = this.readSecLimit;
                    --this.blackTime;
                    if (this.blackTime < 0) {
                        this.blackTimeOut = true;
                    }
                }
                if (this.blackTime == 1 && this.blackSec2 == this.readSecLimit - 1) {
                    this.playSound(17);
                    MyNewClock.sleepSec(30);
                }
                if (this.readSecLimit > 10 && this.readSecLimit - this.blackSec2 == 10) {
                    this.playSound(11);
                } else if (this.readSecLimit > 20 && this.readSecLimit - this.blackSec2 == 20) {
                    this.playSound(12);
                } else if (this.readSecLimit > 30 && this.readSecLimit - this.blackSec2 == 30) {
                    this.playSound(13);
                } else if (this.readSecLimit > 40 && this.readSecLimit - this.blackSec2 == 40) {
                    this.playSound(14);
                }
                if (this.blackSec2 <= 10 && this.blackSec2 >= 1) {
                    this.playSound(this.blackSec2);
                }
            } else {
                if (this.blackSec > 0) {
                    --this.blackSec;
                } else {
                    this.blackSec = 59;
                    if (this.blackMin > 0) {
                        --this.blackMin;
                    } else {
                        this.blackMin = 59;
                        --this.blackHour;
                    }
                }
                if (this.blackSec == 0 && this.blackMin == 0 && this.blackHour == 0) {
                    this.playSound(16);
                    MyNewClock.sleepSec(30);
                }
            }
        } else {
            this.blackSec2 = this.readSecLimit;
            if (this.whiteSec == 0 && this.whiteMin == 0 && this.whiteHour == 0) {
                if (this.whiteSec2 == 0 && this.whiteTime == 1) {
                    if (!this.whiteTimeOut) {
                        this.playSound(0);
                    }
                    this.whiteTimeOut = true;
                } else if (this.whiteSec2 > 0) {
                    --this.whiteSec2;
                } else {
                    this.whiteSec2 = this.readSecLimit;
                    --this.whiteTime;
                    if (this.whiteTime < 0) {
                        this.whiteTimeOut = true;
                    }
                }
                if (this.whiteTime == 1 && this.whiteSec2 == this.readSecLimit - 1) {
                    this.playSound(17);
                    MyNewClock.sleepSec(30);
                }
                if (this.readSecLimit > 10 && this.readSecLimit - this.whiteSec2 == 10) {
                    this.playSound(11);
                } else if (this.readSecLimit > 20 && this.readSecLimit - this.whiteSec2 == 20) {
                    this.playSound(12);
                } else if (this.readSecLimit > 30 && this.readSecLimit - this.whiteSec2 == 30) {
                    this.playSound(13);
                } else if (this.readSecLimit > 40 && this.readSecLimit - this.whiteSec2 == 40) {
                    this.playSound(14);
                }
                if (this.whiteSec2 <= 10 && this.whiteSec2 >= 1) {
                    this.playSound(this.whiteSec2);
                }
            } else {
                if (this.whiteSec > 0) {
                    --this.whiteSec;
                } else {
                    this.whiteSec = 59;
                    if (this.whiteMin > 0) {
                        --this.whiteMin;
                    } else {
                        this.whiteMin = 59;
                        --this.whiteHour;
                    }
                }
                if (this.whiteSec == 0 && this.whiteMin == 0 && this.whiteHour == 0) {
                    this.playSound(16);
                    MyNewClock.sleepSec(30);
                }
            }
        }
    }

    private static void sleepSec(int n) {
        if (n < 0) {
            return;
        }
        if (n == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void playSound(int n) {
        if (this.quiet) {
            return;
        }
        Sound.readSecSound(n);
    }

    public void paint() {
        int n = this.getTimeFlag();
        if (n == 2 || n == 1 || n == 0) {
            boolean bl;
            String string = new String(" " + this.c(this.blackHour) + ":" + this.c(this.blackMin) + ":" + this.c(this.blackSec));
            String string2 = new String(" " + this.c(this.blackTime) + " " + this.c(this.blackSec2));
            String string3 = new String(" " + this.c(this.whiteHour) + ":" + this.c(this.whiteMin) + ":" + this.c(this.whiteSec));
            String string4 = new String(" " + this.c(this.whiteTime) + " " + this.c(this.whiteSec2));
            boolean bl2 = true;
            boolean bl3 = false;
            if (this.getTimeFlag() == 2) {
                bl = false;
                if (this.whiteHour > 0 || this.whiteMin > 0 || this.whiteSec > 0) {
                    bl2 = true;
                } else {
                    bl2 = false;
                    bl3 = this.whiteTime <= 1;
                }
            } else {
                bl = true;
                if (this.blackHour > 0 || this.blackMin > 0 || this.blackSec > 0) {
                    bl2 = true;
                } else {
                    bl2 = false;
                    bl3 = this.blackTime <= 1;
                }
            }
            this.alarm.paintDate(string, string2, string3, string4, bl, bl2, bl3, this.blackPercent(), this.whitePercent());
        } else if (n == 3 || n == 4) {
            if (n == 3) {
                int n2 = this.blackBreakLineCount / 60;
                int n3 = this.blackBreakLineCount % 60;
                this.alarm.printBreakLineTimer(Global.lang.getKey("118_break") + " " + this.c(n2) + ":" + this.c(n3), true);
            } else {
                int n4 = this.whiteBreakLineCount / 60;
                int n5 = this.whiteBreakLineCount % 60;
                this.alarm.printBreakLineTimer(Global.lang.getKey("118_break") + " " + this.c(n4) + ":" + this.c(n5), false);
            }
        }
    }

    private String c(int n) {
        if (n >= 0 && n <= 9) {
            return "0" + n;
        }
        if (n <= 60 && n >= 10) {
            return "" + n;
        }
        if (n < 0 && n >= -9) {
            return "" + n;
        }
        if (n <= -10 && n >= -60) {
            return "" + n;
        }
        return "99";
    }

    private void modifyBlackTime(int n, int n2, int n3, int n4, int n5) {
        this.blackHour = n;
        this.blackMin = n2;
        this.blackSec = n3;
        this.blackTime = n4;
        this.blackSec2 = n5;
    }

    private void modifyWhiteTime(int n, int n2, int n3, int n4, int n5) {
        this.whiteHour = n;
        this.whiteMin = n2;
        this.whiteSec = n3;
        this.whiteTime = n4;
        this.whiteSec2 = n5;
    }

    public synchronized void modifyTime(ClockSnap clockSnap) {
        if (clockSnap.blackHour <= 0 && clockSnap.blackMin <= 0 && clockSnap.blackSec <= 0 && clockSnap.blackReadTime <= 0 && clockSnap.blackReadSec <= 0) {
            this.modifyBlackTime(0, 0, 0, 0, 0);
        } else {
            this.modifyBlackTime(clockSnap.blackHour, clockSnap.blackMin, clockSnap.blackSec, clockSnap.blackReadTime, this.readSecLimit);
        }
        if (clockSnap.whiteHour <= 0 && clockSnap.whiteMin <= 0 && clockSnap.whiteSec <= 0 && clockSnap.whiteReadTime <= 0 && clockSnap.whiteReadSec <= 0) {
            this.modifyWhiteTime(0, 0, 0, 0, 0);
        } else {
            this.modifyWhiteTime(clockSnap.whiteHour, clockSnap.whiteMin, clockSnap.whiteSec, clockSnap.whiteReadTime, this.readSecLimit);
        }
    }

    public void modifyAndPaintTime(ClockSnap clockSnap) {
        this.modifyTime(clockSnap);
        this.paint();
    }

    private int blackPercent() {
        int n;
        int n2 = this.hourLimit * 3600 + this.minLimit * 60 + this.secLimit;
        int n3 = this.blackHour * 3600 + this.blackMin * 60 + this.blackSec;
        if (n2 > 0 && (n = (n2 - n3) * 100 / n2) >= 0 && n < 100) {
            return n;
        }
        if (this.readSecLimit == 0) {
            return 100;
        }
        return 100 - this.blackSec2 * 100 / this.readSecLimit;
    }

    private int whitePercent() {
        int n;
        int n2 = this.hourLimit * 3600 + this.minLimit * 60 + this.secLimit;
        int n3 = this.whiteHour * 3600 + this.whiteMin * 60 + this.whiteSec;
        if (n2 > 0 && (n = (n2 - n3) * 100 / n2) >= 0 && n < 100) {
            return n;
        }
        if (this.readSecLimit == 0) {
            return 100;
        }
        return 100 - this.whiteSec2 * 100 / this.readSecLimit;
    }
}

