/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.util.Vector;
import tianyuan.games.base.GoGameRecord;
import tianyuan.games.base.GoGameRule;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.goeroom.GoeSeeGameRecordPane;
import tianyuan.games.gui.goe.goeroom.SeeGameRecordClock;
import tianyuan.games.gui.goe.goeroom.clk.ClockSnap;
import tianyuan.games.gui.goe.goeroom.qp.Cvs2QiPan;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;

class SeeGameRecordControl {
    GoeSeeGameRecordPane goePane;

    SeeGameRecordControl(GoeSeeGameRecordPane goeSeeGameRecordPane) {
        this.goePane = goeSeeGameRecordPane;
    }

    void setRecord(GoGameRecord goGameRecord) {
        this.goePane.board.clear();
        this.goePane.clock.setRule(goGameRecord.rule);
        boolean bl = this.goePane.board.getSound();
        this.goePane.board.setSound(false);
        Vector<QiZi> vector = GoGameRule.getBeginFinalQiZi(goGameRecord.rule);
        for (QiZi object : vector) {
            this.goePane.board.setQiZi(object);
        }
        for (GoRecordQiZi goRecordQiZi : goGameRecord.mem) {
            this.setRecordQiZi(goRecordQiZi, this.goePane.clock, this.goePane.board);
        }
        this.displayBeEatedCount();
        this.goePane.board.seeGameRecordInit();
        this.goePane.board.setSound(bl);
    }

    protected final void displaySeeGameBeEatedCount() {
        String string = Global.lang.getKey("118_eat") + " ";
        this.goePane.clock.printInfo(string + this.goePane.board.getSeeGameWhiteBeEatedCounter(), true);
        this.goePane.clock.printInfo(string + this.goePane.board.getSeeGameBlackBeEatedCounter(), false);
    }

    protected final void displayBeEatedCount() {
        String string = Global.lang.getKey("118_eat") + " ";
        this.goePane.clock.printInfo(string + this.goePane.board.getWhiteBeEatedCounter(), true);
        this.goePane.clock.printInfo(string + this.goePane.board.getBlackBeEatedCounter(), false);
    }

    private void setRecordQiZi(GoRecordQiZi goRecordQiZi, SeeGameRecordClock seeGameRecordClock, Cvs2QiPan cvs2QiPan) {
        switch (goRecordQiZi.type) {
            case 1: {
                cvs2QiPan.setQiZi(goRecordQiZi.qz);
                if (seeGameRecordClock.clock == null) break;
                seeGameRecordClock.clock.modifyTime(goRecordQiZi.snap);
                seeGameRecordClock.clock.paint();
                break;
            }
            case 3: {
                if (goRecordQiZi.agreeUser.equals(this.goePane.record.black)) {
                    cvs2QiPan.goBack(2);
                    break;
                }
                cvs2QiPan.goBack(1);
            }
        }
    }

    public void setClockSnap() {
        QiZi qiZi = this.goePane.board.getSeeGameLastQiZi();
        ClockSnap clockSnap = this.getSnap(this.goePane.record, qiZi);
        if (clockSnap == null) {
            return;
        }
        this.goePane.clock.clock.modifyAndPaintTime(clockSnap);
        this.goePane.clock.clock.paint();
    }

    private ClockSnap getSnap(GoGameRecord goGameRecord, QiZi qiZi) {
        if (goGameRecord == null) {
            return null;
        }
        if (goGameRecord.mem == null) {
            return null;
        }
        if (qiZi == null) {
            return null;
        }
        for (GoRecordQiZi goRecordQiZi : goGameRecord.mem) {
            if (goRecordQiZi.type != 1 || !goRecordQiZi.qz.equals(qiZi) || goRecordQiZi.qz.getNumber() != qiZi.getNumber()) continue;
            return goRecordQiZi.snap;
        }
        return null;
    }
}

