/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.phoenix.util.MyProperties;
import org.phoenix.util.RwProperties;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJButton;
import tianyuan.games.gui.goe.goeroom.qp.CvsQiPan;
import tianyuan.games.gui.goe.goeroom.qp.WeiQiType;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;

public class BoardView
extends MyJButton
implements ActionListener {
    private MyProperties lang;
    private RwProperties paramter;
    CvsQiPan board;
    protected final JPopupMenu popup = new JPopupMenu();

    public BoardView(CvsQiPan cvsQiPan) {
        super(Global.lang.getKey("7_boardView"));
        this.board = cvsQiPan;
        this.lang = Global.lang;
        this.paramter = Global.paramter;
        this.createPopup();
        this.addMouseListener(new PopupAdapter(this.popup, this));
        this.addActionListener(this);
    }

    public BoardView(CvsQiPan cvsQiPan, MyProperties myProperties, RwProperties rwProperties) {
        super(myProperties.getKey("7_boardView"));
        this.board = cvsQiPan;
        this.lang = myProperties;
        this.paramter = rwProperties;
        this.createPopup();
        this.addMouseListener(new PopupAdapter(this.popup, this));
        this.addActionListener(this);
    }

    public void setBoard(CvsQiPan cvsQiPan) {
        this.board = cvsQiPan;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.popup.show(this, 10, 10);
    }

    protected void createPopup() {
        this.popup.add(new BooleanPropertySet("7_displayNumber"));
        this.popup.add(new BooleanPropertySet("7_bigStone"));
        this.popup.add(new BooleanPropertySet("7_showTarget"));
        this.popup.add(new BooleanPropertySet("7_show3DStone"));
        this.popup.add(new BooleanPropertySet("7_idLastWithNumber"));
        this.popup.add(new BooleanPropertySet("7_woodBoard"));
        this.popup.add(new BooleanPropertySet("7_saturatedBoardColor"));
        this.popup.add(new BooleanPropertySet("7_showCoordinate"));
        if (WeiQiType.type == 3 || WeiQiType.type == 4 || WeiQiType.type == 5) {
            this.popup.add(this.createVisualModeSetMenu());
        }
    }

    protected JMenu createVisualModeSetMenu() {
        JMenu jMenu = new JMenu(this.lang.getKey("300_visual_mode"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (byte by = 0; by <= 9; by = (byte)(by + 1)) {
            boolean bl = false;
            bl = by == 4;
            VisualModeSetRadio visualModeSetRadio = new VisualModeSetRadio(by, bl);
            buttonGroup.add(visualModeSetRadio);
            jMenu.add(visualModeSetRadio);
        }
        return jMenu;
    }

    class BooleanPropertySet
    extends JCheckBoxMenuItem
    implements ItemListener {
        String key;

        public BooleanPropertySet(String string) {
            super(BoardView.this.lang.getKey(string), BoardView.this.paramter.getBoolean(string));
            this.key = string;
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            BoardView.this.paramter.setBoolean(this.key, this.getState());
            BoardView.this.paramter.writeOut();
            BoardView.this.board.setAllFlag(BoardView.this.paramter.getBoolean("7_displayNumber"), BoardView.this.paramter.getBoolean("7_idLastWithNumber"), BoardView.this.paramter.getBoolean("7_show3DStone"), BoardView.this.paramter.getBoolean("7_bigStone"), BoardView.this.paramter.getBoolean("7_showTarget"), BoardView.this.paramter.getBoolean("7_woodBoard"), BoardView.this.paramter.getBoolean("7_saturatedBoardColor"), BoardView.this.paramter.getBoolean("7_showCoordinate"));
        }
    }

    class FullScreenSet
    extends JCheckBoxMenuItem
    implements ItemListener {
        public FullScreenSet() {
            super(BoardView.this.lang.getKey("7_fullscreen"), false);
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    class VisualModeSetRadio
    extends JRadioButtonMenuItem
    implements ItemListener {
        byte visualMode;

        VisualModeSetRadio(byte by, boolean bl) {
            super("" + by, bl);
            this.visualMode = by;
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                BoardView.this.board.setVisualMode(this.visualMode);
                BoardView.this.board.repaint();
            }
        }
    }

    class PopupAdapter
    extends PopupMenuMouseAdapter {
        public PopupAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

