/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor.maptree;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Vector;
import tianyuan.games.base.Root;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.gui.goe.editor.maptree.MapTreeModel;
import tianyuan.games.gui.goe.editor.maptree.MapTreeNode;
import tianyuan.games.gui.goe.editor.maptree.MapTreeSgfNode;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;
import tianyuan.games.sgf.SgfNode;
import tianyuan.games.sgf.SgfParse;

public class QiPu
extends Root {
    private MapTreeModel treeModel;
    private static final int QIPU_TYPE1 = 118380;
    private boolean fileCanRecognized = true;

    public QiPu() {
    }

    public QiPu(Vector<QiZi> vector) {
        MapTreeNode mapTreeNode = new MapTreeNode(new QiZi(0, 9, 9));
        this.treeModel = new MapTreeModel(mapTreeNode);
        int n = 0;
        for (QiZi qiZi : vector) {
            MapTreeNode mapTreeNode2 = new MapTreeNode(qiZi);
            this.treeModel.insertNodeInto(mapTreeNode2, mapTreeNode, n);
            ++n;
        }
    }

    public QiPu(File file) {
        MapTreeNode mapTreeNode = new MapTreeNode(new QiZi(0, 9, 9));
        this.treeModel = new MapTreeModel(mapTreeNode);
        String string = SgfParse.readSgfFile(file);
        SgfNode sgfNode = SgfParse.createTree(string);
        MapTreeSgfNode mapTreeSgfNode = MapTreeSgfNode.transferTree(sgfNode);
        MapTreeSgfNode.transferTree(mapTreeSgfNode, this.treeModel);
        this.treeModel.resortQiZiNumber();
    }

    public QiPu(MapTreeModel mapTreeModel) {
        this.treeModel = mapTreeModel;
    }

    public void setTreeModel(MapTreeModel mapTreeModel) {
        this.treeModel = mapTreeModel;
    }

    public MapTreeModel getTreeModel() {
        return this.treeModel;
    }

    public String getTitle() {
        if (this.treeModel == null) {
            return "";
        }
        MapTreeNode mapTreeNode = (MapTreeNode)this.treeModel.getRoot();
        if (mapTreeNode == null) {
            return "";
        }
        return mapTreeNode.getTitle();
    }

    public void setTitle(String string) {
        if (this.treeModel == null) {
            return;
        }
        MapTreeNode mapTreeNode = (MapTreeNode)this.treeModel.getRoot();
        if (mapTreeNode == null) {
            return;
        }
        mapTreeNode.setTitle(string);
    }

    public String getExplain() {
        if (this.treeModel == null) {
            return "";
        }
        MapTreeNode mapTreeNode = (MapTreeNode)this.treeModel.getRoot();
        if (mapTreeNode == null) {
            return "";
        }
        return mapTreeNode.getExplain();
    }

    public void setExplain(String string) {
        if (this.treeModel == null) {
            return;
        }
        MapTreeNode mapTreeNode = (MapTreeNode)this.treeModel.getRoot();
        if (mapTreeNode == null) {
            return;
        }
        mapTreeNode.setExplain(string);
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        MapTreeNode mapTreeNode;
        tyBaseOutput.writeInt(118380);
        LinkedList<MapTreeNode> linkedList = new LinkedList<MapTreeNode>();
        MapTreeNode mapTreeNode2 = (MapTreeNode)this.treeModel.getRoot();
        boolean bl = linkedList.offer(mapTreeNode2);
        tyBaseOutput.writeInt(this.treeModel.getNodeTotal());
        mapTreeNode2.setNodeNumber(0);
        tyBaseOutput.writeInt(-1);
        mapTreeNode2.write(tyBaseOutput);
        int n = 1;
        while ((mapTreeNode = (MapTreeNode)linkedList.poll()) != null) {
            MapTreeNode mapTreeNode3 = (MapTreeNode)mapTreeNode.getParent();
            if (mapTreeNode3 == null) {
                if (mapTreeNode != mapTreeNode2) {
                    System.out.println("error node =" + n);
                }
            } else {
                mapTreeNode.setNodeNumber(n);
                ++n;
                tyBaseOutput.writeInt(mapTreeNode3.getNodeNumber());
                mapTreeNode.write(tyBaseOutput);
            }
            if (mapTreeNode.isLeaf()) continue;
            for (int i = 0; i < mapTreeNode.getChildCount(); ++i) {
                linkedList.offer((MapTreeNode)mapTreeNode.getChildAt(i));
            }
        }
    }

    public boolean fileCanUsed() {
        return this.fileCanRecognized;
    }

    public int getQiPuSize() {
        if (this.treeModel == null) {
            return 0;
        }
        return this.treeModel.getNodeTotal();
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        int n = tyBaseInput.readInt();
        if (n != 118380) {
            this.fileCanRecognized = false;
            return;
        }
        int n2 = tyBaseInput.readInt();
        int n3 = tyBaseInput.readInt();
        MapTreeNode mapTreeNode = new MapTreeNode();
        mapTreeNode.read(tyBaseInput);
        Vector<MapTreeNode> vector = new Vector<MapTreeNode>();
        vector.add(mapTreeNode);
        for (int i = 1; i < n2; ++i) {
            int n4 = tyBaseInput.readInt();
            MapTreeNode mapTreeNode2 = new MapTreeNode();
            mapTreeNode2.read(tyBaseInput);
            vector.add(mapTreeNode2);
            if (n4 < 0 || n4 > vector.size()) {
                System.out.println("node number error.");
                continue;
            }
            MapTreeNode mapTreeNode3 = (MapTreeNode)vector.elementAt(n4);
            mapTreeNode3.add(mapTreeNode2);
        }
        this.treeModel = new MapTreeModel(mapTreeNode);
        this.fileCanRecognized = true;
    }
}

