/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor.maptree;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import tianyuan.games.gui.goe.editor.GoEditor;
import tianyuan.games.gui.goe.editor.GoEditorInterface;
import tianyuan.games.gui.goe.editor.maptree.MapTreeCellEditor;
import tianyuan.games.gui.goe.editor.maptree.MapTreeCellRenderer;
import tianyuan.games.gui.goe.editor.maptree.MapTreeModel;
import tianyuan.games.gui.goe.editor.maptree.MapTreeNode;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;

public class MapTree
extends JPanel
implements CellEditorListener {
    private GoEditorInterface editor;
    private MapTreeNode beSelectedNode = null;
    private TreePath beSelectedPath = null;
    private final JPopupMenu popup = new JPopupMenu();
    private AddSubTreeAction addSubTreeAction = new AddSubTreeAction();
    private DelSubTreeAction delSubTreeAction = new DelSubTreeAction();
    private MapTreeModel treeModel;
    private MapTreeCellRenderer nodeRenderer;
    private MapTreeCellEditor nodeEditor;
    private JTree tree;
    private JScrollBar scrollBar = new JScrollBar(1);

    public MapTree(GoEditorInterface goEditorInterface, TreeSelectionListener treeSelectionListener) {
        this.editor = goEditorInterface;
        this.treeModel = new MapTreeModel(new MapTreeNode(new QiZi(0, 9, 9)));
        this.beSelectedNode = (MapTreeNode)this.treeModel.getRoot();
        this.beSelectedPath = new TreePath(this.beSelectedNode);
        this.tree = new JTree(this.treeModel);
        this.tree.addTreeSelectionListener(treeSelectionListener);
        this.tree.setEditable(true);
        this.nodeRenderer = new MapTreeCellRenderer();
        this.nodeRenderer.setLangAndParamter(goEditorInterface.getLang(), goEditorInterface.getParamter());
        this.nodeEditor = new MapTreeCellEditor(this.tree, this.nodeRenderer);
        this.nodeEditor.addCellEditorListener(this);
        this.tree.setCellEditor(this.nodeEditor);
        this.tree.setCellRenderer(this.nodeRenderer);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jScrollPane.getViewport().add(this.tree);
        this.setLayout(new BorderLayout());
        this.add("Center", jScrollPane);
        this.createPopupMenu();
    }

    public void setEditable(boolean bl) {
        this.tree.setEditable(bl);
    }

    public void setCanUsed(boolean bl) {
        this.tree.setEnabled(bl);
    }

    private void insertSubkey(QiZi qiZi) {
        if (this.beSelectedNode == null) {
            System.out.println("insert sub key " + qiZi.toString() + " fail!");
            return;
        }
        this.beSelectedNode.addSubKey(qiZi);
    }

    private void insertMark(QiZi qiZi) {
        if (this.beSelectedNode == null) {
            System.out.println("insert mark " + qiZi.toString() + " fail!");
            return;
        }
        this.beSelectedNode.addMark(qiZi);
    }

    public void insert(QiZi qiZi) {
        Object object;
        if (qiZi.flag == 4 || qiZi.flag == 7) {
            this.insertSubkey(qiZi);
            return;
        }
        if (QiZi.isMarkFlag(qiZi.flag)) {
            this.insertMark(qiZi);
            return;
        }
        MapTreeNode mapTreeNode = new MapTreeNode(qiZi);
        MapTreeNode mapTreeNode2 = (MapTreeNode)this.beSelectedNode.getParent();
        if (mapTreeNode2 != null) {
            int n;
            object = this.beSelectedNode.getKey();
            if (object.getColor() == 0) {
                n = mapTreeNode2.getIndex(this.beSelectedNode);
                this.treeModel.insertNodeInto(mapTreeNode, this.beSelectedNode, 0);
            } else {
                n = this.treeModel.getIndexOfChild(mapTreeNode2, this.beSelectedNode);
                this.treeModel.insertNodeInto(mapTreeNode, mapTreeNode2, n + 1);
            }
        } else {
            object = (MapTreeNode)this.treeModel.getRoot();
            this.treeModel.insertNodeInto(mapTreeNode, (MutableTreeNode)object, 0);
        }
        this.treeModel.resortQiZiNumber();
        object = this.treeModel.getPathToRoot(mapTreeNode);
        TreePath treePath = new TreePath((Object[])object);
        this.tree.setSelectionPath(treePath);
    }

    public void clear() {
        this.treeModel.setRoot(new MapTreeNode(new QiZi(0, 9, 9)));
        this.beSelectedNode = (MapTreeNode)this.treeModel.getRoot();
        this.beSelectedPath = new TreePath(this.beSelectedNode);
        this.tree.setSelectionPath(this.beSelectedPath);
        this.editor.setPath(this.beSelectedPath, this.treeModel);
    }

    public void selectBegin() {
        TreePath treePath;
        MapTreeNode mapTreeNode;
        this.beSelectedNode = mapTreeNode = (MapTreeNode)this.treeModel.getRoot();
        Object[] objectArray = this.treeModel.getPathToRoot(mapTreeNode);
        this.beSelectedPath = treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
    }

    public void selectEnd() {
        TreePath treePath;
        MapTreeNode mapTreeNode;
        MapTreeNode mapTreeNode2 = (MapTreeNode)this.treeModel.getRoot();
        this.beSelectedNode = mapTreeNode = (MapTreeNode)mapTreeNode2.getLastChild();
        Object[] objectArray = this.treeModel.getPathToRoot(mapTreeNode);
        this.beSelectedPath = treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
    }

    public boolean removeMark(int n, int n2) {
        if (this.beSelectedNode == null) {
            return false;
        }
        if (this.beSelectedNode.removeMark(n, n2)) {
            this.editor.setPath(this.beSelectedPath, this.treeModel);
            return true;
        }
        return false;
    }

    public boolean removeQiZi(QiZi qiZi) {
        MapTreeNode mapTreeNode;
        if (this.beSelectedPath == null) {
            System.out.println("delete qz fail:beSelectedPath is null");
            return false;
        }
        boolean bl = false;
        Object[] objectArray = this.beSelectedPath.getPath();
        for (int i = objectArray.length - 1; i >= 0 && !(mapTreeNode = (MapTreeNode)objectArray[i]).getKey().equals(qiZi); --i) {
            if (mapTreeNode.removeSubKey(qiZi)) {
                bl = true;
                break;
            }
            if (!mapTreeNode.removeMark(qiZi)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.editor.setPath(this.beSelectedPath, this.treeModel);
        }
        return bl;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.beSelectedNode.setTitle(this.nodeEditor.getCellEditorValue().toString());
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public String valueChanged(TreeSelectionEvent treeSelectionEvent, String string) {
        if (this.beSelectedNode != null) {
            this.beSelectedNode.setExplain(string);
        }
        TreePath treePath = treeSelectionEvent.getPath();
        this.beSelectedNode = (MapTreeNode)treePath.getLastPathComponent();
        this.beSelectedPath = treePath;
        if (this.beSelectedNode != null) {
            return this.beSelectedNode.getExplain();
        }
        return null;
    }

    private void createPopupMenu() {
        this.popup.add(this.addSubTreeAction);
        this.popup.add(this.delSubTreeAction);
        this.tree.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.tree));
    }

    private MapTreeNode insertChild(QiZi qiZi, MapTreeNode mapTreeNode) {
        if (mapTreeNode == null || qiZi == null) {
            return null;
        }
        MapTreeNode mapTreeNode2 = new MapTreeNode(qiZi);
        int n = mapTreeNode.getChildCount();
        this.treeModel.insertNodeInto(mapTreeNode2, mapTreeNode, n);
        Object[] objectArray = this.treeModel.getPathToRoot(mapTreeNode2);
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
        return mapTreeNode2;
    }

    public void insertSubTree() {
        MapTreeNode mapTreeNode = this.insertChild(new QiZi(0, 9, 9), this.beSelectedNode);
        if (mapTreeNode != null) {
            mapTreeNode.setTitle(GoEditor.lang.getKey("304_reference"));
            this.editor.setNewDataUnSaveFlag(true);
        }
    }

    private boolean removeNode(MapTreeNode mapTreeNode) {
        if (mapTreeNode == null) {
            return false;
        }
        MapTreeNode mapTreeNode2 = (MapTreeNode)mapTreeNode.getParent();
        if (mapTreeNode2 == null) {
            return false;
        }
        MapTreeNode mapTreeNode3 = (MapTreeNode)mapTreeNode2.getChildBefore(mapTreeNode);
        this.treeModel.removeNodeFromParent(mapTreeNode);
        Object[] objectArray = mapTreeNode3 != null ? this.treeModel.getPathToRoot(mapTreeNode3) : this.treeModel.getPathToRoot(mapTreeNode2);
        this.treeModel.resortQiZiNumber();
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
        return true;
    }

    public void removeSubTree() {
        if (this.removeNode(this.beSelectedNode)) {
            this.editor.setNewDataUnSaveFlag(true);
        }
    }

    public MapTreeNode getRoot() {
        return (MapTreeNode)this.treeModel.getRoot();
    }

    public MapTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(MapTreeModel mapTreeModel) {
        this.treeModel = mapTreeModel;
        this.tree.setModel(mapTreeModel);
    }

    class DelSubTreeAction
    extends AbstractAction {
        DelSubTreeAction() {
            super(GoEditor.lang.getKey("210_del_sub_tree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MapTree.this.removeSubTree();
        }
    }

    class AddSubTreeAction
    extends AbstractAction {
        AddSubTreeAction() {
            super(GoEditor.lang.getKey("210_add_sub_tree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MapTree.this.insertSubTree();
        }
    }
}

