/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.SpringLayout;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJButton;
import tianyuan.games.gui.MyJToggleButton;
import tianyuan.games.gui.goe.editor.GoEditor;
import tianyuan.games.gui.goe.editor.GoEditorBoard;
import tianyuan.games.gui.goe.editor.GoNetEditor;
import tianyuan.games.gui.goe.goeroom.BoardView;
import tianyuan.games.gui.goe.goeroom.GoCommandPane;

public class GoNetEditorCommandPane
extends GoCommandPane {
    private GoNetEditor netEditor;
    private GoEditorBoard board;
    private boolean analysisFlag = false;
    AbstractButton[] button1 = new AbstractButton[6];
    protected SizeListener seeSize = new SizeListener();

    public GoNetEditorCommandPane(GoEditor goEditor, GoEditorBoard goEditorBoard) {
        this.netEditor = (GoNetEditor)goEditor;
        this.board = goEditorBoard;
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
    }

    @Override
    protected void resetLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = (dimension.width - 10) / this.button1.length;
        int n2 = dimension.height - 4;
        for (int i = 0; i < this.button1.length; ++i) {
            this.addComp(this.button1[i], dimension.width / this.button1.length * i + 2, 0, n, n2);
        }
    }

    private void createButton() {
        this.button1[1] = new MyJToggleButton(GoEditor.lang.getKey("211_analyze"));
        this.button1[2] = new MyJToggleButton(GoEditor.lang.getKey("120_test"));
        this.button1[3] = new MyJToggleButton(GoEditor.lang.getKey("211_quiet"));
        this.button1[4] = new MyJButton(GoEditor.lang.getKey("255_save"));
        this.button1[5] = new MyJButton(GoEditor.lang.getKey("211_quit"));
        this.button1[1].addItemListener(new AnalysisListener());
        this.button1[2].addItemListener(new TestListener());
        this.button1[3].addItemListener(new QuietListener());
        this.button1[4].addActionListener(new ModifyListener());
        this.button1[5].addActionListener(new QuitListener());
        try {
            this.boardView = new BoardView(this.board, GoNetEditor.lang, GoNetEditor.paramter);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        this.button1[0] = this.boardView;
    }

    protected class SizeListener
    extends ComponentAdapter {
        protected SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoNetEditorCommandPane.this.resetLayout();
        }
    }

    class QuitListener
    implements ActionListener {
        QuitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Global.goRootPane.remove(GoNetEditorCommandPane.this.netEditor);
        }
    }

    class ModifyListener
    implements ActionListener {
        ModifyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Global.netDaemon == null) {
                return;
            }
            if (GoNetEditorCommandPane.this.netEditor.getIsMyCollections()) {
                Global.netDaemon.bbsModifyMyCollectionGoQiPu(GoNetEditorCommandPane.this.netEditor.getNumber(), GoNetEditorCommandPane.this.netEditor.getGoQiPu());
            } else {
                Global.netDaemon.bbsModifyGoQiPu(GoNetEditorCommandPane.this.netEditor.getTopic(), GoNetEditorCommandPane.this.netEditor.getNumber(), GoNetEditorCommandPane.this.netEditor.getGoQiPu());
            }
        }
    }

    class TestListener
    implements ItemListener {
        TestListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                GoNetEditorCommandPane.this.netEditor.enterTestMode();
            } else {
                GoNetEditorCommandPane.this.netEditor.quitTestMode();
            }
        }
    }

    class AnalysisListener
    implements ItemListener {
        AnalysisListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                GoNetEditorCommandPane.this.netEditor.enterAnalysisMode();
                GoNetEditorCommandPane.this.analysisFlag = true;
            } else {
                GoNetEditorCommandPane.this.netEditor.quitAnalysisMode();
                GoNetEditorCommandPane.this.analysisFlag = false;
            }
        }
    }

    class QuietListener
    implements ItemListener {
        QuietListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                ((GoNetEditorCommandPane)GoNetEditorCommandPane.this).netEditor.boardMainPane.board.setSound(false);
            } else {
                ((GoNetEditorCommandPane)GoNetEditorCommandPane.this).netEditor.boardMainPane.board.setSound(true);
            }
        }
    }
}

