/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.commonbbs;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tianyuan.games.base.BbsTopics;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.commonbbs.CommonBbsContentTabbedPane;
import tianyuan.games.gui.commonbbs.CommonBbsMenuTreeCellEditor;
import tianyuan.games.gui.commonbbs.CommonBbsMenuTreeCellRenderer;
import tianyuan.games.gui.commonbbs.CommonBbsMenuTreeModel;
import tianyuan.games.gui.commonbbs.CommonBbsMenuTreeNode;
import tianyuan.games.gui.commonbbs.CommonBbsTopicsMenu;
import tianyuan.games.gui.goe.qipubbs.MyTransferHandler;

public class CommonBbsMenu
extends JPanel
implements CellEditorListener,
TreeSelectionListener {
    private JTree tree;
    private CommonBbsMenuTreeModel treeModel;
    private CommonBbsMenuTreeCellRenderer nodeRenderer;
    private CommonBbsMenuTreeCellEditor nodeEditor;
    private boolean isManager = false;
    private BbsTopics topics;
    private CommonBbsMenuTreeNode treeModelRoot = new CommonBbsMenuTreeNode("root");
    private CommonBbsContentTabbedPane tabbedView = null;
    private final JPopupMenu popup = new JPopupMenu();
    private AddSubTreeAction addSubTreeAction = new AddSubTreeAction();
    private DelSubTreeAction delSubTreeAction = new DelSubTreeAction();
    private CommonBbsMenuTreeNode beSelectedNode = null;
    private TreePath beSelectedPath = null;

    public CommonBbsMenu(boolean bl, CommonBbsContentTabbedPane commonBbsContentTabbedPane) {
        this.tabbedView = commonBbsContentTabbedPane;
        this.init();
        this.setManagerFlag(bl);
    }

    private CommonBbsMenuTreeNode insertChild(String string, CommonBbsMenuTreeNode commonBbsMenuTreeNode) {
        if (commonBbsMenuTreeNode == null || string == null) {
            return null;
        }
        CommonBbsMenuTreeNode commonBbsMenuTreeNode2 = new CommonBbsMenuTreeNode(commonBbsMenuTreeNode.getKey() + '.' + string);
        int n = commonBbsMenuTreeNode.getChildCount();
        this.treeModel.insertNodeInto(commonBbsMenuTreeNode2, commonBbsMenuTreeNode, n);
        Object[] objectArray = this.treeModel.getPathToRoot(commonBbsMenuTreeNode2);
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
        return commonBbsMenuTreeNode2;
    }

    private CommonBbsMenuTreeNode getRoot() {
        return (CommonBbsMenuTreeNode)this.treeModel.getRoot();
    }

    protected void myReset() {
        this.isManager = false;
        this.beSelectedNode = null;
        this.beSelectedPath = null;
        CommonBbsMenuTreeNode commonBbsMenuTreeNode = this.getRoot();
        Enumeration<TreeNode> enumeration = commonBbsMenuTreeNode.children();
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            CommonBbsMenuTreeNode commonBbsMenuTreeNode2 = (CommonBbsMenuTreeNode)enumeration.nextElement();
            vector.add(commonBbsMenuTreeNode2);
        }
        for (CommonBbsMenuTreeNode commonBbsMenuTreeNode3 : vector) {
            this.treeModel.removeNodeFromParent(commonBbsMenuTreeNode3);
        }
    }

    private void init() {
        this.treeModel = new CommonBbsMenuTreeModel(this.treeModelRoot);
        this.tree = new JTree(this.treeModel);
        this.beSelectedNode = (CommonBbsMenuTreeNode)this.treeModel.getRoot();
        this.beSelectedPath = new TreePath(this.beSelectedNode);
        this.tree.addTreeSelectionListener(this);
        this.nodeRenderer = new CommonBbsMenuTreeCellRenderer();
        this.nodeEditor = new CommonBbsMenuTreeCellEditor(this.tree, this.nodeRenderer);
        this.nodeEditor.addCellEditorListener(this);
        this.tree.setCellEditor(this.nodeEditor);
        this.tree.setCellRenderer(this.nodeRenderer);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jScrollPane.getViewport().add(this.tree);
        this.setLayout(new BorderLayout());
        this.add("Center", jScrollPane);
        this.popup.add(this.addSubTreeAction);
        this.popup.add(this.delSubTreeAction);
        this.tree.addMouseListener(new PopupActionAdapter(this.popup, this.tree));
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        CommonBbsMenuTreeNode commonBbsMenuTreeNode = (CommonBbsMenuTreeNode)this.treeModel.getRoot();
        if (this.beSelectedNode.equals(commonBbsMenuTreeNode)) {
            return;
        }
        if (!this.beSelectedNode.isLeaf()) {
            return;
        }
        String string = this.nodeEditor.getCellEditorValue().toString();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return;
        }
        this.beSelectedNode.setDisplayStr(string);
        if (Global.netDaemon == null) {
            return;
        }
        Global.netDaemon.commonBbsAddBbsTopic(this.beSelectedNode.getKey());
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.beSelectedPath = treeSelectionEvent.getPath();
        this.beSelectedNode = (CommonBbsMenuTreeNode)this.beSelectedPath.getLastPathComponent();
        if (this.beSelectedNode != null) {
            CommonBbsMenuTreeNode commonBbsMenuTreeNode = (CommonBbsMenuTreeNode)this.treeModel.getRoot();
            if (this.beSelectedNode.equals(commonBbsMenuTreeNode)) {
                return;
            }
            if (this.beSelectedNode.getTopicView() != null) {
                this.tabbedView.setSelectedComponent(this.beSelectedNode.getTopicView());
                return;
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.commonBbsGetIndexInTopic(this.beSelectedNode.getKey(), Integer.MAX_VALUE);
            }
        }
    }

    public CommonBbsMenuTreeNode getMenuNode(String string) {
        CommonBbsMenuTreeNode commonBbsMenuTreeNode = this.getRoot();
        Enumeration<TreeNode> enumeration = commonBbsMenuTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CommonBbsMenuTreeNode commonBbsMenuTreeNode2 = (CommonBbsMenuTreeNode)enumeration.nextElement();
            if (!commonBbsMenuTreeNode2.getKey().equals(string)) continue;
            return commonBbsMenuTreeNode2;
        }
        return null;
    }

    public void setTopics(BbsTopics bbsTopics) {
        this.topics = bbsTopics;
        CommonBbsTopicsMenu commonBbsTopicsMenu = new CommonBbsTopicsMenu(bbsTopics);
        commonBbsTopicsMenu.setMenuTreeData(this.treeModel);
        if (!this.treeModelRoot.isLeaf()) {
            Object[] objectArray = this.treeModel.getPathToRoot(this.treeModelRoot.getChildAt(0));
            TreePath treePath = new TreePath(objectArray);
            this.tree.setSelectionPath(treePath);
        }
    }

    public void selectTopic(CommonBbsMenuTreeNode commonBbsMenuTreeNode) {
        if (commonBbsMenuTreeNode == null) {
            return;
        }
        if (this.beSelectedNode == null) {
            return;
        }
        if (commonBbsMenuTreeNode.equals(this.beSelectedNode)) {
            return;
        }
        Object[] objectArray = this.treeModel.getPathToRoot(commonBbsMenuTreeNode);
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
    }

    public void setManagerFlag(boolean bl) {
        this.isManager = bl;
        if (bl) {
            this.tree.setEditable(true);
            this.tree.setTransferHandler(new MyTransferHandler());
        } else {
            this.tree.setEditable(false);
        }
    }

    public void addBbsTopic() {
        this.insertChild(Global.lang.getKey("240_menu_new_topic"), this.beSelectedNode);
    }

    public void delBbsTopic() {
        if (Global.netDaemon == null) {
            return;
        }
        if (this.beSelectedNode == null) {
            return;
        }
        if (this.beSelectedNode.getKey() == null) {
            return;
        }
        String string = this.beSelectedNode.getKey();
        if (!this.removeNode(this.beSelectedNode)) {
            return;
        }
        Global.netDaemon.commonBbsDelBbsTopic(string);
        if (this.tabbedView != null) {
            this.tabbedView.removeToicView(string);
        }
    }

    private boolean removeNode(CommonBbsMenuTreeNode commonBbsMenuTreeNode) {
        if (commonBbsMenuTreeNode == null) {
            return false;
        }
        CommonBbsMenuTreeNode commonBbsMenuTreeNode2 = (CommonBbsMenuTreeNode)commonBbsMenuTreeNode.getParent();
        if (commonBbsMenuTreeNode2 == null) {
            return false;
        }
        if (commonBbsMenuTreeNode.getChildCount() > 0) {
            return false;
        }
        CommonBbsMenuTreeNode commonBbsMenuTreeNode3 = (CommonBbsMenuTreeNode)commonBbsMenuTreeNode2.getChildBefore(commonBbsMenuTreeNode);
        CommonBbsMenuTreeNode commonBbsMenuTreeNode4 = (CommonBbsMenuTreeNode)commonBbsMenuTreeNode2.getChildAfter(commonBbsMenuTreeNode);
        this.treeModel.removeNodeFromParent(commonBbsMenuTreeNode);
        Object[] objectArray = commonBbsMenuTreeNode3 != null ? this.treeModel.getPathToRoot(commonBbsMenuTreeNode3) : (commonBbsMenuTreeNode4 != null ? this.treeModel.getPathToRoot(commonBbsMenuTreeNode4) : this.treeModel.getPathToRoot(commonBbsMenuTreeNode2));
        TreePath treePath = new TreePath(objectArray);
        this.tree.setSelectionPath(treePath);
        return true;
    }

    class PopupActionAdapter
    extends MouseAdapter {
        protected JPopupMenu popup;
        protected JComponent comp;

        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            this.comp = jComponent;
            this.popup = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (!CommonBbsMenu.this.isManager) {
                    return;
                }
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class DelSubTreeAction
    extends AbstractAction {
        DelSubTreeAction() {
            super(Global.lang.getKey("210_del_sub_tree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsMenu.this.delBbsTopic();
        }
    }

    class AddSubTreeAction
    extends AbstractAction {
        AddSubTreeAction() {
            super(Global.lang.getKey("210_add_sub_tree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsMenu.this.addBbsTopic();
        }
    }
}

