/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.base;

import java.io.IOException;
import java.util.Vector;
import tianyuan.games.base.GoGameIndex;
import tianyuan.games.base.GoGameResult;
import tianyuan.games.base.GoGameRule;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.base.Level;
import tianyuan.games.base.Root;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;

public class GoGameRecord
extends Root {
    public String title = "";
    public long beginTime = 0L;
    public long endTime = 0L;
    public int counterOfNormalQiZi = 0;
    public Vector<GoRecordQiZi> mem = new Vector();
    public GoGameRule rule = new GoGameRule();
    public GoGameResult result = new GoGameResult();
    public String black = "";
    public String white = "";
    public Level blackLevel = new Level();
    public Level whiteLevel = new Level();
    public GoGameResult blackValidate = null;
    public GoGameResult whiteValidate = null;

    public GoGameRecord() {
    }

    public GoGameRecord(GoGameRule goGameRule) {
        this.rule = goGameRule;
        this.black = goGameRule.blackName;
        this.white = goGameRule.whiteName;
        this.blackLevel = goGameRule.blackLevel;
        this.whiteLevel = goGameRule.whiteLevel;
        this.beginTime = System.currentTimeMillis();
    }

    public GoGameIndex getGoGameIndex() {
        GoGameIndex goGameIndex = new GoGameIndex();
        goGameIndex.beginTime = this.beginTime;
        goGameIndex.endTime = this.endTime;
        goGameIndex.blackName = this.black;
        goGameIndex.whiteName = this.white;
        goGameIndex.blackLevel = this.blackLevel;
        goGameIndex.whiteLevel = this.whiteLevel;
        goGameIndex.result = this.result;
        goGameIndex.title = this.title;
        return goGameIndex;
    }

    public void goGameEnd() {
        this.endTime = System.currentTimeMillis();
    }

    public boolean isPlayer(String string) {
        return this.black.equals(string) || this.white.equals(string);
    }

    public String anotherPlayer(String string) {
        if (string.equals(this.black)) {
            return this.white;
        }
        return this.black;
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        this.title = tyBaseInput.readUTF();
        this.black = tyBaseInput.readUTF();
        this.white = tyBaseInput.readUTF();
        this.blackLevel.read(tyBaseInput);
        this.whiteLevel.read(tyBaseInput);
        this.rule = new GoGameRule();
        this.rule.read(tyBaseInput);
        this.result = new GoGameResult();
        this.result.read(tyBaseInput);
        int n = tyBaseInput.readInt();
        for (int i = 0; i < n; ++i) {
            GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
            goRecordQiZi.read(tyBaseInput);
            this.mem.add(goRecordQiZi);
        }
        this.beginTime = tyBaseInput.readLong();
        this.endTime = tyBaseInput.readLong();
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeUTF(this.title);
        tyBaseOutput.writeUTF(this.black);
        tyBaseOutput.writeUTF(this.white);
        this.blackLevel.write(tyBaseOutput);
        this.whiteLevel.write(tyBaseOutput);
        this.rule.write(tyBaseOutput);
        this.result.write(tyBaseOutput);
        tyBaseOutput.writeInt(this.mem.size());
        for (GoRecordQiZi goRecordQiZi : this.mem) {
            goRecordQiZi.write(tyBaseOutput);
        }
        tyBaseOutput.writeLong(this.beginTime);
        tyBaseOutput.writeLong(this.endTime);
    }

    public void readHead(TyBaseInput tyBaseInput) throws IOException {
        this.black = tyBaseInput.readUTF();
        this.white = tyBaseInput.readUTF();
        this.blackLevel.read(tyBaseInput);
        this.whiteLevel.read(tyBaseInput);
    }

    public void writeHead(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeUTF(this.black);
        tyBaseOutput.writeUTF(this.white);
        this.blackLevel.write(tyBaseOutput);
        this.whiteLevel.write(tyBaseOutput);
    }
}

