/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.SocketHandler;

public class LogTool {
    private String logName = "www.org.phoenix";
    private String handlerFile = " log.txt";
    private String socketHandlerHost = "127.0.0.1";
    private int portOfHost = 1973;
    private boolean useConsoleLog = true;
    private boolean useFileLog = false;
    private boolean useHostLog = false;
    private Level defaultLevel = Level.FINE;
    private FileHandler fhd;
    private ConsoleHandler chd;
    private SocketHandler shd;
    public Logger log;
    private static final Level[] lev = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};

    public LogTool(String string, boolean bl, String string2, boolean bl2, boolean bl3, String string3, int n) {
        this.logName = string;
        this.useFileLog = bl;
        this.handlerFile = string2;
        this.useConsoleLog = bl2;
        this.useHostLog = bl3;
        this.socketHandlerHost = string3;
        this.portOfHost = n;
        this.init();
    }

    public LogTool() {
        this.init();
    }

    private void init() {
        try {
            this.log = Logger.getLogger(this.logName);
            if (this.useConsoleLog) {
                this.chd = new ConsoleHandler();
                this.log.addHandler(this.chd);
            }
            if (this.useFileLog) {
                this.fhd = new FileHandler(this.handlerFile);
                this.fhd.setFormatter(new SimpleFormatter());
                this.log.addHandler(this.fhd);
            }
            if (this.useHostLog) {
                this.shd = new SocketHandler(this.socketHandlerHost, this.portOfHost);
                this.log.addHandler(this.shd);
            }
            this.setLevel(Level.ALL);
        }
        catch (Exception exception) {
            System.out.println("static Excpetion in Root " + exception);
        }
    }

    public void appendLog(String string, Level level) {
        LogRecord logRecord = new LogRecord(level, string);
        this.log.log(logRecord);
    }

    public void appendLog(String string) {
        this.appendLog(string, this.defaultLevel);
    }

    public void setLevel(Level level) {
        if (this.log != null) {
            this.log.setLevel(level);
        }
        if (this.chd != null) {
            this.chd.setLevel(level);
        }
        if (this.fhd != null) {
            this.fhd.setLevel(level);
        }
        if (this.shd != null) {
            this.shd.setLevel(level);
        }
    }

    public void setLevel(String string) {
        try {
            Integer n = new Integer(string);
            this.setLevel(lev[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

