/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.util.Iterator;
import java.util.Vector;
import tianyuan.games.base.GoGamblingGameInfo;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.GoRoomInfos;
import tianyuan.games.base.OnLineAdminRecord;
import tianyuan.games.base.TpMoney;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.net.ClientMessage;
import tianyuan.games.net.ClientRequest;
import tianyuan.games.net.GoServerResponse;
import tianyuan.games.net.ServerMessage;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.server.AdminResult;
import tianyuan.games.net.server.BbsDataAdapter;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.CommonBbsDataAdapter;
import tianyuan.games.net.server.DisableUserList;
import tianyuan.games.net.server.GoProcess;
import tianyuan.games.net.server.InnerMailDataAdapter;
import tianyuan.games.net.server.LoginAdapter;
import tianyuan.games.net.server.ProcessRoot;
import tianyuan.games.net.server.RoomNumberManager;
import tianyuan.games.net.server.ServerGlobal;
import tianyuan.games.net.server.UserAdmin;
import tianyuan.games.net.server.UserAdminCommand;
import tianyuan.games.net.server.UserAdminResult;

class ProcessLogic1
extends ProcessRoot {
    GoProcess goProcess;
    CommonBbsDataAdapter commonBbs;
    InnerMailDataAdapter mail;
    DisableUserList shoutDisableUserList;
    DisableUserList sendMailDisableUserList;
    DisableUserList loginDisableUserList;

    ProcessLogic1(Vector<ClientAdapter> vector, Vector<ClientAdapter> vector2, Vector<ClientAdapter> vector3, Vector<GoRoom> vector4, RoomNumberManager roomNumberManager, LoginAdapter loginAdapter, BbsDataAdapter bbsDataAdapter, CommonBbsDataAdapter commonBbsDataAdapter, InnerMailDataAdapter innerMailDataAdapter, DisableUserList disableUserList, DisableUserList disableUserList2, DisableUserList disableUserList3, GoProcess goProcess) {
        super(vector, vector2, vector3, vector4, roomNumberManager, loginAdapter, bbsDataAdapter);
        this.goProcess = goProcess;
        this.commonBbs = commonBbsDataAdapter;
        this.mail = innerMailDataAdapter;
        this.shoutDisableUserList = disableUserList;
        this.sendMailDisableUserList = disableUserList2;
        this.loginDisableUserList = disableUserList3;
    }

    protected void loginResultProcess(UserAdminResult userAdminResult) {
        if (userAdminResult.result == AdminResult.ADD_USER_SUCCEED) {
            this.bbsAdapter.createUserBbsResource(userAdminResult.command.info.userName);
            this.mail.createUserResource(userAdminResult.command.info.userName);
        }
        if (userAdminResult.result == AdminResult.ADD_USER_SUCCEED || userAdminResult.result == AdminResult.LOGIN_SUCCEED) {
            Object object2;
            ServerResponse serverResponse;
            ServerResponse serverResponse2;
            this.mail.createUserResource(userAdminResult.command.info.userName);
            ClientAdapter clientAdapter = this.search(this.onLine, userAdminResult.command.info.userName);
            if (clientAdapter != null) {
                serverResponse2 = new ServerResponse();
                serverResponse2.type = (byte)21;
                clientAdapter.put(serverResponse2);
                serverResponse = new ServerResponse();
                serverResponse.type = (byte)124;
                clientAdapter.put(serverResponse);
                this.onLine.remove(clientAdapter);
                this.breakLine.add(clientAdapter);
            }
            serverResponse2 = new ServerResponse();
            serverResponse2.type = (byte)17;
            serverResponse2.oneUserLoginInfo = userAdminResult.command.info;
            serverResponse2.oneUserLoginTmpInfo = userAdminResult.command.source.tmpInfo;
            this.sendToEveryUser(serverResponse2);
            serverResponse = new ServerResponse();
            serverResponse.type = userAdminResult.result == AdminResult.ADD_USER_SUCCEED ? (byte)2 : (byte)1;
            serverResponse.rooms = this.rooms;
            serverResponse.publicSetting = ServerGlobal.setting;
            serverResponse.clientTitle = ServerGlobal.CLIENT_TITLE;
            serverResponse.clientWelcomeMsg = ServerGlobal.CLIENT_WELCOME_MSG;
            serverResponse.userAllInfos = new Vector();
            for (Object object2 : this.onLine) {
                Iterator<GoRoom> iterator = new UserAllInfo();
                ((UserAllInfo)((Object)iterator)).info = ((ClientAdapter)object2).info;
                ((UserAllInfo)((Object)iterator)).tmpInfo = ((ClientAdapter)object2).tmpInfo;
                serverResponse.userAllInfos.add((UserAllInfo)((Object)iterator));
            }
            serverResponse.bbsTopics = this.bbsAdapter.getAllTopics();
            serverResponse.commonBbsTopics = this.commonBbs.getAllTopics();
            this.onLine.add(userAdminResult.command.source);
            this.waitLogin.remove(userAdminResult.command.source);
            OnLineAdminRecord onLineAdminRecord = new OnLineAdminRecord();
            userAdminResult.command.source.tmpInfo.ipAddress = onLineAdminRecord.ipAddress = userAdminResult.command.source.getIpAddress();
            onLineAdminRecord.loginTime = userAdminResult.command.source.tmpInfo.startTime;
            onLineAdminRecord.logoutTime = 0L;
            onLineAdminRecord.osDescr = userAdminResult.command.source.tmpInfo.clientOsName;
            userAdminResult.command.info.adminField.loginAddOnLineAdminRecord(onLineAdminRecord);
            userAdminResult.command.source.info = userAdminResult.command.info;
            userAdminResult.command.source.put(serverResponse);
            if (userAdminResult.userTable != null) {
                object2 = new ServerResponse();
                ((ServerResponse)object2).type = (byte)60;
                ((ServerResponse)object2).adminUserTable = userAdminResult.userTable;
                userAdminResult.command.source.put((ServerResponse)object2);
            }
            if ((object2 = this.search(this.breakLine, userAdminResult.command.info.userName)) != null) {
                for (GoRoom goRoom : ((ClientAdapter)object2).tmpInfo.go.inGame) {
                    this.enterRoomProcess(userAdminResult.command.source, goRoom.roomNumber);
                }
                for (GoRoom goRoom : ((ClientAdapter)object2).tmpInfo.go.seeGame) {
                    this.enterRoomProcess(userAdminResult.command.source, goRoom.roomNumber);
                }
                this.breakLine.remove(object2);
            }
        } else if (userAdminResult.result == AdminResult.PASSWD_WRONG) {
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)3;
            userAdminResult.command.source.put(serverResponse);
        } else if (userAdminResult.result == AdminResult.ADD_USER_FAIL_TOO_MANY_USER) {
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)124;
            userAdminResult.command.source.put(serverResponse);
        } else if (userAdminResult.result == AdminResult.SEARCH_USER_SUCCEED) {
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)52;
            serverResponse.isBeSearchedUserFind = true;
            serverResponse.isBeSearchedUserOnLine = false;
            serverResponse.searchUserResult = userAdminResult.command.info;
            serverResponse.searchUserResultRoom = new GoRoomInfos();
            serverResponse.searchUserResultSourceRoomNumber = userAdminResult.command.request.beSearchedSourceRoomNumber;
            userAdminResult.command.source.put(serverResponse);
        } else if (userAdminResult.result == AdminResult.SEARCH_USER_NO_FIND) {
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)52;
            serverResponse.isBeSearchedUserFind = false;
            serverResponse.beSearchedUser = userAdminResult.command.request.beSearchedUser;
            serverResponse.searchUserResultRoom = new GoRoomInfos();
            userAdminResult.command.source.put(serverResponse);
        } else if (userAdminResult.result == AdminResult.GET_USER_TABLE_BY_PAGE_SUCCEED) {
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)62;
            serverResponse.userTablePage = userAdminResult.userTable;
            serverResponse.pageNumberOfUserTable = userAdminResult.pageNumber;
            userAdminResult.command.source.put(serverResponse);
        }
    }

    private void timeToMoneyProcess(long l, String string, ClientAdapter clientAdapter) {
        TpMoney tpMoney = new TpMoney();
        tpMoney.addTimeToMoney(System.currentTimeMillis() - l);
        this.login.moneyModify(false, string, tpMoney, clientAdapter);
    }

    void logoutProcess(ClientAdapter clientAdapter) {
        clientAdapter.info.adminField.logoutModifyOnLineAdminRecord();
        this.timeToMoneyProcess(clientAdapter.tmpInfo.startTime, clientAdapter.getName(), clientAdapter);
        this.onLine.remove(clientAdapter);
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)18;
        serverResponse.logoutUserName = clientAdapter.info.userName;
        this.sendToEveryUser(serverResponse);
        Vector<GoRoom> vector = new Vector<GoRoom>();
        for (GoRoom object32 : clientAdapter.tmpInfo.go.inGame) {
            vector.add(object32);
        }
        for (GoRoom goRoom : vector) {
            if (goRoom.isRunner(clientAdapter.info.userName) && goRoom.isPlaying()) {
                this.goProcess.giveUp(clientAdapter, goRoom);
            }
            goRoom.goOut(clientAdapter);
            if (goRoom.members.size() > 0) continue;
            this.rooms.remove(goRoom);
            this.roomNumberManager.release(goRoom.roomNumber);
        }
        Vector vector2 = new Vector();
        for (GoRoom goRoom : clientAdapter.tmpInfo.go.seeGame) {
            vector2.add(goRoom);
        }
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            GoRoom goRoom = (GoRoom)iterator.next();
            if (goRoom.isRunner(clientAdapter.info.userName) && goRoom.isPlaying()) {
                this.goProcess.giveUp(clientAdapter, goRoom);
            }
            goRoom.goOut(clientAdapter);
            if (goRoom.members.size() > 0) continue;
            this.rooms.remove(goRoom);
            this.roomNumberManager.release(goRoom.roomNumber);
        }
        Vector<GoRoom> vector3 = new Vector<GoRoom>();
        for (GoRoom goRoom : clientAdapter.tmpInfo.go.idleGame) {
            vector3.add(goRoom);
        }
        for (GoRoom goRoom : vector3) {
            if (goRoom.isRunner(clientAdapter.info.userName) && goRoom.isPlaying()) {
                this.goProcess.giveUp(clientAdapter, goRoom);
            }
            goRoom.goOut(clientAdapter);
            if (goRoom.members.size() > 0) continue;
            this.rooms.remove(goRoom);
            this.roomNumberManager.release(goRoom.roomNumber);
        }
        Vector<GoRoom> vector4 = new Vector<GoRoom>();
        for (GoRoom goRoom : this.rooms) {
            if (!goRoom.isMember(clientAdapter)) continue;
            if (goRoom.isRunner(clientAdapter.info.userName) && goRoom.isPlaying()) {
                this.goProcess.giveUp(clientAdapter, goRoom);
            }
            goRoom.goOut(clientAdapter);
            if (goRoom.members.size() != 0) continue;
            vector4.add(goRoom);
        }
        for (GoRoom goRoom : vector4) {
            this.rooms.remove(goRoom);
            this.roomNumberManager.release(goRoom.roomNumber);
        }
        ServerResponse serverResponse2 = new ServerResponse();
        serverResponse2.type = (byte)4;
        clientAdapter.put(serverResponse2);
        ServerResponse serverResponse3 = new ServerResponse();
        serverResponse3.type = (byte)124;
        clientAdapter.put(serverResponse3);
    }

    void breakLineProcess(ClientAdapter clientAdapter) {
        clientAdapter.info.adminField.logoutModifyOnLineAdminRecord();
        this.timeToMoneyProcess(clientAdapter.tmpInfo.startTime, clientAdapter.getName(), clientAdapter);
        this.breakLine.add(clientAdapter);
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)19;
        serverResponse.breakLineUserName = clientAdapter.info.userName;
        this.sendToEveryUser(serverResponse);
        Vector<GoRoom> vector = new Vector<GoRoom>();
        boolean bl = false;
        for (GoRoom goRoom : this.rooms) {
            if (!goRoom.isMember(clientAdapter)) continue;
            if (goRoom.isPlaying() && goRoom.isRunner(clientAdapter.info.userName)) {
                clientAdapter.info.go.addCurrentBreakLine(1);
                bl = true;
            }
            goRoom.goOut(clientAdapter);
            if (goRoom.members.size() != 0) continue;
            vector.add(goRoom);
        }
        if (bl) {
            this.login.modify(clientAdapter);
        }
        for (GoRoom goRoom : vector) {
            this.rooms.remove(goRoom);
            this.roomNumberManager.release(goRoom.roomNumber);
            serverResponse = new ServerResponse();
            serverResponse.type = (byte)31;
            serverResponse.endRoomNumber = goRoom.roomNumber;
            this.sendToEveryUser(serverResponse);
        }
    }

    void breakLineTimeOutProcess(ClientAdapter clientAdapter) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)20;
        serverResponse.breakLineTimeOutUserName = clientAdapter.info.userName;
        this.sendToEveryUser(serverResponse);
        clientAdapter.info.go.addCurrentFlee(clientAdapter.tmpInfo.go.inGame.size());
        for (GoRoom goRoom : clientAdapter.tmpInfo.go.inGame) {
            this.goProcess.breakLineTimeOut(clientAdapter, goRoom);
        }
    }

    void createRoomProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        if (clientAdapter.tmpInfo.go.roomTotal() >= ServerGlobal.setting.roomMaxLimit) {
            return;
        }
        GoRoom goRoom = new GoRoom();
        goRoom.roomNumber = this.roomNumberManager.create();
        this.rooms.add(goRoom);
        goRoom.title = clientRequest.createRoomTitle;
        goRoom.info = clientRequest.createRoomInfo;
        goRoom.passwd = clientRequest.createRoomPasswd;
        goRoom.status.setValue(clientRequest.createRoomStatus);
        goRoom.gamblingInfo = new GoGamblingGameInfo();
        goRoom.goInAndModifyAdapterGoTmpInfo(clientAdapter);
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)30;
        serverResponse.createdRoom = goRoom;
        this.sendToEveryUser(serverResponse);
    }

    void enterRoomProcess(ClientAdapter clientAdapter, int n) {
        GoRoom goRoom;
        if (clientAdapter.tmpInfo.go.roomTotal() >= ServerGlobal.setting.roomMaxLimit) {
            return;
        }
        if (n > 0 && (goRoom = this.search(this.rooms, n)) != null) {
            ServerResponse serverResponse;
            if (goRoom.goIn(clientAdapter)) {
                serverResponse = new ServerResponse();
                serverResponse.type = (byte)50;
                serverResponse.goInUser = clientAdapter.info.userName;
                serverResponse.goInRoomNumber = n;
                this.sendToEveryUser(serverResponse);
                if (goRoom.isPlaying()) {
                    if (goRoom.isRunner(clientAdapter.info.userName)) {
                        clientAdapter.tmpInfo.go.addInGameRoom(goRoom);
                        serverResponse = new ServerResponse();
                        serverResponse.type = (byte)70;
                        serverResponse.goResponse = new GoServerResponse();
                        serverResponse.goResponse.type = (byte)43;
                        serverResponse.goResponse.beginGameRecord = goRoom.record;
                        serverResponse.goResponse.beginGameRoomNumber = goRoom.roomNumber;
                        clientAdapter.put(serverResponse);
                    } else {
                        clientAdapter.tmpInfo.go.addSeeGameRoom(goRoom);
                        serverResponse = new ServerResponse();
                        serverResponse.type = (byte)70;
                        serverResponse.goResponse = new GoServerResponse();
                        serverResponse.goResponse.type = (byte)43;
                        serverResponse.goResponse.beginGameRecord = goRoom.record;
                        serverResponse.goResponse.beginGameRoomNumber = goRoom.roomNumber;
                        clientAdapter.put(serverResponse);
                    }
                    serverResponse = new ServerResponse();
                    serverResponse.type = (byte)70;
                    serverResponse.goResponse = new GoServerResponse();
                    serverResponse.goResponse.type = (byte)46;
                    serverResponse.goResponse.counterUserName = clientAdapter.info.userName;
                    serverResponse.goResponse.counterInGameCounter = (byte)clientAdapter.tmpInfo.go.inGame.size();
                    serverResponse.goResponse.counterSeeGameCounter = (byte)clientAdapter.tmpInfo.go.seeGame.size();
                    this.sendToEveryUser(serverResponse);
                } else if (goRoom.getStatus().getValue() == 3) {
                    clientAdapter.tmpInfo.go.addSeeGameRoom(goRoom);
                    if (goRoom.record != null) {
                        serverResponse = new ServerResponse();
                        serverResponse.type = (byte)70;
                        serverResponse.goResponse = new GoServerResponse();
                        serverResponse.goResponse.type = (byte)43;
                        serverResponse.goResponse.beginGameRecord = goRoom.record;
                        serverResponse.goResponse.beginGameRoomNumber = goRoom.roomNumber;
                        clientAdapter.put(serverResponse);
                    }
                    serverResponse = new ServerResponse();
                    serverResponse.type = (byte)70;
                    serverResponse.goResponse = new GoServerResponse();
                    serverResponse.goResponse.type = (byte)46;
                    serverResponse.goResponse.counterUserName = clientAdapter.info.userName;
                    serverResponse.goResponse.counterInGameCounter = (byte)clientAdapter.tmpInfo.go.inGame.size();
                    serverResponse.goResponse.counterSeeGameCounter = (byte)clientAdapter.tmpInfo.go.seeGame.size();
                    this.sendToEveryUser(serverResponse);
                } else {
                    clientAdapter.tmpInfo.go.addIdleGameRoom(goRoom);
                }
            }
            serverResponse = new ServerResponse();
            serverResponse.type = (byte)70;
            serverResponse.goResponse = new GoServerResponse();
            serverResponse.goResponse.type = (byte)81;
            serverResponse.goResponse.goGamblingGameInfo = goRoom.gamblingInfo;
            serverResponse.goResponse.gamblingGameInfoRoomNumber = goRoom.roomNumber;
            clientAdapter.put(serverResponse);
        }
    }

    void quitRoomProcess(ClientAdapter clientAdapter, int n) {
        GoRoom goRoom = this.search(this.rooms, n);
        if (goRoom != null) {
            ServerResponse serverResponse;
            if (goRoom.isRunner(clientAdapter.info.userName)) {
                // empty if block
            }
            if (goRoom.goOutAndModifyAdapterGoTmpInfo(clientAdapter)) {
                serverResponse = new ServerResponse();
                serverResponse.type = (byte)51;
                serverResponse.goOutUser = clientAdapter.info.userName;
                serverResponse.goOutRoomNumber = n;
                this.sendToEveryUser(serverResponse);
            }
            if (goRoom.isPlaying()) {
                serverResponse = new ServerResponse();
                serverResponse.type = (byte)70;
                serverResponse.goResponse = new GoServerResponse();
                serverResponse.goResponse.type = (byte)46;
                serverResponse.goResponse.counterUserName = clientAdapter.info.userName;
                serverResponse.goResponse.counterInGameCounter = (byte)clientAdapter.tmpInfo.go.inGame.size();
                serverResponse.goResponse.counterSeeGameCounter = (byte)clientAdapter.tmpInfo.go.seeGame.size();
                this.sendToEveryUser(serverResponse);
            }
            if (goRoom.members.size() == 0) {
                serverResponse = new ServerResponse();
                serverResponse.type = (byte)31;
                serverResponse.endRoomNumber = n;
                this.sendToEveryUser(serverResponse);
                this.rooms.remove(goRoom);
                this.roomNumberManager.release(n);
            }
        }
    }

    void messageProcess(ClientAdapter clientAdapter, ClientMessage clientMessage) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)40;
        serverResponse.serverMessage = new ServerMessage();
        serverResponse.serverMessage.body = clientMessage.message;
        serverResponse.serverMessage.sender = clientAdapter.info.userName;
        serverResponse.serverMessage.senderGoLevel = clientAdapter.info.go.currentLevel;
        serverResponse.serverMessage.isGoLevelUsed = true;
        if (clientMessage.type == 1) {
            serverResponse.serverMessage.type = (byte)10;
            this.sendToEveryUser(serverResponse);
        }
        if (clientMessage.type == 2) {
            serverResponse.serverMessage.type = (byte)11;
            serverResponse.serverMessage.roomNumber = clientMessage.roomNumber;
            this.sendToRoom(serverResponse, clientMessage.roomNumber);
        }
        if (clientMessage.type == 3) {
            serverResponse.serverMessage.type = (byte)12;
            this.sendToUser(serverResponse, clientMessage.sendTo);
        }
    }

    void modifyRelationshipProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        switch (clientRequest.modifyRelationshipType) {
            case 1: {
                clientAdapter.info.addFriend(clientRequest.modifyRelationshipUsername);
                break;
            }
            case 3: {
                clientAdapter.info.addDislike(clientRequest.modifyRelationshipUsername);
                break;
            }
            case 2: {
                clientAdapter.info.delFriend(clientRequest.modifyRelationshipUsername);
                break;
            }
            case 4: {
                clientAdapter.info.delDislike(clientRequest.modifyRelationshipUsername);
                break;
            }
        }
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = UserAdmin.MODIFY;
        userAdminCommand.info = clientAdapter.info;
        userAdminCommand.source = clientAdapter;
        this.login.put(userAdminCommand);
    }

    void newPasswdProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        clientAdapter.info.userPasswd = clientRequest.newPasswd;
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = UserAdmin.MODIFY;
        userAdminCommand.info = clientAdapter.info;
        userAdminCommand.source = clientAdapter;
        this.login.put(userAdminCommand);
    }

    void delUserProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        this.driveOutProcess(clientAdapter, clientRequest.delUserName);
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = UserAdmin.DELETE;
        userAdminCommand.info = new UserInfo();
        userAdminCommand.info.userName = clientRequest.delUserName;
        userAdminCommand.source = clientAdapter;
        this.login.put(userAdminCommand);
        this.bbsAdapter.freeUserBbsResource(clientRequest.delUserName);
        this.mail.freeUserResource(clientRequest.delUserName);
    }

    private void driveOutProcess(ClientAdapter clientAdapter, String string) {
        ClientAdapter clientAdapter2 = this.search(this.onLine, string);
        if (clientAdapter2 != null) {
            this.logoutProcess(clientAdapter2);
        }
        if ((clientAdapter2 = this.search(this.breakLine, string)) != null) {
            this.breakLine.remove(clientAdapter2);
            this.breakLineTimeOutProcess(clientAdapter2);
        }
    }

    void modifyInfoProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        if (clientRequest.modifyUserInfo.userName.equals(clientAdapter.info.userName)) {
            clientAdapter.info.modifyInfo(clientRequest.modifyUserInfo);
            UserAdminCommand userAdminCommand = new UserAdminCommand();
            userAdminCommand.type = UserAdmin.MODIFY;
            userAdminCommand.info = clientAdapter.info;
            userAdminCommand.source = clientAdapter;
            this.login.put(userAdminCommand);
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)121;
            serverResponse.changeInfo = clientAdapter.info;
            serverResponse.changeTmpInfo = clientAdapter.tmpInfo;
            this.sendToEveryUser(serverResponse);
        } else {
            ClientAdapter clientAdapter2 = this.search(this.onLine, clientRequest.modifyUserInfo.userName);
            if (clientAdapter2 != null) {
                clientAdapter2.info.modifyInfo(clientRequest.modifyUserInfo);
            }
            UserAdminCommand userAdminCommand = new UserAdminCommand();
            userAdminCommand.type = UserAdmin.MODIFY;
            userAdminCommand.info = clientRequest.modifyUserInfo;
            userAdminCommand.source = clientAdapter;
            this.login.put(userAdminCommand);
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)121;
            serverResponse.changeInfo = clientRequest.modifyUserInfo;
            serverResponse.changeTmpInfo = clientAdapter2 == null ? clientAdapter.tmpInfo : clientAdapter2.tmpInfo;
            this.sendToEveryUser(serverResponse);
        }
    }

    void addNetManagerProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        System.out.println("addNetManagerProcess");
    }

    void setNetManagerToNormalUserProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        System.out.println("setNetManagerToNormalUser");
    }

    void searchUserDetialProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        ClientAdapter clientAdapter2 = this.search(this.onLine, clientRequest.beSearchedUser);
        if (clientAdapter2 != null) {
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)52;
            serverResponse.isBeSearchedUserFind = true;
            serverResponse.isBeSearchedUserOnLine = true;
            serverResponse.searchUserResult = clientAdapter2.info;
            serverResponse.searchUserResultRoom = clientAdapter2.tmpInfo.go.getRoomInfos();
            serverResponse.searchUserResultSourceRoomNumber = clientRequest.beSearchedSourceRoomNumber;
            clientAdapter.put(serverResponse);
        } else {
            UserAdminCommand userAdminCommand = new UserAdminCommand();
            userAdminCommand.type = UserAdmin.SEARCH;
            userAdminCommand.source = clientAdapter;
            userAdminCommand.request = clientRequest;
            this.login.put(userAdminCommand);
        }
    }

    void getUserTableByPageProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = UserAdmin.GET_USER_TABLE_BY_PAGE;
        userAdminCommand.source = clientAdapter;
        userAdminCommand.request = clientRequest;
        this.login.put(userAdminCommand);
    }

    void audioRTSProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)76;
        serverResponse.audioTalkRtsRequestSrcUser = clientAdapter.getName();
        serverResponse.audioTalkRtsRequestSrcUserIp = clientAdapter.getIpAddress();
        serverResponse.audioTalkRtsUserSupportFormatList = clientRequest.audioTalkRtsUserSupportFormatList;
        this.sendToUser(serverResponse, clientRequest.audioTalkRtsRequestDestUser);
    }

    void audioCTSProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)77;
        serverResponse.audioTalkCtsRequestSrcUser = clientAdapter.getName();
        serverResponse.audioTalkCtsRequestSrcUserIp = clientAdapter.getIpAddress();
        serverResponse.audioTalkCtsUserResult = clientRequest.audioTalkCtsUserResult;
        serverResponse.audioTalkCtsFormatResult = clientRequest.audioTalkCtsFormatResult;
        serverResponse.audioTalkCtsUserSupportFormatList = clientRequest.audioTalkCtsUserSupportFormatList;
        serverResponse.ctsUserSelectFormat = clientRequest.ctsUserSelectFormat;
        this.sendToUser(serverResponse, clientRequest.audioTalkCtsRequestDestUser);
    }

    void audioRRTSProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)78;
        serverResponse.audioTalkRrtsSrcUser = clientAdapter.getName();
        serverResponse.audioTalkRrtsSrcUserIp = clientAdapter.getIpAddress();
        serverResponse.audioTalkRrtsFormatResult = clientRequest.audioTalkRrtsFormatResult;
        serverResponse.rrtsUserSelectFormat = clientRequest.rrtsUserSelectFormat;
        this.sendToUser(serverResponse, clientRequest.audioTalkRrtsDestUser);
    }

    void exitStudyRoomStatusProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        String string = clientAdapter.getName();
        GoRoom goRoom = this.search(this.rooms, clientRequest.exitStudyRoomNumber);
        if (string == null || goRoom == null) {
            return;
        }
        if (!goRoom.isRunner(string)) {
            return;
        }
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)100;
        serverResponse.exitStudyRoomNumber = clientRequest.exitStudyRoomNumber;
        serverResponse.exitStudyUserName = clientAdapter.getName();
        goRoom.sendRoomInfo(serverResponse);
    }

    void publishStudyRefProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)101;
        serverResponse.publishStudyRefRoomNumber = clientRequest.publishStudyRefRoomNumber;
        serverResponse.publishStudyRefMotherNumber = clientRequest.publishStudyRefMotherNumber;
        serverResponse.publishStudyRefMotherPosition = clientRequest.publishStudyRefMotherPosition;
        serverResponse.publishStudyRef = clientRequest.publishStudyRef;
        serverResponse.publishRefAuthor = clientAdapter.getName();
        GoRoom goRoom = this.search(this.rooms, clientRequest.publishStudyRefRoomNumber);
        serverResponse.publishRefNumber = goRoom != null ? goRoom.refCounterAdd() : 0;
        this.sendToRoom(serverResponse, clientRequest.exitStudyRoomNumber);
    }

    void delPublishStudyRefProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)102;
        serverResponse.delPublishStudyRefRoomNumber = clientRequest.delPublishStudyRefRoomNumber;
        serverResponse.delPublishStudyRefNumber = clientRequest.delPublishStudyRefNumber;
        serverResponse.delPublishRefCommander = clientAdapter.getName();
        this.sendToRoom(serverResponse, clientRequest.exitStudyRoomNumber);
    }
}

