/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.util.Vector;
import tianyuan.games.base.Level;
import tianyuan.games.base.TpMoney;
import tianyuan.games.base.UserInfo;
import tianyuan.games.net.server.AdminResult;
import tianyuan.games.net.server.BooleanFlag;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.DataServerAdapter;
import tianyuan.games.net.server.DataServerAdapterInterface;
import tianyuan.games.net.server.DataServerRequest;
import tianyuan.games.net.server.GoGameRecordAdapter;
import tianyuan.games.net.server.NewUserTable;
import tianyuan.games.net.server.ServerGlobal;
import tianyuan.games.net.server.UserAdmin;
import tianyuan.games.net.server.UserAdminCommand;
import tianyuan.games.net.server.UserAdminResult;

public class LoginAdapter
implements DataServerAdapterInterface {
    private DataServerAdapter dataServer;
    GoGameRecordAdapter recordAdapter;
    private Vector<UserAdminCommand> outQueue = new Vector();
    private Vector<UserAdminResult> inQueue = new Vector();
    private output to;
    private BooleanFlag stopFlag = new BooleanFlag(false);

    LoginAdapter(GoGameRecordAdapter goGameRecordAdapter) {
        this.recordAdapter = goGameRecordAdapter;
        this.to = new output();
        this.to.start();
    }

    @Override
    public void setDataServerAdapter(DataServerAdapter dataServerAdapter) {
        this.dataServer = dataServerAdapter;
    }

    public synchronized int getCurrentSignUp() {
        return this.to.getCurrentSignUp();
    }

    public synchronized UserAdminResult get() {
        if (this.inQueue.isEmpty()) {
            return null;
        }
        UserAdminResult userAdminResult = this.inQueue.firstElement();
        this.inQueue.remove(userAdminResult);
        return userAdminResult;
    }

    public synchronized void put(UserAdminCommand userAdminCommand) {
        this.outQueue.add(userAdminCommand);
        this.notify();
    }

    public void modify(ClientAdapter clientAdapter) {
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = UserAdmin.MODIFY;
        userAdminCommand.info = clientAdapter.info;
        userAdminCommand.source = clientAdapter;
        this.put(userAdminCommand);
    }

    public void addMoneyNoTax(String string, TpMoney tpMoney, ClientAdapter clientAdapter) {
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = UserAdmin.MONEY_ADD_NO_TAX;
        userAdminCommand.userName = string;
        userAdminCommand.money = tpMoney;
        userAdminCommand.source = clientAdapter;
        this.put(userAdminCommand);
    }

    public void moneyModify(boolean bl, String string, TpMoney tpMoney, ClientAdapter clientAdapter) {
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = bl ? UserAdmin.MONEY_RESET : UserAdmin.MONEY_ADD;
        userAdminCommand.userName = string;
        userAdminCommand.money = tpMoney;
        userAdminCommand.source = clientAdapter;
        this.put(userAdminCommand);
    }

    public void close() {
        UserAdminCommand userAdminCommand = new UserAdminCommand();
        userAdminCommand.type = UserAdmin.ADAPTER_TERMINATE;
        this.put(userAdminCommand);
    }

    private synchronized UserAdminCommand getFromOutQueue() {
        while (true) {
            try {
                while (this.outQueue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        UserAdminCommand userAdminCommand = this.outQueue.firstElement();
        this.outQueue.remove(userAdminCommand);
        return userAdminCommand;
    }

    private synchronized void putToInQueue(UserAdminResult userAdminResult) {
        if (userAdminResult != null) {
            this.inQueue.add(userAdminResult);
        }
    }

    public boolean getStopFlag() {
        return this.stopFlag.get();
    }

    private void sleepSec(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class output
    extends Thread {
        private UserAdminCommand msg;
        private NewUserTable users = new NewUserTable();
        private UserAdminResult result = new UserAdminResult();

        private output() {
        }

        private void loginProcess(UserInfo userInfo) {
            if (userInfo.userPasswd.equals(this.msg.info.userPasswd)) {
                this.result.result = AdminResult.LOGIN_SUCCEED;
                userInfo.adminField.ipAddress = this.result.command.source.getIpAddress();
                userInfo.adminField.time = this.result.command.source.tmpInfo.startTime;
                userInfo.adminField.osDescr = this.result.command.source.tmpInfo.clientOsName;
                this.result.command.info = userInfo;
                if (this.result.command.info.adminField.isNetManager) {
                    this.result.userTable = new Vector();
                    this.users.getPage(0, this.result.userTable);
                }
                this.users.modify(this.msg.info);
            } else {
                this.result.result = AdminResult.PASSWD_WRONG;
            }
            LoginAdapter.this.putToInQueue(this.result);
        }

        public int getCurrentSignUp() {
            return this.users.getSize();
        }

        private void addUserProcess() {
            if (this.users.getSize() >= ServerGlobal.ALL_USER_LIMIT) {
                this.result.result = AdminResult.ADD_USER_FAIL_TOO_MANY_USER;
                this.result.command = this.msg;
                LoginAdapter.this.putToInQueue(this.result);
                return;
            }
            Level level = ServerGlobal.getRegisterLevelMax();
            if (this.msg.info.go.currentLevel.compare2(level) > 0) {
                this.msg.info.go.currentLevel = level;
            }
            this.result.result = AdminResult.ADD_USER_SUCCEED;
            this.msg.info.adminField.ipAddress = this.result.command.source.getIpAddress();
            this.msg.info.adminField.time = this.result.command.source.tmpInfo.startTime;
            this.msg.info.adminField.osDescr = this.result.command.source.tmpInfo.clientOsName;
            this.result.command.info = this.msg.info;
            this.users.addUser(this.msg.info);
            if (this.result.command.info.adminField.isNetManager) {
                this.result.userTable = new Vector();
                this.users.getPage(0, this.result.userTable);
            }
            this.users.modify(this.msg.info);
            LoginAdapter.this.recordAdapter.createUser(this.msg.info.userName);
            LoginAdapter.this.putToInQueue(this.result);
        }

        private void modifyProcess() {
            this.users.modify(this.msg.info);
        }

        private void addMoneyNoTaxProcess() {
            UserInfo userInfo = this.users.search(this.msg.userName);
            if (userInfo != null) {
                userInfo.money.add(this.msg.money);
                this.users.modify(userInfo);
                if (this.msg.source == null) {
                    return;
                }
                if (this.msg.userName.equals(this.msg.source.info.userName)) {
                    this.msg.source.info.money = userInfo.money;
                }
            }
        }

        private void addMoneyProcess() {
            UserInfo userInfo = this.users.search(this.msg.userName);
            if (userInfo != null) {
                userInfo.money.addWithTax(this.msg.money);
                this.users.modify(userInfo);
                if (this.msg.source == null) {
                    return;
                }
                if (this.msg.userName.equals(this.msg.source.info.userName)) {
                    this.msg.source.info.money = userInfo.money;
                }
            }
        }

        private void resetMoneyProcess() {
            UserInfo userInfo = this.users.search(this.msg.userName);
            if (userInfo != null) {
                userInfo.money.set(this.msg.money);
                this.users.modify(userInfo);
                if (this.msg.source == null) {
                    return;
                }
                if (this.msg.userName.equals(this.msg.source.info.userName)) {
                    this.msg.source.info.money = userInfo.money;
                }
            }
        }

        private void deleteProcess() {
            this.users.del(this.msg.info.userName);
            LoginAdapter.this.recordAdapter.delUser(this.msg.info.userName);
        }

        private void searchProcess() {
            UserInfo userInfo = this.users.search(this.msg.request.beSearchedUser);
            if (userInfo != null) {
                this.result.result = AdminResult.SEARCH_USER_SUCCEED;
                this.result.command = this.msg;
                this.msg.info = userInfo;
            } else {
                this.result.result = AdminResult.SEARCH_USER_NO_FIND;
                this.result.command = this.msg;
            }
            LoginAdapter.this.putToInQueue(this.result);
        }

        private void getUserTableByPageProcess() {
            this.result.userTable = new Vector();
            this.result.pageNumber = this.users.getPage(this.msg.request.pageOfUserTable, this.result.userTable);
            this.result.result = AdminResult.GET_USER_TABLE_BY_PAGE_SUCCEED;
            LoginAdapter.this.putToInQueue(this.result);
        }

        private boolean centerSwitch() {
            if (this.msg.type == UserAdmin.LOGIN_OR_ADD) {
                UserInfo userInfo = this.users.search(this.msg.info.userName);
                if (userInfo == null) {
                    this.addUserProcess();
                } else {
                    this.loginProcess(userInfo);
                }
            } else if (this.msg.type == UserAdmin.MODIFY) {
                this.modifyProcess();
            } else if (this.msg.type == UserAdmin.DELETE) {
                this.deleteProcess();
            } else if (this.msg.type == UserAdmin.SEARCH) {
                this.searchProcess();
            } else if (this.msg.type == UserAdmin.GET_USER_TABLE_BY_PAGE) {
                this.getUserTableByPageProcess();
            } else {
                if (this.msg.type == UserAdmin.ADAPTER_TERMINATE) {
                    this.users.close();
                    LoginAdapter.this.stopFlag.set(true);
                    return false;
                }
                if (this.msg.type == UserAdmin.MONEY_ADD) {
                    this.addMoneyProcess();
                } else if (this.msg.type == UserAdmin.MONEY_ADD_NO_TAX) {
                    this.addMoneyNoTaxProcess();
                } else if (this.msg.type == UserAdmin.MONEY_RESET) {
                    this.resetMoneyProcess();
                }
            }
            return true;
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    while (true) {
                        this.msg = LoginAdapter.this.getFromOutQueue();
                        if (this.msg == null) {
                            output.sleep(100L);
                            continue;
                        }
                        if (LoginAdapter.this.dataServer == null) {
                            this.result = new UserAdminResult();
                            this.result.command = this.msg;
                            if (this.centerSwitch()) continue;
                            break block2;
                        }
                        DataServerRequest dataServerRequest = new DataServerRequest(1);
                        dataServerRequest.uac = this.msg;
                        LoginAdapter.this.dataServer.put(dataServerRequest);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

