/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;
import tianyuan.games.base.TyBaseInputRandomAccessFile;
import tianyuan.games.base.TyBaseOutputRandomAccessFile;
import tianyuan.games.base.innermail.InnerMail;
import tianyuan.games.base.innermail.InnerMailHead;
import tianyuan.games.base.innermail.InnerMailRequest;
import tianyuan.games.base.innermail.InnerMailResultData;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.InnerMailDataCommand;
import tianyuan.games.net.server.InnerMailDataResult;
import tianyuan.games.net.server.ServerGlobal;

class InnerMailDataAdapter {
    private String pathOfStorageMailUserData = ServerGlobal.pathOfStorageMailUserData;
    private static final String INBOX_HEAD = ".ihead";
    private static final String INBOX_BODY = ".ibody";
    private static final String OUTBOX_HEAD = ".ohead";
    private static final String OUTBOX_BODY = ".obody";
    private static final int HEAD_ITEM_MAX_LENGTH = 500;
    private static final int HEAD_HEAD_LENGTH = 12;
    private static final int BODY_HEAD_LENGTH = 12;
    private static final byte RECORD_USED = 1;
    private static final byte RECORD_DELETE = 2;
    private static final int PAGE_SIZE = 20;
    private static final int HEAD_ITEM_PRESEVING_AREA_LENGTH = 20;
    private Vector<InnerMailDataCommand> outQueue = new Vector();
    private Vector<InnerMailDataResult> inQueue = new Vector();
    private output to;
    private static String tmpFileName = "qwefz342asdfgh_tmp_mail_file";

    InnerMailDataAdapter() {
        this.pathOfStorageMailUserData = ServerGlobal.pathOfStorageMailUserData;
        this.to = new output();
        this.to.start();
    }

    InnerMailDataAdapter(String string) {
        this.pathOfStorageMailUserData = string;
        this.to = new output();
        this.to.start();
    }

    public void createUserResource(String string) {
        InnerMailDataCommand innerMailDataCommand = new InnerMailDataCommand();
        innerMailDataCommand.type = (byte)2;
        innerMailDataCommand.client = null;
        innerMailDataCommand.userName = string;
        this.put(innerMailDataCommand);
    }

    public void freeUserResource(String string) {
        InnerMailDataCommand innerMailDataCommand = new InnerMailDataCommand();
        innerMailDataCommand.type = (byte)3;
        innerMailDataCommand.client = null;
        innerMailDataCommand.userName = string;
        this.put(innerMailDataCommand);
    }

    public void putRequest(InnerMailRequest innerMailRequest, ClientAdapter clientAdapter) {
        InnerMailDataCommand innerMailDataCommand = new InnerMailDataCommand();
        innerMailDataCommand.client = clientAdapter;
        innerMailDataCommand.userName = clientAdapter.getName();
        innerMailDataCommand.request = innerMailRequest;
        this.put(innerMailDataCommand);
    }

    private synchronized InnerMailDataCommand getFromOutQueue() {
        while (true) {
            try {
                while (this.outQueue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        InnerMailDataCommand innerMailDataCommand = this.outQueue.firstElement();
        this.outQueue.remove(innerMailDataCommand);
        return innerMailDataCommand;
    }

    public synchronized InnerMailDataResult get() {
        if (this.inQueue.isEmpty()) {
            return null;
        }
        InnerMailDataResult innerMailDataResult = this.inQueue.firstElement();
        this.inQueue.remove(innerMailDataResult);
        return innerMailDataResult;
    }

    private synchronized void put(InnerMailDataCommand innerMailDataCommand) {
        this.outQueue.add(innerMailDataCommand);
        this.notify();
    }

    private synchronized void putToInQueue(InnerMailDataResult innerMailDataResult) {
        if (innerMailDataResult != null) {
            this.inQueue.add(innerMailDataResult);
        }
    }

    private void createUser(String string) {
        try {
            File file;
            File file2 = new File(this.pathOfStorageMailUserData + string + INBOX_BODY);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            if ((file = new File(this.pathOfStorageMailUserData + string + INBOX_HEAD)).exists()) {
                file.createNewFile();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageMailUserData + string + INBOX_HEAD, "rw");
            randomAccessFile.writeInt(0);
            randomAccessFile.writeLong(0L);
            randomAccessFile.close();
            file2 = new File(this.pathOfStorageMailUserData + string + OUTBOX_BODY);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            if (!(file = new File(this.pathOfStorageMailUserData + string + OUTBOX_HEAD)).exists()) {
                file.createNewFile();
            }
            randomAccessFile = new RandomAccessFile(this.pathOfStorageMailUserData + string + OUTBOX_HEAD, "rw");
            randomAccessFile.writeInt(0);
            randomAccessFile.writeLong(0L);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delUser(String string) {
        File file;
        File file2;
        if (!this.isUserExists(string)) {
            return;
        }
        try {
            file2 = new File(this.pathOfStorageMailUserData + string + INBOX_BODY);
            if (!file2.delete()) {
                System.out.println("delete file fail :" + file2.toString());
            }
            if (!(file = new File(this.pathOfStorageMailUserData + string + INBOX_HEAD)).delete()) {
                System.out.println("delete file fail :" + file.toString());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
        try {
            file2 = new File(this.pathOfStorageMailUserData + string + OUTBOX_BODY);
            if (!file2.delete()) {
                System.out.println("delete file fail :" + file2.toString());
            }
            if (!(file = new File(this.pathOfStorageMailUserData + string + OUTBOX_HEAD)).delete()) {
                System.out.println("delete file fail :" + file.toString());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void sendMail(String string, InnerMail innerMail, ClientAdapter clientAdapter) {
        InnerMailDataResult innerMailDataResult;
        TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile;
        long l;
        long l2;
        RandomAccessFile randomAccessFile;
        long l3;
        TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2;
        long l4;
        RandomAccessFile randomAccessFile2;
        if (!this.isUserExists(string)) {
            InnerMailDataResult innerMailDataResult2 = new InnerMailDataResult();
            innerMailDataResult2.client = clientAdapter;
            innerMailDataResult2.result = new InnerMailResultData();
            innerMailDataResult2.result.type = (byte)6;
            innerMailDataResult2.result.mail = innerMail;
            this.putToInQueue(innerMailDataResult2);
            return;
        }
        try {
            randomAccessFile2 = new RandomAccessFile(this.pathOfStorageMailUserData + innerMail.head.sender + OUTBOX_BODY, "rw");
            l4 = randomAccessFile2.length();
            randomAccessFile2.seek(l4);
            tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
            innerMail.body.write(tyBaseOutputRandomAccessFile2);
            l3 = randomAccessFile2.getFilePointer() - l4;
            randomAccessFile2.close();
            randomAccessFile = new RandomAccessFile(this.pathOfStorageMailUserData + innerMail.head.sender + OUTBOX_HEAD, "rw");
            l2 = randomAccessFile.length();
            l = (l2 - 12L) / 500L;
            innerMail.head.number = (int)l;
            randomAccessFile.setLength(l2 + 500L);
            randomAccessFile.seek(l2);
            randomAccessFile.writeByte(1);
            randomAccessFile.writeLong(l4);
            randomAccessFile.writeLong(l3);
            randomAccessFile.seek(l2 + 20L);
            tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            innerMail.head.write(tyBaseOutputRandomAccessFile);
            randomAccessFile.setLength(l2 + 500L);
            randomAccessFile.close();
            innerMailDataResult = new InnerMailDataResult();
            innerMailDataResult.client = clientAdapter;
            innerMailDataResult.result = new InnerMailResultData();
            innerMailDataResult.result.type = 1;
            innerMailDataResult.result.mailboxType = InnerMail.SENDING_MAIL_BOX;
            innerMailDataResult.result.mailNumber = (int)l;
            innerMailDataResult.result.info = InnerMailHead.copy(innerMail.head);
            this.putToInQueue(innerMailDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
        try {
            randomAccessFile2 = new RandomAccessFile(this.pathOfStorageMailUserData + innerMail.head.receiver + INBOX_BODY, "rw");
            l4 = randomAccessFile2.length();
            randomAccessFile2.seek(l4);
            tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
            innerMail.body.write(tyBaseOutputRandomAccessFile2);
            l3 = randomAccessFile2.getFilePointer() - l4;
            randomAccessFile2.close();
            randomAccessFile = new RandomAccessFile(this.pathOfStorageMailUserData + innerMail.head.receiver + INBOX_HEAD, "rw");
            l2 = randomAccessFile.length();
            l = (l2 - 12L) / 500L;
            innerMail.head.number = (int)l;
            randomAccessFile.setLength(l2 + 500L);
            randomAccessFile.seek(l2);
            randomAccessFile.writeByte(1);
            randomAccessFile.writeLong(l4);
            randomAccessFile.writeLong(l3);
            randomAccessFile.seek(l2 + 20L);
            tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            innerMail.head.write(tyBaseOutputRandomAccessFile);
            randomAccessFile.setLength(l2 + 500L);
            randomAccessFile.close();
            innerMailDataResult = new InnerMailDataResult();
            innerMailDataResult.client = null;
            innerMailDataResult.result = new InnerMailResultData();
            innerMailDataResult.result.type = (byte)5;
            innerMailDataResult.result.mailboxType = InnerMail.READING_MAIL_BOX;
            innerMailDataResult.result.mailNumber = (int)l;
            innerMailDataResult.result.info = InnerMailHead.copy(innerMail.head);
            this.putToInQueue(innerMailDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private boolean isUserExists(String string) {
        try {
            File file = new File(this.pathOfStorageMailUserData + string + INBOX_HEAD);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
            file = new File(this.pathOfStorageMailUserData + string + INBOX_BODY);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
            file = new File(this.pathOfStorageMailUserData + string + OUTBOX_HEAD);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
            file = new File(this.pathOfStorageMailUserData + string + OUTBOX_BODY);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
        return true;
    }

    private void readMail(String string, int n, byte by, ClientAdapter clientAdapter) {
        if (!this.isUserExists(string)) {
            return;
        }
        String string2 = "";
        String string3 = "";
        if (by == InnerMail.SENDING_MAIL_BOX) {
            string2 = OUTBOX_HEAD;
            string3 = OUTBOX_BODY;
        } else if (by == InnerMail.READING_MAIL_BOX) {
            string2 = INBOX_HEAD;
            string3 = INBOX_BODY;
        } else {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageMailUserData + string + string2, "rw");
            if (randomAccessFile.length() < (long)(12 + n * 500 + 1)) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500 + 1);
            long l = randomAccessFile.readLong();
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            randomAccessFile.seek(12 + n * 500 + 20);
            InnerMailHead innerMailHead = new InnerMailHead();
            innerMailHead.read(tyBaseInputRandomAccessFile);
            ++innerMailHead.readCounter;
            randomAccessFile.seek(12 + n * 500 + 20);
            innerMailHead.write(tyBaseOutputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageMailUserData + string + string3, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            InnerMail innerMail = new InnerMail();
            innerMail.readBody(tyBaseInputRandomAccessFile2);
            innerMail.head = innerMailHead;
            randomAccessFile2.close();
            innerMail.head.number = n;
            InnerMailDataResult innerMailDataResult = new InnerMailDataResult();
            innerMailDataResult.client = clientAdapter;
            innerMailDataResult.result = new InnerMailResultData();
            innerMailDataResult.result.type = (byte)2;
            innerMailDataResult.result.mailboxType = by;
            innerMailDataResult.result.mail = innerMail;
            innerMailDataResult.result.mailNumber = n;
            this.putToInQueue(innerMailDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delMail(String string, int n, byte by, ClientAdapter clientAdapter) {
        if (!this.isUserExists(string)) {
            return;
        }
        String string2 = "";
        String string3 = "";
        if (by == InnerMail.SENDING_MAIL_BOX) {
            string2 = INBOX_HEAD;
            string3 = INBOX_BODY;
        } else if (by == InnerMail.READING_MAIL_BOX) {
            string2 = OUTBOX_HEAD;
            string3 = OUTBOX_BODY;
        }
        try {
            int n2 = 0;
            long l = 0L;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageMailUserData + string + string2, "rw");
            randomAccessFile.seek(0L);
            n2 = randomAccessFile.readInt();
            l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500);
            randomAccessFile.writeByte(2);
            randomAccessFile.seek(12 + n * 500 + 9);
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(++n2);
            randomAccessFile.writeLong(l += randomAccessFile.readLong());
            randomAccessFile.close();
            InnerMailDataResult innerMailDataResult = new InnerMailDataResult();
            innerMailDataResult.client = clientAdapter;
            innerMailDataResult.result = new InnerMailResultData();
            innerMailDataResult.result.type = (byte)3;
            innerMailDataResult.result.mailboxType = by;
            innerMailDataResult.result.mailNumber = n;
            this.putToInQueue(innerMailDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void getMailBoxIndex(String string, int n, byte by, ClientAdapter clientAdapter) {
        if (!this.isUserExists(string)) {
            return;
        }
        String string2 = "";
        String string3 = "";
        if (by == InnerMail.SENDING_MAIL_BOX) {
            string2 = OUTBOX_HEAD;
            string3 = OUTBOX_BODY;
        } else if (by == InnerMail.READING_MAIL_BOX) {
            string2 = INBOX_HEAD;
            string3 = INBOX_BODY;
        } else {
            System.out.println("wrong mail box type");
            return;
        }
        try {
            int n2;
            Vector<InnerMailHead> vector = new Vector<InnerMailHead>();
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.pathOfStorageMailUserData + string + string2, "r");
            }
            catch (Exception exception) {
                return;
            }
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            int n3 = (int)((randomAccessFile.length() - 12L) / 500L);
            if (n < 0) {
                n = 0;
            }
            if (n > 10000000) {
                n = 10000000;
            }
            if (n * 20 >= n3) {
                n = (n3 - 1) / 20;
            }
            for (int i = n * 20; i < (n + 1) * 20 && i < n3; ++i) {
                randomAccessFile.seek(12 + i * 500);
                n2 = randomAccessFile.readByte();
                if (n2 == 2) continue;
                randomAccessFile.seek(12 + i * 500 + 20);
                InnerMailHead innerMailHead = new InnerMailHead();
                innerMailHead.read(tyBaseInputRandomAccessFile);
                vector.add(innerMailHead);
            }
            randomAccessFile.close();
            InnerMailHead[] innerMailHeadArray = new InnerMailHead[vector.size()];
            for (n2 = 0; n2 < innerMailHeadArray.length; ++n2) {
                innerMailHeadArray[n2] = (InnerMailHead)vector.elementAt(n2);
            }
            InnerMailDataResult innerMailDataResult = new InnerMailDataResult();
            innerMailDataResult.client = clientAdapter;
            innerMailDataResult.result = new InnerMailResultData();
            innerMailDataResult.result.type = (byte)4;
            innerMailDataResult.result.mailboxType = by;
            innerMailDataResult.result.index = innerMailHeadArray;
            innerMailDataResult.result.pageNumber = n;
            this.putToInQueue(innerMailDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void freeDelSpace() {
        try {
            File file = new File(this.pathOfStorageMailUserData);
            if (file.exists() || file.isDirectory()) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].endsWith(INBOX_HEAD)) continue;
                    this.freeDelSpaceByUser(stringArray[i].substring(0, stringArray[i].length() - INBOX_HEAD.length()));
                }
            } else {
                System.out.println("freeDelSpace error : in InnerMailDataAdapter");
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void freeDelSpaceByUser(String string) {
        this.freeDelSpace(string, tmpFileName, INBOX_HEAD, INBOX_BODY);
        this.freeDelSpace(string, tmpFileName, OUTBOX_HEAD, OUTBOX_BODY);
    }

    private void freeDelSpace(String string, String string2, String string3, String string4) {
        try {
            File file = new File(this.pathOfStorageMailUserData + string2 + string4);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            File file2 = new File(this.pathOfStorageMailUserData + string2 + string3);
            if (file2.exists()) {
                file2.delete();
            }
            file2.createNewFile();
            File file3 = new File(this.pathOfStorageMailUserData + string + string3);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file3, "r");
            File file4 = new File(this.pathOfStorageMailUserData + string + string4);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(file4, "r");
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.pathOfStorageMailUserData + string2 + string3, "rw");
            randomAccessFile3.writeInt(0);
            randomAccessFile3.writeLong(0L);
            RandomAccessFile randomAccessFile4 = new RandomAccessFile(this.pathOfStorageMailUserData + string2 + string4, "rw");
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile3);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile4);
            InnerMailHead innerMailHead = new InnerMailHead();
            InnerMail innerMail = new InnerMail();
            int n = 0;
            int n2 = 0;
            while ((long)n2 < randomAccessFile.length() / 500L) {
                randomAccessFile.seek(12 + n2 * 500);
                byte by = randomAccessFile.readByte();
                if (by != 2) {
                    long l = randomAccessFile.readLong();
                    long l2 = randomAccessFile.readLong();
                    l = file.length();
                    randomAccessFile2.seek(l);
                    innerMail.readBody(tyBaseInputRandomAccessFile2);
                    innerMail.writeBody(tyBaseOutputRandomAccessFile2);
                    l2 = file.length();
                    randomAccessFile.seek(12 + n2 * 500 + 20);
                    innerMailHead.read(tyBaseInputRandomAccessFile);
                    innerMailHead.number = n++;
                    long l3 = randomAccessFile3.length();
                    randomAccessFile3.seek(randomAccessFile3.length());
                    randomAccessFile3.writeByte(1);
                    randomAccessFile3.writeLong(l);
                    randomAccessFile3.writeLong(l2);
                    randomAccessFile3.writeByte(0);
                    randomAccessFile3.writeByte(0);
                    randomAccessFile3.writeByte(0);
                    innerMailHead.write(tyBaseOutputRandomAccessFile);
                    randomAccessFile3.setLength(l3 + 500L);
                }
                ++n2;
            }
            randomAccessFile.close();
            randomAccessFile2.close();
            file3.delete();
            file4.delete();
            randomAccessFile3.close();
            randomAccessFile4.close();
            file2.renameTo(file3);
            file.renameTo(file4);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private class output
    extends Thread {
        private InnerMailDataCommand command;

        private output() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.command = InnerMailDataAdapter.this.getFromOutQueue();
                        if (this.command == null) {
                            output.sleep(100L);
                            continue;
                        }
                        if (!this.centerSwitch()) break;
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private boolean centerSwitch() {
            if (this.command.type == 1) {
                return false;
            }
            if (this.command.type == 2) {
                InnerMailDataAdapter.this.createUser(this.command.userName);
            } else if (this.command.type == 3) {
                InnerMailDataAdapter.this.delUser(this.command.userName);
            } else {
                switch (this.command.request.type) {
                    case 1: {
                        InnerMailDataAdapter.this.sendMail(this.command.userName, this.command.request.mail, this.command.client);
                        break;
                    }
                    case 2: {
                        InnerMailDataAdapter.this.readMail(this.command.userName, this.command.request.mailIndex, this.command.request.mailBoxType, this.command.client);
                        break;
                    }
                    case 3: {
                        InnerMailDataAdapter.this.delMail(this.command.userName, this.command.request.mailIndex, this.command.request.mailBoxType, this.command.client);
                        break;
                    }
                    case 4: {
                        InnerMailDataAdapter.this.getMailBoxIndex(this.command.userName, this.command.request.pageNumber, this.command.request.mailBoxType, this.command.client);
                        break;
                    }
                    case 15: {
                        InnerMailDataAdapter.this.freeDelSpace();
                    }
                }
            }
            return true;
        }
    }
}

