/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.util.Vector;
import tianyuan.games.base.GameResult;
import tianyuan.games.base.GoGamblingGameInfo;
import tianyuan.games.base.GoGamblingOneUserInfo;
import tianyuan.games.base.GoGameRecord;
import tianyuan.games.base.GoGameResult;
import tianyuan.games.base.GoGameRule;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.RoomStatus;
import tianyuan.games.base.Root;
import tianyuan.games.base.TpMoney;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UsernameAndMoney;
import tianyuan.games.net.ClientRequest;
import tianyuan.games.net.GoServerResponse;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.server.BbsDataAdapter;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.GoGameRecordAdapter;
import tianyuan.games.net.server.GoGameRecordResult;
import tianyuan.games.net.server.LoginAdapter;
import tianyuan.games.net.server.ProcessRoot;
import tianyuan.games.net.server.RoomNumberManager;
import tianyuan.games.net.server.ServerGlobal;

class GoProcess
extends ProcessRoot {
    GoGameRecordAdapter recordMem;

    public GoProcess(Vector<ClientAdapter> vector, Vector<ClientAdapter> vector2, Vector<ClientAdapter> vector3, Vector<GoRoom> vector4, RoomNumberManager roomNumberManager, LoginAdapter loginAdapter, BbsDataAdapter bbsDataAdapter, GoGameRecordAdapter goGameRecordAdapter) {
        super(vector, vector2, vector3, vector4, roomNumberManager, loginAdapter, bbsDataAdapter);
        this.recordMem = goGameRecordAdapter;
    }

    public void write(Object ... objectArray) {
        for (Object object : objectArray) {
            System.out.println(object);
        }
    }

    void switchProcess(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        switch (clientRequest.goRequest.type) {
            case 11: {
                serverResponse.goResponse.type = (byte)10;
                serverResponse.goResponse.inventionUser = clientAdapter.info.userName;
                this.sendToUser(serverResponse, clientRequest.goRequest.inventionUser);
                break;
            }
            case 12: {
                serverResponse.goResponse.type = (byte)11;
                serverResponse.goResponse.inventionUser = clientRequest.goRequest.inventionUser;
                this.sendToUser(serverResponse, clientRequest.goRequest.inventionUser);
                this.agreeInventionProcess(clientAdapter, clientRequest.goRequest.inventionUser);
                break;
            }
            case 13: {
                serverResponse.goResponse.type = (byte)12;
                serverResponse.goResponse.inventionUser = clientRequest.goRequest.inventionUser;
                this.sendToUser(serverResponse, clientRequest.goRequest.inventionUser);
                break;
            }
            case 21: {
                serverResponse.goResponse.type = (byte)41;
                serverResponse.goResponse.challenge_rule = clientRequest.goRequest.challenge_rule;
                this.sendToUser(serverResponse, clientRequest.goRequest.challenge_rule.dest);
                break;
            }
            case 22: {
                this.createGoGame(clientRequest.goRequest.beAgreedRule);
                break;
            }
            case 23: {
                serverResponse.goResponse.type = (byte)42;
                serverResponse.goResponse.not_available_reason = (byte)2;
                serverResponse.goResponse.be_challenged_user = clientAdapter.info.userName;
                this.sendToUser(serverResponse, clientRequest.goRequest.beRefusedUser);
                break;
            }
            case 24: {
                this.sendQiZi(clientAdapter, clientRequest);
                break;
            }
            case 25: {
                this.recordMem.readIndex(clientRequest.goRequest.userNameOfGameIndex, clientRequest.goRequest.pageNumberOfGameIndex, clientAdapter);
                break;
            }
            case 26: {
                this.recordMem.readRecrod(clientRequest.goRequest.userNameOfOldGame, clientRequest.goRequest.numberOfOldGame, clientAdapter);
                break;
            }
            case 30: {
                this.setGameResult(clientRequest.goRequest.setGameResult, clientRequest.goRequest.numberOfRoomBeSetGameResult);
                break;
            }
            case 32: {
                this.studyGameProcess(true, clientRequest.goRequest.agreeStudyUser, clientRequest.goRequest.agreeStudyRoomNumber);
                break;
            }
            case 33: {
                this.studyGameProcess(false, clientRequest.goRequest.refuseStudyUser, clientRequest.goRequest.refuseStudyRoomNumber);
                break;
            }
            case 40: {
                this.gamblingProcess(clientAdapter, clientRequest.goRequest.gamblingRoomNumber, clientRequest.goRequest.gamblingMoney, clientRequest.goRequest.gamblingIsSelectBlackWin);
                break;
            }
            default: {
                ServerGlobal.log.log.warning(" go switch process unknown type = " + clientRequest.goRequest.type);
            }
        }
    }

    protected void studyGameProcess(boolean bl, String string, int n) {
        GoRoom goRoom = null;
        for (GoRoom goRoom2 : this.rooms) {
            if (goRoom2.roomNumber != n) continue;
            goRoom = goRoom2;
            break;
        }
        if (goRoom == null) {
            return;
        }
        Object object = new ServerResponse();
        ((ServerResponse)object).type = (byte)70;
        ((ServerResponse)object).goResponse = new GoServerResponse();
        if (bl) {
            ((ServerResponse)object).goResponse.type = (byte)71;
            ((ServerResponse)object).goResponse.agreeStudyGameRoomNumber = n;
            ((ServerResponse)object).goResponse.agreeStudyGameUserName = string;
        } else {
            ((ServerResponse)object).goResponse.type = (byte)72;
            ((ServerResponse)object).goResponse.refuseStudyGameRoomNumber = n;
            ((ServerResponse)object).goResponse.refuseStudyGameUserName = string;
        }
        goRoom.sendRoomInfo((ServerResponse)object);
        goRoom.setStudyStatus(bl);
        if (goRoom.status.getValue() == 8) {
            object = new ServerResponse();
            ((ServerResponse)object).type = (byte)70;
            ((ServerResponse)object).goResponse = new GoServerResponse();
            ((ServerResponse)object).goResponse.type = (byte)73;
            ((ServerResponse)object).goResponse.beginStudyGameRoomNumber = n;
            goRoom.sendRoomInfo((ServerResponse)object);
        }
    }

    protected void setGameResult(GoGameResult goGameResult, int n) {
        Object object2;
        GoRoom goRoom = null;
        for (Object object2 : this.rooms) {
            if (((GoRoom)object2).roomNumber != n) continue;
            goRoom = object2;
            break;
        }
        if (goRoom == null) {
            return;
        }
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)60;
        serverResponse.goResponse.rqz = new GoRecordQiZi();
        serverResponse.goResponse.rqz.type = 40;
        serverResponse.goResponse.rqz.serverResult = goGameResult;
        serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.rqzIsInGame = true;
        goRoom.sendRoomInfo(serverResponse);
        goRoom.record.mem.add(serverResponse.goResponse.rqz);
        goRoom.record.result = goGameResult;
        object2 = null;
        ClientAdapter clientAdapter = goRoom.searchMember(goRoom.black);
        ClientAdapter clientAdapter2 = goRoom.searchMember(goRoom.white);
        GameResult gameResult = GameResult.resultless;
        if (goGameResult.result == 3) {
            gameResult = GameResult.peace;
        } else if (goGameResult.result == 4) {
            gameResult = GameResult.resultless;
        }
        if (clientAdapter != null) {
            object2 = clientAdapter;
            if (goGameResult.result == 1) {
                gameResult = GameResult.win;
            } else if (goGameResult.result == 2) {
                gameResult = GameResult.fail;
            }
        } else if (clientAdapter2 != null) {
            object2 = clientAdapter2;
            if (goGameResult.result == 1) {
                gameResult = GameResult.fail;
            } else if (goGameResult.result == 2) {
                gameResult = GameResult.win;
            }
        } else {
            return;
        }
        this.registGradeAndUpdateForShare((ClientAdapter)object2, goRoom, gameResult);
    }

    private void agreeInventionProcess(ClientAdapter clientAdapter, String string) {
        if (string.equals(clientAdapter.info.userName)) {
            return;
        }
        ClientAdapter clientAdapter2 = this.search(this.onLine, string);
        if (clientAdapter2 == null) {
            return;
        }
        if (!this.canPlayingWith(clientAdapter, clientAdapter2)) {
            return;
        }
        GoRoom goRoom = new GoRoom();
        goRoom.roomNumber = this.roomNumberManager.create();
        this.rooms.add(goRoom);
        goRoom.title = "";
        goRoom.info = "";
        goRoom.passwd = "";
        goRoom.status.setValue((byte)1);
        goRoom.goIn(clientAdapter2);
        goRoom.goIn(clientAdapter);
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)30;
        serverResponse.createdRoom = goRoom;
        this.sendToEveryUser(serverResponse);
    }

    private boolean canPlayingWith(ClientAdapter clientAdapter, ClientAdapter clientAdapter2) {
        if (clientAdapter.tmpInfo.go.roomTotal() >= ServerGlobal.setting.roomMaxLimit) {
            return false;
        }
        return clientAdapter2.tmpInfo.go.roomTotal() < ServerGlobal.setting.roomMaxLimit;
    }

    private boolean isNeedGrade(ClientAdapter clientAdapter, ClientAdapter clientAdapter2, GoGameRule goGameRule) {
        return goGameRule.mode != 1;
    }

    private void registGradeAndUpdateForShare(ClientAdapter clientAdapter, GoRoom goRoom, GameResult gameResult) {
        ServerResponse serverResponse;
        goRoom.record.goGameEnd();
        String string = goRoom.record.anotherPlayer(clientAdapter.info.userName);
        ClientAdapter clientAdapter2 = goRoom.searchMember(string);
        if (clientAdapter2 != null) {
            if (this.isNeedGrade(clientAdapter, clientAdapter2, goRoom.record.rule)) {
                if (gameResult == GameResult.win) {
                    clientAdapter.info.go.registGameResult(GameResult.win);
                    clientAdapter2.info.go.registGameResult(GameResult.fail);
                } else if (gameResult == GameResult.peace) {
                    clientAdapter.info.go.registGameResult(GameResult.peace);
                    clientAdapter2.info.go.registGameResult(GameResult.peace);
                } else if (gameResult == GameResult.fail) {
                    clientAdapter.info.go.registGameResult(GameResult.fail);
                    clientAdapter2.info.go.registGameResult(GameResult.win);
                } else if (gameResult == GameResult.resultless) {
                    clientAdapter.info.go.registGameResult(GameResult.resultless);
                    clientAdapter2.info.go.registGameResult(GameResult.resultless);
                }
                this.login.modify(clientAdapter);
                this.login.modify(clientAdapter2);
            }
            serverResponse = new ServerResponse();
            serverResponse.type = (byte)70;
            serverResponse.goResponse = new GoServerResponse();
            serverResponse.goResponse.type = (byte)48;
            serverResponse.goResponse.info = clientAdapter.info;
            this.sendToEveryUser(serverResponse);
            serverResponse = new ServerResponse();
            serverResponse.type = (byte)70;
            serverResponse.goResponse = new GoServerResponse();
            serverResponse.goResponse.type = (byte)48;
            serverResponse.goResponse.info = clientAdapter2.info;
            this.sendToEveryUser(serverResponse);
        }
        this.gamblingResultProcess(clientAdapter, clientAdapter2, gameResult, goRoom);
        serverResponse = goRoom.setStatusOnServer(new RoomStatus(3));
        if (serverResponse != null) {
            this.sendToEveryUser(serverResponse);
        }
        ServerResponse serverResponse2 = new ServerResponse();
        serverResponse2.type = (byte)70;
        serverResponse2.goResponse = new GoServerResponse();
        serverResponse2.goResponse.type = (byte)44;
        serverResponse2.goResponse.statusGoRoomNumber = goRoom.roomNumber;
        serverResponse2.goResponse.goGameStatus = goRoom.getStatus();
        this.sendToEveryUser(serverResponse2);
        this.recordMem.saveRecord(goRoom.record);
    }

    private void gamblingResultProcess(ClientAdapter clientAdapter, ClientAdapter clientAdapter2, GameResult gameResult, GoRoom goRoom) {
        if (clientAdapter == null || clientAdapter2 == null) {
            System.out.println("gamblingResultProcess : client no find !");
            return;
        }
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)120;
        serverResponse.usernameAndMoneys = new Vector();
        if (goRoom.gamblingInfo == null) {
            goRoom.gamblingInfo = new GoGamblingGameInfo();
        }
        if (gameResult == GameResult.peace || gameResult == GameResult.resultless) {
            UsernameAndMoney usernameAndMoney;
            ClientAdapter clientAdapter3;
            TpMoney tpMoney;
            GoGamblingGameInfo goGamblingGameInfo = goRoom.gamblingInfo;
            for (GoGamblingOneUserInfo goGamblingOneUserInfo : goGamblingGameInfo.getBlackWin()) {
                tpMoney = new TpMoney(goGamblingOneUserInfo.money);
                clientAdapter3 = this.search(this.onLine, goGamblingOneUserInfo.userName);
                if (clientAdapter3 != null) {
                    usernameAndMoney = new UsernameAndMoney();
                    usernameAndMoney.username = goGamblingOneUserInfo.userName;
                    usernameAndMoney.money = goGamblingOneUserInfo.money + clientAdapter3.info.money.intValue();
                    serverResponse.usernameAndMoneys.add(usernameAndMoney);
                    this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter3);
                    continue;
                }
                this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter);
            }
            for (GoGamblingOneUserInfo goGamblingOneUserInfo : goGamblingGameInfo.getWhiteWin()) {
                tpMoney = new TpMoney(goGamblingOneUserInfo.money);
                clientAdapter3 = this.search(this.onLine, goGamblingOneUserInfo.userName);
                if (clientAdapter3 != null) {
                    usernameAndMoney = new UsernameAndMoney();
                    usernameAndMoney.username = goGamblingOneUserInfo.userName;
                    usernameAndMoney.money = goGamblingOneUserInfo.money + clientAdapter3.info.money.intValue();
                    serverResponse.usernameAndMoneys.add(usernameAndMoney);
                    this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter3);
                    continue;
                }
                this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter);
            }
        } else {
            GoGamblingGameInfo goGamblingGameInfo = goRoom.gamblingInfo;
            boolean bl = false;
            if (clientAdapter.getName().equals(goRoom.black)) {
                if (gameResult == GameResult.win) {
                    bl = true;
                }
            } else if (clientAdapter.getName().equals(goRoom.white)) {
                if (gameResult == GameResult.fail) {
                    bl = true;
                }
            } else {
                System.out.println("gamblingResultProcess : no black no white.");
            }
            long l = goGamblingGameInfo.blackWinMoney();
            long l2 = goGamblingGameInfo.whiteWinMoney();
            long l3 = l + l2;
            if (l > 0L && l2 > 0L) {
                if (bl) {
                    Root root2;
                    for (Root root2 : goGamblingGameInfo.getBlackWin()) {
                        root2.money = (int)(((long)(root2.money * 100) + l * 94L / l3) / 100L);
                        TpMoney tpMoney = new TpMoney(root2.money);
                        ClientAdapter clientAdapter4 = this.search(this.onLine, root2.userName);
                        if (clientAdapter4 != null) {
                            UsernameAndMoney usernameAndMoney = new UsernameAndMoney();
                            usernameAndMoney.username = root2.userName;
                            usernameAndMoney.money = root2.money + clientAdapter4.info.money.intValue();
                            serverResponse.usernameAndMoneys.add(usernameAndMoney);
                            this.login.addMoneyNoTax(root2.userName, tpMoney, clientAdapter4);
                            continue;
                        }
                        this.login.addMoneyNoTax(root2.userName, tpMoney, clientAdapter);
                    }
                    TpMoney tpMoney = new TpMoney(l / (l3 * 20L));
                    if (clientAdapter.getName().equals(goRoom.black)) {
                        root2 = new UsernameAndMoney();
                        ((UsernameAndMoney)root2).username = clientAdapter.getName();
                        ((UsernameAndMoney)root2).money = tpMoney.intValue() + clientAdapter.info.money.intValue();
                        serverResponse.usernameAndMoneys.add((UsernameAndMoney)root2);
                        this.login.addMoneyNoTax(clientAdapter.getName(), tpMoney, clientAdapter);
                    } else {
                        root2 = new UsernameAndMoney();
                        ((UsernameAndMoney)root2).username = clientAdapter2.getName();
                        ((UsernameAndMoney)root2).money = tpMoney.intValue() + clientAdapter2.info.money.intValue();
                        serverResponse.usernameAndMoneys.add((UsernameAndMoney)root2);
                        this.login.addMoneyNoTax(clientAdapter2.getName(), tpMoney, clientAdapter2);
                    }
                } else {
                    Root root3;
                    for (Root root3 : goGamblingGameInfo.getWhiteWin()) {
                        root3.money = (int)(((long)(root3.money * 100) + l * 94L / l3) / 100L);
                        TpMoney tpMoney = new TpMoney(root3.money);
                        ClientAdapter clientAdapter5 = this.search(this.onLine, root3.userName);
                        if (clientAdapter5 != null) {
                            UsernameAndMoney usernameAndMoney = new UsernameAndMoney();
                            usernameAndMoney.username = root3.userName;
                            usernameAndMoney.money = root3.money + clientAdapter5.info.money.intValue();
                            serverResponse.usernameAndMoneys.add(usernameAndMoney);
                            this.login.addMoneyNoTax(root3.userName, tpMoney, clientAdapter5);
                            continue;
                        }
                        this.login.addMoneyNoTax(root3.userName, tpMoney, clientAdapter);
                    }
                    TpMoney tpMoney = new TpMoney(l2 / (l3 * 20L));
                    if (clientAdapter.getName().equals(goRoom.white)) {
                        root3 = new UsernameAndMoney();
                        ((UsernameAndMoney)root3).username = clientAdapter.getName();
                        ((UsernameAndMoney)root3).money = tpMoney.intValue() + clientAdapter.info.money.intValue();
                        serverResponse.usernameAndMoneys.add((UsernameAndMoney)root3);
                        this.login.addMoneyNoTax(clientAdapter.getName(), tpMoney, clientAdapter);
                    } else {
                        root3 = new UsernameAndMoney();
                        ((UsernameAndMoney)root3).username = clientAdapter2.getName();
                        ((UsernameAndMoney)root3).money = tpMoney.intValue() + clientAdapter2.info.money.intValue();
                        serverResponse.usernameAndMoneys.add((UsernameAndMoney)root3);
                        this.login.addMoneyNoTax(clientAdapter2.getName(), tpMoney, clientAdapter2);
                    }
                }
            } else {
                UsernameAndMoney usernameAndMoney;
                ClientAdapter clientAdapter6;
                TpMoney tpMoney;
                for (GoGamblingOneUserInfo goGamblingOneUserInfo : goGamblingGameInfo.getBlackWin()) {
                    tpMoney = new TpMoney(goGamblingOneUserInfo.money);
                    clientAdapter6 = this.search(this.onLine, goGamblingOneUserInfo.userName);
                    if (clientAdapter6 != null) {
                        usernameAndMoney = new UsernameAndMoney();
                        usernameAndMoney.username = goGamblingOneUserInfo.userName;
                        usernameAndMoney.money = goGamblingOneUserInfo.money + clientAdapter6.info.money.intValue();
                        serverResponse.usernameAndMoneys.add(usernameAndMoney);
                        this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter6);
                        continue;
                    }
                    this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter);
                }
                for (GoGamblingOneUserInfo goGamblingOneUserInfo : goGamblingGameInfo.getWhiteWin()) {
                    tpMoney = new TpMoney(goGamblingOneUserInfo.money);
                    clientAdapter6 = this.search(this.onLine, goGamblingOneUserInfo.userName);
                    if (clientAdapter6 != null) {
                        usernameAndMoney = new UsernameAndMoney();
                        usernameAndMoney.username = goGamblingOneUserInfo.userName;
                        usernameAndMoney.money = goGamblingOneUserInfo.money + clientAdapter6.info.money.intValue();
                        serverResponse.usernameAndMoneys.add(usernameAndMoney);
                        this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter6);
                        continue;
                    }
                    this.login.addMoneyNoTax(goGamblingOneUserInfo.userName, tpMoney, clientAdapter);
                }
            }
            this.sendToEveryUser(serverResponse);
            goGamblingGameInfo.clear();
        }
    }

    private void agreePeace(ClientAdapter clientAdapter, GoRoom goRoom, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)60;
        serverResponse.goResponse.rqz = new GoRecordQiZi();
        serverResponse.goResponse.rqz.type = 40;
        GoGameResult goGameResult = new GoGameResult();
        goGameResult.result = (byte)3;
        serverResponse.goResponse.rqz.serverResult = goGameResult;
        serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.rqzIsInGame = true;
        goRoom.sendRoomInfo(serverResponse);
        goRoom.record.mem.add(serverResponse.goResponse.rqz);
        goRoom.record.result = goGameResult;
        this.registGradeAndUpdateForShare(clientAdapter, goRoom, GameResult.peace);
    }

    protected void agreeCompute(GoRoom goRoom) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)60;
        serverResponse.goResponse.rqz = new GoRecordQiZi();
        serverResponse.goResponse.rqz.type = 41;
        serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.rqzIsInGame = true;
        goRoom.sendRoomInfo(serverResponse);
        goRoom.record.mem.add(serverResponse.goResponse.rqz);
    }

    protected void agreeRestoreInGame(GoRoom goRoom) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)60;
        serverResponse.goResponse.rqz = new GoRecordQiZi();
        serverResponse.goResponse.rqz.type = 42;
        serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.rqzIsInGame = true;
        goRoom.sendRoomInfo(serverResponse);
        goRoom.record.mem.add(serverResponse.goResponse.rqz);
    }

    protected void giveUp(ClientAdapter clientAdapter, GoRoom goRoom) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)60;
        serverResponse.goResponse.rqz = new GoRecordQiZi();
        serverResponse.goResponse.rqz.type = 40;
        GoGameResult goGameResult = new GoGameResult();
        goGameResult.winMode = 1;
        UserInfo userInfo = goRoom.getBlackInfoOnServer();
        UserInfo userInfo2 = goRoom.getWhiteInfoOnServer();
        if (userInfo != null && userInfo.userName.equals(clientAdapter.info.userName)) {
            goGameResult.result = (byte)2;
        } else if (userInfo2 != null && userInfo2.userName.equals(clientAdapter.info.userName)) {
            goGameResult.result = 1;
        }
        serverResponse.goResponse.rqz.serverResult = goGameResult;
        serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.rqzIsInGame = true;
        goRoom.sendRoomInfo(serverResponse);
        goRoom.record.mem.add(serverResponse.goResponse.rqz);
        goRoom.record.result = goGameResult;
        this.registGradeAndUpdateForShare(clientAdapter, goRoom, GameResult.fail);
    }

    private void giveUp(ClientAdapter clientAdapter, GoRoom goRoom, ClientRequest clientRequest) {
        this.giveUp(clientAdapter, goRoom);
    }

    protected void breakLineTimeOut(ClientAdapter clientAdapter, GoRoom goRoom) {
        if (!goRoom.isPlaying()) {
            return;
        }
        goRoom.record.goGameEnd();
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)60;
        serverResponse.goResponse.rqz = new GoRecordQiZi();
        serverResponse.goResponse.rqz.type = 40;
        GoGameResult goGameResult = new GoGameResult();
        goGameResult.winMode = (byte)3;
        goGameResult.result = goRoom.black.equals(clientAdapter.info.userName) ? (byte)2 : (goRoom.white.equals(clientAdapter.info.userName) ? (byte)1 : (byte)3);
        serverResponse.goResponse.rqz.serverResult = goGameResult;
        serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.rqzIsInGame = true;
        goRoom.sendRoomInfo(serverResponse);
        goRoom.record.mem.add(serverResponse.goResponse.rqz);
        goRoom.record.result = goGameResult;
        GameResult gameResult = GameResult.peace;
        gameResult = clientAdapter.info.userName.equals(clientAdapter.info.userName) ? GameResult.fail : GameResult.win;
        this.registGradeAndUpdateForShare(clientAdapter, goRoom, gameResult);
    }

    private void timeOut(ClientAdapter clientAdapter, GoRoom goRoom, ClientRequest clientRequest) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)60;
        serverResponse.goResponse.rqz = new GoRecordQiZi();
        serverResponse.goResponse.rqz.type = 40;
        GoGameResult goGameResult = new GoGameResult();
        goGameResult.winMode = (byte)2;
        goGameResult.result = goRoom.black.equals(clientRequest.goRequest.inGameRqz.whoTimeOut) ? (byte)2 : (goRoom.white.equals(clientRequest.goRequest.inGameRqz.whoTimeOut) ? (byte)1 : (byte)3);
        serverResponse.goResponse.rqz.serverResult = goGameResult;
        serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.rqzIsInGame = true;
        goRoom.sendRoomInfo(serverResponse);
        goRoom.record.mem.add(serverResponse.goResponse.rqz);
        goRoom.record.result = goGameResult;
        GameResult gameResult = GameResult.peace;
        gameResult = clientAdapter.info.userName.equals(clientRequest.goRequest.inGameRqz.whoTimeOut) ? GameResult.fail : GameResult.win;
        this.registGradeAndUpdateForShare(clientAdapter, goRoom, gameResult);
    }

    private void normalProcess(GoRoom goRoom) {
        ServerResponse serverResponse;
        boolean bl = false;
        ++goRoom.record.counterOfNormalQiZi;
        if (goRoom.record.counterOfNormalQiZi == 50) {
            serverResponse = goRoom.setStatusOnServer(new RoomStatus(6));
            if (serverResponse != null) {
                this.sendToEveryUser(serverResponse);
            }
            bl = true;
        } else if (goRoom.record.counterOfNormalQiZi == 200) {
            serverResponse = goRoom.setStatusOnServer(new RoomStatus(7));
            if (serverResponse != null) {
                this.sendToEveryUser(serverResponse);
            }
            bl = true;
        }
        if (!bl) {
            return;
        }
        serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)44;
        serverResponse.goResponse.statusGoRoomNumber = goRoom.roomNumber;
        serverResponse.goResponse.goGameStatus = goRoom.getStatus();
        this.sendToEveryUser(serverResponse);
    }

    private void sendQiZi(ClientAdapter clientAdapter, ClientRequest clientRequest) {
        GoRoom goRoom = this.search(this.rooms, clientRequest.goRequest.inGameRqzRoomNumber);
        if (goRoom == null) {
            return;
        }
        if (!goRoom.isPlaying()) {
            return;
        }
        goRoom.record.mem.add(clientRequest.goRequest.inGameRqz);
        for (ClientAdapter clientAdapter2 : goRoom.members) {
            if (clientAdapter2.info.userName.equals(clientAdapter.info.userName)) continue;
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)70;
            serverResponse.goResponse = new GoServerResponse();
            serverResponse.goResponse.type = (byte)60;
            serverResponse.goResponse.rqz = clientRequest.goRequest.inGameRqz;
            serverResponse.goResponse.rqzRoomNumber = clientRequest.goRequest.inGameRqzRoomNumber;
            serverResponse.goResponse.rqzIsInGame = goRoom.isRunner(clientAdapter2.info.userName);
            clientAdapter2.put(serverResponse);
        }
        switch (clientRequest.goRequest.inGameRqz.type) {
            case 1: {
                this.normalProcess(goRoom);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.giveUp(clientAdapter, goRoom, clientRequest);
                break;
            }
            case 7: {
                this.timeOut(clientAdapter, goRoom, clientRequest);
                break;
            }
            case 9: {
                this.agreePeace(clientAdapter, goRoom, clientRequest);
                break;
            }
            case 15: {
                break;
            }
            case 20: {
                break;
            }
            case 12: {
                this.agreeCompute(goRoom);
                break;
            }
            case 22: {
                this.agreeRestoreInGame(goRoom);
                break;
            }
            case 24: {
                this.validateProcess(clientAdapter, goRoom, clientRequest);
            }
        }
    }

    private void validateProcess(ClientAdapter clientAdapter, GoRoom goRoom, ClientRequest clientRequest) {
        if (goRoom.record.black.equals(clientRequest.goRequest.inGameRqz.whoValidate)) {
            goRoom.record.blackValidate = clientRequest.goRequest.inGameRqz.beValidatedResult;
        } else if (goRoom.record.white.equals(clientRequest.goRequest.inGameRqz.whoValidate)) {
            goRoom.record.whiteValidate = clientRequest.goRequest.inGameRqz.beValidatedResult;
        }
        if (goRoom.record.whiteValidate != null && goRoom.record.blackValidate != null && goRoom.record.whiteValidate.valueEquals(goRoom.record.blackValidate)) {
            goRoom.record.goGameEnd();
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)70;
            serverResponse.goResponse = new GoServerResponse();
            serverResponse.goResponse.type = (byte)60;
            serverResponse.goResponse.rqzRoomNumber = goRoom.roomNumber;
            serverResponse.goResponse.rqzIsInGame = true;
            serverResponse.goResponse.rqz = new GoRecordQiZi();
            serverResponse.goResponse.rqz.type = 40;
            serverResponse.goResponse.rqz.serverResult = goRoom.record.blackValidate;
            goRoom.sendRoomInfo(serverResponse);
            goRoom.record.mem.add(serverResponse.goResponse.rqz);
            goRoom.record.result = serverResponse.goResponse.rqz.serverResult;
            GameResult gameResult = GameResult.resultless;
            switch (serverResponse.goResponse.rqz.serverResult.result) {
                case 1: {
                    if (clientAdapter.info.userName.equals(goRoom.black)) {
                        gameResult = GameResult.win;
                        break;
                    }
                    if (!clientAdapter.info.userName.equals(goRoom.white)) break;
                    gameResult = GameResult.fail;
                    break;
                }
                case 2: {
                    if (clientAdapter.info.userName.equals(goRoom.black)) {
                        gameResult = GameResult.fail;
                        break;
                    }
                    if (!clientAdapter.info.userName.equals(goRoom.white)) break;
                    gameResult = GameResult.win;
                    break;
                }
                case 3: {
                    gameResult = GameResult.peace;
                    break;
                }
                case 4: {
                    gameResult = GameResult.resultless;
                }
            }
            this.registGradeAndUpdateForShare(clientAdapter, goRoom, gameResult);
        }
    }

    private void createGoGame(GoGameRule goGameRule) {
        Object object3;
        Object object2;
        ClientAdapter clientAdapter;
        ClientAdapter clientAdapter2;
        GoRoom goRoom = null;
        if (goGameRule.roomNumber < 0) {
            goRoom = new GoRoom();
            goRoom.roomNumber = this.roomNumberManager.create();
            clientAdapter2 = this.search(this.onLine, goGameRule.source);
            if (clientAdapter2 != null) {
                goRoom.goIn(clientAdapter2);
            } else {
                System.out.println("source no find.");
            }
            clientAdapter = this.search(this.onLine, goGameRule.dest);
            if (clientAdapter != null) {
                goRoom.goIn(clientAdapter);
            } else {
                System.out.println("dest no find.");
            }
            this.rooms.add(goRoom);
            object2 = new ServerResponse();
            ((ServerResponse)object2).type = (byte)30;
            ((ServerResponse)object2).createdRoom = goRoom;
            this.sendToEveryUser((ServerResponse)object2);
        } else {
            goRoom = this.search(this.rooms, goGameRule.roomNumber);
            if (goRoom == null || goRoom.isPlaying()) {
                goRoom = new GoRoom();
                goRoom.roomNumber = this.roomNumberManager.create();
                this.rooms.add(goRoom);
                clientAdapter2 = this.search(this.onLine, goGameRule.source);
                if (clientAdapter2 != null) {
                    goRoom.goIn(clientAdapter2);
                } else {
                    System.out.println("source no find. " + goGameRule.source);
                }
                clientAdapter = this.search(this.onLine, goGameRule.dest);
                if (clientAdapter != null) {
                    goRoom.goIn(clientAdapter);
                } else {
                    System.out.println("dest no find." + goGameRule.whiteName);
                }
                object2 = new ServerResponse();
                ((ServerResponse)object2).type = (byte)30;
                ((ServerResponse)object2).createdRoom = goRoom;
                this.sendToEveryUser((ServerResponse)object2);
            }
        }
        clientAdapter2 = null;
        clientAdapter = null;
        for (Object object3 : goRoom.members) {
            if (((ClientAdapter)object3).info.userName.equals(goGameRule.source)) {
                clientAdapter2 = object3;
                continue;
            }
            if (!((ClientAdapter)object3).info.userName.equals(goGameRule.dest)) continue;
            clientAdapter = object3;
        }
        if (clientAdapter2 == null || clientAdapter == null) {
            System.out.println(" create room error : source or dest adapter no find.");
            return;
        }
        goGameRule.selectBlackAndWhite(clientAdapter2.info, clientAdapter.info);
        goRoom.record = new GoGameRecord(goGameRule);
        goRoom.title = goRoom.title;
        goRoom.black = goRoom.record.black;
        goRoom.white = goRoom.record.white;
        goRoom.blackLevel = goRoom.record.blackLevel;
        goRoom.whiteLevel = goRoom.record.whiteLevel;
        goRoom.status = new RoomStatus(5);
        object2 = new ServerResponse();
        ((ServerResponse)object2).type = (byte)70;
        ((ServerResponse)object2).goResponse = new GoServerResponse();
        ((ServerResponse)object2).goResponse.type = (byte)45;
        ((ServerResponse)object2).goResponse.headGoGameRecord = goRoom.record;
        ((ServerResponse)object2).goResponse.headRoomNumber = goRoom.roomNumber;
        this.sendToEveryUser((ServerResponse)object2);
        object2 = new ServerResponse();
        ((ServerResponse)object2).type = (byte)70;
        ((ServerResponse)object2).goResponse = new GoServerResponse();
        ((ServerResponse)object2).goResponse.type = (byte)43;
        ((ServerResponse)object2).goResponse.beginGameRecord = goRoom.record;
        ((ServerResponse)object2).goResponse.beginGameRoomNumber = goRoom.roomNumber;
        this.sendToRoom((ServerResponse)object2, goRoom.roomNumber);
        object3 = new ServerResponse();
        ((ServerResponse)object3).type = (byte)70;
        ((ServerResponse)object3).goResponse = new GoServerResponse();
        ((ServerResponse)object3).goResponse.type = (byte)44;
        ((ServerResponse)object3).goResponse.statusGoRoomNumber = goRoom.roomNumber;
        ((ServerResponse)object3).goResponse.goGameStatus = new RoomStatus(5);
        this.sendToEveryUser((ServerResponse)object3);
        for (ClientAdapter clientAdapter3 : goRoom.members) {
            if (goRoom.record.isPlayer(clientAdapter3.info.userName)) {
                clientAdapter3.tmpInfo.go.addInGameRoom(goRoom);
            } else {
                clientAdapter3.tmpInfo.go.addSeeGameRoom(goRoom);
            }
            object2 = new ServerResponse();
            ((ServerResponse)object2).type = (byte)70;
            ((ServerResponse)object2).goResponse = new GoServerResponse();
            ((ServerResponse)object2).goResponse.type = (byte)46;
            ((ServerResponse)object2).goResponse.counterUserName = clientAdapter3.info.userName;
            ((ServerResponse)object2).goResponse.counterInGameCounter = (byte)clientAdapter3.tmpInfo.go.inGame.size();
            ((ServerResponse)object2).goResponse.counterSeeGameCounter = (byte)clientAdapter3.tmpInfo.go.seeGame.size();
            this.sendToEveryUser((ServerResponse)object2);
        }
    }

    void goGameRecordResultProcess(GoGameRecordResult goGameRecordResult) {
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        switch (goGameRecordResult.command.type) {
            case 3: {
                serverResponse.goResponse.type = (byte)50;
                serverResponse.goResponse.userNameOfGoGameIndex = goGameRecordResult.command.userName;
                serverResponse.goResponse.returnGoGameIndex = goGameRecordResult.allIndex;
                serverResponse.goResponse.pageNumberOfGameIndex = goGameRecordResult.pageNumber;
                goGameRecordResult.command.source.put(serverResponse);
                break;
            }
            case 2: {
                serverResponse.goResponse.type = (byte)51;
                serverResponse.goResponse.userNameOfGoGameRecord = goGameRecordResult.command.userNameOfRecord;
                serverResponse.goResponse.returnGoGameRecord = goGameRecordResult.record;
                goGameRecordResult.command.source.put(serverResponse);
                break;
            }
        }
    }

    void gamblingProcess(ClientAdapter clientAdapter, int n, int n2, boolean bl) {
        GoRoom goRoom = this.search(this.rooms, n);
        if (goRoom == null) {
            return;
        }
        if (goRoom.getStatus().getValue() == 1 || goRoom.getStatus().getValue() == 3 || goRoom.getStatus().getValue() == 8 || goRoom.getStatus().getValue() == 6 || goRoom.getStatus().getValue() == 7) {
            return;
        }
        UserInfo userInfo = goRoom.getBlackInfoOnServer();
        UserInfo userInfo2 = goRoom.getWhiteInfoOnServer();
        if (userInfo == null || userInfo2 == null) {
            return;
        }
        if (bl && clientAdapter.getName().equals(userInfo2.userName)) {
            return;
        }
        if (!bl && clientAdapter.getName().equals(userInfo.userName)) {
            return;
        }
        if (clientAdapter.info.money.longValue() >= (long)n2) {
            clientAdapter.info.money.dec(n2);
            this.login.moneyModify(true, clientAdapter.info.userName, clientAdapter.info.money, clientAdapter);
            if (goRoom.gamblingInfo == null) {
                goRoom.gamblingInfo = new GoGamblingGameInfo();
            }
            GoGamblingOneUserInfo goGamblingOneUserInfo = new GoGamblingOneUserInfo(clientAdapter.info.userName, clientAdapter.info.go.currentLevel, n2);
            int n3 = 0;
            n3 = bl ? goRoom.gamblingInfo.buyBlackWin(goGamblingOneUserInfo) : goRoom.gamblingInfo.buyWhiteWin(goGamblingOneUserInfo);
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.type = (byte)70;
            serverResponse.goResponse = new GoServerResponse();
            serverResponse.goResponse.type = (byte)80;
            serverResponse.goResponse.gamblingRoomNumber = n;
            serverResponse.goResponse.gamblingIsSelectBlackWin = bl;
            GoGamblingOneUserInfo goGamblingOneUserInfo2 = new GoGamblingOneUserInfo();
            goGamblingOneUserInfo2.userName = clientAdapter.getName();
            goGamblingOneUserInfo2.level = clientAdapter.info.go.currentLevel;
            goGamblingOneUserInfo2.money = n2;
            serverResponse.goResponse.gamblingUser = goGamblingOneUserInfo2;
            goRoom.sendRoomInfo(serverResponse);
            UsernameAndMoney usernameAndMoney = new UsernameAndMoney();
            usernameAndMoney.username = clientAdapter.getName();
            usernameAndMoney.money = (int)clientAdapter.info.money.longValue();
            ServerResponse serverResponse2 = new ServerResponse();
            serverResponse2.type = (byte)120;
            serverResponse2.usernameAndMoneys = new Vector();
            serverResponse2.usernameAndMoneys.add(usernameAndMoney);
            this.sendToEveryUser(serverResponse2);
        }
    }
}

