/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;
import tianyuan.games.base.GoGameIndex;
import tianyuan.games.base.GoGameRecord;
import tianyuan.games.base.TyBaseInputRandomAccessFile;
import tianyuan.games.base.TyBaseOutputRandomAccessFile;
import tianyuan.games.net.server.BooleanFlag;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.GoGameRecordCommand;
import tianyuan.games.net.server.GoGameRecordResult;
import tianyuan.games.net.server.ServerGlobal;

class GoGameRecordAdapter {
    private String pathOfStorageGoGameRecord = null;
    private Vector<GoGameRecordCommand> outQueue = new Vector();
    private Vector<GoGameRecordResult> inQueue = new Vector();
    private output to;
    private BooleanFlag stopFlag = new BooleanFlag(false);

    GoGameRecordAdapter() {
        this.pathOfStorageGoGameRecord = ServerGlobal.pathOfStorageGoGameRecord;
        this.to = new output();
        this.to.start();
    }

    GoGameRecordAdapter(String string) {
        this.pathOfStorageGoGameRecord = string;
        this.to = new output();
        this.to.start();
    }

    public synchronized GoGameRecordResult get() {
        if (this.inQueue.isEmpty()) {
            return null;
        }
        GoGameRecordResult goGameRecordResult = this.inQueue.firstElement();
        this.inQueue.remove(goGameRecordResult);
        return goGameRecordResult;
    }

    private synchronized void put(GoGameRecordCommand goGameRecordCommand) {
        this.outQueue.add(goGameRecordCommand);
        this.notify();
    }

    protected void close() {
        GoGameRecordCommand goGameRecordCommand = new GoGameRecordCommand();
        goGameRecordCommand.type = 0;
        this.put(goGameRecordCommand);
    }

    protected void readIndex(String string, int n, ClientAdapter clientAdapter) {
        GoGameRecordCommand goGameRecordCommand = new GoGameRecordCommand();
        goGameRecordCommand.type = 3;
        goGameRecordCommand.userName = string;
        goGameRecordCommand.pageNumberOfGame = n;
        goGameRecordCommand.source = clientAdapter;
        this.put(goGameRecordCommand);
    }

    protected void readRecrod(String string, int n, ClientAdapter clientAdapter) {
        GoGameRecordCommand goGameRecordCommand = new GoGameRecordCommand();
        goGameRecordCommand.type = 2;
        goGameRecordCommand.userNameOfRecord = string;
        goGameRecordCommand.numberOfRecord = n;
        goGameRecordCommand.source = clientAdapter;
        this.put(goGameRecordCommand);
    }

    protected void saveRecord(GoGameRecord goGameRecord) {
        GoGameRecordCommand goGameRecordCommand = new GoGameRecordCommand();
        goGameRecordCommand.type = 1;
        goGameRecordCommand.record = goGameRecord;
        this.put(goGameRecordCommand);
    }

    protected void createUser(String string) {
        GoGameRecordCommand goGameRecordCommand = new GoGameRecordCommand();
        goGameRecordCommand.type = 4;
        goGameRecordCommand.userName = string;
        this.put(goGameRecordCommand);
    }

    protected void delUser(String string) {
        GoGameRecordCommand goGameRecordCommand = new GoGameRecordCommand();
        goGameRecordCommand.type = 5;
        goGameRecordCommand.userName = string;
        this.put(goGameRecordCommand);
    }

    private synchronized GoGameRecordCommand getFromOutQueue() {
        while (true) {
            try {
                while (this.outQueue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        GoGameRecordCommand goGameRecordCommand = this.outQueue.firstElement();
        this.outQueue.remove(goGameRecordCommand);
        return goGameRecordCommand;
    }

    private synchronized void putToInQueue(GoGameRecordResult goGameRecordResult) {
        if (goGameRecordResult != null) {
            this.inQueue.add(goGameRecordResult);
        }
    }

    public boolean getStop() {
        return this.stopFlag.get();
    }

    private class output
    extends Thread {
        static final String HEAD = ".head";
        static final String BODY = ".body";
        static final int HEAD_ITEM_MAX_LENGTH = 100;
        static final int BODY_ITEM_MAX_LENGTH = 10240;
        private GoGameRecordCommand msg;
        static final int PAGE_SIZE = 10;

        private output() {
        }

        private void saveRecordProcessNew() {
            this.saveRecordNew(this.msg.record.black);
            this.saveRecordNew(this.msg.record.white);
        }

        private void saveRecordProcess() {
            this.saveRecord(this.msg.record.black);
            this.saveRecord(this.msg.record.white);
        }

        private void saveRecordNew(String string) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + string + BODY, "rw");
                long l = randomAccessFile.length();
                randomAccessFile.seek(l);
                TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
                this.msg.record.write(tyBaseOutputRandomAccessFile);
                long l2 = randomAccessFile.getFilePointer() - l;
                randomAccessFile.close();
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + string + HEAD, "rw");
                long l3 = randomAccessFile2.length();
                long l4 = l3 / 100L;
                randomAccessFile2.setLength(l3 + 100L);
                randomAccessFile2.seek(l3);
                randomAccessFile2.writeLong(l);
                GoGameIndex goGameIndex = this.msg.record.getGoGameIndex();
                goGameIndex.number = (int)l4;
                goGameIndex.recordLength = (short)l2;
                TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
                goGameIndex.write(tyBaseOutputRandomAccessFile2);
                randomAccessFile2.setLength(l3 + 100L);
                randomAccessFile2.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void saveRecord(String string) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + string + BODY, "rw");
                long l = randomAccessFile.length();
                randomAccessFile.setLength(l + 10240L);
                long l2 = l / 10240L;
                randomAccessFile.seek(l);
                TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
                this.msg.record.write(tyBaseOutputRandomAccessFile);
                long l3 = randomAccessFile.getFilePointer() - l;
                randomAccessFile.setLength(l + 10240L);
                randomAccessFile.close();
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + string + HEAD, "rw");
                long l4 = randomAccessFile2.length();
                randomAccessFile2.setLength(l4 + 100L);
                randomAccessFile2.seek(l4);
                GoGameIndex goGameIndex = this.msg.record.getGoGameIndex();
                goGameIndex.number = (int)l2;
                goGameIndex.recordLength = (short)l3;
                TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
                goGameIndex.write(tyBaseOutputRandomAccessFile2);
                randomAccessFile2.setLength(l4 + 100L);
                randomAccessFile2.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void readRecordProcessNew() {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userNameOfRecord + HEAD, "r");
                randomAccessFile.seek(this.msg.numberOfRecord * 100);
                long l = randomAccessFile.readLong();
                GoGameRecord goGameRecord = new GoGameRecord();
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userNameOfRecord + BODY, "r");
                randomAccessFile2.seek(l);
                TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile2);
                goGameRecord.read(tyBaseInputRandomAccessFile);
                randomAccessFile2.close();
                GoGameRecordResult goGameRecordResult = new GoGameRecordResult();
                goGameRecordResult.record = goGameRecord;
                goGameRecordResult.command = this.msg;
                GoGameRecordAdapter.this.putToInQueue(goGameRecordResult);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void readRecordProcess() {
            try {
                GoGameRecord goGameRecord = new GoGameRecord();
                RandomAccessFile randomAccessFile = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userNameOfRecord + BODY, "r");
                randomAccessFile.seek(this.msg.numberOfRecord * 10240);
                TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
                goGameRecord.read(tyBaseInputRandomAccessFile);
                randomAccessFile.close();
                GoGameRecordResult goGameRecordResult = new GoGameRecordResult();
                goGameRecordResult.record = goGameRecord;
                goGameRecordResult.command = this.msg;
                GoGameRecordAdapter.this.putToInQueue(goGameRecordResult);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void getIndexProcessNew() {
            try {
                Vector<GoGameIndex> vector = new Vector<GoGameIndex>();
                RandomAccessFile randomAccessFile = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userName + HEAD, "r");
                TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
                int n = (int)(randomAccessFile.length() / 100L);
                int n2 = this.msg.pageNumberOfGame;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > 10000000) {
                    n2 = 10000000;
                }
                if (n2 * 10 >= n) {
                    n2 = (n - 1) / 10;
                }
                for (int i = n2 * 10; i < (n2 + 1) * 10 && i < n; ++i) {
                    randomAccessFile.seek(i * 100 + 8);
                    GoGameIndex goGameIndex = new GoGameIndex();
                    goGameIndex.read(tyBaseInputRandomAccessFile);
                    vector.add(goGameIndex);
                }
                randomAccessFile.close();
                GoGameRecordResult goGameRecordResult = new GoGameRecordResult();
                goGameRecordResult.allIndex = vector;
                goGameRecordResult.command = this.msg;
                goGameRecordResult.pageNumber = n2;
                GoGameRecordAdapter.this.putToInQueue(goGameRecordResult);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void getIndexProcess() {
            try {
                Vector<GoGameIndex> vector = new Vector<GoGameIndex>();
                RandomAccessFile randomAccessFile = new RandomAccessFile(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userName + HEAD, "r");
                TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
                int n = (int)(randomAccessFile.length() / 100L);
                int n2 = this.msg.pageNumberOfGame;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 * 10 >= n) {
                    n2 = n / 10;
                }
                for (int i = n2 * 10; i < (n2 + 1) * 10 && i < n; ++i) {
                    randomAccessFile.seek(i * 100);
                    GoGameIndex goGameIndex = new GoGameIndex();
                    goGameIndex.read(tyBaseInputRandomAccessFile);
                    vector.add(goGameIndex);
                }
                randomAccessFile.close();
                GoGameRecordResult goGameRecordResult = new GoGameRecordResult();
                goGameRecordResult.allIndex = vector;
                goGameRecordResult.command = this.msg;
                goGameRecordResult.pageNumber = n2;
                GoGameRecordAdapter.this.putToInQueue(goGameRecordResult);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void createUserProcess() {
            try {
                File file = new File(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userName + BODY);
                file.createNewFile();
                File file2 = new File(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userName + HEAD);
                file2.createNewFile();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
        }

        private void delUserProcess() {
            try {
                File file = new File(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userName + BODY);
                File file2 = new File(GoGameRecordAdapter.this.pathOfStorageGoGameRecord + this.msg.userName + HEAD);
                file.delete();
                file2.delete();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
        }

        private boolean centerSwitch() {
            switch (this.msg.type) {
                case 1: {
                    this.saveRecordProcessNew();
                    break;
                }
                case 2: {
                    this.readRecordProcessNew();
                    break;
                }
                case 3: {
                    this.getIndexProcessNew();
                    break;
                }
                case 4: {
                    this.createUserProcess();
                    break;
                }
                case 5: {
                    this.delUserProcess();
                    break;
                }
                case 0: {
                    GoGameRecordAdapter.this.stopFlag.set(true);
                    return false;
                }
            }
            return true;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.msg = GoGameRecordAdapter.this.getFromOutQueue();
                        if (this.msg == null) {
                            output.sleep(100L);
                            continue;
                        }
                        if (!this.centerSwitch()) break;
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

