/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import tianyuan.games.base.TyBaseOutputStream;
import tianyuan.games.net.search.ServerInfo;
import tianyuan.games.net.search.ServerSearchDaemon;
import tianyuan.games.net.search.ServerSearchInterface;
import tianyuan.games.net.server.ClientAdapterManager;
import tianyuan.games.net.server.ServerGlobal;

public class Daemon
extends Thread
implements ServerSearchInterface {
    private int tcpPort = 7703;
    private int udpPort = 7702;
    private ServerSocket server = null;
    private ClientAdapterManager manager = null;
    private ServerSearchDaemon searchServer = null;

    public static void main(String[] stringArray) {
        new Daemon();
    }

    @Override
    public byte[] getServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.currentOnLineUser = (short)this.manager.getCurrentOnLine();
        serverInfo.onLineUserLimit = (short)ServerGlobal.getOnLineLimit();
        serverInfo.registedUserCount = this.manager.getCurrentSignUp();
        serverInfo.registedUserLimit = ServerGlobal.getUserLimit();
        serverInfo.serverName = new String(ServerGlobal.CLIENT_TITLE);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            TyBaseOutputStream tyBaseOutputStream = new TyBaseOutputStream(byteArrayOutputStream);
            serverInfo.ip = InetAddress.getByName("127.0.0.1");
            serverInfo.write(tyBaseOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Daemon() {
        this.setPriority(10);
        this.start();
    }

    public Daemon(int n, int n2) {
        this.tcpPort = n;
        this.udpPort = n2;
        this.setPriority(10);
        this.start();
    }

    public void setStop() {
        this.manager.setStop(true);
    }

    @Override
    public void run() {
        try {
            this.server = new ServerSocket(this.tcpPort);
        }
        catch (Exception exception) {
            ServerGlobal.log.log.warning("create server socket failure ." + exception);
            System.exit(-1);
        }
        this.manager = new ClientAdapterManager();
        this.searchServer = new ServerSearchDaemon(this, this.udpPort);
        this.searchServer.start();
        Runtime runtime = Runtime.getRuntime();
        System.gc();
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    if (runtime.freeMemory() < 50000L) {
                        ServerGlobal.log.log.warning("tyserver: memory waring: refuse a client.");
                        socket.close();
                    } else if (this.manager.alloc(socket) == null) {
                        socket.close();
                    }
                    this.sleepSec(1);
                }
            }
            catch (Exception exception) {
                System.out.println(" error in Daemon " + exception);
                System.exit(0);
                continue;
            }
            break;
        }
    }

    private void sleepSec(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

