/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseInputStream;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.base.TyBaseOutputStream;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserTmpInfo;
import tianyuan.games.net.ClientRequest;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.server.ClientAdapterStub;
import tianyuan.games.net.server.ServerGlobal;
import tianyuan.games.net.update.Update;

public class ClientAdapter {
    public UserInfo info;
    public UserTmpInfo tmpInfo = new UserTmpInfo();
    long lastRequestTime = 0L;
    long requestCounter = 0L;
    private long adapterId = -1L;
    private ClientAdapterStub stub = null;
    private String ipAddress = " no find ";
    private DataInputStream din;
    private DataOutputStream dout;
    private TyBaseInput in;
    private TyBaseOutput out;
    private Vector<ClientRequest> inQueue = new Vector();
    private Vector<ServerResponse> outQueue = new Vector();
    private input ti;
    private output to;
    private Socket sk = null;
    private boolean errorFlag = false;
    private long errorTime = 0L;
    private boolean stop = false;
    private WaitObject tiWaitObject = new WaitObject();
    private WaitObject toWaitObject = new WaitObject();
    public boolean deleteDeadAdapterHasProcessed = false;

    public String getName() {
        return this.info.userName;
    }

    public ClientAdapter(ClientAdapterStub clientAdapterStub) {
        this.stub = clientAdapterStub;
    }

    protected ClientAdapterStub getStub() {
        return new ClientAdapterStub(this.info, this.tmpInfo, this.getName(), this.getIpAddress(), this.tmpInfo.startTime, this.tmpInfo.clientOsName);
    }

    public ClientAdapter(Socket socket, long l) {
        try {
            this.sk = socket;
            this.adapterId = l;
            this.ipAddress = socket.getInetAddress().getHostAddress();
            this.tmpInfo.ipAddress = socket.getInetAddress().toString();
            this.din = new DataInputStream(socket.getInputStream());
            this.dout = new DataOutputStream(socket.getOutputStream());
            this.in = new TyBaseInputStream(this.din);
            this.out = new TyBaseOutputStream(this.dout);
            this.to = new output();
            this.to.setPriority(10);
            this.ti = new input();
            this.ti.start();
            this.errorFlag = false;
            this.lastRequestTime = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            ServerGlobal.log.log.warning("create ClientAdapter failure. " + socket.getInetAddress().toString());
        }
    }

    public ClientAdapter(UserInfo userInfo) {
        this.info = userInfo;
    }

    protected String getIpAddress() {
        return this.ipAddress;
    }

    public synchronized ClientRequest get() {
        if (this.inQueue.isEmpty()) {
            return null;
        }
        ClientRequest clientRequest = this.inQueue.firstElement();
        this.inQueue.remove(clientRequest);
        return clientRequest;
    }

    public boolean isSameUser(String string) {
        if (this.info == null) {
            return false;
        }
        if (this.info.userName == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return string.equals(this.info.userName);
    }

    public synchronized void put(ServerResponse serverResponse) {
        this.outQueue.add(serverResponse);
        this.notify();
    }

    public synchronized boolean isError() {
        return this.errorFlag;
    }

    public synchronized long getErrorTime() {
        return this.errorTime;
    }

    private synchronized void setError() {
        this.errorFlag = true;
        this.errorTime = new Date().getTime();
    }

    public synchronized void close() {
        this.stop = true;
        try {
            this.in.close();
            this.out.close();
            if (this.sk != null) {
                this.sk.close();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void sleepSec(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void start(Socket socket) {
        this.tiWaitObject.start();
        this.toWaitObject.start();
    }

    private void tiWaitForStart() {
        this.tiWaitObject.waitForStart();
    }

    private void toWaitForStart() {
        this.toWaitObject.waitForStart();
    }

    private synchronized ServerResponse getFromOutQueue() {
        while (true) {
            try {
                while (this.outQueue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException");
                continue;
            }
            break;
        }
        ServerResponse serverResponse = this.outQueue.firstElement();
        this.outQueue.remove(serverResponse);
        return serverResponse;
    }

    private synchronized void putToInQueue(ClientRequest clientRequest) {
        if (clientRequest != null) {
            this.inQueue.add(clientRequest);
        }
    }

    private class WaitObject {
        boolean startFlag = false;

        private WaitObject() {
        }

        synchronized void waitForStart() {
            while (true) {
                try {
                    while (!this.startFlag) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        synchronized void start() {
            this.startFlag = true;
            this.notify();
        }
    }

    private class input
    extends Thread {
        private input() {
        }

        @Override
        public void run() {
            ClientAdapter.this.tiWaitForStart();
            Update update = new Update();
            boolean bl = update.serverUpdateSupport(new File("./clientUpdate/windows"), new File("./clientUpdate/linux"), 1010, ClientAdapter.this.din, ClientAdapter.this.dout);
            if (bl) {
                ClientAdapter.this.stop = true;
            }
            ClientAdapter.this.to.start();
            block4: while (true) {
                try {
                    while (!ClientAdapter.this.stop) {
                        ClientRequest clientRequest = new ClientRequest();
                        if ((clientRequest = clientRequest.readRequest(ClientAdapter.this.in)) == null) {
                            ClientAdapter.this.setError();
                            break block4;
                        }
                        if (clientRequest.type == 0) {
                            // empty if block
                        }
                        ClientAdapter.this.putToInQueue(clientRequest);
                        ClientAdapter.this.sleepSec(1);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            try {
                ClientAdapter.this.sk.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class output
    extends Thread {
        private output() {
        }

        @Override
        public void run() {
            ClientAdapter.this.toWaitForStart();
            block4: while (true) {
                try {
                    while (!ClientAdapter.this.stop) {
                        ServerResponse serverResponse = ClientAdapter.this.getFromOutQueue();
                        if (serverResponse == null) continue;
                        if (serverResponse.type == 124) {
                            output.sleep(2000L);
                            break block4;
                        }
                        if (serverResponse.type == 1 || serverResponse.type == 2) {
                            serverResponse.myInfo = ClientAdapter.this.info;
                            serverResponse.myTmpInfo = ClientAdapter.this.tmpInfo;
                            this.setPriority(5);
                        }
                        boolean bl = true;
                        bl = serverResponse.writeResponse(ClientAdapter.this.out);
                        if (!bl) {
                            ClientAdapter.this.setError();
                            break block4;
                        }
                        ClientAdapter.this.sleepSec(1);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
            try {
                ClientAdapter.this.sk.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

