/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.hall;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import tianyuan.games.base.GameResult;
import tianyuan.games.base.GoRoomInfos;
import tianyuan.games.base.UserInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJTabbedPane;
import tianyuan.games.gui.MyJTextField;
import tianyuan.games.gui.goe.dialog.SettingDialog;
import tianyuan.games.gui.goe.goeroom.GoeSeeGameRecordPane;
import tianyuan.games.gui.goe.hall.TabbedInfoPane;
import tianyuan.games.gui.goe.table.GoUserInfoList;
import tianyuan.games.gui.goe.table.GoUserRoomList;

public class UserGoInfoPane
extends MyJTabbedPane {
    UserInfo user = null;
    GoRoomInfos roomInfos = null;
    boolean isOnLine;
    GoUserInfoList gradePane = null;
    GoUserRoomList roomPane = null;
    private TabbedInfoPane father;
    MyJTextField title = new MyJTextField(" ");
    JPanel buttonPane = new JPanel();
    JSplitPane split = null;
    JButton setButton = new JButton(Global.lang.getKey("128_set"));
    JButton closeButton = new JButton(Global.lang.getKey("128_close"));
    JButton displayButton = new JButton(Global.lang.getKey("128_show_record"));
    private SizeListener seeSize = new SizeListener();

    public UserGoInfoPane(UserInfo userInfo, GoRoomInfos goRoomInfos, boolean bl) {
        this.user = userInfo;
        this.roomInfos = goRoomInfos;
        this.isOnLine = bl;
        this.displayButton.addActionListener(new DisplayListener());
        this.closeButton.addActionListener(new CloseListener());
        this.gradePane = new GoUserInfoList();
        this.gradePane.set(userInfo);
        this.roomPane = new GoUserRoomList();
        this.roomPane.set(goRoomInfos);
        this.split = new JSplitPane(1, this.gradePane, this.roomPane);
        this.split.setDividerLocation(0.7);
        this.buttonPane.add(this.displayButton);
        this.buttonPane.add(this.closeButton);
        this.setLayout(new BorderLayout());
        this.add("North", this.title);
        this.add("Center", this.split);
        this.add("South", this.buttonPane);
        this.addComponentListener(this.seeSize);
        this.setTitleInfo(bl);
    }

    public boolean equals(UserGoInfoPane userGoInfoPane) {
        return userGoInfoPane.user.userName.equals(this.user.userName);
    }

    public String getTitle() {
        return this.user.nameWithGoLevel(Global.lang);
    }

    private void setTitleInfo(boolean bl) {
        for (byte by = 0; by < this.user.go.currentDetial.currentLength; by = (byte)(by + 1)) {
            if (this.user.go.currentDetial.getValue(by) == (byte)GameResult.win.value()) {
                this.title.print(this.title.redBold, Global.lang.getKey("128_win"));
                continue;
            }
            if (this.user.go.currentDetial.getValue(by) == (byte)GameResult.fail.value()) {
                this.title.print(this.title.blueBold, Global.lang.getKey("128_fail"));
                continue;
            }
            if (this.user.go.currentDetial.getValue(by) == (byte)GameResult.peace.value()) {
                this.title.print(this.title.greenPlain, Global.lang.getKey("128_peace"));
                continue;
            }
            if (this.user.go.currentDetial.getValue(by) != (byte)GameResult.resultless.value()) continue;
            this.title.print(this.title.blackPlain, Global.lang.getKey("128_resultless"));
        }
        this.title.print(this.title.blackBold, "   " + Global.lang.getKey("128_invitation") + ":");
        if (this.user.go.isAcceptInvitation) {
            this.title.print(this.title.greenBold, Global.lang.getKey("128_agree"));
        } else {
            this.title.print(this.title.redBold, Global.lang.getKey("128_disagree"));
        }
        this.title.print(this.title.blackBold, "   " + Global.lang.getKey("128_collogue") + ":");
        if (this.user.go.isAcceptPersonMessage) {
            this.title.print(this.title.greenBold, Global.lang.getKey("128_accept"));
        } else {
            this.title.print(this.title.redBold, Global.lang.getKey("128_deny"));
        }
        if (bl) {
            this.title.print(this.title.greenBold, "    " + Global.lang.getKey("128_online"));
        } else {
            this.title.print(this.title.redBold, "    " + Global.lang.getKey("128_downline"));
        }
    }

    public void setFather(TabbedInfoPane tabbedInfoPane) {
        this.father = tabbedInfoPane;
    }

    protected void close() {
        this.father.remove(this);
    }

    private void setAllSize() {
        this.split.setDividerLocation(0.7);
        this.revalidate();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            UserGoInfoPane.this.setAllSize();
        }
    }

    class SetListener
    implements ActionListener {
        SetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new SettingDialog(Global.root, Global.myUserInfo);
        }
    }

    class DisplayListener
    implements ActionListener {
        DisplayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoeSeeGameRecordPane goeSeeGameRecordPane = new GoeSeeGameRecordPane(UserGoInfoPane.this.user);
            if (Global.goRootPane != null) {
                Global.goRootPane.addGoeSeeGameRecordPane(goeSeeGameRecordPane, true);
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.go.getGoGameIndex(UserGoInfoPane.this.user.userName, 100000);
            }
        }
    }

    class CloseListener
    implements ActionListener {
        CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserGoInfoPane.this.close();
        }
    }
}

