/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.phoenix.util.MyProperties;
import org.phoenix.util.RwProperties;
import tianyuan.games.gui.goe.editor.GoEditorBoard;
import tianyuan.games.gui.goe.editor.GoEditorInterface;
import tianyuan.games.gui.goe.editor.GoEditorListener;
import tianyuan.games.gui.goe.editor.GoEditorMainPane;
import tianyuan.games.gui.goe.editor.GoEditorToolBar;
import tianyuan.games.gui.goe.editor.maptree.MapTreeModel;
import tianyuan.games.gui.goe.editor.maptree.QiPu;
import tianyuan.games.gui.goe.goeroom.qp.BoardMouseAdapter;
import tianyuan.games.gui.goe.goeroom.qp.CvsQiPan;
import tianyuan.games.gui.goe.goeroom.qp.QiPanPosition;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;

public class GoEditor
extends JPanel
implements GoEditorInterface {
    public GoEditorMainPane boardMainPane;
    public GoEditorToolBar toolBar;
    GoEditorMouseAdapter mouse;
    GoEditorListener geListener;
    public static MyProperties lang;
    public static RwProperties paramter;
    public static RwProperties paramterLang;
    private boolean isNewDataUnSave = false;

    @Override
    public void setBlackFlag(boolean bl) {
        this.boardMainPane.board.setBlackFlag = bl;
    }

    @Override
    public void insertSubTree() {
        this.boardMainPane.treeMap.insertSubTree();
    }

    @Override
    public void removeSubTree() {
        this.boardMainPane.treeMap.removeSubTree();
    }

    @Override
    public MyProperties getLang() {
        return lang;
    }

    @Override
    public RwProperties getParamter() {
        return paramter;
    }

    @Override
    public void setPath(TreePath treePath, MapTreeModel mapTreeModel) {
        this.boardMainPane.board.setPath(treePath, mapTreeModel);
    }

    @Override
    public void removeMark(int n, int n2) {
        this.boardMainPane.treeMap.removeMark(n, n2);
    }

    @Override
    public void removeQiZi(QiZi qiZi) {
        this.boardMainPane.treeMap.removeQiZi(qiZi);
    }

    @Override
    public int getCount() {
        return this.toolBar.getCount();
    }

    @Override
    public void addCount() {
        this.toolBar.addCount();
    }

    @Override
    public void setNewDataUnSaveFlag(boolean bl) {
        this.isNewDataUnSave = bl;
    }

    public boolean getNewDataUnSaveFlag() {
        return this.isNewDataUnSave;
    }

    public static void init(String string) {
        try {
            paramterLang = new RwProperties("./resource/properties/paramter_lang");
            paramterLang.readIn();
            String string2 = paramterLang.getString("1_filename");
            paramter = new RwProperties("./resource/properties/paramter");
            paramter.readIn();
            FileInputStream fileInputStream = null;
            fileInputStream = string != null ? new FileInputStream("./resource/properties/" + string) : (string2 != null && !string2.equals("") ? new FileInputStream("./resource/properties/" + string2) : new FileInputStream("./resource/properties/lang"));
            lang = new MyProperties(fileInputStream);
            GoEditor.styleSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void styleSet() {
        boolean bl = false;
        try {
            if (bl) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public GoEditor(QiPu qiPu) {
        this.boardMainPane = new GoEditorMainPane(this, 0);
        this.mouse = new GoEditorMouseAdapter(this.boardMainPane.board);
        this.toolBar = new GoEditorToolBar();
        this.toolBar.setEditor(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.boardMainPane, "Center");
        this.setQiPu(qiPu);
    }

    public GoEditor(QiPu qiPu, boolean bl) {
        this.boardMainPane = new GoEditorMainPane(this, " ");
        this.mouse = new GoEditorMouseAdapter(this.boardMainPane.board);
        this.toolBar = new GoEditorToolBar();
        this.toolBar.setEditor(this);
        this.boardMainPane.board.addMouseListener(this.mouse);
        this.mouse.setBoard(this.boardMainPane.board);
        this.mouse.setToolBar(this.toolBar);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.boardMainPane, "Center");
        this.setQiPu(qiPu);
    }

    public GoEditor() {
        this.boardMainPane = new GoEditorMainPane(this, true);
        this.mouse = new GoEditorMouseAdapter(this.boardMainPane.board);
        this.toolBar = new GoEditorToolBar();
        this.toolBar.setEditor(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.boardMainPane, "Center");
    }

    public void setGoEditorListener(GoEditorListener goEditorListener) {
        this.geListener = goEditorListener;
    }

    public GoEditor(GoEditorListener goEditorListener) {
        this.boardMainPane = new GoEditorMainPane(this);
        this.mouse = new GoEditorMouseAdapter(this.boardMainPane.board);
        this.toolBar = new GoEditorToolBar();
        this.toolBar.setEditor(this);
        this.geListener = goEditorListener;
        this.boardMainPane.board.addMouseListener(this.mouse);
        this.mouse.setBoard(this.boardMainPane.board);
        this.mouse.setToolBar(this.toolBar);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.boardMainPane, "Center");
        goEditorListener.setGoEditorTitle("tpweiqi-editor-" + this.boardMainPane.commandPane.getFilename());
    }

    public void quit() {
        this.boardMainPane.commandPane.quit();
    }

    public void enterTestMode() {
        this.mouse.editEnabledFlag = false;
        this.boardMainPane.enterTestMode();
    }

    public void quitTestMode() {
        this.mouse.editEnabledFlag = true;
        this.boardMainPane.quitTestMode();
    }

    public void enterAnalysisMode() {
        this.mouse.editEnabledFlag = false;
        this.boardMainPane.enterAnalysisMode();
        this.toolBar.setAllTipsEnabled(false);
    }

    public void quitAnalysisMode() {
        this.mouse.editEnabledFlag = true;
        this.boardMainPane.quitAnalysisMode();
        this.toolBar.setAllTipsEnabled(true);
    }

    public QiPu getQiPu() {
        return this.boardMainPane.getQiPu();
    }

    public void setQiPu(QiPu qiPu) {
        this.boardMainPane.setQiPu(qiPu);
    }

    public void selectEnd() {
        this.boardMainPane.selectEnd();
    }

    public void clear() {
        this.boardMainPane.clear();
        this.toolBar.clear();
        this.mouse.clear();
        this.setNewDataUnSaveFlag(false);
    }

    class GoEditorMouseAdapter
    extends BoardMouseAdapter {
        boolean editEnabledFlag;
        private GoEditorBoard board;
        private GoEditorToolBar toolBar;

        GoEditorMouseAdapter(CvsQiPan cvsQiPan) {
            super(cvsQiPan);
            this.editEnabledFlag = true;
        }

        @Override
        public void handleClick(MouseEvent mouseEvent) {
            if (!this.editEnabledFlag) {
                return;
            }
            QiPanPosition qiPanPosition = this.board.getPosition(mouseEvent.getX(), mouseEvent.getY());
            if (qiPanPosition == null) {
                return;
            }
            QiZi qiZi = this.board.setPositionAndStatus(qiPanPosition, this.toolBar.getToolBarStatus());
            if (qiZi != null) {
                GoEditor.this.boardMainPane.treeMap.insert(qiZi);
                GoEditor.this.setNewDataUnSaveFlag(true);
            }
        }

        public void setBoard(GoEditorBoard goEditorBoard) {
            this.board = goEditorBoard;
        }

        public void setToolBar(GoEditorToolBar goEditorToolBar) {
            this.toolBar = goEditorToolBar;
        }

        public void clear() {
        }
    }
}

