/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.commonbbs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import tianyuan.games.base.commonbbs.CommonBbsItemInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.commonbbs.CommonBbsMenuTreeNode;
import tianyuan.games.gui.goe.dialog.MyJPanel;
import tianyuan.games.gui.goe.hall.PagePane;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.StaticColor;
import tianyuan.games.gui.goe.table.TableSorter;

public class CommonBbsTopicView
extends MyJPanel {
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm;
    protected CommonBbsTableSorter sorter;
    protected JLabel title = new JLabel("");
    protected CommonBbsPager pagePane = new CommonBbsPager();
    protected JButton quitButton = new JButton(Global.lang.getKey("220_quit"));
    private CommonBbsMenuTreeNode menuKey = null;
    protected String[] columnNames = new String[]{Global.lang.getKey("241_view_number"), Global.lang.getKey("241_view_create_time"), Global.lang.getKey("241_view_flag"), Global.lang.getKey("241_view_author"), Global.lang.getKey("241_view_size"), Global.lang.getKey("241_view_read_counter"), Global.lang.getKey("241_view_title")};
    protected JPopupMenu popup = new JPopupMenu();
    protected DeleteAction deleteAction = null;
    protected ReadAction readAction = null;

    public CommonBbsTopicView(String string) {
        this.mtm = new MyTableModel();
        this.sorter = new CommonBbsTableSorter(this.mtm);
        this.table = new JTable(this.sorter);
        this.table.setSelectionMode(0);
        this.table.setDragEnabled(true);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.setPopupMenu();
        this.table.addMouseListener(new DoubleClickAdapter());
        this.sp = new JScrollPane(this.table);
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.table.setModel(this.sorter);
        this.setTableCellRenderer();
        this.title.setText(string);
        this.quitButton.addActionListener(new QuitListener());
    }

    public void setMenuKey(CommonBbsMenuTreeNode commonBbsMenuTreeNode) {
        this.menuKey = commonBbsMenuTreeNode;
    }

    public String getKey() {
        return this.title.getText();
    }

    public void add(CommonBbsItemInfo commonBbsItemInfo) {
        this.addALine(commonBbsItemInfo);
    }

    protected void addALine(CommonBbsItemInfo commonBbsItemInfo) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(commonBbsItemInfo.itemNumber + 1);
        vector.add(this.toDateStr(commonBbsItemInfo.createTime));
        vector.add(commonBbsItemInfo.flag);
        vector.add(commonBbsItemInfo.author);
        vector.add(commonBbsItemInfo.size);
        vector.add(commonBbsItemInfo.readCounter);
        vector.add(commonBbsItemInfo.title);
        this.mtm.addRow(vector);
    }

    public void del(int n) {
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (Global.lang.getKey("241_view_number").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Integer n3 = (Integer)this.mtm.getValueAt(j, i);
                if (n3 - 1 != n) continue;
                this.mtm.removeRow(j);
                return;
            }
        }
    }

    public void setPage(CommonBbsItemInfo[] commonBbsItemInfoArray, int n) {
        this.delAll();
        this.pagePane.setNumber(n + 1);
        for (int i = 0; i < commonBbsItemInfoArray.length; ++i) {
            this.addALine(commonBbsItemInfoArray[i]);
        }
    }

    private int getSelectNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("241_view_number").equals(this.sorter.getColumnName(i))) continue;
            Integer n3 = (Integer)this.sorter.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    private String getSelectAuthor() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return "";
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("241_view_author").equals(this.sorter.getColumnName(i))) continue;
            String string = (String)this.sorter.getValueAt(n, i);
            return string;
        }
        return "";
    }

    private void delAll() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    private void removeMyselfFromContentPane() {
        Global.commonBbs.removeTopicView(this);
        if (this.menuKey != null) {
            this.menuKey.setTopicView(null);
        }
    }

    protected void setPopupMenu() {
        this.readAction = new ReadAction(this);
        this.deleteAction = new DeleteAction(this);
        this.popup.add(this.readAction);
        this.popup.add(this.deleteAction);
        this.table.addMouseListener(new PopupActionAdapter(this.popup, this.table));
    }

    private void setActionEnabled(boolean bl, boolean bl2) {
        this.deleteAction.setEnabled(bl);
        this.readAction.setEnabled(bl2);
    }

    private void setColumnWidth() {
        TableColumn tableColumn = this.table.getColumn(this.columnNames[0]);
        tableColumn.setPreferredWidth(35);
        tableColumn = this.table.getColumn(this.columnNames[1]);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(this.columnNames[2]);
        tableColumn.setPreferredWidth(35);
        tableColumn = this.table.getColumn(this.columnNames[3]);
        tableColumn.setPreferredWidth(80);
        tableColumn = this.table.getColumn(this.columnNames[4]);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.columnNames[5]);
        tableColumn.setPreferredWidth(35);
        tableColumn = this.table.getColumn(this.columnNames[6]);
        tableColumn.setPreferredWidth(500);
        this.table.doLayout();
    }

    private void setTableCellRenderer() {
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.table.getColumnName(i));
            tableColumn.setCellRenderer(new CommonBbsCellRenderer());
        }
    }

    void deleteOperation() {
        if (Global.netDaemon == null) {
            return;
        }
        Global.netDaemon.commonBbsDelItem(this.getKey(), this.getSelectNumber() - 1);
    }

    void readOperation() {
        if (Global.netDaemon == null) {
            return;
        }
        Global.netDaemon.commonBbsReadItem(this.getKey(), this.getSelectNumber() - 1);
    }

    void answerOperation() {
        if (Global.netDaemon == null) {
            return;
        }
    }

    @Override
    protected void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = dimension.width / 2;
        int n2 = dimension.width - n;
        int n3 = 25;
        this.myAddComp(this.title, 5, 3, n - 6, n3 - 6);
        this.myAddComp(this.pagePane, n + 1 - 60, 0, n2 - 1 - 60, n3);
        this.myAddComp(this.quitButton, n + 1 - 60 + n2 - 1 - 54, 2, 82, n3 - 2);
        this.myAddComp(this.sp, 0, n3 + 1, dimension.width, dimension.height - n3 - 1);
        this.setColumnWidth();
        this.revalidate();
    }

    class CommonBbsCellRenderer
    extends DefaultTableCellRenderer
    implements StaticColor {
        CommonBbsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isHostRecordRow(int n) {
            return false;
        }
    }

    class CommonBbsTableSorter
    extends TableSorter {
        CommonBbsTableSorter(TableModel tableModel) {
            super(tableModel);
        }

        public boolean isHostRecord(int n) {
            return false;
        }

        @Override
        public int compareRowsByColumn(int n, int n2, int n3) {
            TableModel tableModel = this.model;
            if (this.ascending) {
                if (this.isHostRecord(n)) {
                    return -1;
                }
                if (this.isHostRecord(n2)) {
                    return 1;
                }
            } else {
                if (this.isHostRecord(n)) {
                    return 1;
                }
                if (this.isHostRecord(n2)) {
                    return -1;
                }
            }
            return super.compareRowsByColumn(n, n2, n3);
        }
    }

    class AnswerAction
    extends RootAction {
        AnswerAction(CommonBbsTopicView commonBbsTopicView2) {
            super(Global.lang.getKey("220_read"), commonBbsTopicView2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsTopicView.this.answerOperation();
        }
    }

    class ReadAction
    extends RootAction {
        ReadAction(CommonBbsTopicView commonBbsTopicView2) {
            super(Global.lang.getKey("220_read"), commonBbsTopicView2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsTopicView.this.readOperation();
        }
    }

    class DeleteAction
    extends RootAction {
        DeleteAction(CommonBbsTopicView commonBbsTopicView2) {
            super(Global.lang.getKey("220_delete"), commonBbsTopicView2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsTopicView.this.deleteOperation();
        }
    }

    class RootAction
    extends AbstractAction {
        CommonBbsTopicView father;

        RootAction(String string, CommonBbsTopicView commonBbsTopicView2) {
            super(string);
            this.father = commonBbsTopicView2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                CommonBbsTopicView.this.readOperation();
            }
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            boolean bl = false;
            if (Global.isAdmin()) {
                bl = true;
            } else if (Global.myName().equals(CommonBbsTopicView.this.getSelectAuthor())) {
                bl = true;
            }
            CommonBbsTopicView.this.setActionEnabled(bl, true);
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class CommonBbsPager
    extends PagePane {
        CommonBbsPager() {
        }

        @Override
        protected void doOperation(int n) {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.commonBbsGetIndexInTopic(CommonBbsTopicView.this.getKey(), n - 1);
        }
    }

    class QuitListener
    implements ActionListener {
        QuitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsTopicView.this.removeMyselfFromContentPane();
        }
    }
}

