/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.base;

import java.io.IOException;
import java.util.Vector;
import org.phoenix.util.MyProperties;
import tianyuan.games.base.GoGamblingGameInfo;
import tianyuan.games.base.GoGameRecord;
import tianyuan.games.base.GoTmpField;
import tianyuan.games.base.Level;
import tianyuan.games.base.RoomStatus;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserSeeInGameCount;
import tianyuan.games.net.GoServerResponse;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.Room;

public class GoRoom
extends Room {
    private int refCounter = 0;
    public GoGameRecord record = null;
    public GoGamblingGameInfo gamblingInfo = null;
    public String black = "";
    public String white = "";
    public Level blackLevel = new Level();
    public Level whiteLevel = new Level();

    public int refCounterAdd() {
        ++this.refCounter;
        return this.refCounter;
    }

    private void refCounterClear() {
        this.refCounter = 0;
    }

    public boolean isRunner(String string) {
        return string.equals(this.black) || string.equals(this.white);
    }

    public UserAllInfo getBlackInfo() {
        return this.getUser(this.black);
    }

    public UserAllInfo getWhiteInfo() {
        return this.getUser(this.white);
    }

    public void setGameRecord(GoGameRecord goGameRecord) {
        this.record = goGameRecord;
        this.black = goGameRecord.black;
        this.white = goGameRecord.white;
        this.blackLevel = goGameRecord.blackLevel;
        this.whiteLevel = goGameRecord.whiteLevel;
    }

    public String blackNameWithLevel(MyProperties myProperties) {
        return this.black + "[" + this.blackLevel.toString(myProperties) + "]";
    }

    public String blackNameWithLevel2(MyProperties myProperties) {
        return this.black + " " + this.blackLevel.toString(myProperties) + " ";
    }

    public String whiteNameWithLevel(MyProperties myProperties) {
        return this.white + "[" + this.whiteLevel.toString(myProperties) + "]";
    }

    public String whiteNameWithLevel2(MyProperties myProperties) {
        return this.white + " " + this.whiteLevel.toString(myProperties) + " ";
    }

    public String blackOrWhiteNameWithLevel(String string, MyProperties myProperties) {
        if (string.equals(this.black)) {
            return this.blackNameWithLevel(myProperties);
        }
        if (string.equals(this.white)) {
            return this.whiteNameWithLevel(myProperties);
        }
        return string;
    }

    public UserInfo getBlackInfoOnServer() {
        return this.searchInfoOnServer(this.black);
    }

    public UserInfo getWhiteInfoOnServer() {
        return this.searchInfoOnServer(this.white);
    }

    public String getNameWithLevel(String string, MyProperties myProperties) {
        for (UserAllInfo userAllInfo : this.userinfos) {
            if (!userAllInfo.info.userName.equals(string)) continue;
            return userAllInfo.info.nameWithGoLevel(myProperties);
        }
        return string;
    }

    public boolean isPlaying() {
        if (this.record == null) {
            return false;
        }
        return this.status.getValue() != 1 && this.status.getValue() != 3;
    }

    public RoomStatus getStatus() {
        return this.status;
    }

    public ServerResponse setStatusOnServer(RoomStatus roomStatus) {
        this.refCounterClear();
        boolean bl = this.isPlaying();
        this.status.setValue(roomStatus.getValue());
        boolean bl2 = this.isPlaying();
        if (bl == bl2) {
            return null;
        }
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.type = (byte)70;
        serverResponse.goResponse = new GoServerResponse();
        serverResponse.goResponse.type = (byte)47;
        serverResponse.goResponse.blockUserSeeInGameCount = new Vector();
        for (ClientAdapter clientAdapter : this.members) {
            if (bl) {
                clientAdapter.tmpInfo.go.removeGoRoom(this.roomNumber);
                clientAdapter.tmpInfo.go.addIdleGameRoom(this);
            } else {
                clientAdapter.tmpInfo.go.removeGoRoom(this.roomNumber);
                if (this.isRunner(clientAdapter.info.userName)) {
                    clientAdapter.tmpInfo.go.addInGameRoom(this);
                } else {
                    clientAdapter.tmpInfo.go.addSeeGameRoom(this);
                }
            }
            UserSeeInGameCount userSeeInGameCount = new UserSeeInGameCount(clientAdapter.info.userName, (byte)clientAdapter.tmpInfo.go.inGame.size(), (byte)clientAdapter.tmpInfo.go.seeGame.size());
            serverResponse.goResponse.blockUserSeeInGameCount.add(userSeeInGameCount);
        }
        return serverResponse;
    }

    private void modifyAdapterGoTmpInfoForGoInOnServer(String string, GoTmpField goTmpField) {
        if (this.isPlaying()) {
            if (this.isRunner(string)) {
                goTmpField.addInGameRoom(this);
            } else {
                goTmpField.addSeeGameRoom(this);
            }
        } else {
            goTmpField.addIdleGameRoom(this);
        }
    }

    public boolean goInAndModifyAdapterGoTmpInfo(ClientAdapter clientAdapter) {
        for (ClientAdapter clientAdapter2 : this.members) {
            if (clientAdapter2.info == null || !clientAdapter2.info.userName.equals(clientAdapter.info.userName)) continue;
            this.members.remove(clientAdapter2);
            this.members.add(clientAdapter);
            this.modifyAdapterGoTmpInfoForGoInOnServer(clientAdapter.info.userName, clientAdapter.tmpInfo.go);
            return false;
        }
        this.members.add(clientAdapter);
        this.modifyAdapterGoTmpInfoForGoInOnServer(clientAdapter.info.userName, clientAdapter.tmpInfo.go);
        return true;
    }

    public boolean goOutAndModifyAdapterGoTmpInfo(ClientAdapter clientAdapter) {
        for (ClientAdapter clientAdapter2 : this.members) {
            if (!clientAdapter2.getName().equals(clientAdapter.info.userName)) continue;
            this.members.remove(clientAdapter2);
            clientAdapter2.tmpInfo.go.removeGoRoom(this.roomNumber);
            return true;
        }
        return false;
    }

    @Override
    public void writeHead(TyBaseOutput tyBaseOutput) throws IOException {
        super.writeHead(tyBaseOutput);
        tyBaseOutput.writeUTF(this.black);
        tyBaseOutput.writeUTF(this.white);
        this.blackLevel.write(tyBaseOutput);
        this.whiteLevel.write(tyBaseOutput);
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        super.writeMeat(tyBaseOutput);
        tyBaseOutput.writeUTF(this.black);
        tyBaseOutput.writeUTF(this.white);
        this.blackLevel.write(tyBaseOutput);
        this.whiteLevel.write(tyBaseOutput);
        if (this.record == null) {
            this.record = new GoGameRecord();
        }
        this.record.write(tyBaseOutput);
        if (this.gamblingInfo == null) {
            this.gamblingInfo = new GoGamblingGameInfo();
        }
        this.gamblingInfo.write(tyBaseOutput);
    }

    @Override
    public void readHead(TyBaseInput tyBaseInput) throws IOException {
        super.readHead(tyBaseInput);
        this.black = tyBaseInput.readUTF();
        this.white = tyBaseInput.readUTF();
        this.blackLevel.read(tyBaseInput);
        this.whiteLevel.read(tyBaseInput);
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        super.readMeat(tyBaseInput);
        this.black = tyBaseInput.readUTF();
        this.white = tyBaseInput.readUTF();
        this.blackLevel.read(tyBaseInput);
        this.whiteLevel.read(tyBaseInput);
        this.record = new GoGameRecord();
        this.record.read(tyBaseInput);
        this.gamblingInfo = new GoGamblingGameInfo();
        this.gamblingInfo.read(tyBaseInput);
    }
}

