/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.sgf;

import java.io.File;
import java.io.FileReader;
import tianyuan.games.sgf.SgfAction;
import tianyuan.games.sgf.SgfActions;
import tianyuan.games.sgf.SgfNode;
import tianyuan.games.sgf.SgfSubAction;

public class SgfParse {
    public static void main(String[] stringArray) {
        String string = SgfParse.readSgfFile(new File(stringArray[0]));
        SgfNode sgfNode = SgfParse.createTree(string);
    }

    public static String readSgfFile(File file) {
        StringBuilder stringBuilder = new StringBuilder("");
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            boolean bl = false;
            while ((n = fileReader.read()) >= 0) {
                char c = (char)n;
                if (c == '[') {
                    bl = true;
                } else if (c == ']') {
                    bl = false;
                }
                if (!bl && (Character.isISOControl(n) || Character.isSpaceChar(n))) continue;
                stringBuilder.append(c);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static SgfNode createTree(String string) {
        SgfNode sgfNode = new SgfNode();
        boolean bl = false;
        boolean bl2 = false;
        SgfNode sgfNode2 = sgfNode;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                if (bl) continue;
                if (!bl2) {
                    bl2 = true;
                    sgfNode.startPosition = i;
                    continue;
                }
                SgfNode sgfNode3 = new SgfNode();
                sgfNode3.startPosition = i;
                sgfNode3.setParent(sgfNode2);
                sgfNode2.addChild(sgfNode3);
                sgfNode2 = sgfNode3;
                continue;
            }
            if (c == ')') {
                if (bl) continue;
                sgfNode2.endPosition = i;
                if (!sgfNode2.hasParsed) {
                    SgfParse.parseNode(sgfNode2, string);
                    sgfNode2.hasParsed = true;
                }
                if (sgfNode2 == sgfNode) continue;
                sgfNode2 = sgfNode2.getParent();
                continue;
            }
            if (c == '[') {
                bl = true;
                continue;
            }
            if (c != ']') continue;
            bl = false;
        }
        return sgfNode;
    }

    public static void parseNode(SgfNode sgfNode, String string) {
        char c;
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        for (n = sgfNode.startPosition + 1; n <= sgfNode.endPosition; ++n) {
            c = string.charAt(n);
            if (c == '[') {
                bl = true;
            } else if (c == ']') {
                bl = false;
            }
            if (bl) continue;
            if (c == ';' && n3 == -1) {
                n3 = n;
            } else if (c == '(' && n4 == -1) {
                n4 = n;
            }
            if (n3 != -1 && n4 != -1) break;
        }
        if (n3 == -1) {
            n3 = sgfNode.startPosition + 1;
        }
        if (n4 == -1) {
            n4 = sgfNode.endPosition;
        }
        sgfNode.content = string.substring(n3, n4 + 1);
        bl = false;
        for (n = 0; n < sgfNode.content.length(); ++n) {
            c = sgfNode.content.charAt(n);
            if (c == ';' || c == ')' || c == '(') {
                if (bl || n - n2 < 2) continue;
                SgfActions sgfActions = new SgfActions(n2, n);
                SgfParse.parseActions(sgfActions, sgfNode.content);
                sgfNode.addActions(sgfActions);
                n2 = n;
                continue;
            }
            if (c == '[') {
                bl = true;
                continue;
            }
            if (c != ']') continue;
            bl = false;
        }
    }

    public static void parseActions(SgfActions sgfActions, String string) {
        int n = 40;
        int n2 = 0;
        SgfAction sgfAction = null;
        for (int i = sgfActions.startPosition; i <= sgfActions.endPosition; ++i) {
            char c = string.charAt(i);
            if (c == ';') {
                n = c;
                n2 = i;
                continue;
            }
            if (c == '[') {
                if (i - n2 > 1 && (n == 59 || n == 93)) {
                    sgfAction = sgfActions.addAction();
                    sgfAction.setFlag(string.substring(n2 + 1, i));
                }
                n = c;
                n2 = i;
                continue;
            }
            if (c != ']') continue;
            if (i - n2 > 1 && n == 91 && sgfAction != null) {
                sgfAction.add(new SgfSubAction(string.substring(n2 + 1, i)));
            }
            n = c;
            n2 = i;
        }
    }
}

