/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.util.Enumeration;
import java.util.Vector;
import tianyuan.games.base.GoRoom;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.server.BbsDataAdapter;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.LoginAdapter;
import tianyuan.games.net.server.Room;
import tianyuan.games.net.server.RoomNumberManager;

class ProcessRoot {
    protected Vector<ClientAdapter> waitLogin;
    protected Vector<ClientAdapter> onLine;
    protected Vector<ClientAdapter> breakLine;
    protected Vector<GoRoom> rooms;
    protected RoomNumberManager roomNumberManager;
    protected LoginAdapter login;
    protected BbsDataAdapter bbsAdapter;

    ProcessRoot(Vector<ClientAdapter> vector, Vector<ClientAdapter> vector2, Vector<ClientAdapter> vector3, Vector<GoRoom> vector4, RoomNumberManager roomNumberManager, LoginAdapter loginAdapter, BbsDataAdapter bbsDataAdapter) {
        this.waitLogin = vector;
        this.onLine = vector2;
        this.breakLine = vector3;
        this.rooms = vector4;
        this.roomNumberManager = roomNumberManager;
        this.login = loginAdapter;
        this.bbsAdapter = bbsDataAdapter;
    }

    protected ClientAdapter search(Vector<ClientAdapter> vector, String string) {
        Enumeration<ClientAdapter> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ClientAdapter clientAdapter = enumeration.nextElement();
            if (!clientAdapter.isSameUser(string)) continue;
            return clientAdapter;
        }
        return null;
    }

    protected GoRoom search(Vector<GoRoom> vector, int n) {
        Enumeration<GoRoom> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GoRoom goRoom = enumeration.nextElement();
            if (goRoom.roomNumber != n) continue;
            return goRoom;
        }
        return null;
    }

    public void sendToEveryUser(ServerResponse serverResponse) {
        Enumeration<ClientAdapter> enumeration = this.onLine.elements();
        while (enumeration.hasMoreElements()) {
            ClientAdapter clientAdapter = enumeration.nextElement();
            clientAdapter.put(serverResponse);
        }
    }

    public void sendToRoom(ServerResponse serverResponse, int n) {
        Enumeration<GoRoom> enumeration = this.rooms.elements();
        while (enumeration.hasMoreElements()) {
            Room room = enumeration.nextElement();
            if (room.roomNumber != n) continue;
            room.sendRoomInfo(serverResponse);
            break;
        }
    }

    public void sendToUser(ServerResponse serverResponse, String string) {
        Enumeration<ClientAdapter> enumeration = this.onLine.elements();
        while (enumeration.hasMoreElements()) {
            ClientAdapter clientAdapter = enumeration.nextElement();
            if (!clientAdapter.info.userName.equals(string)) continue;
            clientAdapter.put(serverResponse);
            break;
        }
    }

    public void sendToNetManager(ServerResponse serverResponse) {
        Enumeration<ClientAdapter> enumeration = this.onLine.elements();
        while (enumeration.hasMoreElements()) {
            ClientAdapter clientAdapter = enumeration.nextElement();
            if (!clientAdapter.info.adminField.isNetManager) continue;
            clientAdapter.put(serverResponse);
        }
    }
}

