/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import tianyuan.games.base.AdminField;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseInputRandomAccessFile;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.base.TyBaseOutputRandomAccessFile;
import tianyuan.games.base.UserInfo;
import tianyuan.games.net.server.ServerGlobal;

class NewUserTable {
    private Stack<Integer> beDeletedUserNumbers = new Stack();
    private String fileName = ServerGlobal.pathOfUserTable + "usrtable.tpdb";
    private Hashtable<String, UserInfo> mem = new Hashtable();
    RandomAccessFile handler;
    TyBaseInput input;
    TyBaseOutput output;
    static final int UNIT_SIZE = 5120;
    static final int PAGE_SIZE = 100;
    static final int USER_EXIST = 1;
    static final int USER_DEL = 0;

    public NewUserTable() {
        this.initAndOpenFile();
        this.loadIntoMemFromFile();
    }

    void close() {
        try {
            this.handler.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean addUser(UserInfo userInfo) {
        UserInfo userInfo2 = this.mem.get(userInfo.userName);
        if (userInfo2 != null) {
            return false;
        }
        if (this.mem.size() == 0) {
            if (userInfo.adminField == null) {
                userInfo.adminField = new AdminField();
            }
            userInfo.adminField.isNetManager = true;
        }
        try {
            int n = this.getUserNumber();
            if (n >= 0) {
                userInfo.userNumber = n;
                this.mem.put(userInfo.userName, userInfo);
                this.handler.seek(n * 5120);
                this.output.writeInt(1);
                userInfo.write(this.output);
            } else {
                int n2;
                long l = this.handler.length();
                userInfo.userNumber = n2 = (int)(l / 5120L);
                this.mem.put(userInfo.userName, userInfo);
                this.handler.seek(l);
                this.output.writeInt(1);
                userInfo.write(this.output);
                this.handler.setLength(l + 5120L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private int getUserNumber() {
        if (this.beDeletedUserNumbers.empty()) {
            return -1;
        }
        Integer n = this.beDeletedUserNumbers.pop();
        return n;
    }

    private void pushUserNumber(int n) {
        this.beDeletedUserNumbers.push(new Integer(n));
    }

    UserInfo search(String string) {
        if (this.mem.size() <= 0) {
            return null;
        }
        UserInfo userInfo = this.mem.get(string);
        return userInfo;
    }

    boolean del(String string) {
        UserInfo userInfo = this.mem.remove(string);
        try {
            if (userInfo != null) {
                this.handler.seek(userInfo.userNumber * 5120);
                this.output.writeInt(0);
                this.pushUserNumber(userInfo.userNumber);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return userInfo != null;
    }

    boolean modify(UserInfo userInfo) {
        String string = new String(userInfo.userName);
        UserInfo userInfo2 = this.mem.remove(string);
        if (userInfo2 != null) {
            userInfo.userNumber = userInfo2.userNumber;
            this.mem.put(string, userInfo);
            try {
                this.handler.seek(userInfo2.userNumber * 5120);
                this.output.writeInt(1);
                userInfo.write(this.output);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }

    Vector<UserInfo> getAll() {
        Vector<UserInfo> vector = new Vector<UserInfo>();
        Enumeration<UserInfo> enumeration = this.mem.elements();
        while (enumeration.hasMoreElements()) {
            UserInfo userInfo = enumeration.nextElement();
            vector.add(userInfo);
        }
        return vector;
    }

    int getSize() {
        return this.mem.size();
    }

    int getPage(int n, Vector<UserInfo> vector) {
        try {
            int n2;
            int n3 = n;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 * 100 >= (n2 = (int)(this.handler.length() / 5120L))) {
                n3 = n2 / 100;
            }
            for (int i = n3 * 100; i < (n3 + 1) * 100 && i < n2; ++i) {
                this.handler.seek(i * 5120);
                UserInfo userInfo = new UserInfo();
                int n4 = this.input.readInt();
                userInfo.read(this.input);
                if (n4 != 1) continue;
                vector.add(userInfo);
            }
            return n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    private void loadIntoMemFromFile() {
        try {
            int n = (int)(this.handler.length() / 5120L);
            for (long i = 0L; i < (long)n; ++i) {
                this.handler.seek(i * 5120L);
                int n2 = this.input.readInt();
                UserInfo userInfo = new UserInfo();
                userInfo.read(this.input);
                if (n2 == 1) {
                    this.mem.put(userInfo.userName, userInfo);
                    continue;
                }
                this.pushUserNumber(userInfo.userNumber);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initAndOpenFile() {
        try {
            File file = new File(this.fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            this.handler = new RandomAccessFile(file, "rwd");
            this.input = new TyBaseInputRandomAccessFile(this.handler);
            this.output = new TyBaseOutputRandomAccessFile(this.handler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

