/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;
import tianyuan.games.base.BbsTopics;
import tianyuan.games.base.TyBaseInputRandomAccessFile;
import tianyuan.games.base.TyBaseOutputRandomAccessFile;
import tianyuan.games.base.commonbbs.CommonBbsDataRequest;
import tianyuan.games.base.commonbbs.CommonBbsItem;
import tianyuan.games.base.commonbbs.CommonBbsItemInfo;
import tianyuan.games.base.commonbbs.CommonBbsResultData;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.CommonBbsDataCommand;
import tianyuan.games.net.server.CommonBbsDataResult;
import tianyuan.games.net.server.ServerGlobal;

class CommonBbsDataAdapter {
    private String pathOfStorageCommonBbsData = ServerGlobal.pathOfStorageCommonBbsData;
    private static final String HEAD = ".head";
    private static final String BODY = ".body";
    private static final int HEAD_ITEM_MAX_LENGTH = 500;
    private static final int HEAD_HEAD_LENGTH = 12;
    private static final int BODY_HEAD_LENGTH = 12;
    private static final byte RECORD_USED = 1;
    private static final byte RECORD_DELETE = 2;
    private static final int PAGE_SIZE = 20;
    private static final int HEAD_ITEM_PRESEVING_AREA_LENGTH = 20;
    private BbsTopics topics = new BbsTopics();
    private Vector<CommonBbsDataCommand> outQueue = new Vector();
    private Vector<CommonBbsDataResult> inQueue = new Vector();
    private output to;
    private static String tmpTopicName = "asdfgh_tmp_topic";

    CommonBbsDataAdapter() {
        this.pathOfStorageCommonBbsData = ServerGlobal.pathOfStorageCommonBbsData;
        this.to = new output();
        this.to.start();
        this.getAllTopic(null);
    }

    CommonBbsDataAdapter(String string) {
        this.pathOfStorageCommonBbsData = string;
        this.to = new output();
        this.to.start();
        this.getAllTopic(null);
    }

    public void putRequest(CommonBbsDataRequest commonBbsDataRequest, ClientAdapter clientAdapter) {
        CommonBbsDataCommand commonBbsDataCommand = new CommonBbsDataCommand();
        commonBbsDataCommand.client = clientAdapter;
        commonBbsDataCommand.request = commonBbsDataRequest;
        this.put(commonBbsDataCommand);
    }

    private synchronized CommonBbsDataCommand getFromOutQueue() {
        while (true) {
            try {
                while (this.outQueue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        CommonBbsDataCommand commonBbsDataCommand = this.outQueue.firstElement();
        this.outQueue.remove(commonBbsDataCommand);
        return commonBbsDataCommand;
    }

    public synchronized CommonBbsDataResult get() {
        if (this.inQueue.isEmpty()) {
            return null;
        }
        CommonBbsDataResult commonBbsDataResult = this.inQueue.firstElement();
        this.inQueue.remove(commonBbsDataResult);
        return commonBbsDataResult;
    }

    private synchronized void put(CommonBbsDataCommand commonBbsDataCommand) {
        this.outQueue.add(commonBbsDataCommand);
        this.notify();
    }

    private synchronized void putToInQueue(CommonBbsDataResult commonBbsDataResult) {
        if (commonBbsDataResult != null) {
            this.inQueue.add(commonBbsDataResult);
        }
    }

    public synchronized BbsTopics getAllTopics() {
        return this.topics.getCopy();
    }

    public void createUserBbsResource(String string) {
    }

    public void freeUserBbsResource(String string) {
    }

    public void updateTopic() {
        this.getAllTopic(null);
    }

    private synchronized void updateTopic(String[] stringArray) {
        this.topics.set(stringArray);
    }

    private void getAllTopic(ClientAdapter clientAdapter) {
        try {
            File file = new File(this.pathOfStorageCommonBbsData);
            String[] stringArray = file.list();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(HEAD)) continue;
                ++n;
            }
            String[] stringArray2 = new String[n];
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (!stringArray[i].endsWith(HEAD)) continue;
                stringArray2[n2] = string = stringArray[i].substring(0, stringArray[i].length() - HEAD.length());
                ++n2;
            }
            if (clientAdapter == null) {
                this.updateTopic(stringArray2);
                return;
            }
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = (byte)6;
            commonBbsDataResult.result.allTopic = stringArray2;
            this.putToInQueue(commonBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void createTopic(String string, ClientAdapter clientAdapter) {
        try {
            File file = new File(this.pathOfStorageCommonBbsData + string + BODY);
            file.createNewFile();
            File file2 = new File(this.pathOfStorageCommonBbsData + string + HEAD);
            file2.createNewFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + HEAD, "rw");
            randomAccessFile.writeInt(0);
            randomAccessFile.writeLong(0L);
            randomAccessFile.close();
            this.getAllTopic(null);
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = 1;
            commonBbsDataResult.result.topicName = string;
            this.putToInQueue(commonBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delTopic(String string, ClientAdapter clientAdapter) {
        try {
            File file;
            File file2 = new File(this.pathOfStorageCommonBbsData + string + BODY);
            if (file2.exists() && !file2.delete()) {
                System.out.println("delete file fail :" + file2.toString());
            }
            if ((file = new File(this.pathOfStorageCommonBbsData + string + HEAD)).exists() && !file.delete()) {
                System.out.println("delete file fail :" + file.toString());
            }
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = (byte)2;
            commonBbsDataResult.result.topicName = string;
            this.putToInQueue(commonBbsDataResult);
            this.getAllTopic(null);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private boolean isTopicExists(String string) {
        try {
            File file = new File(this.pathOfStorageCommonBbsData + string + BODY);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
            file = new File(this.pathOfStorageCommonBbsData + string + HEAD);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
        return true;
    }

    private void addItem(CommonBbsItem commonBbsItem, String string, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + BODY, "rw");
            long l = randomAccessFile.length();
            randomAccessFile.seek(l);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            commonBbsItem.writeBody(tyBaseOutputRandomAccessFile);
            long l2 = randomAccessFile.getFilePointer() - l;
            randomAccessFile.close();
            CommonBbsItemInfo commonBbsItemInfo = commonBbsItem.info;
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + HEAD, "rw");
            long l3 = randomAccessFile2.length();
            long l4 = (l3 - 12L) / 500L;
            randomAccessFile2.setLength(l3 + 500L);
            randomAccessFile2.seek(l3);
            randomAccessFile2.writeByte(1);
            randomAccessFile2.writeLong(l);
            randomAccessFile2.writeLong(l2);
            randomAccessFile2.seek(l3 + 20L);
            commonBbsItemInfo.itemNumber = (int)l4;
            commonBbsItemInfo.createTime = System.currentTimeMillis();
            commonBbsItemInfo.size = (int)l2;
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
            commonBbsItemInfo.write(tyBaseOutputRandomAccessFile2);
            randomAccessFile2.setLength(l3 + 500L);
            randomAccessFile2.close();
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = (byte)3;
            commonBbsDataResult.result.topicName = string;
            commonBbsDataResult.result.itemInfo = commonBbsItemInfo;
            this.putToInQueue(commonBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delItem(String string, int n, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            int n2 = 0;
            long l = 0L;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + HEAD, "rw");
            randomAccessFile.seek(0L);
            n2 = randomAccessFile.readInt();
            l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500);
            randomAccessFile.writeByte(2);
            randomAccessFile.seek(12 + n * 500 + 9);
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(++n2);
            randomAccessFile.writeLong(l += randomAccessFile.readLong());
            randomAccessFile.close();
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = (byte)4;
            commonBbsDataResult.result.topicName = string;
            commonBbsDataResult.result.commonBbsItemNumber = n;
            this.putToInQueue(commonBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void getItem(String string, int n, ClientAdapter clientAdapter) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + HEAD, "rw");
            if (randomAccessFile.length() < (long)(12 + n * 500 + 1)) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500 + 1);
            long l = randomAccessFile.readLong();
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            randomAccessFile.seek(12 + n * 500 + 20);
            CommonBbsItemInfo commonBbsItemInfo = new CommonBbsItemInfo();
            commonBbsItemInfo.read(tyBaseInputRandomAccessFile);
            ++commonBbsItemInfo.readCounter;
            randomAccessFile.seek(12 + n * 500 + 20);
            commonBbsItemInfo.write(tyBaseOutputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            CommonBbsItem commonBbsItem = new CommonBbsItem();
            commonBbsItem.readBody(tyBaseInputRandomAccessFile2);
            commonBbsItem.info = commonBbsItemInfo;
            randomAccessFile2.close();
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = (byte)5;
            commonBbsDataResult.result.topicName = string;
            commonBbsDataResult.result.commonBbsData = commonBbsItem;
            commonBbsDataResult.result.commonBbsItemNumber = n;
            this.putToInQueue(commonBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void getTopicItemIndex(String string, int n, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            int n2;
            Vector<CommonBbsItemInfo> vector = new Vector<CommonBbsItemInfo>();
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + HEAD, "r");
            }
            catch (Exception exception) {
                return;
            }
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            int n3 = (int)((randomAccessFile.length() - 12L) / 500L);
            if (n < 0) {
                n = 0;
            }
            if (n > 10000000) {
                n = 10000000;
            }
            if (n * 20 >= n3) {
                n = (n3 - 1) / 20;
            }
            for (int i = n * 20; i < (n + 1) * 20 && i < n3; ++i) {
                randomAccessFile.seek(12 + i * 500);
                n2 = randomAccessFile.readByte();
                if (n2 == 2) continue;
                randomAccessFile.seek(12 + i * 500 + 20);
                CommonBbsItemInfo commonBbsItemInfo = new CommonBbsItemInfo();
                commonBbsItemInfo.read(tyBaseInputRandomAccessFile);
                vector.add(commonBbsItemInfo);
            }
            randomAccessFile.close();
            CommonBbsItemInfo[] commonBbsItemInfoArray = new CommonBbsItemInfo[vector.size()];
            for (n2 = 0; n2 < commonBbsItemInfoArray.length; ++n2) {
                commonBbsItemInfoArray[n2] = (CommonBbsItemInfo)vector.elementAt(n2);
            }
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = (byte)7;
            commonBbsDataResult.result.topicName = string;
            commonBbsDataResult.result.index = commonBbsItemInfoArray;
            commonBbsDataResult.result.pageNumber = n;
            this.putToInQueue(commonBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void freeAllTopicBeDeletedSpace() {
        this.getAllTopic(null);
        Vector<String> vector = this.topics.getAll();
        for (String string : vector) {
            this.freeTopicBeDeletedSpace(string);
        }
    }

    private void freeTopicBeDeletedSpace(String string) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            File file = new File(this.pathOfStorageCommonBbsData + tmpTopicName + BODY);
            file.createNewFile();
            File file2 = new File(this.pathOfStorageCommonBbsData + tmpTopicName + HEAD);
            file2.createNewFile();
            File file3 = new File(this.pathOfStorageCommonBbsData + string + HEAD);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file3, "r");
            File file4 = new File(this.pathOfStorageCommonBbsData + string + BODY);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(file4, "r");
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.pathOfStorageCommonBbsData + tmpTopicName + HEAD, "rw");
            randomAccessFile3.writeInt(0);
            randomAccessFile3.writeLong(0L);
            RandomAccessFile randomAccessFile4 = new RandomAccessFile(this.pathOfStorageCommonBbsData + tmpTopicName + BODY, "rw");
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile3);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile4);
            CommonBbsItemInfo commonBbsItemInfo = new CommonBbsItemInfo();
            CommonBbsItem commonBbsItem = new CommonBbsItem();
            int n = 0;
            int n2 = 0;
            while ((long)n2 < randomAccessFile.length() / 500L) {
                randomAccessFile.seek(12 + n2 * 500);
                byte by = randomAccessFile.readByte();
                if (by != 2) {
                    long l = randomAccessFile.readLong();
                    long l2 = randomAccessFile.readLong();
                    l = file.length();
                    randomAccessFile2.seek(l);
                    commonBbsItem.readBody(tyBaseInputRandomAccessFile2);
                    commonBbsItem.writeBody(tyBaseOutputRandomAccessFile2);
                    l2 = file.length();
                    randomAccessFile.seek(12 + n2 * 500 + 20);
                    commonBbsItemInfo.read(tyBaseInputRandomAccessFile);
                    commonBbsItemInfo.itemNumber = n++;
                    long l3 = randomAccessFile3.length();
                    randomAccessFile3.seek(randomAccessFile3.length());
                    randomAccessFile3.writeByte(1);
                    randomAccessFile3.writeLong(l);
                    randomAccessFile3.writeLong(l2);
                    randomAccessFile3.writeByte(0);
                    randomAccessFile3.writeByte(0);
                    randomAccessFile3.writeByte(0);
                    commonBbsItemInfo.write(tyBaseOutputRandomAccessFile);
                    randomAccessFile3.setLength(l3 + 500L);
                }
                ++n2;
            }
            randomAccessFile.close();
            randomAccessFile2.close();
            file3.delete();
            file4.delete();
            randomAccessFile3.close();
            randomAccessFile4.close();
            file2.renameTo(file3);
            file.renameTo(file4);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void copyItem(String string, String string2, int n, ClientAdapter clientAdapter) {
        if (n < 0) {
            return;
        }
        if (!this.isTopicExists(string)) {
            return;
        }
        if (!this.isTopicExists(string2)) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + HEAD, "rw");
            if (randomAccessFile.length() / 500L < (long)n) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500);
            byte by = randomAccessFile.readByte();
            if (by == 2) {
                randomAccessFile.close();
                return;
            }
            long l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500 + 20);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            CommonBbsItemInfo commonBbsItemInfo = new CommonBbsItemInfo();
            commonBbsItemInfo.read(tyBaseInputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageCommonBbsData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            CommonBbsItem commonBbsItem = new CommonBbsItem();
            commonBbsItem.read(tyBaseInputRandomAccessFile2);
            randomAccessFile2.close();
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.pathOfStorageCommonBbsData + string2 + BODY, "rw");
            long l2 = randomAccessFile3.length();
            randomAccessFile3.seek(l2);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile3);
            commonBbsItem.write(tyBaseOutputRandomAccessFile);
            long l3 = randomAccessFile3.getFilePointer() - l2;
            randomAccessFile3.close();
            RandomAccessFile randomAccessFile4 = new RandomAccessFile(this.pathOfStorageCommonBbsData + string2 + HEAD, "rw");
            long l4 = randomAccessFile4.length();
            long l5 = (l4 - 12L) / 500L;
            commonBbsItemInfo.itemNumber = (int)l5;
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.seek(l4);
            randomAccessFile4.writeByte(1);
            randomAccessFile4.writeLong(l2);
            randomAccessFile4.writeLong(l3);
            randomAccessFile4.seek(l4 + 20L);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile4);
            commonBbsItemInfo.write(tyBaseOutputRandomAccessFile2);
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.close();
            CommonBbsDataResult commonBbsDataResult = new CommonBbsDataResult();
            commonBbsDataResult.result = new CommonBbsResultData();
            commonBbsDataResult.client = clientAdapter;
            commonBbsDataResult.result.type = (byte)3;
            commonBbsDataResult.result.topicName = string2;
            commonBbsDataResult.result.itemInfo = commonBbsItemInfo;
            this.putToInQueue(commonBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private class output
    extends Thread {
        private CommonBbsDataCommand command;

        private output() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.command = CommonBbsDataAdapter.this.getFromOutQueue();
                        if (this.command == null) {
                            output.sleep(100L);
                            continue;
                        }
                        if (!this.centerSwitch()) break;
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private boolean centerSwitch() {
            if (this.command.type == 1) {
                return false;
            }
            if (this.command.type == 0) {
                // empty if block
            }
            switch (this.command.request.type) {
                case 1: {
                    CommonBbsDataAdapter.this.createTopic(this.command.request.topicName, this.command.client);
                    break;
                }
                case 2: {
                    CommonBbsDataAdapter.this.delTopic(this.command.request.topicName, this.command.client);
                    break;
                }
                case 3: {
                    CommonBbsDataAdapter.this.addItem(this.command.request.item, this.command.request.topicName, this.command.client);
                    break;
                }
                case 4: {
                    CommonBbsDataAdapter.this.delItem(this.command.request.topicName, this.command.request.itemNumber, this.command.client);
                    break;
                }
                case 5: {
                    CommonBbsDataAdapter.this.getItem(this.command.request.topicName, this.command.request.itemNumber, this.command.client);
                    break;
                }
                case 6: {
                    CommonBbsDataAdapter.this.getAllTopic(this.command.client);
                    break;
                }
                case 7: {
                    CommonBbsDataAdapter.this.getTopicItemIndex(this.command.request.topicName, this.command.request.pageNumber, this.command.client);
                    break;
                }
                case 8: {
                    CommonBbsDataAdapter.this.copyItem(this.command.request.sourceTopicName, this.command.request.destTopicName, this.command.request.itemNumber, this.command.client);
                    break;
                }
                case 9: {
                    CommonBbsDataAdapter.this.freeAllTopicBeDeletedSpace();
                }
            }
            return true;
        }
    }
}

