/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;
import tianyuan.games.base.BbsTopics;
import tianyuan.games.base.GoBbsData;
import tianyuan.games.base.GoBbsDataRequest;
import tianyuan.games.base.GoQiPu;
import tianyuan.games.base.GoQiPuInfo;
import tianyuan.games.base.TpMoney;
import tianyuan.games.base.TyBaseInputRandomAccessFile;
import tianyuan.games.base.TyBaseOutputRandomAccessFile;
import tianyuan.games.net.server.ClientAdapter;
import tianyuan.games.net.server.GoBbsDataCommand;
import tianyuan.games.net.server.GoBbsDataResult;
import tianyuan.games.net.server.ServerGlobal;
import tianyuan.games.net.server.UserAndMoneyOperation;

class BbsDataAdapter {
    private String pathOfStorageGoBbsData = ServerGlobal.pathOfStorageGoBbsData;
    private String pathOfStorageGoBbsUserData = ServerGlobal.pathOfStorageGoBbsUserData;
    private static final String HEAD = ".head";
    private static final String BODY = ".body";
    private static final int HEAD_ITEM_MAX_LENGTH = 500;
    private static final int HEAD_HEAD_LENGTH = 12;
    private static final int BODY_HEAD_LENGTH = 12;
    private static final byte RECORD_USED = 1;
    private static final byte RECORD_DELETE = 2;
    private static final int PAGE_SIZE = 15;
    private static final int HEAD_ITEM_PRESEVING_AREA_LENGTH = 20;
    private BbsTopics topics = new BbsTopics();
    private static String tmpTopicName = "asdfgh_tmp_topic";
    private Vector<GoBbsDataCommand> outQueue = new Vector();
    private Vector<GoBbsDataResult> inQueue = new Vector();
    private output to;

    BbsDataAdapter() {
        this.pathOfStorageGoBbsData = ServerGlobal.pathOfStorageGoBbsData;
        this.pathOfStorageGoBbsUserData = ServerGlobal.pathOfStorageGoBbsUserData;
        this.to = new output();
        this.to.start();
    }

    BbsDataAdapter(String string, String string2) {
        this.pathOfStorageGoBbsData = string;
        this.pathOfStorageGoBbsUserData = string2;
        this.to = new output();
        this.to.start();
    }

    public synchronized BbsTopics getAllTopics() {
        return this.topics.getCopy();
    }

    public void createUserBbsResource(String string) {
        GoBbsDataCommand goBbsDataCommand = new GoBbsDataCommand();
        goBbsDataCommand.type = (byte)2;
        goBbsDataCommand.userName = string;
        this.put(goBbsDataCommand);
    }

    public void freeUserBbsResource(String string) {
        GoBbsDataCommand goBbsDataCommand = new GoBbsDataCommand();
        goBbsDataCommand.type = (byte)3;
        goBbsDataCommand.userName = string;
        this.put(goBbsDataCommand);
    }

    public void updateTopic() {
        this.getAllTopic(null);
    }

    private synchronized void updateTopic(String[] stringArray) {
        this.topics.set(stringArray);
    }

    private void getAllTopic(ClientAdapter clientAdapter) {
        try {
            File file = new File(this.pathOfStorageGoBbsData);
            String[] stringArray = file.list();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(HEAD)) continue;
                ++n;
            }
            String[] stringArray2 = new String[n];
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (!stringArray[i].endsWith(HEAD)) continue;
                stringArray2[n2] = string = stringArray[i].substring(0, stringArray[i].length() - HEAD.length());
                ++n2;
            }
            if (clientAdapter == null) {
                this.updateTopic(stringArray2);
                return;
            }
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)6;
            goBbsDataResult.result.allTopic = stringArray2;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void createTopic(String string, ClientAdapter clientAdapter) {
        try {
            File file = new File(this.pathOfStorageGoBbsData + string + BODY);
            file.createNewFile();
            File file2 = new File(this.pathOfStorageGoBbsData + string + HEAD);
            file2.createNewFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            randomAccessFile.writeInt(0);
            randomAccessFile.writeLong(0L);
            randomAccessFile.close();
            this.getAllTopic(null);
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = 1;
            goBbsDataResult.result.topicName = string;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void getTopicGoQiPuIndex(String string, int n, ClientAdapter clientAdapter) {
        try {
            int n2;
            Vector<GoQiPuInfo> vector = new Vector<GoQiPuInfo>();
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "r");
            }
            catch (Exception exception) {
                return;
            }
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            int n3 = (int)((randomAccessFile.length() - 12L) / 500L);
            if (n < 0) {
                n = 0;
            }
            if (n > 10000000) {
                n = 10000000;
            }
            if (n * 15 >= n3) {
                n = (n3 - 1) / 15;
            }
            for (int i = n * 15; i < (n + 1) * 15 && i < n3; ++i) {
                randomAccessFile.seek(12 + i * 500);
                n2 = randomAccessFile.readByte();
                if (n2 == 2) continue;
                randomAccessFile.seek(12 + i * 500 + 20);
                GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
                goQiPuInfo.read(tyBaseInputRandomAccessFile);
                vector.add(goQiPuInfo);
            }
            randomAccessFile.close();
            GoQiPuInfo[] goQiPuInfoArray = new GoQiPuInfo[vector.size()];
            for (n2 = 0; n2 < goQiPuInfoArray.length; ++n2) {
                goQiPuInfoArray[n2] = (GoQiPuInfo)vector.elementAt(n2);
            }
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)7;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.index = goQiPuInfoArray;
            goBbsDataResult.result.pageNumber = n;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delTopic(String string, ClientAdapter clientAdapter) {
        try {
            File file;
            File file2 = new File(this.pathOfStorageGoBbsData + string + BODY);
            if (file2.exists() && !file2.delete()) {
                System.out.println("delete file fail :" + file2.toString());
            }
            if ((file = new File(this.pathOfStorageGoBbsData + string + HEAD)).exists() && !file.delete()) {
                System.out.println("delete file fail :" + file.toString());
            }
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)2;
            goBbsDataResult.result.topicName = string;
            this.putToInQueue(goBbsDataResult);
            this.getAllTopic(null);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private boolean isTopicExists(String string) {
        try {
            File file = new File(this.pathOfStorageGoBbsData + string + BODY);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
            file = new File(this.pathOfStorageGoBbsData + string + HEAD);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
        return true;
    }

    private void modifyUserCollectionGoQiPu(int n, GoQiPu goQiPu, String string, ClientAdapter clientAdapter) {
        if (!this.isUserExists(string)) {
            this.createUser(string);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string + BODY, "rw");
            long l = randomAccessFile.length();
            randomAccessFile.seek(l);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            goQiPu.write(tyBaseOutputRandomAccessFile);
            long l2 = randomAccessFile.getFilePointer() - l;
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string + HEAD, "rw");
            long l3 = 12 + n * 500;
            long l4 = randomAccessFile2.length();
            if (l3 > l4 - 500L) {
                System.out.println("error in modifyUserCollectionGoQiPu");
                return;
            }
            randomAccessFile2.seek(l3);
            randomAccessFile2.writeByte(1);
            randomAccessFile2.writeLong(l);
            randomAccessFile2.writeLong(l2);
            randomAccessFile2.seek(l3 + 20L);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.read(tyBaseInputRandomAccessFile);
            goQiPuInfo.setTitle(goQiPu.qp.getTitle());
            goQiPuInfo.setExplain(goQiPu.qp.getExplain());
            goQiPuInfo.size = (int)l2;
            goQiPuInfo.createTime = System.currentTimeMillis();
            randomAccessFile2.seek(l3 + 20L);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile2);
            randomAccessFile2.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)13;
            goBbsDataResult.result.isMyCollectionData = true;
            goBbsDataResult.result.userName = string;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void modifyGoQiPu(int n, GoQiPu goQiPu, String string, String string2, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + BODY, "rw");
            long l = randomAccessFile.length();
            randomAccessFile.seek(l);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            goQiPu.write(tyBaseOutputRandomAccessFile);
            long l2 = randomAccessFile.getFilePointer() - l;
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            long l3 = 12 + n * 500;
            long l4 = randomAccessFile2.length();
            if (l3 > l4 - 500L) {
                System.out.println("error in modifyGoQiPu");
                return;
            }
            randomAccessFile2.seek(l3);
            randomAccessFile2.writeByte(1);
            randomAccessFile2.writeLong(l);
            randomAccessFile2.writeLong(l2);
            randomAccessFile2.seek(l3 + 20L);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.read(tyBaseInputRandomAccessFile);
            goQiPuInfo.setTitle(goQiPu.qp.getTitle());
            goQiPuInfo.setExplain(goQiPu.qp.getExplain());
            goQiPuInfo.size = (int)l2;
            goQiPuInfo.createTime = System.currentTimeMillis();
            randomAccessFile2.seek(l3 + 20L);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile2);
            randomAccessFile2.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)13;
            goBbsDataResult.result.isMyCollectionData = false;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void addGoQiPu(GoQiPu goQiPu, String string, String string2, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + BODY, "rw");
            long l = randomAccessFile.length();
            randomAccessFile.seek(l);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            goQiPu.write(tyBaseOutputRandomAccessFile);
            long l2 = randomAccessFile.getFilePointer() - l;
            randomAccessFile.close();
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.setTitle(goQiPu.qp.getTitle());
            goQiPuInfo.setExplain(goQiPu.qp.getExplain());
            goQiPuInfo.setAuthor(string2);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            long l3 = randomAccessFile2.length();
            long l4 = (l3 - 12L) / 500L;
            randomAccessFile2.setLength(l3 + 500L);
            randomAccessFile2.seek(l3);
            randomAccessFile2.writeByte(1);
            randomAccessFile2.writeLong(l);
            randomAccessFile2.writeLong(l2);
            randomAccessFile2.seek(l3 + 20L);
            goQiPuInfo.number = (int)l4;
            goQiPuInfo.createTime = System.currentTimeMillis();
            goQiPuInfo.size = (int)l2;
            goQiPuInfo.difficultLevel = goQiPu.difficult;
            goQiPuInfo.readPrice = goQiPu.readPrice;
            goQiPuInfo.buyPrice = goQiPu.buyPrice;
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile2);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile2);
            randomAccessFile2.setLength(l3 + 500L);
            randomAccessFile2.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)3;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delGoQiPu(int n, String string, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            int n2 = 0;
            long l = 0L;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            randomAccessFile.seek(0L);
            n2 = randomAccessFile.readInt();
            l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500);
            randomAccessFile.writeByte(2);
            randomAccessFile.seek(12 + n * 500 + 9);
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(++n2);
            randomAccessFile.writeLong(l += randomAccessFile.readLong());
            randomAccessFile.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)4;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.goQiPuNumber = n;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void getGoQiPu(int n, String string, byte by, byte by2, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (by == 2 && by2 == 1) {
            this.noPayReadGoQiPu(n, string, clientAdapter);
        } else if (by == 2 && by2 == 2) {
            this.noPayBuyGoQiPu(n, string, clientAdapter.getName(), clientAdapter);
        } else if (by == 1 && by2 == 1) {
            this.normalReadGoQiPu(n, string, clientAdapter);
        } else if (by == 1 && by2 == 2) {
            this.normalBuyGoQiPu(n, string, clientAdapter.getName(), clientAdapter);
        }
    }

    private void noPayReadGoQiPu(int n, String string, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            if (randomAccessFile.length() < (long)(12 + n * 500 + 1)) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500 + 1);
            long l = randomAccessFile.readLong();
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            randomAccessFile.seek(12 + n * 500 + 20);
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.read(tyBaseInputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPu goQiPu = new GoQiPu();
            goQiPu.read(tyBaseInputRandomAccessFile2);
            randomAccessFile2.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)5;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.qiPu = goQiPu;
            goBbsDataResult.result.goQiPuNumber = n;
            goBbsDataResult.result.getQiPuOperationType = 1;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void normalReadGoQiPu(int n, String string, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            if (randomAccessFile.length() < (long)(12 + n * 500 + 1)) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500 + 1);
            long l = randomAccessFile.readLong();
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            randomAccessFile.seek(12 + n * 500 + 20);
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.read(tyBaseInputRandomAccessFile);
            ++goQiPuInfo.readerCounter;
            randomAccessFile.seek(12 + n * 500 + 20);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPu goQiPu = new GoQiPu();
            goQiPu.read(tyBaseInputRandomAccessFile2);
            randomAccessFile2.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)5;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.qiPu = goQiPu;
            goBbsDataResult.result.goQiPuNumber = n;
            goBbsDataResult.result.getQiPuOperationType = 1;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            UserAndMoneyOperation userAndMoneyOperation = new UserAndMoneyOperation();
            userAndMoneyOperation.userName = goQiPuInfo.author;
            userAndMoneyOperation.money.addWithTax(new TpMoney(goQiPuInfo.readPrice + ""));
            UserAndMoneyOperation userAndMoneyOperation2 = new UserAndMoneyOperation();
            userAndMoneyOperation.userName = clientAdapter.getName();
            userAndMoneyOperation.money.add(new TpMoney(0 - goQiPuInfo.readPrice + ""));
            goBbsDataResult.addMoneyOperation(userAndMoneyOperation);
            goBbsDataResult.addMoneyOperation(userAndMoneyOperation2);
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void freeAllTopicBeDeletedSpace() {
        this.getAllTopic(null);
        Vector<String> vector = this.topics.getAll();
        for (String string : vector) {
            this.freeTopicBeDeletedSpace(string);
        }
    }

    private void freeTopicBeDeletedSpace(String string) {
        if (!this.isTopicExists(string)) {
            return;
        }
        try {
            File file = new File(this.pathOfStorageGoBbsData + tmpTopicName + BODY);
            file.createNewFile();
            File file2 = new File(this.pathOfStorageGoBbsData + tmpTopicName + HEAD);
            file2.createNewFile();
            File file3 = new File(this.pathOfStorageGoBbsData + string + HEAD);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file3, "r");
            File file4 = new File(this.pathOfStorageGoBbsData + string + BODY);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(file4, "r");
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.pathOfStorageGoBbsData + tmpTopicName + HEAD, "rw");
            randomAccessFile3.writeInt(0);
            randomAccessFile3.writeLong(0L);
            RandomAccessFile randomAccessFile4 = new RandomAccessFile(this.pathOfStorageGoBbsData + tmpTopicName + BODY, "rw");
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile3);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile4);
            byte[] byArray = new byte[480];
            byte[] byArray2 = new byte[1000];
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            GoQiPu goQiPu = new GoQiPu();
            int n = 0;
            int n2 = 0;
            while ((long)n2 < randomAccessFile.length() / 500L) {
                randomAccessFile.seek(12 + n2 * 500);
                byte by = randomAccessFile.readByte();
                if (by != 2) {
                    long l = randomAccessFile.readLong();
                    long l2 = randomAccessFile.readLong();
                    l = file.length();
                    randomAccessFile2.seek(l);
                    goQiPu.read(tyBaseInputRandomAccessFile2);
                    goQiPu.write(tyBaseOutputRandomAccessFile2);
                    l2 = file.length();
                    randomAccessFile.seek(12 + n2 * 500 + 20);
                    goQiPuInfo.read(tyBaseInputRandomAccessFile);
                    goQiPuInfo.number = n++;
                    long l3 = randomAccessFile3.length();
                    randomAccessFile3.seek(randomAccessFile3.length());
                    randomAccessFile3.writeByte(1);
                    randomAccessFile3.writeLong(l);
                    randomAccessFile3.writeLong(l2);
                    randomAccessFile3.writeByte(0);
                    randomAccessFile3.writeByte(0);
                    randomAccessFile3.writeByte(0);
                    goQiPuInfo.write(tyBaseOutputRandomAccessFile);
                    randomAccessFile3.setLength(l3 + 500L);
                }
                ++n2;
            }
            randomAccessFile.close();
            randomAccessFile2.close();
            file3.delete();
            file4.delete();
            randomAccessFile3.close();
            randomAccessFile4.close();
            file2.renameTo(file3);
            file.renameTo(file4);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void copyQiPu(String string, String string2, int n, ClientAdapter clientAdapter) {
        if (n < 0) {
            return;
        }
        if (!this.isTopicExists(string)) {
            return;
        }
        if (!this.isTopicExists(string2)) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            if (randomAccessFile.length() / 500L < (long)n) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500);
            byte by = randomAccessFile.readByte();
            if (by == 2) {
                randomAccessFile.close();
                return;
            }
            long l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500 + 20);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.read(tyBaseInputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPu goQiPu = new GoQiPu();
            goQiPu.read(tyBaseInputRandomAccessFile2);
            randomAccessFile2.close();
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.pathOfStorageGoBbsData + string2 + BODY, "rw");
            long l2 = randomAccessFile3.length();
            randomAccessFile3.seek(l2);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile3);
            goQiPu.write(tyBaseOutputRandomAccessFile);
            long l3 = randomAccessFile3.getFilePointer() - l2;
            randomAccessFile3.close();
            RandomAccessFile randomAccessFile4 = new RandomAccessFile(this.pathOfStorageGoBbsData + string2 + HEAD, "rw");
            long l4 = randomAccessFile4.length();
            long l5 = (l4 - 12L) / 500L;
            goQiPuInfo.number = (int)l5;
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.seek(l4);
            randomAccessFile4.writeByte(1);
            randomAccessFile4.writeLong(l2);
            randomAccessFile4.writeLong(l3);
            randomAccessFile4.seek(l4 + 20L);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile4);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile2);
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)3;
            goBbsDataResult.result.isMyCollectionData = false;
            goBbsDataResult.result.topicName = string2;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void noPayBuyGoQiPu(int n, String string, String string2, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        if (!this.isUserExists(string2)) {
            this.createUser(string2);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            if (randomAccessFile.length() < (long)(12 + n * 500 + 1)) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500 + 1);
            long l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500 + 20);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.read(tyBaseInputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPu goQiPu = new GoQiPu();
            goQiPu.read(tyBaseInputRandomAccessFile2);
            randomAccessFile2.close();
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string2 + BODY, "rw");
            long l2 = randomAccessFile3.length();
            randomAccessFile3.seek(l2);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile3);
            goQiPu.write(tyBaseOutputRandomAccessFile);
            long l3 = randomAccessFile3.getFilePointer() - l2;
            randomAccessFile3.close();
            RandomAccessFile randomAccessFile4 = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string2 + HEAD, "rw");
            long l4 = randomAccessFile4.length();
            long l5 = (l4 - 12L) / 500L;
            goQiPuInfo.number = (int)l5;
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.seek(l4);
            randomAccessFile4.writeByte(1);
            randomAccessFile4.writeLong(l2);
            randomAccessFile4.writeLong(l3);
            randomAccessFile4.seek(l4 + 20L);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile4);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile2);
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)3;
            goBbsDataResult.result.isMyCollectionData = true;
            goBbsDataResult.result.topicName = string2;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void normalBuyGoQiPu(int n, String string, String string2, ClientAdapter clientAdapter) {
        if (!this.isTopicExists(string)) {
            return;
        }
        if (!this.isUserExists(string2)) {
            this.createUser(string2);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsData + string + HEAD, "rw");
            if (randomAccessFile.length() < (long)(12 + n * 500 + 1)) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(12 + n * 500 + 1);
            long l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500 + 20);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile = new TyBaseOutputRandomAccessFile(randomAccessFile);
            GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
            goQiPuInfo.read(tyBaseInputRandomAccessFile);
            ++goQiPuInfo.buyCounter;
            randomAccessFile.seek(12 + n * 500 + 20);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile);
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile2 = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPu goQiPu = new GoQiPu();
            goQiPu.read(tyBaseInputRandomAccessFile2);
            randomAccessFile2.close();
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string2 + BODY, "rw");
            long l2 = randomAccessFile3.length();
            randomAccessFile3.seek(l2);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile2 = new TyBaseOutputRandomAccessFile(randomAccessFile3);
            goQiPu.write(tyBaseOutputRandomAccessFile2);
            long l3 = randomAccessFile3.getFilePointer() - l2;
            randomAccessFile3.close();
            RandomAccessFile randomAccessFile4 = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string2 + HEAD, "rw");
            long l4 = randomAccessFile4.length();
            long l5 = (l4 - 12L) / 500L;
            goQiPuInfo.number = (int)l5;
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.seek(l4);
            randomAccessFile4.writeByte(1);
            randomAccessFile4.writeLong(l2);
            randomAccessFile4.writeLong(l3);
            TyBaseOutputRandomAccessFile tyBaseOutputRandomAccessFile3 = new TyBaseOutputRandomAccessFile(randomAccessFile4);
            goQiPuInfo.write(tyBaseOutputRandomAccessFile3);
            randomAccessFile4.setLength(l4 + 500L);
            randomAccessFile4.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)3;
            goBbsDataResult.result.isMyCollectionData = true;
            goBbsDataResult.result.topicName = string2;
            goBbsDataResult.result.gqpInfo = goQiPuInfo;
            UserAndMoneyOperation userAndMoneyOperation = new UserAndMoneyOperation();
            userAndMoneyOperation.userName = goQiPuInfo.author;
            userAndMoneyOperation.money.addWithTax(new TpMoney(goQiPuInfo.buyPrice + ""));
            UserAndMoneyOperation userAndMoneyOperation2 = new UserAndMoneyOperation();
            userAndMoneyOperation.userName = clientAdapter.getName();
            userAndMoneyOperation.money.add(new TpMoney(0 - goQiPuInfo.buyPrice + ""));
            goBbsDataResult.addMoneyOperation(userAndMoneyOperation);
            goBbsDataResult.addMoneyOperation(userAndMoneyOperation2);
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void getUserCollectionGoQiPu(int n, String string, ClientAdapter clientAdapter) {
        if (!this.isUserExists(string)) {
            this.createUser(string);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string + HEAD, "rw");
            randomAccessFile.seek(12 + n * 500 + 1);
            long l = randomAccessFile.readLong();
            randomAccessFile.close();
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string + BODY, "r");
            randomAccessFile2.seek(l);
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile2);
            GoQiPu goQiPu = new GoQiPu();
            goQiPu.read(tyBaseInputRandomAccessFile);
            randomAccessFile2.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)5;
            goBbsDataResult.result.isMyCollectionData = true;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.qiPu = goQiPu;
            goBbsDataResult.result.goQiPuNumber = n;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delUserCollectionGoQiPu(int n, String string, ClientAdapter clientAdapter) {
        if (!this.isUserExists(string)) {
            this.createUser(string);
        }
        try {
            int n2 = 0;
            long l = 0L;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string + HEAD, "rw");
            randomAccessFile.seek(0L);
            n2 = randomAccessFile.readInt();
            l = randomAccessFile.readLong();
            randomAccessFile.seek(12 + n * 500);
            randomAccessFile.writeByte(2);
            randomAccessFile.seek(12 + n * 500 + 9);
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(++n2);
            randomAccessFile.writeLong(l += randomAccessFile.readLong());
            randomAccessFile.close();
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.type = (byte)4;
            goBbsDataResult.result.isMyCollectionData = true;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.goQiPuNumber = n;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void getUserCollectionGoQiPuIndex(String string, int n, ClientAdapter clientAdapter) {
        if (!this.isUserExists(string)) {
            this.createUser(string);
        }
        try {
            int n2;
            Vector<GoQiPuInfo> vector = new Vector<GoQiPuInfo>();
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string + HEAD, "r");
            }
            catch (Exception exception) {
                return;
            }
            TyBaseInputRandomAccessFile tyBaseInputRandomAccessFile = new TyBaseInputRandomAccessFile(randomAccessFile);
            int n3 = (int)((randomAccessFile.length() - 12L) / 500L);
            if (n < 0) {
                n = 0;
            }
            if (n > 10000000) {
                n = 10000000;
            }
            if (n * 15 >= n3) {
                n = (n3 - 1) / 15;
            }
            for (int i = n * 15; i < (n + 1) * 15 && i < n3; ++i) {
                randomAccessFile.seek(12 + i * 500);
                n2 = randomAccessFile.readByte();
                if (n2 == 2) continue;
                randomAccessFile.seek(12 + i * 500 + 20);
                GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
                goQiPuInfo.read(tyBaseInputRandomAccessFile);
                vector.add(goQiPuInfo);
            }
            randomAccessFile.close();
            GoQiPuInfo[] goQiPuInfoArray = new GoQiPuInfo[vector.size()];
            for (n2 = 0; n2 < goQiPuInfoArray.length; ++n2) {
                goQiPuInfoArray[n2] = (GoQiPuInfo)vector.elementAt(n2);
            }
            GoBbsDataResult goBbsDataResult = new GoBbsDataResult();
            goBbsDataResult.result = new GoBbsData();
            goBbsDataResult.client = clientAdapter;
            goBbsDataResult.result.isMyCollectionData = true;
            goBbsDataResult.result.type = (byte)7;
            goBbsDataResult.result.topicName = string;
            goBbsDataResult.result.index = goQiPuInfoArray;
            goBbsDataResult.result.pageNumber = n;
            this.putToInQueue(goBbsDataResult);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private boolean isUserExists(String string) {
        try {
            File file = new File(this.pathOfStorageGoBbsUserData + string + BODY);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
            File file2 = new File(this.pathOfStorageGoBbsUserData + string + HEAD);
            if (!file2.exists() || !file2.isFile()) {
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
        return true;
    }

    private void createUser(String string) {
        try {
            File file = new File(this.pathOfStorageGoBbsUserData + string + BODY);
            file.createNewFile();
            File file2 = new File(this.pathOfStorageGoBbsUserData + string + HEAD);
            file2.createNewFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pathOfStorageGoBbsUserData + string + HEAD, "rw");
            randomAccessFile.writeInt(0);
            randomAccessFile.writeLong(0L);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    private void delUser(String string) {
        try {
            File file;
            File file2 = new File(this.pathOfStorageGoBbsUserData + string + BODY);
            if (!file2.delete()) {
                System.out.println("delete file fail :" + file2.toString());
            }
            if (!(file = new File(this.pathOfStorageGoBbsUserData + string + HEAD)).delete()) {
                System.out.println("delete file fail :" + file.toString());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    public synchronized GoBbsDataResult get() {
        if (this.inQueue.isEmpty()) {
            return null;
        }
        GoBbsDataResult goBbsDataResult = this.inQueue.firstElement();
        this.inQueue.remove(goBbsDataResult);
        return goBbsDataResult;
    }

    protected void putRequest(GoBbsDataRequest goBbsDataRequest, ClientAdapter clientAdapter) {
        GoBbsDataCommand goBbsDataCommand = new GoBbsDataCommand();
        goBbsDataCommand.client = clientAdapter;
        goBbsDataCommand.request = goBbsDataRequest;
        this.put(goBbsDataCommand);
    }

    private synchronized void put(GoBbsDataCommand goBbsDataCommand) {
        this.outQueue.add(goBbsDataCommand);
        this.notify();
    }

    private synchronized GoBbsDataCommand getFromOutQueue() {
        while (true) {
            try {
                while (this.outQueue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        GoBbsDataCommand goBbsDataCommand = this.outQueue.firstElement();
        this.outQueue.remove(goBbsDataCommand);
        return goBbsDataCommand;
    }

    private synchronized void putToInQueue(GoBbsDataResult goBbsDataResult) {
        if (goBbsDataResult != null) {
            this.inQueue.add(goBbsDataResult);
        }
    }

    private class output
    extends Thread {
        private GoBbsDataCommand command;

        private output() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.command = BbsDataAdapter.this.getFromOutQueue();
                        if (this.command == null) {
                            output.sleep(100L);
                            continue;
                        }
                        if (!this.centerSwitch()) break;
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private boolean centerSwitch() {
            if (this.command.type == 1) {
                return false;
            }
            if (this.command.type == 2) {
                BbsDataAdapter.this.createUser(this.command.userName);
                return true;
            }
            if (this.command.type == 3) {
                BbsDataAdapter.this.delUser(this.command.userName);
                return true;
            }
            switch (this.command.request.type) {
                case 1: {
                    BbsDataAdapter.this.createTopic(this.command.request.topicName, this.command.client);
                    break;
                }
                case 2: {
                    BbsDataAdapter.this.delTopic(this.command.request.topicName, this.command.client);
                    break;
                }
                case 3: {
                    if (this.command.request.isMyCollectionData) break;
                    BbsDataAdapter.this.addGoQiPu(this.command.request.qiPu, this.command.request.topicName, this.command.client.getName(), this.command.client);
                    break;
                }
                case 13: {
                    if (this.command.request.isMyCollectionData) {
                        BbsDataAdapter.this.modifyUserCollectionGoQiPu(this.command.request.qiPuNumber, this.command.request.qiPu, this.command.client.getName(), this.command.client);
                        break;
                    }
                    BbsDataAdapter.this.modifyGoQiPu(this.command.request.qiPuNumber, this.command.request.qiPu, this.command.request.topicName, this.command.client.getName(), this.command.client);
                    break;
                }
                case 4: {
                    if (this.command.request.isMyCollectionData) {
                        BbsDataAdapter.this.delUserCollectionGoQiPu(this.command.request.qiPuNumber, this.command.client.getName(), this.command.client);
                        break;
                    }
                    BbsDataAdapter.this.delGoQiPu(this.command.request.qiPuNumber, this.command.request.topicName, this.command.client);
                    break;
                }
                case 5: {
                    if (this.command.request.isMyCollectionData) {
                        BbsDataAdapter.this.getUserCollectionGoQiPu(this.command.request.qiPuNumber, this.command.client.getName(), this.command.client);
                        break;
                    }
                    BbsDataAdapter.this.getGoQiPu(this.command.request.qiPuNumber, this.command.request.topicName, this.command.request.getQiPuOperationMode, this.command.request.getQiPuOperationType, this.command.client);
                    break;
                }
                case 6: {
                    BbsDataAdapter.this.getAllTopic(this.command.client);
                    break;
                }
                case 7: {
                    if (this.command.request.isMyCollectionData) {
                        BbsDataAdapter.this.getUserCollectionGoQiPuIndex(this.command.client.getName(), this.command.request.pageNumber, this.command.client);
                        break;
                    }
                    BbsDataAdapter.this.getTopicGoQiPuIndex(this.command.request.topicName, this.command.request.pageNumber, this.command.client);
                    break;
                }
                case 8: {
                    BbsDataAdapter.this.copyQiPu(this.command.request.sourceTopicName, this.command.request.destTopicName, this.command.request.qiPuNumber, this.command.client);
                    break;
                }
                case 9: {
                    BbsDataAdapter.this.freeAllTopicBeDeletedSpace();
                    break;
                }
            }
            return true;
        }
    }
}

