/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.innermail;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import tianyuan.games.base.innermail.InnerMail;
import tianyuan.games.base.innermail.InnerMailHead;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyBoldJTextArea;
import tianyuan.games.gui.MyBoldJTextField;
import tianyuan.games.gui.goe.dialog.MyJPanel;

class InnerMailSendPane
extends MyJPanel {
    private JLabel titleLabel = new JLabel(Global.lang.getKey("243_title"));
    private JButton upLoad = new JButton(Global.lang.getKey("252_send"));
    private JButton clearAll = new JButton(Global.lang.getKey("243_clear"));
    private MyBoldJTextField title = new MyBoldJTextField("");
    private MyBoldJTextArea textBody = new MyBoldJTextArea("");
    private JScrollPane sp = new JScrollPane(this.textBody);
    private JLabel receiverLabel = new JLabel(Global.lang.getKey("252_receiver"));
    private MyBoldJTextField receiver = new MyBoldJTextField("");

    InnerMailSendPane() {
        this.myReLayout();
        this.clearAll.addActionListener(new ClearListener());
        this.upLoad.addActionListener(new SubmitListener());
    }

    @Override
    protected void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = 87;
        int n2 = dimension.width - n * 5;
        int n3 = 30;
        this.myAddComp(this.titleLabel, 5, 3, n - 15, n3 - 6);
        this.myAddComp(this.title, n - 15, 3, n2, n3 - 6);
        this.myAddComp(this.receiverLabel, n + n2, 3, n - 5, n3 - 6);
        this.myAddComp(this.receiver, n + n2 + n - 20, 3, n - 10, n3 - 6);
        this.myAddComp(this.upLoad, n * 3 + n2 - 5, 3, n - 5, n3 - 6);
        this.myAddComp(this.clearAll, n * 4 + n2, 3, n - 5, n3 - 6);
        this.myAddComp(this.sp, 0, n3 + 1, dimension.width, dimension.height - n3 - 2);
        this.revalidate();
    }

    private void myClear() {
        this.textBody.setText("");
        this.title.setText("");
        this.receiver.setText("");
    }

    public void mailToAction(String string) {
        this.receiver.setText(string);
    }

    public void setItem(InnerMail innerMail) {
        this.textBody.setText(innerMail.body.meatData);
        this.title.setText(innerMail.head.title);
        this.receiver.setText(innerMail.head.receiver);
    }

    public void replyItem(InnerMail innerMail) {
        this.myClear();
        this.receiver.setText(innerMail.head.sender);
        this.title.setText("Re: " + innerMail.getTitle());
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        stringBuilder.append("\n-----------------------------------------------------\n");
        stringBuilder.append(this.infoStr(innerMail.getHead()));
        stringBuilder.append("     " + innerMail.getBody());
        this.textBody.setText(stringBuilder.toString());
    }

    private String infoStr(InnerMailHead innerMailHead) {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("     " + Global.lang.getKey("252_sender") + " ");
        stringBuilder.append(innerMailHead.sender + "\n");
        stringBuilder.append("     " + Global.lang.getKey("252_title") + " ");
        stringBuilder.append(innerMailHead.title + "\n");
        stringBuilder.append("     " + Global.lang.getKey("252_time") + " ");
        stringBuilder.append(this.toDateStr(innerMailHead.sendTime) + "\n");
        return stringBuilder.toString();
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    class ClearListener
    implements ActionListener {
        ClearListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InnerMailSendPane.this.myClear();
        }
    }

    class SubmitListener
    implements ActionListener {
        SubmitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InnerMail innerMail = new InnerMail();
            String string = InnerMailSendPane.this.title.getText();
            String string2 = InnerMailSendPane.this.textBody.getText();
            String string3 = InnerMailSendPane.this.receiver.getText();
            if (string == null || string.equals("")) {
                return;
            }
            if (string2 == null || string2.equals("")) {
                return;
            }
            if (string3 == null || string3.equals("")) {
                return;
            }
            innerMail.setTitle(string);
            innerMail.setBody(string2);
            innerMail.setSender(Global.myName());
            innerMail.setReceiver(string3);
            innerMail.head.sendTime = System.currentTimeMillis();
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.innerMailSend(innerMail);
            InnerMailSendPane.this.myClear();
        }
    }
}

