/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserTmpInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.table.AddDislikeAction;
import tianyuan.games.gui.goe.table.AddFriendAction;
import tianyuan.games.gui.goe.table.ChallengeAction;
import tianyuan.games.gui.goe.table.DelDislikeAction;
import tianyuan.games.gui.goe.table.DelFriendAction;
import tianyuan.games.gui.goe.table.InfoAction;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.SendMessageAction;
import tianyuan.games.gui.goe.table.StaticColor;
import tianyuan.games.gui.goe.table.TabbedUserList;
import tianyuan.games.gui.goe.table.TableSorter;

class TabbedUserListItem
extends JPanel {
    protected JPopupMenu popup = new JPopupMenu();
    protected ChallengeAction challengeAction;
    protected SendMessageAction sendMessageAction;
    protected InfoAction infoAction;
    protected AddFriendAction addFriendAction;
    protected AddDislikeAction addDislikeAction;
    protected DelFriendAction delFriendAction;
    protected DelDislikeAction delDislikeAction;
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm;
    protected TabbedUserListTableSorter sorter;
    protected TabbedUserList father;
    String[] columnNames = new String[]{Global.lang.getKey("102_username"), Global.lang.getKey("102_level"), Global.lang.getKey("102_winTimes"), Global.lang.getKey("102_failTimes"), Global.lang.getKey("102_breakLineTimes"), Global.lang.getKey("102_flee"), Global.lang.getKey("102_invite"), Global.lang.getKey("102_whisper"), Global.lang.getKey("102_inGame"), Global.lang.getKey("102_seeGame"), Global.lang.getKey("102_money")};
    private SizeListener seeSize = new SizeListener();

    TabbedUserListItem(TabbedUserList tabbedUserList) {
        this.father = tabbedUserList;
        this.mtm = new MyTableModel();
        this.sorter = new TabbedUserListTableSorter(this.mtm);
        this.table = new JTable(this.sorter);
        this.table.setSelectionMode(0);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new PopupActionAdapter(this.popup, this.table));
        this.table.addMouseListener(new DoubleClickAdapter());
        this.table.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        this.sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.addComponentListener(this.seeSize);
        this.table.setModel(this.sorter);
        this.setTableCellRenderer();
    }

    protected int getRowCount() {
        return this.table.getRowCount();
    }

    protected String getSelectedUser() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("102_username").equals(this.sorter.getColumnName(i))) continue;
            String string = (String)this.sorter.getValueAt(n, i);
            return string;
        }
        return null;
    }

    protected void setActionsEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        if (this.challengeAction != null) {
            this.challengeAction.setEnabled(bl);
        }
        if (this.sendMessageAction != null) {
            this.sendMessageAction.setEnabled(bl2);
        }
        if (this.infoAction != null) {
            this.infoAction.setEnabled(bl3);
        }
        if (this.addFriendAction != null) {
            this.addFriendAction.setEnabled(bl4);
        }
        if (this.addDislikeAction != null) {
            this.addDislikeAction.setEnabled(bl5);
        }
        if (this.delFriendAction != null) {
            this.delFriendAction.setEnabled(bl6);
        }
        if (this.delDislikeAction != null) {
            this.delDislikeAction.setEnabled(bl7);
        }
    }

    public void setPopupMenuNormal() {
        this.challengeAction = new ChallengeAction(this);
        this.popup.add(this.challengeAction);
        this.sendMessageAction = new SendMessageAction(this);
        this.popup.add(this.sendMessageAction);
        this.addFriendAction = new AddFriendAction(this);
        this.popup.add(this.addFriendAction);
        this.addDislikeAction = new AddDislikeAction(this);
        this.popup.add(this.addDislikeAction);
        this.infoAction = new InfoAction(this);
        this.popup.add(this.infoAction);
        this.table.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.table));
    }

    public void setPopupMenuFriend() {
        this.challengeAction = new ChallengeAction(this);
        this.popup.add(this.challengeAction);
        this.sendMessageAction = new SendMessageAction(this);
        this.popup.add(this.sendMessageAction);
        this.delFriendAction = new DelFriendAction(this);
        this.popup.add(this.delFriendAction);
        this.infoAction = new InfoAction(this);
        this.popup.add(this.infoAction);
        this.table.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.table));
    }

    public void setPopupMenuDislike() {
        this.challengeAction = new ChallengeAction(this);
        this.popup.add(this.challengeAction);
        this.sendMessageAction = new SendMessageAction(this);
        this.popup.add(this.sendMessageAction);
        this.delDislikeAction = new DelDislikeAction(this);
        this.popup.add(this.delDislikeAction);
        this.infoAction = new InfoAction(this);
        this.popup.add(this.infoAction);
        this.table.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.table));
    }

    private void setTableCellRenderer() {
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.table.getColumnName(i));
            tableColumn.setCellRenderer(new UserTableCellRenderer());
        }
    }

    public void add(Vector<UserInfo> vector, Vector<UserTmpInfo> vector2) {
        Enumeration<UserInfo> enumeration = vector.elements();
        Enumeration<UserTmpInfo> enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            UserInfo userInfo = enumeration.nextElement();
            UserTmpInfo userTmpInfo = enumeration2.nextElement();
            if (userInfo == null || userTmpInfo == null) continue;
            this.addALine(userInfo, userTmpInfo, this.mtm);
        }
    }

    public void add(UserInfo userInfo, UserTmpInfo userTmpInfo) {
        this.addALine(userInfo, userTmpInfo, this.mtm);
    }

    public void delAll() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
    }

    public void del(String string) {
        int n = this.mtm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (Global.lang.getKey("102_username").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (!(object instanceof String) || ((String)object).compareTo(string) != 0) continue;
                this.mtm.removeRow(j);
                return;
            }
        }
    }

    public void updateMoney(String string, int n) {
        int n2 = this.searchRow(string);
        if (n2 < 0) {
            return;
        }
        this.setValue(this.columnNames[10], new Integer(n), n2);
    }

    public void modify(UserAllInfo userAllInfo) {
        int n = this.searchRow(userAllInfo.info.userName);
        if (n < 0) {
            return;
        }
        this.setValue(this.columnNames[1], userAllInfo.info.go.currentLevel.toString(Global.lang), n);
        this.setValue(this.columnNames[2], new Integer(userAllInfo.info.go.total.win), n);
        this.setValue(this.columnNames[3], new Integer(userAllInfo.info.go.total.fail), n);
        this.setValue(this.columnNames[4], new Integer(userAllInfo.info.go.total.inGameBreakLine), n);
        this.setValue(this.columnNames[5], new Integer(userAllInfo.info.go.total.inGameFlee), n);
        if (userAllInfo.info.go.isAcceptInvitation) {
            this.setValue(this.columnNames[6], Global.lang.getKey("102_invite_agree"), n);
        } else {
            this.setValue(this.columnNames[6], Global.lang.getKey("102_invite_not_agree"), n);
        }
        if (userAllInfo.info.go.isAcceptPersonMessage) {
            this.setValue(this.columnNames[7], Global.lang.getKey("102_whisper_agree"), n);
        } else {
            this.setValue(this.columnNames[7], Global.lang.getKey("102_whisper_not_agree"), n);
        }
        this.setValue(this.columnNames[8], new Integer(userAllInfo.tmpInfo.go.currentInGameTotal), n);
        this.setValue(this.columnNames[9], new Integer(userAllInfo.tmpInfo.go.currentSeeGameTotal), n);
        this.setValue(this.columnNames[10], userAllInfo.info.money, n);
    }

    private void setValue(String string, Object object, int n) {
        int n2 = -1;
        int n3 = this.mtm.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (string.compareTo(this.mtm.getColumnName(i)) != 0) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        this.mtm.setValueAt(object, n, n2);
    }

    private void addALine(UserInfo userInfo, UserTmpInfo userTmpInfo, MyTableModel myTableModel) {
        int n = this.searchRow(userInfo.userName);
        if (n >= 0) {
            myTableModel.removeRow(n);
        }
        Vector<Object> vector = new Vector<Object>();
        vector.add(userInfo.userName);
        vector.add(userInfo.go.currentLevel.toString(Global.lang));
        vector.add(new Integer(userInfo.go.total.win));
        vector.add(new Integer(userInfo.go.total.fail));
        vector.add(new Integer(userInfo.go.total.inGameBreakLine));
        vector.add(new Integer(userInfo.go.total.inGameFlee));
        if (userInfo.go.isAcceptInvitation) {
            vector.add(Global.lang.getKey("102_invite_agree"));
        } else {
            vector.add(Global.lang.getKey("102_invite_not_agree"));
        }
        if (userInfo.go.isAcceptPersonMessage) {
            vector.add(Global.lang.getKey("102_whisper_agree"));
        } else {
            vector.add(Global.lang.getKey("102_whisper_not_agree"));
        }
        vector.add(new Integer(userTmpInfo.go.currentInGameTotal));
        vector.add(new Integer(userTmpInfo.go.currentSeeGameTotal));
        vector.add(userInfo.money.toString());
        myTableModel.addRow(vector);
    }

    private int searchRow(String string) {
        int n = this.mtm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!Global.lang.getKey("102_username").equals(this.mtm.getColumnName(i))) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (object == null || !(object instanceof String) || ((String)object).compareTo(string) != 0) continue;
                return j;
            }
        }
        return -1;
    }

    private void setAllSize() {
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        this.table.doLayout();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            TabbedUserListItem.this.setAllSize();
        }
    }

    class UserTableCellRenderer
    extends DefaultTableCellRenderer
    implements StaticColor {
        UserTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.isHostRecordRow(n)) {
                this.setForeground(HOST_FOREGROUND);
                this.setBackground(HOST_BACKGROUND);
            } else {
                this.setForeground(NORMAL_ITEM_FOREGROUND);
                this.setBackground(NORMAL_ITEM_BACKGROUND);
            }
            if (bl) {
                this.setForeground(SELECT_ITEM_FOREGROUND);
                this.setBackground(SELECT_ITEM_BACKGROUND);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isHostRecordRow(int n) {
            String string = (String)TabbedUserListItem.this.sorter.getValueAt(n, 0);
            return string.equals(Global.myUserInfo.userName);
        }
    }

    class TabbedUserListTableSorter
    extends TableSorter {
        TabbedUserListTableSorter(TableModel tableModel) {
            super(tableModel);
        }

        public boolean isHostRecord(int n) {
            String string = (String)TabbedUserListItem.this.sorter.getValueAt(n, 0);
            return string.equals(Global.myUserInfo.userName);
        }

        @Override
        public int compareRowsByColumn(int n, int n2, int n3) {
            TableModel tableModel = this.model;
            if (this.ascending) {
                if (this.isHostRecord(n)) {
                    return -1;
                }
                if (this.isHostRecord(n2)) {
                    return 1;
                }
            } else {
                if (this.isHostRecord(n)) {
                    return 1;
                }
                if (this.isHostRecord(n2)) {
                    return -1;
                }
            }
            return super.compareRowsByColumn(n, n2, n3);
        }
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                String string = TabbedUserListItem.this.getSelectedUser();
                if (string == null) {
                    return;
                }
                UserAllInfo userAllInfo = Global.goRoomPanel.search(string);
                boolean bl = true;
                boolean bl2 = true;
                if (userAllInfo != null) {
                    bl = userAllInfo.info.go.isAcceptInvitation;
                    bl2 = userAllInfo.info.go.isAcceptPersonMessage;
                }
                if (string.equals(Global.myUserInfo.userName)) {
                    TabbedUserListItem.this.setActionsEnabled(false, false, true, false, false, false, false);
                } else if (Global.myUserInfo.isFriend(string)) {
                    TabbedUserListItem.this.setActionsEnabled(bl, bl2, true, false, false, true, false);
                } else if (Global.myUserInfo.isDislike(string)) {
                    TabbedUserListItem.this.setActionsEnabled(bl, bl2, true, false, false, false, true);
                } else {
                    TabbedUserListItem.this.setActionsEnabled(bl, bl2, true, true, true, true, true);
                }
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                String string = TabbedUserListItem.this.getSelectedUser();
                if (string == null) {
                    return;
                }
                if (Global.netDaemon == null) {
                    return;
                }
                Global.netDaemon.searchUserDetial(string, -1);
            }
        }
    }
}

